# This file was auto-generated by Fern from our API Definition.

import enum
import typing

T_Result = typing.TypeVar("T_Result")


class TransactionState(str, enum.Enum):
    """
    Model for transaction states. E.g. Processing, Refunded, Successful etc.
    """

    CREATED = "CREATED"
    PROCESSING = "PROCESSING"
    SENT = "SENT"
    EXPIRED = "EXPIRED"
    DECLINED = "DECLINED"
    SUSPENDED = "SUSPENDED"
    REFUNDED = "REFUNDED"
    SUCCESSFUL = "SUCCESSFUL"

    def visit(
        self,
        created: typing.Callable[[], T_Result],
        processing: typing.Callable[[], T_Result],
        sent: typing.Callable[[], T_Result],
        expired: typing.Callable[[], T_Result],
        declined: typing.Callable[[], T_Result],
        suspended: typing.Callable[[], T_Result],
        refunded: typing.Callable[[], T_Result],
        successful: typing.Callable[[], T_Result],
    ) -> T_Result:
        if self is TransactionState.CREATED:
            return created()
        if self is TransactionState.PROCESSING:
            return processing()
        if self is TransactionState.SENT:
            return sent()
        if self is TransactionState.EXPIRED:
            return expired()
        if self is TransactionState.DECLINED:
            return declined()
        if self is TransactionState.SUSPENDED:
            return suspended()
        if self is TransactionState.REFUNDED:
            return refunded()
        if self is TransactionState.SUCCESSFUL:
            return successful()
