from _typeshed import Incomplete
from collections.abc import Mapping
from dataclasses import dataclass
from pathlib import Path
from typing import Any, Callable, Literal

LOGGABLES: Incomplete

@dataclass
class LogItem:
    origin: Literal['attribute', 'index', 'function', 'value']
    name: str
    timely: bool = ...
    cond: Callable | None = ...
    obj: object | None = ...
    func: Callable | None = ...
    key: str | None = ...
    kwargs: Mapping[str, Any] | None = ...
    value: str | float | int | bool | None = ...
    get_value = ...
    def __post_init__(self) -> None: ...
    def __init__(self, origin, name, timely=..., cond=..., obj=..., func=..., key=..., kwargs=..., value=...) -> None: ...

@dataclass
class Loggables:
    start: list[LogItem]
    update: list[LogItem]
    end: list[LogItem]
    def __post_init__(self) -> None: ...
    def merge(self, other: Loggables): ...
    def arm(self, event: Literal['start', 'update', 'end']): ...
    async def trigger(self): ...
    def __init__(self, start, update, end) -> None: ...

class ExperimentLog:
    states: Incomplete
    continuous: Incomplete
    def __init__(self) -> None: ...
    def arm(self, loggables: Loggables, event: Literal['start', 'update', 'end']): ...
    def trigger(self) -> None: ...
    def log(self, state_number, key, value) -> None: ...
    def log_flip(self) -> None: ...
    def save(self, fn: str | Path): ...
    @property
    def statesdf(self): ...
    @property
    def contdf(self): ...
