# SPDX-FileCopyrightText: 2021 Melissa LeBlanc-Williams for Adafruit Industries
#
# SPDX-License-Identifier: MIT

"""Definition of boards and/or ids"""
# Allow for aligned constant definitions:
VISIONFIVE2 = "VISIONFIVE2"
BEAGLE_PLAY = "BEAGLE_PLAY"
BEAGLEBONE_AI64 = "BEAGLEBONE_AI64"
BEAGLEBONE = "BEAGLEBONE"
BEAGLEBONE_BLACK = "BEAGLEBONE_BLACK"
BEAGLEBONE_BLUE = "BEAGLEBONE_BLUE"
BEAGLEBONE_BLACK_WIRELESS = "BEAGLEBONE_BLACK_WIRELESS"
BEAGLEBONE_POCKETBEAGLE = "BEAGLEBONE_POCKETBEAGLE"
BEAGLEBONE_GREEN = "BEAGLEBONE_GREEN"
BEAGLEBONE_GREEN_WIRELESS = "BEAGLEBONE_GREEN_WIRELESS"
BEAGLEBONE_GREEN_GATEWAY = "BEAGLEBONE_GREEN_GATEWAY"
BEAGLEBONE_BLACK_INDUSTRIAL = "BEAGLEBONE_BLACK_INDUSTRIAL"
BEAGLEBONE_ENHANCED = "BEAGLEBONE_ENHANCED"
BEAGLEBONE_USOMIQ = "BEAGLEBONE_USOMIQ"
BEAGLEBONE_AIR = "BEAGLEBONE_AIR"
BEAGLEBONE_AI = "BEAGLEBONE_AI"
BEAGLEBONE_POCKETBONE = "BEAGLEBONE_POCKETBONE"
BEAGLEV_STARLIGHT = "BEAGLEV_STARLIGHT"
BEAGLEY_AI = "BEAGLEY_AI"
BEAGLELOGIC_STANDALONE = "BEAGLELOGIC_STANDALONE"
OSD3358_DEV_BOARD = "OSD3358_DEV_BOARD"
OSD3358_SM_RED = "OSD3358_SM_RED"
OLIMEX_LIME2 = "OLIMEX_LIME2"
FEATHER_HUZZAH = "FEATHER_HUZZAH"
FEATHER_M0_EXPRESS = "FEATHER_M0_EXPRESS"
GENERIC_LINUX_PC = "GENERIC_LINUX_PC"
PYBOARD = "PYBOARD"
NODEMCU = "NODEMCU"
RASPBERRY_PI_PICO = "RASPBERRY_PI_PICO"
GIANT_BOARD = "GIANT_BOARD"

# ASUS Tinker Boards
ASUS_TINKER_BOARD = "ASUS_TINKER_BOARD"
ASUS_TINKER_BOARD_2 = "ASUS_TINKER_BOARD_2"
ASUS_TINKER_EDGE_R = "ASUS_TINKER_EDGE_R"

# Walnut Pi boards
WALNUT_PI_1B = "WALNUT_PI_1B"
WALNUT_PI_1B_EMMC = "WALNUT_PI_1B_EMMC"

# Clockwork Pi boards
CLOCKWORK_CPI3 = "CLOCKWORK_CPI3"

# Orange Pi boards
ORANGE_PI_PC = "ORANGE_PI_PC"
ORANGE_PI_R1 = "ORANGE_PI_R1"
ORANGE_PI_ZERO = "ORANGE_PI_ZERO"
ORANGE_PI_ONE = "ORANGE_PI_ONE"
ORANGE_PI_LITE = "ORANGE_PI_LITE"
ORANGE_PI_PC_PLUS = "ORANGE_PI_PC_PLUS"
ORANGE_PI_PLUS_2E = "ORANGE_PI_PLUS_2E"
ORANGE_PI_2 = "ORANGE_PI_2"
ORANGE_PI_PC2 = "ORANGE_PI_PC2"
ORANGE_PI_ZERO_PLUS_2H5 = "ORANGE_PI_ZERO_PLUS_2H5"
ORANGE_PI_ZERO_PLUS = "ORANGE_PI_ZERO_PLUS"
ORANGE_PI_ZERO_2 = "ORANGE_PI_ZERO_2"
ORANGE_PI_ZERO_3 = "ORANGE_PI_ZERO_3"
ORANGE_PI_3 = "ORANGE_PI_3"
ORANGE_PI_3B = "ORANGE_PI_3B"
ORANGE_PI_3_LTS = "ORANGE_PI_3_LTS"
ORANGE_PI_4 = "ORANGE_PI_4"
ORANGE_PI_4_LTS = "ORANGE_PI_4_LTS"
ORANGE_PI_5 = "ORANGE_PI_5"
ORANGE_PI_5_MAX = "ORANGE_PI_5_MAX"
ORANGE_PI_5_PLUS = "ORANGE_PI_5_PLUS"
ORANGE_PI_5_PRO = "ORANGE_PI_5_PRO"

# Nano Pi boards
NANOPI_NEO_AIR = "NANOPI_NEO_AIR"
NANOPI_DUO2 = "NANOPI_DUO2"
NANOPI_NEO = "NANOPI_NEO"
NANOPI_NEO_2 = "NANOPI_NEO_2"

# Banana Pi boards
BANANA_PI_M2_ZERO = "BANANA_PI_M2_ZERO"
BANANA_PI_M2_PLUS = "BANANA_PI_M2_PLUS"
BANANA_PI_M2_BERRY = "BANANA_PI_M2_BERRY"
BANANA_PI_M4_BERRY = "BANANA_PI_M4_BERRY"
BANANA_PI_M4_ZERO = "BANANA_PI_M4_ZERO"
BANANA_PI_M5 = "BANANA_PI_M5"
BANANA_PI_F3 = "BANANA_PI_F3"
BANANA_PI_F5 = "BANANA_PI_F5"
BANANA_PI_AI2N = "BANANA_PI_AI2N"
BANANA_PI_AI2H = "BANANA_PI_AI2H"

# LeMaker boards
LEMAKER_BANANA_PRO = "LEMAKER_BANANA_PRO"

# NVIDIA Jetson boards
JETSON_TX1 = "JETSON_TX1"
JETSON_TX2 = "JETSON_TX2"
JETSON_TX2_NX = "JETSON_TX2_NX"
CLARA_AGX_XAVIER = "CLARA_AGX_XAVIER"
JETSON_XAVIER = "JETSON_XAVIER"
JETSON_AGX_ORIN = "JETSON_ORIN"
JETSON_NANO = "JETSON_NANO"
JETSON_NX = "JETSON_NX"
JETSON_ORIN_NANO = "JETSON_ORIN_NANO"
JETSON_ORIN_NX = "JETSON_ORIN_NX"

# Texas Instruments SK boards
TI_J721E_SK = "TI_J721E_SK"

# Google Coral dev board
CORAL_EDGE_TPU_DEV = "CORAL_EDGE_TPU_DEV"
CORAL_EDGE_TPU_DEV_MINI = "CORAL_EDGE_TPU_DEV_MINI"

# Xilinx PYNQ FPGA dev boards
PYNQ_Z1 = "PYNQ_Z1"
PYNQ_Z2 = "PYNQ_Z2"

# STM32 MPU boards
STM32MP157C_DK2 = "STM32MP157C_DK2"
OSD32MP1_BRK = "OSD32MP1_BRK"
OSD32MP1_RED = "OSD32MP1_RED"
STMP157_OLINUXINO_LIME2 = "STMP157_OLINUXINO_LIME2"

# Embedfire LubanCat board
LUBANCAT_IMX6ULL = "LUBANCAT_IMX6ULL"
LUBANCAT_STM32MP157 = "LUBANCAT_STM32MP157"
LUBANCAT_ZERO = "LUBANCAT_ZERO"
LUBANCAT1 = "LUBANCAT1"
LUBANCAT2 = "LUBANCAT2"
LUBANCAT4 = "LUBANCAT4"
LUBANCAT5 = "LUBANCAT5"

# Various Raspberry Pi models
RASPBERRY_PI_B_REV1 = "RASPBERRY_PI_B_REV1"
RASPBERRY_PI_B_REV2 = "RASPBERRY_PI_B_REV2"
RASPBERRY_PI_B_PLUS = "RASPBERRY_PI_B_PLUS"
RASPBERRY_PI_A = "RASPBERRY_PI_A"
RASPBERRY_PI_A_PLUS = "RASPBERRY_PI_A_PLUS"
RASPBERRY_PI_CM1 = "RASPBERRY_PI_CM1"
RASPBERRY_PI_ZERO = "RASPBERRY_PI_ZERO"
RASPBERRY_PI_ZERO_W = "RASPBERRY_PI_ZERO_W"
RASPBERRY_PI_ZERO_2_W = "RASPBERRY_PI_ZERO_2_W"
RASPBERRY_PI_2B = "RASPBERRY_PI_2B"
RASPBERRY_PI_3B = "RASPBERRY_PI_3B"
RASPBERRY_PI_3B_PLUS = "RASPBERRY_PI_3B_PLUS"
RASPBERRY_PI_CM3 = "RASPBERRY_PI_CM3"
RASPBERRY_PI_3A_PLUS = "RASPBERRY_PI_3A_PLUS"
RASPBERRY_PI_CM3_PLUS = "RASPBERRY_PI_CM3_PLUS"
RASPBERRY_PI_4B = "RASPBERRY_PI_4B"
RASPBERRY_PI_AVNET_IIOT_GW = "RASPBERY_PI_AVNET_IIOT_GW"
RASPBERRY_PI_400 = "RASPBERRY_PI_400"
RASPBERRY_PI_CM4 = "RASPBERRY_PI_CM4"
RASPBERRY_PI_CM4S = "RASPBERRY_PI_CM4S"
RASPBERRY_PI_5 = "RASPBERRY_PI_5"
RASPBERRY_PI_CM5 = "RASPBERRY_PI_CM5"
RASPBERRY_PI_500 = "RASPBERRY_PI_500"
RASPBERRY_PI_CM5_LITE = "RASPBERRY_PI_CM5_LITE"

ODROID_C1 = "ODROID_C1"
ODROID_C1_PLUS = "ODROID_C1_PLUS"
ODROID_C2 = "ODROID_C2"
ODROID_C4 = "ODROID_C4"
ODROID_H3 = "ODROID_H3"
ODROID_N2 = "ODROID_N2"
ODROID_XU4 = "ODROID_XU4"
ODROID_M1 = "ODROID_M1"
ODROID_M1S = "ODROID_M1S"

FTDI_FT232H = "FTDI_FT232H"
FTDI_FT2232H = "FTDI_FT2232H"
FTDI_FT4232H = "FTDI_FT4232H"
DRAGONBOARD_410C = "DRAGONBOARD_410C"

SIFIVE_UNLEASHED = "SIFIVE_UNLEASHED"

ALLWINER_D1 = "ALLWINER_D1"
LICHEE_RV = "LICHEE_RV"
LICHEEPI_4A = "LICHEEPI_4A"

MICROCHIP_MCP2221 = "MICROCHIP_MCP2221"

# Linkspirte Pcduino based boards
PCDUINO2 = "PCDUINO2"
PCDUINO3 = "PCDUINO3"

# Boards with u2if firmware
# https://github.com/execuc/u2if
PICO_U2IF = "PICO_U2IF"
FEATHER_U2IF = "FEATHER_U2IF"
FEATHER_CAN_U2IF = "FEATHER_CAN_U2IF"
FEATHER_EPD_U2IF = "FEATHER_EPD_U2IF"
FEATHER_RFM_U2IF = "FEATHER_RFM_U2IF"
ITSYBITSY_U2IF = "ITSYBITSY_U2IF"
MACROPAD_U2IF = "MACROPAD_U2IF"
QTPY_U2IF = "QTPY_U2IF"
QT2040_TRINKEY_U2IF = "QT2040_TRINKEY_U2IF"
KB2040_U2IF = "KB2040_U2IF"

RP2040_ONE_U2IF = "RP2040_ONE_U2IF"
RADXA_X4_U2IF = "RADXA_X4_U2IF"

BINHO_NOVA = "BINHO_NOVA"

ONION_OMEGA = "ONION_OMEGA"
ONION_OMEGA2 = "ONION_OMEGA2"

PINE64 = "PINE64"
PINEH64 = "PINEH64"
PINEBOOK = "PINEBOOK"
PINEPHONE = "PINEPHONE"
SOPINE = "SOPINE"
QUARTZ64_A = "QUARTZ64_A"

RADXA_ZERO = "RADXA_ZERO"
RADXA_ZERO3 = "RADXA_ZERO3"
RADXA_CM3 = "RADXA_CM3"

ROCK_PI_3A = "ROCK_PI_3A"
ROCK_3B = "ROCK_3B"
ROCK_PI_3C = "ROCK_PI_3C"
ROCK_PI_S = "ROCK_PI_S"
ROCK_PI_4 = "ROCK_PI_4"
ROCK_PI_4_C_PLUS = "ROCK_PI_4C+"
ROCK_PI_4_SE = "ROCK_PI_4_SE"
ROCK_PI_X = "ROCK_PI_X"
ROCK_PI_E = "ROCK_PI_E"
ROCK_PI_5 = "ROCK_PI_5"
ROCK_PI_5C = "ROCK_PI_5C"

# Vicharak Boards
VAAMAN = "VAAMAN"
AXON = "AXON"

GREATFET_ONE = "GREATFET_ONE"

# SeeedStudio boards
ODYSSEY_X86J41X5 = "ODYSSEY_X86J41X5"

# Udoo boards
UDOO_BOLT_V3 = "UDOO_BOLT_V3"
UDOO_BOLT_V8 = "UDOO_BOLT_V8"
UDOO_X86 = "UDOO_X86"

# MaaXBoard
MAAXBOARD = "MAAXBOARD"
MAAXBOARD_MINI = "MAAXBOARD_MINI"

# Shenzhen MilkV Technology boards ids
MILKV_DUO = "MILKV_DUO"

# Khadas VIM3
KHADAS_VIM3 = "KHADAS_VIM3"

_KHADAS_40_PIN_IDS = (KHADAS_VIM3,)

# Vivid Unit
VIVID_UNIT = "VIVID_UNIT"

_VIVID_UNIT_IDS = (VIVID_UNIT,)

# Luckfox Pico boards
LUCKFOX_PICO = "LUCKFOX_PICO"
LUCKFOX_PICO_MAX = "LUCKFOX_PICO_MAX"
LUCKFOX_PICO_MINI = "LUCKFOX_PICO_MINI"
LUCKFOX_PICO_PLUS = "LUCKFOX_PICO_PLUS"

# Ameridroid boards
INDIEDROID_NOVA = "INDIEDROID_NOVA"

# Horizon
RDK_X3 = "RDK_X3"

# Particle
PARTICLE_TACHYON = "PARTICLE_TACHYON"

# StarFive boards
_STARFIVE_BOARD_IDS = (VISIONFIVE2,)
# Asus Tinkerboard
_ASUS_TINKER_BOARD_IDS = (
    ASUS_TINKER_BOARD,
    ASUS_TINKER_BOARD_2,
    ASUS_TINKER_EDGE_R,
)

# WalnutPi
_WALNUT_PI_IDS = (
    WALNUT_PI_1B,
    WALNUT_PI_1B_EMMC,
)

# STM32MP1
_STM32MP1_IDS = (
    STM32MP157C_DK2,
    LUBANCAT_STM32MP157,
    OSD32MP1_BRK,
    OSD32MP1_RED,
    STMP157_OLINUXINO_LIME2,
)

# OrangePI
_ORANGE_PI_IDS = (
    ORANGE_PI_PC,
    ORANGE_PI_R1,
    ORANGE_PI_ZERO,
    ORANGE_PI_ONE,
    ORANGE_PI_LITE,
    ORANGE_PI_PC_PLUS,
    ORANGE_PI_PLUS_2E,
    ORANGE_PI_2,
    ORANGE_PI_PC2,
    ORANGE_PI_ZERO_PLUS_2H5,
    ORANGE_PI_ZERO_PLUS,
    ORANGE_PI_ZERO_2,
    ORANGE_PI_3,
    ORANGE_PI_3B,
    ORANGE_PI_3_LTS,
    ORANGE_PI_4,
    ORANGE_PI_4_LTS,
    ORANGE_PI_5,
    ORANGE_PI_5_PLUS,
    ORANGE_PI_5_PRO,
)

# NanoPi
_NANOPI_IDS = (
    NANOPI_NEO_AIR,
    NANOPI_DUO2,
    NANOPI_NEO,
    NANOPI_NEO_2,
)

# BananaPI
_BANANA_PI_IDS = (
    BANANA_PI_M2_ZERO,
    BANANA_PI_M2_PLUS,
    BANANA_PI_M2_BERRY,
    BANANA_PI_M4_BERRY,
    BANANA_PI_M4_ZERO,
    BANANA_PI_M5,
    BANANA_PI_F3,
    BANANA_PI_F5,
    BANANA_PI_AI2N,
    BANANA_PI_AI2H,
)

# LeMaker
_LEMAKER_IDS = (LEMAKER_BANANA_PRO,)

# LubanCat
_LUBANCAT_IDS = (
    LUBANCAT_IMX6ULL,
    LUBANCAT_STM32MP157,
    LUBANCAT_ZERO,
    LUBANCAT1,
    LUBANCAT2,
    LUBANCAT4,
    LUBANCAT5,
)

# Coral boards
_CORAL_IDS = (CORAL_EDGE_TPU_DEV, CORAL_EDGE_TPU_DEV_MINI)

_PYNQ_IDS = (PYNQ_Z1, PYNQ_Z2)

_JETSON_IDS = (
    (JETSON_TX1, ("nvidia,p2371-2180", "nvidia,jetson-cv")),
    (
        JETSON_TX2,
        (
            "nvidia,p2771-0000",
            "nvidia,p2771-0888",
            "nvidia,p3489-0000",
            "nvidia,lightning",
            "nvidia,quill",
            "nvidia,storm",
        ),
    ),
    (JETSON_TX2_NX, ("nvidia,p3509-0000+p3636-0001",)),
    (CLARA_AGX_XAVIER, ("nvidia,e3900-0000+p2888-0004",)),
    (
        JETSON_XAVIER,
        (
            "nvidia,p2972-0000",
            "nvidia,p2972-0006",
            "nvidia,jetson-xavier",
            "nvidia,jetson-xavier-industrial",
            "nvidia,galen-industrial",
        ),
    ),
    (JETSON_NANO, ("nvidia,p3450-0000", "nvidia,p3450-0002", "nvidia,jetson-nano")),
    (
        JETSON_NX,
        (
            "nvidia,p3509-0000+p3668-0000",
            "nvidia,p3509-0000+p3668-0001",
            "nvidia,p3509-0000-a00+p3668-0000-a01",
            "nvidia,p3509-0000-a00+p3668-0001-a01",
            "nvidia,p3449-0000+p3668-0000",
            "nvidia,p3449-0000+p3668-0001",
            "nvidia,p3449-0000+p3668-0003",
        ),
    ),
    (
        JETSON_AGX_ORIN,
        (
            "nvidia,p3737-0000+p3701-0000",
            "nvidia,p3737-0000+p3701-0004",
            "nvidia,p3737-0000+p3701-0008",
            "nvidia,p3737-0000+p3701-0005",
            "nvidia,p3737-0000+p3701-0001",
        ),
    ),
    (
        JETSON_ORIN_NX,
        (
            "nvidia,p3509-0000+p3767-0000",
            "nvidia,p3768-0000+p3767-0000",
            "nvidia,p3509-0000+p3767-0001",
            "nvidia,p3768-0000+p3767-0001",
        ),
    ),
    (
        JETSON_ORIN_NANO,
        (
            "nvidia,p3509-0000+p3767-0003",
            "nvidia,p3768-0000+p3767-0003",
            "nvidia,p3509-0000+p3767-0004",
            "nvidia,p3768-0000+p3767-0004",
            "nvidia,p3509-0000+p3767-0005",
            "nvidia,p3768-0000+p3767-0005",
            "nvidia,p3768-0000+p3767-0005-super",
        ),
    ),
)

_TI_SK_BOARD_IDS = ((TI_J721E_SK, ("ti,j721e-sk", "ti,j721e")),)

# Raspberry Pi boards

_RASPBERRY_PI_40_PIN_IDS = (
    RASPBERRY_PI_B_PLUS,
    RASPBERRY_PI_A_PLUS,
    RASPBERRY_PI_ZERO,
    RASPBERRY_PI_ZERO_W,
    RASPBERRY_PI_ZERO_2_W,
    RASPBERRY_PI_2B,
    RASPBERRY_PI_3B,
    RASPBERRY_PI_3B_PLUS,
    RASPBERRY_PI_3A_PLUS,
    RASPBERRY_PI_4B,
    RASPBERRY_PI_AVNET_IIOT_GW,
    RASPBERRY_PI_400,
    RASPBERRY_PI_5,
    RASPBERRY_PI_500,
)

_RASPBERRY_PI_CM_IDS = (
    RASPBERRY_PI_CM1,
    RASPBERRY_PI_CM3,
    RASPBERRY_PI_CM3_PLUS,
    RASPBERRY_PI_CM4,
    RASPBERRY_PI_CM4S,
    RASPBERRY_PI_CM5,
    RASPBERRY_PI_CM5_LITE,
)

# Pi 4 boards have additional peripherals
_RASPBERRY_PI_4_IDS = (
    RASPBERRY_PI_4B,
    RASPBERRY_PI_CM4,
    RASPBERRY_PI_CM4S,
    RASPBERRY_PI_400,
)

# Pi 5 boards work differently
_RASPBERRY_PI_5_IDS = (
    RASPBERRY_PI_5,
    RASPBERRY_PI_CM5,
    RASPBERRY_PI_500,
    RASPBERRY_PI_CM5_LITE,
)

_PI_MODELS = {
    0x00: RASPBERRY_PI_A,
    0x01: {
        1.0: RASPBERRY_PI_B_REV1,
        2.0: RASPBERRY_PI_B_REV2,
    },
    0x02: RASPBERRY_PI_A_PLUS,
    0x03: RASPBERRY_PI_B_PLUS,
    0x04: RASPBERRY_PI_2B,
    0x06: RASPBERRY_PI_CM1,
    0x08: RASPBERRY_PI_3B,
    0x09: RASPBERRY_PI_ZERO,
    0x0A: RASPBERRY_PI_CM3,
    0x0B: RASPBERRY_PI_AVNET_IIOT_GW,
    0x0C: RASPBERRY_PI_ZERO_W,
    0x0D: RASPBERRY_PI_3B_PLUS,
    0x0E: RASPBERRY_PI_3A_PLUS,
    0x10: RASPBERRY_PI_CM3_PLUS,
    0x11: RASPBERRY_PI_4B,
    0x12: RASPBERRY_PI_ZERO_2_W,
    0x13: RASPBERRY_PI_400,
    0x14: RASPBERRY_PI_CM4,
    0x15: RASPBERRY_PI_CM4S,
    0x17: RASPBERRY_PI_5,
    0x18: RASPBERRY_PI_CM5,
    0x19: RASPBERRY_PI_500,
    0x1A: RASPBERRY_PI_CM5_LITE,
}

# ODROID boards

_ODROID_40_PIN_IDS = (
    ODROID_C1,
    ODROID_C1_PLUS,
    ODROID_C2,
    ODROID_C4,
    ODROID_N2,
    ODROID_XU4,
    ODROID_M1,
    ODROID_M1S,
)

_ODROID_MINI_PC_IDS = (ODROID_H3,)

_BEAGLEBONE_IDS = (
    BEAGLEY_AI,
    BEAGLE_PLAY,
    BEAGLEBONE_AI64,
    BEAGLEBONE,
    BEAGLEBONE_BLACK,
    BEAGLEBONE_BLUE,
    BEAGLEBONE_BLACK_WIRELESS,
    BEAGLEBONE_POCKETBEAGLE,
    BEAGLEBONE_GREEN,
    BEAGLEBONE_GREEN_WIRELESS,
    BEAGLEBONE_GREEN_GATEWAY,
    BEAGLEBONE_BLACK_INDUSTRIAL,
    BEAGLEBONE_ENHANCED,
    BEAGLEBONE_USOMIQ,
    BEAGLEBONE_AIR,
    BEAGLEBONE_AI,
    BEAGLEBONE_POCKETBONE,
    BEAGLELOGIC_STANDALONE,
    BEAGLEV_STARLIGHT,
    OSD3358_DEV_BOARD,
    OSD3358_SM_RED,
)

_LINARO_96BOARDS_IDS = (DRAGONBOARD_410C,)

_SIFIVE_IDS = (SIFIVE_UNLEASHED,)

_OLIMEX_IDS = (OLIMEX_LIME2,)

# BeagleBone eeprom board ids from:
#   https://github.com/beagleboard/image-builder
# Thanks to zmatt on freenode #beagle for pointers.
_BEAGLEBONE_BOARD_IDS = {
    BEAGLE_PLAY: ("A0", "7.BEAGLE"),
    BEAGLEBONE_AI64: ("B0", "7.BBONEA"),
    # Original bone/white:
    BEAGLEBONE: (
        ("A3", "A335BONE00A3"),
        ("A4", "A335BONE00A4"),
        ("A5", "A335BONE00A5"),
        ("A6", "A335BONE00A6"),
        ("A6A", "A335BONE0A6A"),
        ("A6B", "A335BONE0A6B"),
        ("B", "A335BONE000B"),
    ),
    BEAGLEBONE_BLACK: (
        ("A5", "A335BNLT00A5"),
        ("A5A", "A335BNLT0A5A"),
        ("A5B", "A335BNLT0A5B"),
        ("A5C", "A335BNLT0A5C"),
        ("A6", "A335BNLT00A6"),
        ("A6A", "A335BNLT0A6A"),
        ("B", "A335BNLT000B"),
        ("C", "A335BNLT000C"),
        ("C", "A335BNLT00C0"),
    ),
    BEAGLEBONE_BLUE: (("A2", "A335BNLTBLA2"),),
    BEAGLEBONE_BLACK_WIRELESS: (("A5", "A335BNLTBWA5"),),
    BEAGLEBONE_POCKETBEAGLE: (("A2", "A335PBGL00A2"),),
    BEAGLEBONE_GREEN: (("1A", "A335BNLT...."), ("UNKNOWN", "A335BNLTBBG1")),
    BEAGLEBONE_GREEN_WIRELESS: (("W1A", "A335BNLTGW1A"),),
    BEAGLEBONE_GREEN_GATEWAY: (("GA1", "A335BNLTGG1A"),),
    BEAGLEBONE_BLACK_INDUSTRIAL: (
        ("A0", "A335BNLTAIA0"),  # Arrow
        ("A0", "A335BNLTEIA0"),  # Element14
    ),
    BEAGLEBONE_ENHANCED: (("A", "A335BNLTSE0A"),),
    BEAGLEBONE_USOMIQ: (("6", "A335BNLTME06"),),
    BEAGLEBONE_AIR: (("A0", "A335BNLTNAD0"),),
    BEAGLEBONE_POCKETBONE: (("0", "A335BNLTBP00"),),
    OSD3358_DEV_BOARD: (("0.1", "A335BNLTGH01"),),
    OSD3358_SM_RED: (("0", "A335BNLTOS00"),),
    BEAGLELOGIC_STANDALONE: (("A", "A335BLGC000A"),),
}

# Onion omega boards
_ONION_OMEGA_BOARD_IDS = (ONION_OMEGA, ONION_OMEGA2)

# Pine64 boards and devices
_PINE64_DEV_IDS = (PINE64, PINEH64, PINEBOOK, PINEPHONE, SOPINE, QUARTZ64_A)

# Pcduino boards
_PCDUINO_DEV_IDS = (PCDUINO2, PCDUINO3)
# RockPi boards and devices
_ROCK_PI_IDS = (
    ROCK_PI_S,
    ROCK_PI_4,
    ROCK_PI_4_C_PLUS,
    ROCK_PI_4_SE,
    ROCK_PI_X,
    ROCK_PI_E,
    RADXA_ZERO,
    RADXA_ZERO3,
    ROCK_PI_5,
    ROCK_PI_5C,
    RADXA_CM3,
    ROCK_PI_3A,
    ROCK_3B,
    ROCK_PI_3C,
)

# Vicharak Boards
_VICHARAK_BOARD_IDS = (VAAMAN, AXON)

# UDOO
_UDOO_BOARD_IDS = {UDOO_BOLT_V8: ("SC40-2000-0000-C0|C",), UDOO_X86: ("dummy",)}

# SeeedStudio boards
_SEEED_BOARD_IDS = (ODYSSEY_X86J41X5,)

# MaaXBoard boards
_MAAXBOARD_IDS = ("MAAXBOARD", "MAAXBOARD_MINI")

# Lichee RISC-V boards
_LICHEE_RISCV_IDS = (LICHEE_RV, LICHEEPI_4A)

# Siemens Simatic IOT2000 Gateways
SIEMENS_SIMATIC_IOT2050_ADV = "SIEMENS_SIMATIC_IOT2050_ADVANCED"
SIEMENS_SIMATIC_IOT2050_BASIC = "SIEMENS_SIMATIC_IOT2050_BASIC"

# Siemens Simatic IOT2000 Gateways
_SIEMENS_SIMATIC_IOT2000_IDS = (
    SIEMENS_SIMATIC_IOT2050_ADV,
    SIEMENS_SIMATIC_IOT2050_BASIC,
)

# Libre Computer Boards
AML_S905X_CC = "AML-S905X-CC"
ROC_RK3328_CC = "ROC-RK3328-CC"

# Libre Computer Boards
_LIBRE_COMPUTER_IDS = (
    AML_S905X_CC,
    ROC_RK3328_CC,
)

# NXP System on Module Computer boards
NXP_IMX8MPLUS_SOM = "NXP_IMX8MPLUS_SOM"

_NXP_SOM_IDS = (NXP_IMX8MPLUS_SOM,)

# Repka-Pi boards
REPKA_PI_3_H5 = "REPKA_PI_3_H5"
REPKA_PI_4_H6 = "REPKA_PI_4_H6"

# Repka-Pi
_REPKA_PI_IDS = (
    REPKA_PI_3_H5,
    REPKA_PI_4_H6,
)

_MILKV_IDS_ = (MILKV_DUO,)

# Luckfox
_LUCKFOX_IDS = (
    LUCKFOX_PICO,
    LUCKFOX_PICO_MAX,
    LUCKFOX_PICO_MINI,
    LUCKFOX_PICO_PLUS,
)

# Horizon
_HORIZON_IDS = (RDK_X3,)

_AMERIDROID_IDS = (INDIEDROID_NOVA,)

# Particle
_PARTICLE_IDS = (PARTICLE_TACHYON,)

# Agnostic board
OS_AGNOSTIC_BOARD = "OS_AGNOSTIC_BOARD"
