"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.RemoteParameters = exports.RemoteOutputs = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const path = require("path");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const constructs_1 = require("constructs");
/**
 * Represents the RemoteOutputs of the remote CDK stack
 */
class RemoteOutputs extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        const onEvent = new aws_cdk_lib_1.aws_lambda.Function(this, 'MyHandler', {
            runtime: aws_cdk_lib_1.aws_lambda.Runtime.PYTHON_3_8,
            code: aws_cdk_lib_1.aws_lambda.Code.fromAsset(path.join(__dirname, '../custom-resource-handler')),
            handler: 'remote-outputs.on_event',
        });
        const myProvider = new aws_cdk_lib_1.custom_resources.Provider(this, 'MyProvider', {
            onEventHandler: onEvent,
            logRetention: aws_cdk_lib_1.aws_logs.RetentionDays.ONE_DAY,
        });
        onEvent.addToRolePolicy(new aws_cdk_lib_1.aws_iam.PolicyStatement({
            actions: ['cloudformation:DescribeStacks'],
            resources: ['*'],
        }));
        this.outputs = new aws_cdk_lib_1.CustomResource(this, 'RemoteOutputs', {
            serviceToken: myProvider.serviceToken,
            properties: {
                stackName: props.stack.stackName,
                regionName: aws_cdk_lib_1.Stack.of(props.stack).region,
                randomString: props.alwaysUpdate == false ? undefined : randomString(),
            },
        });
    }
    /**
     * Get the attribute value from the outputs.
     * @param key output key
     */
    get(key) {
        return this.outputs.getAttString(key);
    }
}
exports.RemoteOutputs = RemoteOutputs;
_a = JSII_RTTI_SYMBOL_1;
RemoteOutputs[_a] = { fqn: "cdk-remote-stack.RemoteOutputs", version: "2.0.87" };
/**
 * Represents the RemoteParameters of the remote CDK stack
 */
class RemoteParameters extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        const onEvent = new aws_cdk_lib_1.aws_lambda.Function(this, 'MyHandler', {
            runtime: aws_cdk_lib_1.aws_lambda.Runtime.PYTHON_3_8,
            code: aws_cdk_lib_1.aws_lambda.Code.fromAsset(path.join(__dirname, '../custom-resource-handler')),
            handler: 'remote-parameters.on_event',
        });
        const myProvider = new aws_cdk_lib_1.custom_resources.Provider(this, 'MyProvider', {
            onEventHandler: onEvent,
            logRetention: aws_cdk_lib_1.aws_logs.RetentionDays.ONE_DAY,
        });
        onEvent.addToRolePolicy(new aws_cdk_lib_1.aws_iam.PolicyStatement({
            actions: ['ssm:GetParametersByPath'],
            resources: ['*'],
        }));
        this.parameters = new aws_cdk_lib_1.CustomResource(this, 'SsmParameters', {
            serviceToken: myProvider.serviceToken,
            properties: {
                stackName: aws_cdk_lib_1.Stack.of(this).stackName,
                regionName: props.region,
                parameterPath: props.path,
                randomString: props.alwaysUpdate == false ? undefined : randomString(),
                role: props.role?.roleArn,
            },
        });
        if (props.role) {
            myProvider.onEventHandler.addToRolePolicy(new aws_cdk_lib_1.aws_iam.PolicyStatement({
                actions: ['sts:AssumeRole'],
                resources: [props.role.roleArn],
            }));
        }
    }
    /**
     * Get the parameter.
     * @param key output key
     */
    get(key) {
        return this.parameters.getAttString(key);
    }
}
exports.RemoteParameters = RemoteParameters;
_b = JSII_RTTI_SYMBOL_1;
RemoteParameters[_b] = { fqn: "cdk-remote-stack.RemoteParameters", version: "2.0.87" };
function randomString() {
    // Crazy
    return Math.random().toString(36).replace(/[^a-z0-9]+/g, '');
}
//# sourceMappingURL=data:application/json;base64,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