# Generated by Django 5.1.2 on 2024-10-11 16:45

import django.core.serializers.json
import django.db.models.deletion
import functools
import secrets
from django.conf import settings
from django.db import migrations, models


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name='Session',
            fields=[
                ('id', models.CharField(default=functools.partial(secrets.token_urlsafe, *(32,), **{}), max_length=43, primary_key=True, serialize=False)),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('expired_at', models.DateTimeField(blank=True, db_index=True, null=True)),
                ('ip_address', models.GenericIPAddressField(blank=True, null=True)),
                ('data', models.JSONField(default=dict, encoder=django.core.serializers.json.DjangoJSONEncoder)),
                ('user', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='jwt_sessions', to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'verbose_name': 'JWT Session',
                'verbose_name_plural': 'JWT Sessions',
                'indexes': [models.Index(condition=models.Q(('expired_at__isnull', False)), fields=['expired_at'], name='idx_non_null_expired_at'), models.Index(fields=['user'], name='jwt_ninja_s_user_id_5c569c_idx')],
            },
        ),
    ]
