"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.FargateTask = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_ec2_1 = require("aws-cdk-lib/aws-ec2");
const constructs_1 = require("constructs");
/**
 * An FargateTask.
 *
 * If `vpcSubnets` is blank but `assignPublicIp` is set, the task will launch
 * in Public subnets, otherwise the first available one of Private, Isolated,
 * Public, in that order.
 */
class FargateTask extends constructs_1.Construct {
    /**
     * Creates a new FargateTask.
     */
    constructor(scope, id, props) {
        super(scope, id);
        this.connections = new aws_ec2_1.Connections();
        const { securityGroups = [] } = props;
        this.cluster = props.cluster;
        this.taskDefinition = props.taskDefinition;
        this.awsVpcNetworkConfig = this.configureAwsVpcNetworking(props.cluster.vpc, props.assignPublicIp, props.vpcSubnets, securityGroups);
    }
    configureAwsVpcNetworking(vpc, assignPublicIp, vpcSubnets, securityGroups) {
        if (vpcSubnets === undefined) {
            vpcSubnets = assignPublicIp ? { subnetType: aws_ec2_1.SubnetType.PUBLIC } : {};
        }
        if (securityGroups === undefined || securityGroups.length === 0) {
            securityGroups = [new aws_ec2_1.SecurityGroup(this, "SecurityGroup", { vpc })];
        }
        securityGroups.forEach((sg) => {
            this.connections.addSecurityGroup(sg);
        }, this);
        return {
            assignPublicIp: assignPublicIp ? "ENABLED" : "DISABLED",
            subnets: this.cluster.vpc.selectSubnets(vpcSubnets).subnetIds,
            securityGroups: this.connections.securityGroups.map((sg) => sg.securityGroupId),
        };
    }
    grantRun(grantee) {
        const grant = this.taskDefinition.grantRun(grantee);
        const statement = grant.principalStatements.find((ps) => ps.actions.includes("ecs:RunTask"));
        if (statement) {
            statement.addCondition("ArnEquals", {
                "ecs:cluster": this.cluster.clusterArn,
            });
        }
        return grant;
    }
}
exports.FargateTask = FargateTask;
_a = JSII_RTTI_SYMBOL_1;
FargateTask[_a] = { fqn: "shady-island.FargateTask", version: "0.1.1" };
//# sourceMappingURL=data:application/json;base64,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