import { IVpc } from "aws-cdk-lib/aws-ec2";
import { Function } from "aws-cdk-lib/aws-lambda";
import { DatabaseCluster, DatabaseClusterFromSnapshot, DatabaseInstance, DatabaseInstanceFromSnapshot, ServerlessCluster, ServerlessClusterFromSnapshot } from "aws-cdk-lib/aws-rds";
import { ISecret } from "aws-cdk-lib/aws-secretsmanager";
import { ITrigger } from "aws-cdk-lib/triggers";
import { IConstruct, Construct } from "constructs";
import { BaseDatabase, BaseDatabaseProps, BaseDatabaseOptions } from "./base-database";
/**
 * MySQL-specific options.
 */
export interface MysqlDatabaseOptions {
    /**
     * The database default character set to use.
     *
     * @default - "utf8mb4"
     */
    readonly characterSet?: string;
    /**
     * The database default collation to use.
     *
     * @default - rely on MySQL to choose the default collation.
     */
    readonly collation?: string;
}
/**
 * Constructor properties for MysqlDatabase.
 */
export interface MysqlDatabaseProps extends BaseDatabaseProps, MysqlDatabaseOptions {
}
/**
 * Properties to specify when using MysqlDatabase.forCluster().
 */
export interface MysqlDatabaseForClusterOptions extends MysqlDatabaseOptions, BaseDatabaseOptions {
    /**
     * A Secrets Manager secret that contains administrative credentials.
     */
    readonly adminSecret?: ISecret;
}
/**
 * Properties to specify when using MysqlDatabase.forServerlessCluster().
 */
export interface MysqlDatabaseForServerlessClusterOptions extends MysqlDatabaseForClusterOptions {
    /**
     * The VPC where the Lambda function will run.
     */
    readonly vpc: IVpc;
}
/**
 * A MySQL database.
 */
export declare class MysqlDatabase extends BaseDatabase {
    /**
     * Create a new MysqlDatabase inside a DatabaseCluster.
     *
     * This method automatically adds the cluster to the CloudFormation
     * dependencies of the CDK Trigger.
     *
     * @param scope - The Construct that contains this one.
     * @param id - The identifier of this construct.
     * @param cluster - The database cluster construct.
     * @param options - The configuration properties for this construct.
     */
    static forCluster(scope: Construct, id: string, cluster: DatabaseCluster, options: MysqlDatabaseForClusterOptions): MysqlDatabase;
    /**
     * Create a new MysqlDatabase inside a DatabaseClusterFromSnapshot.
     *
     * This method automatically adds the cluster to the CloudFormation
     * dependencies of the CDK Trigger.
     *
     * @param scope - The Construct that contains this one.
     * @param id - The identifier of this construct.
     * @param cluster - The database cluster construct.
     * @param options - The configuration properties for this construct.
     */
    static forClusterFromSnapshot(scope: Construct, id: string, cluster: DatabaseClusterFromSnapshot, options: MysqlDatabaseForClusterOptions): MysqlDatabase;
    /**
     * Create a new MysqlDatabase inside a DatabaseCluster.
     *
     * This method automatically adds the cluster to the CloudFormation
     * dependencies of the CDK Trigger.
     *
     * @param scope - The Construct that contains this one.
     * @param id - The identifier of this construct.
     * @param cluster - The database cluster construct.
     * @param options - The configuration properties for this construct.
     */
    static forServerlessCluster(scope: Construct, id: string, cluster: ServerlessCluster, options: MysqlDatabaseForServerlessClusterOptions): MysqlDatabase;
    /**
     * Create a new MysqlDatabase inside a DatabaseClusterFromSnapshot.
     *
     * This method automatically adds the cluster to the CloudFormation
     * dependencies of the CDK Trigger.
     *
     * @param scope - The Construct that contains this one.
     * @param id - The identifier of this construct.
     * @param cluster - The database cluster construct.
     * @param options - The configuration properties for this construct.
     */
    static forServerlessClusterFromSnapshot(scope: Construct, id: string, cluster: ServerlessClusterFromSnapshot, options: MysqlDatabaseForServerlessClusterOptions): MysqlDatabase;
    /**
     * Create a new MysqlDatabase inside a DatabaseInstance.
     *
     * This method automatically adds the instance to the CloudFormation
     * dependencies of the CDK Trigger.
     *
     * @param scope - The Construct that contains this one.
     * @param id - The identifier of this construct.
     * @param instance - The database cluster construct.
     * @param options - The configuration properties for this construct.
     */
    static forInstance(scope: Construct, id: string, instance: DatabaseInstance, options: MysqlDatabaseForClusterOptions): MysqlDatabase;
    /**
     * Create a new MysqlDatabase inside a DatabaseInstanceFromSnapshot.
     *
     * This method automatically adds the instance to the CloudFormation
     * dependencies of the CDK Trigger.
     *
     * @param scope - The Construct that contains this one.
     * @param id - The identifier of this construct.
     * @param instance - The database cluster construct.
     * @param options - The configuration properties for this construct.
     */
    static forInstanceFromSnapshot(scope: Construct, id: string, instance: DatabaseInstanceFromSnapshot, options: MysqlDatabaseForClusterOptions): MysqlDatabase;
    readonly trigger: ITrigger;
    protected readonly lambdaFunction: Function;
    protected readonly ownerSecrets: ISecret[];
    protected readonly readerSecrets: ISecret[];
    protected readonly unprivilegedSecrets: ISecret[];
    /**
     * Creates a new MysqlDatabase.
     *
     * @param scope - The Construct that contains this one.
     * @param id - The identifier of this construct.
     * @param props - The configuration properties for this construct.
     */
    constructor(scope: IConstruct, id: string, props: MysqlDatabaseProps);
    addUserAsOwner(secret: ISecret): void;
    addUserAsReader(secret: ISecret): void;
    addUserAsUnprivileged(secret: ISecret): void;
}
