
####### Expanded from @PACKAGE_INIT@ by configure_package_config_file() #######
####### Any changes to this file will be overwritten by the next CMake run ####
####### The input file was uuid-config.cmake.in                            ########

get_filename_component(PACKAGE_PREFIX_DIR "${CMAKE_CURRENT_LIST_DIR}/../../" ABSOLUTE)

macro(set_and_check _var _file)
  set(${_var} "${_file}")
  if(NOT EXISTS "${_file}")
    message(FATAL_ERROR "File or directory ${_file} referenced by variable ${_var} does not exist !")
  endif()
endmacro()

macro(check_required_components _NAME)
  foreach(comp ${${_NAME}_FIND_COMPONENTS})
    if(NOT ${_NAME}_${comp}_FOUND)
      if(${_NAME}_FIND_REQUIRED_${comp})
        set(${_NAME}_FOUND FALSE)
      endif()
    endif()
  endforeach()
endmacro()

####################################################################################


# Avoid repeatedly including the targets
if(NOT TARGET uuid::uuid)
    include(${CMAKE_CURRENT_LIST_DIR}/uuid-exports.cmake)

    if (NOT DEFINED LIBUUID_STATIC AND NOT DEFINED LIBUUID_SHARED)

        if (BUILD_SHARED_LIBS)
            set(LIBUUID_SHARED ON)
            set(LIBUUID_STATIC OFF)
        else()
            set(LIBUUID_SHARED OFF)
            set(LIBUUID_STATIC ON)
        endif()
    endif()

    if (LIBUUID_SHARED AND LIBUUID_STATIC)
        if (BUILD_SHARED_LIBS)
            add_library(uuid::uuid ALIAS uuid::uuid_shared)
        elseif (LIBUUID_STATIC)
            add_library(uuid::uuid ALIAS uuid::uuid_static)
        endif()
    elseif (LIBUUID_SHARED)
        add_library(uuid::uuid ALIAS uuid::uuid_shared)
    elseif (LIBUUID_STATIC)
        add_library(uuid::uuid ALIAS uuid::uuid_static)
    endif()
endif()
