# -*- coding: utf-8 -*-
# BioSTEAM: The Biorefinery Simulation and Techno-Economic Analysis Modules
# Copyright (C) 2020-2021, Yoel Cortes-Pena <yoelcortes@gmail.com>
# 
# This module is under the UIUC open-source license. See 
# github.com/BioSTEAMDevelopmentGroup/biosteam/blob/master/LICENSE.txt
# for license details.
"""
Cost indices.

"""

__all__ = ('CEPCI_by_year',)

#: Chemical Engineering Plant Cost Index by year
CEPCI_by_year = {1980: 261,
                 1981: 297,
                 1982: 314,
                 1983: 317,
                 1984: 323,
                 1985: 325,
                 1986: 318,
                 1987: 324,
                 1988: 343,
                 1989: 355,
                 1990: 358,
                 1991: 361,
                 1992: 358,
                 1993: 359,
                 1994: 368,
                 1995: 381,
                 1996: 382,
                 1997: 387,
                 1998: 390,
                 1999: 391,
                 2000: 394,
                 2001: 394,
                 2002: 396,
                 2003: 402,
                 2004: 444,
                 2005: 468,
                 2006: 500,
                 2007: 525,
                 2008: 575,
                 2009: 522,
                 2010: 551,
                 2011: 586,
                 2012: 585,
                 2013: 567,
                 2014: 576,
                 2015: 542,
                 2016: 568,
                 2018: 603}