# -*- coding: utf-8 -*-
# BioSTEAM: The Biorefinery Simulation and Techno-Economic Analysis Modules
# Copyright (C) 2020-2021, Yoel Cortes-Pena <yoelcortes@gmail.com>
# 
# This module is under the UIUC open-source license. See 
# github.com/BioSTEAMDevelopmentGroup/biosteam/blob/master/LICENSE.txt
# for license details.
"""
"""
from . import Facility
from .. import Mixer
from ..._graphics import mixer_graphics

__all__ = ('BlowdownMixer',)

class BlowdownMixer(Facility, Mixer):
    network_priority = 2
    _graphics = mixer_graphics
    ticket_name = 'BDM'
    def __init__(self, ID='', ins=None, outs=(), thermo=None, rigorous=False):
        Facility.__init__(self, ID, ins, outs, thermo)
        self.rigorous = rigorous