# generated by datamodel-codegen:
#   filename:  api/data/createChart.json
#   timestamp: 2025-04-02T05:35:35+00:00

from __future__ import annotations

from typing import List, Optional

from pydantic import ConfigDict, Field
from typing_extensions import Annotated

from metadata.ingestion.models.custom_pydantic import BaseModel

from ...entity.data import chart
from ...type import basic, entityReferenceList, lifeCycle, tagLabel


class CreateChartRequest(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    name: Annotated[
        basic.EntityName, Field(description='Name that identifies this Chart.')
    ]
    displayName: Annotated[
        Optional[str],
        Field(
            None,
            description='Display Name that identifies this Chart. It could be title or label from the source services',
        ),
    ]
    description: Annotated[
        Optional[basic.Markdown],
        Field(
            None,
            description='Description of the chart instance. What it has and how to use it.',
        ),
    ]
    chartType: Optional[chart.ChartType] = None
    sourceUrl: Annotated[
        Optional[basic.SourceUrl],
        Field(None, description='Chart URL suffix from its service.'),
    ]
    tags: Annotated[
        Optional[List[tagLabel.TagLabel]],
        Field(None, description='Tags for this chart'),
    ]
    owners: Annotated[
        Optional[entityReferenceList.EntityReferenceList],
        Field(None, description='Owners of this chart'),
    ]
    service: Annotated[
        basic.FullyQualifiedEntityName,
        Field(description='Link to the chart service where this chart is hosted in'),
    ]
    domain: Annotated[
        Optional[basic.FullyQualifiedEntityName],
        Field(
            None, description='Fully qualified name of the domain the Chart belongs to.'
        ),
    ]
    dataProducts: Annotated[
        Optional[List[basic.FullyQualifiedEntityName]],
        Field(
            None,
            description='List of fully qualified names of data products this entity is part of.',
        ),
    ]
    lifeCycle: Annotated[
        Optional[lifeCycle.LifeCycle],
        Field(None, description='Life Cycle of the entity'),
    ]
    sourceHash: Annotated[
        Optional[str],
        Field(
            None, description='Source hash of the entity', max_length=32, min_length=1
        ),
    ]
    dashboards: Annotated[
        Optional[List[basic.FullyQualifiedEntityName]],
        Field(
            None,
            description='List of fully qualified name of dashboards containing this Chart.',
        ),
    ]
