# generated by datamodel-codegen:
#   filename:  api/data/createDashboard.json
#   timestamp: 2025-04-02T05:35:35+00:00

from __future__ import annotations

from typing import List, Optional

from pydantic import ConfigDict, Field
from typing_extensions import Annotated

from metadata.ingestion.models.custom_pydantic import BaseModel

from ...entity.data import dashboard
from ...type import basic, entityReferenceList, lifeCycle, tagLabel


class CreateDashboardRequest(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    name: Annotated[
        basic.EntityName, Field(description='Name that identifies this dashboard.')
    ]
    displayName: Annotated[
        Optional[str],
        Field(
            None,
            description='Display Name that identifies this Dashboard. It could be title or label from the source services',
        ),
    ]
    description: Annotated[
        Optional[basic.Markdown],
        Field(
            None,
            description='Description of the database instance. What it has and how to use it.',
        ),
    ]
    dashboardType: Optional[dashboard.DashboardType] = dashboard.DashboardType.Dashboard
    sourceUrl: Annotated[
        Optional[basic.SourceUrl],
        Field(None, description='Dashboard URL suffix from its service.'),
    ]
    project: Annotated[
        Optional[str],
        Field(
            None,
            description='Name of the project / workspace / collection in which the dashboard is contained',
        ),
    ]
    charts: Annotated[
        Optional[List[basic.FullyQualifiedEntityName]],
        Field(
            None,
            description='List of fully qualified name of charts included in this Dashboard.',
        ),
    ]
    dataModels: Annotated[
        Optional[List[basic.FullyQualifiedEntityName]],
        Field(
            None,
            description='List of fully qualified name of data models included in this Dashboard.',
        ),
    ]
    tags: Annotated[
        Optional[List[tagLabel.TagLabel]],
        Field(None, description='Tags for this dashboard'),
    ]
    owners: Annotated[
        Optional[entityReferenceList.EntityReferenceList],
        Field(None, description='Owners of this dashboard'),
    ]
    service: Annotated[
        basic.FullyQualifiedEntityName,
        Field(
            description='Link to the dashboard service fully qualified name where this dashboard is hosted in'
        ),
    ]
    extension: Annotated[
        Optional[basic.EntityExtension],
        Field(
            None,
            description='Entity extension data with custom attributes added to the entity.',
        ),
    ]
    domain: Annotated[
        Optional[basic.FullyQualifiedEntityName],
        Field(
            None,
            description='Fully qualified name of the domain the Dashboard belongs to.',
        ),
    ]
    dataProducts: Annotated[
        Optional[List[basic.FullyQualifiedEntityName]],
        Field(
            None,
            description='List of fully qualified names of data products this entity is part of.',
        ),
    ]
    lifeCycle: Annotated[
        Optional[lifeCycle.LifeCycle],
        Field(None, description='Life Cycle of the entity'),
    ]
    sourceHash: Annotated[
        Optional[str],
        Field(
            None, description='Source hash of the entity', max_length=32, min_length=1
        ),
    ]
