# generated by datamodel-codegen:
#   filename:  api/teams/createUser.json
#   timestamp: 2025-04-02T05:35:35+00:00

from __future__ import annotations

from enum import Enum
from typing import List, Optional

from pydantic import ConfigDict, Field
from typing_extensions import Annotated

from metadata.ingestion.models.custom_pydantic import BaseModel

from ...entity.teams import user
from ...type import basic, entityReference, entityReferenceList, profile


class CreatePasswordType(Enum):
    ADMIN_CREATE = 'ADMIN_CREATE'
    USER_CREATE = 'USER_CREATE'


class CreateUserRequest(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    name: basic.EntityName
    description: Annotated[
        Optional[basic.Markdown], Field(None, description='Used for user biography.')
    ]
    displayName: Annotated[
        Optional[str],
        Field(
            None,
            description="Name used for display purposes. Example 'FirstName LastName'",
        ),
    ]
    email: basic.Email
    timezone: Annotated[Optional[str], Field(None, description='Timezone of the user')]
    isBot: Annotated[
        Optional[bool],
        Field(
            False,
            description='When true indicates user is a bot with appropriate privileges',
        ),
    ]
    botName: Annotated[
        Optional[str],
        Field(
            None,
            description='User bot name if we want to associate this bot with an specific bot',
        ),
    ]
    isAdmin: Annotated[
        Optional[bool],
        Field(
            False,
            description='When true indicates user is an administrator for the system with superuser privileges',
        ),
    ]
    profile: Annotated[
        Optional[profile.Profile], Field(None, description='Profile of the user.')
    ]
    teams: Annotated[
        Optional[List[basic.Uuid]],
        Field(None, description='Teams that the user belongs to'),
    ]
    roles: Annotated[
        Optional[List[basic.Uuid]],
        Field(None, description='Roles that the user has been assigned'),
    ]
    personas: Annotated[
        Optional[entityReferenceList.EntityReferenceList],
        Field(None, description='Persona that the user belongs to.'),
    ]
    defaultPersona: Annotated[
        Optional[entityReference.EntityReference],
        Field(None, description="Default Persona from User's Personas."),
    ]
    authenticationMechanism: Annotated[
        Optional[user.AuthenticationMechanism],
        Field(None, description='Authentication mechanism specified '),
    ]
    createPasswordType: Annotated[
        Optional[CreatePasswordType],
        Field(CreatePasswordType.USER_CREATE, description='User Password Method'),
    ]
    password: Annotated[Optional[str], Field(None, description='Password for User')]
    confirmPassword: Annotated[
        Optional[str], Field(None, description='Confirm Password for User')
    ]
    domains: Annotated[
        Optional[List[basic.EntityName]],
        Field(None, description='Domains the User belongs to.'),
    ]
