# generated by datamodel-codegen:
#   filename:  api/tests/createTestDefinition.json
#   timestamp: 2025-04-02T05:35:35+00:00

from __future__ import annotations

from typing import List, Optional

from pydantic import ConfigDict, Field
from typing_extensions import Annotated

from metadata.ingestion.models.custom_pydantic import BaseModel

from ...entity.data import table
from ...tests import testDefinition
from ...type import basic, entityReferenceList


class CreateTestDefinitionRequest(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    name: Annotated[
        basic.TestCaseEntityName,
        Field(description='Name that identifies this test case.'),
    ]
    displayName: Annotated[
        Optional[str],
        Field(None, description='Display Name that identifies this test case.'),
    ]
    description: Annotated[
        basic.Markdown, Field(description='Description of the testcase.')
    ]
    owners: Annotated[
        Optional[entityReferenceList.EntityReferenceList],
        Field(None, description='Owners of this TestCase definition.'),
    ]
    entityType: testDefinition.EntityType
    testPlatforms: List[testDefinition.TestPlatform]
    supportedDataTypes: Optional[List[table.DataType]] = None
    provider: Optional[basic.ProviderType] = basic.ProviderType.user
    parameterDefinition: Optional[
        List[testDefinition.TestCaseParameterDefinition]
    ] = None
    domain: Annotated[
        Optional[str],
        Field(
            None, description='Fully qualified name of the domain the Table belongs to.'
        ),
    ]
