# generated by datamodel-codegen:
#   filename:  configuration/searchSettings.json
#   timestamp: 2025-04-02T05:35:35+00:00

from __future__ import annotations

from enum import Enum
from typing import Any, Dict, List, Optional

from pydantic import ConfigDict, Field
from typing_extensions import Annotated

from metadata.ingestion.models.custom_pydantic import BaseModel


class ScoreMode(Enum):
    multiply = 'multiply'
    sum = 'sum'
    avg = 'avg'
    first = 'first'
    max = 'max'
    min = 'min'


class BoostMode(Enum):
    multiply = 'multiply'
    replace = 'replace'
    sum = 'sum'
    avg = 'avg'
    max = 'max'
    min = 'min'


class FieldBoost(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    field: Annotated[str, Field(description='Field name to search/boost.')]
    boost: Annotated[
        Optional[float],
        Field(1.0, description='Relative boost factor for the above field.'),
    ]


class TermBoost(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    field: Annotated[
        str,
        Field(
            description='The keyword field to match, e.g. tier.tagFQN, tags.tagFQN, certification.tagLabel.tagFQN, etc.'
        ),
    ]
    value: Annotated[
        str, Field(description='The exact keyword value to match in the above field.')
    ]
    boost: Annotated[
        float,
        Field(
            description='Numeric boost factor to apply if a document has field==value.'
        ),
    ]


class Modifier(Enum):
    none = 'none'
    log = 'log'
    log1p = 'log1p'
    log2p = 'log2p'
    ln = 'ln'
    ln1p = 'ln1p'
    ln2p = 'ln2p'
    square = 'square'
    sqrt = 'sqrt'
    reciprocal = 'reciprocal'


class Range(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    gt: Optional[float] = None
    gte: Optional[float] = None
    lt: Optional[float] = None
    lte: Optional[float] = None


class Condition(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    range: Optional[Range] = None


class FieldValueBoost(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    field: Annotated[
        str, Field(description='Numeric field name whose value will affect the score.')
    ]
    factor: Annotated[
        float, Field(description='Multiplier factor for the field value.')
    ]
    modifier: Annotated[
        Optional[Modifier],
        Field(
            None,
            description='Optional mathematical transformation to apply to the field value.',
        ),
    ]
    missing: Annotated[
        Optional[float],
        Field(None, description='Value to use if the field is missing on a document.'),
    ]
    condition: Annotated[
        Optional[Condition],
        Field(
            None,
            description='Conditional logic (e.g., range constraints) to apply the boost only for certain values.',
        ),
    ]


class Type(Enum):
    terms = 'terms'
    range = 'range'
    histogram = 'histogram'
    date_histogram = 'date_histogram'
    filters = 'filters'
    missing = 'missing'
    nested = 'nested'
    reverse_nested = 'reverse_nested'
    top_hits = 'top_hits'
    max = 'max'
    min = 'min'
    avg = 'avg'
    sum = 'sum'
    stats = 'stats'


class Aggregation(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    name: Annotated[str, Field(description='A descriptive name for the aggregation.')]
    type: Annotated[Type, Field(description='The type of aggregation to perform.')]
    field: Annotated[
        str, Field(description='The field on which this aggregation is performed.')
    ]


class Field1(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    name: Annotated[
        str, Field(description='Field name that can be used in searchFields')
    ]
    description: Annotated[
        str,
        Field(
            description='Detailed explanation of what this field represents and how it affects search behavior'
        ),
    ]


class AllowedSearchFields(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    entityType: Annotated[
        str, Field(description='Entity type this field configuration applies to')
    ]
    fields: List[Field1]


class PromptSection(BaseModel):
    section: Annotated[
        str,
        Field(
            description="Section name (e.g., 'CRITICAL FIELD CORRECTIONS', 'QUERY PATTERNS')"
        ),
    ]
    content: Annotated[
        str, Field(description='The content for this section of the prompt')
    ]
    order: Annotated[
        Optional[int],
        Field(
            100,
            description='Display order for this section (lower numbers appear first)',
        ),
    ]


class TitleSection(BaseModel):
    title: Annotated[
        Optional[str], Field('INDEX MAPPINGS', description='Title for the section')
    ]
    description: Annotated[
        Optional[str],
        Field(
            'Below are the Elasticsearch mappings for the relevant indices. Use these to understand the document structure:',
            description='Description text for the section',
        ),
    ]
    order: Annotated[
        Optional[int],
        Field(
            5,
            description='Position of this section in the prompt (lower numbers appear first)',
        ),
    ]


class FieldInterpretation(BaseModel):
    pattern: Annotated[
        str, Field(description="Field pattern to match (e.g., 'tags.tagFQN')")
    ]
    explanation: Annotated[
        str, Field(description='How to interpret and query this field pattern')
    ]


class GuidelineSection(BaseModel):
    title: Annotated[
        str,
        Field(
            description="Section title (e.g., 'For EntityReference type custom properties')"
        ),
    ]
    guidelines: List[str]


class QueryExample(BaseModel):
    description: Annotated[
        Optional[str],
        Field(None, description='Human-readable description of the example query'),
    ]
    query: Annotated[str, Field(description='Natural language query example')]
    esQuery: Annotated[str, Field(description='The corresponding Elasticsearch query')]
    entityTypes: Annotated[
        Optional[List[str]],
        Field(
            None,
            description='Entity types this example applies to (empty array = all types)',
        ),
    ]


class GlobalSettings(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    enableAccessControl: Annotated[
        Optional[bool],
        Field(
            False,
            description='Flag to enable or disable RBAC Search Configuration globally.',
        ),
    ]
    maxAggregateSize: Optional[int] = 10000
    maxResultHits: Optional[int] = 10000
    maxAnalyzedOffset: Optional[int] = 1000
    aggregations: Annotated[
        Optional[List[Aggregation]],
        Field(
            None,
            description='List of global aggregations to include in the search query.',
        ),
    ]
    highlightFields: Annotated[
        Optional[List[str]],
        Field(None, description='Which fields to highlight by default.'),
    ]
    termBoosts: Annotated[
        Optional[List[TermBoost]],
        Field(
            None,
            description='List of field=value term-boost rules that apply only to this asset.',
        ),
    ]
    fieldValueBoosts: Annotated[
        Optional[List[FieldValueBoost]],
        Field(
            None,
            description='Optional list of numeric field-based boosts applied globally.',
        ),
    ]


class EntitySpecificInstruction(BaseModel):
    entityType: Annotated[
        str,
        Field(
            description="Entity type this instruction applies to (e.g., 'table', 'dashboard')"
        ),
    ]
    sections: List[PromptSection]


class MappingConfiguration(BaseModel):
    includeMappings: Annotated[
        Optional[bool],
        Field(
            True, description='Whether to include mapping information in the prompts'
        ),
    ]
    mappingSection: Optional[TitleSection] = None
    fieldInterpretations: Annotated[
        Optional[List[FieldInterpretation]],
        Field(
            None,
            description='Specific guidance for interpreting field patterns in the mapping',
        ),
    ]


class ExtensionFieldGuidelines(BaseModel):
    header: Annotated[
        str, Field(description='Title for the extension field guidelines section')
    ]
    sections: List[GuidelineSection]
    examples: Optional[List[QueryExample]] = None


class NlqConfiguration(BaseModel):
    promptTemplate: Annotated[
        Optional[str],
        Field(
            None,
            description='Base prompt template for the NLQ system. Use {{INSTRUCTIONS}} where entity-specific instructions should appear.',
        ),
    ]
    globalInstructions: Optional[List[PromptSection]] = None
    entitySpecificInstructions: Optional[List[EntitySpecificInstruction]] = None
    examples: Optional[List[QueryExample]] = None
    mappingConfiguration: Annotated[
        Optional[MappingConfiguration],
        Field(
            None,
            description='Configuration for including Elasticsearch mapping information in prompts',
        ),
    ]
    extensionFieldGuidelines: Annotated[
        Optional[ExtensionFieldGuidelines],
        Field(
            None,
            description='Guidelines for querying custom properties in extension fields',
        ),
    ]


class AssetTypeConfiguration(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    assetType: Annotated[
        str,
        Field(
            description='Name or type of the asset to which this configuration applies.'
        ),
    ]
    searchFields: Annotated[
        Optional[List[FieldBoost]],
        Field(
            None,
            description='Which fields to search for this asset, with their boost values.',
        ),
    ]
    highlightFields: Annotated[
        Optional[List[str]],
        Field(None, description='Which fields to highlight for this asset.'),
    ]
    aggregations: Annotated[
        Optional[List[Aggregation]],
        Field(None, description='List of additional aggregations for this asset type.'),
    ]
    termBoosts: Annotated[
        Optional[List[TermBoost]],
        Field(
            None,
            description='List of field=value term-boost rules that apply only to this asset.',
        ),
    ]
    fieldValueBoosts: Annotated[
        Optional[List[FieldValueBoost]],
        Field(
            None,
            description='List of numeric field-based boosts that apply only to this asset.',
        ),
    ]
    scoreMode: Annotated[
        Optional[ScoreMode],
        Field(
            None,
            description='How to combine function scores if multiple boosts are applied.',
        ),
    ]
    boostMode: Annotated[
        Optional[BoostMode],
        Field(
            None,
            description='How the function score is combined with the main query score.',
        ),
    ]
    additionalSettings: Annotated[
        Optional[Dict[str, Any]],
        Field(
            None,
            description='Catch-all for any advanced or asset-specific search settings.',
        ),
    ]


class SearchSettings(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    globalSettings: Optional[GlobalSettings] = None
    assetTypeConfigurations: Annotated[
        Optional[List[AssetTypeConfiguration]],
        Field(
            None,
            description='List of per-asset search configurations that override the global settings.',
        ),
    ]
    defaultConfiguration: Annotated[
        Optional[AssetTypeConfiguration],
        Field(
            None,
            description='Fallback configuration for any entity/asset not matched in assetTypeConfigurations.',
        ),
    ]
    allowedFields: Annotated[
        Optional[List[AllowedSearchFields]],
        Field(
            None,
            description='Configurations of allowed searchable fields for each entity type',
        ),
    ]
    nlqConfiguration: Annotated[
        Optional[NlqConfiguration],
        Field(
            None, description='Configuration for Natural Language Query capabilities'
        ),
    ]
