# generated by datamodel-codegen:
#   filename:  dataInsight/kpi/basic.json
#   timestamp: 2025-04-02T05:35:35+00:00

from __future__ import annotations

from enum import Enum
from typing import Any, List, Optional

from pydantic import ConfigDict, Field, RootModel
from typing_extensions import Annotated

from metadata.ingestion.models.custom_pydantic import BaseModel

from ...type import basic


class Basic(RootModel[Any]):
    root: Annotated[
        Any,
        Field(
            description='This schema defines basic types that are used by other Kpi Definitions',
            title='Basic',
        ),
    ]


class KpiTargetType(Enum):
    NUMBER = 'NUMBER'
    PERCENTAGE = 'PERCENTAGE'


class KpiTarget(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    name: Annotated[
        str,
        Field(
            description='name of the parameter. Must match the parameter names in metrics of the chart this objective refers'
        ),
    ]
    value: Annotated[
        str,
        Field(
            description='value to be passed for the Parameters. These are input from Users. We capture this in string and convert during the runtime.'
        ),
    ]
    targetMet: Annotated[
        Optional[bool],
        Field(None, description='whether the target value was met or not.'),
    ]


class KpiResult(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    timestamp: Annotated[
        basic.Timestamp, Field(description='Data one which result is updated')
    ]
    kpiFqn: Annotated[
        Optional[basic.FullyQualifiedEntityName], Field(None, description='KPI FQN')
    ]
    targetResult: Annotated[
        List[KpiTarget],
        Field(description='Metric and their corresponding current results'),
    ]
