# generated by datamodel-codegen:
#   filename:  entity/data/storedProcedure.json
#   timestamp: 2025-04-02T05:35:35+00:00

from __future__ import annotations

from enum import Enum
from typing import List, Optional

from pydantic import ConfigDict, Field
from typing_extensions import Annotated

from metadata.ingestion.models.custom_pydantic import BaseModel

from ...type import (
    assetCertification,
    basic,
    entityHistory,
    entityReference,
    entityReferenceList,
    lifeCycle,
    tagLabel,
    votes,
)
from ..services import databaseService


class StoredProcedureType(Enum):
    StoredProcedure = 'StoredProcedure'
    UDF = 'UDF'
    StoredPackage = 'StoredPackage'
    Function = 'Function'


class Language(Enum):
    SQL = 'SQL'
    Java = 'Java'
    JavaScript = 'JavaScript'
    Python = 'Python'
    External = 'External'


class StoredProcedureCode(BaseModel):
    language: Annotated[
        Optional[Language],
        Field(
            None,
            description="This schema defines the type of the language used for Stored Procedure's Code.",
        ),
    ]
    code: Annotated[
        Optional[str],
        Field(
            None,
            description="This schema defines the type of the language used for Stored Procedure's Code.",
        ),
    ]


class StoredProcedure(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    id: Annotated[
        basic.Uuid, Field(description='Unique identifier of the StoredProcedure.')
    ]
    name: Annotated[basic.EntityName, Field(description='Name of Stored Procedure.')]
    fullyQualifiedName: Annotated[
        Optional[basic.FullyQualifiedEntityName],
        Field(None, description='Fully qualified name of a Stored Procedure.'),
    ]
    displayName: Annotated[
        Optional[str],
        Field(None, description='Display Name that identifies this Stored Procedure.'),
    ]
    description: Annotated[
        Optional[basic.Markdown],
        Field(None, description='Description of a Stored Procedure.'),
    ]
    storedProcedureCode: Annotated[
        StoredProcedureCode, Field(description='Stored Procedure Code.')
    ]
    version: Annotated[
        Optional[entityHistory.EntityVersion],
        Field(None, description='Metadata version of the Stored Procedure.'),
    ]
    dataProducts: Annotated[
        Optional[entityReferenceList.EntityReferenceList],
        Field(None, description='List of data products this entity is part of.'),
    ]
    updatedAt: Annotated[
        Optional[basic.Timestamp],
        Field(
            None,
            description='Last update time corresponding to the new version of the entity in Unix epoch time milliseconds.',
        ),
    ]
    storedProcedureType: Annotated[
        Optional[StoredProcedureType],
        Field(
            StoredProcedureType.StoredProcedure,
            description='Type of the Stored Procedure.',
        ),
    ]
    updatedBy: Annotated[
        Optional[str], Field(None, description='User who made the query.')
    ]
    href: Annotated[
        Optional[basic.Href], Field(None, description='Link to this Query resource.')
    ]
    changeDescription: Annotated[
        Optional[entityHistory.ChangeDescription],
        Field(None, description='Change that lead to this version of the entity.'),
    ]
    incrementalChangeDescription: Annotated[
        Optional[entityHistory.ChangeDescription],
        Field(None, description='Change that lead to this version of the entity.'),
    ]
    databaseSchema: Annotated[
        Optional[entityReference.EntityReference],
        Field(
            None,
            description='Reference to Database Schema that contains this stored procedure.',
        ),
    ]
    database: Annotated[
        Optional[entityReference.EntityReference],
        Field(
            None,
            description='Reference to Database that contains this stored procedure.',
        ),
    ]
    service: Annotated[
        Optional[entityReference.EntityReference],
        Field(None, description='Link to Database service this table is hosted in.'),
    ]
    serviceType: Annotated[
        Optional[databaseService.DatabaseServiceType],
        Field(None, description='Service type this table is hosted in.'),
    ]
    deleted: Annotated[
        Optional[bool],
        Field(
            False, description='When `true` indicates the entity has been soft deleted.'
        ),
    ]
    owners: Annotated[
        Optional[entityReferenceList.EntityReferenceList],
        Field(None, description='Owners of this Stored Procedure.'),
    ]
    followers: Annotated[
        Optional[entityReferenceList.EntityReferenceList],
        Field(None, description='Followers of this Stored Procedure.'),
    ]
    votes: Annotated[
        Optional[votes.Votes], Field(None, description='Votes on the entity.')
    ]
    code: Annotated[
        Optional[basic.SqlQuery], Field(None, description='SQL Query definition.')
    ]
    tags: Annotated[
        Optional[List[tagLabel.TagLabel]],
        Field([], description='Tags for this SQL query.'),
    ]
    extension: Annotated[
        Optional[basic.EntityExtension],
        Field(
            None,
            description='Entity extension data with custom attributes added to the entity.',
        ),
    ]
    sourceUrl: Annotated[
        Optional[basic.SourceUrl],
        Field(None, description='Source URL of database schema.'),
    ]
    domain: Annotated[
        Optional[entityReference.EntityReference],
        Field(
            None,
            description='Domain the Stored Procedure belongs to. When not set, the Stored Procedure inherits the domain from the database schemna it belongs to.',
        ),
    ]
    lifeCycle: Annotated[
        Optional[lifeCycle.LifeCycle],
        Field(None, description='Life Cycle properties of the entity'),
    ]
    certification: Optional[assetCertification.AssetCertification] = None
    sourceHash: Annotated[
        Optional[str],
        Field(
            None, description='Source hash of the entity', max_length=32, min_length=1
        ),
    ]
    processedLineage: Annotated[
        Optional[bool],
        Field(False, description='Processed lineage for the stored procedure'),
    ]
