# generated by datamodel-codegen:
#   filename:  entity/services/connections/database/clickhouseConnection.json
#   timestamp: 2025-04-02T05:35:35+00:00

from __future__ import annotations

from enum import Enum
from typing import Optional

from pydantic import ConfigDict, Field
from typing_extensions import Annotated

from metadata.ingestion.models.custom_pydantic import BaseModel, CustomSecretStr

from .....type import filterPattern
from .. import connectionBasicType


class ClickhouseType(Enum):
    Clickhouse = 'Clickhouse'


class ClickhouseScheme(Enum):
    clickhouse_http = 'clickhouse+http'
    clickhouse_native = 'clickhouse+native'


class ClickhouseConnection(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    type: Annotated[
        Optional[ClickhouseType],
        Field(
            ClickhouseType.Clickhouse, description='Service Type', title='Service Type'
        ),
    ]
    scheme: Annotated[
        Optional[ClickhouseScheme],
        Field(
            ClickhouseScheme.clickhouse_http,
            description='SQLAlchemy driver scheme options.',
            title='Connection Scheme',
        ),
    ]
    username: Annotated[
        Optional[str],
        Field(
            None,
            description='Username to connect to Clickhouse. This user should have privileges to read all the metadata in Clickhouse.',
            title='Username',
        ),
    ]
    password: Annotated[
        Optional[CustomSecretStr],
        Field(None, description='Password to connect to Clickhouse.', title='Password'),
    ]
    hostPort: Annotated[
        str,
        Field(
            description='Host and port of the Clickhouse service.',
            title='Host and Port',
        ),
    ]
    databaseName: Annotated[
        Optional[str],
        Field(
            None,
            description='Optional name to give to the database in OpenMetadata. If left blank, we will use default as the database name.',
            title='Database Name',
        ),
    ]
    databaseSchema: Annotated[
        Optional[str],
        Field(
            None,
            description='Database Schema of the data source. This is optional parameter, if you would like to restrict the metadata reading to a single schema. When left blank, OpenMetadata Ingestion attempts to scan all the schemas.',
            title='Database Schema',
        ),
    ]
    duration: Annotated[
        Optional[int],
        Field(
            None, description='Clickhouse SQL connection duration.', title='Duration'
        ),
    ]
    https: Annotated[
        Optional[bool],
        Field(
            None,
            description='Use HTTPS Protocol for connection with clickhouse',
            title='Use HTTPS Protocol',
        ),
    ]
    secure: Annotated[
        Optional[bool],
        Field(
            None,
            description='Establish secure connection with clickhouse',
            title='Secure Connection',
        ),
    ]
    keyfile: Annotated[
        Optional[str],
        Field(
            None,
            description='Path to key file for establishing secure connection',
            title='Key File Path',
        ),
    ]
    connectionOptions: Annotated[
        Optional[connectionBasicType.ConnectionOptions],
        Field(None, title='Connection Options'),
    ]
    connectionArguments: Annotated[
        Optional[connectionBasicType.ConnectionArguments],
        Field(None, title='Connection Arguments'),
    ]
    schemaFilterPattern: Annotated[
        Optional[filterPattern.FilterPattern],
        Field(
            None,
            description='Regex to only include/exclude schemas that matches the pattern.',
            title='Default Schema Filter Pattern',
        ),
    ]
    tableFilterPattern: Annotated[
        Optional[filterPattern.FilterPattern],
        Field(
            None,
            description='Regex to only include/exclude tables that matches the pattern.',
            title='Default Table Filter Pattern',
        ),
    ]
    databaseFilterPattern: Annotated[
        Optional[filterPattern.FilterPattern],
        Field(
            None,
            description='Regex to only include/exclude databases that matches the pattern.',
            title='Default Database Filter Pattern',
        ),
    ]
    supportsMetadataExtraction: Annotated[
        Optional[connectionBasicType.SupportsMetadataExtraction],
        Field(None, title='Supports Metadata Extraction'),
    ]
    supportsUsageExtraction: Optional[
        connectionBasicType.SupportsUsageExtraction
    ] = None
    supportsLineageExtraction: Optional[
        connectionBasicType.SupportsLineageExtraction
    ] = None
    supportsDBTExtraction: Optional[connectionBasicType.SupportsDBTExtraction] = None
    supportsProfiler: Annotated[
        Optional[connectionBasicType.SupportsProfiler],
        Field(None, title='Supports Profiler'),
    ]
    supportsQueryComment: Annotated[
        Optional[connectionBasicType.SupportsQueryComment],
        Field(None, title='Supports Query Comment'),
    ]
    sampleDataStorageConfig: Annotated[
        Optional[connectionBasicType.SampleDataStorageConfig],
        Field(None, title='Storage Config for Sample Data'),
    ]
