# generated by datamodel-codegen:
#   filename:  entity/services/connections/database/deltalake/metastoreConfig.json
#   timestamp: 2025-04-02T05:35:35+00:00

from __future__ import annotations

from typing import Optional, Union

from pydantic import ConfigDict, Field
from typing_extensions import Annotated

from metadata.ingestion.models.custom_pydantic import BaseModel, CustomSecretStr


class MetastoreHostPortConnection(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    metastoreHostPort: Annotated[
        Optional[str],
        Field(
            None,
            description='Thrift connection to the metastore service. E.g., localhost:9083',
            title='Hive Metastore Service',
        ),
    ]


class MetastoreDbConnection(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    metastoreDb: Annotated[
        Optional[str],
        Field(
            None,
            description='JDBC connection to the metastore database. E.g., jdbc:mysql://localhost:3306/demo_hive',
            title='Hive Metastore Database',
        ),
    ]
    username: Annotated[
        Optional[str],
        Field(
            None,
            description='Username to use against metastore database. The value will be mapped as spark.hadoop.javax.jdo.option.ConnectionUserName sparks property.',
            title='Connection UserName',
        ),
    ]
    password: Annotated[
        Optional[CustomSecretStr],
        Field(
            None,
            description='Password to use against metastore database. The value will be mapped as spark.hadoop.javax.jdo.option.ConnectionPassword sparks property.',
            title='Connection Password',
        ),
    ]
    driverName: Annotated[
        Optional[str],
        Field(
            None,
            description='Driver class name for JDBC metastore. The value will be mapped as spark.hadoop.javax.jdo.option.ConnectionDriverName sparks property. E.g., org.mariadb.jdbc.Driver',
            title='Connection Driver Name',
        ),
    ]
    jdbcDriverClassPath: Annotated[
        Optional[str],
        Field(
            None,
            description='Class path to JDBC driver required for JDBC connection. The value will be mapped as spark.driver.extraClassPath sparks property.',
            title='JDBC Driver Class Path',
        ),
    ]


class MetastoreFilePathConnection(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    metastoreFilePath: Annotated[
        Optional[str],
        Field(
            None,
            description='Local path for the local file with metastore data. E.g., /tmp/metastore.db',
            title='Hive Metastore File Path',
        ),
    ]


class MetastoreConfig(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    connection: Annotated[
        Union[
            MetastoreHostPortConnection,
            MetastoreDbConnection,
            MetastoreFilePathConnection,
        ],
        Field(
            description='Metastore connection configuration, depending on your metastore type.',
            title='Connection',
        ),
    ]
    appName: Annotated[
        Optional[str],
        Field(
            'OpenMetadata', description='pySpark App Name.', title='Application Name'
        ),
    ]
