# generated by datamodel-codegen:
#   filename:  entity/services/connections/messaging/kafkaConnection.json
#   timestamp: 2025-04-02T05:35:35+00:00

from __future__ import annotations

from enum import Enum
from typing import Any, Dict, Optional

from pydantic import AnyUrl, ConfigDict, Field
from typing_extensions import Annotated

from metadata.ingestion.models.custom_pydantic import BaseModel, CustomSecretStr

from .....security.ssl import verifySSLConfig
from .....type import filterPattern
from .. import connectionBasicType
from . import saslMechanismType


class SecurityProtocol(Enum):
    PLAINTEXT = 'PLAINTEXT'
    SASL_PLAINTEXT = 'SASL_PLAINTEXT'
    SASL_SSL = 'SASL_SSL'
    SSL = 'SSL'


class KafkaType(Enum):
    Kafka = 'Kafka'


class KafkaConnection(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    type: Annotated[
        Optional[KafkaType],
        Field(KafkaType.Kafka, description='Service Type', title='Service Type'),
    ]
    bootstrapServers: Annotated[
        str,
        Field(
            description='Kafka bootstrap servers. add them in comma separated values ex: host1:9092,host2:9092',
            title='Bootstrap Servers',
        ),
    ]
    schemaRegistryURL: Annotated[
        Optional[AnyUrl],
        Field(
            None,
            description='Confluent Kafka Schema Registry URL.',
            title='Schema Registry URL',
        ),
    ]
    saslUsername: Annotated[
        Optional[str],
        Field(
            None,
            description='sasl.username consumer config property',
            title='SASL Username',
        ),
    ]
    saslPassword: Annotated[
        Optional[CustomSecretStr],
        Field(
            None,
            description='sasl.password consumer config property',
            title='SASL Password',
        ),
    ]
    securityProtocol: Annotated[
        Optional[SecurityProtocol],
        Field(
            SecurityProtocol.PLAINTEXT,
            description='security.protocol consumer config property',
            title='Security Protocol',
        ),
    ]
    saslMechanism: Annotated[
        Optional[saslMechanismType.SaslMechanismType],
        Field(
            saslMechanismType.SaslMechanismType.PLAIN,
            description='sasl.mechanism Consumer Config property',
            title='SASL Mechanism',
        ),
    ]
    basicAuthUserInfo: Annotated[
        Optional[CustomSecretStr],
        Field(
            None,
            description='basic.auth.user.info schema registry config property, Client HTTP credentials in the form of username:password.',
            title='Schema Registry Basic Auth User Info',
        ),
    ]
    consumerConfig: Annotated[
        Optional[Dict[str, Any]],
        Field(
            {},
            description='Confluent Kafka Consumer Config. From https://github.com/edenhill/librdkafka/blob/master/CONFIGURATION.md',
            title='Consumer Config',
        ),
    ]
    schemaRegistryConfig: Annotated[
        Optional[Dict[str, Any]],
        Field(
            {},
            description='Confluent Kafka Schema Registry Config. From https://docs.confluent.io/5.5.1/clients/confluent-kafka-python/index.html#confluent_kafka.schema_registry.SchemaRegistryClient',
            title='Schema Registry Config',
        ),
    ]
    schemaRegistryTopicSuffixName: Annotated[
        Optional[str],
        Field(
            '-value',
            description='Schema Registry Topic Suffix Name. The suffix to be appended to the topic name to get topic schema from registry.',
            title='Schema Registry Topic Suffix Name',
        ),
    ]
    consumerConfigSSL: Annotated[
        Optional[verifySSLConfig.SslConfig],
        Field(
            None,
            description='Consumer Config SSL Config. Configuration for enabling SSL for the Consumer Config connection.',
            title='Consumer Config SSL',
        ),
    ]
    schemaRegistrySSL: Annotated[
        Optional[verifySSLConfig.SslConfig],
        Field(
            None,
            description='Schema Registry SSL Config. Configuration for enabling SSL for the Schema Registry connection.',
            title='Schema Registry SSL',
        ),
    ]
    topicFilterPattern: Annotated[
        Optional[filterPattern.FilterPattern],
        Field(
            None,
            description='Regex to only fetch topics that matches the pattern.',
            title='Default Topic Filter Pattern',
        ),
    ]
    supportsMetadataExtraction: Annotated[
        Optional[connectionBasicType.SupportsMetadataExtraction],
        Field(None, title='Supports Metadata Extraction'),
    ]
