# generated by datamodel-codegen:
#   filename:  entity/services/connections/metadata/atlasConnection.json
#   timestamp: 2025-04-02T05:35:35+00:00

from __future__ import annotations

from enum import Enum
from typing import List, Optional

from pydantic import AnyUrl, ConfigDict, Field
from typing_extensions import Annotated

from metadata.ingestion.models.custom_pydantic import BaseModel, CustomSecretStr

from .....type import filterPattern
from .. import connectionBasicType


class AtlasType(Enum):
    Atlas = 'Atlas'


class AtlasConnection(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    type: Annotated[
        Optional[AtlasType], Field(AtlasType.Atlas, description='Service Type')
    ]
    username: Annotated[
        str,
        Field(
            description='username to connect  to the Atlas. This user should have privileges to read all the metadata in Atlas.'
        ),
    ]
    password: Annotated[
        CustomSecretStr, Field(description='password to connect  to the Atlas.')
    ]
    hostPort: Annotated[
        Optional[AnyUrl],
        Field(
            None,
            description='Host and port of the Atlas service.',
            title='Host and Port',
        ),
    ]
    databaseServiceName: Annotated[
        Optional[List[str]], Field(None, description='service type of the data source.')
    ]
    messagingServiceName: Annotated[
        Optional[List[str]],
        Field(None, description='service type of the messaging source'),
    ]
    entity_type: Annotated[
        str,
        Field(
            description='Name of the Entity Type available in Atlas.',
            title='Entity Type',
        ),
    ]
    connectionOptions: Optional[connectionBasicType.ConnectionOptions] = None
    connectionArguments: Optional[connectionBasicType.ConnectionArguments] = None
    schemaFilterPattern: Annotated[
        Optional[filterPattern.FilterPattern],
        Field(
            None,
            description='Regex to only include/exclude schemas that matches the pattern.',
            title='Default Schema Filter Pattern',
        ),
    ]
    tableFilterPattern: Annotated[
        Optional[filterPattern.FilterPattern],
        Field(
            None,
            description='Regex to only include/exclude tables that matches the pattern.',
            title='Default Table Filter Pattern',
        ),
    ]
    databaseFilterPattern: Annotated[
        Optional[filterPattern.FilterPattern],
        Field(
            None,
            description='Regex to only include/exclude databases that matches the pattern.',
            title='Default Database Filter Pattern',
        ),
    ]
    supportsMetadataExtraction: Optional[
        connectionBasicType.SupportsMetadataExtraction
    ] = None
