# generated by datamodel-codegen:
#   filename:  entity/services/connections/pipeline/databricksPipelineConnection.json
#   timestamp: 2025-04-02T05:35:35+00:00

from __future__ import annotations

from enum import Enum
from typing import Optional

from pydantic import ConfigDict, Field
from typing_extensions import Annotated

from metadata.ingestion.models.custom_pydantic import BaseModel, CustomSecretStr

from .....type import filterPattern
from .. import connectionBasicType


class DatabricksType(Enum):
    DatabricksPipeline = 'DatabricksPipeline'


class DatabricksPipelineConnection(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    type: Annotated[
        Optional[DatabricksType],
        Field(
            DatabricksType.DatabricksPipeline,
            description='Service Type',
            title='Service Type',
        ),
    ]
    hostPort: Annotated[
        str,
        Field(
            description='Host and port of the Databricks service.',
            title='Host and Port',
        ),
    ]
    token: Annotated[
        CustomSecretStr,
        Field(description='Generated Token to connect to Databricks.', title='Token'),
    ]
    httpPath: Annotated[
        Optional[str],
        Field(None, description='Databricks compute resources URL.', title='Http Path'),
    ]
    connectionArguments: Annotated[
        Optional[connectionBasicType.ConnectionArguments],
        Field(None, title='Connection Arguments'),
    ]
    pipelineFilterPattern: Annotated[
        Optional[filterPattern.FilterPattern],
        Field(
            None,
            description='Regex exclude pipelines.',
            title='Default Pipeline Filter Pattern',
        ),
    ]
    supportsMetadataExtraction: Annotated[
        Optional[connectionBasicType.SupportsMetadataExtraction],
        Field(None, title='Supports Metadata Extraction'),
    ]
