# generated by datamodel-codegen:
#   filename:  entity/services/connections/search/openSearchConnection.json
#   timestamp: 2025-04-02T05:35:35+00:00

from __future__ import annotations

from enum import Enum
from typing import Optional, Union

from pydantic import AnyUrl, ConfigDict, Field
from typing_extensions import Annotated

from metadata.ingestion.models.custom_pydantic import BaseModel

from .....security.credentials import awsCredentials
from .....security.ssl import verifySSLConfig
from .....type import filterPattern
from .. import connectionBasicType
from ..common import sslConfig
from .elasticSearch import basicAuth


class OpenSearchType(Enum):
    OpenSearch = 'OpenSearch'


class OpenSearchConnection(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    type: Annotated[
        Optional[OpenSearchType],
        Field(
            OpenSearchType.OpenSearch,
            description='OpenSearch Type',
            title='OpenSearch Type',
        ),
    ]
    hostPort: Annotated[
        Optional[AnyUrl],
        Field(
            None,
            description='Host and port of the OpenSearch service.',
            title='Host and Port',
        ),
    ]
    authType: Annotated[
        Optional[Union[basicAuth.BasicAuthentication, awsCredentials.AWSCredentials]],
        Field(
            None,
            description='Choose Auth Config Type.',
            title='Auth Configuration Type',
        ),
    ]
    verifySSL: Optional[verifySSLConfig.VerifySSL] = verifySSLConfig.VerifySSL.no_ssl
    sslConfig: Annotated[Optional[sslConfig.SslConfig], Field(None, title='SSL Config')]
    connectionTimeoutSecs: Annotated[
        Optional[int],
        Field(
            30,
            description='Connection Timeout in Seconds',
            title='Connection Timeout in Seconds',
        ),
    ]
    connectionArguments: Annotated[
        Optional[connectionBasicType.ConnectionArguments],
        Field(None, title='Connection Arguments'),
    ]
    searchIndexFilterPattern: Annotated[
        Optional[filterPattern.FilterPattern],
        Field(
            None,
            description='Regex to only fetch search indexes that matches the pattern.',
            title='Default Search Index Filter Pattern',
        ),
    ]
    supportsMetadataExtraction: Annotated[
        Optional[connectionBasicType.SupportsMetadataExtraction],
        Field(None, title='Supports Metadata Extraction'),
    ]
