# generated by datamodel-codegen:
#   filename:  metadataIngestion/mlmodelServiceMetadataPipeline.json
#   timestamp: 2025-04-02T05:35:35+00:00

from __future__ import annotations

from enum import Enum
from typing import Optional

from pydantic import ConfigDict, Field
from typing_extensions import Annotated

from metadata.ingestion.models.custom_pydantic import BaseModel

from ..type import filterPattern


class MlModelMetadataConfigType(Enum):
    MlModelMetadata = 'MlModelMetadata'


class MlModelServiceMetadataPipeline(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    type: Annotated[
        Optional[MlModelMetadataConfigType],
        Field(MlModelMetadataConfigType.MlModelMetadata, description='Pipeline type'),
    ]
    mlModelFilterPattern: Annotated[
        Optional[filterPattern.FilterPattern],
        Field(
            None,
            description='Regex to only fetch MlModels with names matching the pattern.',
            title='ML Model Filter Pattern',
        ),
    ]
    markDeletedMlModels: Annotated[
        Optional[bool],
        Field(
            True,
            description='Optional configuration to soft delete MlModels in OpenMetadata if the source MlModels are deleted. Also, if the MlModel is deleted, all the associated entities like lineage, etc., with that MlModels will be deleted',
            title='Mark Deleted ML Models',
        ),
    ]
    overrideMetadata: Annotated[
        Optional[bool],
        Field(
            False,
            description="Set the 'Override Metadata' toggle to control whether to override the existing metadata in the OpenMetadata server with the metadata fetched from the source. If the toggle is set to true, the metadata fetched from the source will override the existing metadata in the OpenMetadata server. If the toggle is set to false, the metadata fetched from the source will not override the existing metadata in the OpenMetadata server. This is applicable for fields like description, tags, owner and displayName",
            title='Override Metadata',
        ),
    ]
