# generated by datamodel-codegen:
#   filename:  metadataIngestion/searchServiceMetadataPipeline.json
#   timestamp: 2025-04-02T05:35:35+00:00

from __future__ import annotations

from enum import Enum
from typing import Optional

from pydantic import ConfigDict, Field
from typing_extensions import Annotated

from metadata.ingestion.models.custom_pydantic import BaseModel

from ..type import filterPattern


class SearchMetadataConfigType(Enum):
    SearchMetadata = 'SearchMetadata'


class SearchServiceMetadataPipeline(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    type: Annotated[
        Optional[SearchMetadataConfigType],
        Field(SearchMetadataConfigType.SearchMetadata, description='Pipeline type'),
    ]
    searchIndexFilterPattern: Annotated[
        Optional[filterPattern.FilterPattern],
        Field(
            None,
            description='Regex to only fetch search indexes that matches the pattern.',
            title='Search Index Filter Pattern',
        ),
    ]
    markDeletedSearchIndexes: Annotated[
        Optional[bool],
        Field(
            True,
            description='Optional configuration to soft delete search indexes in OpenMetadata if the source search indexes are deleted. Also, if the search index is deleted, all the associated entities like lineage, etc., with that search index will be deleted',
            title='Mark Deleted Search Indexes',
        ),
    ]
    includeSampleData: Annotated[
        Optional[bool],
        Field(
            True,
            description='Optional configuration to turn off fetching sample data for search index.',
            title='Include Sample Data',
        ),
    ]
    sampleSize: Annotated[
        Optional[int],
        Field(
            10,
            description='No. of records of sample data we want to ingest.',
            title='Sample Size',
        ),
    ]
    overrideMetadata: Annotated[
        Optional[bool],
        Field(
            False,
            description="Set the 'Override Metadata' toggle to control whether to override the existing metadata in the OpenMetadata server with the metadata fetched from the source. If the toggle is set to true, the metadata fetched from the source will override the existing metadata in the OpenMetadata server. If the toggle is set to false, the metadata fetched from the source will not override the existing metadata in the OpenMetadata server. This is applicable for fields like description, tags, owner and displayName",
            title='Override Metadata',
        ),
    ]
    includeIndexTemplate: Annotated[
        Optional[bool],
        Field(
            False,
            description="Enable the 'Include Index Template' toggle to manage the ingestion of index template data.",
            title='Include Index Template',
        ),
    ]
