# generated by datamodel-codegen:
#   filename:  security/client/oidcClientConfig.json
#   timestamp: 2025-04-02T05:35:35+00:00

from __future__ import annotations

from enum import Enum
from typing import Any, Dict, Optional

from pydantic import ConfigDict, Field
from typing_extensions import Annotated

from metadata.ingestion.models.custom_pydantic import BaseModel


class ClientAuthenticationMethod(Enum):
    client_secret_basic = 'client_secret_basic'
    client_secret_post = 'client_secret_post'
    client_secret_jwt = 'client_secret_jwt'
    private_key_jwt = 'private_key_jwt'


class OidcClientConfig(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    type: Annotated[
        Optional[str], Field(None, description='IDP type (Example Google,Azure).')
    ]
    id: Annotated[Optional[str], Field(None, description='Client ID.')]
    secret: Annotated[Optional[str], Field(None, description='Client Secret.')]
    scope: Annotated[
        Optional[str], Field('openid email profile', description='Oidc Request Scopes.')
    ]
    discoveryUri: Annotated[
        Optional[str], Field(None, description='Discovery Uri for the Client.')
    ]
    useNonce: Annotated[Optional[str], Field(True, description='Use Nonce.')]
    preferredJwsAlgorithm: Annotated[
        Optional[str], Field('RS256', description='Preferred Jws Algorithm.')
    ]
    responseType: Annotated[
        Optional[str], Field('code', description='Auth0 Client Secret Key.')
    ]
    disablePkce: Annotated[Optional[bool], Field(True, description='Disable PKCE.')]
    maxClockSkew: Annotated[Optional[str], Field(None, description='Max Clock Skew')]
    clientAuthenticationMethod: Annotated[
        Optional[ClientAuthenticationMethod],
        Field(None, description='Client Authentication Method.'),
    ]
    tokenValidity: Annotated[
        Optional[int],
        Field(
            '3600', description='Validity for the JWT Token created from SAML Response'
        ),
    ]
    customParams: Annotated[
        Optional[Dict[str, Any]], Field(None, description='Custom Params.')
    ]
    tenant: Annotated[
        Optional[str], Field(None, description='Tenant in case of Azure.')
    ]
    serverUrl: Annotated[Optional[str], Field(None, description='Server Url.')]
    callbackUrl: Annotated[Optional[str], Field(None, description='Callback Url.')]
