# generated by datamodel-codegen:
#   filename:  system/validationResponse.json
#   timestamp: 2025-04-02T05:35:35+00:00

from __future__ import annotations

from typing import Optional

from pydantic import ConfigDict, Field
from typing_extensions import Annotated

from metadata.ingestion.models.custom_pydantic import BaseModel


class StepValidation(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    description: Annotated[
        Optional[str],
        Field(None, description='Validation description. What is being tested?'),
    ]
    passed: Annotated[
        Optional[bool], Field(None, description='Did the step validation successfully?')
    ]
    message: Annotated[
        Optional[str],
        Field(
            None,
            description='Results or exceptions to be shared after running the test.',
        ),
    ]


class SystemValidationResponse(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    database: Annotated[
        Optional[StepValidation], Field(None, description='Database connectivity check')
    ]
    searchInstance: Annotated[
        Optional[StepValidation],
        Field(None, description='Search instance connectivity check'),
    ]
    pipelineServiceClient: Annotated[
        Optional[StepValidation],
        Field(None, description='Pipeline Service Client connectivity check'),
    ]
    jwks: Annotated[
        Optional[StepValidation], Field(None, description='JWKs validation')
    ]
    migrations: Annotated[
        Optional[StepValidation], Field(None, description='List migration results')
    ]
