# coding: utf-8

"""
    VRt.Account [AC]

    The version of the OpenAPI document: 6.9.2071

    Generated by OpenAPI Generator: 6.6.0

    Do not edit the code manually

    2023 Veeroute
"""


import re  # noqa: F401

from pydantic import validate_arguments, ValidationError
from typing_extensions import Annotated

from pydantic import Field, StrictStr, conint

from typing import Optional, Union

from vrt_lss_account.models.flow_convert import FlowConvert
from vrt_lss_account.models.flow_type import FlowType

from vrt_lss_account.api_client import ApiClient
from vrt_lss_account.exceptions import (  # noqa: F401
    ApiTypeError,
    ApiValueError
)


class DataApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client

    @validate_arguments
    def read_data(self, tracecode : Annotated[StrictStr, Field(..., description="Unique process identifier.")], data_flow_type : Annotated[Optional[FlowType], Field(description="Data flow type.")] = None, data_flow_stage : Annotated[Optional[conint(strict=True, le=3, ge=0)], Field(description="Data flow stage.")] = None, data_flow_convert : Annotated[Optional[FlowConvert], Field(description="Data result convert.")] = None, **kwargs) -> bytearray:  # noqa: E501
        """Reading input data  # noqa: E501

        Receiving an incoming request by `tracecode`.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.read_data(tracecode, data_flow_type, data_flow_stage, data_flow_convert, async_req=True)
        >>> result = thread.get()

        :param tracecode: Unique process identifier. (required)
        :type tracecode: str
        :param data_flow_type: Data flow type.
        :type data_flow_type: FlowType
        :param data_flow_stage: Data flow stage.
        :type data_flow_stage: int
        :param data_flow_convert: Data result convert.
        :type data_flow_convert: FlowConvert
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: bytearray
        """
        kwargs['_return_http_data_only'] = True
        return self.read_data_with_http_info(tracecode, data_flow_type, data_flow_stage, data_flow_convert, **kwargs)  # noqa: E501

    @validate_arguments
    def read_data_with_http_info(self, tracecode : Annotated[StrictStr, Field(..., description="Unique process identifier.")], data_flow_type : Annotated[Optional[FlowType], Field(description="Data flow type.")] = None, data_flow_stage : Annotated[Optional[conint(strict=True, le=3, ge=0)], Field(description="Data flow stage.")] = None, data_flow_convert : Annotated[Optional[FlowConvert], Field(description="Data result convert.")] = None, **kwargs):  # noqa: E501
        """Reading input data  # noqa: E501

        Receiving an incoming request by `tracecode`.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.read_data_with_http_info(tracecode, data_flow_type, data_flow_stage, data_flow_convert, async_req=True)
        >>> result = thread.get()

        :param tracecode: Unique process identifier. (required)
        :type tracecode: str
        :param data_flow_type: Data flow type.
        :type data_flow_type: FlowType
        :param data_flow_stage: Data flow stage.
        :type data_flow_stage: int
        :param data_flow_convert: Data result convert.
        :type data_flow_convert: FlowConvert
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(bytearray, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'tracecode',
            'data_flow_type',
            'data_flow_stage',
            'data_flow_convert'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method read_data" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['tracecode']:
            _path_params['tracecode'] = _params['tracecode']


        # process the query parameters
        _query_params = []
        if _params.get('data_flow_type') is not None:  # noqa: E501
            _query_params.append(('data_flow_type', _params['data_flow_type']))

        if _params.get('data_flow_stage') is not None:  # noqa: E501
            _query_params.append(('data_flow_stage', _params['data_flow_stage']))

        if _params.get('data_flow_convert') is not None:  # noqa: E501
            _query_params.append(('data_flow_convert', _params['data_flow_convert']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/octet-stream', 'application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ApiKeyAuth']  # noqa: E501

        _response_types_map = {
            '200': "bytearray",
            '400': "General400",
            '401': "General401",
            '402': "General402",
            '403': "General403",
            '404': "General404",
            '405': None,
            '406': None,
            '415': None,
            '429': "General429",
            '500': "General500",
            '501': None,
            '502': None,
            '503': None,
            '504': None,
        }

        return self.api_client.call_api(
            '/account/data/{tracecode}', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))
