# coding: utf-8

"""
    VRt.Account [AC]

    The version of the OpenAPI document: 6.9.2071

    Generated by OpenAPI Generator: 6.6.0

    Do not edit the code manually

    2023 Veeroute
"""


from __future__ import annotations
from inspect import getfullargspec
import pprint
import re  # noqa: F401
import json


from typing import Optional
from pydantic import BaseModel, Field, conint, constr, validator

class AuditActionStatistics(BaseModel):
    """
    Detail user action statistics. 
    """
    points_count: Optional[conint(strict=True, le=10000000, ge=0)] = Field(0, description="Non-unique points per request.")
    duration: Optional[constr(strict=True, max_length=16, min_length=3)] = Field('PT0S', description="Time duration according to [ISO 8601 duration](https://en.wikipedia.org/wiki/ISO_8601#Durations). ")
    __properties = ["points_count", "duration"]

    @validator('duration')
    def duration_validate_regular_expression(cls, v):
        if not re.match(r"^P(?!$)((\d+Y)|(\d+\.\d+Y$))?((\d+M)|(\d+\.\d+M$))?((\d+W)|(\d+\.\d+W$))?((\d+D)|(\d+\.\d+D$))?(T(?=\d)((\d+H)|(\d+\.\d+H$))?((\d+M)|(\d+\.\d+M$))?(\d+(\.\d+)?S)?)??$", v):
            raise ValueError(r"must validate the regular expression /^P(?!$)((\d+Y)|(\d+\.\d+Y$))?((\d+M)|(\d+\.\d+M$))?((\d+W)|(\d+\.\d+W$))?((\d+D)|(\d+\.\d+D$))?(T(?=\d)((\d+H)|(\d+\.\d+H$))?((\d+M)|(\d+\.\d+M$))?(\d+(\.\d+)?S)?)??$/")
        return v

    class Config:
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> AuditActionStatistics:
        """Create an instance of AuditActionStatistics from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> AuditActionStatistics:
        """Create an instance of AuditActionStatistics from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return AuditActionStatistics.parse_obj(obj)

        _obj = AuditActionStatistics.parse_obj({
            "points_count": obj.get("points_count") if obj.get("points_count") is not None else 0,
            "duration": obj.get("duration") if obj.get("duration") is not None else 'PT0S'
        })
        return _obj

