# coding: utf-8

"""
    VRt.Account [AC]

    The version of the OpenAPI document: 6.9.2071

    Generated by OpenAPI Generator: 6.6.0

    Do not edit the code manually

    2023 Veeroute
"""


from __future__ import annotations
from inspect import getfullargspec
import pprint
import re  # noqa: F401
import json


from typing import Optional
from pydantic import BaseModel, Field, conint
from vrt_lss_account.models.method_group import MethodGroup

class MethodQuota(BaseModel):
    """
    Quota for the service method group.  If any of the quotas are exceeded, the request is not returned with the quota exceeded error. 
    """
    method_group: MethodGroup = Field(...)
    points_per_request: conint(strict=True, le=1000000, ge=0) = Field(..., description="Maximum number of non-unique points per request.")
    points_per_day: conint(strict=True, le=100000000, ge=0) = Field(..., description="Maximum number of non-unique points per request per day.")
    points_per_date_window: Optional[conint(strict=True, le=100000000, ge=0)] = Field(None, description="The maximum total number of non-unique points for the specified time period, multiple of a day. If the time period equals to a day, this parameter is not taken into account, since it is responsible for one day ")
    max_concurrent_execution: Optional[conint(strict=True, le=1000, ge=0)] = Field(None, description="The maximum total number of concurrent method execution. ")
    __properties = ["method_group", "points_per_request", "points_per_day", "points_per_date_window", "max_concurrent_execution"]

    class Config:
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> MethodQuota:
        """Create an instance of MethodQuota from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # set to None if points_per_date_window (nullable) is None
        # and __fields_set__ contains the field
        if self.points_per_date_window is None and "points_per_date_window" in self.__fields_set__:
            _dict['points_per_date_window'] = None

        # set to None if max_concurrent_execution (nullable) is None
        # and __fields_set__ contains the field
        if self.max_concurrent_execution is None and "max_concurrent_execution" in self.__fields_set__:
            _dict['max_concurrent_execution'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> MethodQuota:
        """Create an instance of MethodQuota from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return MethodQuota.parse_obj(obj)

        _obj = MethodQuota.parse_obj({
            "method_group": obj.get("method_group"),
            "points_per_request": obj.get("points_per_request"),
            "points_per_day": obj.get("points_per_day"),
            "points_per_date_window": obj.get("points_per_date_window"),
            "max_concurrent_execution": obj.get("max_concurrent_execution")
        })
        return _obj

