# coding: utf-8

"""
Fatture in Cloud API v2 - API Reference

Connect your software with Fatture in Cloud, the invoicing platform chosen by more than 500.000 businesses in Italy.   The Fatture in Cloud API is based on REST, and makes possible to interact with the user related data prior authorization via OAuth2 protocol.

The version of the OpenAPI document: 2.1.5
Contact: info@fattureincloud.it
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from fattureincloud_python_sdk.models.payment_account import PaymentAccount
from fattureincloud_python_sdk.models.payment_method import PaymentMethod
from fattureincloud_python_sdk.models.price_list import PriceList
from fattureincloud_python_sdk.models.vat_type import VatType
from typing import Optional, Set
from typing_extensions import Self


class EntityClientPreCreateInfo(BaseModel):
    """
    EntityClientPreCreateInfo
    """  # noqa: E501

    countries_list: Optional[List[StrictStr]] = Field(
        default=None, description="Countries list"
    )
    payment_methods_list: Optional[List[PaymentMethod]] = Field(
        default=None, description="Entity payment methods list"
    )
    payment_accounts_list: Optional[List[Optional[PaymentAccount]]] = Field(
        default=None, description="Entity payment accounts list"
    )
    vat_types_list: Optional[List[Optional[VatType]]] = Field(
        default=None, description="Vat types list"
    )
    price_lists: Optional[List[PriceList]] = Field(
        default=None, description="Entity price lists"
    )
    limit: Optional[Union[StrictFloat, StrictInt]] = Field(
        default=None, description="Entity limit"
    )
    usage: Optional[Union[StrictFloat, StrictInt]] = Field(
        default=None, description="Entity usage"
    )
    __properties: ClassVar[List[str]] = [
        "countries_list",
        "payment_methods_list",
        "payment_accounts_list",
        "vat_types_list",
        "price_lists",
        "limit",
        "usage",
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of EntityClientPreCreateInfo from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in payment_methods_list (list)
        _items = []
        if self.payment_methods_list:
            for _item_payment_methods_list in self.payment_methods_list:
                if _item_payment_methods_list:
                    _items.append(_item_payment_methods_list.to_dict())
            _dict["payment_methods_list"] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in payment_accounts_list (list)
        _items = []
        if self.payment_accounts_list:
            for _item_payment_accounts_list in self.payment_accounts_list:
                if _item_payment_accounts_list:
                    _items.append(_item_payment_accounts_list.to_dict())
            _dict["payment_accounts_list"] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in vat_types_list (list)
        _items = []
        if self.vat_types_list:
            for _item_vat_types_list in self.vat_types_list:
                if _item_vat_types_list:
                    _items.append(_item_vat_types_list.to_dict())
            _dict["vat_types_list"] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in price_lists (list)
        _items = []
        if self.price_lists:
            for _item_price_lists in self.price_lists:
                if _item_price_lists:
                    _items.append(_item_price_lists.to_dict())
            _dict["price_lists"] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of EntityClientPreCreateInfo from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate(
            {
                "countries_list": obj.get("countries_list"),
                "payment_methods_list": (
                    [
                        PaymentMethod.from_dict(_item)
                        for _item in obj["payment_methods_list"]
                    ]
                    if obj.get("payment_methods_list") is not None
                    else None
                ),
                "payment_accounts_list": (
                    [
                        PaymentAccount.from_dict(_item)
                        for _item in obj["payment_accounts_list"]
                    ]
                    if obj.get("payment_accounts_list") is not None
                    else None
                ),
                "vat_types_list": (
                    [VatType.from_dict(_item) for _item in obj["vat_types_list"]]
                    if obj.get("vat_types_list") is not None
                    else None
                ),
                "price_lists": (
                    [PriceList.from_dict(_item) for _item in obj["price_lists"]]
                    if obj.get("price_lists") is not None
                    else None
                ),
                "limit": obj.get("limit"),
                "usage": obj.get("usage"),
            }
        )
        return _obj
