# coding: utf-8

"""
Fatture in Cloud API v2 - API Reference

Connect your software with Fatture in Cloud, the invoicing platform chosen by more than 500.000 businesses in Italy.   The Fatture in Cloud API is based on REST, and makes possible to interact with the user related data prior authorization via OAuth2 protocol.

The version of the OpenAPI document: 2.1.5
Contact: info@fattureincloud.it
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from fattureincloud_python_sdk.models.price_list_prices_type import PriceListPricesType
from fattureincloud_python_sdk.models.price_list_type import PriceListType
from typing import Optional, Set
from typing_extensions import Self


class PriceList(BaseModel):
    """
    PriceList
    """  # noqa: E501

    id: Optional[StrictStr] = Field(default=None, description="Price list id")
    name: Optional[StrictStr] = Field(default=None, description="Price list name")
    prices_type: Optional[PriceListPricesType] = None
    is_default: Optional[StrictBool] = Field(
        default=None, description="This entity is default"
    )
    valid_from: Optional[StrictStr] = Field(
        default=None, description="Price list validity start date"
    )
    valid_to: Optional[StrictStr] = Field(
        default=None, description="Price list validity end date"
    )
    type: Optional[PriceListType] = None
    __properties: ClassVar[List[str]] = [
        "id",
        "name",
        "prices_type",
        "is_default",
        "valid_from",
        "valid_to",
        "type",
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of PriceList from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of PriceList from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate(
            {
                "id": obj.get("id"),
                "name": obj.get("name"),
                "prices_type": obj.get("prices_type"),
                "is_default": obj.get("is_default"),
                "valid_from": obj.get("valid_from"),
                "valid_to": obj.get("valid_to"),
                "type": obj.get("type"),
            }
        )
        return _obj
