# coding: utf-8

"""
Fatture in Cloud API v2 - API Reference

Connect your software with Fatture in Cloud, the invoicing platform chosen by more than 500.000 businesses in Italy.   The Fatture in Cloud API is based on REST, and makes possible to interact with the user related data prior authorization via OAuth2 protocol.

The version of the OpenAPI document: 2.1.5
Contact: info@fattureincloud.it
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import (
    BaseModel,
    ConfigDict,
    Field,
    StrictBool,
    StrictFloat,
    StrictInt,
    StrictStr,
)
from typing import Any, ClassVar, Dict, List, Optional, Union
from typing import Optional, Set
from typing_extensions import Self


class VatType(BaseModel):
    """
    VatType
    """  # noqa: E501

    id: Optional[StrictInt] = Field(default=None, description="Vat type id")
    value: Optional[Union[StrictFloat, StrictInt]] = Field(
        default=None, description="[Read Only] Vat type percentual value"
    )
    description: Optional[StrictStr] = Field(
        default=None, description="Vat type short description"
    )
    notes: Optional[StrictStr] = Field(
        default=None, description="Vat type notes shown in documents"
    )
    e_invoice: Optional[StrictBool] = Field(
        default=None, description="Vat type is usable for e-invoices"
    )
    ei_type: Optional[StrictStr] = Field(
        default=None, description="Vat type e-invoice type (natura)"
    )
    ei_description: Optional[StrictStr] = Field(
        default=None, description="Vat type e-invoice description"
    )
    editable: Optional[StrictBool] = Field(
        default=None, description="[Read Only] Is the vat type is editable."
    )
    is_disabled: Optional[StrictBool] = Field(
        default=None, description="Is the vat type disabled"
    )
    default: Optional[StrictBool] = Field(
        default=None, description="If the vat type is default"
    )
    __properties: ClassVar[List[str]] = [
        "id",
        "value",
        "description",
        "notes",
        "e_invoice",
        "ei_type",
        "ei_description",
        "editable",
        "is_disabled",
        "default",
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of VatType from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * OpenAPI `readOnly` fields are excluded.
        """
        excluded_fields: Set[str] = set(
            [
                "editable",
            ]
        )

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of VatType from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate(
            {
                "id": obj.get("id"),
                "value": obj.get("value"),
                "description": obj.get("description"),
                "notes": obj.get("notes"),
                "e_invoice": obj.get("e_invoice"),
                "ei_type": obj.get("ei_type"),
                "ei_description": obj.get("ei_description"),
                "editable": obj.get("editable"),
                "is_disabled": obj.get("is_disabled"),
                "default": obj.get("default"),
            }
        )
        return _obj
