import cdk = require('@aws-cdk/core');
/**
 * The Deployment Configuration of a Lambda Deployment Group.
 * The default, pre-defined Configurations are available as constants on the {@link LambdaDeploymentConfig} class
 * (`LambdaDeploymentConfig.AllAtOnce`, `LambdaDeploymentConfig.Canary10Percent30Minutes`, etc.).
 *
 * Note: CloudFormation does not currently support creating custom lambda configs outside
 * of using a custom resource. You can import custom deployment config created outside the
 * CDK or via a custom resource with {@link LambdaDeploymentConfig#import}.
 */
export interface ILambdaDeploymentConfig {
    readonly deploymentConfigName: string;
    readonly deploymentConfigArn: string;
}
/**
 * Properties of a reference to a CodeDeploy Lambda Deployment Configuration.
 *
 * @see LambdaDeploymentConfig#import
 * @see LambdaDeploymentConfig#export
 */
export interface LambdaDeploymentConfigImportProps {
    /**
     * The physical, human-readable name of the custom CodeDeploy Lambda Deployment Configuration
     * that we are referencing.
     */
    readonly deploymentConfigName: string;
}
/**
 * A custom Deployment Configuration for a Lambda Deployment Group.
 *
 * Note: This class currently stands as namespaced container of the default configurations
 * until CloudFormation supports custom Lambda Deployment Configs. Until then it is closed
 * (private constructor) and does not extend {@link cdk.Construct}
 *
 * @resource AWS::CodeDeploy::DeploymentConfig
 */
export declare class LambdaDeploymentConfig {
    static readonly ALL_AT_ONCE: ILambdaDeploymentConfig;
    static readonly CANARY_10PERCENT_30MINUTES: ILambdaDeploymentConfig;
    static readonly CANARY_10PERCENT_5MINUTES: ILambdaDeploymentConfig;
    static readonly CANARY_10PERCENT_10MINUTES: ILambdaDeploymentConfig;
    static readonly CANARY_10PERCENT_15MINUTES: ILambdaDeploymentConfig;
    static readonly LINEAR_10PERCENT_EVERY_10MINUTES: ILambdaDeploymentConfig;
    static readonly LINEAR_10PERCENT_EVERY_1MINUTE: ILambdaDeploymentConfig;
    static readonly LINEAR_10PERCENT_EVERY_2MINUTES: ILambdaDeploymentConfig;
    static readonly LINEAR_10PERCENT_EVERY_3MINUTES: ILambdaDeploymentConfig;
    /**
     * Import a custom Deployment Configuration for a Lambda Deployment Group defined outside the CDK.
     *
     * @param _scope the parent Construct for this new Construct
     * @param _id the logical ID of this new Construct
     * @param props the properties of the referenced custom Deployment Configuration
     * @returns a Construct representing a reference to an existing custom Deployment Configuration
     */
    static import(_scope: cdk.Construct, _id: string, props: LambdaDeploymentConfigImportProps): ILambdaDeploymentConfig;
    private constructor();
}
