define(["@jupyter-widgets/base"], function(__WEBPACK_EXTERNAL_MODULE_4__) { return /******/ (function(modules) { // webpackBootstrap
/******/ 	// The module cache
/******/ 	var installedModules = {};
/******/
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/
/******/ 		// Check if module is in cache
/******/ 		if(installedModules[moduleId]) {
/******/ 			return installedModules[moduleId].exports;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = installedModules[moduleId] = {
/******/ 			i: moduleId,
/******/ 			l: false,
/******/ 			exports: {}
/******/ 		};
/******/
/******/ 		// Execute the module function
/******/ 		modules[moduleId].call(module.exports, module, module.exports, __webpack_require__);
/******/
/******/ 		// Flag the module as loaded
/******/ 		module.l = true;
/******/
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/
/******/
/******/ 	// expose the modules object (__webpack_modules__)
/******/ 	__webpack_require__.m = modules;
/******/
/******/ 	// expose the module cache
/******/ 	__webpack_require__.c = installedModules;
/******/
/******/ 	// define getter function for harmony exports
/******/ 	__webpack_require__.d = function(exports, name, getter) {
/******/ 		if(!__webpack_require__.o(exports, name)) {
/******/ 			Object.defineProperty(exports, name, {
/******/ 				configurable: false,
/******/ 				enumerable: true,
/******/ 				get: getter
/******/ 			});
/******/ 		}
/******/ 	};
/******/
/******/ 	// getDefaultExport function for compatibility with non-harmony modules
/******/ 	__webpack_require__.n = function(module) {
/******/ 		var getter = module && module.__esModule ?
/******/ 			function getDefault() { return module['default']; } :
/******/ 			function getModuleExports() { return module; };
/******/ 		__webpack_require__.d(getter, 'a', getter);
/******/ 		return getter;
/******/ 	};
/******/
/******/ 	// Object.prototype.hasOwnProperty.call
/******/ 	__webpack_require__.o = function(object, property) { return Object.prototype.hasOwnProperty.call(object, property); };
/******/
/******/ 	// __webpack_public_path__
/******/ 	__webpack_require__.p = "";
/******/
/******/ 	// Load entry module and return exports
/******/ 	return __webpack_require__(__webpack_require__.s = 2);
/******/ })
/************************************************************************/
/******/ ([
/* 0 */
/***/ (function(module, exports) {

var g;

// This works in non-strict mode
g = (function() {
	return this;
})();

try {
	// This works if eval is allowed (see CSP)
	g = g || Function("return this")() || (1,eval)("this");
} catch(e) {
	// This works if the window reference is available
	if(typeof window === "object")
		g = window;
}

// g can still be undefined, but nothing to do about it...
// We return undefined, instead of nothing here, so it's
// easier to handle this case. if(!global) { ...}

module.exports = g;


/***/ }),
/* 1 */
/***/ (function(module, exports) {

module.exports = {"name":"plotlywidget","version":"4.8.1","description":"The plotly JupyterLab extension","author":"The plotly.py team","license":"MIT","main":"src/index.js","repository":{"type":"git","url":"https://github.com/plotly/plotly.py"},"keywords":["jupyter","widgets","ipython","ipywidgets","plotly"],"files":["src/**/*.js","dist/*.js","style/*.*"],"scripts":{"build":"webpack","clean":"rimraf dist/ && rimraf  ../../python/plotly/plotlywidget/static'","test":"echo \"Error: no test specified\" && exit 1"},"devDependencies":{"webpack":"^3.10.0","rimraf":"^2.6.1","ify-loader":"^1.1.0","typescript":"~3.1.1"},"dependencies":{"plotly.js":"^1.54.1","@jupyter-widgets/base":"^2.0.0 || ^3.0.0","lodash":"^4.17.4"},"jupyterlab":{"extension":"src/jupyterlab-plugin.js"}}

/***/ }),
/* 2 */
/***/ (function(module, exports, __webpack_require__) {

// Export widget models and views, and the npm package version number.
module.exports = __webpack_require__(3);
module.exports['version'] = __webpack_require__(1).version;


/***/ }),
/* 3 */
/***/ (function(module, exports, __webpack_require__) {

var widgets = __webpack_require__(4);
var _ = __webpack_require__(5);

window.PlotlyConfig = {MathJaxConfig: 'local'};
var Plotly = __webpack_require__(7);
var semver_range = "^" + __webpack_require__(1).version;

// Model
// =====
/**
 * A FigureModel holds a mirror copy of the state of a FigureWidget on
 * the Python side.  There is a one-to-one relationship between JavaScript
 * FigureModels and Python FigureWidgets. The JavaScript FigureModel is
 * initialized as soon as a Python FigureWidget initialized, this happens
 * even before the widget is first displayed in the Notebook
 * @type {widgets.DOMWidgetModel}
 */
var FigureModel = widgets.DOMWidgetModel.extend({

    defaults: _.extend(widgets.DOMWidgetModel.prototype.defaults(), {
        // Model metadata
        // --------------
        _model_name: "FigureModel",
        _view_name: "FigureView",
        _model_module: "plotlywidget",
        _view_module: "plotlywidget",
        _view_module_version: semver_range,
        _model_module_version: semver_range,

        // Data and Layout
        // ---------------
        // The _data and _layout properties are synchronized with the
        // Python side on initialization only.  After initialization, these
        // properties are kept in sync through the use of the _py2js_*
        // messages
        _data: [],
        _layout: {},
        _config: {},

        // Python -> JS messages
        // ---------------------
        // Messages are implemented using trait properties. This is done so
        // that we can take advantage of ipywidget's binary serialization
        // protocol.
        //
        // Messages are sent by the Python side by assigning the message
        // contents to the appropriate _py2js_* property, and then immediately
        // setting it to None.  Messages are received by the JavaScript
        // side by registering property change callbacks in the initialize
        // methods for FigureModel and FigureView. e.g. (where this is a
        // FigureModel):
        //
        //      this.on('change:_py2js_addTraces', this.do_addTraces, this);
        //
        // Message handling methods, do_addTraces, are responsible for
        // performing the appropriate action if the message contents are
        // not null

        /**
         * @typedef {null|Object} Py2JsAddTracesMsg
         * @property {Array.<Object>} trace_data
         *  Array of traces to append to the end of the figure's current traces
         * @property {Number} trace_edit_id
         *  Edit ID to use when returning trace deltas using
         *  the _js2py_traceDeltas message.
         * @property {Number} layout_edit_id
         *  Edit ID to use when returning layout deltas using
         *  the _js2py_layoutDelta message.
         */
        _py2js_addTraces: null,

        /**
         * @typedef {null|Object} Py2JsDeleteTracesMsg
         * @property {Array.<Number>} delete_inds
         *  Array of indexes of traces to be deleted, in ascending order
         * @property {Number} trace_edit_id
         *  Edit ID to use when returning trace deltas using
         *  the _js2py_traceDeltas message.
         * @property {Number} layout_edit_id
         *  Edit ID to use when returning layout deltas using
         *  the _js2py_layoutDelta message.
         */
        _py2js_deleteTraces: null,

        /**
         * @typedef {null|Object} Py2JsMoveTracesMsg
         * @property {Array.<Number>} current_trace_inds
         *  Array of the current indexes of traces to be moved
         * @property {Array.<Number>} new_trace_inds
         *  Array of the new indexes that traces should be moved to.
         */
        _py2js_moveTraces: null,


        /**
         * @typedef {null|Object} Py2JsRestyleMsg
         * @property {Object} restyle_data
         *  Restyle data as accepted by Plotly.restyle
         * @property {null|Array.<Number>} restyle_traces
         *  Array of indexes of the traces that the resytle operation applies
         *  to, or null to apply the operation to all traces
         * @property {Number} trace_edit_id
         *  Edit ID to use when returning trace deltas using
         *  the _js2py_traceDeltas message
         * @property {Number} layout_edit_id
         *  Edit ID to use when returning layout deltas using
         *  the _js2py_layoutDelta message
         * @property {null|String} source_view_id
         *  view_id of the FigureView that triggered the original restyle
         *  event (e.g. by clicking the legend), or null if the restyle was
         *  triggered from Python
         */
        _py2js_restyle: null,

        /**
         * @typedef {null|Object} Py2JsRelayoutMsg
         * @property {Object} relayout_data
         *  Relayout data as accepted by Plotly.relayout
         * @property {Number} layout_edit_id
         *  Edit ID to use when returning layout deltas using
         *  the _js2py_layoutDelta message
         * @property {null|String} source_view_id
         *  view_id of the FigureView that triggered the original relayout
         *  event (e.g. by clicking the zoom button), or null if the
         *  relayout was triggered from Python
         */
        _py2js_relayout: null,

        /**
         * @typedef {null|Object} Py2JsUpdateMsg
         * @property {Object} style_data
         *  Style data as accepted by Plotly.update
         * @property {Object} layout_data
         *  Layout data as accepted by Plotly.update
         * @property {Array.<Number>} style_traces
         *  Array of indexes of the traces that the update operation applies
         *  to, or null to apply the operation to all traces
         * @property {Number} trace_edit_id
         *  Edit ID to use when returning trace deltas using
         *  the _js2py_traceDeltas message
         * @property {Number} layout_edit_id
         *  Edit ID to use when returning layout deltas using
         *  the _js2py_layoutDelta message
         * @property {null|String} source_view_id
         *  view_id of the FigureView that triggered the original update
         *  event (e.g. by clicking a button), or null if the update was
         *  triggered from Python
         */
        _py2js_update: null,

        /**
         * @typedef {null|Object} Py2JsAnimateMsg
         * @property {Object} style_data
         *  Style data as accepted by Plotly.animate
         * @property {Object} layout_data
         *  Layout data as accepted by Plotly.animate
         * @property {Array.<Number>} style_traces
         *  Array of indexes of the traces that the animate operation applies
         *  to, or null to apply the operation to all traces
         * @property {Object} animation_opts
         *  Animation options as accepted by Plotly.animate
         * @property {Number} trace_edit_id
         *  Edit ID to use when returning trace deltas using
         *  the _js2py_traceDeltas message
         * @property {Number} layout_edit_id
         *  Edit ID to use when returning layout deltas using
         *  the _js2py_layoutDelta message
         * @property {null|String} source_view_id
         *  view_id of the FigureView that triggered the original animate
         *  event (e.g. by clicking a button), or null if the update was
         *  triggered from Python
         */
        _py2js_animate: null,

        /**
         * @typedef {null|Object} Py2JsRemoveLayoutPropsMsg
         * @property {Array.<Array.<String|Number>>} remove_props
         *  Array of property paths to remove. Each propery path is an
         *  array of property names or array indexes that locate a property
         *  inside the _layout object
         */
        _py2js_removeLayoutProps: null,

        /**
         * @typedef {null|Object} Py2JsRemoveTracePropsMsg
         * @property {Number} remove_trace
         *  The index of the trace from which to remove properties
         * @property {Array.<Array.<String|Number>>} remove_props
         *  Array of property paths to remove. Each propery path is an
         *  array of property names or array indexes that locate a property
         *  inside the _data[remove_trace] object
         */
        _py2js_removeTraceProps: null,


        // JS -> Python messages
        // ---------------------
        // Messages are sent by the JavaScript side by assigning the
        // message contents to the appropriate _js2py_* property and then
        // calling the `touch` method on the view that triggered the
        // change. e.g. (where this is a FigureView):
        //
        //      this.model.set('_js2py_restyle', data);
        //      this.touch();
        //
        // The Python side is responsible for setting the property to None
        // after receiving the message.
        //
        // Message trigger logic is described in the corresponding
        // handle_plotly_* methods of FigureView

        /**
         * @typedef {null|Object} Js2PyRestyleMsg
         * @property {Object} style_data
         *  Style data that was passed to Plotly.restyle
         * @property {Array.<Number>} style_traces
         *  Array of indexes of the traces that the restyle operation
         *  was applied to, or null if applied to all traces
         * @property {String} source_view_id
         *  view_id of the FigureView that triggered the original restyle
         *  event (e.g. by clicking the legend)
         */
        _js2py_restyle: null,

        /**
         * @typedef {null|Object} Js2PyRelayoutMsg
         * @property {Object} relayout_data
         *  Relayout data that was passed to Plotly.relayout
         * @property {String} source_view_id
         *  view_id of the FigureView that triggered the original relayout
         *  event (e.g. by clicking the zoom button)
         */
        _js2py_relayout: null,

        /**
         * @typedef {null|Object} Js2PyUpdateMsg
         * @property {Object} style_data
         *  Style data that was passed to Plotly.update
         * @property {Object} layout_data
         *  Layout data that was passed to Plotly.update
         * @property {Array.<Number>} style_traces
         *  Array of indexes of the traces that the update operation applied
         *  to, or null if applied to all traces
         * @property {String} source_view_id
         *  view_id of the FigureView that triggered the original relayout
         *  event (e.g. by clicking the zoom button)
         */
        _js2py_update: null,

        /**
         * @typedef {null|Object} Js2PyLayoutDeltaMsg
         * @property {Object} layout_delta
         *  The layout delta object that contains all of the properties of
         *  _fullLayout that are not identical to those in the
         *  FigureModel's _layout property
         * @property {Number} layout_edit_id
         *  Edit ID of message that triggered the creation of layout delta
         */
        _js2py_layoutDelta: null,

        /**
         * @typedef {null|Object} Js2PyTraceDeltasMsg
         * @property {Array.<Object>} trace_deltas
         *  Array of trace delta objects. Each trace delta contains the
         *  trace's uid along with all of the properties of _fullData that
         *  are not identical to those in the FigureModel's _data property
         * @property {Number} trace_edit_id
         *  Edit ID of message that triggered the creation of trace deltas
         */
        _js2py_traceDeltas: null,


        /**
         * Object representing a collection of points for use in click, hover,
         * and selection events
         * @typedef {Object} Points
         * @property {Array.<Number>} trace_indexes
         *  Array of the trace index for each point
         * @property {Array.<Number>} point_indexes
         *  Array of the index of each point in its own trace
         * @property {null|Array.<Number>} xs
         *  Array of the x coordinate of each point (for cartesian trace types)
         *  or null (for non-cartesian trace types)
         * @property {null|Array.<Number>} ys
         *  Array of the y coordinate of each point (for cartesian trace types)
         *  or null (for non-cartesian trace types
         * @property {null|Array.<Number>} zs
         *  Array of the z coordinate of each point (for 3D cartesian
         *  trace types)
         *  or null (for non-3D-cartesian trace types)
         */

        /**
         * Object representing the state of the input devices during a
         * plotly event
         * @typedef {Object} InputDeviceState
         * @property {boolean} alt - true if alt key pressed,
         * false otherwise
         * @property {boolean} ctrl - true if ctrl key pressed,
         * false otherwise
         * @property {boolean} meta - true if meta key pressed,
         * false otherwise
         * @property {boolean} shift - true if shift key pressed,
         * false otherwise
         *
         * @property {boolean} button
         *  Indicates which button was pressed on the mouse to trigger the
         *  event.
         *    0: Main button pressed, usually the left button or the
         *       un-initialized state
         *    1: Auxiliary button pressed, usually the wheel button or
         *       the middle button (if present)
         *    2: Secondary button pressed, usually the right button
         *    3: Fourth button, typically the Browser Back button
         *    4: Fifth button, typically the Browser Forward button
         *
         * @property {boolean} buttons
         *  Indicates which buttons were pressed on the mouse when the event
         *  is triggered.
         *    0  : No button or un-initialized
         *    1  : Primary button (usually left)
         *    2  : Secondary button (usually right)
         *    4  : Auxilary button (usually middle or mouse wheel button)
         *    8  : 4th button (typically the "Browser Back" button)
         *    16 : 5th button (typically the "Browser Forward" button)
         *
         *  Combinations of buttons are represented by the sum of the codes
         *  above. e.g. a value of 7 indicates buttons 1 (primary),
         *  2 (secondary), and 4 (auxilary) were pressed during the event
         */

        /**
         * @typedef {Object} BoxSelectorState
         * @property {Array.<Number>} xrange
         *  Two element array containing the x-range of the box selection
         * @property {Array.<Number>} yrange
         *  Two element array containing the y-range of the box selection
         */

        /**
         * @typedef {Object} LassoSelectorState
         * @property {Array.<Number>} xs
         *  Array of the x-coordinates of the lasso selection region
         * @property {Array.<Number>} ys
         *  Array of the y-coordinates of the lasso selection region
         */

        /**
         * Object representing the state of the selection tool during a
         * plotly_select event
         * @typedef {Object} Selector
         * @property {String} type
         *  Selection type. One of: 'box', or 'lasso'
         * @property {BoxSelectorState|LassoSelectorState} selector_state
         */

        /**
         * @typedef {null|Object} Js2PyPointsCallbackMsg
         * @property {string} event_type
         *  Name of the triggering event. One of 'plotly_click',
         *  'plotly_hover', 'plotly_unhover', or 'plotly_selected'
         * @property {null|Points} points
         *  Points object for event
         * @property {null|InputDeviceState} device_state
         *  InputDeviceState object for event
         * @property {null|Selector} selector
         *  State of the selection tool for 'plotly_selected' events, null
         *  for other event types
         */
        _js2py_pointsCallback: null,

        // Message tracking
        // ----------------
        /**
         * @type {Number}
         * layout_edit_id of the last layout modification operation
         * requested by the Python side
         */
        _last_layout_edit_id: 0,

        /**
         * @type {Number}
         * trace_edit_id of the last trace modification operation
         * requested by the Python side
         */
        _last_trace_edit_id: 0
    }),

    /**
     * Initialize FigureModel. Called when the Python FigureWidget is first
     * constructed
     */
    initialize: function() {
        FigureModel.__super__.initialize.apply(this, arguments);

        this.on("change:_data", this.do_data, this);
        this.on("change:_layout", this.do_layout, this);
        this.on("change:_py2js_addTraces", this.do_addTraces, this);
        this.on("change:_py2js_deleteTraces", this.do_deleteTraces, this);
        this.on("change:_py2js_moveTraces", this.do_moveTraces, this);
        this.on("change:_py2js_restyle", this.do_restyle, this);
        this.on("change:_py2js_relayout", this.do_relayout, this);
        this.on("change:_py2js_update", this.do_update, this);
        this.on("change:_py2js_animate", this.do_animate, this);
        this.on("change:_py2js_removeLayoutProps",
            this.do_removeLayoutProps, this);
        this.on("change:_py2js_removeTraceProps",
            this.do_removeTraceProps, this);
    },

    /**
     * Input a trace index specification and return an Array of trace
     * indexes where:
     *
     *  - null|undefined -> Array of all traces
     *  - Trace index as Number -> Single element array of input index
     *  - Array of trace indexes -> Input array unchanged
     *
     * @param {undefined|null|Number|Array.<Number>} trace_indexes
     * @returns {Array.<Number>}
     *  Array of trace indexes
     * @private
     */
    _normalize_trace_indexes: function (trace_indexes) {
        if (trace_indexes === null || trace_indexes === undefined) {
            var numTraces = this.get("_data").length;
            trace_indexes = _.range(numTraces);
        }
        if (!Array.isArray(trace_indexes)) {
            // Make sure idx is an array
            trace_indexes = [trace_indexes];
        }
        return trace_indexes
    },

    /**
     * Log changes to the _data trait
     *
     * This should only happed on FigureModel initialization
     */
    do_data: function () {

    },

    /**
     * Log changes to the _layout trait
     *
     * This should only happed on FigureModel initialization
     */
    do_layout: function () {

    },

    /**
     * Handle addTraces message
     */
    do_addTraces: function () {
        // add trace to plot
        /** @type {Py2JsAddTracesMsg} */
        var msgData = this.get("_py2js_addTraces");

        if (msgData !== null) {
            var currentTraces = this.get("_data");
            var newTraces = msgData.trace_data;
            _.forEach(newTraces, function (newTrace) {
                currentTraces.push(newTrace);
            })
        }
    },

    /**
     * Handle deleteTraces message
     */
    do_deleteTraces: function () {
        // remove traces from plot

        /** @type {Py2JsDeleteTracesMsg} */
        var msgData = this.get("_py2js_deleteTraces");

        if (msgData !== null) {
            var delete_inds = msgData.delete_inds;
            var tracesData = this.get("_data");

            // Remove del inds in reverse order so indexes remain valid
            // throughout loop
            delete_inds.slice().reverse().forEach(function (del_ind) {
                tracesData.splice(del_ind, 1);
            });
        }
    },

    /**
     * Handle moveTraces message
     */
    do_moveTraces: function () {

        /** @type {Py2JsMoveTracesMsg} */
        var msgData = this.get("_py2js_moveTraces");

        if (msgData !== null) {
            var tracesData = this.get("_data");
            var currentInds = msgData.current_trace_inds;
            var newInds = msgData.new_trace_inds;

            performMoveTracesLike(tracesData, currentInds, newInds);
        }
    },

    /**
     * Handle restyle message
     */
    do_restyle: function () {

        /** @type {Py2JsRestyleMsg} */
        var msgData = this.get("_py2js_restyle");
        if (msgData !== null) {
            var restyleData = msgData.restyle_data;
            var restyleTraces = this._normalize_trace_indexes(
                msgData.restyle_traces);
            performRestyleLike(this.get("_data"), restyleData, restyleTraces);
        }
    },

    /**
     * Handle relayout message
     */
    do_relayout: function () {

        /** @type {Py2JsRelayoutMsg} */
        var msgData = this.get("_py2js_relayout");

        if (msgData !== null) {
            performRelayoutLike(this.get("_layout"), msgData.relayout_data);
        }
    },

    /**
     * Handle update message
     */
    do_update: function() {

        /** @type {Py2JsUpdateMsg} */
        var msgData = this.get("_py2js_update");

        if (msgData !== null) {
            var style = msgData.style_data;
            var layout = msgData.layout_data;
            var styleTraces = this._normalize_trace_indexes(
                msgData.style_traces);
            performRestyleLike(this.get("_data"), style, styleTraces);
            performRelayoutLike(this.get("_layout"), layout);
        }
    },

    /**
     * Handle animate message
     */
    do_animate: function () {

        /** @type {Py2JsAnimateMsg} */
        var msgData = this.get("_py2js_animate");
        if (msgData !== null) {

            var styles = msgData.style_data;
            var layout = msgData.layout_data;
            var trace_indexes = this._normalize_trace_indexes(
                msgData.style_traces);

            for (var i = 0; i < styles.length; i++) {
                var style = styles[i];
                var trace_index = trace_indexes[i];
                var trace = this.get("_data")[trace_index];
                performRelayoutLike(trace, style);
            }

            performRelayoutLike(this.get("_layout"), layout);
        }
    },

    /**
     * Handle removeLayoutProps message
     */
    do_removeLayoutProps: function () {
        /** @type {Py2JsRemoveLayoutPropsMsg} */
        var msgData = this.get("_py2js_removeLayoutProps");

        if (msgData !== null) {
            var keyPaths = msgData.remove_props;
            var layout = this.get("_layout");
            performRemoveProps(layout, keyPaths);
        }
    },

    /**
     * Handle removeTraceProps message
     */
    do_removeTraceProps: function () {
        /** @type {Py2JsRemoveTracePropsMsg} */
        var msgData = this.get("_py2js_removeTraceProps");
        if (msgData !== null) {
            var keyPaths = msgData.remove_props;
            var traceIndex = msgData.remove_trace;
            var trace = this.get("_data")[traceIndex];

            performRemoveProps(trace, keyPaths);
        }
    }
}, {
    serializers: _.extend({
        _data: { deserialize: py2js_deserializer,
            serialize: js2py_serializer},
        _layout: { deserialize: py2js_deserializer,
            serialize: js2py_serializer},
        _py2js_addTraces: { deserialize: py2js_deserializer,
            serialize: js2py_serializer},
        _py2js_deleteTraces: { deserialize: py2js_deserializer,
            serialize: js2py_serializer},
        _py2js_moveTraces: { deserialize: py2js_deserializer,
            serialize: js2py_serializer},
        _py2js_restyle: { deserialize: py2js_deserializer,
            serialize: js2py_serializer},
        _py2js_relayout: { deserialize: py2js_deserializer,
            serialize: js2py_serializer},
        _py2js_update: { deserialize: py2js_deserializer,
            serialize: js2py_serializer},
        _py2js_animate: { deserialize: py2js_deserializer,
            serialize: js2py_serializer},
        _py2js_removeLayoutProps: { deserialize: py2js_deserializer,
            serialize: js2py_serializer},
        _py2js_removeTraceProps: { deserialize: py2js_deserializer,
            serialize: js2py_serializer},
        _js2py_restyle: { deserialize: py2js_deserializer,
            serialize: js2py_serializer},
        _js2py_relayout: { deserialize: py2js_deserializer,
            serialize: js2py_serializer},
        _js2py_update: { deserialize: py2js_deserializer,
            serialize: js2py_serializer},
        _js2py_layoutDelta: { deserialize: py2js_deserializer,
            serialize: js2py_serializer},
        _js2py_traceDeltas: { deserialize: py2js_deserializer,
            serialize: js2py_serializer},
        _js2py_pointsCallback: { deserialize: py2js_deserializer,
            serialize: js2py_serializer}
    }, widgets.DOMWidgetModel.serializers)
});

// View
// ====
/**
 * A FigureView manages the visual presentation of a single Plotly.js
 * figure for a single notebook output cell. Each FigureView has a
 * reference to FigureModel.  Multiple views may share a single model
 * instance, as is the case when a Python FigureWidget is displayed in
 * multiple notebook output cells.
 *
 * @type {widgets.DOMWidgetView}
 */
var FigureView = widgets.DOMWidgetView.extend({

    /**
     * The perform_render method is called by processPhosphorMessage
     * after the widget's DOM element has been attached to the notebook
     * output cell. This happens after the initialize of the
     * FigureModel, and it won't happen at all if the Python FigureWidget
     * is never displayed in a notebook output cell
     */
    perform_render: function() {

        var that = this;

        // Wire up message property callbacks
        // ----------------------------------
        // Python -> JS event properties
        this.model.on("change:_py2js_addTraces",
            this.do_addTraces, this);
        this.model.on("change:_py2js_deleteTraces",
            this.do_deleteTraces, this);
        this.model.on("change:_py2js_moveTraces",
            this.do_moveTraces, this);
        this.model.on("change:_py2js_restyle",
            this.do_restyle, this);
        this.model.on("change:_py2js_relayout",
            this.do_relayout, this);
        this.model.on("change:_py2js_update",
            this.do_update, this);
        this.model.on("change:_py2js_animate",
            this.do_animate, this);

        // MathJax configuration
        // ---------------------
        if (window.MathJax) {
            MathJax.Hub.Config({SVG: {font: "STIX-Web"}});
        }

        // Get message ids
        // ---------------------
        var layout_edit_id = this.model.get("_last_layout_edit_id");
        var trace_edit_id = this.model.get("_last_trace_edit_id");

        // Set view UID
        // ------------
        this.viewID = randstr();

        // Initialize Plotly.js figure
        // ---------------------------
        // We must clone the model's data and layout properties so that
        // the model is not directly mutated by the Plotly.js library.
        var initialTraces = _.cloneDeep(this.model.get("_data"));
        var initialLayout = _.cloneDeep(this.model.get("_layout"));
        var config = this.model.get("_config");

        Plotly.newPlot(that.el, initialTraces, initialLayout, config).then(
            function () {

                // ### Send trace deltas ###
                // We create an array of deltas corresponding to the new
                // traces.
                that._sendTraceDeltas(trace_edit_id);

                // ### Send layout delta ###
                that._sendLayoutDelta(layout_edit_id);

                // Wire up plotly event callbacks
                that.el.on("plotly_restyle",
                    function (update) {
                        that.handle_plotly_restyle(update)
                    });
                that.el.on("plotly_relayout",
                    function (update) {
                        that.handle_plotly_relayout(update)
                    });
                that.el.on("plotly_update",
                    function (update) {
                        that.handle_plotly_update(update)
                    });
                that.el.on("plotly_click",
                    function (update) {
                        that.handle_plotly_click(update)
                    });
                that.el.on("plotly_hover",
                    function (update) {
                        that.handle_plotly_hover(update)
                    });
                that.el.on("plotly_unhover",
                    function (update) {
                        that.handle_plotly_unhover(update)
                    });
                that.el.on("plotly_selected",
                    function (update) {
                        that.handle_plotly_selected(update)
                    });
                that.el.on("plotly_deselect",
                    function (update) {
                        that.handle_plotly_deselect(update)
                    });
                that.el.on("plotly_doubleclick",
                    function (update) {
                        that.handle_plotly_doubleclick(update)
                    });

                // Emit event indicating that the widget has finished
                // rendering
                var event = new CustomEvent("plotlywidget-after-render",
                    { "detail": {"element": that.el, 'viewID': that.viewID}});

                // Dispatch/Trigger/Fire the event
                document.dispatchEvent(event);
            });
    },

    /**
     * Respond to phosphorjs events
     */
    processPhosphorMessage: function(msg) {
        FigureView.__super__.processPhosphorMessage.apply(this, arguments);
        var that = this;
        switch (msg.type) {
            case 'before-attach':
                // Render an initial empty figure. This establishes with
                // the page that the element will not be empty, avoiding
                // some occasions where the dynamic sizing behavior leads
                // to collapsed figure dimensions.
                var axisHidden = {
                    showgrid: false, showline: false, tickvals: []};

                Plotly.newPlot(that.el, [], {
                    xaxis: axisHidden, yaxis: axisHidden
                });

                window.addEventListener("resize", function(){
                    that.autosizeFigure();
                });
                break;
            case 'after-attach':
                // Rendering actual figure in the after-attach event allows
                // Plotly.js to size the figure to fill the available element
                this.perform_render();
                break;
            case 'resize':
                this.autosizeFigure();
                break
        }
    },

    autosizeFigure: function() {
        var that = this;
        var layout = that.model.get('_layout');
        if (_.isNil(layout) ||
            _.isNil(layout.width)) {
            Plotly.Plots.resize(that.el).then(function(){
                var layout_edit_id = that.model.get(
                    "_last_layout_edit_id");
                that._sendLayoutDelta(layout_edit_id);
            });
        }
    },

    /**
     * Purge Plotly.js data structures from the notebook output display
     * element when the view is destroyed
     */
    destroy: function() {
        Plotly.purge(this.el);
    },

    /**
     * Return the figure's _fullData array merged with its data array
     *
     * The merge ensures that for any properties that el._fullData and
     * el.data have in common, we return the version from el.data
     *
     * Named colorscales are one example of why this is needed. The el.data
     * array will hold named colorscale strings (e.g. 'Viridis'), while the
     * el._fullData array will hold the actual colorscale array. e.g.
     *
     *      el.data[0].marker.colorscale == 'Viridis' but
     *      el._fullData[0].marker.colorscale = [[..., ...], ...]
     *
     * Performing the merge allows our FigureModel to retain the 'Viridis'
     * string, rather than having it overridded by the colorscale array.
     *
     */
    getFullData: function () {
        return _.mergeWith({}, this.el._fullData, this.el.data,
            fullMergeCustomizer)
    },

    /**
     * Return the figure's _fullLayout object merged with its layout object
     *
     * See getFullData documentation for discussion of why the merge is
     * necessary
     */
    getFullLayout: function () {
        return _.mergeWith({}, this.el._fullLayout, this.el.layout,
            fullMergeCustomizer);
    },

    /**
     * Build Points data structure from data supplied by the plotly_click,
     * plotly_hover, or plotly_select events
     * @param {Object} data
     * @returns {null|Points}
     */
    buildPointsObject: function (data) {

        var pointsObject;
        if (data.hasOwnProperty("points")) {
            // Most cartesian plots
            var pointObjects = data["points"];
            var numPoints = pointObjects.length;
            pointsObject = {
                "trace_indexes": new Array(numPoints),
                "point_indexes": new Array(numPoints),
                "xs": new Array(numPoints),
                "ys": new Array(numPoints)};


                for (var p = 0; p < numPoints; p++) {
                pointsObject["trace_indexes"][p] =
                    pointObjects[p]["curveNumber"];
                pointsObject["point_indexes"][p] =
                    pointObjects[p]["pointNumber"];
                pointsObject["xs"][p] =
                    pointObjects[p]["x"];
                pointsObject["ys"][p] =
                    pointObjects[p]["y"];
            }

            // Add z if present
            var hasZ = pointObjects[0] !==
                undefined && pointObjects[0].hasOwnProperty("z");
            if (hasZ) {
                pointsObject["zs"] = new Array(numPoints);
                for (p = 0; p < numPoints; p++) {
                    pointsObject["zs"][p] = pointObjects[p]["z"];
                }
            }

            return pointsObject
        } else {
            return null
        }
    },

    /**
     * Build InputDeviceState data structure from data supplied by the
     * plotly_click, plotly_hover, or plotly_select events
     * @param {Object} data
     * @returns {null|InputDeviceState}
     */
    buildInputDeviceStateObject: function (data) {
        var event = data["event"];
        if (event === undefined) {
            return null;
        } else {
            /** @type {InputDeviceState} */
            var inputDeviceState = {
                // Keyboard modifiers
                "alt": event["altKey"],
                "ctrl": event["ctrlKey"],
                "meta": event["metaKey"],
                "shift": event["shiftKey"],

                // Mouse buttons
                "button": event["button"],
                "buttons": event["buttons"]
            };
            return inputDeviceState
        }
    },

    /**
     * Build Selector data structure from data supplied by the
     * plotly_select event
     * @param data
     * @returns {null|Selector}
     */
    buildSelectorObject: function(data) {

        var selectorObject;

        if (data.hasOwnProperty("range")) {
            // Box selection
            selectorObject = {
                type: "box",
                selector_state: {
                    xrange: data["range"]["x"],
                    yrange: data["range"]["y"]
                }
            };
        } else if (data.hasOwnProperty("lassoPoints")) {
            // Lasso selection
            selectorObject = {
                type: "lasso",
                selector_state: {
                    xs: data["lassoPoints"]["x"],
                    ys: data["lassoPoints"]["y"]
                }
            };
        } else {
            selectorObject = null;
        }
        return selectorObject
    },

    /**
     * Handle ploty_restyle events emitted by the Plotly.js library
     * @param data
     */
    handle_plotly_restyle: function (data) {

        if (data === null || data === undefined) {
            // No data to report to the Python side
            return
        }

        if (data[0] && data[0].hasOwnProperty("_doNotReportToPy")) {
            // Restyle originated on the Python side
            return
        }

        // Unpack data
        var styleData = data[0];
        var styleTraces = data[1];

        // Construct restyle message to send to the Python side
        /** @type {Js2PyRestyleMsg} */
        var restyleMsg = {
            style_data: styleData,
            style_traces: styleTraces,
            source_view_id: this.viewID
        };

        this.model.set("_js2py_restyle", restyleMsg);
        this.touch();
    },

    /**
     * Handle plotly_relayout events emitted by the Plotly.js library
     * @param data
     */
    handle_plotly_relayout: function (data) {

        if (data === null || data === undefined) {
            // No data to report to the Python side
            return
        }

        if (data.hasOwnProperty("_doNotReportToPy")) {
            // Relayout originated on the Python side
            return
        }

        /** @type {Js2PyRelayoutMsg} */
        var relayoutMsg = {
            relayout_data: data,
            source_view_id: this.viewID
        };

        this.model.set("_js2py_relayout", relayoutMsg);
        this.touch();
    },

    /**
     * Handle plotly_update events emitted by the Plotly.js library
     * @param data
     */
    handle_plotly_update: function (data) {

        if (data === null || data === undefined) {
            // No data to report to the Python side
            return
        }

        if (data["data"] &&
            data["data"][0].hasOwnProperty("_doNotReportToPy")) {
            // Update originated on the Python side
            return
        }

        /** @type {Js2PyUpdateMsg} */
        var updateMsg = {
            style_data: data["data"][0],
            style_traces: data["data"][1],
            layout_data: data["layout"],
            source_view_id: this.viewID
        };

        // Log message
        this.model.set("_js2py_update", updateMsg);
        this.touch();
    },

    /**
     * Handle plotly_click events emitted by the Plotly.js library
     * @param data
     */
    handle_plotly_click: function (data) {
        this._send_points_callback_message(data, "plotly_click");
    },

    /**
     * Handle plotly_hover events emitted by the Plotly.js library
     * @param data
     */
    handle_plotly_hover: function (data) {
        this._send_points_callback_message(data, "plotly_hover");
    },

    /**
     * Handle plotly_unhover events emitted by the Plotly.js library
     * @param data
     */
    handle_plotly_unhover: function (data) {
        this._send_points_callback_message(data, "plotly_unhover");
    },

    /**
     * Handle plotly_selected events emitted by the Plotly.js library
     * @param data
     */
    handle_plotly_selected: function (data) {
        this._send_points_callback_message(data, "plotly_selected");
    },

    /**
     * Handle plotly_deselect events emitted by the Plotly.js library
     * @param data
     */
    handle_plotly_deselect: function (data) {
        data = {
            points : []
        }
        this._send_points_callback_message(data, "plotly_deselect");
    },

    /**
     * Build and send a points callback message to the Python side
     *
     * @param {Object} data
     *  data object as provided by the plotly_click, plotly_hover,
     *  plotly_unhover, or plotly_selected events
     * @param {String} event_type
     *  Name of the triggering event. One of 'plotly_click',
     *  'plotly_hover', 'plotly_unhover', or 'plotly_selected'
     * @private
     */
    _send_points_callback_message: function (data, event_type) {
        if (data === null || data === undefined) {
            // No data to report to the Python side
            return;
        }

        /** @type {Js2PyPointsCallbackMsg} */
        var pointsMsg = {
            event_type: event_type,
            points: this.buildPointsObject(data),
            device_state: this.buildInputDeviceStateObject(data),
            selector: this.buildSelectorObject(data)
        };

        if (pointsMsg["points"] !== null &&
            pointsMsg["points"] !== undefined) {

            this.model.set("_js2py_pointsCallback", pointsMsg);
            this.touch();
        }
    },

    /**
     * Stub for future handling of plotly_doubleclick
     * @param data
     */
    handle_plotly_doubleclick: function (data) {},


    /**
     * Handle Plotly.addTraces request
     */
    do_addTraces: function () {

        /** @type {Py2JsAddTracesMsg} */
        var msgData = this.model.get("_py2js_addTraces");

        if (msgData !== null) {

            // Save off original number of traces
            var prevNumTraces = this.el.data.length;

            var that = this;
            Plotly.addTraces(this.el, msgData.trace_data).then(function () {

                // ### Send trace deltas ###
                that._sendTraceDeltas(msgData.trace_edit_id);

                // ### Send layout delta ###
                var layout_edit_id = msgData.layout_edit_id;
                that._sendLayoutDelta(layout_edit_id);
            });
        }
    },

    /**
     * Handle Plotly.deleteTraces request
     */
    do_deleteTraces: function () {

        /** @type {Py2JsDeleteTracesMsg} */
        var msgData = this.model.get("_py2js_deleteTraces");

        if (msgData  !== null){
            var delete_inds = msgData.delete_inds;
            var that = this;
            Plotly.deleteTraces(this.el, delete_inds).then(function () {

                // ### Send trace deltas ###
                var trace_edit_id = msgData.trace_edit_id;
                that._sendTraceDeltas(trace_edit_id);

                // ### Send layout delta ###
                var layout_edit_id = msgData.layout_edit_id;
                that._sendLayoutDelta(layout_edit_id);
            });
        }
    },

    /**
     * Handle Plotly.moveTraces request
     */
    do_moveTraces: function () {

        /** @type {Py2JsMoveTracesMsg} */
        var msgData = this.model.get("_py2js_moveTraces");

        if (msgData !== null){
            // Unpack message
            var currentInds = msgData.current_trace_inds;
            var newInds = msgData.new_trace_inds;

            // Check if the new trace indexes are actually different than
            // the current indexes
            var inds_equal = _.isEqual(currentInds, newInds);

            if (!inds_equal) {
                Plotly.moveTraces(this.el, currentInds, newInds)
            }
        }
    },

    /**
     * Handle Plotly.restyle request
     */
    do_restyle: function () {

        /** @type {Py2JsRestyleMsg} */
        var msgData = this.model.get("_py2js_restyle");
        if (msgData !== null) {
            var restyleData = msgData.restyle_data;
            var traceIndexes = this.model._normalize_trace_indexes(
                msgData.restyle_traces);

            restyleData["_doNotReportToPy"] = true;
            Plotly.restyle(this.el, restyleData, traceIndexes);

            // ### Send trace deltas ###
            // We create an array of deltas corresponding to the restyled
            // traces.
            this._sendTraceDeltas(msgData.trace_edit_id);

            // ### Send layout delta ###
            var layout_edit_id = msgData.layout_edit_id;
            this._sendLayoutDelta(layout_edit_id);
        }
    },

    /**
     * Handle Plotly.relayout request
     */
    do_relayout: function () {

        /** @type {Py2JsRelayoutMsg} */
        var msgData = this.model.get("_py2js_relayout");
        if (msgData !== null) {
            if (msgData.source_view_id !== this.viewID) {
                var relayoutData = msgData.relayout_data;
                relayoutData["_doNotReportToPy"] = true;
                Plotly.relayout(this.el, msgData.relayout_data);
            }

            // ### Send layout delta ###
            var layout_edit_id = msgData.layout_edit_id;
            this._sendLayoutDelta(layout_edit_id);
        }
    },

    /**
     * Handle Plotly.update request
     */
    do_update: function () {

        /** @type {Py2JsUpdateMsg} */
        var msgData = this.model.get("_py2js_update");

        if (msgData !== null) {
            var style = msgData.style_data || {};
            var layout = msgData.layout_data || {};
            var traceIndexes = this.model._normalize_trace_indexes(
                msgData.style_traces);

            style["_doNotReportToPy"] = true;
                Plotly.update(this.el, style, layout, traceIndexes);

            // ### Send trace deltas ###
            // We create an array of deltas corresponding to the updated
            // traces.
            this._sendTraceDeltas(msgData.trace_edit_id);

            // ### Send layout delta ###
            var layout_edit_id = msgData.layout_edit_id;
            this._sendLayoutDelta(layout_edit_id);
        }
    },

    /**
     * Handle Plotly.animate request
     */
    do_animate: function() {

        /** @type {Py2JsAnimateMsg} */
        var msgData = this.model.get("_py2js_animate");

        if (msgData !== null) {

            // Unpack params
            // var animationData = msgData[0];
            var animationOpts = msgData.animation_opts;

            var styles = msgData.style_data;
            var layout = msgData.layout_data;
            var traceIndexes = this.model._normalize_trace_indexes(
                msgData.style_traces);

            var animationData = {
                data: styles,
                layout: layout,
                traces: traceIndexes
            };

            animationData["_doNotReportToPy"] = true;
            var that = this;

            Plotly.animate(this.el, animationData, animationOpts).then(
                function () {

                    // ### Send trace deltas ###
                    // We create an array of deltas corresponding to the
                    // animated traces.
                    that._sendTraceDeltas(msgData.trace_edit_id);

                    // ### Send layout delta ###
                    var layout_edit_id = msgData.layout_edit_id;
                    that._sendLayoutDelta(layout_edit_id);
                });

        }
    },

    /**
     * Construct layout delta object and send layoutDelta message to the
     * Python side
     *
     * @param layout_edit_id
     *  Edit ID of message that triggered the creation of the layout delta
     * @private
     */
    _sendLayoutDelta: function(layout_edit_id) {
        // ### Handle layout delta ###
        var layout_delta = createDeltaObject(
            this.getFullLayout(),
            this.model.get("_layout"));

        /** @type{Js2PyLayoutDeltaMsg} */
        var layoutDeltaMsg = {
            layout_delta: layout_delta,
            layout_edit_id: layout_edit_id};

        this.model.set("_js2py_layoutDelta", layoutDeltaMsg);
        this.touch();
    },

    /**
     * Construct trace deltas array for the requested trace indexes and
     * send traceDeltas message to the Python side
     *  Array of indexes of traces for which to compute deltas
     * @param trace_edit_id
     *  Edit ID of message that triggered the creation of trace deltas
     * @private
     */
    _sendTraceDeltas: function (trace_edit_id) {

        var trace_data = this.model.get("_data");
        var traceIndexes = _.range(trace_data.length);
        var trace_deltas = new Array(traceIndexes.length);

        var fullData = this.getFullData();
        for (var i = 0; i < traceIndexes.length; i++) {
            var traceInd = traceIndexes[i];
            trace_deltas[i] = createDeltaObject(
                fullData[traceInd], trace_data[traceInd]);
        }

        /** @type{Js2PyTraceDeltasMsg} */
        var traceDeltasMsg = {
            trace_deltas: trace_deltas,
            trace_edit_id: trace_edit_id};

        this.model.set("_js2py_traceDeltas", traceDeltasMsg);
        this.touch();
    }
});

// Serialization
/**
 * Create a mapping from numpy dtype strings to corresponding typed array
 * constructors
 */
var numpy_dtype_to_typedarray_type = {
    int8: Int8Array,
    int16: Int16Array,
    int32: Int32Array,
    uint8: Uint8Array,
    uint16: Uint16Array,
    uint32: Uint32Array,
    float32: Float32Array,
    float64: Float64Array
};

function serializeTypedArray(v) {
    var numpyType;
    if (v instanceof Int8Array) {
        numpyType = 'int8';
    } else if (v instanceof Int16Array) {
        numpyType = 'int16';
    } else if (v instanceof Int32Array) {
        numpyType = 'int32';
    } else if (v instanceof Uint8Array) {
        numpyType = 'uint8';
    } else if (v instanceof Uint16Array) {
        numpyType = 'uint16';
    } else if (v instanceof Uint32Array) {
        numpyType = 'uint32';
    } else if (v instanceof Float32Array) {
        numpyType = 'float32';
    } else if (v instanceof Float64Array) {
        numpyType = 'float64';
    } else {
        // Don't understand it, return as is
        return v;
    }
    var res = {
        dtype: numpyType,
        shape: [v.length],
        value: v.buffer
    };
    return res
}

/**
 * ipywidget JavaScript -> Python serializer
 */
function js2py_serializer(v, widgetManager) {
    var res;

    if (_.isTypedArray(v)) {
        res = serializeTypedArray(v);
    } else if (Array.isArray(v)) {
        // Serialize array elements recursively
        res = new Array(v.length);
        for (var i = 0; i < v.length; i++) {
            res[i] = js2py_serializer(v[i]);
        }
    } else if (_.isPlainObject(v)) {
        // Serialize object properties recursively
        res = {};
        for (var p in v) {
            if (v.hasOwnProperty(p)) {
                res[p] = js2py_serializer(v[p]);
            }
        }
    } else if (v === undefined) {
        // Translate undefined into '_undefined_' sentinal string. The
        // Python _js_to_py deserializer will convert this into an
        // Undefined object
        res = "_undefined_";
    } else {
        // Primitive value to transfer directly
        res = v;
    }
    return res
}

/**
 * ipywidget Python -> Javascript deserializer
 */
function py2js_deserializer(v, widgetManager) {
    var res;

    if (Array.isArray(v)) {
        // Deserialize array elements recursively
        res = new Array(v.length);
        for (var i = 0; i < v.length; i++) {
            res[i] = py2js_deserializer(v[i]);
        }
    } else if (_.isPlainObject(v)) {
        if ((_.has(v, 'value') || _.has(v, 'buffer')) &&
            _.has(v, 'dtype') &&
            _.has(v, 'shape')) {
            // Deserialize special buffer/dtype/shape objects into typed arrays
            // These objects correspond to numpy arrays on the Python side
            //
            // Note plotly.py<=3.1.1 called the buffer object `buffer`
            // This was renamed `value` in 3.2 to work around a naming conflict
            // when saving widget state to a notebook.
            var typedarray_type = numpy_dtype_to_typedarray_type[v.dtype];
            var buffer = _.has(v, 'value')? v.value.buffer: v.buffer.buffer;
            res = new typedarray_type(buffer);
        } else {
            // Deserialize object properties recursively
            res = {};
            for (var p in v) {
                if (v.hasOwnProperty(p)) {
                    res[p] = py2js_deserializer(v[p]);
                }
            }
        }
    } else if (v === "_undefined_") {
        // Convert the _undefined_ sentinal into undefined
        res = undefined;
    } else {
        // Accept primitive value directly
        res = v;
    }
    return res
}

/**
 * Return whether the input value is a typed array
 * @param potentialTypedArray
 *  Value to examine
 * @returns {boolean}
 */
function isTypedArray(potentialTypedArray) {
    return ArrayBuffer.isView(potentialTypedArray) &&
        !(potentialTypedArray instanceof DataView);
}

/**
 * Customizer for use with lodash's mergeWith function
 *
 * The customizer ensures that typed arrays are not converted into standard
 * arrays during the recursive merge
 *
 * See: https://lodash.com/docs/latest#mergeWith
 */
function fullMergeCustomizer(objValue, srcValue, key) {
    if (key[0] === '_') {
        // Don't recurse into private properties
        return null
    } else if (isTypedArray(srcValue)) {
        // Return typed arrays directly, don't recurse inside
        return srcValue
    }
}

/**
 * Reform a Plotly.relayout like operation on an input object
 *
 * @param {Object} parentObj
 *  The object that the relayout operation should be applied to
 * @param {Object} relayoutData
 *  An relayout object as accepted by Plotly.relayout
 *
 *  Examples:
 *      var d = {foo {bar [5, 10]}};
 *      performRelayoutLike(d, {'foo.bar': [0, 1]});
 *      d -> {foo: {bar: [0, 1]}}
 *
 *      var d = {foo {bar [5, 10]}};
 *      performRelayoutLike(d, {'baz': 34});
 *      d -> {foo: {bar: [5, 10]}, baz: 34}
 *
 *      var d = {foo: {bar: [5, 10]};
 *      performRelayoutLike(d, {'foo.baz[1]': 17});
 *      d -> {foo: {bar: [5, 17]}}
 *
 */
function performRelayoutLike(parentObj, relayoutData) {
    // Perform a relayout style operation on a given parent object
    for (var rawKey in relayoutData) {
        if (!relayoutData.hasOwnProperty(rawKey)) {
            continue
        }

        // Extract value for this key
        var relayoutVal = relayoutData[rawKey];

        // Set property value
        if (relayoutVal === null) {
            _.unset(parentObj, rawKey);
        } else {
            _.set(parentObj, rawKey, relayoutVal);
        }
    }
}

/**
 * Perform a Plotly.restyle like operation on an input object array
 *
 * @param {Array.<Object>} parentArray
 *  The object that the restyle operation should be applied to
 * @param {Object} restyleData
 *  A restyle object as accepted by Plotly.restyle
 * @param {Array.<Number>} restyleTraces
 *  Array of indexes of the traces that the resytle operation applies to
 *
 *  Examples:
 *      var d = [{foo: {bar: 1}}, {}, {}]
 *      performRestyleLike(d, {'foo.bar': 2}, [0])
 *      d -> [{foo: {bar: 2}}, {}, {}]
 *
 *      var d = [{foo: {bar: 1}}, {}, {}]
 *      performRestyleLike(d, {'foo.bar': 2}, [0, 1, 2])
 *      d -> [{foo: {bar: 2}}, {foo: {bar: 2}}, {foo: {bar: 2}}]
 *
 *      var d = [{foo: {bar: 1}}, {}, {}]
 *      performRestyleLike(d, {'foo.bar': [2, 3, 4]}, [0, 1, 2])
 *      d -> [{foo: {bar: 2}}, {foo: {bar: 3}}, {foo: {bar: 4}}]
 *
 */
function performRestyleLike(parentArray, restyleData, restyleTraces) {
    // Loop over the properties of restyleData
    for (var rawKey in restyleData) {
        if (!restyleData.hasOwnProperty(rawKey)) { continue }

        // Extract value for property and normalize into a value list
        var valArray = restyleData[rawKey];
        if (!Array.isArray(valArray)) {
            valArray = [valArray]
        }

        // Loop over the indexes of the traces being restyled
        for (var i = 0; i < restyleTraces.length; i++) {

            // Get trace object
            var traceInd = restyleTraces[i];
            var trace = parentArray[traceInd];

            // Extract value for this trace
            var singleVal = valArray[i % valArray.length];

            // Set property value
            if (singleVal === null) {
                _.unset(trace, rawKey);
            } else if (singleVal !== undefined){
                _.set(trace, rawKey, singleVal);
            }
        }
    }
}

/**
 * Perform a Plotly.moveTraces like operation on an input object array
 * @param parentArray
 *  The object that the moveTraces operation should be applied to
 * @param currentInds
 *  Array of the current indexes of traces to be moved
 * @param newInds
 *  Array of the new indexes that traces selected by currentInds should be
 *  moved to.
 *
 *  Examples:
 *      var d = [{foo: 0}, {foo: 1}, {foo: 2}]
 *      performMoveTracesLike(d, [0, 1], [2, 0])
 *      d -> [{foo: 1}, {foo: 2}, {foo: 0}]
 *
 *      var d = [{foo: 0}, {foo: 1}, {foo: 2}]
 *      performMoveTracesLike(d, [0, 2], [1, 2])
 *      d -> [{foo: 1}, {foo: 0}, {foo: 2}]
 */
function performMoveTracesLike(parentArray, currentInds, newInds) {

    // ### Remove by currentInds in reverse order ###
    var movingTracesData = [];
    for (var ci = currentInds.length - 1; ci >= 0; ci--) {
        // Insert moving parentArray at beginning of the list
        movingTracesData.splice(0, 0, parentArray[currentInds[ci]]);
        parentArray.splice(currentInds[ci], 1);
    }

    // ### Sort newInds and movingTracesData by newInds ###
    var newIndexSortedArrays = _(newInds).zip(movingTracesData)
        .sortBy(0)
        .unzip()
        .value();

    newInds = newIndexSortedArrays[0];
    movingTracesData = newIndexSortedArrays[1];

    // ### Insert by newInds in forward order ###
    for (var ni = 0; ni < newInds.length; ni++) {
        parentArray.splice(newInds[ni], 0, movingTracesData[ni]);
    }
}

/**
 * Remove nested properties from a parent object
 * @param {Object} parentObj
 *  Parent object from which properties or nested properties should be removed
 * @param {Array.<Array.<Number|String>>} keyPaths
 *  Array of key paths for properties that should be removed. Each key path
 *  is an array of properties names or array indexes that reference a
 *  property to be removed
 *
 *  Examples:
 *      var d = {foo: [{bar: 0}, {bar: 1}], baz: 32}
 *      performRemoveProps(d, ['baz'])
 *      d -> {foo: [{bar: 0}, {bar: 1}]}
 *
 *      var d = {foo: [{bar: 0}, {bar: 1}], baz: 32}
 *      performRemoveProps(d, ['foo[1].bar', 'baz'])
 *      d -> {foo: [{bar: 0}, {}]}
 *
 */
function performRemoveProps(parentObj, keyPaths) {

    for(var i=0; i < keyPaths.length; i++) {
        var keyPath = keyPaths[i];
        _.unset(parentObj, keyPath);
    }
}


/**
 * Return object that contains all properties in fullObj that are not
 * identical to the corresponding properties in removeObj
 *
 * Properties of fullObj and removeObj may be objects or arrays of objects
 *
 * Returned object is a deep clone of the properties of the input objects
 *
 * @param {Object} fullObj
 * @param {Object} removeObj
 *
 *  Examples:
 *      var fullD = {foo: [{bar: 0}, {bar: 1}], baz: 32}
 *      var removeD = {baz: 32}
 *      createDeltaObject(fullD, removeD)
 *          -> {foo: [{bar: 0}, {bar: 1}]}
 *
 *      var fullD = {foo: [{bar: 0}, {bar: 1}], baz: 32}
 *      var removeD = {baz: 45}
 *      createDeltaObject(fullD, removeD)
 *          -> {foo: [{bar: 0}, {bar: 1}], baz: 32}
 *
 *      var fullD = {foo: [{bar: 0}, {bar: 1}], baz: 32}
 *      var removeD = {foo: [{bar: 0}, {bar: 1}]}
 *      createDeltaObject(fullD, removeD)
 *          -> {baz: 32}
 *
 */
function createDeltaObject(fullObj, removeObj) {

    // Initialize result as object or array
    var res;
    if(Array.isArray(fullObj)) {
        res = new Array(fullObj.length);
    } else {
        res = {};
    }

    // Initialize removeObj to empty object if not specified
    if (removeObj === null || removeObj === undefined) {
        removeObj = {};
    }

    // Iterate over object properties or array indices
    for (var p in fullObj) {
        if (p[0] !== "_" &&  // Don't consider private properties
            fullObj.hasOwnProperty(p) &&  // Exclude parent properties
            fullObj[p] !== null  // Exclude cases where fullObj doesn't
                                 // have the property
        ) {
            // Compute object equality
            var props_equal;
            props_equal = _.isEqual(fullObj[p], removeObj[p]);

            // Perform recursive comparison if props are not equal
            if (!props_equal || p === "uid") {  // Let uids through

                // property has non-null value in fullObj that doesn't
                // match the value in removeObj
                var fullVal = fullObj[p];
                if (removeObj.hasOwnProperty(p) &&
                    typeof fullVal === "object") {
                    // Recurse over object properties
                    if(Array.isArray(fullVal)) {

                        if (fullVal.length > 0 &&
                            typeof(fullVal[0]) === "object") {
                            // We have an object array
                            res[p] = new Array(fullVal.length);
                            for (var i = 0; i < fullVal.length; i++) {
                                if (!Array.isArray(removeObj[p]) ||
                                    removeObj[p].length <= i) {

                                    res[p][i] = fullVal[i]
                                } else {
                                    res[p][i] = createDeltaObject(fullVal[i],
                                        removeObj[p][i]);
                                }
                            }
                        } else {
                            // We have a primitive array or typed array
                            res[p] = fullVal;
                        }
                    } else { // object
                        var full_obj = createDeltaObject(fullVal,
                            removeObj[p]);
                        if (Object.keys(full_obj).length > 0) {
                            // new object is not empty
                            res[p] = full_obj;
                        }
                    }
                } else if (typeof fullVal === "object" &&
                    !Array.isArray(fullVal)) {
                    // Return 'clone' of fullVal
                    // We don't use a standard clone method so that we keep
                    // the special case handling of this method
                    res[p] = createDeltaObject(fullVal, {});

                } else if (fullVal !== undefined &&
                    typeof fullVal !== 'function') {
                    // No recursion necessary, Just keep value from fullObj.
                    // But skip values with function type
                    res[p] = fullVal;
                }
            }
        }
    }
    return res
}

function randstr(existing, bits, base, _recursion) {
    if(!base) base = 16;
    if(bits === undefined) bits = 24;
    if(bits <= 0) return '0';

    var digits = Math.log(Math.pow(2, bits)) / Math.log(base);
    var res = '';
    var i, b, x;

    for(i = 2; digits === Infinity; i *= 2) {
        digits = Math.log(Math.pow(2, bits / i)) / Math.log(base) * i;
    }

    var rem = digits - Math.floor(digits);

    for(i = 0; i < Math.floor(digits); i++) {
        x = Math.floor(Math.random() * base).toString(base);
        res = x + res;
    }

    if(rem) {
        b = Math.pow(base, rem);
        x = Math.floor(Math.random() * b).toString(base);
        res = x + res;
    }

    var parsed = parseInt(res, base);
    if((existing && existing[res]) ||
        (parsed !== Infinity && parsed >= Math.pow(2, bits))) {
        if(_recursion > 10) {
            lib.warn('randstr failed uniqueness');
            return res;
        }
        return randstr(existing, bits, base, (_recursion || 0) + 1);
    } else return res;
}

module.exports = {
    FigureView : FigureView,
    FigureModel: FigureModel
};


/***/ }),
/* 4 */
/***/ (function(module, exports) {

module.exports = __WEBPACK_EXTERNAL_MODULE_4__;

/***/ }),
/* 5 */
/***/ (function(module, exports, __webpack_require__) {

/* WEBPACK VAR INJECTION */(function(global, module) {var __WEBPACK_AMD_DEFINE_RESULT__;/**
 * @license
 * Lodash <https://lodash.com/>
 * Copyright OpenJS Foundation and other contributors <https://openjsf.org/>
 * Released under MIT license <https://lodash.com/license>
 * Based on Underscore.js 1.8.3 <http://underscorejs.org/LICENSE>
 * Copyright Jeremy Ashkenas, DocumentCloud and Investigative Reporters & Editors
 */
;(function() {

  /** Used as a safe reference for `undefined` in pre-ES5 environments. */
  var undefined;

  /** Used as the semantic version number. */
  var VERSION = '4.17.13';

  /** Used as the size to enable large array optimizations. */
  var LARGE_ARRAY_SIZE = 200;

  /** Error message constants. */
  var CORE_ERROR_TEXT = 'Unsupported core-js use. Try https://npms.io/search?q=ponyfill.',
      FUNC_ERROR_TEXT = 'Expected a function';

  /** Used to stand-in for `undefined` hash values. */
  var HASH_UNDEFINED = '__lodash_hash_undefined__';

  /** Used as the maximum memoize cache size. */
  var MAX_MEMOIZE_SIZE = 500;

  /** Used as the internal argument placeholder. */
  var PLACEHOLDER = '__lodash_placeholder__';

  /** Used to compose bitmasks for cloning. */
  var CLONE_DEEP_FLAG = 1,
      CLONE_FLAT_FLAG = 2,
      CLONE_SYMBOLS_FLAG = 4;

  /** Used to compose bitmasks for value comparisons. */
  var COMPARE_PARTIAL_FLAG = 1,
      COMPARE_UNORDERED_FLAG = 2;

  /** Used to compose bitmasks for function metadata. */
  var WRAP_BIND_FLAG = 1,
      WRAP_BIND_KEY_FLAG = 2,
      WRAP_CURRY_BOUND_FLAG = 4,
      WRAP_CURRY_FLAG = 8,
      WRAP_CURRY_RIGHT_FLAG = 16,
      WRAP_PARTIAL_FLAG = 32,
      WRAP_PARTIAL_RIGHT_FLAG = 64,
      WRAP_ARY_FLAG = 128,
      WRAP_REARG_FLAG = 256,
      WRAP_FLIP_FLAG = 512;

  /** Used as default options for `_.truncate`. */
  var DEFAULT_TRUNC_LENGTH = 30,
      DEFAULT_TRUNC_OMISSION = '...';

  /** Used to detect hot functions by number of calls within a span of milliseconds. */
  var HOT_COUNT = 800,
      HOT_SPAN = 16;

  /** Used to indicate the type of lazy iteratees. */
  var LAZY_FILTER_FLAG = 1,
      LAZY_MAP_FLAG = 2,
      LAZY_WHILE_FLAG = 3;

  /** Used as references for various `Number` constants. */
  var INFINITY = 1 / 0,
      MAX_SAFE_INTEGER = 9007199254740991,
      MAX_INTEGER = 1.7976931348623157e+308,
      NAN = 0 / 0;

  /** Used as references for the maximum length and index of an array. */
  var MAX_ARRAY_LENGTH = 4294967295,
      MAX_ARRAY_INDEX = MAX_ARRAY_LENGTH - 1,
      HALF_MAX_ARRAY_LENGTH = MAX_ARRAY_LENGTH >>> 1;

  /** Used to associate wrap methods with their bit flags. */
  var wrapFlags = [
    ['ary', WRAP_ARY_FLAG],
    ['bind', WRAP_BIND_FLAG],
    ['bindKey', WRAP_BIND_KEY_FLAG],
    ['curry', WRAP_CURRY_FLAG],
    ['curryRight', WRAP_CURRY_RIGHT_FLAG],
    ['flip', WRAP_FLIP_FLAG],
    ['partial', WRAP_PARTIAL_FLAG],
    ['partialRight', WRAP_PARTIAL_RIGHT_FLAG],
    ['rearg', WRAP_REARG_FLAG]
  ];

  /** `Object#toString` result references. */
  var argsTag = '[object Arguments]',
      arrayTag = '[object Array]',
      asyncTag = '[object AsyncFunction]',
      boolTag = '[object Boolean]',
      dateTag = '[object Date]',
      domExcTag = '[object DOMException]',
      errorTag = '[object Error]',
      funcTag = '[object Function]',
      genTag = '[object GeneratorFunction]',
      mapTag = '[object Map]',
      numberTag = '[object Number]',
      nullTag = '[object Null]',
      objectTag = '[object Object]',
      promiseTag = '[object Promise]',
      proxyTag = '[object Proxy]',
      regexpTag = '[object RegExp]',
      setTag = '[object Set]',
      stringTag = '[object String]',
      symbolTag = '[object Symbol]',
      undefinedTag = '[object Undefined]',
      weakMapTag = '[object WeakMap]',
      weakSetTag = '[object WeakSet]';

  var arrayBufferTag = '[object ArrayBuffer]',
      dataViewTag = '[object DataView]',
      float32Tag = '[object Float32Array]',
      float64Tag = '[object Float64Array]',
      int8Tag = '[object Int8Array]',
      int16Tag = '[object Int16Array]',
      int32Tag = '[object Int32Array]',
      uint8Tag = '[object Uint8Array]',
      uint8ClampedTag = '[object Uint8ClampedArray]',
      uint16Tag = '[object Uint16Array]',
      uint32Tag = '[object Uint32Array]';

  /** Used to match empty string literals in compiled template source. */
  var reEmptyStringLeading = /\b__p \+= '';/g,
      reEmptyStringMiddle = /\b(__p \+=) '' \+/g,
      reEmptyStringTrailing = /(__e\(.*?\)|\b__t\)) \+\n'';/g;

  /** Used to match HTML entities and HTML characters. */
  var reEscapedHtml = /&(?:amp|lt|gt|quot|#39);/g,
      reUnescapedHtml = /[&<>"']/g,
      reHasEscapedHtml = RegExp(reEscapedHtml.source),
      reHasUnescapedHtml = RegExp(reUnescapedHtml.source);

  /** Used to match template delimiters. */
  var reEscape = /<%-([\s\S]+?)%>/g,
      reEvaluate = /<%([\s\S]+?)%>/g,
      reInterpolate = /<%=([\s\S]+?)%>/g;

  /** Used to match property names within property paths. */
  var reIsDeepProp = /\.|\[(?:[^[\]]*|(["'])(?:(?!\1)[^\\]|\\.)*?\1)\]/,
      reIsPlainProp = /^\w*$/,
      rePropName = /[^.[\]]+|\[(?:(-?\d+(?:\.\d+)?)|(["'])((?:(?!\2)[^\\]|\\.)*?)\2)\]|(?=(?:\.|\[\])(?:\.|\[\]|$))/g;

  /**
   * Used to match `RegExp`
   * [syntax characters](http://ecma-international.org/ecma-262/7.0/#sec-patterns).
   */
  var reRegExpChar = /[\\^$.*+?()[\]{}|]/g,
      reHasRegExpChar = RegExp(reRegExpChar.source);

  /** Used to match leading and trailing whitespace. */
  var reTrim = /^\s+|\s+$/g,
      reTrimStart = /^\s+/,
      reTrimEnd = /\s+$/;

  /** Used to match wrap detail comments. */
  var reWrapComment = /\{(?:\n\/\* \[wrapped with .+\] \*\/)?\n?/,
      reWrapDetails = /\{\n\/\* \[wrapped with (.+)\] \*/,
      reSplitDetails = /,? & /;

  /** Used to match words composed of alphanumeric characters. */
  var reAsciiWord = /[^\x00-\x2f\x3a-\x40\x5b-\x60\x7b-\x7f]+/g;

  /** Used to match backslashes in property paths. */
  var reEscapeChar = /\\(\\)?/g;

  /**
   * Used to match
   * [ES template delimiters](http://ecma-international.org/ecma-262/7.0/#sec-template-literal-lexical-components).
   */
  var reEsTemplate = /\$\{([^\\}]*(?:\\.[^\\}]*)*)\}/g;

  /** Used to match `RegExp` flags from their coerced string values. */
  var reFlags = /\w*$/;

  /** Used to detect bad signed hexadecimal string values. */
  var reIsBadHex = /^[-+]0x[0-9a-f]+$/i;

  /** Used to detect binary string values. */
  var reIsBinary = /^0b[01]+$/i;

  /** Used to detect host constructors (Safari). */
  var reIsHostCtor = /^\[object .+?Constructor\]$/;

  /** Used to detect octal string values. */
  var reIsOctal = /^0o[0-7]+$/i;

  /** Used to detect unsigned integer values. */
  var reIsUint = /^(?:0|[1-9]\d*)$/;

  /** Used to match Latin Unicode letters (excluding mathematical operators). */
  var reLatin = /[\xc0-\xd6\xd8-\xf6\xf8-\xff\u0100-\u017f]/g;

  /** Used to ensure capturing order of template delimiters. */
  var reNoMatch = /($^)/;

  /** Used to match unescaped characters in compiled string literals. */
  var reUnescapedString = /['\n\r\u2028\u2029\\]/g;

  /** Used to compose unicode character classes. */
  var rsAstralRange = '\\ud800-\\udfff',
      rsComboMarksRange = '\\u0300-\\u036f',
      reComboHalfMarksRange = '\\ufe20-\\ufe2f',
      rsComboSymbolsRange = '\\u20d0-\\u20ff',
      rsComboRange = rsComboMarksRange + reComboHalfMarksRange + rsComboSymbolsRange,
      rsDingbatRange = '\\u2700-\\u27bf',
      rsLowerRange = 'a-z\\xdf-\\xf6\\xf8-\\xff',
      rsMathOpRange = '\\xac\\xb1\\xd7\\xf7',
      rsNonCharRange = '\\x00-\\x2f\\x3a-\\x40\\x5b-\\x60\\x7b-\\xbf',
      rsPunctuationRange = '\\u2000-\\u206f',
      rsSpaceRange = ' \\t\\x0b\\f\\xa0\\ufeff\\n\\r\\u2028\\u2029\\u1680\\u180e\\u2000\\u2001\\u2002\\u2003\\u2004\\u2005\\u2006\\u2007\\u2008\\u2009\\u200a\\u202f\\u205f\\u3000',
      rsUpperRange = 'A-Z\\xc0-\\xd6\\xd8-\\xde',
      rsVarRange = '\\ufe0e\\ufe0f',
      rsBreakRange = rsMathOpRange + rsNonCharRange + rsPunctuationRange + rsSpaceRange;

  /** Used to compose unicode capture groups. */
  var rsApos = "['\u2019]",
      rsAstral = '[' + rsAstralRange + ']',
      rsBreak = '[' + rsBreakRange + ']',
      rsCombo = '[' + rsComboRange + ']',
      rsDigits = '\\d+',
      rsDingbat = '[' + rsDingbatRange + ']',
      rsLower = '[' + rsLowerRange + ']',
      rsMisc = '[^' + rsAstralRange + rsBreakRange + rsDigits + rsDingbatRange + rsLowerRange + rsUpperRange + ']',
      rsFitz = '\\ud83c[\\udffb-\\udfff]',
      rsModifier = '(?:' + rsCombo + '|' + rsFitz + ')',
      rsNonAstral = '[^' + rsAstralRange + ']',
      rsRegional = '(?:\\ud83c[\\udde6-\\uddff]){2}',
      rsSurrPair = '[\\ud800-\\udbff][\\udc00-\\udfff]',
      rsUpper = '[' + rsUpperRange + ']',
      rsZWJ = '\\u200d';

  /** Used to compose unicode regexes. */
  var rsMiscLower = '(?:' + rsLower + '|' + rsMisc + ')',
      rsMiscUpper = '(?:' + rsUpper + '|' + rsMisc + ')',
      rsOptContrLower = '(?:' + rsApos + '(?:d|ll|m|re|s|t|ve))?',
      rsOptContrUpper = '(?:' + rsApos + '(?:D|LL|M|RE|S|T|VE))?',
      reOptMod = rsModifier + '?',
      rsOptVar = '[' + rsVarRange + ']?',
      rsOptJoin = '(?:' + rsZWJ + '(?:' + [rsNonAstral, rsRegional, rsSurrPair].join('|') + ')' + rsOptVar + reOptMod + ')*',
      rsOrdLower = '\\d*(?:1st|2nd|3rd|(?![123])\\dth)(?=\\b|[A-Z_])',
      rsOrdUpper = '\\d*(?:1ST|2ND|3RD|(?![123])\\dTH)(?=\\b|[a-z_])',
      rsSeq = rsOptVar + reOptMod + rsOptJoin,
      rsEmoji = '(?:' + [rsDingbat, rsRegional, rsSurrPair].join('|') + ')' + rsSeq,
      rsSymbol = '(?:' + [rsNonAstral + rsCombo + '?', rsCombo, rsRegional, rsSurrPair, rsAstral].join('|') + ')';

  /** Used to match apostrophes. */
  var reApos = RegExp(rsApos, 'g');

  /**
   * Used to match [combining diacritical marks](https://en.wikipedia.org/wiki/Combining_Diacritical_Marks) and
   * [combining diacritical marks for symbols](https://en.wikipedia.org/wiki/Combining_Diacritical_Marks_for_Symbols).
   */
  var reComboMark = RegExp(rsCombo, 'g');

  /** Used to match [string symbols](https://mathiasbynens.be/notes/javascript-unicode). */
  var reUnicode = RegExp(rsFitz + '(?=' + rsFitz + ')|' + rsSymbol + rsSeq, 'g');

  /** Used to match complex or compound words. */
  var reUnicodeWord = RegExp([
    rsUpper + '?' + rsLower + '+' + rsOptContrLower + '(?=' + [rsBreak, rsUpper, '$'].join('|') + ')',
    rsMiscUpper + '+' + rsOptContrUpper + '(?=' + [rsBreak, rsUpper + rsMiscLower, '$'].join('|') + ')',
    rsUpper + '?' + rsMiscLower + '+' + rsOptContrLower,
    rsUpper + '+' + rsOptContrUpper,
    rsOrdUpper,
    rsOrdLower,
    rsDigits,
    rsEmoji
  ].join('|'), 'g');

  /** Used to detect strings with [zero-width joiners or code points from the astral planes](http://eev.ee/blog/2015/09/12/dark-corners-of-unicode/). */
  var reHasUnicode = RegExp('[' + rsZWJ + rsAstralRange  + rsComboRange + rsVarRange + ']');

  /** Used to detect strings that need a more robust regexp to match words. */
  var reHasUnicodeWord = /[a-z][A-Z]|[A-Z]{2}[a-z]|[0-9][a-zA-Z]|[a-zA-Z][0-9]|[^a-zA-Z0-9 ]/;

  /** Used to assign default `context` object properties. */
  var contextProps = [
    'Array', 'Buffer', 'DataView', 'Date', 'Error', 'Float32Array', 'Float64Array',
    'Function', 'Int8Array', 'Int16Array', 'Int32Array', 'Map', 'Math', 'Object',
    'Promise', 'RegExp', 'Set', 'String', 'Symbol', 'TypeError', 'Uint8Array',
    'Uint8ClampedArray', 'Uint16Array', 'Uint32Array', 'WeakMap',
    '_', 'clearTimeout', 'isFinite', 'parseInt', 'setTimeout'
  ];

  /** Used to make template sourceURLs easier to identify. */
  var templateCounter = -1;

  /** Used to identify `toStringTag` values of typed arrays. */
  var typedArrayTags = {};
  typedArrayTags[float32Tag] = typedArrayTags[float64Tag] =
  typedArrayTags[int8Tag] = typedArrayTags[int16Tag] =
  typedArrayTags[int32Tag] = typedArrayTags[uint8Tag] =
  typedArrayTags[uint8ClampedTag] = typedArrayTags[uint16Tag] =
  typedArrayTags[uint32Tag] = true;
  typedArrayTags[argsTag] = typedArrayTags[arrayTag] =
  typedArrayTags[arrayBufferTag] = typedArrayTags[boolTag] =
  typedArrayTags[dataViewTag] = typedArrayTags[dateTag] =
  typedArrayTags[errorTag] = typedArrayTags[funcTag] =
  typedArrayTags[mapTag] = typedArrayTags[numberTag] =
  typedArrayTags[objectTag] = typedArrayTags[regexpTag] =
  typedArrayTags[setTag] = typedArrayTags[stringTag] =
  typedArrayTags[weakMapTag] = false;

  /** Used to identify `toStringTag` values supported by `_.clone`. */
  var cloneableTags = {};
  cloneableTags[argsTag] = cloneableTags[arrayTag] =
  cloneableTags[arrayBufferTag] = cloneableTags[dataViewTag] =
  cloneableTags[boolTag] = cloneableTags[dateTag] =
  cloneableTags[float32Tag] = cloneableTags[float64Tag] =
  cloneableTags[int8Tag] = cloneableTags[int16Tag] =
  cloneableTags[int32Tag] = cloneableTags[mapTag] =
  cloneableTags[numberTag] = cloneableTags[objectTag] =
  cloneableTags[regexpTag] = cloneableTags[setTag] =
  cloneableTags[stringTag] = cloneableTags[symbolTag] =
  cloneableTags[uint8Tag] = cloneableTags[uint8ClampedTag] =
  cloneableTags[uint16Tag] = cloneableTags[uint32Tag] = true;
  cloneableTags[errorTag] = cloneableTags[funcTag] =
  cloneableTags[weakMapTag] = false;

  /** Used to map Latin Unicode letters to basic Latin letters. */
  var deburredLetters = {
    // Latin-1 Supplement block.
    '\xc0': 'A',  '\xc1': 'A', '\xc2': 'A', '\xc3': 'A', '\xc4': 'A', '\xc5': 'A',
    '\xe0': 'a',  '\xe1': 'a', '\xe2': 'a', '\xe3': 'a', '\xe4': 'a', '\xe5': 'a',
    '\xc7': 'C',  '\xe7': 'c',
    '\xd0': 'D',  '\xf0': 'd',
    '\xc8': 'E',  '\xc9': 'E', '\xca': 'E', '\xcb': 'E',
    '\xe8': 'e',  '\xe9': 'e', '\xea': 'e', '\xeb': 'e',
    '\xcc': 'I',  '\xcd': 'I', '\xce': 'I', '\xcf': 'I',
    '\xec': 'i',  '\xed': 'i', '\xee': 'i', '\xef': 'i',
    '\xd1': 'N',  '\xf1': 'n',
    '\xd2': 'O',  '\xd3': 'O', '\xd4': 'O', '\xd5': 'O', '\xd6': 'O', '\xd8': 'O',
    '\xf2': 'o',  '\xf3': 'o', '\xf4': 'o', '\xf5': 'o', '\xf6': 'o', '\xf8': 'o',
    '\xd9': 'U',  '\xda': 'U', '\xdb': 'U', '\xdc': 'U',
    '\xf9': 'u',  '\xfa': 'u', '\xfb': 'u', '\xfc': 'u',
    '\xdd': 'Y',  '\xfd': 'y', '\xff': 'y',
    '\xc6': 'Ae', '\xe6': 'ae',
    '\xde': 'Th', '\xfe': 'th',
    '\xdf': 'ss',
    // Latin Extended-A block.
    '\u0100': 'A',  '\u0102': 'A', '\u0104': 'A',
    '\u0101': 'a',  '\u0103': 'a', '\u0105': 'a',
    '\u0106': 'C',  '\u0108': 'C', '\u010a': 'C', '\u010c': 'C',
    '\u0107': 'c',  '\u0109': 'c', '\u010b': 'c', '\u010d': 'c',
    '\u010e': 'D',  '\u0110': 'D', '\u010f': 'd', '\u0111': 'd',
    '\u0112': 'E',  '\u0114': 'E', '\u0116': 'E', '\u0118': 'E', '\u011a': 'E',
    '\u0113': 'e',  '\u0115': 'e', '\u0117': 'e', '\u0119': 'e', '\u011b': 'e',
    '\u011c': 'G',  '\u011e': 'G', '\u0120': 'G', '\u0122': 'G',
    '\u011d': 'g',  '\u011f': 'g', '\u0121': 'g', '\u0123': 'g',
    '\u0124': 'H',  '\u0126': 'H', '\u0125': 'h', '\u0127': 'h',
    '\u0128': 'I',  '\u012a': 'I', '\u012c': 'I', '\u012e': 'I', '\u0130': 'I',
    '\u0129': 'i',  '\u012b': 'i', '\u012d': 'i', '\u012f': 'i', '\u0131': 'i',
    '\u0134': 'J',  '\u0135': 'j',
    '\u0136': 'K',  '\u0137': 'k', '\u0138': 'k',
    '\u0139': 'L',  '\u013b': 'L', '\u013d': 'L', '\u013f': 'L', '\u0141': 'L',
    '\u013a': 'l',  '\u013c': 'l', '\u013e': 'l', '\u0140': 'l', '\u0142': 'l',
    '\u0143': 'N',  '\u0145': 'N', '\u0147': 'N', '\u014a': 'N',
    '\u0144': 'n',  '\u0146': 'n', '\u0148': 'n', '\u014b': 'n',
    '\u014c': 'O',  '\u014e': 'O', '\u0150': 'O',
    '\u014d': 'o',  '\u014f': 'o', '\u0151': 'o',
    '\u0154': 'R',  '\u0156': 'R', '\u0158': 'R',
    '\u0155': 'r',  '\u0157': 'r', '\u0159': 'r',
    '\u015a': 'S',  '\u015c': 'S', '\u015e': 'S', '\u0160': 'S',
    '\u015b': 's',  '\u015d': 's', '\u015f': 's', '\u0161': 's',
    '\u0162': 'T',  '\u0164': 'T', '\u0166': 'T',
    '\u0163': 't',  '\u0165': 't', '\u0167': 't',
    '\u0168': 'U',  '\u016a': 'U', '\u016c': 'U', '\u016e': 'U', '\u0170': 'U', '\u0172': 'U',
    '\u0169': 'u',  '\u016b': 'u', '\u016d': 'u', '\u016f': 'u', '\u0171': 'u', '\u0173': 'u',
    '\u0174': 'W',  '\u0175': 'w',
    '\u0176': 'Y',  '\u0177': 'y', '\u0178': 'Y',
    '\u0179': 'Z',  '\u017b': 'Z', '\u017d': 'Z',
    '\u017a': 'z',  '\u017c': 'z', '\u017e': 'z',
    '\u0132': 'IJ', '\u0133': 'ij',
    '\u0152': 'Oe', '\u0153': 'oe',
    '\u0149': "'n", '\u017f': 's'
  };

  /** Used to map characters to HTML entities. */
  var htmlEscapes = {
    '&': '&amp;',
    '<': '&lt;',
    '>': '&gt;',
    '"': '&quot;',
    "'": '&#39;'
  };

  /** Used to map HTML entities to characters. */
  var htmlUnescapes = {
    '&amp;': '&',
    '&lt;': '<',
    '&gt;': '>',
    '&quot;': '"',
    '&#39;': "'"
  };

  /** Used to escape characters for inclusion in compiled string literals. */
  var stringEscapes = {
    '\\': '\\',
    "'": "'",
    '\n': 'n',
    '\r': 'r',
    '\u2028': 'u2028',
    '\u2029': 'u2029'
  };

  /** Built-in method references without a dependency on `root`. */
  var freeParseFloat = parseFloat,
      freeParseInt = parseInt;

  /** Detect free variable `global` from Node.js. */
  var freeGlobal = typeof global == 'object' && global && global.Object === Object && global;

  /** Detect free variable `self`. */
  var freeSelf = typeof self == 'object' && self && self.Object === Object && self;

  /** Used as a reference to the global object. */
  var root = freeGlobal || freeSelf || Function('return this')();

  /** Detect free variable `exports`. */
  var freeExports = typeof exports == 'object' && exports && !exports.nodeType && exports;

  /** Detect free variable `module`. */
  var freeModule = freeExports && typeof module == 'object' && module && !module.nodeType && module;

  /** Detect the popular CommonJS extension `module.exports`. */
  var moduleExports = freeModule && freeModule.exports === freeExports;

  /** Detect free variable `process` from Node.js. */
  var freeProcess = moduleExports && freeGlobal.process;

  /** Used to access faster Node.js helpers. */
  var nodeUtil = (function() {
    try {
      // Use `util.types` for Node.js 10+.
      var types = freeModule && freeModule.require && freeModule.require('util').types;

      if (types) {
        return types;
      }

      // Legacy `process.binding('util')` for Node.js < 10.
      return freeProcess && freeProcess.binding && freeProcess.binding('util');
    } catch (e) {}
  }());

  /* Node.js helper references. */
  var nodeIsArrayBuffer = nodeUtil && nodeUtil.isArrayBuffer,
      nodeIsDate = nodeUtil && nodeUtil.isDate,
      nodeIsMap = nodeUtil && nodeUtil.isMap,
      nodeIsRegExp = nodeUtil && nodeUtil.isRegExp,
      nodeIsSet = nodeUtil && nodeUtil.isSet,
      nodeIsTypedArray = nodeUtil && nodeUtil.isTypedArray;

  /*--------------------------------------------------------------------------*/

  /**
   * A faster alternative to `Function#apply`, this function invokes `func`
   * with the `this` binding of `thisArg` and the arguments of `args`.
   *
   * @private
   * @param {Function} func The function to invoke.
   * @param {*} thisArg The `this` binding of `func`.
   * @param {Array} args The arguments to invoke `func` with.
   * @returns {*} Returns the result of `func`.
   */
  function apply(func, thisArg, args) {
    switch (args.length) {
      case 0: return func.call(thisArg);
      case 1: return func.call(thisArg, args[0]);
      case 2: return func.call(thisArg, args[0], args[1]);
      case 3: return func.call(thisArg, args[0], args[1], args[2]);
    }
    return func.apply(thisArg, args);
  }

  /**
   * A specialized version of `baseAggregator` for arrays.
   *
   * @private
   * @param {Array} [array] The array to iterate over.
   * @param {Function} setter The function to set `accumulator` values.
   * @param {Function} iteratee The iteratee to transform keys.
   * @param {Object} accumulator The initial aggregated object.
   * @returns {Function} Returns `accumulator`.
   */
  function arrayAggregator(array, setter, iteratee, accumulator) {
    var index = -1,
        length = array == null ? 0 : array.length;

    while (++index < length) {
      var value = array[index];
      setter(accumulator, value, iteratee(value), array);
    }
    return accumulator;
  }

  /**
   * A specialized version of `_.forEach` for arrays without support for
   * iteratee shorthands.
   *
   * @private
   * @param {Array} [array] The array to iterate over.
   * @param {Function} iteratee The function invoked per iteration.
   * @returns {Array} Returns `array`.
   */
  function arrayEach(array, iteratee) {
    var index = -1,
        length = array == null ? 0 : array.length;

    while (++index < length) {
      if (iteratee(array[index], index, array) === false) {
        break;
      }
    }
    return array;
  }

  /**
   * A specialized version of `_.forEachRight` for arrays without support for
   * iteratee shorthands.
   *
   * @private
   * @param {Array} [array] The array to iterate over.
   * @param {Function} iteratee The function invoked per iteration.
   * @returns {Array} Returns `array`.
   */
  function arrayEachRight(array, iteratee) {
    var length = array == null ? 0 : array.length;

    while (length--) {
      if (iteratee(array[length], length, array) === false) {
        break;
      }
    }
    return array;
  }

  /**
   * A specialized version of `_.every` for arrays without support for
   * iteratee shorthands.
   *
   * @private
   * @param {Array} [array] The array to iterate over.
   * @param {Function} predicate The function invoked per iteration.
   * @returns {boolean} Returns `true` if all elements pass the predicate check,
   *  else `false`.
   */
  function arrayEvery(array, predicate) {
    var index = -1,
        length = array == null ? 0 : array.length;

    while (++index < length) {
      if (!predicate(array[index], index, array)) {
        return false;
      }
    }
    return true;
  }

  /**
   * A specialized version of `_.filter` for arrays without support for
   * iteratee shorthands.
   *
   * @private
   * @param {Array} [array] The array to iterate over.
   * @param {Function} predicate The function invoked per iteration.
   * @returns {Array} Returns the new filtered array.
   */
  function arrayFilter(array, predicate) {
    var index = -1,
        length = array == null ? 0 : array.length,
        resIndex = 0,
        result = [];

    while (++index < length) {
      var value = array[index];
      if (predicate(value, index, array)) {
        result[resIndex++] = value;
      }
    }
    return result;
  }

  /**
   * A specialized version of `_.includes` for arrays without support for
   * specifying an index to search from.
   *
   * @private
   * @param {Array} [array] The array to inspect.
   * @param {*} target The value to search for.
   * @returns {boolean} Returns `true` if `target` is found, else `false`.
   */
  function arrayIncludes(array, value) {
    var length = array == null ? 0 : array.length;
    return !!length && baseIndexOf(array, value, 0) > -1;
  }

  /**
   * This function is like `arrayIncludes` except that it accepts a comparator.
   *
   * @private
   * @param {Array} [array] The array to inspect.
   * @param {*} target The value to search for.
   * @param {Function} comparator The comparator invoked per element.
   * @returns {boolean} Returns `true` if `target` is found, else `false`.
   */
  function arrayIncludesWith(array, value, comparator) {
    var index = -1,
        length = array == null ? 0 : array.length;

    while (++index < length) {
      if (comparator(value, array[index])) {
        return true;
      }
    }
    return false;
  }

  /**
   * A specialized version of `_.map` for arrays without support for iteratee
   * shorthands.
   *
   * @private
   * @param {Array} [array] The array to iterate over.
   * @param {Function} iteratee The function invoked per iteration.
   * @returns {Array} Returns the new mapped array.
   */
  function arrayMap(array, iteratee) {
    var index = -1,
        length = array == null ? 0 : array.length,
        result = Array(length);

    while (++index < length) {
      result[index] = iteratee(array[index], index, array);
    }
    return result;
  }

  /**
   * Appends the elements of `values` to `array`.
   *
   * @private
   * @param {Array} array The array to modify.
   * @param {Array} values The values to append.
   * @returns {Array} Returns `array`.
   */
  function arrayPush(array, values) {
    var index = -1,
        length = values.length,
        offset = array.length;

    while (++index < length) {
      array[offset + index] = values[index];
    }
    return array;
  }

  /**
   * A specialized version of `_.reduce` for arrays without support for
   * iteratee shorthands.
   *
   * @private
   * @param {Array} [array] The array to iterate over.
   * @param {Function} iteratee The function invoked per iteration.
   * @param {*} [accumulator] The initial value.
   * @param {boolean} [initAccum] Specify using the first element of `array` as
   *  the initial value.
   * @returns {*} Returns the accumulated value.
   */
  function arrayReduce(array, iteratee, accumulator, initAccum) {
    var index = -1,
        length = array == null ? 0 : array.length;

    if (initAccum && length) {
      accumulator = array[++index];
    }
    while (++index < length) {
      accumulator = iteratee(accumulator, array[index], index, array);
    }
    return accumulator;
  }

  /**
   * A specialized version of `_.reduceRight` for arrays without support for
   * iteratee shorthands.
   *
   * @private
   * @param {Array} [array] The array to iterate over.
   * @param {Function} iteratee The function invoked per iteration.
   * @param {*} [accumulator] The initial value.
   * @param {boolean} [initAccum] Specify using the last element of `array` as
   *  the initial value.
   * @returns {*} Returns the accumulated value.
   */
  function arrayReduceRight(array, iteratee, accumulator, initAccum) {
    var length = array == null ? 0 : array.length;
    if (initAccum && length) {
      accumulator = array[--length];
    }
    while (length--) {
      accumulator = iteratee(accumulator, array[length], length, array);
    }
    return accumulator;
  }

  /**
   * A specialized version of `_.some` for arrays without support for iteratee
   * shorthands.
   *
   * @private
   * @param {Array} [array] The array to iterate over.
   * @param {Function} predicate The function invoked per iteration.
   * @returns {boolean} Returns `true` if any element passes the predicate check,
   *  else `false`.
   */
  function arraySome(array, predicate) {
    var index = -1,
        length = array == null ? 0 : array.length;

    while (++index < length) {
      if (predicate(array[index], index, array)) {
        return true;
      }
    }
    return false;
  }

  /**
   * Gets the size of an ASCII `string`.
   *
   * @private
   * @param {string} string The string inspect.
   * @returns {number} Returns the string size.
   */
  var asciiSize = baseProperty('length');

  /**
   * Converts an ASCII `string` to an array.
   *
   * @private
   * @param {string} string The string to convert.
   * @returns {Array} Returns the converted array.
   */
  function asciiToArray(string) {
    return string.split('');
  }

  /**
   * Splits an ASCII `string` into an array of its words.
   *
   * @private
   * @param {string} The string to inspect.
   * @returns {Array} Returns the words of `string`.
   */
  function asciiWords(string) {
    return string.match(reAsciiWord) || [];
  }

  /**
   * The base implementation of methods like `_.findKey` and `_.findLastKey`,
   * without support for iteratee shorthands, which iterates over `collection`
   * using `eachFunc`.
   *
   * @private
   * @param {Array|Object} collection The collection to inspect.
   * @param {Function} predicate The function invoked per iteration.
   * @param {Function} eachFunc The function to iterate over `collection`.
   * @returns {*} Returns the found element or its key, else `undefined`.
   */
  function baseFindKey(collection, predicate, eachFunc) {
    var result;
    eachFunc(collection, function(value, key, collection) {
      if (predicate(value, key, collection)) {
        result = key;
        return false;
      }
    });
    return result;
  }

  /**
   * The base implementation of `_.findIndex` and `_.findLastIndex` without
   * support for iteratee shorthands.
   *
   * @private
   * @param {Array} array The array to inspect.
   * @param {Function} predicate The function invoked per iteration.
   * @param {number} fromIndex The index to search from.
   * @param {boolean} [fromRight] Specify iterating from right to left.
   * @returns {number} Returns the index of the matched value, else `-1`.
   */
  function baseFindIndex(array, predicate, fromIndex, fromRight) {
    var length = array.length,
        index = fromIndex + (fromRight ? 1 : -1);

    while ((fromRight ? index-- : ++index < length)) {
      if (predicate(array[index], index, array)) {
        return index;
      }
    }
    return -1;
  }

  /**
   * The base implementation of `_.indexOf` without `fromIndex` bounds checks.
   *
   * @private
   * @param {Array} array The array to inspect.
   * @param {*} value The value to search for.
   * @param {number} fromIndex The index to search from.
   * @returns {number} Returns the index of the matched value, else `-1`.
   */
  function baseIndexOf(array, value, fromIndex) {
    return value === value
      ? strictIndexOf(array, value, fromIndex)
      : baseFindIndex(array, baseIsNaN, fromIndex);
  }

  /**
   * This function is like `baseIndexOf` except that it accepts a comparator.
   *
   * @private
   * @param {Array} array The array to inspect.
   * @param {*} value The value to search for.
   * @param {number} fromIndex The index to search from.
   * @param {Function} comparator The comparator invoked per element.
   * @returns {number} Returns the index of the matched value, else `-1`.
   */
  function baseIndexOfWith(array, value, fromIndex, comparator) {
    var index = fromIndex - 1,
        length = array.length;

    while (++index < length) {
      if (comparator(array[index], value)) {
        return index;
      }
    }
    return -1;
  }

  /**
   * The base implementation of `_.isNaN` without support for number objects.
   *
   * @private
   * @param {*} value The value to check.
   * @returns {boolean} Returns `true` if `value` is `NaN`, else `false`.
   */
  function baseIsNaN(value) {
    return value !== value;
  }

  /**
   * The base implementation of `_.mean` and `_.meanBy` without support for
   * iteratee shorthands.
   *
   * @private
   * @param {Array} array The array to iterate over.
   * @param {Function} iteratee The function invoked per iteration.
   * @returns {number} Returns the mean.
   */
  function baseMean(array, iteratee) {
    var length = array == null ? 0 : array.length;
    return length ? (baseSum(array, iteratee) / length) : NAN;
  }

  /**
   * The base implementation of `_.property` without support for deep paths.
   *
   * @private
   * @param {string} key The key of the property to get.
   * @returns {Function} Returns the new accessor function.
   */
  function baseProperty(key) {
    return function(object) {
      return object == null ? undefined : object[key];
    };
  }

  /**
   * The base implementation of `_.propertyOf` without support for deep paths.
   *
   * @private
   * @param {Object} object The object to query.
   * @returns {Function} Returns the new accessor function.
   */
  function basePropertyOf(object) {
    return function(key) {
      return object == null ? undefined : object[key];
    };
  }

  /**
   * The base implementation of `_.reduce` and `_.reduceRight`, without support
   * for iteratee shorthands, which iterates over `collection` using `eachFunc`.
   *
   * @private
   * @param {Array|Object} collection The collection to iterate over.
   * @param {Function} iteratee The function invoked per iteration.
   * @param {*} accumulator The initial value.
   * @param {boolean} initAccum Specify using the first or last element of
   *  `collection` as the initial value.
   * @param {Function} eachFunc The function to iterate over `collection`.
   * @returns {*} Returns the accumulated value.
   */
  function baseReduce(collection, iteratee, accumulator, initAccum, eachFunc) {
    eachFunc(collection, function(value, index, collection) {
      accumulator = initAccum
        ? (initAccum = false, value)
        : iteratee(accumulator, value, index, collection);
    });
    return accumulator;
  }

  /**
   * The base implementation of `_.sortBy` which uses `comparer` to define the
   * sort order of `array` and replaces criteria objects with their corresponding
   * values.
   *
   * @private
   * @param {Array} array The array to sort.
   * @param {Function} comparer The function to define sort order.
   * @returns {Array} Returns `array`.
   */
  function baseSortBy(array, comparer) {
    var length = array.length;

    array.sort(comparer);
    while (length--) {
      array[length] = array[length].value;
    }
    return array;
  }

  /**
   * The base implementation of `_.sum` and `_.sumBy` without support for
   * iteratee shorthands.
   *
   * @private
   * @param {Array} array The array to iterate over.
   * @param {Function} iteratee The function invoked per iteration.
   * @returns {number} Returns the sum.
   */
  function baseSum(array, iteratee) {
    var result,
        index = -1,
        length = array.length;

    while (++index < length) {
      var current = iteratee(array[index]);
      if (current !== undefined) {
        result = result === undefined ? current : (result + current);
      }
    }
    return result;
  }

  /**
   * The base implementation of `_.times` without support for iteratee shorthands
   * or max array length checks.
   *
   * @private
   * @param {number} n The number of times to invoke `iteratee`.
   * @param {Function} iteratee The function invoked per iteration.
   * @returns {Array} Returns the array of results.
   */
  function baseTimes(n, iteratee) {
    var index = -1,
        result = Array(n);

    while (++index < n) {
      result[index] = iteratee(index);
    }
    return result;
  }

  /**
   * The base implementation of `_.toPairs` and `_.toPairsIn` which creates an array
   * of key-value pairs for `object` corresponding to the property names of `props`.
   *
   * @private
   * @param {Object} object The object to query.
   * @param {Array} props The property names to get values for.
   * @returns {Object} Returns the key-value pairs.
   */
  function baseToPairs(object, props) {
    return arrayMap(props, function(key) {
      return [key, object[key]];
    });
  }

  /**
   * The base implementation of `_.unary` without support for storing metadata.
   *
   * @private
   * @param {Function} func The function to cap arguments for.
   * @returns {Function} Returns the new capped function.
   */
  function baseUnary(func) {
    return function(value) {
      return func(value);
    };
  }

  /**
   * The base implementation of `_.values` and `_.valuesIn` which creates an
   * array of `object` property values corresponding to the property names
   * of `props`.
   *
   * @private
   * @param {Object} object The object to query.
   * @param {Array} props The property names to get values for.
   * @returns {Object} Returns the array of property values.
   */
  function baseValues(object, props) {
    return arrayMap(props, function(key) {
      return object[key];
    });
  }

  /**
   * Checks if a `cache` value for `key` exists.
   *
   * @private
   * @param {Object} cache The cache to query.
   * @param {string} key The key of the entry to check.
   * @returns {boolean} Returns `true` if an entry for `key` exists, else `false`.
   */
  function cacheHas(cache, key) {
    return cache.has(key);
  }

  /**
   * Used by `_.trim` and `_.trimStart` to get the index of the first string symbol
   * that is not found in the character symbols.
   *
   * @private
   * @param {Array} strSymbols The string symbols to inspect.
   * @param {Array} chrSymbols The character symbols to find.
   * @returns {number} Returns the index of the first unmatched string symbol.
   */
  function charsStartIndex(strSymbols, chrSymbols) {
    var index = -1,
        length = strSymbols.length;

    while (++index < length && baseIndexOf(chrSymbols, strSymbols[index], 0) > -1) {}
    return index;
  }

  /**
   * Used by `_.trim` and `_.trimEnd` to get the index of the last string symbol
   * that is not found in the character symbols.
   *
   * @private
   * @param {Array} strSymbols The string symbols to inspect.
   * @param {Array} chrSymbols The character symbols to find.
   * @returns {number} Returns the index of the last unmatched string symbol.
   */
  function charsEndIndex(strSymbols, chrSymbols) {
    var index = strSymbols.length;

    while (index-- && baseIndexOf(chrSymbols, strSymbols[index], 0) > -1) {}
    return index;
  }

  /**
   * Gets the number of `placeholder` occurrences in `array`.
   *
   * @private
   * @param {Array} array The array to inspect.
   * @param {*} placeholder The placeholder to search for.
   * @returns {number} Returns the placeholder count.
   */
  function countHolders(array, placeholder) {
    var length = array.length,
        result = 0;

    while (length--) {
      if (array[length] === placeholder) {
        ++result;
      }
    }
    return result;
  }

  /**
   * Used by `_.deburr` to convert Latin-1 Supplement and Latin Extended-A
   * letters to basic Latin letters.
   *
   * @private
   * @param {string} letter The matched letter to deburr.
   * @returns {string} Returns the deburred letter.
   */
  var deburrLetter = basePropertyOf(deburredLetters);

  /**
   * Used by `_.escape` to convert characters to HTML entities.
   *
   * @private
   * @param {string} chr The matched character to escape.
   * @returns {string} Returns the escaped character.
   */
  var escapeHtmlChar = basePropertyOf(htmlEscapes);

  /**
   * Used by `_.template` to escape characters for inclusion in compiled string literals.
   *
   * @private
   * @param {string} chr The matched character to escape.
   * @returns {string} Returns the escaped character.
   */
  function escapeStringChar(chr) {
    return '\\' + stringEscapes[chr];
  }

  /**
   * Gets the value at `key` of `object`.
   *
   * @private
   * @param {Object} [object] The object to query.
   * @param {string} key The key of the property to get.
   * @returns {*} Returns the property value.
   */
  function getValue(object, key) {
    return object == null ? undefined : object[key];
  }

  /**
   * Checks if `string` contains Unicode symbols.
   *
   * @private
   * @param {string} string The string to inspect.
   * @returns {boolean} Returns `true` if a symbol is found, else `false`.
   */
  function hasUnicode(string) {
    return reHasUnicode.test(string);
  }

  /**
   * Checks if `string` contains a word composed of Unicode symbols.
   *
   * @private
   * @param {string} string The string to inspect.
   * @returns {boolean} Returns `true` if a word is found, else `false`.
   */
  function hasUnicodeWord(string) {
    return reHasUnicodeWord.test(string);
  }

  /**
   * Converts `iterator` to an array.
   *
   * @private
   * @param {Object} iterator The iterator to convert.
   * @returns {Array} Returns the converted array.
   */
  function iteratorToArray(iterator) {
    var data,
        result = [];

    while (!(data = iterator.next()).done) {
      result.push(data.value);
    }
    return result;
  }

  /**
   * Converts `map` to its key-value pairs.
   *
   * @private
   * @param {Object} map The map to convert.
   * @returns {Array} Returns the key-value pairs.
   */
  function mapToArray(map) {
    var index = -1,
        result = Array(map.size);

    map.forEach(function(value, key) {
      result[++index] = [key, value];
    });
    return result;
  }

  /**
   * Creates a unary function that invokes `func` with its argument transformed.
   *
   * @private
   * @param {Function} func The function to wrap.
   * @param {Function} transform The argument transform.
   * @returns {Function} Returns the new function.
   */
  function overArg(func, transform) {
    return function(arg) {
      return func(transform(arg));
    };
  }

  /**
   * Replaces all `placeholder` elements in `array` with an internal placeholder
   * and returns an array of their indexes.
   *
   * @private
   * @param {Array} array The array to modify.
   * @param {*} placeholder The placeholder to replace.
   * @returns {Array} Returns the new array of placeholder indexes.
   */
  function replaceHolders(array, placeholder) {
    var index = -1,
        length = array.length,
        resIndex = 0,
        result = [];

    while (++index < length) {
      var value = array[index];
      if (value === placeholder || value === PLACEHOLDER) {
        array[index] = PLACEHOLDER;
        result[resIndex++] = index;
      }
    }
    return result;
  }

  /**
   * Converts `set` to an array of its values.
   *
   * @private
   * @param {Object} set The set to convert.
   * @returns {Array} Returns the values.
   */
  function setToArray(set) {
    var index = -1,
        result = Array(set.size);

    set.forEach(function(value) {
      result[++index] = value;
    });
    return result;
  }

  /**
   * Converts `set` to its value-value pairs.
   *
   * @private
   * @param {Object} set The set to convert.
   * @returns {Array} Returns the value-value pairs.
   */
  function setToPairs(set) {
    var index = -1,
        result = Array(set.size);

    set.forEach(function(value) {
      result[++index] = [value, value];
    });
    return result;
  }

  /**
   * A specialized version of `_.indexOf` which performs strict equality
   * comparisons of values, i.e. `===`.
   *
   * @private
   * @param {Array} array The array to inspect.
   * @param {*} value The value to search for.
   * @param {number} fromIndex The index to search from.
   * @returns {number} Returns the index of the matched value, else `-1`.
   */
  function strictIndexOf(array, value, fromIndex) {
    var index = fromIndex - 1,
        length = array.length;

    while (++index < length) {
      if (array[index] === value) {
        return index;
      }
    }
    return -1;
  }

  /**
   * A specialized version of `_.lastIndexOf` which performs strict equality
   * comparisons of values, i.e. `===`.
   *
   * @private
   * @param {Array} array The array to inspect.
   * @param {*} value The value to search for.
   * @param {number} fromIndex The index to search from.
   * @returns {number} Returns the index of the matched value, else `-1`.
   */
  function strictLastIndexOf(array, value, fromIndex) {
    var index = fromIndex + 1;
    while (index--) {
      if (array[index] === value) {
        return index;
      }
    }
    return index;
  }

  /**
   * Gets the number of symbols in `string`.
   *
   * @private
   * @param {string} string The string to inspect.
   * @returns {number} Returns the string size.
   */
  function stringSize(string) {
    return hasUnicode(string)
      ? unicodeSize(string)
      : asciiSize(string);
  }

  /**
   * Converts `string` to an array.
   *
   * @private
   * @param {string} string The string to convert.
   * @returns {Array} Returns the converted array.
   */
  function stringToArray(string) {
    return hasUnicode(string)
      ? unicodeToArray(string)
      : asciiToArray(string);
  }

  /**
   * Used by `_.unescape` to convert HTML entities to characters.
   *
   * @private
   * @param {string} chr The matched character to unescape.
   * @returns {string} Returns the unescaped character.
   */
  var unescapeHtmlChar = basePropertyOf(htmlUnescapes);

  /**
   * Gets the size of a Unicode `string`.
   *
   * @private
   * @param {string} string The string inspect.
   * @returns {number} Returns the string size.
   */
  function unicodeSize(string) {
    var result = reUnicode.lastIndex = 0;
    while (reUnicode.test(string)) {
      ++result;
    }
    return result;
  }

  /**
   * Converts a Unicode `string` to an array.
   *
   * @private
   * @param {string} string The string to convert.
   * @returns {Array} Returns the converted array.
   */
  function unicodeToArray(string) {
    return string.match(reUnicode) || [];
  }

  /**
   * Splits a Unicode `string` into an array of its words.
   *
   * @private
   * @param {string} The string to inspect.
   * @returns {Array} Returns the words of `string`.
   */
  function unicodeWords(string) {
    return string.match(reUnicodeWord) || [];
  }

  /*--------------------------------------------------------------------------*/

  /**
   * Create a new pristine `lodash` function using the `context` object.
   *
   * @static
   * @memberOf _
   * @since 1.1.0
   * @category Util
   * @param {Object} [context=root] The context object.
   * @returns {Function} Returns a new `lodash` function.
   * @example
   *
   * _.mixin({ 'foo': _.constant('foo') });
   *
   * var lodash = _.runInContext();
   * lodash.mixin({ 'bar': lodash.constant('bar') });
   *
   * _.isFunction(_.foo);
   * // => true
   * _.isFunction(_.bar);
   * // => false
   *
   * lodash.isFunction(lodash.foo);
   * // => false
   * lodash.isFunction(lodash.bar);
   * // => true
   *
   * // Create a suped-up `defer` in Node.js.
   * var defer = _.runInContext({ 'setTimeout': setImmediate }).defer;
   */
  var runInContext = (function runInContext(context) {
    context = context == null ? root : _.defaults(root.Object(), context, _.pick(root, contextProps));

    /** Built-in constructor references. */
    var Array = context.Array,
        Date = context.Date,
        Error = context.Error,
        Function = context.Function,
        Math = context.Math,
        Object = context.Object,
        RegExp = context.RegExp,
        String = context.String,
        TypeError = context.TypeError;

    /** Used for built-in method references. */
    var arrayProto = Array.prototype,
        funcProto = Function.prototype,
        objectProto = Object.prototype;

    /** Used to detect overreaching core-js shims. */
    var coreJsData = context['__core-js_shared__'];

    /** Used to resolve the decompiled source of functions. */
    var funcToString = funcProto.toString;

    /** Used to check objects for own properties. */
    var hasOwnProperty = objectProto.hasOwnProperty;

    /** Used to generate unique IDs. */
    var idCounter = 0;

    /** Used to detect methods masquerading as native. */
    var maskSrcKey = (function() {
      var uid = /[^.]+$/.exec(coreJsData && coreJsData.keys && coreJsData.keys.IE_PROTO || '');
      return uid ? ('Symbol(src)_1.' + uid) : '';
    }());

    /**
     * Used to resolve the
     * [`toStringTag`](http://ecma-international.org/ecma-262/7.0/#sec-object.prototype.tostring)
     * of values.
     */
    var nativeObjectToString = objectProto.toString;

    /** Used to infer the `Object` constructor. */
    var objectCtorString = funcToString.call(Object);

    /** Used to restore the original `_` reference in `_.noConflict`. */
    var oldDash = root._;

    /** Used to detect if a method is native. */
    var reIsNative = RegExp('^' +
      funcToString.call(hasOwnProperty).replace(reRegExpChar, '\\$&')
      .replace(/hasOwnProperty|(function).*?(?=\\\()| for .+?(?=\\\])/g, '$1.*?') + '$'
    );

    /** Built-in value references. */
    var Buffer = moduleExports ? context.Buffer : undefined,
        Symbol = context.Symbol,
        Uint8Array = context.Uint8Array,
        allocUnsafe = Buffer ? Buffer.allocUnsafe : undefined,
        getPrototype = overArg(Object.getPrototypeOf, Object),
        objectCreate = Object.create,
        propertyIsEnumerable = objectProto.propertyIsEnumerable,
        splice = arrayProto.splice,
        spreadableSymbol = Symbol ? Symbol.isConcatSpreadable : undefined,
        symIterator = Symbol ? Symbol.iterator : undefined,
        symToStringTag = Symbol ? Symbol.toStringTag : undefined;

    var defineProperty = (function() {
      try {
        var func = getNative(Object, 'defineProperty');
        func({}, '', {});
        return func;
      } catch (e) {}
    }());

    /** Mocked built-ins. */
    var ctxClearTimeout = context.clearTimeout !== root.clearTimeout && context.clearTimeout,
        ctxNow = Date && Date.now !== root.Date.now && Date.now,
        ctxSetTimeout = context.setTimeout !== root.setTimeout && context.setTimeout;

    /* Built-in method references for those with the same name as other `lodash` methods. */
    var nativeCeil = Math.ceil,
        nativeFloor = Math.floor,
        nativeGetSymbols = Object.getOwnPropertySymbols,
        nativeIsBuffer = Buffer ? Buffer.isBuffer : undefined,
        nativeIsFinite = context.isFinite,
        nativeJoin = arrayProto.join,
        nativeKeys = overArg(Object.keys, Object),
        nativeMax = Math.max,
        nativeMin = Math.min,
        nativeNow = Date.now,
        nativeParseInt = context.parseInt,
        nativeRandom = Math.random,
        nativeReverse = arrayProto.reverse;

    /* Built-in method references that are verified to be native. */
    var DataView = getNative(context, 'DataView'),
        Map = getNative(context, 'Map'),
        Promise = getNative(context, 'Promise'),
        Set = getNative(context, 'Set'),
        WeakMap = getNative(context, 'WeakMap'),
        nativeCreate = getNative(Object, 'create');

    /** Used to store function metadata. */
    var metaMap = WeakMap && new WeakMap;

    /** Used to lookup unminified function names. */
    var realNames = {};

    /** Used to detect maps, sets, and weakmaps. */
    var dataViewCtorString = toSource(DataView),
        mapCtorString = toSource(Map),
        promiseCtorString = toSource(Promise),
        setCtorString = toSource(Set),
        weakMapCtorString = toSource(WeakMap);

    /** Used to convert symbols to primitives and strings. */
    var symbolProto = Symbol ? Symbol.prototype : undefined,
        symbolValueOf = symbolProto ? symbolProto.valueOf : undefined,
        symbolToString = symbolProto ? symbolProto.toString : undefined;

    /*------------------------------------------------------------------------*/

    /**
     * Creates a `lodash` object which wraps `value` to enable implicit method
     * chain sequences. Methods that operate on and return arrays, collections,
     * and functions can be chained together. Methods that retrieve a single value
     * or may return a primitive value will automatically end the chain sequence
     * and return the unwrapped value. Otherwise, the value must be unwrapped
     * with `_#value`.
     *
     * Explicit chain sequences, which must be unwrapped with `_#value`, may be
     * enabled using `_.chain`.
     *
     * The execution of chained methods is lazy, that is, it's deferred until
     * `_#value` is implicitly or explicitly called.
     *
     * Lazy evaluation allows several methods to support shortcut fusion.
     * Shortcut fusion is an optimization to merge iteratee calls; this avoids
     * the creation of intermediate arrays and can greatly reduce the number of
     * iteratee executions. Sections of a chain sequence qualify for shortcut
     * fusion if the section is applied to an array and iteratees accept only
     * one argument. The heuristic for whether a section qualifies for shortcut
     * fusion is subject to change.
     *
     * Chaining is supported in custom builds as long as the `_#value` method is
     * directly or indirectly included in the build.
     *
     * In addition to lodash methods, wrappers have `Array` and `String` methods.
     *
     * The wrapper `Array` methods are:
     * `concat`, `join`, `pop`, `push`, `shift`, `sort`, `splice`, and `unshift`
     *
     * The wrapper `String` methods are:
     * `replace` and `split`
     *
     * The wrapper methods that support shortcut fusion are:
     * `at`, `compact`, `drop`, `dropRight`, `dropWhile`, `filter`, `find`,
     * `findLast`, `head`, `initial`, `last`, `map`, `reject`, `reverse`, `slice`,
     * `tail`, `take`, `takeRight`, `takeRightWhile`, `takeWhile`, and `toArray`
     *
     * The chainable wrapper methods are:
     * `after`, `ary`, `assign`, `assignIn`, `assignInWith`, `assignWith`, `at`,
     * `before`, `bind`, `bindAll`, `bindKey`, `castArray`, `chain`, `chunk`,
     * `commit`, `compact`, `concat`, `conforms`, `constant`, `countBy`, `create`,
     * `curry`, `debounce`, `defaults`, `defaultsDeep`, `defer`, `delay`,
     * `difference`, `differenceBy`, `differenceWith`, `drop`, `dropRight`,
     * `dropRightWhile`, `dropWhile`, `extend`, `extendWith`, `fill`, `filter`,
     * `flatMap`, `flatMapDeep`, `flatMapDepth`, `flatten`, `flattenDeep`,
     * `flattenDepth`, `flip`, `flow`, `flowRight`, `fromPairs`, `functions`,
     * `functionsIn`, `groupBy`, `initial`, `intersection`, `intersectionBy`,
     * `intersectionWith`, `invert`, `invertBy`, `invokeMap`, `iteratee`, `keyBy`,
     * `keys`, `keysIn`, `map`, `mapKeys`, `mapValues`, `matches`, `matchesProperty`,
     * `memoize`, `merge`, `mergeWith`, `method`, `methodOf`, `mixin`, `negate`,
     * `nthArg`, `omit`, `omitBy`, `once`, `orderBy`, `over`, `overArgs`,
     * `overEvery`, `overSome`, `partial`, `partialRight`, `partition`, `pick`,
     * `pickBy`, `plant`, `property`, `propertyOf`, `pull`, `pullAll`, `pullAllBy`,
     * `pullAllWith`, `pullAt`, `push`, `range`, `rangeRight`, `rearg`, `reject`,
     * `remove`, `rest`, `reverse`, `sampleSize`, `set`, `setWith`, `shuffle`,
     * `slice`, `sort`, `sortBy`, `splice`, `spread`, `tail`, `take`, `takeRight`,
     * `takeRightWhile`, `takeWhile`, `tap`, `throttle`, `thru`, `toArray`,
     * `toPairs`, `toPairsIn`, `toPath`, `toPlainObject`, `transform`, `unary`,
     * `union`, `unionBy`, `unionWith`, `uniq`, `uniqBy`, `uniqWith`, `unset`,
     * `unshift`, `unzip`, `unzipWith`, `update`, `updateWith`, `values`,
     * `valuesIn`, `without`, `wrap`, `xor`, `xorBy`, `xorWith`, `zip`,
     * `zipObject`, `zipObjectDeep`, and `zipWith`
     *
     * The wrapper methods that are **not** chainable by default are:
     * `add`, `attempt`, `camelCase`, `capitalize`, `ceil`, `clamp`, `clone`,
     * `cloneDeep`, `cloneDeepWith`, `cloneWith`, `conformsTo`, `deburr`,
     * `defaultTo`, `divide`, `each`, `eachRight`, `endsWith`, `eq`, `escape`,
     * `escapeRegExp`, `every`, `find`, `findIndex`, `findKey`, `findLast`,
     * `findLastIndex`, `findLastKey`, `first`, `floor`, `forEach`, `forEachRight`,
     * `forIn`, `forInRight`, `forOwn`, `forOwnRight`, `get`, `gt`, `gte`, `has`,
     * `hasIn`, `head`, `identity`, `includes`, `indexOf`, `inRange`, `invoke`,
     * `isArguments`, `isArray`, `isArrayBuffer`, `isArrayLike`, `isArrayLikeObject`,
     * `isBoolean`, `isBuffer`, `isDate`, `isElement`, `isEmpty`, `isEqual`,
     * `isEqualWith`, `isError`, `isFinite`, `isFunction`, `isInteger`, `isLength`,
     * `isMap`, `isMatch`, `isMatchWith`, `isNaN`, `isNative`, `isNil`, `isNull`,
     * `isNumber`, `isObject`, `isObjectLike`, `isPlainObject`, `isRegExp`,
     * `isSafeInteger`, `isSet`, `isString`, `isUndefined`, `isTypedArray`,
     * `isWeakMap`, `isWeakSet`, `join`, `kebabCase`, `last`, `lastIndexOf`,
     * `lowerCase`, `lowerFirst`, `lt`, `lte`, `max`, `maxBy`, `mean`, `meanBy`,
     * `min`, `minBy`, `multiply`, `noConflict`, `noop`, `now`, `nth`, `pad`,
     * `padEnd`, `padStart`, `parseInt`, `pop`, `random`, `reduce`, `reduceRight`,
     * `repeat`, `result`, `round`, `runInContext`, `sample`, `shift`, `size`,
     * `snakeCase`, `some`, `sortedIndex`, `sortedIndexBy`, `sortedLastIndex`,
     * `sortedLastIndexBy`, `startCase`, `startsWith`, `stubArray`, `stubFalse`,
     * `stubObject`, `stubString`, `stubTrue`, `subtract`, `sum`, `sumBy`,
     * `template`, `times`, `toFinite`, `toInteger`, `toJSON`, `toLength`,
     * `toLower`, `toNumber`, `toSafeInteger`, `toString`, `toUpper`, `trim`,
     * `trimEnd`, `trimStart`, `truncate`, `unescape`, `uniqueId`, `upperCase`,
     * `upperFirst`, `value`, and `words`
     *
     * @name _
     * @constructor
     * @category Seq
     * @param {*} value The value to wrap in a `lodash` instance.
     * @returns {Object} Returns the new `lodash` wrapper instance.
     * @example
     *
     * function square(n) {
     *   return n * n;
     * }
     *
     * var wrapped = _([1, 2, 3]);
     *
     * // Returns an unwrapped value.
     * wrapped.reduce(_.add);
     * // => 6
     *
     * // Returns a wrapped value.
     * var squares = wrapped.map(square);
     *
     * _.isArray(squares);
     * // => false
     *
     * _.isArray(squares.value());
     * // => true
     */
    function lodash(value) {
      if (isObjectLike(value) && !isArray(value) && !(value instanceof LazyWrapper)) {
        if (value instanceof LodashWrapper) {
          return value;
        }
        if (hasOwnProperty.call(value, '__wrapped__')) {
          return wrapperClone(value);
        }
      }
      return new LodashWrapper(value);
    }

    /**
     * The base implementation of `_.create` without support for assigning
     * properties to the created object.
     *
     * @private
     * @param {Object} proto The object to inherit from.
     * @returns {Object} Returns the new object.
     */
    var baseCreate = (function() {
      function object() {}
      return function(proto) {
        if (!isObject(proto)) {
          return {};
        }
        if (objectCreate) {
          return objectCreate(proto);
        }
        object.prototype = proto;
        var result = new object;
        object.prototype = undefined;
        return result;
      };
    }());

    /**
     * The function whose prototype chain sequence wrappers inherit from.
     *
     * @private
     */
    function baseLodash() {
      // No operation performed.
    }

    /**
     * The base constructor for creating `lodash` wrapper objects.
     *
     * @private
     * @param {*} value The value to wrap.
     * @param {boolean} [chainAll] Enable explicit method chain sequences.
     */
    function LodashWrapper(value, chainAll) {
      this.__wrapped__ = value;
      this.__actions__ = [];
      this.__chain__ = !!chainAll;
      this.__index__ = 0;
      this.__values__ = undefined;
    }

    /**
     * By default, the template delimiters used by lodash are like those in
     * embedded Ruby (ERB) as well as ES2015 template strings. Change the
     * following template settings to use alternative delimiters.
     *
     * @static
     * @memberOf _
     * @type {Object}
     */
    lodash.templateSettings = {

      /**
       * Used to detect `data` property values to be HTML-escaped.
       *
       * @memberOf _.templateSettings
       * @type {RegExp}
       */
      'escape': reEscape,

      /**
       * Used to detect code to be evaluated.
       *
       * @memberOf _.templateSettings
       * @type {RegExp}
       */
      'evaluate': reEvaluate,

      /**
       * Used to detect `data` property values to inject.
       *
       * @memberOf _.templateSettings
       * @type {RegExp}
       */
      'interpolate': reInterpolate,

      /**
       * Used to reference the data object in the template text.
       *
       * @memberOf _.templateSettings
       * @type {string}
       */
      'variable': '',

      /**
       * Used to import variables into the compiled template.
       *
       * @memberOf _.templateSettings
       * @type {Object}
       */
      'imports': {

        /**
         * A reference to the `lodash` function.
         *
         * @memberOf _.templateSettings.imports
         * @type {Function}
         */
        '_': lodash
      }
    };

    // Ensure wrappers are instances of `baseLodash`.
    lodash.prototype = baseLodash.prototype;
    lodash.prototype.constructor = lodash;

    LodashWrapper.prototype = baseCreate(baseLodash.prototype);
    LodashWrapper.prototype.constructor = LodashWrapper;

    /*------------------------------------------------------------------------*/

    /**
     * Creates a lazy wrapper object which wraps `value` to enable lazy evaluation.
     *
     * @private
     * @constructor
     * @param {*} value The value to wrap.
     */
    function LazyWrapper(value) {
      this.__wrapped__ = value;
      this.__actions__ = [];
      this.__dir__ = 1;
      this.__filtered__ = false;
      this.__iteratees__ = [];
      this.__takeCount__ = MAX_ARRAY_LENGTH;
      this.__views__ = [];
    }

    /**
     * Creates a clone of the lazy wrapper object.
     *
     * @private
     * @name clone
     * @memberOf LazyWrapper
     * @returns {Object} Returns the cloned `LazyWrapper` object.
     */
    function lazyClone() {
      var result = new LazyWrapper(this.__wrapped__);
      result.__actions__ = copyArray(this.__actions__);
      result.__dir__ = this.__dir__;
      result.__filtered__ = this.__filtered__;
      result.__iteratees__ = copyArray(this.__iteratees__);
      result.__takeCount__ = this.__takeCount__;
      result.__views__ = copyArray(this.__views__);
      return result;
    }

    /**
     * Reverses the direction of lazy iteration.
     *
     * @private
     * @name reverse
     * @memberOf LazyWrapper
     * @returns {Object} Returns the new reversed `LazyWrapper` object.
     */
    function lazyReverse() {
      if (this.__filtered__) {
        var result = new LazyWrapper(this);
        result.__dir__ = -1;
        result.__filtered__ = true;
      } else {
        result = this.clone();
        result.__dir__ *= -1;
      }
      return result;
    }

    /**
     * Extracts the unwrapped value from its lazy wrapper.
     *
     * @private
     * @name value
     * @memberOf LazyWrapper
     * @returns {*} Returns the unwrapped value.
     */
    function lazyValue() {
      var array = this.__wrapped__.value(),
          dir = this.__dir__,
          isArr = isArray(array),
          isRight = dir < 0,
          arrLength = isArr ? array.length : 0,
          view = getView(0, arrLength, this.__views__),
          start = view.start,
          end = view.end,
          length = end - start,
          index = isRight ? end : (start - 1),
          iteratees = this.__iteratees__,
          iterLength = iteratees.length,
          resIndex = 0,
          takeCount = nativeMin(length, this.__takeCount__);

      if (!isArr || (!isRight && arrLength == length && takeCount == length)) {
        return baseWrapperValue(array, this.__actions__);
      }
      var result = [];

      outer:
      while (length-- && resIndex < takeCount) {
        index += dir;

        var iterIndex = -1,
            value = array[index];

        while (++iterIndex < iterLength) {
          var data = iteratees[iterIndex],
              iteratee = data.iteratee,
              type = data.type,
              computed = iteratee(value);

          if (type == LAZY_MAP_FLAG) {
            value = computed;
          } else if (!computed) {
            if (type == LAZY_FILTER_FLAG) {
              continue outer;
            } else {
              break outer;
            }
          }
        }
        result[resIndex++] = value;
      }
      return result;
    }

    // Ensure `LazyWrapper` is an instance of `baseLodash`.
    LazyWrapper.prototype = baseCreate(baseLodash.prototype);
    LazyWrapper.prototype.constructor = LazyWrapper;

    /*------------------------------------------------------------------------*/

    /**
     * Creates a hash object.
     *
     * @private
     * @constructor
     * @param {Array} [entries] The key-value pairs to cache.
     */
    function Hash(entries) {
      var index = -1,
          length = entries == null ? 0 : entries.length;

      this.clear();
      while (++index < length) {
        var entry = entries[index];
        this.set(entry[0], entry[1]);
      }
    }

    /**
     * Removes all key-value entries from the hash.
     *
     * @private
     * @name clear
     * @memberOf Hash
     */
    function hashClear() {
      this.__data__ = nativeCreate ? nativeCreate(null) : {};
      this.size = 0;
    }

    /**
     * Removes `key` and its value from the hash.
     *
     * @private
     * @name delete
     * @memberOf Hash
     * @param {Object} hash The hash to modify.
     * @param {string} key The key of the value to remove.
     * @returns {boolean} Returns `true` if the entry was removed, else `false`.
     */
    function hashDelete(key) {
      var result = this.has(key) && delete this.__data__[key];
      this.size -= result ? 1 : 0;
      return result;
    }

    /**
     * Gets the hash value for `key`.
     *
     * @private
     * @name get
     * @memberOf Hash
     * @param {string} key The key of the value to get.
     * @returns {*} Returns the entry value.
     */
    function hashGet(key) {
      var data = this.__data__;
      if (nativeCreate) {
        var result = data[key];
        return result === HASH_UNDEFINED ? undefined : result;
      }
      return hasOwnProperty.call(data, key) ? data[key] : undefined;
    }

    /**
     * Checks if a hash value for `key` exists.
     *
     * @private
     * @name has
     * @memberOf Hash
     * @param {string} key The key of the entry to check.
     * @returns {boolean} Returns `true` if an entry for `key` exists, else `false`.
     */
    function hashHas(key) {
      var data = this.__data__;
      return nativeCreate ? (data[key] !== undefined) : hasOwnProperty.call(data, key);
    }

    /**
     * Sets the hash `key` to `value`.
     *
     * @private
     * @name set
     * @memberOf Hash
     * @param {string} key The key of the value to set.
     * @param {*} value The value to set.
     * @returns {Object} Returns the hash instance.
     */
    function hashSet(key, value) {
      var data = this.__data__;
      this.size += this.has(key) ? 0 : 1;
      data[key] = (nativeCreate && value === undefined) ? HASH_UNDEFINED : value;
      return this;
    }

    // Add methods to `Hash`.
    Hash.prototype.clear = hashClear;
    Hash.prototype['delete'] = hashDelete;
    Hash.prototype.get = hashGet;
    Hash.prototype.has = hashHas;
    Hash.prototype.set = hashSet;

    /*------------------------------------------------------------------------*/

    /**
     * Creates an list cache object.
     *
     * @private
     * @constructor
     * @param {Array} [entries] The key-value pairs to cache.
     */
    function ListCache(entries) {
      var index = -1,
          length = entries == null ? 0 : entries.length;

      this.clear();
      while (++index < length) {
        var entry = entries[index];
        this.set(entry[0], entry[1]);
      }
    }

    /**
     * Removes all key-value entries from the list cache.
     *
     * @private
     * @name clear
     * @memberOf ListCache
     */
    function listCacheClear() {
      this.__data__ = [];
      this.size = 0;
    }

    /**
     * Removes `key` and its value from the list cache.
     *
     * @private
     * @name delete
     * @memberOf ListCache
     * @param {string} key The key of the value to remove.
     * @returns {boolean} Returns `true` if the entry was removed, else `false`.
     */
    function listCacheDelete(key) {
      var data = this.__data__,
          index = assocIndexOf(data, key);

      if (index < 0) {
        return false;
      }
      var lastIndex = data.length - 1;
      if (index == lastIndex) {
        data.pop();
      } else {
        splice.call(data, index, 1);
      }
      --this.size;
      return true;
    }

    /**
     * Gets the list cache value for `key`.
     *
     * @private
     * @name get
     * @memberOf ListCache
     * @param {string} key The key of the value to get.
     * @returns {*} Returns the entry value.
     */
    function listCacheGet(key) {
      var data = this.__data__,
          index = assocIndexOf(data, key);

      return index < 0 ? undefined : data[index][1];
    }

    /**
     * Checks if a list cache value for `key` exists.
     *
     * @private
     * @name has
     * @memberOf ListCache
     * @param {string} key The key of the entry to check.
     * @returns {boolean} Returns `true` if an entry for `key` exists, else `false`.
     */
    function listCacheHas(key) {
      return assocIndexOf(this.__data__, key) > -1;
    }

    /**
     * Sets the list cache `key` to `value`.
     *
     * @private
     * @name set
     * @memberOf ListCache
     * @param {string} key The key of the value to set.
     * @param {*} value The value to set.
     * @returns {Object} Returns the list cache instance.
     */
    function listCacheSet(key, value) {
      var data = this.__data__,
          index = assocIndexOf(data, key);

      if (index < 0) {
        ++this.size;
        data.push([key, value]);
      } else {
        data[index][1] = value;
      }
      return this;
    }

    // Add methods to `ListCache`.
    ListCache.prototype.clear = listCacheClear;
    ListCache.prototype['delete'] = listCacheDelete;
    ListCache.prototype.get = listCacheGet;
    ListCache.prototype.has = listCacheHas;
    ListCache.prototype.set = listCacheSet;

    /*------------------------------------------------------------------------*/

    /**
     * Creates a map cache object to store key-value pairs.
     *
     * @private
     * @constructor
     * @param {Array} [entries] The key-value pairs to cache.
     */
    function MapCache(entries) {
      var index = -1,
          length = entries == null ? 0 : entries.length;

      this.clear();
      while (++index < length) {
        var entry = entries[index];
        this.set(entry[0], entry[1]);
      }
    }

    /**
     * Removes all key-value entries from the map.
     *
     * @private
     * @name clear
     * @memberOf MapCache
     */
    function mapCacheClear() {
      this.size = 0;
      this.__data__ = {
        'hash': new Hash,
        'map': new (Map || ListCache),
        'string': new Hash
      };
    }

    /**
     * Removes `key` and its value from the map.
     *
     * @private
     * @name delete
     * @memberOf MapCache
     * @param {string} key The key of the value to remove.
     * @returns {boolean} Returns `true` if the entry was removed, else `false`.
     */
    function mapCacheDelete(key) {
      var result = getMapData(this, key)['delete'](key);
      this.size -= result ? 1 : 0;
      return result;
    }

    /**
     * Gets the map value for `key`.
     *
     * @private
     * @name get
     * @memberOf MapCache
     * @param {string} key The key of the value to get.
     * @returns {*} Returns the entry value.
     */
    function mapCacheGet(key) {
      return getMapData(this, key).get(key);
    }

    /**
     * Checks if a map value for `key` exists.
     *
     * @private
     * @name has
     * @memberOf MapCache
     * @param {string} key The key of the entry to check.
     * @returns {boolean} Returns `true` if an entry for `key` exists, else `false`.
     */
    function mapCacheHas(key) {
      return getMapData(this, key).has(key);
    }

    /**
     * Sets the map `key` to `value`.
     *
     * @private
     * @name set
     * @memberOf MapCache
     * @param {string} key The key of the value to set.
     * @param {*} value The value to set.
     * @returns {Object} Returns the map cache instance.
     */
    function mapCacheSet(key, value) {
      var data = getMapData(this, key),
          size = data.size;

      data.set(key, value);
      this.size += data.size == size ? 0 : 1;
      return this;
    }

    // Add methods to `MapCache`.
    MapCache.prototype.clear = mapCacheClear;
    MapCache.prototype['delete'] = mapCacheDelete;
    MapCache.prototype.get = mapCacheGet;
    MapCache.prototype.has = mapCacheHas;
    MapCache.prototype.set = mapCacheSet;

    /*------------------------------------------------------------------------*/

    /**
     *
     * Creates an array cache object to store unique values.
     *
     * @private
     * @constructor
     * @param {Array} [values] The values to cache.
     */
    function SetCache(values) {
      var index = -1,
          length = values == null ? 0 : values.length;

      this.__data__ = new MapCache;
      while (++index < length) {
        this.add(values[index]);
      }
    }

    /**
     * Adds `value` to the array cache.
     *
     * @private
     * @name add
     * @memberOf SetCache
     * @alias push
     * @param {*} value The value to cache.
     * @returns {Object} Returns the cache instance.
     */
    function setCacheAdd(value) {
      this.__data__.set(value, HASH_UNDEFINED);
      return this;
    }

    /**
     * Checks if `value` is in the array cache.
     *
     * @private
     * @name has
     * @memberOf SetCache
     * @param {*} value The value to search for.
     * @returns {number} Returns `true` if `value` is found, else `false`.
     */
    function setCacheHas(value) {
      return this.__data__.has(value);
    }

    // Add methods to `SetCache`.
    SetCache.prototype.add = SetCache.prototype.push = setCacheAdd;
    SetCache.prototype.has = setCacheHas;

    /*------------------------------------------------------------------------*/

    /**
     * Creates a stack cache object to store key-value pairs.
     *
     * @private
     * @constructor
     * @param {Array} [entries] The key-value pairs to cache.
     */
    function Stack(entries) {
      var data = this.__data__ = new ListCache(entries);
      this.size = data.size;
    }

    /**
     * Removes all key-value entries from the stack.
     *
     * @private
     * @name clear
     * @memberOf Stack
     */
    function stackClear() {
      this.__data__ = new ListCache;
      this.size = 0;
    }

    /**
     * Removes `key` and its value from the stack.
     *
     * @private
     * @name delete
     * @memberOf Stack
     * @param {string} key The key of the value to remove.
     * @returns {boolean} Returns `true` if the entry was removed, else `false`.
     */
    function stackDelete(key) {
      var data = this.__data__,
          result = data['delete'](key);

      this.size = data.size;
      return result;
    }

    /**
     * Gets the stack value for `key`.
     *
     * @private
     * @name get
     * @memberOf Stack
     * @param {string} key The key of the value to get.
     * @returns {*} Returns the entry value.
     */
    function stackGet(key) {
      return this.__data__.get(key);
    }

    /**
     * Checks if a stack value for `key` exists.
     *
     * @private
     * @name has
     * @memberOf Stack
     * @param {string} key The key of the entry to check.
     * @returns {boolean} Returns `true` if an entry for `key` exists, else `false`.
     */
    function stackHas(key) {
      return this.__data__.has(key);
    }

    /**
     * Sets the stack `key` to `value`.
     *
     * @private
     * @name set
     * @memberOf Stack
     * @param {string} key The key of the value to set.
     * @param {*} value The value to set.
     * @returns {Object} Returns the stack cache instance.
     */
    function stackSet(key, value) {
      var data = this.__data__;
      if (data instanceof ListCache) {
        var pairs = data.__data__;
        if (!Map || (pairs.length < LARGE_ARRAY_SIZE - 1)) {
          pairs.push([key, value]);
          this.size = ++data.size;
          return this;
        }
        data = this.__data__ = new MapCache(pairs);
      }
      data.set(key, value);
      this.size = data.size;
      return this;
    }

    // Add methods to `Stack`.
    Stack.prototype.clear = stackClear;
    Stack.prototype['delete'] = stackDelete;
    Stack.prototype.get = stackGet;
    Stack.prototype.has = stackHas;
    Stack.prototype.set = stackSet;

    /*------------------------------------------------------------------------*/

    /**
     * Creates an array of the enumerable property names of the array-like `value`.
     *
     * @private
     * @param {*} value The value to query.
     * @param {boolean} inherited Specify returning inherited property names.
     * @returns {Array} Returns the array of property names.
     */
    function arrayLikeKeys(value, inherited) {
      var isArr = isArray(value),
          isArg = !isArr && isArguments(value),
          isBuff = !isArr && !isArg && isBuffer(value),
          isType = !isArr && !isArg && !isBuff && isTypedArray(value),
          skipIndexes = isArr || isArg || isBuff || isType,
          result = skipIndexes ? baseTimes(value.length, String) : [],
          length = result.length;

      for (var key in value) {
        if ((inherited || hasOwnProperty.call(value, key)) &&
            !(skipIndexes && (
               // Safari 9 has enumerable `arguments.length` in strict mode.
               key == 'length' ||
               // Node.js 0.10 has enumerable non-index properties on buffers.
               (isBuff && (key == 'offset' || key == 'parent')) ||
               // PhantomJS 2 has enumerable non-index properties on typed arrays.
               (isType && (key == 'buffer' || key == 'byteLength' || key == 'byteOffset')) ||
               // Skip index properties.
               isIndex(key, length)
            ))) {
          result.push(key);
        }
      }
      return result;
    }

    /**
     * A specialized version of `_.sample` for arrays.
     *
     * @private
     * @param {Array} array The array to sample.
     * @returns {*} Returns the random element.
     */
    function arraySample(array) {
      var length = array.length;
      return length ? array[baseRandom(0, length - 1)] : undefined;
    }

    /**
     * A specialized version of `_.sampleSize` for arrays.
     *
     * @private
     * @param {Array} array The array to sample.
     * @param {number} n The number of elements to sample.
     * @returns {Array} Returns the random elements.
     */
    function arraySampleSize(array, n) {
      return shuffleSelf(copyArray(array), baseClamp(n, 0, array.length));
    }

    /**
     * A specialized version of `_.shuffle` for arrays.
     *
     * @private
     * @param {Array} array The array to shuffle.
     * @returns {Array} Returns the new shuffled array.
     */
    function arrayShuffle(array) {
      return shuffleSelf(copyArray(array));
    }

    /**
     * This function is like `assignValue` except that it doesn't assign
     * `undefined` values.
     *
     * @private
     * @param {Object} object The object to modify.
     * @param {string} key The key of the property to assign.
     * @param {*} value The value to assign.
     */
    function assignMergeValue(object, key, value) {
      if ((value !== undefined && !eq(object[key], value)) ||
          (value === undefined && !(key in object))) {
        baseAssignValue(object, key, value);
      }
    }

    /**
     * Assigns `value` to `key` of `object` if the existing value is not equivalent
     * using [`SameValueZero`](http://ecma-international.org/ecma-262/7.0/#sec-samevaluezero)
     * for equality comparisons.
     *
     * @private
     * @param {Object} object The object to modify.
     * @param {string} key The key of the property to assign.
     * @param {*} value The value to assign.
     */
    function assignValue(object, key, value) {
      var objValue = object[key];
      if (!(hasOwnProperty.call(object, key) && eq(objValue, value)) ||
          (value === undefined && !(key in object))) {
        baseAssignValue(object, key, value);
      }
    }

    /**
     * Gets the index at which the `key` is found in `array` of key-value pairs.
     *
     * @private
     * @param {Array} array The array to inspect.
     * @param {*} key The key to search for.
     * @returns {number} Returns the index of the matched value, else `-1`.
     */
    function assocIndexOf(array, key) {
      var length = array.length;
      while (length--) {
        if (eq(array[length][0], key)) {
          return length;
        }
      }
      return -1;
    }

    /**
     * Aggregates elements of `collection` on `accumulator` with keys transformed
     * by `iteratee` and values set by `setter`.
     *
     * @private
     * @param {Array|Object} collection The collection to iterate over.
     * @param {Function} setter The function to set `accumulator` values.
     * @param {Function} iteratee The iteratee to transform keys.
     * @param {Object} accumulator The initial aggregated object.
     * @returns {Function} Returns `accumulator`.
     */
    function baseAggregator(collection, setter, iteratee, accumulator) {
      baseEach(collection, function(value, key, collection) {
        setter(accumulator, value, iteratee(value), collection);
      });
      return accumulator;
    }

    /**
     * The base implementation of `_.assign` without support for multiple sources
     * or `customizer` functions.
     *
     * @private
     * @param {Object} object The destination object.
     * @param {Object} source The source object.
     * @returns {Object} Returns `object`.
     */
    function baseAssign(object, source) {
      return object && copyObject(source, keys(source), object);
    }

    /**
     * The base implementation of `_.assignIn` without support for multiple sources
     * or `customizer` functions.
     *
     * @private
     * @param {Object} object The destination object.
     * @param {Object} source The source object.
     * @returns {Object} Returns `object`.
     */
    function baseAssignIn(object, source) {
      return object && copyObject(source, keysIn(source), object);
    }

    /**
     * The base implementation of `assignValue` and `assignMergeValue` without
     * value checks.
     *
     * @private
     * @param {Object} object The object to modify.
     * @param {string} key The key of the property to assign.
     * @param {*} value The value to assign.
     */
    function baseAssignValue(object, key, value) {
      if (key == '__proto__' && defineProperty) {
        defineProperty(object, key, {
          'configurable': true,
          'enumerable': true,
          'value': value,
          'writable': true
        });
      } else {
        object[key] = value;
      }
    }

    /**
     * The base implementation of `_.at` without support for individual paths.
     *
     * @private
     * @param {Object} object The object to iterate over.
     * @param {string[]} paths The property paths to pick.
     * @returns {Array} Returns the picked elements.
     */
    function baseAt(object, paths) {
      var index = -1,
          length = paths.length,
          result = Array(length),
          skip = object == null;

      while (++index < length) {
        result[index] = skip ? undefined : get(object, paths[index]);
      }
      return result;
    }

    /**
     * The base implementation of `_.clamp` which doesn't coerce arguments.
     *
     * @private
     * @param {number} number The number to clamp.
     * @param {number} [lower] The lower bound.
     * @param {number} upper The upper bound.
     * @returns {number} Returns the clamped number.
     */
    function baseClamp(number, lower, upper) {
      if (number === number) {
        if (upper !== undefined) {
          number = number <= upper ? number : upper;
        }
        if (lower !== undefined) {
          number = number >= lower ? number : lower;
        }
      }
      return number;
    }

    /**
     * The base implementation of `_.clone` and `_.cloneDeep` which tracks
     * traversed objects.
     *
     * @private
     * @param {*} value The value to clone.
     * @param {boolean} bitmask The bitmask flags.
     *  1 - Deep clone
     *  2 - Flatten inherited properties
     *  4 - Clone symbols
     * @param {Function} [customizer] The function to customize cloning.
     * @param {string} [key] The key of `value`.
     * @param {Object} [object] The parent object of `value`.
     * @param {Object} [stack] Tracks traversed objects and their clone counterparts.
     * @returns {*} Returns the cloned value.
     */
    function baseClone(value, bitmask, customizer, key, object, stack) {
      var result,
          isDeep = bitmask & CLONE_DEEP_FLAG,
          isFlat = bitmask & CLONE_FLAT_FLAG,
          isFull = bitmask & CLONE_SYMBOLS_FLAG;

      if (customizer) {
        result = object ? customizer(value, key, object, stack) : customizer(value);
      }
      if (result !== undefined) {
        return result;
      }
      if (!isObject(value)) {
        return value;
      }
      var isArr = isArray(value);
      if (isArr) {
        result = initCloneArray(value);
        if (!isDeep) {
          return copyArray(value, result);
        }
      } else {
        var tag = getTag(value),
            isFunc = tag == funcTag || tag == genTag;

        if (isBuffer(value)) {
          return cloneBuffer(value, isDeep);
        }
        if (tag == objectTag || tag == argsTag || (isFunc && !object)) {
          result = (isFlat || isFunc) ? {} : initCloneObject(value);
          if (!isDeep) {
            return isFlat
              ? copySymbolsIn(value, baseAssignIn(result, value))
              : copySymbols(value, baseAssign(result, value));
          }
        } else {
          if (!cloneableTags[tag]) {
            return object ? value : {};
          }
          result = initCloneByTag(value, tag, isDeep);
        }
      }
      // Check for circular references and return its corresponding clone.
      stack || (stack = new Stack);
      var stacked = stack.get(value);
      if (stacked) {
        return stacked;
      }
      stack.set(value, result);

      if (isSet(value)) {
        value.forEach(function(subValue) {
          result.add(baseClone(subValue, bitmask, customizer, subValue, value, stack));
        });
      } else if (isMap(value)) {
        value.forEach(function(subValue, key) {
          result.set(key, baseClone(subValue, bitmask, customizer, key, value, stack));
        });
      }

      var keysFunc = isFull
        ? (isFlat ? getAllKeysIn : getAllKeys)
        : (isFlat ? keysIn : keys);

      var props = isArr ? undefined : keysFunc(value);
      arrayEach(props || value, function(subValue, key) {
        if (props) {
          key = subValue;
          subValue = value[key];
        }
        // Recursively populate clone (susceptible to call stack limits).
        assignValue(result, key, baseClone(subValue, bitmask, customizer, key, value, stack));
      });
      return result;
    }

    /**
     * The base implementation of `_.conforms` which doesn't clone `source`.
     *
     * @private
     * @param {Object} source The object of property predicates to conform to.
     * @returns {Function} Returns the new spec function.
     */
    function baseConforms(source) {
      var props = keys(source);
      return function(object) {
        return baseConformsTo(object, source, props);
      };
    }

    /**
     * The base implementation of `_.conformsTo` which accepts `props` to check.
     *
     * @private
     * @param {Object} object The object to inspect.
     * @param {Object} source The object of property predicates to conform to.
     * @returns {boolean} Returns `true` if `object` conforms, else `false`.
     */
    function baseConformsTo(object, source, props) {
      var length = props.length;
      if (object == null) {
        return !length;
      }
      object = Object(object);
      while (length--) {
        var key = props[length],
            predicate = source[key],
            value = object[key];

        if ((value === undefined && !(key in object)) || !predicate(value)) {
          return false;
        }
      }
      return true;
    }

    /**
     * The base implementation of `_.delay` and `_.defer` which accepts `args`
     * to provide to `func`.
     *
     * @private
     * @param {Function} func The function to delay.
     * @param {number} wait The number of milliseconds to delay invocation.
     * @param {Array} args The arguments to provide to `func`.
     * @returns {number|Object} Returns the timer id or timeout object.
     */
    function baseDelay(func, wait, args) {
      if (typeof func != 'function') {
        throw new TypeError(FUNC_ERROR_TEXT);
      }
      return setTimeout(function() { func.apply(undefined, args); }, wait);
    }

    /**
     * The base implementation of methods like `_.difference` without support
     * for excluding multiple arrays or iteratee shorthands.
     *
     * @private
     * @param {Array} array The array to inspect.
     * @param {Array} values The values to exclude.
     * @param {Function} [iteratee] The iteratee invoked per element.
     * @param {Function} [comparator] The comparator invoked per element.
     * @returns {Array} Returns the new array of filtered values.
     */
    function baseDifference(array, values, iteratee, comparator) {
      var index = -1,
          includes = arrayIncludes,
          isCommon = true,
          length = array.length,
          result = [],
          valuesLength = values.length;

      if (!length) {
        return result;
      }
      if (iteratee) {
        values = arrayMap(values, baseUnary(iteratee));
      }
      if (comparator) {
        includes = arrayIncludesWith;
        isCommon = false;
      }
      else if (values.length >= LARGE_ARRAY_SIZE) {
        includes = cacheHas;
        isCommon = false;
        values = new SetCache(values);
      }
      outer:
      while (++index < length) {
        var value = array[index],
            computed = iteratee == null ? value : iteratee(value);

        value = (comparator || value !== 0) ? value : 0;
        if (isCommon && computed === computed) {
          var valuesIndex = valuesLength;
          while (valuesIndex--) {
            if (values[valuesIndex] === computed) {
              continue outer;
            }
          }
          result.push(value);
        }
        else if (!includes(values, computed, comparator)) {
          result.push(value);
        }
      }
      return result;
    }

    /**
     * The base implementation of `_.forEach` without support for iteratee shorthands.
     *
     * @private
     * @param {Array|Object} collection The collection to iterate over.
     * @param {Function} iteratee The function invoked per iteration.
     * @returns {Array|Object} Returns `collection`.
     */
    var baseEach = createBaseEach(baseForOwn);

    /**
     * The base implementation of `_.forEachRight` without support for iteratee shorthands.
     *
     * @private
     * @param {Array|Object} collection The collection to iterate over.
     * @param {Function} iteratee The function invoked per iteration.
     * @returns {Array|Object} Returns `collection`.
     */
    var baseEachRight = createBaseEach(baseForOwnRight, true);

    /**
     * The base implementation of `_.every` without support for iteratee shorthands.
     *
     * @private
     * @param {Array|Object} collection The collection to iterate over.
     * @param {Function} predicate The function invoked per iteration.
     * @returns {boolean} Returns `true` if all elements pass the predicate check,
     *  else `false`
     */
    function baseEvery(collection, predicate) {
      var result = true;
      baseEach(collection, function(value, index, collection) {
        result = !!predicate(value, index, collection);
        return result;
      });
      return result;
    }

    /**
     * The base implementation of methods like `_.max` and `_.min` which accepts a
     * `comparator` to determine the extremum value.
     *
     * @private
     * @param {Array} array The array to iterate over.
     * @param {Function} iteratee The iteratee invoked per iteration.
     * @param {Function} comparator The comparator used to compare values.
     * @returns {*} Returns the extremum value.
     */
    function baseExtremum(array, iteratee, comparator) {
      var index = -1,
          length = array.length;

      while (++index < length) {
        var value = array[index],
            current = iteratee(value);

        if (current != null && (computed === undefined
              ? (current === current && !isSymbol(current))
              : comparator(current, computed)
            )) {
          var computed = current,
              result = value;
        }
      }
      return result;
    }

    /**
     * The base implementation of `_.fill` without an iteratee call guard.
     *
     * @private
     * @param {Array} array The array to fill.
     * @param {*} value The value to fill `array` with.
     * @param {number} [start=0] The start position.
     * @param {number} [end=array.length] The end position.
     * @returns {Array} Returns `array`.
     */
    function baseFill(array, value, start, end) {
      var length = array.length;

      start = toInteger(start);
      if (start < 0) {
        start = -start > length ? 0 : (length + start);
      }
      end = (end === undefined || end > length) ? length : toInteger(end);
      if (end < 0) {
        end += length;
      }
      end = start > end ? 0 : toLength(end);
      while (start < end) {
        array[start++] = value;
      }
      return array;
    }

    /**
     * The base implementation of `_.filter` without support for iteratee shorthands.
     *
     * @private
     * @param {Array|Object} collection The collection to iterate over.
     * @param {Function} predicate The function invoked per iteration.
     * @returns {Array} Returns the new filtered array.
     */
    function baseFilter(collection, predicate) {
      var result = [];
      baseEach(collection, function(value, index, collection) {
        if (predicate(value, index, collection)) {
          result.push(value);
        }
      });
      return result;
    }

    /**
     * The base implementation of `_.flatten` with support for restricting flattening.
     *
     * @private
     * @param {Array} array The array to flatten.
     * @param {number} depth The maximum recursion depth.
     * @param {boolean} [predicate=isFlattenable] The function invoked per iteration.
     * @param {boolean} [isStrict] Restrict to values that pass `predicate` checks.
     * @param {Array} [result=[]] The initial result value.
     * @returns {Array} Returns the new flattened array.
     */
    function baseFlatten(array, depth, predicate, isStrict, result) {
      var index = -1,
          length = array.length;

      predicate || (predicate = isFlattenable);
      result || (result = []);

      while (++index < length) {
        var value = array[index];
        if (depth > 0 && predicate(value)) {
          if (depth > 1) {
            // Recursively flatten arrays (susceptible to call stack limits).
            baseFlatten(value, depth - 1, predicate, isStrict, result);
          } else {
            arrayPush(result, value);
          }
        } else if (!isStrict) {
          result[result.length] = value;
        }
      }
      return result;
    }

    /**
     * The base implementation of `baseForOwn` which iterates over `object`
     * properties returned by `keysFunc` and invokes `iteratee` for each property.
     * Iteratee functions may exit iteration early by explicitly returning `false`.
     *
     * @private
     * @param {Object} object The object to iterate over.
     * @param {Function} iteratee The function invoked per iteration.
     * @param {Function} keysFunc The function to get the keys of `object`.
     * @returns {Object} Returns `object`.
     */
    var baseFor = createBaseFor();

    /**
     * This function is like `baseFor` except that it iterates over properties
     * in the opposite order.
     *
     * @private
     * @param {Object} object The object to iterate over.
     * @param {Function} iteratee The function invoked per iteration.
     * @param {Function} keysFunc The function to get the keys of `object`.
     * @returns {Object} Returns `object`.
     */
    var baseForRight = createBaseFor(true);

    /**
     * The base implementation of `_.forOwn` without support for iteratee shorthands.
     *
     * @private
     * @param {Object} object The object to iterate over.
     * @param {Function} iteratee The function invoked per iteration.
     * @returns {Object} Returns `object`.
     */
    function baseForOwn(object, iteratee) {
      return object && baseFor(object, iteratee, keys);
    }

    /**
     * The base implementation of `_.forOwnRight` without support for iteratee shorthands.
     *
     * @private
     * @param {Object} object The object to iterate over.
     * @param {Function} iteratee The function invoked per iteration.
     * @returns {Object} Returns `object`.
     */
    function baseForOwnRight(object, iteratee) {
      return object && baseForRight(object, iteratee, keys);
    }

    /**
     * The base implementation of `_.functions` which creates an array of
     * `object` function property names filtered from `props`.
     *
     * @private
     * @param {Object} object The object to inspect.
     * @param {Array} props The property names to filter.
     * @returns {Array} Returns the function names.
     */
    function baseFunctions(object, props) {
      return arrayFilter(props, function(key) {
        return isFunction(object[key]);
      });
    }

    /**
     * The base implementation of `_.get` without support for default values.
     *
     * @private
     * @param {Object} object The object to query.
     * @param {Array|string} path The path of the property to get.
     * @returns {*} Returns the resolved value.
     */
    function baseGet(object, path) {
      path = castPath(path, object);

      var index = 0,
          length = path.length;

      while (object != null && index < length) {
        object = object[toKey(path[index++])];
      }
      return (index && index == length) ? object : undefined;
    }

    /**
     * The base implementation of `getAllKeys` and `getAllKeysIn` which uses
     * `keysFunc` and `symbolsFunc` to get the enumerable property names and
     * symbols of `object`.
     *
     * @private
     * @param {Object} object The object to query.
     * @param {Function} keysFunc The function to get the keys of `object`.
     * @param {Function} symbolsFunc The function to get the symbols of `object`.
     * @returns {Array} Returns the array of property names and symbols.
     */
    function baseGetAllKeys(object, keysFunc, symbolsFunc) {
      var result = keysFunc(object);
      return isArray(object) ? result : arrayPush(result, symbolsFunc(object));
    }

    /**
     * The base implementation of `getTag` without fallbacks for buggy environments.
     *
     * @private
     * @param {*} value The value to query.
     * @returns {string} Returns the `toStringTag`.
     */
    function baseGetTag(value) {
      if (value == null) {
        return value === undefined ? undefinedTag : nullTag;
      }
      return (symToStringTag && symToStringTag in Object(value))
        ? getRawTag(value)
        : objectToString(value);
    }

    /**
     * The base implementation of `_.gt` which doesn't coerce arguments.
     *
     * @private
     * @param {*} value The value to compare.
     * @param {*} other The other value to compare.
     * @returns {boolean} Returns `true` if `value` is greater than `other`,
     *  else `false`.
     */
    function baseGt(value, other) {
      return value > other;
    }

    /**
     * The base implementation of `_.has` without support for deep paths.
     *
     * @private
     * @param {Object} [object] The object to query.
     * @param {Array|string} key The key to check.
     * @returns {boolean} Returns `true` if `key` exists, else `false`.
     */
    function baseHas(object, key) {
      return object != null && hasOwnProperty.call(object, key);
    }

    /**
     * The base implementation of `_.hasIn` without support for deep paths.
     *
     * @private
     * @param {Object} [object] The object to query.
     * @param {Array|string} key The key to check.
     * @returns {boolean} Returns `true` if `key` exists, else `false`.
     */
    function baseHasIn(object, key) {
      return object != null && key in Object(object);
    }

    /**
     * The base implementation of `_.inRange` which doesn't coerce arguments.
     *
     * @private
     * @param {number} number The number to check.
     * @param {number} start The start of the range.
     * @param {number} end The end of the range.
     * @returns {boolean} Returns `true` if `number` is in the range, else `false`.
     */
    function baseInRange(number, start, end) {
      return number >= nativeMin(start, end) && number < nativeMax(start, end);
    }

    /**
     * The base implementation of methods like `_.intersection`, without support
     * for iteratee shorthands, that accepts an array of arrays to inspect.
     *
     * @private
     * @param {Array} arrays The arrays to inspect.
     * @param {Function} [iteratee] The iteratee invoked per element.
     * @param {Function} [comparator] The comparator invoked per element.
     * @returns {Array} Returns the new array of shared values.
     */
    function baseIntersection(arrays, iteratee, comparator) {
      var includes = comparator ? arrayIncludesWith : arrayIncludes,
          length = arrays[0].length,
          othLength = arrays.length,
          othIndex = othLength,
          caches = Array(othLength),
          maxLength = Infinity,
          result = [];

      while (othIndex--) {
        var array = arrays[othIndex];
        if (othIndex && iteratee) {
          array = arrayMap(array, baseUnary(iteratee));
        }
        maxLength = nativeMin(array.length, maxLength);
        caches[othIndex] = !comparator && (iteratee || (length >= 120 && array.length >= 120))
          ? new SetCache(othIndex && array)
          : undefined;
      }
      array = arrays[0];

      var index = -1,
          seen = caches[0];

      outer:
      while (++index < length && result.length < maxLength) {
        var value = array[index],
            computed = iteratee ? iteratee(value) : value;

        value = (comparator || value !== 0) ? value : 0;
        if (!(seen
              ? cacheHas(seen, computed)
              : includes(result, computed, comparator)
            )) {
          othIndex = othLength;
          while (--othIndex) {
            var cache = caches[othIndex];
            if (!(cache
                  ? cacheHas(cache, computed)
                  : includes(arrays[othIndex], computed, comparator))
                ) {
              continue outer;
            }
          }
          if (seen) {
            seen.push(computed);
          }
          result.push(value);
        }
      }
      return result;
    }

    /**
     * The base implementation of `_.invert` and `_.invertBy` which inverts
     * `object` with values transformed by `iteratee` and set by `setter`.
     *
     * @private
     * @param {Object} object The object to iterate over.
     * @param {Function} setter The function to set `accumulator` values.
     * @param {Function} iteratee The iteratee to transform values.
     * @param {Object} accumulator The initial inverted object.
     * @returns {Function} Returns `accumulator`.
     */
    function baseInverter(object, setter, iteratee, accumulator) {
      baseForOwn(object, function(value, key, object) {
        setter(accumulator, iteratee(value), key, object);
      });
      return accumulator;
    }

    /**
     * The base implementation of `_.invoke` without support for individual
     * method arguments.
     *
     * @private
     * @param {Object} object The object to query.
     * @param {Array|string} path The path of the method to invoke.
     * @param {Array} args The arguments to invoke the method with.
     * @returns {*} Returns the result of the invoked method.
     */
    function baseInvoke(object, path, args) {
      path = castPath(path, object);
      object = parent(object, path);
      var func = object == null ? object : object[toKey(last(path))];
      return func == null ? undefined : apply(func, object, args);
    }

    /**
     * The base implementation of `_.isArguments`.
     *
     * @private
     * @param {*} value The value to check.
     * @returns {boolean} Returns `true` if `value` is an `arguments` object,
     */
    function baseIsArguments(value) {
      return isObjectLike(value) && baseGetTag(value) == argsTag;
    }

    /**
     * The base implementation of `_.isArrayBuffer` without Node.js optimizations.
     *
     * @private
     * @param {*} value The value to check.
     * @returns {boolean} Returns `true` if `value` is an array buffer, else `false`.
     */
    function baseIsArrayBuffer(value) {
      return isObjectLike(value) && baseGetTag(value) == arrayBufferTag;
    }

    /**
     * The base implementation of `_.isDate` without Node.js optimizations.
     *
     * @private
     * @param {*} value The value to check.
     * @returns {boolean} Returns `true` if `value` is a date object, else `false`.
     */
    function baseIsDate(value) {
      return isObjectLike(value) && baseGetTag(value) == dateTag;
    }

    /**
     * The base implementation of `_.isEqual` which supports partial comparisons
     * and tracks traversed objects.
     *
     * @private
     * @param {*} value The value to compare.
     * @param {*} other The other value to compare.
     * @param {boolean} bitmask The bitmask flags.
     *  1 - Unordered comparison
     *  2 - Partial comparison
     * @param {Function} [customizer] The function to customize comparisons.
     * @param {Object} [stack] Tracks traversed `value` and `other` objects.
     * @returns {boolean} Returns `true` if the values are equivalent, else `false`.
     */
    function baseIsEqual(value, other, bitmask, customizer, stack) {
      if (value === other) {
        return true;
      }
      if (value == null || other == null || (!isObjectLike(value) && !isObjectLike(other))) {
        return value !== value && other !== other;
      }
      return baseIsEqualDeep(value, other, bitmask, customizer, baseIsEqual, stack);
    }

    /**
     * A specialized version of `baseIsEqual` for arrays and objects which performs
     * deep comparisons and tracks traversed objects enabling objects with circular
     * references to be compared.
     *
     * @private
     * @param {Object} object The object to compare.
     * @param {Object} other The other object to compare.
     * @param {number} bitmask The bitmask flags. See `baseIsEqual` for more details.
     * @param {Function} customizer The function to customize comparisons.
     * @param {Function} equalFunc The function to determine equivalents of values.
     * @param {Object} [stack] Tracks traversed `object` and `other` objects.
     * @returns {boolean} Returns `true` if the objects are equivalent, else `false`.
     */
    function baseIsEqualDeep(object, other, bitmask, customizer, equalFunc, stack) {
      var objIsArr = isArray(object),
          othIsArr = isArray(other),
          objTag = objIsArr ? arrayTag : getTag(object),
          othTag = othIsArr ? arrayTag : getTag(other);

      objTag = objTag == argsTag ? objectTag : objTag;
      othTag = othTag == argsTag ? objectTag : othTag;

      var objIsObj = objTag == objectTag,
          othIsObj = othTag == objectTag,
          isSameTag = objTag == othTag;

      if (isSameTag && isBuffer(object)) {
        if (!isBuffer(other)) {
          return false;
        }
        objIsArr = true;
        objIsObj = false;
      }
      if (isSameTag && !objIsObj) {
        stack || (stack = new Stack);
        return (objIsArr || isTypedArray(object))
          ? equalArrays(object, other, bitmask, customizer, equalFunc, stack)
          : equalByTag(object, other, objTag, bitmask, customizer, equalFunc, stack);
      }
      if (!(bitmask & COMPARE_PARTIAL_FLAG)) {
        var objIsWrapped = objIsObj && hasOwnProperty.call(object, '__wrapped__'),
            othIsWrapped = othIsObj && hasOwnProperty.call(other, '__wrapped__');

        if (objIsWrapped || othIsWrapped) {
          var objUnwrapped = objIsWrapped ? object.value() : object,
              othUnwrapped = othIsWrapped ? other.value() : other;

          stack || (stack = new Stack);
          return equalFunc(objUnwrapped, othUnwrapped, bitmask, customizer, stack);
        }
      }
      if (!isSameTag) {
        return false;
      }
      stack || (stack = new Stack);
      return equalObjects(object, other, bitmask, customizer, equalFunc, stack);
    }

    /**
     * The base implementation of `_.isMap` without Node.js optimizations.
     *
     * @private
     * @param {*} value The value to check.
     * @returns {boolean} Returns `true` if `value` is a map, else `false`.
     */
    function baseIsMap(value) {
      return isObjectLike(value) && getTag(value) == mapTag;
    }

    /**
     * The base implementation of `_.isMatch` without support for iteratee shorthands.
     *
     * @private
     * @param {Object} object The object to inspect.
     * @param {Object} source The object of property values to match.
     * @param {Array} matchData The property names, values, and compare flags to match.
     * @param {Function} [customizer] The function to customize comparisons.
     * @returns {boolean} Returns `true` if `object` is a match, else `false`.
     */
    function baseIsMatch(object, source, matchData, customizer) {
      var index = matchData.length,
          length = index,
          noCustomizer = !customizer;

      if (object == null) {
        return !length;
      }
      object = Object(object);
      while (index--) {
        var data = matchData[index];
        if ((noCustomizer && data[2])
              ? data[1] !== object[data[0]]
              : !(data[0] in object)
            ) {
          return false;
        }
      }
      while (++index < length) {
        data = matchData[index];
        var key = data[0],
            objValue = object[key],
            srcValue = data[1];

        if (noCustomizer && data[2]) {
          if (objValue === undefined && !(key in object)) {
            return false;
          }
        } else {
          var stack = new Stack;
          if (customizer) {
            var result = customizer(objValue, srcValue, key, object, source, stack);
          }
          if (!(result === undefined
                ? baseIsEqual(srcValue, objValue, COMPARE_PARTIAL_FLAG | COMPARE_UNORDERED_FLAG, customizer, stack)
                : result
              )) {
            return false;
          }
        }
      }
      return true;
    }

    /**
     * The base implementation of `_.isNative` without bad shim checks.
     *
     * @private
     * @param {*} value The value to check.
     * @returns {boolean} Returns `true` if `value` is a native function,
     *  else `false`.
     */
    function baseIsNative(value) {
      if (!isObject(value) || isMasked(value)) {
        return false;
      }
      var pattern = isFunction(value) ? reIsNative : reIsHostCtor;
      return pattern.test(toSource(value));
    }

    /**
     * The base implementation of `_.isRegExp` without Node.js optimizations.
     *
     * @private
     * @param {*} value The value to check.
     * @returns {boolean} Returns `true` if `value` is a regexp, else `false`.
     */
    function baseIsRegExp(value) {
      return isObjectLike(value) && baseGetTag(value) == regexpTag;
    }

    /**
     * The base implementation of `_.isSet` without Node.js optimizations.
     *
     * @private
     * @param {*} value The value to check.
     * @returns {boolean} Returns `true` if `value` is a set, else `false`.
     */
    function baseIsSet(value) {
      return isObjectLike(value) && getTag(value) == setTag;
    }

    /**
     * The base implementation of `_.isTypedArray` without Node.js optimizations.
     *
     * @private
     * @param {*} value The value to check.
     * @returns {boolean} Returns `true` if `value` is a typed array, else `false`.
     */
    function baseIsTypedArray(value) {
      return isObjectLike(value) &&
        isLength(value.length) && !!typedArrayTags[baseGetTag(value)];
    }

    /**
     * The base implementation of `_.iteratee`.
     *
     * @private
     * @param {*} [value=_.identity] The value to convert to an iteratee.
     * @returns {Function} Returns the iteratee.
     */
    function baseIteratee(value) {
      // Don't store the `typeof` result in a variable to avoid a JIT bug in Safari 9.
      // See https://bugs.webkit.org/show_bug.cgi?id=156034 for more details.
      if (typeof value == 'function') {
        return value;
      }
      if (value == null) {
        return identity;
      }
      if (typeof value == 'object') {
        return isArray(value)
          ? baseMatchesProperty(value[0], value[1])
          : baseMatches(value);
      }
      return property(value);
    }

    /**
     * The base implementation of `_.keys` which doesn't treat sparse arrays as dense.
     *
     * @private
     * @param {Object} object The object to query.
     * @returns {Array} Returns the array of property names.
     */
    function baseKeys(object) {
      if (!isPrototype(object)) {
        return nativeKeys(object);
      }
      var result = [];
      for (var key in Object(object)) {
        if (hasOwnProperty.call(object, key) && key != 'constructor') {
          result.push(key);
        }
      }
      return result;
    }

    /**
     * The base implementation of `_.keysIn` which doesn't treat sparse arrays as dense.
     *
     * @private
     * @param {Object} object The object to query.
     * @returns {Array} Returns the array of property names.
     */
    function baseKeysIn(object) {
      if (!isObject(object)) {
        return nativeKeysIn(object);
      }
      var isProto = isPrototype(object),
          result = [];

      for (var key in object) {
        if (!(key == 'constructor' && (isProto || !hasOwnProperty.call(object, key)))) {
          result.push(key);
        }
      }
      return result;
    }

    /**
     * The base implementation of `_.lt` which doesn't coerce arguments.
     *
     * @private
     * @param {*} value The value to compare.
     * @param {*} other The other value to compare.
     * @returns {boolean} Returns `true` if `value` is less than `other`,
     *  else `false`.
     */
    function baseLt(value, other) {
      return value < other;
    }

    /**
     * The base implementation of `_.map` without support for iteratee shorthands.
     *
     * @private
     * @param {Array|Object} collection The collection to iterate over.
     * @param {Function} iteratee The function invoked per iteration.
     * @returns {Array} Returns the new mapped array.
     */
    function baseMap(collection, iteratee) {
      var index = -1,
          result = isArrayLike(collection) ? Array(collection.length) : [];

      baseEach(collection, function(value, key, collection) {
        result[++index] = iteratee(value, key, collection);
      });
      return result;
    }

    /**
     * The base implementation of `_.matches` which doesn't clone `source`.
     *
     * @private
     * @param {Object} source The object of property values to match.
     * @returns {Function} Returns the new spec function.
     */
    function baseMatches(source) {
      var matchData = getMatchData(source);
      if (matchData.length == 1 && matchData[0][2]) {
        return matchesStrictComparable(matchData[0][0], matchData[0][1]);
      }
      return function(object) {
        return object === source || baseIsMatch(object, source, matchData);
      };
    }

    /**
     * The base implementation of `_.matchesProperty` which doesn't clone `srcValue`.
     *
     * @private
     * @param {string} path The path of the property to get.
     * @param {*} srcValue The value to match.
     * @returns {Function} Returns the new spec function.
     */
    function baseMatchesProperty(path, srcValue) {
      if (isKey(path) && isStrictComparable(srcValue)) {
        return matchesStrictComparable(toKey(path), srcValue);
      }
      return function(object) {
        var objValue = get(object, path);
        return (objValue === undefined && objValue === srcValue)
          ? hasIn(object, path)
          : baseIsEqual(srcValue, objValue, COMPARE_PARTIAL_FLAG | COMPARE_UNORDERED_FLAG);
      };
    }

    /**
     * The base implementation of `_.merge` without support for multiple sources.
     *
     * @private
     * @param {Object} object The destination object.
     * @param {Object} source The source object.
     * @param {number} srcIndex The index of `source`.
     * @param {Function} [customizer] The function to customize merged values.
     * @param {Object} [stack] Tracks traversed source values and their merged
     *  counterparts.
     */
    function baseMerge(object, source, srcIndex, customizer, stack) {
      if (object === source) {
        return;
      }
      baseFor(source, function(srcValue, key) {
        stack || (stack = new Stack);
        if (isObject(srcValue)) {
          baseMergeDeep(object, source, key, srcIndex, baseMerge, customizer, stack);
        }
        else {
          var newValue = customizer
            ? customizer(safeGet(object, key), srcValue, (key + ''), object, source, stack)
            : undefined;

          if (newValue === undefined) {
            newValue = srcValue;
          }
          assignMergeValue(object, key, newValue);
        }
      }, keysIn);
    }

    /**
     * A specialized version of `baseMerge` for arrays and objects which performs
     * deep merges and tracks traversed objects enabling objects with circular
     * references to be merged.
     *
     * @private
     * @param {Object} object The destination object.
     * @param {Object} source The source object.
     * @param {string} key The key of the value to merge.
     * @param {number} srcIndex The index of `source`.
     * @param {Function} mergeFunc The function to merge values.
     * @param {Function} [customizer] The function to customize assigned values.
     * @param {Object} [stack] Tracks traversed source values and their merged
     *  counterparts.
     */
    function baseMergeDeep(object, source, key, srcIndex, mergeFunc, customizer, stack) {
      var objValue = safeGet(object, key),
          srcValue = safeGet(source, key),
          stacked = stack.get(srcValue);

      if (stacked) {
        assignMergeValue(object, key, stacked);
        return;
      }
      var newValue = customizer
        ? customizer(objValue, srcValue, (key + ''), object, source, stack)
        : undefined;

      var isCommon = newValue === undefined;

      if (isCommon) {
        var isArr = isArray(srcValue),
            isBuff = !isArr && isBuffer(srcValue),
            isTyped = !isArr && !isBuff && isTypedArray(srcValue);

        newValue = srcValue;
        if (isArr || isBuff || isTyped) {
          if (isArray(objValue)) {
            newValue = objValue;
          }
          else if (isArrayLikeObject(objValue)) {
            newValue = copyArray(objValue);
          }
          else if (isBuff) {
            isCommon = false;
            newValue = cloneBuffer(srcValue, true);
          }
          else if (isTyped) {
            isCommon = false;
            newValue = cloneTypedArray(srcValue, true);
          }
          else {
            newValue = [];
          }
        }
        else if (isPlainObject(srcValue) || isArguments(srcValue)) {
          newValue = objValue;
          if (isArguments(objValue)) {
            newValue = toPlainObject(objValue);
          }
          else if (!isObject(objValue) || isFunction(objValue)) {
            newValue = initCloneObject(srcValue);
          }
        }
        else {
          isCommon = false;
        }
      }
      if (isCommon) {
        // Recursively merge objects and arrays (susceptible to call stack limits).
        stack.set(srcValue, newValue);
        mergeFunc(newValue, srcValue, srcIndex, customizer, stack);
        stack['delete'](srcValue);
      }
      assignMergeValue(object, key, newValue);
    }

    /**
     * The base implementation of `_.nth` which doesn't coerce arguments.
     *
     * @private
     * @param {Array} array The array to query.
     * @param {number} n The index of the element to return.
     * @returns {*} Returns the nth element of `array`.
     */
    function baseNth(array, n) {
      var length = array.length;
      if (!length) {
        return;
      }
      n += n < 0 ? length : 0;
      return isIndex(n, length) ? array[n] : undefined;
    }

    /**
     * The base implementation of `_.orderBy` without param guards.
     *
     * @private
     * @param {Array|Object} collection The collection to iterate over.
     * @param {Function[]|Object[]|string[]} iteratees The iteratees to sort by.
     * @param {string[]} orders The sort orders of `iteratees`.
     * @returns {Array} Returns the new sorted array.
     */
    function baseOrderBy(collection, iteratees, orders) {
      var index = -1;
      iteratees = arrayMap(iteratees.length ? iteratees : [identity], baseUnary(getIteratee()));

      var result = baseMap(collection, function(value, key, collection) {
        var criteria = arrayMap(iteratees, function(iteratee) {
          return iteratee(value);
        });
        return { 'criteria': criteria, 'index': ++index, 'value': value };
      });

      return baseSortBy(result, function(object, other) {
        return compareMultiple(object, other, orders);
      });
    }

    /**
     * The base implementation of `_.pick` without support for individual
     * property identifiers.
     *
     * @private
     * @param {Object} object The source object.
     * @param {string[]} paths The property paths to pick.
     * @returns {Object} Returns the new object.
     */
    function basePick(object, paths) {
      return basePickBy(object, paths, function(value, path) {
        return hasIn(object, path);
      });
    }

    /**
     * The base implementation of  `_.pickBy` without support for iteratee shorthands.
     *
     * @private
     * @param {Object} object The source object.
     * @param {string[]} paths The property paths to pick.
     * @param {Function} predicate The function invoked per property.
     * @returns {Object} Returns the new object.
     */
    function basePickBy(object, paths, predicate) {
      var index = -1,
          length = paths.length,
          result = {};

      while (++index < length) {
        var path = paths[index],
            value = baseGet(object, path);

        if (predicate(value, path)) {
          baseSet(result, castPath(path, object), value);
        }
      }
      return result;
    }

    /**
     * A specialized version of `baseProperty` which supports deep paths.
     *
     * @private
     * @param {Array|string} path The path of the property to get.
     * @returns {Function} Returns the new accessor function.
     */
    function basePropertyDeep(path) {
      return function(object) {
        return baseGet(object, path);
      };
    }

    /**
     * The base implementation of `_.pullAllBy` without support for iteratee
     * shorthands.
     *
     * @private
     * @param {Array} array The array to modify.
     * @param {Array} values The values to remove.
     * @param {Function} [iteratee] The iteratee invoked per element.
     * @param {Function} [comparator] The comparator invoked per element.
     * @returns {Array} Returns `array`.
     */
    function basePullAll(array, values, iteratee, comparator) {
      var indexOf = comparator ? baseIndexOfWith : baseIndexOf,
          index = -1,
          length = values.length,
          seen = array;

      if (array === values) {
        values = copyArray(values);
      }
      if (iteratee) {
        seen = arrayMap(array, baseUnary(iteratee));
      }
      while (++index < length) {
        var fromIndex = 0,
            value = values[index],
            computed = iteratee ? iteratee(value) : value;

        while ((fromIndex = indexOf(seen, computed, fromIndex, comparator)) > -1) {
          if (seen !== array) {
            splice.call(seen, fromIndex, 1);
          }
          splice.call(array, fromIndex, 1);
        }
      }
      return array;
    }

    /**
     * The base implementation of `_.pullAt` without support for individual
     * indexes or capturing the removed elements.
     *
     * @private
     * @param {Array} array The array to modify.
     * @param {number[]} indexes The indexes of elements to remove.
     * @returns {Array} Returns `array`.
     */
    function basePullAt(array, indexes) {
      var length = array ? indexes.length : 0,
          lastIndex = length - 1;

      while (length--) {
        var index = indexes[length];
        if (length == lastIndex || index !== previous) {
          var previous = index;
          if (isIndex(index)) {
            splice.call(array, index, 1);
          } else {
            baseUnset(array, index);
          }
        }
      }
      return array;
    }

    /**
     * The base implementation of `_.random` without support for returning
     * floating-point numbers.
     *
     * @private
     * @param {number} lower The lower bound.
     * @param {number} upper The upper bound.
     * @returns {number} Returns the random number.
     */
    function baseRandom(lower, upper) {
      return lower + nativeFloor(nativeRandom() * (upper - lower + 1));
    }

    /**
     * The base implementation of `_.range` and `_.rangeRight` which doesn't
     * coerce arguments.
     *
     * @private
     * @param {number} start The start of the range.
     * @param {number} end The end of the range.
     * @param {number} step The value to increment or decrement by.
     * @param {boolean} [fromRight] Specify iterating from right to left.
     * @returns {Array} Returns the range of numbers.
     */
    function baseRange(start, end, step, fromRight) {
      var index = -1,
          length = nativeMax(nativeCeil((end - start) / (step || 1)), 0),
          result = Array(length);

      while (length--) {
        result[fromRight ? length : ++index] = start;
        start += step;
      }
      return result;
    }

    /**
     * The base implementation of `_.repeat` which doesn't coerce arguments.
     *
     * @private
     * @param {string} string The string to repeat.
     * @param {number} n The number of times to repeat the string.
     * @returns {string} Returns the repeated string.
     */
    function baseRepeat(string, n) {
      var result = '';
      if (!string || n < 1 || n > MAX_SAFE_INTEGER) {
        return result;
      }
      // Leverage the exponentiation by squaring algorithm for a faster repeat.
      // See https://en.wikipedia.org/wiki/Exponentiation_by_squaring for more details.
      do {
        if (n % 2) {
          result += string;
        }
        n = nativeFloor(n / 2);
        if (n) {
          string += string;
        }
      } while (n);

      return result;
    }

    /**
     * The base implementation of `_.rest` which doesn't validate or coerce arguments.
     *
     * @private
     * @param {Function} func The function to apply a rest parameter to.
     * @param {number} [start=func.length-1] The start position of the rest parameter.
     * @returns {Function} Returns the new function.
     */
    function baseRest(func, start) {
      return setToString(overRest(func, start, identity), func + '');
    }

    /**
     * The base implementation of `_.sample`.
     *
     * @private
     * @param {Array|Object} collection The collection to sample.
     * @returns {*} Returns the random element.
     */
    function baseSample(collection) {
      return arraySample(values(collection));
    }

    /**
     * The base implementation of `_.sampleSize` without param guards.
     *
     * @private
     * @param {Array|Object} collection The collection to sample.
     * @param {number} n The number of elements to sample.
     * @returns {Array} Returns the random elements.
     */
    function baseSampleSize(collection, n) {
      var array = values(collection);
      return shuffleSelf(array, baseClamp(n, 0, array.length));
    }

    /**
     * The base implementation of `_.set`.
     *
     * @private
     * @param {Object} object The object to modify.
     * @param {Array|string} path The path of the property to set.
     * @param {*} value The value to set.
     * @param {Function} [customizer] The function to customize path creation.
     * @returns {Object} Returns `object`.
     */
    function baseSet(object, path, value, customizer) {
      if (!isObject(object)) {
        return object;
      }
      path = castPath(path, object);

      var index = -1,
          length = path.length,
          lastIndex = length - 1,
          nested = object;

      while (nested != null && ++index < length) {
        var key = toKey(path[index]),
            newValue = value;

        if (index != lastIndex) {
          var objValue = nested[key];
          newValue = customizer ? customizer(objValue, key, nested) : undefined;
          if (newValue === undefined) {
            newValue = isObject(objValue)
              ? objValue
              : (isIndex(path[index + 1]) ? [] : {});
          }
        }
        assignValue(nested, key, newValue);
        nested = nested[key];
      }
      return object;
    }

    /**
     * The base implementation of `setData` without support for hot loop shorting.
     *
     * @private
     * @param {Function} func The function to associate metadata with.
     * @param {*} data The metadata.
     * @returns {Function} Returns `func`.
     */
    var baseSetData = !metaMap ? identity : function(func, data) {
      metaMap.set(func, data);
      return func;
    };

    /**
     * The base implementation of `setToString` without support for hot loop shorting.
     *
     * @private
     * @param {Function} func The function to modify.
     * @param {Function} string The `toString` result.
     * @returns {Function} Returns `func`.
     */
    var baseSetToString = !defineProperty ? identity : function(func, string) {
      return defineProperty(func, 'toString', {
        'configurable': true,
        'enumerable': false,
        'value': constant(string),
        'writable': true
      });
    };

    /**
     * The base implementation of `_.shuffle`.
     *
     * @private
     * @param {Array|Object} collection The collection to shuffle.
     * @returns {Array} Returns the new shuffled array.
     */
    function baseShuffle(collection) {
      return shuffleSelf(values(collection));
    }

    /**
     * The base implementation of `_.slice` without an iteratee call guard.
     *
     * @private
     * @param {Array} array The array to slice.
     * @param {number} [start=0] The start position.
     * @param {number} [end=array.length] The end position.
     * @returns {Array} Returns the slice of `array`.
     */
    function baseSlice(array, start, end) {
      var index = -1,
          length = array.length;

      if (start < 0) {
        start = -start > length ? 0 : (length + start);
      }
      end = end > length ? length : end;
      if (end < 0) {
        end += length;
      }
      length = start > end ? 0 : ((end - start) >>> 0);
      start >>>= 0;

      var result = Array(length);
      while (++index < length) {
        result[index] = array[index + start];
      }
      return result;
    }

    /**
     * The base implementation of `_.some` without support for iteratee shorthands.
     *
     * @private
     * @param {Array|Object} collection The collection to iterate over.
     * @param {Function} predicate The function invoked per iteration.
     * @returns {boolean} Returns `true` if any element passes the predicate check,
     *  else `false`.
     */
    function baseSome(collection, predicate) {
      var result;

      baseEach(collection, function(value, index, collection) {
        result = predicate(value, index, collection);
        return !result;
      });
      return !!result;
    }

    /**
     * The base implementation of `_.sortedIndex` and `_.sortedLastIndex` which
     * performs a binary search of `array` to determine the index at which `value`
     * should be inserted into `array` in order to maintain its sort order.
     *
     * @private
     * @param {Array} array The sorted array to inspect.
     * @param {*} value The value to evaluate.
     * @param {boolean} [retHighest] Specify returning the highest qualified index.
     * @returns {number} Returns the index at which `value` should be inserted
     *  into `array`.
     */
    function baseSortedIndex(array, value, retHighest) {
      var low = 0,
          high = array == null ? low : array.length;

      if (typeof value == 'number' && value === value && high <= HALF_MAX_ARRAY_LENGTH) {
        while (low < high) {
          var mid = (low + high) >>> 1,
              computed = array[mid];

          if (computed !== null && !isSymbol(computed) &&
              (retHighest ? (computed <= value) : (computed < value))) {
            low = mid + 1;
          } else {
            high = mid;
          }
        }
        return high;
      }
      return baseSortedIndexBy(array, value, identity, retHighest);
    }

    /**
     * The base implementation of `_.sortedIndexBy` and `_.sortedLastIndexBy`
     * which invokes `iteratee` for `value` and each element of `array` to compute
     * their sort ranking. The iteratee is invoked with one argument; (value).
     *
     * @private
     * @param {Array} array The sorted array to inspect.
     * @param {*} value The value to evaluate.
     * @param {Function} iteratee The iteratee invoked per element.
     * @param {boolean} [retHighest] Specify returning the highest qualified index.
     * @returns {number} Returns the index at which `value` should be inserted
     *  into `array`.
     */
    function baseSortedIndexBy(array, value, iteratee, retHighest) {
      value = iteratee(value);

      var low = 0,
          high = array == null ? 0 : array.length,
          valIsNaN = value !== value,
          valIsNull = value === null,
          valIsSymbol = isSymbol(value),
          valIsUndefined = value === undefined;

      while (low < high) {
        var mid = nativeFloor((low + high) / 2),
            computed = iteratee(array[mid]),
            othIsDefined = computed !== undefined,
            othIsNull = computed === null,
            othIsReflexive = computed === computed,
            othIsSymbol = isSymbol(computed);

        if (valIsNaN) {
          var setLow = retHighest || othIsReflexive;
        } else if (valIsUndefined) {
          setLow = othIsReflexive && (retHighest || othIsDefined);
        } else if (valIsNull) {
          setLow = othIsReflexive && othIsDefined && (retHighest || !othIsNull);
        } else if (valIsSymbol) {
          setLow = othIsReflexive && othIsDefined && !othIsNull && (retHighest || !othIsSymbol);
        } else if (othIsNull || othIsSymbol) {
          setLow = false;
        } else {
          setLow = retHighest ? (computed <= value) : (computed < value);
        }
        if (setLow) {
          low = mid + 1;
        } else {
          high = mid;
        }
      }
      return nativeMin(high, MAX_ARRAY_INDEX);
    }

    /**
     * The base implementation of `_.sortedUniq` and `_.sortedUniqBy` without
     * support for iteratee shorthands.
     *
     * @private
     * @param {Array} array The array to inspect.
     * @param {Function} [iteratee] The iteratee invoked per element.
     * @returns {Array} Returns the new duplicate free array.
     */
    function baseSortedUniq(array, iteratee) {
      var index = -1,
          length = array.length,
          resIndex = 0,
          result = [];

      while (++index < length) {
        var value = array[index],
            computed = iteratee ? iteratee(value) : value;

        if (!index || !eq(computed, seen)) {
          var seen = computed;
          result[resIndex++] = value === 0 ? 0 : value;
        }
      }
      return result;
    }

    /**
     * The base implementation of `_.toNumber` which doesn't ensure correct
     * conversions of binary, hexadecimal, or octal string values.
     *
     * @private
     * @param {*} value The value to process.
     * @returns {number} Returns the number.
     */
    function baseToNumber(value) {
      if (typeof value == 'number') {
        return value;
      }
      if (isSymbol(value)) {
        return NAN;
      }
      return +value;
    }

    /**
     * The base implementation of `_.toString` which doesn't convert nullish
     * values to empty strings.
     *
     * @private
     * @param {*} value The value to process.
     * @returns {string} Returns the string.
     */
    function baseToString(value) {
      // Exit early for strings to avoid a performance hit in some environments.
      if (typeof value == 'string') {
        return value;
      }
      if (isArray(value)) {
        // Recursively convert values (susceptible to call stack limits).
        return arrayMap(value, baseToString) + '';
      }
      if (isSymbol(value)) {
        return symbolToString ? symbolToString.call(value) : '';
      }
      var result = (value + '');
      return (result == '0' && (1 / value) == -INFINITY) ? '-0' : result;
    }

    /**
     * The base implementation of `_.uniqBy` without support for iteratee shorthands.
     *
     * @private
     * @param {Array} array The array to inspect.
     * @param {Function} [iteratee] The iteratee invoked per element.
     * @param {Function} [comparator] The comparator invoked per element.
     * @returns {Array} Returns the new duplicate free array.
     */
    function baseUniq(array, iteratee, comparator) {
      var index = -1,
          includes = arrayIncludes,
          length = array.length,
          isCommon = true,
          result = [],
          seen = result;

      if (comparator) {
        isCommon = false;
        includes = arrayIncludesWith;
      }
      else if (length >= LARGE_ARRAY_SIZE) {
        var set = iteratee ? null : createSet(array);
        if (set) {
          return setToArray(set);
        }
        isCommon = false;
        includes = cacheHas;
        seen = new SetCache;
      }
      else {
        seen = iteratee ? [] : result;
      }
      outer:
      while (++index < length) {
        var value = array[index],
            computed = iteratee ? iteratee(value) : value;

        value = (comparator || value !== 0) ? value : 0;
        if (isCommon && computed === computed) {
          var seenIndex = seen.length;
          while (seenIndex--) {
            if (seen[seenIndex] === computed) {
              continue outer;
            }
          }
          if (iteratee) {
            seen.push(computed);
          }
          result.push(value);
        }
        else if (!includes(seen, computed, comparator)) {
          if (seen !== result) {
            seen.push(computed);
          }
          result.push(value);
        }
      }
      return result;
    }

    /**
     * The base implementation of `_.unset`.
     *
     * @private
     * @param {Object} object The object to modify.
     * @param {Array|string} path The property path to unset.
     * @returns {boolean} Returns `true` if the property is deleted, else `false`.
     */
    function baseUnset(object, path) {
      path = castPath(path, object);
      object = parent(object, path);
      return object == null || delete object[toKey(last(path))];
    }

    /**
     * The base implementation of `_.update`.
     *
     * @private
     * @param {Object} object The object to modify.
     * @param {Array|string} path The path of the property to update.
     * @param {Function} updater The function to produce the updated value.
     * @param {Function} [customizer] The function to customize path creation.
     * @returns {Object} Returns `object`.
     */
    function baseUpdate(object, path, updater, customizer) {
      return baseSet(object, path, updater(baseGet(object, path)), customizer);
    }

    /**
     * The base implementation of methods like `_.dropWhile` and `_.takeWhile`
     * without support for iteratee shorthands.
     *
     * @private
     * @param {Array} array The array to query.
     * @param {Function} predicate The function invoked per iteration.
     * @param {boolean} [isDrop] Specify dropping elements instead of taking them.
     * @param {boolean} [fromRight] Specify iterating from right to left.
     * @returns {Array} Returns the slice of `array`.
     */
    function baseWhile(array, predicate, isDrop, fromRight) {
      var length = array.length,
          index = fromRight ? length : -1;

      while ((fromRight ? index-- : ++index < length) &&
        predicate(array[index], index, array)) {}

      return isDrop
        ? baseSlice(array, (fromRight ? 0 : index), (fromRight ? index + 1 : length))
        : baseSlice(array, (fromRight ? index + 1 : 0), (fromRight ? length : index));
    }

    /**
     * The base implementation of `wrapperValue` which returns the result of
     * performing a sequence of actions on the unwrapped `value`, where each
     * successive action is supplied the return value of the previous.
     *
     * @private
     * @param {*} value The unwrapped value.
     * @param {Array} actions Actions to perform to resolve the unwrapped value.
     * @returns {*} Returns the resolved value.
     */
    function baseWrapperValue(value, actions) {
      var result = value;
      if (result instanceof LazyWrapper) {
        result = result.value();
      }
      return arrayReduce(actions, function(result, action) {
        return action.func.apply(action.thisArg, arrayPush([result], action.args));
      }, result);
    }

    /**
     * The base implementation of methods like `_.xor`, without support for
     * iteratee shorthands, that accepts an array of arrays to inspect.
     *
     * @private
     * @param {Array} arrays The arrays to inspect.
     * @param {Function} [iteratee] The iteratee invoked per element.
     * @param {Function} [comparator] The comparator invoked per element.
     * @returns {Array} Returns the new array of values.
     */
    function baseXor(arrays, iteratee, comparator) {
      var length = arrays.length;
      if (length < 2) {
        return length ? baseUniq(arrays[0]) : [];
      }
      var index = -1,
          result = Array(length);

      while (++index < length) {
        var array = arrays[index],
            othIndex = -1;

        while (++othIndex < length) {
          if (othIndex != index) {
            result[index] = baseDifference(result[index] || array, arrays[othIndex], iteratee, comparator);
          }
        }
      }
      return baseUniq(baseFlatten(result, 1), iteratee, comparator);
    }

    /**
     * This base implementation of `_.zipObject` which assigns values using `assignFunc`.
     *
     * @private
     * @param {Array} props The property identifiers.
     * @param {Array} values The property values.
     * @param {Function} assignFunc The function to assign values.
     * @returns {Object} Returns the new object.
     */
    function baseZipObject(props, values, assignFunc) {
      var index = -1,
          length = props.length,
          valsLength = values.length,
          result = {};

      while (++index < length) {
        var value = index < valsLength ? values[index] : undefined;
        assignFunc(result, props[index], value);
      }
      return result;
    }

    /**
     * Casts `value` to an empty array if it's not an array like object.
     *
     * @private
     * @param {*} value The value to inspect.
     * @returns {Array|Object} Returns the cast array-like object.
     */
    function castArrayLikeObject(value) {
      return isArrayLikeObject(value) ? value : [];
    }

    /**
     * Casts `value` to `identity` if it's not a function.
     *
     * @private
     * @param {*} value The value to inspect.
     * @returns {Function} Returns cast function.
     */
    function castFunction(value) {
      return typeof value == 'function' ? value : identity;
    }

    /**
     * Casts `value` to a path array if it's not one.
     *
     * @private
     * @param {*} value The value to inspect.
     * @param {Object} [object] The object to query keys on.
     * @returns {Array} Returns the cast property path array.
     */
    function castPath(value, object) {
      if (isArray(value)) {
        return value;
      }
      return isKey(value, object) ? [value] : stringToPath(toString(value));
    }

    /**
     * A `baseRest` alias which can be replaced with `identity` by module
     * replacement plugins.
     *
     * @private
     * @type {Function}
     * @param {Function} func The function to apply a rest parameter to.
     * @returns {Function} Returns the new function.
     */
    var castRest = baseRest;

    /**
     * Casts `array` to a slice if it's needed.
     *
     * @private
     * @param {Array} array The array to inspect.
     * @param {number} start The start position.
     * @param {number} [end=array.length] The end position.
     * @returns {Array} Returns the cast slice.
     */
    function castSlice(array, start, end) {
      var length = array.length;
      end = end === undefined ? length : end;
      return (!start && end >= length) ? array : baseSlice(array, start, end);
    }

    /**
     * A simple wrapper around the global [`clearTimeout`](https://mdn.io/clearTimeout).
     *
     * @private
     * @param {number|Object} id The timer id or timeout object of the timer to clear.
     */
    var clearTimeout = ctxClearTimeout || function(id) {
      return root.clearTimeout(id);
    };

    /**
     * Creates a clone of  `buffer`.
     *
     * @private
     * @param {Buffer} buffer The buffer to clone.
     * @param {boolean} [isDeep] Specify a deep clone.
     * @returns {Buffer} Returns the cloned buffer.
     */
    function cloneBuffer(buffer, isDeep) {
      if (isDeep) {
        return buffer.slice();
      }
      var length = buffer.length,
          result = allocUnsafe ? allocUnsafe(length) : new buffer.constructor(length);

      buffer.copy(result);
      return result;
    }

    /**
     * Creates a clone of `arrayBuffer`.
     *
     * @private
     * @param {ArrayBuffer} arrayBuffer The array buffer to clone.
     * @returns {ArrayBuffer} Returns the cloned array buffer.
     */
    function cloneArrayBuffer(arrayBuffer) {
      var result = new arrayBuffer.constructor(arrayBuffer.byteLength);
      new Uint8Array(result).set(new Uint8Array(arrayBuffer));
      return result;
    }

    /**
     * Creates a clone of `dataView`.
     *
     * @private
     * @param {Object} dataView The data view to clone.
     * @param {boolean} [isDeep] Specify a deep clone.
     * @returns {Object} Returns the cloned data view.
     */
    function cloneDataView(dataView, isDeep) {
      var buffer = isDeep ? cloneArrayBuffer(dataView.buffer) : dataView.buffer;
      return new dataView.constructor(buffer, dataView.byteOffset, dataView.byteLength);
    }

    /**
     * Creates a clone of `regexp`.
     *
     * @private
     * @param {Object} regexp The regexp to clone.
     * @returns {Object} Returns the cloned regexp.
     */
    function cloneRegExp(regexp) {
      var result = new regexp.constructor(regexp.source, reFlags.exec(regexp));
      result.lastIndex = regexp.lastIndex;
      return result;
    }

    /**
     * Creates a clone of the `symbol` object.
     *
     * @private
     * @param {Object} symbol The symbol object to clone.
     * @returns {Object} Returns the cloned symbol object.
     */
    function cloneSymbol(symbol) {
      return symbolValueOf ? Object(symbolValueOf.call(symbol)) : {};
    }

    /**
     * Creates a clone of `typedArray`.
     *
     * @private
     * @param {Object} typedArray The typed array to clone.
     * @param {boolean} [isDeep] Specify a deep clone.
     * @returns {Object} Returns the cloned typed array.
     */
    function cloneTypedArray(typedArray, isDeep) {
      var buffer = isDeep ? cloneArrayBuffer(typedArray.buffer) : typedArray.buffer;
      return new typedArray.constructor(buffer, typedArray.byteOffset, typedArray.length);
    }

    /**
     * Compares values to sort them in ascending order.
     *
     * @private
     * @param {*} value The value to compare.
     * @param {*} other The other value to compare.
     * @returns {number} Returns the sort order indicator for `value`.
     */
    function compareAscending(value, other) {
      if (value !== other) {
        var valIsDefined = value !== undefined,
            valIsNull = value === null,
            valIsReflexive = value === value,
            valIsSymbol = isSymbol(value);

        var othIsDefined = other !== undefined,
            othIsNull = other === null,
            othIsReflexive = other === other,
            othIsSymbol = isSymbol(other);

        if ((!othIsNull && !othIsSymbol && !valIsSymbol && value > other) ||
            (valIsSymbol && othIsDefined && othIsReflexive && !othIsNull && !othIsSymbol) ||
            (valIsNull && othIsDefined && othIsReflexive) ||
            (!valIsDefined && othIsReflexive) ||
            !valIsReflexive) {
          return 1;
        }
        if ((!valIsNull && !valIsSymbol && !othIsSymbol && value < other) ||
            (othIsSymbol && valIsDefined && valIsReflexive && !valIsNull && !valIsSymbol) ||
            (othIsNull && valIsDefined && valIsReflexive) ||
            (!othIsDefined && valIsReflexive) ||
            !othIsReflexive) {
          return -1;
        }
      }
      return 0;
    }

    /**
     * Used by `_.orderBy` to compare multiple properties of a value to another
     * and stable sort them.
     *
     * If `orders` is unspecified, all values are sorted in ascending order. Otherwise,
     * specify an order of "desc" for descending or "asc" for ascending sort order
     * of corresponding values.
     *
     * @private
     * @param {Object} object The object to compare.
     * @param {Object} other The other object to compare.
     * @param {boolean[]|string[]} orders The order to sort by for each property.
     * @returns {number} Returns the sort order indicator for `object`.
     */
    function compareMultiple(object, other, orders) {
      var index = -1,
          objCriteria = object.criteria,
          othCriteria = other.criteria,
          length = objCriteria.length,
          ordersLength = orders.length;

      while (++index < length) {
        var result = compareAscending(objCriteria[index], othCriteria[index]);
        if (result) {
          if (index >= ordersLength) {
            return result;
          }
          var order = orders[index];
          return result * (order == 'desc' ? -1 : 1);
        }
      }
      // Fixes an `Array#sort` bug in the JS engine embedded in Adobe applications
      // that causes it, under certain circumstances, to provide the same value for
      // `object` and `other`. See https://github.com/jashkenas/underscore/pull/1247
      // for more details.
      //
      // This also ensures a stable sort in V8 and other engines.
      // See https://bugs.chromium.org/p/v8/issues/detail?id=90 for more details.
      return object.index - other.index;
    }

    /**
     * Creates an array that is the composition of partially applied arguments,
     * placeholders, and provided arguments into a single array of arguments.
     *
     * @private
     * @param {Array} args The provided arguments.
     * @param {Array} partials The arguments to prepend to those provided.
     * @param {Array} holders The `partials` placeholder indexes.
     * @params {boolean} [isCurried] Specify composing for a curried function.
     * @returns {Array} Returns the new array of composed arguments.
     */
    function composeArgs(args, partials, holders, isCurried) {
      var argsIndex = -1,
          argsLength = args.length,
          holdersLength = holders.length,
          leftIndex = -1,
          leftLength = partials.length,
          rangeLength = nativeMax(argsLength - holdersLength, 0),
          result = Array(leftLength + rangeLength),
          isUncurried = !isCurried;

      while (++leftIndex < leftLength) {
        result[leftIndex] = partials[leftIndex];
      }
      while (++argsIndex < holdersLength) {
        if (isUncurried || argsIndex < argsLength) {
          result[holders[argsIndex]] = args[argsIndex];
        }
      }
      while (rangeLength--) {
        result[leftIndex++] = args[argsIndex++];
      }
      return result;
    }

    /**
     * This function is like `composeArgs` except that the arguments composition
     * is tailored for `_.partialRight`.
     *
     * @private
     * @param {Array} args The provided arguments.
     * @param {Array} partials The arguments to append to those provided.
     * @param {Array} holders The `partials` placeholder indexes.
     * @params {boolean} [isCurried] Specify composing for a curried function.
     * @returns {Array} Returns the new array of composed arguments.
     */
    function composeArgsRight(args, partials, holders, isCurried) {
      var argsIndex = -1,
          argsLength = args.length,
          holdersIndex = -1,
          holdersLength = holders.length,
          rightIndex = -1,
          rightLength = partials.length,
          rangeLength = nativeMax(argsLength - holdersLength, 0),
          result = Array(rangeLength + rightLength),
          isUncurried = !isCurried;

      while (++argsIndex < rangeLength) {
        result[argsIndex] = args[argsIndex];
      }
      var offset = argsIndex;
      while (++rightIndex < rightLength) {
        result[offset + rightIndex] = partials[rightIndex];
      }
      while (++holdersIndex < holdersLength) {
        if (isUncurried || argsIndex < argsLength) {
          result[offset + holders[holdersIndex]] = args[argsIndex++];
        }
      }
      return result;
    }

    /**
     * Copies the values of `source` to `array`.
     *
     * @private
     * @param {Array} source The array to copy values from.
     * @param {Array} [array=[]] The array to copy values to.
     * @returns {Array} Returns `array`.
     */
    function copyArray(source, array) {
      var index = -1,
          length = source.length;

      array || (array = Array(length));
      while (++index < length) {
        array[index] = source[index];
      }
      return array;
    }

    /**
     * Copies properties of `source` to `object`.
     *
     * @private
     * @param {Object} source The object to copy properties from.
     * @param {Array} props The property identifiers to copy.
     * @param {Object} [object={}] The object to copy properties to.
     * @param {Function} [customizer] The function to customize copied values.
     * @returns {Object} Returns `object`.
     */
    function copyObject(source, props, object, customizer) {
      var isNew = !object;
      object || (object = {});

      var index = -1,
          length = props.length;

      while (++index < length) {
        var key = props[index];

        var newValue = customizer
          ? customizer(object[key], source[key], key, object, source)
          : undefined;

        if (newValue === undefined) {
          newValue = source[key];
        }
        if (isNew) {
          baseAssignValue(object, key, newValue);
        } else {
          assignValue(object, key, newValue);
        }
      }
      return object;
    }

    /**
     * Copies own symbols of `source` to `object`.
     *
     * @private
     * @param {Object} source The object to copy symbols from.
     * @param {Object} [object={}] The object to copy symbols to.
     * @returns {Object} Returns `object`.
     */
    function copySymbols(source, object) {
      return copyObject(source, getSymbols(source), object);
    }

    /**
     * Copies own and inherited symbols of `source` to `object`.
     *
     * @private
     * @param {Object} source The object to copy symbols from.
     * @param {Object} [object={}] The object to copy symbols to.
     * @returns {Object} Returns `object`.
     */
    function copySymbolsIn(source, object) {
      return copyObject(source, getSymbolsIn(source), object);
    }

    /**
     * Creates a function like `_.groupBy`.
     *
     * @private
     * @param {Function} setter The function to set accumulator values.
     * @param {Function} [initializer] The accumulator object initializer.
     * @returns {Function} Returns the new aggregator function.
     */
    function createAggregator(setter, initializer) {
      return function(collection, iteratee) {
        var func = isArray(collection) ? arrayAggregator : baseAggregator,
            accumulator = initializer ? initializer() : {};

        return func(collection, setter, getIteratee(iteratee, 2), accumulator);
      };
    }

    /**
     * Creates a function like `_.assign`.
     *
     * @private
     * @param {Function} assigner The function to assign values.
     * @returns {Function} Returns the new assigner function.
     */
    function createAssigner(assigner) {
      return baseRest(function(object, sources) {
        var index = -1,
            length = sources.length,
            customizer = length > 1 ? sources[length - 1] : undefined,
            guard = length > 2 ? sources[2] : undefined;

        customizer = (assigner.length > 3 && typeof customizer == 'function')
          ? (length--, customizer)
          : undefined;

        if (guard && isIterateeCall(sources[0], sources[1], guard)) {
          customizer = length < 3 ? undefined : customizer;
          length = 1;
        }
        object = Object(object);
        while (++index < length) {
          var source = sources[index];
          if (source) {
            assigner(object, source, index, customizer);
          }
        }
        return object;
      });
    }

    /**
     * Creates a `baseEach` or `baseEachRight` function.
     *
     * @private
     * @param {Function} eachFunc The function to iterate over a collection.
     * @param {boolean} [fromRight] Specify iterating from right to left.
     * @returns {Function} Returns the new base function.
     */
    function createBaseEach(eachFunc, fromRight) {
      return function(collection, iteratee) {
        if (collection == null) {
          return collection;
        }
        if (!isArrayLike(collection)) {
          return eachFunc(collection, iteratee);
        }
        var length = collection.length,
            index = fromRight ? length : -1,
            iterable = Object(collection);

        while ((fromRight ? index-- : ++index < length)) {
          if (iteratee(iterable[index], index, iterable) === false) {
            break;
          }
        }
        return collection;
      };
    }

    /**
     * Creates a base function for methods like `_.forIn` and `_.forOwn`.
     *
     * @private
     * @param {boolean} [fromRight] Specify iterating from right to left.
     * @returns {Function} Returns the new base function.
     */
    function createBaseFor(fromRight) {
      return function(object, iteratee, keysFunc) {
        var index = -1,
            iterable = Object(object),
            props = keysFunc(object),
            length = props.length;

        while (length--) {
          var key = props[fromRight ? length : ++index];
          if (iteratee(iterable[key], key, iterable) === false) {
            break;
          }
        }
        return object;
      };
    }

    /**
     * Creates a function that wraps `func` to invoke it with the optional `this`
     * binding of `thisArg`.
     *
     * @private
     * @param {Function} func The function to wrap.
     * @param {number} bitmask The bitmask flags. See `createWrap` for more details.
     * @param {*} [thisArg] The `this` binding of `func`.
     * @returns {Function} Returns the new wrapped function.
     */
    function createBind(func, bitmask, thisArg) {
      var isBind = bitmask & WRAP_BIND_FLAG,
          Ctor = createCtor(func);

      function wrapper() {
        var fn = (this && this !== root && this instanceof wrapper) ? Ctor : func;
        return fn.apply(isBind ? thisArg : this, arguments);
      }
      return wrapper;
    }

    /**
     * Creates a function like `_.lowerFirst`.
     *
     * @private
     * @param {string} methodName The name of the `String` case method to use.
     * @returns {Function} Returns the new case function.
     */
    function createCaseFirst(methodName) {
      return function(string) {
        string = toString(string);

        var strSymbols = hasUnicode(string)
          ? stringToArray(string)
          : undefined;

        var chr = strSymbols
          ? strSymbols[0]
          : string.charAt(0);

        var trailing = strSymbols
          ? castSlice(strSymbols, 1).join('')
          : string.slice(1);

        return chr[methodName]() + trailing;
      };
    }

    /**
     * Creates a function like `_.camelCase`.
     *
     * @private
     * @param {Function} callback The function to combine each word.
     * @returns {Function} Returns the new compounder function.
     */
    function createCompounder(callback) {
      return function(string) {
        return arrayReduce(words(deburr(string).replace(reApos, '')), callback, '');
      };
    }

    /**
     * Creates a function that produces an instance of `Ctor` regardless of
     * whether it was invoked as part of a `new` expression or by `call` or `apply`.
     *
     * @private
     * @param {Function} Ctor The constructor to wrap.
     * @returns {Function} Returns the new wrapped function.
     */
    function createCtor(Ctor) {
      return function() {
        // Use a `switch` statement to work with class constructors. See
        // http://ecma-international.org/ecma-262/7.0/#sec-ecmascript-function-objects-call-thisargument-argumentslist
        // for more details.
        var args = arguments;
        switch (args.length) {
          case 0: return new Ctor;
          case 1: return new Ctor(args[0]);
          case 2: return new Ctor(args[0], args[1]);
          case 3: return new Ctor(args[0], args[1], args[2]);
          case 4: return new Ctor(args[0], args[1], args[2], args[3]);
          case 5: return new Ctor(args[0], args[1], args[2], args[3], args[4]);
          case 6: return new Ctor(args[0], args[1], args[2], args[3], args[4], args[5]);
          case 7: return new Ctor(args[0], args[1], args[2], args[3], args[4], args[5], args[6]);
        }
        var thisBinding = baseCreate(Ctor.prototype),
            result = Ctor.apply(thisBinding, args);

        // Mimic the constructor's `return` behavior.
        // See https://es5.github.io/#x13.2.2 for more details.
        return isObject(result) ? result : thisBinding;
      };
    }

    /**
     * Creates a function that wraps `func` to enable currying.
     *
     * @private
     * @param {Function} func The function to wrap.
     * @param {number} bitmask The bitmask flags. See `createWrap` for more details.
     * @param {number} arity The arity of `func`.
     * @returns {Function} Returns the new wrapped function.
     */
    function createCurry(func, bitmask, arity) {
      var Ctor = createCtor(func);

      function wrapper() {
        var length = arguments.length,
            args = Array(length),
            index = length,
            placeholder = getHolder(wrapper);

        while (index--) {
          args[index] = arguments[index];
        }
        var holders = (length < 3 && args[0] !== placeholder && args[length - 1] !== placeholder)
          ? []
          : replaceHolders(args, placeholder);

        length -= holders.length;
        if (length < arity) {
          return createRecurry(
            func, bitmask, createHybrid, wrapper.placeholder, undefined,
            args, holders, undefined, undefined, arity - length);
        }
        var fn = (this && this !== root && this instanceof wrapper) ? Ctor : func;
        return apply(fn, this, args);
      }
      return wrapper;
    }

    /**
     * Creates a `_.find` or `_.findLast` function.
     *
     * @private
     * @param {Function} findIndexFunc The function to find the collection index.
     * @returns {Function} Returns the new find function.
     */
    function createFind(findIndexFunc) {
      return function(collection, predicate, fromIndex) {
        var iterable = Object(collection);
        if (!isArrayLike(collection)) {
          var iteratee = getIteratee(predicate, 3);
          collection = keys(collection);
          predicate = function(key) { return iteratee(iterable[key], key, iterable); };
        }
        var index = findIndexFunc(collection, predicate, fromIndex);
        return index > -1 ? iterable[iteratee ? collection[index] : index] : undefined;
      };
    }

    /**
     * Creates a `_.flow` or `_.flowRight` function.
     *
     * @private
     * @param {boolean} [fromRight] Specify iterating from right to left.
     * @returns {Function} Returns the new flow function.
     */
    function createFlow(fromRight) {
      return flatRest(function(funcs) {
        var length = funcs.length,
            index = length,
            prereq = LodashWrapper.prototype.thru;

        if (fromRight) {
          funcs.reverse();
        }
        while (index--) {
          var func = funcs[index];
          if (typeof func != 'function') {
            throw new TypeError(FUNC_ERROR_TEXT);
          }
          if (prereq && !wrapper && getFuncName(func) == 'wrapper') {
            var wrapper = new LodashWrapper([], true);
          }
        }
        index = wrapper ? index : length;
        while (++index < length) {
          func = funcs[index];

          var funcName = getFuncName(func),
              data = funcName == 'wrapper' ? getData(func) : undefined;

          if (data && isLaziable(data[0]) &&
                data[1] == (WRAP_ARY_FLAG | WRAP_CURRY_FLAG | WRAP_PARTIAL_FLAG | WRAP_REARG_FLAG) &&
                !data[4].length && data[9] == 1
              ) {
            wrapper = wrapper[getFuncName(data[0])].apply(wrapper, data[3]);
          } else {
            wrapper = (func.length == 1 && isLaziable(func))
              ? wrapper[funcName]()
              : wrapper.thru(func);
          }
        }
        return function() {
          var args = arguments,
              value = args[0];

          if (wrapper && args.length == 1 && isArray(value)) {
            return wrapper.plant(value).value();
          }
          var index = 0,
              result = length ? funcs[index].apply(this, args) : value;

          while (++index < length) {
            result = funcs[index].call(this, result);
          }
          return result;
        };
      });
    }

    /**
     * Creates a function that wraps `func` to invoke it with optional `this`
     * binding of `thisArg`, partial application, and currying.
     *
     * @private
     * @param {Function|string} func The function or method name to wrap.
     * @param {number} bitmask The bitmask flags. See `createWrap` for more details.
     * @param {*} [thisArg] The `this` binding of `func`.
     * @param {Array} [partials] The arguments to prepend to those provided to
     *  the new function.
     * @param {Array} [holders] The `partials` placeholder indexes.
     * @param {Array} [partialsRight] The arguments to append to those provided
     *  to the new function.
     * @param {Array} [holdersRight] The `partialsRight` placeholder indexes.
     * @param {Array} [argPos] The argument positions of the new function.
     * @param {number} [ary] The arity cap of `func`.
     * @param {number} [arity] The arity of `func`.
     * @returns {Function} Returns the new wrapped function.
     */
    function createHybrid(func, bitmask, thisArg, partials, holders, partialsRight, holdersRight, argPos, ary, arity) {
      var isAry = bitmask & WRAP_ARY_FLAG,
          isBind = bitmask & WRAP_BIND_FLAG,
          isBindKey = bitmask & WRAP_BIND_KEY_FLAG,
          isCurried = bitmask & (WRAP_CURRY_FLAG | WRAP_CURRY_RIGHT_FLAG),
          isFlip = bitmask & WRAP_FLIP_FLAG,
          Ctor = isBindKey ? undefined : createCtor(func);

      function wrapper() {
        var length = arguments.length,
            args = Array(length),
            index = length;

        while (index--) {
          args[index] = arguments[index];
        }
        if (isCurried) {
          var placeholder = getHolder(wrapper),
              holdersCount = countHolders(args, placeholder);
        }
        if (partials) {
          args = composeArgs(args, partials, holders, isCurried);
        }
        if (partialsRight) {
          args = composeArgsRight(args, partialsRight, holdersRight, isCurried);
        }
        length -= holdersCount;
        if (isCurried && length < arity) {
          var newHolders = replaceHolders(args, placeholder);
          return createRecurry(
            func, bitmask, createHybrid, wrapper.placeholder, thisArg,
            args, newHolders, argPos, ary, arity - length
          );
        }
        var thisBinding = isBind ? thisArg : this,
            fn = isBindKey ? thisBinding[func] : func;

        length = args.length;
        if (argPos) {
          args = reorder(args, argPos);
        } else if (isFlip && length > 1) {
          args.reverse();
        }
        if (isAry && ary < length) {
          args.length = ary;
        }
        if (this && this !== root && this instanceof wrapper) {
          fn = Ctor || createCtor(fn);
        }
        return fn.apply(thisBinding, args);
      }
      return wrapper;
    }

    /**
     * Creates a function like `_.invertBy`.
     *
     * @private
     * @param {Function} setter The function to set accumulator values.
     * @param {Function} toIteratee The function to resolve iteratees.
     * @returns {Function} Returns the new inverter function.
     */
    function createInverter(setter, toIteratee) {
      return function(object, iteratee) {
        return baseInverter(object, setter, toIteratee(iteratee), {});
      };
    }

    /**
     * Creates a function that performs a mathematical operation on two values.
     *
     * @private
     * @param {Function} operator The function to perform the operation.
     * @param {number} [defaultValue] The value used for `undefined` arguments.
     * @returns {Function} Returns the new mathematical operation function.
     */
    function createMathOperation(operator, defaultValue) {
      return function(value, other) {
        var result;
        if (value === undefined && other === undefined) {
          return defaultValue;
        }
        if (value !== undefined) {
          result = value;
        }
        if (other !== undefined) {
          if (result === undefined) {
            return other;
          }
          if (typeof value == 'string' || typeof other == 'string') {
            value = baseToString(value);
            other = baseToString(other);
          } else {
            value = baseToNumber(value);
            other = baseToNumber(other);
          }
          result = operator(value, other);
        }
        return result;
      };
    }

    /**
     * Creates a function like `_.over`.
     *
     * @private
     * @param {Function} arrayFunc The function to iterate over iteratees.
     * @returns {Function} Returns the new over function.
     */
    function createOver(arrayFunc) {
      return flatRest(function(iteratees) {
        iteratees = arrayMap(iteratees, baseUnary(getIteratee()));
        return baseRest(function(args) {
          var thisArg = this;
          return arrayFunc(iteratees, function(iteratee) {
            return apply(iteratee, thisArg, args);
          });
        });
      });
    }

    /**
     * Creates the padding for `string` based on `length`. The `chars` string
     * is truncated if the number of characters exceeds `length`.
     *
     * @private
     * @param {number} length The padding length.
     * @param {string} [chars=' '] The string used as padding.
     * @returns {string} Returns the padding for `string`.
     */
    function createPadding(length, chars) {
      chars = chars === undefined ? ' ' : baseToString(chars);

      var charsLength = chars.length;
      if (charsLength < 2) {
        return charsLength ? baseRepeat(chars, length) : chars;
      }
      var result = baseRepeat(chars, nativeCeil(length / stringSize(chars)));
      return hasUnicode(chars)
        ? castSlice(stringToArray(result), 0, length).join('')
        : result.slice(0, length);
    }

    /**
     * Creates a function that wraps `func` to invoke it with the `this` binding
     * of `thisArg` and `partials` prepended to the arguments it receives.
     *
     * @private
     * @param {Function} func The function to wrap.
     * @param {number} bitmask The bitmask flags. See `createWrap` for more details.
     * @param {*} thisArg The `this` binding of `func`.
     * @param {Array} partials The arguments to prepend to those provided to
     *  the new function.
     * @returns {Function} Returns the new wrapped function.
     */
    function createPartial(func, bitmask, thisArg, partials) {
      var isBind = bitmask & WRAP_BIND_FLAG,
          Ctor = createCtor(func);

      function wrapper() {
        var argsIndex = -1,
            argsLength = arguments.length,
            leftIndex = -1,
            leftLength = partials.length,
            args = Array(leftLength + argsLength),
            fn = (this && this !== root && this instanceof wrapper) ? Ctor : func;

        while (++leftIndex < leftLength) {
          args[leftIndex] = partials[leftIndex];
        }
        while (argsLength--) {
          args[leftIndex++] = arguments[++argsIndex];
        }
        return apply(fn, isBind ? thisArg : this, args);
      }
      return wrapper;
    }

    /**
     * Creates a `_.range` or `_.rangeRight` function.
     *
     * @private
     * @param {boolean} [fromRight] Specify iterating from right to left.
     * @returns {Function} Returns the new range function.
     */
    function createRange(fromRight) {
      return function(start, end, step) {
        if (step && typeof step != 'number' && isIterateeCall(start, end, step)) {
          end = step = undefined;
        }
        // Ensure the sign of `-0` is preserved.
        start = toFinite(start);
        if (end === undefined) {
          end = start;
          start = 0;
        } else {
          end = toFinite(end);
        }
        step = step === undefined ? (start < end ? 1 : -1) : toFinite(step);
        return baseRange(start, end, step, fromRight);
      };
    }

    /**
     * Creates a function that performs a relational operation on two values.
     *
     * @private
     * @param {Function} operator The function to perform the operation.
     * @returns {Function} Returns the new relational operation function.
     */
    function createRelationalOperation(operator) {
      return function(value, other) {
        if (!(typeof value == 'string' && typeof other == 'string')) {
          value = toNumber(value);
          other = toNumber(other);
        }
        return operator(value, other);
      };
    }

    /**
     * Creates a function that wraps `func` to continue currying.
     *
     * @private
     * @param {Function} func The function to wrap.
     * @param {number} bitmask The bitmask flags. See `createWrap` for more details.
     * @param {Function} wrapFunc The function to create the `func` wrapper.
     * @param {*} placeholder The placeholder value.
     * @param {*} [thisArg] The `this` binding of `func`.
     * @param {Array} [partials] The arguments to prepend to those provided to
     *  the new function.
     * @param {Array} [holders] The `partials` placeholder indexes.
     * @param {Array} [argPos] The argument positions of the new function.
     * @param {number} [ary] The arity cap of `func`.
     * @param {number} [arity] The arity of `func`.
     * @returns {Function} Returns the new wrapped function.
     */
    function createRecurry(func, bitmask, wrapFunc, placeholder, thisArg, partials, holders, argPos, ary, arity) {
      var isCurry = bitmask & WRAP_CURRY_FLAG,
          newHolders = isCurry ? holders : undefined,
          newHoldersRight = isCurry ? undefined : holders,
          newPartials = isCurry ? partials : undefined,
          newPartialsRight = isCurry ? undefined : partials;

      bitmask |= (isCurry ? WRAP_PARTIAL_FLAG : WRAP_PARTIAL_RIGHT_FLAG);
      bitmask &= ~(isCurry ? WRAP_PARTIAL_RIGHT_FLAG : WRAP_PARTIAL_FLAG);

      if (!(bitmask & WRAP_CURRY_BOUND_FLAG)) {
        bitmask &= ~(WRAP_BIND_FLAG | WRAP_BIND_KEY_FLAG);
      }
      var newData = [
        func, bitmask, thisArg, newPartials, newHolders, newPartialsRight,
        newHoldersRight, argPos, ary, arity
      ];

      var result = wrapFunc.apply(undefined, newData);
      if (isLaziable(func)) {
        setData(result, newData);
      }
      result.placeholder = placeholder;
      return setWrapToString(result, func, bitmask);
    }

    /**
     * Creates a function like `_.round`.
     *
     * @private
     * @param {string} methodName The name of the `Math` method to use when rounding.
     * @returns {Function} Returns the new round function.
     */
    function createRound(methodName) {
      var func = Math[methodName];
      return function(number, precision) {
        number = toNumber(number);
        precision = precision == null ? 0 : nativeMin(toInteger(precision), 292);
        if (precision && nativeIsFinite(number)) {
          // Shift with exponential notation to avoid floating-point issues.
          // See [MDN](https://mdn.io/round#Examples) for more details.
          var pair = (toString(number) + 'e').split('e'),
              value = func(pair[0] + 'e' + (+pair[1] + precision));

          pair = (toString(value) + 'e').split('e');
          return +(pair[0] + 'e' + (+pair[1] - precision));
        }
        return func(number);
      };
    }

    /**
     * Creates a set object of `values`.
     *
     * @private
     * @param {Array} values The values to add to the set.
     * @returns {Object} Returns the new set.
     */
    var createSet = !(Set && (1 / setToArray(new Set([,-0]))[1]) == INFINITY) ? noop : function(values) {
      return new Set(values);
    };

    /**
     * Creates a `_.toPairs` or `_.toPairsIn` function.
     *
     * @private
     * @param {Function} keysFunc The function to get the keys of a given object.
     * @returns {Function} Returns the new pairs function.
     */
    function createToPairs(keysFunc) {
      return function(object) {
        var tag = getTag(object);
        if (tag == mapTag) {
          return mapToArray(object);
        }
        if (tag == setTag) {
          return setToPairs(object);
        }
        return baseToPairs(object, keysFunc(object));
      };
    }

    /**
     * Creates a function that either curries or invokes `func` with optional
     * `this` binding and partially applied arguments.
     *
     * @private
     * @param {Function|string} func The function or method name to wrap.
     * @param {number} bitmask The bitmask flags.
     *    1 - `_.bind`
     *    2 - `_.bindKey`
     *    4 - `_.curry` or `_.curryRight` of a bound function
     *    8 - `_.curry`
     *   16 - `_.curryRight`
     *   32 - `_.partial`
     *   64 - `_.partialRight`
     *  128 - `_.rearg`
     *  256 - `_.ary`
     *  512 - `_.flip`
     * @param {*} [thisArg] The `this` binding of `func`.
     * @param {Array} [partials] The arguments to be partially applied.
     * @param {Array} [holders] The `partials` placeholder indexes.
     * @param {Array} [argPos] The argument positions of the new function.
     * @param {number} [ary] The arity cap of `func`.
     * @param {number} [arity] The arity of `func`.
     * @returns {Function} Returns the new wrapped function.
     */
    function createWrap(func, bitmask, thisArg, partials, holders, argPos, ary, arity) {
      var isBindKey = bitmask & WRAP_BIND_KEY_FLAG;
      if (!isBindKey && typeof func != 'function') {
        throw new TypeError(FUNC_ERROR_TEXT);
      }
      var length = partials ? partials.length : 0;
      if (!length) {
        bitmask &= ~(WRAP_PARTIAL_FLAG | WRAP_PARTIAL_RIGHT_FLAG);
        partials = holders = undefined;
      }
      ary = ary === undefined ? ary : nativeMax(toInteger(ary), 0);
      arity = arity === undefined ? arity : toInteger(arity);
      length -= holders ? holders.length : 0;

      if (bitmask & WRAP_PARTIAL_RIGHT_FLAG) {
        var partialsRight = partials,
            holdersRight = holders;

        partials = holders = undefined;
      }
      var data = isBindKey ? undefined : getData(func);

      var newData = [
        func, bitmask, thisArg, partials, holders, partialsRight, holdersRight,
        argPos, ary, arity
      ];

      if (data) {
        mergeData(newData, data);
      }
      func = newData[0];
      bitmask = newData[1];
      thisArg = newData[2];
      partials = newData[3];
      holders = newData[4];
      arity = newData[9] = newData[9] === undefined
        ? (isBindKey ? 0 : func.length)
        : nativeMax(newData[9] - length, 0);

      if (!arity && bitmask & (WRAP_CURRY_FLAG | WRAP_CURRY_RIGHT_FLAG)) {
        bitmask &= ~(WRAP_CURRY_FLAG | WRAP_CURRY_RIGHT_FLAG);
      }
      if (!bitmask || bitmask == WRAP_BIND_FLAG) {
        var result = createBind(func, bitmask, thisArg);
      } else if (bitmask == WRAP_CURRY_FLAG || bitmask == WRAP_CURRY_RIGHT_FLAG) {
        result = createCurry(func, bitmask, arity);
      } else if ((bitmask == WRAP_PARTIAL_FLAG || bitmask == (WRAP_BIND_FLAG | WRAP_PARTIAL_FLAG)) && !holders.length) {
        result = createPartial(func, bitmask, thisArg, partials);
      } else {
        result = createHybrid.apply(undefined, newData);
      }
      var setter = data ? baseSetData : setData;
      return setWrapToString(setter(result, newData), func, bitmask);
    }

    /**
     * Used by `_.defaults` to customize its `_.assignIn` use to assign properties
     * of source objects to the destination object for all destination properties
     * that resolve to `undefined`.
     *
     * @private
     * @param {*} objValue The destination value.
     * @param {*} srcValue The source value.
     * @param {string} key The key of the property to assign.
     * @param {Object} object The parent object of `objValue`.
     * @returns {*} Returns the value to assign.
     */
    function customDefaultsAssignIn(objValue, srcValue, key, object) {
      if (objValue === undefined ||
          (eq(objValue, objectProto[key]) && !hasOwnProperty.call(object, key))) {
        return srcValue;
      }
      return objValue;
    }

    /**
     * Used by `_.defaultsDeep` to customize its `_.merge` use to merge source
     * objects into destination objects that are passed thru.
     *
     * @private
     * @param {*} objValue The destination value.
     * @param {*} srcValue The source value.
     * @param {string} key The key of the property to merge.
     * @param {Object} object The parent object of `objValue`.
     * @param {Object} source The parent object of `srcValue`.
     * @param {Object} [stack] Tracks traversed source values and their merged
     *  counterparts.
     * @returns {*} Returns the value to assign.
     */
    function customDefaultsMerge(objValue, srcValue, key, object, source, stack) {
      if (isObject(objValue) && isObject(srcValue)) {
        // Recursively merge objects and arrays (susceptible to call stack limits).
        stack.set(srcValue, objValue);
        baseMerge(objValue, srcValue, undefined, customDefaultsMerge, stack);
        stack['delete'](srcValue);
      }
      return objValue;
    }

    /**
     * Used by `_.omit` to customize its `_.cloneDeep` use to only clone plain
     * objects.
     *
     * @private
     * @param {*} value The value to inspect.
     * @param {string} key The key of the property to inspect.
     * @returns {*} Returns the uncloned value or `undefined` to defer cloning to `_.cloneDeep`.
     */
    function customOmitClone(value) {
      return isPlainObject(value) ? undefined : value;
    }

    /**
     * A specialized version of `baseIsEqualDeep` for arrays with support for
     * partial deep comparisons.
     *
     * @private
     * @param {Array} array The array to compare.
     * @param {Array} other The other array to compare.
     * @param {number} bitmask The bitmask flags. See `baseIsEqual` for more details.
     * @param {Function} customizer The function to customize comparisons.
     * @param {Function} equalFunc The function to determine equivalents of values.
     * @param {Object} stack Tracks traversed `array` and `other` objects.
     * @returns {boolean} Returns `true` if the arrays are equivalent, else `false`.
     */
    function equalArrays(array, other, bitmask, customizer, equalFunc, stack) {
      var isPartial = bitmask & COMPARE_PARTIAL_FLAG,
          arrLength = array.length,
          othLength = other.length;

      if (arrLength != othLength && !(isPartial && othLength > arrLength)) {
        return false;
      }
      // Assume cyclic values are equal.
      var stacked = stack.get(array);
      if (stacked && stack.get(other)) {
        return stacked == other;
      }
      var index = -1,
          result = true,
          seen = (bitmask & COMPARE_UNORDERED_FLAG) ? new SetCache : undefined;

      stack.set(array, other);
      stack.set(other, array);

      // Ignore non-index properties.
      while (++index < arrLength) {
        var arrValue = array[index],
            othValue = other[index];

        if (customizer) {
          var compared = isPartial
            ? customizer(othValue, arrValue, index, other, array, stack)
            : customizer(arrValue, othValue, index, array, other, stack);
        }
        if (compared !== undefined) {
          if (compared) {
            continue;
          }
          result = false;
          break;
        }
        // Recursively compare arrays (susceptible to call stack limits).
        if (seen) {
          if (!arraySome(other, function(othValue, othIndex) {
                if (!cacheHas(seen, othIndex) &&
                    (arrValue === othValue || equalFunc(arrValue, othValue, bitmask, customizer, stack))) {
                  return seen.push(othIndex);
                }
              })) {
            result = false;
            break;
          }
        } else if (!(
              arrValue === othValue ||
                equalFunc(arrValue, othValue, bitmask, customizer, stack)
            )) {
          result = false;
          break;
        }
      }
      stack['delete'](array);
      stack['delete'](other);
      return result;
    }

    /**
     * A specialized version of `baseIsEqualDeep` for comparing objects of
     * the same `toStringTag`.
     *
     * **Note:** This function only supports comparing values with tags of
     * `Boolean`, `Date`, `Error`, `Number`, `RegExp`, or `String`.
     *
     * @private
     * @param {Object} object The object to compare.
     * @param {Object} other The other object to compare.
     * @param {string} tag The `toStringTag` of the objects to compare.
     * @param {number} bitmask The bitmask flags. See `baseIsEqual` for more details.
     * @param {Function} customizer The function to customize comparisons.
     * @param {Function} equalFunc The function to determine equivalents of values.
     * @param {Object} stack Tracks traversed `object` and `other` objects.
     * @returns {boolean} Returns `true` if the objects are equivalent, else `false`.
     */
    function equalByTag(object, other, tag, bitmask, customizer, equalFunc, stack) {
      switch (tag) {
        case dataViewTag:
          if ((object.byteLength != other.byteLength) ||
              (object.byteOffset != other.byteOffset)) {
            return false;
          }
          object = object.buffer;
          other = other.buffer;

        case arrayBufferTag:
          if ((object.byteLength != other.byteLength) ||
              !equalFunc(new Uint8Array(object), new Uint8Array(other))) {
            return false;
          }
          return true;

        case boolTag:
        case dateTag:
        case numberTag:
          // Coerce booleans to `1` or `0` and dates to milliseconds.
          // Invalid dates are coerced to `NaN`.
          return eq(+object, +other);

        case errorTag:
          return object.name == other.name && object.message == other.message;

        case regexpTag:
        case stringTag:
          // Coerce regexes to strings and treat strings, primitives and objects,
          // as equal. See http://www.ecma-international.org/ecma-262/7.0/#sec-regexp.prototype.tostring
          // for more details.
          return object == (other + '');

        case mapTag:
          var convert = mapToArray;

        case setTag:
          var isPartial = bitmask & COMPARE_PARTIAL_FLAG;
          convert || (convert = setToArray);

          if (object.size != other.size && !isPartial) {
            return false;
          }
          // Assume cyclic values are equal.
          var stacked = stack.get(object);
          if (stacked) {
            return stacked == other;
          }
          bitmask |= COMPARE_UNORDERED_FLAG;

          // Recursively compare objects (susceptible to call stack limits).
          stack.set(object, other);
          var result = equalArrays(convert(object), convert(other), bitmask, customizer, equalFunc, stack);
          stack['delete'](object);
          return result;

        case symbolTag:
          if (symbolValueOf) {
            return symbolValueOf.call(object) == symbolValueOf.call(other);
          }
      }
      return false;
    }

    /**
     * A specialized version of `baseIsEqualDeep` for objects with support for
     * partial deep comparisons.
     *
     * @private
     * @param {Object} object The object to compare.
     * @param {Object} other The other object to compare.
     * @param {number} bitmask The bitmask flags. See `baseIsEqual` for more details.
     * @param {Function} customizer The function to customize comparisons.
     * @param {Function} equalFunc The function to determine equivalents of values.
     * @param {Object} stack Tracks traversed `object` and `other` objects.
     * @returns {boolean} Returns `true` if the objects are equivalent, else `false`.
     */
    function equalObjects(object, other, bitmask, customizer, equalFunc, stack) {
      var isPartial = bitmask & COMPARE_PARTIAL_FLAG,
          objProps = getAllKeys(object),
          objLength = objProps.length,
          othProps = getAllKeys(other),
          othLength = othProps.length;

      if (objLength != othLength && !isPartial) {
        return false;
      }
      var index = objLength;
      while (index--) {
        var key = objProps[index];
        if (!(isPartial ? key in other : hasOwnProperty.call(other, key))) {
          return false;
        }
      }
      // Assume cyclic values are equal.
      var stacked = stack.get(object);
      if (stacked && stack.get(other)) {
        return stacked == other;
      }
      var result = true;
      stack.set(object, other);
      stack.set(other, object);

      var skipCtor = isPartial;
      while (++index < objLength) {
        key = objProps[index];
        var objValue = object[key],
            othValue = other[key];

        if (customizer) {
          var compared = isPartial
            ? customizer(othValue, objValue, key, other, object, stack)
            : customizer(objValue, othValue, key, object, other, stack);
        }
        // Recursively compare objects (susceptible to call stack limits).
        if (!(compared === undefined
              ? (objValue === othValue || equalFunc(objValue, othValue, bitmask, customizer, stack))
              : compared
            )) {
          result = false;
          break;
        }
        skipCtor || (skipCtor = key == 'constructor');
      }
      if (result && !skipCtor) {
        var objCtor = object.constructor,
            othCtor = other.constructor;

        // Non `Object` object instances with different constructors are not equal.
        if (objCtor != othCtor &&
            ('constructor' in object && 'constructor' in other) &&
            !(typeof objCtor == 'function' && objCtor instanceof objCtor &&
              typeof othCtor == 'function' && othCtor instanceof othCtor)) {
          result = false;
        }
      }
      stack['delete'](object);
      stack['delete'](other);
      return result;
    }

    /**
     * A specialized version of `baseRest` which flattens the rest array.
     *
     * @private
     * @param {Function} func The function to apply a rest parameter to.
     * @returns {Function} Returns the new function.
     */
    function flatRest(func) {
      return setToString(overRest(func, undefined, flatten), func + '');
    }

    /**
     * Creates an array of own enumerable property names and symbols of `object`.
     *
     * @private
     * @param {Object} object The object to query.
     * @returns {Array} Returns the array of property names and symbols.
     */
    function getAllKeys(object) {
      return baseGetAllKeys(object, keys, getSymbols);
    }

    /**
     * Creates an array of own and inherited enumerable property names and
     * symbols of `object`.
     *
     * @private
     * @param {Object} object The object to query.
     * @returns {Array} Returns the array of property names and symbols.
     */
    function getAllKeysIn(object) {
      return baseGetAllKeys(object, keysIn, getSymbolsIn);
    }

    /**
     * Gets metadata for `func`.
     *
     * @private
     * @param {Function} func The function to query.
     * @returns {*} Returns the metadata for `func`.
     */
    var getData = !metaMap ? noop : function(func) {
      return metaMap.get(func);
    };

    /**
     * Gets the name of `func`.
     *
     * @private
     * @param {Function} func The function to query.
     * @returns {string} Returns the function name.
     */
    function getFuncName(func) {
      var result = (func.name + ''),
          array = realNames[result],
          length = hasOwnProperty.call(realNames, result) ? array.length : 0;

      while (length--) {
        var data = array[length],
            otherFunc = data.func;
        if (otherFunc == null || otherFunc == func) {
          return data.name;
        }
      }
      return result;
    }

    /**
     * Gets the argument placeholder value for `func`.
     *
     * @private
     * @param {Function} func The function to inspect.
     * @returns {*} Returns the placeholder value.
     */
    function getHolder(func) {
      var object = hasOwnProperty.call(lodash, 'placeholder') ? lodash : func;
      return object.placeholder;
    }

    /**
     * Gets the appropriate "iteratee" function. If `_.iteratee` is customized,
     * this function returns the custom method, otherwise it returns `baseIteratee`.
     * If arguments are provided, the chosen function is invoked with them and
     * its result is returned.
     *
     * @private
     * @param {*} [value] The value to convert to an iteratee.
     * @param {number} [arity] The arity of the created iteratee.
     * @returns {Function} Returns the chosen function or its result.
     */
    function getIteratee() {
      var result = lodash.iteratee || iteratee;
      result = result === iteratee ? baseIteratee : result;
      return arguments.length ? result(arguments[0], arguments[1]) : result;
    }

    /**
     * Gets the data for `map`.
     *
     * @private
     * @param {Object} map The map to query.
     * @param {string} key The reference key.
     * @returns {*} Returns the map data.
     */
    function getMapData(map, key) {
      var data = map.__data__;
      return isKeyable(key)
        ? data[typeof key == 'string' ? 'string' : 'hash']
        : data.map;
    }

    /**
     * Gets the property names, values, and compare flags of `object`.
     *
     * @private
     * @param {Object} object The object to query.
     * @returns {Array} Returns the match data of `object`.
     */
    function getMatchData(object) {
      var result = keys(object),
          length = result.length;

      while (length--) {
        var key = result[length],
            value = object[key];

        result[length] = [key, value, isStrictComparable(value)];
      }
      return result;
    }

    /**
     * Gets the native function at `key` of `object`.
     *
     * @private
     * @param {Object} object The object to query.
     * @param {string} key The key of the method to get.
     * @returns {*} Returns the function if it's native, else `undefined`.
     */
    function getNative(object, key) {
      var value = getValue(object, key);
      return baseIsNative(value) ? value : undefined;
    }

    /**
     * A specialized version of `baseGetTag` which ignores `Symbol.toStringTag` values.
     *
     * @private
     * @param {*} value The value to query.
     * @returns {string} Returns the raw `toStringTag`.
     */
    function getRawTag(value) {
      var isOwn = hasOwnProperty.call(value, symToStringTag),
          tag = value[symToStringTag];

      try {
        value[symToStringTag] = undefined;
        var unmasked = true;
      } catch (e) {}

      var result = nativeObjectToString.call(value);
      if (unmasked) {
        if (isOwn) {
          value[symToStringTag] = tag;
        } else {
          delete value[symToStringTag];
        }
      }
      return result;
    }

    /**
     * Creates an array of the own enumerable symbols of `object`.
     *
     * @private
     * @param {Object} object The object to query.
     * @returns {Array} Returns the array of symbols.
     */
    var getSymbols = !nativeGetSymbols ? stubArray : function(object) {
      if (object == null) {
        return [];
      }
      object = Object(object);
      return arrayFilter(nativeGetSymbols(object), function(symbol) {
        return propertyIsEnumerable.call(object, symbol);
      });
    };

    /**
     * Creates an array of the own and inherited enumerable symbols of `object`.
     *
     * @private
     * @param {Object} object The object to query.
     * @returns {Array} Returns the array of symbols.
     */
    var getSymbolsIn = !nativeGetSymbols ? stubArray : function(object) {
      var result = [];
      while (object) {
        arrayPush(result, getSymbols(object));
        object = getPrototype(object);
      }
      return result;
    };

    /**
     * Gets the `toStringTag` of `value`.
     *
     * @private
     * @param {*} value The value to query.
     * @returns {string} Returns the `toStringTag`.
     */
    var getTag = baseGetTag;

    // Fallback for data views, maps, sets, and weak maps in IE 11 and promises in Node.js < 6.
    if ((DataView && getTag(new DataView(new ArrayBuffer(1))) != dataViewTag) ||
        (Map && getTag(new Map) != mapTag) ||
        (Promise && getTag(Promise.resolve()) != promiseTag) ||
        (Set && getTag(new Set) != setTag) ||
        (WeakMap && getTag(new WeakMap) != weakMapTag)) {
      getTag = function(value) {
        var result = baseGetTag(value),
            Ctor = result == objectTag ? value.constructor : undefined,
            ctorString = Ctor ? toSource(Ctor) : '';

        if (ctorString) {
          switch (ctorString) {
            case dataViewCtorString: return dataViewTag;
            case mapCtorString: return mapTag;
            case promiseCtorString: return promiseTag;
            case setCtorString: return setTag;
            case weakMapCtorString: return weakMapTag;
          }
        }
        return result;
      };
    }

    /**
     * Gets the view, applying any `transforms` to the `start` and `end` positions.
     *
     * @private
     * @param {number} start The start of the view.
     * @param {number} end The end of the view.
     * @param {Array} transforms The transformations to apply to the view.
     * @returns {Object} Returns an object containing the `start` and `end`
     *  positions of the view.
     */
    function getView(start, end, transforms) {
      var index = -1,
          length = transforms.length;

      while (++index < length) {
        var data = transforms[index],
            size = data.size;

        switch (data.type) {
          case 'drop':      start += size; break;
          case 'dropRight': end -= size; break;
          case 'take':      end = nativeMin(end, start + size); break;
          case 'takeRight': start = nativeMax(start, end - size); break;
        }
      }
      return { 'start': start, 'end': end };
    }

    /**
     * Extracts wrapper details from the `source` body comment.
     *
     * @private
     * @param {string} source The source to inspect.
     * @returns {Array} Returns the wrapper details.
     */
    function getWrapDetails(source) {
      var match = source.match(reWrapDetails);
      return match ? match[1].split(reSplitDetails) : [];
    }

    /**
     * Checks if `path` exists on `object`.
     *
     * @private
     * @param {Object} object The object to query.
     * @param {Array|string} path The path to check.
     * @param {Function} hasFunc The function to check properties.
     * @returns {boolean} Returns `true` if `path` exists, else `false`.
     */
    function hasPath(object, path, hasFunc) {
      path = castPath(path, object);

      var index = -1,
          length = path.length,
          result = false;

      while (++index < length) {
        var key = toKey(path[index]);
        if (!(result = object != null && hasFunc(object, key))) {
          break;
        }
        object = object[key];
      }
      if (result || ++index != length) {
        return result;
      }
      length = object == null ? 0 : object.length;
      return !!length && isLength(length) && isIndex(key, length) &&
        (isArray(object) || isArguments(object));
    }

    /**
     * Initializes an array clone.
     *
     * @private
     * @param {Array} array The array to clone.
     * @returns {Array} Returns the initialized clone.
     */
    function initCloneArray(array) {
      var length = array.length,
          result = new array.constructor(length);

      // Add properties assigned by `RegExp#exec`.
      if (length && typeof array[0] == 'string' && hasOwnProperty.call(array, 'index')) {
        result.index = array.index;
        result.input = array.input;
      }
      return result;
    }

    /**
     * Initializes an object clone.
     *
     * @private
     * @param {Object} object The object to clone.
     * @returns {Object} Returns the initialized clone.
     */
    function initCloneObject(object) {
      return (typeof object.constructor == 'function' && !isPrototype(object))
        ? baseCreate(getPrototype(object))
        : {};
    }

    /**
     * Initializes an object clone based on its `toStringTag`.
     *
     * **Note:** This function only supports cloning values with tags of
     * `Boolean`, `Date`, `Error`, `Map`, `Number`, `RegExp`, `Set`, or `String`.
     *
     * @private
     * @param {Object} object The object to clone.
     * @param {string} tag The `toStringTag` of the object to clone.
     * @param {boolean} [isDeep] Specify a deep clone.
     * @returns {Object} Returns the initialized clone.
     */
    function initCloneByTag(object, tag, isDeep) {
      var Ctor = object.constructor;
      switch (tag) {
        case arrayBufferTag:
          return cloneArrayBuffer(object);

        case boolTag:
        case dateTag:
          return new Ctor(+object);

        case dataViewTag:
          return cloneDataView(object, isDeep);

        case float32Tag: case float64Tag:
        case int8Tag: case int16Tag: case int32Tag:
        case uint8Tag: case uint8ClampedTag: case uint16Tag: case uint32Tag:
          return cloneTypedArray(object, isDeep);

        case mapTag:
          return new Ctor;

        case numberTag:
        case stringTag:
          return new Ctor(object);

        case regexpTag:
          return cloneRegExp(object);

        case setTag:
          return new Ctor;

        case symbolTag:
          return cloneSymbol(object);
      }
    }

    /**
     * Inserts wrapper `details` in a comment at the top of the `source` body.
     *
     * @private
     * @param {string} source The source to modify.
     * @returns {Array} details The details to insert.
     * @returns {string} Returns the modified source.
     */
    function insertWrapDetails(source, details) {
      var length = details.length;
      if (!length) {
        return source;
      }
      var lastIndex = length - 1;
      details[lastIndex] = (length > 1 ? '& ' : '') + details[lastIndex];
      details = details.join(length > 2 ? ', ' : ' ');
      return source.replace(reWrapComment, '{\n/* [wrapped with ' + details + '] */\n');
    }

    /**
     * Checks if `value` is a flattenable `arguments` object or array.
     *
     * @private
     * @param {*} value The value to check.
     * @returns {boolean} Returns `true` if `value` is flattenable, else `false`.
     */
    function isFlattenable(value) {
      return isArray(value) || isArguments(value) ||
        !!(spreadableSymbol && value && value[spreadableSymbol]);
    }

    /**
     * Checks if `value` is a valid array-like index.
     *
     * @private
     * @param {*} value The value to check.
     * @param {number} [length=MAX_SAFE_INTEGER] The upper bounds of a valid index.
     * @returns {boolean} Returns `true` if `value` is a valid index, else `false`.
     */
    function isIndex(value, length) {
      var type = typeof value;
      length = length == null ? MAX_SAFE_INTEGER : length;

      return !!length &&
        (type == 'number' ||
          (type != 'symbol' && reIsUint.test(value))) &&
            (value > -1 && value % 1 == 0 && value < length);
    }

    /**
     * Checks if the given arguments are from an iteratee call.
     *
     * @private
     * @param {*} value The potential iteratee value argument.
     * @param {*} index The potential iteratee index or key argument.
     * @param {*} object The potential iteratee object argument.
     * @returns {boolean} Returns `true` if the arguments are from an iteratee call,
     *  else `false`.
     */
    function isIterateeCall(value, index, object) {
      if (!isObject(object)) {
        return false;
      }
      var type = typeof index;
      if (type == 'number'
            ? (isArrayLike(object) && isIndex(index, object.length))
            : (type == 'string' && index in object)
          ) {
        return eq(object[index], value);
      }
      return false;
    }

    /**
     * Checks if `value` is a property name and not a property path.
     *
     * @private
     * @param {*} value The value to check.
     * @param {Object} [object] The object to query keys on.
     * @returns {boolean} Returns `true` if `value` is a property name, else `false`.
     */
    function isKey(value, object) {
      if (isArray(value)) {
        return false;
      }
      var type = typeof value;
      if (type == 'number' || type == 'symbol' || type == 'boolean' ||
          value == null || isSymbol(value)) {
        return true;
      }
      return reIsPlainProp.test(value) || !reIsDeepProp.test(value) ||
        (object != null && value in Object(object));
    }

    /**
     * Checks if `value` is suitable for use as unique object key.
     *
     * @private
     * @param {*} value The value to check.
     * @returns {boolean} Returns `true` if `value` is suitable, else `false`.
     */
    function isKeyable(value) {
      var type = typeof value;
      return (type == 'string' || type == 'number' || type == 'symbol' || type == 'boolean')
        ? (value !== '__proto__')
        : (value === null);
    }

    /**
     * Checks if `func` has a lazy counterpart.
     *
     * @private
     * @param {Function} func The function to check.
     * @returns {boolean} Returns `true` if `func` has a lazy counterpart,
     *  else `false`.
     */
    function isLaziable(func) {
      var funcName = getFuncName(func),
          other = lodash[funcName];

      if (typeof other != 'function' || !(funcName in LazyWrapper.prototype)) {
        return false;
      }
      if (func === other) {
        return true;
      }
      var data = getData(other);
      return !!data && func === data[0];
    }

    /**
     * Checks if `func` has its source masked.
     *
     * @private
     * @param {Function} func The function to check.
     * @returns {boolean} Returns `true` if `func` is masked, else `false`.
     */
    function isMasked(func) {
      return !!maskSrcKey && (maskSrcKey in func);
    }

    /**
     * Checks if `func` is capable of being masked.
     *
     * @private
     * @param {*} value The value to check.
     * @returns {boolean} Returns `true` if `func` is maskable, else `false`.
     */
    var isMaskable = coreJsData ? isFunction : stubFalse;

    /**
     * Checks if `value` is likely a prototype object.
     *
     * @private
     * @param {*} value The value to check.
     * @returns {boolean} Returns `true` if `value` is a prototype, else `false`.
     */
    function isPrototype(value) {
      var Ctor = value && value.constructor,
          proto = (typeof Ctor == 'function' && Ctor.prototype) || objectProto;

      return value === proto;
    }

    /**
     * Checks if `value` is suitable for strict equality comparisons, i.e. `===`.
     *
     * @private
     * @param {*} value The value to check.
     * @returns {boolean} Returns `true` if `value` if suitable for strict
     *  equality comparisons, else `false`.
     */
    function isStrictComparable(value) {
      return value === value && !isObject(value);
    }

    /**
     * A specialized version of `matchesProperty` for source values suitable
     * for strict equality comparisons, i.e. `===`.
     *
     * @private
     * @param {string} key The key of the property to get.
     * @param {*} srcValue The value to match.
     * @returns {Function} Returns the new spec function.
     */
    function matchesStrictComparable(key, srcValue) {
      return function(object) {
        if (object == null) {
          return false;
        }
        return object[key] === srcValue &&
          (srcValue !== undefined || (key in Object(object)));
      };
    }

    /**
     * A specialized version of `_.memoize` which clears the memoized function's
     * cache when it exceeds `MAX_MEMOIZE_SIZE`.
     *
     * @private
     * @param {Function} func The function to have its output memoized.
     * @returns {Function} Returns the new memoized function.
     */
    function memoizeCapped(func) {
      var result = memoize(func, function(key) {
        if (cache.size === MAX_MEMOIZE_SIZE) {
          cache.clear();
        }
        return key;
      });

      var cache = result.cache;
      return result;
    }

    /**
     * Merges the function metadata of `source` into `data`.
     *
     * Merging metadata reduces the number of wrappers used to invoke a function.
     * This is possible because methods like `_.bind`, `_.curry`, and `_.partial`
     * may be applied regardless of execution order. Methods like `_.ary` and
     * `_.rearg` modify function arguments, making the order in which they are
     * executed important, preventing the merging of metadata. However, we make
     * an exception for a safe combined case where curried functions have `_.ary`
     * and or `_.rearg` applied.
     *
     * @private
     * @param {Array} data The destination metadata.
     * @param {Array} source The source metadata.
     * @returns {Array} Returns `data`.
     */
    function mergeData(data, source) {
      var bitmask = data[1],
          srcBitmask = source[1],
          newBitmask = bitmask | srcBitmask,
          isCommon = newBitmask < (WRAP_BIND_FLAG | WRAP_BIND_KEY_FLAG | WRAP_ARY_FLAG);

      var isCombo =
        ((srcBitmask == WRAP_ARY_FLAG) && (bitmask == WRAP_CURRY_FLAG)) ||
        ((srcBitmask == WRAP_ARY_FLAG) && (bitmask == WRAP_REARG_FLAG) && (data[7].length <= source[8])) ||
        ((srcBitmask == (WRAP_ARY_FLAG | WRAP_REARG_FLAG)) && (source[7].length <= source[8]) && (bitmask == WRAP_CURRY_FLAG));

      // Exit early if metadata can't be merged.
      if (!(isCommon || isCombo)) {
        return data;
      }
      // Use source `thisArg` if available.
      if (srcBitmask & WRAP_BIND_FLAG) {
        data[2] = source[2];
        // Set when currying a bound function.
        newBitmask |= bitmask & WRAP_BIND_FLAG ? 0 : WRAP_CURRY_BOUND_FLAG;
      }
      // Compose partial arguments.
      var value = source[3];
      if (value) {
        var partials = data[3];
        data[3] = partials ? composeArgs(partials, value, source[4]) : value;
        data[4] = partials ? replaceHolders(data[3], PLACEHOLDER) : source[4];
      }
      // Compose partial right arguments.
      value = source[5];
      if (value) {
        partials = data[5];
        data[5] = partials ? composeArgsRight(partials, value, source[6]) : value;
        data[6] = partials ? replaceHolders(data[5], PLACEHOLDER) : source[6];
      }
      // Use source `argPos` if available.
      value = source[7];
      if (value) {
        data[7] = value;
      }
      // Use source `ary` if it's smaller.
      if (srcBitmask & WRAP_ARY_FLAG) {
        data[8] = data[8] == null ? source[8] : nativeMin(data[8], source[8]);
      }
      // Use source `arity` if one is not provided.
      if (data[9] == null) {
        data[9] = source[9];
      }
      // Use source `func` and merge bitmasks.
      data[0] = source[0];
      data[1] = newBitmask;

      return data;
    }

    /**
     * This function is like
     * [`Object.keys`](http://ecma-international.org/ecma-262/7.0/#sec-object.keys)
     * except that it includes inherited enumerable properties.
     *
     * @private
     * @param {Object} object The object to query.
     * @returns {Array} Returns the array of property names.
     */
    function nativeKeysIn(object) {
      var result = [];
      if (object != null) {
        for (var key in Object(object)) {
          result.push(key);
        }
      }
      return result;
    }

    /**
     * Converts `value` to a string using `Object.prototype.toString`.
     *
     * @private
     * @param {*} value The value to convert.
     * @returns {string} Returns the converted string.
     */
    function objectToString(value) {
      return nativeObjectToString.call(value);
    }

    /**
     * A specialized version of `baseRest` which transforms the rest array.
     *
     * @private
     * @param {Function} func The function to apply a rest parameter to.
     * @param {number} [start=func.length-1] The start position of the rest parameter.
     * @param {Function} transform The rest array transform.
     * @returns {Function} Returns the new function.
     */
    function overRest(func, start, transform) {
      start = nativeMax(start === undefined ? (func.length - 1) : start, 0);
      return function() {
        var args = arguments,
            index = -1,
            length = nativeMax(args.length - start, 0),
            array = Array(length);

        while (++index < length) {
          array[index] = args[start + index];
        }
        index = -1;
        var otherArgs = Array(start + 1);
        while (++index < start) {
          otherArgs[index] = args[index];
        }
        otherArgs[start] = transform(array);
        return apply(func, this, otherArgs);
      };
    }

    /**
     * Gets the parent value at `path` of `object`.
     *
     * @private
     * @param {Object} object The object to query.
     * @param {Array} path The path to get the parent value of.
     * @returns {*} Returns the parent value.
     */
    function parent(object, path) {
      return path.length < 2 ? object : baseGet(object, baseSlice(path, 0, -1));
    }

    /**
     * Reorder `array` according to the specified indexes where the element at
     * the first index is assigned as the first element, the element at
     * the second index is assigned as the second element, and so on.
     *
     * @private
     * @param {Array} array The array to reorder.
     * @param {Array} indexes The arranged array indexes.
     * @returns {Array} Returns `array`.
     */
    function reorder(array, indexes) {
      var arrLength = array.length,
          length = nativeMin(indexes.length, arrLength),
          oldArray = copyArray(array);

      while (length--) {
        var index = indexes[length];
        array[length] = isIndex(index, arrLength) ? oldArray[index] : undefined;
      }
      return array;
    }

    /**
     * Gets the value at `key`, unless `key` is "__proto__" or "constructor".
     *
     * @private
     * @param {Object} object The object to query.
     * @param {string} key The key of the property to get.
     * @returns {*} Returns the property value.
     */
    function safeGet(object, key) {
      if (key === 'constructor' && typeof object[key] === 'function') {
        return;
      }

      if (key == '__proto__') {
        return;
      }

      return object[key];
    }

    /**
     * Sets metadata for `func`.
     *
     * **Note:** If this function becomes hot, i.e. is invoked a lot in a short
     * period of time, it will trip its breaker and transition to an identity
     * function to avoid garbage collection pauses in V8. See
     * [V8 issue 2070](https://bugs.chromium.org/p/v8/issues/detail?id=2070)
     * for more details.
     *
     * @private
     * @param {Function} func The function to associate metadata with.
     * @param {*} data The metadata.
     * @returns {Function} Returns `func`.
     */
    var setData = shortOut(baseSetData);

    /**
     * A simple wrapper around the global [`setTimeout`](https://mdn.io/setTimeout).
     *
     * @private
     * @param {Function} func The function to delay.
     * @param {number} wait The number of milliseconds to delay invocation.
     * @returns {number|Object} Returns the timer id or timeout object.
     */
    var setTimeout = ctxSetTimeout || function(func, wait) {
      return root.setTimeout(func, wait);
    };

    /**
     * Sets the `toString` method of `func` to return `string`.
     *
     * @private
     * @param {Function} func The function to modify.
     * @param {Function} string The `toString` result.
     * @returns {Function} Returns `func`.
     */
    var setToString = shortOut(baseSetToString);

    /**
     * Sets the `toString` method of `wrapper` to mimic the source of `reference`
     * with wrapper details in a comment at the top of the source body.
     *
     * @private
     * @param {Function} wrapper The function to modify.
     * @param {Function} reference The reference function.
     * @param {number} bitmask The bitmask flags. See `createWrap` for more details.
     * @returns {Function} Returns `wrapper`.
     */
    function setWrapToString(wrapper, reference, bitmask) {
      var source = (reference + '');
      return setToString(wrapper, insertWrapDetails(source, updateWrapDetails(getWrapDetails(source), bitmask)));
    }

    /**
     * Creates a function that'll short out and invoke `identity` instead
     * of `func` when it's called `HOT_COUNT` or more times in `HOT_SPAN`
     * milliseconds.
     *
     * @private
     * @param {Function} func The function to restrict.
     * @returns {Function} Returns the new shortable function.
     */
    function shortOut(func) {
      var count = 0,
          lastCalled = 0;

      return function() {
        var stamp = nativeNow(),
            remaining = HOT_SPAN - (stamp - lastCalled);

        lastCalled = stamp;
        if (remaining > 0) {
          if (++count >= HOT_COUNT) {
            return arguments[0];
          }
        } else {
          count = 0;
        }
        return func.apply(undefined, arguments);
      };
    }

    /**
     * A specialized version of `_.shuffle` which mutates and sets the size of `array`.
     *
     * @private
     * @param {Array} array The array to shuffle.
     * @param {number} [size=array.length] The size of `array`.
     * @returns {Array} Returns `array`.
     */
    function shuffleSelf(array, size) {
      var index = -1,
          length = array.length,
          lastIndex = length - 1;

      size = size === undefined ? length : size;
      while (++index < size) {
        var rand = baseRandom(index, lastIndex),
            value = array[rand];

        array[rand] = array[index];
        array[index] = value;
      }
      array.length = size;
      return array;
    }

    /**
     * Converts `string` to a property path array.
     *
     * @private
     * @param {string} string The string to convert.
     * @returns {Array} Returns the property path array.
     */
    var stringToPath = memoizeCapped(function(string) {
      var result = [];
      if (string.charCodeAt(0) === 46 /* . */) {
        result.push('');
      }
      string.replace(rePropName, function(match, number, quote, subString) {
        result.push(quote ? subString.replace(reEscapeChar, '$1') : (number || match));
      });
      return result;
    });

    /**
     * Converts `value` to a string key if it's not a string or symbol.
     *
     * @private
     * @param {*} value The value to inspect.
     * @returns {string|symbol} Returns the key.
     */
    function toKey(value) {
      if (typeof value == 'string' || isSymbol(value)) {
        return value;
      }
      var result = (value + '');
      return (result == '0' && (1 / value) == -INFINITY) ? '-0' : result;
    }

    /**
     * Converts `func` to its source code.
     *
     * @private
     * @param {Function} func The function to convert.
     * @returns {string} Returns the source code.
     */
    function toSource(func) {
      if (func != null) {
        try {
          return funcToString.call(func);
        } catch (e) {}
        try {
          return (func + '');
        } catch (e) {}
      }
      return '';
    }

    /**
     * Updates wrapper `details` based on `bitmask` flags.
     *
     * @private
     * @returns {Array} details The details to modify.
     * @param {number} bitmask The bitmask flags. See `createWrap` for more details.
     * @returns {Array} Returns `details`.
     */
    function updateWrapDetails(details, bitmask) {
      arrayEach(wrapFlags, function(pair) {
        var value = '_.' + pair[0];
        if ((bitmask & pair[1]) && !arrayIncludes(details, value)) {
          details.push(value);
        }
      });
      return details.sort();
    }

    /**
     * Creates a clone of `wrapper`.
     *
     * @private
     * @param {Object} wrapper The wrapper to clone.
     * @returns {Object} Returns the cloned wrapper.
     */
    function wrapperClone(wrapper) {
      if (wrapper instanceof LazyWrapper) {
        return wrapper.clone();
      }
      var result = new LodashWrapper(wrapper.__wrapped__, wrapper.__chain__);
      result.__actions__ = copyArray(wrapper.__actions__);
      result.__index__  = wrapper.__index__;
      result.__values__ = wrapper.__values__;
      return result;
    }

    /*------------------------------------------------------------------------*/

    /**
     * Creates an array of elements split into groups the length of `size`.
     * If `array` can't be split evenly, the final chunk will be the remaining
     * elements.
     *
     * @static
     * @memberOf _
     * @since 3.0.0
     * @category Array
     * @param {Array} array The array to process.
     * @param {number} [size=1] The length of each chunk
     * @param- {Object} [guard] Enables use as an iteratee for methods like `_.map`.
     * @returns {Array} Returns the new array of chunks.
     * @example
     *
     * _.chunk(['a', 'b', 'c', 'd'], 2);
     * // => [['a', 'b'], ['c', 'd']]
     *
     * _.chunk(['a', 'b', 'c', 'd'], 3);
     * // => [['a', 'b', 'c'], ['d']]
     */
    function chunk(array, size, guard) {
      if ((guard ? isIterateeCall(array, size, guard) : size === undefined)) {
        size = 1;
      } else {
        size = nativeMax(toInteger(size), 0);
      }
      var length = array == null ? 0 : array.length;
      if (!length || size < 1) {
        return [];
      }
      var index = 0,
          resIndex = 0,
          result = Array(nativeCeil(length / size));

      while (index < length) {
        result[resIndex++] = baseSlice(array, index, (index += size));
      }
      return result;
    }

    /**
     * Creates an array with all falsey values removed. The values `false`, `null`,
     * `0`, `""`, `undefined`, and `NaN` are falsey.
     *
     * @static
     * @memberOf _
     * @since 0.1.0
     * @category Array
     * @param {Array} array The array to compact.
     * @returns {Array} Returns the new array of filtered values.
     * @example
     *
     * _.compact([0, 1, false, 2, '', 3]);
     * // => [1, 2, 3]
     */
    function compact(array) {
      var index = -1,
          length = array == null ? 0 : array.length,
          resIndex = 0,
          result = [];

      while (++index < length) {
        var value = array[index];
        if (value) {
          result[resIndex++] = value;
        }
      }
      return result;
    }

    /**
     * Creates a new array concatenating `array` with any additional arrays
     * and/or values.
     *
     * @static
     * @memberOf _
     * @since 4.0.0
     * @category Array
     * @param {Array} array The array to concatenate.
     * @param {...*} [values] The values to concatenate.
     * @returns {Array} Returns the new concatenated array.
     * @example
     *
     * var array = [1];
     * var other = _.concat(array, 2, [3], [[4]]);
     *
     * console.log(other);
     * // => [1, 2, 3, [4]]
     *
     * console.log(array);
     * // => [1]
     */
    function concat() {
      var length = arguments.length;
      if (!length) {
        return [];
      }
      var args = Array(length - 1),
          array = arguments[0],
          index = length;

      while (index--) {
        args[index - 1] = arguments[index];
      }
      return arrayPush(isArray(array) ? copyArray(array) : [array], baseFlatten(args, 1));
    }

    /**
     * Creates an array of `array` values not included in the other given arrays
     * using [`SameValueZero`](http://ecma-international.org/ecma-262/7.0/#sec-samevaluezero)
     * for equality comparisons. The order and references of result values are
     * determined by the first array.
     *
     * **Note:** Unlike `_.pullAll`, this method returns a new array.
     *
     * @static
     * @memberOf _
     * @since 0.1.0
     * @category Array
     * @param {Array} array The array to inspect.
     * @param {...Array} [values] The values to exclude.
     * @returns {Array} Returns the new array of filtered values.
     * @see _.without, _.xor
     * @example
     *
     * _.difference([2, 1], [2, 3]);
     * // => [1]
     */
    var difference = baseRest(function(array, values) {
      return isArrayLikeObject(array)
        ? baseDifference(array, baseFlatten(values, 1, isArrayLikeObject, true))
        : [];
    });

    /**
     * This method is like `_.difference` except that it accepts `iteratee` which
     * is invoked for each element of `array` and `values` to generate the criterion
     * by which they're compared. The order and references of result values are
     * determined by the first array. The iteratee is invoked with one argument:
     * (value).
     *
     * **Note:** Unlike `_.pullAllBy`, this method returns a new array.
     *
     * @static
     * @memberOf _
     * @since 4.0.0
     * @category Array
     * @param {Array} array The array to inspect.
     * @param {...Array} [values] The values to exclude.
     * @param {Function} [iteratee=_.identity] The iteratee invoked per element.
     * @returns {Array} Returns the new array of filtered values.
     * @example
     *
     * _.differenceBy([2.1, 1.2], [2.3, 3.4], Math.floor);
     * // => [1.2]
     *
     * // The `_.property` iteratee shorthand.
     * _.differenceBy([{ 'x': 2 }, { 'x': 1 }], [{ 'x': 1 }], 'x');
     * // => [{ 'x': 2 }]
     */
    var differenceBy = baseRest(function(array, values) {
      var iteratee = last(values);
      if (isArrayLikeObject(iteratee)) {
        iteratee = undefined;
      }
      return isArrayLikeObject(array)
        ? baseDifference(array, baseFlatten(values, 1, isArrayLikeObject, true), getIteratee(iteratee, 2))
        : [];
    });

    /**
     * This method is like `_.difference` except that it accepts `comparator`
     * which is invoked to compare elements of `array` to `values`. The order and
     * references of result values are determined by the first array. The comparator
     * is invoked with two arguments: (arrVal, othVal).
     *
     * **Note:** Unlike `_.pullAllWith`, this method returns a new array.
     *
     * @static
     * @memberOf _
     * @since 4.0.0
     * @category Array
     * @param {Array} array The array to inspect.
     * @param {...Array} [values] The values to exclude.
     * @param {Function} [comparator] The comparator invoked per element.
     * @returns {Array} Returns the new array of filtered values.
     * @example
     *
     * var objects = [{ 'x': 1, 'y': 2 }, { 'x': 2, 'y': 1 }];
     *
     * _.differenceWith(objects, [{ 'x': 1, 'y': 2 }], _.isEqual);
     * // => [{ 'x': 2, 'y': 1 }]
     */
    var differenceWith = baseRest(function(array, values) {
      var comparator = last(values);
      if (isArrayLikeObject(comparator)) {
        comparator = undefined;
      }
      return isArrayLikeObject(array)
        ? baseDifference(array, baseFlatten(values, 1, isArrayLikeObject, true), undefined, comparator)
        : [];
    });

    /**
     * Creates a slice of `array` with `n` elements dropped from the beginning.
     *
     * @static
     * @memberOf _
     * @since 0.5.0
     * @category Array
     * @param {Array} array The array to query.
     * @param {number} [n=1] The number of elements to drop.
     * @param- {Object} [guard] Enables use as an iteratee for methods like `_.map`.
     * @returns {Array} Returns the slice of `array`.
     * @example
     *
     * _.drop([1, 2, 3]);
     * // => [2, 3]
     *
     * _.drop([1, 2, 3], 2);
     * // => [3]
     *
     * _.drop([1, 2, 3], 5);
     * // => []
     *
     * _.drop([1, 2, 3], 0);
     * // => [1, 2, 3]
     */
    function drop(array, n, guard) {
      var length = array == null ? 0 : array.length;
      if (!length) {
        return [];
      }
      n = (guard || n === undefined) ? 1 : toInteger(n);
      return baseSlice(array, n < 0 ? 0 : n, length);
    }

    /**
     * Creates a slice of `array` with `n` elements dropped from the end.
     *
     * @static
     * @memberOf _
     * @since 3.0.0
     * @category Array
     * @param {Array} array The array to query.
     * @param {number} [n=1] The number of elements to drop.
     * @param- {Object} [guard] Enables use as an iteratee for methods like `_.map`.
     * @returns {Array} Returns the slice of `array`.
     * @example
     *
     * _.dropRight([1, 2, 3]);
     * // => [1, 2]
     *
     * _.dropRight([1, 2, 3], 2);
     * // => [1]
     *
     * _.dropRight([1, 2, 3], 5);
     * // => []
     *
     * _.dropRight([1, 2, 3], 0);
     * // => [1, 2, 3]
     */
    function dropRight(array, n, guard) {
      var length = array == null ? 0 : array.length;
      if (!length) {
        return [];
      }
      n = (guard || n === undefined) ? 1 : toInteger(n);
      n = length - n;
      return baseSlice(array, 0, n < 0 ? 0 : n);
    }

    /**
     * Creates a slice of `array` excluding elements dropped from the end.
     * Elements are dropped until `predicate` returns falsey. The predicate is
     * invoked with three arguments: (value, index, array).
     *
     * @static
     * @memberOf _
     * @since 3.0.0
     * @category Array
     * @param {Array} array The array to query.
     * @param {Function} [predicate=_.identity] The function invoked per iteration.
     * @returns {Array} Returns the slice of `array`.
     * @example
     *
     * var users = [
     *   { 'user': 'barney',  'active': true },
     *   { 'user': 'fred',    'active': false },
     *   { 'user': 'pebbles', 'active': false }
     * ];
     *
     * _.dropRightWhile(users, function(o) { return !o.active; });
     * // => objects for ['barney']
     *
     * // The `_.matches` iteratee shorthand.
     * _.dropRightWhile(users, { 'user': 'pebbles', 'active': false });
     * // => objects for ['barney', 'fred']
     *
     * // The `_.matchesProperty` iteratee shorthand.
     * _.dropRightWhile(users, ['active', false]);
     * // => objects for ['barney']
     *
     * // The `_.property` iteratee shorthand.
     * _.dropRightWhile(users, 'active');
     * // => objects for ['barney', 'fred', 'pebbles']
     */
    function dropRightWhile(array, predicate) {
      return (array && array.length)
        ? baseWhile(array, getIteratee(predicate, 3), true, true)
        : [];
    }

    /**
     * Creates a slice of `array` excluding elements dropped from the beginning.
     * Elements are dropped until `predicate` returns falsey. The predicate is
     * invoked with three arguments: (value, index, array).
     *
     * @static
     * @memberOf _
     * @since 3.0.0
     * @category Array
     * @param {Array} array The array to query.
     * @param {Function} [predicate=_.identity] The function invoked per iteration.
     * @returns {Array} Returns the slice of `array`.
     * @example
     *
     * var users = [
     *   { 'user': 'barney',  'active': false },
     *   { 'user': 'fred',    'active': false },
     *   { 'user': 'pebbles', 'active': true }
     * ];
     *
     * _.dropWhile(users, function(o) { return !o.active; });
     * // => objects for ['pebbles']
     *
     * // The `_.matches` iteratee shorthand.
     * _.dropWhile(users, { 'user': 'barney', 'active': false });
     * // => objects for ['fred', 'pebbles']
     *
     * // The `_.matchesProperty` iteratee shorthand.
     * _.dropWhile(users, ['active', false]);
     * // => objects for ['pebbles']
     *
     * // The `_.property` iteratee shorthand.
     * _.dropWhile(users, 'active');
     * // => objects for ['barney', 'fred', 'pebbles']
     */
    function dropWhile(array, predicate) {
      return (array && array.length)
        ? baseWhile(array, getIteratee(predicate, 3), true)
        : [];
    }

    /**
     * Fills elements of `array` with `value` from `start` up to, but not
     * including, `end`.
     *
     * **Note:** This method mutates `array`.
     *
     * @static
     * @memberOf _
     * @since 3.2.0
     * @category Array
     * @param {Array} array The array to fill.
     * @param {*} value The value to fill `array` with.
     * @param {number} [start=0] The start position.
     * @param {number} [end=array.length] The end position.
     * @returns {Array} Returns `array`.
     * @example
     *
     * var array = [1, 2, 3];
     *
     * _.fill(array, 'a');
     * console.log(array);
     * // => ['a', 'a', 'a']
     *
     * _.fill(Array(3), 2);
     * // => [2, 2, 2]
     *
     * _.fill([4, 6, 8, 10], '*', 1, 3);
     * // => [4, '*', '*', 10]
     */
    function fill(array, value, start, end) {
      var length = array == null ? 0 : array.length;
      if (!length) {
        return [];
      }
      if (start && typeof start != 'number' && isIterateeCall(array, value, start)) {
        start = 0;
        end = length;
      }
      return baseFill(array, value, start, end);
    }

    /**
     * This method is like `_.find` except that it returns the index of the first
     * element `predicate` returns truthy for instead of the element itself.
     *
     * @static
     * @memberOf _
     * @since 1.1.0
     * @category Array
     * @param {Array} array The array to inspect.
     * @param {Function} [predicate=_.identity] The function invoked per iteration.
     * @param {number} [fromIndex=0] The index to search from.
     * @returns {number} Returns the index of the found element, else `-1`.
     * @example
     *
     * var users = [
     *   { 'user': 'barney',  'active': false },
     *   { 'user': 'fred',    'active': false },
     *   { 'user': 'pebbles', 'active': true }
     * ];
     *
     * _.findIndex(users, function(o) { return o.user == 'barney'; });
     * // => 0
     *
     * // The `_.matches` iteratee shorthand.
     * _.findIndex(users, { 'user': 'fred', 'active': false });
     * // => 1
     *
     * // The `_.matchesProperty` iteratee shorthand.
     * _.findIndex(users, ['active', false]);
     * // => 0
     *
     * // The `_.property` iteratee shorthand.
     * _.findIndex(users, 'active');
     * // => 2
     */
    function findIndex(array, predicate, fromIndex) {
      var length = array == null ? 0 : array.length;
      if (!length) {
        return -1;
      }
      var index = fromIndex == null ? 0 : toInteger(fromIndex);
      if (index < 0) {
        index = nativeMax(length + index, 0);
      }
      return baseFindIndex(array, getIteratee(predicate, 3), index);
    }

    /**
     * This method is like `_.findIndex` except that it iterates over elements
     * of `collection` from right to left.
     *
     * @static
     * @memberOf _
     * @since 2.0.0
     * @category Array
     * @param {Array} array The array to inspect.
     * @param {Function} [predicate=_.identity] The function invoked per iteration.
     * @param {number} [fromIndex=array.length-1] The index to search from.
     * @returns {number} Returns the index of the found element, else `-1`.
     * @example
     *
     * var users = [
     *   { 'user': 'barney',  'active': true },
     *   { 'user': 'fred',    'active': false },
     *   { 'user': 'pebbles', 'active': false }
     * ];
     *
     * _.findLastIndex(users, function(o) { return o.user == 'pebbles'; });
     * // => 2
     *
     * // The `_.matches` iteratee shorthand.
     * _.findLastIndex(users, { 'user': 'barney', 'active': true });
     * // => 0
     *
     * // The `_.matchesProperty` iteratee shorthand.
     * _.findLastIndex(users, ['active', false]);
     * // => 2
     *
     * // The `_.property` iteratee shorthand.
     * _.findLastIndex(users, 'active');
     * // => 0
     */
    function findLastIndex(array, predicate, fromIndex) {
      var length = array == null ? 0 : array.length;
      if (!length) {
        return -1;
      }
      var index = length - 1;
      if (fromIndex !== undefined) {
        index = toInteger(fromIndex);
        index = fromIndex < 0
          ? nativeMax(length + index, 0)
          : nativeMin(index, length - 1);
      }
      return baseFindIndex(array, getIteratee(predicate, 3), index, true);
    }

    /**
     * Flattens `array` a single level deep.
     *
     * @static
     * @memberOf _
     * @since 0.1.0
     * @category Array
     * @param {Array} array The array to flatten.
     * @returns {Array} Returns the new flattened array.
     * @example
     *
     * _.flatten([1, [2, [3, [4]], 5]]);
     * // => [1, 2, [3, [4]], 5]
     */
    function flatten(array) {
      var length = array == null ? 0 : array.length;
      return length ? baseFlatten(array, 1) : [];
    }

    /**
     * Recursively flattens `array`.
     *
     * @static
     * @memberOf _
     * @since 3.0.0
     * @category Array
     * @param {Array} array The array to flatten.
     * @returns {Array} Returns the new flattened array.
     * @example
     *
     * _.flattenDeep([1, [2, [3, [4]], 5]]);
     * // => [1, 2, 3, 4, 5]
     */
    function flattenDeep(array) {
      var length = array == null ? 0 : array.length;
      return length ? baseFlatten(array, INFINITY) : [];
    }

    /**
     * Recursively flatten `array` up to `depth` times.
     *
     * @static
     * @memberOf _
     * @since 4.4.0
     * @category Array
     * @param {Array} array The array to flatten.
     * @param {number} [depth=1] The maximum recursion depth.
     * @returns {Array} Returns the new flattened array.
     * @example
     *
     * var array = [1, [2, [3, [4]], 5]];
     *
     * _.flattenDepth(array, 1);
     * // => [1, 2, [3, [4]], 5]
     *
     * _.flattenDepth(array, 2);
     * // => [1, 2, 3, [4], 5]
     */
    function flattenDepth(array, depth) {
      var length = array == null ? 0 : array.length;
      if (!length) {
        return [];
      }
      depth = depth === undefined ? 1 : toInteger(depth);
      return baseFlatten(array, depth);
    }

    /**
     * The inverse of `_.toPairs`; this method returns an object composed
     * from key-value `pairs`.
     *
     * @static
     * @memberOf _
     * @since 4.0.0
     * @category Array
     * @param {Array} pairs The key-value pairs.
     * @returns {Object} Returns the new object.
     * @example
     *
     * _.fromPairs([['a', 1], ['b', 2]]);
     * // => { 'a': 1, 'b': 2 }
     */
    function fromPairs(pairs) {
      var index = -1,
          length = pairs == null ? 0 : pairs.length,
          result = {};

      while (++index < length) {
        var pair = pairs[index];
        result[pair[0]] = pair[1];
      }
      return result;
    }

    /**
     * Gets the first element of `array`.
     *
     * @static
     * @memberOf _
     * @since 0.1.0
     * @alias first
     * @category Array
     * @param {Array} array The array to query.
     * @returns {*} Returns the first element of `array`.
     * @example
     *
     * _.head([1, 2, 3]);
     * // => 1
     *
     * _.head([]);
     * // => undefined
     */
    function head(array) {
      return (array && array.length) ? array[0] : undefined;
    }

    /**
     * Gets the index at which the first occurrence of `value` is found in `array`
     * using [`SameValueZero`](http://ecma-international.org/ecma-262/7.0/#sec-samevaluezero)
     * for equality comparisons. If `fromIndex` is negative, it's used as the
     * offset from the end of `array`.
     *
     * @static
     * @memberOf _
     * @since 0.1.0
     * @category Array
     * @param {Array} array The array to inspect.
     * @param {*} value The value to search for.
     * @param {number} [fromIndex=0] The index to search from.
     * @returns {number} Returns the index of the matched value, else `-1`.
     * @example
     *
     * _.indexOf([1, 2, 1, 2], 2);
     * // => 1
     *
     * // Search from the `fromIndex`.
     * _.indexOf([1, 2, 1, 2], 2, 2);
     * // => 3
     */
    function indexOf(array, value, fromIndex) {
      var length = array == null ? 0 : array.length;
      if (!length) {
        return -1;
      }
      var index = fromIndex == null ? 0 : toInteger(fromIndex);
      if (index < 0) {
        index = nativeMax(length + index, 0);
      }
      return baseIndexOf(array, value, index);
    }

    /**
     * Gets all but the last element of `array`.
     *
     * @static
     * @memberOf _
     * @since 0.1.0
     * @category Array
     * @param {Array} array The array to query.
     * @returns {Array} Returns the slice of `array`.
     * @example
     *
     * _.initial([1, 2, 3]);
     * // => [1, 2]
     */
    function initial(array) {
      var length = array == null ? 0 : array.length;
      return length ? baseSlice(array, 0, -1) : [];
    }

    /**
     * Creates an array of unique values that are included in all given arrays
     * using [`SameValueZero`](http://ecma-international.org/ecma-262/7.0/#sec-samevaluezero)
     * for equality comparisons. The order and references of result values are
     * determined by the first array.
     *
     * @static
     * @memberOf _
     * @since 0.1.0
     * @category Array
     * @param {...Array} [arrays] The arrays to inspect.
     * @returns {Array} Returns the new array of intersecting values.
     * @example
     *
     * _.intersection([2, 1], [2, 3]);
     * // => [2]
     */
    var intersection = baseRest(function(arrays) {
      var mapped = arrayMap(arrays, castArrayLikeObject);
      return (mapped.length && mapped[0] === arrays[0])
        ? baseIntersection(mapped)
        : [];
    });

    /**
     * This method is like `_.intersection` except that it accepts `iteratee`
     * which is invoked for each element of each `arrays` to generate the criterion
     * by which they're compared. The order and references of result values are
     * determined by the first array. The iteratee is invoked with one argument:
     * (value).
     *
     * @static
     * @memberOf _
     * @since 4.0.0
     * @category Array
     * @param {...Array} [arrays] The arrays to inspect.
     * @param {Function} [iteratee=_.identity] The iteratee invoked per element.
     * @returns {Array} Returns the new array of intersecting values.
     * @example
     *
     * _.intersectionBy([2.1, 1.2], [2.3, 3.4], Math.floor);
     * // => [2.1]
     *
     * // The `_.property` iteratee shorthand.
     * _.intersectionBy([{ 'x': 1 }], [{ 'x': 2 }, { 'x': 1 }], 'x');
     * // => [{ 'x': 1 }]
     */
    var intersectionBy = baseRest(function(arrays) {
      var iteratee = last(arrays),
          mapped = arrayMap(arrays, castArrayLikeObject);

      if (iteratee === last(mapped)) {
        iteratee = undefined;
      } else {
        mapped.pop();
      }
      return (mapped.length && mapped[0] === arrays[0])
        ? baseIntersection(mapped, getIteratee(iteratee, 2))
        : [];
    });

    /**
     * This method is like `_.intersection` except that it accepts `comparator`
     * which is invoked to compare elements of `arrays`. The order and references
     * of result values are determined by the first array. The comparator is
     * invoked with two arguments: (arrVal, othVal).
     *
     * @static
     * @memberOf _
     * @since 4.0.0
     * @category Array
     * @param {...Array} [arrays] The arrays to inspect.
     * @param {Function} [comparator] The comparator invoked per element.
     * @returns {Array} Returns the new array of intersecting values.
     * @example
     *
     * var objects = [{ 'x': 1, 'y': 2 }, { 'x': 2, 'y': 1 }];
     * var others = [{ 'x': 1, 'y': 1 }, { 'x': 1, 'y': 2 }];
     *
     * _.intersectionWith(objects, others, _.isEqual);
     * // => [{ 'x': 1, 'y': 2 }]
     */
    var intersectionWith = baseRest(function(arrays) {
      var comparator = last(arrays),
          mapped = arrayMap(arrays, castArrayLikeObject);

      comparator = typeof comparator == 'function' ? comparator : undefined;
      if (comparator) {
        mapped.pop();
      }
      return (mapped.length && mapped[0] === arrays[0])
        ? baseIntersection(mapped, undefined, comparator)
        : [];
    });

    /**
     * Converts all elements in `array` into a string separated by `separator`.
     *
     * @static
     * @memberOf _
     * @since 4.0.0
     * @category Array
     * @param {Array} array The array to convert.
     * @param {string} [separator=','] The element separator.
     * @returns {string} Returns the joined string.
     * @example
     *
     * _.join(['a', 'b', 'c'], '~');
     * // => 'a~b~c'
     */
    function join(array, separator) {
      return array == null ? '' : nativeJoin.call(array, separator);
    }

    /**
     * Gets the last element of `array`.
     *
     * @static
     * @memberOf _
     * @since 0.1.0
     * @category Array
     * @param {Array} array The array to query.
     * @returns {*} Returns the last element of `array`.
     * @example
     *
     * _.last([1, 2, 3]);
     * // => 3
     */
    function last(array) {
      var length = array == null ? 0 : array.length;
      return length ? array[length - 1] : undefined;
    }

    /**
     * This method is like `_.indexOf` except that it iterates over elements of
     * `array` from right to left.
     *
     * @static
     * @memberOf _
     * @since 0.1.0
     * @category Array
     * @param {Array} array The array to inspect.
     * @param {*} value The value to search for.
     * @param {number} [fromIndex=array.length-1] The index to search from.
     * @returns {number} Returns the index of the matched value, else `-1`.
     * @example
     *
     * _.lastIndexOf([1, 2, 1, 2], 2);
     * // => 3
     *
     * // Search from the `fromIndex`.
     * _.lastIndexOf([1, 2, 1, 2], 2, 2);
     * // => 1
     */
    function lastIndexOf(array, value, fromIndex) {
      var length = array == null ? 0 : array.length;
      if (!length) {
        return -1;
      }
      var index = length;
      if (fromIndex !== undefined) {
        index = toInteger(fromIndex);
        index = index < 0 ? nativeMax(length + index, 0) : nativeMin(index, length - 1);
      }
      return value === value
        ? strictLastIndexOf(array, value, index)
        : baseFindIndex(array, baseIsNaN, index, true);
    }

    /**
     * Gets the element at index `n` of `array`. If `n` is negative, the nth
     * element from the end is returned.
     *
     * @static
     * @memberOf _
     * @since 4.11.0
     * @category Array
     * @param {Array} array The array to query.
     * @param {number} [n=0] The index of the element to return.
     * @returns {*} Returns the nth element of `array`.
     * @example
     *
     * var array = ['a', 'b', 'c', 'd'];
     *
     * _.nth(array, 1);
     * // => 'b'
     *
     * _.nth(array, -2);
     * // => 'c';
     */
    function nth(array, n) {
      return (array && array.length) ? baseNth(array, toInteger(n)) : undefined;
    }

    /**
     * Removes all given values from `array` using
     * [`SameValueZero`](http://ecma-international.org/ecma-262/7.0/#sec-samevaluezero)
     * for equality comparisons.
     *
     * **Note:** Unlike `_.without`, this method mutates `array`. Use `_.remove`
     * to remove elements from an array by predicate.
     *
     * @static
     * @memberOf _
     * @since 2.0.0
     * @category Array
     * @param {Array} array The array to modify.
     * @param {...*} [values] The values to remove.
     * @returns {Array} Returns `array`.
     * @example
     *
     * var array = ['a', 'b', 'c', 'a', 'b', 'c'];
     *
     * _.pull(array, 'a', 'c');
     * console.log(array);
     * // => ['b', 'b']
     */
    var pull = baseRest(pullAll);

    /**
     * This method is like `_.pull` except that it accepts an array of values to remove.
     *
     * **Note:** Unlike `_.difference`, this method mutates `array`.
     *
     * @static
     * @memberOf _
     * @since 4.0.0
     * @category Array
     * @param {Array} array The array to modify.
     * @param {Array} values The values to remove.
     * @returns {Array} Returns `array`.
     * @example
     *
     * var array = ['a', 'b', 'c', 'a', 'b', 'c'];
     *
     * _.pullAll(array, ['a', 'c']);
     * console.log(array);
     * // => ['b', 'b']
     */
    function pullAll(array, values) {
      return (array && array.length && values && values.length)
        ? basePullAll(array, values)
        : array;
    }

    /**
     * This method is like `_.pullAll` except that it accepts `iteratee` which is
     * invoked for each element of `array` and `values` to generate the criterion
     * by which they're compared. The iteratee is invoked with one argument: (value).
     *
     * **Note:** Unlike `_.differenceBy`, this method mutates `array`.
     *
     * @static
     * @memberOf _
     * @since 4.0.0
     * @category Array
     * @param {Array} array The array to modify.
     * @param {Array} values The values to remove.
     * @param {Function} [iteratee=_.identity] The iteratee invoked per element.
     * @returns {Array} Returns `array`.
     * @example
     *
     * var array = [{ 'x': 1 }, { 'x': 2 }, { 'x': 3 }, { 'x': 1 }];
     *
     * _.pullAllBy(array, [{ 'x': 1 }, { 'x': 3 }], 'x');
     * console.log(array);
     * // => [{ 'x': 2 }]
     */
    function pullAllBy(array, values, iteratee) {
      return (array && array.length && values && values.length)
        ? basePullAll(array, values, getIteratee(iteratee, 2))
        : array;
    }

    /**
     * This method is like `_.pullAll` except that it accepts `comparator` which
     * is invoked to compare elements of `array` to `values`. The comparator is
     * invoked with two arguments: (arrVal, othVal).
     *
     * **Note:** Unlike `_.differenceWith`, this method mutates `array`.
     *
     * @static
     * @memberOf _
     * @since 4.6.0
     * @category Array
     * @param {Array} array The array to modify.
     * @param {Array} values The values to remove.
     * @param {Function} [comparator] The comparator invoked per element.
     * @returns {Array} Returns `array`.
     * @example
     *
     * var array = [{ 'x': 1, 'y': 2 }, { 'x': 3, 'y': 4 }, { 'x': 5, 'y': 6 }];
     *
     * _.pullAllWith(array, [{ 'x': 3, 'y': 4 }], _.isEqual);
     * console.log(array);
     * // => [{ 'x': 1, 'y': 2 }, { 'x': 5, 'y': 6 }]
     */
    function pullAllWith(array, values, comparator) {
      return (array && array.length && values && values.length)
        ? basePullAll(array, values, undefined, comparator)
        : array;
    }

    /**
     * Removes elements from `array` corresponding to `indexes` and returns an
     * array of removed elements.
     *
     * **Note:** Unlike `_.at`, this method mutates `array`.
     *
     * @static
     * @memberOf _
     * @since 3.0.0
     * @category Array
     * @param {Array} array The array to modify.
     * @param {...(number|number[])} [indexes] The indexes of elements to remove.
     * @returns {Array} Returns the new array of removed elements.
     * @example
     *
     * var array = ['a', 'b', 'c', 'd'];
     * var pulled = _.pullAt(array, [1, 3]);
     *
     * console.log(array);
     * // => ['a', 'c']
     *
     * console.log(pulled);
     * // => ['b', 'd']
     */
    var pullAt = flatRest(function(array, indexes) {
      var length = array == null ? 0 : array.length,
          result = baseAt(array, indexes);

      basePullAt(array, arrayMap(indexes, function(index) {
        return isIndex(index, length) ? +index : index;
      }).sort(compareAscending));

      return result;
    });

    /**
     * Removes all elements from `array` that `predicate` returns truthy for
     * and returns an array of the removed elements. The predicate is invoked
     * with three arguments: (value, index, array).
     *
     * **Note:** Unlike `_.filter`, this method mutates `array`. Use `_.pull`
     * to pull elements from an array by value.
     *
     * @static
     * @memberOf _
     * @since 2.0.0
     * @category Array
     * @param {Array} array The array to modify.
     * @param {Function} [predicate=_.identity] The function invoked per iteration.
     * @returns {Array} Returns the new array of removed elements.
     * @example
     *
     * var array = [1, 2, 3, 4];
     * var evens = _.remove(array, function(n) {
     *   return n % 2 == 0;
     * });
     *
     * console.log(array);
     * // => [1, 3]
     *
     * console.log(evens);
     * // => [2, 4]
     */
    function remove(array, predicate) {
      var result = [];
      if (!(array && array.length)) {
        return result;
      }
      var index = -1,
          indexes = [],
          length = array.length;

      predicate = getIteratee(predicate, 3);
      while (++index < length) {
        var value = array[index];
        if (predicate(value, index, array)) {
          result.push(value);
          indexes.push(index);
        }
      }
      basePullAt(array, indexes);
      return result;
    }

    /**
     * Reverses `array` so that the first element becomes the last, the second
     * element becomes the second to last, and so on.
     *
     * **Note:** This method mutates `array` and is based on
     * [`Array#reverse`](https://mdn.io/Array/reverse).
     *
     * @static
     * @memberOf _
     * @since 4.0.0
     * @category Array
     * @param {Array} array The array to modify.
     * @returns {Array} Returns `array`.
     * @example
     *
     * var array = [1, 2, 3];
     *
     * _.reverse(array);
     * // => [3, 2, 1]
     *
     * console.log(array);
     * // => [3, 2, 1]
     */
    function reverse(array) {
      return array == null ? array : nativeReverse.call(array);
    }

    /**
     * Creates a slice of `array` from `start` up to, but not including, `end`.
     *
     * **Note:** This method is used instead of
     * [`Array#slice`](https://mdn.io/Array/slice) to ensure dense arrays are
     * returned.
     *
     * @static
     * @memberOf _
     * @since 3.0.0
     * @category Array
     * @param {Array} array The array to slice.
     * @param {number} [start=0] The start position.
     * @param {number} [end=array.length] The end position.
     * @returns {Array} Returns the slice of `array`.
     */
    function slice(array, start, end) {
      var length = array == null ? 0 : array.length;
      if (!length) {
        return [];
      }
      if (end && typeof end != 'number' && isIterateeCall(array, start, end)) {
        start = 0;
        end = length;
      }
      else {
        start = start == null ? 0 : toInteger(start);
        end = end === undefined ? length : toInteger(end);
      }
      return baseSlice(array, start, end);
    }

    /**
     * Uses a binary search to determine the lowest index at which `value`
     * should be inserted into `array` in order to maintain its sort order.
     *
     * @static
     * @memberOf _
     * @since 0.1.0
     * @category Array
     * @param {Array} array The sorted array to inspect.
     * @param {*} value The value to evaluate.
     * @returns {number} Returns the index at which `value` should be inserted
     *  into `array`.
     * @example
     *
     * _.sortedIndex([30, 50], 40);
     * // => 1
     */
    function sortedIndex(array, value) {
      return baseSortedIndex(array, value);
    }

    /**
     * This method is like `_.sortedIndex` except that it accepts `iteratee`
     * which is invoked for `value` and each element of `array` to compute their
     * sort ranking. The iteratee is invoked with one argument: (value).
     *
     * @static
     * @memberOf _
     * @since 4.0.0
     * @category Array
     * @param {Array} array The sorted array to inspect.
     * @param {*} value The value to evaluate.
     * @param {Function} [iteratee=_.identity] The iteratee invoked per element.
     * @returns {number} Returns the index at which `value` should be inserted
     *  into `array`.
     * @example
     *
     * var objects = [{ 'x': 4 }, { 'x': 5 }];
     *
     * _.sortedIndexBy(objects, { 'x': 4 }, function(o) { return o.x; });
     * // => 0
     *
     * // The `_.property` iteratee shorthand.
     * _.sortedIndexBy(objects, { 'x': 4 }, 'x');
     * // => 0
     */
    function sortedIndexBy(array, value, iteratee) {
      return baseSortedIndexBy(array, value, getIteratee(iteratee, 2));
    }

    /**
     * This method is like `_.indexOf` except that it performs a binary
     * search on a sorted `array`.
     *
     * @static
     * @memberOf _
     * @since 4.0.0
     * @category Array
     * @param {Array} array The array to inspect.
     * @param {*} value The value to search for.
     * @returns {number} Returns the index of the matched value, else `-1`.
     * @example
     *
     * _.sortedIndexOf([4, 5, 5, 5, 6], 5);
     * // => 1
     */
    function sortedIndexOf(array, value) {
      var length = array == null ? 0 : array.length;
      if (length) {
        var index = baseSortedIndex(array, value);
        if (index < length && eq(array[index], value)) {
          return index;
        }
      }
      return -1;
    }

    /**
     * This method is like `_.sortedIndex` except that it returns the highest
     * index at which `value` should be inserted into `array` in order to
     * maintain its sort order.
     *
     * @static
     * @memberOf _
     * @since 3.0.0
     * @category Array
     * @param {Array} array The sorted array to inspect.
     * @param {*} value The value to evaluate.
     * @returns {number} Returns the index at which `value` should be inserted
     *  into `array`.
     * @example
     *
     * _.sortedLastIndex([4, 5, 5, 5, 6], 5);
     * // => 4
     */
    function sortedLastIndex(array, value) {
      return baseSortedIndex(array, value, true);
    }

    /**
     * This method is like `_.sortedLastIndex` except that it accepts `iteratee`
     * which is invoked for `value` and each element of `array` to compute their
     * sort ranking. The iteratee is invoked with one argument: (value).
     *
     * @static
     * @memberOf _
     * @since 4.0.0
     * @category Array
     * @param {Array} array The sorted array to inspect.
     * @param {*} value The value to evaluate.
     * @param {Function} [iteratee=_.identity] The iteratee invoked per element.
     * @returns {number} Returns the index at which `value` should be inserted
     *  into `array`.
     * @example
     *
     * var objects = [{ 'x': 4 }, { 'x': 5 }];
     *
     * _.sortedLastIndexBy(objects, { 'x': 4 }, function(o) { return o.x; });
     * // => 1
     *
     * // The `_.property` iteratee shorthand.
     * _.sortedLastIndexBy(objects, { 'x': 4 }, 'x');
     * // => 1
     */
    function sortedLastIndexBy(array, value, iteratee) {
      return baseSortedIndexBy(array, value, getIteratee(iteratee, 2), true);
    }

    /**
     * This method is like `_.lastIndexOf` except that it performs a binary
     * search on a sorted `array`.
     *
     * @static
     * @memberOf _
     * @since 4.0.0
     * @category Array
     * @param {Array} array The array to inspect.
     * @param {*} value The value to search for.
     * @returns {number} Returns the index of the matched value, else `-1`.
     * @example
     *
     * _.sortedLastIndexOf([4, 5, 5, 5, 6], 5);
     * // => 3
     */
    function sortedLastIndexOf(array, value) {
      var length = array == null ? 0 : array.length;
      if (length) {
        var index = baseSortedIndex(array, value, true) - 1;
        if (eq(array[index], value)) {
          return index;
        }
      }
      return -1;
    }

    /**
     * This method is like `_.uniq` except that it's designed and optimized
     * for sorted arrays.
     *
     * @static
     * @memberOf _
     * @since 4.0.0
     * @category Array
     * @param {Array} array The array to inspect.
     * @returns {Array} Returns the new duplicate free array.
     * @example
     *
     * _.sortedUniq([1, 1, 2]);
     * // => [1, 2]
     */
    function sortedUniq(array) {
      return (array && array.length)
        ? baseSortedUniq(array)
        : [];
    }

    /**
     * This method is like `_.uniqBy` except that it's designed and optimized
     * for sorted arrays.
     *
     * @static
     * @memberOf _
     * @since 4.0.0
     * @category Array
     * @param {Array} array The array to inspect.
     * @param {Function} [iteratee] The iteratee invoked per element.
     * @returns {Array} Returns the new duplicate free array.
     * @example
     *
     * _.sortedUniqBy([1.1, 1.2, 2.3, 2.4], Math.floor);
     * // => [1.1, 2.3]
     */
    function sortedUniqBy(array, iteratee) {
      return (array && array.length)
        ? baseSortedUniq(array, getIteratee(iteratee, 2))
        : [];
    }

    /**
     * Gets all but the first element of `array`.
     *
     * @static
     * @memberOf _
     * @since 4.0.0
     * @category Array
     * @param {Array} array The array to query.
     * @returns {Array} Returns the slice of `array`.
     * @example
     *
     * _.tail([1, 2, 3]);
     * // => [2, 3]
     */
    function tail(array) {
      var length = array == null ? 0 : array.length;
      return length ? baseSlice(array, 1, length) : [];
    }

    /**
     * Creates a slice of `array` with `n` elements taken from the beginning.
     *
     * @static
     * @memberOf _
     * @since 0.1.0
     * @category Array
     * @param {Array} array The array to query.
     * @param {number} [n=1] The number of elements to take.
     * @param- {Object} [guard] Enables use as an iteratee for methods like `_.map`.
     * @returns {Array} Returns the slice of `array`.
     * @example
     *
     * _.take([1, 2, 3]);
     * // => [1]
     *
     * _.take([1, 2, 3], 2);
     * // => [1, 2]
     *
     * _.take([1, 2, 3], 5);
     * // => [1, 2, 3]
     *
     * _.take([1, 2, 3], 0);
     * // => []
     */
    function take(array, n, guard) {
      if (!(array && array.length)) {
        return [];
      }
      n = (guard || n === undefined) ? 1 : toInteger(n);
      return baseSlice(array, 0, n < 0 ? 0 : n);
    }

    /**
     * Creates a slice of `array` with `n` elements taken from the end.
     *
     * @static
     * @memberOf _
     * @since 3.0.0
     * @category Array
     * @param {Array} array The array to query.
     * @param {number} [n=1] The number of elements to take.
     * @param- {Object} [guard] Enables use as an iteratee for methods like `_.map`.
     * @returns {Array} Returns the slice of `array`.
     * @example
     *
     * _.takeRight([1, 2, 3]);
     * // => [3]
     *
     * _.takeRight([1, 2, 3], 2);
     * // => [2, 3]
     *
     * _.takeRight([1, 2, 3], 5);
     * // => [1, 2, 3]
     *
     * _.takeRight([1, 2, 3], 0);
     * // => []
     */
    function takeRight(array, n, guard) {
      var length = array == null ? 0 : array.length;
      if (!length) {
        return [];
      }
      n = (guard || n === undefined) ? 1 : toInteger(n);
      n = length - n;
      return baseSlice(array, n < 0 ? 0 : n, length);
    }

    /**
     * Creates a slice of `array` with elements taken from the end. Elements are
     * taken until `predicate` returns falsey. The predicate is invoked with
     * three arguments: (value, index, array).
     *
     * @static
     * @memberOf _
     * @since 3.0.0
     * @category Array
     * @param {Array} array The array to query.
     * @param {Function} [predicate=_.identity] The function invoked per iteration.
     * @returns {Array} Returns the slice of `array`.
     * @example
     *
     * var users = [
     *   { 'user': 'barney',  'active': true },
     *   { 'user': 'fred',    'active': false },
     *   { 'user': 'pebbles', 'active': false }
     * ];
     *
     * _.takeRightWhile(users, function(o) { return !o.active; });
     * // => objects for ['fred', 'pebbles']
     *
     * // The `_.matches` iteratee shorthand.
     * _.takeRightWhile(users, { 'user': 'pebbles', 'active': false });
     * // => objects for ['pebbles']
     *
     * // The `_.matchesProperty` iteratee shorthand.
     * _.takeRightWhile(users, ['active', false]);
     * // => objects for ['fred', 'pebbles']
     *
     * // The `_.property` iteratee shorthand.
     * _.takeRightWhile(users, 'active');
     * // => []
     */
    function takeRightWhile(array, predicate) {
      return (array && array.length)
        ? baseWhile(array, getIteratee(predicate, 3), false, true)
        : [];
    }

    /**
     * Creates a slice of `array` with elements taken from the beginning. Elements
     * are taken until `predicate` returns falsey. The predicate is invoked with
     * three arguments: (value, index, array).
     *
     * @static
     * @memberOf _
     * @since 3.0.0
     * @category Array
     * @param {Array} array The array to query.
     * @param {Function} [predicate=_.identity] The function invoked per iteration.
     * @returns {Array} Returns the slice of `array`.
     * @example
     *
     * var users = [
     *   { 'user': 'barney',  'active': false },
     *   { 'user': 'fred',    'active': false },
     *   { 'user': 'pebbles', 'active': true }
     * ];
     *
     * _.takeWhile(users, function(o) { return !o.active; });
     * // => objects for ['barney', 'fred']
     *
     * // The `_.matches` iteratee shorthand.
     * _.takeWhile(users, { 'user': 'barney', 'active': false });
     * // => objects for ['barney']
     *
     * // The `_.matchesProperty` iteratee shorthand.
     * _.takeWhile(users, ['active', false]);
     * // => objects for ['barney', 'fred']
     *
     * // The `_.property` iteratee shorthand.
     * _.takeWhile(users, 'active');
     * // => []
     */
    function takeWhile(array, predicate) {
      return (array && array.length)
        ? baseWhile(array, getIteratee(predicate, 3))
        : [];
    }

    /**
     * Creates an array of unique values, in order, from all given arrays using
     * [`SameValueZero`](http://ecma-international.org/ecma-262/7.0/#sec-samevaluezero)
     * for equality comparisons.
     *
     * @static
     * @memberOf _
     * @since 0.1.0
     * @category Array
     * @param {...Array} [arrays] The arrays to inspect.
     * @returns {Array} Returns the new array of combined values.
     * @example
     *
     * _.union([2], [1, 2]);
     * // => [2, 1]
     */
    var union = baseRest(function(arrays) {
      return baseUniq(baseFlatten(arrays, 1, isArrayLikeObject, true));
    });

    /**
     * This method is like `_.union` except that it accepts `iteratee` which is
     * invoked for each element of each `arrays` to generate the criterion by
     * which uniqueness is computed. Result values are chosen from the first
     * array in which the value occurs. The iteratee is invoked with one argument:
     * (value).
     *
     * @static
     * @memberOf _
     * @since 4.0.0
     * @category Array
     * @param {...Array} [arrays] The arrays to inspect.
     * @param {Function} [iteratee=_.identity] The iteratee invoked per element.
     * @returns {Array} Returns the new array of combined values.
     * @example
     *
     * _.unionBy([2.1], [1.2, 2.3], Math.floor);
     * // => [2.1, 1.2]
     *
     * // The `_.property` iteratee shorthand.
     * _.unionBy([{ 'x': 1 }], [{ 'x': 2 }, { 'x': 1 }], 'x');
     * // => [{ 'x': 1 }, { 'x': 2 }]
     */
    var unionBy = baseRest(function(arrays) {
      var iteratee = last(arrays);
      if (isArrayLikeObject(iteratee)) {
        iteratee = undefined;
      }
      return baseUniq(baseFlatten(arrays, 1, isArrayLikeObject, true), getIteratee(iteratee, 2));
    });

    /**
     * This method is like `_.union` except that it accepts `comparator` which
     * is invoked to compare elements of `arrays`. Result values are chosen from
     * the first array in which the value occurs. The comparator is invoked
     * with two arguments: (arrVal, othVal).
     *
     * @static
     * @memberOf _
     * @since 4.0.0
     * @category Array
     * @param {...Array} [arrays] The arrays to inspect.
     * @param {Function} [comparator] The comparator invoked per element.
     * @returns {Array} Returns the new array of combined values.
     * @example
     *
     * var objects = [{ 'x': 1, 'y': 2 }, { 'x': 2, 'y': 1 }];
     * var others = [{ 'x': 1, 'y': 1 }, { 'x': 1, 'y': 2 }];
     *
     * _.unionWith(objects, others, _.isEqual);
     * // => [{ 'x': 1, 'y': 2 }, { 'x': 2, 'y': 1 }, { 'x': 1, 'y': 1 }]
     */
    var unionWith = baseRest(function(arrays) {
      var comparator = last(arrays);
      comparator = typeof comparator == 'function' ? comparator : undefined;
      return baseUniq(baseFlatten(arrays, 1, isArrayLikeObject, true), undefined, comparator);
    });

    /**
     * Creates a duplicate-free version of an array, using
     * [`SameValueZero`](http://ecma-international.org/ecma-262/7.0/#sec-samevaluezero)
     * for equality comparisons, in which only the first occurrence of each element
     * is kept. The order of result values is determined by the order they occur
     * in the array.
     *
     * @static
     * @memberOf _
     * @since 0.1.0
     * @category Array
     * @param {Array} array The array to inspect.
     * @returns {Array} Returns the new duplicate free array.
     * @example
     *
     * _.uniq([2, 1, 2]);
     * // => [2, 1]
     */
    function uniq(array) {
      return (array && array.length) ? baseUniq(array) : [];
    }

    /**
     * This method is like `_.uniq` except that it accepts `iteratee` which is
     * invoked for each element in `array` to generate the criterion by which
     * uniqueness is computed. The order of result values is determined by the
     * order they occur in the array. The iteratee is invoked with one argument:
     * (value).
     *
     * @static
     * @memberOf _
     * @since 4.0.0
     * @category Array
     * @param {Array} array The array to inspect.
     * @param {Function} [iteratee=_.identity] The iteratee invoked per element.
     * @returns {Array} Returns the new duplicate free array.
     * @example
     *
     * _.uniqBy([2.1, 1.2, 2.3], Math.floor);
     * // => [2.1, 1.2]
     *
     * // The `_.property` iteratee shorthand.
     * _.uniqBy([{ 'x': 1 }, { 'x': 2 }, { 'x': 1 }], 'x');
     * // => [{ 'x': 1 }, { 'x': 2 }]
     */
    function uniqBy(array, iteratee) {
      return (array && array.length) ? baseUniq(array, getIteratee(iteratee, 2)) : [];
    }

    /**
     * This method is like `_.uniq` except that it accepts `comparator` which
     * is invoked to compare elements of `array`. The order of result values is
     * determined by the order they occur in the array.The comparator is invoked
     * with two arguments: (arrVal, othVal).
     *
     * @static
     * @memberOf _
     * @since 4.0.0
     * @category Array
     * @param {Array} array The array to inspect.
     * @param {Function} [comparator] The comparator invoked per element.
     * @returns {Array} Returns the new duplicate free array.
     * @example
     *
     * var objects = [{ 'x': 1, 'y': 2 }, { 'x': 2, 'y': 1 }, { 'x': 1, 'y': 2 }];
     *
     * _.uniqWith(objects, _.isEqual);
     * // => [{ 'x': 1, 'y': 2 }, { 'x': 2, 'y': 1 }]
     */
    function uniqWith(array, comparator) {
      comparator = typeof comparator == 'function' ? comparator : undefined;
      return (array && array.length) ? baseUniq(array, undefined, comparator) : [];
    }

    /**
     * This method is like `_.zip` except that it accepts an array of grouped
     * elements and creates an array regrouping the elements to their pre-zip
     * configuration.
     *
     * @static
     * @memberOf _
     * @since 1.2.0
     * @category Array
     * @param {Array} array The array of grouped elements to process.
     * @returns {Array} Returns the new array of regrouped elements.
     * @example
     *
     * var zipped = _.zip(['a', 'b'], [1, 2], [true, false]);
     * // => [['a', 1, true], ['b', 2, false]]
     *
     * _.unzip(zipped);
     * // => [['a', 'b'], [1, 2], [true, false]]
     */
    function unzip(array) {
      if (!(array && array.length)) {
        return [];
      }
      var length = 0;
      array = arrayFilter(array, function(group) {
        if (isArrayLikeObject(group)) {
          length = nativeMax(group.length, length);
          return true;
        }
      });
      return baseTimes(length, function(index) {
        return arrayMap(array, baseProperty(index));
      });
    }

    /**
     * This method is like `_.unzip` except that it accepts `iteratee` to specify
     * how regrouped values should be combined. The iteratee is invoked with the
     * elements of each group: (...group).
     *
     * @static
     * @memberOf _
     * @since 3.8.0
     * @category Array
     * @param {Array} array The array of grouped elements to process.
     * @param {Function} [iteratee=_.identity] The function to combine
     *  regrouped values.
     * @returns {Array} Returns the new array of regrouped elements.
     * @example
     *
     * var zipped = _.zip([1, 2], [10, 20], [100, 200]);
     * // => [[1, 10, 100], [2, 20, 200]]
     *
     * _.unzipWith(zipped, _.add);
     * // => [3, 30, 300]
     */
    function unzipWith(array, iteratee) {
      if (!(array && array.length)) {
        return [];
      }
      var result = unzip(array);
      if (iteratee == null) {
        return result;
      }
      return arrayMap(result, function(group) {
        return apply(iteratee, undefined, group);
      });
    }

    /**
     * Creates an array excluding all given values using
     * [`SameValueZero`](http://ecma-international.org/ecma-262/7.0/#sec-samevaluezero)
     * for equality comparisons.
     *
     * **Note:** Unlike `_.pull`, this method returns a new array.
     *
     * @static
     * @memberOf _
     * @since 0.1.0
     * @category Array
     * @param {Array} array The array to inspect.
     * @param {...*} [values] The values to exclude.
     * @returns {Array} Returns the new array of filtered values.
     * @see _.difference, _.xor
     * @example
     *
     * _.without([2, 1, 2, 3], 1, 2);
     * // => [3]
     */
    var without = baseRest(function(array, values) {
      return isArrayLikeObject(array)
        ? baseDifference(array, values)
        : [];
    });

    /**
     * Creates an array of unique values that is the
     * [symmetric difference](https://en.wikipedia.org/wiki/Symmetric_difference)
     * of the given arrays. The order of result values is determined by the order
     * they occur in the arrays.
     *
     * @static
     * @memberOf _
     * @since 2.4.0
     * @category Array
     * @param {...Array} [arrays] The arrays to inspect.
     * @returns {Array} Returns the new array of filtered values.
     * @see _.difference, _.without
     * @example
     *
     * _.xor([2, 1], [2, 3]);
     * // => [1, 3]
     */
    var xor = baseRest(function(arrays) {
      return baseXor(arrayFilter(arrays, isArrayLikeObject));
    });

    /**
     * This method is like `_.xor` except that it accepts `iteratee` which is
     * invoked for each element of each `arrays` to generate the criterion by
     * which by which they're compared. The order of result values is determined
     * by the order they occur in the arrays. The iteratee is invoked with one
     * argument: (value).
     *
     * @static
     * @memberOf _
     * @since 4.0.0
     * @category Array
     * @param {...Array} [arrays] The arrays to inspect.
     * @param {Function} [iteratee=_.identity] The iteratee invoked per element.
     * @returns {Array} Returns the new array of filtered values.
     * @example
     *
     * _.xorBy([2.1, 1.2], [2.3, 3.4], Math.floor);
     * // => [1.2, 3.4]
     *
     * // The `_.property` iteratee shorthand.
     * _.xorBy([{ 'x': 1 }], [{ 'x': 2 }, { 'x': 1 }], 'x');
     * // => [{ 'x': 2 }]
     */
    var xorBy = baseRest(function(arrays) {
      var iteratee = last(arrays);
      if (isArrayLikeObject(iteratee)) {
        iteratee = undefined;
      }
      return baseXor(arrayFilter(arrays, isArrayLikeObject), getIteratee(iteratee, 2));
    });

    /**
     * This method is like `_.xor` except that it accepts `comparator` which is
     * invoked to compare elements of `arrays`. The order of result values is
     * determined by the order they occur in the arrays. The comparator is invoked
     * with two arguments: (arrVal, othVal).
     *
     * @static
     * @memberOf _
     * @since 4.0.0
     * @category Array
     * @param {...Array} [arrays] The arrays to inspect.
     * @param {Function} [comparator] The comparator invoked per element.
     * @returns {Array} Returns the new array of filtered values.
     * @example
     *
     * var objects = [{ 'x': 1, 'y': 2 }, { 'x': 2, 'y': 1 }];
     * var others = [{ 'x': 1, 'y': 1 }, { 'x': 1, 'y': 2 }];
     *
     * _.xorWith(objects, others, _.isEqual);
     * // => [{ 'x': 2, 'y': 1 }, { 'x': 1, 'y': 1 }]
     */
    var xorWith = baseRest(function(arrays) {
      var comparator = last(arrays);
      comparator = typeof comparator == 'function' ? comparator : undefined;
      return baseXor(arrayFilter(arrays, isArrayLikeObject), undefined, comparator);
    });

    /**
     * Creates an array of grouped elements, the first of which contains the
     * first elements of the given arrays, the second of which contains the
     * second elements of the given arrays, and so on.
     *
     * @static
     * @memberOf _
     * @since 0.1.0
     * @category Array
     * @param {...Array} [arrays] The arrays to process.
     * @returns {Array} Returns the new array of grouped elements.
     * @example
     *
     * _.zip(['a', 'b'], [1, 2], [true, false]);
     * // => [['a', 1, true], ['b', 2, false]]
     */
    var zip = baseRest(unzip);

    /**
     * This method is like `_.fromPairs` except that it accepts two arrays,
     * one of property identifiers and one of corresponding values.
     *
     * @static
     * @memberOf _
     * @since 0.4.0
     * @category Array
     * @param {Array} [props=[]] The property identifiers.
     * @param {Array} [values=[]] The property values.
     * @returns {Object} Returns the new object.
     * @example
     *
     * _.zipObject(['a', 'b'], [1, 2]);
     * // => { 'a': 1, 'b': 2 }
     */
    function zipObject(props, values) {
      return baseZipObject(props || [], values || [], assignValue);
    }

    /**
     * This method is like `_.zipObject` except that it supports property paths.
     *
     * @static
     * @memberOf _
     * @since 4.1.0
     * @category Array
     * @param {Array} [props=[]] The property identifiers.
     * @param {Array} [values=[]] The property values.
     * @returns {Object} Returns the new object.
     * @example
     *
     * _.zipObjectDeep(['a.b[0].c', 'a.b[1].d'], [1, 2]);
     * // => { 'a': { 'b': [{ 'c': 1 }, { 'd': 2 }] } }
     */
    function zipObjectDeep(props, values) {
      return baseZipObject(props || [], values || [], baseSet);
    }

    /**
     * This method is like `_.zip` except that it accepts `iteratee` to specify
     * how grouped values should be combined. The iteratee is invoked with the
     * elements of each group: (...group).
     *
     * @static
     * @memberOf _
     * @since 3.8.0
     * @category Array
     * @param {...Array} [arrays] The arrays to process.
     * @param {Function} [iteratee=_.identity] The function to combine
     *  grouped values.
     * @returns {Array} Returns the new array of grouped elements.
     * @example
     *
     * _.zipWith([1, 2], [10, 20], [100, 200], function(a, b, c) {
     *   return a + b + c;
     * });
     * // => [111, 222]
     */
    var zipWith = baseRest(function(arrays) {
      var length = arrays.length,
          iteratee = length > 1 ? arrays[length - 1] : undefined;

      iteratee = typeof iteratee == 'function' ? (arrays.pop(), iteratee) : undefined;
      return unzipWith(arrays, iteratee);
    });

    /*------------------------------------------------------------------------*/

    /**
     * Creates a `lodash` wrapper instance that wraps `value` with explicit method
     * chain sequences enabled. The result of such sequences must be unwrapped
     * with `_#value`.
     *
     * @static
     * @memberOf _
     * @since 1.3.0
     * @category Seq
     * @param {*} value The value to wrap.
     * @returns {Object} Returns the new `lodash` wrapper instance.
     * @example
     *
     * var users = [
     *   { 'user': 'barney',  'age': 36 },
     *   { 'user': 'fred',    'age': 40 },
     *   { 'user': 'pebbles', 'age': 1 }
     * ];
     *
     * var youngest = _
     *   .chain(users)
     *   .sortBy('age')
     *   .map(function(o) {
     *     return o.user + ' is ' + o.age;
     *   })
     *   .head()
     *   .value();
     * // => 'pebbles is 1'
     */
    function chain(value) {
      var result = lodash(value);
      result.__chain__ = true;
      return result;
    }

    /**
     * This method invokes `interceptor` and returns `value`. The interceptor
     * is invoked with one argument; (value). The purpose of this method is to
     * "tap into" a method chain sequence in order to modify intermediate results.
     *
     * @static
     * @memberOf _
     * @since 0.1.0
     * @category Seq
     * @param {*} value The value to provide to `interceptor`.
     * @param {Function} interceptor The function to invoke.
     * @returns {*} Returns `value`.
     * @example
     *
     * _([1, 2, 3])
     *  .tap(function(array) {
     *    // Mutate input array.
     *    array.pop();
     *  })
     *  .reverse()
     *  .value();
     * // => [2, 1]
     */
    function tap(value, interceptor) {
      interceptor(value);
      return value;
    }

    /**
     * This method is like `_.tap` except that it returns the result of `interceptor`.
     * The purpose of this method is to "pass thru" values replacing intermediate
     * results in a method chain sequence.
     *
     * @static
     * @memberOf _
     * @since 3.0.0
     * @category Seq
     * @param {*} value The value to provide to `interceptor`.
     * @param {Function} interceptor The function to invoke.
     * @returns {*} Returns the result of `interceptor`.
     * @example
     *
     * _('  abc  ')
     *  .chain()
     *  .trim()
     *  .thru(function(value) {
     *    return [value];
     *  })
     *  .value();
     * // => ['abc']
     */
    function thru(value, interceptor) {
      return interceptor(value);
    }

    /**
     * This method is the wrapper version of `_.at`.
     *
     * @name at
     * @memberOf _
     * @since 1.0.0
     * @category Seq
     * @param {...(string|string[])} [paths] The property paths to pick.
     * @returns {Object} Returns the new `lodash` wrapper instance.
     * @example
     *
     * var object = { 'a': [{ 'b': { 'c': 3 } }, 4] };
     *
     * _(object).at(['a[0].b.c', 'a[1]']).value();
     * // => [3, 4]
     */
    var wrapperAt = flatRest(function(paths) {
      var length = paths.length,
          start = length ? paths[0] : 0,
          value = this.__wrapped__,
          interceptor = function(object) { return baseAt(object, paths); };

      if (length > 1 || this.__actions__.length ||
          !(value instanceof LazyWrapper) || !isIndex(start)) {
        return this.thru(interceptor);
      }
      value = value.slice(start, +start + (length ? 1 : 0));
      value.__actions__.push({
        'func': thru,
        'args': [interceptor],
        'thisArg': undefined
      });
      return new LodashWrapper(value, this.__chain__).thru(function(array) {
        if (length && !array.length) {
          array.push(undefined);
        }
        return array;
      });
    });

    /**
     * Creates a `lodash` wrapper instance with explicit method chain sequences enabled.
     *
     * @name chain
     * @memberOf _
     * @since 0.1.0
     * @category Seq
     * @returns {Object} Returns the new `lodash` wrapper instance.
     * @example
     *
     * var users = [
     *   { 'user': 'barney', 'age': 36 },
     *   { 'user': 'fred',   'age': 40 }
     * ];
     *
     * // A sequence without explicit chaining.
     * _(users).head();
     * // => { 'user': 'barney', 'age': 36 }
     *
     * // A sequence with explicit chaining.
     * _(users)
     *   .chain()
     *   .head()
     *   .pick('user')
     *   .value();
     * // => { 'user': 'barney' }
     */
    function wrapperChain() {
      return chain(this);
    }

    /**
     * Executes the chain sequence and returns the wrapped result.
     *
     * @name commit
     * @memberOf _
     * @since 3.2.0
     * @category Seq
     * @returns {Object} Returns the new `lodash` wrapper instance.
     * @example
     *
     * var array = [1, 2];
     * var wrapped = _(array).push(3);
     *
     * console.log(array);
     * // => [1, 2]
     *
     * wrapped = wrapped.commit();
     * console.log(array);
     * // => [1, 2, 3]
     *
     * wrapped.last();
     * // => 3
     *
     * console.log(array);
     * // => [1, 2, 3]
     */
    function wrapperCommit() {
      return new LodashWrapper(this.value(), this.__chain__);
    }

    /**
     * Gets the next value on a wrapped object following the
     * [iterator protocol](https://mdn.io/iteration_protocols#iterator).
     *
     * @name next
     * @memberOf _
     * @since 4.0.0
     * @category Seq
     * @returns {Object} Returns the next iterator value.
     * @example
     *
     * var wrapped = _([1, 2]);
     *
     * wrapped.next();
     * // => { 'done': false, 'value': 1 }
     *
     * wrapped.next();
     * // => { 'done': false, 'value': 2 }
     *
     * wrapped.next();
     * // => { 'done': true, 'value': undefined }
     */
    function wrapperNext() {
      if (this.__values__ === undefined) {
        this.__values__ = toArray(this.value());
      }
      var done = this.__index__ >= this.__values__.length,
          value = done ? undefined : this.__values__[this.__index__++];

      return { 'done': done, 'value': value };
    }

    /**
     * Enables the wrapper to be iterable.
     *
     * @name Symbol.iterator
     * @memberOf _
     * @since 4.0.0
     * @category Seq
     * @returns {Object} Returns the wrapper object.
     * @example
     *
     * var wrapped = _([1, 2]);
     *
     * wrapped[Symbol.iterator]() === wrapped;
     * // => true
     *
     * Array.from(wrapped);
     * // => [1, 2]
     */
    function wrapperToIterator() {
      return this;
    }

    /**
     * Creates a clone of the chain sequence planting `value` as the wrapped value.
     *
     * @name plant
     * @memberOf _
     * @since 3.2.0
     * @category Seq
     * @param {*} value The value to plant.
     * @returns {Object} Returns the new `lodash` wrapper instance.
     * @example
     *
     * function square(n) {
     *   return n * n;
     * }
     *
     * var wrapped = _([1, 2]).map(square);
     * var other = wrapped.plant([3, 4]);
     *
     * other.value();
     * // => [9, 16]
     *
     * wrapped.value();
     * // => [1, 4]
     */
    function wrapperPlant(value) {
      var result,
          parent = this;

      while (parent instanceof baseLodash) {
        var clone = wrapperClone(parent);
        clone.__index__ = 0;
        clone.__values__ = undefined;
        if (result) {
          previous.__wrapped__ = clone;
        } else {
          result = clone;
        }
        var previous = clone;
        parent = parent.__wrapped__;
      }
      previous.__wrapped__ = value;
      return result;
    }

    /**
     * This method is the wrapper version of `_.reverse`.
     *
     * **Note:** This method mutates the wrapped array.
     *
     * @name reverse
     * @memberOf _
     * @since 0.1.0
     * @category Seq
     * @returns {Object} Returns the new `lodash` wrapper instance.
     * @example
     *
     * var array = [1, 2, 3];
     *
     * _(array).reverse().value()
     * // => [3, 2, 1]
     *
     * console.log(array);
     * // => [3, 2, 1]
     */
    function wrapperReverse() {
      var value = this.__wrapped__;
      if (value instanceof LazyWrapper) {
        var wrapped = value;
        if (this.__actions__.length) {
          wrapped = new LazyWrapper(this);
        }
        wrapped = wrapped.reverse();
        wrapped.__actions__.push({
          'func': thru,
          'args': [reverse],
          'thisArg': undefined
        });
        return new LodashWrapper(wrapped, this.__chain__);
      }
      return this.thru(reverse);
    }

    /**
     * Executes the chain sequence to resolve the unwrapped value.
     *
     * @name value
     * @memberOf _
     * @since 0.1.0
     * @alias toJSON, valueOf
     * @category Seq
     * @returns {*} Returns the resolved unwrapped value.
     * @example
     *
     * _([1, 2, 3]).value();
     * // => [1, 2, 3]
     */
    function wrapperValue() {
      return baseWrapperValue(this.__wrapped__, this.__actions__);
    }

    /*------------------------------------------------------------------------*/

    /**
     * Creates an object composed of keys generated from the results of running
     * each element of `collection` thru `iteratee`. The corresponding value of
     * each key is the number of times the key was returned by `iteratee`. The
     * iteratee is invoked with one argument: (value).
     *
     * @static
     * @memberOf _
     * @since 0.5.0
     * @category Collection
     * @param {Array|Object} collection The collection to iterate over.
     * @param {Function} [iteratee=_.identity] The iteratee to transform keys.
     * @returns {Object} Returns the composed aggregate object.
     * @example
     *
     * _.countBy([6.1, 4.2, 6.3], Math.floor);
     * // => { '4': 1, '6': 2 }
     *
     * // The `_.property` iteratee shorthand.
     * _.countBy(['one', 'two', 'three'], 'length');
     * // => { '3': 2, '5': 1 }
     */
    var countBy = createAggregator(function(result, value, key) {
      if (hasOwnProperty.call(result, key)) {
        ++result[key];
      } else {
        baseAssignValue(result, key, 1);
      }
    });

    /**
     * Checks if `predicate` returns truthy for **all** elements of `collection`.
     * Iteration is stopped once `predicate` returns falsey. The predicate is
     * invoked with three arguments: (value, index|key, collection).
     *
     * **Note:** This method returns `true` for
     * [empty collections](https://en.wikipedia.org/wiki/Empty_set) because
     * [everything is true](https://en.wikipedia.org/wiki/Vacuous_truth) of
     * elements of empty collections.
     *
     * @static
     * @memberOf _
     * @since 0.1.0
     * @category Collection
     * @param {Array|Object} collection The collection to iterate over.
     * @param {Function} [predicate=_.identity] The function invoked per iteration.
     * @param- {Object} [guard] Enables use as an iteratee for methods like `_.map`.
     * @returns {boolean} Returns `true` if all elements pass the predicate check,
     *  else `false`.
     * @example
     *
     * _.every([true, 1, null, 'yes'], Boolean);
     * // => false
     *
     * var users = [
     *   { 'user': 'barney', 'age': 36, 'active': false },
     *   { 'user': 'fred',   'age': 40, 'active': false }
     * ];
     *
     * // The `_.matches` iteratee shorthand.
     * _.every(users, { 'user': 'barney', 'active': false });
     * // => false
     *
     * // The `_.matchesProperty` iteratee shorthand.
     * _.every(users, ['active', false]);
     * // => true
     *
     * // The `_.property` iteratee shorthand.
     * _.every(users, 'active');
     * // => false
     */
    function every(collection, predicate, guard) {
      var func = isArray(collection) ? arrayEvery : baseEvery;
      if (guard && isIterateeCall(collection, predicate, guard)) {
        predicate = undefined;
      }
      return func(collection, getIteratee(predicate, 3));
    }

    /**
     * Iterates over elements of `collection`, returning an array of all elements
     * `predicate` returns truthy for. The predicate is invoked with three
     * arguments: (value, index|key, collection).
     *
     * **Note:** Unlike `_.remove`, this method returns a new array.
     *
     * @static
     * @memberOf _
     * @since 0.1.0
     * @category Collection
     * @param {Array|Object} collection The collection to iterate over.
     * @param {Function} [predicate=_.identity] The function invoked per iteration.
     * @returns {Array} Returns the new filtered array.
     * @see _.reject
     * @example
     *
     * var users = [
     *   { 'user': 'barney', 'age': 36, 'active': true },
     *   { 'user': 'fred',   'age': 40, 'active': false }
     * ];
     *
     * _.filter(users, function(o) { return !o.active; });
     * // => objects for ['fred']
     *
     * // The `_.matches` iteratee shorthand.
     * _.filter(users, { 'age': 36, 'active': true });
     * // => objects for ['barney']
     *
     * // The `_.matchesProperty` iteratee shorthand.
     * _.filter(users, ['active', false]);
     * // => objects for ['fred']
     *
     * // The `_.property` iteratee shorthand.
     * _.filter(users, 'active');
     * // => objects for ['barney']
     */
    function filter(collection, predicate) {
      var func = isArray(collection) ? arrayFilter : baseFilter;
      return func(collection, getIteratee(predicate, 3));
    }

    /**
     * Iterates over elements of `collection`, returning the first element
     * `predicate` returns truthy for. The predicate is invoked with three
     * arguments: (value, index|key, collection).
     *
     * @static
     * @memberOf _
     * @since 0.1.0
     * @category Collection
     * @param {Array|Object} collection The collection to inspect.
     * @param {Function} [predicate=_.identity] The function invoked per iteration.
     * @param {number} [fromIndex=0] The index to search from.
     * @returns {*} Returns the matched element, else `undefined`.
     * @example
     *
     * var users = [
     *   { 'user': 'barney',  'age': 36, 'active': true },
     *   { 'user': 'fred',    'age': 40, 'active': false },
     *   { 'user': 'pebbles', 'age': 1,  'active': true }
     * ];
     *
     * _.find(users, function(o) { return o.age < 40; });
     * // => object for 'barney'
     *
     * // The `_.matches` iteratee shorthand.
     * _.find(users, { 'age': 1, 'active': true });
     * // => object for 'pebbles'
     *
     * // The `_.matchesProperty` iteratee shorthand.
     * _.find(users, ['active', false]);
     * // => object for 'fred'
     *
     * // The `_.property` iteratee shorthand.
     * _.find(users, 'active');
     * // => object for 'barney'
     */
    var find = createFind(findIndex);

    /**
     * This method is like `_.find` except that it iterates over elements of
     * `collection` from right to left.
     *
     * @static
     * @memberOf _
     * @since 2.0.0
     * @category Collection
     * @param {Array|Object} collection The collection to inspect.
     * @param {Function} [predicate=_.identity] The function invoked per iteration.
     * @param {number} [fromIndex=collection.length-1] The index to search from.
     * @returns {*} Returns the matched element, else `undefined`.
     * @example
     *
     * _.findLast([1, 2, 3, 4], function(n) {
     *   return n % 2 == 1;
     * });
     * // => 3
     */
    var findLast = createFind(findLastIndex);

    /**
     * Creates a flattened array of values by running each element in `collection`
     * thru `iteratee` and flattening the mapped results. The iteratee is invoked
     * with three arguments: (value, index|key, collection).
     *
     * @static
     * @memberOf _
     * @since 4.0.0
     * @category Collection
     * @param {Array|Object} collection The collection to iterate over.
     * @param {Function} [iteratee=_.identity] The function invoked per iteration.
     * @returns {Array} Returns the new flattened array.
     * @example
     *
     * function duplicate(n) {
     *   return [n, n];
     * }
     *
     * _.flatMap([1, 2], duplicate);
     * // => [1, 1, 2, 2]
     */
    function flatMap(collection, iteratee) {
      return baseFlatten(map(collection, iteratee), 1);
    }

    /**
     * This method is like `_.flatMap` except that it recursively flattens the
     * mapped results.
     *
     * @static
     * @memberOf _
     * @since 4.7.0
     * @category Collection
     * @param {Array|Object} collection The collection to iterate over.
     * @param {Function} [iteratee=_.identity] The function invoked per iteration.
     * @returns {Array} Returns the new flattened array.
     * @example
     *
     * function duplicate(n) {
     *   return [[[n, n]]];
     * }
     *
     * _.flatMapDeep([1, 2], duplicate);
     * // => [1, 1, 2, 2]
     */
    function flatMapDeep(collection, iteratee) {
      return baseFlatten(map(collection, iteratee), INFINITY);
    }

    /**
     * This method is like `_.flatMap` except that it recursively flattens the
     * mapped results up to `depth` times.
     *
     * @static
     * @memberOf _
     * @since 4.7.0
     * @category Collection
     * @param {Array|Object} collection The collection to iterate over.
     * @param {Function} [iteratee=_.identity] The function invoked per iteration.
     * @param {number} [depth=1] The maximum recursion depth.
     * @returns {Array} Returns the new flattened array.
     * @example
     *
     * function duplicate(n) {
     *   return [[[n, n]]];
     * }
     *
     * _.flatMapDepth([1, 2], duplicate, 2);
     * // => [[1, 1], [2, 2]]
     */
    function flatMapDepth(collection, iteratee, depth) {
      depth = depth === undefined ? 1 : toInteger(depth);
      return baseFlatten(map(collection, iteratee), depth);
    }

    /**
     * Iterates over elements of `collection` and invokes `iteratee` for each element.
     * The iteratee is invoked with three arguments: (value, index|key, collection).
     * Iteratee functions may exit iteration early by explicitly returning `false`.
     *
     * **Note:** As with other "Collections" methods, objects with a "length"
     * property are iterated like arrays. To avoid this behavior use `_.forIn`
     * or `_.forOwn` for object iteration.
     *
     * @static
     * @memberOf _
     * @since 0.1.0
     * @alias each
     * @category Collection
     * @param {Array|Object} collection The collection to iterate over.
     * @param {Function} [iteratee=_.identity] The function invoked per iteration.
     * @returns {Array|Object} Returns `collection`.
     * @see _.forEachRight
     * @example
     *
     * _.forEach([1, 2], function(value) {
     *   console.log(value);
     * });
     * // => Logs `1` then `2`.
     *
     * _.forEach({ 'a': 1, 'b': 2 }, function(value, key) {
     *   console.log(key);
     * });
     * // => Logs 'a' then 'b' (iteration order is not guaranteed).
     */
    function forEach(collection, iteratee) {
      var func = isArray(collection) ? arrayEach : baseEach;
      return func(collection, getIteratee(iteratee, 3));
    }

    /**
     * This method is like `_.forEach` except that it iterates over elements of
     * `collection` from right to left.
     *
     * @static
     * @memberOf _
     * @since 2.0.0
     * @alias eachRight
     * @category Collection
     * @param {Array|Object} collection The collection to iterate over.
     * @param {Function} [iteratee=_.identity] The function invoked per iteration.
     * @returns {Array|Object} Returns `collection`.
     * @see _.forEach
     * @example
     *
     * _.forEachRight([1, 2], function(value) {
     *   console.log(value);
     * });
     * // => Logs `2` then `1`.
     */
    function forEachRight(collection, iteratee) {
      var func = isArray(collection) ? arrayEachRight : baseEachRight;
      return func(collection, getIteratee(iteratee, 3));
    }

    /**
     * Creates an object composed of keys generated from the results of running
     * each element of `collection` thru `iteratee`. The order of grouped values
     * is determined by the order they occur in `collection`. The corresponding
     * value of each key is an array of elements responsible for generating the
     * key. The iteratee is invoked with one argument: (value).
     *
     * @static
     * @memberOf _
     * @since 0.1.0
     * @category Collection
     * @param {Array|Object} collection The collection to iterate over.
     * @param {Function} [iteratee=_.identity] The iteratee to transform keys.
     * @returns {Object} Returns the composed aggregate object.
     * @example
     *
     * _.groupBy([6.1, 4.2, 6.3], Math.floor);
     * // => { '4': [4.2], '6': [6.1, 6.3] }
     *
     * // The `_.property` iteratee shorthand.
     * _.groupBy(['one', 'two', 'three'], 'length');
     * // => { '3': ['one', 'two'], '5': ['three'] }
     */
    var groupBy = createAggregator(function(result, value, key) {
      if (hasOwnProperty.call(result, key)) {
        result[key].push(value);
      } else {
        baseAssignValue(result, key, [value]);
      }
    });

    /**
     * Checks if `value` is in `collection`. If `collection` is a string, it's
     * checked for a substring of `value`, otherwise
     * [`SameValueZero`](http://ecma-international.org/ecma-262/7.0/#sec-samevaluezero)
     * is used for equality comparisons. If `fromIndex` is negative, it's used as
     * the offset from the end of `collection`.
     *
     * @static
     * @memberOf _
     * @since 0.1.0
     * @category Collection
     * @param {Array|Object|string} collection The collection to inspect.
     * @param {*} value The value to search for.
     * @param {number} [fromIndex=0] The index to search from.
     * @param- {Object} [guard] Enables use as an iteratee for methods like `_.reduce`.
     * @returns {boolean} Returns `true` if `value` is found, else `false`.
     * @example
     *
     * _.includes([1, 2, 3], 1);
     * // => true
     *
     * _.includes([1, 2, 3], 1, 2);
     * // => false
     *
     * _.includes({ 'a': 1, 'b': 2 }, 1);
     * // => true
     *
     * _.includes('abcd', 'bc');
     * // => true
     */
    function includes(collection, value, fromIndex, guard) {
      collection = isArrayLike(collection) ? collection : values(collection);
      fromIndex = (fromIndex && !guard) ? toInteger(fromIndex) : 0;

      var length = collection.length;
      if (fromIndex < 0) {
        fromIndex = nativeMax(length + fromIndex, 0);
      }
      return isString(collection)
        ? (fromIndex <= length && collection.indexOf(value, fromIndex) > -1)
        : (!!length && baseIndexOf(collection, value, fromIndex) > -1);
    }

    /**
     * Invokes the method at `path` of each element in `collection`, returning
     * an array of the results of each invoked method. Any additional arguments
     * are provided to each invoked method. If `path` is a function, it's invoked
     * for, and `this` bound to, each element in `collection`.
     *
     * @static
     * @memberOf _
     * @since 4.0.0
     * @category Collection
     * @param {Array|Object} collection The collection to iterate over.
     * @param {Array|Function|string} path The path of the method to invoke or
     *  the function invoked per iteration.
     * @param {...*} [args] The arguments to invoke each method with.
     * @returns {Array} Returns the array of results.
     * @example
     *
     * _.invokeMap([[5, 1, 7], [3, 2, 1]], 'sort');
     * // => [[1, 5, 7], [1, 2, 3]]
     *
     * _.invokeMap([123, 456], String.prototype.split, '');
     * // => [['1', '2', '3'], ['4', '5', '6']]
     */
    var invokeMap = baseRest(function(collection, path, args) {
      var index = -1,
          isFunc = typeof path == 'function',
          result = isArrayLike(collection) ? Array(collection.length) : [];

      baseEach(collection, function(value) {
        result[++index] = isFunc ? apply(path, value, args) : baseInvoke(value, path, args);
      });
      return result;
    });

    /**
     * Creates an object composed of keys generated from the results of running
     * each element of `collection` thru `iteratee`. The corresponding value of
     * each key is the last element responsible for generating the key. The
     * iteratee is invoked with one argument: (value).
     *
     * @static
     * @memberOf _
     * @since 4.0.0
     * @category Collection
     * @param {Array|Object} collection The collection to iterate over.
     * @param {Function} [iteratee=_.identity] The iteratee to transform keys.
     * @returns {Object} Returns the composed aggregate object.
     * @example
     *
     * var array = [
     *   { 'dir': 'left', 'code': 97 },
     *   { 'dir': 'right', 'code': 100 }
     * ];
     *
     * _.keyBy(array, function(o) {
     *   return String.fromCharCode(o.code);
     * });
     * // => { 'a': { 'dir': 'left', 'code': 97 }, 'd': { 'dir': 'right', 'code': 100 } }
     *
     * _.keyBy(array, 'dir');
     * // => { 'left': { 'dir': 'left', 'code': 97 }, 'right': { 'dir': 'right', 'code': 100 } }
     */
    var keyBy = createAggregator(function(result, value, key) {
      baseAssignValue(result, key, value);
    });

    /**
     * Creates an array of values by running each element in `collection` thru
     * `iteratee`. The iteratee is invoked with three arguments:
     * (value, index|key, collection).
     *
     * Many lodash methods are guarded to work as iteratees for methods like
     * `_.every`, `_.filter`, `_.map`, `_.mapValues`, `_.reject`, and `_.some`.
     *
     * The guarded methods are:
     * `ary`, `chunk`, `curry`, `curryRight`, `drop`, `dropRight`, `every`,
     * `fill`, `invert`, `parseInt`, `random`, `range`, `rangeRight`, `repeat`,
     * `sampleSize`, `slice`, `some`, `sortBy`, `split`, `take`, `takeRight`,
     * `template`, `trim`, `trimEnd`, `trimStart`, and `words`
     *
     * @static
     * @memberOf _
     * @since 0.1.0
     * @category Collection
     * @param {Array|Object} collection The collection to iterate over.
     * @param {Function} [iteratee=_.identity] The function invoked per iteration.
     * @returns {Array} Returns the new mapped array.
     * @example
     *
     * function square(n) {
     *   return n * n;
     * }
     *
     * _.map([4, 8], square);
     * // => [16, 64]
     *
     * _.map({ 'a': 4, 'b': 8 }, square);
     * // => [16, 64] (iteration order is not guaranteed)
     *
     * var users = [
     *   { 'user': 'barney' },
     *   { 'user': 'fred' }
     * ];
     *
     * // The `_.property` iteratee shorthand.
     * _.map(users, 'user');
     * // => ['barney', 'fred']
     */
    function map(collection, iteratee) {
      var func = isArray(collection) ? arrayMap : baseMap;
      return func(collection, getIteratee(iteratee, 3));
    }

    /**
     * This method is like `_.sortBy` except that it allows specifying the sort
     * orders of the iteratees to sort by. If `orders` is unspecified, all values
     * are sorted in ascending order. Otherwise, specify an order of "desc" for
     * descending or "asc" for ascending sort order of corresponding values.
     *
     * @static
     * @memberOf _
     * @since 4.0.0
     * @category Collection
     * @param {Array|Object} collection The collection to iterate over.
     * @param {Array[]|Function[]|Object[]|string[]} [iteratees=[_.identity]]
     *  The iteratees to sort by.
     * @param {string[]} [orders] The sort orders of `iteratees`.
     * @param- {Object} [guard] Enables use as an iteratee for methods like `_.reduce`.
     * @returns {Array} Returns the new sorted array.
     * @example
     *
     * var users = [
     *   { 'user': 'fred',   'age': 48 },
     *   { 'user': 'barney', 'age': 34 },
     *   { 'user': 'fred',   'age': 40 },
     *   { 'user': 'barney', 'age': 36 }
     * ];
     *
     * // Sort by `user` in ascending order and by `age` in descending order.
     * _.orderBy(users, ['user', 'age'], ['asc', 'desc']);
     * // => objects for [['barney', 36], ['barney', 34], ['fred', 48], ['fred', 40]]
     */
    function orderBy(collection, iteratees, orders, guard) {
      if (collection == null) {
        return [];
      }
      if (!isArray(iteratees)) {
        iteratees = iteratees == null ? [] : [iteratees];
      }
      orders = guard ? undefined : orders;
      if (!isArray(orders)) {
        orders = orders == null ? [] : [orders];
      }
      return baseOrderBy(collection, iteratees, orders);
    }

    /**
     * Creates an array of elements split into two groups, the first of which
     * contains elements `predicate` returns truthy for, the second of which
     * contains elements `predicate` returns falsey for. The predicate is
     * invoked with one argument: (value).
     *
     * @static
     * @memberOf _
     * @since 3.0.0
     * @category Collection
     * @param {Array|Object} collection The collection to iterate over.
     * @param {Function} [predicate=_.identity] The function invoked per iteration.
     * @returns {Array} Returns the array of grouped elements.
     * @example
     *
     * var users = [
     *   { 'user': 'barney',  'age': 36, 'active': false },
     *   { 'user': 'fred',    'age': 40, 'active': true },
     *   { 'user': 'pebbles', 'age': 1,  'active': false }
     * ];
     *
     * _.partition(users, function(o) { return o.active; });
     * // => objects for [['fred'], ['barney', 'pebbles']]
     *
     * // The `_.matches` iteratee shorthand.
     * _.partition(users, { 'age': 1, 'active': false });
     * // => objects for [['pebbles'], ['barney', 'fred']]
     *
     * // The `_.matchesProperty` iteratee shorthand.
     * _.partition(users, ['active', false]);
     * // => objects for [['barney', 'pebbles'], ['fred']]
     *
     * // The `_.property` iteratee shorthand.
     * _.partition(users, 'active');
     * // => objects for [['fred'], ['barney', 'pebbles']]
     */
    var partition = createAggregator(function(result, value, key) {
      result[key ? 0 : 1].push(value);
    }, function() { return [[], []]; });

    /**
     * Reduces `collection` to a value which is the accumulated result of running
     * each element in `collection` thru `iteratee`, where each successive
     * invocation is supplied the return value of the previous. If `accumulator`
     * is not given, the first element of `collection` is used as the initial
     * value. The iteratee is invoked with four arguments:
     * (accumulator, value, index|key, collection).
     *
     * Many lodash methods are guarded to work as iteratees for methods like
     * `_.reduce`, `_.reduceRight`, and `_.transform`.
     *
     * The guarded methods are:
     * `assign`, `defaults`, `defaultsDeep`, `includes`, `merge`, `orderBy`,
     * and `sortBy`
     *
     * @static
     * @memberOf _
     * @since 0.1.0
     * @category Collection
     * @param {Array|Object} collection The collection to iterate over.
     * @param {Function} [iteratee=_.identity] The function invoked per iteration.
     * @param {*} [accumulator] The initial value.
     * @returns {*} Returns the accumulated value.
     * @see _.reduceRight
     * @example
     *
     * _.reduce([1, 2], function(sum, n) {
     *   return sum + n;
     * }, 0);
     * // => 3
     *
     * _.reduce({ 'a': 1, 'b': 2, 'c': 1 }, function(result, value, key) {
     *   (result[value] || (result[value] = [])).push(key);
     *   return result;
     * }, {});
     * // => { '1': ['a', 'c'], '2': ['b'] } (iteration order is not guaranteed)
     */
    function reduce(collection, iteratee, accumulator) {
      var func = isArray(collection) ? arrayReduce : baseReduce,
          initAccum = arguments.length < 3;

      return func(collection, getIteratee(iteratee, 4), accumulator, initAccum, baseEach);
    }

    /**
     * This method is like `_.reduce` except that it iterates over elements of
     * `collection` from right to left.
     *
     * @static
     * @memberOf _
     * @since 0.1.0
     * @category Collection
     * @param {Array|Object} collection The collection to iterate over.
     * @param {Function} [iteratee=_.identity] The function invoked per iteration.
     * @param {*} [accumulator] The initial value.
     * @returns {*} Returns the accumulated value.
     * @see _.reduce
     * @example
     *
     * var array = [[0, 1], [2, 3], [4, 5]];
     *
     * _.reduceRight(array, function(flattened, other) {
     *   return flattened.concat(other);
     * }, []);
     * // => [4, 5, 2, 3, 0, 1]
     */
    function reduceRight(collection, iteratee, accumulator) {
      var func = isArray(collection) ? arrayReduceRight : baseReduce,
          initAccum = arguments.length < 3;

      return func(collection, getIteratee(iteratee, 4), accumulator, initAccum, baseEachRight);
    }

    /**
     * The opposite of `_.filter`; this method returns the elements of `collection`
     * that `predicate` does **not** return truthy for.
     *
     * @static
     * @memberOf _
     * @since 0.1.0
     * @category Collection
     * @param {Array|Object} collection The collection to iterate over.
     * @param {Function} [predicate=_.identity] The function invoked per iteration.
     * @returns {Array} Returns the new filtered array.
     * @see _.filter
     * @example
     *
     * var users = [
     *   { 'user': 'barney', 'age': 36, 'active': false },
     *   { 'user': 'fred',   'age': 40, 'active': true }
     * ];
     *
     * _.reject(users, function(o) { return !o.active; });
     * // => objects for ['fred']
     *
     * // The `_.matches` iteratee shorthand.
     * _.reject(users, { 'age': 40, 'active': true });
     * // => objects for ['barney']
     *
     * // The `_.matchesProperty` iteratee shorthand.
     * _.reject(users, ['active', false]);
     * // => objects for ['fred']
     *
     * // The `_.property` iteratee shorthand.
     * _.reject(users, 'active');
     * // => objects for ['barney']
     */
    function reject(collection, predicate) {
      var func = isArray(collection) ? arrayFilter : baseFilter;
      return func(collection, negate(getIteratee(predicate, 3)));
    }

    /**
     * Gets a random element from `collection`.
     *
     * @static
     * @memberOf _
     * @since 2.0.0
     * @category Collection
     * @param {Array|Object} collection The collection to sample.
     * @returns {*} Returns the random element.
     * @example
     *
     * _.sample([1, 2, 3, 4]);
     * // => 2
     */
    function sample(collection) {
      var func = isArray(collection) ? arraySample : baseSample;
      return func(collection);
    }

    /**
     * Gets `n` random elements at unique keys from `collection` up to the
     * size of `collection`.
     *
     * @static
     * @memberOf _
     * @since 4.0.0
     * @category Collection
     * @param {Array|Object} collection The collection to sample.
     * @param {number} [n=1] The number of elements to sample.
     * @param- {Object} [guard] Enables use as an iteratee for methods like `_.map`.
     * @returns {Array} Returns the random elements.
     * @example
     *
     * _.sampleSize([1, 2, 3], 2);
     * // => [3, 1]
     *
     * _.sampleSize([1, 2, 3], 4);
     * // => [2, 3, 1]
     */
    function sampleSize(collection, n, guard) {
      if ((guard ? isIterateeCall(collection, n, guard) : n === undefined)) {
        n = 1;
      } else {
        n = toInteger(n);
      }
      var func = isArray(collection) ? arraySampleSize : baseSampleSize;
      return func(collection, n);
    }

    /**
     * Creates an array of shuffled values, using a version of the
     * [Fisher-Yates shuffle](https://en.wikipedia.org/wiki/Fisher-Yates_shuffle).
     *
     * @static
     * @memberOf _
     * @since 0.1.0
     * @category Collection
     * @param {Array|Object} collection The collection to shuffle.
     * @returns {Array} Returns the new shuffled array.
     * @example
     *
     * _.shuffle([1, 2, 3, 4]);
     * // => [4, 1, 3, 2]
     */
    function shuffle(collection) {
      var func = isArray(collection) ? arrayShuffle : baseShuffle;
      return func(collection);
    }

    /**
     * Gets the size of `collection` by returning its length for array-like
     * values or the number of own enumerable string keyed properties for objects.
     *
     * @static
     * @memberOf _
     * @since 0.1.0
     * @category Collection
     * @param {Array|Object|string} collection The collection to inspect.
     * @returns {number} Returns the collection size.
     * @example
     *
     * _.size([1, 2, 3]);
     * // => 3
     *
     * _.size({ 'a': 1, 'b': 2 });
     * // => 2
     *
     * _.size('pebbles');
     * // => 7
     */
    function size(collection) {
      if (collection == null) {
        return 0;
      }
      if (isArrayLike(collection)) {
        return isString(collection) ? stringSize(collection) : collection.length;
      }
      var tag = getTag(collection);
      if (tag == mapTag || tag == setTag) {
        return collection.size;
      }
      return baseKeys(collection).length;
    }

    /**
     * Checks if `predicate` returns truthy for **any** element of `collection`.
     * Iteration is stopped once `predicate` returns truthy. The predicate is
     * invoked with three arguments: (value, index|key, collection).
     *
     * @static
     * @memberOf _
     * @since 0.1.0
     * @category Collection
     * @param {Array|Object} collection The collection to iterate over.
     * @param {Function} [predicate=_.identity] The function invoked per iteration.
     * @param- {Object} [guard] Enables use as an iteratee for methods like `_.map`.
     * @returns {boolean} Returns `true` if any element passes the predicate check,
     *  else `false`.
     * @example
     *
     * _.some([null, 0, 'yes', false], Boolean);
     * // => true
     *
     * var users = [
     *   { 'user': 'barney', 'active': true },
     *   { 'user': 'fred',   'active': false }
     * ];
     *
     * // The `_.matches` iteratee shorthand.
     * _.some(users, { 'user': 'barney', 'active': false });
     * // => false
     *
     * // The `_.matchesProperty` iteratee shorthand.
     * _.some(users, ['active', false]);
     * // => true
     *
     * // The `_.property` iteratee shorthand.
     * _.some(users, 'active');
     * // => true
     */
    function some(collection, predicate, guard) {
      var func = isArray(collection) ? arraySome : baseSome;
      if (guard && isIterateeCall(collection, predicate, guard)) {
        predicate = undefined;
      }
      return func(collection, getIteratee(predicate, 3));
    }

    /**
     * Creates an array of elements, sorted in ascending order by the results of
     * running each element in a collection thru each iteratee. This method
     * performs a stable sort, that is, it preserves the original sort order of
     * equal elements. The iteratees are invoked with one argument: (value).
     *
     * @static
     * @memberOf _
     * @since 0.1.0
     * @category Collection
     * @param {Array|Object} collection The collection to iterate over.
     * @param {...(Function|Function[])} [iteratees=[_.identity]]
     *  The iteratees to sort by.
     * @returns {Array} Returns the new sorted array.
     * @example
     *
     * var users = [
     *   { 'user': 'fred',   'age': 48 },
     *   { 'user': 'barney', 'age': 36 },
     *   { 'user': 'fred',   'age': 40 },
     *   { 'user': 'barney', 'age': 34 }
     * ];
     *
     * _.sortBy(users, [function(o) { return o.user; }]);
     * // => objects for [['barney', 36], ['barney', 34], ['fred', 48], ['fred', 40]]
     *
     * _.sortBy(users, ['user', 'age']);
     * // => objects for [['barney', 34], ['barney', 36], ['fred', 40], ['fred', 48]]
     */
    var sortBy = baseRest(function(collection, iteratees) {
      if (collection == null) {
        return [];
      }
      var length = iteratees.length;
      if (length > 1 && isIterateeCall(collection, iteratees[0], iteratees[1])) {
        iteratees = [];
      } else if (length > 2 && isIterateeCall(iteratees[0], iteratees[1], iteratees[2])) {
        iteratees = [iteratees[0]];
      }
      return baseOrderBy(collection, baseFlatten(iteratees, 1), []);
    });

    /*------------------------------------------------------------------------*/

    /**
     * Gets the timestamp of the number of milliseconds that have elapsed since
     * the Unix epoch (1 January 1970 00:00:00 UTC).
     *
     * @static
     * @memberOf _
     * @since 2.4.0
     * @category Date
     * @returns {number} Returns the timestamp.
     * @example
     *
     * _.defer(function(stamp) {
     *   console.log(_.now() - stamp);
     * }, _.now());
     * // => Logs the number of milliseconds it took for the deferred invocation.
     */
    var now = ctxNow || function() {
      return root.Date.now();
    };

    /*------------------------------------------------------------------------*/

    /**
     * The opposite of `_.before`; this method creates a function that invokes
     * `func` once it's called `n` or more times.
     *
     * @static
     * @memberOf _
     * @since 0.1.0
     * @category Function
     * @param {number} n The number of calls before `func` is invoked.
     * @param {Function} func The function to restrict.
     * @returns {Function} Returns the new restricted function.
     * @example
     *
     * var saves = ['profile', 'settings'];
     *
     * var done = _.after(saves.length, function() {
     *   console.log('done saving!');
     * });
     *
     * _.forEach(saves, function(type) {
     *   asyncSave({ 'type': type, 'complete': done });
     * });
     * // => Logs 'done saving!' after the two async saves have completed.
     */
    function after(n, func) {
      if (typeof func != 'function') {
        throw new TypeError(FUNC_ERROR_TEXT);
      }
      n = toInteger(n);
      return function() {
        if (--n < 1) {
          return func.apply(this, arguments);
        }
      };
    }

    /**
     * Creates a function that invokes `func`, with up to `n` arguments,
     * ignoring any additional arguments.
     *
     * @static
     * @memberOf _
     * @since 3.0.0
     * @category Function
     * @param {Function} func The function to cap arguments for.
     * @param {number} [n=func.length] The arity cap.
     * @param- {Object} [guard] Enables use as an iteratee for methods like `_.map`.
     * @returns {Function} Returns the new capped function.
     * @example
     *
     * _.map(['6', '8', '10'], _.ary(parseInt, 1));
     * // => [6, 8, 10]
     */
    function ary(func, n, guard) {
      n = guard ? undefined : n;
      n = (func && n == null) ? func.length : n;
      return createWrap(func, WRAP_ARY_FLAG, undefined, undefined, undefined, undefined, n);
    }

    /**
     * Creates a function that invokes `func`, with the `this` binding and arguments
     * of the created function, while it's called less than `n` times. Subsequent
     * calls to the created function return the result of the last `func` invocation.
     *
     * @static
     * @memberOf _
     * @since 3.0.0
     * @category Function
     * @param {number} n The number of calls at which `func` is no longer invoked.
     * @param {Function} func The function to restrict.
     * @returns {Function} Returns the new restricted function.
     * @example
     *
     * jQuery(element).on('click', _.before(5, addContactToList));
     * // => Allows adding up to 4 contacts to the list.
     */
    function before(n, func) {
      var result;
      if (typeof func != 'function') {
        throw new TypeError(FUNC_ERROR_TEXT);
      }
      n = toInteger(n);
      return function() {
        if (--n > 0) {
          result = func.apply(this, arguments);
        }
        if (n <= 1) {
          func = undefined;
        }
        return result;
      };
    }

    /**
     * Creates a function that invokes `func` with the `this` binding of `thisArg`
     * and `partials` prepended to the arguments it receives.
     *
     * The `_.bind.placeholder` value, which defaults to `_` in monolithic builds,
     * may be used as a placeholder for partially applied arguments.
     *
     * **Note:** Unlike native `Function#bind`, this method doesn't set the "length"
     * property of bound functions.
     *
     * @static
     * @memberOf _
     * @since 0.1.0
     * @category Function
     * @param {Function} func The function to bind.
     * @param {*} thisArg The `this` binding of `func`.
     * @param {...*} [partials] The arguments to be partially applied.
     * @returns {Function} Returns the new bound function.
     * @example
     *
     * function greet(greeting, punctuation) {
     *   return greeting + ' ' + this.user + punctuation;
     * }
     *
     * var object = { 'user': 'fred' };
     *
     * var bound = _.bind(greet, object, 'hi');
     * bound('!');
     * // => 'hi fred!'
     *
     * // Bound with placeholders.
     * var bound = _.bind(greet, object, _, '!');
     * bound('hi');
     * // => 'hi fred!'
     */
    var bind = baseRest(function(func, thisArg, partials) {
      var bitmask = WRAP_BIND_FLAG;
      if (partials.length) {
        var holders = replaceHolders(partials, getHolder(bind));
        bitmask |= WRAP_PARTIAL_FLAG;
      }
      return createWrap(func, bitmask, thisArg, partials, holders);
    });

    /**
     * Creates a function that invokes the method at `object[key]` with `partials`
     * prepended to the arguments it receives.
     *
     * This method differs from `_.bind` by allowing bound functions to reference
     * methods that may be redefined or don't yet exist. See
     * [Peter Michaux's article](http://peter.michaux.ca/articles/lazy-function-definition-pattern)
     * for more details.
     *
     * The `_.bindKey.placeholder` value, which defaults to `_` in monolithic
     * builds, may be used as a placeholder for partially applied arguments.
     *
     * @static
     * @memberOf _
     * @since 0.10.0
     * @category Function
     * @param {Object} object The object to invoke the method on.
     * @param {string} key The key of the method.
     * @param {...*} [partials] The arguments to be partially applied.
     * @returns {Function} Returns the new bound function.
     * @example
     *
     * var object = {
     *   'user': 'fred',
     *   'greet': function(greeting, punctuation) {
     *     return greeting + ' ' + this.user + punctuation;
     *   }
     * };
     *
     * var bound = _.bindKey(object, 'greet', 'hi');
     * bound('!');
     * // => 'hi fred!'
     *
     * object.greet = function(greeting, punctuation) {
     *   return greeting + 'ya ' + this.user + punctuation;
     * };
     *
     * bound('!');
     * // => 'hiya fred!'
     *
     * // Bound with placeholders.
     * var bound = _.bindKey(object, 'greet', _, '!');
     * bound('hi');
     * // => 'hiya fred!'
     */
    var bindKey = baseRest(function(object, key, partials) {
      var bitmask = WRAP_BIND_FLAG | WRAP_BIND_KEY_FLAG;
      if (partials.length) {
        var holders = replaceHolders(partials, getHolder(bindKey));
        bitmask |= WRAP_PARTIAL_FLAG;
      }
      return createWrap(key, bitmask, object, partials, holders);
    });

    /**
     * Creates a function that accepts arguments of `func` and either invokes
     * `func` returning its result, if at least `arity` number of arguments have
     * been provided, or returns a function that accepts the remaining `func`
     * arguments, and so on. The arity of `func` may be specified if `func.length`
     * is not sufficient.
     *
     * The `_.curry.placeholder` value, which defaults to `_` in monolithic builds,
     * may be used as a placeholder for provided arguments.
     *
     * **Note:** This method doesn't set the "length" property of curried functions.
     *
     * @static
     * @memberOf _
     * @since 2.0.0
     * @category Function
     * @param {Function} func The function to curry.
     * @param {number} [arity=func.length] The arity of `func`.
     * @param- {Object} [guard] Enables use as an iteratee for methods like `_.map`.
     * @returns {Function} Returns the new curried function.
     * @example
     *
     * var abc = function(a, b, c) {
     *   return [a, b, c];
     * };
     *
     * var curried = _.curry(abc);
     *
     * curried(1)(2)(3);
     * // => [1, 2, 3]
     *
     * curried(1, 2)(3);
     * // => [1, 2, 3]
     *
     * curried(1, 2, 3);
     * // => [1, 2, 3]
     *
     * // Curried with placeholders.
     * curried(1)(_, 3)(2);
     * // => [1, 2, 3]
     */
    function curry(func, arity, guard) {
      arity = guard ? undefined : arity;
      var result = createWrap(func, WRAP_CURRY_FLAG, undefined, undefined, undefined, undefined, undefined, arity);
      result.placeholder = curry.placeholder;
      return result;
    }

    /**
     * This method is like `_.curry` except that arguments are applied to `func`
     * in the manner of `_.partialRight` instead of `_.partial`.
     *
     * The `_.curryRight.placeholder` value, which defaults to `_` in monolithic
     * builds, may be used as a placeholder for provided arguments.
     *
     * **Note:** This method doesn't set the "length" property of curried functions.
     *
     * @static
     * @memberOf _
     * @since 3.0.0
     * @category Function
     * @param {Function} func The function to curry.
     * @param {number} [arity=func.length] The arity of `func`.
     * @param- {Object} [guard] Enables use as an iteratee for methods like `_.map`.
     * @returns {Function} Returns the new curried function.
     * @example
     *
     * var abc = function(a, b, c) {
     *   return [a, b, c];
     * };
     *
     * var curried = _.curryRight(abc);
     *
     * curried(3)(2)(1);
     * // => [1, 2, 3]
     *
     * curried(2, 3)(1);
     * // => [1, 2, 3]
     *
     * curried(1, 2, 3);
     * // => [1, 2, 3]
     *
     * // Curried with placeholders.
     * curried(3)(1, _)(2);
     * // => [1, 2, 3]
     */
    function curryRight(func, arity, guard) {
      arity = guard ? undefined : arity;
      var result = createWrap(func, WRAP_CURRY_RIGHT_FLAG, undefined, undefined, undefined, undefined, undefined, arity);
      result.placeholder = curryRight.placeholder;
      return result;
    }

    /**
     * Creates a debounced function that delays invoking `func` until after `wait`
     * milliseconds have elapsed since the last time the debounced function was
     * invoked. The debounced function comes with a `cancel` method to cancel
     * delayed `func` invocations and a `flush` method to immediately invoke them.
     * Provide `options` to indicate whether `func` should be invoked on the
     * leading and/or trailing edge of the `wait` timeout. The `func` is invoked
     * with the last arguments provided to the debounced function. Subsequent
     * calls to the debounced function return the result of the last `func`
     * invocation.
     *
     * **Note:** If `leading` and `trailing` options are `true`, `func` is
     * invoked on the trailing edge of the timeout only if the debounced function
     * is invoked more than once during the `wait` timeout.
     *
     * If `wait` is `0` and `leading` is `false`, `func` invocation is deferred
     * until to the next tick, similar to `setTimeout` with a timeout of `0`.
     *
     * See [David Corbacho's article](https://css-tricks.com/debouncing-throttling-explained-examples/)
     * for details over the differences between `_.debounce` and `_.throttle`.
     *
     * @static
     * @memberOf _
     * @since 0.1.0
     * @category Function
     * @param {Function} func The function to debounce.
     * @param {number} [wait=0] The number of milliseconds to delay.
     * @param {Object} [options={}] The options object.
     * @param {boolean} [options.leading=false]
     *  Specify invoking on the leading edge of the timeout.
     * @param {number} [options.maxWait]
     *  The maximum time `func` is allowed to be delayed before it's invoked.
     * @param {boolean} [options.trailing=true]
     *  Specify invoking on the trailing edge of the timeout.
     * @returns {Function} Returns the new debounced function.
     * @example
     *
     * // Avoid costly calculations while the window size is in flux.
     * jQuery(window).on('resize', _.debounce(calculateLayout, 150));
     *
     * // Invoke `sendMail` when clicked, debouncing subsequent calls.
     * jQuery(element).on('click', _.debounce(sendMail, 300, {
     *   'leading': true,
     *   'trailing': false
     * }));
     *
     * // Ensure `batchLog` is invoked once after 1 second of debounced calls.
     * var debounced = _.debounce(batchLog, 250, { 'maxWait': 1000 });
     * var source = new EventSource('/stream');
     * jQuery(source).on('message', debounced);
     *
     * // Cancel the trailing debounced invocation.
     * jQuery(window).on('popstate', debounced.cancel);
     */
    function debounce(func, wait, options) {
      var lastArgs,
          lastThis,
          maxWait,
          result,
          timerId,
          lastCallTime,
          lastInvokeTime = 0,
          leading = false,
          maxing = false,
          trailing = true;

      if (typeof func != 'function') {
        throw new TypeError(FUNC_ERROR_TEXT);
      }
      wait = toNumber(wait) || 0;
      if (isObject(options)) {
        leading = !!options.leading;
        maxing = 'maxWait' in options;
        maxWait = maxing ? nativeMax(toNumber(options.maxWait) || 0, wait) : maxWait;
        trailing = 'trailing' in options ? !!options.trailing : trailing;
      }

      function invokeFunc(time) {
        var args = lastArgs,
            thisArg = lastThis;

        lastArgs = lastThis = undefined;
        lastInvokeTime = time;
        result = func.apply(thisArg, args);
        return result;
      }

      function leadingEdge(time) {
        // Reset any `maxWait` timer.
        lastInvokeTime = time;
        // Start the timer for the trailing edge.
        timerId = setTimeout(timerExpired, wait);
        // Invoke the leading edge.
        return leading ? invokeFunc(time) : result;
      }

      function remainingWait(time) {
        var timeSinceLastCall = time - lastCallTime,
            timeSinceLastInvoke = time - lastInvokeTime,
            timeWaiting = wait - timeSinceLastCall;

        return maxing
          ? nativeMin(timeWaiting, maxWait - timeSinceLastInvoke)
          : timeWaiting;
      }

      function shouldInvoke(time) {
        var timeSinceLastCall = time - lastCallTime,
            timeSinceLastInvoke = time - lastInvokeTime;

        // Either this is the first call, activity has stopped and we're at the
        // trailing edge, the system time has gone backwards and we're treating
        // it as the trailing edge, or we've hit the `maxWait` limit.
        return (lastCallTime === undefined || (timeSinceLastCall >= wait) ||
          (timeSinceLastCall < 0) || (maxing && timeSinceLastInvoke >= maxWait));
      }

      function timerExpired() {
        var time = now();
        if (shouldInvoke(time)) {
          return trailingEdge(time);
        }
        // Restart the timer.
        timerId = setTimeout(timerExpired, remainingWait(time));
      }

      function trailingEdge(time) {
        timerId = undefined;

        // Only invoke if we have `lastArgs` which means `func` has been
        // debounced at least once.
        if (trailing && lastArgs) {
          return invokeFunc(time);
        }
        lastArgs = lastThis = undefined;
        return result;
      }

      function cancel() {
        if (timerId !== undefined) {
          clearTimeout(timerId);
        }
        lastInvokeTime = 0;
        lastArgs = lastCallTime = lastThis = timerId = undefined;
      }

      function flush() {
        return timerId === undefined ? result : trailingEdge(now());
      }

      function debounced() {
        var time = now(),
            isInvoking = shouldInvoke(time);

        lastArgs = arguments;
        lastThis = this;
        lastCallTime = time;

        if (isInvoking) {
          if (timerId === undefined) {
            return leadingEdge(lastCallTime);
          }
          if (maxing) {
            // Handle invocations in a tight loop.
            clearTimeout(timerId);
            timerId = setTimeout(timerExpired, wait);
            return invokeFunc(lastCallTime);
          }
        }
        if (timerId === undefined) {
          timerId = setTimeout(timerExpired, wait);
        }
        return result;
      }
      debounced.cancel = cancel;
      debounced.flush = flush;
      return debounced;
    }

    /**
     * Defers invoking the `func` until the current call stack has cleared. Any
     * additional arguments are provided to `func` when it's invoked.
     *
     * @static
     * @memberOf _
     * @since 0.1.0
     * @category Function
     * @param {Function} func The function to defer.
     * @param {...*} [args] The arguments to invoke `func` with.
     * @returns {number} Returns the timer id.
     * @example
     *
     * _.defer(function(text) {
     *   console.log(text);
     * }, 'deferred');
     * // => Logs 'deferred' after one millisecond.
     */
    var defer = baseRest(function(func, args) {
      return baseDelay(func, 1, args);
    });

    /**
     * Invokes `func` after `wait` milliseconds. Any additional arguments are
     * provided to `func` when it's invoked.
     *
     * @static
     * @memberOf _
     * @since 0.1.0
     * @category Function
     * @param {Function} func The function to delay.
     * @param {number} wait The number of milliseconds to delay invocation.
     * @param {...*} [args] The arguments to invoke `func` with.
     * @returns {number} Returns the timer id.
     * @example
     *
     * _.delay(function(text) {
     *   console.log(text);
     * }, 1000, 'later');
     * // => Logs 'later' after one second.
     */
    var delay = baseRest(function(func, wait, args) {
      return baseDelay(func, toNumber(wait) || 0, args);
    });

    /**
     * Creates a function that invokes `func` with arguments reversed.
     *
     * @static
     * @memberOf _
     * @since 4.0.0
     * @category Function
     * @param {Function} func The function to flip arguments for.
     * @returns {Function} Returns the new flipped function.
     * @example
     *
     * var flipped = _.flip(function() {
     *   return _.toArray(arguments);
     * });
     *
     * flipped('a', 'b', 'c', 'd');
     * // => ['d', 'c', 'b', 'a']
     */
    function flip(func) {
      return createWrap(func, WRAP_FLIP_FLAG);
    }

    /**
     * Creates a function that memoizes the result of `func`. If `resolver` is
     * provided, it determines the cache key for storing the result based on the
     * arguments provided to the memoized function. By default, the first argument
     * provided to the memoized function is used as the map cache key. The `func`
     * is invoked with the `this` binding of the memoized function.
     *
     * **Note:** The cache is exposed as the `cache` property on the memoized
     * function. Its creation may be customized by replacing the `_.memoize.Cache`
     * constructor with one whose instances implement the
     * [`Map`](http://ecma-international.org/ecma-262/7.0/#sec-properties-of-the-map-prototype-object)
     * method interface of `clear`, `delete`, `get`, `has`, and `set`.
     *
     * @static
     * @memberOf _
     * @since 0.1.0
     * @category Function
     * @param {Function} func The function to have its output memoized.
     * @param {Function} [resolver] The function to resolve the cache key.
     * @returns {Function} Returns the new memoized function.
     * @example
     *
     * var object = { 'a': 1, 'b': 2 };
     * var other = { 'c': 3, 'd': 4 };
     *
     * var values = _.memoize(_.values);
     * values(object);
     * // => [1, 2]
     *
     * values(other);
     * // => [3, 4]
     *
     * object.a = 2;
     * values(object);
     * // => [1, 2]
     *
     * // Modify the result cache.
     * values.cache.set(object, ['a', 'b']);
     * values(object);
     * // => ['a', 'b']
     *
     * // Replace `_.memoize.Cache`.
     * _.memoize.Cache = WeakMap;
     */
    function memoize(func, resolver) {
      if (typeof func != 'function' || (resolver != null && typeof resolver != 'function')) {
        throw new TypeError(FUNC_ERROR_TEXT);
      }
      var memoized = function() {
        var args = arguments,
            key = resolver ? resolver.apply(this, args) : args[0],
            cache = memoized.cache;

        if (cache.has(key)) {
          return cache.get(key);
        }
        var result = func.apply(this, args);
        memoized.cache = cache.set(key, result) || cache;
        return result;
      };
      memoized.cache = new (memoize.Cache || MapCache);
      return memoized;
    }

    // Expose `MapCache`.
    memoize.Cache = MapCache;

    /**
     * Creates a function that negates the result of the predicate `func`. The
     * `func` predicate is invoked with the `this` binding and arguments of the
     * created function.
     *
     * @static
     * @memberOf _
     * @since 3.0.0
     * @category Function
     * @param {Function} predicate The predicate to negate.
     * @returns {Function} Returns the new negated function.
     * @example
     *
     * function isEven(n) {
     *   return n % 2 == 0;
     * }
     *
     * _.filter([1, 2, 3, 4, 5, 6], _.negate(isEven));
     * // => [1, 3, 5]
     */
    function negate(predicate) {
      if (typeof predicate != 'function') {
        throw new TypeError(FUNC_ERROR_TEXT);
      }
      return function() {
        var args = arguments;
        switch (args.length) {
          case 0: return !predicate.call(this);
          case 1: return !predicate.call(this, args[0]);
          case 2: return !predicate.call(this, args[0], args[1]);
          case 3: return !predicate.call(this, args[0], args[1], args[2]);
        }
        return !predicate.apply(this, args);
      };
    }

    /**
     * Creates a function that is restricted to invoking `func` once. Repeat calls
     * to the function return the value of the first invocation. The `func` is
     * invoked with the `this` binding and arguments of the created function.
     *
     * @static
     * @memberOf _
     * @since 0.1.0
     * @category Function
     * @param {Function} func The function to restrict.
     * @returns {Function} Returns the new restricted function.
     * @example
     *
     * var initialize = _.once(createApplication);
     * initialize();
     * initialize();
     * // => `createApplication` is invoked once
     */
    function once(func) {
      return before(2, func);
    }

    /**
     * Creates a function that invokes `func` with its arguments transformed.
     *
     * @static
     * @since 4.0.0
     * @memberOf _
     * @category Function
     * @param {Function} func The function to wrap.
     * @param {...(Function|Function[])} [transforms=[_.identity]]
     *  The argument transforms.
     * @returns {Function} Returns the new function.
     * @example
     *
     * function doubled(n) {
     *   return n * 2;
     * }
     *
     * function square(n) {
     *   return n * n;
     * }
     *
     * var func = _.overArgs(function(x, y) {
     *   return [x, y];
     * }, [square, doubled]);
     *
     * func(9, 3);
     * // => [81, 6]
     *
     * func(10, 5);
     * // => [100, 10]
     */
    var overArgs = castRest(function(func, transforms) {
      transforms = (transforms.length == 1 && isArray(transforms[0]))
        ? arrayMap(transforms[0], baseUnary(getIteratee()))
        : arrayMap(baseFlatten(transforms, 1), baseUnary(getIteratee()));

      var funcsLength = transforms.length;
      return baseRest(function(args) {
        var index = -1,
            length = nativeMin(args.length, funcsLength);

        while (++index < length) {
          args[index] = transforms[index].call(this, args[index]);
        }
        return apply(func, this, args);
      });
    });

    /**
     * Creates a function that invokes `func` with `partials` prepended to the
     * arguments it receives. This method is like `_.bind` except it does **not**
     * alter the `this` binding.
     *
     * The `_.partial.placeholder` value, which defaults to `_` in monolithic
     * builds, may be used as a placeholder for partially applied arguments.
     *
     * **Note:** This method doesn't set the "length" property of partially
     * applied functions.
     *
     * @static
     * @memberOf _
     * @since 0.2.0
     * @category Function
     * @param {Function} func The function to partially apply arguments to.
     * @param {...*} [partials] The arguments to be partially applied.
     * @returns {Function} Returns the new partially applied function.
     * @example
     *
     * function greet(greeting, name) {
     *   return greeting + ' ' + name;
     * }
     *
     * var sayHelloTo = _.partial(greet, 'hello');
     * sayHelloTo('fred');
     * // => 'hello fred'
     *
     * // Partially applied with placeholders.
     * var greetFred = _.partial(greet, _, 'fred');
     * greetFred('hi');
     * // => 'hi fred'
     */
    var partial = baseRest(function(func, partials) {
      var holders = replaceHolders(partials, getHolder(partial));
      return createWrap(func, WRAP_PARTIAL_FLAG, undefined, partials, holders);
    });

    /**
     * This method is like `_.partial` except that partially applied arguments
     * are appended to the arguments it receives.
     *
     * The `_.partialRight.placeholder` value, which defaults to `_` in monolithic
     * builds, may be used as a placeholder for partially applied arguments.
     *
     * **Note:** This method doesn't set the "length" property of partially
     * applied functions.
     *
     * @static
     * @memberOf _
     * @since 1.0.0
     * @category Function
     * @param {Function} func The function to partially apply arguments to.
     * @param {...*} [partials] The arguments to be partially applied.
     * @returns {Function} Returns the new partially applied function.
     * @example
     *
     * function greet(greeting, name) {
     *   return greeting + ' ' + name;
     * }
     *
     * var greetFred = _.partialRight(greet, 'fred');
     * greetFred('hi');
     * // => 'hi fred'
     *
     * // Partially applied with placeholders.
     * var sayHelloTo = _.partialRight(greet, 'hello', _);
     * sayHelloTo('fred');
     * // => 'hello fred'
     */
    var partialRight = baseRest(function(func, partials) {
      var holders = replaceHolders(partials, getHolder(partialRight));
      return createWrap(func, WRAP_PARTIAL_RIGHT_FLAG, undefined, partials, holders);
    });

    /**
     * Creates a function that invokes `func` with arguments arranged according
     * to the specified `indexes` where the argument value at the first index is
     * provided as the first argument, the argument value at the second index is
     * provided as the second argument, and so on.
     *
     * @static
     * @memberOf _
     * @since 3.0.0
     * @category Function
     * @param {Function} func The function to rearrange arguments for.
     * @param {...(number|number[])} indexes The arranged argument indexes.
     * @returns {Function} Returns the new function.
     * @example
     *
     * var rearged = _.rearg(function(a, b, c) {
     *   return [a, b, c];
     * }, [2, 0, 1]);
     *
     * rearged('b', 'c', 'a')
     * // => ['a', 'b', 'c']
     */
    var rearg = flatRest(function(func, indexes) {
      return createWrap(func, WRAP_REARG_FLAG, undefined, undefined, undefined, indexes);
    });

    /**
     * Creates a function that invokes `func` with the `this` binding of the
     * created function and arguments from `start` and beyond provided as
     * an array.
     *
     * **Note:** This method is based on the
     * [rest parameter](https://mdn.io/rest_parameters).
     *
     * @static
     * @memberOf _
     * @since 4.0.0
     * @category Function
     * @param {Function} func The function to apply a rest parameter to.
     * @param {number} [start=func.length-1] The start position of the rest parameter.
     * @returns {Function} Returns the new function.
     * @example
     *
     * var say = _.rest(function(what, names) {
     *   return what + ' ' + _.initial(names).join(', ') +
     *     (_.size(names) > 1 ? ', & ' : '') + _.last(names);
     * });
     *
     * say('hello', 'fred', 'barney', 'pebbles');
     * // => 'hello fred, barney, & pebbles'
     */
    function rest(func, start) {
      if (typeof func != 'function') {
        throw new TypeError(FUNC_ERROR_TEXT);
      }
      start = start === undefined ? start : toInteger(start);
      return baseRest(func, start);
    }

    /**
     * Creates a function that invokes `func` with the `this` binding of the
     * create function and an array of arguments much like
     * [`Function#apply`](http://www.ecma-international.org/ecma-262/7.0/#sec-function.prototype.apply).
     *
     * **Note:** This method is based on the
     * [spread operator](https://mdn.io/spread_operator).
     *
     * @static
     * @memberOf _
     * @since 3.2.0
     * @category Function
     * @param {Function} func The function to spread arguments over.
     * @param {number} [start=0] The start position of the spread.
     * @returns {Function} Returns the new function.
     * @example
     *
     * var say = _.spread(function(who, what) {
     *   return who + ' says ' + what;
     * });
     *
     * say(['fred', 'hello']);
     * // => 'fred says hello'
     *
     * var numbers = Promise.all([
     *   Promise.resolve(40),
     *   Promise.resolve(36)
     * ]);
     *
     * numbers.then(_.spread(function(x, y) {
     *   return x + y;
     * }));
     * // => a Promise of 76
     */
    function spread(func, start) {
      if (typeof func != 'function') {
        throw new TypeError(FUNC_ERROR_TEXT);
      }
      start = start == null ? 0 : nativeMax(toInteger(start), 0);
      return baseRest(function(args) {
        var array = args[start],
            otherArgs = castSlice(args, 0, start);

        if (array) {
          arrayPush(otherArgs, array);
        }
        return apply(func, this, otherArgs);
      });
    }

    /**
     * Creates a throttled function that only invokes `func` at most once per
     * every `wait` milliseconds. The throttled function comes with a `cancel`
     * method to cancel delayed `func` invocations and a `flush` method to
     * immediately invoke them. Provide `options` to indicate whether `func`
     * should be invoked on the leading and/or trailing edge of the `wait`
     * timeout. The `func` is invoked with the last arguments provided to the
     * throttled function. Subsequent calls to the throttled function return the
     * result of the last `func` invocation.
     *
     * **Note:** If `leading` and `trailing` options are `true`, `func` is
     * invoked on the trailing edge of the timeout only if the throttled function
     * is invoked more than once during the `wait` timeout.
     *
     * If `wait` is `0` and `leading` is `false`, `func` invocation is deferred
     * until to the next tick, similar to `setTimeout` with a timeout of `0`.
     *
     * See [David Corbacho's article](https://css-tricks.com/debouncing-throttling-explained-examples/)
     * for details over the differences between `_.throttle` and `_.debounce`.
     *
     * @static
     * @memberOf _
     * @since 0.1.0
     * @category Function
     * @param {Function} func The function to throttle.
     * @param {number} [wait=0] The number of milliseconds to throttle invocations to.
     * @param {Object} [options={}] The options object.
     * @param {boolean} [options.leading=true]
     *  Specify invoking on the leading edge of the timeout.
     * @param {boolean} [options.trailing=true]
     *  Specify invoking on the trailing edge of the timeout.
     * @returns {Function} Returns the new throttled function.
     * @example
     *
     * // Avoid excessively updating the position while scrolling.
     * jQuery(window).on('scroll', _.throttle(updatePosition, 100));
     *
     * // Invoke `renewToken` when the click event is fired, but not more than once every 5 minutes.
     * var throttled = _.throttle(renewToken, 300000, { 'trailing': false });
     * jQuery(element).on('click', throttled);
     *
     * // Cancel the trailing throttled invocation.
     * jQuery(window).on('popstate', throttled.cancel);
     */
    function throttle(func, wait, options) {
      var leading = true,
          trailing = true;

      if (typeof func != 'function') {
        throw new TypeError(FUNC_ERROR_TEXT);
      }
      if (isObject(options)) {
        leading = 'leading' in options ? !!options.leading : leading;
        trailing = 'trailing' in options ? !!options.trailing : trailing;
      }
      return debounce(func, wait, {
        'leading': leading,
        'maxWait': wait,
        'trailing': trailing
      });
    }

    /**
     * Creates a function that accepts up to one argument, ignoring any
     * additional arguments.
     *
     * @static
     * @memberOf _
     * @since 4.0.0
     * @category Function
     * @param {Function} func The function to cap arguments for.
     * @returns {Function} Returns the new capped function.
     * @example
     *
     * _.map(['6', '8', '10'], _.unary(parseInt));
     * // => [6, 8, 10]
     */
    function unary(func) {
      return ary(func, 1);
    }

    /**
     * Creates a function that provides `value` to `wrapper` as its first
     * argument. Any additional arguments provided to the function are appended
     * to those provided to the `wrapper`. The wrapper is invoked with the `this`
     * binding of the created function.
     *
     * @static
     * @memberOf _
     * @since 0.1.0
     * @category Function
     * @param {*} value The value to wrap.
     * @param {Function} [wrapper=identity] The wrapper function.
     * @returns {Function} Returns the new function.
     * @example
     *
     * var p = _.wrap(_.escape, function(func, text) {
     *   return '<p>' + func(text) + '</p>';
     * });
     *
     * p('fred, barney, & pebbles');
     * // => '<p>fred, barney, &amp; pebbles</p>'
     */
    function wrap(value, wrapper) {
      return partial(castFunction(wrapper), value);
    }

    /*------------------------------------------------------------------------*/

    /**
     * Casts `value` as an array if it's not one.
     *
     * @static
     * @memberOf _
     * @since 4.4.0
     * @category Lang
     * @param {*} value The value to inspect.
     * @returns {Array} Returns the cast array.
     * @example
     *
     * _.castArray(1);
     * // => [1]
     *
     * _.castArray({ 'a': 1 });
     * // => [{ 'a': 1 }]
     *
     * _.castArray('abc');
     * // => ['abc']
     *
     * _.castArray(null);
     * // => [null]
     *
     * _.castArray(undefined);
     * // => [undefined]
     *
     * _.castArray();
     * // => []
     *
     * var array = [1, 2, 3];
     * console.log(_.castArray(array) === array);
     * // => true
     */
    function castArray() {
      if (!arguments.length) {
        return [];
      }
      var value = arguments[0];
      return isArray(value) ? value : [value];
    }

    /**
     * Creates a shallow clone of `value`.
     *
     * **Note:** This method is loosely based on the
     * [structured clone algorithm](https://mdn.io/Structured_clone_algorithm)
     * and supports cloning arrays, array buffers, booleans, date objects, maps,
     * numbers, `Object` objects, regexes, sets, strings, symbols, and typed
     * arrays. The own enumerable properties of `arguments` objects are cloned
     * as plain objects. An empty object is returned for uncloneable values such
     * as error objects, functions, DOM nodes, and WeakMaps.
     *
     * @static
     * @memberOf _
     * @since 0.1.0
     * @category Lang
     * @param {*} value The value to clone.
     * @returns {*} Returns the cloned value.
     * @see _.cloneDeep
     * @example
     *
     * var objects = [{ 'a': 1 }, { 'b': 2 }];
     *
     * var shallow = _.clone(objects);
     * console.log(shallow[0] === objects[0]);
     * // => true
     */
    function clone(value) {
      return baseClone(value, CLONE_SYMBOLS_FLAG);
    }

    /**
     * This method is like `_.clone` except that it accepts `customizer` which
     * is invoked to produce the cloned value. If `customizer` returns `undefined`,
     * cloning is handled by the method instead. The `customizer` is invoked with
     * up to four arguments; (value [, index|key, object, stack]).
     *
     * @static
     * @memberOf _
     * @since 4.0.0
     * @category Lang
     * @param {*} value The value to clone.
     * @param {Function} [customizer] The function to customize cloning.
     * @returns {*} Returns the cloned value.
     * @see _.cloneDeepWith
     * @example
     *
     * function customizer(value) {
     *   if (_.isElement(value)) {
     *     return value.cloneNode(false);
     *   }
     * }
     *
     * var el = _.cloneWith(document.body, customizer);
     *
     * console.log(el === document.body);
     * // => false
     * console.log(el.nodeName);
     * // => 'BODY'
     * console.log(el.childNodes.length);
     * // => 0
     */
    function cloneWith(value, customizer) {
      customizer = typeof customizer == 'function' ? customizer : undefined;
      return baseClone(value, CLONE_SYMBOLS_FLAG, customizer);
    }

    /**
     * This method is like `_.clone` except that it recursively clones `value`.
     *
     * @static
     * @memberOf _
     * @since 1.0.0
     * @category Lang
     * @param {*} value The value to recursively clone.
     * @returns {*} Returns the deep cloned value.
     * @see _.clone
     * @example
     *
     * var objects = [{ 'a': 1 }, { 'b': 2 }];
     *
     * var deep = _.cloneDeep(objects);
     * console.log(deep[0] === objects[0]);
     * // => false
     */
    function cloneDeep(value) {
      return baseClone(value, CLONE_DEEP_FLAG | CLONE_SYMBOLS_FLAG);
    }

    /**
     * This method is like `_.cloneWith` except that it recursively clones `value`.
     *
     * @static
     * @memberOf _
     * @since 4.0.0
     * @category Lang
     * @param {*} value The value to recursively clone.
     * @param {Function} [customizer] The function to customize cloning.
     * @returns {*} Returns the deep cloned value.
     * @see _.cloneWith
     * @example
     *
     * function customizer(value) {
     *   if (_.isElement(value)) {
     *     return value.cloneNode(true);
     *   }
     * }
     *
     * var el = _.cloneDeepWith(document.body, customizer);
     *
     * console.log(el === document.body);
     * // => false
     * console.log(el.nodeName);
     * // => 'BODY'
     * console.log(el.childNodes.length);
     * // => 20
     */
    function cloneDeepWith(value, customizer) {
      customizer = typeof customizer == 'function' ? customizer : undefined;
      return baseClone(value, CLONE_DEEP_FLAG | CLONE_SYMBOLS_FLAG, customizer);
    }

    /**
     * Checks if `object` conforms to `source` by invoking the predicate
     * properties of `source` with the corresponding property values of `object`.
     *
     * **Note:** This method is equivalent to `_.conforms` when `source` is
     * partially applied.
     *
     * @static
     * @memberOf _
     * @since 4.14.0
     * @category Lang
     * @param {Object} object The object to inspect.
     * @param {Object} source The object of property predicates to conform to.
     * @returns {boolean} Returns `true` if `object` conforms, else `false`.
     * @example
     *
     * var object = { 'a': 1, 'b': 2 };
     *
     * _.conformsTo(object, { 'b': function(n) { return n > 1; } });
     * // => true
     *
     * _.conformsTo(object, { 'b': function(n) { return n > 2; } });
     * // => false
     */
    function conformsTo(object, source) {
      return source == null || baseConformsTo(object, source, keys(source));
    }

    /**
     * Performs a
     * [`SameValueZero`](http://ecma-international.org/ecma-262/7.0/#sec-samevaluezero)
     * comparison between two values to determine if they are equivalent.
     *
     * @static
     * @memberOf _
     * @since 4.0.0
     * @category Lang
     * @param {*} value The value to compare.
     * @param {*} other The other value to compare.
     * @returns {boolean} Returns `true` if the values are equivalent, else `false`.
     * @example
     *
     * var object = { 'a': 1 };
     * var other = { 'a': 1 };
     *
     * _.eq(object, object);
     * // => true
     *
     * _.eq(object, other);
     * // => false
     *
     * _.eq('a', 'a');
     * // => true
     *
     * _.eq('a', Object('a'));
     * // => false
     *
     * _.eq(NaN, NaN);
     * // => true
     */
    function eq(value, other) {
      return value === other || (value !== value && other !== other);
    }

    /**
     * Checks if `value` is greater than `other`.
     *
     * @static
     * @memberOf _
     * @since 3.9.0
     * @category Lang
     * @param {*} value The value to compare.
     * @param {*} other The other value to compare.
     * @returns {boolean} Returns `true` if `value` is greater than `other`,
     *  else `false`.
     * @see _.lt
     * @example
     *
     * _.gt(3, 1);
     * // => true
     *
     * _.gt(3, 3);
     * // => false
     *
     * _.gt(1, 3);
     * // => false
     */
    var gt = createRelationalOperation(baseGt);

    /**
     * Checks if `value` is greater than or equal to `other`.
     *
     * @static
     * @memberOf _
     * @since 3.9.0
     * @category Lang
     * @param {*} value The value to compare.
     * @param {*} other The other value to compare.
     * @returns {boolean} Returns `true` if `value` is greater than or equal to
     *  `other`, else `false`.
     * @see _.lte
     * @example
     *
     * _.gte(3, 1);
     * // => true
     *
     * _.gte(3, 3);
     * // => true
     *
     * _.gte(1, 3);
     * // => false
     */
    var gte = createRelationalOperation(function(value, other) {
      return value >= other;
    });

    /**
     * Checks if `value` is likely an `arguments` object.
     *
     * @static
     * @memberOf _
     * @since 0.1.0
     * @category Lang
     * @param {*} value The value to check.
     * @returns {boolean} Returns `true` if `value` is an `arguments` object,
     *  else `false`.
     * @example
     *
     * _.isArguments(function() { return arguments; }());
     * // => true
     *
     * _.isArguments([1, 2, 3]);
     * // => false
     */
    var isArguments = baseIsArguments(function() { return arguments; }()) ? baseIsArguments : function(value) {
      return isObjectLike(value) && hasOwnProperty.call(value, 'callee') &&
        !propertyIsEnumerable.call(value, 'callee');
    };

    /**
     * Checks if `value` is classified as an `Array` object.
     *
     * @static
     * @memberOf _
     * @since 0.1.0
     * @category Lang
     * @param {*} value The value to check.
     * @returns {boolean} Returns `true` if `value` is an array, else `false`.
     * @example
     *
     * _.isArray([1, 2, 3]);
     * // => true
     *
     * _.isArray(document.body.children);
     * // => false
     *
     * _.isArray('abc');
     * // => false
     *
     * _.isArray(_.noop);
     * // => false
     */
    var isArray = Array.isArray;

    /**
     * Checks if `value` is classified as an `ArrayBuffer` object.
     *
     * @static
     * @memberOf _
     * @since 4.3.0
     * @category Lang
     * @param {*} value The value to check.
     * @returns {boolean} Returns `true` if `value` is an array buffer, else `false`.
     * @example
     *
     * _.isArrayBuffer(new ArrayBuffer(2));
     * // => true
     *
     * _.isArrayBuffer(new Array(2));
     * // => false
     */
    var isArrayBuffer = nodeIsArrayBuffer ? baseUnary(nodeIsArrayBuffer) : baseIsArrayBuffer;

    /**
     * Checks if `value` is array-like. A value is considered array-like if it's
     * not a function and has a `value.length` that's an integer greater than or
     * equal to `0` and less than or equal to `Number.MAX_SAFE_INTEGER`.
     *
     * @static
     * @memberOf _
     * @since 4.0.0
     * @category Lang
     * @param {*} value The value to check.
     * @returns {boolean} Returns `true` if `value` is array-like, else `false`.
     * @example
     *
     * _.isArrayLike([1, 2, 3]);
     * // => true
     *
     * _.isArrayLike(document.body.children);
     * // => true
     *
     * _.isArrayLike('abc');
     * // => true
     *
     * _.isArrayLike(_.noop);
     * // => false
     */
    function isArrayLike(value) {
      return value != null && isLength(value.length) && !isFunction(value);
    }

    /**
     * This method is like `_.isArrayLike` except that it also checks if `value`
     * is an object.
     *
     * @static
     * @memberOf _
     * @since 4.0.0
     * @category Lang
     * @param {*} value The value to check.
     * @returns {boolean} Returns `true` if `value` is an array-like object,
     *  else `false`.
     * @example
     *
     * _.isArrayLikeObject([1, 2, 3]);
     * // => true
     *
     * _.isArrayLikeObject(document.body.children);
     * // => true
     *
     * _.isArrayLikeObject('abc');
     * // => false
     *
     * _.isArrayLikeObject(_.noop);
     * // => false
     */
    function isArrayLikeObject(value) {
      return isObjectLike(value) && isArrayLike(value);
    }

    /**
     * Checks if `value` is classified as a boolean primitive or object.
     *
     * @static
     * @memberOf _
     * @since 0.1.0
     * @category Lang
     * @param {*} value The value to check.
     * @returns {boolean} Returns `true` if `value` is a boolean, else `false`.
     * @example
     *
     * _.isBoolean(false);
     * // => true
     *
     * _.isBoolean(null);
     * // => false
     */
    function isBoolean(value) {
      return value === true || value === false ||
        (isObjectLike(value) && baseGetTag(value) == boolTag);
    }

    /**
     * Checks if `value` is a buffer.
     *
     * @static
     * @memberOf _
     * @since 4.3.0
     * @category Lang
     * @param {*} value The value to check.
     * @returns {boolean} Returns `true` if `value` is a buffer, else `false`.
     * @example
     *
     * _.isBuffer(new Buffer(2));
     * // => true
     *
     * _.isBuffer(new Uint8Array(2));
     * // => false
     */
    var isBuffer = nativeIsBuffer || stubFalse;

    /**
     * Checks if `value` is classified as a `Date` object.
     *
     * @static
     * @memberOf _
     * @since 0.1.0
     * @category Lang
     * @param {*} value The value to check.
     * @returns {boolean} Returns `true` if `value` is a date object, else `false`.
     * @example
     *
     * _.isDate(new Date);
     * // => true
     *
     * _.isDate('Mon April 23 2012');
     * // => false
     */
    var isDate = nodeIsDate ? baseUnary(nodeIsDate) : baseIsDate;

    /**
     * Checks if `value` is likely a DOM element.
     *
     * @static
     * @memberOf _
     * @since 0.1.0
     * @category Lang
     * @param {*} value The value to check.
     * @returns {boolean} Returns `true` if `value` is a DOM element, else `false`.
     * @example
     *
     * _.isElement(document.body);
     * // => true
     *
     * _.isElement('<body>');
     * // => false
     */
    function isElement(value) {
      return isObjectLike(value) && value.nodeType === 1 && !isPlainObject(value);
    }

    /**
     * Checks if `value` is an empty object, collection, map, or set.
     *
     * Objects are considered empty if they have no own enumerable string keyed
     * properties.
     *
     * Array-like values such as `arguments` objects, arrays, buffers, strings, or
     * jQuery-like collections are considered empty if they have a `length` of `0`.
     * Similarly, maps and sets are considered empty if they have a `size` of `0`.
     *
     * @static
     * @memberOf _
     * @since 0.1.0
     * @category Lang
     * @param {*} value The value to check.
     * @returns {boolean} Returns `true` if `value` is empty, else `false`.
     * @example
     *
     * _.isEmpty(null);
     * // => true
     *
     * _.isEmpty(true);
     * // => true
     *
     * _.isEmpty(1);
     * // => true
     *
     * _.isEmpty([1, 2, 3]);
     * // => false
     *
     * _.isEmpty({ 'a': 1 });
     * // => false
     */
    function isEmpty(value) {
      if (value == null) {
        return true;
      }
      if (isArrayLike(value) &&
          (isArray(value) || typeof value == 'string' || typeof value.splice == 'function' ||
            isBuffer(value) || isTypedArray(value) || isArguments(value))) {
        return !value.length;
      }
      var tag = getTag(value);
      if (tag == mapTag || tag == setTag) {
        return !value.size;
      }
      if (isPrototype(value)) {
        return !baseKeys(value).length;
      }
      for (var key in value) {
        if (hasOwnProperty.call(value, key)) {
          return false;
        }
      }
      return true;
    }

    /**
     * Performs a deep comparison between two values to determine if they are
     * equivalent.
     *
     * **Note:** This method supports comparing arrays, array buffers, booleans,
     * date objects, error objects, maps, numbers, `Object` objects, regexes,
     * sets, strings, symbols, and typed arrays. `Object` objects are compared
     * by their own, not inherited, enumerable properties. Functions and DOM
     * nodes are compared by strict equality, i.e. `===`.
     *
     * @static
     * @memberOf _
     * @since 0.1.0
     * @category Lang
     * @param {*} value The value to compare.
     * @param {*} other The other value to compare.
     * @returns {boolean} Returns `true` if the values are equivalent, else `false`.
     * @example
     *
     * var object = { 'a': 1 };
     * var other = { 'a': 1 };
     *
     * _.isEqual(object, other);
     * // => true
     *
     * object === other;
     * // => false
     */
    function isEqual(value, other) {
      return baseIsEqual(value, other);
    }

    /**
     * This method is like `_.isEqual` except that it accepts `customizer` which
     * is invoked to compare values. If `customizer` returns `undefined`, comparisons
     * are handled by the method instead. The `customizer` is invoked with up to
     * six arguments: (objValue, othValue [, index|key, object, other, stack]).
     *
     * @static
     * @memberOf _
     * @since 4.0.0
     * @category Lang
     * @param {*} value The value to compare.
     * @param {*} other The other value to compare.
     * @param {Function} [customizer] The function to customize comparisons.
     * @returns {boolean} Returns `true` if the values are equivalent, else `false`.
     * @example
     *
     * function isGreeting(value) {
     *   return /^h(?:i|ello)$/.test(value);
     * }
     *
     * function customizer(objValue, othValue) {
     *   if (isGreeting(objValue) && isGreeting(othValue)) {
     *     return true;
     *   }
     * }
     *
     * var array = ['hello', 'goodbye'];
     * var other = ['hi', 'goodbye'];
     *
     * _.isEqualWith(array, other, customizer);
     * // => true
     */
    function isEqualWith(value, other, customizer) {
      customizer = typeof customizer == 'function' ? customizer : undefined;
      var result = customizer ? customizer(value, other) : undefined;
      return result === undefined ? baseIsEqual(value, other, undefined, customizer) : !!result;
    }

    /**
     * Checks if `value` is an `Error`, `EvalError`, `RangeError`, `ReferenceError`,
     * `SyntaxError`, `TypeError`, or `URIError` object.
     *
     * @static
     * @memberOf _
     * @since 3.0.0
     * @category Lang
     * @param {*} value The value to check.
     * @returns {boolean} Returns `true` if `value` is an error object, else `false`.
     * @example
     *
     * _.isError(new Error);
     * // => true
     *
     * _.isError(Error);
     * // => false
     */
    function isError(value) {
      if (!isObjectLike(value)) {
        return false;
      }
      var tag = baseGetTag(value);
      return tag == errorTag || tag == domExcTag ||
        (typeof value.message == 'string' && typeof value.name == 'string' && !isPlainObject(value));
    }

    /**
     * Checks if `value` is a finite primitive number.
     *
     * **Note:** This method is based on
     * [`Number.isFinite`](https://mdn.io/Number/isFinite).
     *
     * @static
     * @memberOf _
     * @since 0.1.0
     * @category Lang
     * @param {*} value The value to check.
     * @returns {boolean} Returns `true` if `value` is a finite number, else `false`.
     * @example
     *
     * _.isFinite(3);
     * // => true
     *
     * _.isFinite(Number.MIN_VALUE);
     * // => true
     *
     * _.isFinite(Infinity);
     * // => false
     *
     * _.isFinite('3');
     * // => false
     */
    function isFinite(value) {
      return typeof value == 'number' && nativeIsFinite(value);
    }

    /**
     * Checks if `value` is classified as a `Function` object.
     *
     * @static
     * @memberOf _
     * @since 0.1.0
     * @category Lang
     * @param {*} value The value to check.
     * @returns {boolean} Returns `true` if `value` is a function, else `false`.
     * @example
     *
     * _.isFunction(_);
     * // => true
     *
     * _.isFunction(/abc/);
     * // => false
     */
    function isFunction(value) {
      if (!isObject(value)) {
        return false;
      }
      // The use of `Object#toString` avoids issues with the `typeof` operator
      // in Safari 9 which returns 'object' for typed arrays and other constructors.
      var tag = baseGetTag(value);
      return tag == funcTag || tag == genTag || tag == asyncTag || tag == proxyTag;
    }

    /**
     * Checks if `value` is an integer.
     *
     * **Note:** This method is based on
     * [`Number.isInteger`](https://mdn.io/Number/isInteger).
     *
     * @static
     * @memberOf _
     * @since 4.0.0
     * @category Lang
     * @param {*} value The value to check.
     * @returns {boolean} Returns `true` if `value` is an integer, else `false`.
     * @example
     *
     * _.isInteger(3);
     * // => true
     *
     * _.isInteger(Number.MIN_VALUE);
     * // => false
     *
     * _.isInteger(Infinity);
     * // => false
     *
     * _.isInteger('3');
     * // => false
     */
    function isInteger(value) {
      return typeof value == 'number' && value == toInteger(value);
    }

    /**
     * Checks if `value` is a valid array-like length.
     *
     * **Note:** This method is loosely based on
     * [`ToLength`](http://ecma-international.org/ecma-262/7.0/#sec-tolength).
     *
     * @static
     * @memberOf _
     * @since 4.0.0
     * @category Lang
     * @param {*} value The value to check.
     * @returns {boolean} Returns `true` if `value` is a valid length, else `false`.
     * @example
     *
     * _.isLength(3);
     * // => true
     *
     * _.isLength(Number.MIN_VALUE);
     * // => false
     *
     * _.isLength(Infinity);
     * // => false
     *
     * _.isLength('3');
     * // => false
     */
    function isLength(value) {
      return typeof value == 'number' &&
        value > -1 && value % 1 == 0 && value <= MAX_SAFE_INTEGER;
    }

    /**
     * Checks if `value` is the
     * [language type](http://www.ecma-international.org/ecma-262/7.0/#sec-ecmascript-language-types)
     * of `Object`. (e.g. arrays, functions, objects, regexes, `new Number(0)`, and `new String('')`)
     *
     * @static
     * @memberOf _
     * @since 0.1.0
     * @category Lang
     * @param {*} value The value to check.
     * @returns {boolean} Returns `true` if `value` is an object, else `false`.
     * @example
     *
     * _.isObject({});
     * // => true
     *
     * _.isObject([1, 2, 3]);
     * // => true
     *
     * _.isObject(_.noop);
     * // => true
     *
     * _.isObject(null);
     * // => false
     */
    function isObject(value) {
      var type = typeof value;
      return value != null && (type == 'object' || type == 'function');
    }

    /**
     * Checks if `value` is object-like. A value is object-like if it's not `null`
     * and has a `typeof` result of "object".
     *
     * @static
     * @memberOf _
     * @since 4.0.0
     * @category Lang
     * @param {*} value The value to check.
     * @returns {boolean} Returns `true` if `value` is object-like, else `false`.
     * @example
     *
     * _.isObjectLike({});
     * // => true
     *
     * _.isObjectLike([1, 2, 3]);
     * // => true
     *
     * _.isObjectLike(_.noop);
     * // => false
     *
     * _.isObjectLike(null);
     * // => false
     */
    function isObjectLike(value) {
      return value != null && typeof value == 'object';
    }

    /**
     * Checks if `value` is classified as a `Map` object.
     *
     * @static
     * @memberOf _
     * @since 4.3.0
     * @category Lang
     * @param {*} value The value to check.
     * @returns {boolean} Returns `true` if `value` is a map, else `false`.
     * @example
     *
     * _.isMap(new Map);
     * // => true
     *
     * _.isMap(new WeakMap);
     * // => false
     */
    var isMap = nodeIsMap ? baseUnary(nodeIsMap) : baseIsMap;

    /**
     * Performs a partial deep comparison between `object` and `source` to
     * determine if `object` contains equivalent property values.
     *
     * **Note:** This method is equivalent to `_.matches` when `source` is
     * partially applied.
     *
     * Partial comparisons will match empty array and empty object `source`
     * values against any array or object value, respectively. See `_.isEqual`
     * for a list of supported value comparisons.
     *
     * @static
     * @memberOf _
     * @since 3.0.0
     * @category Lang
     * @param {Object} object The object to inspect.
     * @param {Object} source The object of property values to match.
     * @returns {boolean} Returns `true` if `object` is a match, else `false`.
     * @example
     *
     * var object = { 'a': 1, 'b': 2 };
     *
     * _.isMatch(object, { 'b': 2 });
     * // => true
     *
     * _.isMatch(object, { 'b': 1 });
     * // => false
     */
    function isMatch(object, source) {
      return object === source || baseIsMatch(object, source, getMatchData(source));
    }

    /**
     * This method is like `_.isMatch` except that it accepts `customizer` which
     * is invoked to compare values. If `customizer` returns `undefined`, comparisons
     * are handled by the method instead. The `customizer` is invoked with five
     * arguments: (objValue, srcValue, index|key, object, source).
     *
     * @static
     * @memberOf _
     * @since 4.0.0
     * @category Lang
     * @param {Object} object The object to inspect.
     * @param {Object} source The object of property values to match.
     * @param {Function} [customizer] The function to customize comparisons.
     * @returns {boolean} Returns `true` if `object` is a match, else `false`.
     * @example
     *
     * function isGreeting(value) {
     *   return /^h(?:i|ello)$/.test(value);
     * }
     *
     * function customizer(objValue, srcValue) {
     *   if (isGreeting(objValue) && isGreeting(srcValue)) {
     *     return true;
     *   }
     * }
     *
     * var object = { 'greeting': 'hello' };
     * var source = { 'greeting': 'hi' };
     *
     * _.isMatchWith(object, source, customizer);
     * // => true
     */
    function isMatchWith(object, source, customizer) {
      customizer = typeof customizer == 'function' ? customizer : undefined;
      return baseIsMatch(object, source, getMatchData(source), customizer);
    }

    /**
     * Checks if `value` is `NaN`.
     *
     * **Note:** This method is based on
     * [`Number.isNaN`](https://mdn.io/Number/isNaN) and is not the same as
     * global [`isNaN`](https://mdn.io/isNaN) which returns `true` for
     * `undefined` and other non-number values.
     *
     * @static
     * @memberOf _
     * @since 0.1.0
     * @category Lang
     * @param {*} value The value to check.
     * @returns {boolean} Returns `true` if `value` is `NaN`, else `false`.
     * @example
     *
     * _.isNaN(NaN);
     * // => true
     *
     * _.isNaN(new Number(NaN));
     * // => true
     *
     * isNaN(undefined);
     * // => true
     *
     * _.isNaN(undefined);
     * // => false
     */
    function isNaN(value) {
      // An `NaN` primitive is the only value that is not equal to itself.
      // Perform the `toStringTag` check first to avoid errors with some
      // ActiveX objects in IE.
      return isNumber(value) && value != +value;
    }

    /**
     * Checks if `value` is a pristine native function.
     *
     * **Note:** This method can't reliably detect native functions in the presence
     * of the core-js package because core-js circumvents this kind of detection.
     * Despite multiple requests, the core-js maintainer has made it clear: any
     * attempt to fix the detection will be obstructed. As a result, we're left
     * with little choice but to throw an error. Unfortunately, this also affects
     * packages, like [babel-polyfill](https://www.npmjs.com/package/babel-polyfill),
     * which rely on core-js.
     *
     * @static
     * @memberOf _
     * @since 3.0.0
     * @category Lang
     * @param {*} value The value to check.
     * @returns {boolean} Returns `true` if `value` is a native function,
     *  else `false`.
     * @example
     *
     * _.isNative(Array.prototype.push);
     * // => true
     *
     * _.isNative(_);
     * // => false
     */
    function isNative(value) {
      if (isMaskable(value)) {
        throw new Error(CORE_ERROR_TEXT);
      }
      return baseIsNative(value);
    }

    /**
     * Checks if `value` is `null`.
     *
     * @static
     * @memberOf _
     * @since 0.1.0
     * @category Lang
     * @param {*} value The value to check.
     * @returns {boolean} Returns `true` if `value` is `null`, else `false`.
     * @example
     *
     * _.isNull(null);
     * // => true
     *
     * _.isNull(void 0);
     * // => false
     */
    function isNull(value) {
      return value === null;
    }

    /**
     * Checks if `value` is `null` or `undefined`.
     *
     * @static
     * @memberOf _
     * @since 4.0.0
     * @category Lang
     * @param {*} value The value to check.
     * @returns {boolean} Returns `true` if `value` is nullish, else `false`.
     * @example
     *
     * _.isNil(null);
     * // => true
     *
     * _.isNil(void 0);
     * // => true
     *
     * _.isNil(NaN);
     * // => false
     */
    function isNil(value) {
      return value == null;
    }

    /**
     * Checks if `value` is classified as a `Number` primitive or object.
     *
     * **Note:** To exclude `Infinity`, `-Infinity`, and `NaN`, which are
     * classified as numbers, use the `_.isFinite` method.
     *
     * @static
     * @memberOf _
     * @since 0.1.0
     * @category Lang
     * @param {*} value The value to check.
     * @returns {boolean} Returns `true` if `value` is a number, else `false`.
     * @example
     *
     * _.isNumber(3);
     * // => true
     *
     * _.isNumber(Number.MIN_VALUE);
     * // => true
     *
     * _.isNumber(Infinity);
     * // => true
     *
     * _.isNumber('3');
     * // => false
     */
    function isNumber(value) {
      return typeof value == 'number' ||
        (isObjectLike(value) && baseGetTag(value) == numberTag);
    }

    /**
     * Checks if `value` is a plain object, that is, an object created by the
     * `Object` constructor or one with a `[[Prototype]]` of `null`.
     *
     * @static
     * @memberOf _
     * @since 0.8.0
     * @category Lang
     * @param {*} value The value to check.
     * @returns {boolean} Returns `true` if `value` is a plain object, else `false`.
     * @example
     *
     * function Foo() {
     *   this.a = 1;
     * }
     *
     * _.isPlainObject(new Foo);
     * // => false
     *
     * _.isPlainObject([1, 2, 3]);
     * // => false
     *
     * _.isPlainObject({ 'x': 0, 'y': 0 });
     * // => true
     *
     * _.isPlainObject(Object.create(null));
     * // => true
     */
    function isPlainObject(value) {
      if (!isObjectLike(value) || baseGetTag(value) != objectTag) {
        return false;
      }
      var proto = getPrototype(value);
      if (proto === null) {
        return true;
      }
      var Ctor = hasOwnProperty.call(proto, 'constructor') && proto.constructor;
      return typeof Ctor == 'function' && Ctor instanceof Ctor &&
        funcToString.call(Ctor) == objectCtorString;
    }

    /**
     * Checks if `value` is classified as a `RegExp` object.
     *
     * @static
     * @memberOf _
     * @since 0.1.0
     * @category Lang
     * @param {*} value The value to check.
     * @returns {boolean} Returns `true` if `value` is a regexp, else `false`.
     * @example
     *
     * _.isRegExp(/abc/);
     * // => true
     *
     * _.isRegExp('/abc/');
     * // => false
     */
    var isRegExp = nodeIsRegExp ? baseUnary(nodeIsRegExp) : baseIsRegExp;

    /**
     * Checks if `value` is a safe integer. An integer is safe if it's an IEEE-754
     * double precision number which isn't the result of a rounded unsafe integer.
     *
     * **Note:** This method is based on
     * [`Number.isSafeInteger`](https://mdn.io/Number/isSafeInteger).
     *
     * @static
     * @memberOf _
     * @since 4.0.0
     * @category Lang
     * @param {*} value The value to check.
     * @returns {boolean} Returns `true` if `value` is a safe integer, else `false`.
     * @example
     *
     * _.isSafeInteger(3);
     * // => true
     *
     * _.isSafeInteger(Number.MIN_VALUE);
     * // => false
     *
     * _.isSafeInteger(Infinity);
     * // => false
     *
     * _.isSafeInteger('3');
     * // => false
     */
    function isSafeInteger(value) {
      return isInteger(value) && value >= -MAX_SAFE_INTEGER && value <= MAX_SAFE_INTEGER;
    }

    /**
     * Checks if `value` is classified as a `Set` object.
     *
     * @static
     * @memberOf _
     * @since 4.3.0
     * @category Lang
     * @param {*} value The value to check.
     * @returns {boolean} Returns `true` if `value` is a set, else `false`.
     * @example
     *
     * _.isSet(new Set);
     * // => true
     *
     * _.isSet(new WeakSet);
     * // => false
     */
    var isSet = nodeIsSet ? baseUnary(nodeIsSet) : baseIsSet;

    /**
     * Checks if `value` is classified as a `String` primitive or object.
     *
     * @static
     * @since 0.1.0
     * @memberOf _
     * @category Lang
     * @param {*} value The value to check.
     * @returns {boolean} Returns `true` if `value` is a string, else `false`.
     * @example
     *
     * _.isString('abc');
     * // => true
     *
     * _.isString(1);
     * // => false
     */
    function isString(value) {
      return typeof value == 'string' ||
        (!isArray(value) && isObjectLike(value) && baseGetTag(value) == stringTag);
    }

    /**
     * Checks if `value` is classified as a `Symbol` primitive or object.
     *
     * @static
     * @memberOf _
     * @since 4.0.0
     * @category Lang
     * @param {*} value The value to check.
     * @returns {boolean} Returns `true` if `value` is a symbol, else `false`.
     * @example
     *
     * _.isSymbol(Symbol.iterator);
     * // => true
     *
     * _.isSymbol('abc');
     * // => false
     */
    function isSymbol(value) {
      return typeof value == 'symbol' ||
        (isObjectLike(value) && baseGetTag(value) == symbolTag);
    }

    /**
     * Checks if `value` is classified as a typed array.
     *
     * @static
     * @memberOf _
     * @since 3.0.0
     * @category Lang
     * @param {*} value The value to check.
     * @returns {boolean} Returns `true` if `value` is a typed array, else `false`.
     * @example
     *
     * _.isTypedArray(new Uint8Array);
     * // => true
     *
     * _.isTypedArray([]);
     * // => false
     */
    var isTypedArray = nodeIsTypedArray ? baseUnary(nodeIsTypedArray) : baseIsTypedArray;

    /**
     * Checks if `value` is `undefined`.
     *
     * @static
     * @since 0.1.0
     * @memberOf _
     * @category Lang
     * @param {*} value The value to check.
     * @returns {boolean} Returns `true` if `value` is `undefined`, else `false`.
     * @example
     *
     * _.isUndefined(void 0);
     * // => true
     *
     * _.isUndefined(null);
     * // => false
     */
    function isUndefined(value) {
      return value === undefined;
    }

    /**
     * Checks if `value` is classified as a `WeakMap` object.
     *
     * @static
     * @memberOf _
     * @since 4.3.0
     * @category Lang
     * @param {*} value The value to check.
     * @returns {boolean} Returns `true` if `value` is a weak map, else `false`.
     * @example
     *
     * _.isWeakMap(new WeakMap);
     * // => true
     *
     * _.isWeakMap(new Map);
     * // => false
     */
    function isWeakMap(value) {
      return isObjectLike(value) && getTag(value) == weakMapTag;
    }

    /**
     * Checks if `value` is classified as a `WeakSet` object.
     *
     * @static
     * @memberOf _
     * @since 4.3.0
     * @category Lang
     * @param {*} value The value to check.
     * @returns {boolean} Returns `true` if `value` is a weak set, else `false`.
     * @example
     *
     * _.isWeakSet(new WeakSet);
     * // => true
     *
     * _.isWeakSet(new Set);
     * // => false
     */
    function isWeakSet(value) {
      return isObjectLike(value) && baseGetTag(value) == weakSetTag;
    }

    /**
     * Checks if `value` is less than `other`.
     *
     * @static
     * @memberOf _
     * @since 3.9.0
     * @category Lang
     * @param {*} value The value to compare.
     * @param {*} other The other value to compare.
     * @returns {boolean} Returns `true` if `value` is less than `other`,
     *  else `false`.
     * @see _.gt
     * @example
     *
     * _.lt(1, 3);
     * // => true
     *
     * _.lt(3, 3);
     * // => false
     *
     * _.lt(3, 1);
     * // => false
     */
    var lt = createRelationalOperation(baseLt);

    /**
     * Checks if `value` is less than or equal to `other`.
     *
     * @static
     * @memberOf _
     * @since 3.9.0
     * @category Lang
     * @param {*} value The value to compare.
     * @param {*} other The other value to compare.
     * @returns {boolean} Returns `true` if `value` is less than or equal to
     *  `other`, else `false`.
     * @see _.gte
     * @example
     *
     * _.lte(1, 3);
     * // => true
     *
     * _.lte(3, 3);
     * // => true
     *
     * _.lte(3, 1);
     * // => false
     */
    var lte = createRelationalOperation(function(value, other) {
      return value <= other;
    });

    /**
     * Converts `value` to an array.
     *
     * @static
     * @since 0.1.0
     * @memberOf _
     * @category Lang
     * @param {*} value The value to convert.
     * @returns {Array} Returns the converted array.
     * @example
     *
     * _.toArray({ 'a': 1, 'b': 2 });
     * // => [1, 2]
     *
     * _.toArray('abc');
     * // => ['a', 'b', 'c']
     *
     * _.toArray(1);
     * // => []
     *
     * _.toArray(null);
     * // => []
     */
    function toArray(value) {
      if (!value) {
        return [];
      }
      if (isArrayLike(value)) {
        return isString(value) ? stringToArray(value) : copyArray(value);
      }
      if (symIterator && value[symIterator]) {
        return iteratorToArray(value[symIterator]());
      }
      var tag = getTag(value),
          func = tag == mapTag ? mapToArray : (tag == setTag ? setToArray : values);

      return func(value);
    }

    /**
     * Converts `value` to a finite number.
     *
     * @static
     * @memberOf _
     * @since 4.12.0
     * @category Lang
     * @param {*} value The value to convert.
     * @returns {number} Returns the converted number.
     * @example
     *
     * _.toFinite(3.2);
     * // => 3.2
     *
     * _.toFinite(Number.MIN_VALUE);
     * // => 5e-324
     *
     * _.toFinite(Infinity);
     * // => 1.7976931348623157e+308
     *
     * _.toFinite('3.2');
     * // => 3.2
     */
    function toFinite(value) {
      if (!value) {
        return value === 0 ? value : 0;
      }
      value = toNumber(value);
      if (value === INFINITY || value === -INFINITY) {
        var sign = (value < 0 ? -1 : 1);
        return sign * MAX_INTEGER;
      }
      return value === value ? value : 0;
    }

    /**
     * Converts `value` to an integer.
     *
     * **Note:** This method is loosely based on
     * [`ToInteger`](http://www.ecma-international.org/ecma-262/7.0/#sec-tointeger).
     *
     * @static
     * @memberOf _
     * @since 4.0.0
     * @category Lang
     * @param {*} value The value to convert.
     * @returns {number} Returns the converted integer.
     * @example
     *
     * _.toInteger(3.2);
     * // => 3
     *
     * _.toInteger(Number.MIN_VALUE);
     * // => 0
     *
     * _.toInteger(Infinity);
     * // => 1.7976931348623157e+308
     *
     * _.toInteger('3.2');
     * // => 3
     */
    function toInteger(value) {
      var result = toFinite(value),
          remainder = result % 1;

      return result === result ? (remainder ? result - remainder : result) : 0;
    }

    /**
     * Converts `value` to an integer suitable for use as the length of an
     * array-like object.
     *
     * **Note:** This method is based on
     * [`ToLength`](http://ecma-international.org/ecma-262/7.0/#sec-tolength).
     *
     * @static
     * @memberOf _
     * @since 4.0.0
     * @category Lang
     * @param {*} value The value to convert.
     * @returns {number} Returns the converted integer.
     * @example
     *
     * _.toLength(3.2);
     * // => 3
     *
     * _.toLength(Number.MIN_VALUE);
     * // => 0
     *
     * _.toLength(Infinity);
     * // => 4294967295
     *
     * _.toLength('3.2');
     * // => 3
     */
    function toLength(value) {
      return value ? baseClamp(toInteger(value), 0, MAX_ARRAY_LENGTH) : 0;
    }

    /**
     * Converts `value` to a number.
     *
     * @static
     * @memberOf _
     * @since 4.0.0
     * @category Lang
     * @param {*} value The value to process.
     * @returns {number} Returns the number.
     * @example
     *
     * _.toNumber(3.2);
     * // => 3.2
     *
     * _.toNumber(Number.MIN_VALUE);
     * // => 5e-324
     *
     * _.toNumber(Infinity);
     * // => Infinity
     *
     * _.toNumber('3.2');
     * // => 3.2
     */
    function toNumber(value) {
      if (typeof value == 'number') {
        return value;
      }
      if (isSymbol(value)) {
        return NAN;
      }
      if (isObject(value)) {
        var other = typeof value.valueOf == 'function' ? value.valueOf() : value;
        value = isObject(other) ? (other + '') : other;
      }
      if (typeof value != 'string') {
        return value === 0 ? value : +value;
      }
      value = value.replace(reTrim, '');
      var isBinary = reIsBinary.test(value);
      return (isBinary || reIsOctal.test(value))
        ? freeParseInt(value.slice(2), isBinary ? 2 : 8)
        : (reIsBadHex.test(value) ? NAN : +value);
    }

    /**
     * Converts `value` to a plain object flattening inherited enumerable string
     * keyed properties of `value` to own properties of the plain object.
     *
     * @static
     * @memberOf _
     * @since 3.0.0
     * @category Lang
     * @param {*} value The value to convert.
     * @returns {Object} Returns the converted plain object.
     * @example
     *
     * function Foo() {
     *   this.b = 2;
     * }
     *
     * Foo.prototype.c = 3;
     *
     * _.assign({ 'a': 1 }, new Foo);
     * // => { 'a': 1, 'b': 2 }
     *
     * _.assign({ 'a': 1 }, _.toPlainObject(new Foo));
     * // => { 'a': 1, 'b': 2, 'c': 3 }
     */
    function toPlainObject(value) {
      return copyObject(value, keysIn(value));
    }

    /**
     * Converts `value` to a safe integer. A safe integer can be compared and
     * represented correctly.
     *
     * @static
     * @memberOf _
     * @since 4.0.0
     * @category Lang
     * @param {*} value The value to convert.
     * @returns {number} Returns the converted integer.
     * @example
     *
     * _.toSafeInteger(3.2);
     * // => 3
     *
     * _.toSafeInteger(Number.MIN_VALUE);
     * // => 0
     *
     * _.toSafeInteger(Infinity);
     * // => 9007199254740991
     *
     * _.toSafeInteger('3.2');
     * // => 3
     */
    function toSafeInteger(value) {
      return value
        ? baseClamp(toInteger(value), -MAX_SAFE_INTEGER, MAX_SAFE_INTEGER)
        : (value === 0 ? value : 0);
    }

    /**
     * Converts `value` to a string. An empty string is returned for `null`
     * and `undefined` values. The sign of `-0` is preserved.
     *
     * @static
     * @memberOf _
     * @since 4.0.0
     * @category Lang
     * @param {*} value The value to convert.
     * @returns {string} Returns the converted string.
     * @example
     *
     * _.toString(null);
     * // => ''
     *
     * _.toString(-0);
     * // => '-0'
     *
     * _.toString([1, 2, 3]);
     * // => '1,2,3'
     */
    function toString(value) {
      return value == null ? '' : baseToString(value);
    }

    /*------------------------------------------------------------------------*/

    /**
     * Assigns own enumerable string keyed properties of source objects to the
     * destination object. Source objects are applied from left to right.
     * Subsequent sources overwrite property assignments of previous sources.
     *
     * **Note:** This method mutates `object` and is loosely based on
     * [`Object.assign`](https://mdn.io/Object/assign).
     *
     * @static
     * @memberOf _
     * @since 0.10.0
     * @category Object
     * @param {Object} object The destination object.
     * @param {...Object} [sources] The source objects.
     * @returns {Object} Returns `object`.
     * @see _.assignIn
     * @example
     *
     * function Foo() {
     *   this.a = 1;
     * }
     *
     * function Bar() {
     *   this.c = 3;
     * }
     *
     * Foo.prototype.b = 2;
     * Bar.prototype.d = 4;
     *
     * _.assign({ 'a': 0 }, new Foo, new Bar);
     * // => { 'a': 1, 'c': 3 }
     */
    var assign = createAssigner(function(object, source) {
      if (isPrototype(source) || isArrayLike(source)) {
        copyObject(source, keys(source), object);
        return;
      }
      for (var key in source) {
        if (hasOwnProperty.call(source, key)) {
          assignValue(object, key, source[key]);
        }
      }
    });

    /**
     * This method is like `_.assign` except that it iterates over own and
     * inherited source properties.
     *
     * **Note:** This method mutates `object`.
     *
     * @static
     * @memberOf _
     * @since 4.0.0
     * @alias extend
     * @category Object
     * @param {Object} object The destination object.
     * @param {...Object} [sources] The source objects.
     * @returns {Object} Returns `object`.
     * @see _.assign
     * @example
     *
     * function Foo() {
     *   this.a = 1;
     * }
     *
     * function Bar() {
     *   this.c = 3;
     * }
     *
     * Foo.prototype.b = 2;
     * Bar.prototype.d = 4;
     *
     * _.assignIn({ 'a': 0 }, new Foo, new Bar);
     * // => { 'a': 1, 'b': 2, 'c': 3, 'd': 4 }
     */
    var assignIn = createAssigner(function(object, source) {
      copyObject(source, keysIn(source), object);
    });

    /**
     * This method is like `_.assignIn` except that it accepts `customizer`
     * which is invoked to produce the assigned values. If `customizer` returns
     * `undefined`, assignment is handled by the method instead. The `customizer`
     * is invoked with five arguments: (objValue, srcValue, key, object, source).
     *
     * **Note:** This method mutates `object`.
     *
     * @static
     * @memberOf _
     * @since 4.0.0
     * @alias extendWith
     * @category Object
     * @param {Object} object The destination object.
     * @param {...Object} sources The source objects.
     * @param {Function} [customizer] The function to customize assigned values.
     * @returns {Object} Returns `object`.
     * @see _.assignWith
     * @example
     *
     * function customizer(objValue, srcValue) {
     *   return _.isUndefined(objValue) ? srcValue : objValue;
     * }
     *
     * var defaults = _.partialRight(_.assignInWith, customizer);
     *
     * defaults({ 'a': 1 }, { 'b': 2 }, { 'a': 3 });
     * // => { 'a': 1, 'b': 2 }
     */
    var assignInWith = createAssigner(function(object, source, srcIndex, customizer) {
      copyObject(source, keysIn(source), object, customizer);
    });

    /**
     * This method is like `_.assign` except that it accepts `customizer`
     * which is invoked to produce the assigned values. If `customizer` returns
     * `undefined`, assignment is handled by the method instead. The `customizer`
     * is invoked with five arguments: (objValue, srcValue, key, object, source).
     *
     * **Note:** This method mutates `object`.
     *
     * @static
     * @memberOf _
     * @since 4.0.0
     * @category Object
     * @param {Object} object The destination object.
     * @param {...Object} sources The source objects.
     * @param {Function} [customizer] The function to customize assigned values.
     * @returns {Object} Returns `object`.
     * @see _.assignInWith
     * @example
     *
     * function customizer(objValue, srcValue) {
     *   return _.isUndefined(objValue) ? srcValue : objValue;
     * }
     *
     * var defaults = _.partialRight(_.assignWith, customizer);
     *
     * defaults({ 'a': 1 }, { 'b': 2 }, { 'a': 3 });
     * // => { 'a': 1, 'b': 2 }
     */
    var assignWith = createAssigner(function(object, source, srcIndex, customizer) {
      copyObject(source, keys(source), object, customizer);
    });

    /**
     * Creates an array of values corresponding to `paths` of `object`.
     *
     * @static
     * @memberOf _
     * @since 1.0.0
     * @category Object
     * @param {Object} object The object to iterate over.
     * @param {...(string|string[])} [paths] The property paths to pick.
     * @returns {Array} Returns the picked values.
     * @example
     *
     * var object = { 'a': [{ 'b': { 'c': 3 } }, 4] };
     *
     * _.at(object, ['a[0].b.c', 'a[1]']);
     * // => [3, 4]
     */
    var at = flatRest(baseAt);

    /**
     * Creates an object that inherits from the `prototype` object. If a
     * `properties` object is given, its own enumerable string keyed properties
     * are assigned to the created object.
     *
     * @static
     * @memberOf _
     * @since 2.3.0
     * @category Object
     * @param {Object} prototype The object to inherit from.
     * @param {Object} [properties] The properties to assign to the object.
     * @returns {Object} Returns the new object.
     * @example
     *
     * function Shape() {
     *   this.x = 0;
     *   this.y = 0;
     * }
     *
     * function Circle() {
     *   Shape.call(this);
     * }
     *
     * Circle.prototype = _.create(Shape.prototype, {
     *   'constructor': Circle
     * });
     *
     * var circle = new Circle;
     * circle instanceof Circle;
     * // => true
     *
     * circle instanceof Shape;
     * // => true
     */
    function create(prototype, properties) {
      var result = baseCreate(prototype);
      return properties == null ? result : baseAssign(result, properties);
    }

    /**
     * Assigns own and inherited enumerable string keyed properties of source
     * objects to the destination object for all destination properties that
     * resolve to `undefined`. Source objects are applied from left to right.
     * Once a property is set, additional values of the same property are ignored.
     *
     * **Note:** This method mutates `object`.
     *
     * @static
     * @since 0.1.0
     * @memberOf _
     * @category Object
     * @param {Object} object The destination object.
     * @param {...Object} [sources] The source objects.
     * @returns {Object} Returns `object`.
     * @see _.defaultsDeep
     * @example
     *
     * _.defaults({ 'a': 1 }, { 'b': 2 }, { 'a': 3 });
     * // => { 'a': 1, 'b': 2 }
     */
    var defaults = baseRest(function(object, sources) {
      object = Object(object);

      var index = -1;
      var length = sources.length;
      var guard = length > 2 ? sources[2] : undefined;

      if (guard && isIterateeCall(sources[0], sources[1], guard)) {
        length = 1;
      }

      while (++index < length) {
        var source = sources[index];
        var props = keysIn(source);
        var propsIndex = -1;
        var propsLength = props.length;

        while (++propsIndex < propsLength) {
          var key = props[propsIndex];
          var value = object[key];

          if (value === undefined ||
              (eq(value, objectProto[key]) && !hasOwnProperty.call(object, key))) {
            object[key] = source[key];
          }
        }
      }

      return object;
    });

    /**
     * This method is like `_.defaults` except that it recursively assigns
     * default properties.
     *
     * **Note:** This method mutates `object`.
     *
     * @static
     * @memberOf _
     * @since 3.10.0
     * @category Object
     * @param {Object} object The destination object.
     * @param {...Object} [sources] The source objects.
     * @returns {Object} Returns `object`.
     * @see _.defaults
     * @example
     *
     * _.defaultsDeep({ 'a': { 'b': 2 } }, { 'a': { 'b': 1, 'c': 3 } });
     * // => { 'a': { 'b': 2, 'c': 3 } }
     */
    var defaultsDeep = baseRest(function(args) {
      args.push(undefined, customDefaultsMerge);
      return apply(mergeWith, undefined, args);
    });

    /**
     * This method is like `_.find` except that it returns the key of the first
     * element `predicate` returns truthy for instead of the element itself.
     *
     * @static
     * @memberOf _
     * @since 1.1.0
     * @category Object
     * @param {Object} object The object to inspect.
     * @param {Function} [predicate=_.identity] The function invoked per iteration.
     * @returns {string|undefined} Returns the key of the matched element,
     *  else `undefined`.
     * @example
     *
     * var users = {
     *   'barney':  { 'age': 36, 'active': true },
     *   'fred':    { 'age': 40, 'active': false },
     *   'pebbles': { 'age': 1,  'active': true }
     * };
     *
     * _.findKey(users, function(o) { return o.age < 40; });
     * // => 'barney' (iteration order is not guaranteed)
     *
     * // The `_.matches` iteratee shorthand.
     * _.findKey(users, { 'age': 1, 'active': true });
     * // => 'pebbles'
     *
     * // The `_.matchesProperty` iteratee shorthand.
     * _.findKey(users, ['active', false]);
     * // => 'fred'
     *
     * // The `_.property` iteratee shorthand.
     * _.findKey(users, 'active');
     * // => 'barney'
     */
    function findKey(object, predicate) {
      return baseFindKey(object, getIteratee(predicate, 3), baseForOwn);
    }

    /**
     * This method is like `_.findKey` except that it iterates over elements of
     * a collection in the opposite order.
     *
     * @static
     * @memberOf _
     * @since 2.0.0
     * @category Object
     * @param {Object} object The object to inspect.
     * @param {Function} [predicate=_.identity] The function invoked per iteration.
     * @returns {string|undefined} Returns the key of the matched element,
     *  else `undefined`.
     * @example
     *
     * var users = {
     *   'barney':  { 'age': 36, 'active': true },
     *   'fred':    { 'age': 40, 'active': false },
     *   'pebbles': { 'age': 1,  'active': true }
     * };
     *
     * _.findLastKey(users, function(o) { return o.age < 40; });
     * // => returns 'pebbles' assuming `_.findKey` returns 'barney'
     *
     * // The `_.matches` iteratee shorthand.
     * _.findLastKey(users, { 'age': 36, 'active': true });
     * // => 'barney'
     *
     * // The `_.matchesProperty` iteratee shorthand.
     * _.findLastKey(users, ['active', false]);
     * // => 'fred'
     *
     * // The `_.property` iteratee shorthand.
     * _.findLastKey(users, 'active');
     * // => 'pebbles'
     */
    function findLastKey(object, predicate) {
      return baseFindKey(object, getIteratee(predicate, 3), baseForOwnRight);
    }

    /**
     * Iterates over own and inherited enumerable string keyed properties of an
     * object and invokes `iteratee` for each property. The iteratee is invoked
     * with three arguments: (value, key, object). Iteratee functions may exit
     * iteration early by explicitly returning `false`.
     *
     * @static
     * @memberOf _
     * @since 0.3.0
     * @category Object
     * @param {Object} object The object to iterate over.
     * @param {Function} [iteratee=_.identity] The function invoked per iteration.
     * @returns {Object} Returns `object`.
     * @see _.forInRight
     * @example
     *
     * function Foo() {
     *   this.a = 1;
     *   this.b = 2;
     * }
     *
     * Foo.prototype.c = 3;
     *
     * _.forIn(new Foo, function(value, key) {
     *   console.log(key);
     * });
     * // => Logs 'a', 'b', then 'c' (iteration order is not guaranteed).
     */
    function forIn(object, iteratee) {
      return object == null
        ? object
        : baseFor(object, getIteratee(iteratee, 3), keysIn);
    }

    /**
     * This method is like `_.forIn` except that it iterates over properties of
     * `object` in the opposite order.
     *
     * @static
     * @memberOf _
     * @since 2.0.0
     * @category Object
     * @param {Object} object The object to iterate over.
     * @param {Function} [iteratee=_.identity] The function invoked per iteration.
     * @returns {Object} Returns `object`.
     * @see _.forIn
     * @example
     *
     * function Foo() {
     *   this.a = 1;
     *   this.b = 2;
     * }
     *
     * Foo.prototype.c = 3;
     *
     * _.forInRight(new Foo, function(value, key) {
     *   console.log(key);
     * });
     * // => Logs 'c', 'b', then 'a' assuming `_.forIn` logs 'a', 'b', then 'c'.
     */
    function forInRight(object, iteratee) {
      return object == null
        ? object
        : baseForRight(object, getIteratee(iteratee, 3), keysIn);
    }

    /**
     * Iterates over own enumerable string keyed properties of an object and
     * invokes `iteratee` for each property. The iteratee is invoked with three
     * arguments: (value, key, object). Iteratee functions may exit iteration
     * early by explicitly returning `false`.
     *
     * @static
     * @memberOf _
     * @since 0.3.0
     * @category Object
     * @param {Object} object The object to iterate over.
     * @param {Function} [iteratee=_.identity] The function invoked per iteration.
     * @returns {Object} Returns `object`.
     * @see _.forOwnRight
     * @example
     *
     * function Foo() {
     *   this.a = 1;
     *   this.b = 2;
     * }
     *
     * Foo.prototype.c = 3;
     *
     * _.forOwn(new Foo, function(value, key) {
     *   console.log(key);
     * });
     * // => Logs 'a' then 'b' (iteration order is not guaranteed).
     */
    function forOwn(object, iteratee) {
      return object && baseForOwn(object, getIteratee(iteratee, 3));
    }

    /**
     * This method is like `_.forOwn` except that it iterates over properties of
     * `object` in the opposite order.
     *
     * @static
     * @memberOf _
     * @since 2.0.0
     * @category Object
     * @param {Object} object The object to iterate over.
     * @param {Function} [iteratee=_.identity] The function invoked per iteration.
     * @returns {Object} Returns `object`.
     * @see _.forOwn
     * @example
     *
     * function Foo() {
     *   this.a = 1;
     *   this.b = 2;
     * }
     *
     * Foo.prototype.c = 3;
     *
     * _.forOwnRight(new Foo, function(value, key) {
     *   console.log(key);
     * });
     * // => Logs 'b' then 'a' assuming `_.forOwn` logs 'a' then 'b'.
     */
    function forOwnRight(object, iteratee) {
      return object && baseForOwnRight(object, getIteratee(iteratee, 3));
    }

    /**
     * Creates an array of function property names from own enumerable properties
     * of `object`.
     *
     * @static
     * @since 0.1.0
     * @memberOf _
     * @category Object
     * @param {Object} object The object to inspect.
     * @returns {Array} Returns the function names.
     * @see _.functionsIn
     * @example
     *
     * function Foo() {
     *   this.a = _.constant('a');
     *   this.b = _.constant('b');
     * }
     *
     * Foo.prototype.c = _.constant('c');
     *
     * _.functions(new Foo);
     * // => ['a', 'b']
     */
    function functions(object) {
      return object == null ? [] : baseFunctions(object, keys(object));
    }

    /**
     * Creates an array of function property names from own and inherited
     * enumerable properties of `object`.
     *
     * @static
     * @memberOf _
     * @since 4.0.0
     * @category Object
     * @param {Object} object The object to inspect.
     * @returns {Array} Returns the function names.
     * @see _.functions
     * @example
     *
     * function Foo() {
     *   this.a = _.constant('a');
     *   this.b = _.constant('b');
     * }
     *
     * Foo.prototype.c = _.constant('c');
     *
     * _.functionsIn(new Foo);
     * // => ['a', 'b', 'c']
     */
    function functionsIn(object) {
      return object == null ? [] : baseFunctions(object, keysIn(object));
    }

    /**
     * Gets the value at `path` of `object`. If the resolved value is
     * `undefined`, the `defaultValue` is returned in its place.
     *
     * @static
     * @memberOf _
     * @since 3.7.0
     * @category Object
     * @param {Object} object The object to query.
     * @param {Array|string} path The path of the property to get.
     * @param {*} [defaultValue] The value returned for `undefined` resolved values.
     * @returns {*} Returns the resolved value.
     * @example
     *
     * var object = { 'a': [{ 'b': { 'c': 3 } }] };
     *
     * _.get(object, 'a[0].b.c');
     * // => 3
     *
     * _.get(object, ['a', '0', 'b', 'c']);
     * // => 3
     *
     * _.get(object, 'a.b.c', 'default');
     * // => 'default'
     */
    function get(object, path, defaultValue) {
      var result = object == null ? undefined : baseGet(object, path);
      return result === undefined ? defaultValue : result;
    }

    /**
     * Checks if `path` is a direct property of `object`.
     *
     * @static
     * @since 0.1.0
     * @memberOf _
     * @category Object
     * @param {Object} object The object to query.
     * @param {Array|string} path The path to check.
     * @returns {boolean} Returns `true` if `path` exists, else `false`.
     * @example
     *
     * var object = { 'a': { 'b': 2 } };
     * var other = _.create({ 'a': _.create({ 'b': 2 }) });
     *
     * _.has(object, 'a');
     * // => true
     *
     * _.has(object, 'a.b');
     * // => true
     *
     * _.has(object, ['a', 'b']);
     * // => true
     *
     * _.has(other, 'a');
     * // => false
     */
    function has(object, path) {
      return object != null && hasPath(object, path, baseHas);
    }

    /**
     * Checks if `path` is a direct or inherited property of `object`.
     *
     * @static
     * @memberOf _
     * @since 4.0.0
     * @category Object
     * @param {Object} object The object to query.
     * @param {Array|string} path The path to check.
     * @returns {boolean} Returns `true` if `path` exists, else `false`.
     * @example
     *
     * var object = _.create({ 'a': _.create({ 'b': 2 }) });
     *
     * _.hasIn(object, 'a');
     * // => true
     *
     * _.hasIn(object, 'a.b');
     * // => true
     *
     * _.hasIn(object, ['a', 'b']);
     * // => true
     *
     * _.hasIn(object, 'b');
     * // => false
     */
    function hasIn(object, path) {
      return object != null && hasPath(object, path, baseHasIn);
    }

    /**
     * Creates an object composed of the inverted keys and values of `object`.
     * If `object` contains duplicate values, subsequent values overwrite
     * property assignments of previous values.
     *
     * @static
     * @memberOf _
     * @since 0.7.0
     * @category Object
     * @param {Object} object The object to invert.
     * @returns {Object} Returns the new inverted object.
     * @example
     *
     * var object = { 'a': 1, 'b': 2, 'c': 1 };
     *
     * _.invert(object);
     * // => { '1': 'c', '2': 'b' }
     */
    var invert = createInverter(function(result, value, key) {
      if (value != null &&
          typeof value.toString != 'function') {
        value = nativeObjectToString.call(value);
      }

      result[value] = key;
    }, constant(identity));

    /**
     * This method is like `_.invert` except that the inverted object is generated
     * from the results of running each element of `object` thru `iteratee`. The
     * corresponding inverted value of each inverted key is an array of keys
     * responsible for generating the inverted value. The iteratee is invoked
     * with one argument: (value).
     *
     * @static
     * @memberOf _
     * @since 4.1.0
     * @category Object
     * @param {Object} object The object to invert.
     * @param {Function} [iteratee=_.identity] The iteratee invoked per element.
     * @returns {Object} Returns the new inverted object.
     * @example
     *
     * var object = { 'a': 1, 'b': 2, 'c': 1 };
     *
     * _.invertBy(object);
     * // => { '1': ['a', 'c'], '2': ['b'] }
     *
     * _.invertBy(object, function(value) {
     *   return 'group' + value;
     * });
     * // => { 'group1': ['a', 'c'], 'group2': ['b'] }
     */
    var invertBy = createInverter(function(result, value, key) {
      if (value != null &&
          typeof value.toString != 'function') {
        value = nativeObjectToString.call(value);
      }

      if (hasOwnProperty.call(result, value)) {
        result[value].push(key);
      } else {
        result[value] = [key];
      }
    }, getIteratee);

    /**
     * Invokes the method at `path` of `object`.
     *
     * @static
     * @memberOf _
     * @since 4.0.0
     * @category Object
     * @param {Object} object The object to query.
     * @param {Array|string} path The path of the method to invoke.
     * @param {...*} [args] The arguments to invoke the method with.
     * @returns {*} Returns the result of the invoked method.
     * @example
     *
     * var object = { 'a': [{ 'b': { 'c': [1, 2, 3, 4] } }] };
     *
     * _.invoke(object, 'a[0].b.c.slice', 1, 3);
     * // => [2, 3]
     */
    var invoke = baseRest(baseInvoke);

    /**
     * Creates an array of the own enumerable property names of `object`.
     *
     * **Note:** Non-object values are coerced to objects. See the
     * [ES spec](http://ecma-international.org/ecma-262/7.0/#sec-object.keys)
     * for more details.
     *
     * @static
     * @since 0.1.0
     * @memberOf _
     * @category Object
     * @param {Object} object The object to query.
     * @returns {Array} Returns the array of property names.
     * @example
     *
     * function Foo() {
     *   this.a = 1;
     *   this.b = 2;
     * }
     *
     * Foo.prototype.c = 3;
     *
     * _.keys(new Foo);
     * // => ['a', 'b'] (iteration order is not guaranteed)
     *
     * _.keys('hi');
     * // => ['0', '1']
     */
    function keys(object) {
      return isArrayLike(object) ? arrayLikeKeys(object) : baseKeys(object);
    }

    /**
     * Creates an array of the own and inherited enumerable property names of `object`.
     *
     * **Note:** Non-object values are coerced to objects.
     *
     * @static
     * @memberOf _
     * @since 3.0.0
     * @category Object
     * @param {Object} object The object to query.
     * @returns {Array} Returns the array of property names.
     * @example
     *
     * function Foo() {
     *   this.a = 1;
     *   this.b = 2;
     * }
     *
     * Foo.prototype.c = 3;
     *
     * _.keysIn(new Foo);
     * // => ['a', 'b', 'c'] (iteration order is not guaranteed)
     */
    function keysIn(object) {
      return isArrayLike(object) ? arrayLikeKeys(object, true) : baseKeysIn(object);
    }

    /**
     * The opposite of `_.mapValues`; this method creates an object with the
     * same values as `object` and keys generated by running each own enumerable
     * string keyed property of `object` thru `iteratee`. The iteratee is invoked
     * with three arguments: (value, key, object).
     *
     * @static
     * @memberOf _
     * @since 3.8.0
     * @category Object
     * @param {Object} object The object to iterate over.
     * @param {Function} [iteratee=_.identity] The function invoked per iteration.
     * @returns {Object} Returns the new mapped object.
     * @see _.mapValues
     * @example
     *
     * _.mapKeys({ 'a': 1, 'b': 2 }, function(value, key) {
     *   return key + value;
     * });
     * // => { 'a1': 1, 'b2': 2 }
     */
    function mapKeys(object, iteratee) {
      var result = {};
      iteratee = getIteratee(iteratee, 3);

      baseForOwn(object, function(value, key, object) {
        baseAssignValue(result, iteratee(value, key, object), value);
      });
      return result;
    }

    /**
     * Creates an object with the same keys as `object` and values generated
     * by running each own enumerable string keyed property of `object` thru
     * `iteratee`. The iteratee is invoked with three arguments:
     * (value, key, object).
     *
     * @static
     * @memberOf _
     * @since 2.4.0
     * @category Object
     * @param {Object} object The object to iterate over.
     * @param {Function} [iteratee=_.identity] The function invoked per iteration.
     * @returns {Object} Returns the new mapped object.
     * @see _.mapKeys
     * @example
     *
     * var users = {
     *   'fred':    { 'user': 'fred',    'age': 40 },
     *   'pebbles': { 'user': 'pebbles', 'age': 1 }
     * };
     *
     * _.mapValues(users, function(o) { return o.age; });
     * // => { 'fred': 40, 'pebbles': 1 } (iteration order is not guaranteed)
     *
     * // The `_.property` iteratee shorthand.
     * _.mapValues(users, 'age');
     * // => { 'fred': 40, 'pebbles': 1 } (iteration order is not guaranteed)
     */
    function mapValues(object, iteratee) {
      var result = {};
      iteratee = getIteratee(iteratee, 3);

      baseForOwn(object, function(value, key, object) {
        baseAssignValue(result, key, iteratee(value, key, object));
      });
      return result;
    }

    /**
     * This method is like `_.assign` except that it recursively merges own and
     * inherited enumerable string keyed properties of source objects into the
     * destination object. Source properties that resolve to `undefined` are
     * skipped if a destination value exists. Array and plain object properties
     * are merged recursively. Other objects and value types are overridden by
     * assignment. Source objects are applied from left to right. Subsequent
     * sources overwrite property assignments of previous sources.
     *
     * **Note:** This method mutates `object`.
     *
     * @static
     * @memberOf _
     * @since 0.5.0
     * @category Object
     * @param {Object} object The destination object.
     * @param {...Object} [sources] The source objects.
     * @returns {Object} Returns `object`.
     * @example
     *
     * var object = {
     *   'a': [{ 'b': 2 }, { 'd': 4 }]
     * };
     *
     * var other = {
     *   'a': [{ 'c': 3 }, { 'e': 5 }]
     * };
     *
     * _.merge(object, other);
     * // => { 'a': [{ 'b': 2, 'c': 3 }, { 'd': 4, 'e': 5 }] }
     */
    var merge = createAssigner(function(object, source, srcIndex) {
      baseMerge(object, source, srcIndex);
    });

    /**
     * This method is like `_.merge` except that it accepts `customizer` which
     * is invoked to produce the merged values of the destination and source
     * properties. If `customizer` returns `undefined`, merging is handled by the
     * method instead. The `customizer` is invoked with six arguments:
     * (objValue, srcValue, key, object, source, stack).
     *
     * **Note:** This method mutates `object`.
     *
     * @static
     * @memberOf _
     * @since 4.0.0
     * @category Object
     * @param {Object} object The destination object.
     * @param {...Object} sources The source objects.
     * @param {Function} customizer The function to customize assigned values.
     * @returns {Object} Returns `object`.
     * @example
     *
     * function customizer(objValue, srcValue) {
     *   if (_.isArray(objValue)) {
     *     return objValue.concat(srcValue);
     *   }
     * }
     *
     * var object = { 'a': [1], 'b': [2] };
     * var other = { 'a': [3], 'b': [4] };
     *
     * _.mergeWith(object, other, customizer);
     * // => { 'a': [1, 3], 'b': [2, 4] }
     */
    var mergeWith = createAssigner(function(object, source, srcIndex, customizer) {
      baseMerge(object, source, srcIndex, customizer);
    });

    /**
     * The opposite of `_.pick`; this method creates an object composed of the
     * own and inherited enumerable property paths of `object` that are not omitted.
     *
     * **Note:** This method is considerably slower than `_.pick`.
     *
     * @static
     * @since 0.1.0
     * @memberOf _
     * @category Object
     * @param {Object} object The source object.
     * @param {...(string|string[])} [paths] The property paths to omit.
     * @returns {Object} Returns the new object.
     * @example
     *
     * var object = { 'a': 1, 'b': '2', 'c': 3 };
     *
     * _.omit(object, ['a', 'c']);
     * // => { 'b': '2' }
     */
    var omit = flatRest(function(object, paths) {
      var result = {};
      if (object == null) {
        return result;
      }
      var isDeep = false;
      paths = arrayMap(paths, function(path) {
        path = castPath(path, object);
        isDeep || (isDeep = path.length > 1);
        return path;
      });
      copyObject(object, getAllKeysIn(object), result);
      if (isDeep) {
        result = baseClone(result, CLONE_DEEP_FLAG | CLONE_FLAT_FLAG | CLONE_SYMBOLS_FLAG, customOmitClone);
      }
      var length = paths.length;
      while (length--) {
        baseUnset(result, paths[length]);
      }
      return result;
    });

    /**
     * The opposite of `_.pickBy`; this method creates an object composed of
     * the own and inherited enumerable string keyed properties of `object` that
     * `predicate` doesn't return truthy for. The predicate is invoked with two
     * arguments: (value, key).
     *
     * @static
     * @memberOf _
     * @since 4.0.0
     * @category Object
     * @param {Object} object The source object.
     * @param {Function} [predicate=_.identity] The function invoked per property.
     * @returns {Object} Returns the new object.
     * @example
     *
     * var object = { 'a': 1, 'b': '2', 'c': 3 };
     *
     * _.omitBy(object, _.isNumber);
     * // => { 'b': '2' }
     */
    function omitBy(object, predicate) {
      return pickBy(object, negate(getIteratee(predicate)));
    }

    /**
     * Creates an object composed of the picked `object` properties.
     *
     * @static
     * @since 0.1.0
     * @memberOf _
     * @category Object
     * @param {Object} object The source object.
     * @param {...(string|string[])} [paths] The property paths to pick.
     * @returns {Object} Returns the new object.
     * @example
     *
     * var object = { 'a': 1, 'b': '2', 'c': 3 };
     *
     * _.pick(object, ['a', 'c']);
     * // => { 'a': 1, 'c': 3 }
     */
    var pick = flatRest(function(object, paths) {
      return object == null ? {} : basePick(object, paths);
    });

    /**
     * Creates an object composed of the `object` properties `predicate` returns
     * truthy for. The predicate is invoked with two arguments: (value, key).
     *
     * @static
     * @memberOf _
     * @since 4.0.0
     * @category Object
     * @param {Object} object The source object.
     * @param {Function} [predicate=_.identity] The function invoked per property.
     * @returns {Object} Returns the new object.
     * @example
     *
     * var object = { 'a': 1, 'b': '2', 'c': 3 };
     *
     * _.pickBy(object, _.isNumber);
     * // => { 'a': 1, 'c': 3 }
     */
    function pickBy(object, predicate) {
      if (object == null) {
        return {};
      }
      var props = arrayMap(getAllKeysIn(object), function(prop) {
        return [prop];
      });
      predicate = getIteratee(predicate);
      return basePickBy(object, props, function(value, path) {
        return predicate(value, path[0]);
      });
    }

    /**
     * This method is like `_.get` except that if the resolved value is a
     * function it's invoked with the `this` binding of its parent object and
     * its result is returned.
     *
     * @static
     * @since 0.1.0
     * @memberOf _
     * @category Object
     * @param {Object} object The object to query.
     * @param {Array|string} path The path of the property to resolve.
     * @param {*} [defaultValue] The value returned for `undefined` resolved values.
     * @returns {*} Returns the resolved value.
     * @example
     *
     * var object = { 'a': [{ 'b': { 'c1': 3, 'c2': _.constant(4) } }] };
     *
     * _.result(object, 'a[0].b.c1');
     * // => 3
     *
     * _.result(object, 'a[0].b.c2');
     * // => 4
     *
     * _.result(object, 'a[0].b.c3', 'default');
     * // => 'default'
     *
     * _.result(object, 'a[0].b.c3', _.constant('default'));
     * // => 'default'
     */
    function result(object, path, defaultValue) {
      path = castPath(path, object);

      var index = -1,
          length = path.length;

      // Ensure the loop is entered when path is empty.
      if (!length) {
        length = 1;
        object = undefined;
      }
      while (++index < length) {
        var value = object == null ? undefined : object[toKey(path[index])];
        if (value === undefined) {
          index = length;
          value = defaultValue;
        }
        object = isFunction(value) ? value.call(object) : value;
      }
      return object;
    }

    /**
     * Sets the value at `path` of `object`. If a portion of `path` doesn't exist,
     * it's created. Arrays are created for missing index properties while objects
     * are created for all other missing properties. Use `_.setWith` to customize
     * `path` creation.
     *
     * **Note:** This method mutates `object`.
     *
     * @static
     * @memberOf _
     * @since 3.7.0
     * @category Object
     * @param {Object} object The object to modify.
     * @param {Array|string} path The path of the property to set.
     * @param {*} value The value to set.
     * @returns {Object} Returns `object`.
     * @example
     *
     * var object = { 'a': [{ 'b': { 'c': 3 } }] };
     *
     * _.set(object, 'a[0].b.c', 4);
     * console.log(object.a[0].b.c);
     * // => 4
     *
     * _.set(object, ['x', '0', 'y', 'z'], 5);
     * console.log(object.x[0].y.z);
     * // => 5
     */
    function set(object, path, value) {
      return object == null ? object : baseSet(object, path, value);
    }

    /**
     * This method is like `_.set` except that it accepts `customizer` which is
     * invoked to produce the objects of `path`.  If `customizer` returns `undefined`
     * path creation is handled by the method instead. The `customizer` is invoked
     * with three arguments: (nsValue, key, nsObject).
     *
     * **Note:** This method mutates `object`.
     *
     * @static
     * @memberOf _
     * @since 4.0.0
     * @category Object
     * @param {Object} object The object to modify.
     * @param {Array|string} path The path of the property to set.
     * @param {*} value The value to set.
     * @param {Function} [customizer] The function to customize assigned values.
     * @returns {Object} Returns `object`.
     * @example
     *
     * var object = {};
     *
     * _.setWith(object, '[0][1]', 'a', Object);
     * // => { '0': { '1': 'a' } }
     */
    function setWith(object, path, value, customizer) {
      customizer = typeof customizer == 'function' ? customizer : undefined;
      return object == null ? object : baseSet(object, path, value, customizer);
    }

    /**
     * Creates an array of own enumerable string keyed-value pairs for `object`
     * which can be consumed by `_.fromPairs`. If `object` is a map or set, its
     * entries are returned.
     *
     * @static
     * @memberOf _
     * @since 4.0.0
     * @alias entries
     * @category Object
     * @param {Object} object The object to query.
     * @returns {Array} Returns the key-value pairs.
     * @example
     *
     * function Foo() {
     *   this.a = 1;
     *   this.b = 2;
     * }
     *
     * Foo.prototype.c = 3;
     *
     * _.toPairs(new Foo);
     * // => [['a', 1], ['b', 2]] (iteration order is not guaranteed)
     */
    var toPairs = createToPairs(keys);

    /**
     * Creates an array of own and inherited enumerable string keyed-value pairs
     * for `object` which can be consumed by `_.fromPairs`. If `object` is a map
     * or set, its entries are returned.
     *
     * @static
     * @memberOf _
     * @since 4.0.0
     * @alias entriesIn
     * @category Object
     * @param {Object} object The object to query.
     * @returns {Array} Returns the key-value pairs.
     * @example
     *
     * function Foo() {
     *   this.a = 1;
     *   this.b = 2;
     * }
     *
     * Foo.prototype.c = 3;
     *
     * _.toPairsIn(new Foo);
     * // => [['a', 1], ['b', 2], ['c', 3]] (iteration order is not guaranteed)
     */
    var toPairsIn = createToPairs(keysIn);

    /**
     * An alternative to `_.reduce`; this method transforms `object` to a new
     * `accumulator` object which is the result of running each of its own
     * enumerable string keyed properties thru `iteratee`, with each invocation
     * potentially mutating the `accumulator` object. If `accumulator` is not
     * provided, a new object with the same `[[Prototype]]` will be used. The
     * iteratee is invoked with four arguments: (accumulator, value, key, object).
     * Iteratee functions may exit iteration early by explicitly returning `false`.
     *
     * @static
     * @memberOf _
     * @since 1.3.0
     * @category Object
     * @param {Object} object The object to iterate over.
     * @param {Function} [iteratee=_.identity] The function invoked per iteration.
     * @param {*} [accumulator] The custom accumulator value.
     * @returns {*} Returns the accumulated value.
     * @example
     *
     * _.transform([2, 3, 4], function(result, n) {
     *   result.push(n *= n);
     *   return n % 2 == 0;
     * }, []);
     * // => [4, 9]
     *
     * _.transform({ 'a': 1, 'b': 2, 'c': 1 }, function(result, value, key) {
     *   (result[value] || (result[value] = [])).push(key);
     * }, {});
     * // => { '1': ['a', 'c'], '2': ['b'] }
     */
    function transform(object, iteratee, accumulator) {
      var isArr = isArray(object),
          isArrLike = isArr || isBuffer(object) || isTypedArray(object);

      iteratee = getIteratee(iteratee, 4);
      if (accumulator == null) {
        var Ctor = object && object.constructor;
        if (isArrLike) {
          accumulator = isArr ? new Ctor : [];
        }
        else if (isObject(object)) {
          accumulator = isFunction(Ctor) ? baseCreate(getPrototype(object)) : {};
        }
        else {
          accumulator = {};
        }
      }
      (isArrLike ? arrayEach : baseForOwn)(object, function(value, index, object) {
        return iteratee(accumulator, value, index, object);
      });
      return accumulator;
    }

    /**
     * Removes the property at `path` of `object`.
     *
     * **Note:** This method mutates `object`.
     *
     * @static
     * @memberOf _
     * @since 4.0.0
     * @category Object
     * @param {Object} object The object to modify.
     * @param {Array|string} path The path of the property to unset.
     * @returns {boolean} Returns `true` if the property is deleted, else `false`.
     * @example
     *
     * var object = { 'a': [{ 'b': { 'c': 7 } }] };
     * _.unset(object, 'a[0].b.c');
     * // => true
     *
     * console.log(object);
     * // => { 'a': [{ 'b': {} }] };
     *
     * _.unset(object, ['a', '0', 'b', 'c']);
     * // => true
     *
     * console.log(object);
     * // => { 'a': [{ 'b': {} }] };
     */
    function unset(object, path) {
      return object == null ? true : baseUnset(object, path);
    }

    /**
     * This method is like `_.set` except that accepts `updater` to produce the
     * value to set. Use `_.updateWith` to customize `path` creation. The `updater`
     * is invoked with one argument: (value).
     *
     * **Note:** This method mutates `object`.
     *
     * @static
     * @memberOf _
     * @since 4.6.0
     * @category Object
     * @param {Object} object The object to modify.
     * @param {Array|string} path The path of the property to set.
     * @param {Function} updater The function to produce the updated value.
     * @returns {Object} Returns `object`.
     * @example
     *
     * var object = { 'a': [{ 'b': { 'c': 3 } }] };
     *
     * _.update(object, 'a[0].b.c', function(n) { return n * n; });
     * console.log(object.a[0].b.c);
     * // => 9
     *
     * _.update(object, 'x[0].y.z', function(n) { return n ? n + 1 : 0; });
     * console.log(object.x[0].y.z);
     * // => 0
     */
    function update(object, path, updater) {
      return object == null ? object : baseUpdate(object, path, castFunction(updater));
    }

    /**
     * This method is like `_.update` except that it accepts `customizer` which is
     * invoked to produce the objects of `path`.  If `customizer` returns `undefined`
     * path creation is handled by the method instead. The `customizer` is invoked
     * with three arguments: (nsValue, key, nsObject).
     *
     * **Note:** This method mutates `object`.
     *
     * @static
     * @memberOf _
     * @since 4.6.0
     * @category Object
     * @param {Object} object The object to modify.
     * @param {Array|string} path The path of the property to set.
     * @param {Function} updater The function to produce the updated value.
     * @param {Function} [customizer] The function to customize assigned values.
     * @returns {Object} Returns `object`.
     * @example
     *
     * var object = {};
     *
     * _.updateWith(object, '[0][1]', _.constant('a'), Object);
     * // => { '0': { '1': 'a' } }
     */
    function updateWith(object, path, updater, customizer) {
      customizer = typeof customizer == 'function' ? customizer : undefined;
      return object == null ? object : baseUpdate(object, path, castFunction(updater), customizer);
    }

    /**
     * Creates an array of the own enumerable string keyed property values of `object`.
     *
     * **Note:** Non-object values are coerced to objects.
     *
     * @static
     * @since 0.1.0
     * @memberOf _
     * @category Object
     * @param {Object} object The object to query.
     * @returns {Array} Returns the array of property values.
     * @example
     *
     * function Foo() {
     *   this.a = 1;
     *   this.b = 2;
     * }
     *
     * Foo.prototype.c = 3;
     *
     * _.values(new Foo);
     * // => [1, 2] (iteration order is not guaranteed)
     *
     * _.values('hi');
     * // => ['h', 'i']
     */
    function values(object) {
      return object == null ? [] : baseValues(object, keys(object));
    }

    /**
     * Creates an array of the own and inherited enumerable string keyed property
     * values of `object`.
     *
     * **Note:** Non-object values are coerced to objects.
     *
     * @static
     * @memberOf _
     * @since 3.0.0
     * @category Object
     * @param {Object} object The object to query.
     * @returns {Array} Returns the array of property values.
     * @example
     *
     * function Foo() {
     *   this.a = 1;
     *   this.b = 2;
     * }
     *
     * Foo.prototype.c = 3;
     *
     * _.valuesIn(new Foo);
     * // => [1, 2, 3] (iteration order is not guaranteed)
     */
    function valuesIn(object) {
      return object == null ? [] : baseValues(object, keysIn(object));
    }

    /*------------------------------------------------------------------------*/

    /**
     * Clamps `number` within the inclusive `lower` and `upper` bounds.
     *
     * @static
     * @memberOf _
     * @since 4.0.0
     * @category Number
     * @param {number} number The number to clamp.
     * @param {number} [lower] The lower bound.
     * @param {number} upper The upper bound.
     * @returns {number} Returns the clamped number.
     * @example
     *
     * _.clamp(-10, -5, 5);
     * // => -5
     *
     * _.clamp(10, -5, 5);
     * // => 5
     */
    function clamp(number, lower, upper) {
      if (upper === undefined) {
        upper = lower;
        lower = undefined;
      }
      if (upper !== undefined) {
        upper = toNumber(upper);
        upper = upper === upper ? upper : 0;
      }
      if (lower !== undefined) {
        lower = toNumber(lower);
        lower = lower === lower ? lower : 0;
      }
      return baseClamp(toNumber(number), lower, upper);
    }

    /**
     * Checks if `n` is between `start` and up to, but not including, `end`. If
     * `end` is not specified, it's set to `start` with `start` then set to `0`.
     * If `start` is greater than `end` the params are swapped to support
     * negative ranges.
     *
     * @static
     * @memberOf _
     * @since 3.3.0
     * @category Number
     * @param {number} number The number to check.
     * @param {number} [start=0] The start of the range.
     * @param {number} end The end of the range.
     * @returns {boolean} Returns `true` if `number` is in the range, else `false`.
     * @see _.range, _.rangeRight
     * @example
     *
     * _.inRange(3, 2, 4);
     * // => true
     *
     * _.inRange(4, 8);
     * // => true
     *
     * _.inRange(4, 2);
     * // => false
     *
     * _.inRange(2, 2);
     * // => false
     *
     * _.inRange(1.2, 2);
     * // => true
     *
     * _.inRange(5.2, 4);
     * // => false
     *
     * _.inRange(-3, -2, -6);
     * // => true
     */
    function inRange(number, start, end) {
      start = toFinite(start);
      if (end === undefined) {
        end = start;
        start = 0;
      } else {
        end = toFinite(end);
      }
      number = toNumber(number);
      return baseInRange(number, start, end);
    }

    /**
     * Produces a random number between the inclusive `lower` and `upper` bounds.
     * If only one argument is provided a number between `0` and the given number
     * is returned. If `floating` is `true`, or either `lower` or `upper` are
     * floats, a floating-point number is returned instead of an integer.
     *
     * **Note:** JavaScript follows the IEEE-754 standard for resolving
     * floating-point values which can produce unexpected results.
     *
     * @static
     * @memberOf _
     * @since 0.7.0
     * @category Number
     * @param {number} [lower=0] The lower bound.
     * @param {number} [upper=1] The upper bound.
     * @param {boolean} [floating] Specify returning a floating-point number.
     * @returns {number} Returns the random number.
     * @example
     *
     * _.random(0, 5);
     * // => an integer between 0 and 5
     *
     * _.random(5);
     * // => also an integer between 0 and 5
     *
     * _.random(5, true);
     * // => a floating-point number between 0 and 5
     *
     * _.random(1.2, 5.2);
     * // => a floating-point number between 1.2 and 5.2
     */
    function random(lower, upper, floating) {
      if (floating && typeof floating != 'boolean' && isIterateeCall(lower, upper, floating)) {
        upper = floating = undefined;
      }
      if (floating === undefined) {
        if (typeof upper == 'boolean') {
          floating = upper;
          upper = undefined;
        }
        else if (typeof lower == 'boolean') {
          floating = lower;
          lower = undefined;
        }
      }
      if (lower === undefined && upper === undefined) {
        lower = 0;
        upper = 1;
      }
      else {
        lower = toFinite(lower);
        if (upper === undefined) {
          upper = lower;
          lower = 0;
        } else {
          upper = toFinite(upper);
        }
      }
      if (lower > upper) {
        var temp = lower;
        lower = upper;
        upper = temp;
      }
      if (floating || lower % 1 || upper % 1) {
        var rand = nativeRandom();
        return nativeMin(lower + (rand * (upper - lower + freeParseFloat('1e-' + ((rand + '').length - 1)))), upper);
      }
      return baseRandom(lower, upper);
    }

    /*------------------------------------------------------------------------*/

    /**
     * Converts `string` to [camel case](https://en.wikipedia.org/wiki/CamelCase).
     *
     * @static
     * @memberOf _
     * @since 3.0.0
     * @category String
     * @param {string} [string=''] The string to convert.
     * @returns {string} Returns the camel cased string.
     * @example
     *
     * _.camelCase('Foo Bar');
     * // => 'fooBar'
     *
     * _.camelCase('--foo-bar--');
     * // => 'fooBar'
     *
     * _.camelCase('__FOO_BAR__');
     * // => 'fooBar'
     */
    var camelCase = createCompounder(function(result, word, index) {
      word = word.toLowerCase();
      return result + (index ? capitalize(word) : word);
    });

    /**
     * Converts the first character of `string` to upper case and the remaining
     * to lower case.
     *
     * @static
     * @memberOf _
     * @since 3.0.0
     * @category String
     * @param {string} [string=''] The string to capitalize.
     * @returns {string} Returns the capitalized string.
     * @example
     *
     * _.capitalize('FRED');
     * // => 'Fred'
     */
    function capitalize(string) {
      return upperFirst(toString(string).toLowerCase());
    }

    /**
     * Deburrs `string` by converting
     * [Latin-1 Supplement](https://en.wikipedia.org/wiki/Latin-1_Supplement_(Unicode_block)#Character_table)
     * and [Latin Extended-A](https://en.wikipedia.org/wiki/Latin_Extended-A)
     * letters to basic Latin letters and removing
     * [combining diacritical marks](https://en.wikipedia.org/wiki/Combining_Diacritical_Marks).
     *
     * @static
     * @memberOf _
     * @since 3.0.0
     * @category String
     * @param {string} [string=''] The string to deburr.
     * @returns {string} Returns the deburred string.
     * @example
     *
     * _.deburr('déjà vu');
     * // => 'deja vu'
     */
    function deburr(string) {
      string = toString(string);
      return string && string.replace(reLatin, deburrLetter).replace(reComboMark, '');
    }

    /**
     * Checks if `string` ends with the given target string.
     *
     * @static
     * @memberOf _
     * @since 3.0.0
     * @category String
     * @param {string} [string=''] The string to inspect.
     * @param {string} [target] The string to search for.
     * @param {number} [position=string.length] The position to search up to.
     * @returns {boolean} Returns `true` if `string` ends with `target`,
     *  else `false`.
     * @example
     *
     * _.endsWith('abc', 'c');
     * // => true
     *
     * _.endsWith('abc', 'b');
     * // => false
     *
     * _.endsWith('abc', 'b', 2);
     * // => true
     */
    function endsWith(string, target, position) {
      string = toString(string);
      target = baseToString(target);

      var length = string.length;
      position = position === undefined
        ? length
        : baseClamp(toInteger(position), 0, length);

      var end = position;
      position -= target.length;
      return position >= 0 && string.slice(position, end) == target;
    }

    /**
     * Converts the characters "&", "<", ">", '"', and "'" in `string` to their
     * corresponding HTML entities.
     *
     * **Note:** No other characters are escaped. To escape additional
     * characters use a third-party library like [_he_](https://mths.be/he).
     *
     * Though the ">" character is escaped for symmetry, characters like
     * ">" and "/" don't need escaping in HTML and have no special meaning
     * unless they're part of a tag or unquoted attribute value. See
     * [Mathias Bynens's article](https://mathiasbynens.be/notes/ambiguous-ampersands)
     * (under "semi-related fun fact") for more details.
     *
     * When working with HTML you should always
     * [quote attribute values](http://wonko.com/post/html-escaping) to reduce
     * XSS vectors.
     *
     * @static
     * @since 0.1.0
     * @memberOf _
     * @category String
     * @param {string} [string=''] The string to escape.
     * @returns {string} Returns the escaped string.
     * @example
     *
     * _.escape('fred, barney, & pebbles');
     * // => 'fred, barney, &amp; pebbles'
     */
    function escape(string) {
      string = toString(string);
      return (string && reHasUnescapedHtml.test(string))
        ? string.replace(reUnescapedHtml, escapeHtmlChar)
        : string;
    }

    /**
     * Escapes the `RegExp` special characters "^", "$", "\", ".", "*", "+",
     * "?", "(", ")", "[", "]", "{", "}", and "|" in `string`.
     *
     * @static
     * @memberOf _
     * @since 3.0.0
     * @category String
     * @param {string} [string=''] The string to escape.
     * @returns {string} Returns the escaped string.
     * @example
     *
     * _.escapeRegExp('[lodash](https://lodash.com/)');
     * // => '\[lodash\]\(https://lodash\.com/\)'
     */
    function escapeRegExp(string) {
      string = toString(string);
      return (string && reHasRegExpChar.test(string))
        ? string.replace(reRegExpChar, '\\$&')
        : string;
    }

    /**
     * Converts `string` to
     * [kebab case](https://en.wikipedia.org/wiki/Letter_case#Special_case_styles).
     *
     * @static
     * @memberOf _
     * @since 3.0.0
     * @category String
     * @param {string} [string=''] The string to convert.
     * @returns {string} Returns the kebab cased string.
     * @example
     *
     * _.kebabCase('Foo Bar');
     * // => 'foo-bar'
     *
     * _.kebabCase('fooBar');
     * // => 'foo-bar'
     *
     * _.kebabCase('__FOO_BAR__');
     * // => 'foo-bar'
     */
    var kebabCase = createCompounder(function(result, word, index) {
      return result + (index ? '-' : '') + word.toLowerCase();
    });

    /**
     * Converts `string`, as space separated words, to lower case.
     *
     * @static
     * @memberOf _
     * @since 4.0.0
     * @category String
     * @param {string} [string=''] The string to convert.
     * @returns {string} Returns the lower cased string.
     * @example
     *
     * _.lowerCase('--Foo-Bar--');
     * // => 'foo bar'
     *
     * _.lowerCase('fooBar');
     * // => 'foo bar'
     *
     * _.lowerCase('__FOO_BAR__');
     * // => 'foo bar'
     */
    var lowerCase = createCompounder(function(result, word, index) {
      return result + (index ? ' ' : '') + word.toLowerCase();
    });

    /**
     * Converts the first character of `string` to lower case.
     *
     * @static
     * @memberOf _
     * @since 4.0.0
     * @category String
     * @param {string} [string=''] The string to convert.
     * @returns {string} Returns the converted string.
     * @example
     *
     * _.lowerFirst('Fred');
     * // => 'fred'
     *
     * _.lowerFirst('FRED');
     * // => 'fRED'
     */
    var lowerFirst = createCaseFirst('toLowerCase');

    /**
     * Pads `string` on the left and right sides if it's shorter than `length`.
     * Padding characters are truncated if they can't be evenly divided by `length`.
     *
     * @static
     * @memberOf _
     * @since 3.0.0
     * @category String
     * @param {string} [string=''] The string to pad.
     * @param {number} [length=0] The padding length.
     * @param {string} [chars=' '] The string used as padding.
     * @returns {string} Returns the padded string.
     * @example
     *
     * _.pad('abc', 8);
     * // => '  abc   '
     *
     * _.pad('abc', 8, '_-');
     * // => '_-abc_-_'
     *
     * _.pad('abc', 3);
     * // => 'abc'
     */
    function pad(string, length, chars) {
      string = toString(string);
      length = toInteger(length);

      var strLength = length ? stringSize(string) : 0;
      if (!length || strLength >= length) {
        return string;
      }
      var mid = (length - strLength) / 2;
      return (
        createPadding(nativeFloor(mid), chars) +
        string +
        createPadding(nativeCeil(mid), chars)
      );
    }

    /**
     * Pads `string` on the right side if it's shorter than `length`. Padding
     * characters are truncated if they exceed `length`.
     *
     * @static
     * @memberOf _
     * @since 4.0.0
     * @category String
     * @param {string} [string=''] The string to pad.
     * @param {number} [length=0] The padding length.
     * @param {string} [chars=' '] The string used as padding.
     * @returns {string} Returns the padded string.
     * @example
     *
     * _.padEnd('abc', 6);
     * // => 'abc   '
     *
     * _.padEnd('abc', 6, '_-');
     * // => 'abc_-_'
     *
     * _.padEnd('abc', 3);
     * // => 'abc'
     */
    function padEnd(string, length, chars) {
      string = toString(string);
      length = toInteger(length);

      var strLength = length ? stringSize(string) : 0;
      return (length && strLength < length)
        ? (string + createPadding(length - strLength, chars))
        : string;
    }

    /**
     * Pads `string` on the left side if it's shorter than `length`. Padding
     * characters are truncated if they exceed `length`.
     *
     * @static
     * @memberOf _
     * @since 4.0.0
     * @category String
     * @param {string} [string=''] The string to pad.
     * @param {number} [length=0] The padding length.
     * @param {string} [chars=' '] The string used as padding.
     * @returns {string} Returns the padded string.
     * @example
     *
     * _.padStart('abc', 6);
     * // => '   abc'
     *
     * _.padStart('abc', 6, '_-');
     * // => '_-_abc'
     *
     * _.padStart('abc', 3);
     * // => 'abc'
     */
    function padStart(string, length, chars) {
      string = toString(string);
      length = toInteger(length);

      var strLength = length ? stringSize(string) : 0;
      return (length && strLength < length)
        ? (createPadding(length - strLength, chars) + string)
        : string;
    }

    /**
     * Converts `string` to an integer of the specified radix. If `radix` is
     * `undefined` or `0`, a `radix` of `10` is used unless `value` is a
     * hexadecimal, in which case a `radix` of `16` is used.
     *
     * **Note:** This method aligns with the
     * [ES5 implementation](https://es5.github.io/#x15.1.2.2) of `parseInt`.
     *
     * @static
     * @memberOf _
     * @since 1.1.0
     * @category String
     * @param {string} string The string to convert.
     * @param {number} [radix=10] The radix to interpret `value` by.
     * @param- {Object} [guard] Enables use as an iteratee for methods like `_.map`.
     * @returns {number} Returns the converted integer.
     * @example
     *
     * _.parseInt('08');
     * // => 8
     *
     * _.map(['6', '08', '10'], _.parseInt);
     * // => [6, 8, 10]
     */
    function parseInt(string, radix, guard) {
      if (guard || radix == null) {
        radix = 0;
      } else if (radix) {
        radix = +radix;
      }
      return nativeParseInt(toString(string).replace(reTrimStart, ''), radix || 0);
    }

    /**
     * Repeats the given string `n` times.
     *
     * @static
     * @memberOf _
     * @since 3.0.0
     * @category String
     * @param {string} [string=''] The string to repeat.
     * @param {number} [n=1] The number of times to repeat the string.
     * @param- {Object} [guard] Enables use as an iteratee for methods like `_.map`.
     * @returns {string} Returns the repeated string.
     * @example
     *
     * _.repeat('*', 3);
     * // => '***'
     *
     * _.repeat('abc', 2);
     * // => 'abcabc'
     *
     * _.repeat('abc', 0);
     * // => ''
     */
    function repeat(string, n, guard) {
      if ((guard ? isIterateeCall(string, n, guard) : n === undefined)) {
        n = 1;
      } else {
        n = toInteger(n);
      }
      return baseRepeat(toString(string), n);
    }

    /**
     * Replaces matches for `pattern` in `string` with `replacement`.
     *
     * **Note:** This method is based on
     * [`String#replace`](https://mdn.io/String/replace).
     *
     * @static
     * @memberOf _
     * @since 4.0.0
     * @category String
     * @param {string} [string=''] The string to modify.
     * @param {RegExp|string} pattern The pattern to replace.
     * @param {Function|string} replacement The match replacement.
     * @returns {string} Returns the modified string.
     * @example
     *
     * _.replace('Hi Fred', 'Fred', 'Barney');
     * // => 'Hi Barney'
     */
    function replace() {
      var args = arguments,
          string = toString(args[0]);

      return args.length < 3 ? string : string.replace(args[1], args[2]);
    }

    /**
     * Converts `string` to
     * [snake case](https://en.wikipedia.org/wiki/Snake_case).
     *
     * @static
     * @memberOf _
     * @since 3.0.0
     * @category String
     * @param {string} [string=''] The string to convert.
     * @returns {string} Returns the snake cased string.
     * @example
     *
     * _.snakeCase('Foo Bar');
     * // => 'foo_bar'
     *
     * _.snakeCase('fooBar');
     * // => 'foo_bar'
     *
     * _.snakeCase('--FOO-BAR--');
     * // => 'foo_bar'
     */
    var snakeCase = createCompounder(function(result, word, index) {
      return result + (index ? '_' : '') + word.toLowerCase();
    });

    /**
     * Splits `string` by `separator`.
     *
     * **Note:** This method is based on
     * [`String#split`](https://mdn.io/String/split).
     *
     * @static
     * @memberOf _
     * @since 4.0.0
     * @category String
     * @param {string} [string=''] The string to split.
     * @param {RegExp|string} separator The separator pattern to split by.
     * @param {number} [limit] The length to truncate results to.
     * @returns {Array} Returns the string segments.
     * @example
     *
     * _.split('a-b-c', '-', 2);
     * // => ['a', 'b']
     */
    function split(string, separator, limit) {
      if (limit && typeof limit != 'number' && isIterateeCall(string, separator, limit)) {
        separator = limit = undefined;
      }
      limit = limit === undefined ? MAX_ARRAY_LENGTH : limit >>> 0;
      if (!limit) {
        return [];
      }
      string = toString(string);
      if (string && (
            typeof separator == 'string' ||
            (separator != null && !isRegExp(separator))
          )) {
        separator = baseToString(separator);
        if (!separator && hasUnicode(string)) {
          return castSlice(stringToArray(string), 0, limit);
        }
      }
      return string.split(separator, limit);
    }

    /**
     * Converts `string` to
     * [start case](https://en.wikipedia.org/wiki/Letter_case#Stylistic_or_specialised_usage).
     *
     * @static
     * @memberOf _
     * @since 3.1.0
     * @category String
     * @param {string} [string=''] The string to convert.
     * @returns {string} Returns the start cased string.
     * @example
     *
     * _.startCase('--foo-bar--');
     * // => 'Foo Bar'
     *
     * _.startCase('fooBar');
     * // => 'Foo Bar'
     *
     * _.startCase('__FOO_BAR__');
     * // => 'FOO BAR'
     */
    var startCase = createCompounder(function(result, word, index) {
      return result + (index ? ' ' : '') + upperFirst(word);
    });

    /**
     * Checks if `string` starts with the given target string.
     *
     * @static
     * @memberOf _
     * @since 3.0.0
     * @category String
     * @param {string} [string=''] The string to inspect.
     * @param {string} [target] The string to search for.
     * @param {number} [position=0] The position to search from.
     * @returns {boolean} Returns `true` if `string` starts with `target`,
     *  else `false`.
     * @example
     *
     * _.startsWith('abc', 'a');
     * // => true
     *
     * _.startsWith('abc', 'b');
     * // => false
     *
     * _.startsWith('abc', 'b', 1);
     * // => true
     */
    function startsWith(string, target, position) {
      string = toString(string);
      position = position == null
        ? 0
        : baseClamp(toInteger(position), 0, string.length);

      target = baseToString(target);
      return string.slice(position, position + target.length) == target;
    }

    /**
     * Creates a compiled template function that can interpolate data properties
     * in "interpolate" delimiters, HTML-escape interpolated data properties in
     * "escape" delimiters, and execute JavaScript in "evaluate" delimiters. Data
     * properties may be accessed as free variables in the template. If a setting
     * object is given, it takes precedence over `_.templateSettings` values.
     *
     * **Note:** In the development build `_.template` utilizes
     * [sourceURLs](http://www.html5rocks.com/en/tutorials/developertools/sourcemaps/#toc-sourceurl)
     * for easier debugging.
     *
     * For more information on precompiling templates see
     * [lodash's custom builds documentation](https://lodash.com/custom-builds).
     *
     * For more information on Chrome extension sandboxes see
     * [Chrome's extensions documentation](https://developer.chrome.com/extensions/sandboxingEval).
     *
     * @static
     * @since 0.1.0
     * @memberOf _
     * @category String
     * @param {string} [string=''] The template string.
     * @param {Object} [options={}] The options object.
     * @param {RegExp} [options.escape=_.templateSettings.escape]
     *  The HTML "escape" delimiter.
     * @param {RegExp} [options.evaluate=_.templateSettings.evaluate]
     *  The "evaluate" delimiter.
     * @param {Object} [options.imports=_.templateSettings.imports]
     *  An object to import into the template as free variables.
     * @param {RegExp} [options.interpolate=_.templateSettings.interpolate]
     *  The "interpolate" delimiter.
     * @param {string} [options.sourceURL='lodash.templateSources[n]']
     *  The sourceURL of the compiled template.
     * @param {string} [options.variable='obj']
     *  The data object variable name.
     * @param- {Object} [guard] Enables use as an iteratee for methods like `_.map`.
     * @returns {Function} Returns the compiled template function.
     * @example
     *
     * // Use the "interpolate" delimiter to create a compiled template.
     * var compiled = _.template('hello <%= user %>!');
     * compiled({ 'user': 'fred' });
     * // => 'hello fred!'
     *
     * // Use the HTML "escape" delimiter to escape data property values.
     * var compiled = _.template('<b><%- value %></b>');
     * compiled({ 'value': '<script>' });
     * // => '<b>&lt;script&gt;</b>'
     *
     * // Use the "evaluate" delimiter to execute JavaScript and generate HTML.
     * var compiled = _.template('<% _.forEach(users, function(user) { %><li><%- user %></li><% }); %>');
     * compiled({ 'users': ['fred', 'barney'] });
     * // => '<li>fred</li><li>barney</li>'
     *
     * // Use the internal `print` function in "evaluate" delimiters.
     * var compiled = _.template('<% print("hello " + user); %>!');
     * compiled({ 'user': 'barney' });
     * // => 'hello barney!'
     *
     * // Use the ES template literal delimiter as an "interpolate" delimiter.
     * // Disable support by replacing the "interpolate" delimiter.
     * var compiled = _.template('hello ${ user }!');
     * compiled({ 'user': 'pebbles' });
     * // => 'hello pebbles!'
     *
     * // Use backslashes to treat delimiters as plain text.
     * var compiled = _.template('<%= "\\<%- value %\\>" %>');
     * compiled({ 'value': 'ignored' });
     * // => '<%- value %>'
     *
     * // Use the `imports` option to import `jQuery` as `jq`.
     * var text = '<% jq.each(users, function(user) { %><li><%- user %></li><% }); %>';
     * var compiled = _.template(text, { 'imports': { 'jq': jQuery } });
     * compiled({ 'users': ['fred', 'barney'] });
     * // => '<li>fred</li><li>barney</li>'
     *
     * // Use the `sourceURL` option to specify a custom sourceURL for the template.
     * var compiled = _.template('hello <%= user %>!', { 'sourceURL': '/basic/greeting.jst' });
     * compiled(data);
     * // => Find the source of "greeting.jst" under the Sources tab or Resources panel of the web inspector.
     *
     * // Use the `variable` option to ensure a with-statement isn't used in the compiled template.
     * var compiled = _.template('hi <%= data.user %>!', { 'variable': 'data' });
     * compiled.source;
     * // => function(data) {
     * //   var __t, __p = '';
     * //   __p += 'hi ' + ((__t = ( data.user )) == null ? '' : __t) + '!';
     * //   return __p;
     * // }
     *
     * // Use custom template delimiters.
     * _.templateSettings.interpolate = /{{([\s\S]+?)}}/g;
     * var compiled = _.template('hello {{ user }}!');
     * compiled({ 'user': 'mustache' });
     * // => 'hello mustache!'
     *
     * // Use the `source` property to inline compiled templates for meaningful
     * // line numbers in error messages and stack traces.
     * fs.writeFileSync(path.join(process.cwd(), 'jst.js'), '\
     *   var JST = {\
     *     "main": ' + _.template(mainText).source + '\
     *   };\
     * ');
     */
    function template(string, options, guard) {
      // Based on John Resig's `tmpl` implementation
      // (http://ejohn.org/blog/javascript-micro-templating/)
      // and Laura Doktorova's doT.js (https://github.com/olado/doT).
      var settings = lodash.templateSettings;

      if (guard && isIterateeCall(string, options, guard)) {
        options = undefined;
      }
      string = toString(string);
      options = assignInWith({}, options, settings, customDefaultsAssignIn);

      var imports = assignInWith({}, options.imports, settings.imports, customDefaultsAssignIn),
          importsKeys = keys(imports),
          importsValues = baseValues(imports, importsKeys);

      var isEscaping,
          isEvaluating,
          index = 0,
          interpolate = options.interpolate || reNoMatch,
          source = "__p += '";

      // Compile the regexp to match each delimiter.
      var reDelimiters = RegExp(
        (options.escape || reNoMatch).source + '|' +
        interpolate.source + '|' +
        (interpolate === reInterpolate ? reEsTemplate : reNoMatch).source + '|' +
        (options.evaluate || reNoMatch).source + '|$'
      , 'g');

      // Use a sourceURL for easier debugging.
      // The sourceURL gets injected into the source that's eval-ed, so be careful
      // with lookup (in case of e.g. prototype pollution), and strip newlines if any.
      // A newline wouldn't be a valid sourceURL anyway, and it'd enable code injection.
      var sourceURL = '//# sourceURL=' +
        (hasOwnProperty.call(options, 'sourceURL')
          ? (options.sourceURL + '').replace(/[\r\n]/g, ' ')
          : ('lodash.templateSources[' + (++templateCounter) + ']')
        ) + '\n';

      string.replace(reDelimiters, function(match, escapeValue, interpolateValue, esTemplateValue, evaluateValue, offset) {
        interpolateValue || (interpolateValue = esTemplateValue);

        // Escape characters that can't be included in string literals.
        source += string.slice(index, offset).replace(reUnescapedString, escapeStringChar);

        // Replace delimiters with snippets.
        if (escapeValue) {
          isEscaping = true;
          source += "' +\n__e(" + escapeValue + ") +\n'";
        }
        if (evaluateValue) {
          isEvaluating = true;
          source += "';\n" + evaluateValue + ";\n__p += '";
        }
        if (interpolateValue) {
          source += "' +\n((__t = (" + interpolateValue + ")) == null ? '' : __t) +\n'";
        }
        index = offset + match.length;

        // The JS engine embedded in Adobe products needs `match` returned in
        // order to produce the correct `offset` value.
        return match;
      });

      source += "';\n";

      // If `variable` is not specified wrap a with-statement around the generated
      // code to add the data object to the top of the scope chain.
      // Like with sourceURL, we take care to not check the option's prototype,
      // as this configuration is a code injection vector.
      var variable = hasOwnProperty.call(options, 'variable') && options.variable;
      if (!variable) {
        source = 'with (obj) {\n' + source + '\n}\n';
      }
      // Cleanup code by stripping empty strings.
      source = (isEvaluating ? source.replace(reEmptyStringLeading, '') : source)
        .replace(reEmptyStringMiddle, '$1')
        .replace(reEmptyStringTrailing, '$1;');

      // Frame code as the function body.
      source = 'function(' + (variable || 'obj') + ') {\n' +
        (variable
          ? ''
          : 'obj || (obj = {});\n'
        ) +
        "var __t, __p = ''" +
        (isEscaping
           ? ', __e = _.escape'
           : ''
        ) +
        (isEvaluating
          ? ', __j = Array.prototype.join;\n' +
            "function print() { __p += __j.call(arguments, '') }\n"
          : ';\n'
        ) +
        source +
        'return __p\n}';

      var result = attempt(function() {
        return Function(importsKeys, sourceURL + 'return ' + source)
          .apply(undefined, importsValues);
      });

      // Provide the compiled function's source by its `toString` method or
      // the `source` property as a convenience for inlining compiled templates.
      result.source = source;
      if (isError(result)) {
        throw result;
      }
      return result;
    }

    /**
     * Converts `string`, as a whole, to lower case just like
     * [String#toLowerCase](https://mdn.io/toLowerCase).
     *
     * @static
     * @memberOf _
     * @since 4.0.0
     * @category String
     * @param {string} [string=''] The string to convert.
     * @returns {string} Returns the lower cased string.
     * @example
     *
     * _.toLower('--Foo-Bar--');
     * // => '--foo-bar--'
     *
     * _.toLower('fooBar');
     * // => 'foobar'
     *
     * _.toLower('__FOO_BAR__');
     * // => '__foo_bar__'
     */
    function toLower(value) {
      return toString(value).toLowerCase();
    }

    /**
     * Converts `string`, as a whole, to upper case just like
     * [String#toUpperCase](https://mdn.io/toUpperCase).
     *
     * @static
     * @memberOf _
     * @since 4.0.0
     * @category String
     * @param {string} [string=''] The string to convert.
     * @returns {string} Returns the upper cased string.
     * @example
     *
     * _.toUpper('--foo-bar--');
     * // => '--FOO-BAR--'
     *
     * _.toUpper('fooBar');
     * // => 'FOOBAR'
     *
     * _.toUpper('__foo_bar__');
     * // => '__FOO_BAR__'
     */
    function toUpper(value) {
      return toString(value).toUpperCase();
    }

    /**
     * Removes leading and trailing whitespace or specified characters from `string`.
     *
     * @static
     * @memberOf _
     * @since 3.0.0
     * @category String
     * @param {string} [string=''] The string to trim.
     * @param {string} [chars=whitespace] The characters to trim.
     * @param- {Object} [guard] Enables use as an iteratee for methods like `_.map`.
     * @returns {string} Returns the trimmed string.
     * @example
     *
     * _.trim('  abc  ');
     * // => 'abc'
     *
     * _.trim('-_-abc-_-', '_-');
     * // => 'abc'
     *
     * _.map(['  foo  ', '  bar  '], _.trim);
     * // => ['foo', 'bar']
     */
    function trim(string, chars, guard) {
      string = toString(string);
      if (string && (guard || chars === undefined)) {
        return string.replace(reTrim, '');
      }
      if (!string || !(chars = baseToString(chars))) {
        return string;
      }
      var strSymbols = stringToArray(string),
          chrSymbols = stringToArray(chars),
          start = charsStartIndex(strSymbols, chrSymbols),
          end = charsEndIndex(strSymbols, chrSymbols) + 1;

      return castSlice(strSymbols, start, end).join('');
    }

    /**
     * Removes trailing whitespace or specified characters from `string`.
     *
     * @static
     * @memberOf _
     * @since 4.0.0
     * @category String
     * @param {string} [string=''] The string to trim.
     * @param {string} [chars=whitespace] The characters to trim.
     * @param- {Object} [guard] Enables use as an iteratee for methods like `_.map`.
     * @returns {string} Returns the trimmed string.
     * @example
     *
     * _.trimEnd('  abc  ');
     * // => '  abc'
     *
     * _.trimEnd('-_-abc-_-', '_-');
     * // => '-_-abc'
     */
    function trimEnd(string, chars, guard) {
      string = toString(string);
      if (string && (guard || chars === undefined)) {
        return string.replace(reTrimEnd, '');
      }
      if (!string || !(chars = baseToString(chars))) {
        return string;
      }
      var strSymbols = stringToArray(string),
          end = charsEndIndex(strSymbols, stringToArray(chars)) + 1;

      return castSlice(strSymbols, 0, end).join('');
    }

    /**
     * Removes leading whitespace or specified characters from `string`.
     *
     * @static
     * @memberOf _
     * @since 4.0.0
     * @category String
     * @param {string} [string=''] The string to trim.
     * @param {string} [chars=whitespace] The characters to trim.
     * @param- {Object} [guard] Enables use as an iteratee for methods like `_.map`.
     * @returns {string} Returns the trimmed string.
     * @example
     *
     * _.trimStart('  abc  ');
     * // => 'abc  '
     *
     * _.trimStart('-_-abc-_-', '_-');
     * // => 'abc-_-'
     */
    function trimStart(string, chars, guard) {
      string = toString(string);
      if (string && (guard || chars === undefined)) {
        return string.replace(reTrimStart, '');
      }
      if (!string || !(chars = baseToString(chars))) {
        return string;
      }
      var strSymbols = stringToArray(string),
          start = charsStartIndex(strSymbols, stringToArray(chars));

      return castSlice(strSymbols, start).join('');
    }

    /**
     * Truncates `string` if it's longer than the given maximum string length.
     * The last characters of the truncated string are replaced with the omission
     * string which defaults to "...".
     *
     * @static
     * @memberOf _
     * @since 4.0.0
     * @category String
     * @param {string} [string=''] The string to truncate.
     * @param {Object} [options={}] The options object.
     * @param {number} [options.length=30] The maximum string length.
     * @param {string} [options.omission='...'] The string to indicate text is omitted.
     * @param {RegExp|string} [options.separator] The separator pattern to truncate to.
     * @returns {string} Returns the truncated string.
     * @example
     *
     * _.truncate('hi-diddly-ho there, neighborino');
     * // => 'hi-diddly-ho there, neighbo...'
     *
     * _.truncate('hi-diddly-ho there, neighborino', {
     *   'length': 24,
     *   'separator': ' '
     * });
     * // => 'hi-diddly-ho there,...'
     *
     * _.truncate('hi-diddly-ho there, neighborino', {
     *   'length': 24,
     *   'separator': /,? +/
     * });
     * // => 'hi-diddly-ho there...'
     *
     * _.truncate('hi-diddly-ho there, neighborino', {
     *   'omission': ' [...]'
     * });
     * // => 'hi-diddly-ho there, neig [...]'
     */
    function truncate(string, options) {
      var length = DEFAULT_TRUNC_LENGTH,
          omission = DEFAULT_TRUNC_OMISSION;

      if (isObject(options)) {
        var separator = 'separator' in options ? options.separator : separator;
        length = 'length' in options ? toInteger(options.length) : length;
        omission = 'omission' in options ? baseToString(options.omission) : omission;
      }
      string = toString(string);

      var strLength = string.length;
      if (hasUnicode(string)) {
        var strSymbols = stringToArray(string);
        strLength = strSymbols.length;
      }
      if (length >= strLength) {
        return string;
      }
      var end = length - stringSize(omission);
      if (end < 1) {
        return omission;
      }
      var result = strSymbols
        ? castSlice(strSymbols, 0, end).join('')
        : string.slice(0, end);

      if (separator === undefined) {
        return result + omission;
      }
      if (strSymbols) {
        end += (result.length - end);
      }
      if (isRegExp(separator)) {
        if (string.slice(end).search(separator)) {
          var match,
              substring = result;

          if (!separator.global) {
            separator = RegExp(separator.source, toString(reFlags.exec(separator)) + 'g');
          }
          separator.lastIndex = 0;
          while ((match = separator.exec(substring))) {
            var newEnd = match.index;
          }
          result = result.slice(0, newEnd === undefined ? end : newEnd);
        }
      } else if (string.indexOf(baseToString(separator), end) != end) {
        var index = result.lastIndexOf(separator);
        if (index > -1) {
          result = result.slice(0, index);
        }
      }
      return result + omission;
    }

    /**
     * The inverse of `_.escape`; this method converts the HTML entities
     * `&amp;`, `&lt;`, `&gt;`, `&quot;`, and `&#39;` in `string` to
     * their corresponding characters.
     *
     * **Note:** No other HTML entities are unescaped. To unescape additional
     * HTML entities use a third-party library like [_he_](https://mths.be/he).
     *
     * @static
     * @memberOf _
     * @since 0.6.0
     * @category String
     * @param {string} [string=''] The string to unescape.
     * @returns {string} Returns the unescaped string.
     * @example
     *
     * _.unescape('fred, barney, &amp; pebbles');
     * // => 'fred, barney, & pebbles'
     */
    function unescape(string) {
      string = toString(string);
      return (string && reHasEscapedHtml.test(string))
        ? string.replace(reEscapedHtml, unescapeHtmlChar)
        : string;
    }

    /**
     * Converts `string`, as space separated words, to upper case.
     *
     * @static
     * @memberOf _
     * @since 4.0.0
     * @category String
     * @param {string} [string=''] The string to convert.
     * @returns {string} Returns the upper cased string.
     * @example
     *
     * _.upperCase('--foo-bar');
     * // => 'FOO BAR'
     *
     * _.upperCase('fooBar');
     * // => 'FOO BAR'
     *
     * _.upperCase('__foo_bar__');
     * // => 'FOO BAR'
     */
    var upperCase = createCompounder(function(result, word, index) {
      return result + (index ? ' ' : '') + word.toUpperCase();
    });

    /**
     * Converts the first character of `string` to upper case.
     *
     * @static
     * @memberOf _
     * @since 4.0.0
     * @category String
     * @param {string} [string=''] The string to convert.
     * @returns {string} Returns the converted string.
     * @example
     *
     * _.upperFirst('fred');
     * // => 'Fred'
     *
     * _.upperFirst('FRED');
     * // => 'FRED'
     */
    var upperFirst = createCaseFirst('toUpperCase');

    /**
     * Splits `string` into an array of its words.
     *
     * @static
     * @memberOf _
     * @since 3.0.0
     * @category String
     * @param {string} [string=''] The string to inspect.
     * @param {RegExp|string} [pattern] The pattern to match words.
     * @param- {Object} [guard] Enables use as an iteratee for methods like `_.map`.
     * @returns {Array} Returns the words of `string`.
     * @example
     *
     * _.words('fred, barney, & pebbles');
     * // => ['fred', 'barney', 'pebbles']
     *
     * _.words('fred, barney, & pebbles', /[^, ]+/g);
     * // => ['fred', 'barney', '&', 'pebbles']
     */
    function words(string, pattern, guard) {
      string = toString(string);
      pattern = guard ? undefined : pattern;

      if (pattern === undefined) {
        return hasUnicodeWord(string) ? unicodeWords(string) : asciiWords(string);
      }
      return string.match(pattern) || [];
    }

    /*------------------------------------------------------------------------*/

    /**
     * Attempts to invoke `func`, returning either the result or the caught error
     * object. Any additional arguments are provided to `func` when it's invoked.
     *
     * @static
     * @memberOf _
     * @since 3.0.0
     * @category Util
     * @param {Function} func The function to attempt.
     * @param {...*} [args] The arguments to invoke `func` with.
     * @returns {*} Returns the `func` result or error object.
     * @example
     *
     * // Avoid throwing errors for invalid selectors.
     * var elements = _.attempt(function(selector) {
     *   return document.querySelectorAll(selector);
     * }, '>_>');
     *
     * if (_.isError(elements)) {
     *   elements = [];
     * }
     */
    var attempt = baseRest(function(func, args) {
      try {
        return apply(func, undefined, args);
      } catch (e) {
        return isError(e) ? e : new Error(e);
      }
    });

    /**
     * Binds methods of an object to the object itself, overwriting the existing
     * method.
     *
     * **Note:** This method doesn't set the "length" property of bound functions.
     *
     * @static
     * @since 0.1.0
     * @memberOf _
     * @category Util
     * @param {Object} object The object to bind and assign the bound methods to.
     * @param {...(string|string[])} methodNames The object method names to bind.
     * @returns {Object} Returns `object`.
     * @example
     *
     * var view = {
     *   'label': 'docs',
     *   'click': function() {
     *     console.log('clicked ' + this.label);
     *   }
     * };
     *
     * _.bindAll(view, ['click']);
     * jQuery(element).on('click', view.click);
     * // => Logs 'clicked docs' when clicked.
     */
    var bindAll = flatRest(function(object, methodNames) {
      arrayEach(methodNames, function(key) {
        key = toKey(key);
        baseAssignValue(object, key, bind(object[key], object));
      });
      return object;
    });

    /**
     * Creates a function that iterates over `pairs` and invokes the corresponding
     * function of the first predicate to return truthy. The predicate-function
     * pairs are invoked with the `this` binding and arguments of the created
     * function.
     *
     * @static
     * @memberOf _
     * @since 4.0.0
     * @category Util
     * @param {Array} pairs The predicate-function pairs.
     * @returns {Function} Returns the new composite function.
     * @example
     *
     * var func = _.cond([
     *   [_.matches({ 'a': 1 }),           _.constant('matches A')],
     *   [_.conforms({ 'b': _.isNumber }), _.constant('matches B')],
     *   [_.stubTrue,                      _.constant('no match')]
     * ]);
     *
     * func({ 'a': 1, 'b': 2 });
     * // => 'matches A'
     *
     * func({ 'a': 0, 'b': 1 });
     * // => 'matches B'
     *
     * func({ 'a': '1', 'b': '2' });
     * // => 'no match'
     */
    function cond(pairs) {
      var length = pairs == null ? 0 : pairs.length,
          toIteratee = getIteratee();

      pairs = !length ? [] : arrayMap(pairs, function(pair) {
        if (typeof pair[1] != 'function') {
          throw new TypeError(FUNC_ERROR_TEXT);
        }
        return [toIteratee(pair[0]), pair[1]];
      });

      return baseRest(function(args) {
        var index = -1;
        while (++index < length) {
          var pair = pairs[index];
          if (apply(pair[0], this, args)) {
            return apply(pair[1], this, args);
          }
        }
      });
    }

    /**
     * Creates a function that invokes the predicate properties of `source` with
     * the corresponding property values of a given object, returning `true` if
     * all predicates return truthy, else `false`.
     *
     * **Note:** The created function is equivalent to `_.conformsTo` with
     * `source` partially applied.
     *
     * @static
     * @memberOf _
     * @since 4.0.0
     * @category Util
     * @param {Object} source The object of property predicates to conform to.
     * @returns {Function} Returns the new spec function.
     * @example
     *
     * var objects = [
     *   { 'a': 2, 'b': 1 },
     *   { 'a': 1, 'b': 2 }
     * ];
     *
     * _.filter(objects, _.conforms({ 'b': function(n) { return n > 1; } }));
     * // => [{ 'a': 1, 'b': 2 }]
     */
    function conforms(source) {
      return baseConforms(baseClone(source, CLONE_DEEP_FLAG));
    }

    /**
     * Creates a function that returns `value`.
     *
     * @static
     * @memberOf _
     * @since 2.4.0
     * @category Util
     * @param {*} value The value to return from the new function.
     * @returns {Function} Returns the new constant function.
     * @example
     *
     * var objects = _.times(2, _.constant({ 'a': 1 }));
     *
     * console.log(objects);
     * // => [{ 'a': 1 }, { 'a': 1 }]
     *
     * console.log(objects[0] === objects[1]);
     * // => true
     */
    function constant(value) {
      return function() {
        return value;
      };
    }

    /**
     * Checks `value` to determine whether a default value should be returned in
     * its place. The `defaultValue` is returned if `value` is `NaN`, `null`,
     * or `undefined`.
     *
     * @static
     * @memberOf _
     * @since 4.14.0
     * @category Util
     * @param {*} value The value to check.
     * @param {*} defaultValue The default value.
     * @returns {*} Returns the resolved value.
     * @example
     *
     * _.defaultTo(1, 10);
     * // => 1
     *
     * _.defaultTo(undefined, 10);
     * // => 10
     */
    function defaultTo(value, defaultValue) {
      return (value == null || value !== value) ? defaultValue : value;
    }

    /**
     * Creates a function that returns the result of invoking the given functions
     * with the `this` binding of the created function, where each successive
     * invocation is supplied the return value of the previous.
     *
     * @static
     * @memberOf _
     * @since 3.0.0
     * @category Util
     * @param {...(Function|Function[])} [funcs] The functions to invoke.
     * @returns {Function} Returns the new composite function.
     * @see _.flowRight
     * @example
     *
     * function square(n) {
     *   return n * n;
     * }
     *
     * var addSquare = _.flow([_.add, square]);
     * addSquare(1, 2);
     * // => 9
     */
    var flow = createFlow();

    /**
     * This method is like `_.flow` except that it creates a function that
     * invokes the given functions from right to left.
     *
     * @static
     * @since 3.0.0
     * @memberOf _
     * @category Util
     * @param {...(Function|Function[])} [funcs] The functions to invoke.
     * @returns {Function} Returns the new composite function.
     * @see _.flow
     * @example
     *
     * function square(n) {
     *   return n * n;
     * }
     *
     * var addSquare = _.flowRight([square, _.add]);
     * addSquare(1, 2);
     * // => 9
     */
    var flowRight = createFlow(true);

    /**
     * This method returns the first argument it receives.
     *
     * @static
     * @since 0.1.0
     * @memberOf _
     * @category Util
     * @param {*} value Any value.
     * @returns {*} Returns `value`.
     * @example
     *
     * var object = { 'a': 1 };
     *
     * console.log(_.identity(object) === object);
     * // => true
     */
    function identity(value) {
      return value;
    }

    /**
     * Creates a function that invokes `func` with the arguments of the created
     * function. If `func` is a property name, the created function returns the
     * property value for a given element. If `func` is an array or object, the
     * created function returns `true` for elements that contain the equivalent
     * source properties, otherwise it returns `false`.
     *
     * @static
     * @since 4.0.0
     * @memberOf _
     * @category Util
     * @param {*} [func=_.identity] The value to convert to a callback.
     * @returns {Function} Returns the callback.
     * @example
     *
     * var users = [
     *   { 'user': 'barney', 'age': 36, 'active': true },
     *   { 'user': 'fred',   'age': 40, 'active': false }
     * ];
     *
     * // The `_.matches` iteratee shorthand.
     * _.filter(users, _.iteratee({ 'user': 'barney', 'active': true }));
     * // => [{ 'user': 'barney', 'age': 36, 'active': true }]
     *
     * // The `_.matchesProperty` iteratee shorthand.
     * _.filter(users, _.iteratee(['user', 'fred']));
     * // => [{ 'user': 'fred', 'age': 40 }]
     *
     * // The `_.property` iteratee shorthand.
     * _.map(users, _.iteratee('user'));
     * // => ['barney', 'fred']
     *
     * // Create custom iteratee shorthands.
     * _.iteratee = _.wrap(_.iteratee, function(iteratee, func) {
     *   return !_.isRegExp(func) ? iteratee(func) : function(string) {
     *     return func.test(string);
     *   };
     * });
     *
     * _.filter(['abc', 'def'], /ef/);
     * // => ['def']
     */
    function iteratee(func) {
      return baseIteratee(typeof func == 'function' ? func : baseClone(func, CLONE_DEEP_FLAG));
    }

    /**
     * Creates a function that performs a partial deep comparison between a given
     * object and `source`, returning `true` if the given object has equivalent
     * property values, else `false`.
     *
     * **Note:** The created function is equivalent to `_.isMatch` with `source`
     * partially applied.
     *
     * Partial comparisons will match empty array and empty object `source`
     * values against any array or object value, respectively. See `_.isEqual`
     * for a list of supported value comparisons.
     *
     * @static
     * @memberOf _
     * @since 3.0.0
     * @category Util
     * @param {Object} source The object of property values to match.
     * @returns {Function} Returns the new spec function.
     * @example
     *
     * var objects = [
     *   { 'a': 1, 'b': 2, 'c': 3 },
     *   { 'a': 4, 'b': 5, 'c': 6 }
     * ];
     *
     * _.filter(objects, _.matches({ 'a': 4, 'c': 6 }));
     * // => [{ 'a': 4, 'b': 5, 'c': 6 }]
     */
    function matches(source) {
      return baseMatches(baseClone(source, CLONE_DEEP_FLAG));
    }

    /**
     * Creates a function that performs a partial deep comparison between the
     * value at `path` of a given object to `srcValue`, returning `true` if the
     * object value is equivalent, else `false`.
     *
     * **Note:** Partial comparisons will match empty array and empty object
     * `srcValue` values against any array or object value, respectively. See
     * `_.isEqual` for a list of supported value comparisons.
     *
     * @static
     * @memberOf _
     * @since 3.2.0
     * @category Util
     * @param {Array|string} path The path of the property to get.
     * @param {*} srcValue The value to match.
     * @returns {Function} Returns the new spec function.
     * @example
     *
     * var objects = [
     *   { 'a': 1, 'b': 2, 'c': 3 },
     *   { 'a': 4, 'b': 5, 'c': 6 }
     * ];
     *
     * _.find(objects, _.matchesProperty('a', 4));
     * // => { 'a': 4, 'b': 5, 'c': 6 }
     */
    function matchesProperty(path, srcValue) {
      return baseMatchesProperty(path, baseClone(srcValue, CLONE_DEEP_FLAG));
    }

    /**
     * Creates a function that invokes the method at `path` of a given object.
     * Any additional arguments are provided to the invoked method.
     *
     * @static
     * @memberOf _
     * @since 3.7.0
     * @category Util
     * @param {Array|string} path The path of the method to invoke.
     * @param {...*} [args] The arguments to invoke the method with.
     * @returns {Function} Returns the new invoker function.
     * @example
     *
     * var objects = [
     *   { 'a': { 'b': _.constant(2) } },
     *   { 'a': { 'b': _.constant(1) } }
     * ];
     *
     * _.map(objects, _.method('a.b'));
     * // => [2, 1]
     *
     * _.map(objects, _.method(['a', 'b']));
     * // => [2, 1]
     */
    var method = baseRest(function(path, args) {
      return function(object) {
        return baseInvoke(object, path, args);
      };
    });

    /**
     * The opposite of `_.method`; this method creates a function that invokes
     * the method at a given path of `object`. Any additional arguments are
     * provided to the invoked method.
     *
     * @static
     * @memberOf _
     * @since 3.7.0
     * @category Util
     * @param {Object} object The object to query.
     * @param {...*} [args] The arguments to invoke the method with.
     * @returns {Function} Returns the new invoker function.
     * @example
     *
     * var array = _.times(3, _.constant),
     *     object = { 'a': array, 'b': array, 'c': array };
     *
     * _.map(['a[2]', 'c[0]'], _.methodOf(object));
     * // => [2, 0]
     *
     * _.map([['a', '2'], ['c', '0']], _.methodOf(object));
     * // => [2, 0]
     */
    var methodOf = baseRest(function(object, args) {
      return function(path) {
        return baseInvoke(object, path, args);
      };
    });

    /**
     * Adds all own enumerable string keyed function properties of a source
     * object to the destination object. If `object` is a function, then methods
     * are added to its prototype as well.
     *
     * **Note:** Use `_.runInContext` to create a pristine `lodash` function to
     * avoid conflicts caused by modifying the original.
     *
     * @static
     * @since 0.1.0
     * @memberOf _
     * @category Util
     * @param {Function|Object} [object=lodash] The destination object.
     * @param {Object} source The object of functions to add.
     * @param {Object} [options={}] The options object.
     * @param {boolean} [options.chain=true] Specify whether mixins are chainable.
     * @returns {Function|Object} Returns `object`.
     * @example
     *
     * function vowels(string) {
     *   return _.filter(string, function(v) {
     *     return /[aeiou]/i.test(v);
     *   });
     * }
     *
     * _.mixin({ 'vowels': vowels });
     * _.vowels('fred');
     * // => ['e']
     *
     * _('fred').vowels().value();
     * // => ['e']
     *
     * _.mixin({ 'vowels': vowels }, { 'chain': false });
     * _('fred').vowels();
     * // => ['e']
     */
    function mixin(object, source, options) {
      var props = keys(source),
          methodNames = baseFunctions(source, props);

      if (options == null &&
          !(isObject(source) && (methodNames.length || !props.length))) {
        options = source;
        source = object;
        object = this;
        methodNames = baseFunctions(source, keys(source));
      }
      var chain = !(isObject(options) && 'chain' in options) || !!options.chain,
          isFunc = isFunction(object);

      arrayEach(methodNames, function(methodName) {
        var func = source[methodName];
        object[methodName] = func;
        if (isFunc) {
          object.prototype[methodName] = function() {
            var chainAll = this.__chain__;
            if (chain || chainAll) {
              var result = object(this.__wrapped__),
                  actions = result.__actions__ = copyArray(this.__actions__);

              actions.push({ 'func': func, 'args': arguments, 'thisArg': object });
              result.__chain__ = chainAll;
              return result;
            }
            return func.apply(object, arrayPush([this.value()], arguments));
          };
        }
      });

      return object;
    }

    /**
     * Reverts the `_` variable to its previous value and returns a reference to
     * the `lodash` function.
     *
     * @static
     * @since 0.1.0
     * @memberOf _
     * @category Util
     * @returns {Function} Returns the `lodash` function.
     * @example
     *
     * var lodash = _.noConflict();
     */
    function noConflict() {
      if (root._ === this) {
        root._ = oldDash;
      }
      return this;
    }

    /**
     * This method returns `undefined`.
     *
     * @static
     * @memberOf _
     * @since 2.3.0
     * @category Util
     * @example
     *
     * _.times(2, _.noop);
     * // => [undefined, undefined]
     */
    function noop() {
      // No operation performed.
    }

    /**
     * Creates a function that gets the argument at index `n`. If `n` is negative,
     * the nth argument from the end is returned.
     *
     * @static
     * @memberOf _
     * @since 4.0.0
     * @category Util
     * @param {number} [n=0] The index of the argument to return.
     * @returns {Function} Returns the new pass-thru function.
     * @example
     *
     * var func = _.nthArg(1);
     * func('a', 'b', 'c', 'd');
     * // => 'b'
     *
     * var func = _.nthArg(-2);
     * func('a', 'b', 'c', 'd');
     * // => 'c'
     */
    function nthArg(n) {
      n = toInteger(n);
      return baseRest(function(args) {
        return baseNth(args, n);
      });
    }

    /**
     * Creates a function that invokes `iteratees` with the arguments it receives
     * and returns their results.
     *
     * @static
     * @memberOf _
     * @since 4.0.0
     * @category Util
     * @param {...(Function|Function[])} [iteratees=[_.identity]]
     *  The iteratees to invoke.
     * @returns {Function} Returns the new function.
     * @example
     *
     * var func = _.over([Math.max, Math.min]);
     *
     * func(1, 2, 3, 4);
     * // => [4, 1]
     */
    var over = createOver(arrayMap);

    /**
     * Creates a function that checks if **all** of the `predicates` return
     * truthy when invoked with the arguments it receives.
     *
     * @static
     * @memberOf _
     * @since 4.0.0
     * @category Util
     * @param {...(Function|Function[])} [predicates=[_.identity]]
     *  The predicates to check.
     * @returns {Function} Returns the new function.
     * @example
     *
     * var func = _.overEvery([Boolean, isFinite]);
     *
     * func('1');
     * // => true
     *
     * func(null);
     * // => false
     *
     * func(NaN);
     * // => false
     */
    var overEvery = createOver(arrayEvery);

    /**
     * Creates a function that checks if **any** of the `predicates` return
     * truthy when invoked with the arguments it receives.
     *
     * @static
     * @memberOf _
     * @since 4.0.0
     * @category Util
     * @param {...(Function|Function[])} [predicates=[_.identity]]
     *  The predicates to check.
     * @returns {Function} Returns the new function.
     * @example
     *
     * var func = _.overSome([Boolean, isFinite]);
     *
     * func('1');
     * // => true
     *
     * func(null);
     * // => true
     *
     * func(NaN);
     * // => false
     */
    var overSome = createOver(arraySome);

    /**
     * Creates a function that returns the value at `path` of a given object.
     *
     * @static
     * @memberOf _
     * @since 2.4.0
     * @category Util
     * @param {Array|string} path The path of the property to get.
     * @returns {Function} Returns the new accessor function.
     * @example
     *
     * var objects = [
     *   { 'a': { 'b': 2 } },
     *   { 'a': { 'b': 1 } }
     * ];
     *
     * _.map(objects, _.property('a.b'));
     * // => [2, 1]
     *
     * _.map(_.sortBy(objects, _.property(['a', 'b'])), 'a.b');
     * // => [1, 2]
     */
    function property(path) {
      return isKey(path) ? baseProperty(toKey(path)) : basePropertyDeep(path);
    }

    /**
     * The opposite of `_.property`; this method creates a function that returns
     * the value at a given path of `object`.
     *
     * @static
     * @memberOf _
     * @since 3.0.0
     * @category Util
     * @param {Object} object The object to query.
     * @returns {Function} Returns the new accessor function.
     * @example
     *
     * var array = [0, 1, 2],
     *     object = { 'a': array, 'b': array, 'c': array };
     *
     * _.map(['a[2]', 'c[0]'], _.propertyOf(object));
     * // => [2, 0]
     *
     * _.map([['a', '2'], ['c', '0']], _.propertyOf(object));
     * // => [2, 0]
     */
    function propertyOf(object) {
      return function(path) {
        return object == null ? undefined : baseGet(object, path);
      };
    }

    /**
     * Creates an array of numbers (positive and/or negative) progressing from
     * `start` up to, but not including, `end`. A step of `-1` is used if a negative
     * `start` is specified without an `end` or `step`. If `end` is not specified,
     * it's set to `start` with `start` then set to `0`.
     *
     * **Note:** JavaScript follows the IEEE-754 standard for resolving
     * floating-point values which can produce unexpected results.
     *
     * @static
     * @since 0.1.0
     * @memberOf _
     * @category Util
     * @param {number} [start=0] The start of the range.
     * @param {number} end The end of the range.
     * @param {number} [step=1] The value to increment or decrement by.
     * @returns {Array} Returns the range of numbers.
     * @see _.inRange, _.rangeRight
     * @example
     *
     * _.range(4);
     * // => [0, 1, 2, 3]
     *
     * _.range(-4);
     * // => [0, -1, -2, -3]
     *
     * _.range(1, 5);
     * // => [1, 2, 3, 4]
     *
     * _.range(0, 20, 5);
     * // => [0, 5, 10, 15]
     *
     * _.range(0, -4, -1);
     * // => [0, -1, -2, -3]
     *
     * _.range(1, 4, 0);
     * // => [1, 1, 1]
     *
     * _.range(0);
     * // => []
     */
    var range = createRange();

    /**
     * This method is like `_.range` except that it populates values in
     * descending order.
     *
     * @static
     * @memberOf _
     * @since 4.0.0
     * @category Util
     * @param {number} [start=0] The start of the range.
     * @param {number} end The end of the range.
     * @param {number} [step=1] The value to increment or decrement by.
     * @returns {Array} Returns the range of numbers.
     * @see _.inRange, _.range
     * @example
     *
     * _.rangeRight(4);
     * // => [3, 2, 1, 0]
     *
     * _.rangeRight(-4);
     * // => [-3, -2, -1, 0]
     *
     * _.rangeRight(1, 5);
     * // => [4, 3, 2, 1]
     *
     * _.rangeRight(0, 20, 5);
     * // => [15, 10, 5, 0]
     *
     * _.rangeRight(0, -4, -1);
     * // => [-3, -2, -1, 0]
     *
     * _.rangeRight(1, 4, 0);
     * // => [1, 1, 1]
     *
     * _.rangeRight(0);
     * // => []
     */
    var rangeRight = createRange(true);

    /**
     * This method returns a new empty array.
     *
     * @static
     * @memberOf _
     * @since 4.13.0
     * @category Util
     * @returns {Array} Returns the new empty array.
     * @example
     *
     * var arrays = _.times(2, _.stubArray);
     *
     * console.log(arrays);
     * // => [[], []]
     *
     * console.log(arrays[0] === arrays[1]);
     * // => false
     */
    function stubArray() {
      return [];
    }

    /**
     * This method returns `false`.
     *
     * @static
     * @memberOf _
     * @since 4.13.0
     * @category Util
     * @returns {boolean} Returns `false`.
     * @example
     *
     * _.times(2, _.stubFalse);
     * // => [false, false]
     */
    function stubFalse() {
      return false;
    }

    /**
     * This method returns a new empty object.
     *
     * @static
     * @memberOf _
     * @since 4.13.0
     * @category Util
     * @returns {Object} Returns the new empty object.
     * @example
     *
     * var objects = _.times(2, _.stubObject);
     *
     * console.log(objects);
     * // => [{}, {}]
     *
     * console.log(objects[0] === objects[1]);
     * // => false
     */
    function stubObject() {
      return {};
    }

    /**
     * This method returns an empty string.
     *
     * @static
     * @memberOf _
     * @since 4.13.0
     * @category Util
     * @returns {string} Returns the empty string.
     * @example
     *
     * _.times(2, _.stubString);
     * // => ['', '']
     */
    function stubString() {
      return '';
    }

    /**
     * This method returns `true`.
     *
     * @static
     * @memberOf _
     * @since 4.13.0
     * @category Util
     * @returns {boolean} Returns `true`.
     * @example
     *
     * _.times(2, _.stubTrue);
     * // => [true, true]
     */
    function stubTrue() {
      return true;
    }

    /**
     * Invokes the iteratee `n` times, returning an array of the results of
     * each invocation. The iteratee is invoked with one argument; (index).
     *
     * @static
     * @since 0.1.0
     * @memberOf _
     * @category Util
     * @param {number} n The number of times to invoke `iteratee`.
     * @param {Function} [iteratee=_.identity] The function invoked per iteration.
     * @returns {Array} Returns the array of results.
     * @example
     *
     * _.times(3, String);
     * // => ['0', '1', '2']
     *
     *  _.times(4, _.constant(0));
     * // => [0, 0, 0, 0]
     */
    function times(n, iteratee) {
      n = toInteger(n);
      if (n < 1 || n > MAX_SAFE_INTEGER) {
        return [];
      }
      var index = MAX_ARRAY_LENGTH,
          length = nativeMin(n, MAX_ARRAY_LENGTH);

      iteratee = getIteratee(iteratee);
      n -= MAX_ARRAY_LENGTH;

      var result = baseTimes(length, iteratee);
      while (++index < n) {
        iteratee(index);
      }
      return result;
    }

    /**
     * Converts `value` to a property path array.
     *
     * @static
     * @memberOf _
     * @since 4.0.0
     * @category Util
     * @param {*} value The value to convert.
     * @returns {Array} Returns the new property path array.
     * @example
     *
     * _.toPath('a.b.c');
     * // => ['a', 'b', 'c']
     *
     * _.toPath('a[0].b.c');
     * // => ['a', '0', 'b', 'c']
     */
    function toPath(value) {
      if (isArray(value)) {
        return arrayMap(value, toKey);
      }
      return isSymbol(value) ? [value] : copyArray(stringToPath(toString(value)));
    }

    /**
     * Generates a unique ID. If `prefix` is given, the ID is appended to it.
     *
     * @static
     * @since 0.1.0
     * @memberOf _
     * @category Util
     * @param {string} [prefix=''] The value to prefix the ID with.
     * @returns {string} Returns the unique ID.
     * @example
     *
     * _.uniqueId('contact_');
     * // => 'contact_104'
     *
     * _.uniqueId();
     * // => '105'
     */
    function uniqueId(prefix) {
      var id = ++idCounter;
      return toString(prefix) + id;
    }

    /*------------------------------------------------------------------------*/

    /**
     * Adds two numbers.
     *
     * @static
     * @memberOf _
     * @since 3.4.0
     * @category Math
     * @param {number} augend The first number in an addition.
     * @param {number} addend The second number in an addition.
     * @returns {number} Returns the total.
     * @example
     *
     * _.add(6, 4);
     * // => 10
     */
    var add = createMathOperation(function(augend, addend) {
      return augend + addend;
    }, 0);

    /**
     * Computes `number` rounded up to `precision`.
     *
     * @static
     * @memberOf _
     * @since 3.10.0
     * @category Math
     * @param {number} number The number to round up.
     * @param {number} [precision=0] The precision to round up to.
     * @returns {number} Returns the rounded up number.
     * @example
     *
     * _.ceil(4.006);
     * // => 5
     *
     * _.ceil(6.004, 2);
     * // => 6.01
     *
     * _.ceil(6040, -2);
     * // => 6100
     */
    var ceil = createRound('ceil');

    /**
     * Divide two numbers.
     *
     * @static
     * @memberOf _
     * @since 4.7.0
     * @category Math
     * @param {number} dividend The first number in a division.
     * @param {number} divisor The second number in a division.
     * @returns {number} Returns the quotient.
     * @example
     *
     * _.divide(6, 4);
     * // => 1.5
     */
    var divide = createMathOperation(function(dividend, divisor) {
      return dividend / divisor;
    }, 1);

    /**
     * Computes `number` rounded down to `precision`.
     *
     * @static
     * @memberOf _
     * @since 3.10.0
     * @category Math
     * @param {number} number The number to round down.
     * @param {number} [precision=0] The precision to round down to.
     * @returns {number} Returns the rounded down number.
     * @example
     *
     * _.floor(4.006);
     * // => 4
     *
     * _.floor(0.046, 2);
     * // => 0.04
     *
     * _.floor(4060, -2);
     * // => 4000
     */
    var floor = createRound('floor');

    /**
     * Computes the maximum value of `array`. If `array` is empty or falsey,
     * `undefined` is returned.
     *
     * @static
     * @since 0.1.0
     * @memberOf _
     * @category Math
     * @param {Array} array The array to iterate over.
     * @returns {*} Returns the maximum value.
     * @example
     *
     * _.max([4, 2, 8, 6]);
     * // => 8
     *
     * _.max([]);
     * // => undefined
     */
    function max(array) {
      return (array && array.length)
        ? baseExtremum(array, identity, baseGt)
        : undefined;
    }

    /**
     * This method is like `_.max` except that it accepts `iteratee` which is
     * invoked for each element in `array` to generate the criterion by which
     * the value is ranked. The iteratee is invoked with one argument: (value).
     *
     * @static
     * @memberOf _
     * @since 4.0.0
     * @category Math
     * @param {Array} array The array to iterate over.
     * @param {Function} [iteratee=_.identity] The iteratee invoked per element.
     * @returns {*} Returns the maximum value.
     * @example
     *
     * var objects = [{ 'n': 1 }, { 'n': 2 }];
     *
     * _.maxBy(objects, function(o) { return o.n; });
     * // => { 'n': 2 }
     *
     * // The `_.property` iteratee shorthand.
     * _.maxBy(objects, 'n');
     * // => { 'n': 2 }
     */
    function maxBy(array, iteratee) {
      return (array && array.length)
        ? baseExtremum(array, getIteratee(iteratee, 2), baseGt)
        : undefined;
    }

    /**
     * Computes the mean of the values in `array`.
     *
     * @static
     * @memberOf _
     * @since 4.0.0
     * @category Math
     * @param {Array} array The array to iterate over.
     * @returns {number} Returns the mean.
     * @example
     *
     * _.mean([4, 2, 8, 6]);
     * // => 5
     */
    function mean(array) {
      return baseMean(array, identity);
    }

    /**
     * This method is like `_.mean` except that it accepts `iteratee` which is
     * invoked for each element in `array` to generate the value to be averaged.
     * The iteratee is invoked with one argument: (value).
     *
     * @static
     * @memberOf _
     * @since 4.7.0
     * @category Math
     * @param {Array} array The array to iterate over.
     * @param {Function} [iteratee=_.identity] The iteratee invoked per element.
     * @returns {number} Returns the mean.
     * @example
     *
     * var objects = [{ 'n': 4 }, { 'n': 2 }, { 'n': 8 }, { 'n': 6 }];
     *
     * _.meanBy(objects, function(o) { return o.n; });
     * // => 5
     *
     * // The `_.property` iteratee shorthand.
     * _.meanBy(objects, 'n');
     * // => 5
     */
    function meanBy(array, iteratee) {
      return baseMean(array, getIteratee(iteratee, 2));
    }

    /**
     * Computes the minimum value of `array`. If `array` is empty or falsey,
     * `undefined` is returned.
     *
     * @static
     * @since 0.1.0
     * @memberOf _
     * @category Math
     * @param {Array} array The array to iterate over.
     * @returns {*} Returns the minimum value.
     * @example
     *
     * _.min([4, 2, 8, 6]);
     * // => 2
     *
     * _.min([]);
     * // => undefined
     */
    function min(array) {
      return (array && array.length)
        ? baseExtremum(array, identity, baseLt)
        : undefined;
    }

    /**
     * This method is like `_.min` except that it accepts `iteratee` which is
     * invoked for each element in `array` to generate the criterion by which
     * the value is ranked. The iteratee is invoked with one argument: (value).
     *
     * @static
     * @memberOf _
     * @since 4.0.0
     * @category Math
     * @param {Array} array The array to iterate over.
     * @param {Function} [iteratee=_.identity] The iteratee invoked per element.
     * @returns {*} Returns the minimum value.
     * @example
     *
     * var objects = [{ 'n': 1 }, { 'n': 2 }];
     *
     * _.minBy(objects, function(o) { return o.n; });
     * // => { 'n': 1 }
     *
     * // The `_.property` iteratee shorthand.
     * _.minBy(objects, 'n');
     * // => { 'n': 1 }
     */
    function minBy(array, iteratee) {
      return (array && array.length)
        ? baseExtremum(array, getIteratee(iteratee, 2), baseLt)
        : undefined;
    }

    /**
     * Multiply two numbers.
     *
     * @static
     * @memberOf _
     * @since 4.7.0
     * @category Math
     * @param {number} multiplier The first number in a multiplication.
     * @param {number} multiplicand The second number in a multiplication.
     * @returns {number} Returns the product.
     * @example
     *
     * _.multiply(6, 4);
     * // => 24
     */
    var multiply = createMathOperation(function(multiplier, multiplicand) {
      return multiplier * multiplicand;
    }, 1);

    /**
     * Computes `number` rounded to `precision`.
     *
     * @static
     * @memberOf _
     * @since 3.10.0
     * @category Math
     * @param {number} number The number to round.
     * @param {number} [precision=0] The precision to round to.
     * @returns {number} Returns the rounded number.
     * @example
     *
     * _.round(4.006);
     * // => 4
     *
     * _.round(4.006, 2);
     * // => 4.01
     *
     * _.round(4060, -2);
     * // => 4100
     */
    var round = createRound('round');

    /**
     * Subtract two numbers.
     *
     * @static
     * @memberOf _
     * @since 4.0.0
     * @category Math
     * @param {number} minuend The first number in a subtraction.
     * @param {number} subtrahend The second number in a subtraction.
     * @returns {number} Returns the difference.
     * @example
     *
     * _.subtract(6, 4);
     * // => 2
     */
    var subtract = createMathOperation(function(minuend, subtrahend) {
      return minuend - subtrahend;
    }, 0);

    /**
     * Computes the sum of the values in `array`.
     *
     * @static
     * @memberOf _
     * @since 3.4.0
     * @category Math
     * @param {Array} array The array to iterate over.
     * @returns {number} Returns the sum.
     * @example
     *
     * _.sum([4, 2, 8, 6]);
     * // => 20
     */
    function sum(array) {
      return (array && array.length)
        ? baseSum(array, identity)
        : 0;
    }

    /**
     * This method is like `_.sum` except that it accepts `iteratee` which is
     * invoked for each element in `array` to generate the value to be summed.
     * The iteratee is invoked with one argument: (value).
     *
     * @static
     * @memberOf _
     * @since 4.0.0
     * @category Math
     * @param {Array} array The array to iterate over.
     * @param {Function} [iteratee=_.identity] The iteratee invoked per element.
     * @returns {number} Returns the sum.
     * @example
     *
     * var objects = [{ 'n': 4 }, { 'n': 2 }, { 'n': 8 }, { 'n': 6 }];
     *
     * _.sumBy(objects, function(o) { return o.n; });
     * // => 20
     *
     * // The `_.property` iteratee shorthand.
     * _.sumBy(objects, 'n');
     * // => 20
     */
    function sumBy(array, iteratee) {
      return (array && array.length)
        ? baseSum(array, getIteratee(iteratee, 2))
        : 0;
    }

    /*------------------------------------------------------------------------*/

    // Add methods that return wrapped values in chain sequences.
    lodash.after = after;
    lodash.ary = ary;
    lodash.assign = assign;
    lodash.assignIn = assignIn;
    lodash.assignInWith = assignInWith;
    lodash.assignWith = assignWith;
    lodash.at = at;
    lodash.before = before;
    lodash.bind = bind;
    lodash.bindAll = bindAll;
    lodash.bindKey = bindKey;
    lodash.castArray = castArray;
    lodash.chain = chain;
    lodash.chunk = chunk;
    lodash.compact = compact;
    lodash.concat = concat;
    lodash.cond = cond;
    lodash.conforms = conforms;
    lodash.constant = constant;
    lodash.countBy = countBy;
    lodash.create = create;
    lodash.curry = curry;
    lodash.curryRight = curryRight;
    lodash.debounce = debounce;
    lodash.defaults = defaults;
    lodash.defaultsDeep = defaultsDeep;
    lodash.defer = defer;
    lodash.delay = delay;
    lodash.difference = difference;
    lodash.differenceBy = differenceBy;
    lodash.differenceWith = differenceWith;
    lodash.drop = drop;
    lodash.dropRight = dropRight;
    lodash.dropRightWhile = dropRightWhile;
    lodash.dropWhile = dropWhile;
    lodash.fill = fill;
    lodash.filter = filter;
    lodash.flatMap = flatMap;
    lodash.flatMapDeep = flatMapDeep;
    lodash.flatMapDepth = flatMapDepth;
    lodash.flatten = flatten;
    lodash.flattenDeep = flattenDeep;
    lodash.flattenDepth = flattenDepth;
    lodash.flip = flip;
    lodash.flow = flow;
    lodash.flowRight = flowRight;
    lodash.fromPairs = fromPairs;
    lodash.functions = functions;
    lodash.functionsIn = functionsIn;
    lodash.groupBy = groupBy;
    lodash.initial = initial;
    lodash.intersection = intersection;
    lodash.intersectionBy = intersectionBy;
    lodash.intersectionWith = intersectionWith;
    lodash.invert = invert;
    lodash.invertBy = invertBy;
    lodash.invokeMap = invokeMap;
    lodash.iteratee = iteratee;
    lodash.keyBy = keyBy;
    lodash.keys = keys;
    lodash.keysIn = keysIn;
    lodash.map = map;
    lodash.mapKeys = mapKeys;
    lodash.mapValues = mapValues;
    lodash.matches = matches;
    lodash.matchesProperty = matchesProperty;
    lodash.memoize = memoize;
    lodash.merge = merge;
    lodash.mergeWith = mergeWith;
    lodash.method = method;
    lodash.methodOf = methodOf;
    lodash.mixin = mixin;
    lodash.negate = negate;
    lodash.nthArg = nthArg;
    lodash.omit = omit;
    lodash.omitBy = omitBy;
    lodash.once = once;
    lodash.orderBy = orderBy;
    lodash.over = over;
    lodash.overArgs = overArgs;
    lodash.overEvery = overEvery;
    lodash.overSome = overSome;
    lodash.partial = partial;
    lodash.partialRight = partialRight;
    lodash.partition = partition;
    lodash.pick = pick;
    lodash.pickBy = pickBy;
    lodash.property = property;
    lodash.propertyOf = propertyOf;
    lodash.pull = pull;
    lodash.pullAll = pullAll;
    lodash.pullAllBy = pullAllBy;
    lodash.pullAllWith = pullAllWith;
    lodash.pullAt = pullAt;
    lodash.range = range;
    lodash.rangeRight = rangeRight;
    lodash.rearg = rearg;
    lodash.reject = reject;
    lodash.remove = remove;
    lodash.rest = rest;
    lodash.reverse = reverse;
    lodash.sampleSize = sampleSize;
    lodash.set = set;
    lodash.setWith = setWith;
    lodash.shuffle = shuffle;
    lodash.slice = slice;
    lodash.sortBy = sortBy;
    lodash.sortedUniq = sortedUniq;
    lodash.sortedUniqBy = sortedUniqBy;
    lodash.split = split;
    lodash.spread = spread;
    lodash.tail = tail;
    lodash.take = take;
    lodash.takeRight = takeRight;
    lodash.takeRightWhile = takeRightWhile;
    lodash.takeWhile = takeWhile;
    lodash.tap = tap;
    lodash.throttle = throttle;
    lodash.thru = thru;
    lodash.toArray = toArray;
    lodash.toPairs = toPairs;
    lodash.toPairsIn = toPairsIn;
    lodash.toPath = toPath;
    lodash.toPlainObject = toPlainObject;
    lodash.transform = transform;
    lodash.unary = unary;
    lodash.union = union;
    lodash.unionBy = unionBy;
    lodash.unionWith = unionWith;
    lodash.uniq = uniq;
    lodash.uniqBy = uniqBy;
    lodash.uniqWith = uniqWith;
    lodash.unset = unset;
    lodash.unzip = unzip;
    lodash.unzipWith = unzipWith;
    lodash.update = update;
    lodash.updateWith = updateWith;
    lodash.values = values;
    lodash.valuesIn = valuesIn;
    lodash.without = without;
    lodash.words = words;
    lodash.wrap = wrap;
    lodash.xor = xor;
    lodash.xorBy = xorBy;
    lodash.xorWith = xorWith;
    lodash.zip = zip;
    lodash.zipObject = zipObject;
    lodash.zipObjectDeep = zipObjectDeep;
    lodash.zipWith = zipWith;

    // Add aliases.
    lodash.entries = toPairs;
    lodash.entriesIn = toPairsIn;
    lodash.extend = assignIn;
    lodash.extendWith = assignInWith;

    // Add methods to `lodash.prototype`.
    mixin(lodash, lodash);

    /*------------------------------------------------------------------------*/

    // Add methods that return unwrapped values in chain sequences.
    lodash.add = add;
    lodash.attempt = attempt;
    lodash.camelCase = camelCase;
    lodash.capitalize = capitalize;
    lodash.ceil = ceil;
    lodash.clamp = clamp;
    lodash.clone = clone;
    lodash.cloneDeep = cloneDeep;
    lodash.cloneDeepWith = cloneDeepWith;
    lodash.cloneWith = cloneWith;
    lodash.conformsTo = conformsTo;
    lodash.deburr = deburr;
    lodash.defaultTo = defaultTo;
    lodash.divide = divide;
    lodash.endsWith = endsWith;
    lodash.eq = eq;
    lodash.escape = escape;
    lodash.escapeRegExp = escapeRegExp;
    lodash.every = every;
    lodash.find = find;
    lodash.findIndex = findIndex;
    lodash.findKey = findKey;
    lodash.findLast = findLast;
    lodash.findLastIndex = findLastIndex;
    lodash.findLastKey = findLastKey;
    lodash.floor = floor;
    lodash.forEach = forEach;
    lodash.forEachRight = forEachRight;
    lodash.forIn = forIn;
    lodash.forInRight = forInRight;
    lodash.forOwn = forOwn;
    lodash.forOwnRight = forOwnRight;
    lodash.get = get;
    lodash.gt = gt;
    lodash.gte = gte;
    lodash.has = has;
    lodash.hasIn = hasIn;
    lodash.head = head;
    lodash.identity = identity;
    lodash.includes = includes;
    lodash.indexOf = indexOf;
    lodash.inRange = inRange;
    lodash.invoke = invoke;
    lodash.isArguments = isArguments;
    lodash.isArray = isArray;
    lodash.isArrayBuffer = isArrayBuffer;
    lodash.isArrayLike = isArrayLike;
    lodash.isArrayLikeObject = isArrayLikeObject;
    lodash.isBoolean = isBoolean;
    lodash.isBuffer = isBuffer;
    lodash.isDate = isDate;
    lodash.isElement = isElement;
    lodash.isEmpty = isEmpty;
    lodash.isEqual = isEqual;
    lodash.isEqualWith = isEqualWith;
    lodash.isError = isError;
    lodash.isFinite = isFinite;
    lodash.isFunction = isFunction;
    lodash.isInteger = isInteger;
    lodash.isLength = isLength;
    lodash.isMap = isMap;
    lodash.isMatch = isMatch;
    lodash.isMatchWith = isMatchWith;
    lodash.isNaN = isNaN;
    lodash.isNative = isNative;
    lodash.isNil = isNil;
    lodash.isNull = isNull;
    lodash.isNumber = isNumber;
    lodash.isObject = isObject;
    lodash.isObjectLike = isObjectLike;
    lodash.isPlainObject = isPlainObject;
    lodash.isRegExp = isRegExp;
    lodash.isSafeInteger = isSafeInteger;
    lodash.isSet = isSet;
    lodash.isString = isString;
    lodash.isSymbol = isSymbol;
    lodash.isTypedArray = isTypedArray;
    lodash.isUndefined = isUndefined;
    lodash.isWeakMap = isWeakMap;
    lodash.isWeakSet = isWeakSet;
    lodash.join = join;
    lodash.kebabCase = kebabCase;
    lodash.last = last;
    lodash.lastIndexOf = lastIndexOf;
    lodash.lowerCase = lowerCase;
    lodash.lowerFirst = lowerFirst;
    lodash.lt = lt;
    lodash.lte = lte;
    lodash.max = max;
    lodash.maxBy = maxBy;
    lodash.mean = mean;
    lodash.meanBy = meanBy;
    lodash.min = min;
    lodash.minBy = minBy;
    lodash.stubArray = stubArray;
    lodash.stubFalse = stubFalse;
    lodash.stubObject = stubObject;
    lodash.stubString = stubString;
    lodash.stubTrue = stubTrue;
    lodash.multiply = multiply;
    lodash.nth = nth;
    lodash.noConflict = noConflict;
    lodash.noop = noop;
    lodash.now = now;
    lodash.pad = pad;
    lodash.padEnd = padEnd;
    lodash.padStart = padStart;
    lodash.parseInt = parseInt;
    lodash.random = random;
    lodash.reduce = reduce;
    lodash.reduceRight = reduceRight;
    lodash.repeat = repeat;
    lodash.replace = replace;
    lodash.result = result;
    lodash.round = round;
    lodash.runInContext = runInContext;
    lodash.sample = sample;
    lodash.size = size;
    lodash.snakeCase = snakeCase;
    lodash.some = some;
    lodash.sortedIndex = sortedIndex;
    lodash.sortedIndexBy = sortedIndexBy;
    lodash.sortedIndexOf = sortedIndexOf;
    lodash.sortedLastIndex = sortedLastIndex;
    lodash.sortedLastIndexBy = sortedLastIndexBy;
    lodash.sortedLastIndexOf = sortedLastIndexOf;
    lodash.startCase = startCase;
    lodash.startsWith = startsWith;
    lodash.subtract = subtract;
    lodash.sum = sum;
    lodash.sumBy = sumBy;
    lodash.template = template;
    lodash.times = times;
    lodash.toFinite = toFinite;
    lodash.toInteger = toInteger;
    lodash.toLength = toLength;
    lodash.toLower = toLower;
    lodash.toNumber = toNumber;
    lodash.toSafeInteger = toSafeInteger;
    lodash.toString = toString;
    lodash.toUpper = toUpper;
    lodash.trim = trim;
    lodash.trimEnd = trimEnd;
    lodash.trimStart = trimStart;
    lodash.truncate = truncate;
    lodash.unescape = unescape;
    lodash.uniqueId = uniqueId;
    lodash.upperCase = upperCase;
    lodash.upperFirst = upperFirst;

    // Add aliases.
    lodash.each = forEach;
    lodash.eachRight = forEachRight;
    lodash.first = head;

    mixin(lodash, (function() {
      var source = {};
      baseForOwn(lodash, function(func, methodName) {
        if (!hasOwnProperty.call(lodash.prototype, methodName)) {
          source[methodName] = func;
        }
      });
      return source;
    }()), { 'chain': false });

    /*------------------------------------------------------------------------*/

    /**
     * The semantic version number.
     *
     * @static
     * @memberOf _
     * @type {string}
     */
    lodash.VERSION = VERSION;

    // Assign default placeholders.
    arrayEach(['bind', 'bindKey', 'curry', 'curryRight', 'partial', 'partialRight'], function(methodName) {
      lodash[methodName].placeholder = lodash;
    });

    // Add `LazyWrapper` methods for `_.drop` and `_.take` variants.
    arrayEach(['drop', 'take'], function(methodName, index) {
      LazyWrapper.prototype[methodName] = function(n) {
        n = n === undefined ? 1 : nativeMax(toInteger(n), 0);

        var result = (this.__filtered__ && !index)
          ? new LazyWrapper(this)
          : this.clone();

        if (result.__filtered__) {
          result.__takeCount__ = nativeMin(n, result.__takeCount__);
        } else {
          result.__views__.push({
            'size': nativeMin(n, MAX_ARRAY_LENGTH),
            'type': methodName + (result.__dir__ < 0 ? 'Right' : '')
          });
        }
        return result;
      };

      LazyWrapper.prototype[methodName + 'Right'] = function(n) {
        return this.reverse()[methodName](n).reverse();
      };
    });

    // Add `LazyWrapper` methods that accept an `iteratee` value.
    arrayEach(['filter', 'map', 'takeWhile'], function(methodName, index) {
      var type = index + 1,
          isFilter = type == LAZY_FILTER_FLAG || type == LAZY_WHILE_FLAG;

      LazyWrapper.prototype[methodName] = function(iteratee) {
        var result = this.clone();
        result.__iteratees__.push({
          'iteratee': getIteratee(iteratee, 3),
          'type': type
        });
        result.__filtered__ = result.__filtered__ || isFilter;
        return result;
      };
    });

    // Add `LazyWrapper` methods for `_.head` and `_.last`.
    arrayEach(['head', 'last'], function(methodName, index) {
      var takeName = 'take' + (index ? 'Right' : '');

      LazyWrapper.prototype[methodName] = function() {
        return this[takeName](1).value()[0];
      };
    });

    // Add `LazyWrapper` methods for `_.initial` and `_.tail`.
    arrayEach(['initial', 'tail'], function(methodName, index) {
      var dropName = 'drop' + (index ? '' : 'Right');

      LazyWrapper.prototype[methodName] = function() {
        return this.__filtered__ ? new LazyWrapper(this) : this[dropName](1);
      };
    });

    LazyWrapper.prototype.compact = function() {
      return this.filter(identity);
    };

    LazyWrapper.prototype.find = function(predicate) {
      return this.filter(predicate).head();
    };

    LazyWrapper.prototype.findLast = function(predicate) {
      return this.reverse().find(predicate);
    };

    LazyWrapper.prototype.invokeMap = baseRest(function(path, args) {
      if (typeof path == 'function') {
        return new LazyWrapper(this);
      }
      return this.map(function(value) {
        return baseInvoke(value, path, args);
      });
    });

    LazyWrapper.prototype.reject = function(predicate) {
      return this.filter(negate(getIteratee(predicate)));
    };

    LazyWrapper.prototype.slice = function(start, end) {
      start = toInteger(start);

      var result = this;
      if (result.__filtered__ && (start > 0 || end < 0)) {
        return new LazyWrapper(result);
      }
      if (start < 0) {
        result = result.takeRight(-start);
      } else if (start) {
        result = result.drop(start);
      }
      if (end !== undefined) {
        end = toInteger(end);
        result = end < 0 ? result.dropRight(-end) : result.take(end - start);
      }
      return result;
    };

    LazyWrapper.prototype.takeRightWhile = function(predicate) {
      return this.reverse().takeWhile(predicate).reverse();
    };

    LazyWrapper.prototype.toArray = function() {
      return this.take(MAX_ARRAY_LENGTH);
    };

    // Add `LazyWrapper` methods to `lodash.prototype`.
    baseForOwn(LazyWrapper.prototype, function(func, methodName) {
      var checkIteratee = /^(?:filter|find|map|reject)|While$/.test(methodName),
          isTaker = /^(?:head|last)$/.test(methodName),
          lodashFunc = lodash[isTaker ? ('take' + (methodName == 'last' ? 'Right' : '')) : methodName],
          retUnwrapped = isTaker || /^find/.test(methodName);

      if (!lodashFunc) {
        return;
      }
      lodash.prototype[methodName] = function() {
        var value = this.__wrapped__,
            args = isTaker ? [1] : arguments,
            isLazy = value instanceof LazyWrapper,
            iteratee = args[0],
            useLazy = isLazy || isArray(value);

        var interceptor = function(value) {
          var result = lodashFunc.apply(lodash, arrayPush([value], args));
          return (isTaker && chainAll) ? result[0] : result;
        };

        if (useLazy && checkIteratee && typeof iteratee == 'function' && iteratee.length != 1) {
          // Avoid lazy use if the iteratee has a "length" value other than `1`.
          isLazy = useLazy = false;
        }
        var chainAll = this.__chain__,
            isHybrid = !!this.__actions__.length,
            isUnwrapped = retUnwrapped && !chainAll,
            onlyLazy = isLazy && !isHybrid;

        if (!retUnwrapped && useLazy) {
          value = onlyLazy ? value : new LazyWrapper(this);
          var result = func.apply(value, args);
          result.__actions__.push({ 'func': thru, 'args': [interceptor], 'thisArg': undefined });
          return new LodashWrapper(result, chainAll);
        }
        if (isUnwrapped && onlyLazy) {
          return func.apply(this, args);
        }
        result = this.thru(interceptor);
        return isUnwrapped ? (isTaker ? result.value()[0] : result.value()) : result;
      };
    });

    // Add `Array` methods to `lodash.prototype`.
    arrayEach(['pop', 'push', 'shift', 'sort', 'splice', 'unshift'], function(methodName) {
      var func = arrayProto[methodName],
          chainName = /^(?:push|sort|unshift)$/.test(methodName) ? 'tap' : 'thru',
          retUnwrapped = /^(?:pop|shift)$/.test(methodName);

      lodash.prototype[methodName] = function() {
        var args = arguments;
        if (retUnwrapped && !this.__chain__) {
          var value = this.value();
          return func.apply(isArray(value) ? value : [], args);
        }
        return this[chainName](function(value) {
          return func.apply(isArray(value) ? value : [], args);
        });
      };
    });

    // Map minified method names to their real names.
    baseForOwn(LazyWrapper.prototype, function(func, methodName) {
      var lodashFunc = lodash[methodName];
      if (lodashFunc) {
        var key = lodashFunc.name + '';
        if (!hasOwnProperty.call(realNames, key)) {
          realNames[key] = [];
        }
        realNames[key].push({ 'name': methodName, 'func': lodashFunc });
      }
    });

    realNames[createHybrid(undefined, WRAP_BIND_KEY_FLAG).name] = [{
      'name': 'wrapper',
      'func': undefined
    }];

    // Add methods to `LazyWrapper`.
    LazyWrapper.prototype.clone = lazyClone;
    LazyWrapper.prototype.reverse = lazyReverse;
    LazyWrapper.prototype.value = lazyValue;

    // Add chain sequence methods to the `lodash` wrapper.
    lodash.prototype.at = wrapperAt;
    lodash.prototype.chain = wrapperChain;
    lodash.prototype.commit = wrapperCommit;
    lodash.prototype.next = wrapperNext;
    lodash.prototype.plant = wrapperPlant;
    lodash.prototype.reverse = wrapperReverse;
    lodash.prototype.toJSON = lodash.prototype.valueOf = lodash.prototype.value = wrapperValue;

    // Add lazy aliases.
    lodash.prototype.first = lodash.prototype.head;

    if (symIterator) {
      lodash.prototype[symIterator] = wrapperToIterator;
    }
    return lodash;
  });

  /*--------------------------------------------------------------------------*/

  // Export lodash.
  var _ = runInContext();

  // Some AMD build optimizers, like r.js, check for condition patterns like:
  if (true) {
    // Expose Lodash on the global object to prevent errors when Lodash is
    // loaded by a script tag in the presence of an AMD loader.
    // See http://requirejs.org/docs/errors.html#mismatch for more details.
    // Use `_.noConflict` to remove Lodash from the global object.
    root._ = _;

    // Define as an anonymous module so, through path mapping, it can be
    // referenced as the "underscore" module.
    !(__WEBPACK_AMD_DEFINE_RESULT__ = (function() {
      return _;
    }).call(exports, __webpack_require__, exports, module),
				__WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__));
  }
  // Check for `exports` after `define` in case a build optimizer adds it.
  else if (freeModule) {
    // Export for Node.js.
    (freeModule.exports = _)._ = _;
    // Export for CommonJS support.
    freeExports._ = _;
  }
  else {
    // Export to the global object.
    root._ = _;
  }
}.call(this));

/* WEBPACK VAR INJECTION */}.call(exports, __webpack_require__(0), __webpack_require__(6)(module)))

/***/ }),
/* 6 */
/***/ (function(module, exports) {

module.exports = function(module) {
	if(!module.webpackPolyfill) {
		module.deprecate = function() {};
		module.paths = [];
		// module.parent = undefined by default
		if(!module.children) module.children = [];
		Object.defineProperty(module, "loaded", {
			enumerable: true,
			get: function() {
				return module.l;
			}
		});
		Object.defineProperty(module, "id", {
			enumerable: true,
			get: function() {
				return module.i;
			}
		});
		module.webpackPolyfill = 1;
	}
	return module;
};


/***/ }),
/* 7 */
/***/ (function(module, exports, __webpack_require__) {

/* WEBPACK VAR INJECTION */(function(global) {var require;var require;/**
* plotly.js v1.54.1
* Copyright 2012-2020, Plotly, Inc.
* All rights reserved.
* Licensed under the MIT license
*/
!function(t){if(true)module.exports=t();else if("function"==typeof define&&define.amd)define([],t);else{("undefined"!=typeof window?window:"undefined"!=typeof global?global:"undefined"!=typeof self?self:this).Plotly=t()}}((function(){return function t(e,r,n){function a(o,s){if(!r[o]){if(!e[o]){var l="function"==typeof require&&require;if(!s&&l)return require(o,!0);if(i)return i(o,!0);var c=new Error("Cannot find module '"+o+"'");throw c.code="MODULE_NOT_FOUND",c}var u=r[o]={exports:{}};e[o][0].call(u.exports,(function(t){return a(e[o][1][t]||t)}),u,u.exports,t,e,r,n)}return r[o].exports}for(var i="function"==typeof require&&require,o=0;o<n.length;o++)a(n[o]);return a}({1:[function(t,e,r){"use strict";var n=t("../src/lib"),a={"X,X div":"direction:ltr;font-family:'Open Sans', verdana, arial, sans-serif;margin:0;padding:0;","X input,X button":"font-family:'Open Sans', verdana, arial, sans-serif;","X input:focus,X button:focus":"outline:none;","X a":"text-decoration:none;","X a:hover":"text-decoration:none;","X .crisp":"shape-rendering:crispEdges;","X .user-select-none":"-webkit-user-select:none;-moz-user-select:none;-ms-user-select:none;-o-user-select:none;user-select:none;","X svg":"overflow:hidden;","X svg a":"fill:#447adb;","X svg a:hover":"fill:#3c6dc5;","X .main-svg":"position:absolute;top:0;left:0;pointer-events:none;","X .main-svg .draglayer":"pointer-events:all;","X .cursor-default":"cursor:default;","X .cursor-pointer":"cursor:pointer;","X .cursor-crosshair":"cursor:crosshair;","X .cursor-move":"cursor:move;","X .cursor-col-resize":"cursor:col-resize;","X .cursor-row-resize":"cursor:row-resize;","X .cursor-ns-resize":"cursor:ns-resize;","X .cursor-ew-resize":"cursor:ew-resize;","X .cursor-sw-resize":"cursor:sw-resize;","X .cursor-s-resize":"cursor:s-resize;","X .cursor-se-resize":"cursor:se-resize;","X .cursor-w-resize":"cursor:w-resize;","X .cursor-e-resize":"cursor:e-resize;","X .cursor-nw-resize":"cursor:nw-resize;","X .cursor-n-resize":"cursor:n-resize;","X .cursor-ne-resize":"cursor:ne-resize;","X .cursor-grab":"cursor:-webkit-grab;cursor:grab;","X .modebar":"position:absolute;top:2px;right:2px;","X .ease-bg":"-webkit-transition:background-color 0.3s ease 0s;-moz-transition:background-color 0.3s ease 0s;-ms-transition:background-color 0.3s ease 0s;-o-transition:background-color 0.3s ease 0s;transition:background-color 0.3s ease 0s;","X .modebar--hover>:not(.watermark)":"opacity:0;-webkit-transition:opacity 0.3s ease 0s;-moz-transition:opacity 0.3s ease 0s;-ms-transition:opacity 0.3s ease 0s;-o-transition:opacity 0.3s ease 0s;transition:opacity 0.3s ease 0s;","X:hover .modebar--hover .modebar-group":"opacity:1;","X .modebar-group":"float:left;display:inline-block;box-sizing:border-box;padding-left:8px;position:relative;vertical-align:middle;white-space:nowrap;","X .modebar-btn":"position:relative;font-size:16px;padding:3px 4px;height:22px;cursor:pointer;line-height:normal;box-sizing:border-box;","X .modebar-btn svg":"position:relative;top:2px;","X .modebar.vertical":"display:flex;flex-direction:column;flex-wrap:wrap;align-content:flex-end;max-height:100%;","X .modebar.vertical svg":"top:-1px;","X .modebar.vertical .modebar-group":"display:block;float:none;padding-left:0px;padding-bottom:8px;","X .modebar.vertical .modebar-group .modebar-btn":"display:block;text-align:center;","X [data-title]:before,X [data-title]:after":"position:absolute;-webkit-transform:translate3d(0, 0, 0);-moz-transform:translate3d(0, 0, 0);-ms-transform:translate3d(0, 0, 0);-o-transform:translate3d(0, 0, 0);transform:translate3d(0, 0, 0);display:none;opacity:0;z-index:1001;pointer-events:none;top:110%;right:50%;","X [data-title]:hover:before,X [data-title]:hover:after":"display:block;opacity:1;","X [data-title]:before":"content:'';position:absolute;background:transparent;border:6px solid transparent;z-index:1002;margin-top:-12px;border-bottom-color:#69738a;margin-right:-6px;","X [data-title]:after":"content:attr(data-title);background:#69738a;color:white;padding:8px 10px;font-size:12px;line-height:12px;white-space:nowrap;margin-right:-18px;border-radius:2px;","X .vertical [data-title]:before,X .vertical [data-title]:after":"top:0%;right:200%;","X .vertical [data-title]:before":"border:6px solid transparent;border-left-color:#69738a;margin-top:8px;margin-right:-30px;","X .select-outline":"fill:none;stroke-width:1;shape-rendering:crispEdges;","X .select-outline-1":"stroke:white;","X .select-outline-2":"stroke:black;stroke-dasharray:2px 2px;",Y:"font-family:'Open Sans', verdana, arial, sans-serif;position:fixed;top:50px;right:20px;z-index:10000;font-size:10pt;max-width:180px;","Y p":"margin:0;","Y .notifier-note":"min-width:180px;max-width:250px;border:1px solid #fff;z-index:3000;margin:0;background-color:#8c97af;background-color:rgba(140,151,175,0.9);color:#fff;padding:10px;overflow-wrap:break-word;word-wrap:break-word;-ms-hyphens:auto;-webkit-hyphens:auto;hyphens:auto;","Y .notifier-close":"color:#fff;opacity:0.8;float:right;padding:0 5px;background:none;border:none;font-size:20px;font-weight:bold;line-height:20px;","Y .notifier-close:hover":"color:#444;text-decoration:none;cursor:pointer;"};for(var i in a){var o=i.replace(/^,/," ,").replace(/X/g,".js-plotly-plot .plotly").replace(/Y/g,".plotly-notifier");n.addStyleRule(o,a[i])}},{"../src/lib":735}],2:[function(t,e,r){"use strict";e.exports=t("../src/transforms/aggregate")},{"../src/transforms/aggregate":1317}],3:[function(t,e,r){"use strict";e.exports=t("../src/traces/bar")},{"../src/traces/bar":884}],4:[function(t,e,r){"use strict";e.exports=t("../src/traces/barpolar")},{"../src/traces/barpolar":897}],5:[function(t,e,r){"use strict";e.exports=t("../src/traces/box")},{"../src/traces/box":907}],6:[function(t,e,r){"use strict";e.exports=t("../src/components/calendars")},{"../src/components/calendars":600}],7:[function(t,e,r){"use strict";e.exports=t("../src/traces/candlestick")},{"../src/traces/candlestick":916}],8:[function(t,e,r){"use strict";e.exports=t("../src/traces/carpet")},{"../src/traces/carpet":935}],9:[function(t,e,r){"use strict";e.exports=t("../src/traces/choropleth")},{"../src/traces/choropleth":949}],10:[function(t,e,r){"use strict";e.exports=t("../src/traces/choroplethmapbox")},{"../src/traces/choroplethmapbox":956}],11:[function(t,e,r){"use strict";e.exports=t("../src/traces/cone")},{"../src/traces/cone":962}],12:[function(t,e,r){"use strict";e.exports=t("../src/traces/contour")},{"../src/traces/contour":977}],13:[function(t,e,r){"use strict";e.exports=t("../src/traces/contourcarpet")},{"../src/traces/contourcarpet":988}],14:[function(t,e,r){"use strict";e.exports=t("../src/core")},{"../src/core":713}],15:[function(t,e,r){"use strict";e.exports=t("../src/traces/densitymapbox")},{"../src/traces/densitymapbox":996}],16:[function(t,e,r){"use strict";e.exports=t("../src/transforms/filter")},{"../src/transforms/filter":1318}],17:[function(t,e,r){"use strict";e.exports=t("../src/traces/funnel")},{"../src/traces/funnel":1006}],18:[function(t,e,r){"use strict";e.exports=t("../src/traces/funnelarea")},{"../src/traces/funnelarea":1015}],19:[function(t,e,r){"use strict";e.exports=t("../src/transforms/groupby")},{"../src/transforms/groupby":1319}],20:[function(t,e,r){"use strict";e.exports=t("../src/traces/heatmap")},{"../src/traces/heatmap":1028}],21:[function(t,e,r){"use strict";e.exports=t("../src/traces/heatmapgl")},{"../src/traces/heatmapgl":1037}],22:[function(t,e,r){"use strict";e.exports=t("../src/traces/histogram")},{"../src/traces/histogram":1049}],23:[function(t,e,r){"use strict";e.exports=t("../src/traces/histogram2d")},{"../src/traces/histogram2d":1055}],24:[function(t,e,r){"use strict";e.exports=t("../src/traces/histogram2dcontour")},{"../src/traces/histogram2dcontour":1059}],25:[function(t,e,r){"use strict";e.exports=t("../src/traces/image")},{"../src/traces/image":1066}],26:[function(t,e,r){"use strict";var n=t("./core");n.register([t("./bar"),t("./box"),t("./heatmap"),t("./histogram"),t("./histogram2d"),t("./histogram2dcontour"),t("./contour"),t("./scatterternary"),t("./violin"),t("./funnel"),t("./waterfall"),t("./image"),t("./pie"),t("./sunburst"),t("./treemap"),t("./funnelarea"),t("./scatter3d"),t("./surface"),t("./isosurface"),t("./volume"),t("./mesh3d"),t("./cone"),t("./streamtube"),t("./scattergeo"),t("./choropleth"),t("./scattergl"),t("./splom"),t("./pointcloud"),t("./heatmapgl"),t("./parcoords"),t("./parcats"),t("./scattermapbox"),t("./choroplethmapbox"),t("./densitymapbox"),t("./sankey"),t("./indicator"),t("./table"),t("./carpet"),t("./scattercarpet"),t("./contourcarpet"),t("./ohlc"),t("./candlestick"),t("./scatterpolar"),t("./scatterpolargl"),t("./barpolar")]),n.register([t("./aggregate"),t("./filter"),t("./groupby"),t("./sort")]),n.register([t("./calendars")]),e.exports=n},{"./aggregate":2,"./bar":3,"./barpolar":4,"./box":5,"./calendars":6,"./candlestick":7,"./carpet":8,"./choropleth":9,"./choroplethmapbox":10,"./cone":11,"./contour":12,"./contourcarpet":13,"./core":14,"./densitymapbox":15,"./filter":16,"./funnel":17,"./funnelarea":18,"./groupby":19,"./heatmap":20,"./heatmapgl":21,"./histogram":22,"./histogram2d":23,"./histogram2dcontour":24,"./image":25,"./indicator":27,"./isosurface":28,"./mesh3d":29,"./ohlc":30,"./parcats":31,"./parcoords":32,"./pie":33,"./pointcloud":34,"./sankey":35,"./scatter3d":36,"./scattercarpet":37,"./scattergeo":38,"./scattergl":39,"./scattermapbox":40,"./scatterpolar":41,"./scatterpolargl":42,"./scatterternary":43,"./sort":44,"./splom":45,"./streamtube":46,"./sunburst":47,"./surface":48,"./table":49,"./treemap":50,"./violin":51,"./volume":52,"./waterfall":53}],27:[function(t,e,r){"use strict";e.exports=t("../src/traces/indicator")},{"../src/traces/indicator":1074}],28:[function(t,e,r){"use strict";e.exports=t("../src/traces/isosurface")},{"../src/traces/isosurface":1080}],29:[function(t,e,r){"use strict";e.exports=t("../src/traces/mesh3d")},{"../src/traces/mesh3d":1085}],30:[function(t,e,r){"use strict";e.exports=t("../src/traces/ohlc")},{"../src/traces/ohlc":1090}],31:[function(t,e,r){"use strict";e.exports=t("../src/traces/parcats")},{"../src/traces/parcats":1099}],32:[function(t,e,r){"use strict";e.exports=t("../src/traces/parcoords")},{"../src/traces/parcoords":1109}],33:[function(t,e,r){"use strict";e.exports=t("../src/traces/pie")},{"../src/traces/pie":1120}],34:[function(t,e,r){"use strict";e.exports=t("../src/traces/pointcloud")},{"../src/traces/pointcloud":1129}],35:[function(t,e,r){"use strict";e.exports=t("../src/traces/sankey")},{"../src/traces/sankey":1135}],36:[function(t,e,r){"use strict";e.exports=t("../src/traces/scatter3d")},{"../src/traces/scatter3d":1172}],37:[function(t,e,r){"use strict";e.exports=t("../src/traces/scattercarpet")},{"../src/traces/scattercarpet":1179}],38:[function(t,e,r){"use strict";e.exports=t("../src/traces/scattergeo")},{"../src/traces/scattergeo":1187}],39:[function(t,e,r){"use strict";e.exports=t("../src/traces/scattergl")},{"../src/traces/scattergl":1200}],40:[function(t,e,r){"use strict";e.exports=t("../src/traces/scattermapbox")},{"../src/traces/scattermapbox":1210}],41:[function(t,e,r){"use strict";e.exports=t("../src/traces/scatterpolar")},{"../src/traces/scatterpolar":1218}],42:[function(t,e,r){"use strict";e.exports=t("../src/traces/scatterpolargl")},{"../src/traces/scatterpolargl":1225}],43:[function(t,e,r){"use strict";e.exports=t("../src/traces/scatterternary")},{"../src/traces/scatterternary":1233}],44:[function(t,e,r){"use strict";e.exports=t("../src/transforms/sort")},{"../src/transforms/sort":1321}],45:[function(t,e,r){"use strict";e.exports=t("../src/traces/splom")},{"../src/traces/splom":1242}],46:[function(t,e,r){"use strict";e.exports=t("../src/traces/streamtube")},{"../src/traces/streamtube":1250}],47:[function(t,e,r){"use strict";e.exports=t("../src/traces/sunburst")},{"../src/traces/sunburst":1258}],48:[function(t,e,r){"use strict";e.exports=t("../src/traces/surface")},{"../src/traces/surface":1267}],49:[function(t,e,r){"use strict";e.exports=t("../src/traces/table")},{"../src/traces/table":1275}],50:[function(t,e,r){"use strict";e.exports=t("../src/traces/treemap")},{"../src/traces/treemap":1284}],51:[function(t,e,r){"use strict";e.exports=t("../src/traces/violin")},{"../src/traces/violin":1296}],52:[function(t,e,r){"use strict";e.exports=t("../src/traces/volume")},{"../src/traces/volume":1304}],53:[function(t,e,r){"use strict";e.exports=t("../src/traces/waterfall")},{"../src/traces/waterfall":1312}],54:[function(t,e,r){"use strict";e.exports=function(t){var e=(t=t||{}).eye||[0,0,1],r=t.center||[0,0,0],s=t.up||[0,1,0],l=t.distanceLimits||[0,1/0],c=t.mode||"turntable",u=n(),h=a(),f=i();return u.setDistanceLimits(l[0],l[1]),u.lookAt(0,e,r,s),h.setDistanceLimits(l[0],l[1]),h.lookAt(0,e,r,s),f.setDistanceLimits(l[0],l[1]),f.lookAt(0,e,r,s),new o({turntable:u,orbit:h,matrix:f},c)};var n=t("turntable-camera-controller"),a=t("orbit-camera-controller"),i=t("matrix-camera-controller");function o(t,e){this._controllerNames=Object.keys(t),this._controllerList=this._controllerNames.map((function(e){return t[e]})),this._mode=e,this._active=t[e],this._active||(this._mode="turntable",this._active=t.turntable),this.modes=this._controllerNames,this.computedMatrix=this._active.computedMatrix,this.computedEye=this._active.computedEye,this.computedUp=this._active.computedUp,this.computedCenter=this._active.computedCenter,this.computedRadius=this._active.computedRadius}var s=o.prototype;[["flush",1],["idle",1],["lookAt",4],["rotate",4],["pan",4],["translate",4],["setMatrix",2],["setDistanceLimits",2],["setDistance",2]].forEach((function(t){for(var e=t[0],r=[],n=0;n<t[1];++n)r.push("a"+n);var a="var cc=this._controllerList;for(var i=0;i<cc.length;++i){cc[i]."+t[0]+"("+r.join()+")}";s[e]=Function.apply(null,r.concat(a))})),s.recalcMatrix=function(t){this._active.recalcMatrix(t)},s.getDistance=function(t){return this._active.getDistance(t)},s.getDistanceLimits=function(t){return this._active.getDistanceLimits(t)},s.lastT=function(){return this._active.lastT()},s.setMode=function(t){if(t!==this._mode){var e=this._controllerNames.indexOf(t);if(!(e<0)){var r=this._active,n=this._controllerList[e],a=Math.max(r.lastT(),n.lastT());r.recalcMatrix(a),n.setMatrix(a,r.computedMatrix),this._active=n,this._mode=t,this.computedMatrix=this._active.computedMatrix,this.computedEye=this._active.computedEye,this.computedUp=this._active.computedUp,this.computedCenter=this._active.computedCenter,this.computedRadius=this._active.computedRadius}}},s.getMode=function(){return this._mode}},{"matrix-camera-controller":437,"orbit-camera-controller":461,"turntable-camera-controller":540}],55:[function(t,e,r){!function(n,a){"object"==typeof r&&"undefined"!=typeof e?a(r,t("d3-array"),t("d3-collection"),t("d3-shape"),t("elementary-circuits-directed-graph")):a(n.d3=n.d3||{},n.d3,n.d3,n.d3,null)}(this,(function(t,e,r,n,a){"use strict";function i(t){return t.target.depth}function o(t,e){return t.sourceLinks.length?t.depth:e-1}function s(t){return function(){return t}}a=a&&a.hasOwnProperty("default")?a.default:a;var l="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(t){return typeof t}:function(t){return t&&"function"==typeof Symbol&&t.constructor===Symbol&&t!==Symbol.prototype?"symbol":typeof t};function c(t,e){return h(t.source,e.source)||t.index-e.index}function u(t,e){return h(t.target,e.target)||t.index-e.index}function h(t,e){return t.partOfCycle===e.partOfCycle?t.y0-e.y0:"top"===t.circularLinkType||"bottom"===e.circularLinkType?-1:1}function f(t){return t.value}function p(t){return(t.y0+t.y1)/2}function d(t){return p(t.source)}function g(t){return p(t.target)}function m(t){return t.index}function v(t){return t.nodes}function y(t){return t.links}function x(t,e){var r=t.get(e);if(!r)throw new Error("missing: "+e);return r}function b(t,e){return e(t)}function _(t,e,r){var n=0;if(null===r){for(var i=[],o=0;o<t.links.length;o++){var s=t.links[o],l=s.source.index,c=s.target.index;i[l]||(i[l]=[]),i[c]||(i[c]=[]),-1===i[l].indexOf(c)&&i[l].push(c)}var u=a(i);u.sort((function(t,e){return t.length-e.length}));var h={};for(o=0;o<u.length;o++){var f=u[o].slice(-2);h[f[0]]||(h[f[0]]={}),h[f[0]][f[1]]=!0}t.links.forEach((function(t){var e=t.target.index,r=t.source.index;e===r||h[r]&&h[r][e]?(t.circular=!0,t.circularLinkID=n,n+=1):t.circular=!1}))}else t.links.forEach((function(t){t.source[r]<t.target[r]?t.circular=!1:(t.circular=!0,t.circularLinkID=n,n+=1)}))}function w(t,e){var r=0,n=0;t.links.forEach((function(a){a.circular&&(a.source.circularLinkType||a.target.circularLinkType?a.circularLinkType=a.source.circularLinkType?a.source.circularLinkType:a.target.circularLinkType:a.circularLinkType=r<n?"top":"bottom","top"==a.circularLinkType?r+=1:n+=1,t.nodes.forEach((function(t){b(t,e)!=b(a.source,e)&&b(t,e)!=b(a.target,e)||(t.circularLinkType=a.circularLinkType)})))})),t.links.forEach((function(t){t.circular&&(t.source.circularLinkType==t.target.circularLinkType&&(t.circularLinkType=t.source.circularLinkType),H(t,e)&&(t.circularLinkType=t.source.circularLinkType))}))}function T(t){var e=Math.abs(t.y1-t.y0),r=Math.abs(t.target.x0-t.source.x1);return Math.atan(r/e)}function k(t,e){var r=0;t.sourceLinks.forEach((function(t){r=t.circular&&!H(t,e)?r+1:r}));var n=0;return t.targetLinks.forEach((function(t){n=t.circular&&!H(t,e)?n+1:n})),r+n}function M(t){var e=t.source.sourceLinks,r=0;e.forEach((function(t){r=t.circular?r+1:r}));var n=t.target.targetLinks,a=0;return n.forEach((function(t){a=t.circular?a+1:a})),!(r>1||a>1)}function A(t,e,r){return t.sort(E),t.forEach((function(n,a){var i,o,s=0;if(H(n,r)&&M(n))n.circularPathData.verticalBuffer=s+n.width/2;else{for(var l=0;l<a;l++)if(i=t[a],o=t[l],!(i.source.column<o.target.column||i.target.column>o.source.column)){var c=t[l].circularPathData.verticalBuffer+t[l].width/2+e;s=c>s?c:s}n.circularPathData.verticalBuffer=s+n.width/2}})),t}function S(t,r,a,i){var o=e.min(t.links,(function(t){return t.source.y0}));t.links.forEach((function(t){t.circular&&(t.circularPathData={})})),A(t.links.filter((function(t){return"top"==t.circularLinkType})),r,i),A(t.links.filter((function(t){return"bottom"==t.circularLinkType})),r,i),t.links.forEach((function(e){if(e.circular){if(e.circularPathData.arcRadius=e.width+10,e.circularPathData.leftNodeBuffer=5,e.circularPathData.rightNodeBuffer=5,e.circularPathData.sourceWidth=e.source.x1-e.source.x0,e.circularPathData.sourceX=e.source.x0+e.circularPathData.sourceWidth,e.circularPathData.targetX=e.target.x0,e.circularPathData.sourceY=e.y0,e.circularPathData.targetY=e.y1,H(e,i)&&M(e))e.circularPathData.leftSmallArcRadius=10+e.width/2,e.circularPathData.leftLargeArcRadius=10+e.width/2,e.circularPathData.rightSmallArcRadius=10+e.width/2,e.circularPathData.rightLargeArcRadius=10+e.width/2,"bottom"==e.circularLinkType?(e.circularPathData.verticalFullExtent=e.source.y1+25+e.circularPathData.verticalBuffer,e.circularPathData.verticalLeftInnerExtent=e.circularPathData.verticalFullExtent-e.circularPathData.leftLargeArcRadius,e.circularPathData.verticalRightInnerExtent=e.circularPathData.verticalFullExtent-e.circularPathData.rightLargeArcRadius):(e.circularPathData.verticalFullExtent=e.source.y0-25-e.circularPathData.verticalBuffer,e.circularPathData.verticalLeftInnerExtent=e.circularPathData.verticalFullExtent+e.circularPathData.leftLargeArcRadius,e.circularPathData.verticalRightInnerExtent=e.circularPathData.verticalFullExtent+e.circularPathData.rightLargeArcRadius);else{var s=e.source.column,l=e.circularLinkType,c=t.links.filter((function(t){return t.source.column==s&&t.circularLinkType==l}));"bottom"==e.circularLinkType?c.sort(L):c.sort(C);var u=0;c.forEach((function(t,n){t.circularLinkID==e.circularLinkID&&(e.circularPathData.leftSmallArcRadius=10+e.width/2+u,e.circularPathData.leftLargeArcRadius=10+e.width/2+n*r+u),u+=t.width})),s=e.target.column,c=t.links.filter((function(t){return t.target.column==s&&t.circularLinkType==l})),"bottom"==e.circularLinkType?c.sort(I):c.sort(P),u=0,c.forEach((function(t,n){t.circularLinkID==e.circularLinkID&&(e.circularPathData.rightSmallArcRadius=10+e.width/2+u,e.circularPathData.rightLargeArcRadius=10+e.width/2+n*r+u),u+=t.width})),"bottom"==e.circularLinkType?(e.circularPathData.verticalFullExtent=Math.max(a,e.source.y1,e.target.y1)+25+e.circularPathData.verticalBuffer,e.circularPathData.verticalLeftInnerExtent=e.circularPathData.verticalFullExtent-e.circularPathData.leftLargeArcRadius,e.circularPathData.verticalRightInnerExtent=e.circularPathData.verticalFullExtent-e.circularPathData.rightLargeArcRadius):(e.circularPathData.verticalFullExtent=o-25-e.circularPathData.verticalBuffer,e.circularPathData.verticalLeftInnerExtent=e.circularPathData.verticalFullExtent+e.circularPathData.leftLargeArcRadius,e.circularPathData.verticalRightInnerExtent=e.circularPathData.verticalFullExtent+e.circularPathData.rightLargeArcRadius)}e.circularPathData.leftInnerExtent=e.circularPathData.sourceX+e.circularPathData.leftNodeBuffer,e.circularPathData.rightInnerExtent=e.circularPathData.targetX-e.circularPathData.rightNodeBuffer,e.circularPathData.leftFullExtent=e.circularPathData.sourceX+e.circularPathData.leftLargeArcRadius+e.circularPathData.leftNodeBuffer,e.circularPathData.rightFullExtent=e.circularPathData.targetX-e.circularPathData.rightLargeArcRadius-e.circularPathData.rightNodeBuffer}if(e.circular)e.path=function(t){var e="";e="top"==t.circularLinkType?"M"+t.circularPathData.sourceX+" "+t.circularPathData.sourceY+" L"+t.circularPathData.leftInnerExtent+" "+t.circularPathData.sourceY+" A"+t.circularPathData.leftLargeArcRadius+" "+t.circularPathData.leftSmallArcRadius+" 0 0 0 "+t.circularPathData.leftFullExtent+" "+(t.circularPathData.sourceY-t.circularPathData.leftSmallArcRadius)+" L"+t.circularPathData.leftFullExtent+" "+t.circularPathData.verticalLeftInnerExtent+" A"+t.circularPathData.leftLargeArcRadius+" "+t.circularPathData.leftLargeArcRadius+" 0 0 0 "+t.circularPathData.leftInnerExtent+" "+t.circularPathData.verticalFullExtent+" L"+t.circularPathData.rightInnerExtent+" "+t.circularPathData.verticalFullExtent+" A"+t.circularPathData.rightLargeArcRadius+" "+t.circularPathData.rightLargeArcRadius+" 0 0 0 "+t.circularPathData.rightFullExtent+" "+t.circularPathData.verticalRightInnerExtent+" L"+t.circularPathData.rightFullExtent+" "+(t.circularPathData.targetY-t.circularPathData.rightSmallArcRadius)+" A"+t.circularPathData.rightLargeArcRadius+" "+t.circularPathData.rightSmallArcRadius+" 0 0 0 "+t.circularPathData.rightInnerExtent+" "+t.circularPathData.targetY+" L"+t.circularPathData.targetX+" "+t.circularPathData.targetY:"M"+t.circularPathData.sourceX+" "+t.circularPathData.sourceY+" L"+t.circularPathData.leftInnerExtent+" "+t.circularPathData.sourceY+" A"+t.circularPathData.leftLargeArcRadius+" "+t.circularPathData.leftSmallArcRadius+" 0 0 1 "+t.circularPathData.leftFullExtent+" "+(t.circularPathData.sourceY+t.circularPathData.leftSmallArcRadius)+" L"+t.circularPathData.leftFullExtent+" "+t.circularPathData.verticalLeftInnerExtent+" A"+t.circularPathData.leftLargeArcRadius+" "+t.circularPathData.leftLargeArcRadius+" 0 0 1 "+t.circularPathData.leftInnerExtent+" "+t.circularPathData.verticalFullExtent+" L"+t.circularPathData.rightInnerExtent+" "+t.circularPathData.verticalFullExtent+" A"+t.circularPathData.rightLargeArcRadius+" "+t.circularPathData.rightLargeArcRadius+" 0 0 1 "+t.circularPathData.rightFullExtent+" "+t.circularPathData.verticalRightInnerExtent+" L"+t.circularPathData.rightFullExtent+" "+(t.circularPathData.targetY+t.circularPathData.rightSmallArcRadius)+" A"+t.circularPathData.rightLargeArcRadius+" "+t.circularPathData.rightSmallArcRadius+" 0 0 1 "+t.circularPathData.rightInnerExtent+" "+t.circularPathData.targetY+" L"+t.circularPathData.targetX+" "+t.circularPathData.targetY;return e}(e);else{var h=n.linkHorizontal().source((function(t){return[t.source.x0+(t.source.x1-t.source.x0),t.y0]})).target((function(t){return[t.target.x0,t.y1]}));e.path=h(e)}}))}function E(t,e){return z(t)==z(e)?"bottom"==t.circularLinkType?L(t,e):C(t,e):z(e)-z(t)}function C(t,e){return t.y0-e.y0}function L(t,e){return e.y0-t.y0}function P(t,e){return t.y1-e.y1}function I(t,e){return e.y1-t.y1}function z(t){return t.target.column-t.source.column}function O(t){return t.target.x0-t.source.x1}function D(t,e){var r=T(t),n=O(e)/Math.tan(r);return"up"==q(t)?t.y1+n:t.y1-n}function R(t,e){var r=T(t),n=O(e)/Math.tan(r);return"up"==q(t)?t.y1-n:t.y1+n}function F(t,e,r,n){t.links.forEach((function(a){if(!a.circular&&a.target.column-a.source.column>1){var i=a.source.column+1,o=a.target.column-1,s=1,l=o-i+1;for(s=1;i<=o;i++,s++)t.nodes.forEach((function(o){if(o.column==i){var c,u=s/(l+1),h=Math.pow(1-u,3),f=3*u*Math.pow(1-u,2),p=3*Math.pow(u,2)*(1-u),d=Math.pow(u,3),g=h*a.y0+f*a.y0+p*a.y1+d*a.y1,m=g-a.width/2,v=g+a.width/2;m>o.y0&&m<o.y1?(c=o.y1-m+10,c="bottom"==o.circularLinkType?c:-c,o=N(o,c,e,r),t.nodes.forEach((function(t){b(t,n)!=b(o,n)&&t.column==o.column&&B(o,t)&&N(t,c,e,r)}))):(v>o.y0&&v<o.y1||m<o.y0&&v>o.y1)&&(c=v-o.y0+10,o=N(o,c,e,r),t.nodes.forEach((function(t){b(t,n)!=b(o,n)&&t.column==o.column&&t.y0<o.y1&&t.y1>o.y1&&N(t,c,e,r)})))}}))}}))}function B(t,e){return t.y0>e.y0&&t.y0<e.y1||(t.y1>e.y0&&t.y1<e.y1||t.y0<e.y0&&t.y1>e.y1)}function N(t,e,r,n){return t.y0+e>=r&&t.y1+e<=n&&(t.y0=t.y0+e,t.y1=t.y1+e,t.targetLinks.forEach((function(t){t.y1=t.y1+e})),t.sourceLinks.forEach((function(t){t.y0=t.y0+e}))),t}function j(t,e,r,n){t.nodes.forEach((function(a){n&&a.y+(a.y1-a.y0)>e&&(a.y=a.y-(a.y+(a.y1-a.y0)-e));var i=t.links.filter((function(t){return b(t.source,r)==b(a,r)})),o=i.length;o>1&&i.sort((function(t,e){if(!t.circular&&!e.circular){if(t.target.column==e.target.column)return t.y1-e.y1;if(!V(t,e))return t.y1-e.y1;if(t.target.column>e.target.column){var r=R(e,t);return t.y1-r}if(e.target.column>t.target.column)return R(t,e)-e.y1}return t.circular&&!e.circular?"top"==t.circularLinkType?-1:1:e.circular&&!t.circular?"top"==e.circularLinkType?1:-1:t.circular&&e.circular?t.circularLinkType===e.circularLinkType&&"top"==t.circularLinkType?t.target.column===e.target.column?t.target.y1-e.target.y1:e.target.column-t.target.column:t.circularLinkType===e.circularLinkType&&"bottom"==t.circularLinkType?t.target.column===e.target.column?e.target.y1-t.target.y1:t.target.column-e.target.column:"top"==t.circularLinkType?-1:1:void 0}));var s=a.y0;i.forEach((function(t){t.y0=s+t.width/2,s+=t.width})),i.forEach((function(t,e){if("bottom"==t.circularLinkType){for(var r=e+1,n=0;r<o;r++)n+=i[r].width;t.y0=a.y1-n-t.width/2}}))}))}function U(t,e,r){t.nodes.forEach((function(e){var n=t.links.filter((function(t){return b(t.target,r)==b(e,r)})),a=n.length;a>1&&n.sort((function(t,e){if(!t.circular&&!e.circular){if(t.source.column==e.source.column)return t.y0-e.y0;if(!V(t,e))return t.y0-e.y0;if(e.source.column<t.source.column){var r=D(e,t);return t.y0-r}if(t.source.column<e.source.column)return D(t,e)-e.y0}return t.circular&&!e.circular?"top"==t.circularLinkType?-1:1:e.circular&&!t.circular?"top"==e.circularLinkType?1:-1:t.circular&&e.circular?t.circularLinkType===e.circularLinkType&&"top"==t.circularLinkType?t.source.column===e.source.column?t.source.y1-e.source.y1:t.source.column-e.source.column:t.circularLinkType===e.circularLinkType&&"bottom"==t.circularLinkType?t.source.column===e.source.column?t.source.y1-e.source.y1:e.source.column-t.source.column:"top"==t.circularLinkType?-1:1:void 0}));var i=e.y0;n.forEach((function(t){t.y1=i+t.width/2,i+=t.width})),n.forEach((function(t,r){if("bottom"==t.circularLinkType){for(var i=r+1,o=0;i<a;i++)o+=n[i].width;t.y1=e.y1-o-t.width/2}}))}))}function V(t,e){return q(t)==q(e)}function q(t){return t.y0-t.y1>0?"up":"down"}function H(t,e){return b(t.source,e)==b(t.target,e)}function G(t,r,n){var a=t.nodes,i=t.links,o=!1,s=!1;if(i.forEach((function(t){"top"==t.circularLinkType?o=!0:"bottom"==t.circularLinkType&&(s=!0)})),0==o||0==s){var l=e.min(a,(function(t){return t.y0})),c=(n-r)/(e.max(a,(function(t){return t.y1}))-l);a.forEach((function(t){var e=(t.y1-t.y0)*c;t.y0=(t.y0-l)*c,t.y1=t.y0+e})),i.forEach((function(t){t.y0=(t.y0-l)*c,t.y1=(t.y1-l)*c,t.width=t.width*c}))}}t.sankeyCircular=function(){var t,n,a=0,i=0,b=1,T=1,M=24,A=m,E=o,C=v,L=y,P=32,I=2,z=null;function O(){var t={nodes:C.apply(null,arguments),links:L.apply(null,arguments)};D(t),_(t,A,z),R(t),B(t),w(t,A),N(t,P,A),V(t);for(var e=4,r=0;r<e;r++)j(t,T,A),U(t,T,A),F(t,i,T,A),j(t,T,A),U(t,T,A);return G(t,i,T),S(t,I,T,A),t}function D(t){t.nodes.forEach((function(t,e){t.index=e,t.sourceLinks=[],t.targetLinks=[]}));var e=r.map(t.nodes,A);return t.links.forEach((function(t,r){t.index=r;var n=t.source,a=t.target;"object"!==("undefined"==typeof n?"undefined":l(n))&&(n=t.source=x(e,n)),"object"!==("undefined"==typeof a?"undefined":l(a))&&(a=t.target=x(e,a)),n.sourceLinks.push(t),a.targetLinks.push(t)})),t}function R(t){t.nodes.forEach((function(t){t.partOfCycle=!1,t.value=Math.max(e.sum(t.sourceLinks,f),e.sum(t.targetLinks,f)),t.sourceLinks.forEach((function(e){e.circular&&(t.partOfCycle=!0,t.circularLinkType=e.circularLinkType)})),t.targetLinks.forEach((function(e){e.circular&&(t.partOfCycle=!0,t.circularLinkType=e.circularLinkType)}))}))}function B(t){var e,r,n;for(e=t.nodes,r=[],n=0;e.length;++n,e=r,r=[])e.forEach((function(t){t.depth=n,t.sourceLinks.forEach((function(t){r.indexOf(t.target)<0&&!t.circular&&r.push(t.target)}))}));for(e=t.nodes,r=[],n=0;e.length;++n,e=r,r=[])e.forEach((function(t){t.height=n,t.targetLinks.forEach((function(t){r.indexOf(t.source)<0&&!t.circular&&r.push(t.source)}))}));t.nodes.forEach((function(t){t.column=Math.floor(E.call(null,t,n))}))}function N(o,s,l){var c=r.nest().key((function(t){return t.column})).sortKeys(e.ascending).entries(o.nodes).map((function(t){return t.values}));!function(r){if(n){var s=1/0;c.forEach((function(t){var e=T*n/(t.length+1);s=e<s?e:s})),t=s}var l=e.min(c,(function(r){return(T-i-(r.length-1)*t)/e.sum(r,f)}));l*=.3,o.links.forEach((function(t){t.width=t.value*l}));var u=function(t){var r=0,n=0,a=0,i=0,o=e.max(t.nodes,(function(t){return t.column}));return t.links.forEach((function(t){t.circular&&("top"==t.circularLinkType?r+=t.width:n+=t.width,0==t.target.column&&(i+=t.width),t.source.column==o&&(a+=t.width))})),{top:r=r>0?r+25+10:r,bottom:n=n>0?n+25+10:n,left:i=i>0?i+25+10:i,right:a=a>0?a+25+10:a}}(o),h=function(t,r){var n=e.max(t.nodes,(function(t){return t.column})),o=b-a,s=T-i,l=o/(o+r.right+r.left),c=s/(s+r.top+r.bottom);return a=a*l+r.left,b=0==r.right?b:b*l,i=i*c+r.top,T*=c,t.nodes.forEach((function(t){t.x0=a+t.column*((b-a-M)/n),t.x1=t.x0+M})),c}(o,u);l*=h,o.links.forEach((function(t){t.width=t.value*l})),c.forEach((function(t){var e=t.length;t.forEach((function(t,n){t.depth==c.length-1&&1==e||0==t.depth&&1==e?(t.y0=T/2-t.value*l,t.y1=t.y0+t.value*l):t.partOfCycle?0==k(t,r)?(t.y0=T/2+n,t.y1=t.y0+t.value*l):"top"==t.circularLinkType?(t.y0=i+n,t.y1=t.y0+t.value*l):(t.y0=T-t.value*l-n,t.y1=t.y0+t.value*l):0==u.top||0==u.bottom?(t.y0=(T-i)/e*n,t.y1=t.y0+t.value*l):(t.y0=(T-i)/2-e/2+n,t.y1=t.y0+t.value*l)}))}))}(l),y();for(var u=1,m=s;m>0;--m)v(u*=.99,l),y();function v(t,r){var n=c.length;c.forEach((function(a){var i=a.length,o=a[0].depth;a.forEach((function(a){var s;if(a.sourceLinks.length||a.targetLinks.length)if(a.partOfCycle&&k(a,r)>0);else if(0==o&&1==i)s=a.y1-a.y0,a.y0=T/2-s/2,a.y1=T/2+s/2;else if(o==n-1&&1==i)s=a.y1-a.y0,a.y0=T/2-s/2,a.y1=T/2+s/2;else{var l=e.mean(a.sourceLinks,g),c=e.mean(a.targetLinks,d),u=((l&&c?(l+c)/2:l||c)-p(a))*t;a.y0+=u,a.y1+=u}}))}))}function y(){c.forEach((function(e){var r,n,a,o=i,s=e.length;for(e.sort(h),a=0;a<s;++a)(n=o-(r=e[a]).y0)>0&&(r.y0+=n,r.y1+=n),o=r.y1+t;if((n=o-t-T)>0)for(o=r.y0-=n,r.y1-=n,a=s-2;a>=0;--a)(n=(r=e[a]).y1+t-o)>0&&(r.y0-=n,r.y1-=n),o=r.y0}))}}function V(t){t.nodes.forEach((function(t){t.sourceLinks.sort(u),t.targetLinks.sort(c)})),t.nodes.forEach((function(t){var e=t.y0,r=e,n=t.y1,a=n;t.sourceLinks.forEach((function(t){t.circular?(t.y0=n-t.width/2,n-=t.width):(t.y0=e+t.width/2,e+=t.width)})),t.targetLinks.forEach((function(t){t.circular?(t.y1=a-t.width/2,a-=t.width):(t.y1=r+t.width/2,r+=t.width)}))}))}return O.nodeId=function(t){return arguments.length?(A="function"==typeof t?t:s(t),O):A},O.nodeAlign=function(t){return arguments.length?(E="function"==typeof t?t:s(t),O):E},O.nodeWidth=function(t){return arguments.length?(M=+t,O):M},O.nodePadding=function(e){return arguments.length?(t=+e,O):t},O.nodes=function(t){return arguments.length?(C="function"==typeof t?t:s(t),O):C},O.links=function(t){return arguments.length?(L="function"==typeof t?t:s(t),O):L},O.size=function(t){return arguments.length?(a=i=0,b=+t[0],T=+t[1],O):[b-a,T-i]},O.extent=function(t){return arguments.length?(a=+t[0][0],b=+t[1][0],i=+t[0][1],T=+t[1][1],O):[[a,i],[b,T]]},O.iterations=function(t){return arguments.length?(P=+t,O):P},O.circularLinkGap=function(t){return arguments.length?(I=+t,O):I},O.nodePaddingRatio=function(t){return arguments.length?(n=+t,O):n},O.sortNodes=function(t){return arguments.length?(z=t,O):z},O.update=function(t){return w(t,A),V(t),t.links.forEach((function(t){t.circular&&(t.circularLinkType=t.y0+t.y1<T?"top":"bottom",t.source.circularLinkType=t.circularLinkType,t.target.circularLinkType=t.circularLinkType)})),j(t,T,A,!1),U(t,T,A),S(t,I,T,A),t},O},t.sankeyCenter=function(t){return t.targetLinks.length?t.depth:t.sourceLinks.length?e.min(t.sourceLinks,i)-1:0},t.sankeyLeft=function(t){return t.depth},t.sankeyRight=function(t,e){return e-1-t.height},t.sankeyJustify=o,Object.defineProperty(t,"__esModule",{value:!0})}))},{"d3-array":154,"d3-collection":155,"d3-shape":163,"elementary-circuits-directed-graph":175}],56:[function(t,e,r){!function(n,a){"object"==typeof r&&"undefined"!=typeof e?a(r,t("d3-array"),t("d3-collection"),t("d3-shape")):a(n.d3=n.d3||{},n.d3,n.d3,n.d3)}(this,(function(t,e,r,n){"use strict";function a(t){return t.target.depth}function i(t,e){return t.sourceLinks.length?t.depth:e-1}function o(t){return function(){return t}}function s(t,e){return c(t.source,e.source)||t.index-e.index}function l(t,e){return c(t.target,e.target)||t.index-e.index}function c(t,e){return t.y0-e.y0}function u(t){return t.value}function h(t){return(t.y0+t.y1)/2}function f(t){return h(t.source)*t.value}function p(t){return h(t.target)*t.value}function d(t){return t.index}function g(t){return t.nodes}function m(t){return t.links}function v(t,e){var r=t.get(e);if(!r)throw new Error("missing: "+e);return r}function y(t){return[t.source.x1,t.y0]}function x(t){return[t.target.x0,t.y1]}t.sankey=function(){var t=0,n=0,a=1,y=1,x=24,b=8,_=d,w=i,T=g,k=m,M=32;function A(){var t={nodes:T.apply(null,arguments),links:k.apply(null,arguments)};return S(t),E(t),C(t),L(t),P(t),t}function S(t){t.nodes.forEach((function(t,e){t.index=e,t.sourceLinks=[],t.targetLinks=[]}));var e=r.map(t.nodes,_);t.links.forEach((function(t,r){t.index=r;var n=t.source,a=t.target;"object"!=typeof n&&(n=t.source=v(e,n)),"object"!=typeof a&&(a=t.target=v(e,a)),n.sourceLinks.push(t),a.targetLinks.push(t)}))}function E(t){t.nodes.forEach((function(t){t.value=Math.max(e.sum(t.sourceLinks,u),e.sum(t.targetLinks,u))}))}function C(e){var r,n,i;for(r=e.nodes,n=[],i=0;r.length;++i,r=n,n=[])r.forEach((function(t){t.depth=i,t.sourceLinks.forEach((function(t){n.indexOf(t.target)<0&&n.push(t.target)}))}));for(r=e.nodes,n=[],i=0;r.length;++i,r=n,n=[])r.forEach((function(t){t.height=i,t.targetLinks.forEach((function(t){n.indexOf(t.source)<0&&n.push(t.source)}))}));var o=(a-t-x)/(i-1);e.nodes.forEach((function(e){e.x1=(e.x0=t+Math.max(0,Math.min(i-1,Math.floor(w.call(null,e,i))))*o)+x}))}function L(t){var a=r.nest().key((function(t){return t.x0})).sortKeys(e.ascending).entries(t.nodes).map((function(t){return t.values}));!function(){var r=e.max(a,(function(t){return t.length})),i=2/3*(y-n)/(r-1);b>i&&(b=i);var o=e.min(a,(function(t){return(y-n-(t.length-1)*b)/e.sum(t,u)}));a.forEach((function(t){t.forEach((function(t,e){t.y1=(t.y0=e)+t.value*o}))})),t.links.forEach((function(t){t.width=t.value*o}))}(),d();for(var i=1,o=M;o>0;--o)l(i*=.99),d(),s(i),d();function s(t){a.forEach((function(r){r.forEach((function(r){if(r.targetLinks.length){var n=(e.sum(r.targetLinks,f)/e.sum(r.targetLinks,u)-h(r))*t;r.y0+=n,r.y1+=n}}))}))}function l(t){a.slice().reverse().forEach((function(r){r.forEach((function(r){if(r.sourceLinks.length){var n=(e.sum(r.sourceLinks,p)/e.sum(r.sourceLinks,u)-h(r))*t;r.y0+=n,r.y1+=n}}))}))}function d(){a.forEach((function(t){var e,r,a,i=n,o=t.length;for(t.sort(c),a=0;a<o;++a)(r=i-(e=t[a]).y0)>0&&(e.y0+=r,e.y1+=r),i=e.y1+b;if((r=i-b-y)>0)for(i=e.y0-=r,e.y1-=r,a=o-2;a>=0;--a)(r=(e=t[a]).y1+b-i)>0&&(e.y0-=r,e.y1-=r),i=e.y0}))}}function P(t){t.nodes.forEach((function(t){t.sourceLinks.sort(l),t.targetLinks.sort(s)})),t.nodes.forEach((function(t){var e=t.y0,r=e;t.sourceLinks.forEach((function(t){t.y0=e+t.width/2,e+=t.width})),t.targetLinks.forEach((function(t){t.y1=r+t.width/2,r+=t.width}))}))}return A.update=function(t){return P(t),t},A.nodeId=function(t){return arguments.length?(_="function"==typeof t?t:o(t),A):_},A.nodeAlign=function(t){return arguments.length?(w="function"==typeof t?t:o(t),A):w},A.nodeWidth=function(t){return arguments.length?(x=+t,A):x},A.nodePadding=function(t){return arguments.length?(b=+t,A):b},A.nodes=function(t){return arguments.length?(T="function"==typeof t?t:o(t),A):T},A.links=function(t){return arguments.length?(k="function"==typeof t?t:o(t),A):k},A.size=function(e){return arguments.length?(t=n=0,a=+e[0],y=+e[1],A):[a-t,y-n]},A.extent=function(e){return arguments.length?(t=+e[0][0],a=+e[1][0],n=+e[0][1],y=+e[1][1],A):[[t,n],[a,y]]},A.iterations=function(t){return arguments.length?(M=+t,A):M},A},t.sankeyCenter=function(t){return t.targetLinks.length?t.depth:t.sourceLinks.length?e.min(t.sourceLinks,a)-1:0},t.sankeyLeft=function(t){return t.depth},t.sankeyRight=function(t,e){return e-1-t.height},t.sankeyJustify=i,t.sankeyLinkHorizontal=function(){return n.linkHorizontal().source(y).target(x)},Object.defineProperty(t,"__esModule",{value:!0})}))},{"d3-array":154,"d3-collection":155,"d3-shape":163}],57:[function(t,e,r){"use strict";Object.defineProperty(r,"__esModule",{value:!0});var n=t("@turf/meta");function a(t){var e=0;if(t&&t.length>0){e+=Math.abs(i(t[0]));for(var r=1;r<t.length;r++)e-=Math.abs(i(t[r]))}return e}function i(t){var e,r,n,a,i,s,l=0,c=t.length;if(c>2){for(s=0;s<c;s++)s===c-2?(n=c-2,a=c-1,i=0):s===c-1?(n=c-1,a=0,i=1):(n=s,a=s+1,i=s+2),e=t[n],r=t[a],l+=(o(t[i][0])-o(e[0]))*Math.sin(o(r[1]));l=6378137*l*6378137/2}return l}function o(t){return t*Math.PI/180}r.default=function(t){return n.geomReduce(t,(function(t,e){return t+function(t){var e,r=0;switch(t.type){case"Polygon":return a(t.coordinates);case"MultiPolygon":for(e=0;e<t.coordinates.length;e++)r+=a(t.coordinates[e]);return r;case"Point":case"MultiPoint":case"LineString":case"MultiLineString":return 0}return 0}(e)}),0)}},{"@turf/meta":61}],58:[function(t,e,r){"use strict";Object.defineProperty(r,"__esModule",{value:!0});var n=t("@turf/meta");r.default=function(t){var e=[1/0,1/0,-1/0,-1/0];return n.coordEach(t,(function(t){e[0]>t[0]&&(e[0]=t[0]),e[1]>t[1]&&(e[1]=t[1]),e[2]<t[0]&&(e[2]=t[0]),e[3]<t[1]&&(e[3]=t[1])})),e}},{"@turf/meta":61}],59:[function(t,e,r){"use strict";Object.defineProperty(r,"__esModule",{value:!0});var n=t("@turf/meta"),a=t("@turf/helpers");r.default=function(t,e){void 0===e&&(e={});var r=0,i=0,o=0;return n.coordEach(t,(function(t){r+=t[0],i+=t[1],o++})),a.point([r/o,i/o],e.properties)}},{"@turf/helpers":60,"@turf/meta":61}],60:[function(t,e,r){"use strict";function n(t,e,r){void 0===r&&(r={});var n={type:"Feature"};return(0===r.id||r.id)&&(n.id=r.id),r.bbox&&(n.bbox=r.bbox),n.properties=e||{},n.geometry=t,n}function a(t,e,r){return void 0===r&&(r={}),n({type:"Point",coordinates:t},e,r)}function i(t,e,r){void 0===r&&(r={});for(var a=0,i=t;a<i.length;a++){var o=i[a];if(o.length<4)throw new Error("Each LinearRing of a Polygon must have 4 or more Positions.");for(var s=0;s<o[o.length-1].length;s++)if(o[o.length-1][s]!==o[0][s])throw new Error("First and last Position are not equivalent.")}return n({type:"Polygon",coordinates:t},e,r)}function o(t,e,r){if(void 0===r&&(r={}),t.length<2)throw new Error("coordinates must be an array of two or more positions");return n({type:"LineString",coordinates:t},e,r)}function s(t,e){void 0===e&&(e={});var r={type:"FeatureCollection"};return e.id&&(r.id=e.id),e.bbox&&(r.bbox=e.bbox),r.features=t,r}function l(t,e,r){return void 0===r&&(r={}),n({type:"MultiLineString",coordinates:t},e,r)}function c(t,e,r){return void 0===r&&(r={}),n({type:"MultiPoint",coordinates:t},e,r)}function u(t,e,r){return void 0===r&&(r={}),n({type:"MultiPolygon",coordinates:t},e,r)}function h(t,e){void 0===e&&(e="kilometers");var n=r.factors[e];if(!n)throw new Error(e+" units is invalid");return t*n}function f(t,e){void 0===e&&(e="kilometers");var n=r.factors[e];if(!n)throw new Error(e+" units is invalid");return t/n}function p(t){return 180*(t%(2*Math.PI))/Math.PI}function d(t){return!isNaN(t)&&null!==t&&!Array.isArray(t)&&!/^\s*$/.test(t)}Object.defineProperty(r,"__esModule",{value:!0}),r.earthRadius=6371008.8,r.factors={centimeters:100*r.earthRadius,centimetres:100*r.earthRadius,degrees:r.earthRadius/111325,feet:3.28084*r.earthRadius,inches:39.37*r.earthRadius,kilometers:r.earthRadius/1e3,kilometres:r.earthRadius/1e3,meters:r.earthRadius,metres:r.earthRadius,miles:r.earthRadius/1609.344,millimeters:1e3*r.earthRadius,millimetres:1e3*r.earthRadius,nauticalmiles:r.earthRadius/1852,radians:1,yards:r.earthRadius/1.0936},r.unitsFactors={centimeters:100,centimetres:100,degrees:1/111325,feet:3.28084,inches:39.37,kilometers:.001,kilometres:.001,meters:1,metres:1,miles:1/1609.344,millimeters:1e3,millimetres:1e3,nauticalmiles:1/1852,radians:1/r.earthRadius,yards:1/1.0936},r.areaFactors={acres:247105e-9,centimeters:1e4,centimetres:1e4,feet:10.763910417,inches:1550.003100006,kilometers:1e-6,kilometres:1e-6,meters:1,metres:1,miles:386e-9,millimeters:1e6,millimetres:1e6,yards:1.195990046},r.feature=n,r.geometry=function(t,e,r){switch(void 0===r&&(r={}),t){case"Point":return a(e).geometry;case"LineString":return o(e).geometry;case"Polygon":return i(e).geometry;case"MultiPoint":return c(e).geometry;case"MultiLineString":return l(e).geometry;case"MultiPolygon":return u(e).geometry;default:throw new Error(t+" is invalid")}},r.point=a,r.points=function(t,e,r){return void 0===r&&(r={}),s(t.map((function(t){return a(t,e)})),r)},r.polygon=i,r.polygons=function(t,e,r){return void 0===r&&(r={}),s(t.map((function(t){return i(t,e)})),r)},r.lineString=o,r.lineStrings=function(t,e,r){return void 0===r&&(r={}),s(t.map((function(t){return o(t,e)})),r)},r.featureCollection=s,r.multiLineString=l,r.multiPoint=c,r.multiPolygon=u,r.geometryCollection=function(t,e,r){return void 0===r&&(r={}),n({type:"GeometryCollection",geometries:t},e,r)},r.round=function(t,e){if(void 0===e&&(e=0),e&&!(e>=0))throw new Error("precision must be a positive number");var r=Math.pow(10,e||0);return Math.round(t*r)/r},r.radiansToLength=h,r.lengthToRadians=f,r.lengthToDegrees=function(t,e){return p(f(t,e))},r.bearingToAzimuth=function(t){var e=t%360;return e<0&&(e+=360),e},r.radiansToDegrees=p,r.degreesToRadians=function(t){return t%360*Math.PI/180},r.convertLength=function(t,e,r){if(void 0===e&&(e="kilometers"),void 0===r&&(r="kilometers"),!(t>=0))throw new Error("length must be a positive number");return h(f(t,e),r)},r.convertArea=function(t,e,n){if(void 0===e&&(e="meters"),void 0===n&&(n="kilometers"),!(t>=0))throw new Error("area must be a positive number");var a=r.areaFactors[e];if(!a)throw new Error("invalid original units");var i=r.areaFactors[n];if(!i)throw new Error("invalid final units");return t/a*i},r.isNumber=d,r.isObject=function(t){return!!t&&t.constructor===Object},r.validateBBox=function(t){if(!t)throw new Error("bbox is required");if(!Array.isArray(t))throw new Error("bbox must be an Array");if(4!==t.length&&6!==t.length)throw new Error("bbox must be an Array of 4 or 6 numbers");t.forEach((function(t){if(!d(t))throw new Error("bbox must only contain numbers")}))},r.validateId=function(t){if(!t)throw new Error("id is required");if(-1===["string","number"].indexOf(typeof t))throw new Error("id must be a number or a string")},r.radians2degrees=function(){throw new Error("method has been renamed to `radiansToDegrees`")},r.degrees2radians=function(){throw new Error("method has been renamed to `degreesToRadians`")},r.distanceToDegrees=function(){throw new Error("method has been renamed to `lengthToDegrees`")},r.distanceToRadians=function(){throw new Error("method has been renamed to `lengthToRadians`")},r.radiansToDistance=function(){throw new Error("method has been renamed to `radiansToLength`")},r.bearingToAngle=function(){throw new Error("method has been renamed to `bearingToAzimuth`")},r.convertDistance=function(){throw new Error("method has been renamed to `convertLength`")}},{}],61:[function(t,e,r){"use strict";Object.defineProperty(r,"__esModule",{value:!0});var n=t("@turf/helpers");function a(t,e,r){if(null!==t)for(var n,i,o,s,l,c,u,h,f=0,p=0,d=t.type,g="FeatureCollection"===d,m="Feature"===d,v=g?t.features.length:1,y=0;y<v;y++){l=(h=!!(u=g?t.features[y].geometry:m?t.geometry:t)&&"GeometryCollection"===u.type)?u.geometries.length:1;for(var x=0;x<l;x++){var b=0,_=0;if(null!==(s=h?u.geometries[x]:u)){c=s.coordinates;var w=s.type;switch(f=!r||"Polygon"!==w&&"MultiPolygon"!==w?0:1,w){case null:break;case"Point":if(!1===e(c,p,y,b,_))return!1;p++,b++;break;case"LineString":case"MultiPoint":for(n=0;n<c.length;n++){if(!1===e(c[n],p,y,b,_))return!1;p++,"MultiPoint"===w&&b++}"LineString"===w&&b++;break;case"Polygon":case"MultiLineString":for(n=0;n<c.length;n++){for(i=0;i<c[n].length-f;i++){if(!1===e(c[n][i],p,y,b,_))return!1;p++}"MultiLineString"===w&&b++,"Polygon"===w&&_++}"Polygon"===w&&b++;break;case"MultiPolygon":for(n=0;n<c.length;n++){for(_=0,i=0;i<c[n].length;i++){for(o=0;o<c[n][i].length-f;o++){if(!1===e(c[n][i][o],p,y,b,_))return!1;p++}_++}b++}break;case"GeometryCollection":for(n=0;n<s.geometries.length;n++)if(!1===a(s.geometries[n],e,r))return!1;break;default:throw new Error("Unknown Geometry Type")}}}}}function i(t,e){var r;switch(t.type){case"FeatureCollection":for(r=0;r<t.features.length&&!1!==e(t.features[r].properties,r);r++);break;case"Feature":e(t.properties,0)}}function o(t,e){if("Feature"===t.type)e(t,0);else if("FeatureCollection"===t.type)for(var r=0;r<t.features.length&&!1!==e(t.features[r],r);r++);}function s(t,e){var r,n,a,i,o,s,l,c,u,h,f=0,p="FeatureCollection"===t.type,d="Feature"===t.type,g=p?t.features.length:1;for(r=0;r<g;r++){for(s=p?t.features[r].geometry:d?t.geometry:t,c=p?t.features[r].properties:d?t.properties:{},u=p?t.features[r].bbox:d?t.bbox:void 0,h=p?t.features[r].id:d?t.id:void 0,o=(l=!!s&&"GeometryCollection"===s.type)?s.geometries.length:1,a=0;a<o;a++)if(null!==(i=l?s.geometries[a]:s))switch(i.type){case"Point":case"LineString":case"MultiPoint":case"Polygon":case"MultiLineString":case"MultiPolygon":if(!1===e(i,f,c,u,h))return!1;break;case"GeometryCollection":for(n=0;n<i.geometries.length;n++)if(!1===e(i.geometries[n],f,c,u,h))return!1;break;default:throw new Error("Unknown Geometry Type")}else if(!1===e(null,f,c,u,h))return!1;f++}}function l(t,e){s(t,(function(t,r,a,i,o){var s,l=null===t?null:t.type;switch(l){case null:case"Point":case"LineString":case"Polygon":return!1!==e(n.feature(t,a,{bbox:i,id:o}),r,0)&&void 0}switch(l){case"MultiPoint":s="Point";break;case"MultiLineString":s="LineString";break;case"MultiPolygon":s="Polygon"}for(var c=0;c<t.coordinates.length;c++){var u={type:s,coordinates:t.coordinates[c]};if(!1===e(n.feature(u,a),r,c))return!1}}))}function c(t,e){l(t,(function(t,r,i){var o=0;if(t.geometry){var s=t.geometry.type;if("Point"!==s&&"MultiPoint"!==s){var l,c=0,u=0,h=0;return!1!==a(t,(function(a,s,f,p,d){if(void 0===l||r>c||p>u||d>h)return l=a,c=r,u=p,h=d,void(o=0);var g=n.lineString([l,a],t.properties);if(!1===e(g,r,i,d,o))return!1;o++,l=a}))&&void 0}}}))}function u(t,e){if(!t)throw new Error("geojson is required");l(t,(function(t,r,a){if(null!==t.geometry){var i=t.geometry.type,o=t.geometry.coordinates;switch(i){case"LineString":if(!1===e(t,r,a,0,0))return!1;break;case"Polygon":for(var s=0;s<o.length;s++)if(!1===e(n.lineString(o[s],t.properties),r,a,s))return!1}}}))}r.coordEach=a,r.coordReduce=function(t,e,r,n){var i=r;return a(t,(function(t,n,a,o,s){i=0===n&&void 0===r?t:e(i,t,n,a,o,s)}),n),i},r.propEach=i,r.propReduce=function(t,e,r){var n=r;return i(t,(function(t,a){n=0===a&&void 0===r?t:e(n,t,a)})),n},r.featureEach=o,r.featureReduce=function(t,e,r){var n=r;return o(t,(function(t,a){n=0===a&&void 0===r?t:e(n,t,a)})),n},r.coordAll=function(t){var e=[];return a(t,(function(t){e.push(t)})),e},r.geomEach=s,r.geomReduce=function(t,e,r){var n=r;return s(t,(function(t,a,i,o,s){n=0===a&&void 0===r?t:e(n,t,a,i,o,s)})),n},r.flattenEach=l,r.flattenReduce=function(t,e,r){var n=r;return l(t,(function(t,a,i){n=0===a&&0===i&&void 0===r?t:e(n,t,a,i)})),n},r.segmentEach=c,r.segmentReduce=function(t,e,r){var n=r,a=!1;return c(t,(function(t,i,o,s,l){n=!1===a&&void 0===r?t:e(n,t,i,o,s,l),a=!0})),n},r.lineEach=u,r.lineReduce=function(t,e,r){var n=r;return u(t,(function(t,a,i,o){n=0===a&&void 0===r?t:e(n,t,a,i,o)})),n},r.findSegment=function(t,e){if(e=e||{},!n.isObject(e))throw new Error("options is invalid");var r,a=e.featureIndex||0,i=e.multiFeatureIndex||0,o=e.geometryIndex||0,s=e.segmentIndex||0,l=e.properties;switch(t.type){case"FeatureCollection":a<0&&(a=t.features.length+a),l=l||t.features[a].properties,r=t.features[a].geometry;break;case"Feature":l=l||t.properties,r=t.geometry;break;case"Point":case"MultiPoint":return null;case"LineString":case"Polygon":case"MultiLineString":case"MultiPolygon":r=t;break;default:throw new Error("geojson is invalid")}if(null===r)return null;var c=r.coordinates;switch(r.type){case"Point":case"MultiPoint":return null;case"LineString":return s<0&&(s=c.length+s-1),n.lineString([c[s],c[s+1]],l,e);case"Polygon":return o<0&&(o=c.length+o),s<0&&(s=c[o].length+s-1),n.lineString([c[o][s],c[o][s+1]],l,e);case"MultiLineString":return i<0&&(i=c.length+i),s<0&&(s=c[i].length+s-1),n.lineString([c[i][s],c[i][s+1]],l,e);case"MultiPolygon":return i<0&&(i=c.length+i),o<0&&(o=c[i].length+o),s<0&&(s=c[i][o].length-s-1),n.lineString([c[i][o][s],c[i][o][s+1]],l,e)}throw new Error("geojson is invalid")},r.findPoint=function(t,e){if(e=e||{},!n.isObject(e))throw new Error("options is invalid");var r,a=e.featureIndex||0,i=e.multiFeatureIndex||0,o=e.geometryIndex||0,s=e.coordIndex||0,l=e.properties;switch(t.type){case"FeatureCollection":a<0&&(a=t.features.length+a),l=l||t.features[a].properties,r=t.features[a].geometry;break;case"Feature":l=l||t.properties,r=t.geometry;break;case"Point":case"MultiPoint":return null;case"LineString":case"Polygon":case"MultiLineString":case"MultiPolygon":r=t;break;default:throw new Error("geojson is invalid")}if(null===r)return null;var c=r.coordinates;switch(r.type){case"Point":return n.point(c,l,e);case"MultiPoint":return i<0&&(i=c.length+i),n.point(c[i],l,e);case"LineString":return s<0&&(s=c.length+s),n.point(c[s],l,e);case"Polygon":return o<0&&(o=c.length+o),s<0&&(s=c[o].length+s),n.point(c[o][s],l,e);case"MultiLineString":return i<0&&(i=c.length+i),s<0&&(s=c[i].length+s),n.point(c[i][s],l,e);case"MultiPolygon":return i<0&&(i=c.length+i),o<0&&(o=c[i].length+o),s<0&&(s=c[i][o].length-s),n.point(c[i][o][s],l,e)}throw new Error("geojson is invalid")}},{"@turf/helpers":60}],62:[function(t,e,r){"use strict";var n="undefined"==typeof WeakMap?t("weak-map"):WeakMap,a=t("gl-buffer"),i=t("gl-vao"),o=new n;e.exports=function(t){var e=o.get(t),r=e&&(e._triangleBuffer.handle||e._triangleBuffer.buffer);if(!r||!t.isBuffer(r)){var n=a(t,new Float32Array([-1,-1,-1,4,4,-1]));(e=i(t,[{buffer:n,type:t.FLOAT,size:2}]))._triangleBuffer=n,o.set(t,e)}e.bind(),t.drawArrays(t.TRIANGLES,0,3),e.unbind()}},{"gl-buffer":254,"gl-vao":331,"weak-map":561}],63:[function(t,e,r){e.exports=function(t){var e=0,r=0,n=0,a=0;return t.map((function(t){var i=(t=t.slice())[0],o=i.toUpperCase();if(i!=o)switch(t[0]=o,i){case"a":t[6]+=n,t[7]+=a;break;case"v":t[1]+=a;break;case"h":t[1]+=n;break;default:for(var s=1;s<t.length;)t[s++]+=n,t[s++]+=a}switch(o){case"Z":n=e,a=r;break;case"H":n=t[1];break;case"V":a=t[1];break;case"M":n=e=t[1],a=r=t[2];break;default:n=t[t.length-2],a=t[t.length-1]}return t}))}},{}],64:[function(t,e,r){var n=t("pad-left");e.exports=function(t,e,r){e="number"==typeof e?e:1,r=r||": ";var a=t.split(/\r?\n/),i=String(a.length+e-1).length;return a.map((function(t,a){var o=a+e,s=String(o).length;return n(o,i-s)+r+t})).join("\n")}},{"pad-left":462}],65:[function(t,e,r){"use strict";e.exports=function(t){var e=t.length;if(0===e)return[];if(1===e)return[0];for(var r=t[0].length,n=[t[0]],i=[0],o=1;o<e;++o)if(n.push(t[o]),a(n,r)){if(i.push(o),i.length===r+1)return i}else n.pop();return i};var n=t("robust-orientation");function a(t,e){for(var r=new Array(e+1),a=0;a<t.length;++a)r[a]=t[a];for(a=0;a<=t.length;++a){for(var i=t.length;i<=e;++i){for(var o=new Array(e),s=0;s<e;++s)o[s]=Math.pow(i+1-a,s);r[i]=o}if(n.apply(void 0,r))return!0}return!1}},{"robust-orientation":507}],66:[function(t,e,r){"use strict";e.exports=function(t,e){return n(e).filter((function(r){for(var n=new Array(r.length),i=0;i<r.length;++i)n[i]=e[r[i]];return a(n)*t<1}))};var n=t("delaunay-triangulate"),a=t("circumradius")},{circumradius:116,"delaunay-triangulate":167}],67:[function(t,e,r){e.exports=function(t,e){return a(n(t,e))};var n=t("alpha-complex"),a=t("simplicial-complex-boundary")},{"alpha-complex":66,"simplicial-complex-boundary":514}],68:[function(t,e,r){"use strict";e.exports=function(t,e){if(!t||null==t.length)throw Error("Argument should be an array");e=null==e?1:Math.floor(e);for(var r=Array(2*e),n=0;n<e;n++){for(var a=-1/0,i=1/0,o=n,s=t.length;o<s;o+=e)t[o]>a&&(a=t[o]),t[o]<i&&(i=t[o]);r[n]=i,r[e+n]=a}return r}},{}],69:[function(t,e,r){"use strict";var n=t("array-bounds");e.exports=function(t,e,r){if(!t||null==t.length)throw Error("Argument should be an array");null==e&&(e=1);null==r&&(r=n(t,e));for(var a=0;a<e;a++){var i=r[e+a],o=r[a],s=a,l=t.length;if(i===1/0&&o===-1/0)for(s=a;s<l;s+=e)t[s]=t[s]===i?1:t[s]===o?0:.5;else if(i===1/0)for(s=a;s<l;s+=e)t[s]=t[s]===i?1:0;else if(o===-1/0)for(s=a;s<l;s+=e)t[s]=t[s]===o?0:1;else{var c=i-o;for(s=a;s<l;s+=e)isNaN(t[s])||(t[s]=0===c?.5:(t[s]-o)/c)}}return t}},{"array-bounds":68}],70:[function(t,e,r){e.exports=function(t,e){var r="number"==typeof t,n="number"==typeof e;r&&!n?(e=t,t=0):r||n||(t=0,e=0);var a=(e|=0)-(t|=0);if(a<0)throw new Error("array length must be positive");for(var i=new Array(a),o=0,s=t;o<a;o++,s++)i[o]=s;return i}},{}],71:[function(t,e,r){(function(r){"use strict";var n=t("object-assign");
/*!
 * The buffer module from node.js, for the browser.
 *
 * @author   Feross Aboukhadijeh <feross@feross.org> <http://feross.org>
 * @license  MIT
 */function a(t,e){if(t===e)return 0;for(var r=t.length,n=e.length,a=0,i=Math.min(r,n);a<i;++a)if(t[a]!==e[a]){r=t[a],n=e[a];break}return r<n?-1:n<r?1:0}function i(t){return r.Buffer&&"function"==typeof r.Buffer.isBuffer?r.Buffer.isBuffer(t):!(null==t||!t._isBuffer)}var o=t("util/"),s=Object.prototype.hasOwnProperty,l=Array.prototype.slice,c="foo"===function(){}.name;function u(t){return Object.prototype.toString.call(t)}function h(t){return!i(t)&&("function"==typeof r.ArrayBuffer&&("function"==typeof ArrayBuffer.isView?ArrayBuffer.isView(t):!!t&&(t instanceof DataView||!!(t.buffer&&t.buffer instanceof ArrayBuffer))))}var f=e.exports=y,p=/\s*function\s+([^\(\s]*)\s*/;function d(t){if(o.isFunction(t)){if(c)return t.name;var e=t.toString().match(p);return e&&e[1]}}function g(t,e){return"string"==typeof t?t.length<e?t:t.slice(0,e):t}function m(t){if(c||!o.isFunction(t))return o.inspect(t);var e=d(t);return"[Function"+(e?": "+e:"")+"]"}function v(t,e,r,n,a){throw new f.AssertionError({message:r,actual:t,expected:e,operator:n,stackStartFunction:a})}function y(t,e){t||v(t,!0,e,"==",f.ok)}function x(t,e,r,n){if(t===e)return!0;if(i(t)&&i(e))return 0===a(t,e);if(o.isDate(t)&&o.isDate(e))return t.getTime()===e.getTime();if(o.isRegExp(t)&&o.isRegExp(e))return t.source===e.source&&t.global===e.global&&t.multiline===e.multiline&&t.lastIndex===e.lastIndex&&t.ignoreCase===e.ignoreCase;if(null!==t&&"object"==typeof t||null!==e&&"object"==typeof e){if(h(t)&&h(e)&&u(t)===u(e)&&!(t instanceof Float32Array||t instanceof Float64Array))return 0===a(new Uint8Array(t.buffer),new Uint8Array(e.buffer));if(i(t)!==i(e))return!1;var s=(n=n||{actual:[],expected:[]}).actual.indexOf(t);return-1!==s&&s===n.expected.indexOf(e)||(n.actual.push(t),n.expected.push(e),function(t,e,r,n){if(null==t||null==e)return!1;if(o.isPrimitive(t)||o.isPrimitive(e))return t===e;if(r&&Object.getPrototypeOf(t)!==Object.getPrototypeOf(e))return!1;var a=b(t),i=b(e);if(a&&!i||!a&&i)return!1;if(a)return t=l.call(t),e=l.call(e),x(t,e,r);var s,c,u=T(t),h=T(e);if(u.length!==h.length)return!1;for(u.sort(),h.sort(),c=u.length-1;c>=0;c--)if(u[c]!==h[c])return!1;for(c=u.length-1;c>=0;c--)if(s=u[c],!x(t[s],e[s],r,n))return!1;return!0}(t,e,r,n))}return r?t===e:t==e}function b(t){return"[object Arguments]"==Object.prototype.toString.call(t)}function _(t,e){if(!t||!e)return!1;if("[object RegExp]"==Object.prototype.toString.call(e))return e.test(t);try{if(t instanceof e)return!0}catch(t){}return!Error.isPrototypeOf(e)&&!0===e.call({},t)}function w(t,e,r,n){var a;if("function"!=typeof e)throw new TypeError('"block" argument must be a function');"string"==typeof r&&(n=r,r=null),a=function(t){var e;try{t()}catch(t){e=t}return e}(e),n=(r&&r.name?" ("+r.name+").":".")+(n?" "+n:"."),t&&!a&&v(a,r,"Missing expected exception"+n);var i="string"==typeof n,s=!t&&a&&!r;if((!t&&o.isError(a)&&i&&_(a,r)||s)&&v(a,r,"Got unwanted exception"+n),t&&a&&r&&!_(a,r)||!t&&a)throw a}f.AssertionError=function(t){this.name="AssertionError",this.actual=t.actual,this.expected=t.expected,this.operator=t.operator,t.message?(this.message=t.message,this.generatedMessage=!1):(this.message=function(t){return g(m(t.actual),128)+" "+t.operator+" "+g(m(t.expected),128)}(this),this.generatedMessage=!0);var e=t.stackStartFunction||v;if(Error.captureStackTrace)Error.captureStackTrace(this,e);else{var r=new Error;if(r.stack){var n=r.stack,a=d(e),i=n.indexOf("\n"+a);if(i>=0){var o=n.indexOf("\n",i+1);n=n.substring(o+1)}this.stack=n}}},o.inherits(f.AssertionError,Error),f.fail=v,f.ok=y,f.equal=function(t,e,r){t!=e&&v(t,e,r,"==",f.equal)},f.notEqual=function(t,e,r){t==e&&v(t,e,r,"!=",f.notEqual)},f.deepEqual=function(t,e,r){x(t,e,!1)||v(t,e,r,"deepEqual",f.deepEqual)},f.deepStrictEqual=function(t,e,r){x(t,e,!0)||v(t,e,r,"deepStrictEqual",f.deepStrictEqual)},f.notDeepEqual=function(t,e,r){x(t,e,!1)&&v(t,e,r,"notDeepEqual",f.notDeepEqual)},f.notDeepStrictEqual=function t(e,r,n){x(e,r,!0)&&v(e,r,n,"notDeepStrictEqual",t)},f.strictEqual=function(t,e,r){t!==e&&v(t,e,r,"===",f.strictEqual)},f.notStrictEqual=function(t,e,r){t===e&&v(t,e,r,"!==",f.notStrictEqual)},f.throws=function(t,e,r){w(!0,t,e,r)},f.doesNotThrow=function(t,e,r){w(!1,t,e,r)},f.ifError=function(t){if(t)throw t},f.strict=n((function t(e,r){e||v(e,!0,r,"==",t)}),f,{equal:f.strictEqual,deepEqual:f.deepStrictEqual,notEqual:f.notStrictEqual,notDeepEqual:f.notDeepStrictEqual}),f.strict.strict=f.strict;var T=Object.keys||function(t){var e=[];for(var r in t)s.call(t,r)&&e.push(r);return e}}).call(this,"undefined"!=typeof global?global:"undefined"!=typeof self?self:"undefined"!=typeof window?window:{})},{"object-assign":459,"util/":74}],72:[function(t,e,r){"function"==typeof Object.create?e.exports=function(t,e){t.super_=e,t.prototype=Object.create(e.prototype,{constructor:{value:t,enumerable:!1,writable:!0,configurable:!0}})}:e.exports=function(t,e){t.super_=e;var r=function(){};r.prototype=e.prototype,t.prototype=new r,t.prototype.constructor=t}},{}],73:[function(t,e,r){e.exports=function(t){return t&&"object"==typeof t&&"function"==typeof t.copy&&"function"==typeof t.fill&&"function"==typeof t.readUInt8}},{}],74:[function(t,e,r){(function(e,n){var a=/%[sdj%]/g;r.format=function(t){if(!v(t)){for(var e=[],r=0;r<arguments.length;r++)e.push(s(arguments[r]));return e.join(" ")}r=1;for(var n=arguments,i=n.length,o=String(t).replace(a,(function(t){if("%%"===t)return"%";if(r>=i)return t;switch(t){case"%s":return String(n[r++]);case"%d":return Number(n[r++]);case"%j":try{return JSON.stringify(n[r++])}catch(t){return"[Circular]"}default:return t}})),l=n[r];r<i;l=n[++r])g(l)||!b(l)?o+=" "+l:o+=" "+s(l);return o},r.deprecate=function(t,a){if(y(n.process))return function(){return r.deprecate(t,a).apply(this,arguments)};if(!0===e.noDeprecation)return t;var i=!1;return function(){if(!i){if(e.throwDeprecation)throw new Error(a);e.traceDeprecation?console.trace(a):console.error(a),i=!0}return t.apply(this,arguments)}};var i,o={};function s(t,e){var n={seen:[],stylize:c};return arguments.length>=3&&(n.depth=arguments[2]),arguments.length>=4&&(n.colors=arguments[3]),d(e)?n.showHidden=e:e&&r._extend(n,e),y(n.showHidden)&&(n.showHidden=!1),y(n.depth)&&(n.depth=2),y(n.colors)&&(n.colors=!1),y(n.customInspect)&&(n.customInspect=!0),n.colors&&(n.stylize=l),u(n,t,n.depth)}function l(t,e){var r=s.styles[e];return r?"\x1b["+s.colors[r][0]+"m"+t+"\x1b["+s.colors[r][1]+"m":t}function c(t,e){return t}function u(t,e,n){if(t.customInspect&&e&&T(e.inspect)&&e.inspect!==r.inspect&&(!e.constructor||e.constructor.prototype!==e)){var a=e.inspect(n,t);return v(a)||(a=u(t,a,n)),a}var i=function(t,e){if(y(e))return t.stylize("undefined","undefined");if(v(e)){var r="'"+JSON.stringify(e).replace(/^"|"$/g,"").replace(/'/g,"\\'").replace(/\\"/g,'"')+"'";return t.stylize(r,"string")}if(m(e))return t.stylize(""+e,"number");if(d(e))return t.stylize(""+e,"boolean");if(g(e))return t.stylize("null","null")}(t,e);if(i)return i;var o=Object.keys(e),s=function(t){var e={};return t.forEach((function(t,r){e[t]=!0})),e}(o);if(t.showHidden&&(o=Object.getOwnPropertyNames(e)),w(e)&&(o.indexOf("message")>=0||o.indexOf("description")>=0))return h(e);if(0===o.length){if(T(e)){var l=e.name?": "+e.name:"";return t.stylize("[Function"+l+"]","special")}if(x(e))return t.stylize(RegExp.prototype.toString.call(e),"regexp");if(_(e))return t.stylize(Date.prototype.toString.call(e),"date");if(w(e))return h(e)}var c,b="",k=!1,M=["{","}"];(p(e)&&(k=!0,M=["[","]"]),T(e))&&(b=" [Function"+(e.name?": "+e.name:"")+"]");return x(e)&&(b=" "+RegExp.prototype.toString.call(e)),_(e)&&(b=" "+Date.prototype.toUTCString.call(e)),w(e)&&(b=" "+h(e)),0!==o.length||k&&0!=e.length?n<0?x(e)?t.stylize(RegExp.prototype.toString.call(e),"regexp"):t.stylize("[Object]","special"):(t.seen.push(e),c=k?function(t,e,r,n,a){for(var i=[],o=0,s=e.length;o<s;++o)E(e,String(o))?i.push(f(t,e,r,n,String(o),!0)):i.push("");return a.forEach((function(a){a.match(/^\d+$/)||i.push(f(t,e,r,n,a,!0))})),i}(t,e,n,s,o):o.map((function(r){return f(t,e,n,s,r,k)})),t.seen.pop(),function(t,e,r){if(t.reduce((function(t,e){return e.indexOf("\n")>=0&&0,t+e.replace(/\u001b\[\d\d?m/g,"").length+1}),0)>60)return r[0]+(""===e?"":e+"\n ")+" "+t.join(",\n  ")+" "+r[1];return r[0]+e+" "+t.join(", ")+" "+r[1]}(c,b,M)):M[0]+b+M[1]}function h(t){return"["+Error.prototype.toString.call(t)+"]"}function f(t,e,r,n,a,i){var o,s,l;if((l=Object.getOwnPropertyDescriptor(e,a)||{value:e[a]}).get?s=l.set?t.stylize("[Getter/Setter]","special"):t.stylize("[Getter]","special"):l.set&&(s=t.stylize("[Setter]","special")),E(n,a)||(o="["+a+"]"),s||(t.seen.indexOf(l.value)<0?(s=g(r)?u(t,l.value,null):u(t,l.value,r-1)).indexOf("\n")>-1&&(s=i?s.split("\n").map((function(t){return"  "+t})).join("\n").substr(2):"\n"+s.split("\n").map((function(t){return"   "+t})).join("\n")):s=t.stylize("[Circular]","special")),y(o)){if(i&&a.match(/^\d+$/))return s;(o=JSON.stringify(""+a)).match(/^"([a-zA-Z_][a-zA-Z_0-9]*)"$/)?(o=o.substr(1,o.length-2),o=t.stylize(o,"name")):(o=o.replace(/'/g,"\\'").replace(/\\"/g,'"').replace(/(^"|"$)/g,"'"),o=t.stylize(o,"string"))}return o+": "+s}function p(t){return Array.isArray(t)}function d(t){return"boolean"==typeof t}function g(t){return null===t}function m(t){return"number"==typeof t}function v(t){return"string"==typeof t}function y(t){return void 0===t}function x(t){return b(t)&&"[object RegExp]"===k(t)}function b(t){return"object"==typeof t&&null!==t}function _(t){return b(t)&&"[object Date]"===k(t)}function w(t){return b(t)&&("[object Error]"===k(t)||t instanceof Error)}function T(t){return"function"==typeof t}function k(t){return Object.prototype.toString.call(t)}function M(t){return t<10?"0"+t.toString(10):t.toString(10)}r.debuglog=function(t){if(y(i)&&(i=e.env.NODE_DEBUG||""),t=t.toUpperCase(),!o[t])if(new RegExp("\\b"+t+"\\b","i").test(i)){var n=e.pid;o[t]=function(){var e=r.format.apply(r,arguments);console.error("%s %d: %s",t,n,e)}}else o[t]=function(){};return o[t]},r.inspect=s,s.colors={bold:[1,22],italic:[3,23],underline:[4,24],inverse:[7,27],white:[37,39],grey:[90,39],black:[30,39],blue:[34,39],cyan:[36,39],green:[32,39],magenta:[35,39],red:[31,39],yellow:[33,39]},s.styles={special:"cyan",number:"yellow",boolean:"yellow",undefined:"grey",null:"bold",string:"green",date:"magenta",regexp:"red"},r.isArray=p,r.isBoolean=d,r.isNull=g,r.isNullOrUndefined=function(t){return null==t},r.isNumber=m,r.isString=v,r.isSymbol=function(t){return"symbol"==typeof t},r.isUndefined=y,r.isRegExp=x,r.isObject=b,r.isDate=_,r.isError=w,r.isFunction=T,r.isPrimitive=function(t){return null===t||"boolean"==typeof t||"number"==typeof t||"string"==typeof t||"symbol"==typeof t||"undefined"==typeof t},r.isBuffer=t("./support/isBuffer");var A=["Jan","Feb","Mar","Apr","May","Jun","Jul","Aug","Sep","Oct","Nov","Dec"];function S(){var t=new Date,e=[M(t.getHours()),M(t.getMinutes()),M(t.getSeconds())].join(":");return[t.getDate(),A[t.getMonth()],e].join(" ")}function E(t,e){return Object.prototype.hasOwnProperty.call(t,e)}r.log=function(){console.log("%s - %s",S(),r.format.apply(r,arguments))},r.inherits=t("inherits"),r._extend=function(t,e){if(!e||!b(e))return t;for(var r=Object.keys(e),n=r.length;n--;)t[r[n]]=e[r[n]];return t}}).call(this,t("_process"),"undefined"!=typeof global?global:"undefined"!=typeof self?self:"undefined"!=typeof window?window:{})},{"./support/isBuffer":73,_process:487,inherits:72}],75:[function(t,e,r){e.exports=function(t){return atob(t)}},{}],76:[function(t,e,r){"use strict";e.exports=function(t,e){for(var r=e.length,i=new Array(r+1),o=0;o<r;++o){for(var s=new Array(r+1),l=0;l<=r;++l)s[l]=t[l][o];i[o]=s}i[r]=new Array(r+1);for(o=0;o<=r;++o)i[r][o]=1;var c=new Array(r+1);for(o=0;o<r;++o)c[o]=e[o];c[r]=1;var u=n(i,c),h=a(u[r+1]);0===h&&(h=1);var f=new Array(r+1);for(o=0;o<=r;++o)f[o]=a(u[o])/h;return f};var n=t("robust-linear-solve");function a(t){for(var e=0,r=0;r<t.length;++r)e+=t[r];return e}},{"robust-linear-solve":506}],77:[function(t,e,r){"use strict";r.byteLength=function(t){var e=c(t),r=e[0],n=e[1];return 3*(r+n)/4-n},r.toByteArray=function(t){var e,r,n=c(t),o=n[0],s=n[1],l=new i(function(t,e,r){return 3*(e+r)/4-r}(0,o,s)),u=0,h=s>0?o-4:o;for(r=0;r<h;r+=4)e=a[t.charCodeAt(r)]<<18|a[t.charCodeAt(r+1)]<<12|a[t.charCodeAt(r+2)]<<6|a[t.charCodeAt(r+3)],l[u++]=e>>16&255,l[u++]=e>>8&255,l[u++]=255&e;2===s&&(e=a[t.charCodeAt(r)]<<2|a[t.charCodeAt(r+1)]>>4,l[u++]=255&e);1===s&&(e=a[t.charCodeAt(r)]<<10|a[t.charCodeAt(r+1)]<<4|a[t.charCodeAt(r+2)]>>2,l[u++]=e>>8&255,l[u++]=255&e);return l},r.fromByteArray=function(t){for(var e,r=t.length,a=r%3,i=[],o=0,s=r-a;o<s;o+=16383)i.push(u(t,o,o+16383>s?s:o+16383));1===a?(e=t[r-1],i.push(n[e>>2]+n[e<<4&63]+"==")):2===a&&(e=(t[r-2]<<8)+t[r-1],i.push(n[e>>10]+n[e>>4&63]+n[e<<2&63]+"="));return i.join("")};for(var n=[],a=[],i="undefined"!=typeof Uint8Array?Uint8Array:Array,o="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/",s=0,l=o.length;s<l;++s)n[s]=o[s],a[o.charCodeAt(s)]=s;function c(t){var e=t.length;if(e%4>0)throw new Error("Invalid string. Length must be a multiple of 4");var r=t.indexOf("=");return-1===r&&(r=e),[r,r===e?0:4-r%4]}function u(t,e,r){for(var a,i,o=[],s=e;s<r;s+=3)a=(t[s]<<16&16711680)+(t[s+1]<<8&65280)+(255&t[s+2]),o.push(n[(i=a)>>18&63]+n[i>>12&63]+n[i>>6&63]+n[63&i]);return o.join("")}a["-".charCodeAt(0)]=62,a["_".charCodeAt(0)]=63},{}],78:[function(t,e,r){"use strict";var n=t("./lib/rationalize");e.exports=function(t,e){return n(t[0].mul(e[1]).add(e[0].mul(t[1])),t[1].mul(e[1]))}},{"./lib/rationalize":88}],79:[function(t,e,r){"use strict";e.exports=function(t,e){return t[0].mul(e[1]).cmp(e[0].mul(t[1]))}},{}],80:[function(t,e,r){"use strict";var n=t("./lib/rationalize");e.exports=function(t,e){return n(t[0].mul(e[1]),t[1].mul(e[0]))}},{"./lib/rationalize":88}],81:[function(t,e,r){"use strict";var n=t("./is-rat"),a=t("./lib/is-bn"),i=t("./lib/num-to-bn"),o=t("./lib/str-to-bn"),s=t("./lib/rationalize"),l=t("./div");e.exports=function t(e,r){if(n(e))return r?l(e,t(r)):[e[0].clone(),e[1].clone()];var c,u,h=0;if(a(e))c=e.clone();else if("string"==typeof e)c=o(e);else{if(0===e)return[i(0),i(1)];if(e===Math.floor(e))c=i(e);else{for(;e!==Math.floor(e);)e*=Math.pow(2,256),h-=256;c=i(e)}}if(n(r))c.mul(r[1]),u=r[0].clone();else if(a(r))u=r.clone();else if("string"==typeof r)u=o(r);else if(r)if(r===Math.floor(r))u=i(r);else{for(;r!==Math.floor(r);)r*=Math.pow(2,256),h+=256;u=i(r)}else u=i(1);h>0?c=c.ushln(h):h<0&&(u=u.ushln(-h));return s(c,u)}},{"./div":80,"./is-rat":82,"./lib/is-bn":86,"./lib/num-to-bn":87,"./lib/rationalize":88,"./lib/str-to-bn":89}],82:[function(t,e,r){"use strict";var n=t("./lib/is-bn");e.exports=function(t){return Array.isArray(t)&&2===t.length&&n(t[0])&&n(t[1])}},{"./lib/is-bn":86}],83:[function(t,e,r){"use strict";var n=t("bn.js");e.exports=function(t){return t.cmp(new n(0))}},{"bn.js":97}],84:[function(t,e,r){"use strict";var n=t("./bn-sign");e.exports=function(t){var e=t.length,r=t.words,a=0;if(1===e)a=r[0];else if(2===e)a=r[0]+67108864*r[1];else for(var i=0;i<e;i++){var o=r[i];a+=o*Math.pow(67108864,i)}return n(t)*a}},{"./bn-sign":83}],85:[function(t,e,r){"use strict";var n=t("double-bits"),a=t("bit-twiddle").countTrailingZeros;e.exports=function(t){var e=a(n.lo(t));if(e<32)return e;var r=a(n.hi(t));if(r>20)return 52;return r+32}},{"bit-twiddle":95,"double-bits":169}],86:[function(t,e,r){"use strict";t("bn.js");e.exports=function(t){return t&&"object"==typeof t&&Boolean(t.words)}},{"bn.js":97}],87:[function(t,e,r){"use strict";var n=t("bn.js"),a=t("double-bits");e.exports=function(t){var e=a.exponent(t);return e<52?new n(t):new n(t*Math.pow(2,52-e)).ushln(e-52)}},{"bn.js":97,"double-bits":169}],88:[function(t,e,r){"use strict";var n=t("./num-to-bn"),a=t("./bn-sign");e.exports=function(t,e){var r=a(t),i=a(e);if(0===r)return[n(0),n(1)];if(0===i)return[n(0),n(0)];i<0&&(t=t.neg(),e=e.neg());var o=t.gcd(e);if(o.cmpn(1))return[t.div(o),e.div(o)];return[t,e]}},{"./bn-sign":83,"./num-to-bn":87}],89:[function(t,e,r){"use strict";var n=t("bn.js");e.exports=function(t){return new n(t)}},{"bn.js":97}],90:[function(t,e,r){"use strict";var n=t("./lib/rationalize");e.exports=function(t,e){return n(t[0].mul(e[0]),t[1].mul(e[1]))}},{"./lib/rationalize":88}],91:[function(t,e,r){"use strict";var n=t("./lib/bn-sign");e.exports=function(t){return n(t[0])*n(t[1])}},{"./lib/bn-sign":83}],92:[function(t,e,r){"use strict";var n=t("./lib/rationalize");e.exports=function(t,e){return n(t[0].mul(e[1]).sub(t[1].mul(e[0])),t[1].mul(e[1]))}},{"./lib/rationalize":88}],93:[function(t,e,r){"use strict";var n=t("./lib/bn-to-num"),a=t("./lib/ctz");e.exports=function(t){var e=t[0],r=t[1];if(0===e.cmpn(0))return 0;var i=e.abs().divmod(r.abs()),o=i.div,s=n(o),l=i.mod,c=e.negative!==r.negative?-1:1;if(0===l.cmpn(0))return c*s;if(s){var u=a(s)+4,h=n(l.ushln(u).divRound(r));return c*(s+h*Math.pow(2,-u))}var f=r.bitLength()-l.bitLength()+53;h=n(l.ushln(f).divRound(r));return f<1023?c*h*Math.pow(2,-f):(h*=Math.pow(2,-1023),c*h*Math.pow(2,1023-f))}},{"./lib/bn-to-num":84,"./lib/ctz":85}],94:[function(t,e,r){"use strict";function n(t,e,r,n,a){var i=["function ",t,"(a,l,h,",n.join(","),"){",a?"":"var i=",r?"l-1":"h+1",";while(l<=h){var m=(l+h)>>>1,x=a[m]"];return a?e.indexOf("c")<0?i.push(";if(x===y){return m}else if(x<=y){"):i.push(";var p=c(x,y);if(p===0){return m}else if(p<=0){"):i.push(";if(",e,"){i=m;"),r?i.push("l=m+1}else{h=m-1}"):i.push("h=m-1}else{l=m+1}"),i.push("}"),a?i.push("return -1};"):i.push("return i};"),i.join("")}function a(t,e,r,a){return new Function([n("A","x"+t+"y",e,["y"],a),n("P","c(x,y)"+t+"0",e,["y","c"],a),"function dispatchBsearch",r,"(a,y,c,l,h){if(typeof(c)==='function'){return P(a,(l===void 0)?0:l|0,(h===void 0)?a.length-1:h|0,y,c)}else{return A(a,(c===void 0)?0:c|0,(l===void 0)?a.length-1:l|0,y)}}return dispatchBsearch",r].join(""))()}e.exports={ge:a(">=",!1,"GE"),gt:a(">",!1,"GT"),lt:a("<",!0,"LT"),le:a("<=",!0,"LE"),eq:a("-",!0,"EQ",!0)}},{}],95:[function(t,e,r){"use strict";function n(t){var e=32;return(t&=-t)&&e--,65535&t&&(e-=16),16711935&t&&(e-=8),252645135&t&&(e-=4),858993459&t&&(e-=2),1431655765&t&&(e-=1),e}r.INT_BITS=32,r.INT_MAX=2147483647,r.INT_MIN=-1<<31,r.sign=function(t){return(t>0)-(t<0)},r.abs=function(t){var e=t>>31;return(t^e)-e},r.min=function(t,e){return e^(t^e)&-(t<e)},r.max=function(t,e){return t^(t^e)&-(t<e)},r.isPow2=function(t){return!(t&t-1||!t)},r.log2=function(t){var e,r;return e=(t>65535)<<4,e|=r=((t>>>=e)>255)<<3,e|=r=((t>>>=r)>15)<<2,(e|=r=((t>>>=r)>3)<<1)|(t>>>=r)>>1},r.log10=function(t){return t>=1e9?9:t>=1e8?8:t>=1e7?7:t>=1e6?6:t>=1e5?5:t>=1e4?4:t>=1e3?3:t>=100?2:t>=10?1:0},r.popCount=function(t){return 16843009*((t=(858993459&(t-=t>>>1&1431655765))+(t>>>2&858993459))+(t>>>4)&252645135)>>>24},r.countTrailingZeros=n,r.nextPow2=function(t){return t+=0===t,--t,t|=t>>>1,t|=t>>>2,t|=t>>>4,t|=t>>>8,(t|=t>>>16)+1},r.prevPow2=function(t){return t|=t>>>1,t|=t>>>2,t|=t>>>4,t|=t>>>8,(t|=t>>>16)-(t>>>1)},r.parity=function(t){return t^=t>>>16,t^=t>>>8,t^=t>>>4,27030>>>(t&=15)&1};var a=new Array(256);!function(t){for(var e=0;e<256;++e){var r=e,n=e,a=7;for(r>>>=1;r;r>>>=1)n<<=1,n|=1&r,--a;t[e]=n<<a&255}}(a),r.reverse=function(t){return a[255&t]<<24|a[t>>>8&255]<<16|a[t>>>16&255]<<8|a[t>>>24&255]},r.interleave2=function(t,e){return(t=1431655765&((t=858993459&((t=252645135&((t=16711935&((t&=65535)|t<<8))|t<<4))|t<<2))|t<<1))|(e=1431655765&((e=858993459&((e=252645135&((e=16711935&((e&=65535)|e<<8))|e<<4))|e<<2))|e<<1))<<1},r.deinterleave2=function(t,e){return(t=65535&((t=16711935&((t=252645135&((t=858993459&((t=t>>>e&1431655765)|t>>>1))|t>>>2))|t>>>4))|t>>>16))<<16>>16},r.interleave3=function(t,e,r){return t=1227133513&((t=3272356035&((t=251719695&((t=4278190335&((t&=1023)|t<<16))|t<<8))|t<<4))|t<<2),(t|=(e=1227133513&((e=3272356035&((e=251719695&((e=4278190335&((e&=1023)|e<<16))|e<<8))|e<<4))|e<<2))<<1)|(r=1227133513&((r=3272356035&((r=251719695&((r=4278190335&((r&=1023)|r<<16))|r<<8))|r<<4))|r<<2))<<2},r.deinterleave3=function(t,e){return(t=1023&((t=4278190335&((t=251719695&((t=3272356035&((t=t>>>e&1227133513)|t>>>2))|t>>>4))|t>>>8))|t>>>16))<<22>>22},r.nextCombination=function(t){var e=t|t-1;return e+1|(~e&-~e)-1>>>n(t)+1}},{}],96:[function(t,e,r){"use strict";var n=t("clamp");e.exports=function(t,e){e||(e={});var r,o,s,l,c,u,h,f,p,d,g,m=null==e.cutoff?.25:e.cutoff,v=null==e.radius?8:e.radius,y=e.channel||0;if(ArrayBuffer.isView(t)||Array.isArray(t)){if(!e.width||!e.height)throw Error("For raw data width and height should be provided by options");r=e.width,o=e.height,l=t,u=e.stride?e.stride:Math.floor(t.length/r/o)}else window.HTMLCanvasElement&&t instanceof window.HTMLCanvasElement?(h=(f=t).getContext("2d"),r=f.width,o=f.height,p=h.getImageData(0,0,r,o),l=p.data,u=4):window.CanvasRenderingContext2D&&t instanceof window.CanvasRenderingContext2D?(f=t.canvas,h=t,r=f.width,o=f.height,p=h.getImageData(0,0,r,o),l=p.data,u=4):window.ImageData&&t instanceof window.ImageData&&(p=t,r=t.width,o=t.height,l=p.data,u=4);if(s=Math.max(r,o),window.Uint8ClampedArray&&l instanceof window.Uint8ClampedArray||window.Uint8Array&&l instanceof window.Uint8Array)for(c=l,l=Array(r*o),d=0,g=c.length;d<g;d++)l[d]=c[d*u+y]/255;else if(1!==u)throw Error("Raw data can have only 1 value per pixel");var x=Array(r*o),b=Array(r*o),_=Array(s),w=Array(s),T=Array(s+1),k=Array(s);for(d=0,g=r*o;d<g;d++){var M=l[d];x[d]=1===M?0:0===M?a:Math.pow(Math.max(0,.5-M),2),b[d]=1===M?a:0===M?0:Math.pow(Math.max(0,M-.5),2)}i(x,r,o,_,w,k,T),i(b,r,o,_,w,k,T);var A=window.Float32Array?new Float32Array(r*o):new Array(r*o);for(d=0,g=r*o;d<g;d++)A[d]=n(1-((x[d]-b[d])/v+m),0,1);return A};var a=1e20;function i(t,e,r,n,a,i,s){for(var l=0;l<e;l++){for(var c=0;c<r;c++)n[c]=t[c*e+l];for(o(n,a,i,s,r),c=0;c<r;c++)t[c*e+l]=a[c]}for(c=0;c<r;c++){for(l=0;l<e;l++)n[l]=t[c*e+l];for(o(n,a,i,s,e),l=0;l<e;l++)t[c*e+l]=Math.sqrt(a[l])}}function o(t,e,r,n,i){r[0]=0,n[0]=-a,n[1]=+a;for(var o=1,s=0;o<i;o++){for(var l=(t[o]+o*o-(t[r[s]]+r[s]*r[s]))/(2*o-2*r[s]);l<=n[s];)s--,l=(t[o]+o*o-(t[r[s]]+r[s]*r[s]))/(2*o-2*r[s]);r[++s]=o,n[s]=l,n[s+1]=+a}for(o=0,s=0;o<i;o++){for(;n[s+1]<o;)s++;e[o]=(o-r[s])*(o-r[s])+t[r[s]]}}},{clamp:117}],97:[function(t,e,r){!function(e,r){"use strict";function n(t,e){if(!t)throw new Error(e||"Assertion failed")}function a(t,e){t.super_=e;var r=function(){};r.prototype=e.prototype,t.prototype=new r,t.prototype.constructor=t}function i(t,e,r){if(i.isBN(t))return t;this.negative=0,this.words=null,this.length=0,this.red=null,null!==t&&("le"!==e&&"be"!==e||(r=e,e=10),this._init(t||0,e||10,r||"be"))}var o;"object"==typeof e?e.exports=i:r.BN=i,i.BN=i,i.wordSize=26;try{o=t("buffer").Buffer}catch(t){}function s(t,e,r){for(var n=0,a=Math.min(t.length,r),i=e;i<a;i++){var o=t.charCodeAt(i)-48;n<<=4,n|=o>=49&&o<=54?o-49+10:o>=17&&o<=22?o-17+10:15&o}return n}function l(t,e,r,n){for(var a=0,i=Math.min(t.length,r),o=e;o<i;o++){var s=t.charCodeAt(o)-48;a*=n,a+=s>=49?s-49+10:s>=17?s-17+10:s}return a}i.isBN=function(t){return t instanceof i||null!==t&&"object"==typeof t&&t.constructor.wordSize===i.wordSize&&Array.isArray(t.words)},i.max=function(t,e){return t.cmp(e)>0?t:e},i.min=function(t,e){return t.cmp(e)<0?t:e},i.prototype._init=function(t,e,r){if("number"==typeof t)return this._initNumber(t,e,r);if("object"==typeof t)return this._initArray(t,e,r);"hex"===e&&(e=16),n(e===(0|e)&&e>=2&&e<=36);var a=0;"-"===(t=t.toString().replace(/\s+/g,""))[0]&&a++,16===e?this._parseHex(t,a):this._parseBase(t,e,a),"-"===t[0]&&(this.negative=1),this.strip(),"le"===r&&this._initArray(this.toArray(),e,r)},i.prototype._initNumber=function(t,e,r){t<0&&(this.negative=1,t=-t),t<67108864?(this.words=[67108863&t],this.length=1):t<4503599627370496?(this.words=[67108863&t,t/67108864&67108863],this.length=2):(n(t<9007199254740992),this.words=[67108863&t,t/67108864&67108863,1],this.length=3),"le"===r&&this._initArray(this.toArray(),e,r)},i.prototype._initArray=function(t,e,r){if(n("number"==typeof t.length),t.length<=0)return this.words=[0],this.length=1,this;this.length=Math.ceil(t.length/3),this.words=new Array(this.length);for(var a=0;a<this.length;a++)this.words[a]=0;var i,o,s=0;if("be"===r)for(a=t.length-1,i=0;a>=0;a-=3)o=t[a]|t[a-1]<<8|t[a-2]<<16,this.words[i]|=o<<s&67108863,this.words[i+1]=o>>>26-s&67108863,(s+=24)>=26&&(s-=26,i++);else if("le"===r)for(a=0,i=0;a<t.length;a+=3)o=t[a]|t[a+1]<<8|t[a+2]<<16,this.words[i]|=o<<s&67108863,this.words[i+1]=o>>>26-s&67108863,(s+=24)>=26&&(s-=26,i++);return this.strip()},i.prototype._parseHex=function(t,e){this.length=Math.ceil((t.length-e)/6),this.words=new Array(this.length);for(var r=0;r<this.length;r++)this.words[r]=0;var n,a,i=0;for(r=t.length-6,n=0;r>=e;r-=6)a=s(t,r,r+6),this.words[n]|=a<<i&67108863,this.words[n+1]|=a>>>26-i&4194303,(i+=24)>=26&&(i-=26,n++);r+6!==e&&(a=s(t,e,r+6),this.words[n]|=a<<i&67108863,this.words[n+1]|=a>>>26-i&4194303),this.strip()},i.prototype._parseBase=function(t,e,r){this.words=[0],this.length=1;for(var n=0,a=1;a<=67108863;a*=e)n++;n--,a=a/e|0;for(var i=t.length-r,o=i%n,s=Math.min(i,i-o)+r,c=0,u=r;u<s;u+=n)c=l(t,u,u+n,e),this.imuln(a),this.words[0]+c<67108864?this.words[0]+=c:this._iaddn(c);if(0!==o){var h=1;for(c=l(t,u,t.length,e),u=0;u<o;u++)h*=e;this.imuln(h),this.words[0]+c<67108864?this.words[0]+=c:this._iaddn(c)}},i.prototype.copy=function(t){t.words=new Array(this.length);for(var e=0;e<this.length;e++)t.words[e]=this.words[e];t.length=this.length,t.negative=this.negative,t.red=this.red},i.prototype.clone=function(){var t=new i(null);return this.copy(t),t},i.prototype._expand=function(t){for(;this.length<t;)this.words[this.length++]=0;return this},i.prototype.strip=function(){for(;this.length>1&&0===this.words[this.length-1];)this.length--;return this._normSign()},i.prototype._normSign=function(){return 1===this.length&&0===this.words[0]&&(this.negative=0),this},i.prototype.inspect=function(){return(this.red?"<BN-R: ":"<BN: ")+this.toString(16)+">"};var c=["","0","00","000","0000","00000","000000","0000000","00000000","000000000","0000000000","00000000000","000000000000","0000000000000","00000000000000","000000000000000","0000000000000000","00000000000000000","000000000000000000","0000000000000000000","00000000000000000000","000000000000000000000","0000000000000000000000","00000000000000000000000","000000000000000000000000","0000000000000000000000000"],u=[0,0,25,16,12,11,10,9,8,8,7,7,7,7,6,6,6,6,6,6,6,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5],h=[0,0,33554432,43046721,16777216,48828125,60466176,40353607,16777216,43046721,1e7,19487171,35831808,62748517,7529536,11390625,16777216,24137569,34012224,47045881,64e6,4084101,5153632,6436343,7962624,9765625,11881376,14348907,17210368,20511149,243e5,28629151,33554432,39135393,45435424,52521875,60466176];function f(t,e,r){r.negative=e.negative^t.negative;var n=t.length+e.length|0;r.length=n,n=n-1|0;var a=0|t.words[0],i=0|e.words[0],o=a*i,s=67108863&o,l=o/67108864|0;r.words[0]=s;for(var c=1;c<n;c++){for(var u=l>>>26,h=67108863&l,f=Math.min(c,e.length-1),p=Math.max(0,c-t.length+1);p<=f;p++){var d=c-p|0;u+=(o=(a=0|t.words[d])*(i=0|e.words[p])+h)/67108864|0,h=67108863&o}r.words[c]=0|h,l=0|u}return 0!==l?r.words[c]=0|l:r.length--,r.strip()}i.prototype.toString=function(t,e){var r;if(e=0|e||1,16===(t=t||10)||"hex"===t){r="";for(var a=0,i=0,o=0;o<this.length;o++){var s=this.words[o],l=(16777215&(s<<a|i)).toString(16);r=0!==(i=s>>>24-a&16777215)||o!==this.length-1?c[6-l.length]+l+r:l+r,(a+=2)>=26&&(a-=26,o--)}for(0!==i&&(r=i.toString(16)+r);r.length%e!=0;)r="0"+r;return 0!==this.negative&&(r="-"+r),r}if(t===(0|t)&&t>=2&&t<=36){var f=u[t],p=h[t];r="";var d=this.clone();for(d.negative=0;!d.isZero();){var g=d.modn(p).toString(t);r=(d=d.idivn(p)).isZero()?g+r:c[f-g.length]+g+r}for(this.isZero()&&(r="0"+r);r.length%e!=0;)r="0"+r;return 0!==this.negative&&(r="-"+r),r}n(!1,"Base should be between 2 and 36")},i.prototype.toNumber=function(){var t=this.words[0];return 2===this.length?t+=67108864*this.words[1]:3===this.length&&1===this.words[2]?t+=4503599627370496+67108864*this.words[1]:this.length>2&&n(!1,"Number can only safely store up to 53 bits"),0!==this.negative?-t:t},i.prototype.toJSON=function(){return this.toString(16)},i.prototype.toBuffer=function(t,e){return n("undefined"!=typeof o),this.toArrayLike(o,t,e)},i.prototype.toArray=function(t,e){return this.toArrayLike(Array,t,e)},i.prototype.toArrayLike=function(t,e,r){var a=this.byteLength(),i=r||Math.max(1,a);n(a<=i,"byte array longer than desired length"),n(i>0,"Requested array length <= 0"),this.strip();var o,s,l="le"===e,c=new t(i),u=this.clone();if(l){for(s=0;!u.isZero();s++)o=u.andln(255),u.iushrn(8),c[s]=o;for(;s<i;s++)c[s]=0}else{for(s=0;s<i-a;s++)c[s]=0;for(s=0;!u.isZero();s++)o=u.andln(255),u.iushrn(8),c[i-s-1]=o}return c},Math.clz32?i.prototype._countBits=function(t){return 32-Math.clz32(t)}:i.prototype._countBits=function(t){var e=t,r=0;return e>=4096&&(r+=13,e>>>=13),e>=64&&(r+=7,e>>>=7),e>=8&&(r+=4,e>>>=4),e>=2&&(r+=2,e>>>=2),r+e},i.prototype._zeroBits=function(t){if(0===t)return 26;var e=t,r=0;return 0==(8191&e)&&(r+=13,e>>>=13),0==(127&e)&&(r+=7,e>>>=7),0==(15&e)&&(r+=4,e>>>=4),0==(3&e)&&(r+=2,e>>>=2),0==(1&e)&&r++,r},i.prototype.bitLength=function(){var t=this.words[this.length-1],e=this._countBits(t);return 26*(this.length-1)+e},i.prototype.zeroBits=function(){if(this.isZero())return 0;for(var t=0,e=0;e<this.length;e++){var r=this._zeroBits(this.words[e]);if(t+=r,26!==r)break}return t},i.prototype.byteLength=function(){return Math.ceil(this.bitLength()/8)},i.prototype.toTwos=function(t){return 0!==this.negative?this.abs().inotn(t).iaddn(1):this.clone()},i.prototype.fromTwos=function(t){return this.testn(t-1)?this.notn(t).iaddn(1).ineg():this.clone()},i.prototype.isNeg=function(){return 0!==this.negative},i.prototype.neg=function(){return this.clone().ineg()},i.prototype.ineg=function(){return this.isZero()||(this.negative^=1),this},i.prototype.iuor=function(t){for(;this.length<t.length;)this.words[this.length++]=0;for(var e=0;e<t.length;e++)this.words[e]=this.words[e]|t.words[e];return this.strip()},i.prototype.ior=function(t){return n(0==(this.negative|t.negative)),this.iuor(t)},i.prototype.or=function(t){return this.length>t.length?this.clone().ior(t):t.clone().ior(this)},i.prototype.uor=function(t){return this.length>t.length?this.clone().iuor(t):t.clone().iuor(this)},i.prototype.iuand=function(t){var e;e=this.length>t.length?t:this;for(var r=0;r<e.length;r++)this.words[r]=this.words[r]&t.words[r];return this.length=e.length,this.strip()},i.prototype.iand=function(t){return n(0==(this.negative|t.negative)),this.iuand(t)},i.prototype.and=function(t){return this.length>t.length?this.clone().iand(t):t.clone().iand(this)},i.prototype.uand=function(t){return this.length>t.length?this.clone().iuand(t):t.clone().iuand(this)},i.prototype.iuxor=function(t){var e,r;this.length>t.length?(e=this,r=t):(e=t,r=this);for(var n=0;n<r.length;n++)this.words[n]=e.words[n]^r.words[n];if(this!==e)for(;n<e.length;n++)this.words[n]=e.words[n];return this.length=e.length,this.strip()},i.prototype.ixor=function(t){return n(0==(this.negative|t.negative)),this.iuxor(t)},i.prototype.xor=function(t){return this.length>t.length?this.clone().ixor(t):t.clone().ixor(this)},i.prototype.uxor=function(t){return this.length>t.length?this.clone().iuxor(t):t.clone().iuxor(this)},i.prototype.inotn=function(t){n("number"==typeof t&&t>=0);var e=0|Math.ceil(t/26),r=t%26;this._expand(e),r>0&&e--;for(var a=0;a<e;a++)this.words[a]=67108863&~this.words[a];return r>0&&(this.words[a]=~this.words[a]&67108863>>26-r),this.strip()},i.prototype.notn=function(t){return this.clone().inotn(t)},i.prototype.setn=function(t,e){n("number"==typeof t&&t>=0);var r=t/26|0,a=t%26;return this._expand(r+1),this.words[r]=e?this.words[r]|1<<a:this.words[r]&~(1<<a),this.strip()},i.prototype.iadd=function(t){var e,r,n;if(0!==this.negative&&0===t.negative)return this.negative=0,e=this.isub(t),this.negative^=1,this._normSign();if(0===this.negative&&0!==t.negative)return t.negative=0,e=this.isub(t),t.negative=1,e._normSign();this.length>t.length?(r=this,n=t):(r=t,n=this);for(var a=0,i=0;i<n.length;i++)e=(0|r.words[i])+(0|n.words[i])+a,this.words[i]=67108863&e,a=e>>>26;for(;0!==a&&i<r.length;i++)e=(0|r.words[i])+a,this.words[i]=67108863&e,a=e>>>26;if(this.length=r.length,0!==a)this.words[this.length]=a,this.length++;else if(r!==this)for(;i<r.length;i++)this.words[i]=r.words[i];return this},i.prototype.add=function(t){var e;return 0!==t.negative&&0===this.negative?(t.negative=0,e=this.sub(t),t.negative^=1,e):0===t.negative&&0!==this.negative?(this.negative=0,e=t.sub(this),this.negative=1,e):this.length>t.length?this.clone().iadd(t):t.clone().iadd(this)},i.prototype.isub=function(t){if(0!==t.negative){t.negative=0;var e=this.iadd(t);return t.negative=1,e._normSign()}if(0!==this.negative)return this.negative=0,this.iadd(t),this.negative=1,this._normSign();var r,n,a=this.cmp(t);if(0===a)return this.negative=0,this.length=1,this.words[0]=0,this;a>0?(r=this,n=t):(r=t,n=this);for(var i=0,o=0;o<n.length;o++)i=(e=(0|r.words[o])-(0|n.words[o])+i)>>26,this.words[o]=67108863&e;for(;0!==i&&o<r.length;o++)i=(e=(0|r.words[o])+i)>>26,this.words[o]=67108863&e;if(0===i&&o<r.length&&r!==this)for(;o<r.length;o++)this.words[o]=r.words[o];return this.length=Math.max(this.length,o),r!==this&&(this.negative=1),this.strip()},i.prototype.sub=function(t){return this.clone().isub(t)};var p=function(t,e,r){var n,a,i,o=t.words,s=e.words,l=r.words,c=0,u=0|o[0],h=8191&u,f=u>>>13,p=0|o[1],d=8191&p,g=p>>>13,m=0|o[2],v=8191&m,y=m>>>13,x=0|o[3],b=8191&x,_=x>>>13,w=0|o[4],T=8191&w,k=w>>>13,M=0|o[5],A=8191&M,S=M>>>13,E=0|o[6],C=8191&E,L=E>>>13,P=0|o[7],I=8191&P,z=P>>>13,O=0|o[8],D=8191&O,R=O>>>13,F=0|o[9],B=8191&F,N=F>>>13,j=0|s[0],U=8191&j,V=j>>>13,q=0|s[1],H=8191&q,G=q>>>13,Y=0|s[2],W=8191&Y,Z=Y>>>13,X=0|s[3],J=8191&X,K=X>>>13,Q=0|s[4],$=8191&Q,tt=Q>>>13,et=0|s[5],rt=8191&et,nt=et>>>13,at=0|s[6],it=8191&at,ot=at>>>13,st=0|s[7],lt=8191&st,ct=st>>>13,ut=0|s[8],ht=8191&ut,ft=ut>>>13,pt=0|s[9],dt=8191&pt,gt=pt>>>13;r.negative=t.negative^e.negative,r.length=19;var mt=(c+(n=Math.imul(h,U))|0)+((8191&(a=(a=Math.imul(h,V))+Math.imul(f,U)|0))<<13)|0;c=((i=Math.imul(f,V))+(a>>>13)|0)+(mt>>>26)|0,mt&=67108863,n=Math.imul(d,U),a=(a=Math.imul(d,V))+Math.imul(g,U)|0,i=Math.imul(g,V);var vt=(c+(n=n+Math.imul(h,H)|0)|0)+((8191&(a=(a=a+Math.imul(h,G)|0)+Math.imul(f,H)|0))<<13)|0;c=((i=i+Math.imul(f,G)|0)+(a>>>13)|0)+(vt>>>26)|0,vt&=67108863,n=Math.imul(v,U),a=(a=Math.imul(v,V))+Math.imul(y,U)|0,i=Math.imul(y,V),n=n+Math.imul(d,H)|0,a=(a=a+Math.imul(d,G)|0)+Math.imul(g,H)|0,i=i+Math.imul(g,G)|0;var yt=(c+(n=n+Math.imul(h,W)|0)|0)+((8191&(a=(a=a+Math.imul(h,Z)|0)+Math.imul(f,W)|0))<<13)|0;c=((i=i+Math.imul(f,Z)|0)+(a>>>13)|0)+(yt>>>26)|0,yt&=67108863,n=Math.imul(b,U),a=(a=Math.imul(b,V))+Math.imul(_,U)|0,i=Math.imul(_,V),n=n+Math.imul(v,H)|0,a=(a=a+Math.imul(v,G)|0)+Math.imul(y,H)|0,i=i+Math.imul(y,G)|0,n=n+Math.imul(d,W)|0,a=(a=a+Math.imul(d,Z)|0)+Math.imul(g,W)|0,i=i+Math.imul(g,Z)|0;var xt=(c+(n=n+Math.imul(h,J)|0)|0)+((8191&(a=(a=a+Math.imul(h,K)|0)+Math.imul(f,J)|0))<<13)|0;c=((i=i+Math.imul(f,K)|0)+(a>>>13)|0)+(xt>>>26)|0,xt&=67108863,n=Math.imul(T,U),a=(a=Math.imul(T,V))+Math.imul(k,U)|0,i=Math.imul(k,V),n=n+Math.imul(b,H)|0,a=(a=a+Math.imul(b,G)|0)+Math.imul(_,H)|0,i=i+Math.imul(_,G)|0,n=n+Math.imul(v,W)|0,a=(a=a+Math.imul(v,Z)|0)+Math.imul(y,W)|0,i=i+Math.imul(y,Z)|0,n=n+Math.imul(d,J)|0,a=(a=a+Math.imul(d,K)|0)+Math.imul(g,J)|0,i=i+Math.imul(g,K)|0;var bt=(c+(n=n+Math.imul(h,$)|0)|0)+((8191&(a=(a=a+Math.imul(h,tt)|0)+Math.imul(f,$)|0))<<13)|0;c=((i=i+Math.imul(f,tt)|0)+(a>>>13)|0)+(bt>>>26)|0,bt&=67108863,n=Math.imul(A,U),a=(a=Math.imul(A,V))+Math.imul(S,U)|0,i=Math.imul(S,V),n=n+Math.imul(T,H)|0,a=(a=a+Math.imul(T,G)|0)+Math.imul(k,H)|0,i=i+Math.imul(k,G)|0,n=n+Math.imul(b,W)|0,a=(a=a+Math.imul(b,Z)|0)+Math.imul(_,W)|0,i=i+Math.imul(_,Z)|0,n=n+Math.imul(v,J)|0,a=(a=a+Math.imul(v,K)|0)+Math.imul(y,J)|0,i=i+Math.imul(y,K)|0,n=n+Math.imul(d,$)|0,a=(a=a+Math.imul(d,tt)|0)+Math.imul(g,$)|0,i=i+Math.imul(g,tt)|0;var _t=(c+(n=n+Math.imul(h,rt)|0)|0)+((8191&(a=(a=a+Math.imul(h,nt)|0)+Math.imul(f,rt)|0))<<13)|0;c=((i=i+Math.imul(f,nt)|0)+(a>>>13)|0)+(_t>>>26)|0,_t&=67108863,n=Math.imul(C,U),a=(a=Math.imul(C,V))+Math.imul(L,U)|0,i=Math.imul(L,V),n=n+Math.imul(A,H)|0,a=(a=a+Math.imul(A,G)|0)+Math.imul(S,H)|0,i=i+Math.imul(S,G)|0,n=n+Math.imul(T,W)|0,a=(a=a+Math.imul(T,Z)|0)+Math.imul(k,W)|0,i=i+Math.imul(k,Z)|0,n=n+Math.imul(b,J)|0,a=(a=a+Math.imul(b,K)|0)+Math.imul(_,J)|0,i=i+Math.imul(_,K)|0,n=n+Math.imul(v,$)|0,a=(a=a+Math.imul(v,tt)|0)+Math.imul(y,$)|0,i=i+Math.imul(y,tt)|0,n=n+Math.imul(d,rt)|0,a=(a=a+Math.imul(d,nt)|0)+Math.imul(g,rt)|0,i=i+Math.imul(g,nt)|0;var wt=(c+(n=n+Math.imul(h,it)|0)|0)+((8191&(a=(a=a+Math.imul(h,ot)|0)+Math.imul(f,it)|0))<<13)|0;c=((i=i+Math.imul(f,ot)|0)+(a>>>13)|0)+(wt>>>26)|0,wt&=67108863,n=Math.imul(I,U),a=(a=Math.imul(I,V))+Math.imul(z,U)|0,i=Math.imul(z,V),n=n+Math.imul(C,H)|0,a=(a=a+Math.imul(C,G)|0)+Math.imul(L,H)|0,i=i+Math.imul(L,G)|0,n=n+Math.imul(A,W)|0,a=(a=a+Math.imul(A,Z)|0)+Math.imul(S,W)|0,i=i+Math.imul(S,Z)|0,n=n+Math.imul(T,J)|0,a=(a=a+Math.imul(T,K)|0)+Math.imul(k,J)|0,i=i+Math.imul(k,K)|0,n=n+Math.imul(b,$)|0,a=(a=a+Math.imul(b,tt)|0)+Math.imul(_,$)|0,i=i+Math.imul(_,tt)|0,n=n+Math.imul(v,rt)|0,a=(a=a+Math.imul(v,nt)|0)+Math.imul(y,rt)|0,i=i+Math.imul(y,nt)|0,n=n+Math.imul(d,it)|0,a=(a=a+Math.imul(d,ot)|0)+Math.imul(g,it)|0,i=i+Math.imul(g,ot)|0;var Tt=(c+(n=n+Math.imul(h,lt)|0)|0)+((8191&(a=(a=a+Math.imul(h,ct)|0)+Math.imul(f,lt)|0))<<13)|0;c=((i=i+Math.imul(f,ct)|0)+(a>>>13)|0)+(Tt>>>26)|0,Tt&=67108863,n=Math.imul(D,U),a=(a=Math.imul(D,V))+Math.imul(R,U)|0,i=Math.imul(R,V),n=n+Math.imul(I,H)|0,a=(a=a+Math.imul(I,G)|0)+Math.imul(z,H)|0,i=i+Math.imul(z,G)|0,n=n+Math.imul(C,W)|0,a=(a=a+Math.imul(C,Z)|0)+Math.imul(L,W)|0,i=i+Math.imul(L,Z)|0,n=n+Math.imul(A,J)|0,a=(a=a+Math.imul(A,K)|0)+Math.imul(S,J)|0,i=i+Math.imul(S,K)|0,n=n+Math.imul(T,$)|0,a=(a=a+Math.imul(T,tt)|0)+Math.imul(k,$)|0,i=i+Math.imul(k,tt)|0,n=n+Math.imul(b,rt)|0,a=(a=a+Math.imul(b,nt)|0)+Math.imul(_,rt)|0,i=i+Math.imul(_,nt)|0,n=n+Math.imul(v,it)|0,a=(a=a+Math.imul(v,ot)|0)+Math.imul(y,it)|0,i=i+Math.imul(y,ot)|0,n=n+Math.imul(d,lt)|0,a=(a=a+Math.imul(d,ct)|0)+Math.imul(g,lt)|0,i=i+Math.imul(g,ct)|0;var kt=(c+(n=n+Math.imul(h,ht)|0)|0)+((8191&(a=(a=a+Math.imul(h,ft)|0)+Math.imul(f,ht)|0))<<13)|0;c=((i=i+Math.imul(f,ft)|0)+(a>>>13)|0)+(kt>>>26)|0,kt&=67108863,n=Math.imul(B,U),a=(a=Math.imul(B,V))+Math.imul(N,U)|0,i=Math.imul(N,V),n=n+Math.imul(D,H)|0,a=(a=a+Math.imul(D,G)|0)+Math.imul(R,H)|0,i=i+Math.imul(R,G)|0,n=n+Math.imul(I,W)|0,a=(a=a+Math.imul(I,Z)|0)+Math.imul(z,W)|0,i=i+Math.imul(z,Z)|0,n=n+Math.imul(C,J)|0,a=(a=a+Math.imul(C,K)|0)+Math.imul(L,J)|0,i=i+Math.imul(L,K)|0,n=n+Math.imul(A,$)|0,a=(a=a+Math.imul(A,tt)|0)+Math.imul(S,$)|0,i=i+Math.imul(S,tt)|0,n=n+Math.imul(T,rt)|0,a=(a=a+Math.imul(T,nt)|0)+Math.imul(k,rt)|0,i=i+Math.imul(k,nt)|0,n=n+Math.imul(b,it)|0,a=(a=a+Math.imul(b,ot)|0)+Math.imul(_,it)|0,i=i+Math.imul(_,ot)|0,n=n+Math.imul(v,lt)|0,a=(a=a+Math.imul(v,ct)|0)+Math.imul(y,lt)|0,i=i+Math.imul(y,ct)|0,n=n+Math.imul(d,ht)|0,a=(a=a+Math.imul(d,ft)|0)+Math.imul(g,ht)|0,i=i+Math.imul(g,ft)|0;var Mt=(c+(n=n+Math.imul(h,dt)|0)|0)+((8191&(a=(a=a+Math.imul(h,gt)|0)+Math.imul(f,dt)|0))<<13)|0;c=((i=i+Math.imul(f,gt)|0)+(a>>>13)|0)+(Mt>>>26)|0,Mt&=67108863,n=Math.imul(B,H),a=(a=Math.imul(B,G))+Math.imul(N,H)|0,i=Math.imul(N,G),n=n+Math.imul(D,W)|0,a=(a=a+Math.imul(D,Z)|0)+Math.imul(R,W)|0,i=i+Math.imul(R,Z)|0,n=n+Math.imul(I,J)|0,a=(a=a+Math.imul(I,K)|0)+Math.imul(z,J)|0,i=i+Math.imul(z,K)|0,n=n+Math.imul(C,$)|0,a=(a=a+Math.imul(C,tt)|0)+Math.imul(L,$)|0,i=i+Math.imul(L,tt)|0,n=n+Math.imul(A,rt)|0,a=(a=a+Math.imul(A,nt)|0)+Math.imul(S,rt)|0,i=i+Math.imul(S,nt)|0,n=n+Math.imul(T,it)|0,a=(a=a+Math.imul(T,ot)|0)+Math.imul(k,it)|0,i=i+Math.imul(k,ot)|0,n=n+Math.imul(b,lt)|0,a=(a=a+Math.imul(b,ct)|0)+Math.imul(_,lt)|0,i=i+Math.imul(_,ct)|0,n=n+Math.imul(v,ht)|0,a=(a=a+Math.imul(v,ft)|0)+Math.imul(y,ht)|0,i=i+Math.imul(y,ft)|0;var At=(c+(n=n+Math.imul(d,dt)|0)|0)+((8191&(a=(a=a+Math.imul(d,gt)|0)+Math.imul(g,dt)|0))<<13)|0;c=((i=i+Math.imul(g,gt)|0)+(a>>>13)|0)+(At>>>26)|0,At&=67108863,n=Math.imul(B,W),a=(a=Math.imul(B,Z))+Math.imul(N,W)|0,i=Math.imul(N,Z),n=n+Math.imul(D,J)|0,a=(a=a+Math.imul(D,K)|0)+Math.imul(R,J)|0,i=i+Math.imul(R,K)|0,n=n+Math.imul(I,$)|0,a=(a=a+Math.imul(I,tt)|0)+Math.imul(z,$)|0,i=i+Math.imul(z,tt)|0,n=n+Math.imul(C,rt)|0,a=(a=a+Math.imul(C,nt)|0)+Math.imul(L,rt)|0,i=i+Math.imul(L,nt)|0,n=n+Math.imul(A,it)|0,a=(a=a+Math.imul(A,ot)|0)+Math.imul(S,it)|0,i=i+Math.imul(S,ot)|0,n=n+Math.imul(T,lt)|0,a=(a=a+Math.imul(T,ct)|0)+Math.imul(k,lt)|0,i=i+Math.imul(k,ct)|0,n=n+Math.imul(b,ht)|0,a=(a=a+Math.imul(b,ft)|0)+Math.imul(_,ht)|0,i=i+Math.imul(_,ft)|0;var St=(c+(n=n+Math.imul(v,dt)|0)|0)+((8191&(a=(a=a+Math.imul(v,gt)|0)+Math.imul(y,dt)|0))<<13)|0;c=((i=i+Math.imul(y,gt)|0)+(a>>>13)|0)+(St>>>26)|0,St&=67108863,n=Math.imul(B,J),a=(a=Math.imul(B,K))+Math.imul(N,J)|0,i=Math.imul(N,K),n=n+Math.imul(D,$)|0,a=(a=a+Math.imul(D,tt)|0)+Math.imul(R,$)|0,i=i+Math.imul(R,tt)|0,n=n+Math.imul(I,rt)|0,a=(a=a+Math.imul(I,nt)|0)+Math.imul(z,rt)|0,i=i+Math.imul(z,nt)|0,n=n+Math.imul(C,it)|0,a=(a=a+Math.imul(C,ot)|0)+Math.imul(L,it)|0,i=i+Math.imul(L,ot)|0,n=n+Math.imul(A,lt)|0,a=(a=a+Math.imul(A,ct)|0)+Math.imul(S,lt)|0,i=i+Math.imul(S,ct)|0,n=n+Math.imul(T,ht)|0,a=(a=a+Math.imul(T,ft)|0)+Math.imul(k,ht)|0,i=i+Math.imul(k,ft)|0;var Et=(c+(n=n+Math.imul(b,dt)|0)|0)+((8191&(a=(a=a+Math.imul(b,gt)|0)+Math.imul(_,dt)|0))<<13)|0;c=((i=i+Math.imul(_,gt)|0)+(a>>>13)|0)+(Et>>>26)|0,Et&=67108863,n=Math.imul(B,$),a=(a=Math.imul(B,tt))+Math.imul(N,$)|0,i=Math.imul(N,tt),n=n+Math.imul(D,rt)|0,a=(a=a+Math.imul(D,nt)|0)+Math.imul(R,rt)|0,i=i+Math.imul(R,nt)|0,n=n+Math.imul(I,it)|0,a=(a=a+Math.imul(I,ot)|0)+Math.imul(z,it)|0,i=i+Math.imul(z,ot)|0,n=n+Math.imul(C,lt)|0,a=(a=a+Math.imul(C,ct)|0)+Math.imul(L,lt)|0,i=i+Math.imul(L,ct)|0,n=n+Math.imul(A,ht)|0,a=(a=a+Math.imul(A,ft)|0)+Math.imul(S,ht)|0,i=i+Math.imul(S,ft)|0;var Ct=(c+(n=n+Math.imul(T,dt)|0)|0)+((8191&(a=(a=a+Math.imul(T,gt)|0)+Math.imul(k,dt)|0))<<13)|0;c=((i=i+Math.imul(k,gt)|0)+(a>>>13)|0)+(Ct>>>26)|0,Ct&=67108863,n=Math.imul(B,rt),a=(a=Math.imul(B,nt))+Math.imul(N,rt)|0,i=Math.imul(N,nt),n=n+Math.imul(D,it)|0,a=(a=a+Math.imul(D,ot)|0)+Math.imul(R,it)|0,i=i+Math.imul(R,ot)|0,n=n+Math.imul(I,lt)|0,a=(a=a+Math.imul(I,ct)|0)+Math.imul(z,lt)|0,i=i+Math.imul(z,ct)|0,n=n+Math.imul(C,ht)|0,a=(a=a+Math.imul(C,ft)|0)+Math.imul(L,ht)|0,i=i+Math.imul(L,ft)|0;var Lt=(c+(n=n+Math.imul(A,dt)|0)|0)+((8191&(a=(a=a+Math.imul(A,gt)|0)+Math.imul(S,dt)|0))<<13)|0;c=((i=i+Math.imul(S,gt)|0)+(a>>>13)|0)+(Lt>>>26)|0,Lt&=67108863,n=Math.imul(B,it),a=(a=Math.imul(B,ot))+Math.imul(N,it)|0,i=Math.imul(N,ot),n=n+Math.imul(D,lt)|0,a=(a=a+Math.imul(D,ct)|0)+Math.imul(R,lt)|0,i=i+Math.imul(R,ct)|0,n=n+Math.imul(I,ht)|0,a=(a=a+Math.imul(I,ft)|0)+Math.imul(z,ht)|0,i=i+Math.imul(z,ft)|0;var Pt=(c+(n=n+Math.imul(C,dt)|0)|0)+((8191&(a=(a=a+Math.imul(C,gt)|0)+Math.imul(L,dt)|0))<<13)|0;c=((i=i+Math.imul(L,gt)|0)+(a>>>13)|0)+(Pt>>>26)|0,Pt&=67108863,n=Math.imul(B,lt),a=(a=Math.imul(B,ct))+Math.imul(N,lt)|0,i=Math.imul(N,ct),n=n+Math.imul(D,ht)|0,a=(a=a+Math.imul(D,ft)|0)+Math.imul(R,ht)|0,i=i+Math.imul(R,ft)|0;var It=(c+(n=n+Math.imul(I,dt)|0)|0)+((8191&(a=(a=a+Math.imul(I,gt)|0)+Math.imul(z,dt)|0))<<13)|0;c=((i=i+Math.imul(z,gt)|0)+(a>>>13)|0)+(It>>>26)|0,It&=67108863,n=Math.imul(B,ht),a=(a=Math.imul(B,ft))+Math.imul(N,ht)|0,i=Math.imul(N,ft);var zt=(c+(n=n+Math.imul(D,dt)|0)|0)+((8191&(a=(a=a+Math.imul(D,gt)|0)+Math.imul(R,dt)|0))<<13)|0;c=((i=i+Math.imul(R,gt)|0)+(a>>>13)|0)+(zt>>>26)|0,zt&=67108863;var Ot=(c+(n=Math.imul(B,dt))|0)+((8191&(a=(a=Math.imul(B,gt))+Math.imul(N,dt)|0))<<13)|0;return c=((i=Math.imul(N,gt))+(a>>>13)|0)+(Ot>>>26)|0,Ot&=67108863,l[0]=mt,l[1]=vt,l[2]=yt,l[3]=xt,l[4]=bt,l[5]=_t,l[6]=wt,l[7]=Tt,l[8]=kt,l[9]=Mt,l[10]=At,l[11]=St,l[12]=Et,l[13]=Ct,l[14]=Lt,l[15]=Pt,l[16]=It,l[17]=zt,l[18]=Ot,0!==c&&(l[19]=c,r.length++),r};function d(t,e,r){return(new g).mulp(t,e,r)}function g(t,e){this.x=t,this.y=e}Math.imul||(p=f),i.prototype.mulTo=function(t,e){var r=this.length+t.length;return 10===this.length&&10===t.length?p(this,t,e):r<63?f(this,t,e):r<1024?function(t,e,r){r.negative=e.negative^t.negative,r.length=t.length+e.length;for(var n=0,a=0,i=0;i<r.length-1;i++){var o=a;a=0;for(var s=67108863&n,l=Math.min(i,e.length-1),c=Math.max(0,i-t.length+1);c<=l;c++){var u=i-c,h=(0|t.words[u])*(0|e.words[c]),f=67108863&h;s=67108863&(f=f+s|0),a+=(o=(o=o+(h/67108864|0)|0)+(f>>>26)|0)>>>26,o&=67108863}r.words[i]=s,n=o,o=a}return 0!==n?r.words[i]=n:r.length--,r.strip()}(this,t,e):d(this,t,e)},g.prototype.makeRBT=function(t){for(var e=new Array(t),r=i.prototype._countBits(t)-1,n=0;n<t;n++)e[n]=this.revBin(n,r,t);return e},g.prototype.revBin=function(t,e,r){if(0===t||t===r-1)return t;for(var n=0,a=0;a<e;a++)n|=(1&t)<<e-a-1,t>>=1;return n},g.prototype.permute=function(t,e,r,n,a,i){for(var o=0;o<i;o++)n[o]=e[t[o]],a[o]=r[t[o]]},g.prototype.transform=function(t,e,r,n,a,i){this.permute(i,t,e,r,n,a);for(var o=1;o<a;o<<=1)for(var s=o<<1,l=Math.cos(2*Math.PI/s),c=Math.sin(2*Math.PI/s),u=0;u<a;u+=s)for(var h=l,f=c,p=0;p<o;p++){var d=r[u+p],g=n[u+p],m=r[u+p+o],v=n[u+p+o],y=h*m-f*v;v=h*v+f*m,m=y,r[u+p]=d+m,n[u+p]=g+v,r[u+p+o]=d-m,n[u+p+o]=g-v,p!==s&&(y=l*h-c*f,f=l*f+c*h,h=y)}},g.prototype.guessLen13b=function(t,e){var r=1|Math.max(e,t),n=1&r,a=0;for(r=r/2|0;r;r>>>=1)a++;return 1<<a+1+n},g.prototype.conjugate=function(t,e,r){if(!(r<=1))for(var n=0;n<r/2;n++){var a=t[n];t[n]=t[r-n-1],t[r-n-1]=a,a=e[n],e[n]=-e[r-n-1],e[r-n-1]=-a}},g.prototype.normalize13b=function(t,e){for(var r=0,n=0;n<e/2;n++){var a=8192*Math.round(t[2*n+1]/e)+Math.round(t[2*n]/e)+r;t[n]=67108863&a,r=a<67108864?0:a/67108864|0}return t},g.prototype.convert13b=function(t,e,r,a){for(var i=0,o=0;o<e;o++)i+=0|t[o],r[2*o]=8191&i,i>>>=13,r[2*o+1]=8191&i,i>>>=13;for(o=2*e;o<a;++o)r[o]=0;n(0===i),n(0==(-8192&i))},g.prototype.stub=function(t){for(var e=new Array(t),r=0;r<t;r++)e[r]=0;return e},g.prototype.mulp=function(t,e,r){var n=2*this.guessLen13b(t.length,e.length),a=this.makeRBT(n),i=this.stub(n),o=new Array(n),s=new Array(n),l=new Array(n),c=new Array(n),u=new Array(n),h=new Array(n),f=r.words;f.length=n,this.convert13b(t.words,t.length,o,n),this.convert13b(e.words,e.length,c,n),this.transform(o,i,s,l,n,a),this.transform(c,i,u,h,n,a);for(var p=0;p<n;p++){var d=s[p]*u[p]-l[p]*h[p];l[p]=s[p]*h[p]+l[p]*u[p],s[p]=d}return this.conjugate(s,l,n),this.transform(s,l,f,i,n,a),this.conjugate(f,i,n),this.normalize13b(f,n),r.negative=t.negative^e.negative,r.length=t.length+e.length,r.strip()},i.prototype.mul=function(t){var e=new i(null);return e.words=new Array(this.length+t.length),this.mulTo(t,e)},i.prototype.mulf=function(t){var e=new i(null);return e.words=new Array(this.length+t.length),d(this,t,e)},i.prototype.imul=function(t){return this.clone().mulTo(t,this)},i.prototype.imuln=function(t){n("number"==typeof t),n(t<67108864);for(var e=0,r=0;r<this.length;r++){var a=(0|this.words[r])*t,i=(67108863&a)+(67108863&e);e>>=26,e+=a/67108864|0,e+=i>>>26,this.words[r]=67108863&i}return 0!==e&&(this.words[r]=e,this.length++),this},i.prototype.muln=function(t){return this.clone().imuln(t)},i.prototype.sqr=function(){return this.mul(this)},i.prototype.isqr=function(){return this.imul(this.clone())},i.prototype.pow=function(t){var e=function(t){for(var e=new Array(t.bitLength()),r=0;r<e.length;r++){var n=r/26|0,a=r%26;e[r]=(t.words[n]&1<<a)>>>a}return e}(t);if(0===e.length)return new i(1);for(var r=this,n=0;n<e.length&&0===e[n];n++,r=r.sqr());if(++n<e.length)for(var a=r.sqr();n<e.length;n++,a=a.sqr())0!==e[n]&&(r=r.mul(a));return r},i.prototype.iushln=function(t){n("number"==typeof t&&t>=0);var e,r=t%26,a=(t-r)/26,i=67108863>>>26-r<<26-r;if(0!==r){var o=0;for(e=0;e<this.length;e++){var s=this.words[e]&i,l=(0|this.words[e])-s<<r;this.words[e]=l|o,o=s>>>26-r}o&&(this.words[e]=o,this.length++)}if(0!==a){for(e=this.length-1;e>=0;e--)this.words[e+a]=this.words[e];for(e=0;e<a;e++)this.words[e]=0;this.length+=a}return this.strip()},i.prototype.ishln=function(t){return n(0===this.negative),this.iushln(t)},i.prototype.iushrn=function(t,e,r){var a;n("number"==typeof t&&t>=0),a=e?(e-e%26)/26:0;var i=t%26,o=Math.min((t-i)/26,this.length),s=67108863^67108863>>>i<<i,l=r;if(a-=o,a=Math.max(0,a),l){for(var c=0;c<o;c++)l.words[c]=this.words[c];l.length=o}if(0===o);else if(this.length>o)for(this.length-=o,c=0;c<this.length;c++)this.words[c]=this.words[c+o];else this.words[0]=0,this.length=1;var u=0;for(c=this.length-1;c>=0&&(0!==u||c>=a);c--){var h=0|this.words[c];this.words[c]=u<<26-i|h>>>i,u=h&s}return l&&0!==u&&(l.words[l.length++]=u),0===this.length&&(this.words[0]=0,this.length=1),this.strip()},i.prototype.ishrn=function(t,e,r){return n(0===this.negative),this.iushrn(t,e,r)},i.prototype.shln=function(t){return this.clone().ishln(t)},i.prototype.ushln=function(t){return this.clone().iushln(t)},i.prototype.shrn=function(t){return this.clone().ishrn(t)},i.prototype.ushrn=function(t){return this.clone().iushrn(t)},i.prototype.testn=function(t){n("number"==typeof t&&t>=0);var e=t%26,r=(t-e)/26,a=1<<e;return!(this.length<=r)&&!!(this.words[r]&a)},i.prototype.imaskn=function(t){n("number"==typeof t&&t>=0);var e=t%26,r=(t-e)/26;if(n(0===this.negative,"imaskn works only with positive numbers"),this.length<=r)return this;if(0!==e&&r++,this.length=Math.min(r,this.length),0!==e){var a=67108863^67108863>>>e<<e;this.words[this.length-1]&=a}return this.strip()},i.prototype.maskn=function(t){return this.clone().imaskn(t)},i.prototype.iaddn=function(t){return n("number"==typeof t),n(t<67108864),t<0?this.isubn(-t):0!==this.negative?1===this.length&&(0|this.words[0])<t?(this.words[0]=t-(0|this.words[0]),this.negative=0,this):(this.negative=0,this.isubn(t),this.negative=1,this):this._iaddn(t)},i.prototype._iaddn=function(t){this.words[0]+=t;for(var e=0;e<this.length&&this.words[e]>=67108864;e++)this.words[e]-=67108864,e===this.length-1?this.words[e+1]=1:this.words[e+1]++;return this.length=Math.max(this.length,e+1),this},i.prototype.isubn=function(t){if(n("number"==typeof t),n(t<67108864),t<0)return this.iaddn(-t);if(0!==this.negative)return this.negative=0,this.iaddn(t),this.negative=1,this;if(this.words[0]-=t,1===this.length&&this.words[0]<0)this.words[0]=-this.words[0],this.negative=1;else for(var e=0;e<this.length&&this.words[e]<0;e++)this.words[e]+=67108864,this.words[e+1]-=1;return this.strip()},i.prototype.addn=function(t){return this.clone().iaddn(t)},i.prototype.subn=function(t){return this.clone().isubn(t)},i.prototype.iabs=function(){return this.negative=0,this},i.prototype.abs=function(){return this.clone().iabs()},i.prototype._ishlnsubmul=function(t,e,r){var a,i,o=t.length+r;this._expand(o);var s=0;for(a=0;a<t.length;a++){i=(0|this.words[a+r])+s;var l=(0|t.words[a])*e;s=((i-=67108863&l)>>26)-(l/67108864|0),this.words[a+r]=67108863&i}for(;a<this.length-r;a++)s=(i=(0|this.words[a+r])+s)>>26,this.words[a+r]=67108863&i;if(0===s)return this.strip();for(n(-1===s),s=0,a=0;a<this.length;a++)s=(i=-(0|this.words[a])+s)>>26,this.words[a]=67108863&i;return this.negative=1,this.strip()},i.prototype._wordDiv=function(t,e){var r=(this.length,t.length),n=this.clone(),a=t,o=0|a.words[a.length-1];0!==(r=26-this._countBits(o))&&(a=a.ushln(r),n.iushln(r),o=0|a.words[a.length-1]);var s,l=n.length-a.length;if("mod"!==e){(s=new i(null)).length=l+1,s.words=new Array(s.length);for(var c=0;c<s.length;c++)s.words[c]=0}var u=n.clone()._ishlnsubmul(a,1,l);0===u.negative&&(n=u,s&&(s.words[l]=1));for(var h=l-1;h>=0;h--){var f=67108864*(0|n.words[a.length+h])+(0|n.words[a.length+h-1]);for(f=Math.min(f/o|0,67108863),n._ishlnsubmul(a,f,h);0!==n.negative;)f--,n.negative=0,n._ishlnsubmul(a,1,h),n.isZero()||(n.negative^=1);s&&(s.words[h]=f)}return s&&s.strip(),n.strip(),"div"!==e&&0!==r&&n.iushrn(r),{div:s||null,mod:n}},i.prototype.divmod=function(t,e,r){return n(!t.isZero()),this.isZero()?{div:new i(0),mod:new i(0)}:0!==this.negative&&0===t.negative?(s=this.neg().divmod(t,e),"mod"!==e&&(a=s.div.neg()),"div"!==e&&(o=s.mod.neg(),r&&0!==o.negative&&o.iadd(t)),{div:a,mod:o}):0===this.negative&&0!==t.negative?(s=this.divmod(t.neg(),e),"mod"!==e&&(a=s.div.neg()),{div:a,mod:s.mod}):0!=(this.negative&t.negative)?(s=this.neg().divmod(t.neg(),e),"div"!==e&&(o=s.mod.neg(),r&&0!==o.negative&&o.isub(t)),{div:s.div,mod:o}):t.length>this.length||this.cmp(t)<0?{div:new i(0),mod:this}:1===t.length?"div"===e?{div:this.divn(t.words[0]),mod:null}:"mod"===e?{div:null,mod:new i(this.modn(t.words[0]))}:{div:this.divn(t.words[0]),mod:new i(this.modn(t.words[0]))}:this._wordDiv(t,e);var a,o,s},i.prototype.div=function(t){return this.divmod(t,"div",!1).div},i.prototype.mod=function(t){return this.divmod(t,"mod",!1).mod},i.prototype.umod=function(t){return this.divmod(t,"mod",!0).mod},i.prototype.divRound=function(t){var e=this.divmod(t);if(e.mod.isZero())return e.div;var r=0!==e.div.negative?e.mod.isub(t):e.mod,n=t.ushrn(1),a=t.andln(1),i=r.cmp(n);return i<0||1===a&&0===i?e.div:0!==e.div.negative?e.div.isubn(1):e.div.iaddn(1)},i.prototype.modn=function(t){n(t<=67108863);for(var e=(1<<26)%t,r=0,a=this.length-1;a>=0;a--)r=(e*r+(0|this.words[a]))%t;return r},i.prototype.idivn=function(t){n(t<=67108863);for(var e=0,r=this.length-1;r>=0;r--){var a=(0|this.words[r])+67108864*e;this.words[r]=a/t|0,e=a%t}return this.strip()},i.prototype.divn=function(t){return this.clone().idivn(t)},i.prototype.egcd=function(t){n(0===t.negative),n(!t.isZero());var e=this,r=t.clone();e=0!==e.negative?e.umod(t):e.clone();for(var a=new i(1),o=new i(0),s=new i(0),l=new i(1),c=0;e.isEven()&&r.isEven();)e.iushrn(1),r.iushrn(1),++c;for(var u=r.clone(),h=e.clone();!e.isZero();){for(var f=0,p=1;0==(e.words[0]&p)&&f<26;++f,p<<=1);if(f>0)for(e.iushrn(f);f-- >0;)(a.isOdd()||o.isOdd())&&(a.iadd(u),o.isub(h)),a.iushrn(1),o.iushrn(1);for(var d=0,g=1;0==(r.words[0]&g)&&d<26;++d,g<<=1);if(d>0)for(r.iushrn(d);d-- >0;)(s.isOdd()||l.isOdd())&&(s.iadd(u),l.isub(h)),s.iushrn(1),l.iushrn(1);e.cmp(r)>=0?(e.isub(r),a.isub(s),o.isub(l)):(r.isub(e),s.isub(a),l.isub(o))}return{a:s,b:l,gcd:r.iushln(c)}},i.prototype._invmp=function(t){n(0===t.negative),n(!t.isZero());var e=this,r=t.clone();e=0!==e.negative?e.umod(t):e.clone();for(var a,o=new i(1),s=new i(0),l=r.clone();e.cmpn(1)>0&&r.cmpn(1)>0;){for(var c=0,u=1;0==(e.words[0]&u)&&c<26;++c,u<<=1);if(c>0)for(e.iushrn(c);c-- >0;)o.isOdd()&&o.iadd(l),o.iushrn(1);for(var h=0,f=1;0==(r.words[0]&f)&&h<26;++h,f<<=1);if(h>0)for(r.iushrn(h);h-- >0;)s.isOdd()&&s.iadd(l),s.iushrn(1);e.cmp(r)>=0?(e.isub(r),o.isub(s)):(r.isub(e),s.isub(o))}return(a=0===e.cmpn(1)?o:s).cmpn(0)<0&&a.iadd(t),a},i.prototype.gcd=function(t){if(this.isZero())return t.abs();if(t.isZero())return this.abs();var e=this.clone(),r=t.clone();e.negative=0,r.negative=0;for(var n=0;e.isEven()&&r.isEven();n++)e.iushrn(1),r.iushrn(1);for(;;){for(;e.isEven();)e.iushrn(1);for(;r.isEven();)r.iushrn(1);var a=e.cmp(r);if(a<0){var i=e;e=r,r=i}else if(0===a||0===r.cmpn(1))break;e.isub(r)}return r.iushln(n)},i.prototype.invm=function(t){return this.egcd(t).a.umod(t)},i.prototype.isEven=function(){return 0==(1&this.words[0])},i.prototype.isOdd=function(){return 1==(1&this.words[0])},i.prototype.andln=function(t){return this.words[0]&t},i.prototype.bincn=function(t){n("number"==typeof t);var e=t%26,r=(t-e)/26,a=1<<e;if(this.length<=r)return this._expand(r+1),this.words[r]|=a,this;for(var i=a,o=r;0!==i&&o<this.length;o++){var s=0|this.words[o];i=(s+=i)>>>26,s&=67108863,this.words[o]=s}return 0!==i&&(this.words[o]=i,this.length++),this},i.prototype.isZero=function(){return 1===this.length&&0===this.words[0]},i.prototype.cmpn=function(t){var e,r=t<0;if(0!==this.negative&&!r)return-1;if(0===this.negative&&r)return 1;if(this.strip(),this.length>1)e=1;else{r&&(t=-t),n(t<=67108863,"Number is too big");var a=0|this.words[0];e=a===t?0:a<t?-1:1}return 0!==this.negative?0|-e:e},i.prototype.cmp=function(t){if(0!==this.negative&&0===t.negative)return-1;if(0===this.negative&&0!==t.negative)return 1;var e=this.ucmp(t);return 0!==this.negative?0|-e:e},i.prototype.ucmp=function(t){if(this.length>t.length)return 1;if(this.length<t.length)return-1;for(var e=0,r=this.length-1;r>=0;r--){var n=0|this.words[r],a=0|t.words[r];if(n!==a){n<a?e=-1:n>a&&(e=1);break}}return e},i.prototype.gtn=function(t){return 1===this.cmpn(t)},i.prototype.gt=function(t){return 1===this.cmp(t)},i.prototype.gten=function(t){return this.cmpn(t)>=0},i.prototype.gte=function(t){return this.cmp(t)>=0},i.prototype.ltn=function(t){return-1===this.cmpn(t)},i.prototype.lt=function(t){return-1===this.cmp(t)},i.prototype.lten=function(t){return this.cmpn(t)<=0},i.prototype.lte=function(t){return this.cmp(t)<=0},i.prototype.eqn=function(t){return 0===this.cmpn(t)},i.prototype.eq=function(t){return 0===this.cmp(t)},i.red=function(t){return new w(t)},i.prototype.toRed=function(t){return n(!this.red,"Already a number in reduction context"),n(0===this.negative,"red works only with positives"),t.convertTo(this)._forceRed(t)},i.prototype.fromRed=function(){return n(this.red,"fromRed works only with numbers in reduction context"),this.red.convertFrom(this)},i.prototype._forceRed=function(t){return this.red=t,this},i.prototype.forceRed=function(t){return n(!this.red,"Already a number in reduction context"),this._forceRed(t)},i.prototype.redAdd=function(t){return n(this.red,"redAdd works only with red numbers"),this.red.add(this,t)},i.prototype.redIAdd=function(t){return n(this.red,"redIAdd works only with red numbers"),this.red.iadd(this,t)},i.prototype.redSub=function(t){return n(this.red,"redSub works only with red numbers"),this.red.sub(this,t)},i.prototype.redISub=function(t){return n(this.red,"redISub works only with red numbers"),this.red.isub(this,t)},i.prototype.redShl=function(t){return n(this.red,"redShl works only with red numbers"),this.red.shl(this,t)},i.prototype.redMul=function(t){return n(this.red,"redMul works only with red numbers"),this.red._verify2(this,t),this.red.mul(this,t)},i.prototype.redIMul=function(t){return n(this.red,"redMul works only with red numbers"),this.red._verify2(this,t),this.red.imul(this,t)},i.prototype.redSqr=function(){return n(this.red,"redSqr works only with red numbers"),this.red._verify1(this),this.red.sqr(this)},i.prototype.redISqr=function(){return n(this.red,"redISqr works only with red numbers"),this.red._verify1(this),this.red.isqr(this)},i.prototype.redSqrt=function(){return n(this.red,"redSqrt works only with red numbers"),this.red._verify1(this),this.red.sqrt(this)},i.prototype.redInvm=function(){return n(this.red,"redInvm works only with red numbers"),this.red._verify1(this),this.red.invm(this)},i.prototype.redNeg=function(){return n(this.red,"redNeg works only with red numbers"),this.red._verify1(this),this.red.neg(this)},i.prototype.redPow=function(t){return n(this.red&&!t.red,"redPow(normalNum)"),this.red._verify1(this),this.red.pow(this,t)};var m={k256:null,p224:null,p192:null,p25519:null};function v(t,e){this.name=t,this.p=new i(e,16),this.n=this.p.bitLength(),this.k=new i(1).iushln(this.n).isub(this.p),this.tmp=this._tmp()}function y(){v.call(this,"k256","ffffffff ffffffff ffffffff ffffffff ffffffff ffffffff fffffffe fffffc2f")}function x(){v.call(this,"p224","ffffffff ffffffff ffffffff ffffffff 00000000 00000000 00000001")}function b(){v.call(this,"p192","ffffffff ffffffff ffffffff fffffffe ffffffff ffffffff")}function _(){v.call(this,"25519","7fffffffffffffff ffffffffffffffff ffffffffffffffff ffffffffffffffed")}function w(t){if("string"==typeof t){var e=i._prime(t);this.m=e.p,this.prime=e}else n(t.gtn(1),"modulus must be greater than 1"),this.m=t,this.prime=null}function T(t){w.call(this,t),this.shift=this.m.bitLength(),this.shift%26!=0&&(this.shift+=26-this.shift%26),this.r=new i(1).iushln(this.shift),this.r2=this.imod(this.r.sqr()),this.rinv=this.r._invmp(this.m),this.minv=this.rinv.mul(this.r).isubn(1).div(this.m),this.minv=this.minv.umod(this.r),this.minv=this.r.sub(this.minv)}v.prototype._tmp=function(){var t=new i(null);return t.words=new Array(Math.ceil(this.n/13)),t},v.prototype.ireduce=function(t){var e,r=t;do{this.split(r,this.tmp),e=(r=(r=this.imulK(r)).iadd(this.tmp)).bitLength()}while(e>this.n);var n=e<this.n?-1:r.ucmp(this.p);return 0===n?(r.words[0]=0,r.length=1):n>0?r.isub(this.p):r.strip(),r},v.prototype.split=function(t,e){t.iushrn(this.n,0,e)},v.prototype.imulK=function(t){return t.imul(this.k)},a(y,v),y.prototype.split=function(t,e){for(var r=Math.min(t.length,9),n=0;n<r;n++)e.words[n]=t.words[n];if(e.length=r,t.length<=9)return t.words[0]=0,void(t.length=1);var a=t.words[9];for(e.words[e.length++]=4194303&a,n=10;n<t.length;n++){var i=0|t.words[n];t.words[n-10]=(4194303&i)<<4|a>>>22,a=i}a>>>=22,t.words[n-10]=a,0===a&&t.length>10?t.length-=10:t.length-=9},y.prototype.imulK=function(t){t.words[t.length]=0,t.words[t.length+1]=0,t.length+=2;for(var e=0,r=0;r<t.length;r++){var n=0|t.words[r];e+=977*n,t.words[r]=67108863&e,e=64*n+(e/67108864|0)}return 0===t.words[t.length-1]&&(t.length--,0===t.words[t.length-1]&&t.length--),t},a(x,v),a(b,v),a(_,v),_.prototype.imulK=function(t){for(var e=0,r=0;r<t.length;r++){var n=19*(0|t.words[r])+e,a=67108863&n;n>>>=26,t.words[r]=a,e=n}return 0!==e&&(t.words[t.length++]=e),t},i._prime=function(t){if(m[t])return m[t];var e;if("k256"===t)e=new y;else if("p224"===t)e=new x;else if("p192"===t)e=new b;else{if("p25519"!==t)throw new Error("Unknown prime "+t);e=new _}return m[t]=e,e},w.prototype._verify1=function(t){n(0===t.negative,"red works only with positives"),n(t.red,"red works only with red numbers")},w.prototype._verify2=function(t,e){n(0==(t.negative|e.negative),"red works only with positives"),n(t.red&&t.red===e.red,"red works only with red numbers")},w.prototype.imod=function(t){return this.prime?this.prime.ireduce(t)._forceRed(this):t.umod(this.m)._forceRed(this)},w.prototype.neg=function(t){return t.isZero()?t.clone():this.m.sub(t)._forceRed(this)},w.prototype.add=function(t,e){this._verify2(t,e);var r=t.add(e);return r.cmp(this.m)>=0&&r.isub(this.m),r._forceRed(this)},w.prototype.iadd=function(t,e){this._verify2(t,e);var r=t.iadd(e);return r.cmp(this.m)>=0&&r.isub(this.m),r},w.prototype.sub=function(t,e){this._verify2(t,e);var r=t.sub(e);return r.cmpn(0)<0&&r.iadd(this.m),r._forceRed(this)},w.prototype.isub=function(t,e){this._verify2(t,e);var r=t.isub(e);return r.cmpn(0)<0&&r.iadd(this.m),r},w.prototype.shl=function(t,e){return this._verify1(t),this.imod(t.ushln(e))},w.prototype.imul=function(t,e){return this._verify2(t,e),this.imod(t.imul(e))},w.prototype.mul=function(t,e){return this._verify2(t,e),this.imod(t.mul(e))},w.prototype.isqr=function(t){return this.imul(t,t.clone())},w.prototype.sqr=function(t){return this.mul(t,t)},w.prototype.sqrt=function(t){if(t.isZero())return t.clone();var e=this.m.andln(3);if(n(e%2==1),3===e){var r=this.m.add(new i(1)).iushrn(2);return this.pow(t,r)}for(var a=this.m.subn(1),o=0;!a.isZero()&&0===a.andln(1);)o++,a.iushrn(1);n(!a.isZero());var s=new i(1).toRed(this),l=s.redNeg(),c=this.m.subn(1).iushrn(1),u=this.m.bitLength();for(u=new i(2*u*u).toRed(this);0!==this.pow(u,c).cmp(l);)u.redIAdd(l);for(var h=this.pow(u,a),f=this.pow(t,a.addn(1).iushrn(1)),p=this.pow(t,a),d=o;0!==p.cmp(s);){for(var g=p,m=0;0!==g.cmp(s);m++)g=g.redSqr();n(m<d);var v=this.pow(h,new i(1).iushln(d-m-1));f=f.redMul(v),h=v.redSqr(),p=p.redMul(h),d=m}return f},w.prototype.invm=function(t){var e=t._invmp(this.m);return 0!==e.negative?(e.negative=0,this.imod(e).redNeg()):this.imod(e)},w.prototype.pow=function(t,e){if(e.isZero())return new i(1).toRed(this);if(0===e.cmpn(1))return t.clone();var r=new Array(16);r[0]=new i(1).toRed(this),r[1]=t;for(var n=2;n<r.length;n++)r[n]=this.mul(r[n-1],t);var a=r[0],o=0,s=0,l=e.bitLength()%26;for(0===l&&(l=26),n=e.length-1;n>=0;n--){for(var c=e.words[n],u=l-1;u>=0;u--){var h=c>>u&1;a!==r[0]&&(a=this.sqr(a)),0!==h||0!==o?(o<<=1,o|=h,(4===++s||0===n&&0===u)&&(a=this.mul(a,r[o]),s=0,o=0)):s=0}l=26}return a},w.prototype.convertTo=function(t){var e=t.umod(this.m);return e===t?e.clone():e},w.prototype.convertFrom=function(t){var e=t.clone();return e.red=null,e},i.mont=function(t){return new T(t)},a(T,w),T.prototype.convertTo=function(t){return this.imod(t.ushln(this.shift))},T.prototype.convertFrom=function(t){var e=this.imod(t.mul(this.rinv));return e.red=null,e},T.prototype.imul=function(t,e){if(t.isZero()||e.isZero())return t.words[0]=0,t.length=1,t;var r=t.imul(e),n=r.maskn(this.shift).mul(this.minv).imaskn(this.shift).mul(this.m),a=r.isub(n).iushrn(this.shift),i=a;return a.cmp(this.m)>=0?i=a.isub(this.m):a.cmpn(0)<0&&(i=a.iadd(this.m)),i._forceRed(this)},T.prototype.mul=function(t,e){if(t.isZero()||e.isZero())return new i(0)._forceRed(this);var r=t.mul(e),n=r.maskn(this.shift).mul(this.minv).imaskn(this.shift).mul(this.m),a=r.isub(n).iushrn(this.shift),o=a;return a.cmp(this.m)>=0?o=a.isub(this.m):a.cmpn(0)<0&&(o=a.iadd(this.m)),o._forceRed(this)},T.prototype.invm=function(t){return this.imod(t._invmp(this.m).mul(this.r2))._forceRed(this)}}("undefined"==typeof e||e,this)},{buffer:106}],98:[function(t,e,r){"use strict";e.exports=function(t){var e,r,n,a=t.length,i=0;for(e=0;e<a;++e)i+=t[e].length;var o=new Array(i),s=0;for(e=0;e<a;++e){var l=t[e],c=l.length;for(r=0;r<c;++r){var u=o[s++]=new Array(c-1),h=0;for(n=0;n<c;++n)n!==r&&(u[h++]=l[n]);if(1&r){var f=u[1];u[1]=u[0],u[0]=f}}}return o}},{}],99:[function(t,e,r){"use strict";e.exports=function(t,e,r){switch(arguments.length){case 1:return h(t);case 2:return"function"==typeof e?c(t,t,e,!0):f(t,e);case 3:return c(t,e,r,!1);default:throw new Error("box-intersect: Invalid arguments")}};var n,a=t("typedarray-pool"),i=t("./lib/sweep"),o=t("./lib/intersect");function s(t,e){for(var r=0;r<t;++r)if(!(e[r]<=e[r+t]))return!0;return!1}function l(t,e,r,n){for(var a=0,i=0,o=0,l=t.length;o<l;++o){var c=t[o];if(!s(e,c)){for(var u=0;u<2*e;++u)r[a++]=c[u];n[i++]=o}}return i}function c(t,e,r,n){var s=t.length,c=e.length;if(!(s<=0||c<=0)){var u=t[0].length>>>1;if(!(u<=0)){var h,f=a.mallocDouble(2*u*s),p=a.mallocInt32(s);if((s=l(t,u,f,p))>0){if(1===u&&n)i.init(s),h=i.sweepComplete(u,r,0,s,f,p,0,s,f,p);else{var d=a.mallocDouble(2*u*c),g=a.mallocInt32(c);(c=l(e,u,d,g))>0&&(i.init(s+c),h=1===u?i.sweepBipartite(u,r,0,s,f,p,0,c,d,g):o(u,r,n,s,f,p,c,d,g),a.free(d),a.free(g))}a.free(f),a.free(p)}return h}}}function u(t,e){n.push([t,e])}function h(t){return n=[],c(t,t,u,!0),n}function f(t,e){return n=[],c(t,e,u,!1),n}},{"./lib/intersect":101,"./lib/sweep":105,"typedarray-pool":554}],100:[function(t,e,r){"use strict";var n=["d","ax","vv","rs","re","rb","ri","bs","be","bb","bi"];function a(t){var e="bruteForce"+(t?"Full":"Partial"),r=[],a=n.slice();t||a.splice(3,0,"fp");var i=["function "+e+"("+a.join()+"){"];function o(e,a){var o=function(t,e,r){var a="bruteForce"+(t?"Red":"Blue")+(e?"Flip":"")+(r?"Full":""),i=["function ",a,"(",n.join(),"){","var ","es","=2*","d",";"],o="for(var i=rs,rp=es*rs;i<re;++i,rp+=es){var x0=rb[ax+rp],x1=rb[ax+rp+d],xi=ri[i];",s="for(var j=bs,bp=es*bs;j<be;++j,bp+=es){var y0=bb[ax+bp],"+(r?"y1=bb[ax+bp+d],":"")+"yi=bi[j];";return t?i.push(o,"Q",":",s):i.push(s,"Q",":",o),r?i.push("if(y1<x0||x1<y0)continue;"):e?i.push("if(y0<=x0||x1<y0)continue;"):i.push("if(y0<x0||x1<y0)continue;"),i.push("for(var k=ax+1;k<d;++k){var r0=rb[k+rp],r1=rb[k+d+rp],b0=bb[k+bp],b1=bb[k+d+bp];if(r1<b0||b1<r0)continue Q;}var rv=vv("),e?i.push("yi,xi"):i.push("xi,yi"),i.push(");if(rv!==void 0)return rv;}}}"),{name:a,code:i.join("")}}(e,a,t);r.push(o.code),i.push("return "+o.name+"("+n.join()+");")}i.push("if(re-rs>be-bs){"),t?(o(!0,!1),i.push("}else{"),o(!1,!1)):(i.push("if(fp){"),o(!0,!0),i.push("}else{"),o(!0,!1),i.push("}}else{if(fp){"),o(!1,!0),i.push("}else{"),o(!1,!1),i.push("}")),i.push("}}return "+e);var s=r.join("")+i.join("");return new Function(s)()}r.partial=a(!1),r.full=a(!0)},{}],101:[function(t,e,r){"use strict";e.exports=function(t,e,r,i,u,w,T,k,M){!function(t,e){var r=8*a.log2(e+1)*(t+1)|0,i=a.nextPow2(6*r);v.length<i&&(n.free(v),v=n.mallocInt32(i));var o=a.nextPow2(2*r);y.length<o&&(n.free(y),y=n.mallocDouble(o))}(t,i+T);var A,S=0,E=2*t;x(S++,0,0,i,0,T,r?16:0,-1/0,1/0),r||x(S++,0,0,T,0,i,1,-1/0,1/0);for(;S>0;){var C=6*(S-=1),L=v[C],P=v[C+1],I=v[C+2],z=v[C+3],O=v[C+4],D=v[C+5],R=2*S,F=y[R],B=y[R+1],N=1&D,j=!!(16&D),U=u,V=w,q=k,H=M;if(N&&(U=k,V=M,q=u,H=w),!(2&D&&(I=p(t,L,P,I,U,V,B),P>=I)||4&D&&(P=d(t,L,P,I,U,V,F))>=I)){var G=I-P,Y=O-z;if(j){if(t*G*(G+Y)<1<<22){if(void 0!==(A=l.scanComplete(t,L,e,P,I,U,V,z,O,q,H)))return A;continue}}else{if(t*Math.min(G,Y)<128){if(void 0!==(A=o(t,L,e,N,P,I,U,V,z,O,q,H)))return A;continue}if(t*G*Y<1<<22){if(void 0!==(A=l.scanBipartite(t,L,e,N,P,I,U,V,z,O,q,H)))return A;continue}}var W=h(t,L,P,I,U,V,F,B);if(P<W)if(t*(W-P)<128){if(void 0!==(A=s(t,L+1,e,P,W,U,V,z,O,q,H)))return A}else if(L===t-2){if(void 0!==(A=N?l.sweepBipartite(t,e,z,O,q,H,P,W,U,V):l.sweepBipartite(t,e,P,W,U,V,z,O,q,H)))return A}else x(S++,L+1,P,W,z,O,N,-1/0,1/0),x(S++,L+1,z,O,P,W,1^N,-1/0,1/0);if(W<I){var Z=c(t,L,z,O,q,H),X=q[E*Z+L],J=f(t,L,Z,O,q,H,X);if(J<O&&x(S++,L,W,I,J,O,(4|N)+(j?16:0),X,B),z<Z&&x(S++,L,W,I,z,Z,(2|N)+(j?16:0),F,X),Z+1===J){if(void 0!==(A=j?_(t,L,e,W,I,U,V,Z,q,H[Z]):b(t,L,e,N,W,I,U,V,Z,q,H[Z])))return A}else if(Z<J){var K;if(j){if(K=g(t,L,W,I,U,V,X),W<K){var Q=f(t,L,W,K,U,V,X);if(L===t-2){if(W<Q&&void 0!==(A=l.sweepComplete(t,e,W,Q,U,V,Z,J,q,H)))return A;if(Q<K&&void 0!==(A=l.sweepBipartite(t,e,Q,K,U,V,Z,J,q,H)))return A}else W<Q&&x(S++,L+1,W,Q,Z,J,16,-1/0,1/0),Q<K&&(x(S++,L+1,Q,K,Z,J,0,-1/0,1/0),x(S++,L+1,Z,J,Q,K,1,-1/0,1/0))}}else K=N?m(t,L,W,I,U,V,X):g(t,L,W,I,U,V,X),W<K&&(L===t-2?A=N?l.sweepBipartite(t,e,Z,J,q,H,W,K,U,V):l.sweepBipartite(t,e,W,K,U,V,Z,J,q,H):(x(S++,L+1,W,K,Z,J,N,-1/0,1/0),x(S++,L+1,Z,J,W,K,1^N,-1/0,1/0)))}}}}};var n=t("typedarray-pool"),a=t("bit-twiddle"),i=t("./brute"),o=i.partial,s=i.full,l=t("./sweep"),c=t("./median"),u=t("./partition"),h=u("!(lo>=p0)&&!(p1>=hi)",["p0","p1"]),f=u("lo===p0",["p0"]),p=u("lo<p0",["p0"]),d=u("hi<=p0",["p0"]),g=u("lo<=p0&&p0<=hi",["p0"]),m=u("lo<p0&&p0<=hi",["p0"]),v=n.mallocInt32(1024),y=n.mallocDouble(1024);function x(t,e,r,n,a,i,o,s,l){var c=6*t;v[c]=e,v[c+1]=r,v[c+2]=n,v[c+3]=a,v[c+4]=i,v[c+5]=o;var u=2*t;y[u]=s,y[u+1]=l}function b(t,e,r,n,a,i,o,s,l,c,u){var h=2*t,f=l*h,p=c[f+e];t:for(var d=a,g=a*h;d<i;++d,g+=h){var m=o[g+e],v=o[g+e+t];if(!(p<m||v<p)&&(!n||p!==m)){for(var y,x=s[d],b=e+1;b<t;++b){m=o[g+b],v=o[g+b+t];var _=c[f+b],w=c[f+b+t];if(v<_||w<m)continue t}if(void 0!==(y=n?r(u,x):r(x,u)))return y}}}function _(t,e,r,n,a,i,o,s,l,c){var u=2*t,h=s*u,f=l[h+e];t:for(var p=n,d=n*u;p<a;++p,d+=u){var g=o[p];if(g!==c){var m=i[d+e],v=i[d+e+t];if(!(f<m||v<f)){for(var y=e+1;y<t;++y){m=i[d+y],v=i[d+y+t];var x=l[h+y],b=l[h+y+t];if(v<x||b<m)continue t}var _=r(g,c);if(void 0!==_)return _}}}}},{"./brute":100,"./median":102,"./partition":103,"./sweep":105,"bit-twiddle":95,"typedarray-pool":554}],102:[function(t,e,r){"use strict";e.exports=function(t,e,r,i,o,s){if(i<=r+1)return r;var l=r,c=i,u=i+r>>>1,h=2*t,f=u,p=o[h*u+e];for(;l<c;){if(c-l<8){a(t,e,l,c,o,s),p=o[h*u+e];break}var d=c-l,g=Math.random()*d+l|0,m=o[h*g+e],v=Math.random()*d+l|0,y=o[h*v+e],x=Math.random()*d+l|0,b=o[h*x+e];m<=y?b>=y?(f=v,p=y):m>=b?(f=g,p=m):(f=x,p=b):y>=b?(f=v,p=y):b>=m?(f=g,p=m):(f=x,p=b);for(var _=h*(c-1),w=h*f,T=0;T<h;++T,++_,++w){var k=o[_];o[_]=o[w],o[w]=k}var M=s[c-1];s[c-1]=s[f],s[f]=M,f=n(t,e,l,c-1,o,s,p);for(_=h*(c-1),w=h*f,T=0;T<h;++T,++_,++w){k=o[_];o[_]=o[w],o[w]=k}M=s[c-1];if(s[c-1]=s[f],s[f]=M,u<f){for(c=f-1;l<c&&o[h*(c-1)+e]===p;)c-=1;c+=1}else{if(!(f<u))break;for(l=f+1;l<c&&o[h*l+e]===p;)l+=1}}return n(t,e,r,u,o,s,o[h*u+e])};var n=t("./partition")("lo<p0",["p0"]);function a(t,e,r,n,a,i){for(var o=2*t,s=o*(r+1)+e,l=r+1;l<n;++l,s+=o)for(var c=a[s],u=l,h=o*(l-1);u>r&&a[h+e]>c;--u,h-=o){for(var f=h,p=h+o,d=0;d<o;++d,++f,++p){var g=a[f];a[f]=a[p],a[p]=g}var m=i[u];i[u]=i[u-1],i[u-1]=m}}},{"./partition":103}],103:[function(t,e,r){"use strict";e.exports=function(t,e){var r="abcdef".split("").concat(e),n=[];t.indexOf("lo")>=0&&n.push("lo=e[k+n]");t.indexOf("hi")>=0&&n.push("hi=e[k+o]");return r.push("for(var j=2*a,k=j*c,l=k,m=c,n=b,o=a+b,p=c;d>p;++p,k+=j){var _;if($)if(m===p)m+=1,l+=j;else{for(var s=0;j>s;++s){var t=e[k+s];e[k+s]=e[l],e[l++]=t}var u=f[p];f[p]=f[m],f[m++]=u}}return m".replace("_",n.join()).replace("$",t)),Function.apply(void 0,r)}},{}],104:[function(t,e,r){"use strict";e.exports=function(t,e){e<=128?n(0,e-1,t):function t(e,r,u){var h=(r-e+1)/6|0,f=e+h,p=r-h,d=e+r>>1,g=d-h,m=d+h,v=f,y=g,x=d,b=m,_=p,w=e+1,T=r-1,k=0;l(v,y,u)&&(k=v,v=y,y=k);l(b,_,u)&&(k=b,b=_,_=k);l(v,x,u)&&(k=v,v=x,x=k);l(y,x,u)&&(k=y,y=x,x=k);l(v,b,u)&&(k=v,v=b,b=k);l(x,b,u)&&(k=x,x=b,b=k);l(y,_,u)&&(k=y,y=_,_=k);l(y,x,u)&&(k=y,y=x,x=k);l(b,_,u)&&(k=b,b=_,_=k);for(var M=u[2*y],A=u[2*y+1],S=u[2*b],E=u[2*b+1],C=2*v,L=2*x,P=2*_,I=2*f,z=2*d,O=2*p,D=0;D<2;++D){var R=u[C+D],F=u[L+D],B=u[P+D];u[I+D]=R,u[z+D]=F,u[O+D]=B}i(g,e,u),i(m,r,u);for(var N=w;N<=T;++N)if(c(N,M,A,u))N!==w&&a(N,w,u),++w;else if(!c(N,S,E,u))for(;;){if(c(T,S,E,u)){c(T,M,A,u)?(o(N,w,T,u),++w,--T):(a(N,T,u),--T);break}if(--T<N)break}s(e,w-1,M,A,u),s(r,T+1,S,E,u),w-2-e<=32?n(e,w-2,u):t(e,w-2,u);r-(T+2)<=32?n(T+2,r,u):t(T+2,r,u);T-w<=32?n(w,T,u):t(w,T,u)}(0,e-1,t)};function n(t,e,r){for(var n=2*(t+1),a=t+1;a<=e;++a){for(var i=r[n++],o=r[n++],s=a,l=n-2;s-- >t;){var c=r[l-2],u=r[l-1];if(c<i)break;if(c===i&&u<o)break;r[l]=c,r[l+1]=u,l-=2}r[l]=i,r[l+1]=o}}function a(t,e,r){e*=2;var n=r[t*=2],a=r[t+1];r[t]=r[e],r[t+1]=r[e+1],r[e]=n,r[e+1]=a}function i(t,e,r){e*=2,r[t*=2]=r[e],r[t+1]=r[e+1]}function o(t,e,r,n){e*=2,r*=2;var a=n[t*=2],i=n[t+1];n[t]=n[e],n[t+1]=n[e+1],n[e]=n[r],n[e+1]=n[r+1],n[r]=a,n[r+1]=i}function s(t,e,r,n,a){e*=2,a[t*=2]=a[e],a[e]=r,a[t+1]=a[e+1],a[e+1]=n}function l(t,e,r){e*=2;var n=r[t*=2],a=r[e];return!(n<a)&&(n!==a||r[t+1]>r[e+1])}function c(t,e,r,n){var a=n[t*=2];return a<e||a===e&&n[t+1]<r}},{}],105:[function(t,e,r){"use strict";e.exports={init:function(t){var e=a.nextPow2(t);o.length<e&&(n.free(o),o=n.mallocInt32(e));s.length<e&&(n.free(s),s=n.mallocInt32(e));l.length<e&&(n.free(l),l=n.mallocInt32(e));c.length<e&&(n.free(c),c=n.mallocInt32(e));u.length<e&&(n.free(u),u=n.mallocInt32(e));h.length<e&&(n.free(h),h=n.mallocInt32(e));var r=8*e;f.length<r&&(n.free(f),f=n.mallocDouble(r))},sweepBipartite:function(t,e,r,n,a,u,h,g,m,v){for(var y=0,x=2*t,b=t-1,_=x-1,w=r;w<n;++w){var T=u[w],k=x*w;f[y++]=a[k+b],f[y++]=-(T+1),f[y++]=a[k+_],f[y++]=T}for(w=h;w<g;++w){T=v[w]+(1<<28);var M=x*w;f[y++]=m[M+b],f[y++]=-T,f[y++]=m[M+_],f[y++]=T}var A=y>>>1;i(f,A);var S=0,E=0;for(w=0;w<A;++w){var C=0|f[2*w+1];if(C>=1<<28)p(l,c,E--,C=C-(1<<28)|0);else if(C>=0)p(o,s,S--,C);else if(C<=-(1<<28)){C=-C-(1<<28)|0;for(var L=0;L<S;++L){if(void 0!==(P=e(o[L],C)))return P}d(l,c,E++,C)}else{C=-C-1|0;for(L=0;L<E;++L){var P;if(void 0!==(P=e(C,l[L])))return P}d(o,s,S++,C)}}},sweepComplete:function(t,e,r,n,a,g,m,v,y,x){for(var b=0,_=2*t,w=t-1,T=_-1,k=r;k<n;++k){var M=g[k]+1<<1,A=_*k;f[b++]=a[A+w],f[b++]=-M,f[b++]=a[A+T],f[b++]=M}for(k=m;k<v;++k){M=x[k]+1<<1;var S=_*k;f[b++]=y[S+w],f[b++]=1|-M,f[b++]=y[S+T],f[b++]=1|M}var E=b>>>1;i(f,E);var C=0,L=0,P=0;for(k=0;k<E;++k){var I=0|f[2*k+1],z=1&I;if(k<E-1&&I>>1==f[2*k+3]>>1&&(z=2,k+=1),I<0){for(var O=-(I>>1)-1,D=0;D<P;++D){if(void 0!==(R=e(u[D],O)))return R}if(0!==z)for(D=0;D<C;++D){if(void 0!==(R=e(o[D],O)))return R}if(1!==z)for(D=0;D<L;++D){var R;if(void 0!==(R=e(l[D],O)))return R}0===z?d(o,s,C++,O):1===z?d(l,c,L++,O):2===z&&d(u,h,P++,O)}else{O=(I>>1)-1;0===z?p(o,s,C--,O):1===z?p(l,c,L--,O):2===z&&p(u,h,P--,O)}}},scanBipartite:function(t,e,r,n,a,l,c,u,h,g,m,v){var y=0,x=2*t,b=e,_=e+t,w=1,T=1;n?T=1<<28:w=1<<28;for(var k=a;k<l;++k){var M=k+w,A=x*k;f[y++]=c[A+b],f[y++]=-M,f[y++]=c[A+_],f[y++]=M}for(k=h;k<g;++k){M=k+T;var S=x*k;f[y++]=m[S+b],f[y++]=-M}var E=y>>>1;i(f,E);var C=0;for(k=0;k<E;++k){var L=0|f[2*k+1];if(L<0){var P=!1;if((M=-L)>=1<<28?(P=!n,M-=1<<28):(P=!!n,M-=1),P)d(o,s,C++,M);else{var I=v[M],z=x*M,O=m[z+e+1],D=m[z+e+1+t];t:for(var R=0;R<C;++R){var F=o[R],B=x*F;if(!(D<c[B+e+1]||c[B+e+1+t]<O)){for(var N=e+2;N<t;++N)if(m[z+N+t]<c[B+N]||c[B+N+t]<m[z+N])continue t;var j,U=u[F];if(void 0!==(j=n?r(I,U):r(U,I)))return j}}}}else p(o,s,C--,L-w)}},scanComplete:function(t,e,r,n,a,s,l,c,u,h,p){for(var d=0,g=2*t,m=e,v=e+t,y=n;y<a;++y){var x=y+(1<<28),b=g*y;f[d++]=s[b+m],f[d++]=-x,f[d++]=s[b+v],f[d++]=x}for(y=c;y<u;++y){x=y+1;var _=g*y;f[d++]=h[_+m],f[d++]=-x}var w=d>>>1;i(f,w);var T=0;for(y=0;y<w;++y){var k=0|f[2*y+1];if(k<0){if((x=-k)>=1<<28)o[T++]=x-(1<<28);else{var M=p[x-=1],A=g*x,S=h[A+e+1],E=h[A+e+1+t];t:for(var C=0;C<T;++C){var L=o[C],P=l[L];if(P===M)break;var I=g*L;if(!(E<s[I+e+1]||s[I+e+1+t]<S)){for(var z=e+2;z<t;++z)if(h[A+z+t]<s[I+z]||s[I+z+t]<h[A+z])continue t;var O=r(P,M);if(void 0!==O)return O}}}}else{for(x=k-(1<<28),C=T-1;C>=0;--C)if(o[C]===x){for(z=C+1;z<T;++z)o[z-1]=o[z];break}--T}}}};var n=t("typedarray-pool"),a=t("bit-twiddle"),i=t("./sort"),o=n.mallocInt32(1024),s=n.mallocInt32(1024),l=n.mallocInt32(1024),c=n.mallocInt32(1024),u=n.mallocInt32(1024),h=n.mallocInt32(1024),f=n.mallocDouble(8192);function p(t,e,r,n){var a=e[n],i=t[r-1];t[a]=i,e[i]=a}function d(t,e,r,n){t[r]=n,e[n]=r}},{"./sort":104,"bit-twiddle":95,"typedarray-pool":554}],106:[function(t,e,r){},{}],107:[function(t,e,r){var n=Object.create||function(t){var e=function(){};return e.prototype=t,new e},a=Object.keys||function(t){var e=[];for(var r in t)Object.prototype.hasOwnProperty.call(t,r)&&e.push(r);return r},i=Function.prototype.bind||function(t){var e=this;return function(){return e.apply(t,arguments)}};function o(){this._events&&Object.prototype.hasOwnProperty.call(this,"_events")||(this._events=n(null),this._eventsCount=0),this._maxListeners=this._maxListeners||void 0}e.exports=o,o.EventEmitter=o,o.prototype._events=void 0,o.prototype._maxListeners=void 0;var s,l=10;try{var c={};Object.defineProperty&&Object.defineProperty(c,"x",{value:0}),s=0===c.x}catch(t){s=!1}function u(t){return void 0===t._maxListeners?o.defaultMaxListeners:t._maxListeners}function h(t,e,r){if(e)t.call(r);else for(var n=t.length,a=_(t,n),i=0;i<n;++i)a[i].call(r)}function f(t,e,r,n){if(e)t.call(r,n);else for(var a=t.length,i=_(t,a),o=0;o<a;++o)i[o].call(r,n)}function p(t,e,r,n,a){if(e)t.call(r,n,a);else for(var i=t.length,o=_(t,i),s=0;s<i;++s)o[s].call(r,n,a)}function d(t,e,r,n,a,i){if(e)t.call(r,n,a,i);else for(var o=t.length,s=_(t,o),l=0;l<o;++l)s[l].call(r,n,a,i)}function g(t,e,r,n){if(e)t.apply(r,n);else for(var a=t.length,i=_(t,a),o=0;o<a;++o)i[o].apply(r,n)}function m(t,e,r,a){var i,o,s;if("function"!=typeof r)throw new TypeError('"listener" argument must be a function');if((o=t._events)?(o.newListener&&(t.emit("newListener",e,r.listener?r.listener:r),o=t._events),s=o[e]):(o=t._events=n(null),t._eventsCount=0),s){if("function"==typeof s?s=o[e]=a?[r,s]:[s,r]:a?s.unshift(r):s.push(r),!s.warned&&(i=u(t))&&i>0&&s.length>i){s.warned=!0;var l=new Error("Possible EventEmitter memory leak detected. "+s.length+' "'+String(e)+'" listeners added. Use emitter.setMaxListeners() to increase limit.');l.name="MaxListenersExceededWarning",l.emitter=t,l.type=e,l.count=s.length,"object"==typeof console&&console.warn&&console.warn("%s: %s",l.name,l.message)}}else s=o[e]=r,++t._eventsCount;return t}function v(){if(!this.fired)switch(this.target.removeListener(this.type,this.wrapFn),this.fired=!0,arguments.length){case 0:return this.listener.call(this.target);case 1:return this.listener.call(this.target,arguments[0]);case 2:return this.listener.call(this.target,arguments[0],arguments[1]);case 3:return this.listener.call(this.target,arguments[0],arguments[1],arguments[2]);default:for(var t=new Array(arguments.length),e=0;e<t.length;++e)t[e]=arguments[e];this.listener.apply(this.target,t)}}function y(t,e,r){var n={fired:!1,wrapFn:void 0,target:t,type:e,listener:r},a=i.call(v,n);return a.listener=r,n.wrapFn=a,a}function x(t,e,r){var n=t._events;if(!n)return[];var a=n[e];return a?"function"==typeof a?r?[a.listener||a]:[a]:r?function(t){for(var e=new Array(t.length),r=0;r<e.length;++r)e[r]=t[r].listener||t[r];return e}(a):_(a,a.length):[]}function b(t){var e=this._events;if(e){var r=e[t];if("function"==typeof r)return 1;if(r)return r.length}return 0}function _(t,e){for(var r=new Array(e),n=0;n<e;++n)r[n]=t[n];return r}s?Object.defineProperty(o,"defaultMaxListeners",{enumerable:!0,get:function(){return l},set:function(t){if("number"!=typeof t||t<0||t!=t)throw new TypeError('"defaultMaxListeners" must be a positive number');l=t}}):o.defaultMaxListeners=l,o.prototype.setMaxListeners=function(t){if("number"!=typeof t||t<0||isNaN(t))throw new TypeError('"n" argument must be a positive number');return this._maxListeners=t,this},o.prototype.getMaxListeners=function(){return u(this)},o.prototype.emit=function(t){var e,r,n,a,i,o,s="error"===t;if(o=this._events)s=s&&null==o.error;else if(!s)return!1;if(s){if(arguments.length>1&&(e=arguments[1]),e instanceof Error)throw e;var l=new Error('Unhandled "error" event. ('+e+")");throw l.context=e,l}if(!(r=o[t]))return!1;var c="function"==typeof r;switch(n=arguments.length){case 1:h(r,c,this);break;case 2:f(r,c,this,arguments[1]);break;case 3:p(r,c,this,arguments[1],arguments[2]);break;case 4:d(r,c,this,arguments[1],arguments[2],arguments[3]);break;default:for(a=new Array(n-1),i=1;i<n;i++)a[i-1]=arguments[i];g(r,c,this,a)}return!0},o.prototype.addListener=function(t,e){return m(this,t,e,!1)},o.prototype.on=o.prototype.addListener,o.prototype.prependListener=function(t,e){return m(this,t,e,!0)},o.prototype.once=function(t,e){if("function"!=typeof e)throw new TypeError('"listener" argument must be a function');return this.on(t,y(this,t,e)),this},o.prototype.prependOnceListener=function(t,e){if("function"!=typeof e)throw new TypeError('"listener" argument must be a function');return this.prependListener(t,y(this,t,e)),this},o.prototype.removeListener=function(t,e){var r,a,i,o,s;if("function"!=typeof e)throw new TypeError('"listener" argument must be a function');if(!(a=this._events))return this;if(!(r=a[t]))return this;if(r===e||r.listener===e)0==--this._eventsCount?this._events=n(null):(delete a[t],a.removeListener&&this.emit("removeListener",t,r.listener||e));else if("function"!=typeof r){for(i=-1,o=r.length-1;o>=0;o--)if(r[o]===e||r[o].listener===e){s=r[o].listener,i=o;break}if(i<0)return this;0===i?r.shift():function(t,e){for(var r=e,n=r+1,a=t.length;n<a;r+=1,n+=1)t[r]=t[n];t.pop()}(r,i),1===r.length&&(a[t]=r[0]),a.removeListener&&this.emit("removeListener",t,s||e)}return this},o.prototype.removeAllListeners=function(t){var e,r,i;if(!(r=this._events))return this;if(!r.removeListener)return 0===arguments.length?(this._events=n(null),this._eventsCount=0):r[t]&&(0==--this._eventsCount?this._events=n(null):delete r[t]),this;if(0===arguments.length){var o,s=a(r);for(i=0;i<s.length;++i)"removeListener"!==(o=s[i])&&this.removeAllListeners(o);return this.removeAllListeners("removeListener"),this._events=n(null),this._eventsCount=0,this}if("function"==typeof(e=r[t]))this.removeListener(t,e);else if(e)for(i=e.length-1;i>=0;i--)this.removeListener(t,e[i]);return this},o.prototype.listeners=function(t){return x(this,t,!0)},o.prototype.rawListeners=function(t){return x(this,t,!1)},o.listenerCount=function(t,e){return"function"==typeof t.listenerCount?t.listenerCount(e):b.call(t,e)},o.prototype.listenerCount=b,o.prototype.eventNames=function(){return this._eventsCount>0?Reflect.ownKeys(this._events):[]}},{}],108:[function(t,e,r){(function(e){
/*!
 * The buffer module from node.js, for the browser.
 *
 * @author   Feross Aboukhadijeh <https://feross.org>
 * @license  MIT
 */
"use strict";var n=t("base64-js"),a=t("ieee754");r.Buffer=e,r.SlowBuffer=function(t){+t!=t&&(t=0);return e.alloc(+t)},r.INSPECT_MAX_BYTES=50;function i(t){if(t>2147483647)throw new RangeError('The value "'+t+'" is invalid for option "size"');var r=new Uint8Array(t);return r.__proto__=e.prototype,r}function e(t,e,r){if("number"==typeof t){if("string"==typeof e)throw new TypeError('The "string" argument must be of type string. Received type number');return l(t)}return o(t,e,r)}function o(t,r,n){if("string"==typeof t)return function(t,r){"string"==typeof r&&""!==r||(r="utf8");if(!e.isEncoding(r))throw new TypeError("Unknown encoding: "+r);var n=0|h(t,r),a=i(n),o=a.write(t,r);o!==n&&(a=a.slice(0,o));return a}(t,r);if(ArrayBuffer.isView(t))return c(t);if(null==t)throw TypeError("The first argument must be one of type string, Buffer, ArrayBuffer, Array, or Array-like Object. Received type "+typeof t);if(B(t,ArrayBuffer)||t&&B(t.buffer,ArrayBuffer))return function(t,r,n){if(r<0||t.byteLength<r)throw new RangeError('"offset" is outside of buffer bounds');if(t.byteLength<r+(n||0))throw new RangeError('"length" is outside of buffer bounds');var a;a=void 0===r&&void 0===n?new Uint8Array(t):void 0===n?new Uint8Array(t,r):new Uint8Array(t,r,n);return a.__proto__=e.prototype,a}(t,r,n);if("number"==typeof t)throw new TypeError('The "value" argument must not be of type number. Received type number');var a=t.valueOf&&t.valueOf();if(null!=a&&a!==t)return e.from(a,r,n);var o=function(t){if(e.isBuffer(t)){var r=0|u(t.length),n=i(r);return 0===n.length||t.copy(n,0,0,r),n}if(void 0!==t.length)return"number"!=typeof t.length||N(t.length)?i(0):c(t);if("Buffer"===t.type&&Array.isArray(t.data))return c(t.data)}(t);if(o)return o;if("undefined"!=typeof Symbol&&null!=Symbol.toPrimitive&&"function"==typeof t[Symbol.toPrimitive])return e.from(t[Symbol.toPrimitive]("string"),r,n);throw new TypeError("The first argument must be one of type string, Buffer, ArrayBuffer, Array, or Array-like Object. Received type "+typeof t)}function s(t){if("number"!=typeof t)throw new TypeError('"size" argument must be of type number');if(t<0)throw new RangeError('The value "'+t+'" is invalid for option "size"')}function l(t){return s(t),i(t<0?0:0|u(t))}function c(t){for(var e=t.length<0?0:0|u(t.length),r=i(e),n=0;n<e;n+=1)r[n]=255&t[n];return r}function u(t){if(t>=2147483647)throw new RangeError("Attempt to allocate Buffer larger than maximum size: 0x"+2147483647..toString(16)+" bytes");return 0|t}function h(t,r){if(e.isBuffer(t))return t.length;if(ArrayBuffer.isView(t)||B(t,ArrayBuffer))return t.byteLength;if("string"!=typeof t)throw new TypeError('The "string" argument must be one of type string, Buffer, or ArrayBuffer. Received type '+typeof t);var n=t.length,a=arguments.length>2&&!0===arguments[2];if(!a&&0===n)return 0;for(var i=!1;;)switch(r){case"ascii":case"latin1":case"binary":return n;case"utf8":case"utf-8":return D(t).length;case"ucs2":case"ucs-2":case"utf16le":case"utf-16le":return 2*n;case"hex":return n>>>1;case"base64":return R(t).length;default:if(i)return a?-1:D(t).length;r=(""+r).toLowerCase(),i=!0}}function f(t,e,r){var n=!1;if((void 0===e||e<0)&&(e=0),e>this.length)return"";if((void 0===r||r>this.length)&&(r=this.length),r<=0)return"";if((r>>>=0)<=(e>>>=0))return"";for(t||(t="utf8");;)switch(t){case"hex":return A(this,e,r);case"utf8":case"utf-8":return T(this,e,r);case"ascii":return k(this,e,r);case"latin1":case"binary":return M(this,e,r);case"base64":return w(this,e,r);case"ucs2":case"ucs-2":case"utf16le":case"utf-16le":return S(this,e,r);default:if(n)throw new TypeError("Unknown encoding: "+t);t=(t+"").toLowerCase(),n=!0}}function p(t,e,r){var n=t[e];t[e]=t[r],t[r]=n}function d(t,r,n,a,i){if(0===t.length)return-1;if("string"==typeof n?(a=n,n=0):n>2147483647?n=2147483647:n<-2147483648&&(n=-2147483648),N(n=+n)&&(n=i?0:t.length-1),n<0&&(n=t.length+n),n>=t.length){if(i)return-1;n=t.length-1}else if(n<0){if(!i)return-1;n=0}if("string"==typeof r&&(r=e.from(r,a)),e.isBuffer(r))return 0===r.length?-1:g(t,r,n,a,i);if("number"==typeof r)return r&=255,"function"==typeof Uint8Array.prototype.indexOf?i?Uint8Array.prototype.indexOf.call(t,r,n):Uint8Array.prototype.lastIndexOf.call(t,r,n):g(t,[r],n,a,i);throw new TypeError("val must be string, number or Buffer")}function g(t,e,r,n,a){var i,o=1,s=t.length,l=e.length;if(void 0!==n&&("ucs2"===(n=String(n).toLowerCase())||"ucs-2"===n||"utf16le"===n||"utf-16le"===n)){if(t.length<2||e.length<2)return-1;o=2,s/=2,l/=2,r/=2}function c(t,e){return 1===o?t[e]:t.readUInt16BE(e*o)}if(a){var u=-1;for(i=r;i<s;i++)if(c(t,i)===c(e,-1===u?0:i-u)){if(-1===u&&(u=i),i-u+1===l)return u*o}else-1!==u&&(i-=i-u),u=-1}else for(r+l>s&&(r=s-l),i=r;i>=0;i--){for(var h=!0,f=0;f<l;f++)if(c(t,i+f)!==c(e,f)){h=!1;break}if(h)return i}return-1}function m(t,e,r,n){r=Number(r)||0;var a=t.length-r;n?(n=Number(n))>a&&(n=a):n=a;var i=e.length;n>i/2&&(n=i/2);for(var o=0;o<n;++o){var s=parseInt(e.substr(2*o,2),16);if(N(s))return o;t[r+o]=s}return o}function v(t,e,r,n){return F(D(e,t.length-r),t,r,n)}function y(t,e,r,n){return F(function(t){for(var e=[],r=0;r<t.length;++r)e.push(255&t.charCodeAt(r));return e}(e),t,r,n)}function x(t,e,r,n){return y(t,e,r,n)}function b(t,e,r,n){return F(R(e),t,r,n)}function _(t,e,r,n){return F(function(t,e){for(var r,n,a,i=[],o=0;o<t.length&&!((e-=2)<0);++o)r=t.charCodeAt(o),n=r>>8,a=r%256,i.push(a),i.push(n);return i}(e,t.length-r),t,r,n)}function w(t,e,r){return 0===e&&r===t.length?n.fromByteArray(t):n.fromByteArray(t.slice(e,r))}function T(t,e,r){r=Math.min(t.length,r);for(var n=[],a=e;a<r;){var i,o,s,l,c=t[a],u=null,h=c>239?4:c>223?3:c>191?2:1;if(a+h<=r)switch(h){case 1:c<128&&(u=c);break;case 2:128==(192&(i=t[a+1]))&&(l=(31&c)<<6|63&i)>127&&(u=l);break;case 3:i=t[a+1],o=t[a+2],128==(192&i)&&128==(192&o)&&(l=(15&c)<<12|(63&i)<<6|63&o)>2047&&(l<55296||l>57343)&&(u=l);break;case 4:i=t[a+1],o=t[a+2],s=t[a+3],128==(192&i)&&128==(192&o)&&128==(192&s)&&(l=(15&c)<<18|(63&i)<<12|(63&o)<<6|63&s)>65535&&l<1114112&&(u=l)}null===u?(u=65533,h=1):u>65535&&(u-=65536,n.push(u>>>10&1023|55296),u=56320|1023&u),n.push(u),a+=h}return function(t){var e=t.length;if(e<=4096)return String.fromCharCode.apply(String,t);var r="",n=0;for(;n<e;)r+=String.fromCharCode.apply(String,t.slice(n,n+=4096));return r}(n)}r.kMaxLength=2147483647,e.TYPED_ARRAY_SUPPORT=function(){try{var t=new Uint8Array(1);return t.__proto__={__proto__:Uint8Array.prototype,foo:function(){return 42}},42===t.foo()}catch(t){return!1}}(),e.TYPED_ARRAY_SUPPORT||"undefined"==typeof console||"function"!=typeof console.error||console.error("This browser lacks typed array (Uint8Array) support which is required by `buffer` v5.x. Use `buffer` v4.x if you require old browser support."),Object.defineProperty(e.prototype,"parent",{enumerable:!0,get:function(){if(e.isBuffer(this))return this.buffer}}),Object.defineProperty(e.prototype,"offset",{enumerable:!0,get:function(){if(e.isBuffer(this))return this.byteOffset}}),"undefined"!=typeof Symbol&&null!=Symbol.species&&e[Symbol.species]===e&&Object.defineProperty(e,Symbol.species,{value:null,configurable:!0,enumerable:!1,writable:!1}),e.poolSize=8192,e.from=function(t,e,r){return o(t,e,r)},e.prototype.__proto__=Uint8Array.prototype,e.__proto__=Uint8Array,e.alloc=function(t,e,r){return function(t,e,r){return s(t),t<=0?i(t):void 0!==e?"string"==typeof r?i(t).fill(e,r):i(t).fill(e):i(t)}(t,e,r)},e.allocUnsafe=function(t){return l(t)},e.allocUnsafeSlow=function(t){return l(t)},e.isBuffer=function(t){return null!=t&&!0===t._isBuffer&&t!==e.prototype},e.compare=function(t,r){if(B(t,Uint8Array)&&(t=e.from(t,t.offset,t.byteLength)),B(r,Uint8Array)&&(r=e.from(r,r.offset,r.byteLength)),!e.isBuffer(t)||!e.isBuffer(r))throw new TypeError('The "buf1", "buf2" arguments must be one of type Buffer or Uint8Array');if(t===r)return 0;for(var n=t.length,a=r.length,i=0,o=Math.min(n,a);i<o;++i)if(t[i]!==r[i]){n=t[i],a=r[i];break}return n<a?-1:a<n?1:0},e.isEncoding=function(t){switch(String(t).toLowerCase()){case"hex":case"utf8":case"utf-8":case"ascii":case"latin1":case"binary":case"base64":case"ucs2":case"ucs-2":case"utf16le":case"utf-16le":return!0;default:return!1}},e.concat=function(t,r){if(!Array.isArray(t))throw new TypeError('"list" argument must be an Array of Buffers');if(0===t.length)return e.alloc(0);var n;if(void 0===r)for(r=0,n=0;n<t.length;++n)r+=t[n].length;var a=e.allocUnsafe(r),i=0;for(n=0;n<t.length;++n){var o=t[n];if(B(o,Uint8Array)&&(o=e.from(o)),!e.isBuffer(o))throw new TypeError('"list" argument must be an Array of Buffers');o.copy(a,i),i+=o.length}return a},e.byteLength=h,e.prototype._isBuffer=!0,e.prototype.swap16=function(){var t=this.length;if(t%2!=0)throw new RangeError("Buffer size must be a multiple of 16-bits");for(var e=0;e<t;e+=2)p(this,e,e+1);return this},e.prototype.swap32=function(){var t=this.length;if(t%4!=0)throw new RangeError("Buffer size must be a multiple of 32-bits");for(var e=0;e<t;e+=4)p(this,e,e+3),p(this,e+1,e+2);return this},e.prototype.swap64=function(){var t=this.length;if(t%8!=0)throw new RangeError("Buffer size must be a multiple of 64-bits");for(var e=0;e<t;e+=8)p(this,e,e+7),p(this,e+1,e+6),p(this,e+2,e+5),p(this,e+3,e+4);return this},e.prototype.toString=function(){var t=this.length;return 0===t?"":0===arguments.length?T(this,0,t):f.apply(this,arguments)},e.prototype.toLocaleString=e.prototype.toString,e.prototype.equals=function(t){if(!e.isBuffer(t))throw new TypeError("Argument must be a Buffer");return this===t||0===e.compare(this,t)},e.prototype.inspect=function(){var t="",e=r.INSPECT_MAX_BYTES;return t=this.toString("hex",0,e).replace(/(.{2})/g,"$1 ").trim(),this.length>e&&(t+=" ... "),"<Buffer "+t+">"},e.prototype.compare=function(t,r,n,a,i){if(B(t,Uint8Array)&&(t=e.from(t,t.offset,t.byteLength)),!e.isBuffer(t))throw new TypeError('The "target" argument must be one of type Buffer or Uint8Array. Received type '+typeof t);if(void 0===r&&(r=0),void 0===n&&(n=t?t.length:0),void 0===a&&(a=0),void 0===i&&(i=this.length),r<0||n>t.length||a<0||i>this.length)throw new RangeError("out of range index");if(a>=i&&r>=n)return 0;if(a>=i)return-1;if(r>=n)return 1;if(this===t)return 0;for(var o=(i>>>=0)-(a>>>=0),s=(n>>>=0)-(r>>>=0),l=Math.min(o,s),c=this.slice(a,i),u=t.slice(r,n),h=0;h<l;++h)if(c[h]!==u[h]){o=c[h],s=u[h];break}return o<s?-1:s<o?1:0},e.prototype.includes=function(t,e,r){return-1!==this.indexOf(t,e,r)},e.prototype.indexOf=function(t,e,r){return d(this,t,e,r,!0)},e.prototype.lastIndexOf=function(t,e,r){return d(this,t,e,r,!1)},e.prototype.write=function(t,e,r,n){if(void 0===e)n="utf8",r=this.length,e=0;else if(void 0===r&&"string"==typeof e)n=e,r=this.length,e=0;else{if(!isFinite(e))throw new Error("Buffer.write(string, encoding, offset[, length]) is no longer supported");e>>>=0,isFinite(r)?(r>>>=0,void 0===n&&(n="utf8")):(n=r,r=void 0)}var a=this.length-e;if((void 0===r||r>a)&&(r=a),t.length>0&&(r<0||e<0)||e>this.length)throw new RangeError("Attempt to write outside buffer bounds");n||(n="utf8");for(var i=!1;;)switch(n){case"hex":return m(this,t,e,r);case"utf8":case"utf-8":return v(this,t,e,r);case"ascii":return y(this,t,e,r);case"latin1":case"binary":return x(this,t,e,r);case"base64":return b(this,t,e,r);case"ucs2":case"ucs-2":case"utf16le":case"utf-16le":return _(this,t,e,r);default:if(i)throw new TypeError("Unknown encoding: "+n);n=(""+n).toLowerCase(),i=!0}},e.prototype.toJSON=function(){return{type:"Buffer",data:Array.prototype.slice.call(this._arr||this,0)}};function k(t,e,r){var n="";r=Math.min(t.length,r);for(var a=e;a<r;++a)n+=String.fromCharCode(127&t[a]);return n}function M(t,e,r){var n="";r=Math.min(t.length,r);for(var a=e;a<r;++a)n+=String.fromCharCode(t[a]);return n}function A(t,e,r){var n=t.length;(!e||e<0)&&(e=0),(!r||r<0||r>n)&&(r=n);for(var a="",i=e;i<r;++i)a+=O(t[i]);return a}function S(t,e,r){for(var n=t.slice(e,r),a="",i=0;i<n.length;i+=2)a+=String.fromCharCode(n[i]+256*n[i+1]);return a}function E(t,e,r){if(t%1!=0||t<0)throw new RangeError("offset is not uint");if(t+e>r)throw new RangeError("Trying to access beyond buffer length")}function C(t,r,n,a,i,o){if(!e.isBuffer(t))throw new TypeError('"buffer" argument must be a Buffer instance');if(r>i||r<o)throw new RangeError('"value" argument is out of bounds');if(n+a>t.length)throw new RangeError("Index out of range")}function L(t,e,r,n,a,i){if(r+n>t.length)throw new RangeError("Index out of range");if(r<0)throw new RangeError("Index out of range")}function P(t,e,r,n,i){return e=+e,r>>>=0,i||L(t,0,r,4),a.write(t,e,r,n,23,4),r+4}function I(t,e,r,n,i){return e=+e,r>>>=0,i||L(t,0,r,8),a.write(t,e,r,n,52,8),r+8}e.prototype.slice=function(t,r){var n=this.length;(t=~~t)<0?(t+=n)<0&&(t=0):t>n&&(t=n),(r=void 0===r?n:~~r)<0?(r+=n)<0&&(r=0):r>n&&(r=n),r<t&&(r=t);var a=this.subarray(t,r);return a.__proto__=e.prototype,a},e.prototype.readUIntLE=function(t,e,r){t>>>=0,e>>>=0,r||E(t,e,this.length);for(var n=this[t],a=1,i=0;++i<e&&(a*=256);)n+=this[t+i]*a;return n},e.prototype.readUIntBE=function(t,e,r){t>>>=0,e>>>=0,r||E(t,e,this.length);for(var n=this[t+--e],a=1;e>0&&(a*=256);)n+=this[t+--e]*a;return n},e.prototype.readUInt8=function(t,e){return t>>>=0,e||E(t,1,this.length),this[t]},e.prototype.readUInt16LE=function(t,e){return t>>>=0,e||E(t,2,this.length),this[t]|this[t+1]<<8},e.prototype.readUInt16BE=function(t,e){return t>>>=0,e||E(t,2,this.length),this[t]<<8|this[t+1]},e.prototype.readUInt32LE=function(t,e){return t>>>=0,e||E(t,4,this.length),(this[t]|this[t+1]<<8|this[t+2]<<16)+16777216*this[t+3]},e.prototype.readUInt32BE=function(t,e){return t>>>=0,e||E(t,4,this.length),16777216*this[t]+(this[t+1]<<16|this[t+2]<<8|this[t+3])},e.prototype.readIntLE=function(t,e,r){t>>>=0,e>>>=0,r||E(t,e,this.length);for(var n=this[t],a=1,i=0;++i<e&&(a*=256);)n+=this[t+i]*a;return n>=(a*=128)&&(n-=Math.pow(2,8*e)),n},e.prototype.readIntBE=function(t,e,r){t>>>=0,e>>>=0,r||E(t,e,this.length);for(var n=e,a=1,i=this[t+--n];n>0&&(a*=256);)i+=this[t+--n]*a;return i>=(a*=128)&&(i-=Math.pow(2,8*e)),i},e.prototype.readInt8=function(t,e){return t>>>=0,e||E(t,1,this.length),128&this[t]?-1*(255-this[t]+1):this[t]},e.prototype.readInt16LE=function(t,e){t>>>=0,e||E(t,2,this.length);var r=this[t]|this[t+1]<<8;return 32768&r?4294901760|r:r},e.prototype.readInt16BE=function(t,e){t>>>=0,e||E(t,2,this.length);var r=this[t+1]|this[t]<<8;return 32768&r?4294901760|r:r},e.prototype.readInt32LE=function(t,e){return t>>>=0,e||E(t,4,this.length),this[t]|this[t+1]<<8|this[t+2]<<16|this[t+3]<<24},e.prototype.readInt32BE=function(t,e){return t>>>=0,e||E(t,4,this.length),this[t]<<24|this[t+1]<<16|this[t+2]<<8|this[t+3]},e.prototype.readFloatLE=function(t,e){return t>>>=0,e||E(t,4,this.length),a.read(this,t,!0,23,4)},e.prototype.readFloatBE=function(t,e){return t>>>=0,e||E(t,4,this.length),a.read(this,t,!1,23,4)},e.prototype.readDoubleLE=function(t,e){return t>>>=0,e||E(t,8,this.length),a.read(this,t,!0,52,8)},e.prototype.readDoubleBE=function(t,e){return t>>>=0,e||E(t,8,this.length),a.read(this,t,!1,52,8)},e.prototype.writeUIntLE=function(t,e,r,n){(t=+t,e>>>=0,r>>>=0,n)||C(this,t,e,r,Math.pow(2,8*r)-1,0);var a=1,i=0;for(this[e]=255&t;++i<r&&(a*=256);)this[e+i]=t/a&255;return e+r},e.prototype.writeUIntBE=function(t,e,r,n){(t=+t,e>>>=0,r>>>=0,n)||C(this,t,e,r,Math.pow(2,8*r)-1,0);var a=r-1,i=1;for(this[e+a]=255&t;--a>=0&&(i*=256);)this[e+a]=t/i&255;return e+r},e.prototype.writeUInt8=function(t,e,r){return t=+t,e>>>=0,r||C(this,t,e,1,255,0),this[e]=255&t,e+1},e.prototype.writeUInt16LE=function(t,e,r){return t=+t,e>>>=0,r||C(this,t,e,2,65535,0),this[e]=255&t,this[e+1]=t>>>8,e+2},e.prototype.writeUInt16BE=function(t,e,r){return t=+t,e>>>=0,r||C(this,t,e,2,65535,0),this[e]=t>>>8,this[e+1]=255&t,e+2},e.prototype.writeUInt32LE=function(t,e,r){return t=+t,e>>>=0,r||C(this,t,e,4,4294967295,0),this[e+3]=t>>>24,this[e+2]=t>>>16,this[e+1]=t>>>8,this[e]=255&t,e+4},e.prototype.writeUInt32BE=function(t,e,r){return t=+t,e>>>=0,r||C(this,t,e,4,4294967295,0),this[e]=t>>>24,this[e+1]=t>>>16,this[e+2]=t>>>8,this[e+3]=255&t,e+4},e.prototype.writeIntLE=function(t,e,r,n){if(t=+t,e>>>=0,!n){var a=Math.pow(2,8*r-1);C(this,t,e,r,a-1,-a)}var i=0,o=1,s=0;for(this[e]=255&t;++i<r&&(o*=256);)t<0&&0===s&&0!==this[e+i-1]&&(s=1),this[e+i]=(t/o>>0)-s&255;return e+r},e.prototype.writeIntBE=function(t,e,r,n){if(t=+t,e>>>=0,!n){var a=Math.pow(2,8*r-1);C(this,t,e,r,a-1,-a)}var i=r-1,o=1,s=0;for(this[e+i]=255&t;--i>=0&&(o*=256);)t<0&&0===s&&0!==this[e+i+1]&&(s=1),this[e+i]=(t/o>>0)-s&255;return e+r},e.prototype.writeInt8=function(t,e,r){return t=+t,e>>>=0,r||C(this,t,e,1,127,-128),t<0&&(t=255+t+1),this[e]=255&t,e+1},e.prototype.writeInt16LE=function(t,e,r){return t=+t,e>>>=0,r||C(this,t,e,2,32767,-32768),this[e]=255&t,this[e+1]=t>>>8,e+2},e.prototype.writeInt16BE=function(t,e,r){return t=+t,e>>>=0,r||C(this,t,e,2,32767,-32768),this[e]=t>>>8,this[e+1]=255&t,e+2},e.prototype.writeInt32LE=function(t,e,r){return t=+t,e>>>=0,r||C(this,t,e,4,2147483647,-2147483648),this[e]=255&t,this[e+1]=t>>>8,this[e+2]=t>>>16,this[e+3]=t>>>24,e+4},e.prototype.writeInt32BE=function(t,e,r){return t=+t,e>>>=0,r||C(this,t,e,4,2147483647,-2147483648),t<0&&(t=4294967295+t+1),this[e]=t>>>24,this[e+1]=t>>>16,this[e+2]=t>>>8,this[e+3]=255&t,e+4},e.prototype.writeFloatLE=function(t,e,r){return P(this,t,e,!0,r)},e.prototype.writeFloatBE=function(t,e,r){return P(this,t,e,!1,r)},e.prototype.writeDoubleLE=function(t,e,r){return I(this,t,e,!0,r)},e.prototype.writeDoubleBE=function(t,e,r){return I(this,t,e,!1,r)},e.prototype.copy=function(t,r,n,a){if(!e.isBuffer(t))throw new TypeError("argument should be a Buffer");if(n||(n=0),a||0===a||(a=this.length),r>=t.length&&(r=t.length),r||(r=0),a>0&&a<n&&(a=n),a===n)return 0;if(0===t.length||0===this.length)return 0;if(r<0)throw new RangeError("targetStart out of bounds");if(n<0||n>=this.length)throw new RangeError("Index out of range");if(a<0)throw new RangeError("sourceEnd out of bounds");a>this.length&&(a=this.length),t.length-r<a-n&&(a=t.length-r+n);var i=a-n;if(this===t&&"function"==typeof Uint8Array.prototype.copyWithin)this.copyWithin(r,n,a);else if(this===t&&n<r&&r<a)for(var o=i-1;o>=0;--o)t[o+r]=this[o+n];else Uint8Array.prototype.set.call(t,this.subarray(n,a),r);return i},e.prototype.fill=function(t,r,n,a){if("string"==typeof t){if("string"==typeof r?(a=r,r=0,n=this.length):"string"==typeof n&&(a=n,n=this.length),void 0!==a&&"string"!=typeof a)throw new TypeError("encoding must be a string");if("string"==typeof a&&!e.isEncoding(a))throw new TypeError("Unknown encoding: "+a);if(1===t.length){var i=t.charCodeAt(0);("utf8"===a&&i<128||"latin1"===a)&&(t=i)}}else"number"==typeof t&&(t&=255);if(r<0||this.length<r||this.length<n)throw new RangeError("Out of range index");if(n<=r)return this;var o;if(r>>>=0,n=void 0===n?this.length:n>>>0,t||(t=0),"number"==typeof t)for(o=r;o<n;++o)this[o]=t;else{var s=e.isBuffer(t)?t:e.from(t,a),l=s.length;if(0===l)throw new TypeError('The value "'+t+'" is invalid for argument "value"');for(o=0;o<n-r;++o)this[o+r]=s[o%l]}return this};var z=/[^+/0-9A-Za-z-_]/g;function O(t){return t<16?"0"+t.toString(16):t.toString(16)}function D(t,e){var r;e=e||1/0;for(var n=t.length,a=null,i=[],o=0;o<n;++o){if((r=t.charCodeAt(o))>55295&&r<57344){if(!a){if(r>56319){(e-=3)>-1&&i.push(239,191,189);continue}if(o+1===n){(e-=3)>-1&&i.push(239,191,189);continue}a=r;continue}if(r<56320){(e-=3)>-1&&i.push(239,191,189),a=r;continue}r=65536+(a-55296<<10|r-56320)}else a&&(e-=3)>-1&&i.push(239,191,189);if(a=null,r<128){if((e-=1)<0)break;i.push(r)}else if(r<2048){if((e-=2)<0)break;i.push(r>>6|192,63&r|128)}else if(r<65536){if((e-=3)<0)break;i.push(r>>12|224,r>>6&63|128,63&r|128)}else{if(!(r<1114112))throw new Error("Invalid code point");if((e-=4)<0)break;i.push(r>>18|240,r>>12&63|128,r>>6&63|128,63&r|128)}}return i}function R(t){return n.toByteArray(function(t){if((t=(t=t.split("=")[0]).trim().replace(z,"")).length<2)return"";for(;t.length%4!=0;)t+="=";return t}(t))}function F(t,e,r,n){for(var a=0;a<n&&!(a+r>=e.length||a>=t.length);++a)e[a+r]=t[a];return a}function B(t,e){return t instanceof e||null!=t&&null!=t.constructor&&null!=t.constructor.name&&t.constructor.name===e.name}function N(t){return t!=t}}).call(this,t("buffer").Buffer)},{"base64-js":77,buffer:108,ieee754:415}],109:[function(t,e,r){"use strict";var n=t("./lib/monotone"),a=t("./lib/triangulation"),i=t("./lib/delaunay"),o=t("./lib/filter");function s(t){return[Math.min(t[0],t[1]),Math.max(t[0],t[1])]}function l(t,e){return t[0]-e[0]||t[1]-e[1]}function c(t,e,r){return e in t?t[e]:r}e.exports=function(t,e,r){Array.isArray(e)?(r=r||{},e=e||[]):(r=e||{},e=[]);var u=!!c(r,"delaunay",!0),h=!!c(r,"interior",!0),f=!!c(r,"exterior",!0),p=!!c(r,"infinity",!1);if(!h&&!f||0===t.length)return[];var d=n(t,e);if(u||h!==f||p){for(var g=a(t.length,function(t){return t.map(s).sort(l)}(e)),m=0;m<d.length;++m){var v=d[m];g.addTriangle(v[0],v[1],v[2])}return u&&i(t,g),f?h?p?o(g,0,p):g.cells():o(g,1,p):o(g,-1)}return d}},{"./lib/delaunay":110,"./lib/filter":111,"./lib/monotone":112,"./lib/triangulation":113}],110:[function(t,e,r){"use strict";var n=t("robust-in-sphere")[4];t("binary-search-bounds");function a(t,e,r,a,i,o){var s=e.opposite(a,i);if(!(s<0)){if(i<a){var l=a;a=i,i=l,l=o,o=s,s=l}e.isConstraint(a,i)||n(t[a],t[i],t[o],t[s])<0&&r.push(a,i)}}e.exports=function(t,e){for(var r=[],i=t.length,o=e.stars,s=0;s<i;++s)for(var l=o[s],c=1;c<l.length;c+=2){if(!((p=l[c])<s)&&!e.isConstraint(s,p)){for(var u=l[c-1],h=-1,f=1;f<l.length;f+=2)if(l[f-1]===p){h=l[f];break}h<0||n(t[s],t[p],t[u],t[h])<0&&r.push(s,p)}}for(;r.length>0;){for(var p=r.pop(),d=(s=r.pop(),u=-1,h=-1,l=o[s],1);d<l.length;d+=2){var g=l[d-1],m=l[d];g===p?h=m:m===p&&(u=g)}u<0||h<0||(n(t[s],t[p],t[u],t[h])>=0||(e.flip(s,p),a(t,e,r,u,s,h),a(t,e,r,s,h,u),a(t,e,r,h,p,u),a(t,e,r,p,u,h)))}}},{"binary-search-bounds":94,"robust-in-sphere":505}],111:[function(t,e,r){"use strict";var n,a=t("binary-search-bounds");function i(t,e,r,n,a,i,o){this.cells=t,this.neighbor=e,this.flags=n,this.constraint=r,this.active=a,this.next=i,this.boundary=o}function o(t,e){return t[0]-e[0]||t[1]-e[1]||t[2]-e[2]}e.exports=function(t,e,r){var n=function(t,e){for(var r=t.cells(),n=r.length,a=0;a<n;++a){var s=(v=r[a])[0],l=v[1],c=v[2];l<c?l<s&&(v[0]=l,v[1]=c,v[2]=s):c<s&&(v[0]=c,v[1]=s,v[2]=l)}r.sort(o);var u=new Array(n);for(a=0;a<u.length;++a)u[a]=0;var h=[],f=[],p=new Array(3*n),d=new Array(3*n),g=null;e&&(g=[]);var m=new i(r,p,d,u,h,f,g);for(a=0;a<n;++a)for(var v=r[a],y=0;y<3;++y){s=v[y],l=v[(y+1)%3];var x=p[3*a+y]=m.locate(l,s,t.opposite(l,s)),b=d[3*a+y]=t.isConstraint(s,l);x<0&&(b?f.push(a):(h.push(a),u[a]=1),e&&g.push([l,s,-1]))}return m}(t,r);if(0===e)return r?n.cells.concat(n.boundary):n.cells;var a=1,s=n.active,l=n.next,c=n.flags,u=n.cells,h=n.constraint,f=n.neighbor;for(;s.length>0||l.length>0;){for(;s.length>0;){var p=s.pop();if(c[p]!==-a){c[p]=a;u[p];for(var d=0;d<3;++d){var g=f[3*p+d];g>=0&&0===c[g]&&(h[3*p+d]?l.push(g):(s.push(g),c[g]=a))}}}var m=l;l=s,s=m,l.length=0,a=-a}var v=function(t,e,r){for(var n=0,a=0;a<t.length;++a)e[a]===r&&(t[n++]=t[a]);return t.length=n,t}(u,c,e);if(r)return v.concat(n.boundary);return v},i.prototype.locate=(n=[0,0,0],function(t,e,r){var i=t,s=e,l=r;return e<r?e<t&&(i=e,s=r,l=t):r<t&&(i=r,s=t,l=e),i<0?-1:(n[0]=i,n[1]=s,n[2]=l,a.eq(this.cells,n,o))})},{"binary-search-bounds":94}],112:[function(t,e,r){"use strict";var n=t("binary-search-bounds"),a=t("robust-orientation")[3];function i(t,e,r,n,a){this.a=t,this.b=e,this.idx=r,this.lowerIds=n,this.upperIds=a}function o(t,e,r,n){this.a=t,this.b=e,this.type=r,this.idx=n}function s(t,e){var r=t.a[0]-e.a[0]||t.a[1]-e.a[1]||t.type-e.type;return r||(0!==t.type&&(r=a(t.a,t.b,e.b))?r:t.idx-e.idx)}function l(t,e){return a(t.a,t.b,e)}function c(t,e,r,i,o){for(var s=n.lt(e,i,l),c=n.gt(e,i,l),u=s;u<c;++u){for(var h=e[u],f=h.lowerIds,p=f.length;p>1&&a(r[f[p-2]],r[f[p-1]],i)>0;)t.push([f[p-1],f[p-2],o]),p-=1;f.length=p,f.push(o);var d=h.upperIds;for(p=d.length;p>1&&a(r[d[p-2]],r[d[p-1]],i)<0;)t.push([d[p-2],d[p-1],o]),p-=1;d.length=p,d.push(o)}}function u(t,e){var r;return(r=t.a[0]<e.a[0]?a(t.a,t.b,e.a):a(e.b,e.a,t.a))?r:(r=e.b[0]<t.b[0]?a(t.a,t.b,e.b):a(e.b,e.a,t.b))||t.idx-e.idx}function h(t,e,r){var a=n.le(t,r,u),o=t[a],s=o.upperIds,l=s[s.length-1];o.upperIds=[l],t.splice(a+1,0,new i(r.a,r.b,r.idx,[l],s))}function f(t,e,r){var a=r.a;r.a=r.b,r.b=a;var i=n.eq(t,r,u),o=t[i];t[i-1].upperIds=o.upperIds,t.splice(i,1)}e.exports=function(t,e){for(var r=t.length,n=e.length,a=[],l=0;l<r;++l)a.push(new o(t[l],null,0,l));for(l=0;l<n;++l){var u=e[l],p=t[u[0]],d=t[u[1]];p[0]<d[0]?a.push(new o(p,d,2,l),new o(d,p,1,l)):p[0]>d[0]&&a.push(new o(d,p,2,l),new o(p,d,1,l))}a.sort(s);for(var g=a[0].a[0]-(1+Math.abs(a[0].a[0]))*Math.pow(2,-52),m=[new i([g,1],[g,0],-1,[],[],[],[])],v=[],y=(l=0,a.length);l<y;++l){var x=a[l],b=x.type;0===b?c(v,m,t,x.a,x.idx):2===b?h(m,t,x):f(m,t,x)}return v}},{"binary-search-bounds":94,"robust-orientation":507}],113:[function(t,e,r){"use strict";var n=t("binary-search-bounds");function a(t,e){this.stars=t,this.edges=e}e.exports=function(t,e){for(var r=new Array(t),n=0;n<t;++n)r[n]=[];return new a(r,e)};var i=a.prototype;function o(t,e,r){for(var n=1,a=t.length;n<a;n+=2)if(t[n-1]===e&&t[n]===r)return t[n-1]=t[a-2],t[n]=t[a-1],void(t.length=a-2)}i.isConstraint=function(){var t=[0,0];function e(t,e){return t[0]-e[0]||t[1]-e[1]}return function(r,a){return t[0]=Math.min(r,a),t[1]=Math.max(r,a),n.eq(this.edges,t,e)>=0}}(),i.removeTriangle=function(t,e,r){var n=this.stars;o(n[t],e,r),o(n[e],r,t),o(n[r],t,e)},i.addTriangle=function(t,e,r){var n=this.stars;n[t].push(e,r),n[e].push(r,t),n[r].push(t,e)},i.opposite=function(t,e){for(var r=this.stars[e],n=1,a=r.length;n<a;n+=2)if(r[n]===t)return r[n-1];return-1},i.flip=function(t,e){var r=this.opposite(t,e),n=this.opposite(e,t);this.removeTriangle(t,e,r),this.removeTriangle(e,t,n),this.addTriangle(t,n,r),this.addTriangle(e,r,n)},i.edges=function(){for(var t=this.stars,e=[],r=0,n=t.length;r<n;++r)for(var a=t[r],i=0,o=a.length;i<o;i+=2)e.push([a[i],a[i+1]]);return e},i.cells=function(){for(var t=this.stars,e=[],r=0,n=t.length;r<n;++r)for(var a=t[r],i=0,o=a.length;i<o;i+=2){var s=a[i],l=a[i+1];r<Math.min(s,l)&&e.push([r,s,l])}return e}},{"binary-search-bounds":94}],114:[function(t,e,r){"use strict";e.exports=function(t){for(var e=1,r=1;r<t.length;++r)for(var n=0;n<r;++n)if(t[r]<t[n])e=-e;else if(t[n]===t[r])return 0;return e}},{}],115:[function(t,e,r){"use strict";var n=t("dup"),a=t("robust-linear-solve");function i(t,e){for(var r=0,n=t.length,a=0;a<n;++a)r+=t[a]*e[a];return r}function o(t){var e=t.length;if(0===e)return[];t[0].length;var r=n([t.length+1,t.length+1],1),o=n([t.length+1],1);r[e][e]=0;for(var s=0;s<e;++s){for(var l=0;l<=s;++l)r[l][s]=r[s][l]=2*i(t[s],t[l]);o[s]=i(t[s],t[s])}var c=a(r,o),u=0,h=c[e+1];for(s=0;s<h.length;++s)u+=h[s];var f=new Array(e);for(s=0;s<e;++s){h=c[s];var p=0;for(l=0;l<h.length;++l)p+=h[l];f[s]=p/u}return f}function s(t){if(0===t.length)return[];for(var e=t[0].length,r=n([e]),a=o(t),i=0;i<t.length;++i)for(var s=0;s<e;++s)r[s]+=t[i][s]*a[i];return r}s.barycenetric=o,e.exports=s},{dup:172,"robust-linear-solve":506}],116:[function(t,e,r){e.exports=function(t){for(var e=n(t),r=0,a=0;a<t.length;++a)for(var i=t[a],o=0;o<e.length;++o)r+=Math.pow(i[o]-e[o],2);return Math.sqrt(r/t.length)};var n=t("circumcenter")},{circumcenter:115}],117:[function(t,e,r){e.exports=function(t,e,r){return e<r?t<e?e:t>r?r:t:t<r?r:t>e?e:t}},{}],118:[function(t,e,r){"use strict";e.exports=function(t,e,r){var n;if(r){n=e;for(var a=new Array(e.length),i=0;i<e.length;++i){var o=e[i];a[i]=[o[0],o[1],r[i]]}e=a}var s=function(t,e,r){var n=d(t,[],p(t));return v(e,n,r),!!n}(t,e,!!r);for(;y(t,e,!!r);)s=!0;if(r&&s){n.length=0,r.length=0;for(i=0;i<e.length;++i){o=e[i];n.push([o[0],o[1]]),r.push(o[2])}}return s};var n=t("union-find"),a=t("box-intersect"),i=t("robust-segment-intersect"),o=t("big-rat"),s=t("big-rat/cmp"),l=t("big-rat/to-float"),c=t("rat-vec"),u=t("nextafter"),h=t("./lib/rat-seg-intersect");function f(t){var e=l(t);return[u(e,-1/0),u(e,1/0)]}function p(t){for(var e=new Array(t.length),r=0;r<t.length;++r){var n=t[r];e[r]=[u(n[0],-1/0),u(n[1],-1/0),u(n[0],1/0),u(n[1],1/0)]}return e}function d(t,e,r){for(var i=e.length,o=new n(i),s=[],l=0;l<e.length;++l){var c=e[l],h=f(c[0]),p=f(c[1]);s.push([u(h[0],-1/0),u(p[0],-1/0),u(h[1],1/0),u(p[1],1/0)])}a(s,(function(t,e){o.link(t,e)}));var d=!0,g=new Array(i);for(l=0;l<i;++l){(v=o.find(l))!==l&&(d=!1,t[v]=[Math.min(t[l][0],t[v][0]),Math.min(t[l][1],t[v][1])])}if(d)return null;var m=0;for(l=0;l<i;++l){var v;(v=o.find(l))===l?(g[l]=m,t[m++]=t[l]):g[l]=-1}t.length=m;for(l=0;l<i;++l)g[l]<0&&(g[l]=g[o.find(l)]);return g}function g(t,e){return t[0]-e[0]||t[1]-e[1]}function m(t,e){var r=t[0]-e[0]||t[1]-e[1];return r||(t[2]<e[2]?-1:t[2]>e[2]?1:0)}function v(t,e,r){if(0!==t.length){if(e)for(var n=0;n<t.length;++n){var a=e[(o=t[n])[0]],i=e[o[1]];o[0]=Math.min(a,i),o[1]=Math.max(a,i)}else for(n=0;n<t.length;++n){var o;a=(o=t[n])[0],i=o[1];o[0]=Math.min(a,i),o[1]=Math.max(a,i)}r?t.sort(m):t.sort(g);var s=1;for(n=1;n<t.length;++n){var l=t[n-1],c=t[n];(c[0]!==l[0]||c[1]!==l[1]||r&&c[2]!==l[2])&&(t[s++]=c)}t.length=s}}function y(t,e,r){var n=function(t,e){for(var r=new Array(e.length),n=0;n<e.length;++n){var a=e[n],i=t[a[0]],o=t[a[1]];r[n]=[u(Math.min(i[0],o[0]),-1/0),u(Math.min(i[1],o[1]),-1/0),u(Math.max(i[0],o[0]),1/0),u(Math.max(i[1],o[1]),1/0)]}return r}(t,e),f=function(t,e,r){var n=[];return a(r,(function(r,a){var o=e[r],s=e[a];if(o[0]!==s[0]&&o[0]!==s[1]&&o[1]!==s[0]&&o[1]!==s[1]){var l=t[o[0]],c=t[o[1]],u=t[s[0]],h=t[s[1]];i(l,c,u,h)&&n.push([r,a])}})),n}(t,e,n),g=p(t),m=function(t,e,r,n){var o=[];return a(r,n,(function(r,n){var a=e[r];if(a[0]!==n&&a[1]!==n){var s=t[n],l=t[a[0]],c=t[a[1]];i(l,c,s,s)&&o.push([r,n])}})),o}(t,e,n,g),y=d(t,function(t,e,r,n,a){var i,u,f=t.map((function(t){return[o(t[0]),o(t[1])]}));for(i=0;i<r.length;++i){var p=r[i];u=p[0];var d=p[1],g=e[u],m=e[d],v=h(c(t[g[0]]),c(t[g[1]]),c(t[m[0]]),c(t[m[1]]));if(v){var y=t.length;t.push([l(v[0]),l(v[1])]),f.push(v),n.push([u,y],[d,y])}}for(n.sort((function(t,e){if(t[0]!==e[0])return t[0]-e[0];var r=f[t[1]],n=f[e[1]];return s(r[0],n[0])||s(r[1],n[1])})),i=n.length-1;i>=0;--i){var x=e[u=(S=n[i])[0]],b=x[0],_=x[1],w=t[b],T=t[_];if((w[0]-T[0]||w[1]-T[1])<0){var k=b;b=_,_=k}x[0]=b;var M,A=x[1]=S[1];for(a&&(M=x[2]);i>0&&n[i-1][0]===u;){var S,E=(S=n[--i])[1];a?e.push([A,E,M]):e.push([A,E]),A=E}a?e.push([A,_,M]):e.push([A,_])}return f}(t,e,f,m,r));return v(e,y,r),!!y||(f.length>0||m.length>0)}},{"./lib/rat-seg-intersect":119,"big-rat":81,"big-rat/cmp":79,"big-rat/to-float":93,"box-intersect":99,nextafter:456,"rat-vec":491,"robust-segment-intersect":510,"union-find":555}],119:[function(t,e,r){"use strict";e.exports=function(t,e,r,n){var i=s(e,t),h=s(n,r),f=u(i,h);if(0===o(f))return null;var p=s(t,r),d=u(h,p),g=a(d,f),m=c(i,g);return l(t,m)};var n=t("big-rat/mul"),a=t("big-rat/div"),i=t("big-rat/sub"),o=t("big-rat/sign"),s=t("rat-vec/sub"),l=t("rat-vec/add"),c=t("rat-vec/muls");function u(t,e){return i(n(t[0],e[1]),n(t[1],e[0]))}},{"big-rat/div":80,"big-rat/mul":90,"big-rat/sign":91,"big-rat/sub":92,"rat-vec/add":490,"rat-vec/muls":492,"rat-vec/sub":493}],120:[function(t,e,r){"use strict";var n=t("clamp");function a(t,e){null==e&&(e=!0);var r=t[0],a=t[1],i=t[2],o=t[3];return null==o&&(o=e?1:255),e&&(r*=255,a*=255,i*=255,o*=255),16777216*(r=255&n(r,0,255))+((a=255&n(a,0,255))<<16)+((i=255&n(i,0,255))<<8)+(o=255&n(o,0,255))}e.exports=a,e.exports.to=a,e.exports.from=function(t,e){var r=(t=+t)>>>24,n=(16711680&t)>>>16,a=(65280&t)>>>8,i=255&t;return!1===e?[r,n,a,i]:[r/255,n/255,a/255,i/255]}},{clamp:117}],121:[function(t,e,r){"use strict";e.exports={aliceblue:[240,248,255],antiquewhite:[250,235,215],aqua:[0,255,255],aquamarine:[127,255,212],azure:[240,255,255],beige:[245,245,220],bisque:[255,228,196],black:[0,0,0],blanchedalmond:[255,235,205],blue:[0,0,255],blueviolet:[138,43,226],brown:[165,42,42],burlywood:[222,184,135],cadetblue:[95,158,160],chartreuse:[127,255,0],chocolate:[210,105,30],coral:[255,127,80],cornflowerblue:[100,149,237],cornsilk:[255,248,220],crimson:[220,20,60],cyan:[0,255,255],darkblue:[0,0,139],darkcyan:[0,139,139],darkgoldenrod:[184,134,11],darkgray:[169,169,169],darkgreen:[0,100,0],darkgrey:[169,169,169],darkkhaki:[189,183,107],darkmagenta:[139,0,139],darkolivegreen:[85,107,47],darkorange:[255,140,0],darkorchid:[153,50,204],darkred:[139,0,0],darksalmon:[233,150,122],darkseagreen:[143,188,143],darkslateblue:[72,61,139],darkslategray:[47,79,79],darkslategrey:[47,79,79],darkturquoise:[0,206,209],darkviolet:[148,0,211],deeppink:[255,20,147],deepskyblue:[0,191,255],dimgray:[105,105,105],dimgrey:[105,105,105],dodgerblue:[30,144,255],firebrick:[178,34,34],floralwhite:[255,250,240],forestgreen:[34,139,34],fuchsia:[255,0,255],gainsboro:[220,220,220],ghostwhite:[248,248,255],gold:[255,215,0],goldenrod:[218,165,32],gray:[128,128,128],green:[0,128,0],greenyellow:[173,255,47],grey:[128,128,128],honeydew:[240,255,240],hotpink:[255,105,180],indianred:[205,92,92],indigo:[75,0,130],ivory:[255,255,240],khaki:[240,230,140],lavender:[230,230,250],lavenderblush:[255,240,245],lawngreen:[124,252,0],lemonchiffon:[255,250,205],lightblue:[173,216,230],lightcoral:[240,128,128],lightcyan:[224,255,255],lightgoldenrodyellow:[250,250,210],lightgray:[211,211,211],lightgreen:[144,238,144],lightgrey:[211,211,211],lightpink:[255,182,193],lightsalmon:[255,160,122],lightseagreen:[32,178,170],lightskyblue:[135,206,250],lightslategray:[119,136,153],lightslategrey:[119,136,153],lightsteelblue:[176,196,222],lightyellow:[255,255,224],lime:[0,255,0],limegreen:[50,205,50],linen:[250,240,230],magenta:[255,0,255],maroon:[128,0,0],mediumaquamarine:[102,205,170],mediumblue:[0,0,205],mediumorchid:[186,85,211],mediumpurple:[147,112,219],mediumseagreen:[60,179,113],mediumslateblue:[123,104,238],mediumspringgreen:[0,250,154],mediumturquoise:[72,209,204],mediumvioletred:[199,21,133],midnightblue:[25,25,112],mintcream:[245,255,250],mistyrose:[255,228,225],moccasin:[255,228,181],navajowhite:[255,222,173],navy:[0,0,128],oldlace:[253,245,230],olive:[128,128,0],olivedrab:[107,142,35],orange:[255,165,0],orangered:[255,69,0],orchid:[218,112,214],palegoldenrod:[238,232,170],palegreen:[152,251,152],paleturquoise:[175,238,238],palevioletred:[219,112,147],papayawhip:[255,239,213],peachpuff:[255,218,185],peru:[205,133,63],pink:[255,192,203],plum:[221,160,221],powderblue:[176,224,230],purple:[128,0,128],rebeccapurple:[102,51,153],red:[255,0,0],rosybrown:[188,143,143],royalblue:[65,105,225],saddlebrown:[139,69,19],salmon:[250,128,114],sandybrown:[244,164,96],seagreen:[46,139,87],seashell:[255,245,238],sienna:[160,82,45],silver:[192,192,192],skyblue:[135,206,235],slateblue:[106,90,205],slategray:[112,128,144],slategrey:[112,128,144],snow:[255,250,250],springgreen:[0,255,127],steelblue:[70,130,180],tan:[210,180,140],teal:[0,128,128],thistle:[216,191,216],tomato:[255,99,71],turquoise:[64,224,208],violet:[238,130,238],wheat:[245,222,179],white:[255,255,255],whitesmoke:[245,245,245],yellow:[255,255,0],yellowgreen:[154,205,50]}},{}],122:[function(t,e,r){"use strict";var n=t("color-rgba"),a=t("clamp"),i=t("dtype");e.exports=function(t,e){"float"!==e&&e||(e="array"),"uint"===e&&(e="uint8"),"uint_clamped"===e&&(e="uint8_clamped");var r=new(i(e))(4),o="uint8"!==e&&"uint8_clamped"!==e;return t.length&&"string"!=typeof t||((t=n(t))[0]/=255,t[1]/=255,t[2]/=255),function(t){return t instanceof Uint8Array||t instanceof Uint8ClampedArray||!!(Array.isArray(t)&&(t[0]>1||0===t[0])&&(t[1]>1||0===t[1])&&(t[2]>1||0===t[2])&&(!t[3]||t[3]>1))}(t)?(r[0]=t[0],r[1]=t[1],r[2]=t[2],r[3]=null!=t[3]?t[3]:255,o&&(r[0]/=255,r[1]/=255,r[2]/=255,r[3]/=255),r):(o?(r[0]=t[0],r[1]=t[1],r[2]=t[2],r[3]=null!=t[3]?t[3]:1):(r[0]=a(Math.floor(255*t[0]),0,255),r[1]=a(Math.floor(255*t[1]),0,255),r[2]=a(Math.floor(255*t[2]),0,255),r[3]=null==t[3]?255:a(Math.floor(255*t[3]),0,255)),r)}},{clamp:117,"color-rgba":124,dtype:171}],123:[function(t,e,r){(function(r){"use strict";var n=t("color-name"),a=t("is-plain-obj"),i=t("defined");e.exports=function(t){var e,s,l=[],c=1;if("string"==typeof t)if(n[t])l=n[t].slice(),s="rgb";else if("transparent"===t)c=0,s="rgb",l=[0,0,0];else if(/^#[A-Fa-f0-9]+$/.test(t)){var u=(p=t.slice(1)).length;c=1,u<=4?(l=[parseInt(p[0]+p[0],16),parseInt(p[1]+p[1],16),parseInt(p[2]+p[2],16)],4===u&&(c=parseInt(p[3]+p[3],16)/255)):(l=[parseInt(p[0]+p[1],16),parseInt(p[2]+p[3],16),parseInt(p[4]+p[5],16)],8===u&&(c=parseInt(p[6]+p[7],16)/255)),l[0]||(l[0]=0),l[1]||(l[1]=0),l[2]||(l[2]=0),s="rgb"}else if(e=/^((?:rgb|hs[lvb]|hwb|cmyk?|xy[zy]|gray|lab|lchu?v?|[ly]uv|lms)a?)\s*\(([^\)]*)\)/.exec(t)){var h=e[1],f="rgb"===h,p=h.replace(/a$/,"");s=p;u="cmyk"===p?4:"gray"===p?1:3;l=e[2].trim().split(/\s*,\s*/).map((function(t,e){if(/%$/.test(t))return e===u?parseFloat(t)/100:"rgb"===p?255*parseFloat(t)/100:parseFloat(t);if("h"===p[e]){if(/deg$/.test(t))return parseFloat(t);if(void 0!==o[t])return o[t]}return parseFloat(t)})),h===p&&l.push(1),c=f||void 0===l[u]?1:l[u],l=l.slice(0,u)}else t.length>10&&/[0-9](?:\s|\/)/.test(t)&&(l=t.match(/([0-9]+)/g).map((function(t){return parseFloat(t)})),s=t.match(/([a-z])/gi).join("").toLowerCase());else if(isNaN(t))if(a(t)){var d=i(t.r,t.red,t.R,null);null!==d?(s="rgb",l=[d,i(t.g,t.green,t.G),i(t.b,t.blue,t.B)]):(s="hsl",l=[i(t.h,t.hue,t.H),i(t.s,t.saturation,t.S),i(t.l,t.lightness,t.L,t.b,t.brightness)]),c=i(t.a,t.alpha,t.opacity,1),null!=t.opacity&&(c/=100)}else(Array.isArray(t)||r.ArrayBuffer&&ArrayBuffer.isView&&ArrayBuffer.isView(t))&&(l=[t[0],t[1],t[2]],s="rgb",c=4===t.length?t[3]:1);else s="rgb",l=[t>>>16,(65280&t)>>>8,255&t];return{space:s,values:l,alpha:c}};var o={red:0,orange:60,yellow:120,green:180,blue:240,purple:300}}).call(this,"undefined"!=typeof global?global:"undefined"!=typeof self?self:"undefined"!=typeof window?window:{})},{"color-name":121,defined:166,"is-plain-obj":426}],124:[function(t,e,r){"use strict";var n=t("color-parse"),a=t("color-space/hsl"),i=t("clamp");e.exports=function(t){var e,r=n(t);return r.space?((e=Array(3))[0]=i(r.values[0],0,255),e[1]=i(r.values[1],0,255),e[2]=i(r.values[2],0,255),"h"===r.space[0]&&(e=a.rgb(e)),e.push(i(r.alpha,0,1)),e):[]}},{clamp:117,"color-parse":123,"color-space/hsl":125}],125:[function(t,e,r){"use strict";var n=t("./rgb");e.exports={name:"hsl",min:[0,0,0],max:[360,100,100],channel:["hue","saturation","lightness"],alias:["HSL"],rgb:function(t){var e,r,n,a,i,o=t[0]/360,s=t[1]/100,l=t[2]/100;if(0===s)return[i=255*l,i,i];e=2*l-(r=l<.5?l*(1+s):l+s-l*s),a=[0,0,0];for(var c=0;c<3;c++)(n=o+1/3*-(c-1))<0?n++:n>1&&n--,i=6*n<1?e+6*(r-e)*n:2*n<1?r:3*n<2?e+(r-e)*(2/3-n)*6:e,a[c]=255*i;return a}},n.hsl=function(t){var e,r,n=t[0]/255,a=t[1]/255,i=t[2]/255,o=Math.min(n,a,i),s=Math.max(n,a,i),l=s-o;return s===o?e=0:n===s?e=(a-i)/l:a===s?e=2+(i-n)/l:i===s&&(e=4+(n-a)/l),(e=Math.min(60*e,360))<0&&(e+=360),r=(o+s)/2,[e,100*(s===o?0:r<=.5?l/(s+o):l/(2-s-o)),100*r]}},{"./rgb":126}],126:[function(t,e,r){"use strict";e.exports={name:"rgb",min:[0,0,0],max:[255,255,255],channel:["red","green","blue"],alias:["RGB"]}},{}],127:[function(t,e,r){e.exports={jet:[{index:0,rgb:[0,0,131]},{index:.125,rgb:[0,60,170]},{index:.375,rgb:[5,255,255]},{index:.625,rgb:[255,255,0]},{index:.875,rgb:[250,0,0]},{index:1,rgb:[128,0,0]}],hsv:[{index:0,rgb:[255,0,0]},{index:.169,rgb:[253,255,2]},{index:.173,rgb:[247,255,2]},{index:.337,rgb:[0,252,4]},{index:.341,rgb:[0,252,10]},{index:.506,rgb:[1,249,255]},{index:.671,rgb:[2,0,253]},{index:.675,rgb:[8,0,253]},{index:.839,rgb:[255,0,251]},{index:.843,rgb:[255,0,245]},{index:1,rgb:[255,0,6]}],hot:[{index:0,rgb:[0,0,0]},{index:.3,rgb:[230,0,0]},{index:.6,rgb:[255,210,0]},{index:1,rgb:[255,255,255]}],cool:[{index:0,rgb:[0,255,255]},{index:1,rgb:[255,0,255]}],spring:[{index:0,rgb:[255,0,255]},{index:1,rgb:[255,255,0]}],summer:[{index:0,rgb:[0,128,102]},{index:1,rgb:[255,255,102]}],autumn:[{index:0,rgb:[255,0,0]},{index:1,rgb:[255,255,0]}],winter:[{index:0,rgb:[0,0,255]},{index:1,rgb:[0,255,128]}],bone:[{index:0,rgb:[0,0,0]},{index:.376,rgb:[84,84,116]},{index:.753,rgb:[169,200,200]},{index:1,rgb:[255,255,255]}],copper:[{index:0,rgb:[0,0,0]},{index:.804,rgb:[255,160,102]},{index:1,rgb:[255,199,127]}],greys:[{index:0,rgb:[0,0,0]},{index:1,rgb:[255,255,255]}],yignbu:[{index:0,rgb:[8,29,88]},{index:.125,rgb:[37,52,148]},{index:.25,rgb:[34,94,168]},{index:.375,rgb:[29,145,192]},{index:.5,rgb:[65,182,196]},{index:.625,rgb:[127,205,187]},{index:.75,rgb:[199,233,180]},{index:.875,rgb:[237,248,217]},{index:1,rgb:[255,255,217]}],greens:[{index:0,rgb:[0,68,27]},{index:.125,rgb:[0,109,44]},{index:.25,rgb:[35,139,69]},{index:.375,rgb:[65,171,93]},{index:.5,rgb:[116,196,118]},{index:.625,rgb:[161,217,155]},{index:.75,rgb:[199,233,192]},{index:.875,rgb:[229,245,224]},{index:1,rgb:[247,252,245]}],yiorrd:[{index:0,rgb:[128,0,38]},{index:.125,rgb:[189,0,38]},{index:.25,rgb:[227,26,28]},{index:.375,rgb:[252,78,42]},{index:.5,rgb:[253,141,60]},{index:.625,rgb:[254,178,76]},{index:.75,rgb:[254,217,118]},{index:.875,rgb:[255,237,160]},{index:1,rgb:[255,255,204]}],bluered:[{index:0,rgb:[0,0,255]},{index:1,rgb:[255,0,0]}],rdbu:[{index:0,rgb:[5,10,172]},{index:.35,rgb:[106,137,247]},{index:.5,rgb:[190,190,190]},{index:.6,rgb:[220,170,132]},{index:.7,rgb:[230,145,90]},{index:1,rgb:[178,10,28]}],picnic:[{index:0,rgb:[0,0,255]},{index:.1,rgb:[51,153,255]},{index:.2,rgb:[102,204,255]},{index:.3,rgb:[153,204,255]},{index:.4,rgb:[204,204,255]},{index:.5,rgb:[255,255,255]},{index:.6,rgb:[255,204,255]},{index:.7,rgb:[255,153,255]},{index:.8,rgb:[255,102,204]},{index:.9,rgb:[255,102,102]},{index:1,rgb:[255,0,0]}],rainbow:[{index:0,rgb:[150,0,90]},{index:.125,rgb:[0,0,200]},{index:.25,rgb:[0,25,255]},{index:.375,rgb:[0,152,255]},{index:.5,rgb:[44,255,150]},{index:.625,rgb:[151,255,0]},{index:.75,rgb:[255,234,0]},{index:.875,rgb:[255,111,0]},{index:1,rgb:[255,0,0]}],portland:[{index:0,rgb:[12,51,131]},{index:.25,rgb:[10,136,186]},{index:.5,rgb:[242,211,56]},{index:.75,rgb:[242,143,56]},{index:1,rgb:[217,30,30]}],blackbody:[{index:0,rgb:[0,0,0]},{index:.2,rgb:[230,0,0]},{index:.4,rgb:[230,210,0]},{index:.7,rgb:[255,255,255]},{index:1,rgb:[160,200,255]}],earth:[{index:0,rgb:[0,0,130]},{index:.1,rgb:[0,180,180]},{index:.2,rgb:[40,210,40]},{index:.4,rgb:[230,230,50]},{index:.6,rgb:[120,70,20]},{index:1,rgb:[255,255,255]}],electric:[{index:0,rgb:[0,0,0]},{index:.15,rgb:[30,0,100]},{index:.4,rgb:[120,0,100]},{index:.6,rgb:[160,90,0]},{index:.8,rgb:[230,200,0]},{index:1,rgb:[255,250,220]}],alpha:[{index:0,rgb:[255,255,255,0]},{index:1,rgb:[255,255,255,1]}],viridis:[{index:0,rgb:[68,1,84]},{index:.13,rgb:[71,44,122]},{index:.25,rgb:[59,81,139]},{index:.38,rgb:[44,113,142]},{index:.5,rgb:[33,144,141]},{index:.63,rgb:[39,173,129]},{index:.75,rgb:[92,200,99]},{index:.88,rgb:[170,220,50]},{index:1,rgb:[253,231,37]}],inferno:[{index:0,rgb:[0,0,4]},{index:.13,rgb:[31,12,72]},{index:.25,rgb:[85,15,109]},{index:.38,rgb:[136,34,106]},{index:.5,rgb:[186,54,85]},{index:.63,rgb:[227,89,51]},{index:.75,rgb:[249,140,10]},{index:.88,rgb:[249,201,50]},{index:1,rgb:[252,255,164]}],magma:[{index:0,rgb:[0,0,4]},{index:.13,rgb:[28,16,68]},{index:.25,rgb:[79,18,123]},{index:.38,rgb:[129,37,129]},{index:.5,rgb:[181,54,122]},{index:.63,rgb:[229,80,100]},{index:.75,rgb:[251,135,97]},{index:.88,rgb:[254,194,135]},{index:1,rgb:[252,253,191]}],plasma:[{index:0,rgb:[13,8,135]},{index:.13,rgb:[75,3,161]},{index:.25,rgb:[125,3,168]},{index:.38,rgb:[168,34,150]},{index:.5,rgb:[203,70,121]},{index:.63,rgb:[229,107,93]},{index:.75,rgb:[248,148,65]},{index:.88,rgb:[253,195,40]},{index:1,rgb:[240,249,33]}],warm:[{index:0,rgb:[125,0,179]},{index:.13,rgb:[172,0,187]},{index:.25,rgb:[219,0,170]},{index:.38,rgb:[255,0,130]},{index:.5,rgb:[255,63,74]},{index:.63,rgb:[255,123,0]},{index:.75,rgb:[234,176,0]},{index:.88,rgb:[190,228,0]},{index:1,rgb:[147,255,0]}],cool:[{index:0,rgb:[125,0,179]},{index:.13,rgb:[116,0,218]},{index:.25,rgb:[98,74,237]},{index:.38,rgb:[68,146,231]},{index:.5,rgb:[0,204,197]},{index:.63,rgb:[0,247,146]},{index:.75,rgb:[0,255,88]},{index:.88,rgb:[40,255,8]},{index:1,rgb:[147,255,0]}],"rainbow-soft":[{index:0,rgb:[125,0,179]},{index:.1,rgb:[199,0,180]},{index:.2,rgb:[255,0,121]},{index:.3,rgb:[255,108,0]},{index:.4,rgb:[222,194,0]},{index:.5,rgb:[150,255,0]},{index:.6,rgb:[0,255,55]},{index:.7,rgb:[0,246,150]},{index:.8,rgb:[50,167,222]},{index:.9,rgb:[103,51,235]},{index:1,rgb:[124,0,186]}],bathymetry:[{index:0,rgb:[40,26,44]},{index:.13,rgb:[59,49,90]},{index:.25,rgb:[64,76,139]},{index:.38,rgb:[63,110,151]},{index:.5,rgb:[72,142,158]},{index:.63,rgb:[85,174,163]},{index:.75,rgb:[120,206,163]},{index:.88,rgb:[187,230,172]},{index:1,rgb:[253,254,204]}],cdom:[{index:0,rgb:[47,15,62]},{index:.13,rgb:[87,23,86]},{index:.25,rgb:[130,28,99]},{index:.38,rgb:[171,41,96]},{index:.5,rgb:[206,67,86]},{index:.63,rgb:[230,106,84]},{index:.75,rgb:[242,149,103]},{index:.88,rgb:[249,193,135]},{index:1,rgb:[254,237,176]}],chlorophyll:[{index:0,rgb:[18,36,20]},{index:.13,rgb:[25,63,41]},{index:.25,rgb:[24,91,59]},{index:.38,rgb:[13,119,72]},{index:.5,rgb:[18,148,80]},{index:.63,rgb:[80,173,89]},{index:.75,rgb:[132,196,122]},{index:.88,rgb:[175,221,162]},{index:1,rgb:[215,249,208]}],density:[{index:0,rgb:[54,14,36]},{index:.13,rgb:[89,23,80]},{index:.25,rgb:[110,45,132]},{index:.38,rgb:[120,77,178]},{index:.5,rgb:[120,113,213]},{index:.63,rgb:[115,151,228]},{index:.75,rgb:[134,185,227]},{index:.88,rgb:[177,214,227]},{index:1,rgb:[230,241,241]}],"freesurface-blue":[{index:0,rgb:[30,4,110]},{index:.13,rgb:[47,14,176]},{index:.25,rgb:[41,45,236]},{index:.38,rgb:[25,99,212]},{index:.5,rgb:[68,131,200]},{index:.63,rgb:[114,156,197]},{index:.75,rgb:[157,181,203]},{index:.88,rgb:[200,208,216]},{index:1,rgb:[241,237,236]}],"freesurface-red":[{index:0,rgb:[60,9,18]},{index:.13,rgb:[100,17,27]},{index:.25,rgb:[142,20,29]},{index:.38,rgb:[177,43,27]},{index:.5,rgb:[192,87,63]},{index:.63,rgb:[205,125,105]},{index:.75,rgb:[216,162,148]},{index:.88,rgb:[227,199,193]},{index:1,rgb:[241,237,236]}],oxygen:[{index:0,rgb:[64,5,5]},{index:.13,rgb:[106,6,15]},{index:.25,rgb:[144,26,7]},{index:.38,rgb:[168,64,3]},{index:.5,rgb:[188,100,4]},{index:.63,rgb:[206,136,11]},{index:.75,rgb:[220,174,25]},{index:.88,rgb:[231,215,44]},{index:1,rgb:[248,254,105]}],par:[{index:0,rgb:[51,20,24]},{index:.13,rgb:[90,32,35]},{index:.25,rgb:[129,44,34]},{index:.38,rgb:[159,68,25]},{index:.5,rgb:[182,99,19]},{index:.63,rgb:[199,134,22]},{index:.75,rgb:[212,171,35]},{index:.88,rgb:[221,210,54]},{index:1,rgb:[225,253,75]}],phase:[{index:0,rgb:[145,105,18]},{index:.13,rgb:[184,71,38]},{index:.25,rgb:[186,58,115]},{index:.38,rgb:[160,71,185]},{index:.5,rgb:[110,97,218]},{index:.63,rgb:[50,123,164]},{index:.75,rgb:[31,131,110]},{index:.88,rgb:[77,129,34]},{index:1,rgb:[145,105,18]}],salinity:[{index:0,rgb:[42,24,108]},{index:.13,rgb:[33,50,162]},{index:.25,rgb:[15,90,145]},{index:.38,rgb:[40,118,137]},{index:.5,rgb:[59,146,135]},{index:.63,rgb:[79,175,126]},{index:.75,rgb:[120,203,104]},{index:.88,rgb:[193,221,100]},{index:1,rgb:[253,239,154]}],temperature:[{index:0,rgb:[4,35,51]},{index:.13,rgb:[23,51,122]},{index:.25,rgb:[85,59,157]},{index:.38,rgb:[129,79,143]},{index:.5,rgb:[175,95,130]},{index:.63,rgb:[222,112,101]},{index:.75,rgb:[249,146,66]},{index:.88,rgb:[249,196,65]},{index:1,rgb:[232,250,91]}],turbidity:[{index:0,rgb:[34,31,27]},{index:.13,rgb:[65,50,41]},{index:.25,rgb:[98,69,52]},{index:.38,rgb:[131,89,57]},{index:.5,rgb:[161,112,59]},{index:.63,rgb:[185,140,66]},{index:.75,rgb:[202,174,88]},{index:.88,rgb:[216,209,126]},{index:1,rgb:[233,246,171]}],"velocity-blue":[{index:0,rgb:[17,32,64]},{index:.13,rgb:[35,52,116]},{index:.25,rgb:[29,81,156]},{index:.38,rgb:[31,113,162]},{index:.5,rgb:[50,144,169]},{index:.63,rgb:[87,173,176]},{index:.75,rgb:[149,196,189]},{index:.88,rgb:[203,221,211]},{index:1,rgb:[254,251,230]}],"velocity-green":[{index:0,rgb:[23,35,19]},{index:.13,rgb:[24,64,38]},{index:.25,rgb:[11,95,45]},{index:.38,rgb:[39,123,35]},{index:.5,rgb:[95,146,12]},{index:.63,rgb:[152,165,18]},{index:.75,rgb:[201,186,69]},{index:.88,rgb:[233,216,137]},{index:1,rgb:[255,253,205]}],cubehelix:[{index:0,rgb:[0,0,0]},{index:.07,rgb:[22,5,59]},{index:.13,rgb:[60,4,105]},{index:.2,rgb:[109,1,135]},{index:.27,rgb:[161,0,147]},{index:.33,rgb:[210,2,142]},{index:.4,rgb:[251,11,123]},{index:.47,rgb:[255,29,97]},{index:.53,rgb:[255,54,69]},{index:.6,rgb:[255,85,46]},{index:.67,rgb:[255,120,34]},{index:.73,rgb:[255,157,37]},{index:.8,rgb:[241,191,57]},{index:.87,rgb:[224,220,93]},{index:.93,rgb:[218,241,142]},{index:1,rgb:[227,253,198]}]}},{}],128:[function(t,e,r){"use strict";var n=t("./colorScale"),a=t("lerp");function i(t){return[t[0]/255,t[1]/255,t[2]/255,t[3]]}function o(t){for(var e,r="#",n=0;n<3;++n)r+=("00"+(e=(e=t[n]).toString(16))).substr(e.length);return r}function s(t){return"rgba("+t.join(",")+")"}e.exports=function(t){var e,r,l,c,u,h,f,p,d,g;t||(t={});p=(t.nshades||72)-1,f=t.format||"hex",(h=t.colormap)||(h="jet");if("string"==typeof h){if(h=h.toLowerCase(),!n[h])throw Error(h+" not a supported colorscale");u=n[h]}else{if(!Array.isArray(h))throw Error("unsupported colormap option",h);u=h.slice()}if(u.length>p+1)throw new Error(h+" map requires nshades to be at least size "+u.length);d=Array.isArray(t.alpha)?2!==t.alpha.length?[1,1]:t.alpha.slice():"number"==typeof t.alpha?[t.alpha,t.alpha]:[1,1];e=u.map((function(t){return Math.round(t.index*p)})),d[0]=Math.min(Math.max(d[0],0),1),d[1]=Math.min(Math.max(d[1],0),1);var m=u.map((function(t,e){var r=u[e].index,n=u[e].rgb.slice();return 4===n.length&&n[3]>=0&&n[3]<=1||(n[3]=d[0]+(d[1]-d[0])*r),n})),v=[];for(g=0;g<e.length-1;++g){c=e[g+1]-e[g],r=m[g],l=m[g+1];for(var y=0;y<c;y++){var x=y/c;v.push([Math.round(a(r[0],l[0],x)),Math.round(a(r[1],l[1],x)),Math.round(a(r[2],l[2],x)),a(r[3],l[3],x)])}}v.push(u[u.length-1].rgb.concat(d[1])),"hex"===f?v=v.map(o):"rgbaString"===f?v=v.map(s):"float"===f&&(v=v.map(i));return v}},{"./colorScale":127,lerp:429}],129:[function(t,e,r){"use strict";e.exports=function(t,e,r,i){var o=n(e,r,i);if(0===o){var s=a(n(t,e,r)),c=a(n(t,e,i));if(s===c){if(0===s){var u=l(t,e,r),h=l(t,e,i);return u===h?0:u?1:-1}return 0}return 0===c?s>0||l(t,e,i)?-1:1:0===s?c>0||l(t,e,r)?1:-1:a(c-s)}var f=n(t,e,r);return f>0?o>0&&n(t,e,i)>0?1:-1:f<0?o>0||n(t,e,i)>0?1:-1:n(t,e,i)>0||l(t,e,r)?1:-1};var n=t("robust-orientation"),a=t("signum"),i=t("two-sum"),o=t("robust-product"),s=t("robust-sum");function l(t,e,r){var n=i(t[0],-e[0]),a=i(t[1],-e[1]),l=i(r[0],-e[0]),c=i(r[1],-e[1]),u=s(o(n,l),o(a,c));return u[u.length-1]>=0}},{"robust-orientation":507,"robust-product":508,"robust-sum":512,signum:513,"two-sum":542}],130:[function(t,e,r){e.exports=function(t,e){var r=t.length,i=t.length-e.length;if(i)return i;switch(r){case 0:return 0;case 1:return t[0]-e[0];case 2:return t[0]+t[1]-e[0]-e[1]||n(t[0],t[1])-n(e[0],e[1]);case 3:var o=t[0]+t[1],s=e[0]+e[1];if(i=o+t[2]-(s+e[2]))return i;var l=n(t[0],t[1]),c=n(e[0],e[1]);return n(l,t[2])-n(c,e[2])||n(l+t[2],o)-n(c+e[2],s);case 4:var u=t[0],h=t[1],f=t[2],p=t[3],d=e[0],g=e[1],m=e[2],v=e[3];return u+h+f+p-(d+g+m+v)||n(u,h,f,p)-n(d,g,m,v,d)||n(u+h,u+f,u+p,h+f,h+p,f+p)-n(d+g,d+m,d+v,g+m,g+v,m+v)||n(u+h+f,u+h+p,u+f+p,h+f+p)-n(d+g+m,d+g+v,d+m+v,g+m+v);default:for(var y=t.slice().sort(a),x=e.slice().sort(a),b=0;b<r;++b)if(i=y[b]-x[b])return i;return 0}};var n=Math.min;function a(t,e){return t-e}},{}],131:[function(t,e,r){"use strict";var n=t("compare-cell"),a=t("cell-orientation");e.exports=function(t,e){return n(t,e)||a(t)-a(e)}},{"cell-orientation":114,"compare-cell":130}],132:[function(t,e,r){"use strict";var n=t("./lib/ch1d"),a=t("./lib/ch2d"),i=t("./lib/chnd");e.exports=function(t){var e=t.length;if(0===e)return[];if(1===e)return[[0]];var r=t[0].length;if(0===r)return[];if(1===r)return n(t);if(2===r)return a(t);return i(t,r)}},{"./lib/ch1d":133,"./lib/ch2d":134,"./lib/chnd":135}],133:[function(t,e,r){"use strict";e.exports=function(t){for(var e=0,r=0,n=1;n<t.length;++n)t[n][0]<t[e][0]&&(e=n),t[n][0]>t[r][0]&&(r=n);return e<r?[[e],[r]]:e>r?[[r],[e]]:[[e]]}},{}],134:[function(t,e,r){"use strict";e.exports=function(t){var e=n(t),r=e.length;if(r<=2)return[];for(var a=new Array(r),i=e[r-1],o=0;o<r;++o){var s=e[o];a[o]=[i,s],i=s}return a};var n=t("monotone-convex-hull-2d")},{"monotone-convex-hull-2d":439}],135:[function(t,e,r){"use strict";e.exports=function(t,e){try{return n(t,!0)}catch(o){var r=a(t);if(r.length<=e)return[];var i=function(t,e){for(var r=t.length,n=new Array(r),a=0;a<e.length;++a)n[a]=t[e[a]];var i=e.length;for(a=0;a<r;++a)e.indexOf(a)<0&&(n[i++]=t[a]);return n}(t,r);return function(t,e){for(var r=t.length,n=e.length,a=0;a<r;++a)for(var i=t[a],o=0;o<i.length;++o){var s=i[o];if(s<n)i[o]=e[s];else{s-=n;for(var l=0;l<n;++l)s>=e[l]&&(s+=1);i[o]=s}}return t}(n(i,!0),r)}};var n=t("incremental-convex-hull"),a=t("affine-hull")},{"affine-hull":65,"incremental-convex-hull":416}],136:[function(t,e,r){e.exports={AFG:"afghan",ALA:"\\b\\wland",ALB:"albania",DZA:"algeria",ASM:"^(?=.*americ).*samoa",AND:"andorra",AGO:"angola",AIA:"anguill?a",ATA:"antarctica",ATG:"antigua",ARG:"argentin",ARM:"armenia",ABW:"^(?!.*bonaire).*\\baruba",AUS:"australia",AUT:"^(?!.*hungary).*austria|\\baustri.*\\bemp",AZE:"azerbaijan",BHS:"bahamas",BHR:"bahrain",BGD:"bangladesh|^(?=.*east).*paki?stan",BRB:"barbados",BLR:"belarus|byelo",BEL:"^(?!.*luxem).*belgium",BLZ:"belize|^(?=.*british).*honduras",BEN:"benin|dahome",BMU:"bermuda",BTN:"bhutan",BOL:"bolivia",BES:"^(?=.*bonaire).*eustatius|^(?=.*carib).*netherlands|\\bbes.?islands",BIH:"herzegovina|bosnia",BWA:"botswana|bechuana",BVT:"bouvet",BRA:"brazil",IOT:"british.?indian.?ocean",BRN:"brunei",BGR:"bulgaria",BFA:"burkina|\\bfaso|upper.?volta",BDI:"burundi",CPV:"verde",KHM:"cambodia|kampuchea|khmer",CMR:"cameroon",CAN:"canada",CYM:"cayman",CAF:"\\bcentral.african.republic",TCD:"\\bchad",CHL:"\\bchile",CHN:"^(?!.*\\bmac)(?!.*\\bhong)(?!.*\\btai)(?!.*\\brep).*china|^(?=.*peo)(?=.*rep).*china",CXR:"christmas",CCK:"\\bcocos|keeling",COL:"colombia",COM:"comoro",COG:"^(?!.*\\bdem)(?!.*\\bd[\\.]?r)(?!.*kinshasa)(?!.*zaire)(?!.*belg)(?!.*l.opoldville)(?!.*free).*\\bcongo",COK:"\\bcook",CRI:"costa.?rica",CIV:"ivoire|ivory",HRV:"croatia",CUB:"\\bcuba",CUW:"^(?!.*bonaire).*\\bcura(c|\xe7)ao",CYP:"cyprus",CSK:"czechoslovakia",CZE:"^(?=.*rep).*czech|czechia|bohemia",COD:"\\bdem.*congo|congo.*\\bdem|congo.*\\bd[\\.]?r|\\bd[\\.]?r.*congo|belgian.?congo|congo.?free.?state|kinshasa|zaire|l.opoldville|drc|droc|rdc",DNK:"denmark",DJI:"djibouti",DMA:"dominica(?!n)",DOM:"dominican.rep",ECU:"ecuador",EGY:"egypt",SLV:"el.?salvador",GNQ:"guine.*eq|eq.*guine|^(?=.*span).*guinea",ERI:"eritrea",EST:"estonia",ETH:"ethiopia|abyssinia",FLK:"falkland|malvinas",FRO:"faroe|faeroe",FJI:"fiji",FIN:"finland",FRA:"^(?!.*\\bdep)(?!.*martinique).*france|french.?republic|\\bgaul",GUF:"^(?=.*french).*guiana",PYF:"french.?polynesia|tahiti",ATF:"french.?southern",GAB:"gabon",GMB:"gambia",GEO:"^(?!.*south).*georgia",DDR:"german.?democratic.?republic|democratic.?republic.*germany|east.germany",DEU:"^(?!.*east).*germany|^(?=.*\\bfed.*\\brep).*german",GHA:"ghana|gold.?coast",GIB:"gibraltar",GRC:"greece|hellenic|hellas",GRL:"greenland",GRD:"grenada",GLP:"guadeloupe",GUM:"\\bguam",GTM:"guatemala",GGY:"guernsey",GIN:"^(?!.*eq)(?!.*span)(?!.*bissau)(?!.*portu)(?!.*new).*guinea",GNB:"bissau|^(?=.*portu).*guinea",GUY:"guyana|british.?guiana",HTI:"haiti",HMD:"heard.*mcdonald",VAT:"holy.?see|vatican|papal.?st",HND:"^(?!.*brit).*honduras",HKG:"hong.?kong",HUN:"^(?!.*austr).*hungary",ISL:"iceland",IND:"india(?!.*ocea)",IDN:"indonesia",IRN:"\\biran|persia",IRQ:"\\biraq|mesopotamia",IRL:"(^ireland)|(^republic.*ireland)",IMN:"^(?=.*isle).*\\bman",ISR:"israel",ITA:"italy",JAM:"jamaica",JPN:"japan",JEY:"jersey",JOR:"jordan",KAZ:"kazak",KEN:"kenya|british.?east.?africa|east.?africa.?prot",KIR:"kiribati",PRK:"^(?=.*democrat|people|north|d.*p.*.r).*\\bkorea|dprk|korea.*(d.*p.*r)",KWT:"kuwait",KGZ:"kyrgyz|kirghiz",LAO:"\\blaos?\\b",LVA:"latvia",LBN:"lebanon",LSO:"lesotho|basuto",LBR:"liberia",LBY:"libya",LIE:"liechtenstein",LTU:"lithuania",LUX:"^(?!.*belg).*luxem",MAC:"maca(o|u)",MDG:"madagascar|malagasy",MWI:"malawi|nyasa",MYS:"malaysia",MDV:"maldive",MLI:"\\bmali\\b",MLT:"\\bmalta",MHL:"marshall",MTQ:"martinique",MRT:"mauritania",MUS:"mauritius",MYT:"\\bmayotte",MEX:"\\bmexic",FSM:"fed.*micronesia|micronesia.*fed",MCO:"monaco",MNG:"mongolia",MNE:"^(?!.*serbia).*montenegro",MSR:"montserrat",MAR:"morocco|\\bmaroc",MOZ:"mozambique",MMR:"myanmar|burma",NAM:"namibia",NRU:"nauru",NPL:"nepal",NLD:"^(?!.*\\bant)(?!.*\\bcarib).*netherlands",ANT:"^(?=.*\\bant).*(nether|dutch)",NCL:"new.?caledonia",NZL:"new.?zealand",NIC:"nicaragua",NER:"\\bniger(?!ia)",NGA:"nigeria",NIU:"niue",NFK:"norfolk",MNP:"mariana",NOR:"norway",OMN:"\\boman|trucial",PAK:"^(?!.*east).*paki?stan",PLW:"palau",PSE:"palestin|\\bgaza|west.?bank",PAN:"panama",PNG:"papua|new.?guinea",PRY:"paraguay",PER:"peru",PHL:"philippines",PCN:"pitcairn",POL:"poland",PRT:"portugal",PRI:"puerto.?rico",QAT:"qatar",KOR:"^(?!.*d.*p.*r)(?!.*democrat)(?!.*people)(?!.*north).*\\bkorea(?!.*d.*p.*r)",MDA:"moldov|b(a|e)ssarabia",REU:"r(e|\xe9)union",ROU:"r(o|u|ou)mania",RUS:"\\brussia|soviet.?union|u\\.?s\\.?s\\.?r|socialist.?republics",RWA:"rwanda",BLM:"barth(e|\xe9)lemy",SHN:"helena",KNA:"kitts|\\bnevis",LCA:"\\blucia",MAF:"^(?=.*collectivity).*martin|^(?=.*france).*martin(?!ique)|^(?=.*french).*martin(?!ique)",SPM:"miquelon",VCT:"vincent",WSM:"^(?!.*amer).*samoa",SMR:"san.?marino",STP:"\\bs(a|\xe3)o.?tom(e|\xe9)",SAU:"\\bsa\\w*.?arabia",SEN:"senegal",SRB:"^(?!.*monte).*serbia",SYC:"seychell",SLE:"sierra",SGP:"singapore",SXM:"^(?!.*martin)(?!.*saba).*maarten",SVK:"^(?!.*cze).*slovak",SVN:"slovenia",SLB:"solomon",SOM:"somali",ZAF:"south.africa|s\\\\..?africa",SGS:"south.?georgia|sandwich",SSD:"\\bs\\w*.?sudan",ESP:"spain",LKA:"sri.?lanka|ceylon",SDN:"^(?!.*\\bs(?!u)).*sudan",SUR:"surinam|dutch.?guiana",SJM:"svalbard",SWZ:"swaziland",SWE:"sweden",CHE:"switz|swiss",SYR:"syria",TWN:"taiwan|taipei|formosa|^(?!.*peo)(?=.*rep).*china",TJK:"tajik",THA:"thailand|\\bsiam",MKD:"macedonia|fyrom",TLS:"^(?=.*leste).*timor|^(?=.*east).*timor",TGO:"togo",TKL:"tokelau",TON:"tonga",TTO:"trinidad|tobago",TUN:"tunisia",TUR:"turkey",TKM:"turkmen",TCA:"turks",TUV:"tuvalu",UGA:"uganda",UKR:"ukrain",ARE:"emirates|^u\\.?a\\.?e\\.?$|united.?arab.?em",GBR:"united.?kingdom|britain|^u\\.?k\\.?$",TZA:"tanzania",USA:"united.?states\\b(?!.*islands)|\\bu\\.?s\\.?a\\.?\\b|^\\s*u\\.?s\\.?\\b(?!.*islands)",UMI:"minor.?outlying.?is",URY:"uruguay",UZB:"uzbek",VUT:"vanuatu|new.?hebrides",VEN:"venezuela",VNM:"^(?!.*republic).*viet.?nam|^(?=.*socialist).*viet.?nam",VGB:"^(?=.*\\bu\\.?\\s?k).*virgin|^(?=.*brit).*virgin|^(?=.*kingdom).*virgin",VIR:"^(?=.*\\bu\\.?\\s?s).*virgin|^(?=.*states).*virgin",WLF:"futuna|wallis",ESH:"western.sahara",YEM:"^(?!.*arab)(?!.*north)(?!.*sana)(?!.*peo)(?!.*dem)(?!.*south)(?!.*aden)(?!.*\\bp\\.?d\\.?r).*yemen",YMD:"^(?=.*peo).*yemen|^(?!.*rep)(?=.*dem).*yemen|^(?=.*south).*yemen|^(?=.*aden).*yemen|^(?=.*\\bp\\.?d\\.?r).*yemen",YUG:"yugoslavia",ZMB:"zambia|northern.?rhodesia",EAZ:"zanzibar",ZWE:"zimbabwe|^(?!.*northern).*rhodesia"}},{}],137:[function(t,e,r){e.exports=["xx-small","x-small","small","medium","large","x-large","xx-large","larger","smaller"]},{}],138:[function(t,e,r){e.exports=["normal","condensed","semi-condensed","extra-condensed","ultra-condensed","expanded","semi-expanded","extra-expanded","ultra-expanded"]},{}],139:[function(t,e,r){e.exports=["normal","italic","oblique"]},{}],140:[function(t,e,r){e.exports=["normal","bold","bolder","lighter","100","200","300","400","500","600","700","800","900"]},{}],141:[function(t,e,r){"use strict";e.exports={parse:t("./parse"),stringify:t("./stringify")}},{"./parse":143,"./stringify":144}],142:[function(t,e,r){"use strict";var n=t("css-font-size-keywords");e.exports={isSize:function(t){return/^[\d\.]/.test(t)||-1!==t.indexOf("/")||-1!==n.indexOf(t)}}},{"css-font-size-keywords":137}],143:[function(t,e,r){"use strict";var n=t("unquote"),a=t("css-global-keywords"),i=t("css-system-font-keywords"),o=t("css-font-weight-keywords"),s=t("css-font-style-keywords"),l=t("css-font-stretch-keywords"),c=t("string-split-by"),u=t("./lib/util").isSize;e.exports=f;var h=f.cache={};function f(t){if("string"!=typeof t)throw new Error("Font argument must be a string.");if(h[t])return h[t];if(""===t)throw new Error("Cannot parse an empty string.");if(-1!==i.indexOf(t))return h[t]={system:t};for(var e,r={style:"normal",variant:"normal",weight:"normal",stretch:"normal",lineHeight:"normal",size:"1rem",family:["serif"]},f=c(t,/\s+/);e=f.shift();){if(-1!==a.indexOf(e))return["style","variant","weight","stretch"].forEach((function(t){r[t]=e})),h[t]=r;if(-1===s.indexOf(e))if("normal"!==e&&"small-caps"!==e)if(-1===l.indexOf(e)){if(-1===o.indexOf(e)){if(u(e)){var d=c(e,"/");if(r.size=d[0],null!=d[1]?r.lineHeight=p(d[1]):"/"===f[0]&&(f.shift(),r.lineHeight=p(f.shift())),!f.length)throw new Error("Missing required font-family.");return r.family=c(f.join(" "),/\s*,\s*/).map(n),h[t]=r}throw new Error("Unknown or unsupported font token: "+e)}r.weight=e}else r.stretch=e;else r.variant=e;else r.style=e}throw new Error("Missing required font-size.")}function p(t){var e=parseFloat(t);return e.toString()===t?e:t}},{"./lib/util":142,"css-font-stretch-keywords":138,"css-font-style-keywords":139,"css-font-weight-keywords":140,"css-global-keywords":145,"css-system-font-keywords":146,"string-split-by":527,unquote:557}],144:[function(t,e,r){"use strict";var n=t("pick-by-alias"),a=t("./lib/util").isSize,i=g(t("css-global-keywords")),o=g(t("css-system-font-keywords")),s=g(t("css-font-weight-keywords")),l=g(t("css-font-style-keywords")),c=g(t("css-font-stretch-keywords")),u={normal:1,"small-caps":1},h={serif:1,"sans-serif":1,monospace:1,cursive:1,fantasy:1,"system-ui":1},f="1rem",p="serif";function d(t,e){if(t&&!e[t]&&!i[t])throw Error("Unknown keyword `"+t+"`");return t}function g(t){for(var e={},r=0;r<t.length;r++)e[t[r]]=1;return e}e.exports=function(t){if((t=n(t,{style:"style fontstyle fontStyle font-style slope distinction",variant:"variant font-variant fontVariant fontvariant var capitalization",weight:"weight w font-weight fontWeight fontweight",stretch:"stretch font-stretch fontStretch fontstretch width",size:"size s font-size fontSize fontsize height em emSize",lineHeight:"lh line-height lineHeight lineheight leading",family:"font family fontFamily font-family fontfamily type typeface face",system:"system reserved default global"})).system)return t.system&&d(t.system,o),t.system;if(d(t.style,l),d(t.variant,u),d(t.weight,s),d(t.stretch,c),null==t.size&&(t.size=f),"number"==typeof t.size&&(t.size+="px"),!a)throw Error("Bad size value `"+t.size+"`");t.family||(t.family=p),Array.isArray(t.family)&&(t.family.length||(t.family=[p]),t.family=t.family.map((function(t){return h[t]?t:'"'+t+'"'})).join(", "));var e=[];return e.push(t.style),t.variant!==t.style&&e.push(t.variant),t.weight!==t.variant&&t.weight!==t.style&&e.push(t.weight),t.stretch!==t.weight&&t.stretch!==t.variant&&t.stretch!==t.style&&e.push(t.stretch),e.push(t.size+(null==t.lineHeight||"normal"===t.lineHeight||t.lineHeight+""=="1"?"":"/"+t.lineHeight)),e.push(t.family),e.filter(Boolean).join(" ")}},{"./lib/util":142,"css-font-stretch-keywords":138,"css-font-style-keywords":139,"css-font-weight-keywords":140,"css-global-keywords":145,"css-system-font-keywords":146,"pick-by-alias":470}],145:[function(t,e,r){e.exports=["inherit","initial","unset"]},{}],146:[function(t,e,r){e.exports=["caption","icon","menu","message-box","small-caption","status-bar"]},{}],147:[function(t,e,r){"use strict";e.exports=function(t,e,r,n,a,i){var o=a-1,s=a*a,l=o*o,c=(1+2*a)*l,u=a*l,h=s*(3-2*a),f=s*o;if(t.length){i||(i=new Array(t.length));for(var p=t.length-1;p>=0;--p)i[p]=c*t[p]+u*e[p]+h*r[p]+f*n[p];return i}return c*t+u*e+h*r+f*n},e.exports.derivative=function(t,e,r,n,a,i){var o=6*a*a-6*a,s=3*a*a-4*a+1,l=-6*a*a+6*a,c=3*a*a-2*a;if(t.length){i||(i=new Array(t.length));for(var u=t.length-1;u>=0;--u)i[u]=o*t[u]+s*e[u]+l*r[u]+c*n[u];return i}return o*t+s*e+l*r[u]+c*n}},{}],148:[function(t,e,r){"use strict";var n=t("./lib/thunk.js");function a(){this.argTypes=[],this.shimArgs=[],this.arrayArgs=[],this.arrayBlockIndices=[],this.scalarArgs=[],this.offsetArgs=[],this.offsetArgIndex=[],this.indexArgs=[],this.shapeArgs=[],this.funcName="",this.pre=null,this.body=null,this.post=null,this.debug=!1}e.exports=function(t){var e=new a;e.pre=t.pre,e.body=t.body,e.post=t.post;var r=t.args.slice(0);e.argTypes=r;for(var i=0;i<r.length;++i){var o=r[i];if("array"===o||"object"==typeof o&&o.blockIndices){if(e.argTypes[i]="array",e.arrayArgs.push(i),e.arrayBlockIndices.push(o.blockIndices?o.blockIndices:0),e.shimArgs.push("array"+i),i<e.pre.args.length&&e.pre.args[i].count>0)throw new Error("cwise: pre() block may not reference array args");if(i<e.post.args.length&&e.post.args[i].count>0)throw new Error("cwise: post() block may not reference array args")}else if("scalar"===o)e.scalarArgs.push(i),e.shimArgs.push("scalar"+i);else if("index"===o){if(e.indexArgs.push(i),i<e.pre.args.length&&e.pre.args[i].count>0)throw new Error("cwise: pre() block may not reference array index");if(i<e.body.args.length&&e.body.args[i].lvalue)throw new Error("cwise: body() block may not write to array index");if(i<e.post.args.length&&e.post.args[i].count>0)throw new Error("cwise: post() block may not reference array index")}else if("shape"===o){if(e.shapeArgs.push(i),i<e.pre.args.length&&e.pre.args[i].lvalue)throw new Error("cwise: pre() block may not write to array shape");if(i<e.body.args.length&&e.body.args[i].lvalue)throw new Error("cwise: body() block may not write to array shape");if(i<e.post.args.length&&e.post.args[i].lvalue)throw new Error("cwise: post() block may not write to array shape")}else{if("object"!=typeof o||!o.offset)throw new Error("cwise: Unknown argument type "+r[i]);e.argTypes[i]="offset",e.offsetArgs.push({array:o.array,offset:o.offset}),e.offsetArgIndex.push(i)}}if(e.arrayArgs.length<=0)throw new Error("cwise: No array arguments specified");if(e.pre.args.length>r.length)throw new Error("cwise: Too many arguments in pre() block");if(e.body.args.length>r.length)throw new Error("cwise: Too many arguments in body() block");if(e.post.args.length>r.length)throw new Error("cwise: Too many arguments in post() block");return e.debug=!!t.printCode||!!t.debug,e.funcName=t.funcName||"cwise",e.blockSize=t.blockSize||64,n(e)}},{"./lib/thunk.js":150}],149:[function(t,e,r){"use strict";var n=t("uniq");function a(t,e,r){var n,a,i=t.length,o=e.arrayArgs.length,s=e.indexArgs.length>0,l=[],c=[],u=0,h=0;for(n=0;n<i;++n)c.push(["i",n,"=0"].join(""));for(a=0;a<o;++a)for(n=0;n<i;++n)h=u,u=t[n],0===n?c.push(["d",a,"s",n,"=t",a,"p",u].join("")):c.push(["d",a,"s",n,"=(t",a,"p",u,"-s",h,"*t",a,"p",h,")"].join(""));for(c.length>0&&l.push("var "+c.join(",")),n=i-1;n>=0;--n)u=t[n],l.push(["for(i",n,"=0;i",n,"<s",u,";++i",n,"){"].join(""));for(l.push(r),n=0;n<i;++n){for(h=u,u=t[n],a=0;a<o;++a)l.push(["p",a,"+=d",a,"s",n].join(""));s&&(n>0&&l.push(["index[",h,"]-=s",h].join("")),l.push(["++index[",u,"]"].join(""))),l.push("}")}return l.join("\n")}function i(t,e,r){for(var n=t.body,a=[],i=[],o=0;o<t.args.length;++o){var s=t.args[o];if(!(s.count<=0)){var l=new RegExp(s.name,"g"),c="",u=e.arrayArgs.indexOf(o);switch(e.argTypes[o]){case"offset":var h=e.offsetArgIndex.indexOf(o);u=e.offsetArgs[h].array,c="+q"+h;case"array":c="p"+u+c;var f="l"+o,p="a"+u;if(0===e.arrayBlockIndices[u])1===s.count?"generic"===r[u]?s.lvalue?(a.push(["var ",f,"=",p,".get(",c,")"].join("")),n=n.replace(l,f),i.push([p,".set(",c,",",f,")"].join(""))):n=n.replace(l,[p,".get(",c,")"].join("")):n=n.replace(l,[p,"[",c,"]"].join("")):"generic"===r[u]?(a.push(["var ",f,"=",p,".get(",c,")"].join("")),n=n.replace(l,f),s.lvalue&&i.push([p,".set(",c,",",f,")"].join(""))):(a.push(["var ",f,"=",p,"[",c,"]"].join("")),n=n.replace(l,f),s.lvalue&&i.push([p,"[",c,"]=",f].join("")));else{for(var d=[s.name],g=[c],m=0;m<Math.abs(e.arrayBlockIndices[u]);m++)d.push("\\s*\\[([^\\]]+)\\]"),g.push("$"+(m+1)+"*t"+u+"b"+m);if(l=new RegExp(d.join(""),"g"),c=g.join("+"),"generic"===r[u])throw new Error("cwise: Generic arrays not supported in combination with blocks!");n=n.replace(l,[p,"[",c,"]"].join(""))}break;case"scalar":n=n.replace(l,"Y"+e.scalarArgs.indexOf(o));break;case"index":n=n.replace(l,"index");break;case"shape":n=n.replace(l,"shape")}}}return[a.join("\n"),n,i.join("\n")].join("\n").trim()}function o(t){for(var e=new Array(t.length),r=!0,n=0;n<t.length;++n){var a=t[n],i=a.match(/\d+/);i=i?i[0]:"",0===a.charAt(0)?e[n]="u"+a.charAt(1)+i:e[n]=a.charAt(0)+i,n>0&&(r=r&&e[n]===e[n-1])}return r?e[0]:e.join("")}e.exports=function(t,e){for(var r=e[1].length-Math.abs(t.arrayBlockIndices[0])|0,s=new Array(t.arrayArgs.length),l=new Array(t.arrayArgs.length),c=0;c<t.arrayArgs.length;++c)l[c]=e[2*c],s[c]=e[2*c+1];var u=[],h=[],f=[],p=[],d=[];for(c=0;c<t.arrayArgs.length;++c){t.arrayBlockIndices[c]<0?(f.push(0),p.push(r),u.push(r),h.push(r+t.arrayBlockIndices[c])):(f.push(t.arrayBlockIndices[c]),p.push(t.arrayBlockIndices[c]+r),u.push(0),h.push(t.arrayBlockIndices[c]));for(var g=[],m=0;m<s[c].length;m++)f[c]<=s[c][m]&&s[c][m]<p[c]&&g.push(s[c][m]-f[c]);d.push(g)}var v=["SS"],y=["'use strict'"],x=[];for(m=0;m<r;++m)x.push(["s",m,"=SS[",m,"]"].join(""));for(c=0;c<t.arrayArgs.length;++c){v.push("a"+c),v.push("t"+c),v.push("p"+c);for(m=0;m<r;++m)x.push(["t",c,"p",m,"=t",c,"[",f[c]+m,"]"].join(""));for(m=0;m<Math.abs(t.arrayBlockIndices[c]);++m)x.push(["t",c,"b",m,"=t",c,"[",u[c]+m,"]"].join(""))}for(c=0;c<t.scalarArgs.length;++c)v.push("Y"+c);if(t.shapeArgs.length>0&&x.push("shape=SS.slice(0)"),t.indexArgs.length>0){var b=new Array(r);for(c=0;c<r;++c)b[c]="0";x.push(["index=[",b.join(","),"]"].join(""))}for(c=0;c<t.offsetArgs.length;++c){var _=t.offsetArgs[c],w=[];for(m=0;m<_.offset.length;++m)0!==_.offset[m]&&(1===_.offset[m]?w.push(["t",_.array,"p",m].join("")):w.push([_.offset[m],"*t",_.array,"p",m].join("")));0===w.length?x.push("q"+c+"=0"):x.push(["q",c,"=",w.join("+")].join(""))}var T=n([].concat(t.pre.thisVars).concat(t.body.thisVars).concat(t.post.thisVars));for((x=x.concat(T)).length>0&&y.push("var "+x.join(",")),c=0;c<t.arrayArgs.length;++c)y.push("p"+c+"|=0");t.pre.body.length>3&&y.push(i(t.pre,t,l));var k=i(t.body,t,l),M=function(t){for(var e=0,r=t[0].length;e<r;){for(var n=1;n<t.length;++n)if(t[n][e]!==t[0][e])return e;++e}return e}(d);M<r?y.push(function(t,e,r,n){for(var i=e.length,o=r.arrayArgs.length,s=r.blockSize,l=r.indexArgs.length>0,c=[],u=0;u<o;++u)c.push(["var offset",u,"=p",u].join(""));for(u=t;u<i;++u)c.push(["for(var j"+u+"=SS[",e[u],"]|0;j",u,">0;){"].join("")),c.push(["if(j",u,"<",s,"){"].join("")),c.push(["s",e[u],"=j",u].join("")),c.push(["j",u,"=0"].join("")),c.push(["}else{s",e[u],"=",s].join("")),c.push(["j",u,"-=",s,"}"].join("")),l&&c.push(["index[",e[u],"]=j",u].join(""));for(u=0;u<o;++u){for(var h=["offset"+u],f=t;f<i;++f)h.push(["j",f,"*t",u,"p",e[f]].join(""));c.push(["p",u,"=(",h.join("+"),")"].join(""))}for(c.push(a(e,r,n)),u=t;u<i;++u)c.push("}");return c.join("\n")}(M,d[0],t,k)):y.push(a(d[0],t,k)),t.post.body.length>3&&y.push(i(t.post,t,l)),t.debug&&console.log("-----Generated cwise routine for ",e,":\n"+y.join("\n")+"\n----------");var A=[t.funcName||"unnamed","_cwise_loop_",s[0].join("s"),"m",M,o(l)].join("");return new Function(["function ",A,"(",v.join(","),"){",y.join("\n"),"} return ",A].join(""))()}},{uniq:556}],150:[function(t,e,r){"use strict";var n=t("./compile.js");e.exports=function(t){var e=["'use strict'","var CACHED={}"],r=[],a=t.funcName+"_cwise_thunk";e.push(["return function ",a,"(",t.shimArgs.join(","),"){"].join(""));for(var i=[],o=[],s=[["array",t.arrayArgs[0],".shape.slice(",Math.max(0,t.arrayBlockIndices[0]),t.arrayBlockIndices[0]<0?","+t.arrayBlockIndices[0]+")":")"].join("")],l=[],c=[],u=0;u<t.arrayArgs.length;++u){var h=t.arrayArgs[u];r.push(["t",h,"=array",h,".dtype,","r",h,"=array",h,".order"].join("")),i.push("t"+h),i.push("r"+h),o.push("t"+h),o.push("r"+h+".join()"),s.push("array"+h+".data"),s.push("array"+h+".stride"),s.push("array"+h+".offset|0"),u>0&&(l.push("array"+t.arrayArgs[0]+".shape.length===array"+h+".shape.length+"+(Math.abs(t.arrayBlockIndices[0])-Math.abs(t.arrayBlockIndices[u]))),c.push("array"+t.arrayArgs[0]+".shape[shapeIndex+"+Math.max(0,t.arrayBlockIndices[0])+"]===array"+h+".shape[shapeIndex+"+Math.max(0,t.arrayBlockIndices[u])+"]"))}for(t.arrayArgs.length>1&&(e.push("if (!("+l.join(" && ")+")) throw new Error('cwise: Arrays do not all have the same dimensionality!')"),e.push("for(var shapeIndex=array"+t.arrayArgs[0]+".shape.length-"+Math.abs(t.arrayBlockIndices[0])+"; shapeIndex--\x3e0;) {"),e.push("if (!("+c.join(" && ")+")) throw new Error('cwise: Arrays do not all have the same shape!')"),e.push("}")),u=0;u<t.scalarArgs.length;++u)s.push("scalar"+t.scalarArgs[u]);return r.push(["type=[",o.join(","),"].join()"].join("")),r.push("proc=CACHED[type]"),e.push("var "+r.join(",")),e.push(["if(!proc){","CACHED[type]=proc=compile([",i.join(","),"])}","return proc(",s.join(","),")}"].join("")),t.debug&&console.log("-----Generated thunk:\n"+e.join("\n")+"\n----------"),new Function("compile",e.join("\n"))(n.bind(void 0,t))}},{"./compile.js":149}],151:[function(t,e,r){e.exports=t("cwise-compiler")},{"cwise-compiler":148}],152:[function(t,e,r){"use strict";var n,a=t("type/value/is"),i=t("type/value/ensure"),o=t("type/plain-function/ensure"),s=t("es5-ext/object/copy"),l=t("es5-ext/object/normalize-options"),c=t("es5-ext/object/map"),u=Function.prototype.bind,h=Object.defineProperty,f=Object.prototype.hasOwnProperty;n=function(t,e,r){var n,a=i(e)&&o(e.value);return delete(n=s(e)).writable,delete n.value,n.get=function(){return!r.overwriteDefinition&&f.call(this,t)?a:(e.value=u.call(a,r.resolveContext?r.resolveContext(this):this),h(this,t,e),this[t])},n},e.exports=function(t){var e=l(arguments[1]);return a(e.resolveContext)&&o(e.resolveContext),c(t,(function(t,r){return n(r,t,e)}))}},{"es5-ext/object/copy":192,"es5-ext/object/map":200,"es5-ext/object/normalize-options":201,"type/plain-function/ensure":548,"type/value/ensure":552,"type/value/is":553}],153:[function(t,e,r){"use strict";var n=t("type/value/is"),a=t("type/plain-function/is"),i=t("es5-ext/object/assign"),o=t("es5-ext/object/normalize-options"),s=t("es5-ext/string/#/contains");(e.exports=function(t,e){var r,a,l,c,u;return arguments.length<2||"string"!=typeof t?(c=e,e=t,t=null):c=arguments[2],n(t)?(r=s.call(t,"c"),a=s.call(t,"e"),l=s.call(t,"w")):(r=l=!0,a=!1),u={value:e,configurable:r,enumerable:a,writable:l},c?i(o(c),u):u}).gs=function(t,e,r){var l,c,u,h;return"string"!=typeof t?(u=r,r=e,e=t,t=null):u=arguments[3],n(e)?a(e)?n(r)?a(r)||(u=r,r=void 0):r=void 0:(u=e,e=r=void 0):e=void 0,n(t)?(l=s.call(t,"c"),c=s.call(t,"e")):(l=!0,c=!1),h={get:e,set:r,configurable:l,enumerable:c},u?i(o(u),h):h}},{"es5-ext/object/assign":189,"es5-ext/object/normalize-options":201,"es5-ext/string/#/contains":208,"type/plain-function/is":549,"type/value/is":553}],154:[function(t,e,r){!function(t,n){n("object"==typeof r&&"undefined"!=typeof e?r:t.d3=t.d3||{})}(this,(function(t){"use strict";function e(t,e){return t<e?-1:t>e?1:t>=e?0:NaN}function r(t){var r;return 1===t.length&&(r=t,t=function(t,n){return e(r(t),n)}),{left:function(e,r,n,a){for(null==n&&(n=0),null==a&&(a=e.length);n<a;){var i=n+a>>>1;t(e[i],r)<0?n=i+1:a=i}return n},right:function(e,r,n,a){for(null==n&&(n=0),null==a&&(a=e.length);n<a;){var i=n+a>>>1;t(e[i],r)>0?a=i:n=i+1}return n}}}var n=r(e),a=n.right,i=n.left;function o(t,e){return[t,e]}function s(t){return null===t?NaN:+t}function l(t,e){var r,n,a=t.length,i=0,o=-1,l=0,c=0;if(null==e)for(;++o<a;)isNaN(r=s(t[o]))||(c+=(n=r-l)*(r-(l+=n/++i)));else for(;++o<a;)isNaN(r=s(e(t[o],o,t)))||(c+=(n=r-l)*(r-(l+=n/++i)));if(i>1)return c/(i-1)}function c(t,e){var r=l(t,e);return r?Math.sqrt(r):r}function u(t,e){var r,n,a,i=t.length,o=-1;if(null==e){for(;++o<i;)if(null!=(r=t[o])&&r>=r)for(n=a=r;++o<i;)null!=(r=t[o])&&(n>r&&(n=r),a<r&&(a=r))}else for(;++o<i;)if(null!=(r=e(t[o],o,t))&&r>=r)for(n=a=r;++o<i;)null!=(r=e(t[o],o,t))&&(n>r&&(n=r),a<r&&(a=r));return[n,a]}var h=Array.prototype,f=h.slice,p=h.map;function d(t){return function(){return t}}function g(t){return t}function m(t,e,r){t=+t,e=+e,r=(a=arguments.length)<2?(e=t,t=0,1):a<3?1:+r;for(var n=-1,a=0|Math.max(0,Math.ceil((e-t)/r)),i=new Array(a);++n<a;)i[n]=t+n*r;return i}var v=Math.sqrt(50),y=Math.sqrt(10),x=Math.sqrt(2);function b(t,e,r){var n=(e-t)/Math.max(0,r),a=Math.floor(Math.log(n)/Math.LN10),i=n/Math.pow(10,a);return a>=0?(i>=v?10:i>=y?5:i>=x?2:1)*Math.pow(10,a):-Math.pow(10,-a)/(i>=v?10:i>=y?5:i>=x?2:1)}function _(t,e,r){var n=Math.abs(e-t)/Math.max(0,r),a=Math.pow(10,Math.floor(Math.log(n)/Math.LN10)),i=n/a;return i>=v?a*=10:i>=y?a*=5:i>=x&&(a*=2),e<t?-a:a}function w(t){return Math.ceil(Math.log(t.length)/Math.LN2)+1}function T(t,e,r){if(null==r&&(r=s),n=t.length){if((e=+e)<=0||n<2)return+r(t[0],0,t);if(e>=1)return+r(t[n-1],n-1,t);var n,a=(n-1)*e,i=Math.floor(a),o=+r(t[i],i,t);return o+(+r(t[i+1],i+1,t)-o)*(a-i)}}function k(t,e){var r,n,a=t.length,i=-1;if(null==e){for(;++i<a;)if(null!=(r=t[i])&&r>=r)for(n=r;++i<a;)null!=(r=t[i])&&n>r&&(n=r)}else for(;++i<a;)if(null!=(r=e(t[i],i,t))&&r>=r)for(n=r;++i<a;)null!=(r=e(t[i],i,t))&&n>r&&(n=r);return n}function M(t){if(!(a=t.length))return[];for(var e=-1,r=k(t,A),n=new Array(r);++e<r;)for(var a,i=-1,o=n[e]=new Array(a);++i<a;)o[i]=t[i][e];return n}function A(t){return t.length}t.bisect=a,t.bisectRight=a,t.bisectLeft=i,t.ascending=e,t.bisector=r,t.cross=function(t,e,r){var n,a,i,s,l=t.length,c=e.length,u=new Array(l*c);for(null==r&&(r=o),n=i=0;n<l;++n)for(s=t[n],a=0;a<c;++a,++i)u[i]=r(s,e[a]);return u},t.descending=function(t,e){return e<t?-1:e>t?1:e>=t?0:NaN},t.deviation=c,t.extent=u,t.histogram=function(){var t=g,e=u,r=w;function n(n){var i,o,s=n.length,l=new Array(s);for(i=0;i<s;++i)l[i]=t(n[i],i,n);var c=e(l),u=c[0],h=c[1],f=r(l,u,h);Array.isArray(f)||(f=_(u,h,f),f=m(Math.ceil(u/f)*f,h,f));for(var p=f.length;f[0]<=u;)f.shift(),--p;for(;f[p-1]>h;)f.pop(),--p;var d,g=new Array(p+1);for(i=0;i<=p;++i)(d=g[i]=[]).x0=i>0?f[i-1]:u,d.x1=i<p?f[i]:h;for(i=0;i<s;++i)u<=(o=l[i])&&o<=h&&g[a(f,o,0,p)].push(n[i]);return g}return n.value=function(e){return arguments.length?(t="function"==typeof e?e:d(e),n):t},n.domain=function(t){return arguments.length?(e="function"==typeof t?t:d([t[0],t[1]]),n):e},n.thresholds=function(t){return arguments.length?(r="function"==typeof t?t:Array.isArray(t)?d(f.call(t)):d(t),n):r},n},t.thresholdFreedmanDiaconis=function(t,r,n){return t=p.call(t,s).sort(e),Math.ceil((n-r)/(2*(T(t,.75)-T(t,.25))*Math.pow(t.length,-1/3)))},t.thresholdScott=function(t,e,r){return Math.ceil((r-e)/(3.5*c(t)*Math.pow(t.length,-1/3)))},t.thresholdSturges=w,t.max=function(t,e){var r,n,a=t.length,i=-1;if(null==e){for(;++i<a;)if(null!=(r=t[i])&&r>=r)for(n=r;++i<a;)null!=(r=t[i])&&r>n&&(n=r)}else for(;++i<a;)if(null!=(r=e(t[i],i,t))&&r>=r)for(n=r;++i<a;)null!=(r=e(t[i],i,t))&&r>n&&(n=r);return n},t.mean=function(t,e){var r,n=t.length,a=n,i=-1,o=0;if(null==e)for(;++i<n;)isNaN(r=s(t[i]))?--a:o+=r;else for(;++i<n;)isNaN(r=s(e(t[i],i,t)))?--a:o+=r;if(a)return o/a},t.median=function(t,r){var n,a=t.length,i=-1,o=[];if(null==r)for(;++i<a;)isNaN(n=s(t[i]))||o.push(n);else for(;++i<a;)isNaN(n=s(r(t[i],i,t)))||o.push(n);return T(o.sort(e),.5)},t.merge=function(t){for(var e,r,n,a=t.length,i=-1,o=0;++i<a;)o+=t[i].length;for(r=new Array(o);--a>=0;)for(e=(n=t[a]).length;--e>=0;)r[--o]=n[e];return r},t.min=k,t.pairs=function(t,e){null==e&&(e=o);for(var r=0,n=t.length-1,a=t[0],i=new Array(n<0?0:n);r<n;)i[r]=e(a,a=t[++r]);return i},t.permute=function(t,e){for(var r=e.length,n=new Array(r);r--;)n[r]=t[e[r]];return n},t.quantile=T,t.range=m,t.scan=function(t,r){if(n=t.length){var n,a,i=0,o=0,s=t[o];for(null==r&&(r=e);++i<n;)(r(a=t[i],s)<0||0!==r(s,s))&&(s=a,o=i);return 0===r(s,s)?o:void 0}},t.shuffle=function(t,e,r){for(var n,a,i=(null==r?t.length:r)-(e=null==e?0:+e);i;)a=Math.random()*i--|0,n=t[i+e],t[i+e]=t[a+e],t[a+e]=n;return t},t.sum=function(t,e){var r,n=t.length,a=-1,i=0;if(null==e)for(;++a<n;)(r=+t[a])&&(i+=r);else for(;++a<n;)(r=+e(t[a],a,t))&&(i+=r);return i},t.ticks=function(t,e,r){var n,a,i,o,s=-1;if(r=+r,(t=+t)===(e=+e)&&r>0)return[t];if((n=e<t)&&(a=t,t=e,e=a),0===(o=b(t,e,r))||!isFinite(o))return[];if(o>0)for(t=Math.ceil(t/o),e=Math.floor(e/o),i=new Array(a=Math.ceil(e-t+1));++s<a;)i[s]=(t+s)*o;else for(t=Math.floor(t*o),e=Math.ceil(e*o),i=new Array(a=Math.ceil(t-e+1));++s<a;)i[s]=(t-s)/o;return n&&i.reverse(),i},t.tickIncrement=b,t.tickStep=_,t.transpose=M,t.variance=l,t.zip=function(){return M(arguments)},Object.defineProperty(t,"__esModule",{value:!0})}))},{}],155:[function(t,e,r){!function(t,n){n("object"==typeof r&&"undefined"!=typeof e?r:t.d3=t.d3||{})}(this,(function(t){"use strict";function e(){}function r(t,r){var n=new e;if(t instanceof e)t.each((function(t,e){n.set(e,t)}));else if(Array.isArray(t)){var a,i=-1,o=t.length;if(null==r)for(;++i<o;)n.set(i,t[i]);else for(;++i<o;)n.set(r(a=t[i],i,t),a)}else if(t)for(var s in t)n.set(s,t[s]);return n}function n(){return{}}function a(t,e,r){t[e]=r}function i(){return r()}function o(t,e,r){t.set(e,r)}function s(){}e.prototype=r.prototype={constructor:e,has:function(t){return"$"+t in this},get:function(t){return this["$"+t]},set:function(t,e){return this["$"+t]=e,this},remove:function(t){var e="$"+t;return e in this&&delete this[e]},clear:function(){for(var t in this)"$"===t[0]&&delete this[t]},keys:function(){var t=[];for(var e in this)"$"===e[0]&&t.push(e.slice(1));return t},values:function(){var t=[];for(var e in this)"$"===e[0]&&t.push(this[e]);return t},entries:function(){var t=[];for(var e in this)"$"===e[0]&&t.push({key:e.slice(1),value:this[e]});return t},size:function(){var t=0;for(var e in this)"$"===e[0]&&++t;return t},empty:function(){for(var t in this)if("$"===t[0])return!1;return!0},each:function(t){for(var e in this)"$"===e[0]&&t(this[e],e.slice(1),this)}};var l=r.prototype;function c(t,e){var r=new s;if(t instanceof s)t.each((function(t){r.add(t)}));else if(t){var n=-1,a=t.length;if(null==e)for(;++n<a;)r.add(t[n]);else for(;++n<a;)r.add(e(t[n],n,t))}return r}s.prototype=c.prototype={constructor:s,has:l.has,add:function(t){return this["$"+(t+="")]=t,this},remove:l.remove,clear:l.clear,values:l.keys,size:l.size,empty:l.empty,each:l.each},t.nest=function(){var t,e,s,l=[],c=[];function u(n,a,i,o){if(a>=l.length)return null!=t&&n.sort(t),null!=e?e(n):n;for(var s,c,h,f=-1,p=n.length,d=l[a++],g=r(),m=i();++f<p;)(h=g.get(s=d(c=n[f])+""))?h.push(c):g.set(s,[c]);return g.each((function(t,e){o(m,e,u(t,a,i,o))})),m}return s={object:function(t){return u(t,0,n,a)},map:function(t){return u(t,0,i,o)},entries:function(t){return function t(r,n){if(++n>l.length)return r;var a,i=c[n-1];return null!=e&&n>=l.length?a=r.entries():(a=[],r.each((function(e,r){a.push({key:r,values:t(e,n)})}))),null!=i?a.sort((function(t,e){return i(t.key,e.key)})):a}(u(t,0,i,o),0)},key:function(t){return l.push(t),s},sortKeys:function(t){return c[l.length-1]=t,s},sortValues:function(e){return t=e,s},rollup:function(t){return e=t,s}}},t.set=c,t.map=r,t.keys=function(t){var e=[];for(var r in t)e.push(r);return e},t.values=function(t){var e=[];for(var r in t)e.push(t[r]);return e},t.entries=function(t){var e=[];for(var r in t)e.push({key:r,value:t[r]});return e},Object.defineProperty(t,"__esModule",{value:!0})}))},{}],156:[function(t,e,r){!function(t,n){"object"==typeof r&&"undefined"!=typeof e?n(r):n((t=t||self).d3=t.d3||{})}(this,(function(t){"use strict";function e(t,e,r){t.prototype=e.prototype=r,r.constructor=t}function r(t,e){var r=Object.create(t.prototype);for(var n in e)r[n]=e[n];return r}function n(){}var a="\\s*([+-]?\\d+)\\s*",i="\\s*([+-]?\\d*\\.?\\d+(?:[eE][+-]?\\d+)?)\\s*",o="\\s*([+-]?\\d*\\.?\\d+(?:[eE][+-]?\\d+)?)%\\s*",s=/^#([0-9a-f]{3,8})$/,l=new RegExp("^rgb\\("+[a,a,a]+"\\)$"),c=new RegExp("^rgb\\("+[o,o,o]+"\\)$"),u=new RegExp("^rgba\\("+[a,a,a,i]+"\\)$"),h=new RegExp("^rgba\\("+[o,o,o,i]+"\\)$"),f=new RegExp("^hsl\\("+[i,o,o]+"\\)$"),p=new RegExp("^hsla\\("+[i,o,o,i]+"\\)$"),d={aliceblue:15792383,antiquewhite:16444375,aqua:65535,aquamarine:8388564,azure:15794175,beige:16119260,bisque:16770244,black:0,blanchedalmond:16772045,blue:255,blueviolet:9055202,brown:10824234,burlywood:14596231,cadetblue:6266528,chartreuse:8388352,chocolate:13789470,coral:16744272,cornflowerblue:6591981,cornsilk:16775388,crimson:14423100,cyan:65535,darkblue:139,darkcyan:35723,darkgoldenrod:12092939,darkgray:11119017,darkgreen:25600,darkgrey:11119017,darkkhaki:12433259,darkmagenta:9109643,darkolivegreen:5597999,darkorange:16747520,darkorchid:10040012,darkred:9109504,darksalmon:15308410,darkseagreen:9419919,darkslateblue:4734347,darkslategray:3100495,darkslategrey:3100495,darkturquoise:52945,darkviolet:9699539,deeppink:16716947,deepskyblue:49151,dimgray:6908265,dimgrey:6908265,dodgerblue:2003199,firebrick:11674146,floralwhite:16775920,forestgreen:2263842,fuchsia:16711935,gainsboro:14474460,ghostwhite:16316671,gold:16766720,goldenrod:14329120,gray:8421504,green:32768,greenyellow:11403055,grey:8421504,honeydew:15794160,hotpink:16738740,indianred:13458524,indigo:4915330,ivory:16777200,khaki:15787660,lavender:15132410,lavenderblush:16773365,lawngreen:8190976,lemonchiffon:16775885,lightblue:11393254,lightcoral:15761536,lightcyan:14745599,lightgoldenrodyellow:16448210,lightgray:13882323,lightgreen:9498256,lightgrey:13882323,lightpink:16758465,lightsalmon:16752762,lightseagreen:2142890,lightskyblue:8900346,lightslategray:7833753,lightslategrey:7833753,lightsteelblue:11584734,lightyellow:16777184,lime:65280,limegreen:3329330,linen:16445670,magenta:16711935,maroon:8388608,mediumaquamarine:6737322,mediumblue:205,mediumorchid:12211667,mediumpurple:9662683,mediumseagreen:3978097,mediumslateblue:8087790,mediumspringgreen:64154,mediumturquoise:4772300,mediumvioletred:13047173,midnightblue:1644912,mintcream:16121850,mistyrose:16770273,moccasin:16770229,navajowhite:16768685,navy:128,oldlace:16643558,olive:8421376,olivedrab:7048739,orange:16753920,orangered:16729344,orchid:14315734,palegoldenrod:15657130,palegreen:10025880,paleturquoise:11529966,palevioletred:14381203,papayawhip:16773077,peachpuff:16767673,peru:13468991,pink:16761035,plum:14524637,powderblue:11591910,purple:8388736,rebeccapurple:6697881,red:16711680,rosybrown:12357519,royalblue:4286945,saddlebrown:9127187,salmon:16416882,sandybrown:16032864,seagreen:3050327,seashell:16774638,sienna:10506797,silver:12632256,skyblue:8900331,slateblue:6970061,slategray:7372944,slategrey:7372944,snow:16775930,springgreen:65407,steelblue:4620980,tan:13808780,teal:32896,thistle:14204888,tomato:16737095,turquoise:4251856,violet:15631086,wheat:16113331,white:16777215,whitesmoke:16119285,yellow:16776960,yellowgreen:10145074};function g(){return this.rgb().formatHex()}function m(){return this.rgb().formatRgb()}function v(t){var e,r;return t=(t+"").trim().toLowerCase(),(e=s.exec(t))?(r=e[1].length,e=parseInt(e[1],16),6===r?y(e):3===r?new w(e>>8&15|e>>4&240,e>>4&15|240&e,(15&e)<<4|15&e,1):8===r?x(e>>24&255,e>>16&255,e>>8&255,(255&e)/255):4===r?x(e>>12&15|e>>8&240,e>>8&15|e>>4&240,e>>4&15|240&e,((15&e)<<4|15&e)/255):null):(e=l.exec(t))?new w(e[1],e[2],e[3],1):(e=c.exec(t))?new w(255*e[1]/100,255*e[2]/100,255*e[3]/100,1):(e=u.exec(t))?x(e[1],e[2],e[3],e[4]):(e=h.exec(t))?x(255*e[1]/100,255*e[2]/100,255*e[3]/100,e[4]):(e=f.exec(t))?A(e[1],e[2]/100,e[3]/100,1):(e=p.exec(t))?A(e[1],e[2]/100,e[3]/100,e[4]):d.hasOwnProperty(t)?y(d[t]):"transparent"===t?new w(NaN,NaN,NaN,0):null}function y(t){return new w(t>>16&255,t>>8&255,255&t,1)}function x(t,e,r,n){return n<=0&&(t=e=r=NaN),new w(t,e,r,n)}function b(t){return t instanceof n||(t=v(t)),t?new w((t=t.rgb()).r,t.g,t.b,t.opacity):new w}function _(t,e,r,n){return 1===arguments.length?b(t):new w(t,e,r,null==n?1:n)}function w(t,e,r,n){this.r=+t,this.g=+e,this.b=+r,this.opacity=+n}function T(){return"#"+M(this.r)+M(this.g)+M(this.b)}function k(){var t=this.opacity;return(1===(t=isNaN(t)?1:Math.max(0,Math.min(1,t)))?"rgb(":"rgba(")+Math.max(0,Math.min(255,Math.round(this.r)||0))+", "+Math.max(0,Math.min(255,Math.round(this.g)||0))+", "+Math.max(0,Math.min(255,Math.round(this.b)||0))+(1===t?")":", "+t+")")}function M(t){return((t=Math.max(0,Math.min(255,Math.round(t)||0)))<16?"0":"")+t.toString(16)}function A(t,e,r,n){return n<=0?t=e=r=NaN:r<=0||r>=1?t=e=NaN:e<=0&&(t=NaN),new C(t,e,r,n)}function S(t){if(t instanceof C)return new C(t.h,t.s,t.l,t.opacity);if(t instanceof n||(t=v(t)),!t)return new C;if(t instanceof C)return t;var e=(t=t.rgb()).r/255,r=t.g/255,a=t.b/255,i=Math.min(e,r,a),o=Math.max(e,r,a),s=NaN,l=o-i,c=(o+i)/2;return l?(s=e===o?(r-a)/l+6*(r<a):r===o?(a-e)/l+2:(e-r)/l+4,l/=c<.5?o+i:2-o-i,s*=60):l=c>0&&c<1?0:s,new C(s,l,c,t.opacity)}function E(t,e,r,n){return 1===arguments.length?S(t):new C(t,e,r,null==n?1:n)}function C(t,e,r,n){this.h=+t,this.s=+e,this.l=+r,this.opacity=+n}function L(t,e,r){return 255*(t<60?e+(r-e)*t/60:t<180?r:t<240?e+(r-e)*(240-t)/60:e)}e(n,v,{copy:function(t){return Object.assign(new this.constructor,this,t)},displayable:function(){return this.rgb().displayable()},hex:g,formatHex:g,formatHsl:function(){return S(this).formatHsl()},formatRgb:m,toString:m}),e(w,_,r(n,{brighter:function(t){return t=null==t?1/.7:Math.pow(1/.7,t),new w(this.r*t,this.g*t,this.b*t,this.opacity)},darker:function(t){return t=null==t?.7:Math.pow(.7,t),new w(this.r*t,this.g*t,this.b*t,this.opacity)},rgb:function(){return this},displayable:function(){return-.5<=this.r&&this.r<255.5&&-.5<=this.g&&this.g<255.5&&-.5<=this.b&&this.b<255.5&&0<=this.opacity&&this.opacity<=1},hex:T,formatHex:T,formatRgb:k,toString:k})),e(C,E,r(n,{brighter:function(t){return t=null==t?1/.7:Math.pow(1/.7,t),new C(this.h,this.s,this.l*t,this.opacity)},darker:function(t){return t=null==t?.7:Math.pow(.7,t),new C(this.h,this.s,this.l*t,this.opacity)},rgb:function(){var t=this.h%360+360*(this.h<0),e=isNaN(t)||isNaN(this.s)?0:this.s,r=this.l,n=r+(r<.5?r:1-r)*e,a=2*r-n;return new w(L(t>=240?t-240:t+120,a,n),L(t,a,n),L(t<120?t+240:t-120,a,n),this.opacity)},displayable:function(){return(0<=this.s&&this.s<=1||isNaN(this.s))&&0<=this.l&&this.l<=1&&0<=this.opacity&&this.opacity<=1},formatHsl:function(){var t=this.opacity;return(1===(t=isNaN(t)?1:Math.max(0,Math.min(1,t)))?"hsl(":"hsla(")+(this.h||0)+", "+100*(this.s||0)+"%, "+100*(this.l||0)+"%"+(1===t?")":", "+t+")")}}));var P=Math.PI/180,I=180/Math.PI,z=6/29,O=3*z*z;function D(t){if(t instanceof F)return new F(t.l,t.a,t.b,t.opacity);if(t instanceof H)return G(t);t instanceof w||(t=b(t));var e,r,n=U(t.r),a=U(t.g),i=U(t.b),o=B((.2225045*n+.7168786*a+.0606169*i)/1);return n===a&&a===i?e=r=o:(e=B((.4360747*n+.3850649*a+.1430804*i)/.96422),r=B((.0139322*n+.0971045*a+.7141733*i)/.82521)),new F(116*o-16,500*(e-o),200*(o-r),t.opacity)}function R(t,e,r,n){return 1===arguments.length?D(t):new F(t,e,r,null==n?1:n)}function F(t,e,r,n){this.l=+t,this.a=+e,this.b=+r,this.opacity=+n}function B(t){return t>.008856451679035631?Math.pow(t,1/3):t/O+4/29}function N(t){return t>z?t*t*t:O*(t-4/29)}function j(t){return 255*(t<=.0031308?12.92*t:1.055*Math.pow(t,1/2.4)-.055)}function U(t){return(t/=255)<=.04045?t/12.92:Math.pow((t+.055)/1.055,2.4)}function V(t){if(t instanceof H)return new H(t.h,t.c,t.l,t.opacity);if(t instanceof F||(t=D(t)),0===t.a&&0===t.b)return new H(NaN,0<t.l&&t.l<100?0:NaN,t.l,t.opacity);var e=Math.atan2(t.b,t.a)*I;return new H(e<0?e+360:e,Math.sqrt(t.a*t.a+t.b*t.b),t.l,t.opacity)}function q(t,e,r,n){return 1===arguments.length?V(t):new H(t,e,r,null==n?1:n)}function H(t,e,r,n){this.h=+t,this.c=+e,this.l=+r,this.opacity=+n}function G(t){if(isNaN(t.h))return new F(t.l,0,0,t.opacity);var e=t.h*P;return new F(t.l,Math.cos(e)*t.c,Math.sin(e)*t.c,t.opacity)}e(F,R,r(n,{brighter:function(t){return new F(this.l+18*(null==t?1:t),this.a,this.b,this.opacity)},darker:function(t){return new F(this.l-18*(null==t?1:t),this.a,this.b,this.opacity)},rgb:function(){var t=(this.l+16)/116,e=isNaN(this.a)?t:t+this.a/500,r=isNaN(this.b)?t:t-this.b/200;return new w(j(3.1338561*(e=.96422*N(e))-1.6168667*(t=1*N(t))-.4906146*(r=.82521*N(r))),j(-.9787684*e+1.9161415*t+.033454*r),j(.0719453*e-.2289914*t+1.4052427*r),this.opacity)}})),e(H,q,r(n,{brighter:function(t){return new H(this.h,this.c,this.l+18*(null==t?1:t),this.opacity)},darker:function(t){return new H(this.h,this.c,this.l-18*(null==t?1:t),this.opacity)},rgb:function(){return G(this).rgb()}}));var Y=-.14861,W=1.78277,Z=-.29227,X=-.90649,J=1.97294,K=J*X,Q=J*W,$=W*Z-X*Y;function tt(t){if(t instanceof rt)return new rt(t.h,t.s,t.l,t.opacity);t instanceof w||(t=b(t));var e=t.r/255,r=t.g/255,n=t.b/255,a=($*n+K*e-Q*r)/($+K-Q),i=n-a,o=(J*(r-a)-Z*i)/X,s=Math.sqrt(o*o+i*i)/(J*a*(1-a)),l=s?Math.atan2(o,i)*I-120:NaN;return new rt(l<0?l+360:l,s,a,t.opacity)}function et(t,e,r,n){return 1===arguments.length?tt(t):new rt(t,e,r,null==n?1:n)}function rt(t,e,r,n){this.h=+t,this.s=+e,this.l=+r,this.opacity=+n}e(rt,et,r(n,{brighter:function(t){return t=null==t?1/.7:Math.pow(1/.7,t),new rt(this.h,this.s,this.l*t,this.opacity)},darker:function(t){return t=null==t?.7:Math.pow(.7,t),new rt(this.h,this.s,this.l*t,this.opacity)},rgb:function(){var t=isNaN(this.h)?0:(this.h+120)*P,e=+this.l,r=isNaN(this.s)?0:this.s*e*(1-e),n=Math.cos(t),a=Math.sin(t);return new w(255*(e+r*(Y*n+W*a)),255*(e+r*(Z*n+X*a)),255*(e+r*(J*n)),this.opacity)}})),t.color=v,t.cubehelix=et,t.gray=function(t,e){return new F(t,0,0,null==e?1:e)},t.hcl=q,t.hsl=E,t.lab=R,t.lch=function(t,e,r,n){return 1===arguments.length?V(t):new H(r,e,t,null==n?1:n)},t.rgb=_,Object.defineProperty(t,"__esModule",{value:!0})}))},{}],157:[function(t,e,r){!function(t,n){"object"==typeof r&&"undefined"!=typeof e?n(r):n((t=t||self).d3=t.d3||{})}(this,(function(t){"use strict";var e={value:function(){}};function r(){for(var t,e=0,r=arguments.length,a={};e<r;++e){if(!(t=arguments[e]+"")||t in a||/[\s.]/.test(t))throw new Error("illegal type: "+t);a[t]=[]}return new n(a)}function n(t){this._=t}function a(t,e){return t.trim().split(/^|\s+/).map((function(t){var r="",n=t.indexOf(".");if(n>=0&&(r=t.slice(n+1),t=t.slice(0,n)),t&&!e.hasOwnProperty(t))throw new Error("unknown type: "+t);return{type:t,name:r}}))}function i(t,e){for(var r,n=0,a=t.length;n<a;++n)if((r=t[n]).name===e)return r.value}function o(t,r,n){for(var a=0,i=t.length;a<i;++a)if(t[a].name===r){t[a]=e,t=t.slice(0,a).concat(t.slice(a+1));break}return null!=n&&t.push({name:r,value:n}),t}n.prototype=r.prototype={constructor:n,on:function(t,e){var r,n=this._,s=a(t+"",n),l=-1,c=s.length;if(!(arguments.length<2)){if(null!=e&&"function"!=typeof e)throw new Error("invalid callback: "+e);for(;++l<c;)if(r=(t=s[l]).type)n[r]=o(n[r],t.name,e);else if(null==e)for(r in n)n[r]=o(n[r],t.name,null);return this}for(;++l<c;)if((r=(t=s[l]).type)&&(r=i(n[r],t.name)))return r},copy:function(){var t={},e=this._;for(var r in e)t[r]=e[r].slice();return new n(t)},call:function(t,e){if((r=arguments.length-2)>0)for(var r,n,a=new Array(r),i=0;i<r;++i)a[i]=arguments[i+2];if(!this._.hasOwnProperty(t))throw new Error("unknown type: "+t);for(i=0,r=(n=this._[t]).length;i<r;++i)n[i].value.apply(e,a)},apply:function(t,e,r){if(!this._.hasOwnProperty(t))throw new Error("unknown type: "+t);for(var n=this._[t],a=0,i=n.length;a<i;++a)n[a].value.apply(e,r)}},t.dispatch=r,Object.defineProperty(t,"__esModule",{value:!0})}))},{}],158:[function(t,e,r){!function(n,a){"object"==typeof r&&"undefined"!=typeof e?a(r,t("d3-quadtree"),t("d3-collection"),t("d3-dispatch"),t("d3-timer")):a(n.d3=n.d3||{},n.d3,n.d3,n.d3,n.d3)}(this,(function(t,e,r,n,a){"use strict";function i(t){return function(){return t}}function o(){return 1e-6*(Math.random()-.5)}function s(t){return t.x+t.vx}function l(t){return t.y+t.vy}function c(t){return t.index}function u(t,e){var r=t.get(e);if(!r)throw new Error("missing: "+e);return r}function h(t){return t.x}function f(t){return t.y}var p=Math.PI*(3-Math.sqrt(5));t.forceCenter=function(t,e){var r;function n(){var n,a,i=r.length,o=0,s=0;for(n=0;n<i;++n)o+=(a=r[n]).x,s+=a.y;for(o=o/i-t,s=s/i-e,n=0;n<i;++n)(a=r[n]).x-=o,a.y-=s}return null==t&&(t=0),null==e&&(e=0),n.initialize=function(t){r=t},n.x=function(e){return arguments.length?(t=+e,n):t},n.y=function(t){return arguments.length?(e=+t,n):e},n},t.forceCollide=function(t){var r,n,a=1,c=1;function u(){for(var t,i,u,f,p,d,g,m=r.length,v=0;v<c;++v)for(i=e.quadtree(r,s,l).visitAfter(h),t=0;t<m;++t)u=r[t],d=n[u.index],g=d*d,f=u.x+u.vx,p=u.y+u.vy,i.visit(y);function y(t,e,r,n,i){var s=t.data,l=t.r,c=d+l;if(!s)return e>f+c||n<f-c||r>p+c||i<p-c;if(s.index>u.index){var h=f-s.x-s.vx,m=p-s.y-s.vy,v=h*h+m*m;v<c*c&&(0===h&&(v+=(h=o())*h),0===m&&(v+=(m=o())*m),v=(c-(v=Math.sqrt(v)))/v*a,u.vx+=(h*=v)*(c=(l*=l)/(g+l)),u.vy+=(m*=v)*c,s.vx-=h*(c=1-c),s.vy-=m*c)}}}function h(t){if(t.data)return t.r=n[t.data.index];for(var e=t.r=0;e<4;++e)t[e]&&t[e].r>t.r&&(t.r=t[e].r)}function f(){if(r){var e,a,i=r.length;for(n=new Array(i),e=0;e<i;++e)a=r[e],n[a.index]=+t(a,e,r)}}return"function"!=typeof t&&(t=i(null==t?1:+t)),u.initialize=function(t){r=t,f()},u.iterations=function(t){return arguments.length?(c=+t,u):c},u.strength=function(t){return arguments.length?(a=+t,u):a},u.radius=function(e){return arguments.length?(t="function"==typeof e?e:i(+e),f(),u):t},u},t.forceLink=function(t){var e,n,a,s,l,h=c,f=function(t){return 1/Math.min(s[t.source.index],s[t.target.index])},p=i(30),d=1;function g(r){for(var a=0,i=t.length;a<d;++a)for(var s,c,u,h,f,p,g,m=0;m<i;++m)c=(s=t[m]).source,h=(u=s.target).x+u.vx-c.x-c.vx||o(),f=u.y+u.vy-c.y-c.vy||o(),h*=p=((p=Math.sqrt(h*h+f*f))-n[m])/p*r*e[m],f*=p,u.vx-=h*(g=l[m]),u.vy-=f*g,c.vx+=h*(g=1-g),c.vy+=f*g}function m(){if(a){var i,o,c=a.length,f=t.length,p=r.map(a,h);for(i=0,s=new Array(c);i<f;++i)(o=t[i]).index=i,"object"!=typeof o.source&&(o.source=u(p,o.source)),"object"!=typeof o.target&&(o.target=u(p,o.target)),s[o.source.index]=(s[o.source.index]||0)+1,s[o.target.index]=(s[o.target.index]||0)+1;for(i=0,l=new Array(f);i<f;++i)o=t[i],l[i]=s[o.source.index]/(s[o.source.index]+s[o.target.index]);e=new Array(f),v(),n=new Array(f),y()}}function v(){if(a)for(var r=0,n=t.length;r<n;++r)e[r]=+f(t[r],r,t)}function y(){if(a)for(var e=0,r=t.length;e<r;++e)n[e]=+p(t[e],e,t)}return null==t&&(t=[]),g.initialize=function(t){a=t,m()},g.links=function(e){return arguments.length?(t=e,m(),g):t},g.id=function(t){return arguments.length?(h=t,g):h},g.iterations=function(t){return arguments.length?(d=+t,g):d},g.strength=function(t){return arguments.length?(f="function"==typeof t?t:i(+t),v(),g):f},g.distance=function(t){return arguments.length?(p="function"==typeof t?t:i(+t),y(),g):p},g},t.forceManyBody=function(){var t,r,n,a,s=i(-30),l=1,c=1/0,u=.81;function p(a){var i,o=t.length,s=e.quadtree(t,h,f).visitAfter(g);for(n=a,i=0;i<o;++i)r=t[i],s.visit(m)}function d(){if(t){var e,r,n=t.length;for(a=new Array(n),e=0;e<n;++e)r=t[e],a[r.index]=+s(r,e,t)}}function g(t){var e,r,n,i,o,s=0,l=0;if(t.length){for(n=i=o=0;o<4;++o)(e=t[o])&&(r=Math.abs(e.value))&&(s+=e.value,l+=r,n+=r*e.x,i+=r*e.y);t.x=n/l,t.y=i/l}else{(e=t).x=e.data.x,e.y=e.data.y;do{s+=a[e.data.index]}while(e=e.next)}t.value=s}function m(t,e,i,s){if(!t.value)return!0;var h=t.x-r.x,f=t.y-r.y,p=s-e,d=h*h+f*f;if(p*p/u<d)return d<c&&(0===h&&(d+=(h=o())*h),0===f&&(d+=(f=o())*f),d<l&&(d=Math.sqrt(l*d)),r.vx+=h*t.value*n/d,r.vy+=f*t.value*n/d),!0;if(!(t.length||d>=c)){(t.data!==r||t.next)&&(0===h&&(d+=(h=o())*h),0===f&&(d+=(f=o())*f),d<l&&(d=Math.sqrt(l*d)));do{t.data!==r&&(p=a[t.data.index]*n/d,r.vx+=h*p,r.vy+=f*p)}while(t=t.next)}}return p.initialize=function(e){t=e,d()},p.strength=function(t){return arguments.length?(s="function"==typeof t?t:i(+t),d(),p):s},p.distanceMin=function(t){return arguments.length?(l=t*t,p):Math.sqrt(l)},p.distanceMax=function(t){return arguments.length?(c=t*t,p):Math.sqrt(c)},p.theta=function(t){return arguments.length?(u=t*t,p):Math.sqrt(u)},p},t.forceRadial=function(t,e,r){var n,a,o,s=i(.1);function l(t){for(var i=0,s=n.length;i<s;++i){var l=n[i],c=l.x-e||1e-6,u=l.y-r||1e-6,h=Math.sqrt(c*c+u*u),f=(o[i]-h)*a[i]*t/h;l.vx+=c*f,l.vy+=u*f}}function c(){if(n){var e,r=n.length;for(a=new Array(r),o=new Array(r),e=0;e<r;++e)o[e]=+t(n[e],e,n),a[e]=isNaN(o[e])?0:+s(n[e],e,n)}}return"function"!=typeof t&&(t=i(+t)),null==e&&(e=0),null==r&&(r=0),l.initialize=function(t){n=t,c()},l.strength=function(t){return arguments.length?(s="function"==typeof t?t:i(+t),c(),l):s},l.radius=function(e){return arguments.length?(t="function"==typeof e?e:i(+e),c(),l):t},l.x=function(t){return arguments.length?(e=+t,l):e},l.y=function(t){return arguments.length?(r=+t,l):r},l},t.forceSimulation=function(t){var e,i=1,o=.001,s=1-Math.pow(o,1/300),l=0,c=.6,u=r.map(),h=a.timer(d),f=n.dispatch("tick","end");function d(){g(),f.call("tick",e),i<o&&(h.stop(),f.call("end",e))}function g(r){var n,a,o=t.length;void 0===r&&(r=1);for(var h=0;h<r;++h)for(i+=(l-i)*s,u.each((function(t){t(i)})),n=0;n<o;++n)null==(a=t[n]).fx?a.x+=a.vx*=c:(a.x=a.fx,a.vx=0),null==a.fy?a.y+=a.vy*=c:(a.y=a.fy,a.vy=0);return e}function m(){for(var e,r=0,n=t.length;r<n;++r){if((e=t[r]).index=r,null!=e.fx&&(e.x=e.fx),null!=e.fy&&(e.y=e.fy),isNaN(e.x)||isNaN(e.y)){var a=10*Math.sqrt(r),i=r*p;e.x=a*Math.cos(i),e.y=a*Math.sin(i)}(isNaN(e.vx)||isNaN(e.vy))&&(e.vx=e.vy=0)}}function v(e){return e.initialize&&e.initialize(t),e}return null==t&&(t=[]),m(),e={tick:g,restart:function(){return h.restart(d),e},stop:function(){return h.stop(),e},nodes:function(r){return arguments.length?(t=r,m(),u.each(v),e):t},alpha:function(t){return arguments.length?(i=+t,e):i},alphaMin:function(t){return arguments.length?(o=+t,e):o},alphaDecay:function(t){return arguments.length?(s=+t,e):+s},alphaTarget:function(t){return arguments.length?(l=+t,e):l},velocityDecay:function(t){return arguments.length?(c=1-t,e):1-c},force:function(t,r){return arguments.length>1?(null==r?u.remove(t):u.set(t,v(r)),e):u.get(t)},find:function(e,r,n){var a,i,o,s,l,c=0,u=t.length;for(null==n?n=1/0:n*=n,c=0;c<u;++c)(o=(a=e-(s=t[c]).x)*a+(i=r-s.y)*i)<n&&(l=s,n=o);return l},on:function(t,r){return arguments.length>1?(f.on(t,r),e):f.on(t)}}},t.forceX=function(t){var e,r,n,a=i(.1);function o(t){for(var a,i=0,o=e.length;i<o;++i)(a=e[i]).vx+=(n[i]-a.x)*r[i]*t}function s(){if(e){var i,o=e.length;for(r=new Array(o),n=new Array(o),i=0;i<o;++i)r[i]=isNaN(n[i]=+t(e[i],i,e))?0:+a(e[i],i,e)}}return"function"!=typeof t&&(t=i(null==t?0:+t)),o.initialize=function(t){e=t,s()},o.strength=function(t){return arguments.length?(a="function"==typeof t?t:i(+t),s(),o):a},o.x=function(e){return arguments.length?(t="function"==typeof e?e:i(+e),s(),o):t},o},t.forceY=function(t){var e,r,n,a=i(.1);function o(t){for(var a,i=0,o=e.length;i<o;++i)(a=e[i]).vy+=(n[i]-a.y)*r[i]*t}function s(){if(e){var i,o=e.length;for(r=new Array(o),n=new Array(o),i=0;i<o;++i)r[i]=isNaN(n[i]=+t(e[i],i,e))?0:+a(e[i],i,e)}}return"function"!=typeof t&&(t=i(null==t?0:+t)),o.initialize=function(t){e=t,s()},o.strength=function(t){return arguments.length?(a="function"==typeof t?t:i(+t),s(),o):a},o.y=function(e){return arguments.length?(t="function"==typeof e?e:i(+e),s(),o):t},o},Object.defineProperty(t,"__esModule",{value:!0})}))},{"d3-collection":155,"d3-dispatch":157,"d3-quadtree":162,"d3-timer":164}],159:[function(t,e,r){!function(t,n){"object"==typeof r&&"undefined"!=typeof e?n(r):n((t=t||self).d3=t.d3||{})}(this,(function(t){"use strict";function e(t,e){return t.parent===e.parent?1:2}function r(t,e){return t+e.x}function n(t,e){return Math.max(t,e.y)}function a(t){var e=0,r=t.children,n=r&&r.length;if(n)for(;--n>=0;)e+=r[n].value;else e=1;t.value=e}function i(t,e){var r,n,a,i,s,u=new c(t),h=+t.value&&(u.value=t.value),f=[u];for(null==e&&(e=o);r=f.pop();)if(h&&(r.value=+r.data.value),(a=e(r.data))&&(s=a.length))for(r.children=new Array(s),i=s-1;i>=0;--i)f.push(n=r.children[i]=new c(a[i])),n.parent=r,n.depth=r.depth+1;return u.eachBefore(l)}function o(t){return t.children}function s(t){t.data=t.data.data}function l(t){var e=0;do{t.height=e}while((t=t.parent)&&t.height<++e)}function c(t){this.data=t,this.depth=this.height=0,this.parent=null}c.prototype=i.prototype={constructor:c,count:function(){return this.eachAfter(a)},each:function(t){var e,r,n,a,i=this,o=[i];do{for(e=o.reverse(),o=[];i=e.pop();)if(t(i),r=i.children)for(n=0,a=r.length;n<a;++n)o.push(r[n])}while(o.length);return this},eachAfter:function(t){for(var e,r,n,a=this,i=[a],o=[];a=i.pop();)if(o.push(a),e=a.children)for(r=0,n=e.length;r<n;++r)i.push(e[r]);for(;a=o.pop();)t(a);return this},eachBefore:function(t){for(var e,r,n=this,a=[n];n=a.pop();)if(t(n),e=n.children)for(r=e.length-1;r>=0;--r)a.push(e[r]);return this},sum:function(t){return this.eachAfter((function(e){for(var r=+t(e.data)||0,n=e.children,a=n&&n.length;--a>=0;)r+=n[a].value;e.value=r}))},sort:function(t){return this.eachBefore((function(e){e.children&&e.children.sort(t)}))},path:function(t){for(var e=this,r=function(t,e){if(t===e)return t;var r=t.ancestors(),n=e.ancestors(),a=null;t=r.pop(),e=n.pop();for(;t===e;)a=t,t=r.pop(),e=n.pop();return a}(e,t),n=[e];e!==r;)e=e.parent,n.push(e);for(var a=n.length;t!==r;)n.splice(a,0,t),t=t.parent;return n},ancestors:function(){for(var t=this,e=[t];t=t.parent;)e.push(t);return e},descendants:function(){var t=[];return this.each((function(e){t.push(e)})),t},leaves:function(){var t=[];return this.eachBefore((function(e){e.children||t.push(e)})),t},links:function(){var t=this,e=[];return t.each((function(r){r!==t&&e.push({source:r.parent,target:r})})),e},copy:function(){return i(this).eachBefore(s)}};var u=Array.prototype.slice;function h(t){for(var e,r,n=0,a=(t=function(t){for(var e,r,n=t.length;n;)r=Math.random()*n--|0,e=t[n],t[n]=t[r],t[r]=e;return t}(u.call(t))).length,i=[];n<a;)e=t[n],r&&d(r,e)?++n:(r=m(i=f(i,e)),n=0);return r}function f(t,e){var r,n;if(g(e,t))return[e];for(r=0;r<t.length;++r)if(p(e,t[r])&&g(v(t[r],e),t))return[t[r],e];for(r=0;r<t.length-1;++r)for(n=r+1;n<t.length;++n)if(p(v(t[r],t[n]),e)&&p(v(t[r],e),t[n])&&p(v(t[n],e),t[r])&&g(y(t[r],t[n],e),t))return[t[r],t[n],e];throw new Error}function p(t,e){var r=t.r-e.r,n=e.x-t.x,a=e.y-t.y;return r<0||r*r<n*n+a*a}function d(t,e){var r=t.r-e.r+1e-6,n=e.x-t.x,a=e.y-t.y;return r>0&&r*r>n*n+a*a}function g(t,e){for(var r=0;r<e.length;++r)if(!d(t,e[r]))return!1;return!0}function m(t){switch(t.length){case 1:return{x:(e=t[0]).x,y:e.y,r:e.r};case 2:return v(t[0],t[1]);case 3:return y(t[0],t[1],t[2])}var e}function v(t,e){var r=t.x,n=t.y,a=t.r,i=e.x,o=e.y,s=e.r,l=i-r,c=o-n,u=s-a,h=Math.sqrt(l*l+c*c);return{x:(r+i+l/h*u)/2,y:(n+o+c/h*u)/2,r:(h+a+s)/2}}function y(t,e,r){var n=t.x,a=t.y,i=t.r,o=e.x,s=e.y,l=e.r,c=r.x,u=r.y,h=r.r,f=n-o,p=n-c,d=a-s,g=a-u,m=l-i,v=h-i,y=n*n+a*a-i*i,x=y-o*o-s*s+l*l,b=y-c*c-u*u+h*h,_=p*d-f*g,w=(d*b-g*x)/(2*_)-n,T=(g*m-d*v)/_,k=(p*x-f*b)/(2*_)-a,M=(f*v-p*m)/_,A=T*T+M*M-1,S=2*(i+w*T+k*M),E=w*w+k*k-i*i,C=-(A?(S+Math.sqrt(S*S-4*A*E))/(2*A):E/S);return{x:n+w+T*C,y:a+k+M*C,r:C}}function x(t,e,r){var n,a,i,o,s=t.x-e.x,l=t.y-e.y,c=s*s+l*l;c?(a=e.r+r.r,a*=a,o=t.r+r.r,a>(o*=o)?(n=(c+o-a)/(2*c),i=Math.sqrt(Math.max(0,o/c-n*n)),r.x=t.x-n*s-i*l,r.y=t.y-n*l+i*s):(n=(c+a-o)/(2*c),i=Math.sqrt(Math.max(0,a/c-n*n)),r.x=e.x+n*s-i*l,r.y=e.y+n*l+i*s)):(r.x=e.x+r.r,r.y=e.y)}function b(t,e){var r=t.r+e.r-1e-6,n=e.x-t.x,a=e.y-t.y;return r>0&&r*r>n*n+a*a}function _(t){var e=t._,r=t.next._,n=e.r+r.r,a=(e.x*r.r+r.x*e.r)/n,i=(e.y*r.r+r.y*e.r)/n;return a*a+i*i}function w(t){this._=t,this.next=null,this.previous=null}function T(t){if(!(a=t.length))return 0;var e,r,n,a,i,o,s,l,c,u,f;if((e=t[0]).x=0,e.y=0,!(a>1))return e.r;if(r=t[1],e.x=-r.r,r.x=e.r,r.y=0,!(a>2))return e.r+r.r;x(r,e,n=t[2]),e=new w(e),r=new w(r),n=new w(n),e.next=n.previous=r,r.next=e.previous=n,n.next=r.previous=e;t:for(s=3;s<a;++s){x(e._,r._,n=t[s]),n=new w(n),l=r.next,c=e.previous,u=r._.r,f=e._.r;do{if(u<=f){if(b(l._,n._)){r=l,e.next=r,r.previous=e,--s;continue t}u+=l._.r,l=l.next}else{if(b(c._,n._)){(e=c).next=r,r.previous=e,--s;continue t}f+=c._.r,c=c.previous}}while(l!==c.next);for(n.previous=e,n.next=r,e.next=r.previous=r=n,i=_(e);(n=n.next)!==r;)(o=_(n))<i&&(e=n,i=o);r=e.next}for(e=[r._],n=r;(n=n.next)!==r;)e.push(n._);for(n=h(e),s=0;s<a;++s)(e=t[s]).x-=n.x,e.y-=n.y;return n.r}function k(t){return null==t?null:M(t)}function M(t){if("function"!=typeof t)throw new Error;return t}function A(){return 0}function S(t){return function(){return t}}function E(t){return Math.sqrt(t.value)}function C(t){return function(e){e.children||(e.r=Math.max(0,+t(e)||0))}}function L(t,e){return function(r){if(n=r.children){var n,a,i,o=n.length,s=t(r)*e||0;if(s)for(a=0;a<o;++a)n[a].r+=s;if(i=T(n),s)for(a=0;a<o;++a)n[a].r-=s;r.r=i+s}}}function P(t){return function(e){var r=e.parent;e.r*=t,r&&(e.x=r.x+t*e.x,e.y=r.y+t*e.y)}}function I(t){t.x0=Math.round(t.x0),t.y0=Math.round(t.y0),t.x1=Math.round(t.x1),t.y1=Math.round(t.y1)}function z(t,e,r,n,a){for(var i,o=t.children,s=-1,l=o.length,c=t.value&&(n-e)/t.value;++s<l;)(i=o[s]).y0=r,i.y1=a,i.x0=e,i.x1=e+=i.value*c}var O={depth:-1},D={};function R(t){return t.id}function F(t){return t.parentId}function B(t,e){return t.parent===e.parent?1:2}function N(t){var e=t.children;return e?e[0]:t.t}function j(t){var e=t.children;return e?e[e.length-1]:t.t}function U(t,e,r){var n=r/(e.i-t.i);e.c-=n,e.s+=r,t.c+=n,e.z+=r,e.m+=r}function V(t,e,r){return t.a.parent===e.parent?t.a:r}function q(t,e){this._=t,this.parent=null,this.children=null,this.A=null,this.a=this,this.z=0,this.m=0,this.c=0,this.s=0,this.t=null,this.i=e}function H(t,e,r,n,a){for(var i,o=t.children,s=-1,l=o.length,c=t.value&&(a-r)/t.value;++s<l;)(i=o[s]).x0=e,i.x1=n,i.y0=r,i.y1=r+=i.value*c}q.prototype=Object.create(c.prototype);var G=(1+Math.sqrt(5))/2;function Y(t,e,r,n,a,i){for(var o,s,l,c,u,h,f,p,d,g,m,v=[],y=e.children,x=0,b=0,_=y.length,w=e.value;x<_;){l=a-r,c=i-n;do{u=y[b++].value}while(!u&&b<_);for(h=f=u,m=u*u*(g=Math.max(c/l,l/c)/(w*t)),d=Math.max(f/m,m/h);b<_;++b){if(u+=s=y[b].value,s<h&&(h=s),s>f&&(f=s),m=u*u*g,(p=Math.max(f/m,m/h))>d){u-=s;break}d=p}v.push(o={value:u,dice:l<c,children:y.slice(x,b)}),o.dice?z(o,r,n,a,w?n+=c*u/w:i):H(o,r,n,w?r+=l*u/w:a,i),w-=u,x=b}return v}var W=function t(e){function r(t,r,n,a,i){Y(e,t,r,n,a,i)}return r.ratio=function(e){return t((e=+e)>1?e:1)},r}(G);var Z=function t(e){function r(t,r,n,a,i){if((o=t._squarify)&&o.ratio===e)for(var o,s,l,c,u,h=-1,f=o.length,p=t.value;++h<f;){for(l=(s=o[h]).children,c=s.value=0,u=l.length;c<u;++c)s.value+=l[c].value;s.dice?z(s,r,n,a,n+=(i-n)*s.value/p):H(s,r,n,r+=(a-r)*s.value/p,i),p-=s.value}else t._squarify=o=Y(e,t,r,n,a,i),o.ratio=e}return r.ratio=function(e){return t((e=+e)>1?e:1)},r}(G);t.cluster=function(){var t=e,a=1,i=1,o=!1;function s(e){var s,l=0;e.eachAfter((function(e){var a=e.children;a?(e.x=function(t){return t.reduce(r,0)/t.length}(a),e.y=function(t){return 1+t.reduce(n,0)}(a)):(e.x=s?l+=t(e,s):0,e.y=0,s=e)}));var c=function(t){for(var e;e=t.children;)t=e[0];return t}(e),u=function(t){for(var e;e=t.children;)t=e[e.length-1];return t}(e),h=c.x-t(c,u)/2,f=u.x+t(u,c)/2;return e.eachAfter(o?function(t){t.x=(t.x-e.x)*a,t.y=(e.y-t.y)*i}:function(t){t.x=(t.x-h)/(f-h)*a,t.y=(1-(e.y?t.y/e.y:1))*i})}return s.separation=function(e){return arguments.length?(t=e,s):t},s.size=function(t){return arguments.length?(o=!1,a=+t[0],i=+t[1],s):o?null:[a,i]},s.nodeSize=function(t){return arguments.length?(o=!0,a=+t[0],i=+t[1],s):o?[a,i]:null},s},t.hierarchy=i,t.pack=function(){var t=null,e=1,r=1,n=A;function a(a){return a.x=e/2,a.y=r/2,t?a.eachBefore(C(t)).eachAfter(L(n,.5)).eachBefore(P(1)):a.eachBefore(C(E)).eachAfter(L(A,1)).eachAfter(L(n,a.r/Math.min(e,r))).eachBefore(P(Math.min(e,r)/(2*a.r))),a}return a.radius=function(e){return arguments.length?(t=k(e),a):t},a.size=function(t){return arguments.length?(e=+t[0],r=+t[1],a):[e,r]},a.padding=function(t){return arguments.length?(n="function"==typeof t?t:S(+t),a):n},a},t.packEnclose=h,t.packSiblings=function(t){return T(t),t},t.partition=function(){var t=1,e=1,r=0,n=!1;function a(a){var i=a.height+1;return a.x0=a.y0=r,a.x1=t,a.y1=e/i,a.eachBefore(function(t,e){return function(n){n.children&&z(n,n.x0,t*(n.depth+1)/e,n.x1,t*(n.depth+2)/e);var a=n.x0,i=n.y0,o=n.x1-r,s=n.y1-r;o<a&&(a=o=(a+o)/2),s<i&&(i=s=(i+s)/2),n.x0=a,n.y0=i,n.x1=o,n.y1=s}}(e,i)),n&&a.eachBefore(I),a}return a.round=function(t){return arguments.length?(n=!!t,a):n},a.size=function(r){return arguments.length?(t=+r[0],e=+r[1],a):[t,e]},a.padding=function(t){return arguments.length?(r=+t,a):r},a},t.stratify=function(){var t=R,e=F;function r(r){var n,a,i,o,s,u,h,f=r.length,p=new Array(f),d={};for(a=0;a<f;++a)n=r[a],s=p[a]=new c(n),null!=(u=t(n,a,r))&&(u+="")&&(d[h="$"+(s.id=u)]=h in d?D:s);for(a=0;a<f;++a)if(s=p[a],null!=(u=e(r[a],a,r))&&(u+="")){if(!(o=d["$"+u]))throw new Error("missing: "+u);if(o===D)throw new Error("ambiguous: "+u);o.children?o.children.push(s):o.children=[s],s.parent=o}else{if(i)throw new Error("multiple roots");i=s}if(!i)throw new Error("no root");if(i.parent=O,i.eachBefore((function(t){t.depth=t.parent.depth+1,--f})).eachBefore(l),i.parent=null,f>0)throw new Error("cycle");return i}return r.id=function(e){return arguments.length?(t=M(e),r):t},r.parentId=function(t){return arguments.length?(e=M(t),r):e},r},t.tree=function(){var t=B,e=1,r=1,n=null;function a(a){var l=function(t){for(var e,r,n,a,i,o=new q(t,0),s=[o];e=s.pop();)if(n=e._.children)for(e.children=new Array(i=n.length),a=i-1;a>=0;--a)s.push(r=e.children[a]=new q(n[a],a)),r.parent=e;return(o.parent=new q(null,0)).children=[o],o}(a);if(l.eachAfter(i),l.parent.m=-l.z,l.eachBefore(o),n)a.eachBefore(s);else{var c=a,u=a,h=a;a.eachBefore((function(t){t.x<c.x&&(c=t),t.x>u.x&&(u=t),t.depth>h.depth&&(h=t)}));var f=c===u?1:t(c,u)/2,p=f-c.x,d=e/(u.x+f+p),g=r/(h.depth||1);a.eachBefore((function(t){t.x=(t.x+p)*d,t.y=t.depth*g}))}return a}function i(e){var r=e.children,n=e.parent.children,a=e.i?n[e.i-1]:null;if(r){!function(t){for(var e,r=0,n=0,a=t.children,i=a.length;--i>=0;)(e=a[i]).z+=r,e.m+=r,r+=e.s+(n+=e.c)}(e);var i=(r[0].z+r[r.length-1].z)/2;a?(e.z=a.z+t(e._,a._),e.m=e.z-i):e.z=i}else a&&(e.z=a.z+t(e._,a._));e.parent.A=function(e,r,n){if(r){for(var a,i=e,o=e,s=r,l=i.parent.children[0],c=i.m,u=o.m,h=s.m,f=l.m;s=j(s),i=N(i),s&&i;)l=N(l),(o=j(o)).a=e,(a=s.z+h-i.z-c+t(s._,i._))>0&&(U(V(s,e,n),e,a),c+=a,u+=a),h+=s.m,c+=i.m,f+=l.m,u+=o.m;s&&!j(o)&&(o.t=s,o.m+=h-u),i&&!N(l)&&(l.t=i,l.m+=c-f,n=e)}return n}(e,a,e.parent.A||n[0])}function o(t){t._.x=t.z+t.parent.m,t.m+=t.parent.m}function s(t){t.x*=e,t.y=t.depth*r}return a.separation=function(e){return arguments.length?(t=e,a):t},a.size=function(t){return arguments.length?(n=!1,e=+t[0],r=+t[1],a):n?null:[e,r]},a.nodeSize=function(t){return arguments.length?(n=!0,e=+t[0],r=+t[1],a):n?[e,r]:null},a},t.treemap=function(){var t=W,e=!1,r=1,n=1,a=[0],i=A,o=A,s=A,l=A,c=A;function u(t){return t.x0=t.y0=0,t.x1=r,t.y1=n,t.eachBefore(h),a=[0],e&&t.eachBefore(I),t}function h(e){var r=a[e.depth],n=e.x0+r,u=e.y0+r,h=e.x1-r,f=e.y1-r;h<n&&(n=h=(n+h)/2),f<u&&(u=f=(u+f)/2),e.x0=n,e.y0=u,e.x1=h,e.y1=f,e.children&&(r=a[e.depth+1]=i(e)/2,n+=c(e)-r,u+=o(e)-r,(h-=s(e)-r)<n&&(n=h=(n+h)/2),(f-=l(e)-r)<u&&(u=f=(u+f)/2),t(e,n,u,h,f))}return u.round=function(t){return arguments.length?(e=!!t,u):e},u.size=function(t){return arguments.length?(r=+t[0],n=+t[1],u):[r,n]},u.tile=function(e){return arguments.length?(t=M(e),u):t},u.padding=function(t){return arguments.length?u.paddingInner(t).paddingOuter(t):u.paddingInner()},u.paddingInner=function(t){return arguments.length?(i="function"==typeof t?t:S(+t),u):i},u.paddingOuter=function(t){return arguments.length?u.paddingTop(t).paddingRight(t).paddingBottom(t).paddingLeft(t):u.paddingTop()},u.paddingTop=function(t){return arguments.length?(o="function"==typeof t?t:S(+t),u):o},u.paddingRight=function(t){return arguments.length?(s="function"==typeof t?t:S(+t),u):s},u.paddingBottom=function(t){return arguments.length?(l="function"==typeof t?t:S(+t),u):l},u.paddingLeft=function(t){return arguments.length?(c="function"==typeof t?t:S(+t),u):c},u},t.treemapBinary=function(t,e,r,n,a){var i,o,s=t.children,l=s.length,c=new Array(l+1);for(c[0]=o=i=0;i<l;++i)c[i+1]=o+=s[i].value;!function t(e,r,n,a,i,o,l){if(e>=r-1){var u=s[e];return u.x0=a,u.y0=i,u.x1=o,void(u.y1=l)}var h=c[e],f=n/2+h,p=e+1,d=r-1;for(;p<d;){var g=p+d>>>1;c[g]<f?p=g+1:d=g}f-c[p-1]<c[p]-f&&e+1<p&&--p;var m=c[p]-h,v=n-m;if(o-a>l-i){var y=(a*v+o*m)/n;t(e,p,m,a,i,y,l),t(p,r,v,y,i,o,l)}else{var x=(i*v+l*m)/n;t(e,p,m,a,i,o,x),t(p,r,v,a,x,o,l)}}(0,l,t.value,e,r,n,a)},t.treemapDice=z,t.treemapResquarify=Z,t.treemapSlice=H,t.treemapSliceDice=function(t,e,r,n,a){(1&t.depth?H:z)(t,e,r,n,a)},t.treemapSquarify=W,Object.defineProperty(t,"__esModule",{value:!0})}))},{}],160:[function(t,e,r){!function(n,a){"object"==typeof r&&"undefined"!=typeof e?a(r,t("d3-color")):a((n=n||self).d3=n.d3||{},n.d3)}(this,(function(t,e){"use strict";function r(t,e,r,n,a){var i=t*t,o=i*t;return((1-3*t+3*i-o)*e+(4-6*i+3*o)*r+(1+3*t+3*i-3*o)*n+o*a)/6}function n(t){var e=t.length-1;return function(n){var a=n<=0?n=0:n>=1?(n=1,e-1):Math.floor(n*e),i=t[a],o=t[a+1],s=a>0?t[a-1]:2*i-o,l=a<e-1?t[a+2]:2*o-i;return r((n-a/e)*e,s,i,o,l)}}function a(t){var e=t.length;return function(n){var a=Math.floor(((n%=1)<0?++n:n)*e),i=t[(a+e-1)%e],o=t[a%e],s=t[(a+1)%e],l=t[(a+2)%e];return r((n-a/e)*e,i,o,s,l)}}function i(t){return function(){return t}}function o(t,e){return function(r){return t+r*e}}function s(t,e){var r=e-t;return r?o(t,r>180||r<-180?r-360*Math.round(r/360):r):i(isNaN(t)?e:t)}function l(t){return 1==(t=+t)?c:function(e,r){return r-e?function(t,e,r){return t=Math.pow(t,r),e=Math.pow(e,r)-t,r=1/r,function(n){return Math.pow(t+n*e,r)}}(e,r,t):i(isNaN(e)?r:e)}}function c(t,e){var r=e-t;return r?o(t,r):i(isNaN(t)?e:t)}var u=function t(r){var n=l(r);function a(t,r){var a=n((t=e.rgb(t)).r,(r=e.rgb(r)).r),i=n(t.g,r.g),o=n(t.b,r.b),s=c(t.opacity,r.opacity);return function(e){return t.r=a(e),t.g=i(e),t.b=o(e),t.opacity=s(e),t+""}}return a.gamma=t,a}(1);function h(t){return function(r){var n,a,i=r.length,o=new Array(i),s=new Array(i),l=new Array(i);for(n=0;n<i;++n)a=e.rgb(r[n]),o[n]=a.r||0,s[n]=a.g||0,l[n]=a.b||0;return o=t(o),s=t(s),l=t(l),a.opacity=1,function(t){return a.r=o(t),a.g=s(t),a.b=l(t),a+""}}}var f=h(n),p=h(a);function d(t,e){e||(e=[]);var r,n=t?Math.min(e.length,t.length):0,a=e.slice();return function(i){for(r=0;r<n;++r)a[r]=t[r]*(1-i)+e[r]*i;return a}}function g(t){return ArrayBuffer.isView(t)&&!(t instanceof DataView)}function m(t,e){var r,n=e?e.length:0,a=t?Math.min(n,t.length):0,i=new Array(a),o=new Array(n);for(r=0;r<a;++r)i[r]=T(t[r],e[r]);for(;r<n;++r)o[r]=e[r];return function(t){for(r=0;r<a;++r)o[r]=i[r](t);return o}}function v(t,e){var r=new Date;return t=+t,e=+e,function(n){return r.setTime(t*(1-n)+e*n),r}}function y(t,e){return t=+t,e=+e,function(r){return t*(1-r)+e*r}}function x(t,e){var r,n={},a={};for(r in null!==t&&"object"==typeof t||(t={}),null!==e&&"object"==typeof e||(e={}),e)r in t?n[r]=T(t[r],e[r]):a[r]=e[r];return function(t){for(r in n)a[r]=n[r](t);return a}}var b=/[-+]?(?:\d+\.?\d*|\.?\d+)(?:[eE][-+]?\d+)?/g,_=new RegExp(b.source,"g");function w(t,e){var r,n,a,i=b.lastIndex=_.lastIndex=0,o=-1,s=[],l=[];for(t+="",e+="";(r=b.exec(t))&&(n=_.exec(e));)(a=n.index)>i&&(a=e.slice(i,a),s[o]?s[o]+=a:s[++o]=a),(r=r[0])===(n=n[0])?s[o]?s[o]+=n:s[++o]=n:(s[++o]=null,l.push({i:o,x:y(r,n)})),i=_.lastIndex;return i<e.length&&(a=e.slice(i),s[o]?s[o]+=a:s[++o]=a),s.length<2?l[0]?function(t){return function(e){return t(e)+""}}(l[0].x):function(t){return function(){return t}}(e):(e=l.length,function(t){for(var r,n=0;n<e;++n)s[(r=l[n]).i]=r.x(t);return s.join("")})}function T(t,r){var n,a=typeof r;return null==r||"boolean"===a?i(r):("number"===a?y:"string"===a?(n=e.color(r))?(r=n,u):w:r instanceof e.color?u:r instanceof Date?v:g(r)?d:Array.isArray(r)?m:"function"!=typeof r.valueOf&&"function"!=typeof r.toString||isNaN(r)?x:y)(t,r)}var k,M,A,S,E=180/Math.PI,C={translateX:0,translateY:0,rotate:0,skewX:0,scaleX:1,scaleY:1};function L(t,e,r,n,a,i){var o,s,l;return(o=Math.sqrt(t*t+e*e))&&(t/=o,e/=o),(l=t*r+e*n)&&(r-=t*l,n-=e*l),(s=Math.sqrt(r*r+n*n))&&(r/=s,n/=s,l/=s),t*n<e*r&&(t=-t,e=-e,l=-l,o=-o),{translateX:a,translateY:i,rotate:Math.atan2(e,t)*E,skewX:Math.atan(l)*E,scaleX:o,scaleY:s}}function P(t,e,r,n){function a(t){return t.length?t.pop()+" ":""}return function(i,o){var s=[],l=[];return i=t(i),o=t(o),function(t,n,a,i,o,s){if(t!==a||n!==i){var l=o.push("translate(",null,e,null,r);s.push({i:l-4,x:y(t,a)},{i:l-2,x:y(n,i)})}else(a||i)&&o.push("translate("+a+e+i+r)}(i.translateX,i.translateY,o.translateX,o.translateY,s,l),function(t,e,r,i){t!==e?(t-e>180?e+=360:e-t>180&&(t+=360),i.push({i:r.push(a(r)+"rotate(",null,n)-2,x:y(t,e)})):e&&r.push(a(r)+"rotate("+e+n)}(i.rotate,o.rotate,s,l),function(t,e,r,i){t!==e?i.push({i:r.push(a(r)+"skewX(",null,n)-2,x:y(t,e)}):e&&r.push(a(r)+"skewX("+e+n)}(i.skewX,o.skewX,s,l),function(t,e,r,n,i,o){if(t!==r||e!==n){var s=i.push(a(i)+"scale(",null,",",null,")");o.push({i:s-4,x:y(t,r)},{i:s-2,x:y(e,n)})}else 1===r&&1===n||i.push(a(i)+"scale("+r+","+n+")")}(i.scaleX,i.scaleY,o.scaleX,o.scaleY,s,l),i=o=null,function(t){for(var e,r=-1,n=l.length;++r<n;)s[(e=l[r]).i]=e.x(t);return s.join("")}}}var I=P((function(t){return"none"===t?C:(k||(k=document.createElement("DIV"),M=document.documentElement,A=document.defaultView),k.style.transform=t,t=A.getComputedStyle(M.appendChild(k),null).getPropertyValue("transform"),M.removeChild(k),L(+(t=t.slice(7,-1).split(","))[0],+t[1],+t[2],+t[3],+t[4],+t[5]))}),"px, ","px)","deg)"),z=P((function(t){return null==t?C:(S||(S=document.createElementNS("http://www.w3.org/2000/svg","g")),S.setAttribute("transform",t),(t=S.transform.baseVal.consolidate())?L((t=t.matrix).a,t.b,t.c,t.d,t.e,t.f):C)}),", ",")",")"),O=Math.SQRT2;function D(t){return((t=Math.exp(t))+1/t)/2}function R(t){return function(r,n){var a=t((r=e.hsl(r)).h,(n=e.hsl(n)).h),i=c(r.s,n.s),o=c(r.l,n.l),s=c(r.opacity,n.opacity);return function(t){return r.h=a(t),r.s=i(t),r.l=o(t),r.opacity=s(t),r+""}}}var F=R(s),B=R(c);function N(t){return function(r,n){var a=t((r=e.hcl(r)).h,(n=e.hcl(n)).h),i=c(r.c,n.c),o=c(r.l,n.l),s=c(r.opacity,n.opacity);return function(t){return r.h=a(t),r.c=i(t),r.l=o(t),r.opacity=s(t),r+""}}}var j=N(s),U=N(c);function V(t){return function r(n){function a(r,a){var i=t((r=e.cubehelix(r)).h,(a=e.cubehelix(a)).h),o=c(r.s,a.s),s=c(r.l,a.l),l=c(r.opacity,a.opacity);return function(t){return r.h=i(t),r.s=o(t),r.l=s(Math.pow(t,n)),r.opacity=l(t),r+""}}return n=+n,a.gamma=r,a}(1)}var q=V(s),H=V(c);t.interpolate=T,t.interpolateArray=function(t,e){return(g(e)?d:m)(t,e)},t.interpolateBasis=n,t.interpolateBasisClosed=a,t.interpolateCubehelix=q,t.interpolateCubehelixLong=H,t.interpolateDate=v,t.interpolateDiscrete=function(t){var e=t.length;return function(r){return t[Math.max(0,Math.min(e-1,Math.floor(r*e)))]}},t.interpolateHcl=j,t.interpolateHclLong=U,t.interpolateHsl=F,t.interpolateHslLong=B,t.interpolateHue=function(t,e){var r=s(+t,+e);return function(t){var e=r(t);return e-360*Math.floor(e/360)}},t.interpolateLab=function(t,r){var n=c((t=e.lab(t)).l,(r=e.lab(r)).l),a=c(t.a,r.a),i=c(t.b,r.b),o=c(t.opacity,r.opacity);return function(e){return t.l=n(e),t.a=a(e),t.b=i(e),t.opacity=o(e),t+""}},t.interpolateNumber=y,t.interpolateNumberArray=d,t.interpolateObject=x,t.interpolateRgb=u,t.interpolateRgbBasis=f,t.interpolateRgbBasisClosed=p,t.interpolateRound=function(t,e){return t=+t,e=+e,function(r){return Math.round(t*(1-r)+e*r)}},t.interpolateString=w,t.interpolateTransformCss=I,t.interpolateTransformSvg=z,t.interpolateZoom=function(t,e){var r,n,a=t[0],i=t[1],o=t[2],s=e[0],l=e[1],c=e[2],u=s-a,h=l-i,f=u*u+h*h;if(f<1e-12)n=Math.log(c/o)/O,r=function(t){return[a+t*u,i+t*h,o*Math.exp(O*t*n)]};else{var p=Math.sqrt(f),d=(c*c-o*o+4*f)/(2*o*2*p),g=(c*c-o*o-4*f)/(2*c*2*p),m=Math.log(Math.sqrt(d*d+1)-d),v=Math.log(Math.sqrt(g*g+1)-g);n=(v-m)/O,r=function(t){var e,r=t*n,s=D(m),l=o/(2*p)*(s*(e=O*r+m,((e=Math.exp(2*e))-1)/(e+1))-function(t){return((t=Math.exp(t))-1/t)/2}(m));return[a+l*u,i+l*h,o*s/D(O*r+m)]}}return r.duration=1e3*n,r},t.piecewise=function(t,e){for(var r=0,n=e.length-1,a=e[0],i=new Array(n<0?0:n);r<n;)i[r]=t(a,a=e[++r]);return function(t){var e=Math.max(0,Math.min(n-1,Math.floor(t*=n)));return i[e](t-e)}},t.quantize=function(t,e){for(var r=new Array(e),n=0;n<e;++n)r[n]=t(n/(e-1));return r},Object.defineProperty(t,"__esModule",{value:!0})}))},{"d3-color":156}],161:[function(t,e,r){!function(t,n){"object"==typeof r&&"undefined"!=typeof e?n(r):n((t=t||self).d3=t.d3||{})}(this,(function(t){"use strict";var e=Math.PI,r=2*e,n=r-1e-6;function a(){this._x0=this._y0=this._x1=this._y1=null,this._=""}function i(){return new a}a.prototype=i.prototype={constructor:a,moveTo:function(t,e){this._+="M"+(this._x0=this._x1=+t)+","+(this._y0=this._y1=+e)},closePath:function(){null!==this._x1&&(this._x1=this._x0,this._y1=this._y0,this._+="Z")},lineTo:function(t,e){this._+="L"+(this._x1=+t)+","+(this._y1=+e)},quadraticCurveTo:function(t,e,r,n){this._+="Q"+ +t+","+ +e+","+(this._x1=+r)+","+(this._y1=+n)},bezierCurveTo:function(t,e,r,n,a,i){this._+="C"+ +t+","+ +e+","+ +r+","+ +n+","+(this._x1=+a)+","+(this._y1=+i)},arcTo:function(t,r,n,a,i){t=+t,r=+r,n=+n,a=+a,i=+i;var o=this._x1,s=this._y1,l=n-t,c=a-r,u=o-t,h=s-r,f=u*u+h*h;if(i<0)throw new Error("negative radius: "+i);if(null===this._x1)this._+="M"+(this._x1=t)+","+(this._y1=r);else if(f>1e-6)if(Math.abs(h*l-c*u)>1e-6&&i){var p=n-o,d=a-s,g=l*l+c*c,m=p*p+d*d,v=Math.sqrt(g),y=Math.sqrt(f),x=i*Math.tan((e-Math.acos((g+f-m)/(2*v*y)))/2),b=x/y,_=x/v;Math.abs(b-1)>1e-6&&(this._+="L"+(t+b*u)+","+(r+b*h)),this._+="A"+i+","+i+",0,0,"+ +(h*p>u*d)+","+(this._x1=t+_*l)+","+(this._y1=r+_*c)}else this._+="L"+(this._x1=t)+","+(this._y1=r);else;},arc:function(t,a,i,o,s,l){t=+t,a=+a,l=!!l;var c=(i=+i)*Math.cos(o),u=i*Math.sin(o),h=t+c,f=a+u,p=1^l,d=l?o-s:s-o;if(i<0)throw new Error("negative radius: "+i);null===this._x1?this._+="M"+h+","+f:(Math.abs(this._x1-h)>1e-6||Math.abs(this._y1-f)>1e-6)&&(this._+="L"+h+","+f),i&&(d<0&&(d=d%r+r),d>n?this._+="A"+i+","+i+",0,1,"+p+","+(t-c)+","+(a-u)+"A"+i+","+i+",0,1,"+p+","+(this._x1=h)+","+(this._y1=f):d>1e-6&&(this._+="A"+i+","+i+",0,"+ +(d>=e)+","+p+","+(this._x1=t+i*Math.cos(s))+","+(this._y1=a+i*Math.sin(s))))},rect:function(t,e,r,n){this._+="M"+(this._x0=this._x1=+t)+","+(this._y0=this._y1=+e)+"h"+ +r+"v"+ +n+"h"+-r+"Z"},toString:function(){return this._}},t.path=i,Object.defineProperty(t,"__esModule",{value:!0})}))},{}],162:[function(t,e,r){!function(t,n){"object"==typeof r&&"undefined"!=typeof e?n(r):n((t=t||self).d3=t.d3||{})}(this,(function(t){"use strict";function e(t,e,r,n){if(isNaN(e)||isNaN(r))return t;var a,i,o,s,l,c,u,h,f,p=t._root,d={data:n},g=t._x0,m=t._y0,v=t._x1,y=t._y1;if(!p)return t._root=d,t;for(;p.length;)if((c=e>=(i=(g+v)/2))?g=i:v=i,(u=r>=(o=(m+y)/2))?m=o:y=o,a=p,!(p=p[h=u<<1|c]))return a[h]=d,t;if(s=+t._x.call(null,p.data),l=+t._y.call(null,p.data),e===s&&r===l)return d.next=p,a?a[h]=d:t._root=d,t;do{a=a?a[h]=new Array(4):t._root=new Array(4),(c=e>=(i=(g+v)/2))?g=i:v=i,(u=r>=(o=(m+y)/2))?m=o:y=o}while((h=u<<1|c)==(f=(l>=o)<<1|s>=i));return a[f]=p,a[h]=d,t}function r(t,e,r,n,a){this.node=t,this.x0=e,this.y0=r,this.x1=n,this.y1=a}function n(t){return t[0]}function a(t){return t[1]}function i(t,e,r){var i=new o(null==e?n:e,null==r?a:r,NaN,NaN,NaN,NaN);return null==t?i:i.addAll(t)}function o(t,e,r,n,a,i){this._x=t,this._y=e,this._x0=r,this._y0=n,this._x1=a,this._y1=i,this._root=void 0}function s(t){for(var e={data:t.data},r=e;t=t.next;)r=r.next={data:t.data};return e}var l=i.prototype=o.prototype;l.copy=function(){var t,e,r=new o(this._x,this._y,this._x0,this._y0,this._x1,this._y1),n=this._root;if(!n)return r;if(!n.length)return r._root=s(n),r;for(t=[{source:n,target:r._root=new Array(4)}];n=t.pop();)for(var a=0;a<4;++a)(e=n.source[a])&&(e.length?t.push({source:e,target:n.target[a]=new Array(4)}):n.target[a]=s(e));return r},l.add=function(t){var r=+this._x.call(null,t),n=+this._y.call(null,t);return e(this.cover(r,n),r,n,t)},l.addAll=function(t){var r,n,a,i,o=t.length,s=new Array(o),l=new Array(o),c=1/0,u=1/0,h=-1/0,f=-1/0;for(n=0;n<o;++n)isNaN(a=+this._x.call(null,r=t[n]))||isNaN(i=+this._y.call(null,r))||(s[n]=a,l[n]=i,a<c&&(c=a),a>h&&(h=a),i<u&&(u=i),i>f&&(f=i));if(c>h||u>f)return this;for(this.cover(c,u).cover(h,f),n=0;n<o;++n)e(this,s[n],l[n],t[n]);return this},l.cover=function(t,e){if(isNaN(t=+t)||isNaN(e=+e))return this;var r=this._x0,n=this._y0,a=this._x1,i=this._y1;if(isNaN(r))a=(r=Math.floor(t))+1,i=(n=Math.floor(e))+1;else{for(var o,s,l=a-r,c=this._root;r>t||t>=a||n>e||e>=i;)switch(s=(e<n)<<1|t<r,(o=new Array(4))[s]=c,c=o,l*=2,s){case 0:a=r+l,i=n+l;break;case 1:r=a-l,i=n+l;break;case 2:a=r+l,n=i-l;break;case 3:r=a-l,n=i-l}this._root&&this._root.length&&(this._root=c)}return this._x0=r,this._y0=n,this._x1=a,this._y1=i,this},l.data=function(){var t=[];return this.visit((function(e){if(!e.length)do{t.push(e.data)}while(e=e.next)})),t},l.extent=function(t){return arguments.length?this.cover(+t[0][0],+t[0][1]).cover(+t[1][0],+t[1][1]):isNaN(this._x0)?void 0:[[this._x0,this._y0],[this._x1,this._y1]]},l.find=function(t,e,n){var a,i,o,s,l,c,u,h=this._x0,f=this._y0,p=this._x1,d=this._y1,g=[],m=this._root;for(m&&g.push(new r(m,h,f,p,d)),null==n?n=1/0:(h=t-n,f=e-n,p=t+n,d=e+n,n*=n);c=g.pop();)if(!(!(m=c.node)||(i=c.x0)>p||(o=c.y0)>d||(s=c.x1)<h||(l=c.y1)<f))if(m.length){var v=(i+s)/2,y=(o+l)/2;g.push(new r(m[3],v,y,s,l),new r(m[2],i,y,v,l),new r(m[1],v,o,s,y),new r(m[0],i,o,v,y)),(u=(e>=y)<<1|t>=v)&&(c=g[g.length-1],g[g.length-1]=g[g.length-1-u],g[g.length-1-u]=c)}else{var x=t-+this._x.call(null,m.data),b=e-+this._y.call(null,m.data),_=x*x+b*b;if(_<n){var w=Math.sqrt(n=_);h=t-w,f=e-w,p=t+w,d=e+w,a=m.data}}return a},l.remove=function(t){if(isNaN(i=+this._x.call(null,t))||isNaN(o=+this._y.call(null,t)))return this;var e,r,n,a,i,o,s,l,c,u,h,f,p=this._root,d=this._x0,g=this._y0,m=this._x1,v=this._y1;if(!p)return this;if(p.length)for(;;){if((c=i>=(s=(d+m)/2))?d=s:m=s,(u=o>=(l=(g+v)/2))?g=l:v=l,e=p,!(p=p[h=u<<1|c]))return this;if(!p.length)break;(e[h+1&3]||e[h+2&3]||e[h+3&3])&&(r=e,f=h)}for(;p.data!==t;)if(n=p,!(p=p.next))return this;return(a=p.next)&&delete p.next,n?(a?n.next=a:delete n.next,this):e?(a?e[h]=a:delete e[h],(p=e[0]||e[1]||e[2]||e[3])&&p===(e[3]||e[2]||e[1]||e[0])&&!p.length&&(r?r[f]=p:this._root=p),this):(this._root=a,this)},l.removeAll=function(t){for(var e=0,r=t.length;e<r;++e)this.remove(t[e]);return this},l.root=function(){return this._root},l.size=function(){var t=0;return this.visit((function(e){if(!e.length)do{++t}while(e=e.next)})),t},l.visit=function(t){var e,n,a,i,o,s,l=[],c=this._root;for(c&&l.push(new r(c,this._x0,this._y0,this._x1,this._y1));e=l.pop();)if(!t(c=e.node,a=e.x0,i=e.y0,o=e.x1,s=e.y1)&&c.length){var u=(a+o)/2,h=(i+s)/2;(n=c[3])&&l.push(new r(n,u,h,o,s)),(n=c[2])&&l.push(new r(n,a,h,u,s)),(n=c[1])&&l.push(new r(n,u,i,o,h)),(n=c[0])&&l.push(new r(n,a,i,u,h))}return this},l.visitAfter=function(t){var e,n=[],a=[];for(this._root&&n.push(new r(this._root,this._x0,this._y0,this._x1,this._y1));e=n.pop();){var i=e.node;if(i.length){var o,s=e.x0,l=e.y0,c=e.x1,u=e.y1,h=(s+c)/2,f=(l+u)/2;(o=i[0])&&n.push(new r(o,s,l,h,f)),(o=i[1])&&n.push(new r(o,h,l,c,f)),(o=i[2])&&n.push(new r(o,s,f,h,u)),(o=i[3])&&n.push(new r(o,h,f,c,u))}a.push(e)}for(;e=a.pop();)t(e.node,e.x0,e.y0,e.x1,e.y1);return this},l.x=function(t){return arguments.length?(this._x=t,this):this._x},l.y=function(t){return arguments.length?(this._y=t,this):this._y},t.quadtree=i,Object.defineProperty(t,"__esModule",{value:!0})}))},{}],163:[function(t,e,r){!function(n,a){"object"==typeof r&&"undefined"!=typeof e?a(r,t("d3-path")):a((n=n||self).d3=n.d3||{},n.d3)}(this,(function(t,e){"use strict";function r(t){return function(){return t}}var n=Math.abs,a=Math.atan2,i=Math.cos,o=Math.max,s=Math.min,l=Math.sin,c=Math.sqrt,u=Math.PI,h=u/2,f=2*u;function p(t){return t>1?0:t<-1?u:Math.acos(t)}function d(t){return t>=1?h:t<=-1?-h:Math.asin(t)}function g(t){return t.innerRadius}function m(t){return t.outerRadius}function v(t){return t.startAngle}function y(t){return t.endAngle}function x(t){return t&&t.padAngle}function b(t,e,r,n,a,i,o,s){var l=r-t,c=n-e,u=o-a,h=s-i,f=h*l-u*c;if(!(f*f<1e-12))return[t+(f=(u*(e-i)-h*(t-a))/f)*l,e+f*c]}function _(t,e,r,n,a,i,s){var l=t-r,u=e-n,h=(s?i:-i)/c(l*l+u*u),f=h*u,p=-h*l,d=t+f,g=e+p,m=r+f,v=n+p,y=(d+m)/2,x=(g+v)/2,b=m-d,_=v-g,w=b*b+_*_,T=a-i,k=d*v-m*g,M=(_<0?-1:1)*c(o(0,T*T*w-k*k)),A=(k*_-b*M)/w,S=(-k*b-_*M)/w,E=(k*_+b*M)/w,C=(-k*b+_*M)/w,L=A-y,P=S-x,I=E-y,z=C-x;return L*L+P*P>I*I+z*z&&(A=E,S=C),{cx:A,cy:S,x01:-f,y01:-p,x11:A*(a/T-1),y11:S*(a/T-1)}}function w(t){this._context=t}function T(t){return new w(t)}function k(t){return t[0]}function M(t){return t[1]}function A(){var t=k,n=M,a=r(!0),i=null,o=T,s=null;function l(r){var l,c,u,h=r.length,f=!1;for(null==i&&(s=o(u=e.path())),l=0;l<=h;++l)!(l<h&&a(c=r[l],l,r))===f&&((f=!f)?s.lineStart():s.lineEnd()),f&&s.point(+t(c,l,r),+n(c,l,r));if(u)return s=null,u+""||null}return l.x=function(e){return arguments.length?(t="function"==typeof e?e:r(+e),l):t},l.y=function(t){return arguments.length?(n="function"==typeof t?t:r(+t),l):n},l.defined=function(t){return arguments.length?(a="function"==typeof t?t:r(!!t),l):a},l.curve=function(t){return arguments.length?(o=t,null!=i&&(s=o(i)),l):o},l.context=function(t){return arguments.length?(null==t?i=s=null:s=o(i=t),l):i},l}function S(){var t=k,n=null,a=r(0),i=M,o=r(!0),s=null,l=T,c=null;function u(r){var u,h,f,p,d,g=r.length,m=!1,v=new Array(g),y=new Array(g);for(null==s&&(c=l(d=e.path())),u=0;u<=g;++u){if(!(u<g&&o(p=r[u],u,r))===m)if(m=!m)h=u,c.areaStart(),c.lineStart();else{for(c.lineEnd(),c.lineStart(),f=u-1;f>=h;--f)c.point(v[f],y[f]);c.lineEnd(),c.areaEnd()}m&&(v[u]=+t(p,u,r),y[u]=+a(p,u,r),c.point(n?+n(p,u,r):v[u],i?+i(p,u,r):y[u]))}if(d)return c=null,d+""||null}function h(){return A().defined(o).curve(l).context(s)}return u.x=function(e){return arguments.length?(t="function"==typeof e?e:r(+e),n=null,u):t},u.x0=function(e){return arguments.length?(t="function"==typeof e?e:r(+e),u):t},u.x1=function(t){return arguments.length?(n=null==t?null:"function"==typeof t?t:r(+t),u):n},u.y=function(t){return arguments.length?(a="function"==typeof t?t:r(+t),i=null,u):a},u.y0=function(t){return arguments.length?(a="function"==typeof t?t:r(+t),u):a},u.y1=function(t){return arguments.length?(i=null==t?null:"function"==typeof t?t:r(+t),u):i},u.lineX0=u.lineY0=function(){return h().x(t).y(a)},u.lineY1=function(){return h().x(t).y(i)},u.lineX1=function(){return h().x(n).y(a)},u.defined=function(t){return arguments.length?(o="function"==typeof t?t:r(!!t),u):o},u.curve=function(t){return arguments.length?(l=t,null!=s&&(c=l(s)),u):l},u.context=function(t){return arguments.length?(null==t?s=c=null:c=l(s=t),u):s},u}function E(t,e){return e<t?-1:e>t?1:e>=t?0:NaN}function C(t){return t}w.prototype={areaStart:function(){this._line=0},areaEnd:function(){this._line=NaN},lineStart:function(){this._point=0},lineEnd:function(){(this._line||0!==this._line&&1===this._point)&&this._context.closePath(),this._line=1-this._line},point:function(t,e){switch(t=+t,e=+e,this._point){case 0:this._point=1,this._line?this._context.lineTo(t,e):this._context.moveTo(t,e);break;case 1:this._point=2;default:this._context.lineTo(t,e)}}};var L=I(T);function P(t){this._curve=t}function I(t){function e(e){return new P(t(e))}return e._curve=t,e}function z(t){var e=t.curve;return t.angle=t.x,delete t.x,t.radius=t.y,delete t.y,t.curve=function(t){return arguments.length?e(I(t)):e()._curve},t}function O(){return z(A().curve(L))}function D(){var t=S().curve(L),e=t.curve,r=t.lineX0,n=t.lineX1,a=t.lineY0,i=t.lineY1;return t.angle=t.x,delete t.x,t.startAngle=t.x0,delete t.x0,t.endAngle=t.x1,delete t.x1,t.radius=t.y,delete t.y,t.innerRadius=t.y0,delete t.y0,t.outerRadius=t.y1,delete t.y1,t.lineStartAngle=function(){return z(r())},delete t.lineX0,t.lineEndAngle=function(){return z(n())},delete t.lineX1,t.lineInnerRadius=function(){return z(a())},delete t.lineY0,t.lineOuterRadius=function(){return z(i())},delete t.lineY1,t.curve=function(t){return arguments.length?e(I(t)):e()._curve},t}function R(t,e){return[(e=+e)*Math.cos(t-=Math.PI/2),e*Math.sin(t)]}P.prototype={areaStart:function(){this._curve.areaStart()},areaEnd:function(){this._curve.areaEnd()},lineStart:function(){this._curve.lineStart()},lineEnd:function(){this._curve.lineEnd()},point:function(t,e){this._curve.point(e*Math.sin(t),e*-Math.cos(t))}};var F=Array.prototype.slice;function B(t){return t.source}function N(t){return t.target}function j(t){var n=B,a=N,i=k,o=M,s=null;function l(){var r,l=F.call(arguments),c=n.apply(this,l),u=a.apply(this,l);if(s||(s=r=e.path()),t(s,+i.apply(this,(l[0]=c,l)),+o.apply(this,l),+i.apply(this,(l[0]=u,l)),+o.apply(this,l)),r)return s=null,r+""||null}return l.source=function(t){return arguments.length?(n=t,l):n},l.target=function(t){return arguments.length?(a=t,l):a},l.x=function(t){return arguments.length?(i="function"==typeof t?t:r(+t),l):i},l.y=function(t){return arguments.length?(o="function"==typeof t?t:r(+t),l):o},l.context=function(t){return arguments.length?(s=null==t?null:t,l):s},l}function U(t,e,r,n,a){t.moveTo(e,r),t.bezierCurveTo(e=(e+n)/2,r,e,a,n,a)}function V(t,e,r,n,a){t.moveTo(e,r),t.bezierCurveTo(e,r=(r+a)/2,n,r,n,a)}function q(t,e,r,n,a){var i=R(e,r),o=R(e,r=(r+a)/2),s=R(n,r),l=R(n,a);t.moveTo(i[0],i[1]),t.bezierCurveTo(o[0],o[1],s[0],s[1],l[0],l[1])}var H={draw:function(t,e){var r=Math.sqrt(e/u);t.moveTo(r,0),t.arc(0,0,r,0,f)}},G={draw:function(t,e){var r=Math.sqrt(e/5)/2;t.moveTo(-3*r,-r),t.lineTo(-r,-r),t.lineTo(-r,-3*r),t.lineTo(r,-3*r),t.lineTo(r,-r),t.lineTo(3*r,-r),t.lineTo(3*r,r),t.lineTo(r,r),t.lineTo(r,3*r),t.lineTo(-r,3*r),t.lineTo(-r,r),t.lineTo(-3*r,r),t.closePath()}},Y=Math.sqrt(1/3),W=2*Y,Z={draw:function(t,e){var r=Math.sqrt(e/W),n=r*Y;t.moveTo(0,-r),t.lineTo(n,0),t.lineTo(0,r),t.lineTo(-n,0),t.closePath()}},X=Math.sin(u/10)/Math.sin(7*u/10),J=Math.sin(f/10)*X,K=-Math.cos(f/10)*X,Q={draw:function(t,e){var r=Math.sqrt(.8908130915292852*e),n=J*r,a=K*r;t.moveTo(0,-r),t.lineTo(n,a);for(var i=1;i<5;++i){var o=f*i/5,s=Math.cos(o),l=Math.sin(o);t.lineTo(l*r,-s*r),t.lineTo(s*n-l*a,l*n+s*a)}t.closePath()}},$={draw:function(t,e){var r=Math.sqrt(e),n=-r/2;t.rect(n,n,r,r)}},tt=Math.sqrt(3),et={draw:function(t,e){var r=-Math.sqrt(e/(3*tt));t.moveTo(0,2*r),t.lineTo(-tt*r,-r),t.lineTo(tt*r,-r),t.closePath()}},rt=-.5,nt=Math.sqrt(3)/2,at=1/Math.sqrt(12),it=3*(at/2+1),ot={draw:function(t,e){var r=Math.sqrt(e/it),n=r/2,a=r*at,i=n,o=r*at+r,s=-i,l=o;t.moveTo(n,a),t.lineTo(i,o),t.lineTo(s,l),t.lineTo(rt*n-nt*a,nt*n+rt*a),t.lineTo(rt*i-nt*o,nt*i+rt*o),t.lineTo(rt*s-nt*l,nt*s+rt*l),t.lineTo(rt*n+nt*a,rt*a-nt*n),t.lineTo(rt*i+nt*o,rt*o-nt*i),t.lineTo(rt*s+nt*l,rt*l-nt*s),t.closePath()}},st=[H,G,Z,$,Q,et,ot];function lt(){}function ct(t,e,r){t._context.bezierCurveTo((2*t._x0+t._x1)/3,(2*t._y0+t._y1)/3,(t._x0+2*t._x1)/3,(t._y0+2*t._y1)/3,(t._x0+4*t._x1+e)/6,(t._y0+4*t._y1+r)/6)}function ut(t){this._context=t}function ht(t){this._context=t}function ft(t){this._context=t}function pt(t,e){this._basis=new ut(t),this._beta=e}ut.prototype={areaStart:function(){this._line=0},areaEnd:function(){this._line=NaN},lineStart:function(){this._x0=this._x1=this._y0=this._y1=NaN,this._point=0},lineEnd:function(){switch(this._point){case 3:ct(this,this._x1,this._y1);case 2:this._context.lineTo(this._x1,this._y1)}(this._line||0!==this._line&&1===this._point)&&this._context.closePath(),this._line=1-this._line},point:function(t,e){switch(t=+t,e=+e,this._point){case 0:this._point=1,this._line?this._context.lineTo(t,e):this._context.moveTo(t,e);break;case 1:this._point=2;break;case 2:this._point=3,this._context.lineTo((5*this._x0+this._x1)/6,(5*this._y0+this._y1)/6);default:ct(this,t,e)}this._x0=this._x1,this._x1=t,this._y0=this._y1,this._y1=e}},ht.prototype={areaStart:lt,areaEnd:lt,lineStart:function(){this._x0=this._x1=this._x2=this._x3=this._x4=this._y0=this._y1=this._y2=this._y3=this._y4=NaN,this._point=0},lineEnd:function(){switch(this._point){case 1:this._context.moveTo(this._x2,this._y2),this._context.closePath();break;case 2:this._context.moveTo((this._x2+2*this._x3)/3,(this._y2+2*this._y3)/3),this._context.lineTo((this._x3+2*this._x2)/3,(this._y3+2*this._y2)/3),this._context.closePath();break;case 3:this.point(this._x2,this._y2),this.point(this._x3,this._y3),this.point(this._x4,this._y4)}},point:function(t,e){switch(t=+t,e=+e,this._point){case 0:this._point=1,this._x2=t,this._y2=e;break;case 1:this._point=2,this._x3=t,this._y3=e;break;case 2:this._point=3,this._x4=t,this._y4=e,this._context.moveTo((this._x0+4*this._x1+t)/6,(this._y0+4*this._y1+e)/6);break;default:ct(this,t,e)}this._x0=this._x1,this._x1=t,this._y0=this._y1,this._y1=e}},ft.prototype={areaStart:function(){this._line=0},areaEnd:function(){this._line=NaN},lineStart:function(){this._x0=this._x1=this._y0=this._y1=NaN,this._point=0},lineEnd:function(){(this._line||0!==this._line&&3===this._point)&&this._context.closePath(),this._line=1-this._line},point:function(t,e){switch(t=+t,e=+e,this._point){case 0:this._point=1;break;case 1:this._point=2;break;case 2:this._point=3;var r=(this._x0+4*this._x1+t)/6,n=(this._y0+4*this._y1+e)/6;this._line?this._context.lineTo(r,n):this._context.moveTo(r,n);break;case 3:this._point=4;default:ct(this,t,e)}this._x0=this._x1,this._x1=t,this._y0=this._y1,this._y1=e}},pt.prototype={lineStart:function(){this._x=[],this._y=[],this._basis.lineStart()},lineEnd:function(){var t=this._x,e=this._y,r=t.length-1;if(r>0)for(var n,a=t[0],i=e[0],o=t[r]-a,s=e[r]-i,l=-1;++l<=r;)n=l/r,this._basis.point(this._beta*t[l]+(1-this._beta)*(a+n*o),this._beta*e[l]+(1-this._beta)*(i+n*s));this._x=this._y=null,this._basis.lineEnd()},point:function(t,e){this._x.push(+t),this._y.push(+e)}};var dt=function t(e){function r(t){return 1===e?new ut(t):new pt(t,e)}return r.beta=function(e){return t(+e)},r}(.85);function gt(t,e,r){t._context.bezierCurveTo(t._x1+t._k*(t._x2-t._x0),t._y1+t._k*(t._y2-t._y0),t._x2+t._k*(t._x1-e),t._y2+t._k*(t._y1-r),t._x2,t._y2)}function mt(t,e){this._context=t,this._k=(1-e)/6}mt.prototype={areaStart:function(){this._line=0},areaEnd:function(){this._line=NaN},lineStart:function(){this._x0=this._x1=this._x2=this._y0=this._y1=this._y2=NaN,this._point=0},lineEnd:function(){switch(this._point){case 2:this._context.lineTo(this._x2,this._y2);break;case 3:gt(this,this._x1,this._y1)}(this._line||0!==this._line&&1===this._point)&&this._context.closePath(),this._line=1-this._line},point:function(t,e){switch(t=+t,e=+e,this._point){case 0:this._point=1,this._line?this._context.lineTo(t,e):this._context.moveTo(t,e);break;case 1:this._point=2,this._x1=t,this._y1=e;break;case 2:this._point=3;default:gt(this,t,e)}this._x0=this._x1,this._x1=this._x2,this._x2=t,this._y0=this._y1,this._y1=this._y2,this._y2=e}};var vt=function t(e){function r(t){return new mt(t,e)}return r.tension=function(e){return t(+e)},r}(0);function yt(t,e){this._context=t,this._k=(1-e)/6}yt.prototype={areaStart:lt,areaEnd:lt,lineStart:function(){this._x0=this._x1=this._x2=this._x3=this._x4=this._x5=this._y0=this._y1=this._y2=this._y3=this._y4=this._y5=NaN,this._point=0},lineEnd:function(){switch(this._point){case 1:this._context.moveTo(this._x3,this._y3),this._context.closePath();break;case 2:this._context.lineTo(this._x3,this._y3),this._context.closePath();break;case 3:this.point(this._x3,this._y3),this.point(this._x4,this._y4),this.point(this._x5,this._y5)}},point:function(t,e){switch(t=+t,e=+e,this._point){case 0:this._point=1,this._x3=t,this._y3=e;break;case 1:this._point=2,this._context.moveTo(this._x4=t,this._y4=e);break;case 2:this._point=3,this._x5=t,this._y5=e;break;default:gt(this,t,e)}this._x0=this._x1,this._x1=this._x2,this._x2=t,this._y0=this._y1,this._y1=this._y2,this._y2=e}};var xt=function t(e){function r(t){return new yt(t,e)}return r.tension=function(e){return t(+e)},r}(0);function bt(t,e){this._context=t,this._k=(1-e)/6}bt.prototype={areaStart:function(){this._line=0},areaEnd:function(){this._line=NaN},lineStart:function(){this._x0=this._x1=this._x2=this._y0=this._y1=this._y2=NaN,this._point=0},lineEnd:function(){(this._line||0!==this._line&&3===this._point)&&this._context.closePath(),this._line=1-this._line},point:function(t,e){switch(t=+t,e=+e,this._point){case 0:this._point=1;break;case 1:this._point=2;break;case 2:this._point=3,this._line?this._context.lineTo(this._x2,this._y2):this._context.moveTo(this._x2,this._y2);break;case 3:this._point=4;default:gt(this,t,e)}this._x0=this._x1,this._x1=this._x2,this._x2=t,this._y0=this._y1,this._y1=this._y2,this._y2=e}};var _t=function t(e){function r(t){return new bt(t,e)}return r.tension=function(e){return t(+e)},r}(0);function wt(t,e,r){var n=t._x1,a=t._y1,i=t._x2,o=t._y2;if(t._l01_a>1e-12){var s=2*t._l01_2a+3*t._l01_a*t._l12_a+t._l12_2a,l=3*t._l01_a*(t._l01_a+t._l12_a);n=(n*s-t._x0*t._l12_2a+t._x2*t._l01_2a)/l,a=(a*s-t._y0*t._l12_2a+t._y2*t._l01_2a)/l}if(t._l23_a>1e-12){var c=2*t._l23_2a+3*t._l23_a*t._l12_a+t._l12_2a,u=3*t._l23_a*(t._l23_a+t._l12_a);i=(i*c+t._x1*t._l23_2a-e*t._l12_2a)/u,o=(o*c+t._y1*t._l23_2a-r*t._l12_2a)/u}t._context.bezierCurveTo(n,a,i,o,t._x2,t._y2)}function Tt(t,e){this._context=t,this._alpha=e}Tt.prototype={areaStart:function(){this._line=0},areaEnd:function(){this._line=NaN},lineStart:function(){this._x0=this._x1=this._x2=this._y0=this._y1=this._y2=NaN,this._l01_a=this._l12_a=this._l23_a=this._l01_2a=this._l12_2a=this._l23_2a=this._point=0},lineEnd:function(){switch(this._point){case 2:this._context.lineTo(this._x2,this._y2);break;case 3:this.point(this._x2,this._y2)}(this._line||0!==this._line&&1===this._point)&&this._context.closePath(),this._line=1-this._line},point:function(t,e){if(t=+t,e=+e,this._point){var r=this._x2-t,n=this._y2-e;this._l23_a=Math.sqrt(this._l23_2a=Math.pow(r*r+n*n,this._alpha))}switch(this._point){case 0:this._point=1,this._line?this._context.lineTo(t,e):this._context.moveTo(t,e);break;case 1:this._point=2;break;case 2:this._point=3;default:wt(this,t,e)}this._l01_a=this._l12_a,this._l12_a=this._l23_a,this._l01_2a=this._l12_2a,this._l12_2a=this._l23_2a,this._x0=this._x1,this._x1=this._x2,this._x2=t,this._y0=this._y1,this._y1=this._y2,this._y2=e}};var kt=function t(e){function r(t){return e?new Tt(t,e):new mt(t,0)}return r.alpha=function(e){return t(+e)},r}(.5);function Mt(t,e){this._context=t,this._alpha=e}Mt.prototype={areaStart:lt,areaEnd:lt,lineStart:function(){this._x0=this._x1=this._x2=this._x3=this._x4=this._x5=this._y0=this._y1=this._y2=this._y3=this._y4=this._y5=NaN,this._l01_a=this._l12_a=this._l23_a=this._l01_2a=this._l12_2a=this._l23_2a=this._point=0},lineEnd:function(){switch(this._point){case 1:this._context.moveTo(this._x3,this._y3),this._context.closePath();break;case 2:this._context.lineTo(this._x3,this._y3),this._context.closePath();break;case 3:this.point(this._x3,this._y3),this.point(this._x4,this._y4),this.point(this._x5,this._y5)}},point:function(t,e){if(t=+t,e=+e,this._point){var r=this._x2-t,n=this._y2-e;this._l23_a=Math.sqrt(this._l23_2a=Math.pow(r*r+n*n,this._alpha))}switch(this._point){case 0:this._point=1,this._x3=t,this._y3=e;break;case 1:this._point=2,this._context.moveTo(this._x4=t,this._y4=e);break;case 2:this._point=3,this._x5=t,this._y5=e;break;default:wt(this,t,e)}this._l01_a=this._l12_a,this._l12_a=this._l23_a,this._l01_2a=this._l12_2a,this._l12_2a=this._l23_2a,this._x0=this._x1,this._x1=this._x2,this._x2=t,this._y0=this._y1,this._y1=this._y2,this._y2=e}};var At=function t(e){function r(t){return e?new Mt(t,e):new yt(t,0)}return r.alpha=function(e){return t(+e)},r}(.5);function St(t,e){this._context=t,this._alpha=e}St.prototype={areaStart:function(){this._line=0},areaEnd:function(){this._line=NaN},lineStart:function(){this._x0=this._x1=this._x2=this._y0=this._y1=this._y2=NaN,this._l01_a=this._l12_a=this._l23_a=this._l01_2a=this._l12_2a=this._l23_2a=this._point=0},lineEnd:function(){(this._line||0!==this._line&&3===this._point)&&this._context.closePath(),this._line=1-this._line},point:function(t,e){if(t=+t,e=+e,this._point){var r=this._x2-t,n=this._y2-e;this._l23_a=Math.sqrt(this._l23_2a=Math.pow(r*r+n*n,this._alpha))}switch(this._point){case 0:this._point=1;break;case 1:this._point=2;break;case 2:this._point=3,this._line?this._context.lineTo(this._x2,this._y2):this._context.moveTo(this._x2,this._y2);break;case 3:this._point=4;default:wt(this,t,e)}this._l01_a=this._l12_a,this._l12_a=this._l23_a,this._l01_2a=this._l12_2a,this._l12_2a=this._l23_2a,this._x0=this._x1,this._x1=this._x2,this._x2=t,this._y0=this._y1,this._y1=this._y2,this._y2=e}};var Et=function t(e){function r(t){return e?new St(t,e):new bt(t,0)}return r.alpha=function(e){return t(+e)},r}(.5);function Ct(t){this._context=t}function Lt(t){return t<0?-1:1}function Pt(t,e,r){var n=t._x1-t._x0,a=e-t._x1,i=(t._y1-t._y0)/(n||a<0&&-0),o=(r-t._y1)/(a||n<0&&-0),s=(i*a+o*n)/(n+a);return(Lt(i)+Lt(o))*Math.min(Math.abs(i),Math.abs(o),.5*Math.abs(s))||0}function It(t,e){var r=t._x1-t._x0;return r?(3*(t._y1-t._y0)/r-e)/2:e}function zt(t,e,r){var n=t._x0,a=t._y0,i=t._x1,o=t._y1,s=(i-n)/3;t._context.bezierCurveTo(n+s,a+s*e,i-s,o-s*r,i,o)}function Ot(t){this._context=t}function Dt(t){this._context=new Rt(t)}function Rt(t){this._context=t}function Ft(t){this._context=t}function Bt(t){var e,r,n=t.length-1,a=new Array(n),i=new Array(n),o=new Array(n);for(a[0]=0,i[0]=2,o[0]=t[0]+2*t[1],e=1;e<n-1;++e)a[e]=1,i[e]=4,o[e]=4*t[e]+2*t[e+1];for(a[n-1]=2,i[n-1]=7,o[n-1]=8*t[n-1]+t[n],e=1;e<n;++e)r=a[e]/i[e-1],i[e]-=r,o[e]-=r*o[e-1];for(a[n-1]=o[n-1]/i[n-1],e=n-2;e>=0;--e)a[e]=(o[e]-a[e+1])/i[e];for(i[n-1]=(t[n]+a[n-1])/2,e=0;e<n-1;++e)i[e]=2*t[e+1]-a[e+1];return[a,i]}function Nt(t,e){this._context=t,this._t=e}function jt(t,e){if((a=t.length)>1)for(var r,n,a,i=1,o=t[e[0]],s=o.length;i<a;++i)for(n=o,o=t[e[i]],r=0;r<s;++r)o[r][1]+=o[r][0]=isNaN(n[r][1])?n[r][0]:n[r][1]}function Ut(t){for(var e=t.length,r=new Array(e);--e>=0;)r[e]=e;return r}function Vt(t,e){return t[e]}function qt(t){var e=t.map(Ht);return Ut(t).sort((function(t,r){return e[t]-e[r]}))}function Ht(t){for(var e,r=-1,n=0,a=t.length,i=-1/0;++r<a;)(e=+t[r][1])>i&&(i=e,n=r);return n}function Gt(t){var e=t.map(Yt);return Ut(t).sort((function(t,r){return e[t]-e[r]}))}function Yt(t){for(var e,r=0,n=-1,a=t.length;++n<a;)(e=+t[n][1])&&(r+=e);return r}Ct.prototype={areaStart:lt,areaEnd:lt,lineStart:function(){this._point=0},lineEnd:function(){this._point&&this._context.closePath()},point:function(t,e){t=+t,e=+e,this._point?this._context.lineTo(t,e):(this._point=1,this._context.moveTo(t,e))}},Ot.prototype={areaStart:function(){this._line=0},areaEnd:function(){this._line=NaN},lineStart:function(){this._x0=this._x1=this._y0=this._y1=this._t0=NaN,this._point=0},lineEnd:function(){switch(this._point){case 2:this._context.lineTo(this._x1,this._y1);break;case 3:zt(this,this._t0,It(this,this._t0))}(this._line||0!==this._line&&1===this._point)&&this._context.closePath(),this._line=1-this._line},point:function(t,e){var r=NaN;if(e=+e,(t=+t)!==this._x1||e!==this._y1){switch(this._point){case 0:this._point=1,this._line?this._context.lineTo(t,e):this._context.moveTo(t,e);break;case 1:this._point=2;break;case 2:this._point=3,zt(this,It(this,r=Pt(this,t,e)),r);break;default:zt(this,this._t0,r=Pt(this,t,e))}this._x0=this._x1,this._x1=t,this._y0=this._y1,this._y1=e,this._t0=r}}},(Dt.prototype=Object.create(Ot.prototype)).point=function(t,e){Ot.prototype.point.call(this,e,t)},Rt.prototype={moveTo:function(t,e){this._context.moveTo(e,t)},closePath:function(){this._context.closePath()},lineTo:function(t,e){this._context.lineTo(e,t)},bezierCurveTo:function(t,e,r,n,a,i){this._context.bezierCurveTo(e,t,n,r,i,a)}},Ft.prototype={areaStart:function(){this._line=0},areaEnd:function(){this._line=NaN},lineStart:function(){this._x=[],this._y=[]},lineEnd:function(){var t=this._x,e=this._y,r=t.length;if(r)if(this._line?this._context.lineTo(t[0],e[0]):this._context.moveTo(t[0],e[0]),2===r)this._context.lineTo(t[1],e[1]);else for(var n=Bt(t),a=Bt(e),i=0,o=1;o<r;++i,++o)this._context.bezierCurveTo(n[0][i],a[0][i],n[1][i],a[1][i],t[o],e[o]);(this._line||0!==this._line&&1===r)&&this._context.closePath(),this._line=1-this._line,this._x=this._y=null},point:function(t,e){this._x.push(+t),this._y.push(+e)}},Nt.prototype={areaStart:function(){this._line=0},areaEnd:function(){this._line=NaN},lineStart:function(){this._x=this._y=NaN,this._point=0},lineEnd:function(){0<this._t&&this._t<1&&2===this._point&&this._context.lineTo(this._x,this._y),(this._line||0!==this._line&&1===this._point)&&this._context.closePath(),this._line>=0&&(this._t=1-this._t,this._line=1-this._line)},point:function(t,e){switch(t=+t,e=+e,this._point){case 0:this._point=1,this._line?this._context.lineTo(t,e):this._context.moveTo(t,e);break;case 1:this._point=2;default:if(this._t<=0)this._context.lineTo(this._x,e),this._context.lineTo(t,e);else{var r=this._x*(1-this._t)+t*this._t;this._context.lineTo(r,this._y),this._context.lineTo(r,e)}}this._x=t,this._y=e}},t.arc=function(){var t=g,o=m,w=r(0),T=null,k=v,M=y,A=x,S=null;function E(){var r,g,m=+t.apply(this,arguments),v=+o.apply(this,arguments),y=k.apply(this,arguments)-h,x=M.apply(this,arguments)-h,E=n(x-y),C=x>y;if(S||(S=r=e.path()),v<m&&(g=v,v=m,m=g),v>1e-12)if(E>f-1e-12)S.moveTo(v*i(y),v*l(y)),S.arc(0,0,v,y,x,!C),m>1e-12&&(S.moveTo(m*i(x),m*l(x)),S.arc(0,0,m,x,y,C));else{var L,P,I=y,z=x,O=y,D=x,R=E,F=E,B=A.apply(this,arguments)/2,N=B>1e-12&&(T?+T.apply(this,arguments):c(m*m+v*v)),j=s(n(v-m)/2,+w.apply(this,arguments)),U=j,V=j;if(N>1e-12){var q=d(N/m*l(B)),H=d(N/v*l(B));(R-=2*q)>1e-12?(O+=q*=C?1:-1,D-=q):(R=0,O=D=(y+x)/2),(F-=2*H)>1e-12?(I+=H*=C?1:-1,z-=H):(F=0,I=z=(y+x)/2)}var G=v*i(I),Y=v*l(I),W=m*i(D),Z=m*l(D);if(j>1e-12){var X,J=v*i(z),K=v*l(z),Q=m*i(O),$=m*l(O);if(E<u&&(X=b(G,Y,Q,$,J,K,W,Z))){var tt=G-X[0],et=Y-X[1],rt=J-X[0],nt=K-X[1],at=1/l(p((tt*rt+et*nt)/(c(tt*tt+et*et)*c(rt*rt+nt*nt)))/2),it=c(X[0]*X[0]+X[1]*X[1]);U=s(j,(m-it)/(at-1)),V=s(j,(v-it)/(at+1))}}F>1e-12?V>1e-12?(L=_(Q,$,G,Y,v,V,C),P=_(J,K,W,Z,v,V,C),S.moveTo(L.cx+L.x01,L.cy+L.y01),V<j?S.arc(L.cx,L.cy,V,a(L.y01,L.x01),a(P.y01,P.x01),!C):(S.arc(L.cx,L.cy,V,a(L.y01,L.x01),a(L.y11,L.x11),!C),S.arc(0,0,v,a(L.cy+L.y11,L.cx+L.x11),a(P.cy+P.y11,P.cx+P.x11),!C),S.arc(P.cx,P.cy,V,a(P.y11,P.x11),a(P.y01,P.x01),!C))):(S.moveTo(G,Y),S.arc(0,0,v,I,z,!C)):S.moveTo(G,Y),m>1e-12&&R>1e-12?U>1e-12?(L=_(W,Z,J,K,m,-U,C),P=_(G,Y,Q,$,m,-U,C),S.lineTo(L.cx+L.x01,L.cy+L.y01),U<j?S.arc(L.cx,L.cy,U,a(L.y01,L.x01),a(P.y01,P.x01),!C):(S.arc(L.cx,L.cy,U,a(L.y01,L.x01),a(L.y11,L.x11),!C),S.arc(0,0,m,a(L.cy+L.y11,L.cx+L.x11),a(P.cy+P.y11,P.cx+P.x11),C),S.arc(P.cx,P.cy,U,a(P.y11,P.x11),a(P.y01,P.x01),!C))):S.arc(0,0,m,D,O,C):S.lineTo(W,Z)}else S.moveTo(0,0);if(S.closePath(),r)return S=null,r+""||null}return E.centroid=function(){var e=(+t.apply(this,arguments)+ +o.apply(this,arguments))/2,r=(+k.apply(this,arguments)+ +M.apply(this,arguments))/2-u/2;return[i(r)*e,l(r)*e]},E.innerRadius=function(e){return arguments.length?(t="function"==typeof e?e:r(+e),E):t},E.outerRadius=function(t){return arguments.length?(o="function"==typeof t?t:r(+t),E):o},E.cornerRadius=function(t){return arguments.length?(w="function"==typeof t?t:r(+t),E):w},E.padRadius=function(t){return arguments.length?(T=null==t?null:"function"==typeof t?t:r(+t),E):T},E.startAngle=function(t){return arguments.length?(k="function"==typeof t?t:r(+t),E):k},E.endAngle=function(t){return arguments.length?(M="function"==typeof t?t:r(+t),E):M},E.padAngle=function(t){return arguments.length?(A="function"==typeof t?t:r(+t),E):A},E.context=function(t){return arguments.length?(S=null==t?null:t,E):S},E},t.area=S,t.areaRadial=D,t.curveBasis=function(t){return new ut(t)},t.curveBasisClosed=function(t){return new ht(t)},t.curveBasisOpen=function(t){return new ft(t)},t.curveBundle=dt,t.curveCardinal=vt,t.curveCardinalClosed=xt,t.curveCardinalOpen=_t,t.curveCatmullRom=kt,t.curveCatmullRomClosed=At,t.curveCatmullRomOpen=Et,t.curveLinear=T,t.curveLinearClosed=function(t){return new Ct(t)},t.curveMonotoneX=function(t){return new Ot(t)},t.curveMonotoneY=function(t){return new Dt(t)},t.curveNatural=function(t){return new Ft(t)},t.curveStep=function(t){return new Nt(t,.5)},t.curveStepAfter=function(t){return new Nt(t,1)},t.curveStepBefore=function(t){return new Nt(t,0)},t.line=A,t.lineRadial=O,t.linkHorizontal=function(){return j(U)},t.linkRadial=function(){var t=j(q);return t.angle=t.x,delete t.x,t.radius=t.y,delete t.y,t},t.linkVertical=function(){return j(V)},t.pie=function(){var t=C,e=E,n=null,a=r(0),i=r(f),o=r(0);function s(r){var s,l,c,u,h,p=r.length,d=0,g=new Array(p),m=new Array(p),v=+a.apply(this,arguments),y=Math.min(f,Math.max(-f,i.apply(this,arguments)-v)),x=Math.min(Math.abs(y)/p,o.apply(this,arguments)),b=x*(y<0?-1:1);for(s=0;s<p;++s)(h=m[g[s]=s]=+t(r[s],s,r))>0&&(d+=h);for(null!=e?g.sort((function(t,r){return e(m[t],m[r])})):null!=n&&g.sort((function(t,e){return n(r[t],r[e])})),s=0,c=d?(y-p*b)/d:0;s<p;++s,v=u)l=g[s],u=v+((h=m[l])>0?h*c:0)+b,m[l]={data:r[l],index:s,value:h,startAngle:v,endAngle:u,padAngle:x};return m}return s.value=function(e){return arguments.length?(t="function"==typeof e?e:r(+e),s):t},s.sortValues=function(t){return arguments.length?(e=t,n=null,s):e},s.sort=function(t){return arguments.length?(n=t,e=null,s):n},s.startAngle=function(t){return arguments.length?(a="function"==typeof t?t:r(+t),s):a},s.endAngle=function(t){return arguments.length?(i="function"==typeof t?t:r(+t),s):i},s.padAngle=function(t){return arguments.length?(o="function"==typeof t?t:r(+t),s):o},s},t.pointRadial=R,t.radialArea=D,t.radialLine=O,t.stack=function(){var t=r([]),e=Ut,n=jt,a=Vt;function i(r){var i,o,s=t.apply(this,arguments),l=r.length,c=s.length,u=new Array(c);for(i=0;i<c;++i){for(var h,f=s[i],p=u[i]=new Array(l),d=0;d<l;++d)p[d]=h=[0,+a(r[d],f,d,r)],h.data=r[d];p.key=f}for(i=0,o=e(u);i<c;++i)u[o[i]].index=i;return n(u,o),u}return i.keys=function(e){return arguments.length?(t="function"==typeof e?e:r(F.call(e)),i):t},i.value=function(t){return arguments.length?(a="function"==typeof t?t:r(+t),i):a},i.order=function(t){return arguments.length?(e=null==t?Ut:"function"==typeof t?t:r(F.call(t)),i):e},i.offset=function(t){return arguments.length?(n=null==t?jt:t,i):n},i},t.stackOffsetDiverging=function(t,e){if((s=t.length)>0)for(var r,n,a,i,o,s,l=0,c=t[e[0]].length;l<c;++l)for(i=o=0,r=0;r<s;++r)(a=(n=t[e[r]][l])[1]-n[0])>0?(n[0]=i,n[1]=i+=a):a<0?(n[1]=o,n[0]=o+=a):(n[0]=0,n[1]=a)},t.stackOffsetExpand=function(t,e){if((n=t.length)>0){for(var r,n,a,i=0,o=t[0].length;i<o;++i){for(a=r=0;r<n;++r)a+=t[r][i][1]||0;if(a)for(r=0;r<n;++r)t[r][i][1]/=a}jt(t,e)}},t.stackOffsetNone=jt,t.stackOffsetSilhouette=function(t,e){if((r=t.length)>0){for(var r,n=0,a=t[e[0]],i=a.length;n<i;++n){for(var o=0,s=0;o<r;++o)s+=t[o][n][1]||0;a[n][1]+=a[n][0]=-s/2}jt(t,e)}},t.stackOffsetWiggle=function(t,e){if((a=t.length)>0&&(n=(r=t[e[0]]).length)>0){for(var r,n,a,i=0,o=1;o<n;++o){for(var s=0,l=0,c=0;s<a;++s){for(var u=t[e[s]],h=u[o][1]||0,f=(h-(u[o-1][1]||0))/2,p=0;p<s;++p){var d=t[e[p]];f+=(d[o][1]||0)-(d[o-1][1]||0)}l+=h,c+=f*h}r[o-1][1]+=r[o-1][0]=i,l&&(i-=c/l)}r[o-1][1]+=r[o-1][0]=i,jt(t,e)}},t.stackOrderAppearance=qt,t.stackOrderAscending=Gt,t.stackOrderDescending=function(t){return Gt(t).reverse()},t.stackOrderInsideOut=function(t){var e,r,n=t.length,a=t.map(Yt),i=qt(t),o=0,s=0,l=[],c=[];for(e=0;e<n;++e)r=i[e],o<s?(o+=a[r],l.push(r)):(s+=a[r],c.push(r));return c.reverse().concat(l)},t.stackOrderNone=Ut,t.stackOrderReverse=function(t){return Ut(t).reverse()},t.symbol=function(){var t=r(H),n=r(64),a=null;function i(){var r;if(a||(a=r=e.path()),t.apply(this,arguments).draw(a,+n.apply(this,arguments)),r)return a=null,r+""||null}return i.type=function(e){return arguments.length?(t="function"==typeof e?e:r(e),i):t},i.size=function(t){return arguments.length?(n="function"==typeof t?t:r(+t),i):n},i.context=function(t){return arguments.length?(a=null==t?null:t,i):a},i},t.symbolCircle=H,t.symbolCross=G,t.symbolDiamond=Z,t.symbolSquare=$,t.symbolStar=Q,t.symbolTriangle=et,t.symbolWye=ot,t.symbols=st,Object.defineProperty(t,"__esModule",{value:!0})}))},{"d3-path":161}],164:[function(t,e,r){!function(t,n){"object"==typeof r&&"undefined"!=typeof e?n(r):n((t=t||self).d3=t.d3||{})}(this,(function(t){"use strict";var e,r,n=0,a=0,i=0,o=0,s=0,l=0,c="object"==typeof performance&&performance.now?performance:Date,u="object"==typeof window&&window.requestAnimationFrame?window.requestAnimationFrame.bind(window):function(t){setTimeout(t,17)};function h(){return s||(u(f),s=c.now()+l)}function f(){s=0}function p(){this._call=this._time=this._next=null}function d(t,e,r){var n=new p;return n.restart(t,e,r),n}function g(){h(),++n;for(var t,r=e;r;)(t=s-r._time)>=0&&r._call.call(null,t),r=r._next;--n}function m(){s=(o=c.now())+l,n=a=0;try{g()}finally{n=0,function(){var t,n,a=e,i=1/0;for(;a;)a._call?(i>a._time&&(i=a._time),t=a,a=a._next):(n=a._next,a._next=null,a=t?t._next=n:e=n);r=t,y(i)}(),s=0}}function v(){var t=c.now(),e=t-o;e>1e3&&(l-=e,o=t)}function y(t){n||(a&&(a=clearTimeout(a)),t-s>24?(t<1/0&&(a=setTimeout(m,t-c.now()-l)),i&&(i=clearInterval(i))):(i||(o=c.now(),i=setInterval(v,1e3)),n=1,u(m)))}p.prototype=d.prototype={constructor:p,restart:function(t,n,a){if("function"!=typeof t)throw new TypeError("callback is not a function");a=(null==a?h():+a)+(null==n?0:+n),this._next||r===this||(r?r._next=this:e=this,r=this),this._call=t,this._time=a,y()},stop:function(){this._call&&(this._call=null,this._time=1/0,y())}},t.interval=function(t,e,r){var n=new p,a=e;return null==e?(n.restart(t,e,r),n):(e=+e,r=null==r?h():+r,n.restart((function i(o){o+=a,n.restart(i,a+=e,r),t(o)}),e,r),n)},t.now=h,t.timeout=function(t,e,r){var n=new p;return e=null==e?0:+e,n.restart((function(r){n.stop(),t(r+e)}),e,r),n},t.timer=d,t.timerFlush=g,Object.defineProperty(t,"__esModule",{value:!0})}))},{}],165:[function(t,e,r){!function(){var t={version:"3.5.17"},r=[].slice,n=function(t){return r.call(t)},a=this.document;function i(t){return t&&(t.ownerDocument||t.document||t).documentElement}function o(t){return t&&(t.ownerDocument&&t.ownerDocument.defaultView||t.document&&t||t.defaultView)}if(a)try{n(a.documentElement.childNodes)[0].nodeType}catch(t){n=function(t){for(var e=t.length,r=new Array(e);e--;)r[e]=t[e];return r}}if(Date.now||(Date.now=function(){return+new Date}),a)try{a.createElement("DIV").style.setProperty("opacity",0,"")}catch(t){var s=this.Element.prototype,l=s.setAttribute,c=s.setAttributeNS,u=this.CSSStyleDeclaration.prototype,h=u.setProperty;s.setAttribute=function(t,e){l.call(this,t,e+"")},s.setAttributeNS=function(t,e,r){c.call(this,t,e,r+"")},u.setProperty=function(t,e,r){h.call(this,t,e+"",r)}}function f(t,e){return t<e?-1:t>e?1:t>=e?0:NaN}function p(t){return null===t?NaN:+t}function d(t){return!isNaN(t)}function g(t){return{left:function(e,r,n,a){for(arguments.length<3&&(n=0),arguments.length<4&&(a=e.length);n<a;){var i=n+a>>>1;t(e[i],r)<0?n=i+1:a=i}return n},right:function(e,r,n,a){for(arguments.length<3&&(n=0),arguments.length<4&&(a=e.length);n<a;){var i=n+a>>>1;t(e[i],r)>0?a=i:n=i+1}return n}}}t.ascending=f,t.descending=function(t,e){return e<t?-1:e>t?1:e>=t?0:NaN},t.min=function(t,e){var r,n,a=-1,i=t.length;if(1===arguments.length){for(;++a<i;)if(null!=(n=t[a])&&n>=n){r=n;break}for(;++a<i;)null!=(n=t[a])&&r>n&&(r=n)}else{for(;++a<i;)if(null!=(n=e.call(t,t[a],a))&&n>=n){r=n;break}for(;++a<i;)null!=(n=e.call(t,t[a],a))&&r>n&&(r=n)}return r},t.max=function(t,e){var r,n,a=-1,i=t.length;if(1===arguments.length){for(;++a<i;)if(null!=(n=t[a])&&n>=n){r=n;break}for(;++a<i;)null!=(n=t[a])&&n>r&&(r=n)}else{for(;++a<i;)if(null!=(n=e.call(t,t[a],a))&&n>=n){r=n;break}for(;++a<i;)null!=(n=e.call(t,t[a],a))&&n>r&&(r=n)}return r},t.extent=function(t,e){var r,n,a,i=-1,o=t.length;if(1===arguments.length){for(;++i<o;)if(null!=(n=t[i])&&n>=n){r=a=n;break}for(;++i<o;)null!=(n=t[i])&&(r>n&&(r=n),a<n&&(a=n))}else{for(;++i<o;)if(null!=(n=e.call(t,t[i],i))&&n>=n){r=a=n;break}for(;++i<o;)null!=(n=e.call(t,t[i],i))&&(r>n&&(r=n),a<n&&(a=n))}return[r,a]},t.sum=function(t,e){var r,n=0,a=t.length,i=-1;if(1===arguments.length)for(;++i<a;)d(r=+t[i])&&(n+=r);else for(;++i<a;)d(r=+e.call(t,t[i],i))&&(n+=r);return n},t.mean=function(t,e){var r,n=0,a=t.length,i=-1,o=a;if(1===arguments.length)for(;++i<a;)d(r=p(t[i]))?n+=r:--o;else for(;++i<a;)d(r=p(e.call(t,t[i],i)))?n+=r:--o;if(o)return n/o},t.quantile=function(t,e){var r=(t.length-1)*e+1,n=Math.floor(r),a=+t[n-1],i=r-n;return i?a+i*(t[n]-a):a},t.median=function(e,r){var n,a=[],i=e.length,o=-1;if(1===arguments.length)for(;++o<i;)d(n=p(e[o]))&&a.push(n);else for(;++o<i;)d(n=p(r.call(e,e[o],o)))&&a.push(n);if(a.length)return t.quantile(a.sort(f),.5)},t.variance=function(t,e){var r,n,a=t.length,i=0,o=0,s=-1,l=0;if(1===arguments.length)for(;++s<a;)d(r=p(t[s]))&&(o+=(n=r-i)*(r-(i+=n/++l)));else for(;++s<a;)d(r=p(e.call(t,t[s],s)))&&(o+=(n=r-i)*(r-(i+=n/++l)));if(l>1)return o/(l-1)},t.deviation=function(){var e=t.variance.apply(this,arguments);return e?Math.sqrt(e):e};var m=g(f);function v(t){return t.length}t.bisectLeft=m.left,t.bisect=t.bisectRight=m.right,t.bisector=function(t){return g(1===t.length?function(e,r){return f(t(e),r)}:t)},t.shuffle=function(t,e,r){(i=arguments.length)<3&&(r=t.length,i<2&&(e=0));for(var n,a,i=r-e;i;)a=Math.random()*i--|0,n=t[i+e],t[i+e]=t[a+e],t[a+e]=n;return t},t.permute=function(t,e){for(var r=e.length,n=new Array(r);r--;)n[r]=t[e[r]];return n},t.pairs=function(t){for(var e=0,r=t.length-1,n=t[0],a=new Array(r<0?0:r);e<r;)a[e]=[n,n=t[++e]];return a},t.transpose=function(e){if(!(i=e.length))return[];for(var r=-1,n=t.min(e,v),a=new Array(n);++r<n;)for(var i,o=-1,s=a[r]=new Array(i);++o<i;)s[o]=e[o][r];return a},t.zip=function(){return t.transpose(arguments)},t.keys=function(t){var e=[];for(var r in t)e.push(r);return e},t.values=function(t){var e=[];for(var r in t)e.push(t[r]);return e},t.entries=function(t){var e=[];for(var r in t)e.push({key:r,value:t[r]});return e},t.merge=function(t){for(var e,r,n,a=t.length,i=-1,o=0;++i<a;)o+=t[i].length;for(r=new Array(o);--a>=0;)for(e=(n=t[a]).length;--e>=0;)r[--o]=n[e];return r};var y=Math.abs;function x(t){for(var e=1;t*e%1;)e*=10;return e}function b(t,e){for(var r in e)Object.defineProperty(t.prototype,r,{value:e[r],enumerable:!1})}function _(){this._=Object.create(null)}t.range=function(t,e,r){if(arguments.length<3&&(r=1,arguments.length<2&&(e=t,t=0)),(e-t)/r==1/0)throw new Error("infinite range");var n,a=[],i=x(y(r)),o=-1;if(t*=i,e*=i,(r*=i)<0)for(;(n=t+r*++o)>e;)a.push(n/i);else for(;(n=t+r*++o)<e;)a.push(n/i);return a},t.map=function(t,e){var r=new _;if(t instanceof _)t.forEach((function(t,e){r.set(t,e)}));else if(Array.isArray(t)){var n,a=-1,i=t.length;if(1===arguments.length)for(;++a<i;)r.set(a,t[a]);else for(;++a<i;)r.set(e.call(t,n=t[a],a),n)}else for(var o in t)r.set(o,t[o]);return r};function w(t){return"__proto__"==(t+="")||"\0"===t[0]?"\0"+t:t}function T(t){return"\0"===(t+="")[0]?t.slice(1):t}function k(t){return w(t)in this._}function M(t){return(t=w(t))in this._&&delete this._[t]}function A(){var t=[];for(var e in this._)t.push(T(e));return t}function S(){var t=0;for(var e in this._)++t;return t}function E(){for(var t in this._)return!1;return!0}function C(){this._=Object.create(null)}function L(t){return t}function P(t,e,r){return function(){var n=r.apply(e,arguments);return n===e?t:n}}function I(t,e){if(e in t)return e;e=e.charAt(0).toUpperCase()+e.slice(1);for(var r=0,n=z.length;r<n;++r){var a=z[r]+e;if(a in t)return a}}b(_,{has:k,get:function(t){return this._[w(t)]},set:function(t,e){return this._[w(t)]=e},remove:M,keys:A,values:function(){var t=[];for(var e in this._)t.push(this._[e]);return t},entries:function(){var t=[];for(var e in this._)t.push({key:T(e),value:this._[e]});return t},size:S,empty:E,forEach:function(t){for(var e in this._)t.call(this,T(e),this._[e])}}),t.nest=function(){var e,r,n={},a=[],i=[];function o(t,i,s){if(s>=a.length)return r?r.call(n,i):e?i.sort(e):i;for(var l,c,u,h,f=-1,p=i.length,d=a[s++],g=new _;++f<p;)(h=g.get(l=d(c=i[f])))?h.push(c):g.set(l,[c]);return t?(c=t(),u=function(e,r){c.set(e,o(t,r,s))}):(c={},u=function(e,r){c[e]=o(t,r,s)}),g.forEach(u),c}return n.map=function(t,e){return o(e,t,0)},n.entries=function(e){return function t(e,r){if(r>=a.length)return e;var n=[],o=i[r++];return e.forEach((function(e,a){n.push({key:e,values:t(a,r)})})),o?n.sort((function(t,e){return o(t.key,e.key)})):n}(o(t.map,e,0),0)},n.key=function(t){return a.push(t),n},n.sortKeys=function(t){return i[a.length-1]=t,n},n.sortValues=function(t){return e=t,n},n.rollup=function(t){return r=t,n},n},t.set=function(t){var e=new C;if(t)for(var r=0,n=t.length;r<n;++r)e.add(t[r]);return e},b(C,{has:k,add:function(t){return this._[w(t+="")]=!0,t},remove:M,values:A,size:S,empty:E,forEach:function(t){for(var e in this._)t.call(this,T(e))}}),t.behavior={},t.rebind=function(t,e){for(var r,n=1,a=arguments.length;++n<a;)t[r=arguments[n]]=P(t,e,e[r]);return t};var z=["webkit","ms","moz","Moz","o","O"];function O(){}function D(){}function R(t){var e=[],r=new _;function n(){for(var r,n=e,a=-1,i=n.length;++a<i;)(r=n[a].on)&&r.apply(this,arguments);return t}return n.on=function(n,a){var i,o=r.get(n);return arguments.length<2?o&&o.on:(o&&(o.on=null,e=e.slice(0,i=e.indexOf(o)).concat(e.slice(i+1)),r.remove(n)),a&&e.push(r.set(n,{on:a})),t)},n}function F(){t.event.preventDefault()}function B(){for(var e,r=t.event;e=r.sourceEvent;)r=e;return r}function N(e){for(var r=new D,n=0,a=arguments.length;++n<a;)r[arguments[n]]=R(r);return r.of=function(n,a){return function(i){try{var o=i.sourceEvent=t.event;i.target=e,t.event=i,r[i.type].apply(n,a)}finally{t.event=o}}},r}t.dispatch=function(){for(var t=new D,e=-1,r=arguments.length;++e<r;)t[arguments[e]]=R(t);return t},D.prototype.on=function(t,e){var r=t.indexOf("."),n="";if(r>=0&&(n=t.slice(r+1),t=t.slice(0,r)),t)return arguments.length<2?this[t].on(n):this[t].on(n,e);if(2===arguments.length){if(null==e)for(t in this)this.hasOwnProperty(t)&&this[t].on(n,null);return this}},t.event=null,t.requote=function(t){return t.replace(j,"\\$&")};var j=/[\\\^\$\*\+\?\|\[\]\(\)\.\{\}]/g,U={}.__proto__?function(t,e){t.__proto__=e}:function(t,e){for(var r in e)t[r]=e[r]};function V(t){return U(t,Y),t}var q=function(t,e){return e.querySelector(t)},H=function(t,e){return e.querySelectorAll(t)},G=function(t,e){var r=t.matches||t[I(t,"matchesSelector")];return(G=function(t,e){return r.call(t,e)})(t,e)};"function"==typeof Sizzle&&(q=function(t,e){return Sizzle(t,e)[0]||null},H=Sizzle,G=Sizzle.matchesSelector),t.selection=function(){return t.select(a.documentElement)};var Y=t.selection.prototype=[];function W(t){return"function"==typeof t?t:function(){return q(t,this)}}function Z(t){return"function"==typeof t?t:function(){return H(t,this)}}Y.select=function(t){var e,r,n,a,i=[];t=W(t);for(var o=-1,s=this.length;++o<s;){i.push(e=[]),e.parentNode=(n=this[o]).parentNode;for(var l=-1,c=n.length;++l<c;)(a=n[l])?(e.push(r=t.call(a,a.__data__,l,o)),r&&"__data__"in a&&(r.__data__=a.__data__)):e.push(null)}return V(i)},Y.selectAll=function(t){var e,r,a=[];t=Z(t);for(var i=-1,o=this.length;++i<o;)for(var s=this[i],l=-1,c=s.length;++l<c;)(r=s[l])&&(a.push(e=n(t.call(r,r.__data__,l,i))),e.parentNode=r);return V(a)};var X="http://www.w3.org/1999/xhtml",J={svg:"http://www.w3.org/2000/svg",xhtml:X,xlink:"http://www.w3.org/1999/xlink",xml:"http://www.w3.org/XML/1998/namespace",xmlns:"http://www.w3.org/2000/xmlns/"};function K(e,r){return e=t.ns.qualify(e),null==r?e.local?function(){this.removeAttributeNS(e.space,e.local)}:function(){this.removeAttribute(e)}:"function"==typeof r?e.local?function(){var t=r.apply(this,arguments);null==t?this.removeAttributeNS(e.space,e.local):this.setAttributeNS(e.space,e.local,t)}:function(){var t=r.apply(this,arguments);null==t?this.removeAttribute(e):this.setAttribute(e,t)}:e.local?function(){this.setAttributeNS(e.space,e.local,r)}:function(){this.setAttribute(e,r)}}function Q(t){return t.trim().replace(/\s+/g," ")}function $(e){return new RegExp("(?:^|\\s+)"+t.requote(e)+"(?:\\s+|$)","g")}function tt(t){return(t+"").trim().split(/^|\s+/)}function et(t,e){var r=(t=tt(t).map(rt)).length;return"function"==typeof e?function(){for(var n=-1,a=e.apply(this,arguments);++n<r;)t[n](this,a)}:function(){for(var n=-1;++n<r;)t[n](this,e)}}function rt(t){var e=$(t);return function(r,n){if(a=r.classList)return n?a.add(t):a.remove(t);var a=r.getAttribute("class")||"";n?(e.lastIndex=0,e.test(a)||r.setAttribute("class",Q(a+" "+t))):r.setAttribute("class",Q(a.replace(e," ")))}}function nt(t,e,r){return null==e?function(){this.style.removeProperty(t)}:"function"==typeof e?function(){var n=e.apply(this,arguments);null==n?this.style.removeProperty(t):this.style.setProperty(t,n,r)}:function(){this.style.setProperty(t,e,r)}}function at(t,e){return null==e?function(){delete this[t]}:"function"==typeof e?function(){var r=e.apply(this,arguments);null==r?delete this[t]:this[t]=r}:function(){this[t]=e}}function it(e){return"function"==typeof e?e:(e=t.ns.qualify(e)).local?function(){return this.ownerDocument.createElementNS(e.space,e.local)}:function(){var t=this.ownerDocument,r=this.namespaceURI;return r===X&&t.documentElement.namespaceURI===X?t.createElement(e):t.createElementNS(r,e)}}function ot(){var t=this.parentNode;t&&t.removeChild(this)}function st(t){return{__data__:t}}function lt(t){return function(){return G(this,t)}}function ct(t){return arguments.length||(t=f),function(e,r){return e&&r?t(e.__data__,r.__data__):!e-!r}}function ut(t,e){for(var r=0,n=t.length;r<n;r++)for(var a,i=t[r],o=0,s=i.length;o<s;o++)(a=i[o])&&e(a,o,r);return t}function ht(t){return U(t,ft),t}t.ns={prefix:J,qualify:function(t){var e=t.indexOf(":"),r=t;return e>=0&&"xmlns"!==(r=t.slice(0,e))&&(t=t.slice(e+1)),J.hasOwnProperty(r)?{space:J[r],local:t}:t}},Y.attr=function(e,r){if(arguments.length<2){if("string"==typeof e){var n=this.node();return(e=t.ns.qualify(e)).local?n.getAttributeNS(e.space,e.local):n.getAttribute(e)}for(r in e)this.each(K(r,e[r]));return this}return this.each(K(e,r))},Y.classed=function(t,e){if(arguments.length<2){if("string"==typeof t){var r=this.node(),n=(t=tt(t)).length,a=-1;if(e=r.classList){for(;++a<n;)if(!e.contains(t[a]))return!1}else for(e=r.getAttribute("class");++a<n;)if(!$(t[a]).test(e))return!1;return!0}for(e in t)this.each(et(e,t[e]));return this}return this.each(et(t,e))},Y.style=function(t,e,r){var n=arguments.length;if(n<3){if("string"!=typeof t){for(r in n<2&&(e=""),t)this.each(nt(r,t[r],e));return this}if(n<2){var a=this.node();return o(a).getComputedStyle(a,null).getPropertyValue(t)}r=""}return this.each(nt(t,e,r))},Y.property=function(t,e){if(arguments.length<2){if("string"==typeof t)return this.node()[t];for(e in t)this.each(at(e,t[e]));return this}return this.each(at(t,e))},Y.text=function(t){return arguments.length?this.each("function"==typeof t?function(){var e=t.apply(this,arguments);this.textContent=null==e?"":e}:null==t?function(){this.textContent=""}:function(){this.textContent=t}):this.node().textContent},Y.html=function(t){return arguments.length?this.each("function"==typeof t?function(){var e=t.apply(this,arguments);this.innerHTML=null==e?"":e}:null==t?function(){this.innerHTML=""}:function(){this.innerHTML=t}):this.node().innerHTML},Y.append=function(t){return t=it(t),this.select((function(){return this.appendChild(t.apply(this,arguments))}))},Y.insert=function(t,e){return t=it(t),e=W(e),this.select((function(){return this.insertBefore(t.apply(this,arguments),e.apply(this,arguments)||null)}))},Y.remove=function(){return this.each(ot)},Y.data=function(t,e){var r,n,a=-1,i=this.length;if(!arguments.length){for(t=new Array(i=(r=this[0]).length);++a<i;)(n=r[a])&&(t[a]=n.__data__);return t}function o(t,r){var n,a,i,o=t.length,u=r.length,h=Math.min(o,u),f=new Array(u),p=new Array(u),d=new Array(o);if(e){var g,m=new _,v=new Array(o);for(n=-1;++n<o;)(a=t[n])&&(m.has(g=e.call(a,a.__data__,n))?d[n]=a:m.set(g,a),v[n]=g);for(n=-1;++n<u;)(a=m.get(g=e.call(r,i=r[n],n)))?!0!==a&&(f[n]=a,a.__data__=i):p[n]=st(i),m.set(g,!0);for(n=-1;++n<o;)n in v&&!0!==m.get(v[n])&&(d[n]=t[n])}else{for(n=-1;++n<h;)a=t[n],i=r[n],a?(a.__data__=i,f[n]=a):p[n]=st(i);for(;n<u;++n)p[n]=st(r[n]);for(;n<o;++n)d[n]=t[n]}p.update=f,p.parentNode=f.parentNode=d.parentNode=t.parentNode,s.push(p),l.push(f),c.push(d)}var s=ht([]),l=V([]),c=V([]);if("function"==typeof t)for(;++a<i;)o(r=this[a],t.call(r,r.parentNode.__data__,a));else for(;++a<i;)o(r=this[a],t);return l.enter=function(){return s},l.exit=function(){return c},l},Y.datum=function(t){return arguments.length?this.property("__data__",t):this.property("__data__")},Y.filter=function(t){var e,r,n,a=[];"function"!=typeof t&&(t=lt(t));for(var i=0,o=this.length;i<o;i++){a.push(e=[]),e.parentNode=(r=this[i]).parentNode;for(var s=0,l=r.length;s<l;s++)(n=r[s])&&t.call(n,n.__data__,s,i)&&e.push(n)}return V(a)},Y.order=function(){for(var t=-1,e=this.length;++t<e;)for(var r,n=this[t],a=n.length-1,i=n[a];--a>=0;)(r=n[a])&&(i&&i!==r.nextSibling&&i.parentNode.insertBefore(r,i),i=r);return this},Y.sort=function(t){t=ct.apply(this,arguments);for(var e=-1,r=this.length;++e<r;)this[e].sort(t);return this.order()},Y.each=function(t){return ut(this,(function(e,r,n){t.call(e,e.__data__,r,n)}))},Y.call=function(t){var e=n(arguments);return t.apply(e[0]=this,e),this},Y.empty=function(){return!this.node()},Y.node=function(){for(var t=0,e=this.length;t<e;t++)for(var r=this[t],n=0,a=r.length;n<a;n++){var i=r[n];if(i)return i}return null},Y.size=function(){var t=0;return ut(this,(function(){++t})),t};var ft=[];function pt(t){var e,r;return function(n,a,i){var o,s=t[i].update,l=s.length;for(i!=r&&(r=i,e=0),a>=e&&(e=a+1);!(o=s[e])&&++e<l;);return o}}function dt(e,r,a){var i="__on"+e,o=e.indexOf("."),s=mt;o>0&&(e=e.slice(0,o));var l=gt.get(e);function c(){var t=this[i];t&&(this.removeEventListener(e,t,t.$),delete this[i])}return l&&(e=l,s=vt),o?r?function(){var t=s(r,n(arguments));c.call(this),this.addEventListener(e,this[i]=t,t.$=a),t._=r}:c:r?O:function(){var r,n=new RegExp("^__on([^.]+)"+t.requote(e)+"$");for(var a in this)if(r=a.match(n)){var i=this[a];this.removeEventListener(r[1],i,i.$),delete this[a]}}}t.selection.enter=ht,t.selection.enter.prototype=ft,ft.append=Y.append,ft.empty=Y.empty,ft.node=Y.node,ft.call=Y.call,ft.size=Y.size,ft.select=function(t){for(var e,r,n,a,i,o=[],s=-1,l=this.length;++s<l;){n=(a=this[s]).update,o.push(e=[]),e.parentNode=a.parentNode;for(var c=-1,u=a.length;++c<u;)(i=a[c])?(e.push(n[c]=r=t.call(a.parentNode,i.__data__,c,s)),r.__data__=i.__data__):e.push(null)}return V(o)},ft.insert=function(t,e){return arguments.length<2&&(e=pt(this)),Y.insert.call(this,t,e)},t.select=function(t){var e;return"string"==typeof t?(e=[q(t,a)]).parentNode=a.documentElement:(e=[t]).parentNode=i(t),V([e])},t.selectAll=function(t){var e;return"string"==typeof t?(e=n(H(t,a))).parentNode=a.documentElement:(e=n(t)).parentNode=null,V([e])},Y.on=function(t,e,r){var n=arguments.length;if(n<3){if("string"!=typeof t){for(r in n<2&&(e=!1),t)this.each(dt(r,t[r],e));return this}if(n<2)return(n=this.node()["__on"+t])&&n._;r=!1}return this.each(dt(t,e,r))};var gt=t.map({mouseenter:"mouseover",mouseleave:"mouseout"});function mt(e,r){return function(n){var a=t.event;t.event=n,r[0]=this.__data__;try{e.apply(this,r)}finally{t.event=a}}}function vt(t,e){var r=mt(t,e);return function(t){var e=t.relatedTarget;e&&(e===this||8&e.compareDocumentPosition(this))||r.call(this,t)}}a&&gt.forEach((function(t){"on"+t in a&&gt.remove(t)}));var yt,xt=0;function bt(e){var r=".dragsuppress-"+ ++xt,n="click"+r,a=t.select(o(e)).on("touchmove"+r,F).on("dragstart"+r,F).on("selectstart"+r,F);if(null==yt&&(yt=!("onselectstart"in e)&&I(e.style,"userSelect")),yt){var s=i(e).style,l=s[yt];s[yt]="none"}return function(t){if(a.on(r,null),yt&&(s[yt]=l),t){var e=function(){a.on(n,null)};a.on(n,(function(){F(),e()}),!0),setTimeout(e,0)}}}t.mouse=function(t){return wt(t,B())};var _t=this.navigator&&/WebKit/.test(this.navigator.userAgent)?-1:0;function wt(e,r){r.changedTouches&&(r=r.changedTouches[0]);var n=e.ownerSVGElement||e;if(n.createSVGPoint){var a=n.createSVGPoint();if(_t<0){var i=o(e);if(i.scrollX||i.scrollY){var s=(n=t.select("body").append("svg").style({position:"absolute",top:0,left:0,margin:0,padding:0,border:"none"},"important"))[0][0].getScreenCTM();_t=!(s.f||s.e),n.remove()}}return _t?(a.x=r.pageX,a.y=r.pageY):(a.x=r.clientX,a.y=r.clientY),[(a=a.matrixTransform(e.getScreenCTM().inverse())).x,a.y]}var l=e.getBoundingClientRect();return[r.clientX-l.left-e.clientLeft,r.clientY-l.top-e.clientTop]}function Tt(){return t.event.changedTouches[0].identifier}t.touch=function(t,e,r){if(arguments.length<3&&(r=e,e=B().changedTouches),e)for(var n,a=0,i=e.length;a<i;++a)if((n=e[a]).identifier===r)return wt(t,n)},t.behavior.drag=function(){var e=N(i,"drag","dragstart","dragend"),r=null,n=s(O,t.mouse,o,"mousemove","mouseup"),a=s(Tt,t.touch,L,"touchmove","touchend");function i(){this.on("mousedown.drag",n).on("touchstart.drag",a)}function s(n,a,i,o,s){return function(){var l,c=this,u=t.event.target.correspondingElement||t.event.target,h=c.parentNode,f=e.of(c,arguments),p=0,d=n(),g=".drag"+(null==d?"":"-"+d),m=t.select(i(u)).on(o+g,x).on(s+g,b),v=bt(u),y=a(h,d);function x(){var t,e,r=a(h,d);r&&(t=r[0]-y[0],e=r[1]-y[1],p|=t|e,y=r,f({type:"drag",x:r[0]+l[0],y:r[1]+l[1],dx:t,dy:e}))}function b(){a(h,d)&&(m.on(o+g,null).on(s+g,null),v(p),f({type:"dragend"}))}l=r?[(l=r.apply(c,arguments)).x-y[0],l.y-y[1]]:[0,0],f({type:"dragstart"})}}return i.origin=function(t){return arguments.length?(r=t,i):r},t.rebind(i,e,"on")},t.touches=function(t,e){return arguments.length<2&&(e=B().touches),e?n(e).map((function(e){var r=wt(t,e);return r.identifier=e.identifier,r})):[]};var kt=1e-6,Mt=1e-12,At=Math.PI,St=2*At,Et=St-kt,Ct=At/2,Lt=At/180,Pt=180/At;function It(t){return t>0?1:t<0?-1:0}function zt(t,e,r){return(e[0]-t[0])*(r[1]-t[1])-(e[1]-t[1])*(r[0]-t[0])}function Ot(t){return t>1?0:t<-1?At:Math.acos(t)}function Dt(t){return t>1?Ct:t<-1?-Ct:Math.asin(t)}function Rt(t){return((t=Math.exp(t))+1/t)/2}function Ft(t){return(t=Math.sin(t/2))*t}var Bt=Math.SQRT2;t.interpolateZoom=function(t,e){var r,n,a=t[0],i=t[1],o=t[2],s=e[0],l=e[1],c=e[2],u=s-a,h=l-i,f=u*u+h*h;if(f<Mt)n=Math.log(c/o)/Bt,r=function(t){return[a+t*u,i+t*h,o*Math.exp(Bt*t*n)]};else{var p=Math.sqrt(f),d=(c*c-o*o+4*f)/(2*o*2*p),g=(c*c-o*o-4*f)/(2*c*2*p),m=Math.log(Math.sqrt(d*d+1)-d),v=Math.log(Math.sqrt(g*g+1)-g);n=(v-m)/Bt,r=function(t){var e,r=t*n,s=Rt(m),l=o/(2*p)*(s*(e=Bt*r+m,((e=Math.exp(2*e))-1)/(e+1))-function(t){return((t=Math.exp(t))-1/t)/2}(m));return[a+l*u,i+l*h,o*s/Rt(Bt*r+m)]}}return r.duration=1e3*n,r},t.behavior.zoom=function(){var e,r,n,i,s,l,c,u,h,f={x:0,y:0,k:1},p=[960,500],d=Ut,g=250,m=0,v="mousedown.zoom",y="mousemove.zoom",x="mouseup.zoom",b="touchstart.zoom",_=N(w,"zoomstart","zoom","zoomend");function w(t){t.on(v,P).on(jt+".zoom",z).on("dblclick.zoom",O).on(b,I)}function T(t){return[(t[0]-f.x)/f.k,(t[1]-f.y)/f.k]}function k(t){f.k=Math.max(d[0],Math.min(d[1],t))}function M(t,e){e=function(t){return[t[0]*f.k+f.x,t[1]*f.k+f.y]}(e),f.x+=t[0]-e[0],f.y+=t[1]-e[1]}function A(e,n,a,i){e.__chart__={x:f.x,y:f.y,k:f.k},k(Math.pow(2,i)),M(r=n,a),e=t.select(e),g>0&&(e=e.transition().duration(g)),e.call(w.event)}function S(){c&&c.domain(l.range().map((function(t){return(t-f.x)/f.k})).map(l.invert)),h&&h.domain(u.range().map((function(t){return(t-f.y)/f.k})).map(u.invert))}function E(t){m++||t({type:"zoomstart"})}function C(t){S(),t({type:"zoom",scale:f.k,translate:[f.x,f.y]})}function L(t){--m||(t({type:"zoomend"}),r=null)}function P(){var e=this,r=_.of(e,arguments),n=0,a=t.select(o(e)).on(y,l).on(x,c),i=T(t.mouse(e)),s=bt(e);function l(){n=1,M(t.mouse(e),i),C(r)}function c(){a.on(y,null).on(x,null),s(n),L(r)}vs.call(e),E(r)}function I(){var e,r=this,n=_.of(r,arguments),a={},i=0,o=".zoom-"+t.event.changedTouches[0].identifier,l="touchmove"+o,c="touchend"+o,u=[],h=t.select(r),p=bt(r);function d(){var n=t.touches(r);return e=f.k,n.forEach((function(t){t.identifier in a&&(a[t.identifier]=T(t))})),n}function g(){var e=t.event.target;t.select(e).on(l,m).on(c,y),u.push(e);for(var n=t.event.changedTouches,o=0,h=n.length;o<h;++o)a[n[o].identifier]=null;var p=d(),g=Date.now();if(1===p.length){if(g-s<500){var v=p[0];A(r,v,a[v.identifier],Math.floor(Math.log(f.k)/Math.LN2)+1),F()}s=g}else if(p.length>1){v=p[0];var x=p[1],b=v[0]-x[0],_=v[1]-x[1];i=b*b+_*_}}function m(){var o,l,c,u,h=t.touches(r);vs.call(r);for(var f=0,p=h.length;f<p;++f,u=null)if(c=h[f],u=a[c.identifier]){if(l)break;o=c,l=u}if(u){var d=(d=c[0]-o[0])*d+(d=c[1]-o[1])*d,g=i&&Math.sqrt(d/i);o=[(o[0]+c[0])/2,(o[1]+c[1])/2],l=[(l[0]+u[0])/2,(l[1]+u[1])/2],k(g*e)}s=null,M(o,l),C(n)}function y(){if(t.event.touches.length){for(var e=t.event.changedTouches,r=0,i=e.length;r<i;++r)delete a[e[r].identifier];for(var s in a)return void d()}t.selectAll(u).on(o,null),h.on(v,P).on(b,I),p(),L(n)}g(),E(n),h.on(v,null).on(b,g)}function z(){var a=_.of(this,arguments);i?clearTimeout(i):(vs.call(this),e=T(r=n||t.mouse(this)),E(a)),i=setTimeout((function(){i=null,L(a)}),50),F(),k(Math.pow(2,.002*Nt())*f.k),M(r,e),C(a)}function O(){var e=t.mouse(this),r=Math.log(f.k)/Math.LN2;A(this,e,T(e),t.event.shiftKey?Math.ceil(r)-1:Math.floor(r)+1)}return jt||(jt="onwheel"in a?(Nt=function(){return-t.event.deltaY*(t.event.deltaMode?120:1)},"wheel"):"onmousewheel"in a?(Nt=function(){return t.event.wheelDelta},"mousewheel"):(Nt=function(){return-t.event.detail},"MozMousePixelScroll")),w.event=function(e){e.each((function(){var e=_.of(this,arguments),n=f;bs?t.select(this).transition().each("start.zoom",(function(){f=this.__chart__||{x:0,y:0,k:1},E(e)})).tween("zoom:zoom",(function(){var a=p[0],i=p[1],o=r?r[0]:a/2,s=r?r[1]:i/2,l=t.interpolateZoom([(o-f.x)/f.k,(s-f.y)/f.k,a/f.k],[(o-n.x)/n.k,(s-n.y)/n.k,a/n.k]);return function(t){var r=l(t),n=a/r[2];this.__chart__=f={x:o-r[0]*n,y:s-r[1]*n,k:n},C(e)}})).each("interrupt.zoom",(function(){L(e)})).each("end.zoom",(function(){L(e)})):(this.__chart__=f,E(e),C(e),L(e))}))},w.translate=function(t){return arguments.length?(f={x:+t[0],y:+t[1],k:f.k},S(),w):[f.x,f.y]},w.scale=function(t){return arguments.length?(f={x:f.x,y:f.y,k:null},k(+t),S(),w):f.k},w.scaleExtent=function(t){return arguments.length?(d=null==t?Ut:[+t[0],+t[1]],w):d},w.center=function(t){return arguments.length?(n=t&&[+t[0],+t[1]],w):n},w.size=function(t){return arguments.length?(p=t&&[+t[0],+t[1]],w):p},w.duration=function(t){return arguments.length?(g=+t,w):g},w.x=function(t){return arguments.length?(c=t,l=t.copy(),f={x:0,y:0,k:1},w):c},w.y=function(t){return arguments.length?(h=t,u=t.copy(),f={x:0,y:0,k:1},w):h},t.rebind(w,_,"on")};var Nt,jt,Ut=[0,1/0];function Vt(){}function qt(t,e,r){return this instanceof qt?(this.h=+t,this.s=+e,void(this.l=+r)):arguments.length<2?t instanceof qt?new qt(t.h,t.s,t.l):le(""+t,ce,qt):new qt(t,e,r)}t.color=Vt,Vt.prototype.toString=function(){return this.rgb()+""},t.hsl=qt;var Ht=qt.prototype=new Vt;function Gt(t,e,r){var n,a;function i(t){return Math.round(255*function(t){return t>360?t-=360:t<0&&(t+=360),t<60?n+(a-n)*t/60:t<180?a:t<240?n+(a-n)*(240-t)/60:n}(t))}return t=isNaN(t)?0:(t%=360)<0?t+360:t,e=isNaN(e)||e<0?0:e>1?1:e,n=2*(r=r<0?0:r>1?1:r)-(a=r<=.5?r*(1+e):r+e-r*e),new ne(i(t+120),i(t),i(t-120))}function Yt(e,r,n){return this instanceof Yt?(this.h=+e,this.c=+r,void(this.l=+n)):arguments.length<2?e instanceof Yt?new Yt(e.h,e.c,e.l):$t(e instanceof Xt?e.l:(e=ue((e=t.rgb(e)).r,e.g,e.b)).l,e.a,e.b):new Yt(e,r,n)}Ht.brighter=function(t){return t=Math.pow(.7,arguments.length?t:1),new qt(this.h,this.s,this.l/t)},Ht.darker=function(t){return t=Math.pow(.7,arguments.length?t:1),new qt(this.h,this.s,t*this.l)},Ht.rgb=function(){return Gt(this.h,this.s,this.l)},t.hcl=Yt;var Wt=Yt.prototype=new Vt;function Zt(t,e,r){return isNaN(t)&&(t=0),isNaN(e)&&(e=0),new Xt(r,Math.cos(t*=Lt)*e,Math.sin(t)*e)}function Xt(t,e,r){return this instanceof Xt?(this.l=+t,this.a=+e,void(this.b=+r)):arguments.length<2?t instanceof Xt?new Xt(t.l,t.a,t.b):t instanceof Yt?Zt(t.h,t.c,t.l):ue((t=ne(t)).r,t.g,t.b):new Xt(t,e,r)}Wt.brighter=function(t){return new Yt(this.h,this.c,Math.min(100,this.l+Jt*(arguments.length?t:1)))},Wt.darker=function(t){return new Yt(this.h,this.c,Math.max(0,this.l-Jt*(arguments.length?t:1)))},Wt.rgb=function(){return Zt(this.h,this.c,this.l).rgb()},t.lab=Xt;var Jt=18,Kt=Xt.prototype=new Vt;function Qt(t,e,r){var n=(t+16)/116,a=n+e/500,i=n-r/200;return new ne(re(3.2404542*(a=.95047*te(a))-1.5371385*(n=1*te(n))-.4985314*(i=1.08883*te(i))),re(-.969266*a+1.8760108*n+.041556*i),re(.0556434*a-.2040259*n+1.0572252*i))}function $t(t,e,r){return t>0?new Yt(Math.atan2(r,e)*Pt,Math.sqrt(e*e+r*r),t):new Yt(NaN,NaN,t)}function te(t){return t>.206893034?t*t*t:(t-4/29)/7.787037}function ee(t){return t>.008856?Math.pow(t,1/3):7.787037*t+4/29}function re(t){return Math.round(255*(t<=.00304?12.92*t:1.055*Math.pow(t,1/2.4)-.055))}function ne(t,e,r){return this instanceof ne?(this.r=~~t,this.g=~~e,void(this.b=~~r)):arguments.length<2?t instanceof ne?new ne(t.r,t.g,t.b):le(""+t,ne,Gt):new ne(t,e,r)}function ae(t){return new ne(t>>16,t>>8&255,255&t)}function ie(t){return ae(t)+""}Kt.brighter=function(t){return new Xt(Math.min(100,this.l+Jt*(arguments.length?t:1)),this.a,this.b)},Kt.darker=function(t){return new Xt(Math.max(0,this.l-Jt*(arguments.length?t:1)),this.a,this.b)},Kt.rgb=function(){return Qt(this.l,this.a,this.b)},t.rgb=ne;var oe=ne.prototype=new Vt;function se(t){return t<16?"0"+Math.max(0,t).toString(16):Math.min(255,t).toString(16)}function le(t,e,r){var n,a,i,o=0,s=0,l=0;if(n=/([a-z]+)\((.*)\)/.exec(t=t.toLowerCase()))switch(a=n[2].split(","),n[1]){case"hsl":return r(parseFloat(a[0]),parseFloat(a[1])/100,parseFloat(a[2])/100);case"rgb":return e(fe(a[0]),fe(a[1]),fe(a[2]))}return(i=pe.get(t))?e(i.r,i.g,i.b):(null==t||"#"!==t.charAt(0)||isNaN(i=parseInt(t.slice(1),16))||(4===t.length?(o=(3840&i)>>4,o|=o>>4,s=240&i,s|=s>>4,l=15&i,l|=l<<4):7===t.length&&(o=(16711680&i)>>16,s=(65280&i)>>8,l=255&i)),e(o,s,l))}function ce(t,e,r){var n,a,i=Math.min(t/=255,e/=255,r/=255),o=Math.max(t,e,r),s=o-i,l=(o+i)/2;return s?(a=l<.5?s/(o+i):s/(2-o-i),n=t==o?(e-r)/s+(e<r?6:0):e==o?(r-t)/s+2:(t-e)/s+4,n*=60):(n=NaN,a=l>0&&l<1?0:n),new qt(n,a,l)}function ue(t,e,r){var n=ee((.4124564*(t=he(t))+.3575761*(e=he(e))+.1804375*(r=he(r)))/.95047),a=ee((.2126729*t+.7151522*e+.072175*r)/1);return Xt(116*a-16,500*(n-a),200*(a-ee((.0193339*t+.119192*e+.9503041*r)/1.08883)))}function he(t){return(t/=255)<=.04045?t/12.92:Math.pow((t+.055)/1.055,2.4)}function fe(t){var e=parseFloat(t);return"%"===t.charAt(t.length-1)?Math.round(2.55*e):e}oe.brighter=function(t){t=Math.pow(.7,arguments.length?t:1);var e=this.r,r=this.g,n=this.b,a=30;return e||r||n?(e&&e<a&&(e=a),r&&r<a&&(r=a),n&&n<a&&(n=a),new ne(Math.min(255,e/t),Math.min(255,r/t),Math.min(255,n/t))):new ne(a,a,a)},oe.darker=function(t){return new ne((t=Math.pow(.7,arguments.length?t:1))*this.r,t*this.g,t*this.b)},oe.hsl=function(){return ce(this.r,this.g,this.b)},oe.toString=function(){return"#"+se(this.r)+se(this.g)+se(this.b)};var pe=t.map({aliceblue:15792383,antiquewhite:16444375,aqua:65535,aquamarine:8388564,azure:15794175,beige:16119260,bisque:16770244,black:0,blanchedalmond:16772045,blue:255,blueviolet:9055202,brown:10824234,burlywood:14596231,cadetblue:6266528,chartreuse:8388352,chocolate:13789470,coral:16744272,cornflowerblue:6591981,cornsilk:16775388,crimson:14423100,cyan:65535,darkblue:139,darkcyan:35723,darkgoldenrod:12092939,darkgray:11119017,darkgreen:25600,darkgrey:11119017,darkkhaki:12433259,darkmagenta:9109643,darkolivegreen:5597999,darkorange:16747520,darkorchid:10040012,darkred:9109504,darksalmon:15308410,darkseagreen:9419919,darkslateblue:4734347,darkslategray:3100495,darkslategrey:3100495,darkturquoise:52945,darkviolet:9699539,deeppink:16716947,deepskyblue:49151,dimgray:6908265,dimgrey:6908265,dodgerblue:2003199,firebrick:11674146,floralwhite:16775920,forestgreen:2263842,fuchsia:16711935,gainsboro:14474460,ghostwhite:16316671,gold:16766720,goldenrod:14329120,gray:8421504,green:32768,greenyellow:11403055,grey:8421504,honeydew:15794160,hotpink:16738740,indianred:13458524,indigo:4915330,ivory:16777200,khaki:15787660,lavender:15132410,lavenderblush:16773365,lawngreen:8190976,lemonchiffon:16775885,lightblue:11393254,lightcoral:15761536,lightcyan:14745599,lightgoldenrodyellow:16448210,lightgray:13882323,lightgreen:9498256,lightgrey:13882323,lightpink:16758465,lightsalmon:16752762,lightseagreen:2142890,lightskyblue:8900346,lightslategray:7833753,lightslategrey:7833753,lightsteelblue:11584734,lightyellow:16777184,lime:65280,limegreen:3329330,linen:16445670,magenta:16711935,maroon:8388608,mediumaquamarine:6737322,mediumblue:205,mediumorchid:12211667,mediumpurple:9662683,mediumseagreen:3978097,mediumslateblue:8087790,mediumspringgreen:64154,mediumturquoise:4772300,mediumvioletred:13047173,midnightblue:1644912,mintcream:16121850,mistyrose:16770273,moccasin:16770229,navajowhite:16768685,navy:128,oldlace:16643558,olive:8421376,olivedrab:7048739,orange:16753920,orangered:16729344,orchid:14315734,palegoldenrod:15657130,palegreen:10025880,paleturquoise:11529966,palevioletred:14381203,papayawhip:16773077,peachpuff:16767673,peru:13468991,pink:16761035,plum:14524637,powderblue:11591910,purple:8388736,rebeccapurple:6697881,red:16711680,rosybrown:12357519,royalblue:4286945,saddlebrown:9127187,salmon:16416882,sandybrown:16032864,seagreen:3050327,seashell:16774638,sienna:10506797,silver:12632256,skyblue:8900331,slateblue:6970061,slategray:7372944,slategrey:7372944,snow:16775930,springgreen:65407,steelblue:4620980,tan:13808780,teal:32896,thistle:14204888,tomato:16737095,turquoise:4251856,violet:15631086,wheat:16113331,white:16777215,whitesmoke:16119285,yellow:16776960,yellowgreen:10145074});function de(t){return"function"==typeof t?t:function(){return t}}function ge(t){return function(e,r,n){return 2===arguments.length&&"function"==typeof r&&(n=r,r=null),me(e,r,t,n)}}function me(e,r,a,i){var o={},s=t.dispatch("beforesend","progress","load","error"),l={},c=new XMLHttpRequest,u=null;function h(){var t,e=c.status;if(!e&&function(t){var e=t.responseType;return e&&"text"!==e?t.response:t.responseText}(c)||e>=200&&e<300||304===e){try{t=a.call(o,c)}catch(t){return void s.error.call(o,t)}s.load.call(o,t)}else s.error.call(o,c)}return this.XDomainRequest&&!("withCredentials"in c)&&/^(http(s)?:)?\/\//.test(e)&&(c=new XDomainRequest),"onload"in c?c.onload=c.onerror=h:c.onreadystatechange=function(){c.readyState>3&&h()},c.onprogress=function(e){var r=t.event;t.event=e;try{s.progress.call(o,c)}finally{t.event=r}},o.header=function(t,e){return t=(t+"").toLowerCase(),arguments.length<2?l[t]:(null==e?delete l[t]:l[t]=e+"",o)},o.mimeType=function(t){return arguments.length?(r=null==t?null:t+"",o):r},o.responseType=function(t){return arguments.length?(u=t,o):u},o.response=function(t){return a=t,o},["get","post"].forEach((function(t){o[t]=function(){return o.send.apply(o,[t].concat(n(arguments)))}})),o.send=function(t,n,a){if(2===arguments.length&&"function"==typeof n&&(a=n,n=null),c.open(t,e,!0),null==r||"accept"in l||(l.accept=r+",*/*"),c.setRequestHeader)for(var i in l)c.setRequestHeader(i,l[i]);return null!=r&&c.overrideMimeType&&c.overrideMimeType(r),null!=u&&(c.responseType=u),null!=a&&o.on("error",a).on("load",(function(t){a(null,t)})),s.beforesend.call(o,c),c.send(null==n?null:n),o},o.abort=function(){return c.abort(),o},t.rebind(o,s,"on"),null==i?o:o.get(function(t){return 1===t.length?function(e,r){t(null==e?r:null)}:t}(i))}pe.forEach((function(t,e){pe.set(t,ae(e))})),t.functor=de,t.xhr=ge(L),t.dsv=function(t,e){var r=new RegExp('["'+t+"\n]"),n=t.charCodeAt(0);function a(t,r,n){arguments.length<3&&(n=r,r=null);var a=me(t,e,null==r?i:o(r),n);return a.row=function(t){return arguments.length?a.response(null==(r=t)?i:o(t)):r},a}function i(t){return a.parse(t.responseText)}function o(t){return function(e){return a.parse(e.responseText,t)}}function s(e){return e.map(l).join(t)}function l(t){return r.test(t)?'"'+t.replace(/\"/g,'""')+'"':t}return a.parse=function(t,e){var r;return a.parseRows(t,(function(t,n){if(r)return r(t,n-1);var a=new Function("d","return {"+t.map((function(t,e){return JSON.stringify(t)+": d["+e+"]"})).join(",")+"}");r=e?function(t,r){return e(a(t),r)}:a}))},a.parseRows=function(t,e){var r,a,i={},o={},s=[],l=t.length,c=0,u=0;function h(){if(c>=l)return o;if(a)return a=!1,i;var e=c;if(34===t.charCodeAt(e)){for(var r=e;r++<l;)if(34===t.charCodeAt(r)){if(34!==t.charCodeAt(r+1))break;++r}return c=r+2,13===(s=t.charCodeAt(r+1))?(a=!0,10===t.charCodeAt(r+2)&&++c):10===s&&(a=!0),t.slice(e+1,r).replace(/""/g,'"')}for(;c<l;){var s,u=1;if(10===(s=t.charCodeAt(c++)))a=!0;else if(13===s)a=!0,10===t.charCodeAt(c)&&(++c,++u);else if(s!==n)continue;return t.slice(e,c-u)}return t.slice(e)}for(;(r=h())!==o;){for(var f=[];r!==i&&r!==o;)f.push(r),r=h();e&&null==(f=e(f,u++))||s.push(f)}return s},a.format=function(e){if(Array.isArray(e[0]))return a.formatRows(e);var r=new C,n=[];return e.forEach((function(t){for(var e in t)r.has(e)||n.push(r.add(e))})),[n.map(l).join(t)].concat(e.map((function(e){return n.map((function(t){return l(e[t])})).join(t)}))).join("\n")},a.formatRows=function(t){return t.map(s).join("\n")},a},t.csv=t.dsv(",","text/csv"),t.tsv=t.dsv("\t","text/tab-separated-values");var ve,ye,xe,be,_e=this[I(this,"requestAnimationFrame")]||function(t){setTimeout(t,17)};function we(t,e,r){var n=arguments.length;n<2&&(e=0),n<3&&(r=Date.now());var a=r+e,i={c:t,t:a,n:null};return ye?ye.n=i:ve=i,ye=i,xe||(be=clearTimeout(be),xe=1,_e(Te)),i}function Te(){var t=ke(),e=Me()-t;e>24?(isFinite(e)&&(clearTimeout(be),be=setTimeout(Te,e)),xe=0):(xe=1,_e(Te))}function ke(){for(var t=Date.now(),e=ve;e;)t>=e.t&&e.c(t-e.t)&&(e.c=null),e=e.n;return t}function Me(){for(var t,e=ve,r=1/0;e;)e.c?(e.t<r&&(r=e.t),e=(t=e).n):e=t?t.n=e.n:ve=e.n;return ye=t,r}function Ae(t,e){return e-(t?Math.ceil(Math.log(t)/Math.LN10):1)}t.timer=function(){we.apply(this,arguments)},t.timer.flush=function(){ke(),Me()},t.round=function(t,e){return e?Math.round(t*(e=Math.pow(10,e)))/e:Math.round(t)};var Se=["y","z","a","f","p","n","\xb5","m","","k","M","G","T","P","E","Z","Y"].map((function(t,e){var r=Math.pow(10,3*y(8-e));return{scale:e>8?function(t){return t/r}:function(t){return t*r},symbol:t}}));function Ee(e){var r=e.decimal,n=e.thousands,a=e.grouping,i=e.currency,o=a&&n?function(t,e){for(var r=t.length,i=[],o=0,s=a[0],l=0;r>0&&s>0&&(l+s+1>e&&(s=Math.max(1,e-l)),i.push(t.substring(r-=s,r+s)),!((l+=s+1)>e));)s=a[o=(o+1)%a.length];return i.reverse().join(n)}:L;return function(e){var n=Ce.exec(e),a=n[1]||" ",s=n[2]||">",l=n[3]||"-",c=n[4]||"",u=n[5],h=+n[6],f=n[7],p=n[8],d=n[9],g=1,m="",v="",y=!1,x=!0;switch(p&&(p=+p.substring(1)),(u||"0"===a&&"="===s)&&(u=a="0",s="="),d){case"n":f=!0,d="g";break;case"%":g=100,v="%",d="f";break;case"p":g=100,v="%",d="r";break;case"b":case"o":case"x":case"X":"#"===c&&(m="0"+d.toLowerCase());case"c":x=!1;case"d":y=!0,p=0;break;case"s":g=-1,d="r"}"$"===c&&(m=i[0],v=i[1]),"r"!=d||p||(d="g"),null!=p&&("g"==d?p=Math.max(1,Math.min(21,p)):"e"!=d&&"f"!=d||(p=Math.max(0,Math.min(20,p)))),d=Le.get(d)||Pe;var b=u&&f;return function(e){var n=v;if(y&&e%1)return"";var i=e<0||0===e&&1/e<0?(e=-e,"-"):"-"===l?"":l;if(g<0){var c=t.formatPrefix(e,p);e=c.scale(e),n=c.symbol+v}else e*=g;var _,w,T=(e=d(e,p)).lastIndexOf(".");if(T<0){var k=x?e.lastIndexOf("e"):-1;k<0?(_=e,w=""):(_=e.substring(0,k),w=e.substring(k))}else _=e.substring(0,T),w=r+e.substring(T+1);!u&&f&&(_=o(_,1/0));var M=m.length+_.length+w.length+(b?0:i.length),A=M<h?new Array(M=h-M+1).join(a):"";return b&&(_=o(A+_,A.length?h-w.length:1/0)),i+=m,e=_+w,("<"===s?i+e+A:">"===s?A+i+e:"^"===s?A.substring(0,M>>=1)+i+e+A.substring(M):i+(b?e:A+e))+n}}}t.formatPrefix=function(e,r){var n=0;return(e=+e)&&(e<0&&(e*=-1),r&&(e=t.round(e,Ae(e,r))),n=1+Math.floor(1e-12+Math.log(e)/Math.LN10),n=Math.max(-24,Math.min(24,3*Math.floor((n-1)/3)))),Se[8+n/3]};var Ce=/(?:([^{])?([<>=^]))?([+\- ])?([$#])?(0)?(\d+)?(,)?(\.-?\d+)?([a-z%])?/i,Le=t.map({b:function(t){return t.toString(2)},c:function(t){return String.fromCharCode(t)},o:function(t){return t.toString(8)},x:function(t){return t.toString(16)},X:function(t){return t.toString(16).toUpperCase()},g:function(t,e){return t.toPrecision(e)},e:function(t,e){return t.toExponential(e)},f:function(t,e){return t.toFixed(e)},r:function(e,r){return(e=t.round(e,Ae(e,r))).toFixed(Math.max(0,Math.min(20,Ae(e*(1+1e-15),r))))}});function Pe(t){return t+""}var Ie=t.time={},ze=Date;function Oe(){this._=new Date(arguments.length>1?Date.UTC.apply(this,arguments):arguments[0])}Oe.prototype={getDate:function(){return this._.getUTCDate()},getDay:function(){return this._.getUTCDay()},getFullYear:function(){return this._.getUTCFullYear()},getHours:function(){return this._.getUTCHours()},getMilliseconds:function(){return this._.getUTCMilliseconds()},getMinutes:function(){return this._.getUTCMinutes()},getMonth:function(){return this._.getUTCMonth()},getSeconds:function(){return this._.getUTCSeconds()},getTime:function(){return this._.getTime()},getTimezoneOffset:function(){return 0},valueOf:function(){return this._.valueOf()},setDate:function(){De.setUTCDate.apply(this._,arguments)},setDay:function(){De.setUTCDay.apply(this._,arguments)},setFullYear:function(){De.setUTCFullYear.apply(this._,arguments)},setHours:function(){De.setUTCHours.apply(this._,arguments)},setMilliseconds:function(){De.setUTCMilliseconds.apply(this._,arguments)},setMinutes:function(){De.setUTCMinutes.apply(this._,arguments)},setMonth:function(){De.setUTCMonth.apply(this._,arguments)},setSeconds:function(){De.setUTCSeconds.apply(this._,arguments)},setTime:function(){De.setTime.apply(this._,arguments)}};var De=Date.prototype;function Re(t,e,r){function n(e){var r=t(e),n=i(r,1);return e-r<n-e?r:n}function a(r){return e(r=t(new ze(r-1)),1),r}function i(t,r){return e(t=new ze(+t),r),t}function o(t,n,i){var o=a(t),s=[];if(i>1)for(;o<n;)r(o)%i||s.push(new Date(+o)),e(o,1);else for(;o<n;)s.push(new Date(+o)),e(o,1);return s}t.floor=t,t.round=n,t.ceil=a,t.offset=i,t.range=o;var s=t.utc=Fe(t);return s.floor=s,s.round=Fe(n),s.ceil=Fe(a),s.offset=Fe(i),s.range=function(t,e,r){try{ze=Oe;var n=new Oe;return n._=t,o(n,e,r)}finally{ze=Date}},t}function Fe(t){return function(e,r){try{ze=Oe;var n=new Oe;return n._=e,t(n,r)._}finally{ze=Date}}}function Be(e){var r=e.dateTime,n=e.date,a=e.time,i=e.periods,o=e.days,s=e.shortDays,l=e.months,c=e.shortMonths;function u(t){var e=t.length;function r(r){for(var n,a,i,o=[],s=-1,l=0;++s<e;)37===t.charCodeAt(s)&&(o.push(t.slice(l,s)),null!=(a=Ne[n=t.charAt(++s)])&&(n=t.charAt(++s)),(i=_[n])&&(n=i(r,null==a?"e"===n?" ":"0":a)),o.push(n),l=s+1);return o.push(t.slice(l,s)),o.join("")}return r.parse=function(e){var r={y:1900,m:0,d:1,H:0,M:0,S:0,L:0,Z:null};if(h(r,t,e,0)!=e.length)return null;"p"in r&&(r.H=r.H%12+12*r.p);var n=null!=r.Z&&ze!==Oe,a=new(n?Oe:ze);return"j"in r?a.setFullYear(r.y,0,r.j):"W"in r||"U"in r?("w"in r||(r.w="W"in r?1:0),a.setFullYear(r.y,0,1),a.setFullYear(r.y,0,"W"in r?(r.w+6)%7+7*r.W-(a.getDay()+5)%7:r.w+7*r.U-(a.getDay()+6)%7)):a.setFullYear(r.y,r.m,r.d),a.setHours(r.H+(r.Z/100|0),r.M+r.Z%100,r.S,r.L),n?a._:a},r.toString=function(){return t},r}function h(t,e,r,n){for(var a,i,o,s=0,l=e.length,c=r.length;s<l;){if(n>=c)return-1;if(37===(a=e.charCodeAt(s++))){if(o=e.charAt(s++),!(i=w[o in Ne?e.charAt(s++):o])||(n=i(t,r,n))<0)return-1}else if(a!=r.charCodeAt(n++))return-1}return n}u.utc=function(t){var e=u(t);function r(t){try{var r=new(ze=Oe);return r._=t,e(r)}finally{ze=Date}}return r.parse=function(t){try{ze=Oe;var r=e.parse(t);return r&&r._}finally{ze=Date}},r.toString=e.toString,r},u.multi=u.utc.multi=or;var f=t.map(),p=qe(o),d=He(o),g=qe(s),m=He(s),v=qe(l),y=He(l),x=qe(c),b=He(c);i.forEach((function(t,e){f.set(t.toLowerCase(),e)}));var _={a:function(t){return s[t.getDay()]},A:function(t){return o[t.getDay()]},b:function(t){return c[t.getMonth()]},B:function(t){return l[t.getMonth()]},c:u(r),d:function(t,e){return Ve(t.getDate(),e,2)},e:function(t,e){return Ve(t.getDate(),e,2)},H:function(t,e){return Ve(t.getHours(),e,2)},I:function(t,e){return Ve(t.getHours()%12||12,e,2)},j:function(t,e){return Ve(1+Ie.dayOfYear(t),e,3)},L:function(t,e){return Ve(t.getMilliseconds(),e,3)},m:function(t,e){return Ve(t.getMonth()+1,e,2)},M:function(t,e){return Ve(t.getMinutes(),e,2)},p:function(t){return i[+(t.getHours()>=12)]},S:function(t,e){return Ve(t.getSeconds(),e,2)},U:function(t,e){return Ve(Ie.sundayOfYear(t),e,2)},w:function(t){return t.getDay()},W:function(t,e){return Ve(Ie.mondayOfYear(t),e,2)},x:u(n),X:u(a),y:function(t,e){return Ve(t.getFullYear()%100,e,2)},Y:function(t,e){return Ve(t.getFullYear()%1e4,e,4)},Z:ar,"%":function(){return"%"}},w={a:function(t,e,r){g.lastIndex=0;var n=g.exec(e.slice(r));return n?(t.w=m.get(n[0].toLowerCase()),r+n[0].length):-1},A:function(t,e,r){p.lastIndex=0;var n=p.exec(e.slice(r));return n?(t.w=d.get(n[0].toLowerCase()),r+n[0].length):-1},b:function(t,e,r){x.lastIndex=0;var n=x.exec(e.slice(r));return n?(t.m=b.get(n[0].toLowerCase()),r+n[0].length):-1},B:function(t,e,r){v.lastIndex=0;var n=v.exec(e.slice(r));return n?(t.m=y.get(n[0].toLowerCase()),r+n[0].length):-1},c:function(t,e,r){return h(t,_.c.toString(),e,r)},d:Qe,e:Qe,H:tr,I:tr,j:$e,L:nr,m:Ke,M:er,p:function(t,e,r){var n=f.get(e.slice(r,r+=2).toLowerCase());return null==n?-1:(t.p=n,r)},S:rr,U:Ye,w:Ge,W:We,x:function(t,e,r){return h(t,_.x.toString(),e,r)},X:function(t,e,r){return h(t,_.X.toString(),e,r)},y:Xe,Y:Ze,Z:Je,"%":ir};return u}Ie.year=Re((function(t){return(t=Ie.day(t)).setMonth(0,1),t}),(function(t,e){t.setFullYear(t.getFullYear()+e)}),(function(t){return t.getFullYear()})),Ie.years=Ie.year.range,Ie.years.utc=Ie.year.utc.range,Ie.day=Re((function(t){var e=new ze(2e3,0);return e.setFullYear(t.getFullYear(),t.getMonth(),t.getDate()),e}),(function(t,e){t.setDate(t.getDate()+e)}),(function(t){return t.getDate()-1})),Ie.days=Ie.day.range,Ie.days.utc=Ie.day.utc.range,Ie.dayOfYear=function(t){var e=Ie.year(t);return Math.floor((t-e-6e4*(t.getTimezoneOffset()-e.getTimezoneOffset()))/864e5)},["sunday","monday","tuesday","wednesday","thursday","friday","saturday"].forEach((function(t,e){e=7-e;var r=Ie[t]=Re((function(t){return(t=Ie.day(t)).setDate(t.getDate()-(t.getDay()+e)%7),t}),(function(t,e){t.setDate(t.getDate()+7*Math.floor(e))}),(function(t){var r=Ie.year(t).getDay();return Math.floor((Ie.dayOfYear(t)+(r+e)%7)/7)-(r!==e)}));Ie[t+"s"]=r.range,Ie[t+"s"].utc=r.utc.range,Ie[t+"OfYear"]=function(t){var r=Ie.year(t).getDay();return Math.floor((Ie.dayOfYear(t)+(r+e)%7)/7)}})),Ie.week=Ie.sunday,Ie.weeks=Ie.sunday.range,Ie.weeks.utc=Ie.sunday.utc.range,Ie.weekOfYear=Ie.sundayOfYear;var Ne={"-":"",_:" ",0:"0"},je=/^\s*\d+/,Ue=/^%/;function Ve(t,e,r){var n=t<0?"-":"",a=(n?-t:t)+"",i=a.length;return n+(i<r?new Array(r-i+1).join(e)+a:a)}function qe(e){return new RegExp("^(?:"+e.map(t.requote).join("|")+")","i")}function He(t){for(var e=new _,r=-1,n=t.length;++r<n;)e.set(t[r].toLowerCase(),r);return e}function Ge(t,e,r){je.lastIndex=0;var n=je.exec(e.slice(r,r+1));return n?(t.w=+n[0],r+n[0].length):-1}function Ye(t,e,r){je.lastIndex=0;var n=je.exec(e.slice(r));return n?(t.U=+n[0],r+n[0].length):-1}function We(t,e,r){je.lastIndex=0;var n=je.exec(e.slice(r));return n?(t.W=+n[0],r+n[0].length):-1}function Ze(t,e,r){je.lastIndex=0;var n=je.exec(e.slice(r,r+4));return n?(t.y=+n[0],r+n[0].length):-1}function Xe(t,e,r){je.lastIndex=0;var n,a=je.exec(e.slice(r,r+2));return a?(t.y=(n=+a[0])+(n>68?1900:2e3),r+a[0].length):-1}function Je(t,e,r){return/^[+-]\d{4}$/.test(e=e.slice(r,r+5))?(t.Z=-e,r+5):-1}function Ke(t,e,r){je.lastIndex=0;var n=je.exec(e.slice(r,r+2));return n?(t.m=n[0]-1,r+n[0].length):-1}function Qe(t,e,r){je.lastIndex=0;var n=je.exec(e.slice(r,r+2));return n?(t.d=+n[0],r+n[0].length):-1}function $e(t,e,r){je.lastIndex=0;var n=je.exec(e.slice(r,r+3));return n?(t.j=+n[0],r+n[0].length):-1}function tr(t,e,r){je.lastIndex=0;var n=je.exec(e.slice(r,r+2));return n?(t.H=+n[0],r+n[0].length):-1}function er(t,e,r){je.lastIndex=0;var n=je.exec(e.slice(r,r+2));return n?(t.M=+n[0],r+n[0].length):-1}function rr(t,e,r){je.lastIndex=0;var n=je.exec(e.slice(r,r+2));return n?(t.S=+n[0],r+n[0].length):-1}function nr(t,e,r){je.lastIndex=0;var n=je.exec(e.slice(r,r+3));return n?(t.L=+n[0],r+n[0].length):-1}function ar(t){var e=t.getTimezoneOffset(),r=e>0?"-":"+",n=y(e)/60|0,a=y(e)%60;return r+Ve(n,"0",2)+Ve(a,"0",2)}function ir(t,e,r){Ue.lastIndex=0;var n=Ue.exec(e.slice(r,r+1));return n?r+n[0].length:-1}function or(t){for(var e=t.length,r=-1;++r<e;)t[r][0]=this(t[r][0]);return function(e){for(var r=0,n=t[r];!n[1](e);)n=t[++r];return n[0](e)}}t.locale=function(t){return{numberFormat:Ee(t),timeFormat:Be(t)}};var sr=t.locale({decimal:".",thousands:",",grouping:[3],currency:["$",""],dateTime:"%a %b %e %X %Y",date:"%m/%d/%Y",time:"%H:%M:%S",periods:["AM","PM"],days:["Sunday","Monday","Tuesday","Wednesday","Thursday","Friday","Saturday"],shortDays:["Sun","Mon","Tue","Wed","Thu","Fri","Sat"],months:["January","February","March","April","May","June","July","August","September","October","November","December"],shortMonths:["Jan","Feb","Mar","Apr","May","Jun","Jul","Aug","Sep","Oct","Nov","Dec"]});function lr(){}t.format=sr.numberFormat,t.geo={},lr.prototype={s:0,t:0,add:function(t){ur(t,this.t,cr),ur(cr.s,this.s,this),this.s?this.t+=cr.t:this.s=cr.t},reset:function(){this.s=this.t=0},valueOf:function(){return this.s}};var cr=new lr;function ur(t,e,r){var n=r.s=t+e,a=n-t,i=n-a;r.t=t-i+(e-a)}function hr(t,e){t&&pr.hasOwnProperty(t.type)&&pr[t.type](t,e)}t.geo.stream=function(t,e){t&&fr.hasOwnProperty(t.type)?fr[t.type](t,e):hr(t,e)};var fr={Feature:function(t,e){hr(t.geometry,e)},FeatureCollection:function(t,e){for(var r=t.features,n=-1,a=r.length;++n<a;)hr(r[n].geometry,e)}},pr={Sphere:function(t,e){e.sphere()},Point:function(t,e){t=t.coordinates,e.point(t[0],t[1],t[2])},MultiPoint:function(t,e){for(var r=t.coordinates,n=-1,a=r.length;++n<a;)t=r[n],e.point(t[0],t[1],t[2])},LineString:function(t,e){dr(t.coordinates,e,0)},MultiLineString:function(t,e){for(var r=t.coordinates,n=-1,a=r.length;++n<a;)dr(r[n],e,0)},Polygon:function(t,e){gr(t.coordinates,e)},MultiPolygon:function(t,e){for(var r=t.coordinates,n=-1,a=r.length;++n<a;)gr(r[n],e)},GeometryCollection:function(t,e){for(var r=t.geometries,n=-1,a=r.length;++n<a;)hr(r[n],e)}};function dr(t,e,r){var n,a=-1,i=t.length-r;for(e.lineStart();++a<i;)n=t[a],e.point(n[0],n[1],n[2]);e.lineEnd()}function gr(t,e){var r=-1,n=t.length;for(e.polygonStart();++r<n;)dr(t[r],e,1);e.polygonEnd()}t.geo.area=function(e){return mr=0,t.geo.stream(e,Cr),mr};var mr,vr,yr,xr,br,_r,wr,Tr,kr,Mr,Ar,Sr,Er=new lr,Cr={sphere:function(){mr+=4*At},point:O,lineStart:O,lineEnd:O,polygonStart:function(){Er.reset(),Cr.lineStart=Lr},polygonEnd:function(){var t=2*Er;mr+=t<0?4*At+t:t,Cr.lineStart=Cr.lineEnd=Cr.point=O}};function Lr(){var t,e,r,n,a;function i(t,e){e=e*Lt/2+At/4;var i=(t*=Lt)-r,o=i>=0?1:-1,s=o*i,l=Math.cos(e),c=Math.sin(e),u=a*c,h=n*l+u*Math.cos(s),f=u*o*Math.sin(s);Er.add(Math.atan2(f,h)),r=t,n=l,a=c}Cr.point=function(o,s){Cr.point=i,r=(t=o)*Lt,n=Math.cos(s=(e=s)*Lt/2+At/4),a=Math.sin(s)},Cr.lineEnd=function(){i(t,e)}}function Pr(t){var e=t[0],r=t[1],n=Math.cos(r);return[n*Math.cos(e),n*Math.sin(e),Math.sin(r)]}function Ir(t,e){return t[0]*e[0]+t[1]*e[1]+t[2]*e[2]}function zr(t,e){return[t[1]*e[2]-t[2]*e[1],t[2]*e[0]-t[0]*e[2],t[0]*e[1]-t[1]*e[0]]}function Or(t,e){t[0]+=e[0],t[1]+=e[1],t[2]+=e[2]}function Dr(t,e){return[t[0]*e,t[1]*e,t[2]*e]}function Rr(t){var e=Math.sqrt(t[0]*t[0]+t[1]*t[1]+t[2]*t[2]);t[0]/=e,t[1]/=e,t[2]/=e}function Fr(t){return[Math.atan2(t[1],t[0]),Dt(t[2])]}function Br(t,e){return y(t[0]-e[0])<kt&&y(t[1]-e[1])<kt}t.geo.bounds=function(){var e,r,n,a,i,o,s,l,c,u,h,f={point:p,lineStart:g,lineEnd:m,polygonStart:function(){f.point=v,f.lineStart=x,f.lineEnd=b,c=0,Cr.polygonStart()},polygonEnd:function(){Cr.polygonEnd(),f.point=p,f.lineStart=g,f.lineEnd=m,Er<0?(e=-(n=180),r=-(a=90)):c>kt?a=90:c<-kt&&(r=-90),h[0]=e,h[1]=n}};function p(t,i){u.push(h=[e=t,n=t]),i<r&&(r=i),i>a&&(a=i)}function d(t,o){var s=Pr([t*Lt,o*Lt]);if(l){var c=zr(l,s),u=zr([c[1],-c[0],0],c);Rr(u),u=Fr(u);var h=t-i,f=h>0?1:-1,d=u[0]*Pt*f,g=y(h)>180;if(g^(f*i<d&&d<f*t))(m=u[1]*Pt)>a&&(a=m);else if(g^(f*i<(d=(d+360)%360-180)&&d<f*t)){var m;(m=-u[1]*Pt)<r&&(r=m)}else o<r&&(r=o),o>a&&(a=o);g?t<i?_(e,t)>_(e,n)&&(n=t):_(t,n)>_(e,n)&&(e=t):n>=e?(t<e&&(e=t),t>n&&(n=t)):t>i?_(e,t)>_(e,n)&&(n=t):_(t,n)>_(e,n)&&(e=t)}else p(t,o);l=s,i=t}function g(){f.point=d}function m(){h[0]=e,h[1]=n,f.point=p,l=null}function v(t,e){if(l){var r=t-i;c+=y(r)>180?r+(r>0?360:-360):r}else o=t,s=e;Cr.point(t,e),d(t,e)}function x(){Cr.lineStart()}function b(){v(o,s),Cr.lineEnd(),y(c)>kt&&(e=-(n=180)),h[0]=e,h[1]=n,l=null}function _(t,e){return(e-=t)<0?e+360:e}function w(t,e){return t[0]-e[0]}function T(t,e){return e[0]<=e[1]?e[0]<=t&&t<=e[1]:t<e[0]||e[1]<t}return function(i){if(a=n=-(e=r=1/0),u=[],t.geo.stream(i,f),c=u.length){u.sort(w);for(var o=1,s=[g=u[0]];o<c;++o)T((p=u[o])[0],g)||T(p[1],g)?(_(g[0],p[1])>_(g[0],g[1])&&(g[1]=p[1]),_(p[0],g[1])>_(g[0],g[1])&&(g[0]=p[0])):s.push(g=p);for(var l,c,p,d=-1/0,g=(o=0,s[c=s.length-1]);o<=c;g=p,++o)p=s[o],(l=_(g[1],p[0]))>d&&(d=l,e=p[0],n=g[1])}return u=h=null,e===1/0||r===1/0?[[NaN,NaN],[NaN,NaN]]:[[e,r],[n,a]]}}(),t.geo.centroid=function(e){vr=yr=xr=br=_r=wr=Tr=kr=Mr=Ar=Sr=0,t.geo.stream(e,Nr);var r=Mr,n=Ar,a=Sr,i=r*r+n*n+a*a;return i<Mt&&(r=wr,n=Tr,a=kr,yr<kt&&(r=xr,n=br,a=_r),(i=r*r+n*n+a*a)<Mt)?[NaN,NaN]:[Math.atan2(n,r)*Pt,Dt(a/Math.sqrt(i))*Pt]};var Nr={sphere:O,point:jr,lineStart:Vr,lineEnd:qr,polygonStart:function(){Nr.lineStart=Hr},polygonEnd:function(){Nr.lineStart=Vr}};function jr(t,e){t*=Lt;var r=Math.cos(e*=Lt);Ur(r*Math.cos(t),r*Math.sin(t),Math.sin(e))}function Ur(t,e,r){++vr,xr+=(t-xr)/vr,br+=(e-br)/vr,_r+=(r-_r)/vr}function Vr(){var t,e,r;function n(n,a){n*=Lt;var i=Math.cos(a*=Lt),o=i*Math.cos(n),s=i*Math.sin(n),l=Math.sin(a),c=Math.atan2(Math.sqrt((c=e*l-r*s)*c+(c=r*o-t*l)*c+(c=t*s-e*o)*c),t*o+e*s+r*l);yr+=c,wr+=c*(t+(t=o)),Tr+=c*(e+(e=s)),kr+=c*(r+(r=l)),Ur(t,e,r)}Nr.point=function(a,i){a*=Lt;var o=Math.cos(i*=Lt);t=o*Math.cos(a),e=o*Math.sin(a),r=Math.sin(i),Nr.point=n,Ur(t,e,r)}}function qr(){Nr.point=jr}function Hr(){var t,e,r,n,a;function i(t,e){t*=Lt;var i=Math.cos(e*=Lt),o=i*Math.cos(t),s=i*Math.sin(t),l=Math.sin(e),c=n*l-a*s,u=a*o-r*l,h=r*s-n*o,f=Math.sqrt(c*c+u*u+h*h),p=r*o+n*s+a*l,d=f&&-Ot(p)/f,g=Math.atan2(f,p);Mr+=d*c,Ar+=d*u,Sr+=d*h,yr+=g,wr+=g*(r+(r=o)),Tr+=g*(n+(n=s)),kr+=g*(a+(a=l)),Ur(r,n,a)}Nr.point=function(o,s){t=o,e=s,Nr.point=i,o*=Lt;var l=Math.cos(s*=Lt);r=l*Math.cos(o),n=l*Math.sin(o),a=Math.sin(s),Ur(r,n,a)},Nr.lineEnd=function(){i(t,e),Nr.lineEnd=qr,Nr.point=jr}}function Gr(t,e){function r(r,n){return r=t(r,n),e(r[0],r[1])}return t.invert&&e.invert&&(r.invert=function(r,n){return(r=e.invert(r,n))&&t.invert(r[0],r[1])}),r}function Yr(){return!0}function Wr(t,e,r,n,a){var i=[],o=[];if(t.forEach((function(t){if(!((e=t.length-1)<=0)){var e,r=t[0],n=t[e];if(Br(r,n)){a.lineStart();for(var s=0;s<e;++s)a.point((r=t[s])[0],r[1]);a.lineEnd()}else{var l=new Xr(r,t,null,!0),c=new Xr(r,null,l,!1);l.o=c,i.push(l),o.push(c),l=new Xr(n,t,null,!1),c=new Xr(n,null,l,!0),l.o=c,i.push(l),o.push(c)}}})),o.sort(e),Zr(i),Zr(o),i.length){for(var s=0,l=r,c=o.length;s<c;++s)o[s].e=l=!l;for(var u,h,f=i[0];;){for(var p=f,d=!0;p.v;)if((p=p.n)===f)return;u=p.z,a.lineStart();do{if(p.v=p.o.v=!0,p.e){if(d)for(s=0,c=u.length;s<c;++s)a.point((h=u[s])[0],h[1]);else n(p.x,p.n.x,1,a);p=p.n}else{if(d)for(s=(u=p.p.z).length-1;s>=0;--s)a.point((h=u[s])[0],h[1]);else n(p.x,p.p.x,-1,a);p=p.p}u=(p=p.o).z,d=!d}while(!p.v);a.lineEnd()}}}function Zr(t){if(e=t.length){for(var e,r,n=0,a=t[0];++n<e;)a.n=r=t[n],r.p=a,a=r;a.n=r=t[0],r.p=a}}function Xr(t,e,r,n){this.x=t,this.z=e,this.o=r,this.e=n,this.v=!1,this.n=this.p=null}function Jr(e,r,n,a){return function(i,o){var s,l=r(o),c=i.invert(a[0],a[1]),u={point:h,lineStart:p,lineEnd:d,polygonStart:function(){u.point=b,u.lineStart=_,u.lineEnd=w,s=[],g=[]},polygonEnd:function(){u.point=h,u.lineStart=p,u.lineEnd=d,s=t.merge(s);var e=function(t,e){var r=t[0],n=t[1],a=[Math.sin(r),-Math.cos(r),0],i=0,o=0;Er.reset();for(var s=0,l=e.length;s<l;++s){var c=e[s],u=c.length;if(u)for(var h=c[0],f=h[0],p=h[1]/2+At/4,d=Math.sin(p),g=Math.cos(p),m=1;;){m===u&&(m=0);var v=(t=c[m])[0],y=t[1]/2+At/4,x=Math.sin(y),b=Math.cos(y),_=v-f,w=_>=0?1:-1,T=w*_,k=T>At,M=d*x;if(Er.add(Math.atan2(M*w*Math.sin(T),g*b+M*Math.cos(T))),i+=k?_+w*St:_,k^f>=r^v>=r){var A=zr(Pr(h),Pr(t));Rr(A);var S=zr(a,A);Rr(S);var E=(k^_>=0?-1:1)*Dt(S[2]);(n>E||n===E&&(A[0]||A[1]))&&(o+=k^_>=0?1:-1)}if(!m++)break;f=v,d=x,g=b,h=t}}return(i<-kt||i<kt&&Er<-kt)^1&o}(c,g);s.length?(x||(o.polygonStart(),x=!0),Wr(s,$r,e,n,o)):e&&(x||(o.polygonStart(),x=!0),o.lineStart(),n(null,null,1,o),o.lineEnd()),x&&(o.polygonEnd(),x=!1),s=g=null},sphere:function(){o.polygonStart(),o.lineStart(),n(null,null,1,o),o.lineEnd(),o.polygonEnd()}};function h(t,r){var n=i(t,r);e(t=n[0],r=n[1])&&o.point(t,r)}function f(t,e){var r=i(t,e);l.point(r[0],r[1])}function p(){u.point=f,l.lineStart()}function d(){u.point=h,l.lineEnd()}var g,m,v=Qr(),y=r(v),x=!1;function b(t,e){m.push([t,e]);var r=i(t,e);y.point(r[0],r[1])}function _(){y.lineStart(),m=[]}function w(){b(m[0][0],m[0][1]),y.lineEnd();var t,e=y.clean(),r=v.buffer(),n=r.length;if(m.pop(),g.push(m),m=null,n)if(1&e){var a,i=-1;if((n=(t=r[0]).length-1)>0){for(x||(o.polygonStart(),x=!0),o.lineStart();++i<n;)o.point((a=t[i])[0],a[1]);o.lineEnd()}}else n>1&&2&e&&r.push(r.pop().concat(r.shift())),s.push(r.filter(Kr))}return u}}function Kr(t){return t.length>1}function Qr(){var t,e=[];return{lineStart:function(){e.push(t=[])},point:function(e,r){t.push([e,r])},lineEnd:O,buffer:function(){var r=e;return e=[],t=null,r},rejoin:function(){e.length>1&&e.push(e.pop().concat(e.shift()))}}}function $r(t,e){return((t=t.x)[0]<0?t[1]-Ct-kt:Ct-t[1])-((e=e.x)[0]<0?e[1]-Ct-kt:Ct-e[1])}var tn=Jr(Yr,(function(t){var e,r=NaN,n=NaN,a=NaN;return{lineStart:function(){t.lineStart(),e=1},point:function(i,o){var s=i>0?At:-At,l=y(i-r);y(l-At)<kt?(t.point(r,n=(n+o)/2>0?Ct:-Ct),t.point(a,n),t.lineEnd(),t.lineStart(),t.point(s,n),t.point(i,n),e=0):a!==s&&l>=At&&(y(r-a)<kt&&(r-=a*kt),y(i-s)<kt&&(i-=s*kt),n=function(t,e,r,n){var a,i,o=Math.sin(t-r);return y(o)>kt?Math.atan((Math.sin(e)*(i=Math.cos(n))*Math.sin(r)-Math.sin(n)*(a=Math.cos(e))*Math.sin(t))/(a*i*o)):(e+n)/2}(r,n,i,o),t.point(a,n),t.lineEnd(),t.lineStart(),t.point(s,n),e=0),t.point(r=i,n=o),a=s},lineEnd:function(){t.lineEnd(),r=n=NaN},clean:function(){return 2-e}}}),(function(t,e,r,n){var a;if(null==t)a=r*Ct,n.point(-At,a),n.point(0,a),n.point(At,a),n.point(At,0),n.point(At,-a),n.point(0,-a),n.point(-At,-a),n.point(-At,0),n.point(-At,a);else if(y(t[0]-e[0])>kt){var i=t[0]<e[0]?At:-At;a=r*i/2,n.point(-i,a),n.point(0,a),n.point(i,a)}else n.point(e[0],e[1])}),[-At,-At/2]);function en(t){var e=Math.cos(t),r=e>0,n=y(e)>kt;return Jr(a,(function(t){var e,s,l,c,u;return{lineStart:function(){c=l=!1,u=1},point:function(h,f){var p,d=[h,f],g=a(h,f),m=r?g?0:o(h,f):g?o(h+(h<0?At:-At),f):0;if(!e&&(c=l=g)&&t.lineStart(),g!==l&&(p=i(e,d),(Br(e,p)||Br(d,p))&&(d[0]+=kt,d[1]+=kt,g=a(d[0],d[1]))),g!==l)u=0,g?(t.lineStart(),p=i(d,e),t.point(p[0],p[1])):(p=i(e,d),t.point(p[0],p[1]),t.lineEnd()),e=p;else if(n&&e&&r^g){var v;m&s||!(v=i(d,e,!0))||(u=0,r?(t.lineStart(),t.point(v[0][0],v[0][1]),t.point(v[1][0],v[1][1]),t.lineEnd()):(t.point(v[1][0],v[1][1]),t.lineEnd(),t.lineStart(),t.point(v[0][0],v[0][1])))}!g||e&&Br(e,d)||t.point(d[0],d[1]),e=d,l=g,s=m},lineEnd:function(){l&&t.lineEnd(),e=null},clean:function(){return u|(c&&l)<<1}}}),Bn(t,6*Lt),r?[0,-t]:[-At,t-At]);function a(t,r){return Math.cos(t)*Math.cos(r)>e}function i(t,r,n){var a=[1,0,0],i=zr(Pr(t),Pr(r)),o=Ir(i,i),s=i[0],l=o-s*s;if(!l)return!n&&t;var c=e*o/l,u=-e*s/l,h=zr(a,i),f=Dr(a,c);Or(f,Dr(i,u));var p=h,d=Ir(f,p),g=Ir(p,p),m=d*d-g*(Ir(f,f)-1);if(!(m<0)){var v=Math.sqrt(m),x=Dr(p,(-d-v)/g);if(Or(x,f),x=Fr(x),!n)return x;var b,_=t[0],w=r[0],T=t[1],k=r[1];w<_&&(b=_,_=w,w=b);var M=w-_,A=y(M-At)<kt;if(!A&&k<T&&(b=T,T=k,k=b),A||M<kt?A?T+k>0^x[1]<(y(x[0]-_)<kt?T:k):T<=x[1]&&x[1]<=k:M>At^(_<=x[0]&&x[0]<=w)){var S=Dr(p,(-d+v)/g);return Or(S,f),[x,Fr(S)]}}}function o(e,n){var a=r?t:At-t,i=0;return e<-a?i|=1:e>a&&(i|=2),n<-a?i|=4:n>a&&(i|=8),i}}function rn(t,e,r,n){return function(a){var i,o=a.a,s=a.b,l=o.x,c=o.y,u=0,h=1,f=s.x-l,p=s.y-c;if(i=t-l,f||!(i>0)){if(i/=f,f<0){if(i<u)return;i<h&&(h=i)}else if(f>0){if(i>h)return;i>u&&(u=i)}if(i=r-l,f||!(i<0)){if(i/=f,f<0){if(i>h)return;i>u&&(u=i)}else if(f>0){if(i<u)return;i<h&&(h=i)}if(i=e-c,p||!(i>0)){if(i/=p,p<0){if(i<u)return;i<h&&(h=i)}else if(p>0){if(i>h)return;i>u&&(u=i)}if(i=n-c,p||!(i<0)){if(i/=p,p<0){if(i>h)return;i>u&&(u=i)}else if(p>0){if(i<u)return;i<h&&(h=i)}return u>0&&(a.a={x:l+u*f,y:c+u*p}),h<1&&(a.b={x:l+h*f,y:c+h*p}),a}}}}}}function nn(e,r,n,a){return function(l){var c,u,h,f,p,d,g,m,v,y,x,b=l,_=Qr(),w=rn(e,r,n,a),T={point:A,lineStart:function(){T.point=S,u&&u.push(h=[]);y=!0,v=!1,g=m=NaN},lineEnd:function(){c&&(S(f,p),d&&v&&_.rejoin(),c.push(_.buffer()));T.point=A,v&&l.lineEnd()},polygonStart:function(){l=_,c=[],u=[],x=!0},polygonEnd:function(){l=b,c=t.merge(c);var r=function(t){for(var e=0,r=u.length,n=t[1],a=0;a<r;++a)for(var i,o=1,s=u[a],l=s.length,c=s[0];o<l;++o)i=s[o],c[1]<=n?i[1]>n&&zt(c,i,t)>0&&++e:i[1]<=n&&zt(c,i,t)<0&&--e,c=i;return 0!==e}([e,a]),n=x&&r,i=c.length;(n||i)&&(l.polygonStart(),n&&(l.lineStart(),k(null,null,1,l),l.lineEnd()),i&&Wr(c,o,r,k,l),l.polygonEnd()),c=u=h=null}};function k(t,o,l,c){var u=0,h=0;if(null==t||(u=i(t,l))!==(h=i(o,l))||s(t,o)<0^l>0)do{c.point(0===u||3===u?e:n,u>1?a:r)}while((u=(u+l+4)%4)!==h);else c.point(o[0],o[1])}function M(t,i){return e<=t&&t<=n&&r<=i&&i<=a}function A(t,e){M(t,e)&&l.point(t,e)}function S(t,e){var r=M(t=Math.max(-1e9,Math.min(1e9,t)),e=Math.max(-1e9,Math.min(1e9,e)));if(u&&h.push([t,e]),y)f=t,p=e,d=r,y=!1,r&&(l.lineStart(),l.point(t,e));else if(r&&v)l.point(t,e);else{var n={a:{x:g,y:m},b:{x:t,y:e}};w(n)?(v||(l.lineStart(),l.point(n.a.x,n.a.y)),l.point(n.b.x,n.b.y),r||l.lineEnd(),x=!1):r&&(l.lineStart(),l.point(t,e),x=!1)}g=t,m=e,v=r}return T};function i(t,a){return y(t[0]-e)<kt?a>0?0:3:y(t[0]-n)<kt?a>0?2:1:y(t[1]-r)<kt?a>0?1:0:a>0?3:2}function o(t,e){return s(t.x,e.x)}function s(t,e){var r=i(t,1),n=i(e,1);return r!==n?r-n:0===r?e[1]-t[1]:1===r?t[0]-e[0]:2===r?t[1]-e[1]:e[0]-t[0]}}function an(t){var e=0,r=At/3,n=Ln(t),a=n(e,r);return a.parallels=function(t){return arguments.length?n(e=t[0]*At/180,r=t[1]*At/180):[e/At*180,r/At*180]},a}function on(t,e){var r=Math.sin(t),n=(r+Math.sin(e))/2,a=1+r*(2*n-r),i=Math.sqrt(a)/n;function o(t,e){var r=Math.sqrt(a-2*n*Math.sin(e))/n;return[r*Math.sin(t*=n),i-r*Math.cos(t)]}return o.invert=function(t,e){var r=i-e;return[Math.atan2(t,r)/n,Dt((a-(t*t+r*r)*n*n)/(2*n))]},o}t.geo.clipExtent=function(){var t,e,r,n,a,i,o={stream:function(t){return a&&(a.valid=!1),(a=i(t)).valid=!0,a},extent:function(s){return arguments.length?(i=nn(t=+s[0][0],e=+s[0][1],r=+s[1][0],n=+s[1][1]),a&&(a.valid=!1,a=null),o):[[t,e],[r,n]]}};return o.extent([[0,0],[960,500]])},(t.geo.conicEqualArea=function(){return an(on)}).raw=on,t.geo.albers=function(){return t.geo.conicEqualArea().rotate([96,0]).center([-.6,38.7]).parallels([29.5,45.5]).scale(1070)},t.geo.albersUsa=function(){var e,r,n,a,i=t.geo.albers(),o=t.geo.conicEqualArea().rotate([154,0]).center([-2,58.5]).parallels([55,65]),s=t.geo.conicEqualArea().rotate([157,0]).center([-3,19.9]).parallels([8,18]),l={point:function(t,r){e=[t,r]}};function c(t){var i=t[0],o=t[1];return e=null,r(i,o),e||(n(i,o),e)||a(i,o),e}return c.invert=function(t){var e=i.scale(),r=i.translate(),n=(t[0]-r[0])/e,a=(t[1]-r[1])/e;return(a>=.12&&a<.234&&n>=-.425&&n<-.214?o:a>=.166&&a<.234&&n>=-.214&&n<-.115?s:i).invert(t)},c.stream=function(t){var e=i.stream(t),r=o.stream(t),n=s.stream(t);return{point:function(t,a){e.point(t,a),r.point(t,a),n.point(t,a)},sphere:function(){e.sphere(),r.sphere(),n.sphere()},lineStart:function(){e.lineStart(),r.lineStart(),n.lineStart()},lineEnd:function(){e.lineEnd(),r.lineEnd(),n.lineEnd()},polygonStart:function(){e.polygonStart(),r.polygonStart(),n.polygonStart()},polygonEnd:function(){e.polygonEnd(),r.polygonEnd(),n.polygonEnd()}}},c.precision=function(t){return arguments.length?(i.precision(t),o.precision(t),s.precision(t),c):i.precision()},c.scale=function(t){return arguments.length?(i.scale(t),o.scale(.35*t),s.scale(t),c.translate(i.translate())):i.scale()},c.translate=function(t){if(!arguments.length)return i.translate();var e=i.scale(),u=+t[0],h=+t[1];return r=i.translate(t).clipExtent([[u-.455*e,h-.238*e],[u+.455*e,h+.238*e]]).stream(l).point,n=o.translate([u-.307*e,h+.201*e]).clipExtent([[u-.425*e+kt,h+.12*e+kt],[u-.214*e-kt,h+.234*e-kt]]).stream(l).point,a=s.translate([u-.205*e,h+.212*e]).clipExtent([[u-.214*e+kt,h+.166*e+kt],[u-.115*e-kt,h+.234*e-kt]]).stream(l).point,c},c.scale(1070)};var sn,ln,cn,un,hn,fn,pn={point:O,lineStart:O,lineEnd:O,polygonStart:function(){ln=0,pn.lineStart=dn},polygonEnd:function(){pn.lineStart=pn.lineEnd=pn.point=O,sn+=y(ln/2)}};function dn(){var t,e,r,n;function a(t,e){ln+=n*t-r*e,r=t,n=e}pn.point=function(i,o){pn.point=a,t=r=i,e=n=o},pn.lineEnd=function(){a(t,e)}}var gn={point:function(t,e){t<cn&&(cn=t);t>hn&&(hn=t);e<un&&(un=e);e>fn&&(fn=e)},lineStart:O,lineEnd:O,polygonStart:O,polygonEnd:O};function mn(){var t=vn(4.5),e=[],r={point:n,lineStart:function(){r.point=a},lineEnd:o,polygonStart:function(){r.lineEnd=s},polygonEnd:function(){r.lineEnd=o,r.point=n},pointRadius:function(e){return t=vn(e),r},result:function(){if(e.length){var t=e.join("");return e=[],t}}};function n(r,n){e.push("M",r,",",n,t)}function a(t,n){e.push("M",t,",",n),r.point=i}function i(t,r){e.push("L",t,",",r)}function o(){r.point=n}function s(){e.push("Z")}return r}function vn(t){return"m0,"+t+"a"+t+","+t+" 0 1,1 0,"+-2*t+"a"+t+","+t+" 0 1,1 0,"+2*t+"z"}var yn,xn={point:bn,lineStart:_n,lineEnd:wn,polygonStart:function(){xn.lineStart=Tn},polygonEnd:function(){xn.point=bn,xn.lineStart=_n,xn.lineEnd=wn}};function bn(t,e){xr+=t,br+=e,++_r}function _n(){var t,e;function r(r,n){var a=r-t,i=n-e,o=Math.sqrt(a*a+i*i);wr+=o*(t+r)/2,Tr+=o*(e+n)/2,kr+=o,bn(t=r,e=n)}xn.point=function(n,a){xn.point=r,bn(t=n,e=a)}}function wn(){xn.point=bn}function Tn(){var t,e,r,n;function a(t,e){var a=t-r,i=e-n,o=Math.sqrt(a*a+i*i);wr+=o*(r+t)/2,Tr+=o*(n+e)/2,kr+=o,Mr+=(o=n*t-r*e)*(r+t),Ar+=o*(n+e),Sr+=3*o,bn(r=t,n=e)}xn.point=function(i,o){xn.point=a,bn(t=r=i,e=n=o)},xn.lineEnd=function(){a(t,e)}}function kn(t){var e=4.5,r={point:n,lineStart:function(){r.point=a},lineEnd:o,polygonStart:function(){r.lineEnd=s},polygonEnd:function(){r.lineEnd=o,r.point=n},pointRadius:function(t){return e=t,r},result:O};function n(r,n){t.moveTo(r+e,n),t.arc(r,n,e,0,St)}function a(e,n){t.moveTo(e,n),r.point=i}function i(e,r){t.lineTo(e,r)}function o(){r.point=n}function s(){t.closePath()}return r}function Mn(t){var e=.5,r=Math.cos(30*Lt),n=16;function a(t){return(n?o:i)(t)}function i(e){return En(e,(function(r,n){r=t(r,n),e.point(r[0],r[1])}))}function o(e){var r,a,i,o,l,c,u,h,f,p,d,g,m={point:v,lineStart:y,lineEnd:b,polygonStart:function(){e.polygonStart(),m.lineStart=_},polygonEnd:function(){e.polygonEnd(),m.lineStart=y}};function v(r,n){r=t(r,n),e.point(r[0],r[1])}function y(){h=NaN,m.point=x,e.lineStart()}function x(r,a){var i=Pr([r,a]),o=t(r,a);s(h,f,u,p,d,g,h=o[0],f=o[1],u=r,p=i[0],d=i[1],g=i[2],n,e),e.point(h,f)}function b(){m.point=v,e.lineEnd()}function _(){y(),m.point=w,m.lineEnd=T}function w(t,e){x(r=t,e),a=h,i=f,o=p,l=d,c=g,m.point=x}function T(){s(h,f,u,p,d,g,a,i,r,o,l,c,n,e),m.lineEnd=b,b()}return m}function s(n,a,i,o,l,c,u,h,f,p,d,g,m,v){var x=u-n,b=h-a,_=x*x+b*b;if(_>4*e&&m--){var w=o+p,T=l+d,k=c+g,M=Math.sqrt(w*w+T*T+k*k),A=Math.asin(k/=M),S=y(y(k)-1)<kt||y(i-f)<kt?(i+f)/2:Math.atan2(T,w),E=t(S,A),C=E[0],L=E[1],P=C-n,I=L-a,z=b*P-x*I;(z*z/_>e||y((x*P+b*I)/_-.5)>.3||o*p+l*d+c*g<r)&&(s(n,a,i,o,l,c,C,L,S,w/=M,T/=M,k,m,v),v.point(C,L),s(C,L,S,w,T,k,u,h,f,p,d,g,m,v))}}return a.precision=function(t){return arguments.length?(n=(e=t*t)>0&&16,a):Math.sqrt(e)},a}function An(t){var e=Mn((function(e,r){return t([e*Pt,r*Pt])}));return function(t){return Pn(e(t))}}function Sn(t){this.stream=t}function En(t,e){return{point:e,sphere:function(){t.sphere()},lineStart:function(){t.lineStart()},lineEnd:function(){t.lineEnd()},polygonStart:function(){t.polygonStart()},polygonEnd:function(){t.polygonEnd()}}}function Cn(t){return Ln((function(){return t}))()}function Ln(e){var r,n,a,i,o,s,l=Mn((function(t,e){return[(t=r(t,e))[0]*c+i,o-t[1]*c]})),c=150,u=480,h=250,f=0,p=0,d=0,g=0,m=0,v=tn,y=L,x=null,b=null;function _(t){return[(t=a(t[0]*Lt,t[1]*Lt))[0]*c+i,o-t[1]*c]}function w(t){return(t=a.invert((t[0]-i)/c,(o-t[1])/c))&&[t[0]*Pt,t[1]*Pt]}function T(){a=Gr(n=On(d,g,m),r);var t=r(f,p);return i=u-t[0]*c,o=h+t[1]*c,k()}function k(){return s&&(s.valid=!1,s=null),_}return _.stream=function(t){return s&&(s.valid=!1),(s=Pn(v(n,l(y(t))))).valid=!0,s},_.clipAngle=function(t){return arguments.length?(v=null==t?(x=t,tn):en((x=+t)*Lt),k()):x},_.clipExtent=function(t){return arguments.length?(b=t,y=t?nn(t[0][0],t[0][1],t[1][0],t[1][1]):L,k()):b},_.scale=function(t){return arguments.length?(c=+t,T()):c},_.translate=function(t){return arguments.length?(u=+t[0],h=+t[1],T()):[u,h]},_.center=function(t){return arguments.length?(f=t[0]%360*Lt,p=t[1]%360*Lt,T()):[f*Pt,p*Pt]},_.rotate=function(t){return arguments.length?(d=t[0]%360*Lt,g=t[1]%360*Lt,m=t.length>2?t[2]%360*Lt:0,T()):[d*Pt,g*Pt,m*Pt]},t.rebind(_,l,"precision"),function(){return r=e.apply(this,arguments),_.invert=r.invert&&w,T()}}function Pn(t){return En(t,(function(e,r){t.point(e*Lt,r*Lt)}))}function In(t,e){return[t,e]}function zn(t,e){return[t>At?t-St:t<-At?t+St:t,e]}function On(t,e,r){return t?e||r?Gr(Rn(t),Fn(e,r)):Rn(t):e||r?Fn(e,r):zn}function Dn(t){return function(e,r){return[(e+=t)>At?e-St:e<-At?e+St:e,r]}}function Rn(t){var e=Dn(t);return e.invert=Dn(-t),e}function Fn(t,e){var r=Math.cos(t),n=Math.sin(t),a=Math.cos(e),i=Math.sin(e);function o(t,e){var o=Math.cos(e),s=Math.cos(t)*o,l=Math.sin(t)*o,c=Math.sin(e),u=c*r+s*n;return[Math.atan2(l*a-u*i,s*r-c*n),Dt(u*a+l*i)]}return o.invert=function(t,e){var o=Math.cos(e),s=Math.cos(t)*o,l=Math.sin(t)*o,c=Math.sin(e),u=c*a-l*i;return[Math.atan2(l*a+c*i,s*r+u*n),Dt(u*r-s*n)]},o}function Bn(t,e){var r=Math.cos(t),n=Math.sin(t);return function(a,i,o,s){var l=o*e;null!=a?(a=Nn(r,a),i=Nn(r,i),(o>0?a<i:a>i)&&(a+=o*St)):(a=t+o*St,i=t-.5*l);for(var c,u=a;o>0?u>i:u<i;u-=l)s.point((c=Fr([r,-n*Math.cos(u),-n*Math.sin(u)]))[0],c[1])}}function Nn(t,e){var r=Pr(e);r[0]-=t,Rr(r);var n=Ot(-r[1]);return((-r[2]<0?-n:n)+2*Math.PI-kt)%(2*Math.PI)}function jn(e,r,n){var a=t.range(e,r-kt,n).concat(r);return function(t){return a.map((function(e){return[t,e]}))}}function Un(e,r,n){var a=t.range(e,r-kt,n).concat(r);return function(t){return a.map((function(e){return[e,t]}))}}function Vn(t){return t.source}function qn(t){return t.target}t.geo.path=function(){var e,r,n,a,i,o=4.5;function s(e){return e&&("function"==typeof o&&a.pointRadius(+o.apply(this,arguments)),i&&i.valid||(i=n(a)),t.geo.stream(e,i)),a.result()}function l(){return i=null,s}return s.area=function(e){return sn=0,t.geo.stream(e,n(pn)),sn},s.centroid=function(e){return xr=br=_r=wr=Tr=kr=Mr=Ar=Sr=0,t.geo.stream(e,n(xn)),Sr?[Mr/Sr,Ar/Sr]:kr?[wr/kr,Tr/kr]:_r?[xr/_r,br/_r]:[NaN,NaN]},s.bounds=function(e){return hn=fn=-(cn=un=1/0),t.geo.stream(e,n(gn)),[[cn,un],[hn,fn]]},s.projection=function(t){return arguments.length?(n=(e=t)?t.stream||An(t):L,l()):e},s.context=function(t){return arguments.length?(a=null==(r=t)?new mn:new kn(t),"function"!=typeof o&&a.pointRadius(o),l()):r},s.pointRadius=function(t){return arguments.length?(o="function"==typeof t?t:(a.pointRadius(+t),+t),s):o},s.projection(t.geo.albersUsa()).context(null)},t.geo.transform=function(t){return{stream:function(e){var r=new Sn(e);for(var n in t)r[n]=t[n];return r}}},Sn.prototype={point:function(t,e){this.stream.point(t,e)},sphere:function(){this.stream.sphere()},lineStart:function(){this.stream.lineStart()},lineEnd:function(){this.stream.lineEnd()},polygonStart:function(){this.stream.polygonStart()},polygonEnd:function(){this.stream.polygonEnd()}},t.geo.projection=Cn,t.geo.projectionMutator=Ln,(t.geo.equirectangular=function(){return Cn(In)}).raw=In.invert=In,t.geo.rotation=function(t){function e(e){return(e=t(e[0]*Lt,e[1]*Lt))[0]*=Pt,e[1]*=Pt,e}return t=On(t[0]%360*Lt,t[1]*Lt,t.length>2?t[2]*Lt:0),e.invert=function(e){return(e=t.invert(e[0]*Lt,e[1]*Lt))[0]*=Pt,e[1]*=Pt,e},e},zn.invert=In,t.geo.circle=function(){var t,e,r=[0,0],n=6;function a(){var t="function"==typeof r?r.apply(this,arguments):r,n=On(-t[0]*Lt,-t[1]*Lt,0).invert,a=[];return e(null,null,1,{point:function(t,e){a.push(t=n(t,e)),t[0]*=Pt,t[1]*=Pt}}),{type:"Polygon",coordinates:[a]}}return a.origin=function(t){return arguments.length?(r=t,a):r},a.angle=function(r){return arguments.length?(e=Bn((t=+r)*Lt,n*Lt),a):t},a.precision=function(r){return arguments.length?(e=Bn(t*Lt,(n=+r)*Lt),a):n},a.angle(90)},t.geo.distance=function(t,e){var r,n=(e[0]-t[0])*Lt,a=t[1]*Lt,i=e[1]*Lt,o=Math.sin(n),s=Math.cos(n),l=Math.sin(a),c=Math.cos(a),u=Math.sin(i),h=Math.cos(i);return Math.atan2(Math.sqrt((r=h*o)*r+(r=c*u-l*h*s)*r),l*u+c*h*s)},t.geo.graticule=function(){var e,r,n,a,i,o,s,l,c,u,h,f,p=10,d=p,g=90,m=360,v=2.5;function x(){return{type:"MultiLineString",coordinates:b()}}function b(){return t.range(Math.ceil(a/g)*g,n,g).map(h).concat(t.range(Math.ceil(l/m)*m,s,m).map(f)).concat(t.range(Math.ceil(r/p)*p,e,p).filter((function(t){return y(t%g)>kt})).map(c)).concat(t.range(Math.ceil(o/d)*d,i,d).filter((function(t){return y(t%m)>kt})).map(u))}return x.lines=function(){return b().map((function(t){return{type:"LineString",coordinates:t}}))},x.outline=function(){return{type:"Polygon",coordinates:[h(a).concat(f(s).slice(1),h(n).reverse().slice(1),f(l).reverse().slice(1))]}},x.extent=function(t){return arguments.length?x.majorExtent(t).minorExtent(t):x.minorExtent()},x.majorExtent=function(t){return arguments.length?(a=+t[0][0],n=+t[1][0],l=+t[0][1],s=+t[1][1],a>n&&(t=a,a=n,n=t),l>s&&(t=l,l=s,s=t),x.precision(v)):[[a,l],[n,s]]},x.minorExtent=function(t){return arguments.length?(r=+t[0][0],e=+t[1][0],o=+t[0][1],i=+t[1][1],r>e&&(t=r,r=e,e=t),o>i&&(t=o,o=i,i=t),x.precision(v)):[[r,o],[e,i]]},x.step=function(t){return arguments.length?x.majorStep(t).minorStep(t):x.minorStep()},x.majorStep=function(t){return arguments.length?(g=+t[0],m=+t[1],x):[g,m]},x.minorStep=function(t){return arguments.length?(p=+t[0],d=+t[1],x):[p,d]},x.precision=function(t){return arguments.length?(v=+t,c=jn(o,i,90),u=Un(r,e,v),h=jn(l,s,90),f=Un(a,n,v),x):v},x.majorExtent([[-180,-90+kt],[180,90-kt]]).minorExtent([[-180,-80-kt],[180,80+kt]])},t.geo.greatArc=function(){var e,r,n=Vn,a=qn;function i(){return{type:"LineString",coordinates:[e||n.apply(this,arguments),r||a.apply(this,arguments)]}}return i.distance=function(){return t.geo.distance(e||n.apply(this,arguments),r||a.apply(this,arguments))},i.source=function(t){return arguments.length?(n=t,e="function"==typeof t?null:t,i):n},i.target=function(t){return arguments.length?(a=t,r="function"==typeof t?null:t,i):a},i.precision=function(){return arguments.length?i:0},i},t.geo.interpolate=function(t,e){return r=t[0]*Lt,n=t[1]*Lt,a=e[0]*Lt,i=e[1]*Lt,o=Math.cos(n),s=Math.sin(n),l=Math.cos(i),c=Math.sin(i),u=o*Math.cos(r),h=o*Math.sin(r),f=l*Math.cos(a),p=l*Math.sin(a),d=2*Math.asin(Math.sqrt(Ft(i-n)+o*l*Ft(a-r))),g=1/Math.sin(d),(m=d?function(t){var e=Math.sin(t*=d)*g,r=Math.sin(d-t)*g,n=r*u+e*f,a=r*h+e*p,i=r*s+e*c;return[Math.atan2(a,n)*Pt,Math.atan2(i,Math.sqrt(n*n+a*a))*Pt]}:function(){return[r*Pt,n*Pt]}).distance=d,m;var r,n,a,i,o,s,l,c,u,h,f,p,d,g,m},t.geo.length=function(e){return yn=0,t.geo.stream(e,Hn),yn};var Hn={sphere:O,point:O,lineStart:function(){var t,e,r;function n(n,a){var i=Math.sin(a*=Lt),o=Math.cos(a),s=y((n*=Lt)-t),l=Math.cos(s);yn+=Math.atan2(Math.sqrt((s=o*Math.sin(s))*s+(s=r*i-e*o*l)*s),e*i+r*o*l),t=n,e=i,r=o}Hn.point=function(a,i){t=a*Lt,e=Math.sin(i*=Lt),r=Math.cos(i),Hn.point=n},Hn.lineEnd=function(){Hn.point=Hn.lineEnd=O}},lineEnd:O,polygonStart:O,polygonEnd:O};function Gn(t,e){function r(e,r){var n=Math.cos(e),a=Math.cos(r),i=t(n*a);return[i*a*Math.sin(e),i*Math.sin(r)]}return r.invert=function(t,r){var n=Math.sqrt(t*t+r*r),a=e(n),i=Math.sin(a),o=Math.cos(a);return[Math.atan2(t*i,n*o),Math.asin(n&&r*i/n)]},r}var Yn=Gn((function(t){return Math.sqrt(2/(1+t))}),(function(t){return 2*Math.asin(t/2)}));(t.geo.azimuthalEqualArea=function(){return Cn(Yn)}).raw=Yn;var Wn=Gn((function(t){var e=Math.acos(t);return e&&e/Math.sin(e)}),L);function Zn(t,e){var r=Math.cos(t),n=function(t){return Math.tan(At/4+t/2)},a=t===e?Math.sin(t):Math.log(r/Math.cos(e))/Math.log(n(e)/n(t)),i=r*Math.pow(n(t),a)/a;if(!a)return Kn;function o(t,e){i>0?e<-Ct+kt&&(e=-Ct+kt):e>Ct-kt&&(e=Ct-kt);var r=i/Math.pow(n(e),a);return[r*Math.sin(a*t),i-r*Math.cos(a*t)]}return o.invert=function(t,e){var r=i-e,n=It(a)*Math.sqrt(t*t+r*r);return[Math.atan2(t,r)/a,2*Math.atan(Math.pow(i/n,1/a))-Ct]},o}function Xn(t,e){var r=Math.cos(t),n=t===e?Math.sin(t):(r-Math.cos(e))/(e-t),a=r/n+t;if(y(n)<kt)return In;function i(t,e){var r=a-e;return[r*Math.sin(n*t),a-r*Math.cos(n*t)]}return i.invert=function(t,e){var r=a-e;return[Math.atan2(t,r)/n,a-It(n)*Math.sqrt(t*t+r*r)]},i}(t.geo.azimuthalEquidistant=function(){return Cn(Wn)}).raw=Wn,(t.geo.conicConformal=function(){return an(Zn)}).raw=Zn,(t.geo.conicEquidistant=function(){return an(Xn)}).raw=Xn;var Jn=Gn((function(t){return 1/t}),Math.atan);function Kn(t,e){return[t,Math.log(Math.tan(At/4+e/2))]}function Qn(t){var e,r=Cn(t),n=r.scale,a=r.translate,i=r.clipExtent;return r.scale=function(){var t=n.apply(r,arguments);return t===r?e?r.clipExtent(null):r:t},r.translate=function(){var t=a.apply(r,arguments);return t===r?e?r.clipExtent(null):r:t},r.clipExtent=function(t){var o=i.apply(r,arguments);if(o===r){if(e=null==t){var s=At*n(),l=a();i([[l[0]-s,l[1]-s],[l[0]+s,l[1]+s]])}}else e&&(o=null);return o},r.clipExtent(null)}(t.geo.gnomonic=function(){return Cn(Jn)}).raw=Jn,Kn.invert=function(t,e){return[t,2*Math.atan(Math.exp(e))-Ct]},(t.geo.mercator=function(){return Qn(Kn)}).raw=Kn;var $n=Gn((function(){return 1}),Math.asin);(t.geo.orthographic=function(){return Cn($n)}).raw=$n;var ta=Gn((function(t){return 1/(1+t)}),(function(t){return 2*Math.atan(t)}));function ea(t,e){return[Math.log(Math.tan(At/4+e/2)),-t]}function ra(t){return t[0]}function na(t){return t[1]}function aa(t){for(var e=t.length,r=[0,1],n=2,a=2;a<e;a++){for(;n>1&&zt(t[r[n-2]],t[r[n-1]],t[a])<=0;)--n;r[n++]=a}return r.slice(0,n)}function ia(t,e){return t[0]-e[0]||t[1]-e[1]}(t.geo.stereographic=function(){return Cn(ta)}).raw=ta,ea.invert=function(t,e){return[-e,2*Math.atan(Math.exp(t))-Ct]},(t.geo.transverseMercator=function(){var t=Qn(ea),e=t.center,r=t.rotate;return t.center=function(t){return t?e([-t[1],t[0]]):[(t=e())[1],-t[0]]},t.rotate=function(t){return t?r([t[0],t[1],t.length>2?t[2]+90:90]):[(t=r())[0],t[1],t[2]-90]},r([0,0,90])}).raw=ea,t.geom={},t.geom.hull=function(t){var e=ra,r=na;if(arguments.length)return n(t);function n(t){if(t.length<3)return[];var n,a=de(e),i=de(r),o=t.length,s=[],l=[];for(n=0;n<o;n++)s.push([+a.call(this,t[n],n),+i.call(this,t[n],n),n]);for(s.sort(ia),n=0;n<o;n++)l.push([s[n][0],-s[n][1]]);var c=aa(s),u=aa(l),h=u[0]===c[0],f=u[u.length-1]===c[c.length-1],p=[];for(n=c.length-1;n>=0;--n)p.push(t[s[c[n]][2]]);for(n=+h;n<u.length-f;++n)p.push(t[s[u[n]][2]]);return p}return n.x=function(t){return arguments.length?(e=t,n):e},n.y=function(t){return arguments.length?(r=t,n):r},n},t.geom.polygon=function(t){return U(t,oa),t};var oa=t.geom.polygon.prototype=[];function sa(t,e,r){return(r[0]-e[0])*(t[1]-e[1])<(r[1]-e[1])*(t[0]-e[0])}function la(t,e,r,n){var a=t[0],i=r[0],o=e[0]-a,s=n[0]-i,l=t[1],c=r[1],u=e[1]-l,h=n[1]-c,f=(s*(l-c)-h*(a-i))/(h*o-s*u);return[a+f*o,l+f*u]}function ca(t){var e=t[0],r=t[t.length-1];return!(e[0]-r[0]||e[1]-r[1])}oa.area=function(){for(var t,e=-1,r=this.length,n=this[r-1],a=0;++e<r;)t=n,n=this[e],a+=t[1]*n[0]-t[0]*n[1];return.5*a},oa.centroid=function(t){var e,r,n=-1,a=this.length,i=0,o=0,s=this[a-1];for(arguments.length||(t=-1/(6*this.area()));++n<a;)e=s,s=this[n],r=e[0]*s[1]-s[0]*e[1],i+=(e[0]+s[0])*r,o+=(e[1]+s[1])*r;return[i*t,o*t]},oa.clip=function(t){for(var e,r,n,a,i,o,s=ca(t),l=-1,c=this.length-ca(this),u=this[c-1];++l<c;){for(e=t.slice(),t.length=0,a=this[l],i=e[(n=e.length-s)-1],r=-1;++r<n;)sa(o=e[r],u,a)?(sa(i,u,a)||t.push(la(i,o,u,a)),t.push(o)):sa(i,u,a)&&t.push(la(i,o,u,a)),i=o;s&&t.push(t[0]),u=a}return t};var ua,ha,fa,pa,da,ga=[],ma=[];function va(){Ra(this),this.edge=this.site=this.circle=null}function ya(t){var e=ga.pop()||new va;return e.site=t,e}function xa(t){Ea(t),fa.remove(t),ga.push(t),Ra(t)}function ba(t){var e=t.circle,r=e.x,n=e.cy,a={x:r,y:n},i=t.P,o=t.N,s=[t];xa(t);for(var l=i;l.circle&&y(r-l.circle.x)<kt&&y(n-l.circle.cy)<kt;)i=l.P,s.unshift(l),xa(l),l=i;s.unshift(l),Ea(l);for(var c=o;c.circle&&y(r-c.circle.x)<kt&&y(n-c.circle.cy)<kt;)o=c.N,s.push(c),xa(c),c=o;s.push(c),Ea(c);var u,h=s.length;for(u=1;u<h;++u)c=s[u],l=s[u-1],za(c.edge,l.site,c.site,a);l=s[0],(c=s[h-1]).edge=Pa(l.site,c.site,null,a),Sa(l),Sa(c)}function _a(t){for(var e,r,n,a,i=t.x,o=t.y,s=fa._;s;)if((n=wa(s,o)-i)>kt)s=s.L;else{if(!((a=i-Ta(s,o))>kt)){n>-kt?(e=s.P,r=s):a>-kt?(e=s,r=s.N):e=r=s;break}if(!s.R){e=s;break}s=s.R}var l=ya(t);if(fa.insert(e,l),e||r){if(e===r)return Ea(e),r=ya(e.site),fa.insert(l,r),l.edge=r.edge=Pa(e.site,l.site),Sa(e),void Sa(r);if(r){Ea(e),Ea(r);var c=e.site,u=c.x,h=c.y,f=t.x-u,p=t.y-h,d=r.site,g=d.x-u,m=d.y-h,v=2*(f*m-p*g),y=f*f+p*p,x=g*g+m*m,b={x:(m*y-p*x)/v+u,y:(f*x-g*y)/v+h};za(r.edge,c,d,b),l.edge=Pa(c,t,null,b),r.edge=Pa(t,d,null,b),Sa(e),Sa(r)}else l.edge=Pa(e.site,l.site)}}function wa(t,e){var r=t.site,n=r.x,a=r.y,i=a-e;if(!i)return n;var o=t.P;if(!o)return-1/0;var s=(r=o.site).x,l=r.y,c=l-e;if(!c)return s;var u=s-n,h=1/i-1/c,f=u/c;return h?(-f+Math.sqrt(f*f-2*h*(u*u/(-2*c)-l+c/2+a-i/2)))/h+n:(n+s)/2}function Ta(t,e){var r=t.N;if(r)return wa(r,e);var n=t.site;return n.y===e?n.x:1/0}function ka(t){this.site=t,this.edges=[]}function Ma(t,e){return e.angle-t.angle}function Aa(){Ra(this),this.x=this.y=this.arc=this.site=this.cy=null}function Sa(t){var e=t.P,r=t.N;if(e&&r){var n=e.site,a=t.site,i=r.site;if(n!==i){var o=a.x,s=a.y,l=n.x-o,c=n.y-s,u=i.x-o,h=2*(l*(m=i.y-s)-c*u);if(!(h>=-Mt)){var f=l*l+c*c,p=u*u+m*m,d=(m*f-c*p)/h,g=(l*p-u*f)/h,m=g+s,v=ma.pop()||new Aa;v.arc=t,v.site=a,v.x=d+o,v.y=m+Math.sqrt(d*d+g*g),v.cy=m,t.circle=v;for(var y=null,x=da._;x;)if(v.y<x.y||v.y===x.y&&v.x<=x.x){if(!x.L){y=x.P;break}x=x.L}else{if(!x.R){y=x;break}x=x.R}da.insert(y,v),y||(pa=v)}}}}function Ea(t){var e=t.circle;e&&(e.P||(pa=e.N),da.remove(e),ma.push(e),Ra(e),t.circle=null)}function Ca(t,e){var r=t.b;if(r)return!0;var n,a,i=t.a,o=e[0][0],s=e[1][0],l=e[0][1],c=e[1][1],u=t.l,h=t.r,f=u.x,p=u.y,d=h.x,g=h.y,m=(f+d)/2,v=(p+g)/2;if(g===p){if(m<o||m>=s)return;if(f>d){if(i){if(i.y>=c)return}else i={x:m,y:l};r={x:m,y:c}}else{if(i){if(i.y<l)return}else i={x:m,y:c};r={x:m,y:l}}}else if(a=v-(n=(f-d)/(g-p))*m,n<-1||n>1)if(f>d){if(i){if(i.y>=c)return}else i={x:(l-a)/n,y:l};r={x:(c-a)/n,y:c}}else{if(i){if(i.y<l)return}else i={x:(c-a)/n,y:c};r={x:(l-a)/n,y:l}}else if(p<g){if(i){if(i.x>=s)return}else i={x:o,y:n*o+a};r={x:s,y:n*s+a}}else{if(i){if(i.x<o)return}else i={x:s,y:n*s+a};r={x:o,y:n*o+a}}return t.a=i,t.b=r,!0}function La(t,e){this.l=t,this.r=e,this.a=this.b=null}function Pa(t,e,r,n){var a=new La(t,e);return ua.push(a),r&&za(a,t,e,r),n&&za(a,e,t,n),ha[t.i].edges.push(new Oa(a,t,e)),ha[e.i].edges.push(new Oa(a,e,t)),a}function Ia(t,e,r){var n=new La(t,null);return n.a=e,n.b=r,ua.push(n),n}function za(t,e,r,n){t.a||t.b?t.l===r?t.b=n:t.a=n:(t.a=n,t.l=e,t.r=r)}function Oa(t,e,r){var n=t.a,a=t.b;this.edge=t,this.site=e,this.angle=r?Math.atan2(r.y-e.y,r.x-e.x):t.l===e?Math.atan2(a.x-n.x,n.y-a.y):Math.atan2(n.x-a.x,a.y-n.y)}function Da(){this._=null}function Ra(t){t.U=t.C=t.L=t.R=t.P=t.N=null}function Fa(t,e){var r=e,n=e.R,a=r.U;a?a.L===r?a.L=n:a.R=n:t._=n,n.U=a,r.U=n,r.R=n.L,r.R&&(r.R.U=r),n.L=r}function Ba(t,e){var r=e,n=e.L,a=r.U;a?a.L===r?a.L=n:a.R=n:t._=n,n.U=a,r.U=n,r.L=n.R,r.L&&(r.L.U=r),n.R=r}function Na(t){for(;t.L;)t=t.L;return t}function ja(t,e){var r,n,a,i=t.sort(Ua).pop();for(ua=[],ha=new Array(t.length),fa=new Da,da=new Da;;)if(a=pa,i&&(!a||i.y<a.y||i.y===a.y&&i.x<a.x))i.x===r&&i.y===n||(ha[i.i]=new ka(i),_a(i),r=i.x,n=i.y),i=t.pop();else{if(!a)break;ba(a.arc)}e&&(function(t){for(var e,r=ua,n=rn(t[0][0],t[0][1],t[1][0],t[1][1]),a=r.length;a--;)(!Ca(e=r[a],t)||!n(e)||y(e.a.x-e.b.x)<kt&&y(e.a.y-e.b.y)<kt)&&(e.a=e.b=null,r.splice(a,1))}(e),function(t){for(var e,r,n,a,i,o,s,l,c,u,h=t[0][0],f=t[1][0],p=t[0][1],d=t[1][1],g=ha,m=g.length;m--;)if((i=g[m])&&i.prepare())for(l=(s=i.edges).length,o=0;o<l;)n=(u=s[o].end()).x,a=u.y,e=(c=s[++o%l].start()).x,r=c.y,(y(n-e)>kt||y(a-r)>kt)&&(s.splice(o,0,new Oa(Ia(i.site,u,y(n-h)<kt&&d-a>kt?{x:h,y:y(e-h)<kt?r:d}:y(a-d)<kt&&f-n>kt?{x:y(r-d)<kt?e:f,y:d}:y(n-f)<kt&&a-p>kt?{x:f,y:y(e-f)<kt?r:p}:y(a-p)<kt&&n-h>kt?{x:y(r-p)<kt?e:h,y:p}:null),i.site,null)),++l)}(e));var o={cells:ha,edges:ua};return fa=da=ua=ha=null,o}function Ua(t,e){return e.y-t.y||e.x-t.x}ka.prototype.prepare=function(){for(var t,e=this.edges,r=e.length;r--;)(t=e[r].edge).b&&t.a||e.splice(r,1);return e.sort(Ma),e.length},Oa.prototype={start:function(){return this.edge.l===this.site?this.edge.a:this.edge.b},end:function(){return this.edge.l===this.site?this.edge.b:this.edge.a}},Da.prototype={insert:function(t,e){var r,n,a;if(t){if(e.P=t,e.N=t.N,t.N&&(t.N.P=e),t.N=e,t.R){for(t=t.R;t.L;)t=t.L;t.L=e}else t.R=e;r=t}else this._?(t=Na(this._),e.P=null,e.N=t,t.P=t.L=e,r=t):(e.P=e.N=null,this._=e,r=null);for(e.L=e.R=null,e.U=r,e.C=!0,t=e;r&&r.C;)r===(n=r.U).L?(a=n.R)&&a.C?(r.C=a.C=!1,n.C=!0,t=n):(t===r.R&&(Fa(this,r),r=(t=r).U),r.C=!1,n.C=!0,Ba(this,n)):(a=n.L)&&a.C?(r.C=a.C=!1,n.C=!0,t=n):(t===r.L&&(Ba(this,r),r=(t=r).U),r.C=!1,n.C=!0,Fa(this,n)),r=t.U;this._.C=!1},remove:function(t){t.N&&(t.N.P=t.P),t.P&&(t.P.N=t.N),t.N=t.P=null;var e,r,n,a=t.U,i=t.L,o=t.R;if(r=i?o?Na(o):i:o,a?a.L===t?a.L=r:a.R=r:this._=r,i&&o?(n=r.C,r.C=t.C,r.L=i,i.U=r,r!==o?(a=r.U,r.U=t.U,t=r.R,a.L=t,r.R=o,o.U=r):(r.U=a,a=r,t=r.R)):(n=t.C,t=r),t&&(t.U=a),!n)if(t&&t.C)t.C=!1;else{do{if(t===this._)break;if(t===a.L){if((e=a.R).C&&(e.C=!1,a.C=!0,Fa(this,a),e=a.R),e.L&&e.L.C||e.R&&e.R.C){e.R&&e.R.C||(e.L.C=!1,e.C=!0,Ba(this,e),e=a.R),e.C=a.C,a.C=e.R.C=!1,Fa(this,a),t=this._;break}}else if((e=a.L).C&&(e.C=!1,a.C=!0,Ba(this,a),e=a.L),e.L&&e.L.C||e.R&&e.R.C){e.L&&e.L.C||(e.R.C=!1,e.C=!0,Fa(this,e),e=a.L),e.C=a.C,a.C=e.L.C=!1,Ba(this,a),t=this._;break}e.C=!0,t=a,a=a.U}while(!t.C);t&&(t.C=!1)}}},t.geom.voronoi=function(t){var e=ra,r=na,n=e,a=r,i=Va;if(t)return o(t);function o(t){var e=new Array(t.length),r=i[0][0],n=i[0][1],a=i[1][0],o=i[1][1];return ja(s(t),i).cells.forEach((function(i,s){var l=i.edges,c=i.site;(e[s]=l.length?l.map((function(t){var e=t.start();return[e.x,e.y]})):c.x>=r&&c.x<=a&&c.y>=n&&c.y<=o?[[r,o],[a,o],[a,n],[r,n]]:[]).point=t[s]})),e}function s(t){return t.map((function(t,e){return{x:Math.round(n(t,e)/kt)*kt,y:Math.round(a(t,e)/kt)*kt,i:e}}))}return o.links=function(t){return ja(s(t)).edges.filter((function(t){return t.l&&t.r})).map((function(e){return{source:t[e.l.i],target:t[e.r.i]}}))},o.triangles=function(t){var e=[];return ja(s(t)).cells.forEach((function(r,n){for(var a,i,o,s,l=r.site,c=r.edges.sort(Ma),u=-1,h=c.length,f=c[h-1].edge,p=f.l===l?f.r:f.l;++u<h;)f,a=p,p=(f=c[u].edge).l===l?f.r:f.l,n<a.i&&n<p.i&&(o=a,s=p,((i=l).x-s.x)*(o.y-i.y)-(i.x-o.x)*(s.y-i.y)<0)&&e.push([t[n],t[a.i],t[p.i]])})),e},o.x=function(t){return arguments.length?(n=de(e=t),o):e},o.y=function(t){return arguments.length?(a=de(r=t),o):r},o.clipExtent=function(t){return arguments.length?(i=null==t?Va:t,o):i===Va?null:i},o.size=function(t){return arguments.length?o.clipExtent(t&&[[0,0],t]):i===Va?null:i&&i[1]},o};var Va=[[-1e6,-1e6],[1e6,1e6]];function qa(t){return t.x}function Ha(t){return t.y}function Ga(t,e,r,n,a,i){if(!t(e,r,n,a,i)){var o=.5*(r+a),s=.5*(n+i),l=e.nodes;l[0]&&Ga(t,l[0],r,n,o,s),l[1]&&Ga(t,l[1],o,n,a,s),l[2]&&Ga(t,l[2],r,s,o,i),l[3]&&Ga(t,l[3],o,s,a,i)}}function Ya(t,e,r,n,a,i,o){var s,l=1/0;return function t(c,u,h,f,p){if(!(u>i||h>o||f<n||p<a)){if(d=c.point){var d,g=e-c.x,m=r-c.y,v=g*g+m*m;if(v<l){var y=Math.sqrt(l=v);n=e-y,a=r-y,i=e+y,o=r+y,s=d}}for(var x=c.nodes,b=.5*(u+f),_=.5*(h+p),w=(r>=_)<<1|e>=b,T=w+4;w<T;++w)if(c=x[3&w])switch(3&w){case 0:t(c,u,h,b,_);break;case 1:t(c,b,h,f,_);break;case 2:t(c,u,_,b,p);break;case 3:t(c,b,_,f,p)}}}(t,n,a,i,o),s}function Wa(e,r){e=t.rgb(e),r=t.rgb(r);var n=e.r,a=e.g,i=e.b,o=r.r-n,s=r.g-a,l=r.b-i;return function(t){return"#"+se(Math.round(n+o*t))+se(Math.round(a+s*t))+se(Math.round(i+l*t))}}function Za(t,e){var r,n={},a={};for(r in t)r in e?n[r]=$a(t[r],e[r]):a[r]=t[r];for(r in e)r in t||(a[r]=e[r]);return function(t){for(r in n)a[r]=n[r](t);return a}}function Xa(t,e){return t=+t,e=+e,function(r){return t*(1-r)+e*r}}function Ja(t,e){var r,n,a,i=Ka.lastIndex=Qa.lastIndex=0,o=-1,s=[],l=[];for(t+="",e+="";(r=Ka.exec(t))&&(n=Qa.exec(e));)(a=n.index)>i&&(a=e.slice(i,a),s[o]?s[o]+=a:s[++o]=a),(r=r[0])===(n=n[0])?s[o]?s[o]+=n:s[++o]=n:(s[++o]=null,l.push({i:o,x:Xa(r,n)})),i=Qa.lastIndex;return i<e.length&&(a=e.slice(i),s[o]?s[o]+=a:s[++o]=a),s.length<2?l[0]?(e=l[0].x,function(t){return e(t)+""}):function(){return e}:(e=l.length,function(t){for(var r,n=0;n<e;++n)s[(r=l[n]).i]=r.x(t);return s.join("")})}t.geom.delaunay=function(e){return t.geom.voronoi().triangles(e)},t.geom.quadtree=function(t,e,r,n,a){var i,o=ra,s=na;if(i=arguments.length)return o=qa,s=Ha,3===i&&(a=r,n=e,r=e=0),l(t);function l(t){var l,c,u,h,f,p,d,g,m,v=de(o),x=de(s);if(null!=e)p=e,d=r,g=n,m=a;else if(g=m=-(p=d=1/0),c=[],u=[],f=t.length,i)for(h=0;h<f;++h)(l=t[h]).x<p&&(p=l.x),l.y<d&&(d=l.y),l.x>g&&(g=l.x),l.y>m&&(m=l.y),c.push(l.x),u.push(l.y);else for(h=0;h<f;++h){var b=+v(l=t[h],h),_=+x(l,h);b<p&&(p=b),_<d&&(d=_),b>g&&(g=b),_>m&&(m=_),c.push(b),u.push(_)}var w=g-p,T=m-d;function k(t,e,r,n,a,i,o,s){if(!isNaN(r)&&!isNaN(n))if(t.leaf){var l=t.x,c=t.y;if(null!=l)if(y(l-r)+y(c-n)<.01)M(t,e,r,n,a,i,o,s);else{var u=t.point;t.x=t.y=t.point=null,M(t,u,l,c,a,i,o,s),M(t,e,r,n,a,i,o,s)}else t.x=r,t.y=n,t.point=e}else M(t,e,r,n,a,i,o,s)}function M(t,e,r,n,a,i,o,s){var l=.5*(a+o),c=.5*(i+s),u=r>=l,h=n>=c,f=h<<1|u;t.leaf=!1,u?a=l:o=l,h?i=c:s=c,k(t=t.nodes[f]||(t.nodes[f]={leaf:!0,nodes:[],point:null,x:null,y:null}),e,r,n,a,i,o,s)}w>T?m=d+w:g=p+T;var A={leaf:!0,nodes:[],point:null,x:null,y:null,add:function(t){k(A,t,+v(t,++h),+x(t,h),p,d,g,m)},visit:function(t){Ga(t,A,p,d,g,m)},find:function(t){return Ya(A,t[0],t[1],p,d,g,m)}};if(h=-1,null==e){for(;++h<f;)k(A,t[h],c[h],u[h],p,d,g,m);--h}else t.forEach(A.add);return c=u=t=l=null,A}return l.x=function(t){return arguments.length?(o=t,l):o},l.y=function(t){return arguments.length?(s=t,l):s},l.extent=function(t){return arguments.length?(null==t?e=r=n=a=null:(