import numpy as np
from .. import core as jiminy
from ..dynamics import Trajectory as Trajectory
from ..log import UpdateHook as UpdateHook, build_robot_from_log as build_robot_from_log, extract_trajectory_from_log as extract_trajectory_from_log, read_log as read_log, update_sensor_measurements_from_log as update_sensor_measurements_from_log
from .meshcat.utilities import interactive_mode as interactive_mode
from .viewer import COLORS as COLORS, CameraMotionType as CameraMotionType, CameraPoseType as CameraPoseType, Tuple3FType as Tuple3FType, Tuple4FType as Tuple4FType, Viewer as Viewer, get_default_backend as get_default_backend, is_display_available as is_display_available
from _typeshed import Incomplete
from threading import Thread
from types import TracebackType
from typing import Any, Sequence

VIDEO_FRAMERATE: int
VIDEO_QUALITY: float
LOGGER: Incomplete
ColorType = str | Tuple4FType

class QRLock:
    def __init__(self) -> None: ...
    def acquire(self) -> None: ...
    def release(self) -> None: ...
    def __enter__(self) -> None: ...
    def __exit__(self, exc_type: type[BaseException] | None, exc_value: BaseException | None, traceback: TracebackType | None) -> None: ...

viewer_lock: Incomplete

def play_trajectories(trajectories: Trajectory | Sequence[Trajectory], update_hooks: UpdateHook | Sequence[UpdateHook | None] | None = None, time_interval: np.ndarray | tuple[float, float] = ..., speed_ratio: float = 1.0, xyz_offsets: Tuple3FType | Sequence[Tuple3FType | None] | None = None, robots_colors: ColorType | Sequence[ColorType | None] | None = None, camera_pose: CameraPoseType | None = None, enable_travelling: bool = False, camera_motion: CameraMotionType | None = None, watermark_fullpath: str | None = None, legend: str | Sequence[str] | None = None, enable_clock: bool = False, display_com: bool | None = None, display_dcm: bool | None = None, display_contacts: bool | None = None, display_f_external: Sequence[bool] | bool | None = None, scene_name: str = 'world', record_video_path: str | None = None, record_video_size: tuple[int, int] | None = None, start_paused: bool = False, backend: str | None = None, delete_robot_on_close: bool | None = None, remove_widgets_overlay: bool = True, close_backend: bool = False, viewers: Viewer | Sequence[Viewer | None] | None = None, verbose: bool = True, **kwargs: Any) -> Sequence[Viewer]: ...
def extract_replay_data_from_log(log_data: dict[str, np.ndarray], robot: jiminy.Robot | None = None) -> tuple[Trajectory, UpdateHook | None, dict[str, Any]]: ...
def play_logs_data(logs_data: Sequence[dict[str, np.ndarray]] | dict[str, np.ndarray], robots: Sequence[jiminy.Robot | None] | jiminy.Robot | None = None, **kwargs: Any) -> Sequence[Viewer]: ...
def play_logs_files(logs_files: str | Sequence[str], mesh_dir_path: str | None = None, mesh_package_dirs: Sequence[str] = (), **kwargs: Any) -> Sequence[Viewer]: ...
def async_play_and_record_logs_files(logs_files: str | Sequence[str], enable_replay: bool | None = None, mesh_dir_path: str | None = None, mesh_package_dirs: Sequence[str] = (), **kwargs: Any) -> Thread | None: ...
