// This file is @generated by prost-build.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct Subscribe {
    #[prost(message, optional, tag = "1")]
    pub header: ::core::option::Option<AgpHeader>,
    #[prost(string, tag = "2")]
    pub organization: ::prost::alloc::string::String,
    #[prost(string, tag = "3")]
    pub namespace: ::prost::alloc::string::String,
    #[prost(string, tag = "4")]
    pub agent_type: ::prost::alloc::string::String,
}
#[derive(Clone, Copy, PartialEq, ::prost::Message)]
pub struct Unsubscribe {
    #[prost(message, optional, tag = "1")]
    pub header: ::core::option::Option<AgpHeader>,
}
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct Publish {
    #[prost(message, optional, tag = "1")]
    pub header: ::core::option::Option<AgpHeader>,
    #[prost(message, optional, tag = "2")]
    pub session: ::core::option::Option<SessionHeader>,
    #[prost(message, optional, tag = "4")]
    pub msg: ::core::option::Option<Content>,
}
/// recvFrom = connection from where the sub/unsub is supposed to be received
/// forwardTo = connection where to forward the message
/// incomingConn = connection from where the packet was received
/// error = if true the publication contains an error notification
#[derive(Clone, Copy, PartialEq, ::prost::Message)]
pub struct AgpHeader {
    #[prost(message, optional, tag = "1")]
    pub source: ::core::option::Option<Agent>,
    #[prost(message, optional, tag = "2")]
    pub destination: ::core::option::Option<Agent>,
    #[prost(uint32, tag = "3")]
    pub fanout: u32,
    #[prost(uint64, optional, tag = "4")]
    pub recv_from: ::core::option::Option<u64>,
    #[prost(uint64, optional, tag = "5")]
    pub forward_to: ::core::option::Option<u64>,
    #[prost(uint64, optional, tag = "6")]
    pub incoming_conn: ::core::option::Option<u64>,
    #[prost(bool, optional, tag = "7")]
    pub error: ::core::option::Option<bool>,
}
#[derive(Clone, Copy, PartialEq, ::prost::Message)]
pub struct Agent {
    #[prost(uint64, tag = "1")]
    pub organization: u64,
    #[prost(uint64, tag = "2")]
    pub namespace: u64,
    #[prost(uint64, tag = "3")]
    pub agent_type: u64,
    #[prost(uint64, optional, tag = "4")]
    pub agent_id: ::core::option::Option<u64>,
}
#[derive(Clone, Copy, PartialEq, ::prost::Message)]
pub struct SessionHeader {
    #[prost(enumeration = "SessionHeaderType", tag = "1")]
    pub header_type: i32,
    #[prost(uint32, tag = "2")]
    pub session_id: u32,
    #[prost(uint32, tag = "3")]
    pub message_id: u32,
}
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct Content {
    #[prost(string, tag = "1")]
    pub content_type: ::prost::alloc::string::String,
    #[prost(bytes = "vec", tag = "2")]
    pub blob: ::prost::alloc::vec::Vec<u8>,
}
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct Message {
    #[prost(map = "string, string", tag = "4")]
    pub metadata: ::std::collections::HashMap<
        ::prost::alloc::string::String,
        ::prost::alloc::string::String,
    >,
    #[prost(oneof = "message::MessageType", tags = "1, 2, 3")]
    pub message_type: ::core::option::Option<message::MessageType>,
}
/// Nested message and enum types in `Message`.
pub mod message {
    #[derive(Clone, PartialEq, ::prost::Oneof)]
    pub enum MessageType {
        #[prost(message, tag = "1")]
        Subscribe(super::Subscribe),
        #[prost(message, tag = "2")]
        Unsubscribe(super::Unsubscribe),
        #[prost(message, tag = "3")]
        Publish(super::Publish),
    }
}
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord, ::prost::Enumeration)]
#[repr(i32)]
pub enum SessionHeaderType {
    Unspecified = 0,
    Fnf = 1,
    FnfReliable = 2,
    FnfAck = 3,
    Request = 4,
    Reply = 5,
    Stream = 6,
    PubSub = 7,
    RtxRequest = 8,
    RtxReply = 9,
    BeaconStream = 10,
    BeaconPubSub = 11,
}
impl SessionHeaderType {
    /// String value of the enum field names used in the ProtoBuf definition.
    ///
    /// The values are not transformed in any way and thus are considered stable
    /// (if the ProtoBuf definition does not change) and safe for programmatic use.
    pub fn as_str_name(&self) -> &'static str {
        match self {
            Self::Unspecified => "UNSPECIFIED",
            Self::Fnf => "FNF",
            Self::FnfReliable => "FNF_RELIABLE",
            Self::FnfAck => "FNF_ACK",
            Self::Request => "REQUEST",
            Self::Reply => "REPLY",
            Self::Stream => "STREAM",
            Self::PubSub => "PUB_SUB",
            Self::RtxRequest => "RTX_REQUEST",
            Self::RtxReply => "RTX_REPLY",
            Self::BeaconStream => "BEACON_STREAM",
            Self::BeaconPubSub => "BEACON_PUB_SUB",
        }
    }
    /// Creates an enum from field names used in the ProtoBuf definition.
    pub fn from_str_name(value: &str) -> ::core::option::Option<Self> {
        match value {
            "UNSPECIFIED" => Some(Self::Unspecified),
            "FNF" => Some(Self::Fnf),
            "FNF_RELIABLE" => Some(Self::FnfReliable),
            "FNF_ACK" => Some(Self::FnfAck),
            "REQUEST" => Some(Self::Request),
            "REPLY" => Some(Self::Reply),
            "STREAM" => Some(Self::Stream),
            "PUB_SUB" => Some(Self::PubSub),
            "RTX_REQUEST" => Some(Self::RtxRequest),
            "RTX_REPLY" => Some(Self::RtxReply),
            "BEACON_STREAM" => Some(Self::BeaconStream),
            "BEACON_PUB_SUB" => Some(Self::BeaconPubSub),
            _ => None,
        }
    }
}
/// Generated client implementations.
pub mod pub_sub_service_client {
    #![allow(
        unused_variables,
        dead_code,
        missing_docs,
        clippy::wildcard_imports,
        clippy::let_unit_value,
    )]
    use tonic::codegen::*;
    use tonic::codegen::http::Uri;
    #[derive(Debug, Clone)]
    pub struct PubSubServiceClient<T> {
        inner: tonic::client::Grpc<T>,
    }
    impl PubSubServiceClient<tonic::transport::Channel> {
        /// Attempt to create a new client by connecting to a given endpoint.
        pub async fn connect<D>(dst: D) -> Result<Self, tonic::transport::Error>
        where
            D: TryInto<tonic::transport::Endpoint>,
            D::Error: Into<StdError>,
        {
            let conn = tonic::transport::Endpoint::new(dst)?.connect().await?;
            Ok(Self::new(conn))
        }
    }
    impl<T> PubSubServiceClient<T>
    where
        T: tonic::client::GrpcService<tonic::body::Body>,
        T::Error: Into<StdError>,
        T::ResponseBody: Body<Data = Bytes> + std::marker::Send + 'static,
        <T::ResponseBody as Body>::Error: Into<StdError> + std::marker::Send,
    {
        pub fn new(inner: T) -> Self {
            let inner = tonic::client::Grpc::new(inner);
            Self { inner }
        }
        pub fn with_origin(inner: T, origin: Uri) -> Self {
            let inner = tonic::client::Grpc::with_origin(inner, origin);
            Self { inner }
        }
        pub fn with_interceptor<F>(
            inner: T,
            interceptor: F,
        ) -> PubSubServiceClient<InterceptedService<T, F>>
        where
            F: tonic::service::Interceptor,
            T::ResponseBody: Default,
            T: tonic::codegen::Service<
                http::Request<tonic::body::Body>,
                Response = http::Response<
                    <T as tonic::client::GrpcService<tonic::body::Body>>::ResponseBody,
                >,
            >,
            <T as tonic::codegen::Service<
                http::Request<tonic::body::Body>,
            >>::Error: Into<StdError> + std::marker::Send + std::marker::Sync,
        {
            PubSubServiceClient::new(InterceptedService::new(inner, interceptor))
        }
        /// Compress requests with the given encoding.
        ///
        /// This requires the server to support it otherwise it might respond with an
        /// error.
        #[must_use]
        pub fn send_compressed(mut self, encoding: CompressionEncoding) -> Self {
            self.inner = self.inner.send_compressed(encoding);
            self
        }
        /// Enable decompressing responses.
        #[must_use]
        pub fn accept_compressed(mut self, encoding: CompressionEncoding) -> Self {
            self.inner = self.inner.accept_compressed(encoding);
            self
        }
        /// Limits the maximum size of a decoded message.
        ///
        /// Default: `4MB`
        #[must_use]
        pub fn max_decoding_message_size(mut self, limit: usize) -> Self {
            self.inner = self.inner.max_decoding_message_size(limit);
            self
        }
        /// Limits the maximum size of an encoded message.
        ///
        /// Default: `usize::MAX`
        #[must_use]
        pub fn max_encoding_message_size(mut self, limit: usize) -> Self {
            self.inner = self.inner.max_encoding_message_size(limit);
            self
        }
        pub async fn open_channel(
            &mut self,
            request: impl tonic::IntoStreamingRequest<Message = super::Message>,
        ) -> std::result::Result<
            tonic::Response<tonic::codec::Streaming<super::Message>>,
            tonic::Status,
        > {
            self.inner
                .ready()
                .await
                .map_err(|e| {
                    tonic::Status::unknown(
                        format!("Service was not ready: {}", e.into()),
                    )
                })?;
            let codec = tonic::codec::ProstCodec::default();
            let path = http::uri::PathAndQuery::from_static(
                "/pubsub.proto.v1.PubSubService/OpenChannel",
            );
            let mut req = request.into_streaming_request();
            req.extensions_mut()
                .insert(GrpcMethod::new("pubsub.proto.v1.PubSubService", "OpenChannel"));
            self.inner.streaming(req, path, codec).await
        }
    }
}
/// Generated server implementations.
pub mod pub_sub_service_server {
    #![allow(
        unused_variables,
        dead_code,
        missing_docs,
        clippy::wildcard_imports,
        clippy::let_unit_value,
    )]
    use tonic::codegen::*;
    /// Generated trait containing gRPC methods that should be implemented for use with PubSubServiceServer.
    #[async_trait]
    pub trait PubSubService: std::marker::Send + std::marker::Sync + 'static {
        /// Server streaming response type for the OpenChannel method.
        type OpenChannelStream: tonic::codegen::tokio_stream::Stream<
                Item = std::result::Result<super::Message, tonic::Status>,
            >
            + std::marker::Send
            + 'static;
        async fn open_channel(
            &self,
            request: tonic::Request<tonic::Streaming<super::Message>>,
        ) -> std::result::Result<
            tonic::Response<Self::OpenChannelStream>,
            tonic::Status,
        >;
    }
    #[derive(Debug)]
    pub struct PubSubServiceServer<T> {
        inner: Arc<T>,
        accept_compression_encodings: EnabledCompressionEncodings,
        send_compression_encodings: EnabledCompressionEncodings,
        max_decoding_message_size: Option<usize>,
        max_encoding_message_size: Option<usize>,
    }
    impl<T> PubSubServiceServer<T> {
        pub fn new(inner: T) -> Self {
            Self::from_arc(Arc::new(inner))
        }
        pub fn from_arc(inner: Arc<T>) -> Self {
            Self {
                inner,
                accept_compression_encodings: Default::default(),
                send_compression_encodings: Default::default(),
                max_decoding_message_size: None,
                max_encoding_message_size: None,
            }
        }
        pub fn with_interceptor<F>(
            inner: T,
            interceptor: F,
        ) -> InterceptedService<Self, F>
        where
            F: tonic::service::Interceptor,
        {
            InterceptedService::new(Self::new(inner), interceptor)
        }
        /// Enable decompressing requests with the given encoding.
        #[must_use]
        pub fn accept_compressed(mut self, encoding: CompressionEncoding) -> Self {
            self.accept_compression_encodings.enable(encoding);
            self
        }
        /// Compress responses with the given encoding, if the client supports it.
        #[must_use]
        pub fn send_compressed(mut self, encoding: CompressionEncoding) -> Self {
            self.send_compression_encodings.enable(encoding);
            self
        }
        /// Limits the maximum size of a decoded message.
        ///
        /// Default: `4MB`
        #[must_use]
        pub fn max_decoding_message_size(mut self, limit: usize) -> Self {
            self.max_decoding_message_size = Some(limit);
            self
        }
        /// Limits the maximum size of an encoded message.
        ///
        /// Default: `usize::MAX`
        #[must_use]
        pub fn max_encoding_message_size(mut self, limit: usize) -> Self {
            self.max_encoding_message_size = Some(limit);
            self
        }
    }
    impl<T, B> tonic::codegen::Service<http::Request<B>> for PubSubServiceServer<T>
    where
        T: PubSubService,
        B: Body + std::marker::Send + 'static,
        B::Error: Into<StdError> + std::marker::Send + 'static,
    {
        type Response = http::Response<tonic::body::Body>;
        type Error = std::convert::Infallible;
        type Future = BoxFuture<Self::Response, Self::Error>;
        fn poll_ready(
            &mut self,
            _cx: &mut Context<'_>,
        ) -> Poll<std::result::Result<(), Self::Error>> {
            Poll::Ready(Ok(()))
        }
        fn call(&mut self, req: http::Request<B>) -> Self::Future {
            match req.uri().path() {
                "/pubsub.proto.v1.PubSubService/OpenChannel" => {
                    #[allow(non_camel_case_types)]
                    struct OpenChannelSvc<T: PubSubService>(pub Arc<T>);
                    impl<
                        T: PubSubService,
                    > tonic::server::StreamingService<super::Message>
                    for OpenChannelSvc<T> {
                        type Response = super::Message;
                        type ResponseStream = T::OpenChannelStream;
                        type Future = BoxFuture<
                            tonic::Response<Self::ResponseStream>,
                            tonic::Status,
                        >;
                        fn call(
                            &mut self,
                            request: tonic::Request<tonic::Streaming<super::Message>>,
                        ) -> Self::Future {
                            let inner = Arc::clone(&self.0);
                            let fut = async move {
                                <T as PubSubService>::open_channel(&inner, request).await
                            };
                            Box::pin(fut)
                        }
                    }
                    let accept_compression_encodings = self.accept_compression_encodings;
                    let send_compression_encodings = self.send_compression_encodings;
                    let max_decoding_message_size = self.max_decoding_message_size;
                    let max_encoding_message_size = self.max_encoding_message_size;
                    let inner = self.inner.clone();
                    let fut = async move {
                        let method = OpenChannelSvc(inner);
                        let codec = tonic::codec::ProstCodec::default();
                        let mut grpc = tonic::server::Grpc::new(codec)
                            .apply_compression_config(
                                accept_compression_encodings,
                                send_compression_encodings,
                            )
                            .apply_max_message_size_config(
                                max_decoding_message_size,
                                max_encoding_message_size,
                            );
                        let res = grpc.streaming(method, req).await;
                        Ok(res)
                    };
                    Box::pin(fut)
                }
                _ => {
                    Box::pin(async move {
                        let mut response = http::Response::new(
                            tonic::body::Body::default(),
                        );
                        let headers = response.headers_mut();
                        headers
                            .insert(
                                tonic::Status::GRPC_STATUS,
                                (tonic::Code::Unimplemented as i32).into(),
                            );
                        headers
                            .insert(
                                http::header::CONTENT_TYPE,
                                tonic::metadata::GRPC_CONTENT_TYPE,
                            );
                        Ok(response)
                    })
                }
            }
        }
    }
    impl<T> Clone for PubSubServiceServer<T> {
        fn clone(&self) -> Self {
            let inner = self.inner.clone();
            Self {
                inner,
                accept_compression_encodings: self.accept_compression_encodings,
                send_compression_encodings: self.send_compression_encodings,
                max_decoding_message_size: self.max_decoding_message_size,
                max_encoding_message_size: self.max_encoding_message_size,
            }
        }
    }
    /// Generated gRPC service name
    pub const SERVICE_NAME: &str = "pubsub.proto.v1.PubSubService";
    impl<T> tonic::server::NamedService for PubSubServiceServer<T> {
        const NAME: &'static str = SERVICE_NAME;
    }
}
