# coding: utf-8

"""
    Residential Electrification Model API

    An API for REM, the Residential Electrification Model.

    The version of the OpenAPI document: 0.4.6
    Contact: datascience@rewiringamerica.org
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501

import warnings
from pydantic import validate_call, Field, StrictFloat, StrictStr, StrictInt
from typing import Any, Dict, List, Optional, Tuple, Union
from typing_extensions import Annotated

from pydantic import Field, StrictStr
from typing_extensions import Annotated
from rewiringamerica_rem.models.heating_fuel import HeatingFuel
from rewiringamerica_rem.models.rem_profile_request import RemProfileRequest
from rewiringamerica_rem.models.savings import Savings
from rewiringamerica_rem.models.supported_upgrade import SupportedUpgrade

from rewiringamerica_rem.api_client import ApiClient, RequestSerialized
from rewiringamerica_rem.api_response import ApiResponse
from rewiringamerica_rem.rest import RESTResponseType


class ResidentialElectrificationModelApi:
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None) -> None:
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client


    @validate_call
    def get_by_address(
        self,
        upgrade: Annotated[SupportedUpgrade, Field(description="The upgrade whose effects we want to analyze. Supported values are as follows: - `baseline`: Baseline building with no upgrades applied. - `combination__all_electric__hvac_seer24_hspf13__weatherization`: A whole-home upgrade including a high efficiency air source heat pump for the home’s HVAC system, basic weatherization, a heat pump water heater, a heat pump dryer, and an induction stove. HVAC heat pump is SEER 24, HSPF 13 for ducted systems; SEER 29.3, HSPF 14 for ductless systems, heat pump water heater is UEF 3.35-3.45, and heat pump dryer is Combined Energy Factor (CEF) 5.2. Additional details can be found in measure package 9 (on page 9) of [this document](https://oedi-data-lake.s3.amazonaws.com/nrel-pds-building-stock/end-use-load-profiles-for-us-building-stock/2022/EUSS_ResRound1_Technical_Documentation.pdf).  - `combination__hvac_seer18_hspf10__weatherization`: A medium-efficiency heat pump upgrade for the home's HVAC system, plus a basic weatherization upgrade. The heat pump is SEER 18, HSPF 10 for ducted systems; SEER 18, HSPF 10.5 for ductless systems. The nominal capacity is sized equal to the larger of heating/cooling design loads, and the heating and cooling are modeled without setpoint setbacks. The basic weatherization component of this upgrade includes attic floor insulation, air sealing, duct sealing, and drill-and-fill insulation. Attic floor insulation levels are upgraded for compliance with IECC-Residential 2021 and range from R-30 to R-60 depending on climate zone. Attic floor insulation only applies to dwelling units with vented attics. Air sealing is performed to reduce ACH50 by 30%, duct sealing is performed to reduce duct leakage to 10%, and a drill-and-fill insulation level of R-13 is applied to uninsulated wood stud walls. Additional details can be found in measure package 1 (on page 4) of [this document](https://oedi-data-lake.s3.amazonaws.com/nrel-pds-building-stock/end-use-load-profiles-for-us-building-stock/2022/EUSS_ResRound1_Technical_Documentation.pdf). - `hvac__heat_pump_seer15_hspf9`: A relatively-low efficiency air source heat pump upgrade for the home’s HVAC system. Heat pump is SEER 15, HSPF 9 for both ducted and ductless systems.Additional details can be found in measure package 3 (on page 5) of [this document](https://oedi-data-lake.s3.amazonaws.com/nrel-pds-building-stock/end-use-load-profiles-for-us-building-stock/2022/EUSS_ResRound1_Technical_Documentation.pdf). - `hvac__heat_pump_seer18_hspf10`: A medium-efficiency heat pump upgrade for the home's HVAC system. SEER 18, HSPF 10 for ducted systems; SEER 18, HSPF 10.5 for ductless systems. The nominal capacity is sized equal to the larger of heating/cooling design loads, and the heating and cooling are modeled without setpoint setbacks.  - `hvac__heat_pump_seer24_hspf13`: A high efficiency air source heat pump upgrade for the home’s HVAC system. Heat pump is SEER 24, HSPF 13 for ducted systems; SEER 29.3, HSPF 14 for ductless systems. Additional details can be found in measure package 4 (on page 6) of [this document](https://oedi-data-lake.s3.amazonaws.com/nrel-pds-building-stock/end-use-load-profiles-for-us-building-stock/2022/EUSS_ResRound1_Technical_Documentation.pdf).  - `weatherization__insulation_air_duct_sealing`: A basic weatherization upgrade for the home. Measures include attic floor insulation, air sealing, duct sealing, and drill-and-fill insulation. Attic floor insulation levels are upgraded for compliance with IECC-Residential 2021 and range from R-30 to R-60 depending on climate zone. Attic floor insulation only applies to dwelling units with vented attics. Air sealing is performed to reduce ACH50 by 30%, duct sealing is performed to reduce duct leakage to 10%, and a drill-and-fill insulation level of R-13 is applied to uninsulated wood stud walls. Additional details can be found in measure package 1 (on page 4) of [this document](https://oedi-data-lake.s3.amazonaws.com/nrel-pds-building-stock/end-use-load-profiles-for-us-building-stock/2022/EUSS_ResRound1_Technical_Documentation.pdf).")],
        address: Annotated[str, Field(min_length=1, strict=True, description="The full address for a location including street number and name, city, state, and zip code.")],
        heating_fuel: Annotated[HeatingFuel, Field(description="The heating fuel used in the home before the upgrade. Supported values are as follows: - `electricity`: the home is currently heated with electric heating, such as   electric resistance heating or a heat pump. - `natural_gas`: The home is currently heated with natural gas. - `fuel_oil`: The home is currently heated with fuel oil. - `propane`:  The home is currently heated with propane. ")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> Savings:
        """Get by address

        Predict a user's annual savings using the Residential Electrification Model. This API makes predictions of the energy, emissions, and energy bill changes for an existing home based on the upgrade type, the address of the home being upgraded, and the current heating fuel.  Using the provided address, we first query a large database of home properties that Rewiring America has assembled, which contains data such as home age, size, construction material, and much more. We don't know all of the properties needed to get a good estimate of energy consumption, so we perform a [Monte Carlo](https://en.wikipedia.org/wiki/Monte_Carlo_method) simulation over a sample homes chosen from a [conditional probability distribution](https://github.com/NREL/resstock/tree/develop/project_national/housing_characteristics) based the properties that we do know. We then estimate the energy consumption for each sample building by running inference using a Machine Learning based surrogate model, trained on [EnergyPlus](https://energyplus.net/) simulations.  The response JSON is a dictionary with three components: - `fuel_results`: This is a dictionary of the main results from the model, one for each fuel type: `electricity`, `fuel_oil`, `natural_gas`, `propane`, `total` (for the total of all the others). - `rates`: A summary of the rates used to calculate the annual cost in dollars for each fuel. These vary from region to region based local fuel costs. - `emissions_factors`: A summary of the local emissions factors used to calculate annual emissions. Electricity emissions vary from region to region based on how electricity is generated.  Within the `fuel_results` subsection for each of the fuel types, there are three components:   - `baseline`: the annual usage of the fuel before the upgrade across all end uses  (e.g., heating, cooling, water heating, drying, cooking).   - `upgrade`: the annual usage of the fuel after the upgrade across all end uses.   - `delta`: the change in usage of the fuel across all end uses.  Inside those three, there are parallel structures with statistics for the `energy` consumption for each fuel, as well as the `emissions` and `cost` incurred by the consumption of each fuel. The electricity emissions factors are [long run marginal emissions rates assuming a 95% decarbonized grid by 2050](https://www.nrel.gov/analysis/cambium.html).  The emissions and costs are computed with the `rates` and `emissions_factors` data mentioned above, where the costs reflect the annual costs from both volumetric charges and fixed charges. Note that the fixed charges are based on the presence of the given fuel in the baseline scenario, and not assumed to change in the upgrade scenario.  All of the statistics are for a full typical weather year. The units for each of the statistics are also provided and are as appropriate for the fuel, emissions, or cost.  If `baseline` is specified as the upgrade in the request, `fuel_results` will exclude `upgrade` and `delta` since baseline represents the home's current state without any upgrades.  **A note on statistics**: For each value we provide statistics for, we provide a mean, a median, and the 20th and 80th percentile values over all the set of sample homes in the Monte Carlo simulation. It is important to note that the statistics are taken over the distribution of the values they represent. This means, for example, that the median electricity usage before the upgrade, the median electricity usage after the upgrade, and the median change of electricity usage might all be from the same modeled home. So adding the median change to the median usage before the upgrade might not produce the number reported as the median usage after the upgrade.  Note that because we are modeling whole home energy consumption over a set of building samples, and the building set contains homes with a variety of fuels for the non-heating appliances, you may see consumption of fuels other than the passed heating fuel, particularly for the mean.  **Demonstrations**  There are two sample Python notebooks that demonstrate the API in action. - [REM Demo.ipynb](https://github.com/rewiringamerica/api_demos/blob/main/notebooks/REM%20Demo.ipynb) illustrates basic API calls. - [All About REM Statistics.ipynb](https://github.com/rewiringamerica/api_demos/blob/main/notebooks/All%20About%20REM%20Statistics.ipynb) digs into details on the statistics that the API returns and how they relate to one another in various circumstances.  There are also examples showing how to integrate the REM API into a web site. See the full list [here](https://github.com/rewiringamerica/api_demos?tab=readme-ov-file#api_demos).

        :param upgrade: The upgrade whose effects we want to analyze. Supported values are as follows: - `baseline`: Baseline building with no upgrades applied. - `combination__all_electric__hvac_seer24_hspf13__weatherization`: A whole-home upgrade including a high efficiency air source heat pump for the home’s HVAC system, basic weatherization, a heat pump water heater, a heat pump dryer, and an induction stove. HVAC heat pump is SEER 24, HSPF 13 for ducted systems; SEER 29.3, HSPF 14 for ductless systems, heat pump water heater is UEF 3.35-3.45, and heat pump dryer is Combined Energy Factor (CEF) 5.2. Additional details can be found in measure package 9 (on page 9) of [this document](https://oedi-data-lake.s3.amazonaws.com/nrel-pds-building-stock/end-use-load-profiles-for-us-building-stock/2022/EUSS_ResRound1_Technical_Documentation.pdf).  - `combination__hvac_seer18_hspf10__weatherization`: A medium-efficiency heat pump upgrade for the home's HVAC system, plus a basic weatherization upgrade. The heat pump is SEER 18, HSPF 10 for ducted systems; SEER 18, HSPF 10.5 for ductless systems. The nominal capacity is sized equal to the larger of heating/cooling design loads, and the heating and cooling are modeled without setpoint setbacks. The basic weatherization component of this upgrade includes attic floor insulation, air sealing, duct sealing, and drill-and-fill insulation. Attic floor insulation levels are upgraded for compliance with IECC-Residential 2021 and range from R-30 to R-60 depending on climate zone. Attic floor insulation only applies to dwelling units with vented attics. Air sealing is performed to reduce ACH50 by 30%, duct sealing is performed to reduce duct leakage to 10%, and a drill-and-fill insulation level of R-13 is applied to uninsulated wood stud walls. Additional details can be found in measure package 1 (on page 4) of [this document](https://oedi-data-lake.s3.amazonaws.com/nrel-pds-building-stock/end-use-load-profiles-for-us-building-stock/2022/EUSS_ResRound1_Technical_Documentation.pdf). - `hvac__heat_pump_seer15_hspf9`: A relatively-low efficiency air source heat pump upgrade for the home’s HVAC system. Heat pump is SEER 15, HSPF 9 for both ducted and ductless systems.Additional details can be found in measure package 3 (on page 5) of [this document](https://oedi-data-lake.s3.amazonaws.com/nrel-pds-building-stock/end-use-load-profiles-for-us-building-stock/2022/EUSS_ResRound1_Technical_Documentation.pdf). - `hvac__heat_pump_seer18_hspf10`: A medium-efficiency heat pump upgrade for the home's HVAC system. SEER 18, HSPF 10 for ducted systems; SEER 18, HSPF 10.5 for ductless systems. The nominal capacity is sized equal to the larger of heating/cooling design loads, and the heating and cooling are modeled without setpoint setbacks.  - `hvac__heat_pump_seer24_hspf13`: A high efficiency air source heat pump upgrade for the home’s HVAC system. Heat pump is SEER 24, HSPF 13 for ducted systems; SEER 29.3, HSPF 14 for ductless systems. Additional details can be found in measure package 4 (on page 6) of [this document](https://oedi-data-lake.s3.amazonaws.com/nrel-pds-building-stock/end-use-load-profiles-for-us-building-stock/2022/EUSS_ResRound1_Technical_Documentation.pdf).  - `weatherization__insulation_air_duct_sealing`: A basic weatherization upgrade for the home. Measures include attic floor insulation, air sealing, duct sealing, and drill-and-fill insulation. Attic floor insulation levels are upgraded for compliance with IECC-Residential 2021 and range from R-30 to R-60 depending on climate zone. Attic floor insulation only applies to dwelling units with vented attics. Air sealing is performed to reduce ACH50 by 30%, duct sealing is performed to reduce duct leakage to 10%, and a drill-and-fill insulation level of R-13 is applied to uninsulated wood stud walls. Additional details can be found in measure package 1 (on page 4) of [this document](https://oedi-data-lake.s3.amazonaws.com/nrel-pds-building-stock/end-use-load-profiles-for-us-building-stock/2022/EUSS_ResRound1_Technical_Documentation.pdf). (required)
        :type upgrade: SupportedUpgrade
        :param address: The full address for a location including street number and name, city, state, and zip code. (required)
        :type address: str
        :param heating_fuel: The heating fuel used in the home before the upgrade. Supported values are as follows: - `electricity`: the home is currently heated with electric heating, such as   electric resistance heating or a heat pump. - `natural_gas`: The home is currently heated with natural gas. - `fuel_oil`: The home is currently heated with fuel oil. - `propane`:  The home is currently heated with propane.  (required)
        :type heating_fuel: HeatingFuel
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_by_address_serialize(
            upgrade=upgrade,
            address=address,
            heating_fuel=heating_fuel,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "Savings",
            '400': "HTTPValidationError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def get_by_address_with_http_info(
        self,
        upgrade: Annotated[SupportedUpgrade, Field(description="The upgrade whose effects we want to analyze. Supported values are as follows: - `baseline`: Baseline building with no upgrades applied. - `combination__all_electric__hvac_seer24_hspf13__weatherization`: A whole-home upgrade including a high efficiency air source heat pump for the home’s HVAC system, basic weatherization, a heat pump water heater, a heat pump dryer, and an induction stove. HVAC heat pump is SEER 24, HSPF 13 for ducted systems; SEER 29.3, HSPF 14 for ductless systems, heat pump water heater is UEF 3.35-3.45, and heat pump dryer is Combined Energy Factor (CEF) 5.2. Additional details can be found in measure package 9 (on page 9) of [this document](https://oedi-data-lake.s3.amazonaws.com/nrel-pds-building-stock/end-use-load-profiles-for-us-building-stock/2022/EUSS_ResRound1_Technical_Documentation.pdf).  - `combination__hvac_seer18_hspf10__weatherization`: A medium-efficiency heat pump upgrade for the home's HVAC system, plus a basic weatherization upgrade. The heat pump is SEER 18, HSPF 10 for ducted systems; SEER 18, HSPF 10.5 for ductless systems. The nominal capacity is sized equal to the larger of heating/cooling design loads, and the heating and cooling are modeled without setpoint setbacks. The basic weatherization component of this upgrade includes attic floor insulation, air sealing, duct sealing, and drill-and-fill insulation. Attic floor insulation levels are upgraded for compliance with IECC-Residential 2021 and range from R-30 to R-60 depending on climate zone. Attic floor insulation only applies to dwelling units with vented attics. Air sealing is performed to reduce ACH50 by 30%, duct sealing is performed to reduce duct leakage to 10%, and a drill-and-fill insulation level of R-13 is applied to uninsulated wood stud walls. Additional details can be found in measure package 1 (on page 4) of [this document](https://oedi-data-lake.s3.amazonaws.com/nrel-pds-building-stock/end-use-load-profiles-for-us-building-stock/2022/EUSS_ResRound1_Technical_Documentation.pdf). - `hvac__heat_pump_seer15_hspf9`: A relatively-low efficiency air source heat pump upgrade for the home’s HVAC system. Heat pump is SEER 15, HSPF 9 for both ducted and ductless systems.Additional details can be found in measure package 3 (on page 5) of [this document](https://oedi-data-lake.s3.amazonaws.com/nrel-pds-building-stock/end-use-load-profiles-for-us-building-stock/2022/EUSS_ResRound1_Technical_Documentation.pdf). - `hvac__heat_pump_seer18_hspf10`: A medium-efficiency heat pump upgrade for the home's HVAC system. SEER 18, HSPF 10 for ducted systems; SEER 18, HSPF 10.5 for ductless systems. The nominal capacity is sized equal to the larger of heating/cooling design loads, and the heating and cooling are modeled without setpoint setbacks.  - `hvac__heat_pump_seer24_hspf13`: A high efficiency air source heat pump upgrade for the home’s HVAC system. Heat pump is SEER 24, HSPF 13 for ducted systems; SEER 29.3, HSPF 14 for ductless systems. Additional details can be found in measure package 4 (on page 6) of [this document](https://oedi-data-lake.s3.amazonaws.com/nrel-pds-building-stock/end-use-load-profiles-for-us-building-stock/2022/EUSS_ResRound1_Technical_Documentation.pdf).  - `weatherization__insulation_air_duct_sealing`: A basic weatherization upgrade for the home. Measures include attic floor insulation, air sealing, duct sealing, and drill-and-fill insulation. Attic floor insulation levels are upgraded for compliance with IECC-Residential 2021 and range from R-30 to R-60 depending on climate zone. Attic floor insulation only applies to dwelling units with vented attics. Air sealing is performed to reduce ACH50 by 30%, duct sealing is performed to reduce duct leakage to 10%, and a drill-and-fill insulation level of R-13 is applied to uninsulated wood stud walls. Additional details can be found in measure package 1 (on page 4) of [this document](https://oedi-data-lake.s3.amazonaws.com/nrel-pds-building-stock/end-use-load-profiles-for-us-building-stock/2022/EUSS_ResRound1_Technical_Documentation.pdf).")],
        address: Annotated[str, Field(min_length=1, strict=True, description="The full address for a location including street number and name, city, state, and zip code.")],
        heating_fuel: Annotated[HeatingFuel, Field(description="The heating fuel used in the home before the upgrade. Supported values are as follows: - `electricity`: the home is currently heated with electric heating, such as   electric resistance heating or a heat pump. - `natural_gas`: The home is currently heated with natural gas. - `fuel_oil`: The home is currently heated with fuel oil. - `propane`:  The home is currently heated with propane. ")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[Savings]:
        """Get by address

        Predict a user's annual savings using the Residential Electrification Model. This API makes predictions of the energy, emissions, and energy bill changes for an existing home based on the upgrade type, the address of the home being upgraded, and the current heating fuel.  Using the provided address, we first query a large database of home properties that Rewiring America has assembled, which contains data such as home age, size, construction material, and much more. We don't know all of the properties needed to get a good estimate of energy consumption, so we perform a [Monte Carlo](https://en.wikipedia.org/wiki/Monte_Carlo_method) simulation over a sample homes chosen from a [conditional probability distribution](https://github.com/NREL/resstock/tree/develop/project_national/housing_characteristics) based the properties that we do know. We then estimate the energy consumption for each sample building by running inference using a Machine Learning based surrogate model, trained on [EnergyPlus](https://energyplus.net/) simulations.  The response JSON is a dictionary with three components: - `fuel_results`: This is a dictionary of the main results from the model, one for each fuel type: `electricity`, `fuel_oil`, `natural_gas`, `propane`, `total` (for the total of all the others). - `rates`: A summary of the rates used to calculate the annual cost in dollars for each fuel. These vary from region to region based local fuel costs. - `emissions_factors`: A summary of the local emissions factors used to calculate annual emissions. Electricity emissions vary from region to region based on how electricity is generated.  Within the `fuel_results` subsection for each of the fuel types, there are three components:   - `baseline`: the annual usage of the fuel before the upgrade across all end uses  (e.g., heating, cooling, water heating, drying, cooking).   - `upgrade`: the annual usage of the fuel after the upgrade across all end uses.   - `delta`: the change in usage of the fuel across all end uses.  Inside those three, there are parallel structures with statistics for the `energy` consumption for each fuel, as well as the `emissions` and `cost` incurred by the consumption of each fuel. The electricity emissions factors are [long run marginal emissions rates assuming a 95% decarbonized grid by 2050](https://www.nrel.gov/analysis/cambium.html).  The emissions and costs are computed with the `rates` and `emissions_factors` data mentioned above, where the costs reflect the annual costs from both volumetric charges and fixed charges. Note that the fixed charges are based on the presence of the given fuel in the baseline scenario, and not assumed to change in the upgrade scenario.  All of the statistics are for a full typical weather year. The units for each of the statistics are also provided and are as appropriate for the fuel, emissions, or cost.  If `baseline` is specified as the upgrade in the request, `fuel_results` will exclude `upgrade` and `delta` since baseline represents the home's current state without any upgrades.  **A note on statistics**: For each value we provide statistics for, we provide a mean, a median, and the 20th and 80th percentile values over all the set of sample homes in the Monte Carlo simulation. It is important to note that the statistics are taken over the distribution of the values they represent. This means, for example, that the median electricity usage before the upgrade, the median electricity usage after the upgrade, and the median change of electricity usage might all be from the same modeled home. So adding the median change to the median usage before the upgrade might not produce the number reported as the median usage after the upgrade.  Note that because we are modeling whole home energy consumption over a set of building samples, and the building set contains homes with a variety of fuels for the non-heating appliances, you may see consumption of fuels other than the passed heating fuel, particularly for the mean.  **Demonstrations**  There are two sample Python notebooks that demonstrate the API in action. - [REM Demo.ipynb](https://github.com/rewiringamerica/api_demos/blob/main/notebooks/REM%20Demo.ipynb) illustrates basic API calls. - [All About REM Statistics.ipynb](https://github.com/rewiringamerica/api_demos/blob/main/notebooks/All%20About%20REM%20Statistics.ipynb) digs into details on the statistics that the API returns and how they relate to one another in various circumstances.  There are also examples showing how to integrate the REM API into a web site. See the full list [here](https://github.com/rewiringamerica/api_demos?tab=readme-ov-file#api_demos).

        :param upgrade: The upgrade whose effects we want to analyze. Supported values are as follows: - `baseline`: Baseline building with no upgrades applied. - `combination__all_electric__hvac_seer24_hspf13__weatherization`: A whole-home upgrade including a high efficiency air source heat pump for the home’s HVAC system, basic weatherization, a heat pump water heater, a heat pump dryer, and an induction stove. HVAC heat pump is SEER 24, HSPF 13 for ducted systems; SEER 29.3, HSPF 14 for ductless systems, heat pump water heater is UEF 3.35-3.45, and heat pump dryer is Combined Energy Factor (CEF) 5.2. Additional details can be found in measure package 9 (on page 9) of [this document](https://oedi-data-lake.s3.amazonaws.com/nrel-pds-building-stock/end-use-load-profiles-for-us-building-stock/2022/EUSS_ResRound1_Technical_Documentation.pdf).  - `combination__hvac_seer18_hspf10__weatherization`: A medium-efficiency heat pump upgrade for the home's HVAC system, plus a basic weatherization upgrade. The heat pump is SEER 18, HSPF 10 for ducted systems; SEER 18, HSPF 10.5 for ductless systems. The nominal capacity is sized equal to the larger of heating/cooling design loads, and the heating and cooling are modeled without setpoint setbacks. The basic weatherization component of this upgrade includes attic floor insulation, air sealing, duct sealing, and drill-and-fill insulation. Attic floor insulation levels are upgraded for compliance with IECC-Residential 2021 and range from R-30 to R-60 depending on climate zone. Attic floor insulation only applies to dwelling units with vented attics. Air sealing is performed to reduce ACH50 by 30%, duct sealing is performed to reduce duct leakage to 10%, and a drill-and-fill insulation level of R-13 is applied to uninsulated wood stud walls. Additional details can be found in measure package 1 (on page 4) of [this document](https://oedi-data-lake.s3.amazonaws.com/nrel-pds-building-stock/end-use-load-profiles-for-us-building-stock/2022/EUSS_ResRound1_Technical_Documentation.pdf). - `hvac__heat_pump_seer15_hspf9`: A relatively-low efficiency air source heat pump upgrade for the home’s HVAC system. Heat pump is SEER 15, HSPF 9 for both ducted and ductless systems.Additional details can be found in measure package 3 (on page 5) of [this document](https://oedi-data-lake.s3.amazonaws.com/nrel-pds-building-stock/end-use-load-profiles-for-us-building-stock/2022/EUSS_ResRound1_Technical_Documentation.pdf). - `hvac__heat_pump_seer18_hspf10`: A medium-efficiency heat pump upgrade for the home's HVAC system. SEER 18, HSPF 10 for ducted systems; SEER 18, HSPF 10.5 for ductless systems. The nominal capacity is sized equal to the larger of heating/cooling design loads, and the heating and cooling are modeled without setpoint setbacks.  - `hvac__heat_pump_seer24_hspf13`: A high efficiency air source heat pump upgrade for the home’s HVAC system. Heat pump is SEER 24, HSPF 13 for ducted systems; SEER 29.3, HSPF 14 for ductless systems. Additional details can be found in measure package 4 (on page 6) of [this document](https://oedi-data-lake.s3.amazonaws.com/nrel-pds-building-stock/end-use-load-profiles-for-us-building-stock/2022/EUSS_ResRound1_Technical_Documentation.pdf).  - `weatherization__insulation_air_duct_sealing`: A basic weatherization upgrade for the home. Measures include attic floor insulation, air sealing, duct sealing, and drill-and-fill insulation. Attic floor insulation levels are upgraded for compliance with IECC-Residential 2021 and range from R-30 to R-60 depending on climate zone. Attic floor insulation only applies to dwelling units with vented attics. Air sealing is performed to reduce ACH50 by 30%, duct sealing is performed to reduce duct leakage to 10%, and a drill-and-fill insulation level of R-13 is applied to uninsulated wood stud walls. Additional details can be found in measure package 1 (on page 4) of [this document](https://oedi-data-lake.s3.amazonaws.com/nrel-pds-building-stock/end-use-load-profiles-for-us-building-stock/2022/EUSS_ResRound1_Technical_Documentation.pdf). (required)
        :type upgrade: SupportedUpgrade
        :param address: The full address for a location including street number and name, city, state, and zip code. (required)
        :type address: str
        :param heating_fuel: The heating fuel used in the home before the upgrade. Supported values are as follows: - `electricity`: the home is currently heated with electric heating, such as   electric resistance heating or a heat pump. - `natural_gas`: The home is currently heated with natural gas. - `fuel_oil`: The home is currently heated with fuel oil. - `propane`:  The home is currently heated with propane.  (required)
        :type heating_fuel: HeatingFuel
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_by_address_serialize(
            upgrade=upgrade,
            address=address,
            heating_fuel=heating_fuel,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "Savings",
            '400': "HTTPValidationError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def get_by_address_without_preload_content(
        self,
        upgrade: Annotated[SupportedUpgrade, Field(description="The upgrade whose effects we want to analyze. Supported values are as follows: - `baseline`: Baseline building with no upgrades applied. - `combination__all_electric__hvac_seer24_hspf13__weatherization`: A whole-home upgrade including a high efficiency air source heat pump for the home’s HVAC system, basic weatherization, a heat pump water heater, a heat pump dryer, and an induction stove. HVAC heat pump is SEER 24, HSPF 13 for ducted systems; SEER 29.3, HSPF 14 for ductless systems, heat pump water heater is UEF 3.35-3.45, and heat pump dryer is Combined Energy Factor (CEF) 5.2. Additional details can be found in measure package 9 (on page 9) of [this document](https://oedi-data-lake.s3.amazonaws.com/nrel-pds-building-stock/end-use-load-profiles-for-us-building-stock/2022/EUSS_ResRound1_Technical_Documentation.pdf).  - `combination__hvac_seer18_hspf10__weatherization`: A medium-efficiency heat pump upgrade for the home's HVAC system, plus a basic weatherization upgrade. The heat pump is SEER 18, HSPF 10 for ducted systems; SEER 18, HSPF 10.5 for ductless systems. The nominal capacity is sized equal to the larger of heating/cooling design loads, and the heating and cooling are modeled without setpoint setbacks. The basic weatherization component of this upgrade includes attic floor insulation, air sealing, duct sealing, and drill-and-fill insulation. Attic floor insulation levels are upgraded for compliance with IECC-Residential 2021 and range from R-30 to R-60 depending on climate zone. Attic floor insulation only applies to dwelling units with vented attics. Air sealing is performed to reduce ACH50 by 30%, duct sealing is performed to reduce duct leakage to 10%, and a drill-and-fill insulation level of R-13 is applied to uninsulated wood stud walls. Additional details can be found in measure package 1 (on page 4) of [this document](https://oedi-data-lake.s3.amazonaws.com/nrel-pds-building-stock/end-use-load-profiles-for-us-building-stock/2022/EUSS_ResRound1_Technical_Documentation.pdf). - `hvac__heat_pump_seer15_hspf9`: A relatively-low efficiency air source heat pump upgrade for the home’s HVAC system. Heat pump is SEER 15, HSPF 9 for both ducted and ductless systems.Additional details can be found in measure package 3 (on page 5) of [this document](https://oedi-data-lake.s3.amazonaws.com/nrel-pds-building-stock/end-use-load-profiles-for-us-building-stock/2022/EUSS_ResRound1_Technical_Documentation.pdf). - `hvac__heat_pump_seer18_hspf10`: A medium-efficiency heat pump upgrade for the home's HVAC system. SEER 18, HSPF 10 for ducted systems; SEER 18, HSPF 10.5 for ductless systems. The nominal capacity is sized equal to the larger of heating/cooling design loads, and the heating and cooling are modeled without setpoint setbacks.  - `hvac__heat_pump_seer24_hspf13`: A high efficiency air source heat pump upgrade for the home’s HVAC system. Heat pump is SEER 24, HSPF 13 for ducted systems; SEER 29.3, HSPF 14 for ductless systems. Additional details can be found in measure package 4 (on page 6) of [this document](https://oedi-data-lake.s3.amazonaws.com/nrel-pds-building-stock/end-use-load-profiles-for-us-building-stock/2022/EUSS_ResRound1_Technical_Documentation.pdf).  - `weatherization__insulation_air_duct_sealing`: A basic weatherization upgrade for the home. Measures include attic floor insulation, air sealing, duct sealing, and drill-and-fill insulation. Attic floor insulation levels are upgraded for compliance with IECC-Residential 2021 and range from R-30 to R-60 depending on climate zone. Attic floor insulation only applies to dwelling units with vented attics. Air sealing is performed to reduce ACH50 by 30%, duct sealing is performed to reduce duct leakage to 10%, and a drill-and-fill insulation level of R-13 is applied to uninsulated wood stud walls. Additional details can be found in measure package 1 (on page 4) of [this document](https://oedi-data-lake.s3.amazonaws.com/nrel-pds-building-stock/end-use-load-profiles-for-us-building-stock/2022/EUSS_ResRound1_Technical_Documentation.pdf).")],
        address: Annotated[str, Field(min_length=1, strict=True, description="The full address for a location including street number and name, city, state, and zip code.")],
        heating_fuel: Annotated[HeatingFuel, Field(description="The heating fuel used in the home before the upgrade. Supported values are as follows: - `electricity`: the home is currently heated with electric heating, such as   electric resistance heating or a heat pump. - `natural_gas`: The home is currently heated with natural gas. - `fuel_oil`: The home is currently heated with fuel oil. - `propane`:  The home is currently heated with propane. ")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get by address

        Predict a user's annual savings using the Residential Electrification Model. This API makes predictions of the energy, emissions, and energy bill changes for an existing home based on the upgrade type, the address of the home being upgraded, and the current heating fuel.  Using the provided address, we first query a large database of home properties that Rewiring America has assembled, which contains data such as home age, size, construction material, and much more. We don't know all of the properties needed to get a good estimate of energy consumption, so we perform a [Monte Carlo](https://en.wikipedia.org/wiki/Monte_Carlo_method) simulation over a sample homes chosen from a [conditional probability distribution](https://github.com/NREL/resstock/tree/develop/project_national/housing_characteristics) based the properties that we do know. We then estimate the energy consumption for each sample building by running inference using a Machine Learning based surrogate model, trained on [EnergyPlus](https://energyplus.net/) simulations.  The response JSON is a dictionary with three components: - `fuel_results`: This is a dictionary of the main results from the model, one for each fuel type: `electricity`, `fuel_oil`, `natural_gas`, `propane`, `total` (for the total of all the others). - `rates`: A summary of the rates used to calculate the annual cost in dollars for each fuel. These vary from region to region based local fuel costs. - `emissions_factors`: A summary of the local emissions factors used to calculate annual emissions. Electricity emissions vary from region to region based on how electricity is generated.  Within the `fuel_results` subsection for each of the fuel types, there are three components:   - `baseline`: the annual usage of the fuel before the upgrade across all end uses  (e.g., heating, cooling, water heating, drying, cooking).   - `upgrade`: the annual usage of the fuel after the upgrade across all end uses.   - `delta`: the change in usage of the fuel across all end uses.  Inside those three, there are parallel structures with statistics for the `energy` consumption for each fuel, as well as the `emissions` and `cost` incurred by the consumption of each fuel. The electricity emissions factors are [long run marginal emissions rates assuming a 95% decarbonized grid by 2050](https://www.nrel.gov/analysis/cambium.html).  The emissions and costs are computed with the `rates` and `emissions_factors` data mentioned above, where the costs reflect the annual costs from both volumetric charges and fixed charges. Note that the fixed charges are based on the presence of the given fuel in the baseline scenario, and not assumed to change in the upgrade scenario.  All of the statistics are for a full typical weather year. The units for each of the statistics are also provided and are as appropriate for the fuel, emissions, or cost.  If `baseline` is specified as the upgrade in the request, `fuel_results` will exclude `upgrade` and `delta` since baseline represents the home's current state without any upgrades.  **A note on statistics**: For each value we provide statistics for, we provide a mean, a median, and the 20th and 80th percentile values over all the set of sample homes in the Monte Carlo simulation. It is important to note that the statistics are taken over the distribution of the values they represent. This means, for example, that the median electricity usage before the upgrade, the median electricity usage after the upgrade, and the median change of electricity usage might all be from the same modeled home. So adding the median change to the median usage before the upgrade might not produce the number reported as the median usage after the upgrade.  Note that because we are modeling whole home energy consumption over a set of building samples, and the building set contains homes with a variety of fuels for the non-heating appliances, you may see consumption of fuels other than the passed heating fuel, particularly for the mean.  **Demonstrations**  There are two sample Python notebooks that demonstrate the API in action. - [REM Demo.ipynb](https://github.com/rewiringamerica/api_demos/blob/main/notebooks/REM%20Demo.ipynb) illustrates basic API calls. - [All About REM Statistics.ipynb](https://github.com/rewiringamerica/api_demos/blob/main/notebooks/All%20About%20REM%20Statistics.ipynb) digs into details on the statistics that the API returns and how they relate to one another in various circumstances.  There are also examples showing how to integrate the REM API into a web site. See the full list [here](https://github.com/rewiringamerica/api_demos?tab=readme-ov-file#api_demos).

        :param upgrade: The upgrade whose effects we want to analyze. Supported values are as follows: - `baseline`: Baseline building with no upgrades applied. - `combination__all_electric__hvac_seer24_hspf13__weatherization`: A whole-home upgrade including a high efficiency air source heat pump for the home’s HVAC system, basic weatherization, a heat pump water heater, a heat pump dryer, and an induction stove. HVAC heat pump is SEER 24, HSPF 13 for ducted systems; SEER 29.3, HSPF 14 for ductless systems, heat pump water heater is UEF 3.35-3.45, and heat pump dryer is Combined Energy Factor (CEF) 5.2. Additional details can be found in measure package 9 (on page 9) of [this document](https://oedi-data-lake.s3.amazonaws.com/nrel-pds-building-stock/end-use-load-profiles-for-us-building-stock/2022/EUSS_ResRound1_Technical_Documentation.pdf).  - `combination__hvac_seer18_hspf10__weatherization`: A medium-efficiency heat pump upgrade for the home's HVAC system, plus a basic weatherization upgrade. The heat pump is SEER 18, HSPF 10 for ducted systems; SEER 18, HSPF 10.5 for ductless systems. The nominal capacity is sized equal to the larger of heating/cooling design loads, and the heating and cooling are modeled without setpoint setbacks. The basic weatherization component of this upgrade includes attic floor insulation, air sealing, duct sealing, and drill-and-fill insulation. Attic floor insulation levels are upgraded for compliance with IECC-Residential 2021 and range from R-30 to R-60 depending on climate zone. Attic floor insulation only applies to dwelling units with vented attics. Air sealing is performed to reduce ACH50 by 30%, duct sealing is performed to reduce duct leakage to 10%, and a drill-and-fill insulation level of R-13 is applied to uninsulated wood stud walls. Additional details can be found in measure package 1 (on page 4) of [this document](https://oedi-data-lake.s3.amazonaws.com/nrel-pds-building-stock/end-use-load-profiles-for-us-building-stock/2022/EUSS_ResRound1_Technical_Documentation.pdf). - `hvac__heat_pump_seer15_hspf9`: A relatively-low efficiency air source heat pump upgrade for the home’s HVAC system. Heat pump is SEER 15, HSPF 9 for both ducted and ductless systems.Additional details can be found in measure package 3 (on page 5) of [this document](https://oedi-data-lake.s3.amazonaws.com/nrel-pds-building-stock/end-use-load-profiles-for-us-building-stock/2022/EUSS_ResRound1_Technical_Documentation.pdf). - `hvac__heat_pump_seer18_hspf10`: A medium-efficiency heat pump upgrade for the home's HVAC system. SEER 18, HSPF 10 for ducted systems; SEER 18, HSPF 10.5 for ductless systems. The nominal capacity is sized equal to the larger of heating/cooling design loads, and the heating and cooling are modeled without setpoint setbacks.  - `hvac__heat_pump_seer24_hspf13`: A high efficiency air source heat pump upgrade for the home’s HVAC system. Heat pump is SEER 24, HSPF 13 for ducted systems; SEER 29.3, HSPF 14 for ductless systems. Additional details can be found in measure package 4 (on page 6) of [this document](https://oedi-data-lake.s3.amazonaws.com/nrel-pds-building-stock/end-use-load-profiles-for-us-building-stock/2022/EUSS_ResRound1_Technical_Documentation.pdf).  - `weatherization__insulation_air_duct_sealing`: A basic weatherization upgrade for the home. Measures include attic floor insulation, air sealing, duct sealing, and drill-and-fill insulation. Attic floor insulation levels are upgraded for compliance with IECC-Residential 2021 and range from R-30 to R-60 depending on climate zone. Attic floor insulation only applies to dwelling units with vented attics. Air sealing is performed to reduce ACH50 by 30%, duct sealing is performed to reduce duct leakage to 10%, and a drill-and-fill insulation level of R-13 is applied to uninsulated wood stud walls. Additional details can be found in measure package 1 (on page 4) of [this document](https://oedi-data-lake.s3.amazonaws.com/nrel-pds-building-stock/end-use-load-profiles-for-us-building-stock/2022/EUSS_ResRound1_Technical_Documentation.pdf). (required)
        :type upgrade: SupportedUpgrade
        :param address: The full address for a location including street number and name, city, state, and zip code. (required)
        :type address: str
        :param heating_fuel: The heating fuel used in the home before the upgrade. Supported values are as follows: - `electricity`: the home is currently heated with electric heating, such as   electric resistance heating or a heat pump. - `natural_gas`: The home is currently heated with natural gas. - `fuel_oil`: The home is currently heated with fuel oil. - `propane`:  The home is currently heated with propane.  (required)
        :type heating_fuel: HeatingFuel
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_by_address_serialize(
            upgrade=upgrade,
            address=address,
            heating_fuel=heating_fuel,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "Savings",
            '400': "HTTPValidationError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_by_address_serialize(
        self,
        upgrade,
        address,
        heating_fuel,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if upgrade is not None:
            
            _query_params.append(('upgrade', upgrade.value))
            
        if address is not None:
            
            _query_params.append(('address', address))
            
        if heating_fuel is not None:
            
            _query_params.append(('heating_fuel', heating_fuel.value))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'auth'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/v1/rem/address',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def get_by_profile(
        self,
        rem_profile_request: RemProfileRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> Savings:
        """Get by profile

        Predict a user's annual savings using Residential Electrification Model, using a Building Profile and an Upgrade.

        :param rem_profile_request: (required)
        :type rem_profile_request: RemProfileRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_by_profile_serialize(
            rem_profile_request=rem_profile_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "Savings",
            '400': "HTTPValidationError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def get_by_profile_with_http_info(
        self,
        rem_profile_request: RemProfileRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[Savings]:
        """Get by profile

        Predict a user's annual savings using Residential Electrification Model, using a Building Profile and an Upgrade.

        :param rem_profile_request: (required)
        :type rem_profile_request: RemProfileRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_by_profile_serialize(
            rem_profile_request=rem_profile_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "Savings",
            '400': "HTTPValidationError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def get_by_profile_without_preload_content(
        self,
        rem_profile_request: RemProfileRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get by profile

        Predict a user's annual savings using Residential Electrification Model, using a Building Profile and an Upgrade.

        :param rem_profile_request: (required)
        :type rem_profile_request: RemProfileRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_by_profile_serialize(
            rem_profile_request=rem_profile_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "Savings",
            '400': "HTTPValidationError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_by_profile_serialize(
        self,
        rem_profile_request,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if rem_profile_request is not None:
            _body_params = rem_profile_request


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'auth'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/api/v1/rem/profile',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def get_impl_version(
        self,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> str:
        """Get implementation version

        Return the back end version of the code that is deployed.  This is not the version of the API, but rather of the code that implements it. This is mainly to track code deployments. The same API version is typically supported by a series of deployments each of which improves upon earlier ones in some way, such as fixing bugs or improving performance.

        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_impl_version_serialize(
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "str",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def get_impl_version_with_http_info(
        self,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[str]:
        """Get implementation version

        Return the back end version of the code that is deployed.  This is not the version of the API, but rather of the code that implements it. This is mainly to track code deployments. The same API version is typically supported by a series of deployments each of which improves upon earlier ones in some way, such as fixing bugs or improving performance.

        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_impl_version_serialize(
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "str",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def get_impl_version_without_preload_content(
        self,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get implementation version

        Return the back end version of the code that is deployed.  This is not the version of the API, but rather of the code that implements it. This is mainly to track code deployments. The same API version is typically supported by a series of deployments each of which improves upon earlier ones in some way, such as fixing bugs or improving performance.

        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_impl_version_serialize(
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "str",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_impl_version_serialize(
        self,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'auth'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/v1/rem/server_version',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )


