#!/usr/bin/env python
# -*- coding: utf-8 -*-

#
# Generated Thu Jan 30 15:00:37 2025 by generateDS.py version 2.43.3.
# Python 3.12.6 (tags/v3.12.6:a4a2d2b, Sep  6 2024, 20:11:23) [MSC v.1940 64 bit (AMD64)]
#
# Command line options:
#   ('-o', 'r4.py')
#   ('--no-questions', '')
#   ('-f', '')
#   ('--export', 'write json')
#   ('--use-namespacedef-instead-of-namespaceprefix-for', 'xhtml')
#
# Command line arguments:
#   C:\Users\nikol\gitrepos\malac-hd\malac\models\fhir\schema\r4b\fhir-single.xsd
#
# Command line:
#   generateDS.py -o "r4.py" --no-questions -f --export="write json" --use-namespacedef-instead-of-namespaceprefix-for="xhtml" C:\Users\nikol\gitrepos\malac-hd\malac\models\fhir\schema\r4b\fhir-single.xsd
#
# Current working directory (os.getcwd()):
#   generateds
#

import sys
try:
    ModulenotfoundExp_ = ModuleNotFoundError
except NameError:
    ModulenotfoundExp_ = ImportError
from six.moves import zip_longest
import os
import re as re_
import base64
# imports for django and/or sqlalchemy
import json as json_
import datetime as datetime_
import decimal as decimal_
from lxml import etree as etree_
from typing import List as List_


Validate_simpletypes_ = True
SaveElementTreeNode = True
SaveNodeDict = True
TagNamePrefix = ""
if sys.version_info.major == 2:
    BaseStrType_ = basestring
else:
    BaseStrType_ = str
node_dict = {}


def parsexml_(infile, parser=None, **kwargs):
    if parser is None:
        # Use the lxml ElementTree compatible parser so that, e.g.,
        #   we ignore comments.
        try:
            parser = etree_.ETCompatXMLParser()
        except AttributeError:
            # fallback to xml.etree
            parser = etree_.XMLParser()
    try:
        if isinstance(infile, os.PathLike):
            infile = os.path.join(infile)
    except AttributeError:
        pass
    doc = etree_.parse(infile, parser=parser, **kwargs)
    return doc

def parsexmlstring_(instring, parser=None, **kwargs):
    if parser is None:
        # Use the lxml ElementTree compatible parser so that, e.g.,
        #   we ignore comments.
        try:
            parser = etree_.ETCompatXMLParser()
        except AttributeError:
            # fallback to xml.etree
            parser = etree_.XMLParser()
    element = etree_.fromstring(instring, parser=parser, **kwargs)
    return element

#
# Namespace prefix definition table (and other attributes, too)
#
# The module generatedsnamespaces, if it is importable, must contain
# a dictionary named GeneratedsNamespaceDefs.  This Python dictionary
# should map element type names (strings) to XML schema namespace prefix
# definitions.  The export method for any class for which there is
# a namespace prefix definition, will export that definition in the
# XML representation of that element.  See the export method of
# any generated element type class for an example of the use of this
# table.
# A sample table is:
#
#     # File: generatedsnamespaces.py
#
#     GenerateDSNamespaceDefs = {
#         "ElementtypeA": "http://www.xxx.com/namespaceA",
#         "ElementtypeB": "http://www.xxx.com/namespaceB",
#     }
#
# Additionally, the generatedsnamespaces module can contain a python
# dictionary named GenerateDSNamespaceTypePrefixes that associates element
# types with the namespace prefixes that are to be added to the
# "xsi:type" attribute value.  See the _exportAttributes method of
# any generated element type and the generation of "xsi:type" for an
# example of the use of this table.
# An example table:
#
#     # File: generatedsnamespaces.py
#
#     GenerateDSNamespaceTypePrefixes = {
#         "ElementtypeC": "aaa:",
#         "ElementtypeD": "bbb:",
#     }
#

try:
    from generatedsnamespaces import GenerateDSNamespaceDefs as GenerateDSNamespaceDefs_
except ModulenotfoundExp_ :
    GenerateDSNamespaceDefs_ = {}
try:
    from generatedsnamespaces import GenerateDSNamespaceTypePrefixes as GenerateDSNamespaceTypePrefixes_
except ModulenotfoundExp_ :
    GenerateDSNamespaceTypePrefixes_ = {}

#
# You can replace the following class definition by defining an
# importable module named "generatedscollector" containing a class
# named "GdsCollector".  See the default class definition below for
# clues about the possible content of that class.
#
try:
    from generatedscollector import GdsCollector as GdsCollector_
except ModulenotfoundExp_ :

    class GdsCollector_(object):

        def __init__(self, messages=None):
            if messages is None:
                self.messages = []
            else:
                self.messages = messages

        def add_message(self, msg):
            self.messages.append(msg)

        def get_messages(self):
            return self.messages

        def clear_messages(self):
            self.messages = []

        def print_messages(self):
            for msg in self.messages:
                print("Warning: {}".format(msg))

        def write_messages(self, outstream):
            for msg in self.messages:
                outstream.write("Warning: {}\n".format(msg))


#
# The super-class for enum types
#

try:
    from enum import Enum
except ModulenotfoundExp_ :
    Enum = object

#
# The root super-class for element type classes
#
# Calls to the methods in these classes are generated by generateDS.py.
# You can replace these methods by re-implementing the following class
#   in a module named generatedssuper.py.

try:
    from generatedssuper import GeneratedsSuper
except ModulenotfoundExp_ as exp:
    try:
        from generatedssupersuper import GeneratedsSuperSuper
    except ModulenotfoundExp_ as exp:
        class GeneratedsSuperSuper(object):
            pass
    
    class GeneratedsSuper(GeneratedsSuperSuper):
        __hash__ = object.__hash__
        tzoff_pattern = re_.compile(r'(\+|-)((0\d|1[0-3]):[0-5]\d|14:00)$')
        class _FixedOffsetTZ(datetime_.tzinfo):
            def __init__(self, offset, name):
                self.__offset = datetime_.timedelta(minutes=offset)
                self.__name = name
            def utcoffset(self, dt):
                return self.__offset
            def tzname(self, dt):
                return self.__name
            def dst(self, dt):
                return None
        def __str__(self):
            settings = {
                'str_pretty_print': True,
                'str_indent_level': 0,
                'str_namespaceprefix': '',
                'str_name': self.__class__.__name__,
                'str_namespacedefs': '',
            }
            for n in settings:
                if hasattr(self, n):
                    settings[n] = getattr(self, n)
            if sys.version_info.major == 2:
                from StringIO import StringIO
            else:
                from io import StringIO
            output = StringIO()
            self.export(
                output,
                settings['str_indent_level'],
                pretty_print=settings['str_pretty_print'],
                namespaceprefix_=settings['str_namespaceprefix'],
                name_=settings['str_name'],
                namespacedef_=settings['str_namespacedefs']
            )
            strval = output.getvalue()
            output.close()
            return strval
        def gds_format_string(self, input_data, input_name=''):
            return input_data
        def gds_parse_string(self, input_data, node=None, input_name=''):
            return input_data
        def gds_validate_string(self, input_data, node=None, input_name=''):
            if not input_data:
                return ''
            else:
                return input_data
        def gds_format_base64(self, input_data, input_name=''):
            return base64.b64encode(input_data).decode('ascii')
        def gds_validate_base64(self, input_data, node=None, input_name=''):
            return input_data
        def gds_format_integer(self, input_data, input_name=''):
            return '%d' % int(input_data)
        def gds_parse_integer(self, input_data, node=None, input_name=''):
            try:
                ival = int(input_data)
            except (TypeError, ValueError) as exp:
                raise_parse_error(node, 'Requires integer value: %s' % exp)
            return ival
        def gds_validate_integer(self, input_data, node=None, input_name=''):
            try:
                value = int(input_data)
            except (TypeError, ValueError):
                raise_parse_error(node, 'Requires integer value')
            return value
        def gds_format_integer_list(self, input_data, input_name=''):
            if len(input_data) > 0 and not isinstance(input_data[0], BaseStrType_):
                input_data = [str(s) for s in input_data]
            return '%s' % ' '.join(input_data)
        def gds_validate_integer_list(
                self, input_data, node=None, input_name=''):
            values = input_data.split()
            for value in values:
                try:
                    int(value)
                except (TypeError, ValueError):
                    raise_parse_error(node, 'Requires sequence of integer values')
            return values
        def gds_format_float(self, input_data, input_name=''):
            value = ('%.15f' % float(input_data)).rstrip('0')
            if value.endswith('.'):
                value += '0'
            return value
    
        def gds_parse_float(self, input_data, node=None, input_name=''):
            try:
                fval_ = float(input_data)
            except (TypeError, ValueError) as exp:
                raise_parse_error(node, 'Requires float or double value: %s' % exp)
            return fval_
        def gds_validate_float(self, input_data, node=None, input_name=''):
            try:
                value = float(input_data)
            except (TypeError, ValueError):
                raise_parse_error(node, 'Requires float value')
            return value
        def gds_format_float_list(self, input_data, input_name=''):
            if len(input_data) > 0 and not isinstance(input_data[0], BaseStrType_):
                input_data = [str(s) for s in input_data]
            return '%s' % ' '.join(input_data)
        def gds_validate_float_list(
                self, input_data, node=None, input_name=''):
            values = input_data.split()
            for value in values:
                try:
                    float(value)
                except (TypeError, ValueError):
                    raise_parse_error(node, 'Requires sequence of float values')
            return values
        def gds_format_decimal(self, input_data, input_name=''):
            return_value = '%s' % input_data
            if '.' in return_value:
                return_value = return_value.rstrip('0')
                if return_value.endswith('.'):
                    return_value = return_value.rstrip('.')
            return return_value
        def gds_parse_decimal(self, input_data, node=None, input_name=''):
            try:
                decimal_value = decimal_.Decimal(input_data)
            except (TypeError, ValueError):
                raise_parse_error(node, 'Requires decimal value')
            return decimal_value
        def gds_validate_decimal(self, input_data, node=None, input_name=''):
            try:
                value = decimal_.Decimal(input_data)
            except (TypeError, ValueError):
                raise_parse_error(node, 'Requires decimal value')
            return value
        def gds_format_decimal_list(self, input_data, input_name=''):
            if len(input_data) > 0 and not isinstance(input_data[0], BaseStrType_):
                input_data = [str(s) for s in input_data]
            return ' '.join([self.gds_format_decimal(item) for item in input_data])
        def gds_validate_decimal_list(
                self, input_data, node=None, input_name=''):
            values = input_data.split()
            for value in values:
                try:
                    decimal_.Decimal(value)
                except (TypeError, ValueError):
                    raise_parse_error(node, 'Requires sequence of decimal values')
            return values
        def gds_format_double(self, input_data, input_name=''):
            return '%s' % input_data
        def gds_parse_double(self, input_data, node=None, input_name=''):
            try:
                fval_ = float(input_data)
            except (TypeError, ValueError) as exp:
                raise_parse_error(node, 'Requires double or float value: %s' % exp)
            return fval_
        def gds_validate_double(self, input_data, node=None, input_name=''):
            try:
                value = float(input_data)
            except (TypeError, ValueError):
                raise_parse_error(node, 'Requires double or float value')
            return value
        def gds_format_double_list(self, input_data, input_name=''):
            if len(input_data) > 0 and not isinstance(input_data[0], BaseStrType_):
                input_data = [str(s) for s in input_data]
            return '%s' % ' '.join(input_data)
        def gds_validate_double_list(
                self, input_data, node=None, input_name=''):
            values = input_data.split()
            for value in values:
                try:
                    float(value)
                except (TypeError, ValueError):
                    raise_parse_error(
                        node, 'Requires sequence of double or float values')
            return values
        def gds_format_boolean(self, input_data, input_name=''):
            return ('%s' % input_data).lower()
        def gds_parse_boolean(self, input_data, node=None, input_name=''):
            input_data = input_data.strip()
            if input_data in ('true', '1'):
                bval = True
            elif input_data in ('false', '0'):
                bval = False
            else:
                raise_parse_error(node, 'Requires boolean value')
            return bval
        def gds_validate_boolean(self, input_data, node=None, input_name=''):
            if input_data not in (True, 1, False, 0, ):
                raise_parse_error(
                    node,
                    'Requires boolean value '
                    '(one of True, 1, False, 0)')
            return input_data
        def gds_format_boolean_list(self, input_data, input_name=''):
            if len(input_data) > 0 and not isinstance(input_data[0], BaseStrType_):
                input_data = [str(s) for s in input_data]
            return '%s' % ' '.join(input_data)
        def gds_validate_boolean_list(
                self, input_data, node=None, input_name=''):
            values = input_data.split()
            for value in values:
                value = self.gds_parse_boolean(value, node, input_name)
                if value not in (True, 1, False, 0, ):
                    raise_parse_error(
                        node,
                        'Requires sequence of boolean values '
                        '(one of True, 1, False, 0)')
            return values
        def gds_validate_datetime(self, input_data, node=None, input_name=''):
            return input_data
        def gds_format_datetime(self, input_data, input_name=''):
            if input_data.microsecond == 0:
                _svalue = '%04d-%02d-%02dT%02d:%02d:%02d' % (
                    input_data.year,
                    input_data.month,
                    input_data.day,
                    input_data.hour,
                    input_data.minute,
                    input_data.second,
                )
            else:
                _svalue = '%04d-%02d-%02dT%02d:%02d:%02d.%s' % (
                    input_data.year,
                    input_data.month,
                    input_data.day,
                    input_data.hour,
                    input_data.minute,
                    input_data.second,
                    ('%f' % (float(input_data.microsecond) / 1000000))[2:],
                )
            if input_data.tzinfo is not None:
                tzoff = input_data.tzinfo.utcoffset(input_data)
                if tzoff is not None:
                    total_seconds = tzoff.seconds + (86400 * tzoff.days)
                    if total_seconds == 0:
                        _svalue += 'Z'
                    else:
                        if total_seconds < 0:
                            _svalue += '-'
                            total_seconds *= -1
                        else:
                            _svalue += '+'
                        hours = total_seconds // 3600
                        minutes = (total_seconds - (hours * 3600)) // 60
                        _svalue += '{0:02d}:{1:02d}'.format(hours, minutes)
            return _svalue
        @classmethod
        def gds_parse_datetime(cls, input_data):
            tz = None
            if input_data[-1] == 'Z':
                tz = GeneratedsSuper._FixedOffsetTZ(0, 'UTC')
                input_data = input_data[:-1]
            else:
                results = GeneratedsSuper.tzoff_pattern.search(input_data)
                if results is not None:
                    tzoff_parts = results.group(2).split(':')
                    tzoff = int(tzoff_parts[0]) * 60 + int(tzoff_parts[1])
                    if results.group(1) == '-':
                        tzoff *= -1
                    tz = GeneratedsSuper._FixedOffsetTZ(
                        tzoff, results.group(0))
                    input_data = input_data[:-6]
            time_parts = input_data.split('.')
            if len(time_parts) > 1:
                micro_seconds = int(float('0.' + time_parts[1]) * 1000000)
                input_data = '%s.%s' % (
                    time_parts[0], "{}".format(micro_seconds).rjust(6, "0"), )
                dt = datetime_.datetime.strptime(
                    input_data, '%Y-%m-%dT%H:%M:%S.%f')
            else:
                dt = datetime_.datetime.strptime(
                    input_data, '%Y-%m-%dT%H:%M:%S')
            dt = dt.replace(tzinfo=tz)
            return dt
        def gds_validate_date(self, input_data, node=None, input_name=''):
            return input_data
        def gds_format_date(self, input_data, input_name=''):
            _svalue = '%04d-%02d-%02d' % (
                input_data.year,
                input_data.month,
                input_data.day,
            )
            try:
                if input_data.tzinfo is not None:
                    tzoff = input_data.tzinfo.utcoffset(input_data)
                    if tzoff is not None:
                        total_seconds = tzoff.seconds + (86400 * tzoff.days)
                        if total_seconds == 0:
                            _svalue += 'Z'
                        else:
                            if total_seconds < 0:
                                _svalue += '-'
                                total_seconds *= -1
                            else:
                                _svalue += '+'
                            hours = total_seconds // 3600
                            minutes = (total_seconds - (hours * 3600)) // 60
                            _svalue += '{0:02d}:{1:02d}'.format(
                                hours, minutes)
            except AttributeError:
                pass
            return _svalue
        @classmethod
        def gds_parse_date(cls, input_data):
            tz = None
            if input_data[-1] == 'Z':
                tz = GeneratedsSuper._FixedOffsetTZ(0, 'UTC')
                input_data = input_data[:-1]
            else:
                results = GeneratedsSuper.tzoff_pattern.search(input_data)
                if results is not None:
                    tzoff_parts = results.group(2).split(':')
                    tzoff = int(tzoff_parts[0]) * 60 + int(tzoff_parts[1])
                    if results.group(1) == '-':
                        tzoff *= -1
                    tz = GeneratedsSuper._FixedOffsetTZ(
                        tzoff, results.group(0))
                    input_data = input_data[:-6]
            dt = datetime_.datetime.strptime(input_data, '%Y-%m-%d')
            dt = dt.replace(tzinfo=tz)
            return dt.date()
        def gds_validate_time(self, input_data, node=None, input_name=''):
            return input_data
        def gds_format_time(self, input_data, input_name=''):
            if input_data.microsecond == 0:
                _svalue = '%02d:%02d:%02d' % (
                    input_data.hour,
                    input_data.minute,
                    input_data.second,
                )
            else:
                _svalue = '%02d:%02d:%02d.%s' % (
                    input_data.hour,
                    input_data.minute,
                    input_data.second,
                    ('%f' % (float(input_data.microsecond) / 1000000))[2:],
                )
            if input_data.tzinfo is not None:
                tzoff = input_data.tzinfo.utcoffset(input_data)
                if tzoff is not None:
                    total_seconds = tzoff.seconds + (86400 * tzoff.days)
                    if total_seconds == 0:
                        _svalue += 'Z'
                    else:
                        if total_seconds < 0:
                            _svalue += '-'
                            total_seconds *= -1
                        else:
                            _svalue += '+'
                        hours = total_seconds // 3600
                        minutes = (total_seconds - (hours * 3600)) // 60
                        _svalue += '{0:02d}:{1:02d}'.format(hours, minutes)
            return _svalue
        def gds_validate_simple_patterns(self, patterns, target):
            # pat is a list of lists of strings/patterns.
            # The target value must match at least one of the patterns
            # in order for the test to succeed.
            found1 = True
            target = str(target)
            for patterns1 in patterns:
                found2 = False
                for patterns2 in patterns1:
                    mo = re_.search(patterns2, target)
                    if mo is not None and len(mo.group(0)) == len(target):
                        found2 = True
                        break
                if not found2:
                    found1 = False
                    break
            return found1
        @classmethod
        def gds_parse_time(cls, input_data):
            tz = None
            if input_data[-1] == 'Z':
                tz = GeneratedsSuper._FixedOffsetTZ(0, 'UTC')
                input_data = input_data[:-1]
            else:
                results = GeneratedsSuper.tzoff_pattern.search(input_data)
                if results is not None:
                    tzoff_parts = results.group(2).split(':')
                    tzoff = int(tzoff_parts[0]) * 60 + int(tzoff_parts[1])
                    if results.group(1) == '-':
                        tzoff *= -1
                    tz = GeneratedsSuper._FixedOffsetTZ(
                        tzoff, results.group(0))
                    input_data = input_data[:-6]
            if len(input_data.split('.')) > 1:
                dt = datetime_.datetime.strptime(input_data, '%H:%M:%S.%f')
            else:
                dt = datetime_.datetime.strptime(input_data, '%H:%M:%S')
            dt = dt.replace(tzinfo=tz)
            return dt.time()
        def gds_check_cardinality_(
                self, value, input_name,
                min_occurs=0, max_occurs=1, required=None):
            if value is None:
                length = 0
            elif isinstance(value, list):
                length = len(value)
            else:
                length = 1
            if required is not None :
                if required and length < 1:
                    self.gds_collector_.add_message(
                        "Required value {}{} is missing".format(
                            input_name, self.gds_get_node_lineno_()))
            if length < min_occurs:
                self.gds_collector_.add_message(
                    "Number of values for {}{} is below "
                    "the minimum allowed, "
                    "expected at least {}, found {}".format(
                        input_name, self.gds_get_node_lineno_(),
                        min_occurs, length))
            elif length > max_occurs:
                self.gds_collector_.add_message(
                    "Number of values for {}{} is above "
                    "the maximum allowed, "
                    "expected at most {}, found {}".format(
                        input_name, self.gds_get_node_lineno_(),
                        max_occurs, length))
        def gds_validate_builtin_ST_(
                self, validator, value, input_name,
                min_occurs=None, max_occurs=None, required=None):
            if value is not None:
                try:
                    validator(value, input_name=input_name)
                except GDSParseError as parse_error:
                    self.gds_collector_.add_message(str(parse_error))
        def gds_validate_defined_ST_(
                self, validator, value, input_name,
                min_occurs=None, max_occurs=None, required=None):
            if value is not None:
                try:
                    validator(value)
                except GDSParseError as parse_error:
                    self.gds_collector_.add_message(str(parse_error))
        def gds_str_lower(self, instring):
            return instring.lower()
        def get_path_(self, node):
            path_list = []
            self.get_path_list_(node, path_list)
            path_list.reverse()
            path = '/'.join(path_list)
            return path
        Tag_strip_pattern_ = re_.compile(r'\{.*\}')
        def get_path_list_(self, node, path_list):
            if node is None:
                return
            tag = GeneratedsSuper.Tag_strip_pattern_.sub('', node.tag)
            if tag:
                path_list.append(tag)
            self.get_path_list_(node.getparent(), path_list)
        def get_class_obj_(self, node, default_class=None):
            class_obj1 = default_class
            if 'xsi' in node.nsmap:
                classname = node.get('{%s}type' % node.nsmap['xsi'])
                if classname is not None:
                    names = classname.split(':')
                    if len(names) == 2:
                        classname = names[1]
                    class_obj2 = globals().get(classname)
                    if class_obj2 is not None:
                        class_obj1 = class_obj2
            return class_obj1
        def gds_build_any(self, node, type_name=None):
            # provide default value in case option --disable-xml is used.
            content = ""
            content = etree_.tostring(node, encoding="unicode")
            return content
        @classmethod
        def gds_reverse_node_mapping(cls, mapping):
            return dict(((v, k) for k, v in mapping.items()))
        @staticmethod
        def gds_encode(instring):
            if sys.version_info.major == 2:
                if ExternalEncoding:
                    encoding = ExternalEncoding
                else:
                    encoding = 'utf-8'
                return instring.encode(encoding)
            else:
                return instring
        @staticmethod
        def convert_unicode(instring):
            if instring is None:
                result = ""
            elif isinstance(instring, str):
                result = quote_xml(instring)
            elif sys.version_info.major == 2 and isinstance(instring, unicode):
                result = quote_xml(instring).encode('utf8')
            else:
                result = GeneratedsSuper.gds_encode(str(instring))
            return result
        def __eq__(self, other):
            def excl_select_objs_(obj):
                return (obj[0] != 'parent_object_' and
                        obj[0] != 'gds_collector_')
            if type(self) != type(other):
                return False
            return all(x == y for x, y in zip_longest(
                filter(excl_select_objs_, self.__dict__.items()),
                filter(excl_select_objs_, other.__dict__.items())))
        def __ne__(self, other):
            return not self.__eq__(other)
        # Django ETL transform hooks.
        def gds_djo_etl_transform(self):
            pass
        def gds_djo_etl_transform_db_obj(self, dbobj):
            pass
        # SQLAlchemy ETL transform hooks.
        def gds_sqa_etl_transform(self):
            return 0, None
        def gds_sqa_etl_transform_db_obj(self, dbobj):
            pass
        def gds_get_node_lineno_(self):
            if (hasattr(self, "gds_elementtree_node_") and
                    self.gds_elementtree_node_ is not None):
                return ' near line {}'.format(
                    self.gds_elementtree_node_.sourceline)
            else:
                return ""
    
    
    def getSubclassFromModule_(module, class_):
        '''Get the subclass of a class from a specific module.'''
        name = class_.__name__ + 'Sub'
        if hasattr(module, name):
            return getattr(module, name)
        else:
            return None


#
# If you have installed IPython you can uncomment and use the following.
# IPython is available from http://ipython.scipy.org/.
#

## from IPython.Shell import IPShellEmbed
## args = ''
## ipshell = IPShellEmbed(args,
##     banner = 'Dropping into IPython',
##     exit_msg = 'Leaving Interpreter, back to program.')

# Then use the following line where and when you want to drop into the
# IPython shell:
#    ipshell('<some message> -- Entering ipshell.\nHit Ctrl-D to exit')

#
# Globals
#

ExternalEncoding = ''
# Set this to false in order to deactivate during export, the use of
# name space prefixes captured from the input document.
UseCapturedNS_ = True
CapturedNsmap_ = {}
Tag_pattern_ = re_.compile(r'({.*})?(.*)')
String_cleanup_pat_ = re_.compile(r"[\n\r\s]+")
Namespace_extract_pat_ = re_.compile(r'{(.*)}(.*)')
CDATA_pattern_ = re_.compile(r"<!\[CDATA\[.*?\]\]>", re_.DOTALL)

# Change this to redirect the generated superclass module to use a
# specific subclass module.
CurrentSubclassModule_ = None

#
# Support/utility functions.
#


def showIndent(outfile, level, pretty_print=True):
    if pretty_print:
        for idx in range(level):
            outfile.write('    ')


def quote_xml(inStr):
    "Escape markup chars, but do not modify CDATA sections."
    if not inStr:
        return ''
    s1 = (isinstance(inStr, BaseStrType_) and inStr or '%s' % inStr)
    s2 = ''
    pos = 0
    matchobjects = CDATA_pattern_.finditer(s1)
    for mo in matchobjects:
        s3 = s1[pos:mo.start()]
        s2 += quote_xml_aux(s3)
        s2 += s1[mo.start():mo.end()]
        pos = mo.end()
    s3 = s1[pos:]
    s2 += quote_xml_aux(s3)
    return s2


def quote_xml_aux(inStr):
    s1 = inStr.replace('&', '&amp;')
    s1 = s1.replace('<', '&lt;')
    s1 = s1.replace('>', '&gt;')
    return s1


def quote_attrib(inStr):
    s1 = (isinstance(inStr, BaseStrType_) and inStr or '%s' % inStr)
    s1 = s1.replace('&', '&amp;')
    s1 = s1.replace('<', '&lt;')
    s1 = s1.replace('>', '&gt;')
    s1 = s1.replace('\n', '&#10;')
    if '"' in s1:
        if "'" in s1:
            s1 = '"%s"' % s1.replace('"', "&quot;")
        else:
            s1 = "'%s'" % s1
    else:
        s1 = '"%s"' % s1
    return s1


def quote_python(inStr):
    s1 = inStr
    if s1.find("'") == -1:
        if s1.find('\n') == -1:
            return "'%s'" % s1
        else:
            return "'''%s'''" % s1
    else:
        if s1.find('"') != -1:
            s1 = s1.replace('"', '\\"')
        if s1.find('\n') == -1:
            return '"%s"' % s1
        else:
            return '"""%s"""' % s1


def get_all_text_(node):
    if node.text is not None:
        text = node.text
    else:
        text = ''
    for child in node:
        if child.tail is not None:
            text += child.tail
    return text


def find_attr_value_(attr_name, node):
    attrs = node.attrib
    attr_parts = attr_name.split(':')
    value = None
    if len(attr_parts) == 1:
        value = attrs.get(attr_name)
    elif len(attr_parts) == 2:
        prefix, name = attr_parts
        if prefix == 'xml':
            namespace = 'http://www.w3.org/XML/1998/namespace'
        else:
            namespace = node.nsmap.get(prefix)
        if namespace is not None:
            value = attrs.get('{%s}%s' % (namespace, name, ))
    return value


def encode_str_2_3(instr):
    return instr


class GDSParseError(Exception):
    pass


def raise_parse_error(node, msg):
    if node is not None:
        msg = '%s (element %s/line %d)' % (msg, node.tag, node.sourceline, )
    raise GDSParseError(msg)


class MixedContainer:
    # Constants for category:
    CategoryNone = 0
    CategoryText = 1
    CategorySimple = 2
    CategoryComplex = 3
    # Constants for content_type:
    TypeNone = 0
    TypeText = 1
    TypeString = 2
    TypeInteger = 3
    TypeFloat = 4
    TypeDecimal = 5
    TypeDouble = 6
    TypeBoolean = 7
    TypeBase64 = 8
    def __init__(self, category, content_type, name, value):
        self.category = category
        self.content_type = content_type
        self.name = name
        self.value = value
    def getCategory(self):
        return self.category
    def getContenttype(self, content_type):
        return self.content_type
    def getValue(self):
        return self.value
    def getName(self):
        return self.name
    def export(self, outfile, level, name, namespace,
               pretty_print=True):
        if self.category == MixedContainer.CategoryText:
            # Prevent exporting empty content as empty lines.
            if self.value.strip():
                outfile.write(self.value)
        elif self.category == MixedContainer.CategorySimple:
            self.exportSimple(outfile, level, name)
        else:    # category == MixedContainer.CategoryComplex
            self.value.export(
                outfile, level, namespace, name_=name,
                pretty_print=pretty_print)
    def exportSimple(self, outfile, level, name):
        if self.content_type == MixedContainer.TypeString:
            outfile.write('<%s>%s</%s>' % (
                self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeInteger or \
                self.content_type == MixedContainer.TypeBoolean:
            outfile.write('<%s>%d</%s>' % (
                self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeFloat or \
                self.content_type == MixedContainer.TypeDecimal:
            outfile.write('<%s>%f</%s>' % (
                self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeDouble:
            outfile.write('<%s>%g</%s>' % (
                self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeBase64:
            outfile.write('<%s>%s</%s>' % (
                self.name,
                base64.b64encode(self.value),
                self.name))
    def to_etree(self, element, mapping_=None, reverse_mapping_=None, nsmap_=None):
        if self.category == MixedContainer.CategoryText:
            # Prevent exporting empty content as empty lines.
            if self.value.strip():
                if len(element) > 0:
                    if element[-1].tail is None:
                        element[-1].tail = self.value
                    else:
                        element[-1].tail += self.value
                else:
                    if element.text is None:
                        element.text = self.value
                    else:
                        element.text += self.value
        elif self.category == MixedContainer.CategorySimple:
            subelement = etree_.SubElement(
                element, '%s' % self.name)
            subelement.text = self.to_etree_simple()
        else:    # category == MixedContainer.CategoryComplex
            self.value.to_etree(element)
    def to_etree_simple(self, mapping_=None, reverse_mapping_=None, nsmap_=None):
        if self.content_type == MixedContainer.TypeString:
            text = self.value
        elif (self.content_type == MixedContainer.TypeInteger or
                self.content_type == MixedContainer.TypeBoolean):
            text = '%d' % self.value
        elif (self.content_type == MixedContainer.TypeFloat or
                self.content_type == MixedContainer.TypeDecimal):
            text = '%f' % self.value
        elif self.content_type == MixedContainer.TypeDouble:
            text = '%g' % self.value
        elif self.content_type == MixedContainer.TypeBase64:
            text = '%s' % base64.b64encode(self.value)
        return text
    def exportLiteral(self, outfile, level, name):
        if self.category == MixedContainer.CategoryText:
            showIndent(outfile, level)
            outfile.write(
                'model_.MixedContainer(%d, %d, "%s", "%s"),\n' % (
                    self.category, self.content_type,
                    self.name, self.value))
        elif self.category == MixedContainer.CategorySimple:
            showIndent(outfile, level)
            outfile.write(
                'model_.MixedContainer(%d, %d, "%s", "%s"),\n' % (
                    self.category, self.content_type,
                    self.name, self.value))
        else:    # category == MixedContainer.CategoryComplex
            showIndent(outfile, level)
            outfile.write(
                'model_.MixedContainer(%d, %d, "%s",\n' % (
                    self.category, self.content_type, self.name,))
            self.value.exportLiteral(outfile, level + 1)
            showIndent(outfile, level)
            outfile.write(')\n')


class MemberSpec_(object):
    def __init__(self, name='', data_type='', container=0,
            optional=0, child_attrs=None, choice=None):
        self.name = name
        self.data_type = data_type
        self.container = container
        self.child_attrs = child_attrs
        self.choice = choice
        self.optional = optional
    def set_name(self, name): self.name = name
    def get_name(self): return self.name
    def set_data_type(self, data_type): self.data_type = data_type
    def get_data_type_chain(self): return self.data_type
    def get_data_type(self):
        if isinstance(self.data_type, list):
            if len(self.data_type) > 0:
                return self.data_type[-1]
            else:
                return 'xs:string'
        else:
            return self.data_type
    def set_container(self, container): self.container = container
    def get_container(self): return self.container
    def set_child_attrs(self, child_attrs): self.child_attrs = child_attrs
    def get_child_attrs(self): return self.child_attrs
    def set_choice(self, choice): self.choice = choice
    def get_choice(self): return self.choice
    def set_optional(self, optional): self.optional = optional
    def get_optional(self): return self.optional


def _cast(typ, value):
    if typ is None or value is None:
        return value
    return typ(value)


#
# Start enum classes
#
class AccountStatusEnum(str, Enum):
    ACTIVE='active' # Active
    INACTIVE='inactive' # Inactive
    ENTEREDINERROR='entered-in-error' # Entered in error
    ONHOLD='on-hold' # On Hold
    UNKNOWN='unknown' # Unknown


class ActionCardinalityBehaviorEnum(str, Enum):
    SINGLE='single' # Single
    MULTIPLE='multiple' # Multiple


class ActionConditionKindEnum(str, Enum):
    APPLICABILITY='applicability' # Applicability
    START='start' # Start
    STOP='stop' # Stop


class ActionGroupingBehaviorEnum(str, Enum):
    VISUALGROUP='visual-group' # Visual Group
    LOGICALGROUP='logical-group' # Logical Group
    SENTENCEGROUP='sentence-group' # Sentence Group


class ActionParticipantTypeEnum(str, Enum):
    PATIENT='patient' # Patient
    PRACTITIONER='practitioner' # Practitioner
    RELATEDPERSON='related-person' # Related Person
    DEVICE='device' # Device


class ActionPrecheckBehaviorEnum(str, Enum):
    YES='yes' # Yes
    NO='no' # No


class ActionRelationshipTypeEnum(str, Enum):
    BEFORESTART='before-start' # Before Start
    BEFORE='before' # Before
    BEFOREEND='before-end' # Before End
    CONCURRENTWITHSTART='concurrent-with-start' # Concurrent With Start
    CONCURRENT='concurrent' # Concurrent
    CONCURRENTWITHEND='concurrent-with-end' # Concurrent With End
    AFTERSTART='after-start' # After Start
    AFTER='after' # After
    AFTEREND='after-end' # After End


class ActionRequiredBehaviorEnum(str, Enum):
    MUST='must' # Must
    COULD='could' # Could
    MUSTUNLESSDOCUMENTED='must-unless-documented' # Must Unless Documented


class ActionSelectionBehaviorEnum(str, Enum):
    ANY='any' # Any
    ALL='all' # All
    ALLORNONE='all-or-none' # All Or None
    EXACTLYONE='exactly-one' # Exactly One
    ATMOSTONE='at-most-one' # At Most One
    ONEORMORE='one-or-more' # One Or More


class AddressTypeEnum(str, Enum):
    POSTAL='postal' # Postal
    PHYSICAL='physical' # Physical
    BOTH='both' # Postal & Physical


class AddressUseEnum(str, Enum):
    HOME='home' # Home
    WORK='work' # Work
    TEMP='temp' # Temporary
    OLD='old' # Old / Incorrect
    BILLING='billing' # Billing


class AdministrativeGenderEnum(str, Enum):
    MALE='male' # Male
    FEMALE='female' # Female
    OTHER='other' # Other
    UNKNOWN='unknown' # Unknown


class AdverseEventActualityEnum(str, Enum):
    ACTUAL='actual' # Adverse Event
    POTENTIAL='potential' # Potential Adverse Event


class AgeUnitsEnum(str, Enum):
    MIN='min' # Minute
    H='h' # Hour
    D='d' # Day
    WK='wk' # Week
    MO='mo' # Month
    A='a' # Year


class AggregationModeEnum(str, Enum):
    CONTAINED='contained' # Contained
    REFERENCED='referenced' # Referenced
    BUNDLED='bundled' # Bundled


class AllergyIntoleranceCategoryEnum(str, Enum):
    FOOD='food' # Food
    MEDICATION='medication' # Medication
    ENVIRONMENT='environment' # Environment
    BIOLOGIC='biologic' # Biologic


class AllergyIntoleranceCriticalityEnum(str, Enum):
    LOW='low' # Low Risk
    HIGH='high' # High Risk
    UNABLETOASSESS='unable-to-assess' # Unable to Assess Risk


class AllergyIntoleranceSeverityEnum(str, Enum):
    MILD='mild' # Mild
    MODERATE='moderate' # Moderate
    SEVERE='severe' # Severe


class AllergyIntoleranceTypeEnum(str, Enum):
    ALLERGY='allergy' # Allergy
    INTOLERANCE='intolerance' # Intolerance


class AppointmentStatusEnum(str, Enum):
    PROPOSED='proposed' # Proposed
    PENDING='pending' # Pending
    BOOKED='booked' # Booked
    ARRIVED='arrived' # Arrived
    FULFILLED='fulfilled' # Fulfilled
    CANCELLED='cancelled' # Cancelled
    NOSHOW='noshow' # No Show
    ENTEREDINERROR='entered-in-error' # Entered in error
    CHECKEDIN='checked-in' # Checked In
    WAITLIST='waitlist' # Waitlisted


class AssertionDirectionTypeEnum(str, Enum):
    RESPONSE='response' # response
    REQUEST='request' # request


class AssertionOperatorTypeEnum(str, Enum):
    EQUALS='equals' # equals
    NOT_EQUALS='notEquals' # notEquals
    IN='in' # in
    NOT_IN='notIn' # notIn
    GREATER_THAN='greaterThan' # greaterThan
    LESS_THAN='lessThan' # lessThan
    EMPTY='empty' # empty
    NOT_EMPTY='notEmpty' # notEmpty
    CONTAINS='contains' # contains
    NOT_CONTAINS='notContains' # notContains
    EVAL='eval' # evaluate


class AssertionResponseTypesEnum(str, Enum):
    OKAY='okay' # okay
    CREATED='created' # created
    NO_CONTENT='noContent' # noContent
    NOT_MODIFIED='notModified' # notModified
    BAD='bad' # bad
    FORBIDDEN='forbidden' # forbidden
    NOT_FOUND='notFound' # notFound
    METHOD_NOT_ALLOWED='methodNotAllowed' # methodNotAllowed
    CONFLICT='conflict' # conflict
    GONE='gone' # gone
    PRECONDITION_FAILED='preconditionFailed' # preconditionFailed
    UNPROCESSABLE='unprocessable' # unprocessable


class AuditEventActionEnum(str, Enum):
    C='C' # Create
    R='R' # Read/View/Print
    U='U' # Update
    D='D' # Delete
    E='E' # Execute


class AuditEventAgentNetworkTypeEnum(str, Enum):
    _1='1' # Machine Name
    _2='2' # IP Address
    _3='3' # Telephone Number
    _4='4' # Email address
    _5='5' # URI


class AuditEventOutcomeEnum(str, Enum):
    _0='0' # Success
    _4='4' # Minor failure
    _8='8' # Serious failure
    _1_2='12' # Major failure


class BindingStrengthEnum(str, Enum):
    REQUIRED='required' # Required
    EXTENSIBLE='extensible' # Extensible
    PREFERRED='preferred' # Preferred
    EXAMPLE='example' # Example


class BiologicallyDerivedProductCategoryEnum(str, Enum):
    ORGAN='organ' # Organ
    TISSUE='tissue' # Tissue
    FLUID='fluid' # Fluid
    CELLS='cells' # Cells
    BIOLOGICAL_AGENT='biologicalAgent' # BiologicalAgent


class BiologicallyDerivedProductStatusEnum(str, Enum):
    AVAILABLE='available' # Available
    UNAVAILABLE='unavailable' # Unavailable


class BiologicallyDerivedProductStorageScaleEnum(str, Enum):
    FARENHEIT='farenheit' # Fahrenheit
    CELSIUS='celsius' # Celsius
    KELVIN='kelvin' # Kelvin


class BundleTypeEnum(str, Enum):
    DOCUMENT='document' # Document
    MESSAGE='message' # Message
    TRANSACTION='transaction' # Transaction
    TRANSACTIONRESPONSE='transaction-response' # Transaction Response
    BATCH='batch' # Batch
    BATCHRESPONSE='batch-response' # Batch Response
    HISTORY='history' # History List
    SEARCHSET='searchset' # Search Results
    COLLECTION='collection' # Collection


class CapabilityStatementKindEnum(str, Enum):
    INSTANCE='instance' # Instance
    CAPABILITY='capability' # Capability
    REQUIREMENTS='requirements' # Requirements


class CarePlanActivityKindEnum(str, Enum):
    APPOINTMENT='Appointment' # AppointmentAppuntamentoRendezVousCita预约
    COMMUNICATION_REQUEST='CommunicationRequest' # CommunicationRequestRichiestaDiComunicazioneDemandeDeCommunicationComunicaciónRequerimiento通讯请求
    DEVICE_REQUEST='DeviceRequest' # DeviceRequestRichiestaDispositivoDemandeUtilisationDispositifSolicitudDeDispositivo装置请求
    MEDICATION_REQUEST='MedicationRequest' # MedicationRequestPrescriptionMédicamenteuseTODO药物请求PrescripciónMedicaciónTODO /PrescripcionMedicamento
    NUTRITION_ORDER='NutritionOrder' # NutritionOrderOrdreNutritionOrdenNutrición营养医嘱
    TASK='Task' # TaskTarea任务
    SERVICE_REQUEST='ServiceRequest' # ServiceRequestRichiestaDiServizioDemandeServicePeticiónServicio服务项目请求
    VISION_PRESCRIPTION='VisionPrescription' # VisionPrescriptionPrescriptionVisionPrescripcionDeVision视力处方


class CarePlanActivityStatusEnum(str, Enum):
    NOTSTARTED='not-started' # Not Started
    SCHEDULED='scheduled' # Scheduled
    INPROGRESS='in-progress' # In Progress
    ONHOLD='on-hold' # On Hold
    COMPLETED='completed' # Completed
    CANCELLED='cancelled' # Cancelled
    STOPPED='stopped' # Stopped
    UNKNOWN='unknown' # Unknown
    ENTEREDINERROR='entered-in-error' # Entered in Error


class CarePlanIntentEnum(str, Enum):
    PROPOSAL='proposal' # Proposal
    PLAN='plan' # Plan
    ORDER='order' # Order
    OPTION='option' # Option


class CareTeamStatusEnum(str, Enum):
    PROPOSED='proposed' # Proposed
    ACTIVE='active' # Active
    SUSPENDED='suspended' # Suspended
    INACTIVE='inactive' # Inactive
    ENTEREDINERROR='entered-in-error' # Entered in Error


class CatalogEntryRelationTypeEnum(str, Enum):
    TRIGGERS='triggers' # Triggers
    ISREPLACEDBY='is-replaced-by' # Replaced By


class CharacteristicCombinationEnum(str, Enum):
    INTERSECTION='intersection' # intersection
    UNION='union' # union


class ChargeItemStatusEnum(str, Enum):
    PLANNED='planned' # Planned
    BILLABLE='billable' # Billable
    NOTBILLABLE='not-billable' # Not billable
    ABORTED='aborted' # Aborted
    BILLED='billed' # Billed
    ENTEREDINERROR='entered-in-error' # Entered in Error
    UNKNOWN='unknown' # Unknown


class ClinicalImpressionStatusEnum(str, Enum):
    INPROGRESS='in-progress' # In Progress
    COMPLETED='completed' # Completed
    ENTEREDINERROR='entered-in-error' # Entered in Error


class ClinicalUseDefinitionTypeEnum(str, Enum):
    INDICATION='indication' # Indication
    CONTRAINDICATION='contraindication' # Contraindication
    INTERACTION='interaction' # Interaction
    UNDESIRABLEEFFECT='undesirable-effect' # Undesirable Effect
    WARNING='warning' # Warning


class CodeSearchSupportEnum(str, Enum):
    EXPLICIT='explicit' # Explicit Codes
    ALL='all' # Implicit Codes


class CodeSystemContentModeEnum(str, Enum):
    NOTPRESENT='not-present' # Not Present
    EXAMPLE='example' # Example
    FRAGMENT='fragment' # Fragment
    COMPLETE='complete' # Complete
    SUPPLEMENT='supplement' # Supplement


class CodeSystemHierarchyMeaningEnum(str, Enum):
    GROUPEDBY='grouped-by' # Grouped By
    ISA='is-a' # Is-A
    PARTOF='part-of' # Part Of
    CLASSIFIEDWITH='classified-with' # Classified With


class CompartmentTypeEnum(str, Enum):
    PATIENT='Patient' # Patient
    ENCOUNTER='Encounter' # Encounter
    RELATED_PERSON='RelatedPerson' # RelatedPerson
    PRACTITIONER='Practitioner' # Practitioner
    DEVICE='Device' # Device


class CompositionAttestationModeEnum(str, Enum):
    PERSONAL='personal' # Personal
    PROFESSIONAL='professional' # Professional
    LEGAL='legal' # Legal
    OFFICIAL='official' # Official


class CompositionStatusEnum(str, Enum):
    PRELIMINARY='preliminary' # Preliminary
    FINAL='final' # Final
    AMENDED='amended' # Amended
    ENTEREDINERROR='entered-in-error' # Entered in Error


class ConceptMapEquivalenceEnum(str, Enum):
    RELATEDTO='relatedto' # Related To
    EQUIVALENT='equivalent' # Equivalent
    EQUAL='equal' # Equal
    WIDER='wider' # Wider
    SUBSUMES='subsumes' # Subsumes
    NARROWER='narrower' # Narrower
    SPECIALIZES='specializes' # Specializes
    INEXACT='inexact' # Inexact
    UNMATCHED='unmatched' # Unmatched
    DISJOINT='disjoint' # Disjoint


class ConceptMapGroupUnmappedModeEnum(str, Enum):
    PROVIDED='provided' # Provided Code
    FIXED='fixed' # Fixed Code
    OTHERMAP='other-map' # Other Map


class ConditionalDeleteStatusEnum(str, Enum):
    NOTSUPPORTED='not-supported' # Not Supported
    SINGLE='single' # Single Deletes Supported
    MULTIPLE='multiple' # Multiple Deletes Supported


class ConditionalReadStatusEnum(str, Enum):
    NOTSUPPORTED='not-supported' # Not Supported
    MODIFIEDSINCE='modified-since' # If-Modified-Since
    NOTMATCH='not-match' # If-None-Match
    FULLSUPPORT='full-support' # Full Support


class ConfidentialityEnum(str, Enum):
    L='L' # low
    M='M' # moderate
    N='N' # normal
    R='R' # restricted
    U='U' # unrestricted
    V='V' # very restricted


class ConsentDataMeaningEnum(str, Enum):
    INSTANCE='instance' # Instance
    RELATED='related' # Related
    DEPENDENTS='dependents' # Dependents
    AUTHOREDBY='authoredby' # AuthoredBy


class ConsentProvisionTypeEnum(str, Enum):
    DENY='deny' # Opt Out
    PERMIT='permit' # Opt In


class ConsentStateEnum(str, Enum):
    DRAFT='draft' # Pending
    PROPOSED='proposed' # Proposed
    ACTIVE='active' # Active
    REJECTED='rejected' # Rejected
    INACTIVE='inactive' # Inactive
    ENTEREDINERROR='entered-in-error' # Entered in Error


class ConstraintSeverityEnum(str, Enum):
    ERROR='error' # Error
    WARNING='warning' # Warning


class ContactPointSystemEnum(str, Enum):
    PHONE='phone' # Phone
    FAX='fax' # Fax
    EMAIL='email' # Email
    PAGER='pager' # Pager
    URL='url' # URL
    SMS='sms' # SMS
    OTHER='other' # Other


class ContactPointUseEnum(str, Enum):
    HOME='home' # Home
    WORK='work' # Work
    TEMP='temp' # Temp
    OLD='old' # Old
    MOBILE='mobile' # Mobile


class ContractResourcePublicationStatusCodesEnum(str, Enum):
    AMENDED='amended' # Amended
    APPENDED='appended' # Appended
    CANCELLED='cancelled' # Cancelled
    DISPUTED='disputed' # Disputed
    ENTEREDINERROR='entered-in-error' # Entered in Error
    EXECUTABLE='executable' # Executable
    EXECUTED='executed' # Executed
    NEGOTIABLE='negotiable' # Negotiable
    OFFERED='offered' # Offered
    POLICY='policy' # Policy
    REJECTED='rejected' # Rejected
    RENEWED='renewed' # Renewed
    REVOKED='revoked' # Revoked
    RESOLVED='resolved' # Resolved
    TERMINATED='terminated' # Terminated


class ContractResourceStatusCodesEnum(str, Enum):
    AMENDED='amended' # Amended
    APPENDED='appended' # Appended
    CANCELLED='cancelled' # Cancelled
    DISPUTED='disputed' # Disputed
    ENTEREDINERROR='entered-in-error' # Entered in Error
    EXECUTABLE='executable' # Executable
    EXECUTED='executed' # Executed
    NEGOTIABLE='negotiable' # Negotiable
    OFFERED='offered' # Offered
    POLICY='policy' # Policy
    REJECTED='rejected' # Rejected
    RENEWED='renewed' # Renewed
    REVOKED='revoked' # Revoked
    RESOLVED='resolved' # Resolved
    TERMINATED='terminated' # Terminated


class ContributorTypeEnum(str, Enum):
    AUTHOR='author' # Author
    EDITOR='editor' # Editor
    REVIEWER='reviewer' # Reviewer
    ENDORSER='endorser' # Endorser


class CriteriaNotExistsBehaviorEnum(str, Enum):
    TESTPASSES='test-passes' # test passes
    TESTFAILS='test-fails' # test fails


class DaysOfWeekEnum(str, Enum):
    MON='mon' # Monday
    TUE='tue' # Tuesday
    WED='wed' # Wednesday
    THU='thu' # Thursday
    FRI='fri' # Friday
    SAT='sat' # Saturday
    SUN='sun' # Sunday


class DefinitionResourceTypeEnum(str, Enum):
    ACTIVITY_DEFINITION='ActivityDefinition' # ActivityDefinition
    EVENT_DEFINITION='EventDefinition' # EventDefinition
    MEASURE='Measure' # Measure
    OPERATION_DEFINITION='OperationDefinition' # OperationDefinition
    PLAN_DEFINITION='PlanDefinition' # PlanDefinition
    QUESTIONNAIRE='Questionnaire' # Questionnaire


class DetectedIssueSeverityEnum(str, Enum):
    HIGH='high' # High
    MODERATE='moderate' # Moderate
    LOW='low' # Low


class DeviceMetricCalibrationStateEnum(str, Enum):
    NOTCALIBRATED='not-calibrated' # Not Calibrated
    CALIBRATIONREQUIRED='calibration-required' # Calibration Required
    CALIBRATED='calibrated' # Calibrated
    UNSPECIFIED='unspecified' # Unspecified


class DeviceMetricCalibrationTypeEnum(str, Enum):
    UNSPECIFIED='unspecified' # Unspecified
    OFFSET='offset' # Offset
    GAIN='gain' # Gain
    TWOPOINT='two-point' # Two Point


class DeviceMetricCategoryEnum(str, Enum):
    MEASUREMENT='measurement' # Measurement
    SETTING='setting' # Setting
    CALCULATION='calculation' # Calculation
    UNSPECIFIED='unspecified' # Unspecified


class DeviceMetricColorEnum(str, Enum):
    BLACK='black' # Color Black
    RED='red' # Color Red
    GREEN='green' # Color Green
    YELLOW='yellow' # Color Yellow
    BLUE='blue' # Color Blue
    MAGENTA='magenta' # Color Magenta
    CYAN='cyan' # Color Cyan
    WHITE='white' # Color White


class DeviceMetricOperationalStatusEnum(str, Enum):
    ON='on' # On
    OFF='off' # Off
    STANDBY='standby' # Standby
    ENTEREDINERROR='entered-in-error' # Entered In Error


class DeviceNameTypeEnum(str, Enum):
    UDILABELNAME='udi-label-name' # UDI Label name
    USERFRIENDLYNAME='user-friendly-name' # User Friendly name
    PATIENTREPORTEDNAME='patient-reported-name' # Patient Reported name
    MANUFACTURERNAME='manufacturer-name' # Manufacturer name
    MODELNAME='model-name' # Model name
    OTHER='other' # other


class DeviceUseStatementStatusEnum(str, Enum):
    ACTIVE='active' # Active
    COMPLETED='completed' # Completed
    ENTEREDINERROR='entered-in-error' # Entered in Error
    INTENDED='intended' # Intended
    STOPPED='stopped' # Stopped
    ONHOLD='on-hold' # On Hold


class DiagnosticReportStatusEnum(str, Enum):
    REGISTERED='registered' # Registered
    PARTIAL='partial' # Partial
    PRELIMINARY='preliminary' # Preliminary
    FINAL='final' # Final
    AMENDED='amended' # Amended
    CORRECTED='corrected' # Corrected
    APPENDED='appended' # Appended
    CANCELLED='cancelled' # Cancelled
    ENTEREDINERROR='entered-in-error' # Entered in Error
    UNKNOWN='unknown' # Unknown


class DiscriminatorTypeEnum(str, Enum):
    VALUE='value' # Value
    EXISTS='exists' # Exists
    PATTERN='pattern' # Pattern
    TYPE='type' # Type
    PROFILE='profile' # Profile


class DocumentModeEnum(str, Enum):
    PRODUCER='producer' # Producer
    CONSUMER='consumer' # Consumer


class DocumentReferenceStatusEnum(str, Enum):
    CURRENT='current' # Current
    SUPERSEDED='superseded' # Superseded
    ENTEREDINERROR='entered-in-error' # Entered in Error


class DocumentRelationshipTypeEnum(str, Enum):
    REPLACES='replaces' # Replaces
    TRANSFORMS='transforms' # Transforms
    SIGNS='signs' # Signs
    APPENDS='appends' # Appends


class EligibilityRequestPurposeEnum(str, Enum):
    AUTHREQUIREMENTS='auth-requirements' # Coverage auth-requirements
    BENEFITS='benefits' # Coverage benefits
    DISCOVERY='discovery' # Coverage Discovery
    VALIDATION='validation' # Coverage Validation


class EligibilityResponsePurposeEnum(str, Enum):
    AUTHREQUIREMENTS='auth-requirements' # Coverage auth-requirements
    BENEFITS='benefits' # Coverage benefits
    DISCOVERY='discovery' # Coverage Discovery
    VALIDATION='validation' # Coverage Validation


class EnableWhenBehaviorEnum(str, Enum):
    ALL='all' # All
    ANY='any' # Any


class EncounterLocationStatusEnum(str, Enum):
    PLANNED='planned' # Planned
    ACTIVE='active' # Active
    RESERVED='reserved' # Reserved
    COMPLETED='completed' # Completed


class EncounterStatusEnum(str, Enum):
    PLANNED='planned' # Planned
    ARRIVED='arrived' # Arrived
    TRIAGED='triaged' # Triaged
    INPROGRESS='in-progress' # In Progress
    ONLEAVE='onleave' # On Leave
    FINISHED='finished' # Finished
    CANCELLED='cancelled' # Cancelled
    ENTEREDINERROR='entered-in-error' # Entered in Error
    UNKNOWN='unknown' # Unknown


class EndpointStatusEnum(str, Enum):
    ACTIVE='active' # Active
    SUSPENDED='suspended' # Suspended
    ERROR='error' # Error
    OFF='off' # Off
    ENTEREDINERROR='entered-in-error' # Entered in error
    TEST='test' # Test


class EpisodeOfCareStatusEnum(str, Enum):
    PLANNED='planned' # Planned
    WAITLIST='waitlist' # Waitlist
    ACTIVE='active' # Active
    ONHOLD='onhold' # On Hold
    FINISHED='finished' # Finished
    CANCELLED='cancelled' # Cancelled
    ENTEREDINERROR='entered-in-error' # Entered in Error


class EventCapabilityModeEnum(str, Enum):
    SENDER='sender' # Sender
    RECEIVER='receiver' # Receiver


class EventOrRequestResourceTypesEnum(str, Enum):
    CHARGE_ITEM='ChargeItem' # ChargeItem
    CLAIM_RESPONSE='ClaimResponse' # ClaimResponse
    CLINICAL_IMPRESSION='ClinicalImpression' # ClinicalImpression
    COMMUNICATION='Communication' # Communication
    COMPOSITION='Composition' # Composition
    CONDITION='Condition' # Condition
    CONSENT='Consent' # Consent
    COVERAGE='Coverage' # Coverage
    DEVICE_USE_STATEMENT='DeviceUseStatement' # DeviceUseStatement
    DIAGNOSTIC_REPORT='DiagnosticReport' # DiagnosticReport
    DOCUMENT_MANIFEST='DocumentManifest' # DocumentManifest
    DOCUMENT_REFERENCE='DocumentReference' # DocumentReference
    ENCOUNTER='Encounter' # Encounter
    ENROLLMENT_RESPONSE='EnrollmentResponse' # EnrollmentResponse
    EPISODE_OF_CARE='EpisodeOfCare' # EpisodeOfCare
    EXPLANATION_OF_BENEFIT='ExplanationOfBenefit' # ExplanationOfBenefit
    FAMILY_MEMBER_HISTORY='FamilyMemberHistory' # FamilyMemberHistory
    GUIDANCE_RESPONSE='GuidanceResponse' # GuidanceResponse
    IMAGING_STUDY='ImagingStudy' # ImagingStudy
    IMMUNIZATION='Immunization' # Immunization
    MEASURE_REPORT='MeasureReport' # MeasureReport
    MEDIA='Media' # Media
    MEDICATION_ADMINISTRATION='MedicationAdministration' # MedicationAdministration
    MEDICATION_DISPENSE='MedicationDispense' # MedicationDispense
    MEDICATION_STATEMENT='MedicationStatement' # MedicationStatement
    OBSERVATION='Observation' # Observation
    PAYMENT_NOTICE='PaymentNotice' # PaymentNotice
    PAYMENT_RECONCILIATION='PaymentReconciliation' # PaymentReconciliation
    PROCEDURE='Procedure' # Procedure
    PROCESS_RESPONSE='ProcessResponse' # ProcessResponse
    QUESTIONNAIRE_RESPONSE='QuestionnaireResponse' # QuestionnaireResponse
    RISK_ASSESSMENT='RiskAssessment' # RiskAssessment
    SUPPLY_DELIVERY='SupplyDelivery' # SupplyDelivery
    TASK='Task' # TaskTask
    APPOINTMENT='Appointment' # Appointment
    APPOINTMENT_RESPONSE='AppointmentResponse' # AppointmentResponse
    CARE_PLAN='CarePlan' # CarePlan
    CLAIM='Claim' # Claim
    COMMUNICATION_REQUEST='CommunicationRequest' # CommunicationRequest
    CONTRACT='Contract' # Contract
    DEVICE_REQUEST='DeviceRequest' # DeviceRequest
    ENROLLMENT_REQUEST='EnrollmentRequest' # EnrollmentRequest
    IMMUNIZATION_RECOMMENDATION='ImmunizationRecommendation' # ImmunizationRecommendation
    MEDICATION_REQUEST='MedicationRequest' # MedicationRequest
    NUTRITION_ORDER='NutritionOrder' # NutritionOrder
    SERVICE_REQUEST='ServiceRequest' # ServiceRequest
    SUPPLY_REQUEST='SupplyRequest' # SupplyRequest
    TASK_1='Task' # TaskTask
    VISION_PRESCRIPTION='VisionPrescription' # VisionPrescription


class EventResourceTypeEnum(str, Enum):
    CHARGE_ITEM='ChargeItem' # ChargeItem
    CLAIM_RESPONSE='ClaimResponse' # ClaimResponse
    CLINICAL_IMPRESSION='ClinicalImpression' # ClinicalImpression
    COMMUNICATION='Communication' # Communication
    COMPOSITION='Composition' # Composition
    CONDITION='Condition' # Condition
    CONSENT='Consent' # Consent
    COVERAGE='Coverage' # Coverage
    DEVICE_USE_STATEMENT='DeviceUseStatement' # DeviceUseStatement
    DIAGNOSTIC_REPORT='DiagnosticReport' # DiagnosticReport
    DOCUMENT_MANIFEST='DocumentManifest' # DocumentManifest
    DOCUMENT_REFERENCE='DocumentReference' # DocumentReference
    ENCOUNTER='Encounter' # Encounter
    ENROLLMENT_RESPONSE='EnrollmentResponse' # EnrollmentResponse
    EPISODE_OF_CARE='EpisodeOfCare' # EpisodeOfCare
    EXPLANATION_OF_BENEFIT='ExplanationOfBenefit' # ExplanationOfBenefit
    FAMILY_MEMBER_HISTORY='FamilyMemberHistory' # FamilyMemberHistory
    GUIDANCE_RESPONSE='GuidanceResponse' # GuidanceResponse
    IMAGING_STUDY='ImagingStudy' # ImagingStudy
    IMMUNIZATION='Immunization' # Immunization
    MEASURE_REPORT='MeasureReport' # MeasureReport
    MEDIA='Media' # Media
    MEDICATION_ADMINISTRATION='MedicationAdministration' # MedicationAdministration
    MEDICATION_DISPENSE='MedicationDispense' # MedicationDispense
    MEDICATION_STATEMENT='MedicationStatement' # MedicationStatement
    OBSERVATION='Observation' # Observation
    PAYMENT_NOTICE='PaymentNotice' # PaymentNotice
    PAYMENT_RECONCILIATION='PaymentReconciliation' # PaymentReconciliation
    PROCEDURE='Procedure' # Procedure
    PROCESS_RESPONSE='ProcessResponse' # ProcessResponse
    QUESTIONNAIRE_RESPONSE='QuestionnaireResponse' # QuestionnaireResponse
    RISK_ASSESSMENT='RiskAssessment' # RiskAssessment
    SUPPLY_DELIVERY='SupplyDelivery' # SupplyDelivery
    TASK='Task' # Task


class EventStatusEnum(str, Enum):
    PREPARATION='preparation' # Preparation
    INPROGRESS='in-progress' # In Progress
    NOTDONE='not-done' # Not Done
    ONHOLD='on-hold' # On Hold
    STOPPED='stopped' # Stopped
    COMPLETED='completed' # Completed
    ENTEREDINERROR='entered-in-error' # Entered in Error
    UNKNOWN='unknown' # Unknown


class EventTimingEnum(str, Enum):
    MORN='MORN' # Morning
    MORNEARLY='MORN.early' # Early Morning
    MORNLATE='MORN.late' # Late Morning
    NOON='NOON' # Noon
    AFT='AFT' # Afternoon
    AFTEARLY='AFT.early' # Early Afternoon
    AFTLATE='AFT.late' # Late Afternoon
    EVE='EVE' # Evening
    EVEEARLY='EVE.early' # Early Evening
    EVELATE='EVE.late' # Late Evening
    NIGHT='NIGHT' # Night
    PHS='PHS' # After Sleep
    HS='HS' # HS
    WAKE='WAKE' # WAKE
    C='C' # C
    CM='CM' # CM
    CD='CD' # CD
    CV='CV' # CV
    AC='AC' # AC
    ACM='ACM' # ACM
    ACD='ACD' # ACD
    ACV='ACV' # ACV
    PC='PC' # PC
    PCM='PCM' # PCM
    PCD='PCD' # PCD
    PCV='PCV' # PCV


class EvidenceVariableHandlingEnum(str, Enum):
    CONTINUOUS='continuous' # continuous variable
    DICHOTOMOUS='dichotomous' # dichotomous variable
    ORDINAL='ordinal' # ordinal variable
    POLYCHOTOMOUS='polychotomous' # polychotomous variable


class ExampleScenarioActorTypeEnum(str, Enum):
    PERSON='person' # Person
    ENTITY='entity' # System


class ExplanationOfBenefitStatusEnum(str, Enum):
    ACTIVE='active' # Active
    CANCELLED='cancelled' # Cancelled
    DRAFT='draft' # Draft
    ENTEREDINERROR='entered-in-error' # Entered In Error


class ExpressionLanguageEnum(str, Enum):
    TEXTCQL='text/cql' # CQL
    TEXTFHIRPATH='text/fhirpath' # FHIRPath
    APPLICATIONXFHIRQUERY='application/x-fhir-query' # FHIR Query
    TEXTCQLIDENTIFIER='text/cql-identifier' # CQL Identifier
    TEXTCQLEXPRESSION='text/cql-expression' # CQL Expression


class ExtensionContextTypeEnum(str, Enum):
    FHIRPATH='fhirpath' # FHIRPath
    ELEMENT='element' # Element ID
    EXTENSION='extension' # Extension URL


class FHIRAllTypesEnum(str, Enum):
    ADDRESS='Address' # Address
    AGE='Age' # Age
    ANNOTATION='Annotation' # Annotation
    ATTACHMENT='Attachment' # Attachment
    BACKBONE_ELEMENT='BackboneElement' # BackboneElement
    CODEABLE_CONCEPT='CodeableConcept' # CodeableConcept
    CODEABLE_REFERENCE='CodeableReference' # CodeableReference
    CODING='Coding' # Coding
    CONTACT_DETAIL='ContactDetail' # ContactDetail
    CONTACT_POINT='ContactPoint' # ContactPoint
    CONTRIBUTOR='Contributor' # Contributor
    COUNT='Count' # Count
    DATA_REQUIREMENT='DataRequirement' # DataRequirement
    DISTANCE='Distance' # Distance
    DOSAGE='Dosage' # Dosage
    DURATION='Duration' # Duration
    ELEMENT='Element' # Element
    ELEMENT_DEFINITION='ElementDefinition' # ElementDefinition
    EXPRESSION='Expression' # Expression
    EXTENSION='Extension' # Extension
    HUMAN_NAME='HumanName' # HumanName
    IDENTIFIER='Identifier' # Identifier
    MARKETING_STATUS='MarketingStatus' # MarketingStatus
    META='Meta' # Meta
    MONEY='Money' # Money
    MONEY_QUANTITY='MoneyQuantity' # MoneyQuantity
    NARRATIVE='Narrative' # Narrative
    PARAMETER_DEFINITION='ParameterDefinition' # ParameterDefinition
    PERIOD='Period' # Period
    POPULATION='Population' # Population
    PROD_CHARACTERISTIC='ProdCharacteristic' # ProdCharacteristic
    PRODUCT_SHELF_LIFE='ProductShelfLife' # ProductShelfLife
    QUANTITY='Quantity' # Quantity
    RANGE='Range' # Range
    RATIO='Ratio' # Ratio
    RATIO_RANGE='RatioRange' # RatioRange
    REFERENCE='Reference' # Reference
    RELATED_ARTIFACT='RelatedArtifact' # RelatedArtifact
    SAMPLED_DATA='SampledData' # SampledData
    SIGNATURE='Signature' # Signature
    SIMPLE_QUANTITY='SimpleQuantity' # SimpleQuantity
    TIMING='Timing' # Timing
    TRIGGER_DEFINITION='TriggerDefinition' # TriggerDefinition
    USAGE_CONTEXT='UsageContext' # UsageContext
    BASE_64_BINARY='base64Binary' # base64Binary
    BOOLEAN='boolean' # boolean
    CANONICAL='canonical' # canonical
    CODE='code' # code
    DATE='date' # date
    DATE_TIME='dateTime' # dateTime
    DECIMAL='decimal' # decimal
    ID='id' # id
    INSTANT='instant' # instant
    INTEGER='integer' # integer
    MARKDOWN='markdown' # markdown
    OID='oid' # oid
    POSITIVE_INT='positiveInt' # positiveInt
    STRING='string' # string
    TIME='time' # time
    UNSIGNED_INT='unsignedInt' # unsignedInt
    URI='uri' # uri
    URL='url' # url
    UUID='uuid' # uuid
    XHTML='xhtml' # XHTML
    RESOURCE='Resource' # ResourceRecurso资源
    BINARY='Binary' # BinaryBinarioBinaireBinario二进制资源
    BUNDLE='Bundle' # BundlePaquetPaquete捆束
    DOMAIN_RESOURCE='DomainResource' # DomainResourceRecursoDeDominio领域资源
    ACCOUNT='Account' # AccountCuenta账户
    ACTIVITY_DEFINITION='ActivityDefinition' # ActivityDefinitionDefinizioneAttivitaDefinicionDeActividad活动定义
    ADMINISTRABLE_PRODUCT_DEFINITION='AdministrableProductDefinition' # AdministrableProductDefinition
    ADVERSE_EVENT='AdverseEvent' # AdverseEventEventoAvversoEventoAdverso不良事件
    ALLERGY_INTOLERANCE='AllergyIntolerance' # AllergyIntoleranceAllergiaIntolleranzaIntoléranceAllergiqueAllergiaIntolerancia变态反应与不耐性
    APPOINTMENT='Appointment' # AppointmentAppuntamentoRendezVousCita预约
    APPOINTMENT_RESPONSE='AppointmentResponse' # AppointmentResponseRispostaAppuntamentoRéponseRendezVousCitaRespuesta预约响应
    AUDIT_EVENT='AuditEvent' # AuditEventÉvènementSécuritéEventoSeguridad审计事件
    BASIC='Basic' # BasicBasiqueBasico初级资源
    BIOLOGICALLY_DERIVED_PRODUCT='BiologicallyDerivedProduct' # BiologicallyDerivedProduct
    BODY_STRUCTURE='BodyStructure' # BodyStructureStrutturaDelCorpoMorphologieDeCorpsEstructuraDelCuerpo身体结构
    CAPABILITY_STATEMENT='CapabilityStatement' # CapabilityStatementDeclaracionDeCapacidad能力声明
    CARE_PLAN='CarePlan' # CarePlanPianoDiCuraPlanDeSoinsPlanDeCuidado照护计划
    CARE_TEAM='CareTeam' # CareTeamEquipoDeCuidado照护团队
    CATALOG_ENTRY='CatalogEntry' # CatalogEntryEntradaDeCatalogo条目定义
    CHARGE_ITEM='ChargeItem' # ChargeItemCargoDeItem收费项目
    CHARGE_ITEM_DEFINITION='ChargeItemDefinition' # ChargeItemDefinition
    CITATION='Citation' # Citation
    CLAIM='Claim' # ClaimRéclamationReclamación / Factura赔单
    CLAIM_RESPONSE='ClaimResponse' # ClaimResponseRéponseARéclamation赔单请求
    CLINICAL_IMPRESSION='ClinicalImpression' # ClinicalImpressionImpressioneClinicaImpressionCliniqueHallazgoClinico临床印象
    CLINICAL_USE_DEFINITION='ClinicalUseDefinition' # ClinicalUseDefinition
    CODE_SYSTEM='CodeSystem' # CodeSystemSistemaDiCodificaSistemaDeCodigos代码系统
    COMMUNICATION='Communication' # CommunicationComunicazioneCommunicationComunicación通讯
    COMMUNICATION_REQUEST='CommunicationRequest' # CommunicationRequestRichiestaDiComunicazioneDemandeDeCommunicationComunicaciónRequerimiento通讯请求
    COMPARTMENT_DEFINITION='CompartmentDefinition' # CompartmentDefinitionDefinicionDeCompartimento逻辑区块定义
    COMPOSITION='Composition' # CompositionComposizioneCompositionComposición组合式文书
    CONCEPT_MAP='ConceptMap' # ConceptMapMappaDiConcettiCarteDeConceptsMapaDeConceptos概念映射
    CONDITION='Condition' # ConditionCondizioneConditionCondición情况
    CONSENT='Consent' # ConsentConsensoConsentimiento同意书
    CONTRACT='Contract' # ContractContrattoContratContato合同
    COVERAGE='Coverage' # CoverageCoperturaCouvertureCobertura保险责任
    COVERAGE_ELIGIBILITY_REQUEST='CoverageEligibilityRequest' # CoverageEligibilityRequestRichiestaEleggibilitaCoperturaCouvertureDemandeEligibilité资格请求
    COVERAGE_ELIGIBILITY_RESPONSE='CoverageEligibilityResponse' # CoverageEligibilityResponseRispostaEleggibilitaCoperturaRéponseEligibilitéCouverture资格响应
    DETECTED_ISSUE='DetectedIssue' # DetectedIssueProblemaRilevatoProblème DétectéProblema-Detectado /ProblemaDetectado已发现问题
    DEVICE='Device' # DeviceDispositivoDispositifDispositivo装置
    DEVICE_DEFINITION='DeviceDefinition' # DeviceDefinitionDéfinitionDeDispositifDefiniciónDeDispositivo装置组件
    DEVICE_METRIC='DeviceMetric' # DeviceMetricMétriqueDispositifMetricaDeDispositivo装置指标
    DEVICE_REQUEST='DeviceRequest' # DeviceRequestRichiestaDispositivoDemandeUtilisationDispositifSolicitudDeDispositivo装置请求
    DEVICE_USE_STATEMENT='DeviceUseStatement' # DeviceUseStatement装置使用声明
    DIAGNOSTIC_REPORT='DiagnosticReport' # DiagnosticReportRefertoDiagnosticoRapportDiagnostique诊断报告InformeDiagnostico
    DOCUMENT_MANIFEST='DocumentManifest' # DocumentManifestManifeste文档清单ManifestoDocumento
    DOCUMENT_REFERENCE='DocumentReference' # DocumentReferenceRiferimentoDocumentoRéférenceDocumentReferenciaDocumento文档引用
    ENCOUNTER='Encounter' # EncounterVenue就医过程Encuentro
    ENDPOINT='Endpoint' # EndpointEndpoint端点
    ENROLLMENT_REQUEST='EnrollmentRequest' # EnrollmentRequestRichiestaIscrizioneDemandeInscriptionSolicitudDeEnrolamiento保险注册请求
    ENROLLMENT_RESPONSE='EnrollmentResponse' # EnrollmentResponseRispostaIscrizioneRéponseInscriptionRespuestaDeEnrolamiento保险注册响应
    EPISODE_OF_CARE='EpisodeOfCare' # EpisodeOfCareEpisodioDiCuraÉpisodeDeSoinsEpisodioDeCuidado照护服务节段
    EVENT_DEFINITION='EventDefinition' # EventDefinitionDefinizioneEventoDefinitionDeEvento事件定义
    EVIDENCE='Evidence' # Evidence
    EVIDENCE_REPORT='EvidenceReport' # EvidenceReport
    EVIDENCE_VARIABLE='EvidenceVariable' # EvidenceVariable
    EXAMPLE_SCENARIO='ExampleScenario' # ExampleScenarioScenarioDiEsempioEjemploDeEscenario示例场景
    EXPLANATION_OF_BENEFIT='ExplanationOfBenefit' # ExplanationOfBenefitExplicationDuBénéfice赔付说明
    FAMILY_MEMBER_HISTORY='FamilyMemberHistory' # FamilyMemberHistoryHistoireMembreFamilleHistorialMiembroFamiliar家族史
    FLAG='Flag' # FlagDrapeauBandera标记
    GOAL='Goal' # GoalButObjetivo目标
    GRAPH_DEFINITION='GraphDefinition' # GraphDefinitionDefinitionGrafico图形定义
    GROUP='Group' # GroupGruppoGroupeGrupo群组
    GUIDANCE_RESPONSE='GuidanceResponse' # GuidanceResponseRespuestaDeOrientacion指导意见响应
    HEALTHCARE_SERVICE='HealthcareService' # HealthcareServiceServizioSanitarioServiceDeSantéServicioDeCuidado医疗保健服务项目
    IMAGING_STUDY='ImagingStudy' # ImagingStudyEtudeImagerieEstudioImagen / EstudioImagen成像检查
    IMMUNIZATION='Immunization' # ImmunizationImmunizzazioneImmunisation免疫接种Inmunización
    IMMUNIZATION_EVALUATION='ImmunizationEvaluation' # ImmunizationEvaluation
    IMMUNIZATION_RECOMMENDATION='ImmunizationRecommendation' # ImmunizationRecommendationRecommendationImmunisation免疫接种建议RecomendaciónInmunización /
    IMPLEMENTATION_GUIDE='ImplementationGuide' # ImplementationGuideGuiaDeImplementacion实施指南
    INGREDIENT='Ingredient' # Ingredient
    INSURANCE_PLAN='InsurancePlan' # InsurancePlan
    INVOICE='Invoice' # Invoice
    LIBRARY='Library' # LibraryLibrería库
    LINKAGE='Linkage' # LinkageEnlace / Conexión / Vinculo / Acoplamiento 链接关系
    LIST='List' # ListListaListe列表Lista
    LOCATION='Location' # LocationLocalisation位置Locacion
    MANUFACTURED_ITEM_DEFINITION='ManufacturedItemDefinition' # ManufacturedItemDefinition
    MEASURE='Measure' # MeasureMisuraMedida指标
    MEASURE_REPORT='MeasureReport' # MeasureReportReporteMedida指标报告
    MEDIA='Media' # MediaMediaMédiaMedio媒体
    MEDICATION='Medication' # MedicationMédication药物Medicación /Medicamento
    MEDICATION_ADMINISTRATION='MedicationAdministration' # MedicationAdministrationAdministrationMédicaments药物施用AdministraciónMedicación / AdministracionMedicamento
    MEDICATION_DISPENSE='MedicationDispense' # MedicationDispenseDispensationMédicaments药物配发DispensaciónMedicación /DispensacionMedicamento
    MEDICATION_KNOWLEDGE='MedicationKnowledge' # MedicationKnowledge
    MEDICATION_REQUEST='MedicationRequest' # MedicationRequestPrescriptionMédicamenteuseTODO药物请求PrescripciónMedicaciónTODO /PrescripcionMedicamento
    MEDICATION_STATEMENT='MedicationStatement' # MedicationStatementÉtatMédication药物声明ResumenMedicación /ResumenMedicamento
    MEDICINAL_PRODUCT_DEFINITION='MedicinalProductDefinition' # MedicinalProductDefinition
    MESSAGE_DEFINITION='MessageDefinition' # MessageDefinitionDefinizioneMessaggioDefinicionMensaje消息定义
    MESSAGE_HEADER='MessageHeader' # MessageHeaderEntêteMessage消息标头CabeceraMensaje
    MOLECULAR_SEQUENCE='MolecularSequence' # MolecularSequenceSecuenciaMolecular分子序列
    NAMING_SYSTEM='NamingSystem' # NamingSystemSystèmeDeNommageSistemaDeNombres命名系统
    NUTRITION_ORDER='NutritionOrder' # NutritionOrderOrdreNutritionOrdenNutrición营养医嘱
    NUTRITION_PRODUCT='NutritionProduct' # NutritionProductProduitNutritionnelProductoNutricional
    OBSERVATION='Observation' # ObservationOsservazioneObservation观察Observación
    OBSERVATION_DEFINITION='ObservationDefinition' # ObservationDefinitionDefinizioneOsservazioneDefinicionDeEspecimen观察定义
    OPERATION_DEFINITION='OperationDefinition' # OperationDefinitionDefinizioneOperazioneDéfinitionOpérationDefinicionDeOperacion操作定义
    OPERATION_OUTCOME='OperationOutcome' # OperationOutcomeRisultatoOperazioneRésultatOpération操作结局ResultadoOperación
    ORGANIZATION='Organization' # OrganizationOrganizzazioneOrganisation组织机构Organización
    ORGANIZATION_AFFILIATION='OrganizationAffiliation' # OrganizationAffiliation
    PACKAGED_PRODUCT_DEFINITION='PackagedProductDefinition' # PackagedProductDefinition
    PATIENT='Patient' # PatientPazientePatient患者Paciente
    PAYMENT_NOTICE='PaymentNotice' # PaymentNoticeAvvisoDiPagamentoAvisPaiementAvisoDePago付款通知
    PAYMENT_RECONCILIATION='PaymentReconciliation' # PaymentReconciliationRiconciliazionePagamentoRéconciliationPaiementConciliacionDePago付款对账
    PERSON='Person' # PersonPersonaPersonnePersona人员
    PLAN_DEFINITION='PlanDefinition' # PlanDefinitionDefinicionDePlan计划定义
    PRACTITIONER='Practitioner' # PractitionerPraticien执业人员Practicante / Profesional
    PRACTITIONER_ROLE='PractitionerRole' # PractitionerRoleRolProfesional执业人员角色
    PROCEDURE='Procedure' # ProcedureProceduraProcédure操作项目Procedimiento
    PROVENANCE='Provenance' # ProvenanceProvenienzaProvenance出处Procedencia
    QUESTIONNAIRE='Questionnaire' # QuestionnaireQuestionarioQuestionnaire调查问卷Cuestionario
    QUESTIONNAIRE_RESPONSE='QuestionnaireResponse' # QuestionnaireResponseRispostaQuestionarioRéponseQuestionnaireRespuestaAlCuestionario调查问卷答复
    REGULATED_AUTHORIZATION='RegulatedAuthorization' # RegulatedAuthorization
    RELATED_PERSON='RelatedPerson' # RelatedPersonPersonaCorrelataPersonneEnRelationPersonaRelacionada相关人员
    REQUEST_GROUP='RequestGroup' # RequestGroupGruppoDiRichiesteGrupoDeSolicitudes请求分组
    RESEARCH_DEFINITION='ResearchDefinition' # ResearchDefinition
    RESEARCH_ELEMENT_DEFINITION='ResearchElementDefinition' # ResearchElementDefinition
    RESEARCH_STUDY='ResearchStudy' # ResearchStudyEstudioDeInvestigacion调查研究
    RESEARCH_SUBJECT='ResearchSubject' # ResearchSubjectSujetoDeInvestigacion研究主题
    RISK_ASSESSMENT='RiskAssessment' # RiskAssessmentÉvaluationRisquesEvaluacionDeRiesgo风险评估
    SCHEDULE='Schedule' # ScheduleAgenda日程安排
    SEARCH_PARAMETER='SearchParameter' # SearchParameterParametroDiRicercaParamètreRechercheParametroDeBusqueda搜索参数
    SERVICE_REQUEST='ServiceRequest' # ServiceRequestRichiestaDiServizioDemandeServicePeticiónServicio服务项目请求
    SLOT='Slot' # SlotSlot槽位Hueco / Zocalo / Espacio
    SPECIMEN='Specimen' # SpecimenCampioneSpécimen标本Especimen
    SPECIMEN_DEFINITION='SpecimenDefinition' # SpecimenDefinitionDefinizioneCampioneDefinicionDeEspecimen标本定义
    STRUCTURE_DEFINITION='StructureDefinition' # StructureDefinitionDefinizioneStrutturaDéfinitionStructureDefinicionDeEstructura结构定义
    STRUCTURE_MAP='StructureMap' # StructureMapMapaDeEstructura结构映射
    SUBSCRIPTION='Subscription' # SubscriptionSottoscrizioneSouscription订阅Suscripción
    SUBSCRIPTION_STATUS='SubscriptionStatus' # SubscriptionStatus
    SUBSCRIPTION_TOPIC='SubscriptionTopic' # SubscriptionTopic
    SUBSTANCE='Substance' # SubstanceSostanzaSubstance物质Sustancia
    SUBSTANCE_DEFINITION='SubstanceDefinition' # SubstanceDefinition
    SUPPLY_DELIVERY='SupplyDelivery' # SupplyDeliverySupply Livraison供应交付Entrega de Suministro
    SUPPLY_REQUEST='SupplyRequest' # SupplyRequestDemande d'approvisionnement供应请求Solicitud de Suministro
    TASK='Task' # TaskTarea任务
    TERMINOLOGY_CAPABILITIES='TerminologyCapabilities' # TerminologyCapabilitiesCapacidadTerminologica术语服务能力
    TEST_REPORT='TestReport' # TestReportRapportTestReporteDePrueba测试报告
    TEST_SCRIPT='TestScript' # TestScriptScriptTestScriptDePrueba测试脚本
    VALUE_SET='ValueSet' # ValueSetEnsembleValeurs取值集合ConjuntoValores / ConjuntoDeValores
    VERIFICATION_RESULT='VerificationResult' # VerificationResult
    VISION_PRESCRIPTION='VisionPrescription' # VisionPrescriptionPrescriptionVisionPrescripcionDeVision视力处方
    PARAMETERS='Parameters' # ParametersParametros参数
    TYPE='Type' # Type
    ANY='Any' # Any


class FHIRDefinedTypeEnum(str, Enum):
    ADDRESS='Address' # Address
    AGE='Age' # Age
    ANNOTATION='Annotation' # Annotation
    ATTACHMENT='Attachment' # Attachment
    BACKBONE_ELEMENT='BackboneElement' # BackboneElement
    CODEABLE_CONCEPT='CodeableConcept' # CodeableConcept
    CODEABLE_REFERENCE='CodeableReference' # CodeableReference
    CODING='Coding' # Coding
    CONTACT_DETAIL='ContactDetail' # ContactDetail
    CONTACT_POINT='ContactPoint' # ContactPoint
    CONTRIBUTOR='Contributor' # Contributor
    COUNT='Count' # Count
    DATA_REQUIREMENT='DataRequirement' # DataRequirement
    DISTANCE='Distance' # Distance
    DOSAGE='Dosage' # Dosage
    DURATION='Duration' # Duration
    ELEMENT='Element' # Element
    ELEMENT_DEFINITION='ElementDefinition' # ElementDefinition
    EXPRESSION='Expression' # Expression
    EXTENSION='Extension' # Extension
    HUMAN_NAME='HumanName' # HumanName
    IDENTIFIER='Identifier' # Identifier
    MARKETING_STATUS='MarketingStatus' # MarketingStatus
    META='Meta' # Meta
    MONEY='Money' # Money
    MONEY_QUANTITY='MoneyQuantity' # MoneyQuantity
    NARRATIVE='Narrative' # Narrative
    PARAMETER_DEFINITION='ParameterDefinition' # ParameterDefinition
    PERIOD='Period' # Period
    POPULATION='Population' # Population
    PROD_CHARACTERISTIC='ProdCharacteristic' # ProdCharacteristic
    PRODUCT_SHELF_LIFE='ProductShelfLife' # ProductShelfLife
    QUANTITY='Quantity' # Quantity
    RANGE='Range' # Range
    RATIO='Ratio' # Ratio
    RATIO_RANGE='RatioRange' # RatioRange
    REFERENCE='Reference' # Reference
    RELATED_ARTIFACT='RelatedArtifact' # RelatedArtifact
    SAMPLED_DATA='SampledData' # SampledData
    SIGNATURE='Signature' # Signature
    SIMPLE_QUANTITY='SimpleQuantity' # SimpleQuantity
    TIMING='Timing' # Timing
    TRIGGER_DEFINITION='TriggerDefinition' # TriggerDefinition
    USAGE_CONTEXT='UsageContext' # UsageContext
    BASE_64_BINARY='base64Binary' # base64Binary
    BOOLEAN='boolean' # boolean
    CANONICAL='canonical' # canonical
    CODE='code' # code
    DATE='date' # date
    DATE_TIME='dateTime' # dateTime
    DECIMAL='decimal' # decimal
    ID='id' # id
    INSTANT='instant' # instant
    INTEGER='integer' # integer
    MARKDOWN='markdown' # markdown
    OID='oid' # oid
    POSITIVE_INT='positiveInt' # positiveInt
    STRING='string' # string
    TIME='time' # time
    UNSIGNED_INT='unsignedInt' # unsignedInt
    URI='uri' # uri
    URL='url' # url
    UUID='uuid' # uuid
    XHTML='xhtml' # XHTML
    RESOURCE='Resource' # ResourceRecurso资源
    BINARY='Binary' # BinaryBinarioBinaireBinario二进制资源
    BUNDLE='Bundle' # BundlePaquetPaquete捆束
    DOMAIN_RESOURCE='DomainResource' # DomainResourceRecursoDeDominio领域资源
    ACCOUNT='Account' # AccountCuenta账户
    ACTIVITY_DEFINITION='ActivityDefinition' # ActivityDefinitionDefinizioneAttivitaDefinicionDeActividad活动定义
    ADMINISTRABLE_PRODUCT_DEFINITION='AdministrableProductDefinition' # AdministrableProductDefinition
    ADVERSE_EVENT='AdverseEvent' # AdverseEventEventoAvversoEventoAdverso不良事件
    ALLERGY_INTOLERANCE='AllergyIntolerance' # AllergyIntoleranceAllergiaIntolleranzaIntoléranceAllergiqueAllergiaIntolerancia变态反应与不耐性
    APPOINTMENT='Appointment' # AppointmentAppuntamentoRendezVousCita预约
    APPOINTMENT_RESPONSE='AppointmentResponse' # AppointmentResponseRispostaAppuntamentoRéponseRendezVousCitaRespuesta预约响应
    AUDIT_EVENT='AuditEvent' # AuditEventÉvènementSécuritéEventoSeguridad审计事件
    BASIC='Basic' # BasicBasiqueBasico初级资源
    BIOLOGICALLY_DERIVED_PRODUCT='BiologicallyDerivedProduct' # BiologicallyDerivedProduct
    BODY_STRUCTURE='BodyStructure' # BodyStructureStrutturaDelCorpoMorphologieDeCorpsEstructuraDelCuerpo身体结构
    CAPABILITY_STATEMENT='CapabilityStatement' # CapabilityStatementDeclaracionDeCapacidad能力声明
    CARE_PLAN='CarePlan' # CarePlanPianoDiCuraPlanDeSoinsPlanDeCuidado照护计划
    CARE_TEAM='CareTeam' # CareTeamEquipoDeCuidado照护团队
    CATALOG_ENTRY='CatalogEntry' # CatalogEntryEntradaDeCatalogo条目定义
    CHARGE_ITEM='ChargeItem' # ChargeItemCargoDeItem收费项目
    CHARGE_ITEM_DEFINITION='ChargeItemDefinition' # ChargeItemDefinition
    CITATION='Citation' # Citation
    CLAIM='Claim' # ClaimRéclamationReclamación / Factura赔单
    CLAIM_RESPONSE='ClaimResponse' # ClaimResponseRéponseARéclamation赔单请求
    CLINICAL_IMPRESSION='ClinicalImpression' # ClinicalImpressionImpressioneClinicaImpressionCliniqueHallazgoClinico临床印象
    CLINICAL_USE_DEFINITION='ClinicalUseDefinition' # ClinicalUseDefinition
    CODE_SYSTEM='CodeSystem' # CodeSystemSistemaDiCodificaSistemaDeCodigos代码系统
    COMMUNICATION='Communication' # CommunicationComunicazioneCommunicationComunicación通讯
    COMMUNICATION_REQUEST='CommunicationRequest' # CommunicationRequestRichiestaDiComunicazioneDemandeDeCommunicationComunicaciónRequerimiento通讯请求
    COMPARTMENT_DEFINITION='CompartmentDefinition' # CompartmentDefinitionDefinicionDeCompartimento逻辑区块定义
    COMPOSITION='Composition' # CompositionComposizioneCompositionComposición组合式文书
    CONCEPT_MAP='ConceptMap' # ConceptMapMappaDiConcettiCarteDeConceptsMapaDeConceptos概念映射
    CONDITION='Condition' # ConditionCondizioneConditionCondición情况
    CONSENT='Consent' # ConsentConsensoConsentimiento同意书
    CONTRACT='Contract' # ContractContrattoContratContato合同
    COVERAGE='Coverage' # CoverageCoperturaCouvertureCobertura保险责任
    COVERAGE_ELIGIBILITY_REQUEST='CoverageEligibilityRequest' # CoverageEligibilityRequestRichiestaEleggibilitaCoperturaCouvertureDemandeEligibilité资格请求
    COVERAGE_ELIGIBILITY_RESPONSE='CoverageEligibilityResponse' # CoverageEligibilityResponseRispostaEleggibilitaCoperturaRéponseEligibilitéCouverture资格响应
    DETECTED_ISSUE='DetectedIssue' # DetectedIssueProblemaRilevatoProblème DétectéProblema-Detectado /ProblemaDetectado已发现问题
    DEVICE='Device' # DeviceDispositivoDispositifDispositivo装置
    DEVICE_DEFINITION='DeviceDefinition' # DeviceDefinitionDéfinitionDeDispositifDefiniciónDeDispositivo装置组件
    DEVICE_METRIC='DeviceMetric' # DeviceMetricMétriqueDispositifMetricaDeDispositivo装置指标
    DEVICE_REQUEST='DeviceRequest' # DeviceRequestRichiestaDispositivoDemandeUtilisationDispositifSolicitudDeDispositivo装置请求
    DEVICE_USE_STATEMENT='DeviceUseStatement' # DeviceUseStatement装置使用声明
    DIAGNOSTIC_REPORT='DiagnosticReport' # DiagnosticReportRefertoDiagnosticoRapportDiagnostique诊断报告InformeDiagnostico
    DOCUMENT_MANIFEST='DocumentManifest' # DocumentManifestManifeste文档清单ManifestoDocumento
    DOCUMENT_REFERENCE='DocumentReference' # DocumentReferenceRiferimentoDocumentoRéférenceDocumentReferenciaDocumento文档引用
    ENCOUNTER='Encounter' # EncounterVenue就医过程Encuentro
    ENDPOINT='Endpoint' # EndpointEndpoint端点
    ENROLLMENT_REQUEST='EnrollmentRequest' # EnrollmentRequestRichiestaIscrizioneDemandeInscriptionSolicitudDeEnrolamiento保险注册请求
    ENROLLMENT_RESPONSE='EnrollmentResponse' # EnrollmentResponseRispostaIscrizioneRéponseInscriptionRespuestaDeEnrolamiento保险注册响应
    EPISODE_OF_CARE='EpisodeOfCare' # EpisodeOfCareEpisodioDiCuraÉpisodeDeSoinsEpisodioDeCuidado照护服务节段
    EVENT_DEFINITION='EventDefinition' # EventDefinitionDefinizioneEventoDefinitionDeEvento事件定义
    EVIDENCE='Evidence' # Evidence
    EVIDENCE_REPORT='EvidenceReport' # EvidenceReport
    EVIDENCE_VARIABLE='EvidenceVariable' # EvidenceVariable
    EXAMPLE_SCENARIO='ExampleScenario' # ExampleScenarioScenarioDiEsempioEjemploDeEscenario示例场景
    EXPLANATION_OF_BENEFIT='ExplanationOfBenefit' # ExplanationOfBenefitExplicationDuBénéfice赔付说明
    FAMILY_MEMBER_HISTORY='FamilyMemberHistory' # FamilyMemberHistoryHistoireMembreFamilleHistorialMiembroFamiliar家族史
    FLAG='Flag' # FlagDrapeauBandera标记
    GOAL='Goal' # GoalButObjetivo目标
    GRAPH_DEFINITION='GraphDefinition' # GraphDefinitionDefinitionGrafico图形定义
    GROUP='Group' # GroupGruppoGroupeGrupo群组
    GUIDANCE_RESPONSE='GuidanceResponse' # GuidanceResponseRespuestaDeOrientacion指导意见响应
    HEALTHCARE_SERVICE='HealthcareService' # HealthcareServiceServizioSanitarioServiceDeSantéServicioDeCuidado医疗保健服务项目
    IMAGING_STUDY='ImagingStudy' # ImagingStudyEtudeImagerieEstudioImagen / EstudioImagen成像检查
    IMMUNIZATION='Immunization' # ImmunizationImmunizzazioneImmunisation免疫接种Inmunización
    IMMUNIZATION_EVALUATION='ImmunizationEvaluation' # ImmunizationEvaluation
    IMMUNIZATION_RECOMMENDATION='ImmunizationRecommendation' # ImmunizationRecommendationRecommendationImmunisation免疫接种建议RecomendaciónInmunización /
    IMPLEMENTATION_GUIDE='ImplementationGuide' # ImplementationGuideGuiaDeImplementacion实施指南
    INGREDIENT='Ingredient' # Ingredient
    INSURANCE_PLAN='InsurancePlan' # InsurancePlan
    INVOICE='Invoice' # Invoice
    LIBRARY='Library' # LibraryLibrería库
    LINKAGE='Linkage' # LinkageEnlace / Conexión / Vinculo / Acoplamiento 链接关系
    LIST='List' # ListListaListe列表Lista
    LOCATION='Location' # LocationLocalisation位置Locacion
    MANUFACTURED_ITEM_DEFINITION='ManufacturedItemDefinition' # ManufacturedItemDefinition
    MEASURE='Measure' # MeasureMisuraMedida指标
    MEASURE_REPORT='MeasureReport' # MeasureReportReporteMedida指标报告
    MEDIA='Media' # MediaMediaMédiaMedio媒体
    MEDICATION='Medication' # MedicationMédication药物Medicación /Medicamento
    MEDICATION_ADMINISTRATION='MedicationAdministration' # MedicationAdministrationAdministrationMédicaments药物施用AdministraciónMedicación / AdministracionMedicamento
    MEDICATION_DISPENSE='MedicationDispense' # MedicationDispenseDispensationMédicaments药物配发DispensaciónMedicación /DispensacionMedicamento
    MEDICATION_KNOWLEDGE='MedicationKnowledge' # MedicationKnowledge
    MEDICATION_REQUEST='MedicationRequest' # MedicationRequestPrescriptionMédicamenteuseTODO药物请求PrescripciónMedicaciónTODO /PrescripcionMedicamento
    MEDICATION_STATEMENT='MedicationStatement' # MedicationStatementÉtatMédication药物声明ResumenMedicación /ResumenMedicamento
    MEDICINAL_PRODUCT_DEFINITION='MedicinalProductDefinition' # MedicinalProductDefinition
    MESSAGE_DEFINITION='MessageDefinition' # MessageDefinitionDefinizioneMessaggioDefinicionMensaje消息定义
    MESSAGE_HEADER='MessageHeader' # MessageHeaderEntêteMessage消息标头CabeceraMensaje
    MOLECULAR_SEQUENCE='MolecularSequence' # MolecularSequenceSecuenciaMolecular分子序列
    NAMING_SYSTEM='NamingSystem' # NamingSystemSystèmeDeNommageSistemaDeNombres命名系统
    NUTRITION_ORDER='NutritionOrder' # NutritionOrderOrdreNutritionOrdenNutrición营养医嘱
    NUTRITION_PRODUCT='NutritionProduct' # NutritionProductProduitNutritionnelProductoNutricional
    OBSERVATION='Observation' # ObservationOsservazioneObservation观察Observación
    OBSERVATION_DEFINITION='ObservationDefinition' # ObservationDefinitionDefinizioneOsservazioneDefinicionDeEspecimen观察定义
    OPERATION_DEFINITION='OperationDefinition' # OperationDefinitionDefinizioneOperazioneDéfinitionOpérationDefinicionDeOperacion操作定义
    OPERATION_OUTCOME='OperationOutcome' # OperationOutcomeRisultatoOperazioneRésultatOpération操作结局ResultadoOperación
    ORGANIZATION='Organization' # OrganizationOrganizzazioneOrganisation组织机构Organización
    ORGANIZATION_AFFILIATION='OrganizationAffiliation' # OrganizationAffiliation
    PACKAGED_PRODUCT_DEFINITION='PackagedProductDefinition' # PackagedProductDefinition
    PATIENT='Patient' # PatientPazientePatient患者Paciente
    PAYMENT_NOTICE='PaymentNotice' # PaymentNoticeAvvisoDiPagamentoAvisPaiementAvisoDePago付款通知
    PAYMENT_RECONCILIATION='PaymentReconciliation' # PaymentReconciliationRiconciliazionePagamentoRéconciliationPaiementConciliacionDePago付款对账
    PERSON='Person' # PersonPersonaPersonnePersona人员
    PLAN_DEFINITION='PlanDefinition' # PlanDefinitionDefinicionDePlan计划定义
    PRACTITIONER='Practitioner' # PractitionerPraticien执业人员Practicante / Profesional
    PRACTITIONER_ROLE='PractitionerRole' # PractitionerRoleRolProfesional执业人员角色
    PROCEDURE='Procedure' # ProcedureProceduraProcédure操作项目Procedimiento
    PROVENANCE='Provenance' # ProvenanceProvenienzaProvenance出处Procedencia
    QUESTIONNAIRE='Questionnaire' # QuestionnaireQuestionarioQuestionnaire调查问卷Cuestionario
    QUESTIONNAIRE_RESPONSE='QuestionnaireResponse' # QuestionnaireResponseRispostaQuestionarioRéponseQuestionnaireRespuestaAlCuestionario调查问卷答复
    REGULATED_AUTHORIZATION='RegulatedAuthorization' # RegulatedAuthorization
    RELATED_PERSON='RelatedPerson' # RelatedPersonPersonaCorrelataPersonneEnRelationPersonaRelacionada相关人员
    REQUEST_GROUP='RequestGroup' # RequestGroupGruppoDiRichiesteGrupoDeSolicitudes请求分组
    RESEARCH_DEFINITION='ResearchDefinition' # ResearchDefinition
    RESEARCH_ELEMENT_DEFINITION='ResearchElementDefinition' # ResearchElementDefinition
    RESEARCH_STUDY='ResearchStudy' # ResearchStudyEstudioDeInvestigacion调查研究
    RESEARCH_SUBJECT='ResearchSubject' # ResearchSubjectSujetoDeInvestigacion研究主题
    RISK_ASSESSMENT='RiskAssessment' # RiskAssessmentÉvaluationRisquesEvaluacionDeRiesgo风险评估
    SCHEDULE='Schedule' # ScheduleAgenda日程安排
    SEARCH_PARAMETER='SearchParameter' # SearchParameterParametroDiRicercaParamètreRechercheParametroDeBusqueda搜索参数
    SERVICE_REQUEST='ServiceRequest' # ServiceRequestRichiestaDiServizioDemandeServicePeticiónServicio服务项目请求
    SLOT='Slot' # SlotSlot槽位Hueco / Zocalo / Espacio
    SPECIMEN='Specimen' # SpecimenCampioneSpécimen标本Especimen
    SPECIMEN_DEFINITION='SpecimenDefinition' # SpecimenDefinitionDefinizioneCampioneDefinicionDeEspecimen标本定义
    STRUCTURE_DEFINITION='StructureDefinition' # StructureDefinitionDefinizioneStrutturaDéfinitionStructureDefinicionDeEstructura结构定义
    STRUCTURE_MAP='StructureMap' # StructureMapMapaDeEstructura结构映射
    SUBSCRIPTION='Subscription' # SubscriptionSottoscrizioneSouscription订阅Suscripción
    SUBSCRIPTION_STATUS='SubscriptionStatus' # SubscriptionStatus
    SUBSCRIPTION_TOPIC='SubscriptionTopic' # SubscriptionTopic
    SUBSTANCE='Substance' # SubstanceSostanzaSubstance物质Sustancia
    SUBSTANCE_DEFINITION='SubstanceDefinition' # SubstanceDefinition
    SUPPLY_DELIVERY='SupplyDelivery' # SupplyDeliverySupply Livraison供应交付Entrega de Suministro
    SUPPLY_REQUEST='SupplyRequest' # SupplyRequestDemande d'approvisionnement供应请求Solicitud de Suministro
    TASK='Task' # TaskTarea任务
    TERMINOLOGY_CAPABILITIES='TerminologyCapabilities' # TerminologyCapabilitiesCapacidadTerminologica术语服务能力
    TEST_REPORT='TestReport' # TestReportRapportTestReporteDePrueba测试报告
    TEST_SCRIPT='TestScript' # TestScriptScriptTestScriptDePrueba测试脚本
    VALUE_SET='ValueSet' # ValueSetEnsembleValeurs取值集合ConjuntoValores / ConjuntoDeValores
    VERIFICATION_RESULT='VerificationResult' # VerificationResult
    VISION_PRESCRIPTION='VisionPrescription' # VisionPrescriptionPrescriptionVisionPrescripcionDeVision视力处方
    PARAMETERS='Parameters' # ParametersParametros参数


class FHIRDeviceStatusEnum(str, Enum):
    ACTIVE='active' # Active
    INACTIVE='inactive' # Inactive
    ENTEREDINERROR='entered-in-error' # Entered in Error
    UNKNOWN='unknown' # Unknown


class FHIRPathTypesEnum(str, Enum):
    HTTPHL_7ORGFHIRPATH_SYSTEM_STRING='http://hl7.org/fhirpath/System.String' # String
    HTTPHL_7ORGFHIRPATH_SYSTEM_BOOLEAN='http://hl7.org/fhirpath/System.Boolean' # Boolean
    HTTPHL_7ORGFHIRPATH_SYSTEM_DATE='http://hl7.org/fhirpath/System.Date' # Date
    HTTPHL_7ORGFHIRPATH_SYSTEM_DATE_TIME='http://hl7.org/fhirpath/System.DateTime' # DateTime
    HTTPHL_7ORGFHIRPATH_SYSTEM_DECIMAL='http://hl7.org/fhirpath/System.Decimal' # Decimal
    HTTPHL_7ORGFHIRPATH_SYSTEM_INTEGER='http://hl7.org/fhirpath/System.Integer' # Integer
    HTTPHL_7ORGFHIRPATH_SYSTEM_TIME='http://hl7.org/fhirpath/System.Time' # Time


class FHIRSubstanceStatusEnum(str, Enum):
    ACTIVE='active' # Active
    INACTIVE='inactive' # Inactive
    ENTEREDINERROR='entered-in-error' # Entered in Error


class FHIRVersionEnum(str, Enum):
    _0_01='0.01' # 0.01
    _0_05='0.05' # 0.05
    _0_06='0.06' # 0.06
    _0_11='0.11' # 0.11
    _0_0_80='0.0.80' # 0.0.80
    _0_0_81='0.0.81' # 0.0.81
    _0_0_82='0.0.82' # 0.0.82
    _0_4_0='0.4.0' # 0.4.0
    _0_5_0='0.5.0' # 0.5.0
    _1_0_0='1.0.0' # 1.0.0
    _1_0_1='1.0.1' # 1.0.1
    _1_0_2='1.0.2' # 1.0.2
    _1_1_0='1.1.0' # 1.1.0
    _1_4_0='1.4.0' # 1.4.0
    _1_6_0='1.6.0' # 1.6.0
    _1_8_0='1.8.0' # 1.8.0
    _3_0_0='3.0.0' # 3.0.0
    _3_0_1='3.0.1' # 3.0.1
    _3_0_2='3.0.2' # 3.0.2
    _3_3_0='3.3.0' # 3.3.0
    _3_5_0='3.5.0' # 3.5.0
    _4_0_0='4.0.0' # 4.0.0
    _4_0_1='4.0.1' # 4.0.1
    _4_1_0='4.1.0' # 4.1.0
    _4_3_0CIBUILD='4.3.0-cibuild' # 4.3.0-cibuild
    _4_3_0SNAPSHOT_1='4.3.0-snapshot1' # 4.3.0-snapshot1
    _4_3_0='4.3.0' # 4.3.0


class FamilyHistoryStatusEnum(str, Enum):
    PARTIAL='partial' # Partial
    COMPLETED='completed' # Completed
    ENTEREDINERROR='entered-in-error' # Entered in Error
    HEALTHUNKNOWN='health-unknown' # Health Unknown


class FilterOperatorEnum(str, Enum):
    _='=' # Equals
    ISA='is-a' # Is A (by subsumption)
    DESCENDENTOF='descendent-of' # Descendent Of (by subsumption)
    ISNOTA='is-not-a' # Not (Is A) (by subsumption)
    REGEX='regex' # Regular Expression
    IN='in' # In Set
    NOTIN='not-in' # Not in Set
    GENERALIZES='generalizes' # Generalizes (by Subsumption)
    EXISTS='exists' # Exists


class FinancialResourceStatusCodesEnum(str, Enum):
    ACTIVE='active' # Active
    CANCELLED='cancelled' # Cancelled
    DRAFT='draft' # Draft
    ENTEREDINERROR='entered-in-error' # Entered in Error


class FlagStatusEnum(str, Enum):
    ACTIVE='active' # Active
    INACTIVE='inactive' # Inactive
    ENTEREDINERROR='entered-in-error' # Entered in Error


class GoalLifecycleStatusEnum(str, Enum):
    PROPOSED='proposed' # Proposed
    PLANNED='planned' # Planned
    ACCEPTED='accepted' # Accepted
    ACTIVE='active' # Active
    ONHOLD='on-hold' # On Hold
    COMPLETED='completed' # Completed
    CANCELLED='cancelled' # Cancelled
    ENTEREDINERROR='entered-in-error' # Entered in Error
    REJECTED='rejected' # Rejected


class GraphCompartmentRuleEnum(str, Enum):
    IDENTICAL='identical' # Identical
    MATCHING='matching' # Matching
    DIFFERENT='different' # Different
    CUSTOM='custom' # Custom


class GraphCompartmentUseEnum(str, Enum):
    CONDITION='condition' # Condition
    REQUIREMENT='requirement' # Requirement


class GroupMeasureEnum(str, Enum):
    MEAN='mean' # Mean
    MEDIAN='median' # Median
    MEANOFMEAN='mean-of-mean' # Mean of Study Means
    MEANOFMEDIAN='mean-of-median' # Mean of Study Medins
    MEDIANOFMEAN='median-of-mean' # Median of Study Means
    MEDIANOFMEDIAN='median-of-median' # Median of Study Medians


class GroupTypeEnum(str, Enum):
    PERSON='person' # Person
    ANIMAL='animal' # Animal
    PRACTITIONER='practitioner' # Practitioner
    DEVICE='device' # Device
    MEDICATION='medication' # Medication
    SUBSTANCE='substance' # Substance


class GuidanceResponseStatusEnum(str, Enum):
    SUCCESS='success' # Success
    DATAREQUESTED='data-requested' # Data Requested
    DATAREQUIRED='data-required' # Data Required
    INPROGRESS='in-progress' # In Progress
    FAILURE='failure' # Failure
    ENTEREDINERROR='entered-in-error' # Entered In Error


class GuidePageGenerationEnum(str, Enum):
    HTML='html' # HTML
    MARKDOWN='markdown' # Markdown
    XML='xml' # XML
    GENERATED='generated' # Generated


class GuideParameterCodeEnum(str, Enum):
    APPLY='apply' # Apply Metadata Value
    PATHRESOURCE='path-resource' # Resource Path
    PATHPAGES='path-pages' # Pages Path
    PATHTXCACHE='path-tx-cache' # Terminology Cache Path
    EXPANSIONPARAMETER='expansion-parameter' # Expansion Profile
    RULEBROKENLINKS='rule-broken-links' # Broken Links Rule
    GENERATEXML='generate-xml' # Generate XML
    GENERATEJSON='generate-json' # Generate JSON
    GENERATETURTLE='generate-turtle' # Generate Turtle
    HTMLTEMPLATE='html-template' # HTML Template


class HTTPVerbEnum(str, Enum):
    GET='GET' # GET
    HEAD='HEAD' # HEAD
    POST='POST' # POST
    PUT='PUT' # PUT
    DELETE='DELETE' # DELETE
    PATCH='PATCH' # PATCH


class IdentifierUseEnum(str, Enum):
    USUAL='usual' # Usual
    OFFICIAL='official' # Official
    TEMP='temp' # Temp
    SECONDARY='secondary' # Secondary
    OLD='old' # Old


class IdentityAssuranceLevelEnum(str, Enum):
    LEVEL_1='level1' # Level 1
    LEVEL_2='level2' # Level 2
    LEVEL_3='level3' # Level 3
    LEVEL_4='level4' # Level 4


class ImagingStudyStatusEnum(str, Enum):
    REGISTERED='registered' # Registered
    AVAILABLE='available' # Available
    CANCELLED='cancelled' # Cancelled
    ENTEREDINERROR='entered-in-error' # Entered in Error
    UNKNOWN='unknown' # Unknown


class ImmunizationEvaluationStatusCodesEnum(str, Enum):
    COMPLETED='completed' # Completed
    ENTEREDINERROR='entered-in-error' # Entered in Error


class ImmunizationStatusCodesEnum(str, Enum):
    COMPLETED='completed' # Completed
    ENTEREDINERROR='entered-in-error' # Entered in Error
    NOTDONE='not-done' # Not Done


class IngredientManufacturerRoleEnum(str, Enum):
    ALLOWED='allowed' # Manufacturer is specifically allowed for this ingredient
    POSSIBLE='possible' # Manufacturer is known to make this ingredient in general
    ACTUAL='actual' # Manufacturer actually makes this particular ingredient


class InteractionTriggerEnum(str, Enum):
    CREATE='create' # create
    UPDATE='update' # update
    DELETE='delete' # delete


class InvoicePriceComponentTypeEnum(str, Enum):
    BASE='base' # base price
    SURCHARGE='surcharge' # surcharge
    DEDUCTION='deduction' # deduction
    DISCOUNT='discount' # discount
    TAX='tax' # tax
    INFORMATIONAL='informational' # informational


class InvoiceStatusEnum(str, Enum):
    DRAFT='draft' # draft
    ISSUED='issued' # issued
    BALANCED='balanced' # balanced
    CANCELLED='cancelled' # cancelled
    ENTEREDINERROR='entered-in-error' # entered in error


class IssueSeverityEnum(str, Enum):
    FATAL='fatal' # Fatal
    ERROR='error' # Error
    WARNING='warning' # Warning
    INFORMATION='information' # Information


class IssueTypeEnum(str, Enum):
    INVALID='invalid' # Invalid Content
    STRUCTURE='structure' # Structural Issue
    REQUIRED='required' # Required element missing
    VALUE='value' # Element value invalid
    INVARIANT='invariant' # Validation rule failed
    SECURITY='security' # Security Problem
    LOGIN='login' # Login Required
    UNKNOWN='unknown' # Unknown User
    EXPIRED='expired' # Session Expired
    FORBIDDEN='forbidden' # Forbidden
    SUPPRESSED='suppressed' # Information Suppressed
    PROCESSING='processing' # Processing Failure
    NOTSUPPORTED='not-supported' # Content not supported
    DUPLICATE='duplicate' # Duplicate
    MULTIPLEMATCHES='multiple-matches' # Multiple Matches
    NOTFOUND='not-found' # Not Found
    DELETED='deleted' # Deleted
    TOOLONG='too-long' # Content Too Long
    CODEINVALID='code-invalid' # Invalid Code
    EXTENSION='extension' # Unacceptable Extension
    TOOCOSTLY='too-costly' # Operation Too Costly
    BUSINESSRULE='business-rule' # Business Rule Violation
    CONFLICT='conflict' # Edit Version Conflict
    TRANSIENT='transient' # Transient Issue
    LOCKERROR='lock-error' # Lock Error
    NOSTORE='no-store' # No Store Available
    EXCEPTION='exception' # Exception
    TIMEOUT='timeout' # Timeout
    INCOMPLETE='incomplete' # Incomplete Results
    THROTTLED='throttled' # Throttled
    INFORMATIONAL='informational' # Informational Note


class KnowledgeResourceTypeEnum(str, Enum):
    ACTIVITY_DEFINITION='ActivityDefinition' # ActivityDefinition
    CODE_SYSTEM='CodeSystem' # CodeSystem
    CONCEPT_MAP='ConceptMap' # ConceptMap
    LIBRARY='Library' # Library
    MEASURE='Measure' # Measure
    PLAN_DEFINITION='PlanDefinition' # PlanDefinition
    STRUCTURE_DEFINITION='StructureDefinition' # StructureDefinition
    STRUCTURE_MAP='StructureMap' # StructureMap
    VALUE_SET='ValueSet' # ValueSet


class LinkTypeEnum(str, Enum):
    REPLACEDBY='replaced-by' # Replaced-byVervangen door
    REPLACES='replaces' # ReplacesVervangt
    REFER='refer' # ReferVerwijzing
    SEEALSO='seealso' # See alsoZie ook


class LinkageTypeEnum(str, Enum):
    SOURCE='source' # Source of Truth
    ALTERNATE='alternate' # Alternate Record
    HISTORICAL='historical' # Historical/Obsolete Record


class ListModeEnum(str, Enum):
    WORKING='working' # Working List
    SNAPSHOT='snapshot' # Snapshot List
    CHANGES='changes' # Change List


class ListStatusEnum(str, Enum):
    CURRENT='current' # Current
    RETIRED='retired' # Retired
    ENTEREDINERROR='entered-in-error' # Entered In Error


class LocationModeEnum(str, Enum):
    INSTANCE='instance' # Instance
    KIND='kind' # Kind


class LocationStatusEnum(str, Enum):
    ACTIVE='active' # Active
    SUSPENDED='suspended' # Suspended
    INACTIVE='inactive' # Inactive


class MeasureReportStatusEnum(str, Enum):
    COMPLETE='complete' # Complete
    PENDING='pending' # Pending
    ERROR='error' # Error


class MeasureReportTypeEnum(str, Enum):
    INDIVIDUAL='individual' # Individual
    SUBJECTLIST='subject-list' # Subject List
    SUMMARY='summary' # Summary
    DATACOLLECTION='data-collection' # Data Collection


class MedicationStatementStatusCodesEnum(str, Enum):
    ACTIVE='active' # Active
    COMPLETED='completed' # Completed
    ENTEREDINERROR='entered-in-error' # Entered in Error
    INTENDED='intended' # Intended
    STOPPED='stopped' # Stopped
    ONHOLD='on-hold' # On Hold
    UNKNOWN='unknown' # Unknown
    NOTTAKEN='not-taken' # Not Taken


class MedicationStatusCodesEnum(str, Enum):
    ACTIVE='active' # Active
    INACTIVE='inactive' # Inactive
    ENTEREDINERROR='entered-in-error' # Entered in Error


class MessageSignificanceCategoryEnum(str, Enum):
    CONSEQUENCE='consequence' # Consequence
    CURRENCY='currency' # Currency
    NOTIFICATION='notification' # Notification


class NameUseEnum(str, Enum):
    USUAL='usual' # Usual
    OFFICIAL='official' # Official
    TEMP='temp' # Temp
    NICKNAME='nickname' # Nickname
    ANONYMOUS='anonymous' # Anonymous
    OLD='old' # Old
    MAIDEN='maiden' # Name changed for Marriage


class NamingSystemIdentifierTypeEnum(str, Enum):
    OID='oid' # OID
    UUID='uuid' # UUID
    URI='uri' # URI
    OTHER='other' # Other


class NamingSystemTypeEnum(str, Enum):
    CODESYSTEM='codesystem' # Code System
    IDENTIFIER='identifier' # Identifier
    ROOT='root' # Root


class NarrativeStatusEnum(str, Enum):
    GENERATED='generated' # Generated
    EXTENSIONS='extensions' # Extensions
    ADDITIONAL='additional' # Additional
    EMPTY='empty' # Empty


class NoteTypeEnum(str, Enum):
    DISPLAY='display' # Display
    PRINT='print' # Print (Form)
    PRINTOPER='printoper' # Print (Operator)


class NutritionProductStatusEnum(str, Enum):
    ACTIVE='active' # Active
    INACTIVE='inactive' # Inactive
    ENTEREDINERROR='entered-in-error' # Entered in Error


class ObservationDataTypeEnum(str, Enum):
    QUANTITY='Quantity' # Quantity
    CODEABLE_CONCEPT='CodeableConcept' # CodeableConcept
    STRING='string' # string
    BOOLEAN='boolean' # boolean
    INTEGER='integer' # integer
    RANGE='Range' # Range
    RATIO='Ratio' # Ratio
    SAMPLED_DATA='SampledData' # SampledData
    TIME='time' # time
    DATE_TIME='dateTime' # dateTime
    PERIOD='Period' # Period


class ObservationRangeCategoryEnum(str, Enum):
    REFERENCE='reference' # reference range
    CRITICAL='critical' # critical range
    ABSOLUTE='absolute' # absolute range


class ObservationStatusEnum(str, Enum):
    REGISTERED='registered' # Registered
    PRELIMINARY='preliminary' # Preliminary
    FINAL='final' # Final
    AMENDED='amended' # Amended
    CORRECTED='corrected' # Corrected
    CANCELLED='cancelled' # Cancelled
    ENTEREDINERROR='entered-in-error' # Entered in Error
    UNKNOWN='unknown' # Unknown


class OperationKindEnum(str, Enum):
    OPERATION='operation' # Operation
    QUERY='query' # Query


class OperationParameterUseEnum(str, Enum):
    IN='in' # In
    OUT='out' # Out


class ParticipantRequiredEnum(str, Enum):
    REQUIRED='required' # Required
    OPTIONAL='optional' # Optional
    INFORMATIONONLY='information-only' # Information Only


class ParticipationStatusEnum(str, Enum):
    ACCEPTED='accepted' # Accepted
    DECLINED='declined' # Declined
    TENTATIVE='tentative' # Tentative
    NEEDSACTION='needs-action' # Needs Action


class PropertyRepresentationEnum(str, Enum):
    XML_ATTR='xmlAttr' # XML Attribute
    XML_TEXT='xmlText' # XML Text
    TYPE_ATTR='typeAttr' # Type Attribute
    CDA_TEXT='cdaText' # CDA Text Format
    XHTML='xhtml' # XHTML


class PropertyTypeEnum(str, Enum):
    CODE='code' # code (internal reference)
    CODING='Coding' # Coding (external reference)
    STRING='string' # string
    INTEGER='integer' # integer
    BOOLEAN='boolean' # boolean
    DATE_TIME='dateTime' # dateTime
    DECIMAL='decimal' # decimal


class ProvenanceEntityRoleEnum(str, Enum):
    DERIVATION='derivation' # Derivation
    REVISION='revision' # Revision
    QUOTATION='quotation' # Quotation
    SOURCE='source' # Source
    REMOVAL='removal' # Removal


class PublicationStatusEnum(str, Enum):
    DRAFT='draft' # Draftчерновикontwerp
    ACTIVE='active' # Activeактивныйactief
    RETIRED='retired' # Retiredудалёнverouderd
    UNKNOWN='unknown' # Unknown


class QuantityComparatorEnum(str, Enum):
    _='<' # Less than
    __1='<=' # Less or Equal to
    __2='>=' # Greater or Equal to
    __3='>' # Greater than


class QuestionnaireItemOperatorEnum(str, Enum):
    EXISTS='exists' # Exists
    _='=' # Equals
    __1='!=' # Not Equals
    __2='>' # Greater Than
    __3='<' # Less Than
    __4='>=' # Greater or Equals
    __5='<=' # Less or Equals


class QuestionnaireItemTypeEnum(str, Enum):
    GROUP='group' # Group
    DISPLAY='display' # Display
    QUESTION='question' # Question
    BOOLEAN='boolean' # Boolean
    DECIMAL='decimal' # Decimal
    INTEGER='integer' # Integer
    DATE='date' # Date
    DATE_TIME='dateTime' # Date Time
    TIME='time' # Time
    STRING='string' # String
    TEXT='text' # Text
    URL='url' # Url
    CHOICE='choice' # Choice
    OPENCHOICE='open-choice' # Open Choice
    ATTACHMENT='attachment' # Attachment
    REFERENCE='reference' # Reference
    QUANTITY='quantity' # Quantity


class QuestionnaireResponseStatusEnum(str, Enum):
    INPROGRESS='in-progress' # In Progress
    COMPLETED='completed' # Completed
    AMENDED='amended' # Amended
    ENTEREDINERROR='entered-in-error' # Entered in Error
    STOPPED='stopped' # Stopped


class ReferenceHandlingPolicyEnum(str, Enum):
    LITERAL='literal' # Literal References
    LOGICAL='logical' # Logical References
    RESOLVES='resolves' # Resolves References
    ENFORCED='enforced' # Reference Integrity Enforced
    LOCAL='local' # Local References Only


class ReferenceVersionRulesEnum(str, Enum):
    EITHER='either' # Either Specific or independent
    INDEPENDENT='independent' # Version independent
    SPECIFIC='specific' # Version Specific


class RelatedArtifactTypeEnum(str, Enum):
    DOCUMENTATION='documentation' # Documentation
    JUSTIFICATION='justification' # Justification
    CITATION='citation' # Citation
    PREDECESSOR='predecessor' # Predecessor
    SUCCESSOR='successor' # Successor
    DERIVEDFROM='derived-from' # Derived From
    DEPENDSON='depends-on' # Depends On
    COMPOSEDOF='composed-of' # Composed Of


class RemittanceOutcomeEnum(str, Enum):
    QUEUED='queued' # Queued
    COMPLETE='complete' # Complete
    ERROR='error' # Error
    PARTIAL='partial' # Partial


class ReportRelationshipTypeEnum(str, Enum):
    REPLACES='replaces' # Replaces
    AMENDS='amends' # Amends
    APPENDS='appends' # Appends
    TRANSFORMS='transforms' # Transforms
    REPLACED_WITH='replacedWith' # Replaced With
    AMENDED_WITH='amendedWith' # Amended With
    APPENDED_WITH='appendedWith' # Appended With
    TRANSFORMED_WITH='transformedWith' # Transformed With


class RequestIntentEnum(str, Enum):
    PROPOSAL='proposal' # Proposal
    PLAN='plan' # Plan
    DIRECTIVE='directive' # Directive
    ORDER='order' # Order
    ORIGINALORDER='original-order' # Original Order
    REFLEXORDER='reflex-order' # Reflex Order
    FILLERORDER='filler-order' # Filler Order
    INSTANCEORDER='instance-order' # Instance Order
    OPTION='option' # Option


class RequestPriorityEnum(str, Enum):
    ROUTINE='routine' # Routine
    URGENT='urgent' # Urgent
    ASAP='asap' # ASAP
    STAT='stat' # STAT


class RequestResourceTypeEnum(str, Enum):
    APPOINTMENT='Appointment' # Appointment
    APPOINTMENT_RESPONSE='AppointmentResponse' # AppointmentResponse
    CARE_PLAN='CarePlan' # CarePlan
    CLAIM='Claim' # Claim
    COMMUNICATION_REQUEST='CommunicationRequest' # CommunicationRequest
    CONTRACT='Contract' # Contract
    DEVICE_REQUEST='DeviceRequest' # DeviceRequest
    ENROLLMENT_REQUEST='EnrollmentRequest' # EnrollmentRequest
    IMMUNIZATION_RECOMMENDATION='ImmunizationRecommendation' # ImmunizationRecommendation
    MEDICATION_REQUEST='MedicationRequest' # MedicationRequest
    NUTRITION_ORDER='NutritionOrder' # NutritionOrder
    SERVICE_REQUEST='ServiceRequest' # ServiceRequest
    SUPPLY_REQUEST='SupplyRequest' # SupplyRequest
    TASK='Task' # Task
    VISION_PRESCRIPTION='VisionPrescription' # VisionPrescription


class RequestStatusEnum(str, Enum):
    DRAFT='draft' # Draft
    ACTIVE='active' # Active
    ONHOLD='on-hold' # On Hold
    REVOKED='revoked' # Revoked
    COMPLETED='completed' # Completed
    ENTEREDINERROR='entered-in-error' # Entered in Error
    UNKNOWN='unknown' # Unknown


class ResearchElementTypeEnum(str, Enum):
    POPULATION='population' # Population
    EXPOSURE='exposure' # Exposure
    OUTCOME='outcome' # Outcome


class ResearchStudyStatusEnum(str, Enum):
    ACTIVE='active' # Active
    ADMINISTRATIVELYCOMPLETED='administratively-completed' # Administratively Completed
    APPROVED='approved' # Approved
    CLOSEDTOACCRUAL='closed-to-accrual' # Closed to Accrual
    CLOSEDTOACCRUALANDINTERVENTION='closed-to-accrual-and-intervention' # Closed to Accrual and Intervention
    COMPLETED='completed' # Completed
    DISAPPROVED='disapproved' # Disapproved
    INREVIEW='in-review' # In Review
    TEMPORARILYCLOSEDTOACCRUAL='temporarily-closed-to-accrual' # Temporarily Closed to Accrual
    TEMPORARILYCLOSEDTOACCRUALANDINTERVENTION='temporarily-closed-to-accrual-and-intervention' # Temporarily Closed to Accrual and Intervention
    WITHDRAWN='withdrawn' # Withdrawn


class ResearchSubjectStatusEnum(str, Enum):
    CANDIDATE='candidate' # Candidate
    ELIGIBLE='eligible' # Eligible
    FOLLOWUP='follow-up' # Follow-up
    INELIGIBLE='ineligible' # Ineligible
    NOTREGISTERED='not-registered' # Not Registered
    OFFSTUDY='off-study' # Off-study
    ONSTUDY='on-study' # On-study
    ONSTUDYINTERVENTION='on-study-intervention' # On-study-intervention
    ONSTUDYOBSERVATION='on-study-observation' # On-study-observation
    PENDINGONSTUDY='pending-on-study' # Pending on-study
    POTENTIALCANDIDATE='potential-candidate' # Potential Candidate
    SCREENING='screening' # Screening
    WITHDRAWN='withdrawn' # Withdrawn


class ResourceTypeEnum(str, Enum):
    RESOURCE='Resource' # ResourceRecurso资源
    BINARY='Binary' # BinaryBinarioBinaireBinario二进制资源
    BUNDLE='Bundle' # BundlePaquetPaquete捆束
    DOMAIN_RESOURCE='DomainResource' # DomainResourceRecursoDeDominio领域资源
    ACCOUNT='Account' # AccountCuenta账户
    ACTIVITY_DEFINITION='ActivityDefinition' # ActivityDefinitionDefinizioneAttivitaDefinicionDeActividad活动定义
    ADMINISTRABLE_PRODUCT_DEFINITION='AdministrableProductDefinition' # AdministrableProductDefinition
    ADVERSE_EVENT='AdverseEvent' # AdverseEventEventoAvversoEventoAdverso不良事件
    ALLERGY_INTOLERANCE='AllergyIntolerance' # AllergyIntoleranceAllergiaIntolleranzaIntoléranceAllergiqueAllergiaIntolerancia变态反应与不耐性
    APPOINTMENT='Appointment' # AppointmentAppuntamentoRendezVousCita预约
    APPOINTMENT_RESPONSE='AppointmentResponse' # AppointmentResponseRispostaAppuntamentoRéponseRendezVousCitaRespuesta预约响应
    AUDIT_EVENT='AuditEvent' # AuditEventÉvènementSécuritéEventoSeguridad审计事件
    BASIC='Basic' # BasicBasiqueBasico初级资源
    BIOLOGICALLY_DERIVED_PRODUCT='BiologicallyDerivedProduct' # BiologicallyDerivedProduct
    BODY_STRUCTURE='BodyStructure' # BodyStructureStrutturaDelCorpoMorphologieDeCorpsEstructuraDelCuerpo身体结构
    CAPABILITY_STATEMENT='CapabilityStatement' # CapabilityStatementDeclaracionDeCapacidad能力声明
    CARE_PLAN='CarePlan' # CarePlanPianoDiCuraPlanDeSoinsPlanDeCuidado照护计划
    CARE_TEAM='CareTeam' # CareTeamEquipoDeCuidado照护团队
    CATALOG_ENTRY='CatalogEntry' # CatalogEntryEntradaDeCatalogo条目定义
    CHARGE_ITEM='ChargeItem' # ChargeItemCargoDeItem收费项目
    CHARGE_ITEM_DEFINITION='ChargeItemDefinition' # ChargeItemDefinition
    CITATION='Citation' # Citation
    CLAIM='Claim' # ClaimRéclamationReclamación / Factura赔单
    CLAIM_RESPONSE='ClaimResponse' # ClaimResponseRéponseARéclamation赔单请求
    CLINICAL_IMPRESSION='ClinicalImpression' # ClinicalImpressionImpressioneClinicaImpressionCliniqueHallazgoClinico临床印象
    CLINICAL_USE_DEFINITION='ClinicalUseDefinition' # ClinicalUseDefinition
    CODE_SYSTEM='CodeSystem' # CodeSystemSistemaDiCodificaSistemaDeCodigos代码系统
    COMMUNICATION='Communication' # CommunicationComunicazioneCommunicationComunicación通讯
    COMMUNICATION_REQUEST='CommunicationRequest' # CommunicationRequestRichiestaDiComunicazioneDemandeDeCommunicationComunicaciónRequerimiento通讯请求
    COMPARTMENT_DEFINITION='CompartmentDefinition' # CompartmentDefinitionDefinicionDeCompartimento逻辑区块定义
    COMPOSITION='Composition' # CompositionComposizioneCompositionComposición组合式文书
    CONCEPT_MAP='ConceptMap' # ConceptMapMappaDiConcettiCarteDeConceptsMapaDeConceptos概念映射
    CONDITION='Condition' # ConditionCondizioneConditionCondición情况
    CONSENT='Consent' # ConsentConsensoConsentimiento同意书
    CONTRACT='Contract' # ContractContrattoContratContato合同
    COVERAGE='Coverage' # CoverageCoperturaCouvertureCobertura保险责任
    COVERAGE_ELIGIBILITY_REQUEST='CoverageEligibilityRequest' # CoverageEligibilityRequestRichiestaEleggibilitaCoperturaCouvertureDemandeEligibilité资格请求
    COVERAGE_ELIGIBILITY_RESPONSE='CoverageEligibilityResponse' # CoverageEligibilityResponseRispostaEleggibilitaCoperturaRéponseEligibilitéCouverture资格响应
    DETECTED_ISSUE='DetectedIssue' # DetectedIssueProblemaRilevatoProblème DétectéProblema-Detectado /ProblemaDetectado已发现问题
    DEVICE='Device' # DeviceDispositivoDispositifDispositivo装置
    DEVICE_DEFINITION='DeviceDefinition' # DeviceDefinitionDéfinitionDeDispositifDefiniciónDeDispositivo装置组件
    DEVICE_METRIC='DeviceMetric' # DeviceMetricMétriqueDispositifMetricaDeDispositivo装置指标
    DEVICE_REQUEST='DeviceRequest' # DeviceRequestRichiestaDispositivoDemandeUtilisationDispositifSolicitudDeDispositivo装置请求
    DEVICE_USE_STATEMENT='DeviceUseStatement' # DeviceUseStatement装置使用声明
    DIAGNOSTIC_REPORT='DiagnosticReport' # DiagnosticReportRefertoDiagnosticoRapportDiagnostique诊断报告InformeDiagnostico
    DOCUMENT_MANIFEST='DocumentManifest' # DocumentManifestManifeste文档清单ManifestoDocumento
    DOCUMENT_REFERENCE='DocumentReference' # DocumentReferenceRiferimentoDocumentoRéférenceDocumentReferenciaDocumento文档引用
    ENCOUNTER='Encounter' # EncounterVenue就医过程Encuentro
    ENDPOINT='Endpoint' # EndpointEndpoint端点
    ENROLLMENT_REQUEST='EnrollmentRequest' # EnrollmentRequestRichiestaIscrizioneDemandeInscriptionSolicitudDeEnrolamiento保险注册请求
    ENROLLMENT_RESPONSE='EnrollmentResponse' # EnrollmentResponseRispostaIscrizioneRéponseInscriptionRespuestaDeEnrolamiento保险注册响应
    EPISODE_OF_CARE='EpisodeOfCare' # EpisodeOfCareEpisodioDiCuraÉpisodeDeSoinsEpisodioDeCuidado照护服务节段
    EVENT_DEFINITION='EventDefinition' # EventDefinitionDefinizioneEventoDefinitionDeEvento事件定义
    EVIDENCE='Evidence' # Evidence
    EVIDENCE_REPORT='EvidenceReport' # EvidenceReport
    EVIDENCE_VARIABLE='EvidenceVariable' # EvidenceVariable
    EXAMPLE_SCENARIO='ExampleScenario' # ExampleScenarioScenarioDiEsempioEjemploDeEscenario示例场景
    EXPLANATION_OF_BENEFIT='ExplanationOfBenefit' # ExplanationOfBenefitExplicationDuBénéfice赔付说明
    FAMILY_MEMBER_HISTORY='FamilyMemberHistory' # FamilyMemberHistoryHistoireMembreFamilleHistorialMiembroFamiliar家族史
    FLAG='Flag' # FlagDrapeauBandera标记
    GOAL='Goal' # GoalButObjetivo目标
    GRAPH_DEFINITION='GraphDefinition' # GraphDefinitionDefinitionGrafico图形定义
    GROUP='Group' # GroupGruppoGroupeGrupo群组
    GUIDANCE_RESPONSE='GuidanceResponse' # GuidanceResponseRespuestaDeOrientacion指导意见响应
    HEALTHCARE_SERVICE='HealthcareService' # HealthcareServiceServizioSanitarioServiceDeSantéServicioDeCuidado医疗保健服务项目
    IMAGING_STUDY='ImagingStudy' # ImagingStudyEtudeImagerieEstudioImagen / EstudioImagen成像检查
    IMMUNIZATION='Immunization' # ImmunizationImmunizzazioneImmunisation免疫接种Inmunización
    IMMUNIZATION_EVALUATION='ImmunizationEvaluation' # ImmunizationEvaluation
    IMMUNIZATION_RECOMMENDATION='ImmunizationRecommendation' # ImmunizationRecommendationRecommendationImmunisation免疫接种建议RecomendaciónInmunización /
    IMPLEMENTATION_GUIDE='ImplementationGuide' # ImplementationGuideGuiaDeImplementacion实施指南
    INGREDIENT='Ingredient' # Ingredient
    INSURANCE_PLAN='InsurancePlan' # InsurancePlan
    INVOICE='Invoice' # Invoice
    LIBRARY='Library' # LibraryLibrería库
    LINKAGE='Linkage' # LinkageEnlace / Conexión / Vinculo / Acoplamiento 链接关系
    LIST='List' # ListListaListe列表Lista
    LOCATION='Location' # LocationLocalisation位置Locacion
    MANUFACTURED_ITEM_DEFINITION='ManufacturedItemDefinition' # ManufacturedItemDefinition
    MEASURE='Measure' # MeasureMisuraMedida指标
    MEASURE_REPORT='MeasureReport' # MeasureReportReporteMedida指标报告
    MEDIA='Media' # MediaMediaMédiaMedio媒体
    MEDICATION='Medication' # MedicationMédication药物Medicación /Medicamento
    MEDICATION_ADMINISTRATION='MedicationAdministration' # MedicationAdministrationAdministrationMédicaments药物施用AdministraciónMedicación / AdministracionMedicamento
    MEDICATION_DISPENSE='MedicationDispense' # MedicationDispenseDispensationMédicaments药物配发DispensaciónMedicación /DispensacionMedicamento
    MEDICATION_KNOWLEDGE='MedicationKnowledge' # MedicationKnowledge
    MEDICATION_REQUEST='MedicationRequest' # MedicationRequestPrescriptionMédicamenteuseTODO药物请求PrescripciónMedicaciónTODO /PrescripcionMedicamento
    MEDICATION_STATEMENT='MedicationStatement' # MedicationStatementÉtatMédication药物声明ResumenMedicación /ResumenMedicamento
    MEDICINAL_PRODUCT_DEFINITION='MedicinalProductDefinition' # MedicinalProductDefinition
    MESSAGE_DEFINITION='MessageDefinition' # MessageDefinitionDefinizioneMessaggioDefinicionMensaje消息定义
    MESSAGE_HEADER='MessageHeader' # MessageHeaderEntêteMessage消息标头CabeceraMensaje
    MOLECULAR_SEQUENCE='MolecularSequence' # MolecularSequenceSecuenciaMolecular分子序列
    NAMING_SYSTEM='NamingSystem' # NamingSystemSystèmeDeNommageSistemaDeNombres命名系统
    NUTRITION_ORDER='NutritionOrder' # NutritionOrderOrdreNutritionOrdenNutrición营养医嘱
    NUTRITION_PRODUCT='NutritionProduct' # NutritionProductProduitNutritionnelProductoNutricional
    OBSERVATION='Observation' # ObservationOsservazioneObservation观察Observación
    OBSERVATION_DEFINITION='ObservationDefinition' # ObservationDefinitionDefinizioneOsservazioneDefinicionDeEspecimen观察定义
    OPERATION_DEFINITION='OperationDefinition' # OperationDefinitionDefinizioneOperazioneDéfinitionOpérationDefinicionDeOperacion操作定义
    OPERATION_OUTCOME='OperationOutcome' # OperationOutcomeRisultatoOperazioneRésultatOpération操作结局ResultadoOperación
    ORGANIZATION='Organization' # OrganizationOrganizzazioneOrganisation组织机构Organización
    ORGANIZATION_AFFILIATION='OrganizationAffiliation' # OrganizationAffiliation
    PACKAGED_PRODUCT_DEFINITION='PackagedProductDefinition' # PackagedProductDefinition
    PATIENT='Patient' # PatientPazientePatient患者Paciente
    PAYMENT_NOTICE='PaymentNotice' # PaymentNoticeAvvisoDiPagamentoAvisPaiementAvisoDePago付款通知
    PAYMENT_RECONCILIATION='PaymentReconciliation' # PaymentReconciliationRiconciliazionePagamentoRéconciliationPaiementConciliacionDePago付款对账
    PERSON='Person' # PersonPersonaPersonnePersona人员
    PLAN_DEFINITION='PlanDefinition' # PlanDefinitionDefinicionDePlan计划定义
    PRACTITIONER='Practitioner' # PractitionerPraticien执业人员Practicante / Profesional
    PRACTITIONER_ROLE='PractitionerRole' # PractitionerRoleRolProfesional执业人员角色
    PROCEDURE='Procedure' # ProcedureProceduraProcédure操作项目Procedimiento
    PROVENANCE='Provenance' # ProvenanceProvenienzaProvenance出处Procedencia
    QUESTIONNAIRE='Questionnaire' # QuestionnaireQuestionarioQuestionnaire调查问卷Cuestionario
    QUESTIONNAIRE_RESPONSE='QuestionnaireResponse' # QuestionnaireResponseRispostaQuestionarioRéponseQuestionnaireRespuestaAlCuestionario调查问卷答复
    REGULATED_AUTHORIZATION='RegulatedAuthorization' # RegulatedAuthorization
    RELATED_PERSON='RelatedPerson' # RelatedPersonPersonaCorrelataPersonneEnRelationPersonaRelacionada相关人员
    REQUEST_GROUP='RequestGroup' # RequestGroupGruppoDiRichiesteGrupoDeSolicitudes请求分组
    RESEARCH_DEFINITION='ResearchDefinition' # ResearchDefinition
    RESEARCH_ELEMENT_DEFINITION='ResearchElementDefinition' # ResearchElementDefinition
    RESEARCH_STUDY='ResearchStudy' # ResearchStudyEstudioDeInvestigacion调查研究
    RESEARCH_SUBJECT='ResearchSubject' # ResearchSubjectSujetoDeInvestigacion研究主题
    RISK_ASSESSMENT='RiskAssessment' # RiskAssessmentÉvaluationRisquesEvaluacionDeRiesgo风险评估
    SCHEDULE='Schedule' # ScheduleAgenda日程安排
    SEARCH_PARAMETER='SearchParameter' # SearchParameterParametroDiRicercaParamètreRechercheParametroDeBusqueda搜索参数
    SERVICE_REQUEST='ServiceRequest' # ServiceRequestRichiestaDiServizioDemandeServicePeticiónServicio服务项目请求
    SLOT='Slot' # SlotSlot槽位Hueco / Zocalo / Espacio
    SPECIMEN='Specimen' # SpecimenCampioneSpécimen标本Especimen
    SPECIMEN_DEFINITION='SpecimenDefinition' # SpecimenDefinitionDefinizioneCampioneDefinicionDeEspecimen标本定义
    STRUCTURE_DEFINITION='StructureDefinition' # StructureDefinitionDefinizioneStrutturaDéfinitionStructureDefinicionDeEstructura结构定义
    STRUCTURE_MAP='StructureMap' # StructureMapMapaDeEstructura结构映射
    SUBSCRIPTION='Subscription' # SubscriptionSottoscrizioneSouscription订阅Suscripción
    SUBSCRIPTION_STATUS='SubscriptionStatus' # SubscriptionStatus
    SUBSCRIPTION_TOPIC='SubscriptionTopic' # SubscriptionTopic
    SUBSTANCE='Substance' # SubstanceSostanzaSubstance物质Sustancia
    SUBSTANCE_DEFINITION='SubstanceDefinition' # SubstanceDefinition
    SUPPLY_DELIVERY='SupplyDelivery' # SupplyDeliverySupply Livraison供应交付Entrega de Suministro
    SUPPLY_REQUEST='SupplyRequest' # SupplyRequestDemande d'approvisionnement供应请求Solicitud de Suministro
    TASK='Task' # TaskTarea任务
    TERMINOLOGY_CAPABILITIES='TerminologyCapabilities' # TerminologyCapabilitiesCapacidadTerminologica术语服务能力
    TEST_REPORT='TestReport' # TestReportRapportTestReporteDePrueba测试报告
    TEST_SCRIPT='TestScript' # TestScriptScriptTestScriptDePrueba测试脚本
    VALUE_SET='ValueSet' # ValueSetEnsembleValeurs取值集合ConjuntoValores / ConjuntoDeValores
    VERIFICATION_RESULT='VerificationResult' # VerificationResult
    VISION_PRESCRIPTION='VisionPrescription' # VisionPrescriptionPrescriptionVisionPrescripcionDeVision视力处方
    PARAMETERS='Parameters' # ParametersParametros参数


class ResourceVersionPolicyEnum(str, Enum):
    NOVERSION='no-version' # No VersionId Support
    VERSIONED='versioned' # Versioned
    VERSIONEDUPDATE='versioned-update' # VersionId tracked fully


class ResponseTypeEnum(str, Enum):
    OK='ok' # OK
    TRANSIENTERROR='transient-error' # Transient Error
    FATALERROR='fatal-error' # Fatal Error


class RestfulCapabilityModeEnum(str, Enum):
    CLIENT='client' # Client
    SERVER='server' # Server


class SPDXLicenseEnum(str, Enum):
    NOTOPENSOURCE='not-open-source' # Not open source
    _0_BSD='0BSD' # BSD Zero Clause License
    AAL='AAL' # Attribution Assurance License
    ABSTYLES='Abstyles' # Abstyles License
    ADOBE_2006='Adobe-2006' # Adobe Systems Incorporated Source Code License Agreement
    ADOBE_GLYPH='Adobe-Glyph' # Adobe Glyph List License
    ADSL='ADSL' # Amazon Digital Services License
    AFL_1_1='AFL-1.1' # Academic Free License v1.1
    AFL_1_2='AFL-1.2' # Academic Free License v1.2
    AFL_2_0='AFL-2.0' # Academic Free License v2.0
    AFL_2_1='AFL-2.1' # Academic Free License v2.1
    AFL_3_0='AFL-3.0' # Academic Free License v3.0
    AFMPARSE='Afmparse' # Afmparse License
    AGPL_1_0ONLY='AGPL-1.0-only' # Affero General Public License v1.0 only
    AGPL_1_0ORLATER='AGPL-1.0-or-later' # Affero General Public License v1.0 or later
    AGPL_3_0ONLY='AGPL-3.0-only' # GNU Affero General Public License v3.0 only
    AGPL_3_0ORLATER='AGPL-3.0-or-later' # GNU Affero General Public License v3.0 or later
    ALADDIN='Aladdin' # Aladdin Free Public License
    AMDPLPA='AMDPLPA' # AMD's plpa_map.c License
    AML='AML' # Apple MIT License
    AMPAS='AMPAS' # Academy of Motion Picture Arts and Sciences BSD
    ANTLRPD='ANTLR-PD' # ANTLR Software Rights Notice
    APACHE_1_0='Apache-1.0' # Apache License 1.0
    APACHE_1_1='Apache-1.1' # Apache License 1.1
    APACHE_2_0='Apache-2.0' # Apache License 2.0
    APAFML='APAFML' # Adobe Postscript AFM License
    APL_1_0='APL-1.0' # Adaptive Public License 1.0
    APSL_1_0='APSL-1.0' # Apple Public Source License 1.0
    APSL_1_1='APSL-1.1' # Apple Public Source License 1.1
    APSL_1_2='APSL-1.2' # Apple Public Source License 1.2
    APSL_2_0='APSL-2.0' # Apple Public Source License 2.0
    ARTISTIC_1_0CL_8='Artistic-1.0-cl8' # Artistic License 1.0 w/clause 8
    ARTISTIC_1_0_PERL='Artistic-1.0-Perl' # Artistic License 1.0 (Perl)
    ARTISTIC_1_0='Artistic-1.0' # Artistic License 1.0
    ARTISTIC_2_0='Artistic-2.0' # Artistic License 2.0
    BAHYPH='Bahyph' # Bahyph License
    BARR='Barr' # Barr License
    BEERWARE='Beerware' # Beerware License
    BIT_TORRENT_1_0='BitTorrent-1.0' # BitTorrent Open Source License v1.0
    BIT_TORRENT_1_1='BitTorrent-1.1' # BitTorrent Open Source License v1.1
    BORCEUX='Borceux' # Borceux license
    BSD_1_CLAUSE='BSD-1-Clause' # BSD 1-Clause License
    BSD_2_CLAUSE_FREE_BSD='BSD-2-Clause-FreeBSD' # BSD 2-Clause FreeBSD License
    BSD_2_CLAUSE_NET_BSD='BSD-2-Clause-NetBSD' # BSD 2-Clause NetBSD License
    BSD_2_CLAUSE_PATENT='BSD-2-Clause-Patent' # BSD-2-Clause Plus Patent License
    BSD_2_CLAUSE='BSD-2-Clause' # BSD 2-Clause "Simplified" License
    BSD_3_CLAUSE_ATTRIBUTION='BSD-3-Clause-Attribution' # BSD with attribution
    BSD_3_CLAUSE_CLEAR='BSD-3-Clause-Clear' # BSD 3-Clause Clear License
    BSD_3_CLAUSELBNL='BSD-3-Clause-LBNL' # Lawrence Berkeley National Labs BSD variant license
    BSD_3_CLAUSE_NO_NUCLEAR_LICENSE_2014='BSD-3-Clause-No-Nuclear-License-2014' # BSD 3-Clause No Nuclear License 2014
    BSD_3_CLAUSE_NO_NUCLEAR_LICENSE='BSD-3-Clause-No-Nuclear-License' # BSD 3-Clause No Nuclear License
    BSD_3_CLAUSE_NO_NUCLEAR_WARRANTY='BSD-3-Clause-No-Nuclear-Warranty' # BSD 3-Clause No Nuclear Warranty
    BSD_3_CLAUSE='BSD-3-Clause' # BSD 3-Clause "New" or "Revised" License
    BSD_4_CLAUSEUC='BSD-4-Clause-UC' # BSD-4-Clause (University of California-Specific)
    BSD_4_CLAUSE='BSD-4-Clause' # BSD 4-Clause "Original" or "Old" License
    BSD_PROTECTION='BSD-Protection' # BSD Protection License
    BSD_SOURCE_CODE='BSD-Source-Code' # BSD Source Code Attribution
    BSL_1_0='BSL-1.0' # Boost Software License 1.0
    BZIP_2_1_0_5='bzip2-1.0.5' # bzip2 and libbzip2 License v1.0.5
    BZIP_2_1_0_6='bzip2-1.0.6' # bzip2 and libbzip2 License v1.0.6
    CALDERA='Caldera' # Caldera License
    CATOSL_1_1='CATOSL-1.1' # Computer Associates Trusted Open Source License 1.1
    CCBY_1_0='CC-BY-1.0' # Creative Commons Attribution 1.0 Generic
    CCBY_2_0='CC-BY-2.0' # Creative Commons Attribution 2.0 Generic
    CCBY_2_5='CC-BY-2.5' # Creative Commons Attribution 2.5 Generic
    CCBY_3_0='CC-BY-3.0' # Creative Commons Attribution 3.0 Unported
    CCBY_4_0='CC-BY-4.0' # Creative Commons Attribution 4.0 International
    CCBYNC_1_0='CC-BY-NC-1.0' # Creative Commons Attribution Non Commercial 1.0 Generic
    CCBYNC_2_0='CC-BY-NC-2.0' # Creative Commons Attribution Non Commercial 2.0 Generic
    CCBYNC_2_5='CC-BY-NC-2.5' # Creative Commons Attribution Non Commercial 2.5 Generic
    CCBYNC_3_0='CC-BY-NC-3.0' # Creative Commons Attribution Non Commercial 3.0 Unported
    CCBYNC_4_0='CC-BY-NC-4.0' # Creative Commons Attribution Non Commercial 4.0 International
    CCBYNCND_1_0='CC-BY-NC-ND-1.0' # Creative Commons Attribution Non Commercial No Derivatives 1.0 Generic
    CCBYNCND_2_0='CC-BY-NC-ND-2.0' # Creative Commons Attribution Non Commercial No Derivatives 2.0 Generic
    CCBYNCND_2_5='CC-BY-NC-ND-2.5' # Creative Commons Attribution Non Commercial No Derivatives 2.5 Generic
    CCBYNCND_3_0='CC-BY-NC-ND-3.0' # Creative Commons Attribution Non Commercial No Derivatives 3.0 Unported
    CCBYNCND_4_0='CC-BY-NC-ND-4.0' # Creative Commons Attribution Non Commercial No Derivatives 4.0 International
    CCBYNCSA_1_0='CC-BY-NC-SA-1.0' # Creative Commons Attribution Non Commercial Share Alike 1.0 Generic
    CCBYNCSA_2_0='CC-BY-NC-SA-2.0' # Creative Commons Attribution Non Commercial Share Alike 2.0 Generic
    CCBYNCSA_2_5='CC-BY-NC-SA-2.5' # Creative Commons Attribution Non Commercial Share Alike 2.5 Generic
    CCBYNCSA_3_0='CC-BY-NC-SA-3.0' # Creative Commons Attribution Non Commercial Share Alike 3.0 Unported
    CCBYNCSA_4_0='CC-BY-NC-SA-4.0' # Creative Commons Attribution Non Commercial Share Alike 4.0 International
    CCBYND_1_0='CC-BY-ND-1.0' # Creative Commons Attribution No Derivatives 1.0 Generic
    CCBYND_2_0='CC-BY-ND-2.0' # Creative Commons Attribution No Derivatives 2.0 Generic
    CCBYND_2_5='CC-BY-ND-2.5' # Creative Commons Attribution No Derivatives 2.5 Generic
    CCBYND_3_0='CC-BY-ND-3.0' # Creative Commons Attribution No Derivatives 3.0 Unported
    CCBYND_4_0='CC-BY-ND-4.0' # Creative Commons Attribution No Derivatives 4.0 International
    CCBYSA_1_0='CC-BY-SA-1.0' # Creative Commons Attribution Share Alike 1.0 Generic
    CCBYSA_2_0='CC-BY-SA-2.0' # Creative Commons Attribution Share Alike 2.0 Generic
    CCBYSA_2_5='CC-BY-SA-2.5' # Creative Commons Attribution Share Alike 2.5 Generic
    CCBYSA_3_0='CC-BY-SA-3.0' # Creative Commons Attribution Share Alike 3.0 Unported
    CCBYSA_4_0='CC-BY-SA-4.0' # Creative Commons Attribution Share Alike 4.0 International
    CC_0_1_0='CC0-1.0' # Creative Commons Zero v1.0 Universal
    CDDL_1_0='CDDL-1.0' # Common Development and Distribution License 1.0
    CDDL_1_1='CDDL-1.1' # Common Development and Distribution License 1.1
    CDLA_PERMISSIVE_1_0='CDLA-Permissive-1.0' # Community Data License Agreement Permissive 1.0
    CDLA_SHARING_1_0='CDLA-Sharing-1.0' # Community Data License Agreement Sharing 1.0
    CECILL_1_0='CECILL-1.0' # CeCILL Free Software License Agreement v1.0
    CECILL_1_1='CECILL-1.1' # CeCILL Free Software License Agreement v1.1
    CECILL_2_0='CECILL-2.0' # CeCILL Free Software License Agreement v2.0
    CECILL_2_1='CECILL-2.1' # CeCILL Free Software License Agreement v2.1
    CECILLB='CECILL-B' # CeCILL-B Free Software License Agreement
    CECILLC='CECILL-C' # CeCILL-C Free Software License Agreement
    CL_ARTISTIC='ClArtistic' # Clarified Artistic License
    CNRI_JYTHON='CNRI-Jython' # CNRI Jython License
    CNRI_PYTHONGPL_COMPATIBLE='CNRI-Python-GPL-Compatible' # CNRI Python Open Source GPL Compatible License Agreement
    CNRI_PYTHON='CNRI-Python' # CNRI Python License
    CONDOR_1_1='Condor-1.1' # Condor Public License v1.1
    CPAL_1_0='CPAL-1.0' # Common Public Attribution License 1.0
    CPL_1_0='CPL-1.0' # Common Public License 1.0
    CPOL_1_02='CPOL-1.02' # Code Project Open License 1.02
    CROSSWORD='Crossword' # Crossword License
    CRYSTAL_STACKER='CrystalStacker' # CrystalStacker License
    CUAOPL_1_0='CUA-OPL-1.0' # CUA Office Public License v1.0
    CUBE='Cube' # Cube License
    CURL='curl' # curl License
    DFSL_1_0='D-FSL-1.0' # Deutsche Freie Software Lizenz
    DIFFMARK='diffmark' # diffmark license
    DOC='DOC' # DOC License
    DOTSEQN='Dotseqn' # Dotseqn License
    DSDP='DSDP' # DSDP License
    DVIPDFM='dvipdfm' # dvipdfm License
    ECL_1_0='ECL-1.0' # Educational Community License v1.0
    ECL_2_0='ECL-2.0' # Educational Community License v2.0
    EFL_1_0='EFL-1.0' # Eiffel Forum License v1.0
    EFL_2_0='EFL-2.0' # Eiffel Forum License v2.0
    E_GENIX='eGenix' # eGenix.com Public License 1.1.0
    ENTESSA='Entessa' # Entessa Public License v1.0
    EPL_1_0='EPL-1.0' # Eclipse Public License 1.0
    EPL_2_0='EPL-2.0' # Eclipse Public License 2.0
    ERL_PL_1_1='ErlPL-1.1' # Erlang Public License v1.1
    EU_DATAGRID='EUDatagrid' # EU DataGrid Software License
    EUPL_1_0='EUPL-1.0' # European Union Public License 1.0
    EUPL_1_1='EUPL-1.1' # European Union Public License 1.1
    EUPL_1_2='EUPL-1.2' # European Union Public License 1.2
    EUROSYM='Eurosym' # Eurosym License
    FAIR='Fair' # Fair License
    FRAMEWORX_1_0='Frameworx-1.0' # Frameworx Open License 1.0
    FREE_IMAGE='FreeImage' # FreeImage Public License v1.0
    FSFAP='FSFAP' # FSF All Permissive License
    FSFUL='FSFUL' # FSF Unlimited License
    FSFULLR='FSFULLR' # FSF Unlimited License (with License Retention)
    FTL='FTL' # Freetype Project License
    GFDL_1_1ONLY='GFDL-1.1-only' # GNU Free Documentation License v1.1 only
    GFDL_1_1ORLATER='GFDL-1.1-or-later' # GNU Free Documentation License v1.1 or later
    GFDL_1_2ONLY='GFDL-1.2-only' # GNU Free Documentation License v1.2 only
    GFDL_1_2ORLATER='GFDL-1.2-or-later' # GNU Free Documentation License v1.2 or later
    GFDL_1_3ONLY='GFDL-1.3-only' # GNU Free Documentation License v1.3 only
    GFDL_1_3ORLATER='GFDL-1.3-or-later' # GNU Free Documentation License v1.3 or later
    GIFTWARE='Giftware' # Giftware License
    GL_2_PS='GL2PS' # GL2PS License
    GLIDE='Glide' # 3dfx Glide License
    GLULXE='Glulxe' # Glulxe License
    GNUPLOT='gnuplot' # gnuplot License
    GPL_1_0ONLY='GPL-1.0-only' # GNU General Public License v1.0 only
    GPL_1_0ORLATER='GPL-1.0-or-later' # GNU General Public License v1.0 or later
    GPL_2_0ONLY='GPL-2.0-only' # GNU General Public License v2.0 only
    GPL_2_0ORLATER='GPL-2.0-or-later' # GNU General Public License v2.0 or later
    GPL_3_0ONLY='GPL-3.0-only' # GNU General Public License v3.0 only
    GPL_3_0ORLATER='GPL-3.0-or-later' # GNU General Public License v3.0 or later
    G_SOAP_1_3_B='gSOAP-1.3b' # gSOAP Public License v1.3b
    HASKELL_REPORT='HaskellReport' # Haskell Language Report License
    HPND='HPND' # Historical Permission Notice and Disclaimer
    IBMPIBS='IBM-pibs' # IBM PowerPC Initialization and Boot Software
    ICU='ICU' # ICU License
    IJG='IJG' # Independent JPEG Group License
    IMAGE_MAGICK='ImageMagick' # ImageMagick License
    I_MATIX='iMatix' # iMatix Standard Function Library Agreement
    IMLIB_2='Imlib2' # Imlib2 License
    INFOZIP='Info-ZIP' # Info-ZIP License
    INTELACPI='Intel-ACPI' # Intel ACPI Software License Agreement
    INTEL='Intel' # Intel Open Source License
    INTERBASE_1_0='Interbase-1.0' # Interbase Public License v1.0
    IPA='IPA' # IPA Font License
    IPL_1_0='IPL-1.0' # IBM Public License v1.0
    ISC='ISC' # ISC License
    JAS_PER_2_0='JasPer-2.0' # JasPer License
    JSON='JSON' # JSON License
    LAL_1_2='LAL-1.2' # Licence Art Libre 1.2
    LAL_1_3='LAL-1.3' # Licence Art Libre 1.3
    LATEX_2_E='Latex2e' # Latex2e License
    LEPTONICA='Leptonica' # Leptonica License
    LGPL_2_0ONLY='LGPL-2.0-only' # GNU Library General Public License v2 only
    LGPL_2_0ORLATER='LGPL-2.0-or-later' # GNU Library General Public License v2 or later
    LGPL_2_1ONLY='LGPL-2.1-only' # GNU Lesser General Public License v2.1 only
    LGPL_2_1ORLATER='LGPL-2.1-or-later' # GNU Lesser General Public License v2.1 or later
    LGPL_3_0ONLY='LGPL-3.0-only' # GNU Lesser General Public License v3.0 only
    LGPL_3_0ORLATER='LGPL-3.0-or-later' # GNU Lesser General Public License v3.0 or later
    LGPLLR='LGPLLR' # Lesser General Public License For Linguistic Resources
    LIBPNG='Libpng' # libpng License
    LIBTIFF='libtiff' # libtiff License
    LI_LI_QP_1_1='LiLiQ-P-1.1' # Licence Libre du Québec – Permissive version 1.1
    LI_LI_QR_1_1='LiLiQ-R-1.1' # Licence Libre du Québec – Réciprocité version 1.1
    LI_LI_Q_RPLUS_1_1='LiLiQ-Rplus-1.1' # Licence Libre du Québec – Réciprocité forte version 1.1
    LINUX_OPEN_IB='Linux-OpenIB' # Linux Kernel Variant of OpenIB.org license
    LPL_1_0='LPL-1.0' # Lucent Public License Version 1.0
    LPL_1_02='LPL-1.02' # Lucent Public License v1.02
    LPPL_1_0='LPPL-1.0' # LaTeX Project Public License v1.0
    LPPL_1_1='LPPL-1.1' # LaTeX Project Public License v1.1
    LPPL_1_2='LPPL-1.2' # LaTeX Project Public License v1.2
    LPPL_1_3_A='LPPL-1.3a' # LaTeX Project Public License v1.3a
    LPPL_1_3_C='LPPL-1.3c' # LaTeX Project Public License v1.3c
    MAKE_INDEX='MakeIndex' # MakeIndex License
    MIR_OS='MirOS' # MirOS License
    MIT_0='MIT-0' # MIT No Attribution
    MITADVERTISING='MIT-advertising' # Enlightenment License (e16)
    MITCMU='MIT-CMU' # CMU License
    MITENNA='MIT-enna' # enna License
    MITFEH='MIT-feh' # feh License
    MIT='MIT' # MIT License
    MITNFA='MITNFA' # MIT +no-false-attribs license
    MOTOSOTO='Motosoto' # Motosoto License
    MPICH_2='mpich2' # mpich2 License
    MPL_1_0='MPL-1.0' # Mozilla Public License 1.0
    MPL_1_1='MPL-1.1' # Mozilla Public License 1.1
    MPL_2_0NOCOPYLEFTEXCEPTION='MPL-2.0-no-copyleft-exception' # Mozilla Public License 2.0 (no copyleft exception)
    MPL_2_0='MPL-2.0' # Mozilla Public License 2.0
    MSPL='MS-PL' # Microsoft Public License
    MSRL='MS-RL' # Microsoft Reciprocal License
    MTLL='MTLL' # Matrix Template Library License
    MULTICS='Multics' # Multics License
    MUP='Mup' # Mup License
    NASA_1_3='NASA-1.3' # NASA Open Source Agreement 1.3
    NAUMEN='Naumen' # Naumen Public License
    NBPL_1_0='NBPL-1.0' # Net Boolean Public License v1
    NCSA='NCSA' # University of Illinois/NCSA Open Source License
    NETSNMP='Net-SNMP' # Net-SNMP License
    NET_CDF='NetCDF' # NetCDF license
    NEWSLETR='Newsletr' # Newsletr License
    NGPL='NGPL' # Nethack General Public License
    NLOD_1_0='NLOD-1.0' # Norwegian Licence for Open Government Data
    NLPL='NLPL' # No Limit Public License
    NOKIA='Nokia' # Nokia Open Source License
    NOSL='NOSL' # Netizen Open Source License
    NOWEB='Noweb' # Noweb License
    NPL_1_0='NPL-1.0' # Netscape Public License v1.0
    NPL_1_1='NPL-1.1' # Netscape Public License v1.1
    NPOSL_3_0='NPOSL-3.0' # Non-Profit Open Software License 3.0
    NRL='NRL' # NRL License
    NTP='NTP' # NTP License
    OCCTPL='OCCT-PL' # Open CASCADE Technology Public License
    OCLC_2_0='OCLC-2.0' # OCLC Research Public License 2.0
    O_DB_L_1_0='ODbL-1.0' # ODC Open Database License v1.0
    OFL_1_0='OFL-1.0' # SIL Open Font License 1.0
    OFL_1_1='OFL-1.1' # SIL Open Font License 1.1
    OGTSL='OGTSL' # Open Group Test Suite License
    OLDAP_1_1='OLDAP-1.1' # Open LDAP Public License v1.1
    OLDAP_1_2='OLDAP-1.2' # Open LDAP Public License v1.2
    OLDAP_1_3='OLDAP-1.3' # Open LDAP Public License v1.3
    OLDAP_1_4='OLDAP-1.4' # Open LDAP Public License v1.4
    OLDAP_2_0_1='OLDAP-2.0.1' # Open LDAP Public License v2.0.1
    OLDAP_2_0='OLDAP-2.0' # Open LDAP Public License v2.0 (or possibly 2.0A and 2.0B)
    OLDAP_2_1='OLDAP-2.1' # Open LDAP Public License v2.1
    OLDAP_2_2_1='OLDAP-2.2.1' # Open LDAP Public License v2.2.1
    OLDAP_2_2_2='OLDAP-2.2.2' # Open LDAP Public License 2.2.2
    OLDAP_2_2='OLDAP-2.2' # Open LDAP Public License v2.2
    OLDAP_2_3='OLDAP-2.3' # Open LDAP Public License v2.3
    OLDAP_2_4='OLDAP-2.4' # Open LDAP Public License v2.4
    OLDAP_2_5='OLDAP-2.5' # Open LDAP Public License v2.5
    OLDAP_2_6='OLDAP-2.6' # Open LDAP Public License v2.6
    OLDAP_2_7='OLDAP-2.7' # Open LDAP Public License v2.7
    OLDAP_2_8='OLDAP-2.8' # Open LDAP Public License v2.8
    OML='OML' # Open Market License
    OPEN_SSL='OpenSSL' # OpenSSL License
    OPL_1_0='OPL-1.0' # Open Public License v1.0
    OSETPL_2_1='OSET-PL-2.1' # OSET Public License version 2.1
    OSL_1_0='OSL-1.0' # Open Software License 1.0
    OSL_1_1='OSL-1.1' # Open Software License 1.1
    OSL_2_0='OSL-2.0' # Open Software License 2.0
    OSL_2_1='OSL-2.1' # Open Software License 2.1
    OSL_3_0='OSL-3.0' # Open Software License 3.0
    PDDL_1_0='PDDL-1.0' # ODC Public Domain Dedication & License 1.0
    PHP_3_0='PHP-3.0' # PHP License v3.0
    PHP_3_01='PHP-3.01' # PHP License v3.01
    PLEXUS='Plexus' # Plexus Classworlds License
    POSTGRE_SQL='PostgreSQL' # PostgreSQL License
    PSFRAG='psfrag' # psfrag License
    PSUTILS='psutils' # psutils License
    PYTHON_2_0='Python-2.0' # Python License 2.0
    QHULL='Qhull' # Qhull License
    QPL_1_0='QPL-1.0' # Q Public License 1.0
    RDISC='Rdisc' # Rdisc License
    R_HE_COS_1_1='RHeCos-1.1' # Red Hat eCos Public License v1.1
    RPL_1_1='RPL-1.1' # Reciprocal Public License 1.1
    RPL_1_5='RPL-1.5' # Reciprocal Public License 1.5
    RPSL_1_0='RPSL-1.0' # RealNetworks Public Source License v1.0
    RSAMD='RSA-MD' # RSA Message-Digest License
    RSCPL='RSCPL' # Ricoh Source Code Public License
    RUBY='Ruby' # Ruby License
    SAXPD='SAX-PD' # Sax Public Domain Notice
    SAXPATH='Saxpath' # Saxpath License
    SCEA='SCEA' # SCEA Shared Source License
    SENDMAIL='Sendmail' # Sendmail License
    SGIB_1_0='SGI-B-1.0' # SGI Free Software License B v1.0
    SGIB_1_1='SGI-B-1.1' # SGI Free Software License B v1.1
    SGIB_2_0='SGI-B-2.0' # SGI Free Software License B v2.0
    SIM_PL_2_0='SimPL-2.0' # Simple Public License 2.0
    SISSL_1_2='SISSL-1.2' # Sun Industry Standards Source License v1.2
    SISSL='SISSL' # Sun Industry Standards Source License v1.1
    SLEEPYCAT='Sleepycat' # Sleepycat License
    SMLNJ='SMLNJ' # Standard ML of New Jersey License
    SMPPL='SMPPL' # Secure Messaging Protocol Public License
    SNIA='SNIA' # SNIA Public License 1.1
    SPENCER_86='Spencer-86' # Spencer License 86
    SPENCER_94='Spencer-94' # Spencer License 94
    SPENCER_99='Spencer-99' # Spencer License 99
    SPL_1_0='SPL-1.0' # Sun Public License v1.0
    SUGAR_CRM_1_1_3='SugarCRM-1.1.3' # SugarCRM Public License v1.1.3
    SWL='SWL' # Scheme Widget Library (SWL) Software License Agreement
    TCL='TCL' # TCL/TK License
    TCPWRAPPERS='TCP-wrappers' # TCP Wrappers License
    T_MATE='TMate' # TMate Open Source License
    TORQUE_1_1='TORQUE-1.1' # TORQUE v2.5+ Software License v1.1
    TOSL='TOSL' # Trusster Open Source License
    UNICODEDFS_2015='Unicode-DFS-2015' # Unicode License Agreement - Data Files and Software (2015)
    UNICODEDFS_2016='Unicode-DFS-2016' # Unicode License Agreement - Data Files and Software (2016)
    UNICODETOU='Unicode-TOU' # Unicode Terms of Use
    UNLICENSE='Unlicense' # The Unlicense
    UPL_1_0='UPL-1.0' # Universal Permissive License v1.0
    VIM='Vim' # Vim License
    VOSTROM='VOSTROM' # VOSTROM Public License for Open Source
    VSL_1_0='VSL-1.0' # Vovida Software License v1.0
    W_3_C_19980720='W3C-19980720' # W3C Software Notice and License (1998-07-20)
    W_3_C_20150513='W3C-20150513' # W3C Software Notice and Document License (2015-05-13)
    W_3_C='W3C' # W3C Software Notice and License (2002-12-31)
    WATCOM_1_0='Watcom-1.0' # Sybase Open Watcom Public License 1.0
    WSUIPA='Wsuipa' # Wsuipa License
    WTFPL='WTFPL' # Do What The F*ck You Want To Public License
    X_11='X11' # X11 License
    XEROX='Xerox' # Xerox License
    X_FREE_86_1_1='XFree86-1.1' # XFree86 License 1.1
    XINETD='xinetd' # xinetd License
    XNET='Xnet' # X.Net License
    XPP='xpp' # XPP License
    X_SKAT='XSkat' # XSkat License
    YPL_1_0='YPL-1.0' # Yahoo! Public License v1.0
    YPL_1_1='YPL-1.1' # Yahoo! Public License v1.1
    ZED='Zed' # Zed License
    ZEND_2_0='Zend-2.0' # Zend License v2.0
    ZIMBRA_1_3='Zimbra-1.3' # Zimbra Public License v1.3
    ZIMBRA_1_4='Zimbra-1.4' # Zimbra Public License v1.4
    ZLIBACKNOWLEDGEMENT='zlib-acknowledgement' # zlib/libpng License with Acknowledgement
    ZLIB='Zlib' # zlib License
    ZPL_1_1='ZPL-1.1' # Zope Public License 1.1
    ZPL_2_0='ZPL-2.0' # Zope Public License 2.0
    ZPL_2_1='ZPL-2.1' # Zope Public License 2.1


class Scope(str, Enum):
    """Scope --
    Scope is simpler than headers attribute for common tables
    
    """
    ROW='row'
    COL='col'
    ROWGROUP='rowgroup'
    COLGROUP='colgroup'


class SearchComparatorEnum(str, Enum):
    EQ='eq' # Equals
    NE='ne' # Not Equals
    GT='gt' # Greater Than
    LT='lt' # Less Than
    GE='ge' # Greater or Equals
    LE='le' # Less of Equal
    SA='sa' # Starts After
    EB='eb' # Ends Before
    AP='ap' # Approximately


class SearchEntryModeEnum(str, Enum):
    MATCH='match' # Match
    INCLUDE='include' # Include
    OUTCOME='outcome' # Outcome


class SearchModifierCodeEnum(str, Enum):
    MISSING='missing' # Missing
    EXACT='exact' # Exact
    CONTAINS='contains' # Contains
    NOT='not' # Not
    TEXT='text' # Text
    IN='in' # In
    NOTIN='not-in' # Not In
    BELOW='below' # Below
    ABOVE='above' # Above
    TYPE='type' # Type
    IDENTIFIER='identifier' # Identifier
    OF_TYPE='ofType' # Of Type


class SearchParamTypeEnum(str, Enum):
    NUMBER='number' # Number
    DATE='date' # Date/DateTime
    STRING='string' # String
    TOKEN='token' # Token
    REFERENCE='reference' # Reference
    COMPOSITE='composite' # Composite
    QUANTITY='quantity' # Quantity
    URI='uri' # URI
    SPECIAL='special' # Special


class Shape(str, Enum):
    RECT='rect'
    CIRCLE='circle'
    POLY='poly'
    DEFAULT='default'


class SlicingRulesEnum(str, Enum):
    CLOSED='closed' # Closed
    OPEN='open' # Open
    OPEN_AT_END='openAtEnd' # Open at End


class SlotStatusEnum(str, Enum):
    BUSY='busy' # Busy
    FREE='free' # Free
    BUSYUNAVAILABLE='busy-unavailable' # Busy (Unavailable)
    BUSYTENTATIVE='busy-tentative' # Busy (Tentative)
    ENTEREDINERROR='entered-in-error' # Entered in error


class SortDirectionEnum(str, Enum):
    ASCENDING='ascending' # Ascending
    DESCENDING='descending' # Descending


class SpecimenContainedPreferenceEnum(str, Enum):
    PREFERRED='preferred' # Preferred
    ALTERNATE='alternate' # Alternate


class SpecimenStatusEnum(str, Enum):
    AVAILABLE='available' # Available
    UNAVAILABLE='unavailable' # Unavailable
    UNSATISFACTORY='unsatisfactory' # Unsatisfactory
    ENTEREDINERROR='entered-in-error' # Entered in Error


class StructureDefinitionKindEnum(str, Enum):
    PRIMITIVETYPE='primitive-type' # Primitive Data Type
    COMPLEXTYPE='complex-type' # Complex Data Type
    RESOURCE='resource' # Resource
    LOGICAL='logical' # Logical


class StructureMapContextTypeEnum(str, Enum):
    TYPE='type' # Type
    VARIABLE='variable' # Variable


class StructureMapGroupTypeModeEnum(str, Enum):
    NONE='none' # Not a Default
    TYPES='types' # Default for Type Combination
    TYPEANDTYPES='type-and-types' # Default for type + combination


class StructureMapInputModeEnum(str, Enum):
    SOURCE='source' # Source Instance
    TARGET='target' # Target Instance


class StructureMapModelModeEnum(str, Enum):
    SOURCE='source' # Source Structure Definition
    QUERIED='queried' # Queried Structure Definition
    TARGET='target' # Target Structure Definition
    PRODUCED='produced' # Produced Structure Definition


class StructureMapSourceListModeEnum(str, Enum):
    FIRST='first' # First
    NOT_FIRST='not_first' # All but the first
    LAST='last' # Last
    NOT_LAST='not_last' # All but the last
    ONLY_ONE='only_one' # Enforce only one


class StructureMapTargetListModeEnum(str, Enum):
    FIRST='first' # First
    SHARE='share' # Share
    LAST='last' # Last
    COLLATE='collate' # Collate


class StructureMapTransformEnum(str, Enum):
    CREATE='create' # create
    COPY='copy' # copy
    TRUNCATE='truncate' # truncate
    ESCAPE='escape' # escape
    CAST='cast' # cast
    APPEND='append' # append
    TRANSLATE='translate' # translate
    REFERENCE='reference' # reference
    DATE_OP='dateOp' # dateOp
    UUID='uuid' # uuid
    POINTER='pointer' # pointer
    EVALUATE='evaluate' # evaluate
    CC='cc' # cc
    C='c' # c
    QTY='qty' # qty
    ID='id' # id
    CP='cp' # cp


class SubscriptionChannelTypeEnum(str, Enum):
    RESTHOOK='rest-hook' # Rest Hook
    WEBSOCKET='websocket' # Websocket
    EMAIL='email' # Email
    SMS='sms' # SMS
    MESSAGE='message' # Message


class SubscriptionNotificationTypeEnum(str, Enum):
    HANDSHAKE='handshake' # Handshake
    HEARTBEAT='heartbeat' # Heartbeat
    EVENTNOTIFICATION='event-notification' # Event Notification
    QUERYSTATUS='query-status' # Query Status
    QUERYEVENT='query-event' # Query Event


class SubscriptionStatusCodesEnum(str, Enum):
    REQUESTED='requested' # Requested
    ACTIVE='active' # Active
    ERROR='error' # Error
    OFF='off' # Off


class SupplyDeliveryStatusEnum(str, Enum):
    INPROGRESS='in-progress' # In Progress
    COMPLETED='completed' # Delivered
    ABANDONED='abandoned' # Abandoned
    ENTEREDINERROR='entered-in-error' # Entered In Error


class SupplyRequestStatusEnum(str, Enum):
    DRAFT='draft' # Draft
    ACTIVE='active' # Active
    SUSPENDED='suspended' # Suspended
    CANCELLED='cancelled' # Cancelled
    COMPLETED='completed' # Completed
    ENTEREDINERROR='entered-in-error' # Entered in Error
    UNKNOWN='unknown' # Unknown


class SystemRestfulInteractionEnum(str, Enum):
    TRANSACTION='transaction' # transaction
    BATCH='batch' # batch
    SEARCHSYSTEM='search-system' # search-system
    HISTORYSYSTEM='history-system' # history-system


class TFrame(str, Enum):
    """TFrame --
    The border attribute sets the thickness of the frame around the
    table. The default units are screen pixels.
    The frame attribute specifies which parts of the frame around
    the table should be rendered. The values are not the same as
    CALS to avoid a name clash with the valign attribute.
    
    """
    VOID='void'
    ABOVE='above'
    BELOW='below'
    HSIDES='hsides'
    LHS='lhs'
    RHS='rhs'
    VSIDES='vsides'
    BOX='box'
    BORDER='border'


class TRules(str, Enum):
    """TRules --
    The rules attribute defines which rules to draw between cells:
    If rules is absent then assume:
    "none" if border is absent or border="0" otherwise "all"
    
    """
    NONE='none'
    GROUPS='groups'
    ROWS='rows'
    COLS='cols'
    ALL='all'


class TaskIntentEnum(str, Enum):
    UNKNOWN='unknown' # Unknown
    PROPOSAL='proposal' # Proposal
    PLAN='plan' # Plan
    ORDER='order' # Order
    ORIGINALORDER='original-order' # Original Order
    REFLEXORDER='reflex-order' # Reflex Order
    FILLERORDER='filler-order' # Filler Order
    INSTANCEORDER='instance-order' # Instance Order
    OPTION='option' # Option


class TaskStatusEnum(str, Enum):
    DRAFT='draft' # Draft
    REQUESTED='requested' # Requested
    RECEIVED='received' # Received
    ACCEPTED='accepted' # Accepted
    REJECTED='rejected' # Rejected
    READY='ready' # Ready
    CANCELLED='cancelled' # Cancelled
    INPROGRESS='in-progress' # In Progress
    ONHOLD='on-hold' # On Hold
    FAILED='failed' # Failed
    COMPLETED='completed' # Completed
    ENTEREDINERROR='entered-in-error' # Entered in Error


class TestReportActionResultEnum(str, Enum):
    PASS='pass' # Pass
    SKIP='skip' # Skip
    FAIL='fail' # Fail
    WARNING='warning' # Warning
    ERROR='error' # Error


class TestReportParticipantTypeEnum(str, Enum):
    TESTENGINE='test-engine' # Test Engine
    CLIENT='client' # Client
    SERVER='server' # Server


class TestReportResultEnum(str, Enum):
    PASS='pass' # Pass
    FAIL='fail' # Fail
    PENDING='pending' # Pending


class TestReportStatusEnum(str, Enum):
    COMPLETED='completed' # Completed
    INPROGRESS='in-progress' # In Progress
    WAITING='waiting' # Waiting
    STOPPED='stopped' # Stopped
    ENTEREDINERROR='entered-in-error' # Entered In Error


class TestScriptRequestMethodCodeEnum(str, Enum):
    DELETE='delete' # DELETE
    GET='get' # GET
    OPTIONS='options' # OPTIONS
    PATCH='patch' # PATCH
    POST='post' # POST
    PUT='put' # PUT
    HEAD='head' # HEAD


class TriggerTypeEnum(str, Enum):
    NAMEDEVENT='named-event' # Named Event
    PERIODIC='periodic' # Periodic
    DATACHANGED='data-changed' # Data Changed
    DATAADDED='data-added' # Data Added
    DATAMODIFIED='data-modified' # Data Updated
    DATAREMOVED='data-removed' # Data Removed
    DATAACCESSED='data-accessed' # Data Accessed
    DATAACCESSENDED='data-access-ended' # Data Access Ended


class TypeDerivationRuleEnum(str, Enum):
    SPECIALIZATION='specialization' # Specialization
    CONSTRAINT='constraint' # Constraint


class TypeRestfulInteractionEnum(str, Enum):
    READ='read' # read
    VREAD='vread' # vread
    UPDATE='update' # update
    PATCH='patch' # patch
    DELETE='delete' # delete
    HISTORYINSTANCE='history-instance' # history-instance
    HISTORYTYPE='history-type' # history-type
    CREATE='create' # create
    SEARCHTYPE='search-type' # search-type


class UDIEntryTypeEnum(str, Enum):
    BARCODE='barcode' # Barcode
    RFID='rfid' # RFID
    MANUAL='manual' # Manual
    CARD='card' # Card
    SELFREPORTED='self-reported' # Self Reported
    UNKNOWN='unknown' # Unknown


class UnitsOfTimeEnum(str, Enum):
    S='s' # 秒
    MIN='min' # 分钟
    H='h' # 小时
    D='d' # 天
    WK='wk' # 星期
    MO='mo' # 月
    A='a' # 年


class UseEnum(str, Enum):
    CLAIM='claim' # Claim
    PREAUTHORIZATION='preauthorization' # Preauthorization
    PREDETERMINATION='predetermination' # Predetermination


class VariableTypeEnum(str, Enum):
    DICHOTOMOUS='dichotomous' # Dichotomous
    CONTINUOUS='continuous' # Continuous
    DESCRIPTIVE='descriptive' # Descriptive


class VisionBaseEnum(str, Enum):
    UP='up' # Up
    DOWN='down' # Down
    IN='in' # In
    OUT='out' # Out


class VisionEyesEnum(str, Enum):
    RIGHT='right' # Right Eye
    LEFT='left' # Left Eye


class XPathUsageTypeEnum(str, Enum):
    NORMAL='normal' # Normal
    PHONETIC='phonetic' # Phonetic
    NEARBY='nearby' # Nearby
    DISTANCE='distance' # Distance
    OTHER='other' # Other


class alignType(str, Enum):
    LEFT='left'
    CENTER='center'
    RIGHT='right'
    JUSTIFY='justify'
    CHAR='char'


class dirType(str, Enum):
    LTR='ltr'
    RTL='rtl'


class dirType1(str, Enum):
    LTR='ltr'
    RTL='rtl'


class ismapType(str, Enum):
    ISMAP='ismap'


class medicationRequestIntentEnum(str, Enum):
    PROPOSAL='proposal' # Proposal
    PLAN='plan' # Plan
    ORDER='order' # Order
    ORIGINALORDER='original-order' # Original Order
    REFLEXORDER='reflex-order' # Reflex Order
    FILLERORDER='filler-order' # Filler Order
    INSTANCEORDER='instance-order' # Instance Order
    OPTION='option' # Option


class medicationrequestStatusEnum(str, Enum):
    ACTIVE='active' # Active
    ONHOLD='on-hold' # On Hold
    CANCELLED='cancelled' # Cancelled
    COMPLETED='completed' # Completed
    ENTEREDINERROR='entered-in-error' # Entered in Error
    STOPPED='stopped' # Stopped
    DRAFT='draft' # Draft
    UNKNOWN='unknown' # Unknown


class messageheaderResponseRequestEnum(str, Enum):
    ALWAYS='always' # Always
    ONERROR='on-error' # Error/reject conditions only
    NEVER='never' # Never
    ONSUCCESS='on-success' # Successful completion only


class nohrefType(str, Enum):
    NOHREF='nohref'


class orientationTypeEnum(str, Enum):
    SENSE='sense' # Sense orientation of referenceSeq
    ANTISENSE='antisense' # Antisense orientation of referenceSeq


class qualityTypeEnum(str, Enum):
    INDEL='indel' # INDEL Comparison
    SNP='snp' # SNP Comparison
    UNKNOWN='unknown' # UNKNOWN Comparison


class repositoryTypeEnum(str, Enum):
    DIRECTLINK='directlink' # Click and see
    OPENAPI='openapi' # The URL is the RESTful or other kind of API that can access to the result.
    LOGIN='login' # Result cannot be access unless an account is logged in
    OAUTH='oauth' # Result need to be fetched with API and need LOGIN( or cookies are required when visiting the link of resource)
    OTHER='other' # Some other complicated or particular way to get resource from URL.


class sequenceTypeEnum(str, Enum):
    AA='aa' # AA Sequence
    DNA='dna' # DNA Sequence
    RNA='rna' # RNA Sequence


class statusEnum(str, Enum):
    ATTESTED='attested' # Attested
    VALIDATED='validated' # Validated
    INPROCESS='in-process' # In process
    REQREVALID='req-revalid' # Requires revalidation
    VALFAIL='val-fail' # Validation failed
    REVALFAIL='reval-fail' # Re-Validation failed


class strandTypeEnum(str, Enum):
    WATSON='watson' # Watson strand of referenceSeq
    CRICK='crick' # Crick strand of referenceSeq


class valignType(str, Enum):
    TOP='top'
    MIDDLE='middle'
    BOTTOM='bottom'
    BASELINE='baseline'


#
# Start data representation classes
#
class ResourceContainer(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, Account: 'Account' = None, ActivityDefinition: 'ActivityDefinition' = None, AdministrableProductDefinition: 'AdministrableProductDefinition' = None, AdverseEvent: 'AdverseEvent' = None, AllergyIntolerance: 'AllergyIntolerance' = None, Appointment: 'Appointment' = None, AppointmentResponse: 'AppointmentResponse' = None, AuditEvent: 'AuditEvent' = None, Basic: 'Basic' = None, Binary: 'Binary' = None, BiologicallyDerivedProduct: 'BiologicallyDerivedProduct' = None, BodyStructure: 'BodyStructure' = None, Bundle: 'Bundle' = None, CapabilityStatement: 'CapabilityStatement' = None, CarePlan: 'CarePlan' = None, CareTeam: 'CareTeam' = None, CatalogEntry: 'CatalogEntry' = None, ChargeItem: 'ChargeItem' = None, ChargeItemDefinition: 'ChargeItemDefinition' = None, Citation: 'Citation' = None, Claim: 'Claim' = None, ClaimResponse: 'ClaimResponse' = None, ClinicalImpression: 'ClinicalImpression' = None, ClinicalUseDefinition: 'ClinicalUseDefinition' = None, CodeSystem: 'CodeSystem' = None, Communication: 'Communication' = None, CommunicationRequest: 'CommunicationRequest' = None, CompartmentDefinition: 'CompartmentDefinition' = None, Composition: 'Composition' = None, ConceptMap: 'ConceptMap' = None, Condition: 'Condition' = None, Consent: 'Consent' = None, Contract: 'Contract' = None, Coverage: 'Coverage' = None, CoverageEligibilityRequest: 'CoverageEligibilityRequest' = None, CoverageEligibilityResponse: 'CoverageEligibilityResponse' = None, DetectedIssue: 'DetectedIssue' = None, Device: 'Device' = None, DeviceDefinition: 'DeviceDefinition' = None, DeviceMetric: 'DeviceMetric' = None, DeviceRequest: 'DeviceRequest' = None, DeviceUseStatement: 'DeviceUseStatement' = None, DiagnosticReport: 'DiagnosticReport' = None, DocumentManifest: 'DocumentManifest' = None, DocumentReference: 'DocumentReference' = None, Encounter: 'Encounter' = None, Endpoint: 'Endpoint' = None, EnrollmentRequest: 'EnrollmentRequest' = None, EnrollmentResponse: 'EnrollmentResponse' = None, EpisodeOfCare: 'EpisodeOfCare' = None, EventDefinition: 'EventDefinition' = None, Evidence: 'Evidence' = None, EvidenceReport: 'EvidenceReport' = None, EvidenceVariable: 'EvidenceVariable' = None, ExampleScenario: 'ExampleScenario' = None, ExplanationOfBenefit: 'ExplanationOfBenefit' = None, FamilyMemberHistory: 'FamilyMemberHistory' = None, Flag: 'Flag' = None, Goal: 'Goal' = None, GraphDefinition: 'GraphDefinition' = None, Group: 'Group' = None, GuidanceResponse: 'GuidanceResponse' = None, HealthcareService: 'HealthcareService' = None, ImagingStudy: 'ImagingStudy' = None, Immunization: 'Immunization' = None, ImmunizationEvaluation: 'ImmunizationEvaluation' = None, ImmunizationRecommendation: 'ImmunizationRecommendation' = None, ImplementationGuide: 'ImplementationGuide' = None, Ingredient: 'Ingredient' = None, InsurancePlan: 'InsurancePlan' = None, Invoice: 'Invoice' = None, Library: 'Library' = None, Linkage: 'Linkage' = None, List: 'List' = None, Location: 'Location' = None, ManufacturedItemDefinition: 'ManufacturedItemDefinition' = None, Measure: 'Measure' = None, MeasureReport: 'MeasureReport' = None, Media: 'Media' = None, Medication: 'Medication' = None, MedicationAdministration: 'MedicationAdministration' = None, MedicationDispense: 'MedicationDispense' = None, MedicationKnowledge: 'MedicationKnowledge' = None, MedicationRequest: 'MedicationRequest' = None, MedicationStatement: 'MedicationStatement' = None, MedicinalProductDefinition: 'MedicinalProductDefinition' = None, MessageDefinition: 'MessageDefinition' = None, MessageHeader: 'MessageHeader' = None, MolecularSequence: 'MolecularSequence' = None, NamingSystem: 'NamingSystem' = None, NutritionOrder: 'NutritionOrder' = None, NutritionProduct: 'NutritionProduct' = None, Observation: 'Observation' = None, ObservationDefinition: 'ObservationDefinition' = None, OperationDefinition: 'OperationDefinition' = None, OperationOutcome: 'OperationOutcome' = None, Organization: 'Organization' = None, OrganizationAffiliation: 'OrganizationAffiliation' = None, PackagedProductDefinition: 'PackagedProductDefinition' = None, Patient: 'Patient' = None, PaymentNotice: 'PaymentNotice' = None, PaymentReconciliation: 'PaymentReconciliation' = None, Person: 'Person' = None, PlanDefinition: 'PlanDefinition' = None, Practitioner: 'Practitioner' = None, PractitionerRole: 'PractitionerRole' = None, Procedure: 'Procedure' = None, Provenance: 'Provenance' = None, Questionnaire: 'Questionnaire' = None, QuestionnaireResponse: 'QuestionnaireResponse' = None, RegulatedAuthorization: 'RegulatedAuthorization' = None, RelatedPerson: 'RelatedPerson' = None, RequestGroup: 'RequestGroup' = None, ResearchDefinition: 'ResearchDefinition' = None, ResearchElementDefinition: 'ResearchElementDefinition' = None, ResearchStudy: 'ResearchStudy' = None, ResearchSubject: 'ResearchSubject' = None, RiskAssessment: 'RiskAssessment' = None, Schedule: 'Schedule' = None, SearchParameter: 'SearchParameter' = None, ServiceRequest: 'ServiceRequest' = None, Slot: 'Slot' = None, Specimen: 'Specimen' = None, SpecimenDefinition: 'SpecimenDefinition' = None, StructureDefinition: 'StructureDefinition' = None, StructureMap: 'StructureMap' = None, Subscription: 'Subscription' = None, SubscriptionStatus: 'SubscriptionStatus' = None, SubscriptionTopic: 'SubscriptionTopic' = None, Substance: 'Substance' = None, SubstanceDefinition: 'SubstanceDefinition' = None, SupplyDelivery: 'SupplyDelivery' = None, SupplyRequest: 'SupplyRequest' = None, Task: 'Task' = None, TerminologyCapabilities: 'TerminologyCapabilities' = None, TestReport: 'TestReport' = None, TestScript: 'TestScript' = None, ValueSet: 'ValueSet' = None, VerificationResult: 'VerificationResult' = None, VisionPrescription: 'VisionPrescription' = None, Parameters: 'Parameters' = None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.Account = Account
        self.Account_nsprefix_ = None
        self.ActivityDefinition = ActivityDefinition
        self.ActivityDefinition_nsprefix_ = None
        self.AdministrableProductDefinition = AdministrableProductDefinition
        self.AdministrableProductDefinition_nsprefix_ = None
        self.AdverseEvent = AdverseEvent
        self.AdverseEvent_nsprefix_ = None
        self.AllergyIntolerance = AllergyIntolerance
        self.AllergyIntolerance_nsprefix_ = None
        self.Appointment = Appointment
        self.Appointment_nsprefix_ = None
        self.AppointmentResponse = AppointmentResponse
        self.AppointmentResponse_nsprefix_ = None
        self.AuditEvent = AuditEvent
        self.AuditEvent_nsprefix_ = None
        self.Basic = Basic
        self.Basic_nsprefix_ = None
        self.Binary = Binary
        self.Binary_nsprefix_ = None
        self.BiologicallyDerivedProduct = BiologicallyDerivedProduct
        self.BiologicallyDerivedProduct_nsprefix_ = None
        self.BodyStructure = BodyStructure
        self.BodyStructure_nsprefix_ = None
        self.Bundle = Bundle
        self.Bundle_nsprefix_ = None
        self.CapabilityStatement = CapabilityStatement
        self.CapabilityStatement_nsprefix_ = None
        self.CarePlan = CarePlan
        self.CarePlan_nsprefix_ = None
        self.CareTeam = CareTeam
        self.CareTeam_nsprefix_ = None
        self.CatalogEntry = CatalogEntry
        self.CatalogEntry_nsprefix_ = None
        self.ChargeItem = ChargeItem
        self.ChargeItem_nsprefix_ = None
        self.ChargeItemDefinition = ChargeItemDefinition
        self.ChargeItemDefinition_nsprefix_ = None
        self.Citation = Citation
        self.Citation_nsprefix_ = None
        self.Claim = Claim
        self.Claim_nsprefix_ = None
        self.ClaimResponse = ClaimResponse
        self.ClaimResponse_nsprefix_ = None
        self.ClinicalImpression = ClinicalImpression
        self.ClinicalImpression_nsprefix_ = None
        self.ClinicalUseDefinition = ClinicalUseDefinition
        self.ClinicalUseDefinition_nsprefix_ = None
        self.CodeSystem = CodeSystem
        self.CodeSystem_nsprefix_ = None
        self.Communication = Communication
        self.Communication_nsprefix_ = None
        self.CommunicationRequest = CommunicationRequest
        self.CommunicationRequest_nsprefix_ = None
        self.CompartmentDefinition = CompartmentDefinition
        self.CompartmentDefinition_nsprefix_ = None
        self.Composition = Composition
        self.Composition_nsprefix_ = None
        self.ConceptMap = ConceptMap
        self.ConceptMap_nsprefix_ = None
        self.Condition = Condition
        self.Condition_nsprefix_ = None
        self.Consent = Consent
        self.Consent_nsprefix_ = None
        self.Contract = Contract
        self.Contract_nsprefix_ = None
        self.Coverage = Coverage
        self.Coverage_nsprefix_ = None
        self.CoverageEligibilityRequest = CoverageEligibilityRequest
        self.CoverageEligibilityRequest_nsprefix_ = None
        self.CoverageEligibilityResponse = CoverageEligibilityResponse
        self.CoverageEligibilityResponse_nsprefix_ = None
        self.DetectedIssue = DetectedIssue
        self.DetectedIssue_nsprefix_ = None
        self.Device = Device
        self.Device_nsprefix_ = None
        self.DeviceDefinition = DeviceDefinition
        self.DeviceDefinition_nsprefix_ = None
        self.DeviceMetric = DeviceMetric
        self.DeviceMetric_nsprefix_ = None
        self.DeviceRequest = DeviceRequest
        self.DeviceRequest_nsprefix_ = None
        self.DeviceUseStatement = DeviceUseStatement
        self.DeviceUseStatement_nsprefix_ = None
        self.DiagnosticReport = DiagnosticReport
        self.DiagnosticReport_nsprefix_ = None
        self.DocumentManifest = DocumentManifest
        self.DocumentManifest_nsprefix_ = None
        self.DocumentReference = DocumentReference
        self.DocumentReference_nsprefix_ = None
        self.Encounter = Encounter
        self.Encounter_nsprefix_ = None
        self.Endpoint = Endpoint
        self.Endpoint_nsprefix_ = None
        self.EnrollmentRequest = EnrollmentRequest
        self.EnrollmentRequest_nsprefix_ = None
        self.EnrollmentResponse = EnrollmentResponse
        self.EnrollmentResponse_nsprefix_ = None
        self.EpisodeOfCare = EpisodeOfCare
        self.EpisodeOfCare_nsprefix_ = None
        self.EventDefinition = EventDefinition
        self.EventDefinition_nsprefix_ = None
        self.Evidence = Evidence
        self.Evidence_nsprefix_ = None
        self.EvidenceReport = EvidenceReport
        self.EvidenceReport_nsprefix_ = None
        self.EvidenceVariable = EvidenceVariable
        self.EvidenceVariable_nsprefix_ = None
        self.ExampleScenario = ExampleScenario
        self.ExampleScenario_nsprefix_ = None
        self.ExplanationOfBenefit = ExplanationOfBenefit
        self.ExplanationOfBenefit_nsprefix_ = None
        self.FamilyMemberHistory = FamilyMemberHistory
        self.FamilyMemberHistory_nsprefix_ = None
        self.Flag = Flag
        self.Flag_nsprefix_ = None
        self.Goal = Goal
        self.Goal_nsprefix_ = None
        self.GraphDefinition = GraphDefinition
        self.GraphDefinition_nsprefix_ = None
        self.Group = Group
        self.Group_nsprefix_ = None
        self.GuidanceResponse = GuidanceResponse
        self.GuidanceResponse_nsprefix_ = None
        self.HealthcareService = HealthcareService
        self.HealthcareService_nsprefix_ = None
        self.ImagingStudy = ImagingStudy
        self.ImagingStudy_nsprefix_ = None
        self.Immunization = Immunization
        self.Immunization_nsprefix_ = None
        self.ImmunizationEvaluation = ImmunizationEvaluation
        self.ImmunizationEvaluation_nsprefix_ = None
        self.ImmunizationRecommendation = ImmunizationRecommendation
        self.ImmunizationRecommendation_nsprefix_ = None
        self.ImplementationGuide = ImplementationGuide
        self.ImplementationGuide_nsprefix_ = None
        self.Ingredient = Ingredient
        self.Ingredient_nsprefix_ = None
        self.InsurancePlan = InsurancePlan
        self.InsurancePlan_nsprefix_ = None
        self.Invoice = Invoice
        self.Invoice_nsprefix_ = None
        self.Library = Library
        self.Library_nsprefix_ = None
        self.Linkage = Linkage
        self.Linkage_nsprefix_ = None
        self.List = List
        self.List_nsprefix_ = None
        self.Location = Location
        self.Location_nsprefix_ = None
        self.ManufacturedItemDefinition = ManufacturedItemDefinition
        self.ManufacturedItemDefinition_nsprefix_ = None
        self.Measure = Measure
        self.Measure_nsprefix_ = None
        self.MeasureReport = MeasureReport
        self.MeasureReport_nsprefix_ = None
        self.Media = Media
        self.Media_nsprefix_ = None
        self.Medication = Medication
        self.Medication_nsprefix_ = None
        self.MedicationAdministration = MedicationAdministration
        self.MedicationAdministration_nsprefix_ = None
        self.MedicationDispense = MedicationDispense
        self.MedicationDispense_nsprefix_ = None
        self.MedicationKnowledge = MedicationKnowledge
        self.MedicationKnowledge_nsprefix_ = None
        self.MedicationRequest = MedicationRequest
        self.MedicationRequest_nsprefix_ = None
        self.MedicationStatement = MedicationStatement
        self.MedicationStatement_nsprefix_ = None
        self.MedicinalProductDefinition = MedicinalProductDefinition
        self.MedicinalProductDefinition_nsprefix_ = None
        self.MessageDefinition = MessageDefinition
        self.MessageDefinition_nsprefix_ = None
        self.MessageHeader = MessageHeader
        self.MessageHeader_nsprefix_ = None
        self.MolecularSequence = MolecularSequence
        self.MolecularSequence_nsprefix_ = None
        self.NamingSystem = NamingSystem
        self.NamingSystem_nsprefix_ = None
        self.NutritionOrder = NutritionOrder
        self.NutritionOrder_nsprefix_ = None
        self.NutritionProduct = NutritionProduct
        self.NutritionProduct_nsprefix_ = None
        self.Observation = Observation
        self.Observation_nsprefix_ = None
        self.ObservationDefinition = ObservationDefinition
        self.ObservationDefinition_nsprefix_ = None
        self.OperationDefinition = OperationDefinition
        self.OperationDefinition_nsprefix_ = None
        self.OperationOutcome = OperationOutcome
        self.OperationOutcome_nsprefix_ = None
        self.Organization = Organization
        self.Organization_nsprefix_ = None
        self.OrganizationAffiliation = OrganizationAffiliation
        self.OrganizationAffiliation_nsprefix_ = None
        self.PackagedProductDefinition = PackagedProductDefinition
        self.PackagedProductDefinition_nsprefix_ = None
        self.Patient = Patient
        self.Patient_nsprefix_ = None
        self.PaymentNotice = PaymentNotice
        self.PaymentNotice_nsprefix_ = None
        self.PaymentReconciliation = PaymentReconciliation
        self.PaymentReconciliation_nsprefix_ = None
        self.Person = Person
        self.Person_nsprefix_ = None
        self.PlanDefinition = PlanDefinition
        self.PlanDefinition_nsprefix_ = None
        self.Practitioner = Practitioner
        self.Practitioner_nsprefix_ = None
        self.PractitionerRole = PractitionerRole
        self.PractitionerRole_nsprefix_ = None
        self.Procedure = Procedure
        self.Procedure_nsprefix_ = None
        self.Provenance = Provenance
        self.Provenance_nsprefix_ = None
        self.Questionnaire = Questionnaire
        self.Questionnaire_nsprefix_ = None
        self.QuestionnaireResponse = QuestionnaireResponse
        self.QuestionnaireResponse_nsprefix_ = None
        self.RegulatedAuthorization = RegulatedAuthorization
        self.RegulatedAuthorization_nsprefix_ = None
        self.RelatedPerson = RelatedPerson
        self.RelatedPerson_nsprefix_ = None
        self.RequestGroup = RequestGroup
        self.RequestGroup_nsprefix_ = None
        self.ResearchDefinition = ResearchDefinition
        self.ResearchDefinition_nsprefix_ = None
        self.ResearchElementDefinition = ResearchElementDefinition
        self.ResearchElementDefinition_nsprefix_ = None
        self.ResearchStudy = ResearchStudy
        self.ResearchStudy_nsprefix_ = None
        self.ResearchSubject = ResearchSubject
        self.ResearchSubject_nsprefix_ = None
        self.RiskAssessment = RiskAssessment
        self.RiskAssessment_nsprefix_ = None
        self.Schedule = Schedule
        self.Schedule_nsprefix_ = None
        self.SearchParameter = SearchParameter
        self.SearchParameter_nsprefix_ = None
        self.ServiceRequest = ServiceRequest
        self.ServiceRequest_nsprefix_ = None
        self.Slot = Slot
        self.Slot_nsprefix_ = None
        self.Specimen = Specimen
        self.Specimen_nsprefix_ = None
        self.SpecimenDefinition = SpecimenDefinition
        self.SpecimenDefinition_nsprefix_ = None
        self.StructureDefinition = StructureDefinition
        self.StructureDefinition_nsprefix_ = None
        self.StructureMap = StructureMap
        self.StructureMap_nsprefix_ = None
        self.Subscription = Subscription
        self.Subscription_nsprefix_ = None
        self.SubscriptionStatus = SubscriptionStatus
        self.SubscriptionStatus_nsprefix_ = None
        self.SubscriptionTopic = SubscriptionTopic
        self.SubscriptionTopic_nsprefix_ = None
        self.Substance = Substance
        self.Substance_nsprefix_ = None
        self.SubstanceDefinition = SubstanceDefinition
        self.SubstanceDefinition_nsprefix_ = None
        self.SupplyDelivery = SupplyDelivery
        self.SupplyDelivery_nsprefix_ = None
        self.SupplyRequest = SupplyRequest
        self.SupplyRequest_nsprefix_ = None
        self.Task = Task
        self.Task_nsprefix_ = None
        self.TerminologyCapabilities = TerminologyCapabilities
        self.TerminologyCapabilities_nsprefix_ = None
        self.TestReport = TestReport
        self.TestReport_nsprefix_ = None
        self.TestScript = TestScript
        self.TestScript_nsprefix_ = None
        self.ValueSet = ValueSet
        self.ValueSet_nsprefix_ = None
        self.VerificationResult = VerificationResult
        self.VerificationResult_nsprefix_ = None
        self.VisionPrescription = VisionPrescription
        self.VisionPrescription_nsprefix_ = None
        self.Parameters = Parameters
        self.Parameters_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ResourceContainer)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ResourceContainer.subclass:
            return ResourceContainer.subclass(*args_, **kwargs_)
        else:
            return ResourceContainer(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_Account(self):
        return self.Account
    def set_Account(self, Account):
        self.Account = Account
    def get_ActivityDefinition(self):
        return self.ActivityDefinition
    def set_ActivityDefinition(self, ActivityDefinition):
        self.ActivityDefinition = ActivityDefinition
    def get_AdministrableProductDefinition(self):
        return self.AdministrableProductDefinition
    def set_AdministrableProductDefinition(self, AdministrableProductDefinition):
        self.AdministrableProductDefinition = AdministrableProductDefinition
    def get_AdverseEvent(self):
        return self.AdverseEvent
    def set_AdverseEvent(self, AdverseEvent):
        self.AdverseEvent = AdverseEvent
    def get_AllergyIntolerance(self):
        return self.AllergyIntolerance
    def set_AllergyIntolerance(self, AllergyIntolerance):
        self.AllergyIntolerance = AllergyIntolerance
    def get_Appointment(self):
        return self.Appointment
    def set_Appointment(self, Appointment):
        self.Appointment = Appointment
    def get_AppointmentResponse(self):
        return self.AppointmentResponse
    def set_AppointmentResponse(self, AppointmentResponse):
        self.AppointmentResponse = AppointmentResponse
    def get_AuditEvent(self):
        return self.AuditEvent
    def set_AuditEvent(self, AuditEvent):
        self.AuditEvent = AuditEvent
    def get_Basic(self):
        return self.Basic
    def set_Basic(self, Basic):
        self.Basic = Basic
    def get_Binary(self):
        return self.Binary
    def set_Binary(self, Binary):
        self.Binary = Binary
    def get_BiologicallyDerivedProduct(self):
        return self.BiologicallyDerivedProduct
    def set_BiologicallyDerivedProduct(self, BiologicallyDerivedProduct):
        self.BiologicallyDerivedProduct = BiologicallyDerivedProduct
    def get_BodyStructure(self):
        return self.BodyStructure
    def set_BodyStructure(self, BodyStructure):
        self.BodyStructure = BodyStructure
    def get_Bundle(self):
        return self.Bundle
    def set_Bundle(self, Bundle):
        self.Bundle = Bundle
    def get_CapabilityStatement(self):
        return self.CapabilityStatement
    def set_CapabilityStatement(self, CapabilityStatement):
        self.CapabilityStatement = CapabilityStatement
    def get_CarePlan(self):
        return self.CarePlan
    def set_CarePlan(self, CarePlan):
        self.CarePlan = CarePlan
    def get_CareTeam(self):
        return self.CareTeam
    def set_CareTeam(self, CareTeam):
        self.CareTeam = CareTeam
    def get_CatalogEntry(self):
        return self.CatalogEntry
    def set_CatalogEntry(self, CatalogEntry):
        self.CatalogEntry = CatalogEntry
    def get_ChargeItem(self):
        return self.ChargeItem
    def set_ChargeItem(self, ChargeItem):
        self.ChargeItem = ChargeItem
    def get_ChargeItemDefinition(self):
        return self.ChargeItemDefinition
    def set_ChargeItemDefinition(self, ChargeItemDefinition):
        self.ChargeItemDefinition = ChargeItemDefinition
    def get_Citation(self):
        return self.Citation
    def set_Citation(self, Citation):
        self.Citation = Citation
    def get_Claim(self):
        return self.Claim
    def set_Claim(self, Claim):
        self.Claim = Claim
    def get_ClaimResponse(self):
        return self.ClaimResponse
    def set_ClaimResponse(self, ClaimResponse):
        self.ClaimResponse = ClaimResponse
    def get_ClinicalImpression(self):
        return self.ClinicalImpression
    def set_ClinicalImpression(self, ClinicalImpression):
        self.ClinicalImpression = ClinicalImpression
    def get_ClinicalUseDefinition(self):
        return self.ClinicalUseDefinition
    def set_ClinicalUseDefinition(self, ClinicalUseDefinition):
        self.ClinicalUseDefinition = ClinicalUseDefinition
    def get_CodeSystem(self):
        return self.CodeSystem
    def set_CodeSystem(self, CodeSystem):
        self.CodeSystem = CodeSystem
    def get_Communication(self):
        return self.Communication
    def set_Communication(self, Communication):
        self.Communication = Communication
    def get_CommunicationRequest(self):
        return self.CommunicationRequest
    def set_CommunicationRequest(self, CommunicationRequest):
        self.CommunicationRequest = CommunicationRequest
    def get_CompartmentDefinition(self):
        return self.CompartmentDefinition
    def set_CompartmentDefinition(self, CompartmentDefinition):
        self.CompartmentDefinition = CompartmentDefinition
    def get_Composition(self):
        return self.Composition
    def set_Composition(self, Composition):
        self.Composition = Composition
    def get_ConceptMap(self):
        return self.ConceptMap
    def set_ConceptMap(self, ConceptMap):
        self.ConceptMap = ConceptMap
    def get_Condition(self):
        return self.Condition
    def set_Condition(self, Condition):
        self.Condition = Condition
    def get_Consent(self):
        return self.Consent
    def set_Consent(self, Consent):
        self.Consent = Consent
    def get_Contract(self):
        return self.Contract
    def set_Contract(self, Contract):
        self.Contract = Contract
    def get_Coverage(self):
        return self.Coverage
    def set_Coverage(self, Coverage):
        self.Coverage = Coverage
    def get_CoverageEligibilityRequest(self):
        return self.CoverageEligibilityRequest
    def set_CoverageEligibilityRequest(self, CoverageEligibilityRequest):
        self.CoverageEligibilityRequest = CoverageEligibilityRequest
    def get_CoverageEligibilityResponse(self):
        return self.CoverageEligibilityResponse
    def set_CoverageEligibilityResponse(self, CoverageEligibilityResponse):
        self.CoverageEligibilityResponse = CoverageEligibilityResponse
    def get_DetectedIssue(self):
        return self.DetectedIssue
    def set_DetectedIssue(self, DetectedIssue):
        self.DetectedIssue = DetectedIssue
    def get_Device(self):
        return self.Device
    def set_Device(self, Device):
        self.Device = Device
    def get_DeviceDefinition(self):
        return self.DeviceDefinition
    def set_DeviceDefinition(self, DeviceDefinition):
        self.DeviceDefinition = DeviceDefinition
    def get_DeviceMetric(self):
        return self.DeviceMetric
    def set_DeviceMetric(self, DeviceMetric):
        self.DeviceMetric = DeviceMetric
    def get_DeviceRequest(self):
        return self.DeviceRequest
    def set_DeviceRequest(self, DeviceRequest):
        self.DeviceRequest = DeviceRequest
    def get_DeviceUseStatement(self):
        return self.DeviceUseStatement
    def set_DeviceUseStatement(self, DeviceUseStatement):
        self.DeviceUseStatement = DeviceUseStatement
    def get_DiagnosticReport(self):
        return self.DiagnosticReport
    def set_DiagnosticReport(self, DiagnosticReport):
        self.DiagnosticReport = DiagnosticReport
    def get_DocumentManifest(self):
        return self.DocumentManifest
    def set_DocumentManifest(self, DocumentManifest):
        self.DocumentManifest = DocumentManifest
    def get_DocumentReference(self):
        return self.DocumentReference
    def set_DocumentReference(self, DocumentReference):
        self.DocumentReference = DocumentReference
    def get_Encounter(self):
        return self.Encounter
    def set_Encounter(self, Encounter):
        self.Encounter = Encounter
    def get_Endpoint(self):
        return self.Endpoint
    def set_Endpoint(self, Endpoint):
        self.Endpoint = Endpoint
    def get_EnrollmentRequest(self):
        return self.EnrollmentRequest
    def set_EnrollmentRequest(self, EnrollmentRequest):
        self.EnrollmentRequest = EnrollmentRequest
    def get_EnrollmentResponse(self):
        return self.EnrollmentResponse
    def set_EnrollmentResponse(self, EnrollmentResponse):
        self.EnrollmentResponse = EnrollmentResponse
    def get_EpisodeOfCare(self):
        return self.EpisodeOfCare
    def set_EpisodeOfCare(self, EpisodeOfCare):
        self.EpisodeOfCare = EpisodeOfCare
    def get_EventDefinition(self):
        return self.EventDefinition
    def set_EventDefinition(self, EventDefinition):
        self.EventDefinition = EventDefinition
    def get_Evidence(self):
        return self.Evidence
    def set_Evidence(self, Evidence):
        self.Evidence = Evidence
    def get_EvidenceReport(self):
        return self.EvidenceReport
    def set_EvidenceReport(self, EvidenceReport):
        self.EvidenceReport = EvidenceReport
    def get_EvidenceVariable(self):
        return self.EvidenceVariable
    def set_EvidenceVariable(self, EvidenceVariable):
        self.EvidenceVariable = EvidenceVariable
    def get_ExampleScenario(self):
        return self.ExampleScenario
    def set_ExampleScenario(self, ExampleScenario):
        self.ExampleScenario = ExampleScenario
    def get_ExplanationOfBenefit(self):
        return self.ExplanationOfBenefit
    def set_ExplanationOfBenefit(self, ExplanationOfBenefit):
        self.ExplanationOfBenefit = ExplanationOfBenefit
    def get_FamilyMemberHistory(self):
        return self.FamilyMemberHistory
    def set_FamilyMemberHistory(self, FamilyMemberHistory):
        self.FamilyMemberHistory = FamilyMemberHistory
    def get_Flag(self):
        return self.Flag
    def set_Flag(self, Flag):
        self.Flag = Flag
    def get_Goal(self):
        return self.Goal
    def set_Goal(self, Goal):
        self.Goal = Goal
    def get_GraphDefinition(self):
        return self.GraphDefinition
    def set_GraphDefinition(self, GraphDefinition):
        self.GraphDefinition = GraphDefinition
    def get_Group(self):
        return self.Group
    def set_Group(self, Group):
        self.Group = Group
    def get_GuidanceResponse(self):
        return self.GuidanceResponse
    def set_GuidanceResponse(self, GuidanceResponse):
        self.GuidanceResponse = GuidanceResponse
    def get_HealthcareService(self):
        return self.HealthcareService
    def set_HealthcareService(self, HealthcareService):
        self.HealthcareService = HealthcareService
    def get_ImagingStudy(self):
        return self.ImagingStudy
    def set_ImagingStudy(self, ImagingStudy):
        self.ImagingStudy = ImagingStudy
    def get_Immunization(self):
        return self.Immunization
    def set_Immunization(self, Immunization):
        self.Immunization = Immunization
    def get_ImmunizationEvaluation(self):
        return self.ImmunizationEvaluation
    def set_ImmunizationEvaluation(self, ImmunizationEvaluation):
        self.ImmunizationEvaluation = ImmunizationEvaluation
    def get_ImmunizationRecommendation(self):
        return self.ImmunizationRecommendation
    def set_ImmunizationRecommendation(self, ImmunizationRecommendation):
        self.ImmunizationRecommendation = ImmunizationRecommendation
    def get_ImplementationGuide(self):
        return self.ImplementationGuide
    def set_ImplementationGuide(self, ImplementationGuide):
        self.ImplementationGuide = ImplementationGuide
    def get_Ingredient(self):
        return self.Ingredient
    def set_Ingredient(self, Ingredient):
        self.Ingredient = Ingredient
    def get_InsurancePlan(self):
        return self.InsurancePlan
    def set_InsurancePlan(self, InsurancePlan):
        self.InsurancePlan = InsurancePlan
    def get_Invoice(self):
        return self.Invoice
    def set_Invoice(self, Invoice):
        self.Invoice = Invoice
    def get_Library(self):
        return self.Library
    def set_Library(self, Library):
        self.Library = Library
    def get_Linkage(self):
        return self.Linkage
    def set_Linkage(self, Linkage):
        self.Linkage = Linkage
    def get_List(self):
        return self.List
    def set_List(self, List):
        self.List = List
    def get_Location(self):
        return self.Location
    def set_Location(self, Location):
        self.Location = Location
    def get_ManufacturedItemDefinition(self):
        return self.ManufacturedItemDefinition
    def set_ManufacturedItemDefinition(self, ManufacturedItemDefinition):
        self.ManufacturedItemDefinition = ManufacturedItemDefinition
    def get_Measure(self):
        return self.Measure
    def set_Measure(self, Measure):
        self.Measure = Measure
    def get_MeasureReport(self):
        return self.MeasureReport
    def set_MeasureReport(self, MeasureReport):
        self.MeasureReport = MeasureReport
    def get_Media(self):
        return self.Media
    def set_Media(self, Media):
        self.Media = Media
    def get_Medication(self):
        return self.Medication
    def set_Medication(self, Medication):
        self.Medication = Medication
    def get_MedicationAdministration(self):
        return self.MedicationAdministration
    def set_MedicationAdministration(self, MedicationAdministration):
        self.MedicationAdministration = MedicationAdministration
    def get_MedicationDispense(self):
        return self.MedicationDispense
    def set_MedicationDispense(self, MedicationDispense):
        self.MedicationDispense = MedicationDispense
    def get_MedicationKnowledge(self):
        return self.MedicationKnowledge
    def set_MedicationKnowledge(self, MedicationKnowledge):
        self.MedicationKnowledge = MedicationKnowledge
    def get_MedicationRequest(self):
        return self.MedicationRequest
    def set_MedicationRequest(self, MedicationRequest):
        self.MedicationRequest = MedicationRequest
    def get_MedicationStatement(self):
        return self.MedicationStatement
    def set_MedicationStatement(self, MedicationStatement):
        self.MedicationStatement = MedicationStatement
    def get_MedicinalProductDefinition(self):
        return self.MedicinalProductDefinition
    def set_MedicinalProductDefinition(self, MedicinalProductDefinition):
        self.MedicinalProductDefinition = MedicinalProductDefinition
    def get_MessageDefinition(self):
        return self.MessageDefinition
    def set_MessageDefinition(self, MessageDefinition):
        self.MessageDefinition = MessageDefinition
    def get_MessageHeader(self):
        return self.MessageHeader
    def set_MessageHeader(self, MessageHeader):
        self.MessageHeader = MessageHeader
    def get_MolecularSequence(self):
        return self.MolecularSequence
    def set_MolecularSequence(self, MolecularSequence):
        self.MolecularSequence = MolecularSequence
    def get_NamingSystem(self):
        return self.NamingSystem
    def set_NamingSystem(self, NamingSystem):
        self.NamingSystem = NamingSystem
    def get_NutritionOrder(self):
        return self.NutritionOrder
    def set_NutritionOrder(self, NutritionOrder):
        self.NutritionOrder = NutritionOrder
    def get_NutritionProduct(self):
        return self.NutritionProduct
    def set_NutritionProduct(self, NutritionProduct):
        self.NutritionProduct = NutritionProduct
    def get_Observation(self):
        return self.Observation
    def set_Observation(self, Observation):
        self.Observation = Observation
    def get_ObservationDefinition(self):
        return self.ObservationDefinition
    def set_ObservationDefinition(self, ObservationDefinition):
        self.ObservationDefinition = ObservationDefinition
    def get_OperationDefinition(self):
        return self.OperationDefinition
    def set_OperationDefinition(self, OperationDefinition):
        self.OperationDefinition = OperationDefinition
    def get_OperationOutcome(self):
        return self.OperationOutcome
    def set_OperationOutcome(self, OperationOutcome):
        self.OperationOutcome = OperationOutcome
    def get_Organization(self):
        return self.Organization
    def set_Organization(self, Organization):
        self.Organization = Organization
    def get_OrganizationAffiliation(self):
        return self.OrganizationAffiliation
    def set_OrganizationAffiliation(self, OrganizationAffiliation):
        self.OrganizationAffiliation = OrganizationAffiliation
    def get_PackagedProductDefinition(self):
        return self.PackagedProductDefinition
    def set_PackagedProductDefinition(self, PackagedProductDefinition):
        self.PackagedProductDefinition = PackagedProductDefinition
    def get_Patient(self):
        return self.Patient
    def set_Patient(self, Patient):
        self.Patient = Patient
    def get_PaymentNotice(self):
        return self.PaymentNotice
    def set_PaymentNotice(self, PaymentNotice):
        self.PaymentNotice = PaymentNotice
    def get_PaymentReconciliation(self):
        return self.PaymentReconciliation
    def set_PaymentReconciliation(self, PaymentReconciliation):
        self.PaymentReconciliation = PaymentReconciliation
    def get_Person(self):
        return self.Person
    def set_Person(self, Person):
        self.Person = Person
    def get_PlanDefinition(self):
        return self.PlanDefinition
    def set_PlanDefinition(self, PlanDefinition):
        self.PlanDefinition = PlanDefinition
    def get_Practitioner(self):
        return self.Practitioner
    def set_Practitioner(self, Practitioner):
        self.Practitioner = Practitioner
    def get_PractitionerRole(self):
        return self.PractitionerRole
    def set_PractitionerRole(self, PractitionerRole):
        self.PractitionerRole = PractitionerRole
    def get_Procedure(self):
        return self.Procedure
    def set_Procedure(self, Procedure):
        self.Procedure = Procedure
    def get_Provenance(self):
        return self.Provenance
    def set_Provenance(self, Provenance):
        self.Provenance = Provenance
    def get_Questionnaire(self):
        return self.Questionnaire
    def set_Questionnaire(self, Questionnaire):
        self.Questionnaire = Questionnaire
    def get_QuestionnaireResponse(self):
        return self.QuestionnaireResponse
    def set_QuestionnaireResponse(self, QuestionnaireResponse):
        self.QuestionnaireResponse = QuestionnaireResponse
    def get_RegulatedAuthorization(self):
        return self.RegulatedAuthorization
    def set_RegulatedAuthorization(self, RegulatedAuthorization):
        self.RegulatedAuthorization = RegulatedAuthorization
    def get_RelatedPerson(self):
        return self.RelatedPerson
    def set_RelatedPerson(self, RelatedPerson):
        self.RelatedPerson = RelatedPerson
    def get_RequestGroup(self):
        return self.RequestGroup
    def set_RequestGroup(self, RequestGroup):
        self.RequestGroup = RequestGroup
    def get_ResearchDefinition(self):
        return self.ResearchDefinition
    def set_ResearchDefinition(self, ResearchDefinition):
        self.ResearchDefinition = ResearchDefinition
    def get_ResearchElementDefinition(self):
        return self.ResearchElementDefinition
    def set_ResearchElementDefinition(self, ResearchElementDefinition):
        self.ResearchElementDefinition = ResearchElementDefinition
    def get_ResearchStudy(self):
        return self.ResearchStudy
    def set_ResearchStudy(self, ResearchStudy):
        self.ResearchStudy = ResearchStudy
    def get_ResearchSubject(self):
        return self.ResearchSubject
    def set_ResearchSubject(self, ResearchSubject):
        self.ResearchSubject = ResearchSubject
    def get_RiskAssessment(self):
        return self.RiskAssessment
    def set_RiskAssessment(self, RiskAssessment):
        self.RiskAssessment = RiskAssessment
    def get_Schedule(self):
        return self.Schedule
    def set_Schedule(self, Schedule):
        self.Schedule = Schedule
    def get_SearchParameter(self):
        return self.SearchParameter
    def set_SearchParameter(self, SearchParameter):
        self.SearchParameter = SearchParameter
    def get_ServiceRequest(self):
        return self.ServiceRequest
    def set_ServiceRequest(self, ServiceRequest):
        self.ServiceRequest = ServiceRequest
    def get_Slot(self):
        return self.Slot
    def set_Slot(self, Slot):
        self.Slot = Slot
    def get_Specimen(self):
        return self.Specimen
    def set_Specimen(self, Specimen):
        self.Specimen = Specimen
    def get_SpecimenDefinition(self):
        return self.SpecimenDefinition
    def set_SpecimenDefinition(self, SpecimenDefinition):
        self.SpecimenDefinition = SpecimenDefinition
    def get_StructureDefinition(self):
        return self.StructureDefinition
    def set_StructureDefinition(self, StructureDefinition):
        self.StructureDefinition = StructureDefinition
    def get_StructureMap(self):
        return self.StructureMap
    def set_StructureMap(self, StructureMap):
        self.StructureMap = StructureMap
    def get_Subscription(self):
        return self.Subscription
    def set_Subscription(self, Subscription):
        self.Subscription = Subscription
    def get_SubscriptionStatus(self):
        return self.SubscriptionStatus
    def set_SubscriptionStatus(self, SubscriptionStatus):
        self.SubscriptionStatus = SubscriptionStatus
    def get_SubscriptionTopic(self):
        return self.SubscriptionTopic
    def set_SubscriptionTopic(self, SubscriptionTopic):
        self.SubscriptionTopic = SubscriptionTopic
    def get_Substance(self):
        return self.Substance
    def set_Substance(self, Substance):
        self.Substance = Substance
    def get_SubstanceDefinition(self):
        return self.SubstanceDefinition
    def set_SubstanceDefinition(self, SubstanceDefinition):
        self.SubstanceDefinition = SubstanceDefinition
    def get_SupplyDelivery(self):
        return self.SupplyDelivery
    def set_SupplyDelivery(self, SupplyDelivery):
        self.SupplyDelivery = SupplyDelivery
    def get_SupplyRequest(self):
        return self.SupplyRequest
    def set_SupplyRequest(self, SupplyRequest):
        self.SupplyRequest = SupplyRequest
    def get_Task(self):
        return self.Task
    def set_Task(self, Task):
        self.Task = Task
    def get_TerminologyCapabilities(self):
        return self.TerminologyCapabilities
    def set_TerminologyCapabilities(self, TerminologyCapabilities):
        self.TerminologyCapabilities = TerminologyCapabilities
    def get_TestReport(self):
        return self.TestReport
    def set_TestReport(self, TestReport):
        self.TestReport = TestReport
    def get_TestScript(self):
        return self.TestScript
    def set_TestScript(self, TestScript):
        self.TestScript = TestScript
    def get_ValueSet(self):
        return self.ValueSet
    def set_ValueSet(self, ValueSet):
        self.ValueSet = ValueSet
    def get_VerificationResult(self):
        return self.VerificationResult
    def set_VerificationResult(self, VerificationResult):
        self.VerificationResult = VerificationResult
    def get_VisionPrescription(self):
        return self.VisionPrescription
    def set_VisionPrescription(self, VisionPrescription):
        self.VisionPrescription = VisionPrescription
    def get_Parameters(self):
        return self.Parameters
    def set_Parameters(self, Parameters):
        self.Parameters = Parameters
    def has__content(self):
        if (
            self.Account is not None or
            self.ActivityDefinition is not None or
            self.AdministrableProductDefinition is not None or
            self.AdverseEvent is not None or
            self.AllergyIntolerance is not None or
            self.Appointment is not None or
            self.AppointmentResponse is not None or
            self.AuditEvent is not None or
            self.Basic is not None or
            self.Binary is not None or
            self.BiologicallyDerivedProduct is not None or
            self.BodyStructure is not None or
            self.Bundle is not None or
            self.CapabilityStatement is not None or
            self.CarePlan is not None or
            self.CareTeam is not None or
            self.CatalogEntry is not None or
            self.ChargeItem is not None or
            self.ChargeItemDefinition is not None or
            self.Citation is not None or
            self.Claim is not None or
            self.ClaimResponse is not None or
            self.ClinicalImpression is not None or
            self.ClinicalUseDefinition is not None or
            self.CodeSystem is not None or
            self.Communication is not None or
            self.CommunicationRequest is not None or
            self.CompartmentDefinition is not None or
            self.Composition is not None or
            self.ConceptMap is not None or
            self.Condition is not None or
            self.Consent is not None or
            self.Contract is not None or
            self.Coverage is not None or
            self.CoverageEligibilityRequest is not None or
            self.CoverageEligibilityResponse is not None or
            self.DetectedIssue is not None or
            self.Device is not None or
            self.DeviceDefinition is not None or
            self.DeviceMetric is not None or
            self.DeviceRequest is not None or
            self.DeviceUseStatement is not None or
            self.DiagnosticReport is not None or
            self.DocumentManifest is not None or
            self.DocumentReference is not None or
            self.Encounter is not None or
            self.Endpoint is not None or
            self.EnrollmentRequest is not None or
            self.EnrollmentResponse is not None or
            self.EpisodeOfCare is not None or
            self.EventDefinition is not None or
            self.Evidence is not None or
            self.EvidenceReport is not None or
            self.EvidenceVariable is not None or
            self.ExampleScenario is not None or
            self.ExplanationOfBenefit is not None or
            self.FamilyMemberHistory is not None or
            self.Flag is not None or
            self.Goal is not None or
            self.GraphDefinition is not None or
            self.Group is not None or
            self.GuidanceResponse is not None or
            self.HealthcareService is not None or
            self.ImagingStudy is not None or
            self.Immunization is not None or
            self.ImmunizationEvaluation is not None or
            self.ImmunizationRecommendation is not None or
            self.ImplementationGuide is not None or
            self.Ingredient is not None or
            self.InsurancePlan is not None or
            self.Invoice is not None or
            self.Library is not None or
            self.Linkage is not None or
            self.List is not None or
            self.Location is not None or
            self.ManufacturedItemDefinition is not None or
            self.Measure is not None or
            self.MeasureReport is not None or
            self.Media is not None or
            self.Medication is not None or
            self.MedicationAdministration is not None or
            self.MedicationDispense is not None or
            self.MedicationKnowledge is not None or
            self.MedicationRequest is not None or
            self.MedicationStatement is not None or
            self.MedicinalProductDefinition is not None or
            self.MessageDefinition is not None or
            self.MessageHeader is not None or
            self.MolecularSequence is not None or
            self.NamingSystem is not None or
            self.NutritionOrder is not None or
            self.NutritionProduct is not None or
            self.Observation is not None or
            self.ObservationDefinition is not None or
            self.OperationDefinition is not None or
            self.OperationOutcome is not None or
            self.Organization is not None or
            self.OrganizationAffiliation is not None or
            self.PackagedProductDefinition is not None or
            self.Patient is not None or
            self.PaymentNotice is not None or
            self.PaymentReconciliation is not None or
            self.Person is not None or
            self.PlanDefinition is not None or
            self.Practitioner is not None or
            self.PractitionerRole is not None or
            self.Procedure is not None or
            self.Provenance is not None or
            self.Questionnaire is not None or
            self.QuestionnaireResponse is not None or
            self.RegulatedAuthorization is not None or
            self.RelatedPerson is not None or
            self.RequestGroup is not None or
            self.ResearchDefinition is not None or
            self.ResearchElementDefinition is not None or
            self.ResearchStudy is not None or
            self.ResearchSubject is not None or
            self.RiskAssessment is not None or
            self.Schedule is not None or
            self.SearchParameter is not None or
            self.ServiceRequest is not None or
            self.Slot is not None or
            self.Specimen is not None or
            self.SpecimenDefinition is not None or
            self.StructureDefinition is not None or
            self.StructureMap is not None or
            self.Subscription is not None or
            self.SubscriptionStatus is not None or
            self.SubscriptionTopic is not None or
            self.Substance is not None or
            self.SubstanceDefinition is not None or
            self.SupplyDelivery is not None or
            self.SupplyRequest is not None or
            self.Task is not None or
            self.TerminologyCapabilities is not None or
            self.TestReport is not None or
            self.TestScript is not None or
            self.ValueSet is not None or
            self.VerificationResult is not None or
            self.VisionPrescription is not None or
            self.Parameters is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_=' xmlns:None="http://hl7.org/fhir" ', name_='ResourceContainer', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('ResourceContainer')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'ResourceContainer':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='ResourceContainer')
        if self.has__content():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='ResourceContainer', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='ResourceContainer'):
        pass
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_=' xmlns:None="http://hl7.org/fhir" ', name_='ResourceContainer', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.Account is not None:
            namespaceprefix_ = self.Account_nsprefix_ + ':' if (UseCapturedNS_ and self.Account_nsprefix_) else ''
            self.Account.export(outfile, level, namespaceprefix_, namespacedef_='', name_='Account', pretty_print=pretty_print)
        if self.ActivityDefinition is not None:
            namespaceprefix_ = self.ActivityDefinition_nsprefix_ + ':' if (UseCapturedNS_ and self.ActivityDefinition_nsprefix_) else ''
            self.ActivityDefinition.export(outfile, level, namespaceprefix_, namespacedef_='', name_='ActivityDefinition', pretty_print=pretty_print)
        if self.AdministrableProductDefinition is not None:
            namespaceprefix_ = self.AdministrableProductDefinition_nsprefix_ + ':' if (UseCapturedNS_ and self.AdministrableProductDefinition_nsprefix_) else ''
            self.AdministrableProductDefinition.export(outfile, level, namespaceprefix_, namespacedef_='', name_='AdministrableProductDefinition', pretty_print=pretty_print)
        if self.AdverseEvent is not None:
            namespaceprefix_ = self.AdverseEvent_nsprefix_ + ':' if (UseCapturedNS_ and self.AdverseEvent_nsprefix_) else ''
            self.AdverseEvent.export(outfile, level, namespaceprefix_, namespacedef_='', name_='AdverseEvent', pretty_print=pretty_print)
        if self.AllergyIntolerance is not None:
            namespaceprefix_ = self.AllergyIntolerance_nsprefix_ + ':' if (UseCapturedNS_ and self.AllergyIntolerance_nsprefix_) else ''
            self.AllergyIntolerance.export(outfile, level, namespaceprefix_, namespacedef_='', name_='AllergyIntolerance', pretty_print=pretty_print)
        if self.Appointment is not None:
            namespaceprefix_ = self.Appointment_nsprefix_ + ':' if (UseCapturedNS_ and self.Appointment_nsprefix_) else ''
            self.Appointment.export(outfile, level, namespaceprefix_, namespacedef_='', name_='Appointment', pretty_print=pretty_print)
        if self.AppointmentResponse is not None:
            namespaceprefix_ = self.AppointmentResponse_nsprefix_ + ':' if (UseCapturedNS_ and self.AppointmentResponse_nsprefix_) else ''
            self.AppointmentResponse.export(outfile, level, namespaceprefix_, namespacedef_='', name_='AppointmentResponse', pretty_print=pretty_print)
        if self.AuditEvent is not None:
            namespaceprefix_ = self.AuditEvent_nsprefix_ + ':' if (UseCapturedNS_ and self.AuditEvent_nsprefix_) else ''
            self.AuditEvent.export(outfile, level, namespaceprefix_, namespacedef_='', name_='AuditEvent', pretty_print=pretty_print)
        if self.Basic is not None:
            namespaceprefix_ = self.Basic_nsprefix_ + ':' if (UseCapturedNS_ and self.Basic_nsprefix_) else ''
            self.Basic.export(outfile, level, namespaceprefix_, namespacedef_='', name_='Basic', pretty_print=pretty_print)
        if self.Binary is not None:
            namespaceprefix_ = self.Binary_nsprefix_ + ':' if (UseCapturedNS_ and self.Binary_nsprefix_) else ''
            self.Binary.export(outfile, level, namespaceprefix_, namespacedef_='', name_='Binary', pretty_print=pretty_print)
        if self.BiologicallyDerivedProduct is not None:
            namespaceprefix_ = self.BiologicallyDerivedProduct_nsprefix_ + ':' if (UseCapturedNS_ and self.BiologicallyDerivedProduct_nsprefix_) else ''
            self.BiologicallyDerivedProduct.export(outfile, level, namespaceprefix_, namespacedef_='', name_='BiologicallyDerivedProduct', pretty_print=pretty_print)
        if self.BodyStructure is not None:
            namespaceprefix_ = self.BodyStructure_nsprefix_ + ':' if (UseCapturedNS_ and self.BodyStructure_nsprefix_) else ''
            self.BodyStructure.export(outfile, level, namespaceprefix_, namespacedef_='', name_='BodyStructure', pretty_print=pretty_print)
        if self.Bundle is not None:
            namespaceprefix_ = self.Bundle_nsprefix_ + ':' if (UseCapturedNS_ and self.Bundle_nsprefix_) else ''
            self.Bundle.export(outfile, level, namespaceprefix_, namespacedef_='', name_='Bundle', pretty_print=pretty_print)
        if self.CapabilityStatement is not None:
            namespaceprefix_ = self.CapabilityStatement_nsprefix_ + ':' if (UseCapturedNS_ and self.CapabilityStatement_nsprefix_) else ''
            self.CapabilityStatement.export(outfile, level, namespaceprefix_, namespacedef_='', name_='CapabilityStatement', pretty_print=pretty_print)
        if self.CarePlan is not None:
            namespaceprefix_ = self.CarePlan_nsprefix_ + ':' if (UseCapturedNS_ and self.CarePlan_nsprefix_) else ''
            self.CarePlan.export(outfile, level, namespaceprefix_, namespacedef_='', name_='CarePlan', pretty_print=pretty_print)
        if self.CareTeam is not None:
            namespaceprefix_ = self.CareTeam_nsprefix_ + ':' if (UseCapturedNS_ and self.CareTeam_nsprefix_) else ''
            self.CareTeam.export(outfile, level, namespaceprefix_, namespacedef_='', name_='CareTeam', pretty_print=pretty_print)
        if self.CatalogEntry is not None:
            namespaceprefix_ = self.CatalogEntry_nsprefix_ + ':' if (UseCapturedNS_ and self.CatalogEntry_nsprefix_) else ''
            self.CatalogEntry.export(outfile, level, namespaceprefix_, namespacedef_='', name_='CatalogEntry', pretty_print=pretty_print)
        if self.ChargeItem is not None:
            namespaceprefix_ = self.ChargeItem_nsprefix_ + ':' if (UseCapturedNS_ and self.ChargeItem_nsprefix_) else ''
            self.ChargeItem.export(outfile, level, namespaceprefix_, namespacedef_='', name_='ChargeItem', pretty_print=pretty_print)
        if self.ChargeItemDefinition is not None:
            namespaceprefix_ = self.ChargeItemDefinition_nsprefix_ + ':' if (UseCapturedNS_ and self.ChargeItemDefinition_nsprefix_) else ''
            self.ChargeItemDefinition.export(outfile, level, namespaceprefix_, namespacedef_='', name_='ChargeItemDefinition', pretty_print=pretty_print)
        if self.Citation is not None:
            namespaceprefix_ = self.Citation_nsprefix_ + ':' if (UseCapturedNS_ and self.Citation_nsprefix_) else ''
            self.Citation.export(outfile, level, namespaceprefix_, namespacedef_='', name_='Citation', pretty_print=pretty_print)
        if self.Claim is not None:
            namespaceprefix_ = self.Claim_nsprefix_ + ':' if (UseCapturedNS_ and self.Claim_nsprefix_) else ''
            self.Claim.export(outfile, level, namespaceprefix_, namespacedef_='', name_='Claim', pretty_print=pretty_print)
        if self.ClaimResponse is not None:
            namespaceprefix_ = self.ClaimResponse_nsprefix_ + ':' if (UseCapturedNS_ and self.ClaimResponse_nsprefix_) else ''
            self.ClaimResponse.export(outfile, level, namespaceprefix_, namespacedef_='', name_='ClaimResponse', pretty_print=pretty_print)
        if self.ClinicalImpression is not None:
            namespaceprefix_ = self.ClinicalImpression_nsprefix_ + ':' if (UseCapturedNS_ and self.ClinicalImpression_nsprefix_) else ''
            self.ClinicalImpression.export(outfile, level, namespaceprefix_, namespacedef_='', name_='ClinicalImpression', pretty_print=pretty_print)
        if self.ClinicalUseDefinition is not None:
            namespaceprefix_ = self.ClinicalUseDefinition_nsprefix_ + ':' if (UseCapturedNS_ and self.ClinicalUseDefinition_nsprefix_) else ''
            self.ClinicalUseDefinition.export(outfile, level, namespaceprefix_, namespacedef_='', name_='ClinicalUseDefinition', pretty_print=pretty_print)
        if self.CodeSystem is not None:
            namespaceprefix_ = self.CodeSystem_nsprefix_ + ':' if (UseCapturedNS_ and self.CodeSystem_nsprefix_) else ''
            self.CodeSystem.export(outfile, level, namespaceprefix_, namespacedef_='', name_='CodeSystem', pretty_print=pretty_print)
        if self.Communication is not None:
            namespaceprefix_ = self.Communication_nsprefix_ + ':' if (UseCapturedNS_ and self.Communication_nsprefix_) else ''
            self.Communication.export(outfile, level, namespaceprefix_, namespacedef_='', name_='Communication', pretty_print=pretty_print)
        if self.CommunicationRequest is not None:
            namespaceprefix_ = self.CommunicationRequest_nsprefix_ + ':' if (UseCapturedNS_ and self.CommunicationRequest_nsprefix_) else ''
            self.CommunicationRequest.export(outfile, level, namespaceprefix_, namespacedef_='', name_='CommunicationRequest', pretty_print=pretty_print)
        if self.CompartmentDefinition is not None:
            namespaceprefix_ = self.CompartmentDefinition_nsprefix_ + ':' if (UseCapturedNS_ and self.CompartmentDefinition_nsprefix_) else ''
            self.CompartmentDefinition.export(outfile, level, namespaceprefix_, namespacedef_='', name_='CompartmentDefinition', pretty_print=pretty_print)
        if self.Composition is not None:
            namespaceprefix_ = self.Composition_nsprefix_ + ':' if (UseCapturedNS_ and self.Composition_nsprefix_) else ''
            self.Composition.export(outfile, level, namespaceprefix_, namespacedef_='', name_='Composition', pretty_print=pretty_print)
        if self.ConceptMap is not None:
            namespaceprefix_ = self.ConceptMap_nsprefix_ + ':' if (UseCapturedNS_ and self.ConceptMap_nsprefix_) else ''
            self.ConceptMap.export(outfile, level, namespaceprefix_, namespacedef_='', name_='ConceptMap', pretty_print=pretty_print)
        if self.Condition is not None:
            namespaceprefix_ = self.Condition_nsprefix_ + ':' if (UseCapturedNS_ and self.Condition_nsprefix_) else ''
            self.Condition.export(outfile, level, namespaceprefix_, namespacedef_='', name_='Condition', pretty_print=pretty_print)
        if self.Consent is not None:
            namespaceprefix_ = self.Consent_nsprefix_ + ':' if (UseCapturedNS_ and self.Consent_nsprefix_) else ''
            self.Consent.export(outfile, level, namespaceprefix_, namespacedef_='', name_='Consent', pretty_print=pretty_print)
        if self.Contract is not None:
            namespaceprefix_ = self.Contract_nsprefix_ + ':' if (UseCapturedNS_ and self.Contract_nsprefix_) else ''
            self.Contract.export(outfile, level, namespaceprefix_, namespacedef_='', name_='Contract', pretty_print=pretty_print)
        if self.Coverage is not None:
            namespaceprefix_ = self.Coverage_nsprefix_ + ':' if (UseCapturedNS_ and self.Coverage_nsprefix_) else ''
            self.Coverage.export(outfile, level, namespaceprefix_, namespacedef_='', name_='Coverage', pretty_print=pretty_print)
        if self.CoverageEligibilityRequest is not None:
            namespaceprefix_ = self.CoverageEligibilityRequest_nsprefix_ + ':' if (UseCapturedNS_ and self.CoverageEligibilityRequest_nsprefix_) else ''
            self.CoverageEligibilityRequest.export(outfile, level, namespaceprefix_, namespacedef_='', name_='CoverageEligibilityRequest', pretty_print=pretty_print)
        if self.CoverageEligibilityResponse is not None:
            namespaceprefix_ = self.CoverageEligibilityResponse_nsprefix_ + ':' if (UseCapturedNS_ and self.CoverageEligibilityResponse_nsprefix_) else ''
            self.CoverageEligibilityResponse.export(outfile, level, namespaceprefix_, namespacedef_='', name_='CoverageEligibilityResponse', pretty_print=pretty_print)
        if self.DetectedIssue is not None:
            namespaceprefix_ = self.DetectedIssue_nsprefix_ + ':' if (UseCapturedNS_ and self.DetectedIssue_nsprefix_) else ''
            self.DetectedIssue.export(outfile, level, namespaceprefix_, namespacedef_='', name_='DetectedIssue', pretty_print=pretty_print)
        if self.Device is not None:
            namespaceprefix_ = self.Device_nsprefix_ + ':' if (UseCapturedNS_ and self.Device_nsprefix_) else ''
            self.Device.export(outfile, level, namespaceprefix_, namespacedef_='', name_='Device', pretty_print=pretty_print)
        if self.DeviceDefinition is not None:
            namespaceprefix_ = self.DeviceDefinition_nsprefix_ + ':' if (UseCapturedNS_ and self.DeviceDefinition_nsprefix_) else ''
            self.DeviceDefinition.export(outfile, level, namespaceprefix_, namespacedef_='', name_='DeviceDefinition', pretty_print=pretty_print)
        if self.DeviceMetric is not None:
            namespaceprefix_ = self.DeviceMetric_nsprefix_ + ':' if (UseCapturedNS_ and self.DeviceMetric_nsprefix_) else ''
            self.DeviceMetric.export(outfile, level, namespaceprefix_, namespacedef_='', name_='DeviceMetric', pretty_print=pretty_print)
        if self.DeviceRequest is not None:
            namespaceprefix_ = self.DeviceRequest_nsprefix_ + ':' if (UseCapturedNS_ and self.DeviceRequest_nsprefix_) else ''
            self.DeviceRequest.export(outfile, level, namespaceprefix_, namespacedef_='', name_='DeviceRequest', pretty_print=pretty_print)
        if self.DeviceUseStatement is not None:
            namespaceprefix_ = self.DeviceUseStatement_nsprefix_ + ':' if (UseCapturedNS_ and self.DeviceUseStatement_nsprefix_) else ''
            self.DeviceUseStatement.export(outfile, level, namespaceprefix_, namespacedef_='', name_='DeviceUseStatement', pretty_print=pretty_print)
        if self.DiagnosticReport is not None:
            namespaceprefix_ = self.DiagnosticReport_nsprefix_ + ':' if (UseCapturedNS_ and self.DiagnosticReport_nsprefix_) else ''
            self.DiagnosticReport.export(outfile, level, namespaceprefix_, namespacedef_='', name_='DiagnosticReport', pretty_print=pretty_print)
        if self.DocumentManifest is not None:
            namespaceprefix_ = self.DocumentManifest_nsprefix_ + ':' if (UseCapturedNS_ and self.DocumentManifest_nsprefix_) else ''
            self.DocumentManifest.export(outfile, level, namespaceprefix_, namespacedef_='', name_='DocumentManifest', pretty_print=pretty_print)
        if self.DocumentReference is not None:
            namespaceprefix_ = self.DocumentReference_nsprefix_ + ':' if (UseCapturedNS_ and self.DocumentReference_nsprefix_) else ''
            self.DocumentReference.export(outfile, level, namespaceprefix_, namespacedef_='', name_='DocumentReference', pretty_print=pretty_print)
        if self.Encounter is not None:
            namespaceprefix_ = self.Encounter_nsprefix_ + ':' if (UseCapturedNS_ and self.Encounter_nsprefix_) else ''
            self.Encounter.export(outfile, level, namespaceprefix_, namespacedef_='', name_='Encounter', pretty_print=pretty_print)
        if self.Endpoint is not None:
            namespaceprefix_ = self.Endpoint_nsprefix_ + ':' if (UseCapturedNS_ and self.Endpoint_nsprefix_) else ''
            self.Endpoint.export(outfile, level, namespaceprefix_, namespacedef_='', name_='Endpoint', pretty_print=pretty_print)
        if self.EnrollmentRequest is not None:
            namespaceprefix_ = self.EnrollmentRequest_nsprefix_ + ':' if (UseCapturedNS_ and self.EnrollmentRequest_nsprefix_) else ''
            self.EnrollmentRequest.export(outfile, level, namespaceprefix_, namespacedef_='', name_='EnrollmentRequest', pretty_print=pretty_print)
        if self.EnrollmentResponse is not None:
            namespaceprefix_ = self.EnrollmentResponse_nsprefix_ + ':' if (UseCapturedNS_ and self.EnrollmentResponse_nsprefix_) else ''
            self.EnrollmentResponse.export(outfile, level, namespaceprefix_, namespacedef_='', name_='EnrollmentResponse', pretty_print=pretty_print)
        if self.EpisodeOfCare is not None:
            namespaceprefix_ = self.EpisodeOfCare_nsprefix_ + ':' if (UseCapturedNS_ and self.EpisodeOfCare_nsprefix_) else ''
            self.EpisodeOfCare.export(outfile, level, namespaceprefix_, namespacedef_='', name_='EpisodeOfCare', pretty_print=pretty_print)
        if self.EventDefinition is not None:
            namespaceprefix_ = self.EventDefinition_nsprefix_ + ':' if (UseCapturedNS_ and self.EventDefinition_nsprefix_) else ''
            self.EventDefinition.export(outfile, level, namespaceprefix_, namespacedef_='', name_='EventDefinition', pretty_print=pretty_print)
        if self.Evidence is not None:
            namespaceprefix_ = self.Evidence_nsprefix_ + ':' if (UseCapturedNS_ and self.Evidence_nsprefix_) else ''
            self.Evidence.export(outfile, level, namespaceprefix_, namespacedef_='', name_='Evidence', pretty_print=pretty_print)
        if self.EvidenceReport is not None:
            namespaceprefix_ = self.EvidenceReport_nsprefix_ + ':' if (UseCapturedNS_ and self.EvidenceReport_nsprefix_) else ''
            self.EvidenceReport.export(outfile, level, namespaceprefix_, namespacedef_='', name_='EvidenceReport', pretty_print=pretty_print)
        if self.EvidenceVariable is not None:
            namespaceprefix_ = self.EvidenceVariable_nsprefix_ + ':' if (UseCapturedNS_ and self.EvidenceVariable_nsprefix_) else ''
            self.EvidenceVariable.export(outfile, level, namespaceprefix_, namespacedef_='', name_='EvidenceVariable', pretty_print=pretty_print)
        if self.ExampleScenario is not None:
            namespaceprefix_ = self.ExampleScenario_nsprefix_ + ':' if (UseCapturedNS_ and self.ExampleScenario_nsprefix_) else ''
            self.ExampleScenario.export(outfile, level, namespaceprefix_, namespacedef_='', name_='ExampleScenario', pretty_print=pretty_print)
        if self.ExplanationOfBenefit is not None:
            namespaceprefix_ = self.ExplanationOfBenefit_nsprefix_ + ':' if (UseCapturedNS_ and self.ExplanationOfBenefit_nsprefix_) else ''
            self.ExplanationOfBenefit.export(outfile, level, namespaceprefix_, namespacedef_='', name_='ExplanationOfBenefit', pretty_print=pretty_print)
        if self.FamilyMemberHistory is not None:
            namespaceprefix_ = self.FamilyMemberHistory_nsprefix_ + ':' if (UseCapturedNS_ and self.FamilyMemberHistory_nsprefix_) else ''
            self.FamilyMemberHistory.export(outfile, level, namespaceprefix_, namespacedef_='', name_='FamilyMemberHistory', pretty_print=pretty_print)
        if self.Flag is not None:
            namespaceprefix_ = self.Flag_nsprefix_ + ':' if (UseCapturedNS_ and self.Flag_nsprefix_) else ''
            self.Flag.export(outfile, level, namespaceprefix_, namespacedef_='', name_='Flag', pretty_print=pretty_print)
        if self.Goal is not None:
            namespaceprefix_ = self.Goal_nsprefix_ + ':' if (UseCapturedNS_ and self.Goal_nsprefix_) else ''
            self.Goal.export(outfile, level, namespaceprefix_, namespacedef_='', name_='Goal', pretty_print=pretty_print)
        if self.GraphDefinition is not None:
            namespaceprefix_ = self.GraphDefinition_nsprefix_ + ':' if (UseCapturedNS_ and self.GraphDefinition_nsprefix_) else ''
            self.GraphDefinition.export(outfile, level, namespaceprefix_, namespacedef_='', name_='GraphDefinition', pretty_print=pretty_print)
        if self.Group is not None:
            namespaceprefix_ = self.Group_nsprefix_ + ':' if (UseCapturedNS_ and self.Group_nsprefix_) else ''
            self.Group.export(outfile, level, namespaceprefix_, namespacedef_='', name_='Group', pretty_print=pretty_print)
        if self.GuidanceResponse is not None:
            namespaceprefix_ = self.GuidanceResponse_nsprefix_ + ':' if (UseCapturedNS_ and self.GuidanceResponse_nsprefix_) else ''
            self.GuidanceResponse.export(outfile, level, namespaceprefix_, namespacedef_='', name_='GuidanceResponse', pretty_print=pretty_print)
        if self.HealthcareService is not None:
            namespaceprefix_ = self.HealthcareService_nsprefix_ + ':' if (UseCapturedNS_ and self.HealthcareService_nsprefix_) else ''
            self.HealthcareService.export(outfile, level, namespaceprefix_, namespacedef_='', name_='HealthcareService', pretty_print=pretty_print)
        if self.ImagingStudy is not None:
            namespaceprefix_ = self.ImagingStudy_nsprefix_ + ':' if (UseCapturedNS_ and self.ImagingStudy_nsprefix_) else ''
            self.ImagingStudy.export(outfile, level, namespaceprefix_, namespacedef_='', name_='ImagingStudy', pretty_print=pretty_print)
        if self.Immunization is not None:
            namespaceprefix_ = self.Immunization_nsprefix_ + ':' if (UseCapturedNS_ and self.Immunization_nsprefix_) else ''
            self.Immunization.export(outfile, level, namespaceprefix_, namespacedef_='', name_='Immunization', pretty_print=pretty_print)
        if self.ImmunizationEvaluation is not None:
            namespaceprefix_ = self.ImmunizationEvaluation_nsprefix_ + ':' if (UseCapturedNS_ and self.ImmunizationEvaluation_nsprefix_) else ''
            self.ImmunizationEvaluation.export(outfile, level, namespaceprefix_, namespacedef_='', name_='ImmunizationEvaluation', pretty_print=pretty_print)
        if self.ImmunizationRecommendation is not None:
            namespaceprefix_ = self.ImmunizationRecommendation_nsprefix_ + ':' if (UseCapturedNS_ and self.ImmunizationRecommendation_nsprefix_) else ''
            self.ImmunizationRecommendation.export(outfile, level, namespaceprefix_, namespacedef_='', name_='ImmunizationRecommendation', pretty_print=pretty_print)
        if self.ImplementationGuide is not None:
            namespaceprefix_ = self.ImplementationGuide_nsprefix_ + ':' if (UseCapturedNS_ and self.ImplementationGuide_nsprefix_) else ''
            self.ImplementationGuide.export(outfile, level, namespaceprefix_, namespacedef_='', name_='ImplementationGuide', pretty_print=pretty_print)
        if self.Ingredient is not None:
            namespaceprefix_ = self.Ingredient_nsprefix_ + ':' if (UseCapturedNS_ and self.Ingredient_nsprefix_) else ''
            self.Ingredient.export(outfile, level, namespaceprefix_, namespacedef_='', name_='Ingredient', pretty_print=pretty_print)
        if self.InsurancePlan is not None:
            namespaceprefix_ = self.InsurancePlan_nsprefix_ + ':' if (UseCapturedNS_ and self.InsurancePlan_nsprefix_) else ''
            self.InsurancePlan.export(outfile, level, namespaceprefix_, namespacedef_='', name_='InsurancePlan', pretty_print=pretty_print)
        if self.Invoice is not None:
            namespaceprefix_ = self.Invoice_nsprefix_ + ':' if (UseCapturedNS_ and self.Invoice_nsprefix_) else ''
            self.Invoice.export(outfile, level, namespaceprefix_, namespacedef_='', name_='Invoice', pretty_print=pretty_print)
        if self.Library is not None:
            namespaceprefix_ = self.Library_nsprefix_ + ':' if (UseCapturedNS_ and self.Library_nsprefix_) else ''
            self.Library.export(outfile, level, namespaceprefix_, namespacedef_='', name_='Library', pretty_print=pretty_print)
        if self.Linkage is not None:
            namespaceprefix_ = self.Linkage_nsprefix_ + ':' if (UseCapturedNS_ and self.Linkage_nsprefix_) else ''
            self.Linkage.export(outfile, level, namespaceprefix_, namespacedef_='', name_='Linkage', pretty_print=pretty_print)
        if self.List is not None:
            namespaceprefix_ = self.List_nsprefix_ + ':' if (UseCapturedNS_ and self.List_nsprefix_) else ''
            self.List.export(outfile, level, namespaceprefix_, namespacedef_='', name_='List', pretty_print=pretty_print)
        if self.Location is not None:
            namespaceprefix_ = self.Location_nsprefix_ + ':' if (UseCapturedNS_ and self.Location_nsprefix_) else ''
            self.Location.export(outfile, level, namespaceprefix_, namespacedef_='', name_='Location', pretty_print=pretty_print)
        if self.ManufacturedItemDefinition is not None:
            namespaceprefix_ = self.ManufacturedItemDefinition_nsprefix_ + ':' if (UseCapturedNS_ and self.ManufacturedItemDefinition_nsprefix_) else ''
            self.ManufacturedItemDefinition.export(outfile, level, namespaceprefix_, namespacedef_='', name_='ManufacturedItemDefinition', pretty_print=pretty_print)
        if self.Measure is not None:
            namespaceprefix_ = self.Measure_nsprefix_ + ':' if (UseCapturedNS_ and self.Measure_nsprefix_) else ''
            self.Measure.export(outfile, level, namespaceprefix_, namespacedef_='', name_='Measure', pretty_print=pretty_print)
        if self.MeasureReport is not None:
            namespaceprefix_ = self.MeasureReport_nsprefix_ + ':' if (UseCapturedNS_ and self.MeasureReport_nsprefix_) else ''
            self.MeasureReport.export(outfile, level, namespaceprefix_, namespacedef_='', name_='MeasureReport', pretty_print=pretty_print)
        if self.Media is not None:
            namespaceprefix_ = self.Media_nsprefix_ + ':' if (UseCapturedNS_ and self.Media_nsprefix_) else ''
            self.Media.export(outfile, level, namespaceprefix_, namespacedef_='', name_='Media', pretty_print=pretty_print)
        if self.Medication is not None:
            namespaceprefix_ = self.Medication_nsprefix_ + ':' if (UseCapturedNS_ and self.Medication_nsprefix_) else ''
            self.Medication.export(outfile, level, namespaceprefix_, namespacedef_='', name_='Medication', pretty_print=pretty_print)
        if self.MedicationAdministration is not None:
            namespaceprefix_ = self.MedicationAdministration_nsprefix_ + ':' if (UseCapturedNS_ and self.MedicationAdministration_nsprefix_) else ''
            self.MedicationAdministration.export(outfile, level, namespaceprefix_, namespacedef_='', name_='MedicationAdministration', pretty_print=pretty_print)
        if self.MedicationDispense is not None:
            namespaceprefix_ = self.MedicationDispense_nsprefix_ + ':' if (UseCapturedNS_ and self.MedicationDispense_nsprefix_) else ''
            self.MedicationDispense.export(outfile, level, namespaceprefix_, namespacedef_='', name_='MedicationDispense', pretty_print=pretty_print)
        if self.MedicationKnowledge is not None:
            namespaceprefix_ = self.MedicationKnowledge_nsprefix_ + ':' if (UseCapturedNS_ and self.MedicationKnowledge_nsprefix_) else ''
            self.MedicationKnowledge.export(outfile, level, namespaceprefix_, namespacedef_='', name_='MedicationKnowledge', pretty_print=pretty_print)
        if self.MedicationRequest is not None:
            namespaceprefix_ = self.MedicationRequest_nsprefix_ + ':' if (UseCapturedNS_ and self.MedicationRequest_nsprefix_) else ''
            self.MedicationRequest.export(outfile, level, namespaceprefix_, namespacedef_='', name_='MedicationRequest', pretty_print=pretty_print)
        if self.MedicationStatement is not None:
            namespaceprefix_ = self.MedicationStatement_nsprefix_ + ':' if (UseCapturedNS_ and self.MedicationStatement_nsprefix_) else ''
            self.MedicationStatement.export(outfile, level, namespaceprefix_, namespacedef_='', name_='MedicationStatement', pretty_print=pretty_print)
        if self.MedicinalProductDefinition is not None:
            namespaceprefix_ = self.MedicinalProductDefinition_nsprefix_ + ':' if (UseCapturedNS_ and self.MedicinalProductDefinition_nsprefix_) else ''
            self.MedicinalProductDefinition.export(outfile, level, namespaceprefix_, namespacedef_='', name_='MedicinalProductDefinition', pretty_print=pretty_print)
        if self.MessageDefinition is not None:
            namespaceprefix_ = self.MessageDefinition_nsprefix_ + ':' if (UseCapturedNS_ and self.MessageDefinition_nsprefix_) else ''
            self.MessageDefinition.export(outfile, level, namespaceprefix_, namespacedef_='', name_='MessageDefinition', pretty_print=pretty_print)
        if self.MessageHeader is not None:
            namespaceprefix_ = self.MessageHeader_nsprefix_ + ':' if (UseCapturedNS_ and self.MessageHeader_nsprefix_) else ''
            self.MessageHeader.export(outfile, level, namespaceprefix_, namespacedef_='', name_='MessageHeader', pretty_print=pretty_print)
        if self.MolecularSequence is not None:
            namespaceprefix_ = self.MolecularSequence_nsprefix_ + ':' if (UseCapturedNS_ and self.MolecularSequence_nsprefix_) else ''
            self.MolecularSequence.export(outfile, level, namespaceprefix_, namespacedef_='', name_='MolecularSequence', pretty_print=pretty_print)
        if self.NamingSystem is not None:
            namespaceprefix_ = self.NamingSystem_nsprefix_ + ':' if (UseCapturedNS_ and self.NamingSystem_nsprefix_) else ''
            self.NamingSystem.export(outfile, level, namespaceprefix_, namespacedef_='', name_='NamingSystem', pretty_print=pretty_print)
        if self.NutritionOrder is not None:
            namespaceprefix_ = self.NutritionOrder_nsprefix_ + ':' if (UseCapturedNS_ and self.NutritionOrder_nsprefix_) else ''
            self.NutritionOrder.export(outfile, level, namespaceprefix_, namespacedef_='', name_='NutritionOrder', pretty_print=pretty_print)
        if self.NutritionProduct is not None:
            namespaceprefix_ = self.NutritionProduct_nsprefix_ + ':' if (UseCapturedNS_ and self.NutritionProduct_nsprefix_) else ''
            self.NutritionProduct.export(outfile, level, namespaceprefix_, namespacedef_='', name_='NutritionProduct', pretty_print=pretty_print)
        if self.Observation is not None:
            namespaceprefix_ = self.Observation_nsprefix_ + ':' if (UseCapturedNS_ and self.Observation_nsprefix_) else ''
            self.Observation.export(outfile, level, namespaceprefix_, namespacedef_='', name_='Observation', pretty_print=pretty_print)
        if self.ObservationDefinition is not None:
            namespaceprefix_ = self.ObservationDefinition_nsprefix_ + ':' if (UseCapturedNS_ and self.ObservationDefinition_nsprefix_) else ''
            self.ObservationDefinition.export(outfile, level, namespaceprefix_, namespacedef_='', name_='ObservationDefinition', pretty_print=pretty_print)
        if self.OperationDefinition is not None:
            namespaceprefix_ = self.OperationDefinition_nsprefix_ + ':' if (UseCapturedNS_ and self.OperationDefinition_nsprefix_) else ''
            self.OperationDefinition.export(outfile, level, namespaceprefix_, namespacedef_='', name_='OperationDefinition', pretty_print=pretty_print)
        if self.OperationOutcome is not None:
            namespaceprefix_ = self.OperationOutcome_nsprefix_ + ':' if (UseCapturedNS_ and self.OperationOutcome_nsprefix_) else ''
            self.OperationOutcome.export(outfile, level, namespaceprefix_, namespacedef_='', name_='OperationOutcome', pretty_print=pretty_print)
        if self.Organization is not None:
            namespaceprefix_ = self.Organization_nsprefix_ + ':' if (UseCapturedNS_ and self.Organization_nsprefix_) else ''
            self.Organization.export(outfile, level, namespaceprefix_, namespacedef_='', name_='Organization', pretty_print=pretty_print)
        if self.OrganizationAffiliation is not None:
            namespaceprefix_ = self.OrganizationAffiliation_nsprefix_ + ':' if (UseCapturedNS_ and self.OrganizationAffiliation_nsprefix_) else ''
            self.OrganizationAffiliation.export(outfile, level, namespaceprefix_, namespacedef_='', name_='OrganizationAffiliation', pretty_print=pretty_print)
        if self.PackagedProductDefinition is not None:
            namespaceprefix_ = self.PackagedProductDefinition_nsprefix_ + ':' if (UseCapturedNS_ and self.PackagedProductDefinition_nsprefix_) else ''
            self.PackagedProductDefinition.export(outfile, level, namespaceprefix_, namespacedef_='', name_='PackagedProductDefinition', pretty_print=pretty_print)
        if self.Patient is not None:
            namespaceprefix_ = self.Patient_nsprefix_ + ':' if (UseCapturedNS_ and self.Patient_nsprefix_) else ''
            self.Patient.export(outfile, level, namespaceprefix_, namespacedef_='', name_='Patient', pretty_print=pretty_print)
        if self.PaymentNotice is not None:
            namespaceprefix_ = self.PaymentNotice_nsprefix_ + ':' if (UseCapturedNS_ and self.PaymentNotice_nsprefix_) else ''
            self.PaymentNotice.export(outfile, level, namespaceprefix_, namespacedef_='', name_='PaymentNotice', pretty_print=pretty_print)
        if self.PaymentReconciliation is not None:
            namespaceprefix_ = self.PaymentReconciliation_nsprefix_ + ':' if (UseCapturedNS_ and self.PaymentReconciliation_nsprefix_) else ''
            self.PaymentReconciliation.export(outfile, level, namespaceprefix_, namespacedef_='', name_='PaymentReconciliation', pretty_print=pretty_print)
        if self.Person is not None:
            namespaceprefix_ = self.Person_nsprefix_ + ':' if (UseCapturedNS_ and self.Person_nsprefix_) else ''
            self.Person.export(outfile, level, namespaceprefix_, namespacedef_='', name_='Person', pretty_print=pretty_print)
        if self.PlanDefinition is not None:
            namespaceprefix_ = self.PlanDefinition_nsprefix_ + ':' if (UseCapturedNS_ and self.PlanDefinition_nsprefix_) else ''
            self.PlanDefinition.export(outfile, level, namespaceprefix_, namespacedef_='', name_='PlanDefinition', pretty_print=pretty_print)
        if self.Practitioner is not None:
            namespaceprefix_ = self.Practitioner_nsprefix_ + ':' if (UseCapturedNS_ and self.Practitioner_nsprefix_) else ''
            self.Practitioner.export(outfile, level, namespaceprefix_, namespacedef_='', name_='Practitioner', pretty_print=pretty_print)
        if self.PractitionerRole is not None:
            namespaceprefix_ = self.PractitionerRole_nsprefix_ + ':' if (UseCapturedNS_ and self.PractitionerRole_nsprefix_) else ''
            self.PractitionerRole.export(outfile, level, namespaceprefix_, namespacedef_='', name_='PractitionerRole', pretty_print=pretty_print)
        if self.Procedure is not None:
            namespaceprefix_ = self.Procedure_nsprefix_ + ':' if (UseCapturedNS_ and self.Procedure_nsprefix_) else ''
            self.Procedure.export(outfile, level, namespaceprefix_, namespacedef_='', name_='Procedure', pretty_print=pretty_print)
        if self.Provenance is not None:
            namespaceprefix_ = self.Provenance_nsprefix_ + ':' if (UseCapturedNS_ and self.Provenance_nsprefix_) else ''
            self.Provenance.export(outfile, level, namespaceprefix_, namespacedef_='', name_='Provenance', pretty_print=pretty_print)
        if self.Questionnaire is not None:
            namespaceprefix_ = self.Questionnaire_nsprefix_ + ':' if (UseCapturedNS_ and self.Questionnaire_nsprefix_) else ''
            self.Questionnaire.export(outfile, level, namespaceprefix_, namespacedef_='', name_='Questionnaire', pretty_print=pretty_print)
        if self.QuestionnaireResponse is not None:
            namespaceprefix_ = self.QuestionnaireResponse_nsprefix_ + ':' if (UseCapturedNS_ and self.QuestionnaireResponse_nsprefix_) else ''
            self.QuestionnaireResponse.export(outfile, level, namespaceprefix_, namespacedef_='', name_='QuestionnaireResponse', pretty_print=pretty_print)
        if self.RegulatedAuthorization is not None:
            namespaceprefix_ = self.RegulatedAuthorization_nsprefix_ + ':' if (UseCapturedNS_ and self.RegulatedAuthorization_nsprefix_) else ''
            self.RegulatedAuthorization.export(outfile, level, namespaceprefix_, namespacedef_='', name_='RegulatedAuthorization', pretty_print=pretty_print)
        if self.RelatedPerson is not None:
            namespaceprefix_ = self.RelatedPerson_nsprefix_ + ':' if (UseCapturedNS_ and self.RelatedPerson_nsprefix_) else ''
            self.RelatedPerson.export(outfile, level, namespaceprefix_, namespacedef_='', name_='RelatedPerson', pretty_print=pretty_print)
        if self.RequestGroup is not None:
            namespaceprefix_ = self.RequestGroup_nsprefix_ + ':' if (UseCapturedNS_ and self.RequestGroup_nsprefix_) else ''
            self.RequestGroup.export(outfile, level, namespaceprefix_, namespacedef_='', name_='RequestGroup', pretty_print=pretty_print)
        if self.ResearchDefinition is not None:
            namespaceprefix_ = self.ResearchDefinition_nsprefix_ + ':' if (UseCapturedNS_ and self.ResearchDefinition_nsprefix_) else ''
            self.ResearchDefinition.export(outfile, level, namespaceprefix_, namespacedef_='', name_='ResearchDefinition', pretty_print=pretty_print)
        if self.ResearchElementDefinition is not None:
            namespaceprefix_ = self.ResearchElementDefinition_nsprefix_ + ':' if (UseCapturedNS_ and self.ResearchElementDefinition_nsprefix_) else ''
            self.ResearchElementDefinition.export(outfile, level, namespaceprefix_, namespacedef_='', name_='ResearchElementDefinition', pretty_print=pretty_print)
        if self.ResearchStudy is not None:
            namespaceprefix_ = self.ResearchStudy_nsprefix_ + ':' if (UseCapturedNS_ and self.ResearchStudy_nsprefix_) else ''
            self.ResearchStudy.export(outfile, level, namespaceprefix_, namespacedef_='', name_='ResearchStudy', pretty_print=pretty_print)
        if self.ResearchSubject is not None:
            namespaceprefix_ = self.ResearchSubject_nsprefix_ + ':' if (UseCapturedNS_ and self.ResearchSubject_nsprefix_) else ''
            self.ResearchSubject.export(outfile, level, namespaceprefix_, namespacedef_='', name_='ResearchSubject', pretty_print=pretty_print)
        if self.RiskAssessment is not None:
            namespaceprefix_ = self.RiskAssessment_nsprefix_ + ':' if (UseCapturedNS_ and self.RiskAssessment_nsprefix_) else ''
            self.RiskAssessment.export(outfile, level, namespaceprefix_, namespacedef_='', name_='RiskAssessment', pretty_print=pretty_print)
        if self.Schedule is not None:
            namespaceprefix_ = self.Schedule_nsprefix_ + ':' if (UseCapturedNS_ and self.Schedule_nsprefix_) else ''
            self.Schedule.export(outfile, level, namespaceprefix_, namespacedef_='', name_='Schedule', pretty_print=pretty_print)
        if self.SearchParameter is not None:
            namespaceprefix_ = self.SearchParameter_nsprefix_ + ':' if (UseCapturedNS_ and self.SearchParameter_nsprefix_) else ''
            self.SearchParameter.export(outfile, level, namespaceprefix_, namespacedef_='', name_='SearchParameter', pretty_print=pretty_print)
        if self.ServiceRequest is not None:
            namespaceprefix_ = self.ServiceRequest_nsprefix_ + ':' if (UseCapturedNS_ and self.ServiceRequest_nsprefix_) else ''
            self.ServiceRequest.export(outfile, level, namespaceprefix_, namespacedef_='', name_='ServiceRequest', pretty_print=pretty_print)
        if self.Slot is not None:
            namespaceprefix_ = self.Slot_nsprefix_ + ':' if (UseCapturedNS_ and self.Slot_nsprefix_) else ''
            self.Slot.export(outfile, level, namespaceprefix_, namespacedef_='', name_='Slot', pretty_print=pretty_print)
        if self.Specimen is not None:
            namespaceprefix_ = self.Specimen_nsprefix_ + ':' if (UseCapturedNS_ and self.Specimen_nsprefix_) else ''
            self.Specimen.export(outfile, level, namespaceprefix_, namespacedef_='', name_='Specimen', pretty_print=pretty_print)
        if self.SpecimenDefinition is not None:
            namespaceprefix_ = self.SpecimenDefinition_nsprefix_ + ':' if (UseCapturedNS_ and self.SpecimenDefinition_nsprefix_) else ''
            self.SpecimenDefinition.export(outfile, level, namespaceprefix_, namespacedef_='', name_='SpecimenDefinition', pretty_print=pretty_print)
        if self.StructureDefinition is not None:
            namespaceprefix_ = self.StructureDefinition_nsprefix_ + ':' if (UseCapturedNS_ and self.StructureDefinition_nsprefix_) else ''
            self.StructureDefinition.export(outfile, level, namespaceprefix_, namespacedef_='', name_='StructureDefinition', pretty_print=pretty_print)
        if self.StructureMap is not None:
            namespaceprefix_ = self.StructureMap_nsprefix_ + ':' if (UseCapturedNS_ and self.StructureMap_nsprefix_) else ''
            self.StructureMap.export(outfile, level, namespaceprefix_, namespacedef_='', name_='StructureMap', pretty_print=pretty_print)
        if self.Subscription is not None:
            namespaceprefix_ = self.Subscription_nsprefix_ + ':' if (UseCapturedNS_ and self.Subscription_nsprefix_) else ''
            self.Subscription.export(outfile, level, namespaceprefix_, namespacedef_='', name_='Subscription', pretty_print=pretty_print)
        if self.SubscriptionStatus is not None:
            namespaceprefix_ = self.SubscriptionStatus_nsprefix_ + ':' if (UseCapturedNS_ and self.SubscriptionStatus_nsprefix_) else ''
            self.SubscriptionStatus.export(outfile, level, namespaceprefix_, namespacedef_='', name_='SubscriptionStatus', pretty_print=pretty_print)
        if self.SubscriptionTopic is not None:
            namespaceprefix_ = self.SubscriptionTopic_nsprefix_ + ':' if (UseCapturedNS_ and self.SubscriptionTopic_nsprefix_) else ''
            self.SubscriptionTopic.export(outfile, level, namespaceprefix_, namespacedef_='', name_='SubscriptionTopic', pretty_print=pretty_print)
        if self.Substance is not None:
            namespaceprefix_ = self.Substance_nsprefix_ + ':' if (UseCapturedNS_ and self.Substance_nsprefix_) else ''
            self.Substance.export(outfile, level, namespaceprefix_, namespacedef_='', name_='Substance', pretty_print=pretty_print)
        if self.SubstanceDefinition is not None:
            namespaceprefix_ = self.SubstanceDefinition_nsprefix_ + ':' if (UseCapturedNS_ and self.SubstanceDefinition_nsprefix_) else ''
            self.SubstanceDefinition.export(outfile, level, namespaceprefix_, namespacedef_='', name_='SubstanceDefinition', pretty_print=pretty_print)
        if self.SupplyDelivery is not None:
            namespaceprefix_ = self.SupplyDelivery_nsprefix_ + ':' if (UseCapturedNS_ and self.SupplyDelivery_nsprefix_) else ''
            self.SupplyDelivery.export(outfile, level, namespaceprefix_, namespacedef_='', name_='SupplyDelivery', pretty_print=pretty_print)
        if self.SupplyRequest is not None:
            namespaceprefix_ = self.SupplyRequest_nsprefix_ + ':' if (UseCapturedNS_ and self.SupplyRequest_nsprefix_) else ''
            self.SupplyRequest.export(outfile, level, namespaceprefix_, namespacedef_='', name_='SupplyRequest', pretty_print=pretty_print)
        if self.Task is not None:
            namespaceprefix_ = self.Task_nsprefix_ + ':' if (UseCapturedNS_ and self.Task_nsprefix_) else ''
            self.Task.export(outfile, level, namespaceprefix_, namespacedef_='', name_='Task', pretty_print=pretty_print)
        if self.TerminologyCapabilities is not None:
            namespaceprefix_ = self.TerminologyCapabilities_nsprefix_ + ':' if (UseCapturedNS_ and self.TerminologyCapabilities_nsprefix_) else ''
            self.TerminologyCapabilities.export(outfile, level, namespaceprefix_, namespacedef_='', name_='TerminologyCapabilities', pretty_print=pretty_print)
        if self.TestReport is not None:
            namespaceprefix_ = self.TestReport_nsprefix_ + ':' if (UseCapturedNS_ and self.TestReport_nsprefix_) else ''
            self.TestReport.export(outfile, level, namespaceprefix_, namespacedef_='', name_='TestReport', pretty_print=pretty_print)
        if self.TestScript is not None:
            namespaceprefix_ = self.TestScript_nsprefix_ + ':' if (UseCapturedNS_ and self.TestScript_nsprefix_) else ''
            self.TestScript.export(outfile, level, namespaceprefix_, namespacedef_='', name_='TestScript', pretty_print=pretty_print)
        if self.ValueSet is not None:
            namespaceprefix_ = self.ValueSet_nsprefix_ + ':' if (UseCapturedNS_ and self.ValueSet_nsprefix_) else ''
            self.ValueSet.export(outfile, level, namespaceprefix_, namespacedef_='', name_='ValueSet', pretty_print=pretty_print)
        if self.VerificationResult is not None:
            namespaceprefix_ = self.VerificationResult_nsprefix_ + ':' if (UseCapturedNS_ and self.VerificationResult_nsprefix_) else ''
            self.VerificationResult.export(outfile, level, namespaceprefix_, namespacedef_='', name_='VerificationResult', pretty_print=pretty_print)
        if self.VisionPrescription is not None:
            namespaceprefix_ = self.VisionPrescription_nsprefix_ + ':' if (UseCapturedNS_ and self.VisionPrescription_nsprefix_) else ''
            self.VisionPrescription.export(outfile, level, namespaceprefix_, namespacedef_='', name_='VisionPrescription', pretty_print=pretty_print)
        if self.Parameters is not None:
            namespaceprefix_ = self.Parameters_nsprefix_ + ':' if (UseCapturedNS_ and self.Parameters_nsprefix_) else ''
            self.Parameters.export(outfile, level, namespaceprefix_, namespacedef_='', name_='Parameters', pretty_print=pretty_print)
    def exportJson(self, parent_dict=None, key=None, is_list=False):
        json_dict = dict()
        self.exportJsonAttributes(json_dict)
        self.exportJsonChildren(json_dict)
        return self.exportJsonResult(json_dict, parent_dict, key, is_list)
    def exportJsonResult(self, json_dict, parent_dict, key, is_list, sub_defs=[], attr_defs=[]):
        return json_dict
    def exportJsonAttributes(self, json_dict):
        pass
    def exportJsonChildren(self, json_dict):
        if self.Account is not None:
            child_dict = self.Account.exportJson(json_dict, 'Account', False)
            if child_dict:
                json_dict['Account'] = child_dict
        if self.ActivityDefinition is not None:
            child_dict = self.ActivityDefinition.exportJson(json_dict, 'ActivityDefinition', False)
            if child_dict:
                json_dict['ActivityDefinition'] = child_dict
        if self.AdministrableProductDefinition is not None:
            child_dict = self.AdministrableProductDefinition.exportJson(json_dict, 'AdministrableProductDefinition', False)
            if child_dict:
                json_dict['AdministrableProductDefinition'] = child_dict
        if self.AdverseEvent is not None:
            child_dict = self.AdverseEvent.exportJson(json_dict, 'AdverseEvent', False)
            if child_dict:
                json_dict['AdverseEvent'] = child_dict
        if self.AllergyIntolerance is not None:
            child_dict = self.AllergyIntolerance.exportJson(json_dict, 'AllergyIntolerance', False)
            if child_dict:
                json_dict['AllergyIntolerance'] = child_dict
        if self.Appointment is not None:
            child_dict = self.Appointment.exportJson(json_dict, 'Appointment', False)
            if child_dict:
                json_dict['Appointment'] = child_dict
        if self.AppointmentResponse is not None:
            child_dict = self.AppointmentResponse.exportJson(json_dict, 'AppointmentResponse', False)
            if child_dict:
                json_dict['AppointmentResponse'] = child_dict
        if self.AuditEvent is not None:
            child_dict = self.AuditEvent.exportJson(json_dict, 'AuditEvent', False)
            if child_dict:
                json_dict['AuditEvent'] = child_dict
        if self.Basic is not None:
            child_dict = self.Basic.exportJson(json_dict, 'Basic', False)
            if child_dict:
                json_dict['Basic'] = child_dict
        if self.Binary is not None:
            child_dict = self.Binary.exportJson(json_dict, 'Binary', False)
            if child_dict:
                json_dict['Binary'] = child_dict
        if self.BiologicallyDerivedProduct is not None:
            child_dict = self.BiologicallyDerivedProduct.exportJson(json_dict, 'BiologicallyDerivedProduct', False)
            if child_dict:
                json_dict['BiologicallyDerivedProduct'] = child_dict
        if self.BodyStructure is not None:
            child_dict = self.BodyStructure.exportJson(json_dict, 'BodyStructure', False)
            if child_dict:
                json_dict['BodyStructure'] = child_dict
        if self.Bundle is not None:
            child_dict = self.Bundle.exportJson(json_dict, 'Bundle', False)
            if child_dict:
                json_dict['Bundle'] = child_dict
        if self.CapabilityStatement is not None:
            child_dict = self.CapabilityStatement.exportJson(json_dict, 'CapabilityStatement', False)
            if child_dict:
                json_dict['CapabilityStatement'] = child_dict
        if self.CarePlan is not None:
            child_dict = self.CarePlan.exportJson(json_dict, 'CarePlan', False)
            if child_dict:
                json_dict['CarePlan'] = child_dict
        if self.CareTeam is not None:
            child_dict = self.CareTeam.exportJson(json_dict, 'CareTeam', False)
            if child_dict:
                json_dict['CareTeam'] = child_dict
        if self.CatalogEntry is not None:
            child_dict = self.CatalogEntry.exportJson(json_dict, 'CatalogEntry', False)
            if child_dict:
                json_dict['CatalogEntry'] = child_dict
        if self.ChargeItem is not None:
            child_dict = self.ChargeItem.exportJson(json_dict, 'ChargeItem', False)
            if child_dict:
                json_dict['ChargeItem'] = child_dict
        if self.ChargeItemDefinition is not None:
            child_dict = self.ChargeItemDefinition.exportJson(json_dict, 'ChargeItemDefinition', False)
            if child_dict:
                json_dict['ChargeItemDefinition'] = child_dict
        if self.Citation is not None:
            child_dict = self.Citation.exportJson(json_dict, 'Citation', False)
            if child_dict:
                json_dict['Citation'] = child_dict
        if self.Claim is not None:
            child_dict = self.Claim.exportJson(json_dict, 'Claim', False)
            if child_dict:
                json_dict['Claim'] = child_dict
        if self.ClaimResponse is not None:
            child_dict = self.ClaimResponse.exportJson(json_dict, 'ClaimResponse', False)
            if child_dict:
                json_dict['ClaimResponse'] = child_dict
        if self.ClinicalImpression is not None:
            child_dict = self.ClinicalImpression.exportJson(json_dict, 'ClinicalImpression', False)
            if child_dict:
                json_dict['ClinicalImpression'] = child_dict
        if self.ClinicalUseDefinition is not None:
            child_dict = self.ClinicalUseDefinition.exportJson(json_dict, 'ClinicalUseDefinition', False)
            if child_dict:
                json_dict['ClinicalUseDefinition'] = child_dict
        if self.CodeSystem is not None:
            child_dict = self.CodeSystem.exportJson(json_dict, 'CodeSystem', False)
            if child_dict:
                json_dict['CodeSystem'] = child_dict
        if self.Communication is not None:
            child_dict = self.Communication.exportJson(json_dict, 'Communication', False)
            if child_dict:
                json_dict['Communication'] = child_dict
        if self.CommunicationRequest is not None:
            child_dict = self.CommunicationRequest.exportJson(json_dict, 'CommunicationRequest', False)
            if child_dict:
                json_dict['CommunicationRequest'] = child_dict
        if self.CompartmentDefinition is not None:
            child_dict = self.CompartmentDefinition.exportJson(json_dict, 'CompartmentDefinition', False)
            if child_dict:
                json_dict['CompartmentDefinition'] = child_dict
        if self.Composition is not None:
            child_dict = self.Composition.exportJson(json_dict, 'Composition', False)
            if child_dict:
                json_dict['Composition'] = child_dict
        if self.ConceptMap is not None:
            child_dict = self.ConceptMap.exportJson(json_dict, 'ConceptMap', False)
            if child_dict:
                json_dict['ConceptMap'] = child_dict
        if self.Condition is not None:
            child_dict = self.Condition.exportJson(json_dict, 'Condition', False)
            if child_dict:
                json_dict['Condition'] = child_dict
        if self.Consent is not None:
            child_dict = self.Consent.exportJson(json_dict, 'Consent', False)
            if child_dict:
                json_dict['Consent'] = child_dict
        if self.Contract is not None:
            child_dict = self.Contract.exportJson(json_dict, 'Contract', False)
            if child_dict:
                json_dict['Contract'] = child_dict
        if self.Coverage is not None:
            child_dict = self.Coverage.exportJson(json_dict, 'Coverage', False)
            if child_dict:
                json_dict['Coverage'] = child_dict
        if self.CoverageEligibilityRequest is not None:
            child_dict = self.CoverageEligibilityRequest.exportJson(json_dict, 'CoverageEligibilityRequest', False)
            if child_dict:
                json_dict['CoverageEligibilityRequest'] = child_dict
        if self.CoverageEligibilityResponse is not None:
            child_dict = self.CoverageEligibilityResponse.exportJson(json_dict, 'CoverageEligibilityResponse', False)
            if child_dict:
                json_dict['CoverageEligibilityResponse'] = child_dict
        if self.DetectedIssue is not None:
            child_dict = self.DetectedIssue.exportJson(json_dict, 'DetectedIssue', False)
            if child_dict:
                json_dict['DetectedIssue'] = child_dict
        if self.Device is not None:
            child_dict = self.Device.exportJson(json_dict, 'Device', False)
            if child_dict:
                json_dict['Device'] = child_dict
        if self.DeviceDefinition is not None:
            child_dict = self.DeviceDefinition.exportJson(json_dict, 'DeviceDefinition', False)
            if child_dict:
                json_dict['DeviceDefinition'] = child_dict
        if self.DeviceMetric is not None:
            child_dict = self.DeviceMetric.exportJson(json_dict, 'DeviceMetric', False)
            if child_dict:
                json_dict['DeviceMetric'] = child_dict
        if self.DeviceRequest is not None:
            child_dict = self.DeviceRequest.exportJson(json_dict, 'DeviceRequest', False)
            if child_dict:
                json_dict['DeviceRequest'] = child_dict
        if self.DeviceUseStatement is not None:
            child_dict = self.DeviceUseStatement.exportJson(json_dict, 'DeviceUseStatement', False)
            if child_dict:
                json_dict['DeviceUseStatement'] = child_dict
        if self.DiagnosticReport is not None:
            child_dict = self.DiagnosticReport.exportJson(json_dict, 'DiagnosticReport', False)
            if child_dict:
                json_dict['DiagnosticReport'] = child_dict
        if self.DocumentManifest is not None:
            child_dict = self.DocumentManifest.exportJson(json_dict, 'DocumentManifest', False)
            if child_dict:
                json_dict['DocumentManifest'] = child_dict
        if self.DocumentReference is not None:
            child_dict = self.DocumentReference.exportJson(json_dict, 'DocumentReference', False)
            if child_dict:
                json_dict['DocumentReference'] = child_dict
        if self.Encounter is not None:
            child_dict = self.Encounter.exportJson(json_dict, 'Encounter', False)
            if child_dict:
                json_dict['Encounter'] = child_dict
        if self.Endpoint is not None:
            child_dict = self.Endpoint.exportJson(json_dict, 'Endpoint', False)
            if child_dict:
                json_dict['Endpoint'] = child_dict
        if self.EnrollmentRequest is not None:
            child_dict = self.EnrollmentRequest.exportJson(json_dict, 'EnrollmentRequest', False)
            if child_dict:
                json_dict['EnrollmentRequest'] = child_dict
        if self.EnrollmentResponse is not None:
            child_dict = self.EnrollmentResponse.exportJson(json_dict, 'EnrollmentResponse', False)
            if child_dict:
                json_dict['EnrollmentResponse'] = child_dict
        if self.EpisodeOfCare is not None:
            child_dict = self.EpisodeOfCare.exportJson(json_dict, 'EpisodeOfCare', False)
            if child_dict:
                json_dict['EpisodeOfCare'] = child_dict
        if self.EventDefinition is not None:
            child_dict = self.EventDefinition.exportJson(json_dict, 'EventDefinition', False)
            if child_dict:
                json_dict['EventDefinition'] = child_dict
        if self.Evidence is not None:
            child_dict = self.Evidence.exportJson(json_dict, 'Evidence', False)
            if child_dict:
                json_dict['Evidence'] = child_dict
        if self.EvidenceReport is not None:
            child_dict = self.EvidenceReport.exportJson(json_dict, 'EvidenceReport', False)
            if child_dict:
                json_dict['EvidenceReport'] = child_dict
        if self.EvidenceVariable is not None:
            child_dict = self.EvidenceVariable.exportJson(json_dict, 'EvidenceVariable', False)
            if child_dict:
                json_dict['EvidenceVariable'] = child_dict
        if self.ExampleScenario is not None:
            child_dict = self.ExampleScenario.exportJson(json_dict, 'ExampleScenario', False)
            if child_dict:
                json_dict['ExampleScenario'] = child_dict
        if self.ExplanationOfBenefit is not None:
            child_dict = self.ExplanationOfBenefit.exportJson(json_dict, 'ExplanationOfBenefit', False)
            if child_dict:
                json_dict['ExplanationOfBenefit'] = child_dict
        if self.FamilyMemberHistory is not None:
            child_dict = self.FamilyMemberHistory.exportJson(json_dict, 'FamilyMemberHistory', False)
            if child_dict:
                json_dict['FamilyMemberHistory'] = child_dict
        if self.Flag is not None:
            child_dict = self.Flag.exportJson(json_dict, 'Flag', False)
            if child_dict:
                json_dict['Flag'] = child_dict
        if self.Goal is not None:
            child_dict = self.Goal.exportJson(json_dict, 'Goal', False)
            if child_dict:
                json_dict['Goal'] = child_dict
        if self.GraphDefinition is not None:
            child_dict = self.GraphDefinition.exportJson(json_dict, 'GraphDefinition', False)
            if child_dict:
                json_dict['GraphDefinition'] = child_dict
        if self.Group is not None:
            child_dict = self.Group.exportJson(json_dict, 'Group', False)
            if child_dict:
                json_dict['Group'] = child_dict
        if self.GuidanceResponse is not None:
            child_dict = self.GuidanceResponse.exportJson(json_dict, 'GuidanceResponse', False)
            if child_dict:
                json_dict['GuidanceResponse'] = child_dict
        if self.HealthcareService is not None:
            child_dict = self.HealthcareService.exportJson(json_dict, 'HealthcareService', False)
            if child_dict:
                json_dict['HealthcareService'] = child_dict
        if self.ImagingStudy is not None:
            child_dict = self.ImagingStudy.exportJson(json_dict, 'ImagingStudy', False)
            if child_dict:
                json_dict['ImagingStudy'] = child_dict
        if self.Immunization is not None:
            child_dict = self.Immunization.exportJson(json_dict, 'Immunization', False)
            if child_dict:
                json_dict['Immunization'] = child_dict
        if self.ImmunizationEvaluation is not None:
            child_dict = self.ImmunizationEvaluation.exportJson(json_dict, 'ImmunizationEvaluation', False)
            if child_dict:
                json_dict['ImmunizationEvaluation'] = child_dict
        if self.ImmunizationRecommendation is not None:
            child_dict = self.ImmunizationRecommendation.exportJson(json_dict, 'ImmunizationRecommendation', False)
            if child_dict:
                json_dict['ImmunizationRecommendation'] = child_dict
        if self.ImplementationGuide is not None:
            child_dict = self.ImplementationGuide.exportJson(json_dict, 'ImplementationGuide', False)
            if child_dict:
                json_dict['ImplementationGuide'] = child_dict
        if self.Ingredient is not None:
            child_dict = self.Ingredient.exportJson(json_dict, 'Ingredient', False)
            if child_dict:
                json_dict['Ingredient'] = child_dict
        if self.InsurancePlan is not None:
            child_dict = self.InsurancePlan.exportJson(json_dict, 'InsurancePlan', False)
            if child_dict:
                json_dict['InsurancePlan'] = child_dict
        if self.Invoice is not None:
            child_dict = self.Invoice.exportJson(json_dict, 'Invoice', False)
            if child_dict:
                json_dict['Invoice'] = child_dict
        if self.Library is not None:
            child_dict = self.Library.exportJson(json_dict, 'Library', False)
            if child_dict:
                json_dict['Library'] = child_dict
        if self.Linkage is not None:
            child_dict = self.Linkage.exportJson(json_dict, 'Linkage', False)
            if child_dict:
                json_dict['Linkage'] = child_dict
        if self.List is not None:
            child_dict = self.List.exportJson(json_dict, 'List', False)
            if child_dict:
                json_dict['List'] = child_dict
        if self.Location is not None:
            child_dict = self.Location.exportJson(json_dict, 'Location', False)
            if child_dict:
                json_dict['Location'] = child_dict
        if self.ManufacturedItemDefinition is not None:
            child_dict = self.ManufacturedItemDefinition.exportJson(json_dict, 'ManufacturedItemDefinition', False)
            if child_dict:
                json_dict['ManufacturedItemDefinition'] = child_dict
        if self.Measure is not None:
            child_dict = self.Measure.exportJson(json_dict, 'Measure', False)
            if child_dict:
                json_dict['Measure'] = child_dict
        if self.MeasureReport is not None:
            child_dict = self.MeasureReport.exportJson(json_dict, 'MeasureReport', False)
            if child_dict:
                json_dict['MeasureReport'] = child_dict
        if self.Media is not None:
            child_dict = self.Media.exportJson(json_dict, 'Media', False)
            if child_dict:
                json_dict['Media'] = child_dict
        if self.Medication is not None:
            child_dict = self.Medication.exportJson(json_dict, 'Medication', False)
            if child_dict:
                json_dict['Medication'] = child_dict
        if self.MedicationAdministration is not None:
            child_dict = self.MedicationAdministration.exportJson(json_dict, 'MedicationAdministration', False)
            if child_dict:
                json_dict['MedicationAdministration'] = child_dict
        if self.MedicationDispense is not None:
            child_dict = self.MedicationDispense.exportJson(json_dict, 'MedicationDispense', False)
            if child_dict:
                json_dict['MedicationDispense'] = child_dict
        if self.MedicationKnowledge is not None:
            child_dict = self.MedicationKnowledge.exportJson(json_dict, 'MedicationKnowledge', False)
            if child_dict:
                json_dict['MedicationKnowledge'] = child_dict
        if self.MedicationRequest is not None:
            child_dict = self.MedicationRequest.exportJson(json_dict, 'MedicationRequest', False)
            if child_dict:
                json_dict['MedicationRequest'] = child_dict
        if self.MedicationStatement is not None:
            child_dict = self.MedicationStatement.exportJson(json_dict, 'MedicationStatement', False)
            if child_dict:
                json_dict['MedicationStatement'] = child_dict
        if self.MedicinalProductDefinition is not None:
            child_dict = self.MedicinalProductDefinition.exportJson(json_dict, 'MedicinalProductDefinition', False)
            if child_dict:
                json_dict['MedicinalProductDefinition'] = child_dict
        if self.MessageDefinition is not None:
            child_dict = self.MessageDefinition.exportJson(json_dict, 'MessageDefinition', False)
            if child_dict:
                json_dict['MessageDefinition'] = child_dict
        if self.MessageHeader is not None:
            child_dict = self.MessageHeader.exportJson(json_dict, 'MessageHeader', False)
            if child_dict:
                json_dict['MessageHeader'] = child_dict
        if self.MolecularSequence is not None:
            child_dict = self.MolecularSequence.exportJson(json_dict, 'MolecularSequence', False)
            if child_dict:
                json_dict['MolecularSequence'] = child_dict
        if self.NamingSystem is not None:
            child_dict = self.NamingSystem.exportJson(json_dict, 'NamingSystem', False)
            if child_dict:
                json_dict['NamingSystem'] = child_dict
        if self.NutritionOrder is not None:
            child_dict = self.NutritionOrder.exportJson(json_dict, 'NutritionOrder', False)
            if child_dict:
                json_dict['NutritionOrder'] = child_dict
        if self.NutritionProduct is not None:
            child_dict = self.NutritionProduct.exportJson(json_dict, 'NutritionProduct', False)
            if child_dict:
                json_dict['NutritionProduct'] = child_dict
        if self.Observation is not None:
            child_dict = self.Observation.exportJson(json_dict, 'Observation', False)
            if child_dict:
                json_dict['Observation'] = child_dict
        if self.ObservationDefinition is not None:
            child_dict = self.ObservationDefinition.exportJson(json_dict, 'ObservationDefinition', False)
            if child_dict:
                json_dict['ObservationDefinition'] = child_dict
        if self.OperationDefinition is not None:
            child_dict = self.OperationDefinition.exportJson(json_dict, 'OperationDefinition', False)
            if child_dict:
                json_dict['OperationDefinition'] = child_dict
        if self.OperationOutcome is not None:
            child_dict = self.OperationOutcome.exportJson(json_dict, 'OperationOutcome', False)
            if child_dict:
                json_dict['OperationOutcome'] = child_dict
        if self.Organization is not None:
            child_dict = self.Organization.exportJson(json_dict, 'Organization', False)
            if child_dict:
                json_dict['Organization'] = child_dict
        if self.OrganizationAffiliation is not None:
            child_dict = self.OrganizationAffiliation.exportJson(json_dict, 'OrganizationAffiliation', False)
            if child_dict:
                json_dict['OrganizationAffiliation'] = child_dict
        if self.PackagedProductDefinition is not None:
            child_dict = self.PackagedProductDefinition.exportJson(json_dict, 'PackagedProductDefinition', False)
            if child_dict:
                json_dict['PackagedProductDefinition'] = child_dict
        if self.Patient is not None:
            child_dict = self.Patient.exportJson(json_dict, 'Patient', False)
            if child_dict:
                json_dict['Patient'] = child_dict
        if self.PaymentNotice is not None:
            child_dict = self.PaymentNotice.exportJson(json_dict, 'PaymentNotice', False)
            if child_dict:
                json_dict['PaymentNotice'] = child_dict
        if self.PaymentReconciliation is not None:
            child_dict = self.PaymentReconciliation.exportJson(json_dict, 'PaymentReconciliation', False)
            if child_dict:
                json_dict['PaymentReconciliation'] = child_dict
        if self.Person is not None:
            child_dict = self.Person.exportJson(json_dict, 'Person', False)
            if child_dict:
                json_dict['Person'] = child_dict
        if self.PlanDefinition is not None:
            child_dict = self.PlanDefinition.exportJson(json_dict, 'PlanDefinition', False)
            if child_dict:
                json_dict['PlanDefinition'] = child_dict
        if self.Practitioner is not None:
            child_dict = self.Practitioner.exportJson(json_dict, 'Practitioner', False)
            if child_dict:
                json_dict['Practitioner'] = child_dict
        if self.PractitionerRole is not None:
            child_dict = self.PractitionerRole.exportJson(json_dict, 'PractitionerRole', False)
            if child_dict:
                json_dict['PractitionerRole'] = child_dict
        if self.Procedure is not None:
            child_dict = self.Procedure.exportJson(json_dict, 'Procedure', False)
            if child_dict:
                json_dict['Procedure'] = child_dict
        if self.Provenance is not None:
            child_dict = self.Provenance.exportJson(json_dict, 'Provenance', False)
            if child_dict:
                json_dict['Provenance'] = child_dict
        if self.Questionnaire is not None:
            child_dict = self.Questionnaire.exportJson(json_dict, 'Questionnaire', False)
            if child_dict:
                json_dict['Questionnaire'] = child_dict
        if self.QuestionnaireResponse is not None:
            child_dict = self.QuestionnaireResponse.exportJson(json_dict, 'QuestionnaireResponse', False)
            if child_dict:
                json_dict['QuestionnaireResponse'] = child_dict
        if self.RegulatedAuthorization is not None:
            child_dict = self.RegulatedAuthorization.exportJson(json_dict, 'RegulatedAuthorization', False)
            if child_dict:
                json_dict['RegulatedAuthorization'] = child_dict
        if self.RelatedPerson is not None:
            child_dict = self.RelatedPerson.exportJson(json_dict, 'RelatedPerson', False)
            if child_dict:
                json_dict['RelatedPerson'] = child_dict
        if self.RequestGroup is not None:
            child_dict = self.RequestGroup.exportJson(json_dict, 'RequestGroup', False)
            if child_dict:
                json_dict['RequestGroup'] = child_dict
        if self.ResearchDefinition is not None:
            child_dict = self.ResearchDefinition.exportJson(json_dict, 'ResearchDefinition', False)
            if child_dict:
                json_dict['ResearchDefinition'] = child_dict
        if self.ResearchElementDefinition is not None:
            child_dict = self.ResearchElementDefinition.exportJson(json_dict, 'ResearchElementDefinition', False)
            if child_dict:
                json_dict['ResearchElementDefinition'] = child_dict
        if self.ResearchStudy is not None:
            child_dict = self.ResearchStudy.exportJson(json_dict, 'ResearchStudy', False)
            if child_dict:
                json_dict['ResearchStudy'] = child_dict
        if self.ResearchSubject is not None:
            child_dict = self.ResearchSubject.exportJson(json_dict, 'ResearchSubject', False)
            if child_dict:
                json_dict['ResearchSubject'] = child_dict
        if self.RiskAssessment is not None:
            child_dict = self.RiskAssessment.exportJson(json_dict, 'RiskAssessment', False)
            if child_dict:
                json_dict['RiskAssessment'] = child_dict
        if self.Schedule is not None:
            child_dict = self.Schedule.exportJson(json_dict, 'Schedule', False)
            if child_dict:
                json_dict['Schedule'] = child_dict
        if self.SearchParameter is not None:
            child_dict = self.SearchParameter.exportJson(json_dict, 'SearchParameter', False)
            if child_dict:
                json_dict['SearchParameter'] = child_dict
        if self.ServiceRequest is not None:
            child_dict = self.ServiceRequest.exportJson(json_dict, 'ServiceRequest', False)
            if child_dict:
                json_dict['ServiceRequest'] = child_dict
        if self.Slot is not None:
            child_dict = self.Slot.exportJson(json_dict, 'Slot', False)
            if child_dict:
                json_dict['Slot'] = child_dict
        if self.Specimen is not None:
            child_dict = self.Specimen.exportJson(json_dict, 'Specimen', False)
            if child_dict:
                json_dict['Specimen'] = child_dict
        if self.SpecimenDefinition is not None:
            child_dict = self.SpecimenDefinition.exportJson(json_dict, 'SpecimenDefinition', False)
            if child_dict:
                json_dict['SpecimenDefinition'] = child_dict
        if self.StructureDefinition is not None:
            child_dict = self.StructureDefinition.exportJson(json_dict, 'StructureDefinition', False)
            if child_dict:
                json_dict['StructureDefinition'] = child_dict
        if self.StructureMap is not None:
            child_dict = self.StructureMap.exportJson(json_dict, 'StructureMap', False)
            if child_dict:
                json_dict['StructureMap'] = child_dict
        if self.Subscription is not None:
            child_dict = self.Subscription.exportJson(json_dict, 'Subscription', False)
            if child_dict:
                json_dict['Subscription'] = child_dict
        if self.SubscriptionStatus is not None:
            child_dict = self.SubscriptionStatus.exportJson(json_dict, 'SubscriptionStatus', False)
            if child_dict:
                json_dict['SubscriptionStatus'] = child_dict
        if self.SubscriptionTopic is not None:
            child_dict = self.SubscriptionTopic.exportJson(json_dict, 'SubscriptionTopic', False)
            if child_dict:
                json_dict['SubscriptionTopic'] = child_dict
        if self.Substance is not None:
            child_dict = self.Substance.exportJson(json_dict, 'Substance', False)
            if child_dict:
                json_dict['Substance'] = child_dict
        if self.SubstanceDefinition is not None:
            child_dict = self.SubstanceDefinition.exportJson(json_dict, 'SubstanceDefinition', False)
            if child_dict:
                json_dict['SubstanceDefinition'] = child_dict
        if self.SupplyDelivery is not None:
            child_dict = self.SupplyDelivery.exportJson(json_dict, 'SupplyDelivery', False)
            if child_dict:
                json_dict['SupplyDelivery'] = child_dict
        if self.SupplyRequest is not None:
            child_dict = self.SupplyRequest.exportJson(json_dict, 'SupplyRequest', False)
            if child_dict:
                json_dict['SupplyRequest'] = child_dict
        if self.Task is not None:
            child_dict = self.Task.exportJson(json_dict, 'Task', False)
            if child_dict:
                json_dict['Task'] = child_dict
        if self.TerminologyCapabilities is not None:
            child_dict = self.TerminologyCapabilities.exportJson(json_dict, 'TerminologyCapabilities', False)
            if child_dict:
                json_dict['TerminologyCapabilities'] = child_dict
        if self.TestReport is not None:
            child_dict = self.TestReport.exportJson(json_dict, 'TestReport', False)
            if child_dict:
                json_dict['TestReport'] = child_dict
        if self.TestScript is not None:
            child_dict = self.TestScript.exportJson(json_dict, 'TestScript', False)
            if child_dict:
                json_dict['TestScript'] = child_dict
        if self.ValueSet is not None:
            child_dict = self.ValueSet.exportJson(json_dict, 'ValueSet', False)
            if child_dict:
                json_dict['ValueSet'] = child_dict
        if self.VerificationResult is not None:
            child_dict = self.VerificationResult.exportJson(json_dict, 'VerificationResult', False)
            if child_dict:
                json_dict['VerificationResult'] = child_dict
        if self.VisionPrescription is not None:
            child_dict = self.VisionPrescription.exportJson(json_dict, 'VisionPrescription', False)
            if child_dict:
                json_dict['VisionPrescription'] = child_dict
        if self.Parameters is not None:
            child_dict = self.Parameters.exportJson(json_dict, 'Parameters', False)
            if child_dict:
                json_dict['Parameters'] = child_dict
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        if SaveNodeDict:
            node_dict[node] = self 
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        pass
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'Account':
            obj_ = Account.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.Account = obj_
            obj_.original_tagname_ = 'Account'
        elif nodeName_ == 'ActivityDefinition':
            obj_ = ActivityDefinition.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.ActivityDefinition = obj_
            obj_.original_tagname_ = 'ActivityDefinition'
        elif nodeName_ == 'AdministrableProductDefinition':
            obj_ = AdministrableProductDefinition.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.AdministrableProductDefinition = obj_
            obj_.original_tagname_ = 'AdministrableProductDefinition'
        elif nodeName_ == 'AdverseEvent':
            obj_ = AdverseEvent.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.AdverseEvent = obj_
            obj_.original_tagname_ = 'AdverseEvent'
        elif nodeName_ == 'AllergyIntolerance':
            obj_ = AllergyIntolerance.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.AllergyIntolerance = obj_
            obj_.original_tagname_ = 'AllergyIntolerance'
        elif nodeName_ == 'Appointment':
            obj_ = Appointment.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.Appointment = obj_
            obj_.original_tagname_ = 'Appointment'
        elif nodeName_ == 'AppointmentResponse':
            obj_ = AppointmentResponse.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.AppointmentResponse = obj_
            obj_.original_tagname_ = 'AppointmentResponse'
        elif nodeName_ == 'AuditEvent':
            obj_ = AuditEvent.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.AuditEvent = obj_
            obj_.original_tagname_ = 'AuditEvent'
        elif nodeName_ == 'Basic':
            obj_ = Basic.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.Basic = obj_
            obj_.original_tagname_ = 'Basic'
        elif nodeName_ == 'Binary':
            obj_ = Binary.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.Binary = obj_
            obj_.original_tagname_ = 'Binary'
        elif nodeName_ == 'BiologicallyDerivedProduct':
            obj_ = BiologicallyDerivedProduct.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.BiologicallyDerivedProduct = obj_
            obj_.original_tagname_ = 'BiologicallyDerivedProduct'
        elif nodeName_ == 'BodyStructure':
            obj_ = BodyStructure.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.BodyStructure = obj_
            obj_.original_tagname_ = 'BodyStructure'
        elif nodeName_ == 'Bundle':
            obj_ = Bundle.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.Bundle = obj_
            obj_.original_tagname_ = 'Bundle'
        elif nodeName_ == 'CapabilityStatement':
            obj_ = CapabilityStatement.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.CapabilityStatement = obj_
            obj_.original_tagname_ = 'CapabilityStatement'
        elif nodeName_ == 'CarePlan':
            obj_ = CarePlan.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.CarePlan = obj_
            obj_.original_tagname_ = 'CarePlan'
        elif nodeName_ == 'CareTeam':
            obj_ = CareTeam.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.CareTeam = obj_
            obj_.original_tagname_ = 'CareTeam'
        elif nodeName_ == 'CatalogEntry':
            obj_ = CatalogEntry.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.CatalogEntry = obj_
            obj_.original_tagname_ = 'CatalogEntry'
        elif nodeName_ == 'ChargeItem':
            obj_ = ChargeItem.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.ChargeItem = obj_
            obj_.original_tagname_ = 'ChargeItem'
        elif nodeName_ == 'ChargeItemDefinition':
            obj_ = ChargeItemDefinition.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.ChargeItemDefinition = obj_
            obj_.original_tagname_ = 'ChargeItemDefinition'
        elif nodeName_ == 'Citation':
            obj_ = Citation.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.Citation = obj_
            obj_.original_tagname_ = 'Citation'
        elif nodeName_ == 'Claim':
            obj_ = Claim.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.Claim = obj_
            obj_.original_tagname_ = 'Claim'
        elif nodeName_ == 'ClaimResponse':
            obj_ = ClaimResponse.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.ClaimResponse = obj_
            obj_.original_tagname_ = 'ClaimResponse'
        elif nodeName_ == 'ClinicalImpression':
            obj_ = ClinicalImpression.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.ClinicalImpression = obj_
            obj_.original_tagname_ = 'ClinicalImpression'
        elif nodeName_ == 'ClinicalUseDefinition':
            obj_ = ClinicalUseDefinition.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.ClinicalUseDefinition = obj_
            obj_.original_tagname_ = 'ClinicalUseDefinition'
        elif nodeName_ == 'CodeSystem':
            obj_ = CodeSystem.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.CodeSystem = obj_
            obj_.original_tagname_ = 'CodeSystem'
        elif nodeName_ == 'Communication':
            obj_ = Communication.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.Communication = obj_
            obj_.original_tagname_ = 'Communication'
        elif nodeName_ == 'CommunicationRequest':
            obj_ = CommunicationRequest.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.CommunicationRequest = obj_
            obj_.original_tagname_ = 'CommunicationRequest'
        elif nodeName_ == 'CompartmentDefinition':
            obj_ = CompartmentDefinition.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.CompartmentDefinition = obj_
            obj_.original_tagname_ = 'CompartmentDefinition'
        elif nodeName_ == 'Composition':
            obj_ = Composition.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.Composition = obj_
            obj_.original_tagname_ = 'Composition'
        elif nodeName_ == 'ConceptMap':
            obj_ = ConceptMap.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.ConceptMap = obj_
            obj_.original_tagname_ = 'ConceptMap'
        elif nodeName_ == 'Condition':
            obj_ = Condition.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.Condition = obj_
            obj_.original_tagname_ = 'Condition'
        elif nodeName_ == 'Consent':
            obj_ = Consent.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.Consent = obj_
            obj_.original_tagname_ = 'Consent'
        elif nodeName_ == 'Contract':
            obj_ = Contract.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.Contract = obj_
            obj_.original_tagname_ = 'Contract'
        elif nodeName_ == 'Coverage':
            obj_ = Coverage.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.Coverage = obj_
            obj_.original_tagname_ = 'Coverage'
        elif nodeName_ == 'CoverageEligibilityRequest':
            obj_ = CoverageEligibilityRequest.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.CoverageEligibilityRequest = obj_
            obj_.original_tagname_ = 'CoverageEligibilityRequest'
        elif nodeName_ == 'CoverageEligibilityResponse':
            obj_ = CoverageEligibilityResponse.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.CoverageEligibilityResponse = obj_
            obj_.original_tagname_ = 'CoverageEligibilityResponse'
        elif nodeName_ == 'DetectedIssue':
            obj_ = DetectedIssue.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.DetectedIssue = obj_
            obj_.original_tagname_ = 'DetectedIssue'
        elif nodeName_ == 'Device':
            obj_ = Device.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.Device = obj_
            obj_.original_tagname_ = 'Device'
        elif nodeName_ == 'DeviceDefinition':
            obj_ = DeviceDefinition.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.DeviceDefinition = obj_
            obj_.original_tagname_ = 'DeviceDefinition'
        elif nodeName_ == 'DeviceMetric':
            obj_ = DeviceMetric.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.DeviceMetric = obj_
            obj_.original_tagname_ = 'DeviceMetric'
        elif nodeName_ == 'DeviceRequest':
            obj_ = DeviceRequest.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.DeviceRequest = obj_
            obj_.original_tagname_ = 'DeviceRequest'
        elif nodeName_ == 'DeviceUseStatement':
            obj_ = DeviceUseStatement.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.DeviceUseStatement = obj_
            obj_.original_tagname_ = 'DeviceUseStatement'
        elif nodeName_ == 'DiagnosticReport':
            obj_ = DiagnosticReport.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.DiagnosticReport = obj_
            obj_.original_tagname_ = 'DiagnosticReport'
        elif nodeName_ == 'DocumentManifest':
            obj_ = DocumentManifest.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.DocumentManifest = obj_
            obj_.original_tagname_ = 'DocumentManifest'
        elif nodeName_ == 'DocumentReference':
            obj_ = DocumentReference.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.DocumentReference = obj_
            obj_.original_tagname_ = 'DocumentReference'
        elif nodeName_ == 'Encounter':
            obj_ = Encounter.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.Encounter = obj_
            obj_.original_tagname_ = 'Encounter'
        elif nodeName_ == 'Endpoint':
            obj_ = Endpoint.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.Endpoint = obj_
            obj_.original_tagname_ = 'Endpoint'
        elif nodeName_ == 'EnrollmentRequest':
            obj_ = EnrollmentRequest.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.EnrollmentRequest = obj_
            obj_.original_tagname_ = 'EnrollmentRequest'
        elif nodeName_ == 'EnrollmentResponse':
            obj_ = EnrollmentResponse.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.EnrollmentResponse = obj_
            obj_.original_tagname_ = 'EnrollmentResponse'
        elif nodeName_ == 'EpisodeOfCare':
            obj_ = EpisodeOfCare.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.EpisodeOfCare = obj_
            obj_.original_tagname_ = 'EpisodeOfCare'
        elif nodeName_ == 'EventDefinition':
            obj_ = EventDefinition.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.EventDefinition = obj_
            obj_.original_tagname_ = 'EventDefinition'
        elif nodeName_ == 'Evidence':
            obj_ = Evidence.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.Evidence = obj_
            obj_.original_tagname_ = 'Evidence'
        elif nodeName_ == 'EvidenceReport':
            obj_ = EvidenceReport.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.EvidenceReport = obj_
            obj_.original_tagname_ = 'EvidenceReport'
        elif nodeName_ == 'EvidenceVariable':
            obj_ = EvidenceVariable.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.EvidenceVariable = obj_
            obj_.original_tagname_ = 'EvidenceVariable'
        elif nodeName_ == 'ExampleScenario':
            obj_ = ExampleScenario.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.ExampleScenario = obj_
            obj_.original_tagname_ = 'ExampleScenario'
        elif nodeName_ == 'ExplanationOfBenefit':
            obj_ = ExplanationOfBenefit.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.ExplanationOfBenefit = obj_
            obj_.original_tagname_ = 'ExplanationOfBenefit'
        elif nodeName_ == 'FamilyMemberHistory':
            obj_ = FamilyMemberHistory.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.FamilyMemberHistory = obj_
            obj_.original_tagname_ = 'FamilyMemberHistory'
        elif nodeName_ == 'Flag':
            obj_ = Flag.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.Flag = obj_
            obj_.original_tagname_ = 'Flag'
        elif nodeName_ == 'Goal':
            obj_ = Goal.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.Goal = obj_
            obj_.original_tagname_ = 'Goal'
        elif nodeName_ == 'GraphDefinition':
            obj_ = GraphDefinition.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.GraphDefinition = obj_
            obj_.original_tagname_ = 'GraphDefinition'
        elif nodeName_ == 'Group':
            obj_ = Group.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.Group = obj_
            obj_.original_tagname_ = 'Group'
        elif nodeName_ == 'GuidanceResponse':
            obj_ = GuidanceResponse.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.GuidanceResponse = obj_
            obj_.original_tagname_ = 'GuidanceResponse'
        elif nodeName_ == 'HealthcareService':
            obj_ = HealthcareService.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.HealthcareService = obj_
            obj_.original_tagname_ = 'HealthcareService'
        elif nodeName_ == 'ImagingStudy':
            obj_ = ImagingStudy.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.ImagingStudy = obj_
            obj_.original_tagname_ = 'ImagingStudy'
        elif nodeName_ == 'Immunization':
            obj_ = Immunization.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.Immunization = obj_
            obj_.original_tagname_ = 'Immunization'
        elif nodeName_ == 'ImmunizationEvaluation':
            obj_ = ImmunizationEvaluation.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.ImmunizationEvaluation = obj_
            obj_.original_tagname_ = 'ImmunizationEvaluation'
        elif nodeName_ == 'ImmunizationRecommendation':
            obj_ = ImmunizationRecommendation.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.ImmunizationRecommendation = obj_
            obj_.original_tagname_ = 'ImmunizationRecommendation'
        elif nodeName_ == 'ImplementationGuide':
            obj_ = ImplementationGuide.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.ImplementationGuide = obj_
            obj_.original_tagname_ = 'ImplementationGuide'
        elif nodeName_ == 'Ingredient':
            obj_ = Ingredient.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.Ingredient = obj_
            obj_.original_tagname_ = 'Ingredient'
        elif nodeName_ == 'InsurancePlan':
            obj_ = InsurancePlan.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.InsurancePlan = obj_
            obj_.original_tagname_ = 'InsurancePlan'
        elif nodeName_ == 'Invoice':
            obj_ = Invoice.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.Invoice = obj_
            obj_.original_tagname_ = 'Invoice'
        elif nodeName_ == 'Library':
            obj_ = Library.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.Library = obj_
            obj_.original_tagname_ = 'Library'
        elif nodeName_ == 'Linkage':
            obj_ = Linkage.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.Linkage = obj_
            obj_.original_tagname_ = 'Linkage'
        elif nodeName_ == 'List':
            obj_ = List.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.List = obj_
            obj_.original_tagname_ = 'List'
        elif nodeName_ == 'Location':
            obj_ = Location.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.Location = obj_
            obj_.original_tagname_ = 'Location'
        elif nodeName_ == 'ManufacturedItemDefinition':
            obj_ = ManufacturedItemDefinition.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.ManufacturedItemDefinition = obj_
            obj_.original_tagname_ = 'ManufacturedItemDefinition'
        elif nodeName_ == 'Measure':
            obj_ = Measure.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.Measure = obj_
            obj_.original_tagname_ = 'Measure'
        elif nodeName_ == 'MeasureReport':
            obj_ = MeasureReport.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.MeasureReport = obj_
            obj_.original_tagname_ = 'MeasureReport'
        elif nodeName_ == 'Media':
            obj_ = Media.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.Media = obj_
            obj_.original_tagname_ = 'Media'
        elif nodeName_ == 'Medication':
            obj_ = Medication.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.Medication = obj_
            obj_.original_tagname_ = 'Medication'
        elif nodeName_ == 'MedicationAdministration':
            obj_ = MedicationAdministration.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.MedicationAdministration = obj_
            obj_.original_tagname_ = 'MedicationAdministration'
        elif nodeName_ == 'MedicationDispense':
            obj_ = MedicationDispense.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.MedicationDispense = obj_
            obj_.original_tagname_ = 'MedicationDispense'
        elif nodeName_ == 'MedicationKnowledge':
            obj_ = MedicationKnowledge.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.MedicationKnowledge = obj_
            obj_.original_tagname_ = 'MedicationKnowledge'
        elif nodeName_ == 'MedicationRequest':
            obj_ = MedicationRequest.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.MedicationRequest = obj_
            obj_.original_tagname_ = 'MedicationRequest'
        elif nodeName_ == 'MedicationStatement':
            obj_ = MedicationStatement.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.MedicationStatement = obj_
            obj_.original_tagname_ = 'MedicationStatement'
        elif nodeName_ == 'MedicinalProductDefinition':
            obj_ = MedicinalProductDefinition.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.MedicinalProductDefinition = obj_
            obj_.original_tagname_ = 'MedicinalProductDefinition'
        elif nodeName_ == 'MessageDefinition':
            obj_ = MessageDefinition.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.MessageDefinition = obj_
            obj_.original_tagname_ = 'MessageDefinition'
        elif nodeName_ == 'MessageHeader':
            obj_ = MessageHeader.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.MessageHeader = obj_
            obj_.original_tagname_ = 'MessageHeader'
        elif nodeName_ == 'MolecularSequence':
            obj_ = MolecularSequence.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.MolecularSequence = obj_
            obj_.original_tagname_ = 'MolecularSequence'
        elif nodeName_ == 'NamingSystem':
            obj_ = NamingSystem.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.NamingSystem = obj_
            obj_.original_tagname_ = 'NamingSystem'
        elif nodeName_ == 'NutritionOrder':
            obj_ = NutritionOrder.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.NutritionOrder = obj_
            obj_.original_tagname_ = 'NutritionOrder'
        elif nodeName_ == 'NutritionProduct':
            obj_ = NutritionProduct.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.NutritionProduct = obj_
            obj_.original_tagname_ = 'NutritionProduct'
        elif nodeName_ == 'Observation':
            obj_ = Observation.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.Observation = obj_
            obj_.original_tagname_ = 'Observation'
        elif nodeName_ == 'ObservationDefinition':
            obj_ = ObservationDefinition.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.ObservationDefinition = obj_
            obj_.original_tagname_ = 'ObservationDefinition'
        elif nodeName_ == 'OperationDefinition':
            obj_ = OperationDefinition.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.OperationDefinition = obj_
            obj_.original_tagname_ = 'OperationDefinition'
        elif nodeName_ == 'OperationOutcome':
            obj_ = OperationOutcome.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.OperationOutcome = obj_
            obj_.original_tagname_ = 'OperationOutcome'
        elif nodeName_ == 'Organization':
            obj_ = Organization.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.Organization = obj_
            obj_.original_tagname_ = 'Organization'
        elif nodeName_ == 'OrganizationAffiliation':
            obj_ = OrganizationAffiliation.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.OrganizationAffiliation = obj_
            obj_.original_tagname_ = 'OrganizationAffiliation'
        elif nodeName_ == 'PackagedProductDefinition':
            obj_ = PackagedProductDefinition.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.PackagedProductDefinition = obj_
            obj_.original_tagname_ = 'PackagedProductDefinition'
        elif nodeName_ == 'Patient':
            obj_ = Patient.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.Patient = obj_
            obj_.original_tagname_ = 'Patient'
        elif nodeName_ == 'PaymentNotice':
            obj_ = PaymentNotice.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.PaymentNotice = obj_
            obj_.original_tagname_ = 'PaymentNotice'
        elif nodeName_ == 'PaymentReconciliation':
            obj_ = PaymentReconciliation.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.PaymentReconciliation = obj_
            obj_.original_tagname_ = 'PaymentReconciliation'
        elif nodeName_ == 'Person':
            obj_ = Person.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.Person = obj_
            obj_.original_tagname_ = 'Person'
        elif nodeName_ == 'PlanDefinition':
            obj_ = PlanDefinition.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.PlanDefinition = obj_
            obj_.original_tagname_ = 'PlanDefinition'
        elif nodeName_ == 'Practitioner':
            obj_ = Practitioner.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.Practitioner = obj_
            obj_.original_tagname_ = 'Practitioner'
        elif nodeName_ == 'PractitionerRole':
            obj_ = PractitionerRole.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.PractitionerRole = obj_
            obj_.original_tagname_ = 'PractitionerRole'
        elif nodeName_ == 'Procedure':
            obj_ = Procedure.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.Procedure = obj_
            obj_.original_tagname_ = 'Procedure'
        elif nodeName_ == 'Provenance':
            obj_ = Provenance.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.Provenance = obj_
            obj_.original_tagname_ = 'Provenance'
        elif nodeName_ == 'Questionnaire':
            obj_ = Questionnaire.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.Questionnaire = obj_
            obj_.original_tagname_ = 'Questionnaire'
        elif nodeName_ == 'QuestionnaireResponse':
            obj_ = QuestionnaireResponse.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.QuestionnaireResponse = obj_
            obj_.original_tagname_ = 'QuestionnaireResponse'
        elif nodeName_ == 'RegulatedAuthorization':
            obj_ = RegulatedAuthorization.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.RegulatedAuthorization = obj_
            obj_.original_tagname_ = 'RegulatedAuthorization'
        elif nodeName_ == 'RelatedPerson':
            obj_ = RelatedPerson.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.RelatedPerson = obj_
            obj_.original_tagname_ = 'RelatedPerson'
        elif nodeName_ == 'RequestGroup':
            obj_ = RequestGroup.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.RequestGroup = obj_
            obj_.original_tagname_ = 'RequestGroup'
        elif nodeName_ == 'ResearchDefinition':
            obj_ = ResearchDefinition.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.ResearchDefinition = obj_
            obj_.original_tagname_ = 'ResearchDefinition'
        elif nodeName_ == 'ResearchElementDefinition':
            obj_ = ResearchElementDefinition.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.ResearchElementDefinition = obj_
            obj_.original_tagname_ = 'ResearchElementDefinition'
        elif nodeName_ == 'ResearchStudy':
            obj_ = ResearchStudy.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.ResearchStudy = obj_
            obj_.original_tagname_ = 'ResearchStudy'
        elif nodeName_ == 'ResearchSubject':
            obj_ = ResearchSubject.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.ResearchSubject = obj_
            obj_.original_tagname_ = 'ResearchSubject'
        elif nodeName_ == 'RiskAssessment':
            obj_ = RiskAssessment.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.RiskAssessment = obj_
            obj_.original_tagname_ = 'RiskAssessment'
        elif nodeName_ == 'Schedule':
            obj_ = Schedule.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.Schedule = obj_
            obj_.original_tagname_ = 'Schedule'
        elif nodeName_ == 'SearchParameter':
            obj_ = SearchParameter.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.SearchParameter = obj_
            obj_.original_tagname_ = 'SearchParameter'
        elif nodeName_ == 'ServiceRequest':
            obj_ = ServiceRequest.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.ServiceRequest = obj_
            obj_.original_tagname_ = 'ServiceRequest'
        elif nodeName_ == 'Slot':
            obj_ = Slot.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.Slot = obj_
            obj_.original_tagname_ = 'Slot'
        elif nodeName_ == 'Specimen':
            obj_ = Specimen.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.Specimen = obj_
            obj_.original_tagname_ = 'Specimen'
        elif nodeName_ == 'SpecimenDefinition':
            obj_ = SpecimenDefinition.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.SpecimenDefinition = obj_
            obj_.original_tagname_ = 'SpecimenDefinition'
        elif nodeName_ == 'StructureDefinition':
            obj_ = StructureDefinition.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.StructureDefinition = obj_
            obj_.original_tagname_ = 'StructureDefinition'
        elif nodeName_ == 'StructureMap':
            obj_ = StructureMap.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.StructureMap = obj_
            obj_.original_tagname_ = 'StructureMap'
        elif nodeName_ == 'Subscription':
            obj_ = Subscription.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.Subscription = obj_
            obj_.original_tagname_ = 'Subscription'
        elif nodeName_ == 'SubscriptionStatus':
            obj_ = SubscriptionStatus.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.SubscriptionStatus = obj_
            obj_.original_tagname_ = 'SubscriptionStatus'
        elif nodeName_ == 'SubscriptionTopic':
            obj_ = SubscriptionTopic.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.SubscriptionTopic = obj_
            obj_.original_tagname_ = 'SubscriptionTopic'
        elif nodeName_ == 'Substance':
            obj_ = Substance.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.Substance = obj_
            obj_.original_tagname_ = 'Substance'
        elif nodeName_ == 'SubstanceDefinition':
            obj_ = SubstanceDefinition.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.SubstanceDefinition = obj_
            obj_.original_tagname_ = 'SubstanceDefinition'
        elif nodeName_ == 'SupplyDelivery':
            obj_ = SupplyDelivery.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.SupplyDelivery = obj_
            obj_.original_tagname_ = 'SupplyDelivery'
        elif nodeName_ == 'SupplyRequest':
            obj_ = SupplyRequest.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.SupplyRequest = obj_
            obj_.original_tagname_ = 'SupplyRequest'
        elif nodeName_ == 'Task':
            obj_ = Task.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.Task = obj_
            obj_.original_tagname_ = 'Task'
        elif nodeName_ == 'TerminologyCapabilities':
            obj_ = TerminologyCapabilities.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.TerminologyCapabilities = obj_
            obj_.original_tagname_ = 'TerminologyCapabilities'
        elif nodeName_ == 'TestReport':
            obj_ = TestReport.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.TestReport = obj_
            obj_.original_tagname_ = 'TestReport'
        elif nodeName_ == 'TestScript':
            obj_ = TestScript.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.TestScript = obj_
            obj_.original_tagname_ = 'TestScript'
        elif nodeName_ == 'ValueSet':
            obj_ = ValueSet.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.ValueSet = obj_
            obj_.original_tagname_ = 'ValueSet'
        elif nodeName_ == 'VerificationResult':
            obj_ = VerificationResult.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.VerificationResult = obj_
            obj_.original_tagname_ = 'VerificationResult'
        elif nodeName_ == 'VisionPrescription':
            obj_ = VisionPrescription.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.VisionPrescription = obj_
            obj_.original_tagname_ = 'VisionPrescription'
        elif nodeName_ == 'Parameters':
            obj_ = Parameters.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.Parameters = obj_
            obj_.original_tagname_ = 'Parameters'
# end class ResourceContainer


class Element(GeneratedsSuper):
    """extension -- May be used to represent additional information that is not part of the basic definition of the element. To make the use of extensions safe and manageable, there is a strict set of governance  applied to the definition and use of extensions. Though any implementer can define an extension, there is a set of requirements that SHALL be met as part of the definition of the extension.
    
    """
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, id: 'string_primitive' = None, extension: List_['Extension'] = None, extensiontype_=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.id = _cast(None, id)
        self.id_nsprefix_ = None
        if extension is None:
            self.extension = []
        else:
            self.extension = extension
        self.extension_nsprefix_ = None
        self.extensiontype_ = extensiontype_
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, Element)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if Element.subclass:
            return Element.subclass(*args_, **kwargs_)
        else:
            return Element(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_extension(self):
        return self.extension
    def set_extension(self, extension):
        self.extension = extension
    def add_extension(self, value):
        self.extension.append(value)
    def insert_extension_at(self, index, value):
        self.extension.insert(index, value)
    def replace_extension_at(self, index, value):
        self.extension[index] = value
    def get_id(self):
        return self.id
    def set_id(self, id):
        self.id = id
    def get_extensiontype_(self): return self.extensiontype_
    def set_extensiontype_(self, extensiontype_): self.extensiontype_ = extensiontype_
    def validate_string_primitive(self, value):
        # Validate type string-primitive, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if len(value) < 1:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd minLength restriction on string-primitive' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
    def has__content(self):
        if (
            self.extension
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_=' xmlns:None="http://hl7.org/fhir" ', name_='Element', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('Element')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'Element':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='Element')
        if self.has__content():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='Element', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='Element'):
        if self.id is not None and 'id' not in already_processed:
            already_processed.add('id')
            outfile.write(' id=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.id), input_name='id')), ))
        if self.extensiontype_ is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            outfile.write(' xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"')
            if ":" not in self.extensiontype_:
                imported_ns_type_prefix_ = GenerateDSNamespaceTypePrefixes_.get(self.extensiontype_, '')
                outfile.write(' xsi:type="%s%s"' % (imported_ns_type_prefix_, self.extensiontype_))
            else:
                outfile.write(' xsi:type="%s"' % self.extensiontype_)
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_=' xmlns:None="http://hl7.org/fhir" ', name_='Element', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for extension_ in self.extension:
            namespaceprefix_ = self.extension_nsprefix_ + ':' if (UseCapturedNS_ and self.extension_nsprefix_) else ''
            extension_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='extension', pretty_print=pretty_print)
    def exportJson(self, parent_dict=None, key=None, is_list=False):
        json_dict = dict()
        self.exportJsonAttributes(json_dict)
        self.exportJsonChildren(json_dict)
        return self.exportJsonResult(json_dict, parent_dict, key, is_list)
    def exportJsonResult(self, json_dict, parent_dict, key, is_list, sub_defs=[], attr_defs=['id']):
        return json_dict
    def exportJsonAttributes(self, json_dict):
        if self.id is not None:
            json_dict['id'] = self.id
    def exportJsonChildren(self, json_dict):
        child_list = []
        for child in self.extension:
            child_dict = child.exportJson(json_dict, 'extension', True)
            if child_dict:
                child_list.append(child_dict)
        if child_list:
            json_dict['extension'] = child_list
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        if SaveNodeDict:
            node_dict[node] = self 
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('id', node)
        if value is not None and 'id' not in already_processed:
            already_processed.add('id')
            self.id = value
            self.validate_string_primitive(self.id)    # validate type string-primitive
        value = find_attr_value_('xsi:type', node)
        if value is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            self.extensiontype_ = value
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'extension':
            obj_ = Extension.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.extension.append(obj_)
            obj_.original_tagname_ = 'extension'
# end class Element


class Meta(Element):
    """versionId -- The version specific identifier, as it appears in the version portion of the URL. This value changes when the resource is created, updated, or deleted.
    lastUpdated -- When the resource last changed - e.g. when the version changed.
    source -- A uri that identifies the source system of the resource. This provides a minimal amount of [[[Provenance]]] information that can be used to track or differentiate the source of information in the resource. The source may identify another FHIR server, document, message, database, etc.
    profile -- A list of profiles (references to [[[StructureDefinition]]] resources) that this resource claims to conform to. The URL is a reference to [[[StructureDefinition.url]]].
    security -- Security labels applied to this resource. These tags connect specific resources to the overall security policy and infrastructure.
    tag -- Tags applied to this resource. Tags are intended to be used to identify and relate resources to process and workflow, and applications are not required to consider the tags when interpreting the meaning of a resource.
    
    """
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = Element
    def __init__(self, id: 'string_primitive' = None, extension: List_['Extension'] = None, versionId: 'id' = None, lastUpdated: 'instant' = None, source: 'uri' = None, profile: List_['canonical'] = None, security: List_['Coding'] = None, tag: List_['Coding'] = None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        super(globals().get("Meta"), self).__init__(id, extension,  **kwargs_)
        self.versionId = versionId
        self.versionId_nsprefix_ = None
        self.lastUpdated = lastUpdated
        self.lastUpdated_nsprefix_ = None
        self.source = source
        self.source_nsprefix_ = None
        if profile is None:
            self.profile = []
        else:
            self.profile = profile
        self.profile_nsprefix_ = None
        if security is None:
            self.security = []
        else:
            self.security = security
        self.security_nsprefix_ = None
        if tag is None:
            self.tag = []
        else:
            self.tag = tag
        self.tag_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, Meta)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if Meta.subclass:
            return Meta.subclass(*args_, **kwargs_)
        else:
            return Meta(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_versionId(self):
        return self.versionId
    def set_versionId(self, versionId):
        self.versionId = versionId
    def get_lastUpdated(self):
        return self.lastUpdated
    def set_lastUpdated(self, lastUpdated):
        self.lastUpdated = lastUpdated
    def get_source(self):
        return self.source
    def set_source(self, source):
        self.source = source
    def get_profile(self):
        return self.profile
    def set_profile(self, profile):
        self.profile = profile
    def add_profile(self, value):
        self.profile.append(value)
    def insert_profile_at(self, index, value):
        self.profile.insert(index, value)
    def replace_profile_at(self, index, value):
        self.profile[index] = value
    def get_security(self):
        return self.security
    def set_security(self, security):
        self.security = security
    def add_security(self, value):
        self.security.append(value)
    def insert_security_at(self, index, value):
        self.security.insert(index, value)
    def replace_security_at(self, index, value):
        self.security[index] = value
    def get_tag(self):
        return self.tag
    def set_tag(self, tag):
        self.tag = tag
    def add_tag(self, value):
        self.tag.append(value)
    def insert_tag_at(self, index, value):
        self.tag.insert(index, value)
    def replace_tag_at(self, index, value):
        self.tag[index] = value
    def has__content(self):
        if (
            self.versionId is not None or
            self.lastUpdated is not None or
            self.source is not None or
            self.profile or
            self.security or
            self.tag or
            super(Meta, self).has__content()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_=' xmlns:None="http://hl7.org/fhir" ', name_='Meta', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('Meta')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'Meta':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='Meta')
        if self.has__content():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='Meta', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='Meta'):
        super(Meta, self)._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='Meta')
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_=' xmlns:None="http://hl7.org/fhir" ', name_='Meta', fromsubclass_=False, pretty_print=True):
        super(Meta, self)._exportChildren(outfile, level, namespaceprefix_, namespacedef_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.versionId is not None:
            namespaceprefix_ = self.versionId_nsprefix_ + ':' if (UseCapturedNS_ and self.versionId_nsprefix_) else ''
            self.versionId.export(outfile, level, namespaceprefix_, namespacedef_='', name_='versionId', pretty_print=pretty_print)
        if self.lastUpdated is not None:
            namespaceprefix_ = self.lastUpdated_nsprefix_ + ':' if (UseCapturedNS_ and self.lastUpdated_nsprefix_) else ''
            self.lastUpdated.export(outfile, level, namespaceprefix_, namespacedef_='', name_='lastUpdated', pretty_print=pretty_print)
        if self.source is not None:
            namespaceprefix_ = self.source_nsprefix_ + ':' if (UseCapturedNS_ and self.source_nsprefix_) else ''
            self.source.export(outfile, level, namespaceprefix_, namespacedef_='', name_='source', pretty_print=pretty_print)
        for profile_ in self.profile:
            namespaceprefix_ = self.profile_nsprefix_ + ':' if (UseCapturedNS_ and self.profile_nsprefix_) else ''
            profile_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='profile', pretty_print=pretty_print)
        for security_ in self.security:
            namespaceprefix_ = self.security_nsprefix_ + ':' if (UseCapturedNS_ and self.security_nsprefix_) else ''
            security_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='security', pretty_print=pretty_print)
        for tag_ in self.tag:
            namespaceprefix_ = self.tag_nsprefix_ + ':' if (UseCapturedNS_ and self.tag_nsprefix_) else ''
            tag_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='tag', pretty_print=pretty_print)
    def exportJson(self, parent_dict=None, key=None, is_list=False):
        json_dict = dict()
        self.exportJsonAttributes(json_dict)
        self.exportJsonChildren(json_dict)
        return self.exportJsonResult(json_dict, parent_dict, key, is_list)
    def exportJsonResult(self, json_dict, parent_dict, key, is_list, sub_defs=[], attr_defs=[]):
        return super().exportJsonResult(json_dict, parent_dict, key, is_list, attr_defs)
    def exportJsonAttributes(self, json_dict):
        super().exportJsonAttributes(json_dict)
    def exportJsonChildren(self, json_dict):
        super().exportJsonChildren(json_dict)
        if self.versionId is not None:
            child_dict = self.versionId.exportJson(json_dict, 'versionId', False)
            if child_dict:
                json_dict['versionId'] = child_dict
        if self.lastUpdated is not None:
            child_dict = self.lastUpdated.exportJson(json_dict, 'lastUpdated', False)
            if child_dict:
                json_dict['lastUpdated'] = child_dict
        if self.source is not None:
            child_dict = self.source.exportJson(json_dict, 'source', False)
            if child_dict:
                json_dict['source'] = child_dict
        child_list = []
        for child in self.profile:
            child_dict = child.exportJson(json_dict, 'profile', True)
            if child_dict:
                child_list.append(child_dict)
        if child_list:
            json_dict['profile'] = child_list
        child_list = []
        for child in self.security:
            child_dict = child.exportJson(json_dict, 'security', True)
            if child_dict:
                child_list.append(child_dict)
        if child_list:
            json_dict['security'] = child_list
        child_list = []
        for child in self.tag:
            child_dict = child.exportJson(json_dict, 'tag', True)
            if child_dict:
                child_list.append(child_dict)
        if child_list:
            json_dict['tag'] = child_list
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        if SaveNodeDict:
            node_dict[node] = self 
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        super(Meta, self)._buildAttributes(node, attrs, already_processed)
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'versionId':
            obj_ = id.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.versionId = obj_
            obj_.original_tagname_ = 'versionId'
        elif nodeName_ == 'lastUpdated':
            obj_ = instant.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.lastUpdated = obj_
            obj_.original_tagname_ = 'lastUpdated'
        elif nodeName_ == 'source':
            obj_ = uri.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.source = obj_
            obj_.original_tagname_ = 'source'
        elif nodeName_ == 'profile':
            obj_ = canonical.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.profile.append(obj_)
            obj_.original_tagname_ = 'profile'
        elif nodeName_ == 'security':
            obj_ = Coding.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.security.append(obj_)
            obj_.original_tagname_ = 'security'
        elif nodeName_ == 'tag':
            obj_ = Coding.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.tag.append(obj_)
            obj_.original_tagname_ = 'tag'
        super(Meta, self)._buildChildren(child_, node, nodeName_, True)
# end class Meta


class Address(Element):
    """use -- The purpose of this address.
    type -- Distinguishes between physical addresses (those you can visit) and mailing addresses (e.g. PO Boxes and care-of addresses). Most addresses are both.
    text -- Specifies the entire address as it should be displayed e.g. on a postal label. This may be provided instead of or as well as the specific parts.
    line -- This component contains the house number, apartment number, street name, street direction,  P.O. Box number, delivery hints, and similar address information.
    city -- The name of the city, town, suburb, village or other community or delivery center.
    district -- The name of the administrative area (county).
    state -- Sub-unit of a country with limited sovereignty in a federally organized country. A code may be used if codes are in common use (e.g. US 2 letter state codes).
    postalCode -- A postal code designating a region defined by the postal service.
    country -- Country - a nation as commonly understood or generally accepted.
    period -- Time period when address was/is in use.
    
    """
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = Element
    def __init__(self, id: 'string_primitive' = None, extension: List_['Extension'] = None, use: 'AddressUse' = None, type_: 'AddressType' = None, text: 'string' = None, line: List_['string'] = None, city: 'string' = None, district: 'string' = None, state: 'string' = None, postalCode: 'string' = None, country: 'string' = None, period: 'Period' = None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        super(globals().get("Address"), self).__init__(id, extension,  **kwargs_)
        self.use = use
        self.use_nsprefix_ = None
        self.type_ = type_
        self.type__nsprefix_ = None
        self.text = text
        self.text_nsprefix_ = None
        if line is None:
            self.line = []
        else:
            self.line = line
        self.line_nsprefix_ = None
        self.city = city
        self.city_nsprefix_ = None
        self.district = district
        self.district_nsprefix_ = None
        self.state = state
        self.state_nsprefix_ = None
        self.postalCode = postalCode
        self.postalCode_nsprefix_ = None
        self.country = country
        self.country_nsprefix_ = None
        self.period = period
        self.period_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, Address)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if Address.subclass:
            return Address.subclass(*args_, **kwargs_)
        else:
            return Address(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_use(self):
        return self.use
    def set_use(self, use):
        self.use = use
    def get_type(self):
        return self.type_
    def set_type(self, type_):
        self.type_ = type_
    def get_text(self):
        return self.text
    def set_text(self, text):
        self.text = text
    def get_line(self):
        return self.line
    def set_line(self, line):
        self.line = line
    def add_line(self, value):
        self.line.append(value)
    def insert_line_at(self, index, value):
        self.line.insert(index, value)
    def replace_line_at(self, index, value):
        self.line[index] = value
    def get_city(self):
        return self.city
    def set_city(self, city):
        self.city = city
    def get_district(self):
        return self.district
    def set_district(self, district):
        self.district = district
    def get_state(self):
        return self.state
    def set_state(self, state):
        self.state = state
    def get_postalCode(self):
        return self.postalCode
    def set_postalCode(self, postalCode):
        self.postalCode = postalCode
    def get_country(self):
        return self.country
    def set_country(self, country):
        self.country = country
    def get_period(self):
        return self.period
    def set_period(self, period):
        self.period = period
    def has__content(self):
        if (
            self.use is not None or
            self.type_ is not None or
            self.text is not None or
            self.line or
            self.city is not None or
            self.district is not None or
            self.state is not None or
            self.postalCode is not None or
            self.country is not None or
            self.period is not None or
            super(Address, self).has__content()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_=' xmlns:None="http://hl7.org/fhir" ', name_='Address', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('Address')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'Address':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='Address')
        if self.has__content():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='Address', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='Address'):
        super(Address, self)._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='Address')
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_=' xmlns:None="http://hl7.org/fhir" ', name_='Address', fromsubclass_=False, pretty_print=True):
        super(Address, self)._exportChildren(outfile, level, namespaceprefix_, namespacedef_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.use is not None:
            namespaceprefix_ = self.use_nsprefix_ + ':' if (UseCapturedNS_ and self.use_nsprefix_) else ''
            self.use.export(outfile, level, namespaceprefix_, namespacedef_='', name_='use', pretty_print=pretty_print)
        if self.type_ is not None:
            namespaceprefix_ = self.type__nsprefix_ + ':' if (UseCapturedNS_ and self.type__nsprefix_) else ''
            self.type_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='type', pretty_print=pretty_print)
        if self.text is not None:
            namespaceprefix_ = self.text_nsprefix_ + ':' if (UseCapturedNS_ and self.text_nsprefix_) else ''
            self.text.export(outfile, level, namespaceprefix_, namespacedef_='', name_='text', pretty_print=pretty_print)
        for line_ in self.line:
            namespaceprefix_ = self.line_nsprefix_ + ':' if (UseCapturedNS_ and self.line_nsprefix_) else ''
            line_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='line', pretty_print=pretty_print)
        if self.city is not None:
            namespaceprefix_ = self.city_nsprefix_ + ':' if (UseCapturedNS_ and self.city_nsprefix_) else ''
            self.city.export(outfile, level, namespaceprefix_, namespacedef_='', name_='city', pretty_print=pretty_print)
        if self.district is not None:
            namespaceprefix_ = self.district_nsprefix_ + ':' if (UseCapturedNS_ and self.district_nsprefix_) else ''
            self.district.export(outfile, level, namespaceprefix_, namespacedef_='', name_='district', pretty_print=pretty_print)
        if self.state is not None:
            namespaceprefix_ = self.state_nsprefix_ + ':' if (UseCapturedNS_ and self.state_nsprefix_) else ''
            self.state.export(outfile, level, namespaceprefix_, namespacedef_='', name_='state', pretty_print=pretty_print)
        if self.postalCode is not None:
            namespaceprefix_ = self.postalCode_nsprefix_ + ':' if (UseCapturedNS_ and self.postalCode_nsprefix_) else ''
            self.postalCode.export(outfile, level, namespaceprefix_, namespacedef_='', name_='postalCode', pretty_print=pretty_print)
        if self.country is not None:
            namespaceprefix_ = self.country_nsprefix_ + ':' if (UseCapturedNS_ and self.country_nsprefix_) else ''
            self.country.export(outfile, level, namespaceprefix_, namespacedef_='', name_='country', pretty_print=pretty_print)
        if self.period is not None:
            namespaceprefix_ = self.period_nsprefix_ + ':' if (UseCapturedNS_ and self.period_nsprefix_) else ''
            self.period.export(outfile, level, namespaceprefix_, namespacedef_='', name_='period', pretty_print=pretty_print)
    def exportJson(self, parent_dict=None, key=None, is_list=False):
        json_dict = dict()
        self.exportJsonAttributes(json_dict)
        self.exportJsonChildren(json_dict)
        return self.exportJsonResult(json_dict, parent_dict, key, is_list)
    def exportJsonResult(self, json_dict, parent_dict, key, is_list, sub_defs=[], attr_defs=[]):
        return super().exportJsonResult(json_dict, parent_dict, key, is_list, attr_defs)
    def exportJsonAttributes(self, json_dict):
        super().exportJsonAttributes(json_dict)
    def exportJsonChildren(self, json_dict):
        super().exportJsonChildren(json_dict)
        if self.use is not None:
            child_dict = self.use.exportJson(json_dict, 'use', False)
            if child_dict:
                json_dict['use'] = child_dict
        if self.type_ is not None:
            child_dict = self.type_.exportJson(json_dict, 'type', False)
            if child_dict:
                json_dict['type'] = child_dict
        if self.text is not None:
            child_dict = self.text.exportJson(json_dict, 'text', False)
            if child_dict:
                json_dict['text'] = child_dict
        child_list = []
        for child in self.line:
            child_dict = child.exportJson(json_dict, 'line', True)
            if child_dict:
                child_list.append(child_dict)
        if child_list:
            json_dict['line'] = child_list
        if self.city is not None:
            child_dict = self.city.exportJson(json_dict, 'city', False)
            if child_dict:
                json_dict['city'] = child_dict
        if self.district is not None:
            child_dict = self.district.exportJson(json_dict, 'district', False)
            if child_dict:
                json_dict['district'] = child_dict
        if self.state is not None:
            child_dict = self.state.exportJson(json_dict, 'state', False)
            if child_dict:
                json_dict['state'] = child_dict
        if self.postalCode is not None:
            child_dict = self.postalCode.exportJson(json_dict, 'postalCode', False)
            if child_dict:
                json_dict['postalCode'] = child_dict
        if self.country is not None:
            child_dict = self.country.exportJson(json_dict, 'country', False)
            if child_dict:
                json_dict['country'] = child_dict
        if self.period is not None:
            child_dict = self.period.exportJson(json_dict, 'period', False)
            if child_dict:
                json_dict['period'] = child_dict
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        if SaveNodeDict:
            node_dict[node] = self 
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        super(Address, self)._buildAttributes(node, attrs, already_processed)
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'use':
            obj_ = AddressUse.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.use = obj_
            obj_.original_tagname_ = 'use'
        elif nodeName_ == 'type':
            obj_ = AddressType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.type_ = obj_
            obj_.original_tagname_ = 'type'
        elif nodeName_ == 'text':
            obj_ = string.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.text = obj_
            obj_.original_tagname_ = 'text'
        elif nodeName_ == 'line':
            obj_ = string.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.line.append(obj_)
            obj_.original_tagname_ = 'line'
        elif nodeName_ == 'city':
            obj_ = string.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.city = obj_
            obj_.original_tagname_ = 'city'
        elif nodeName_ == 'district':
            obj_ = string.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.district = obj_
            obj_.original_tagname_ = 'district'
        elif nodeName_ == 'state':
            obj_ = string.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.state = obj_
            obj_.original_tagname_ = 'state'
        elif nodeName_ == 'postalCode':
            obj_ = string.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.postalCode = obj_
            obj_.original_tagname_ = 'postalCode'
        elif nodeName_ == 'country':
            obj_ = string.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.country = obj_
            obj_.original_tagname_ = 'country'
        elif nodeName_ == 'period':
            obj_ = Period.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.period = obj_
            obj_.original_tagname_ = 'period'
        super(Address, self)._buildChildren(child_, node, nodeName_, True)
# end class Address


class AddressUse(Element):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = Element
    def __init__(self, id: 'string_primitive' = None, extension: List_['Extension'] = None, value: 'AddressUseEnum' = None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        super(globals().get("AddressUse"), self).__init__(id, extension,  **kwargs_)
        self.value = _cast(None, value)
        self.value_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, AddressUse)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if AddressUse.subclass:
            return AddressUse.subclass(*args_, **kwargs_)
        else:
            return AddressUse(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_value(self):
        return self.value
    def set_value(self, value):
        self.value = value
    def validate_AddressUseEnum(self, value):
        # Validate type AddressUseEnum, a restriction on code-primitive.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['home', 'work', 'temp', 'old', 'billing']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on AddressUseEnum' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
            if len(value) < 1:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd minLength restriction on AddressUseEnum' % {"value" : value, "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_AddressUseEnum_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_AddressUseEnum_patterns_, ))
    validate_AddressUseEnum_patterns_ = [['^([^\\s]+(\\s[^\\s]+)*)$']]
    def has__content(self):
        if (
            super(AddressUse, self).has__content()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='AddressUse', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('AddressUse')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'AddressUse':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='AddressUse')
        if self.has__content():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='AddressUse', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='AddressUse'):
        super(AddressUse, self)._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='AddressUse')
        if self.value is not None and 'value' not in already_processed:
            already_processed.add('value')
            outfile.write(' value=%s' % (quote_attrib(self.value), ))
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='AddressUse', fromsubclass_=False, pretty_print=True):
        super(AddressUse, self)._exportChildren(outfile, level, namespaceprefix_, namespacedef_, name_, True, pretty_print=pretty_print)
    def exportJson(self, parent_dict=None, key=None, is_list=False):
        json_dict = dict()
        self.exportJsonAttributes(json_dict)
        self.exportJsonChildren(json_dict)
        return self.exportJsonResult(json_dict, parent_dict, key, is_list)
    def exportJsonResult(self, json_dict, parent_dict, key, is_list, sub_defs=[], attr_defs=['value']):
        return super().exportJsonResult(json_dict, parent_dict, key, is_list, attr_defs)
    def exportJsonAttributes(self, json_dict):
        super().exportJsonAttributes(json_dict)
        if self.value is not None:
            json_dict['value'] = self.value
    def exportJsonChildren(self, json_dict):
        super().exportJsonChildren(json_dict)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        if SaveNodeDict:
            node_dict[node] = self 
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('value', node)
        if value is not None and 'value' not in already_processed:
            already_processed.add('value')
            self.value = value
            self.value = ' '.join(self.value.split())
            self.validate_AddressUseEnum(self.value)    # validate type AddressUseEnum
        super(AddressUse, self)._buildAttributes(node, attrs, already_processed)
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        super(AddressUse, self)._buildChildren(child_, node, nodeName_, True)
        pass
# end class AddressUse


class AddressType(Element):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = Element
    def __init__(self, id: 'string_primitive' = None, extension: List_['Extension'] = None, value: 'AddressTypeEnum' = None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        super(globals().get("AddressType"), self).__init__(id, extension,  **kwargs_)
        self.value = _cast(None, value)
        self.value_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, AddressType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if AddressType.subclass:
            return AddressType.subclass(*args_, **kwargs_)
        else:
            return AddressType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_value(self):
        return self.value
    def set_value(self, value):
        self.value = value
    def validate_AddressTypeEnum(self, value):
        # Validate type AddressTypeEnum, a restriction on code-primitive.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['postal', 'physical', 'both']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on AddressTypeEnum' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
            if len(value) < 1:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd minLength restriction on AddressTypeEnum' % {"value" : value, "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_AddressTypeEnum_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_AddressTypeEnum_patterns_, ))
    validate_AddressTypeEnum_patterns_ = [['^([^\\s]+(\\s[^\\s]+)*)$']]
    def has__content(self):
        if (
            super(AddressType, self).has__content()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='AddressType', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('AddressType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'AddressType':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='AddressType')
        if self.has__content():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='AddressType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='AddressType'):
        super(AddressType, self)._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='AddressType')
        if self.value is not None and 'value' not in already_processed:
            already_processed.add('value')
            outfile.write(' value=%s' % (quote_attrib(self.value), ))
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='AddressType', fromsubclass_=False, pretty_print=True):
        super(AddressType, self)._exportChildren(outfile, level, namespaceprefix_, namespacedef_, name_, True, pretty_print=pretty_print)
    def exportJson(self, parent_dict=None, key=None, is_list=False):
        json_dict = dict()
        self.exportJsonAttributes(json_dict)
        self.exportJsonChildren(json_dict)
        return self.exportJsonResult(json_dict, parent_dict, key, is_list)
    def exportJsonResult(self, json_dict, parent_dict, key, is_list, sub_defs=[], attr_defs=['value']):
        return super().exportJsonResult(json_dict, parent_dict, key, is_list, attr_defs)
    def exportJsonAttributes(self, json_dict):
        super().exportJsonAttributes(json_dict)
        if self.value is not None:
            json_dict['value'] = self.value
    def exportJsonChildren(self, json_dict):
        super().exportJsonChildren(json_dict)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        if SaveNodeDict:
            node_dict[node] = self 
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('value', node)
        if value is not None and 'value' not in already_processed:
            already_processed.add('value')
            self.value = value
            self.value = ' '.join(self.value.split())
            self.validate_AddressTypeEnum(self.value)    # validate type AddressTypeEnum
        super(AddressType, self)._buildAttributes(node, attrs, already_processed)
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        super(AddressType, self)._buildChildren(child_, node, nodeName_, True)
        pass
# end class AddressType


class Contributor(Element):
    """type -- The type of contributor.
    name -- The name of the individual or organization responsible for the contribution.
    contact -- Contact details to assist a user in finding and communicating with the contributor.
    
    """
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = Element
    def __init__(self, id: 'string_primitive' = None, extension: List_['Extension'] = None, type_: 'ContributorType' = None, name: 'string' = None, contact: List_['ContactDetail'] = None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        super(globals().get("Contributor"), self).__init__(id, extension,  **kwargs_)
        self.type_ = type_
        self.type__nsprefix_ = None
        self.name = name
        self.name_nsprefix_ = None
        if contact is None:
            self.contact = []
        else:
            self.contact = contact
        self.contact_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, Contributor)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if Contributor.subclass:
            return Contributor.subclass(*args_, **kwargs_)
        else:
            return Contributor(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_type(self):
        return self.type_
    def set_type(self, type_):
        self.type_ = type_
    def get_name(self):
        return self.name
    def set_name(self, name):
        self.name = name
    def get_contact(self):
        return self.contact
    def set_contact(self, contact):
        self.contact = contact
    def add_contact(self, value):
        self.contact.append(value)
    def insert_contact_at(self, index, value):
        self.contact.insert(index, value)
    def replace_contact_at(self, index, value):
        self.contact[index] = value
    def has__content(self):
        if (
            self.type_ is not None or
            self.name is not None or
            self.contact or
            super(Contributor, self).has__content()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_=' xmlns:None="http://hl7.org/fhir" ', name_='Contributor', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('Contributor')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'Contributor':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='Contributor')
        if self.has__content():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='Contributor', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='Contributor'):
        super(Contributor, self)._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='Contributor')
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_=' xmlns:None="http://hl7.org/fhir" ', name_='Contributor', fromsubclass_=False, pretty_print=True):
        super(Contributor, self)._exportChildren(outfile, level, namespaceprefix_, namespacedef_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.type_ is not None:
            namespaceprefix_ = self.type__nsprefix_ + ':' if (UseCapturedNS_ and self.type__nsprefix_) else ''
            self.type_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='type', pretty_print=pretty_print)
        if self.name is not None:
            namespaceprefix_ = self.name_nsprefix_ + ':' if (UseCapturedNS_ and self.name_nsprefix_) else ''
            self.name.export(outfile, level, namespaceprefix_, namespacedef_='', name_='name', pretty_print=pretty_print)
        for contact_ in self.contact:
            namespaceprefix_ = self.contact_nsprefix_ + ':' if (UseCapturedNS_ and self.contact_nsprefix_) else ''
            contact_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='contact', pretty_print=pretty_print)
    def exportJson(self, parent_dict=None, key=None, is_list=False):
        json_dict = dict()
        self.exportJsonAttributes(json_dict)
        self.exportJsonChildren(json_dict)
        return self.exportJsonResult(json_dict, parent_dict, key, is_list)
    def exportJsonResult(self, json_dict, parent_dict, key, is_list, sub_defs=[], attr_defs=[]):
        return super().exportJsonResult(json_dict, parent_dict, key, is_list, attr_defs)
    def exportJsonAttributes(self, json_dict):
        super().exportJsonAttributes(json_dict)
    def exportJsonChildren(self, json_dict):
        super().exportJsonChildren(json_dict)
        if self.type_ is not None:
            child_dict = self.type_.exportJson(json_dict, 'type', False)
            if child_dict:
                json_dict['type'] = child_dict
        if self.name is not None:
            child_dict = self.name.exportJson(json_dict, 'name', False)
            if child_dict:
                json_dict['name'] = child_dict
        child_list = []
        for child in self.contact:
            child_dict = child.exportJson(json_dict, 'contact', True)
            if child_dict:
                child_list.append(child_dict)
        if child_list:
            json_dict['contact'] = child_list
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        if SaveNodeDict:
            node_dict[node] = self 
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        super(Contributor, self)._buildAttributes(node, attrs, already_processed)
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'type':
            obj_ = ContributorType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.type_ = obj_
            obj_.original_tagname_ = 'type'
        elif nodeName_ == 'name':
            obj_ = string.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.name = obj_
            obj_.original_tagname_ = 'name'
        elif nodeName_ == 'contact':
            obj_ = ContactDetail.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.contact.append(obj_)
            obj_.original_tagname_ = 'contact'
        super(Contributor, self)._buildChildren(child_, node, nodeName_, True)
# end class Contributor


class ContributorType(Element):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = Element
    def __init__(self, id: 'string_primitive' = None, extension: List_['Extension'] = None, value: 'ContributorTypeEnum' = None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        super(globals().get("ContributorType"), self).__init__(id, extension,  **kwargs_)
        self.value = _cast(None, value)
        self.value_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ContributorType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ContributorType.subclass:
            return ContributorType.subclass(*args_, **kwargs_)
        else:
            return ContributorType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_value(self):
        return self.value
    def set_value(self, value):
        self.value = value
    def validate_ContributorTypeEnum(self, value):
        # Validate type ContributorTypeEnum, a restriction on code-primitive.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['author', 'editor', 'reviewer', 'endorser']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on ContributorTypeEnum' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
            if len(value) < 1:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd minLength restriction on ContributorTypeEnum' % {"value" : value, "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_ContributorTypeEnum_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_ContributorTypeEnum_patterns_, ))
    validate_ContributorTypeEnum_patterns_ = [['^([^\\s]+(\\s[^\\s]+)*)$']]
    def has__content(self):
        if (
            super(ContributorType, self).has__content()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='ContributorType', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('ContributorType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'ContributorType':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='ContributorType')
        if self.has__content():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='ContributorType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='ContributorType'):
        super(ContributorType, self)._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='ContributorType')
        if self.value is not None and 'value' not in already_processed:
            already_processed.add('value')
            outfile.write(' value=%s' % (quote_attrib(self.value), ))
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='ContributorType', fromsubclass_=False, pretty_print=True):
        super(ContributorType, self)._exportChildren(outfile, level, namespaceprefix_, namespacedef_, name_, True, pretty_print=pretty_print)
    def exportJson(self, parent_dict=None, key=None, is_list=False):
        json_dict = dict()
        self.exportJsonAttributes(json_dict)
        self.exportJsonChildren(json_dict)
        return self.exportJsonResult(json_dict, parent_dict, key, is_list)
    def exportJsonResult(self, json_dict, parent_dict, key, is_list, sub_defs=[], attr_defs=['value']):
        return super().exportJsonResult(json_dict, parent_dict, key, is_list, attr_defs)
    def exportJsonAttributes(self, json_dict):
        super().exportJsonAttributes(json_dict)
        if self.value is not None:
            json_dict['value'] = self.value
    def exportJsonChildren(self, json_dict):
        super().exportJsonChildren(json_dict)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        if SaveNodeDict:
            node_dict[node] = self 
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('value', node)
        if value is not None and 'value' not in already_processed:
            already_processed.add('value')
            self.value = value
            self.value = ' '.join(self.value.split())
            self.validate_ContributorTypeEnum(self.value)    # validate type ContributorTypeEnum
        super(ContributorType, self)._buildAttributes(node, attrs, already_processed)
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        super(ContributorType, self)._buildChildren(child_, node, nodeName_, True)
        pass
# end class ContributorType


class Attachment(Element):
    """contentType -- Identifies the type of the data in the attachment and allows a method to be chosen to interpret or render the data. Includes mime type parameters such as charset where appropriate.
    language -- The human language of the content. The value can be any valid value according to BCP 47.
    data -- The actual data of the attachment - a sequence of bytes, base64 encoded.
    url -- A location where the data can be accessed.
    size -- The number of bytes of data that make up this attachment (before base64 encoding, if that is done).
    hash -- The calculated hash of the data using SHA-1. Represented using base64.
    title -- A label or set of text to display in place of the data.
    creation -- The date that the attachment was first created.
    
    """
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = Element
    def __init__(self, id: 'string_primitive' = None, extension: List_['Extension'] = None, contentType: 'code' = None, language: 'code' = None, data: 'base64Binary' = None, url: 'url' = None, size: 'unsignedInt' = None, hash: 'base64Binary' = None, title: 'string' = None, creation: 'dateTime' = None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        super(globals().get("Attachment"), self).__init__(id, extension,  **kwargs_)
        self.contentType = contentType
        self.contentType_nsprefix_ = None
        self.language = language
        self.language_nsprefix_ = None
        self.data = data
        self.data_nsprefix_ = None
        self.url = url
        self.url_nsprefix_ = None
        self.size = size
        self.size_nsprefix_ = None
        self.hash = hash
        self.hash_nsprefix_ = None
        self.title = title
        self.title_nsprefix_ = None
        self.creation = creation
        self.creation_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, Attachment)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if Attachment.subclass:
            return Attachment.subclass(*args_, **kwargs_)
        else:
            return Attachment(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_contentType(self):
        return self.contentType
    def set_contentType(self, contentType):
        self.contentType = contentType
    def get_language(self):
        return self.language
    def set_language(self, language):
        self.language = language
    def get_data(self):
        return self.data
    def set_data(self, data):
        self.data = data
    def get_url(self):
        return self.url
    def set_url(self, url):
        self.url = url
    def get_size(self):
        return self.size
    def set_size(self, size):
        self.size = size
    def get_hash(self):
        return self.hash
    def set_hash(self, hash):
        self.hash = hash
    def get_title(self):
        return self.title
    def set_title(self, title):
        self.title = title
    def get_creation(self):
        return self.creation
    def set_creation(self, creation):
        self.creation = creation
    def has__content(self):
        if (
            self.contentType is not None or
            self.language is not None or
            self.data is not None or
            self.url is not None or
            self.size is not None or
            self.hash is not None or
            self.title is not None or
            self.creation is not None or
            super(Attachment, self).has__content()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_=' xmlns:None="http://hl7.org/fhir" ', name_='Attachment', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('Attachment')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'Attachment':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='Attachment')
        if self.has__content():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='Attachment', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='Attachment'):
        super(Attachment, self)._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='Attachment')
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_=' xmlns:None="http://hl7.org/fhir" ', name_='Attachment', fromsubclass_=False, pretty_print=True):
        super(Attachment, self)._exportChildren(outfile, level, namespaceprefix_, namespacedef_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.contentType is not None:
            namespaceprefix_ = self.contentType_nsprefix_ + ':' if (UseCapturedNS_ and self.contentType_nsprefix_) else ''
            self.contentType.export(outfile, level, namespaceprefix_, namespacedef_='', name_='contentType', pretty_print=pretty_print)
        if self.language is not None:
            namespaceprefix_ = self.language_nsprefix_ + ':' if (UseCapturedNS_ and self.language_nsprefix_) else ''
            self.language.export(outfile, level, namespaceprefix_, namespacedef_='', name_='language', pretty_print=pretty_print)
        if self.data is not None:
            namespaceprefix_ = self.data_nsprefix_ + ':' if (UseCapturedNS_ and self.data_nsprefix_) else ''
            self.data.export(outfile, level, namespaceprefix_, namespacedef_='', name_='data', pretty_print=pretty_print)
        if self.url is not None:
            namespaceprefix_ = self.url_nsprefix_ + ':' if (UseCapturedNS_ and self.url_nsprefix_) else ''
            self.url.export(outfile, level, namespaceprefix_, namespacedef_='', name_='url', pretty_print=pretty_print)
        if self.size is not None:
            namespaceprefix_ = self.size_nsprefix_ + ':' if (UseCapturedNS_ and self.size_nsprefix_) else ''
            self.size.export(outfile, level, namespaceprefix_, namespacedef_='', name_='size', pretty_print=pretty_print)
        if self.hash is not None:
            namespaceprefix_ = self.hash_nsprefix_ + ':' if (UseCapturedNS_ and self.hash_nsprefix_) else ''
            self.hash.export(outfile, level, namespaceprefix_, namespacedef_='', name_='hash', pretty_print=pretty_print)
        if self.title is not None:
            namespaceprefix_ = self.title_nsprefix_ + ':' if (UseCapturedNS_ and self.title_nsprefix_) else ''
            self.title.export(outfile, level, namespaceprefix_, namespacedef_='', name_='title', pretty_print=pretty_print)
        if self.creation is not None:
            namespaceprefix_ = self.creation_nsprefix_ + ':' if (UseCapturedNS_ and self.creation_nsprefix_) else ''
            self.creation.export(outfile, level, namespaceprefix_, namespacedef_='', name_='creation', pretty_print=pretty_print)
    def exportJson(self, parent_dict=None, key=None, is_list=False):
        json_dict = dict()
        self.exportJsonAttributes(json_dict)
        self.exportJsonChildren(json_dict)
        return self.exportJsonResult(json_dict, parent_dict, key, is_list)
    def exportJsonResult(self, json_dict, parent_dict, key, is_list, sub_defs=[], attr_defs=[]):
        return super().exportJsonResult(json_dict, parent_dict, key, is_list, attr_defs)
    def exportJsonAttributes(self, json_dict):
        super().exportJsonAttributes(json_dict)
    def exportJsonChildren(self, json_dict):
        super().exportJsonChildren(json_dict)
        if self.contentType is not None:
            child_dict = self.contentType.exportJson(json_dict, 'contentType', False)
            if child_dict:
                json_dict['contentType'] = child_dict
        if self.language is not None:
            child_dict = self.language.exportJson(json_dict, 'language', False)
            if child_dict:
                json_dict['language'] = child_dict
        if self.data is not None:
            child_dict = self.data.exportJson(json_dict, 'data', False)
            if child_dict:
                json_dict['data'] = child_dict
        if self.url is not None:
            child_dict = self.url.exportJson(json_dict, 'url', False)
            if child_dict:
                json_dict['url'] = child_dict
        if self.size is not None:
            child_dict = self.size.exportJson(json_dict, 'size', False)
            if child_dict:
                json_dict['size'] = child_dict
        if self.hash is not None:
            child_dict = self.hash.exportJson(json_dict, 'hash', False)
            if child_dict:
                json_dict['hash'] = child_dict
        if self.title is not None:
            child_dict = self.title.exportJson(json_dict, 'title', False)
            if child_dict:
                json_dict['title'] = child_dict
        if self.creation is not None:
            child_dict = self.creation.exportJson(json_dict, 'creation', False)
            if child_dict:
                json_dict['creation'] = child_dict
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        if SaveNodeDict:
            node_dict[node] = self 
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        super(Attachment, self)._buildAttributes(node, attrs, already_processed)
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'contentType':
            obj_ = code.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.contentType = obj_
            obj_.original_tagname_ = 'contentType'
        elif nodeName_ == 'language':
            obj_ = code.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.language = obj_
            obj_.original_tagname_ = 'language'
        elif nodeName_ == 'data':
            obj_ = base64Binary.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.data = obj_
            obj_.original_tagname_ = 'data'
        elif nodeName_ == 'url':
            obj_ = url.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.url = obj_
            obj_.original_tagname_ = 'url'
        elif nodeName_ == 'size':
            obj_ = unsignedInt.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.size = obj_
            obj_.original_tagname_ = 'size'
        elif nodeName_ == 'hash':
            obj_ = base64Binary.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.hash = obj_
            obj_.original_tagname_ = 'hash'
        elif nodeName_ == 'title':
            obj_ = string.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.title = obj_
            obj_.original_tagname_ = 'title'
        elif nodeName_ == 'creation':
            obj_ = dateTime.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.creation = obj_
            obj_.original_tagname_ = 'creation'
        super(Attachment, self)._buildChildren(child_, node, nodeName_, True)
# end class Attachment


class DataRequirement(Element):
    """type -- The type of the required data, specified as the type name of a resource. For profiles, this value is set to the type of the base resource of the profile.
    profile -- The profile of the required data, specified as the uri of the profile definition.
    mustSupport -- Indicates that specific elements of the type are referenced by the knowledge module and must be supported by the consumer in order to obtain an effective evaluation. This does not mean that a value is required for this element, only that the consuming system must understand the element and be able to provide values for it if they are available.
    The value of mustSupport SHALL be a FHIRPath resolveable on the type of the DataRequirement. The path SHALL consist only of identifiers, constant indexers, and .resolve() (see the [Simple FHIRPath Profile](fhirpath.html#simple) for full details).
    codeFilter -- Code filters specify additional constraints on the data, specifying the value set of interest for a particular element of the data. Each code filter defines an additional constraint on the data, i.e. code filters are AND'ed, not OR'ed.
    dateFilter -- Date filters specify additional constraints on the data in terms of the applicable date range for specific elements. Each date filter specifies an additional constraint on the data, i.e. date filters are AND'ed, not OR'ed.
    limit -- Specifies a maximum number of results that are required (uses the _count search parameter).
    sort -- Specifies the order of the results to be returned.
    
    """
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = Element
    def __init__(self, id: 'string_primitive' = None, extension: List_['Extension'] = None, type_: 'code' = None, profile: List_['canonical'] = None, subjectCodeableConcept: 'CodeableConcept' = None, subjectReference: 'Reference' = None, mustSupport: List_['string'] = None, codeFilter: List_['DataRequirement.CodeFilter'] = None, dateFilter: List_['DataRequirement.DateFilter'] = None, limit: 'positiveInt' = None, sort: List_['DataRequirement.Sort'] = None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        super(globals().get("DataRequirement"), self).__init__(id, extension,  **kwargs_)
        self.type_ = type_
        self.type__nsprefix_ = None
        if profile is None:
            self.profile = []
        else:
            self.profile = profile
        self.profile_nsprefix_ = None
        self.subjectCodeableConcept = subjectCodeableConcept
        self.subjectCodeableConcept_nsprefix_ = None
        self.subjectReference = subjectReference
        self.subjectReference_nsprefix_ = None
        if mustSupport is None:
            self.mustSupport = []
        else:
            self.mustSupport = mustSupport
        self.mustSupport_nsprefix_ = None
        if codeFilter is None:
            self.codeFilter = []
        else:
            self.codeFilter = codeFilter
        self.codeFilter_nsprefix_ = None
        if dateFilter is None:
            self.dateFilter = []
        else:
            self.dateFilter = dateFilter
        self.dateFilter_nsprefix_ = None
        self.limit = limit
        self.limit_nsprefix_ = None
        if sort is None:
            self.sort = []
        else:
            self.sort = sort
        self.sort_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, DataRequirement)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if DataRequirement.subclass:
            return DataRequirement.subclass(*args_, **kwargs_)
        else:
            return DataRequirement(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_type(self):
        return self.type_
    def set_type(self, type_):
        self.type_ = type_
    def get_profile(self):
        return self.profile
    def set_profile(self, profile):
        self.profile = profile
    def add_profile(self, value):
        self.profile.append(value)
    def insert_profile_at(self, index, value):
        self.profile.insert(index, value)
    def replace_profile_at(self, index, value):
        self.profile[index] = value
    def get_subjectCodeableConcept(self):
        return self.subjectCodeableConcept
    def set_subjectCodeableConcept(self, subjectCodeableConcept):
        self.subjectCodeableConcept = subjectCodeableConcept
    def get_subjectReference(self):
        return self.subjectReference
    def set_subjectReference(self, subjectReference):
        self.subjectReference = subjectReference
    def get_mustSupport(self):
        return self.mustSupport
    def set_mustSupport(self, mustSupport):
        self.mustSupport = mustSupport
    def add_mustSupport(self, value):
        self.mustSupport.append(value)
    def insert_mustSupport_at(self, index, value):
        self.mustSupport.insert(index, value)
    def replace_mustSupport_at(self, index, value):
        self.mustSupport[index] = value
    def get_codeFilter(self):
        return self.codeFilter
    def set_codeFilter(self, codeFilter):
        self.codeFilter = codeFilter
    def add_codeFilter(self, value):
        self.codeFilter.append(value)
    def insert_codeFilter_at(self, index, value):
        self.codeFilter.insert(index, value)
    def replace_codeFilter_at(self, index, value):
        self.codeFilter[index] = value
    def get_dateFilter(self):
        return self.dateFilter
    def set_dateFilter(self, dateFilter):
        self.dateFilter = dateFilter
    def add_dateFilter(self, value):
        self.dateFilter.append(value)
    def insert_dateFilter_at(self, index, value):
        self.dateFilter.insert(index, value)
    def replace_dateFilter_at(self, index, value):
        self.dateFilter[index] = value
    def get_limit(self):
        return self.limit
    def set_limit(self, limit):
        self.limit = limit
    def get_sort(self):
        return self.sort
    def set_sort(self, sort):
        self.sort = sort
    def add_sort(self, value):
        self.sort.append(value)
    def insert_sort_at(self, index, value):
        self.sort.insert(index, value)
    def replace_sort_at(self, index, value):
        self.sort[index] = value
    def has__content(self):
        if (
            self.type_ is not None or
            self.profile or
            self.subjectCodeableConcept is not None or
            self.subjectReference is not None or
            self.mustSupport or
            self.codeFilter or
            self.dateFilter or
            self.limit is not None or
            self.sort or
            super(DataRequirement, self).has__content()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_=' xmlns:None="http://hl7.org/fhir" ', name_='DataRequirement', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('DataRequirement')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'DataRequirement':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='DataRequirement')
        if self.has__content():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='DataRequirement', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='DataRequirement'):
        super(DataRequirement, self)._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='DataRequirement')
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_=' xmlns:None="http://hl7.org/fhir" ', name_='DataRequirement', fromsubclass_=False, pretty_print=True):
        super(DataRequirement, self)._exportChildren(outfile, level, namespaceprefix_, namespacedef_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.type_ is not None:
            namespaceprefix_ = self.type__nsprefix_ + ':' if (UseCapturedNS_ and self.type__nsprefix_) else ''
            self.type_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='type', pretty_print=pretty_print)
        for profile_ in self.profile:
            namespaceprefix_ = self.profile_nsprefix_ + ':' if (UseCapturedNS_ and self.profile_nsprefix_) else ''
            profile_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='profile', pretty_print=pretty_print)
        if self.subjectCodeableConcept is not None:
            namespaceprefix_ = self.subjectCodeableConcept_nsprefix_ + ':' if (UseCapturedNS_ and self.subjectCodeableConcept_nsprefix_) else ''
            self.subjectCodeableConcept.export(outfile, level, namespaceprefix_, namespacedef_='', name_='subjectCodeableConcept', pretty_print=pretty_print)
        if self.subjectReference is not None:
            namespaceprefix_ = self.subjectReference_nsprefix_ + ':' if (UseCapturedNS_ and self.subjectReference_nsprefix_) else ''
            self.subjectReference.export(outfile, level, namespaceprefix_, namespacedef_='', name_='subjectReference', pretty_print=pretty_print)
        for mustSupport_ in self.mustSupport:
            namespaceprefix_ = self.mustSupport_nsprefix_ + ':' if (UseCapturedNS_ and self.mustSupport_nsprefix_) else ''
            mustSupport_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='mustSupport', pretty_print=pretty_print)
        for codeFilter_ in self.codeFilter:
            namespaceprefix_ = self.codeFilter_nsprefix_ + ':' if (UseCapturedNS_ and self.codeFilter_nsprefix_) else ''
            codeFilter_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='codeFilter', pretty_print=pretty_print)
        for dateFilter_ in self.dateFilter:
            namespaceprefix_ = self.dateFilter_nsprefix_ + ':' if (UseCapturedNS_ and self.dateFilter_nsprefix_) else ''
            dateFilter_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='dateFilter', pretty_print=pretty_print)
        if self.limit is not None:
            namespaceprefix_ = self.limit_nsprefix_ + ':' if (UseCapturedNS_ and self.limit_nsprefix_) else ''
            self.limit.export(outfile, level, namespaceprefix_, namespacedef_='', name_='limit', pretty_print=pretty_print)
        for sort_ in self.sort:
            namespaceprefix_ = self.sort_nsprefix_ + ':' if (UseCapturedNS_ and self.sort_nsprefix_) else ''
            sort_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='sort', pretty_print=pretty_print)
    def exportJson(self, parent_dict=None, key=None, is_list=False):
        json_dict = dict()
        self.exportJsonAttributes(json_dict)
        self.exportJsonChildren(json_dict)
        return self.exportJsonResult(json_dict, parent_dict, key, is_list)
    def exportJsonResult(self, json_dict, parent_dict, key, is_list, sub_defs=[], attr_defs=[]):
        return super().exportJsonResult(json_dict, parent_dict, key, is_list, attr_defs)
    def exportJsonAttributes(self, json_dict):
        super().exportJsonAttributes(json_dict)
    def exportJsonChildren(self, json_dict):
        super().exportJsonChildren(json_dict)
        if self.type_ is not None:
            child_dict = self.type_.exportJson(json_dict, 'type', False)
            if child_dict:
                json_dict['type'] = child_dict
        child_list = []
        for child in self.profile:
            child_dict = child.exportJson(json_dict, 'profile', True)
            if child_dict:
                child_list.append(child_dict)
        if child_list:
            json_dict['profile'] = child_list
        if self.subjectCodeableConcept is not None:
            child_dict = self.subjectCodeableConcept.exportJson(json_dict, 'subjectCodeableConcept', False)
            if child_dict:
                json_dict['subjectCodeableConcept'] = child_dict
        if self.subjectReference is not None:
            child_dict = self.subjectReference.exportJson(json_dict, 'subjectReference', False)
            if child_dict:
                json_dict['subjectReference'] = child_dict
        child_list = []
        for child in self.mustSupport:
            child_dict = child.exportJson(json_dict, 'mustSupport', True)
            if child_dict:
                child_list.append(child_dict)
        if child_list:
            json_dict['mustSupport'] = child_list
        child_list = []
        for child in self.codeFilter:
            child_dict = child.exportJson(json_dict, 'codeFilter', True)
            if child_dict:
                child_list.append(child_dict)
        if child_list:
            json_dict['codeFilter'] = child_list
        child_list = []
        for child in self.dateFilter:
            child_dict = child.exportJson(json_dict, 'dateFilter', True)
            if child_dict:
                child_list.append(child_dict)
        if child_list:
            json_dict['dateFilter'] = child_list
        if self.limit is not None:
            child_dict = self.limit.exportJson(json_dict, 'limit', False)
            if child_dict:
                json_dict['limit'] = child_dict
        child_list = []
        for child in self.sort:
            child_dict = child.exportJson(json_dict, 'sort', True)
            if child_dict:
                child_list.append(child_dict)
        if child_list:
            json_dict['sort'] = child_list
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        if SaveNodeDict:
            node_dict[node] = self 
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        super(DataRequirement, self)._buildAttributes(node, attrs, already_processed)
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'type':
            obj_ = code.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.type_ = obj_
            obj_.original_tagname_ = 'type'
        elif nodeName_ == 'profile':
            obj_ = canonical.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.profile.append(obj_)
            obj_.original_tagname_ = 'profile'
        elif nodeName_ == 'subjectCodeableConcept':
            obj_ = CodeableConcept.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.subjectCodeableConcept = obj_
            obj_.original_tagname_ = 'subjectCodeableConcept'
        elif nodeName_ == 'subjectReference':
            obj_ = Reference.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.subjectReference = obj_
            obj_.original_tagname_ = 'subjectReference'
        elif nodeName_ == 'mustSupport':
            obj_ = string.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.mustSupport.append(obj_)
            obj_.original_tagname_ = 'mustSupport'
        elif nodeName_ == 'codeFilter':
            obj_ = DataRequirement_CodeFilter.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.codeFilter.append(obj_)
            obj_.original_tagname_ = 'codeFilter'
        elif nodeName_ == 'dateFilter':
            obj_ = DataRequirement_DateFilter.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.dateFilter.append(obj_)
            obj_.original_tagname_ = 'dateFilter'
        elif nodeName_ == 'limit':
            obj_ = positiveInt.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.limit = obj_
            obj_.original_tagname_ = 'limit'
        elif nodeName_ == 'sort':
            obj_ = DataRequirement_Sort.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.sort.append(obj_)
            obj_.original_tagname_ = 'sort'
        super(DataRequirement, self)._buildChildren(child_, node, nodeName_, True)
# end class DataRequirement


class DataRequirement_CodeFilter(Element):
    """path -- The code-valued attribute of the filter. The specified path SHALL be a FHIRPath resolveable on the specified type of the DataRequirement, and SHALL consist only of identifiers, constant indexers, and .resolve(). The path is allowed to contain qualifiers (.) to traverse sub-elements, as well as indexers ([x]) to traverse multiple-cardinality sub-elements (see the [Simple FHIRPath Profile](fhirpath.html#simple) for full details). Note that the index must be an integer constant. The path must resolve to an element of type code, Coding, or CodeableConcept.
    searchParam -- A token parameter that refers to a search parameter defined on the specified type of the DataRequirement, and which searches on elements of type code, Coding, or CodeableConcept.
    valueSet -- The valueset for the code filter. The valueSet and code elements are additive. If valueSet is specified, the filter will return only those data items for which the value of the code-valued element specified in the path is a member of the specified valueset.
    code -- The codes for the code filter. If values are given, the filter will return only those data items for which the code-valued attribute specified by the path has a value that is one of the specified codes. If codes are specified in addition to a value set, the filter returns items matching a code in the value set or one of the specified codes.
    
    """
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = Element
    def __init__(self, id: 'string_primitive' = None, extension: List_['Extension'] = None, path: 'string' = None, searchParam: 'string' = None, valueSet: 'canonical' = None, code: List_['Coding'] = None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        super(globals().get("DataRequirement_CodeFilter"), self).__init__(id, extension,  **kwargs_)
        self.path = path
        self.path_nsprefix_ = None
        self.searchParam = searchParam
        self.searchParam_nsprefix_ = None
        self.valueSet = valueSet
        self.valueSet_nsprefix_ = None
        if code is None:
            self.code = []
        else:
            self.code = code
        self.code_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, DataRequirement_CodeFilter)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if DataRequirement_CodeFilter.subclass:
            return DataRequirement_CodeFilter.subclass(*args_, **kwargs_)
        else:
            return DataRequirement_CodeFilter(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_path(self):
        return self.path
    def set_path(self, path):
        self.path = path
    def get_searchParam(self):
        return self.searchParam
    def set_searchParam(self, searchParam):
        self.searchParam = searchParam
    def get_valueSet(self):
        return self.valueSet
    def set_valueSet(self, valueSet):
        self.valueSet = valueSet
    def get_code(self):
        return self.code
    def set_code(self, code):
        self.code = code
    def add_code(self, value):
        self.code.append(value)
    def insert_code_at(self, index, value):
        self.code.insert(index, value)
    def replace_code_at(self, index, value):
        self.code[index] = value
    def has__content(self):
        if (
            self.path is not None or
            self.searchParam is not None or
            self.valueSet is not None or
            self.code or
            super(DataRequirement_CodeFilter, self).has__content()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_=' xmlns:None="http://hl7.org/fhir" ', name_='DataRequirement.CodeFilter', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('DataRequirement.CodeFilter')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'DataRequirement.CodeFilter':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='DataRequirement.CodeFilter')
        if self.has__content():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='DataRequirement.CodeFilter', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='DataRequirement.CodeFilter'):
        super(DataRequirement_CodeFilter, self)._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='DataRequirement.CodeFilter')
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_=' xmlns:None="http://hl7.org/fhir" ', name_='DataRequirement.CodeFilter', fromsubclass_=False, pretty_print=True):
        super(DataRequirement_CodeFilter, self)._exportChildren(outfile, level, namespaceprefix_, namespacedef_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.path is not None:
            namespaceprefix_ = self.path_nsprefix_ + ':' if (UseCapturedNS_ and self.path_nsprefix_) else ''
            self.path.export(outfile, level, namespaceprefix_, namespacedef_='', name_='path', pretty_print=pretty_print)
        if self.searchParam is not None:
            namespaceprefix_ = self.searchParam_nsprefix_ + ':' if (UseCapturedNS_ and self.searchParam_nsprefix_) else ''
            self.searchParam.export(outfile, level, namespaceprefix_, namespacedef_='', name_='searchParam', pretty_print=pretty_print)
        if self.valueSet is not None:
            namespaceprefix_ = self.valueSet_nsprefix_ + ':' if (UseCapturedNS_ and self.valueSet_nsprefix_) else ''
            self.valueSet.export(outfile, level, namespaceprefix_, namespacedef_='', name_='valueSet', pretty_print=pretty_print)
        for code_ in self.code:
            namespaceprefix_ = self.code_nsprefix_ + ':' if (UseCapturedNS_ and self.code_nsprefix_) else ''
            code_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='code', pretty_print=pretty_print)
    def exportJson(self, parent_dict=None, key=None, is_list=False):
        json_dict = dict()
        self.exportJsonAttributes(json_dict)
        self.exportJsonChildren(json_dict)
        return self.exportJsonResult(json_dict, parent_dict, key, is_list)
    def exportJsonResult(self, json_dict, parent_dict, key, is_list, sub_defs=[], attr_defs=[]):
        return super().exportJsonResult(json_dict, parent_dict, key, is_list, attr_defs)
    def exportJsonAttributes(self, json_dict):
        super().exportJsonAttributes(json_dict)
    def exportJsonChildren(self, json_dict):
        super().exportJsonChildren(json_dict)
        if self.path is not None:
            child_dict = self.path.exportJson(json_dict, 'path', False)
            if child_dict:
                json_dict['path'] = child_dict
        if self.searchParam is not None:
            child_dict = self.searchParam.exportJson(json_dict, 'searchParam', False)
            if child_dict:
                json_dict['searchParam'] = child_dict
        if self.valueSet is not None:
            child_dict = self.valueSet.exportJson(json_dict, 'valueSet', False)
            if child_dict:
                json_dict['valueSet'] = child_dict
        child_list = []
        for child in self.code:
            child_dict = child.exportJson(json_dict, 'code', True)
            if child_dict:
                child_list.append(child_dict)
        if child_list:
            json_dict['code'] = child_list
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        if SaveNodeDict:
            node_dict[node] = self 
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        super(DataRequirement_CodeFilter, self)._buildAttributes(node, attrs, already_processed)
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'path':
            obj_ = string.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.path = obj_
            obj_.original_tagname_ = 'path'
        elif nodeName_ == 'searchParam':
            obj_ = string.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.searchParam = obj_
            obj_.original_tagname_ = 'searchParam'
        elif nodeName_ == 'valueSet':
            obj_ = canonical.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.valueSet = obj_
            obj_.original_tagname_ = 'valueSet'
        elif nodeName_ == 'code':
            obj_ = Coding.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.code.append(obj_)
            obj_.original_tagname_ = 'code'
        super(DataRequirement_CodeFilter, self)._buildChildren(child_, node, nodeName_, True)
# end class DataRequirement_CodeFilter


class DataRequirement_DateFilter(Element):
    """path -- The date-valued attribute of the filter. The specified path SHALL be a FHIRPath resolveable on the specified type of the DataRequirement, and SHALL consist only of identifiers, constant indexers, and .resolve(). The path is allowed to contain qualifiers (.) to traverse sub-elements, as well as indexers ([x]) to traverse multiple-cardinality sub-elements (see the [Simple FHIRPath Profile](fhirpath.html#simple) for full details). Note that the index must be an integer constant. The path must resolve to an element of type date, dateTime, Period, Schedule, or Timing.
    searchParam -- A date parameter that refers to a search parameter defined on the specified type of the DataRequirement, and which searches on elements of type date, dateTime, Period, Schedule, or Timing.
    
    """
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = Element
    def __init__(self, id: 'string_primitive' = None, extension: List_['Extension'] = None, path: 'string' = None, searchParam: 'string' = None, valueDateTime: 'dateTime' = None, valuePeriod: 'Period' = None, valueDuration: 'Duration' = None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        super(globals().get("DataRequirement_DateFilter"), self).__init__(id, extension,  **kwargs_)
        self.path = path
        self.path_nsprefix_ = None
        self.searchParam = searchParam
        self.searchParam_nsprefix_ = None
        self.valueDateTime = valueDateTime
        self.valueDateTime_nsprefix_ = None
        self.valuePeriod = valuePeriod
        self.valuePeriod_nsprefix_ = None
        self.valueDuration = valueDuration
        self.valueDuration_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, DataRequirement_DateFilter)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if DataRequirement_DateFilter.subclass:
            return DataRequirement_DateFilter.subclass(*args_, **kwargs_)
        else:
            return DataRequirement_DateFilter(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_path(self):
        return self.path
    def set_path(self, path):
        self.path = path
    def get_searchParam(self):
        return self.searchParam
    def set_searchParam(self, searchParam):
        self.searchParam = searchParam
    def get_valueDateTime(self):
        return self.valueDateTime
    def set_valueDateTime(self, valueDateTime):
        self.valueDateTime = valueDateTime
    def get_valuePeriod(self):
        return self.valuePeriod
    def set_valuePeriod(self, valuePeriod):
        self.valuePeriod = valuePeriod
    def get_valueDuration(self):
        return self.valueDuration
    def set_valueDuration(self, valueDuration):
        self.valueDuration = valueDuration
    def has__content(self):
        if (
            self.path is not None or
            self.searchParam is not None or
            self.valueDateTime is not None or
            self.valuePeriod is not None or
            self.valueDuration is not None or
            super(DataRequirement_DateFilter, self).has__content()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_=' xmlns:None="http://hl7.org/fhir" ', name_='DataRequirement.DateFilter', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('DataRequirement.DateFilter')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'DataRequirement.DateFilter':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='DataRequirement.DateFilter')
        if self.has__content():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='DataRequirement.DateFilter', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='DataRequirement.DateFilter'):
        super(DataRequirement_DateFilter, self)._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='DataRequirement.DateFilter')
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_=' xmlns:None="http://hl7.org/fhir" ', name_='DataRequirement.DateFilter', fromsubclass_=False, pretty_print=True):
        super(DataRequirement_DateFilter, self)._exportChildren(outfile, level, namespaceprefix_, namespacedef_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.path is not None:
            namespaceprefix_ = self.path_nsprefix_ + ':' if (UseCapturedNS_ and self.path_nsprefix_) else ''
            self.path.export(outfile, level, namespaceprefix_, namespacedef_='', name_='path', pretty_print=pretty_print)
        if self.searchParam is not None:
            namespaceprefix_ = self.searchParam_nsprefix_ + ':' if (UseCapturedNS_ and self.searchParam_nsprefix_) else ''
            self.searchParam.export(outfile, level, namespaceprefix_, namespacedef_='', name_='searchParam', pretty_print=pretty_print)
        if self.valueDateTime is not None:
            namespaceprefix_ = self.valueDateTime_nsprefix_ + ':' if (UseCapturedNS_ and self.valueDateTime_nsprefix_) else ''
            self.valueDateTime.export(outfile, level, namespaceprefix_, namespacedef_='', name_='valueDateTime', pretty_print=pretty_print)
        if self.valuePeriod is not None:
            namespaceprefix_ = self.valuePeriod_nsprefix_ + ':' if (UseCapturedNS_ and self.valuePeriod_nsprefix_) else ''
            self.valuePeriod.export(outfile, level, namespaceprefix_, namespacedef_='', name_='valuePeriod', pretty_print=pretty_print)
        if self.valueDuration is not None:
            namespaceprefix_ = self.valueDuration_nsprefix_ + ':' if (UseCapturedNS_ and self.valueDuration_nsprefix_) else ''
            self.valueDuration.export(outfile, level, namespaceprefix_, namespacedef_='', name_='valueDuration', pretty_print=pretty_print)
    def exportJson(self, parent_dict=None, key=None, is_list=False):
        json_dict = dict()
        self.exportJsonAttributes(json_dict)
        self.exportJsonChildren(json_dict)
        return self.exportJsonResult(json_dict, parent_dict, key, is_list)
    def exportJsonResult(self, json_dict, parent_dict, key, is_list, sub_defs=[], attr_defs=[]):
        return super().exportJsonResult(json_dict, parent_dict, key, is_list, attr_defs)
    def exportJsonAttributes(self, json_dict):
        super().exportJsonAttributes(json_dict)
    def exportJsonChildren(self, json_dict):
        super().exportJsonChildren(json_dict)
        if self.path is not None:
            child_dict = self.path.exportJson(json_dict, 'path', False)
            if child_dict:
                json_dict['path'] = child_dict
        if self.searchParam is not None:
            child_dict = self.searchParam.exportJson(json_dict, 'searchParam', False)
            if child_dict:
                json_dict['searchParam'] = child_dict
        if self.valueDateTime is not None:
            child_dict = self.valueDateTime.exportJson(json_dict, 'valueDateTime', False)
            if child_dict:
                json_dict['valueDateTime'] = child_dict
        if self.valuePeriod is not None:
            child_dict = self.valuePeriod.exportJson(json_dict, 'valuePeriod', False)
            if child_dict:
                json_dict['valuePeriod'] = child_dict
        if self.valueDuration is not None:
            child_dict = self.valueDuration.exportJson(json_dict, 'valueDuration', False)
            if child_dict:
                json_dict['valueDuration'] = child_dict
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        if SaveNodeDict:
            node_dict[node] = self 
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        super(DataRequirement_DateFilter, self)._buildAttributes(node, attrs, already_processed)
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'path':
            obj_ = string.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.path = obj_
            obj_.original_tagname_ = 'path'
        elif nodeName_ == 'searchParam':
            obj_ = string.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.searchParam = obj_
            obj_.original_tagname_ = 'searchParam'
        elif nodeName_ == 'valueDateTime':
            obj_ = dateTime.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.valueDateTime = obj_
            obj_.original_tagname_ = 'valueDateTime'
        elif nodeName_ == 'valuePeriod':
            obj_ = Period.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.valuePeriod = obj_
            obj_.original_tagname_ = 'valuePeriod'
        elif nodeName_ == 'valueDuration':
            obj_ = Duration.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.valueDuration = obj_
            obj_.original_tagname_ = 'valueDuration'
        super(DataRequirement_DateFilter, self)._buildChildren(child_, node, nodeName_, True)
# end class DataRequirement_DateFilter


class DataRequirement_Sort(Element):
    """path -- The attribute of the sort. The specified path must be resolvable from the type of the required data. The path is allowed to contain qualifiers (.) to traverse sub-elements, as well as indexers ([x]) to traverse multiple-cardinality sub-elements. Note that the index must be an integer constant.
    direction -- The direction of the sort, ascending or descending.
    
    """
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = Element
    def __init__(self, id: 'string_primitive' = None, extension: List_['Extension'] = None, path: 'string' = None, direction: 'SortDirection' = None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        super(globals().get("DataRequirement_Sort"), self).__init__(id, extension,  **kwargs_)
        self.path = path
        self.path_nsprefix_ = None
        self.direction = direction
        self.direction_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, DataRequirement_Sort)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if DataRequirement_Sort.subclass:
            return DataRequirement_Sort.subclass(*args_, **kwargs_)
        else:
            return DataRequirement_Sort(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_path(self):
        return self.path
    def set_path(self, path):
        self.path = path
    def get_direction(self):
        return self.direction
    def set_direction(self, direction):
        self.direction = direction
    def has__content(self):
        if (
            self.path is not None or
            self.direction is not None or
            super(DataRequirement_Sort, self).has__content()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_=' xmlns:None="http://hl7.org/fhir" ', name_='DataRequirement.Sort', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('DataRequirement.Sort')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'DataRequirement.Sort':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='DataRequirement.Sort')
        if self.has__content():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='DataRequirement.Sort', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='DataRequirement.Sort'):
        super(DataRequirement_Sort, self)._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='DataRequirement.Sort')
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_=' xmlns:None="http://hl7.org/fhir" ', name_='DataRequirement.Sort', fromsubclass_=False, pretty_print=True):
        super(DataRequirement_Sort, self)._exportChildren(outfile, level, namespaceprefix_, namespacedef_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.path is not None:
            namespaceprefix_ = self.path_nsprefix_ + ':' if (UseCapturedNS_ and self.path_nsprefix_) else ''
            self.path.export(outfile, level, namespaceprefix_, namespacedef_='', name_='path', pretty_print=pretty_print)
        if self.direction is not None:
            namespaceprefix_ = self.direction_nsprefix_ + ':' if (UseCapturedNS_ and self.direction_nsprefix_) else ''
            self.direction.export(outfile, level, namespaceprefix_, namespacedef_='', name_='direction', pretty_print=pretty_print)
    def exportJson(self, parent_dict=None, key=None, is_list=False):
        json_dict = dict()
        self.exportJsonAttributes(json_dict)
        self.exportJsonChildren(json_dict)
        return self.exportJsonResult(json_dict, parent_dict, key, is_list)
    def exportJsonResult(self, json_dict, parent_dict, key, is_list, sub_defs=[], attr_defs=[]):
        return super().exportJsonResult(json_dict, parent_dict, key, is_list, attr_defs)
    def exportJsonAttributes(self, json_dict):
        super().exportJsonAttributes(json_dict)
    def exportJsonChildren(self, json_dict):
        super().exportJsonChildren(json_dict)
        if self.path is not None:
            child_dict = self.path.exportJson(json_dict, 'path', False)
            if child_dict:
                json_dict['path'] = child_dict
        if self.direction is not None:
            child_dict = self.direction.exportJson(json_dict, 'direction', False)
            if child_dict:
                json_dict['direction'] = child_dict
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        if SaveNodeDict:
            node_dict[node] = self 
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        super(DataRequirement_Sort, self)._buildAttributes(node, attrs, already_processed)
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'path':
            obj_ = string.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.path = obj_
            obj_.original_tagname_ = 'path'
        elif nodeName_ == 'direction':
            obj_ = SortDirection.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.direction = obj_
            obj_.original_tagname_ = 'direction'
        super(DataRequirement_Sort, self)._buildChildren(child_, node, nodeName_, True)
# end class DataRequirement_Sort


class SortDirection(Element):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = Element
    def __init__(self, id: 'string_primitive' = None, extension: List_['Extension'] = None, value: 'SortDirectionEnum' = None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        super(globals().get("SortDirection"), self).__init__(id, extension,  **kwargs_)
        self.value = _cast(None, value)
        self.value_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, SortDirection)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if SortDirection.subclass:
            return SortDirection.subclass(*args_, **kwargs_)
        else:
            return SortDirection(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_value(self):
        return self.value
    def set_value(self, value):
        self.value = value
    def validate_SortDirectionEnum(self, value):
        # Validate type SortDirectionEnum, a restriction on code-primitive.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['ascending', 'descending']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on SortDirectionEnum' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
            if len(value) < 1:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd minLength restriction on SortDirectionEnum' % {"value" : value, "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_SortDirectionEnum_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_SortDirectionEnum_patterns_, ))
    validate_SortDirectionEnum_patterns_ = [['^([^\\s]+(\\s[^\\s]+)*)$']]
    def has__content(self):
        if (
            super(SortDirection, self).has__content()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='SortDirection', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('SortDirection')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'SortDirection':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='SortDirection')
        if self.has__content():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='SortDirection', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='SortDirection'):
        super(SortDirection, self)._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='SortDirection')
        if self.value is not None and 'value' not in already_processed:
            already_processed.add('value')
            outfile.write(' value=%s' % (quote_attrib(self.value), ))
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='SortDirection', fromsubclass_=False, pretty_print=True):
        super(SortDirection, self)._exportChildren(outfile, level, namespaceprefix_, namespacedef_, name_, True, pretty_print=pretty_print)
    def exportJson(self, parent_dict=None, key=None, is_list=False):
        json_dict = dict()
        self.exportJsonAttributes(json_dict)
        self.exportJsonChildren(json_dict)
        return self.exportJsonResult(json_dict, parent_dict, key, is_list)
    def exportJsonResult(self, json_dict, parent_dict, key, is_list, sub_defs=[], attr_defs=['value']):
        return super().exportJsonResult(json_dict, parent_dict, key, is_list, attr_defs)
    def exportJsonAttributes(self, json_dict):
        super().exportJsonAttributes(json_dict)
        if self.value is not None:
            json_dict['value'] = self.value
    def exportJsonChildren(self, json_dict):
        super().exportJsonChildren(json_dict)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        if SaveNodeDict:
            node_dict[node] = self 
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('value', node)
        if value is not None and 'value' not in already_processed:
            already_processed.add('value')
            self.value = value
            self.value = ' '.join(self.value.split())
            self.validate_SortDirectionEnum(self.value)    # validate type SortDirectionEnum
        super(SortDirection, self)._buildAttributes(node, attrs, already_processed)
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        super(SortDirection, self)._buildChildren(child_, node, nodeName_, True)
        pass
# end class SortDirection


class Money(Element):
    """value -- Numerical value (with implicit precision).
    currency -- ISO 4217 Currency Code.
    
    """
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = Element
    def __init__(self, id: 'string_primitive' = None, extension: List_['Extension'] = None, value: 'decimal' = None, currency: 'code' = None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        super(globals().get("Money"), self).__init__(id, extension,  **kwargs_)
        self.value = value
        self.value_nsprefix_ = None
        self.currency = currency
        self.currency_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, Money)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if Money.subclass:
            return Money.subclass(*args_, **kwargs_)
        else:
            return Money(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_value(self):
        return self.value
    def set_value(self, value):
        self.value = value
    def get_currency(self):
        return self.currency
    def set_currency(self, currency):
        self.currency = currency
    def has__content(self):
        if (
            self.value is not None or
            self.currency is not None or
            super(Money, self).has__content()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_=' xmlns:None="http://hl7.org/fhir" ', name_='Money', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('Money')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'Money':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='Money')
        if self.has__content():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='Money', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='Money'):
        super(Money, self)._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='Money')
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_=' xmlns:None="http://hl7.org/fhir" ', name_='Money', fromsubclass_=False, pretty_print=True):
        super(Money, self)._exportChildren(outfile, level, namespaceprefix_, namespacedef_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.value is not None:
            namespaceprefix_ = self.value_nsprefix_ + ':' if (UseCapturedNS_ and self.value_nsprefix_) else ''
            self.value.export(outfile, level, namespaceprefix_, namespacedef_='', name_='value', pretty_print=pretty_print)
        if self.currency is not None:
            namespaceprefix_ = self.currency_nsprefix_ + ':' if (UseCapturedNS_ and self.currency_nsprefix_) else ''
            self.currency.export(outfile, level, namespaceprefix_, namespacedef_='', name_='currency', pretty_print=pretty_print)
    def exportJson(self, parent_dict=None, key=None, is_list=False):
        json_dict = dict()
        self.exportJsonAttributes(json_dict)
        self.exportJsonChildren(json_dict)
        return self.exportJsonResult(json_dict, parent_dict, key, is_list)
    def exportJsonResult(self, json_dict, parent_dict, key, is_list, sub_defs=[], attr_defs=[]):
        return super().exportJsonResult(json_dict, parent_dict, key, is_list, attr_defs)
    def exportJsonAttributes(self, json_dict):
        super().exportJsonAttributes(json_dict)
    def exportJsonChildren(self, json_dict):
        super().exportJsonChildren(json_dict)
        if self.value is not None:
            child_dict = self.value.exportJson(json_dict, 'value', False)
            if child_dict:
                json_dict['value'] = child_dict
        if self.currency is not None:
            child_dict = self.currency.exportJson(json_dict, 'currency', False)
            if child_dict:
                json_dict['currency'] = child_dict
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        if SaveNodeDict:
            node_dict[node] = self 
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        super(Money, self)._buildAttributes(node, attrs, already_processed)
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'value':
            obj_ = decimal.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.value = obj_
            obj_.original_tagname_ = 'value'
        elif nodeName_ == 'currency':
            obj_ = code.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.currency = obj_
            obj_.original_tagname_ = 'currency'
        super(Money, self)._buildChildren(child_, node, nodeName_, True)
# end class Money


class HumanName(Element):
    """use -- Identifies the purpose for this name.
    text -- Specifies the entire name as it should be displayed e.g. on an application UI. This may be provided instead of or as well as the specific parts.
    family -- The part of a name that links to the genealogy. In some cultures (e.g. Eritrea) the family name of a son is the first name of his father.
    given -- Given name.
    prefix -- Part of the name that is acquired as a title due to academic, legal, employment or nobility status, etc. and that appears at the start of the name.
    suffix -- Part of the name that is acquired as a title due to academic, legal, employment or nobility status, etc. and that appears at the end of the name.
    period -- Indicates the period of time when this name was valid for the named person.
    
    """
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = Element
    def __init__(self, id: 'string_primitive' = None, extension: List_['Extension'] = None, use: 'NameUse' = None, text: 'string' = None, family: 'string' = None, given: List_['string'] = None, prefix: List_['string'] = None, suffix: List_['string'] = None, period: 'Period' = None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        super(globals().get("HumanName"), self).__init__(id, extension,  **kwargs_)
        self.use = use
        self.use_nsprefix_ = None
        self.text = text
        self.text_nsprefix_ = None
        self.family = family
        self.family_nsprefix_ = None
        if given is None:
            self.given = []
        else:
            self.given = given
        self.given_nsprefix_ = None
        if prefix is None:
            self.prefix = []
        else:
            self.prefix = prefix
        self.prefix_nsprefix_ = None
        if suffix is None:
            self.suffix = []
        else:
            self.suffix = suffix
        self.suffix_nsprefix_ = None
        self.period = period
        self.period_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, HumanName)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if HumanName.subclass:
            return HumanName.subclass(*args_, **kwargs_)
        else:
            return HumanName(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_use(self):
        return self.use
    def set_use(self, use):
        self.use = use
    def get_text(self):
        return self.text
    def set_text(self, text):
        self.text = text
    def get_family(self):
        return self.family
    def set_family(self, family):
        self.family = family
    def get_given(self):
        return self.given
    def set_given(self, given):
        self.given = given
    def add_given(self, value):
        self.given.append(value)
    def insert_given_at(self, index, value):
        self.given.insert(index, value)
    def replace_given_at(self, index, value):
        self.given[index] = value
    def get_prefix(self):
        return self.prefix
    def set_prefix(self, prefix):
        self.prefix = prefix
    def add_prefix(self, value):
        self.prefix.append(value)
    def insert_prefix_at(self, index, value):
        self.prefix.insert(index, value)
    def replace_prefix_at(self, index, value):
        self.prefix[index] = value
    def get_suffix(self):
        return self.suffix
    def set_suffix(self, suffix):
        self.suffix = suffix
    def add_suffix(self, value):
        self.suffix.append(value)
    def insert_suffix_at(self, index, value):
        self.suffix.insert(index, value)
    def replace_suffix_at(self, index, value):
        self.suffix[index] = value
    def get_period(self):
        return self.period
    def set_period(self, period):
        self.period = period
    def has__content(self):
        if (
            self.use is not None or
            self.text is not None or
            self.family is not None or
            self.given or
            self.prefix or
            self.suffix or
            self.period is not None or
            super(HumanName, self).has__content()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_=' xmlns:None="http://hl7.org/fhir" ', name_='HumanName', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('HumanName')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'HumanName':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='HumanName')
        if self.has__content():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='HumanName', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='HumanName'):
        super(HumanName, self)._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='HumanName')
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_=' xmlns:None="http://hl7.org/fhir" ', name_='HumanName', fromsubclass_=False, pretty_print=True):
        super(HumanName, self)._exportChildren(outfile, level, namespaceprefix_, namespacedef_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.use is not None:
            namespaceprefix_ = self.use_nsprefix_ + ':' if (UseCapturedNS_ and self.use_nsprefix_) else ''
            self.use.export(outfile, level, namespaceprefix_, namespacedef_='', name_='use', pretty_print=pretty_print)
        if self.text is not None:
            namespaceprefix_ = self.text_nsprefix_ + ':' if (UseCapturedNS_ and self.text_nsprefix_) else ''
            self.text.export(outfile, level, namespaceprefix_, namespacedef_='', name_='text', pretty_print=pretty_print)
        if self.family is not None:
            namespaceprefix_ = self.family_nsprefix_ + ':' if (UseCapturedNS_ and self.family_nsprefix_) else ''
            self.family.export(outfile, level, namespaceprefix_, namespacedef_='', name_='family', pretty_print=pretty_print)
        for given_ in self.given:
            namespaceprefix_ = self.given_nsprefix_ + ':' if (UseCapturedNS_ and self.given_nsprefix_) else ''
            given_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='given', pretty_print=pretty_print)
        for prefix_ in self.prefix:
            namespaceprefix_ = self.prefix_nsprefix_ + ':' if (UseCapturedNS_ and self.prefix_nsprefix_) else ''
            prefix_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='prefix', pretty_print=pretty_print)
        for suffix_ in self.suffix:
            namespaceprefix_ = self.suffix_nsprefix_ + ':' if (UseCapturedNS_ and self.suffix_nsprefix_) else ''
            suffix_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='suffix', pretty_print=pretty_print)
        if self.period is not None:
            namespaceprefix_ = self.period_nsprefix_ + ':' if (UseCapturedNS_ and self.period_nsprefix_) else ''
            self.period.export(outfile, level, namespaceprefix_, namespacedef_='', name_='period', pretty_print=pretty_print)
    def exportJson(self, parent_dict=None, key=None, is_list=False):
        json_dict = dict()
        self.exportJsonAttributes(json_dict)
        self.exportJsonChildren(json_dict)
        return self.exportJsonResult(json_dict, parent_dict, key, is_list)
    def exportJsonResult(self, json_dict, parent_dict, key, is_list, sub_defs=[], attr_defs=[]):
        return super().exportJsonResult(json_dict, parent_dict, key, is_list, attr_defs)
    def exportJsonAttributes(self, json_dict):
        super().exportJsonAttributes(json_dict)
    def exportJsonChildren(self, json_dict):
        super().exportJsonChildren(json_dict)
        if self.use is not None:
            child_dict = self.use.exportJson(json_dict, 'use', False)
            if child_dict:
                json_dict['use'] = child_dict
        if self.text is not None:
            child_dict = self.text.exportJson(json_dict, 'text', False)
            if child_dict:
                json_dict['text'] = child_dict
        if self.family is not None:
            child_dict = self.family.exportJson(json_dict, 'family', False)
            if child_dict:
                json_dict['family'] = child_dict
        child_list = []
        for child in self.given:
            child_dict = child.exportJson(json_dict, 'given', True)
            if child_dict:
                child_list.append(child_dict)
        if child_list:
            json_dict['given'] = child_list
        child_list = []
        for child in self.prefix:
            child_dict = child.exportJson(json_dict, 'prefix', True)
            if child_dict:
                child_list.append(child_dict)
        if child_list:
            json_dict['prefix'] = child_list
        child_list = []
        for child in self.suffix:
            child_dict = child.exportJson(json_dict, 'suffix', True)
            if child_dict:
                child_list.append(child_dict)
        if child_list:
            json_dict['suffix'] = child_list
        if self.period is not None:
            child_dict = self.period.exportJson(json_dict, 'period', False)
            if child_dict:
                json_dict['period'] = child_dict
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        if SaveNodeDict:
            node_dict[node] = self 
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        super(HumanName, self)._buildAttributes(node, attrs, already_processed)
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'use':
            obj_ = NameUse.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.use = obj_
            obj_.original_tagname_ = 'use'
        elif nodeName_ == 'text':
            obj_ = string.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.text = obj_
            obj_.original_tagname_ = 'text'
        elif nodeName_ == 'family':
            obj_ = string.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.family = obj_
            obj_.original_tagname_ = 'family'
        elif nodeName_ == 'given':
            obj_ = string.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.given.append(obj_)
            obj_.original_tagname_ = 'given'
        elif nodeName_ == 'prefix':
            obj_ = string.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.prefix.append(obj_)
            obj_.original_tagname_ = 'prefix'
        elif nodeName_ == 'suffix':
            obj_ = string.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.suffix.append(obj_)
            obj_.original_tagname_ = 'suffix'
        elif nodeName_ == 'period':
            obj_ = Period.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.period = obj_
            obj_.original_tagname_ = 'period'
        super(HumanName, self)._buildChildren(child_, node, nodeName_, True)
# end class HumanName


class NameUse(Element):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = Element
    def __init__(self, id: 'string_primitive' = None, extension: List_['Extension'] = None, value: 'NameUseEnum' = None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        super(globals().get("NameUse"), self).__init__(id, extension,  **kwargs_)
        self.value = _cast(None, value)
        self.value_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, NameUse)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if NameUse.subclass:
            return NameUse.subclass(*args_, **kwargs_)
        else:
            return NameUse(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_value(self):
        return self.value
    def set_value(self, value):
        self.value = value
    def validate_NameUseEnum(self, value):
        # Validate type NameUseEnum, a restriction on code-primitive.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['usual', 'official', 'temp', 'nickname', 'anonymous', 'old', 'maiden']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on NameUseEnum' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
            if len(value) < 1:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd minLength restriction on NameUseEnum' % {"value" : value, "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_NameUseEnum_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_NameUseEnum_patterns_, ))
    validate_NameUseEnum_patterns_ = [['^([^\\s]+(\\s[^\\s]+)*)$']]
    def has__content(self):
        if (
            super(NameUse, self).has__content()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='NameUse', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('NameUse')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'NameUse':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='NameUse')
        if self.has__content():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='NameUse', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='NameUse'):
        super(NameUse, self)._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='NameUse')
        if self.value is not None and 'value' not in already_processed:
            already_processed.add('value')
            outfile.write(' value=%s' % (quote_attrib(self.value), ))
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='NameUse', fromsubclass_=False, pretty_print=True):
        super(NameUse, self)._exportChildren(outfile, level, namespaceprefix_, namespacedef_, name_, True, pretty_print=pretty_print)
    def exportJson(self, parent_dict=None, key=None, is_list=False):
        json_dict = dict()
        self.exportJsonAttributes(json_dict)
        self.exportJsonChildren(json_dict)
        return self.exportJsonResult(json_dict, parent_dict, key, is_list)
    def exportJsonResult(self, json_dict, parent_dict, key, is_list, sub_defs=[], attr_defs=['value']):
        return super().exportJsonResult(json_dict, parent_dict, key, is_list, attr_defs)
    def exportJsonAttributes(self, json_dict):
        super().exportJsonAttributes(json_dict)
        if self.value is not None:
            json_dict['value'] = self.value
    def exportJsonChildren(self, json_dict):
        super().exportJsonChildren(json_dict)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        if SaveNodeDict:
            node_dict[node] = self 
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('value', node)
        if value is not None and 'value' not in already_processed:
            already_processed.add('value')
            self.value = value
            self.value = ' '.join(self.value.split())
            self.validate_NameUseEnum(self.value)    # validate type NameUseEnum
        super(NameUse, self)._buildAttributes(node, attrs, already_processed)
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        super(NameUse, self)._buildChildren(child_, node, nodeName_, True)
        pass
# end class NameUse


class ContactPoint(Element):
    """system -- Telecommunications form for contact point - what communications system is required to make use of the contact.
    value -- The actual contact point details, in a form that is meaningful to the designated communication system (i.e. phone number or email address).
    use -- Identifies the purpose for the contact point.
    rank -- Specifies a preferred order in which to use a set of contacts. ContactPoints with lower rank values are more preferred than those with higher rank values.
    period -- Time period when the contact point was/is in use.
    
    """
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = Element
    def __init__(self, id: 'string_primitive' = None, extension: List_['Extension'] = None, system: 'ContactPointSystem' = None, value: 'string' = None, use: 'ContactPointUse' = None, rank: 'positiveInt' = None, period: 'Period' = None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        super(globals().get("ContactPoint"), self).__init__(id, extension,  **kwargs_)
        self.system = system
        self.system_nsprefix_ = None
        self.value = value
        self.value_nsprefix_ = None
        self.use = use
        self.use_nsprefix_ = None
        self.rank = rank
        self.rank_nsprefix_ = None
        self.period = period
        self.period_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ContactPoint)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ContactPoint.subclass:
            return ContactPoint.subclass(*args_, **kwargs_)
        else:
            return ContactPoint(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_system(self):
        return self.system
    def set_system(self, system):
        self.system = system
    def get_value(self):
        return self.value
    def set_value(self, value):
        self.value = value
    def get_use(self):
        return self.use
    def set_use(self, use):
        self.use = use
    def get_rank(self):
        return self.rank
    def set_rank(self, rank):
        self.rank = rank
    def get_period(self):
        return self.period
    def set_period(self, period):
        self.period = period
    def has__content(self):
        if (
            self.system is not None or
            self.value is not None or
            self.use is not None or
            self.rank is not None or
            self.period is not None or
            super(ContactPoint, self).has__content()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_=' xmlns:None="http://hl7.org/fhir" ', name_='ContactPoint', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('ContactPoint')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'ContactPoint':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='ContactPoint')
        if self.has__content():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='ContactPoint', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='ContactPoint'):
        super(ContactPoint, self)._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='ContactPoint')
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_=' xmlns:None="http://hl7.org/fhir" ', name_='ContactPoint', fromsubclass_=False, pretty_print=True):
        super(ContactPoint, self)._exportChildren(outfile, level, namespaceprefix_, namespacedef_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.system is not None:
            namespaceprefix_ = self.system_nsprefix_ + ':' if (UseCapturedNS_ and self.system_nsprefix_) else ''
            self.system.export(outfile, level, namespaceprefix_, namespacedef_='', name_='system', pretty_print=pretty_print)
        if self.value is not None:
            namespaceprefix_ = self.value_nsprefix_ + ':' if (UseCapturedNS_ and self.value_nsprefix_) else ''
            self.value.export(outfile, level, namespaceprefix_, namespacedef_='', name_='value', pretty_print=pretty_print)
        if self.use is not None:
            namespaceprefix_ = self.use_nsprefix_ + ':' if (UseCapturedNS_ and self.use_nsprefix_) else ''
            self.use.export(outfile, level, namespaceprefix_, namespacedef_='', name_='use', pretty_print=pretty_print)
        if self.rank is not None:
            namespaceprefix_ = self.rank_nsprefix_ + ':' if (UseCapturedNS_ and self.rank_nsprefix_) else ''
            self.rank.export(outfile, level, namespaceprefix_, namespacedef_='', name_='rank', pretty_print=pretty_print)
        if self.period is not None:
            namespaceprefix_ = self.period_nsprefix_ + ':' if (UseCapturedNS_ and self.period_nsprefix_) else ''
            self.period.export(outfile, level, namespaceprefix_, namespacedef_='', name_='period', pretty_print=pretty_print)
    def exportJson(self, parent_dict=None, key=None, is_list=False):
        json_dict = dict()
        self.exportJsonAttributes(json_dict)
        self.exportJsonChildren(json_dict)
        return self.exportJsonResult(json_dict, parent_dict, key, is_list)
    def exportJsonResult(self, json_dict, parent_dict, key, is_list, sub_defs=[], attr_defs=[]):
        return super().exportJsonResult(json_dict, parent_dict, key, is_list, attr_defs)
    def exportJsonAttributes(self, json_dict):
        super().exportJsonAttributes(json_dict)
    def exportJsonChildren(self, json_dict):
        super().exportJsonChildren(json_dict)
        if self.system is not None:
            child_dict = self.system.exportJson(json_dict, 'system', False)
            if child_dict:
                json_dict['system'] = child_dict
        if self.value is not None:
            child_dict = self.value.exportJson(json_dict, 'value', False)
            if child_dict:
                json_dict['value'] = child_dict
        if self.use is not None:
            child_dict = self.use.exportJson(json_dict, 'use', False)
            if child_dict:
                json_dict['use'] = child_dict
        if self.rank is not None:
            child_dict = self.rank.exportJson(json_dict, 'rank', False)
            if child_dict:
                json_dict['rank'] = child_dict
        if self.period is not None:
            child_dict = self.period.exportJson(json_dict, 'period', False)
            if child_dict:
                json_dict['period'] = child_dict
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        if SaveNodeDict:
            node_dict[node] = self 
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        super(ContactPoint, self)._buildAttributes(node, attrs, already_processed)
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'system':
            obj_ = ContactPointSystem.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.system = obj_
            obj_.original_tagname_ = 'system'
        elif nodeName_ == 'value':
            obj_ = string.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.value = obj_
            obj_.original_tagname_ = 'value'
        elif nodeName_ == 'use':
            obj_ = ContactPointUse.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.use = obj_
            obj_.original_tagname_ = 'use'
        elif nodeName_ == 'rank':
            obj_ = positiveInt.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.rank = obj_
            obj_.original_tagname_ = 'rank'
        elif nodeName_ == 'period':
            obj_ = Period.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.period = obj_
            obj_.original_tagname_ = 'period'
        super(ContactPoint, self)._buildChildren(child_, node, nodeName_, True)
# end class ContactPoint


class ContactPointSystem(Element):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = Element
    def __init__(self, id: 'string_primitive' = None, extension: List_['Extension'] = None, value: 'ContactPointSystemEnum' = None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        super(globals().get("ContactPointSystem"), self).__init__(id, extension,  **kwargs_)
        self.value = _cast(None, value)
        self.value_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ContactPointSystem)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ContactPointSystem.subclass:
            return ContactPointSystem.subclass(*args_, **kwargs_)
        else:
            return ContactPointSystem(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_value(self):
        return self.value
    def set_value(self, value):
        self.value = value
    def validate_ContactPointSystemEnum(self, value):
        # Validate type ContactPointSystemEnum, a restriction on code-primitive.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['phone', 'fax', 'email', 'pager', 'url', 'sms', 'other']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on ContactPointSystemEnum' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
            if len(value) < 1:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd minLength restriction on ContactPointSystemEnum' % {"value" : value, "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_ContactPointSystemEnum_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_ContactPointSystemEnum_patterns_, ))
    validate_ContactPointSystemEnum_patterns_ = [['^([^\\s]+(\\s[^\\s]+)*)$']]
    def has__content(self):
        if (
            super(ContactPointSystem, self).has__content()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='ContactPointSystem', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('ContactPointSystem')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'ContactPointSystem':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='ContactPointSystem')
        if self.has__content():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='ContactPointSystem', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='ContactPointSystem'):
        super(ContactPointSystem, self)._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='ContactPointSystem')
        if self.value is not None and 'value' not in already_processed:
            already_processed.add('value')
            outfile.write(' value=%s' % (quote_attrib(self.value), ))
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='ContactPointSystem', fromsubclass_=False, pretty_print=True):
        super(ContactPointSystem, self)._exportChildren(outfile, level, namespaceprefix_, namespacedef_, name_, True, pretty_print=pretty_print)
    def exportJson(self, parent_dict=None, key=None, is_list=False):
        json_dict = dict()
        self.exportJsonAttributes(json_dict)
        self.exportJsonChildren(json_dict)
        return self.exportJsonResult(json_dict, parent_dict, key, is_list)
    def exportJsonResult(self, json_dict, parent_dict, key, is_list, sub_defs=[], attr_defs=['value']):
        return super().exportJsonResult(json_dict, parent_dict, key, is_list, attr_defs)
    def exportJsonAttributes(self, json_dict):
        super().exportJsonAttributes(json_dict)
        if self.value is not None:
            json_dict['value'] = self.value
    def exportJsonChildren(self, json_dict):
        super().exportJsonChildren(json_dict)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        if SaveNodeDict:
            node_dict[node] = self 
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('value', node)
        if value is not None and 'value' not in already_processed:
            already_processed.add('value')
            self.value = value
            self.value = ' '.join(self.value.split())
            self.validate_ContactPointSystemEnum(self.value)    # validate type ContactPointSystemEnum
        super(ContactPointSystem, self)._buildAttributes(node, attrs, already_processed)
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        super(ContactPointSystem, self)._buildChildren(child_, node, nodeName_, True)
        pass
# end class ContactPointSystem


class ContactPointUse(Element):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = Element
    def __init__(self, id: 'string_primitive' = None, extension: List_['Extension'] = None, value: 'ContactPointUseEnum' = None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        super(globals().get("ContactPointUse"), self).__init__(id, extension,  **kwargs_)
        self.value = _cast(None, value)
        self.value_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ContactPointUse)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ContactPointUse.subclass:
            return ContactPointUse.subclass(*args_, **kwargs_)
        else:
            return ContactPointUse(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_value(self):
        return self.value
    def set_value(self, value):
        self.value = value
    def validate_ContactPointUseEnum(self, value):
        # Validate type ContactPointUseEnum, a restriction on code-primitive.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['home', 'work', 'temp', 'old', 'mobile']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on ContactPointUseEnum' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
            if len(value) < 1:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd minLength restriction on ContactPointUseEnum' % {"value" : value, "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_ContactPointUseEnum_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_ContactPointUseEnum_patterns_, ))
    validate_ContactPointUseEnum_patterns_ = [['^([^\\s]+(\\s[^\\s]+)*)$']]
    def has__content(self):
        if (
            super(ContactPointUse, self).has__content()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='ContactPointUse', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('ContactPointUse')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'ContactPointUse':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='ContactPointUse')
        if self.has__content():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='ContactPointUse', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='ContactPointUse'):
        super(ContactPointUse, self)._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='ContactPointUse')
        if self.value is not None and 'value' not in already_processed:
            already_processed.add('value')
            outfile.write(' value=%s' % (quote_attrib(self.value), ))
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='ContactPointUse', fromsubclass_=False, pretty_print=True):
        super(ContactPointUse, self)._exportChildren(outfile, level, namespaceprefix_, namespacedef_, name_, True, pretty_print=pretty_print)
    def exportJson(self, parent_dict=None, key=None, is_list=False):
        json_dict = dict()
        self.exportJsonAttributes(json_dict)
        self.exportJsonChildren(json_dict)
        return self.exportJsonResult(json_dict, parent_dict, key, is_list)
    def exportJsonResult(self, json_dict, parent_dict, key, is_list, sub_defs=[], attr_defs=['value']):
        return super().exportJsonResult(json_dict, parent_dict, key, is_list, attr_defs)
    def exportJsonAttributes(self, json_dict):
        super().exportJsonAttributes(json_dict)
        if self.value is not None:
            json_dict['value'] = self.value
    def exportJsonChildren(self, json_dict):
        super().exportJsonChildren(json_dict)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        if SaveNodeDict:
            node_dict[node] = self 
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('value', node)
        if value is not None and 'value' not in already_processed:
            already_processed.add('value')
            self.value = value
            self.value = ' '.join(self.value.split())
            self.validate_ContactPointUseEnum(self.value)    # validate type ContactPointUseEnum
        super(ContactPointUse, self)._buildAttributes(node, attrs, already_processed)
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        super(ContactPointUse, self)._buildChildren(child_, node, nodeName_, True)
        pass
# end class ContactPointUse


class Identifier(Element):
    """use -- The purpose of this identifier.
    type -- A coded type for the identifier that can be used to determine which identifier to use for a specific purpose.
    system -- Establishes the namespace for the value - that is, a URL that describes a set values that are unique.
    value -- The portion of the identifier typically relevant to the user and which is unique within the context of the system.
    period -- Time period during which identifier is/was valid for use.
    assigner -- Organization that issued/manages the identifier.
    
    """
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = Element
    def __init__(self, id: 'string_primitive' = None, extension: List_['Extension'] = None, use: 'IdentifierUse' = None, type_: 'CodeableConcept' = None, system: 'uri' = None, value: 'string' = None, period: 'Period' = None, assigner: 'Reference' = None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        super(globals().get("Identifier"), self).__init__(id, extension,  **kwargs_)
        self.use = use
        self.use_nsprefix_ = None
        self.type_ = type_
        self.type__nsprefix_ = None
        self.system = system
        self.system_nsprefix_ = None
        self.value = value
        self.value_nsprefix_ = None
        self.period = period
        self.period_nsprefix_ = None
        self.assigner = assigner
        self.assigner_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, Identifier)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if Identifier.subclass:
            return Identifier.subclass(*args_, **kwargs_)
        else:
            return Identifier(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_use(self):
        return self.use
    def set_use(self, use):
        self.use = use
    def get_type(self):
        return self.type_
    def set_type(self, type_):
        self.type_ = type_
    def get_system(self):
        return self.system
    def set_system(self, system):
        self.system = system
    def get_value(self):
        return self.value
    def set_value(self, value):
        self.value = value
    def get_period(self):
        return self.period
    def set_period(self, period):
        self.period = period
    def get_assigner(self):
        return self.assigner
    def set_assigner(self, assigner):
        self.assigner = assigner
    def has__content(self):
        if (
            self.use is not None or
            self.type_ is not None or
            self.system is not None or
            self.value is not None or
            self.period is not None or
            self.assigner is not None or
            super(Identifier, self).has__content()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_=' xmlns:None="http://hl7.org/fhir" ', name_='Identifier', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('Identifier')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'Identifier':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='Identifier')
        if self.has__content():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='Identifier', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='Identifier'):
        super(Identifier, self)._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='Identifier')
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_=' xmlns:None="http://hl7.org/fhir" ', name_='Identifier', fromsubclass_=False, pretty_print=True):
        super(Identifier, self)._exportChildren(outfile, level, namespaceprefix_, namespacedef_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.use is not None:
            namespaceprefix_ = self.use_nsprefix_ + ':' if (UseCapturedNS_ and self.use_nsprefix_) else ''
            self.use.export(outfile, level, namespaceprefix_, namespacedef_='', name_='use', pretty_print=pretty_print)
        if self.type_ is not None:
            namespaceprefix_ = self.type__nsprefix_ + ':' if (UseCapturedNS_ and self.type__nsprefix_) else ''
            self.type_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='type', pretty_print=pretty_print)
        if self.system is not None:
            namespaceprefix_ = self.system_nsprefix_ + ':' if (UseCapturedNS_ and self.system_nsprefix_) else ''
            self.system.export(outfile, level, namespaceprefix_, namespacedef_='', name_='system', pretty_print=pretty_print)
        if self.value is not None:
            namespaceprefix_ = self.value_nsprefix_ + ':' if (UseCapturedNS_ and self.value_nsprefix_) else ''
            self.value.export(outfile, level, namespaceprefix_, namespacedef_='', name_='value', pretty_print=pretty_print)
        if self.period is not None:
            namespaceprefix_ = self.period_nsprefix_ + ':' if (UseCapturedNS_ and self.period_nsprefix_) else ''
            self.period.export(outfile, level, namespaceprefix_, namespacedef_='', name_='period', pretty_print=pretty_print)
        if self.assigner is not None:
            namespaceprefix_ = self.assigner_nsprefix_ + ':' if (UseCapturedNS_ and self.assigner_nsprefix_) else ''
            self.assigner.export(outfile, level, namespaceprefix_, namespacedef_='', name_='assigner', pretty_print=pretty_print)
    def exportJson(self, parent_dict=None, key=None, is_list=False):
        json_dict = dict()
        self.exportJsonAttributes(json_dict)
        self.exportJsonChildren(json_dict)
        return self.exportJsonResult(json_dict, parent_dict, key, is_list)
    def exportJsonResult(self, json_dict, parent_dict, key, is_list, sub_defs=[], attr_defs=[]):
        return super().exportJsonResult(json_dict, parent_dict, key, is_list, attr_defs)
    def exportJsonAttributes(self, json_dict):
        super().exportJsonAttributes(json_dict)
    def exportJsonChildren(self, json_dict):
        super().exportJsonChildren(json_dict)
        if self.use is not None:
            child_dict = self.use.exportJson(json_dict, 'use', False)
            if child_dict:
                json_dict['use'] = child_dict
        if self.type_ is not None:
            child_dict = self.type_.exportJson(json_dict, 'type', False)
            if child_dict:
                json_dict['type'] = child_dict
        if self.system is not None:
            child_dict = self.system.exportJson(json_dict, 'system', False)
            if child_dict:
                json_dict['system'] = child_dict
        if self.value is not None:
            child_dict = self.value.exportJson(json_dict, 'value', False)
            if child_dict:
                json_dict['value'] = child_dict
        if self.period is not None:
            child_dict = self.period.exportJson(json_dict, 'period', False)
            if child_dict:
                json_dict['period'] = child_dict
        if self.assigner is not None:
            child_dict = self.assigner.exportJson(json_dict, 'assigner', False)
            if child_dict:
                json_dict['assigner'] = child_dict
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        if SaveNodeDict:
            node_dict[node] = self 
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        super(Identifier, self)._buildAttributes(node, attrs, already_processed)
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'use':
            obj_ = IdentifierUse.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.use = obj_
            obj_.original_tagname_ = 'use'
        elif nodeName_ == 'type':
            obj_ = CodeableConcept.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.type_ = obj_
            obj_.original_tagname_ = 'type'
        elif nodeName_ == 'system':
            obj_ = uri.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.system = obj_
            obj_.original_tagname_ = 'system'
        elif nodeName_ == 'value':
            obj_ = string.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.value = obj_
            obj_.original_tagname_ = 'value'
        elif nodeName_ == 'period':
            obj_ = Period.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.period = obj_
            obj_.original_tagname_ = 'period'
        elif nodeName_ == 'assigner':
            obj_ = Reference.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.assigner = obj_
            obj_.original_tagname_ = 'assigner'
        super(Identifier, self)._buildChildren(child_, node, nodeName_, True)
# end class Identifier


class IdentifierUse(Element):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = Element
    def __init__(self, id: 'string_primitive' = None, extension: List_['Extension'] = None, value: 'IdentifierUseEnum' = None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        super(globals().get("IdentifierUse"), self).__init__(id, extension,  **kwargs_)
        self.value = _cast(None, value)
        self.value_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, IdentifierUse)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if IdentifierUse.subclass:
            return IdentifierUse.subclass(*args_, **kwargs_)
        else:
            return IdentifierUse(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_value(self):
        return self.value
    def set_value(self, value):
        self.value = value
    def validate_IdentifierUseEnum(self, value):
        # Validate type IdentifierUseEnum, a restriction on code-primitive.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['usual', 'official', 'temp', 'secondary', 'old']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on IdentifierUseEnum' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
            if len(value) < 1:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd minLength restriction on IdentifierUseEnum' % {"value" : value, "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_IdentifierUseEnum_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_IdentifierUseEnum_patterns_, ))
    validate_IdentifierUseEnum_patterns_ = [['^([^\\s]+(\\s[^\\s]+)*)$']]
    def has__content(self):
        if (
            super(IdentifierUse, self).has__content()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='IdentifierUse', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('IdentifierUse')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'IdentifierUse':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='IdentifierUse')
        if self.has__content():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='IdentifierUse', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='IdentifierUse'):
        super(IdentifierUse, self)._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='IdentifierUse')
        if self.value is not None and 'value' not in already_processed:
            already_processed.add('value')
            outfile.write(' value=%s' % (quote_attrib(self.value), ))
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='IdentifierUse', fromsubclass_=False, pretty_print=True):
        super(IdentifierUse, self)._exportChildren(outfile, level, namespaceprefix_, namespacedef_, name_, True, pretty_print=pretty_print)
    def exportJson(self, parent_dict=None, key=None, is_list=False):
        json_dict = dict()
        self.exportJsonAttributes(json_dict)
        self.exportJsonChildren(json_dict)
        return self.exportJsonResult(json_dict, parent_dict, key, is_list)
    def exportJsonResult(self, json_dict, parent_dict, key, is_list, sub_defs=[], attr_defs=['value']):
        return super().exportJsonResult(json_dict, parent_dict, key, is_list, attr_defs)
    def exportJsonAttributes(self, json_dict):
        super().exportJsonAttributes(json_dict)
        if self.value is not None:
            json_dict['value'] = self.value
    def exportJsonChildren(self, json_dict):
        super().exportJsonChildren(json_dict)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        if SaveNodeDict:
            node_dict[node] = self 
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('value', node)
        if value is not None and 'value' not in already_processed:
            already_processed.add('value')
            self.value = value
            self.value = ' '.join(self.value.split())
            self.validate_IdentifierUseEnum(self.value)    # validate type IdentifierUseEnum
        super(IdentifierUse, self)._buildAttributes(node, attrs, already_processed)
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        super(IdentifierUse, self)._buildChildren(child_, node, nodeName_, True)
        pass
# end class IdentifierUse


class RatioRange(Element):
    """lowNumerator -- The value of the low limit numerator.
    highNumerator -- The value of the high limit numerator.
    denominator -- The value of the denominator.
    
    """
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = Element
    def __init__(self, id: 'string_primitive' = None, extension: List_['Extension'] = None, lowNumerator: 'Quantity' = None, highNumerator: 'Quantity' = None, denominator: 'Quantity' = None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        super(globals().get("RatioRange"), self).__init__(id, extension,  **kwargs_)
        self.lowNumerator = lowNumerator
        self.lowNumerator_nsprefix_ = None
        self.highNumerator = highNumerator
        self.highNumerator_nsprefix_ = None
        self.denominator = denominator
        self.denominator_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, RatioRange)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if RatioRange.subclass:
            return RatioRange.subclass(*args_, **kwargs_)
        else:
            return RatioRange(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_lowNumerator(self):
        return self.lowNumerator
    def set_lowNumerator(self, lowNumerator):
        self.lowNumerator = lowNumerator
    def get_highNumerator(self):
        return self.highNumerator
    def set_highNumerator(self, highNumerator):
        self.highNumerator = highNumerator
    def get_denominator(self):
        return self.denominator
    def set_denominator(self, denominator):
        self.denominator = denominator
    def has__content(self):
        if (
            self.lowNumerator is not None or
            self.highNumerator is not None or
            self.denominator is not None or
            super(RatioRange, self).has__content()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_=' xmlns:None="http://hl7.org/fhir" ', name_='RatioRange', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('RatioRange')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'RatioRange':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='RatioRange')
        if self.has__content():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='RatioRange', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='RatioRange'):
        super(RatioRange, self)._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='RatioRange')
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_=' xmlns:None="http://hl7.org/fhir" ', name_='RatioRange', fromsubclass_=False, pretty_print=True):
        super(RatioRange, self)._exportChildren(outfile, level, namespaceprefix_, namespacedef_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.lowNumerator is not None:
            namespaceprefix_ = self.lowNumerator_nsprefix_ + ':' if (UseCapturedNS_ and self.lowNumerator_nsprefix_) else ''
            self.lowNumerator.export(outfile, level, namespaceprefix_, namespacedef_='', name_='lowNumerator', pretty_print=pretty_print)
        if self.highNumerator is not None:
            namespaceprefix_ = self.highNumerator_nsprefix_ + ':' if (UseCapturedNS_ and self.highNumerator_nsprefix_) else ''
            self.highNumerator.export(outfile, level, namespaceprefix_, namespacedef_='', name_='highNumerator', pretty_print=pretty_print)
        if self.denominator is not None:
            namespaceprefix_ = self.denominator_nsprefix_ + ':' if (UseCapturedNS_ and self.denominator_nsprefix_) else ''
            self.denominator.export(outfile, level, namespaceprefix_, namespacedef_='', name_='denominator', pretty_print=pretty_print)
    def exportJson(self, parent_dict=None, key=None, is_list=False):
        json_dict = dict()
        self.exportJsonAttributes(json_dict)
        self.exportJsonChildren(json_dict)
        return self.exportJsonResult(json_dict, parent_dict, key, is_list)
    def exportJsonResult(self, json_dict, parent_dict, key, is_list, sub_defs=[], attr_defs=[]):
        return super().exportJsonResult(json_dict, parent_dict, key, is_list, attr_defs)
    def exportJsonAttributes(self, json_dict):
        super().exportJsonAttributes(json_dict)
    def exportJsonChildren(self, json_dict):
        super().exportJsonChildren(json_dict)
        if self.lowNumerator is not None:
            child_dict = self.lowNumerator.exportJson(json_dict, 'lowNumerator', False)
            if child_dict:
                json_dict['lowNumerator'] = child_dict
        if self.highNumerator is not None:
            child_dict = self.highNumerator.exportJson(json_dict, 'highNumerator', False)
            if child_dict:
                json_dict['highNumerator'] = child_dict
        if self.denominator is not None:
            child_dict = self.denominator.exportJson(json_dict, 'denominator', False)
            if child_dict:
                json_dict['denominator'] = child_dict
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        if SaveNodeDict:
            node_dict[node] = self 
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        super(RatioRange, self)._buildAttributes(node, attrs, already_processed)
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'lowNumerator':
            class_obj_ = self.get_class_obj_(child_, Quantity)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.lowNumerator = obj_
            obj_.original_tagname_ = 'lowNumerator'
        elif nodeName_ == 'highNumerator':
            class_obj_ = self.get_class_obj_(child_, Quantity)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.highNumerator = obj_
            obj_.original_tagname_ = 'highNumerator'
        elif nodeName_ == 'denominator':
            class_obj_ = self.get_class_obj_(child_, Quantity)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.denominator = obj_
            obj_.original_tagname_ = 'denominator'
        super(RatioRange, self)._buildChildren(child_, node, nodeName_, True)
# end class RatioRange


class Coding(Element):
    """system -- The identification of the code system that defines the meaning of the symbol in the code.
    version -- The version of the code system which was used when choosing this code. Note that a well-maintained code system does not need the version reported, because the meaning of codes is consistent across versions. However this cannot consistently be assured, and when the meaning is not guaranteed to be consistent, the version SHOULD be exchanged.
    code -- A symbol in syntax defined by the system. The symbol may be a predefined code or an expression in a syntax defined by the coding system (e.g. post-coordination).
    display -- A representation of the meaning of the code in the system, following the rules of the system.
    userSelected -- Indicates that this coding was chosen by a user directly - e.g. off a pick list of available items (codes or displays).
    
    """
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = Element
    def __init__(self, id: 'string_primitive' = None, extension: List_['Extension'] = None, system: 'uri' = None, version: 'string' = None, code: 'code' = None, display: 'string' = None, userSelected: 'boolean' = None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        super(globals().get("Coding"), self).__init__(id, extension,  **kwargs_)
        self.system = system
        self.system_nsprefix_ = None
        self.version = version
        self.version_nsprefix_ = None
        self.code = code
        self.code_nsprefix_ = None
        self.display = display
        self.display_nsprefix_ = None
        self.userSelected = userSelected
        self.userSelected_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, Coding)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if Coding.subclass:
            return Coding.subclass(*args_, **kwargs_)
        else:
            return Coding(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_system(self):
        return self.system
    def set_system(self, system):
        self.system = system
    def get_version(self):
        return self.version
    def set_version(self, version):
        self.version = version
    def get_code(self):
        return self.code
    def set_code(self, code):
        self.code = code
    def get_display(self):
        return self.display
    def set_display(self, display):
        self.display = display
    def get_userSelected(self):
        return self.userSelected
    def set_userSelected(self, userSelected):
        self.userSelected = userSelected
    def has__content(self):
        if (
            self.system is not None or
            self.version is not None or
            self.code is not None or
            self.display is not None or
            self.userSelected is not None or
            super(Coding, self).has__content()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_=' xmlns:None="http://hl7.org/fhir" ', name_='Coding', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('Coding')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'Coding':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='Coding')
        if self.has__content():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='Coding', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='Coding'):
        super(Coding, self)._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='Coding')
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_=' xmlns:None="http://hl7.org/fhir" ', name_='Coding', fromsubclass_=False, pretty_print=True):
        super(Coding, self)._exportChildren(outfile, level, namespaceprefix_, namespacedef_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.system is not None:
            namespaceprefix_ = self.system_nsprefix_ + ':' if (UseCapturedNS_ and self.system_nsprefix_) else ''
            self.system.export(outfile, level, namespaceprefix_, namespacedef_='', name_='system', pretty_print=pretty_print)
        if self.version is not None:
            namespaceprefix_ = self.version_nsprefix_ + ':' if (UseCapturedNS_ and self.version_nsprefix_) else ''
            self.version.export(outfile, level, namespaceprefix_, namespacedef_='', name_='version', pretty_print=pretty_print)
        if self.code is not None:
            namespaceprefix_ = self.code_nsprefix_ + ':' if (UseCapturedNS_ and self.code_nsprefix_) else ''
            self.code.export(outfile, level, namespaceprefix_, namespacedef_='', name_='code', pretty_print=pretty_print)
        if self.display is not None:
            namespaceprefix_ = self.display_nsprefix_ + ':' if (UseCapturedNS_ and self.display_nsprefix_) else ''
            self.display.export(outfile, level, namespaceprefix_, namespacedef_='', name_='display', pretty_print=pretty_print)
        if self.userSelected is not None:
            namespaceprefix_ = self.userSelected_nsprefix_ + ':' if (UseCapturedNS_ and self.userSelected_nsprefix_) else ''
            self.userSelected.export(outfile, level, namespaceprefix_, namespacedef_='', name_='userSelected', pretty_print=pretty_print)
    def exportJson(self, parent_dict=None, key=None, is_list=False):
        json_dict = dict()
        self.exportJsonAttributes(json_dict)
        self.exportJsonChildren(json_dict)
        return self.exportJsonResult(json_dict, parent_dict, key, is_list)
    def exportJsonResult(self, json_dict, parent_dict, key, is_list, sub_defs=[], attr_defs=[]):
        return super().exportJsonResult(json_dict, parent_dict, key, is_list, attr_defs)
    def exportJsonAttributes(self, json_dict):
        super().exportJsonAttributes(json_dict)
    def exportJsonChildren(self, json_dict):
        super().exportJsonChildren(json_dict)
        if self.system is not None:
            child_dict = self.system.exportJson(json_dict, 'system', False)
            if child_dict:
                json_dict['system'] = child_dict
        if self.version is not None:
            child_dict = self.version.exportJson(json_dict, 'version', False)
            if child_dict:
                json_dict['version'] = child_dict
        if self.code is not None:
            child_dict = self.code.exportJson(json_dict, 'code', False)
            if child_dict:
                json_dict['code'] = child_dict
        if self.display is not None:
            child_dict = self.display.exportJson(json_dict, 'display', False)
            if child_dict:
                json_dict['display'] = child_dict
        if self.userSelected is not None:
            child_dict = self.userSelected.exportJson(json_dict, 'userSelected', False)
            if child_dict:
                json_dict['userSelected'] = child_dict
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        if SaveNodeDict:
            node_dict[node] = self 
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        super(Coding, self)._buildAttributes(node, attrs, already_processed)
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'system':
            obj_ = uri.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.system = obj_
            obj_.original_tagname_ = 'system'
        elif nodeName_ == 'version':
            obj_ = string.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.version = obj_
            obj_.original_tagname_ = 'version'
        elif nodeName_ == 'code':
            obj_ = code.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.code = obj_
            obj_.original_tagname_ = 'code'
        elif nodeName_ == 'display':
            obj_ = string.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.display = obj_
            obj_.original_tagname_ = 'display'
        elif nodeName_ == 'userSelected':
            obj_ = boolean.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.userSelected = obj_
            obj_.original_tagname_ = 'userSelected'
        super(Coding, self)._buildChildren(child_, node, nodeName_, True)
# end class Coding


class SampledData(Element):
    """origin -- The base quantity that a measured value of zero represents. In addition, this provides the units of the entire measurement series.
    period -- The length of time between sampling times, measured in milliseconds.
    factor -- A correction factor that is applied to the sampled data points before they are added to the origin.
    lowerLimit -- The lower limit of detection of the measured points. This is needed if any of the data points have the value "L" (lower than detection limit).
    upperLimit -- The upper limit of detection of the measured points. This is needed if any of the data points have the value "U" (higher than detection limit).
    dimensions -- The number of sample points at each time point. If this value is greater than one, then the dimensions will be interlaced - all the sample points for a point in time will be recorded at once.
    data -- A series of data points which are decimal values separated by a single space (character u20). The special values "E" (error), "L" (below detection limit) and "U" (above detection limit) can also be used in place of a decimal value.
    
    """
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = Element
    def __init__(self, id: 'string_primitive' = None, extension: List_['Extension'] = None, origin: 'Quantity' = None, period: 'decimal' = None, factor: 'decimal' = None, lowerLimit: 'decimal' = None, upperLimit: 'decimal' = None, dimensions: 'positiveInt' = None, data: 'SampledDataDataType' = None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        super(globals().get("SampledData"), self).__init__(id, extension,  **kwargs_)
        self.origin = origin
        self.origin_nsprefix_ = None
        self.period = period
        self.period_nsprefix_ = None
        self.factor = factor
        self.factor_nsprefix_ = None
        self.lowerLimit = lowerLimit
        self.lowerLimit_nsprefix_ = None
        self.upperLimit = upperLimit
        self.upperLimit_nsprefix_ = None
        self.dimensions = dimensions
        self.dimensions_nsprefix_ = None
        self.data = data
        self.data_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, SampledData)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if SampledData.subclass:
            return SampledData.subclass(*args_, **kwargs_)
        else:
            return SampledData(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_origin(self):
        return self.origin
    def set_origin(self, origin):
        self.origin = origin
    def get_period(self):
        return self.period
    def set_period(self, period):
        self.period = period
    def get_factor(self):
        return self.factor
    def set_factor(self, factor):
        self.factor = factor
    def get_lowerLimit(self):
        return self.lowerLimit
    def set_lowerLimit(self, lowerLimit):
        self.lowerLimit = lowerLimit
    def get_upperLimit(self):
        return self.upperLimit
    def set_upperLimit(self, upperLimit):
        self.upperLimit = upperLimit
    def get_dimensions(self):
        return self.dimensions
    def set_dimensions(self, dimensions):
        self.dimensions = dimensions
    def get_data(self):
        return self.data
    def set_data(self, data):
        self.data = data
    def has__content(self):
        if (
            self.origin is not None or
            self.period is not None or
            self.factor is not None or
            self.lowerLimit is not None or
            self.upperLimit is not None or
            self.dimensions is not None or
            self.data is not None or
            super(SampledData, self).has__content()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_=' xmlns:None="http://hl7.org/fhir" ', name_='SampledData', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('SampledData')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'SampledData':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='SampledData')
        if self.has__content():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='SampledData', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='SampledData'):
        super(SampledData, self)._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='SampledData')
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_=' xmlns:None="http://hl7.org/fhir" ', name_='SampledData', fromsubclass_=False, pretty_print=True):
        super(SampledData, self)._exportChildren(outfile, level, namespaceprefix_, namespacedef_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.origin is not None:
            namespaceprefix_ = self.origin_nsprefix_ + ':' if (UseCapturedNS_ and self.origin_nsprefix_) else ''
            self.origin.export(outfile, level, namespaceprefix_, namespacedef_='', name_='origin', pretty_print=pretty_print)
        if self.period is not None:
            namespaceprefix_ = self.period_nsprefix_ + ':' if (UseCapturedNS_ and self.period_nsprefix_) else ''
            self.period.export(outfile, level, namespaceprefix_, namespacedef_='', name_='period', pretty_print=pretty_print)
        if self.factor is not None:
            namespaceprefix_ = self.factor_nsprefix_ + ':' if (UseCapturedNS_ and self.factor_nsprefix_) else ''
            self.factor.export(outfile, level, namespaceprefix_, namespacedef_='', name_='factor', pretty_print=pretty_print)
        if self.lowerLimit is not None:
            namespaceprefix_ = self.lowerLimit_nsprefix_ + ':' if (UseCapturedNS_ and self.lowerLimit_nsprefix_) else ''
            self.lowerLimit.export(outfile, level, namespaceprefix_, namespacedef_='', name_='lowerLimit', pretty_print=pretty_print)
        if self.upperLimit is not None:
            namespaceprefix_ = self.upperLimit_nsprefix_ + ':' if (UseCapturedNS_ and self.upperLimit_nsprefix_) else ''
            self.upperLimit.export(outfile, level, namespaceprefix_, namespacedef_='', name_='upperLimit', pretty_print=pretty_print)
        if self.dimensions is not None:
            namespaceprefix_ = self.dimensions_nsprefix_ + ':' if (UseCapturedNS_ and self.dimensions_nsprefix_) else ''
            self.dimensions.export(outfile, level, namespaceprefix_, namespacedef_='', name_='dimensions', pretty_print=pretty_print)
        if self.data is not None:
            namespaceprefix_ = self.data_nsprefix_ + ':' if (UseCapturedNS_ and self.data_nsprefix_) else ''
            self.data.export(outfile, level, namespaceprefix_, namespacedef_='', name_='data', pretty_print=pretty_print)
    def exportJson(self, parent_dict=None, key=None, is_list=False):
        json_dict = dict()
        self.exportJsonAttributes(json_dict)
        self.exportJsonChildren(json_dict)
        return self.exportJsonResult(json_dict, parent_dict, key, is_list)
    def exportJsonResult(self, json_dict, parent_dict, key, is_list, sub_defs=[], attr_defs=[]):
        return super().exportJsonResult(json_dict, parent_dict, key, is_list, attr_defs)
    def exportJsonAttributes(self, json_dict):
        super().exportJsonAttributes(json_dict)
    def exportJsonChildren(self, json_dict):
        super().exportJsonChildren(json_dict)
        if self.origin is not None:
            child_dict = self.origin.exportJson(json_dict, 'origin', False)
            if child_dict:
                json_dict['origin'] = child_dict
        if self.period is not None:
            child_dict = self.period.exportJson(json_dict, 'period', False)
            if child_dict:
                json_dict['period'] = child_dict
        if self.factor is not None:
            child_dict = self.factor.exportJson(json_dict, 'factor', False)
            if child_dict:
                json_dict['factor'] = child_dict
        if self.lowerLimit is not None:
            child_dict = self.lowerLimit.exportJson(json_dict, 'lowerLimit', False)
            if child_dict:
                json_dict['lowerLimit'] = child_dict
        if self.upperLimit is not None:
            child_dict = self.upperLimit.exportJson(json_dict, 'upperLimit', False)
            if child_dict:
                json_dict['upperLimit'] = child_dict
        if self.dimensions is not None:
            child_dict = self.dimensions.exportJson(json_dict, 'dimensions', False)
            if child_dict:
                json_dict['dimensions'] = child_dict
        if self.data is not None:
            child_dict = self.data.exportJson(json_dict, 'data', False)
            if child_dict:
                json_dict['data'] = child_dict
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        if SaveNodeDict:
            node_dict[node] = self 
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        super(SampledData, self)._buildAttributes(node, attrs, already_processed)
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'origin':
            class_obj_ = self.get_class_obj_(child_, Quantity)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.origin = obj_
            obj_.original_tagname_ = 'origin'
        elif nodeName_ == 'period':
            obj_ = decimal.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.period = obj_
            obj_.original_tagname_ = 'period'
        elif nodeName_ == 'factor':
            obj_ = decimal.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.factor = obj_
            obj_.original_tagname_ = 'factor'
        elif nodeName_ == 'lowerLimit':
            obj_ = decimal.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.lowerLimit = obj_
            obj_.original_tagname_ = 'lowerLimit'
        elif nodeName_ == 'upperLimit':
            obj_ = decimal.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.upperLimit = obj_
            obj_.original_tagname_ = 'upperLimit'
        elif nodeName_ == 'dimensions':
            obj_ = positiveInt.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.dimensions = obj_
            obj_.original_tagname_ = 'dimensions'
        elif nodeName_ == 'data':
            obj_ = SampledDataDataType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.data = obj_
            obj_.original_tagname_ = 'data'
        super(SampledData, self)._buildChildren(child_, node, nodeName_, True)
# end class SampledData


class SampledDataDataType(Element):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = Element
    def __init__(self, id: 'string_primitive' = None, extension: List_['Extension'] = None, value: 'SampledDataDataType_primitive' = None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        super(globals().get("SampledDataDataType"), self).__init__(id, extension,  **kwargs_)
        self.value = _cast(None, value)
        self.value_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, SampledDataDataType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if SampledDataDataType.subclass:
            return SampledDataDataType.subclass(*args_, **kwargs_)
        else:
            return SampledDataDataType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_value(self):
        return self.value
    def set_value(self, value):
        self.value = value
    def validate_SampledDataDataType_primitive(self, value):
        # Validate type SampledDataDataType-primitive, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if not self.gds_validate_simple_patterns(
                    self.validate_SampledDataDataType_primitive_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_SampledDataDataType_primitive_patterns_, ))
    validate_SampledDataDataType_primitive_patterns_ = [['^(((-{0,1}\\d*\\.{0,1}\\d+)|[EUL])( ((-{0,1}\\d*\\.{0,1}\\d+)|[EUL]))*)$']]
    def has__content(self):
        if (
            super(SampledDataDataType, self).has__content()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='SampledDataDataType', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('SampledDataDataType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'SampledDataDataType':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='SampledDataDataType')
        if self.has__content():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='SampledDataDataType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='SampledDataDataType'):
        super(SampledDataDataType, self)._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='SampledDataDataType')
        if self.value is not None and 'value' not in already_processed:
            already_processed.add('value')
            outfile.write(' value=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.value), input_name='value')), ))
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='SampledDataDataType', fromsubclass_=False, pretty_print=True):
        super(SampledDataDataType, self)._exportChildren(outfile, level, namespaceprefix_, namespacedef_, name_, True, pretty_print=pretty_print)
    def exportJson(self, parent_dict=None, key=None, is_list=False):
        json_dict = dict()
        self.exportJsonAttributes(json_dict)
        self.exportJsonChildren(json_dict)
        return self.exportJsonResult(json_dict, parent_dict, key, is_list)
    def exportJsonResult(self, json_dict, parent_dict, key, is_list, sub_defs=[], attr_defs=['value']):
        return super().exportJsonResult(json_dict, parent_dict, key, is_list, attr_defs)
    def exportJsonAttributes(self, json_dict):
        super().exportJsonAttributes(json_dict)
        if self.value is not None:
            json_dict['value'] = self.value
    def exportJsonChildren(self, json_dict):
        super().exportJsonChildren(json_dict)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        if SaveNodeDict:
            node_dict[node] = self 
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('value', node)
        if value is not None and 'value' not in already_processed:
            already_processed.add('value')
            self.value = value
            self.validate_SampledDataDataType_primitive(self.value)    # validate type SampledDataDataType-primitive
        super(SampledDataDataType, self)._buildAttributes(node, attrs, already_processed)
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        super(SampledDataDataType, self)._buildChildren(child_, node, nodeName_, True)
        pass
# end class SampledDataDataType


class Ratio(Element):
    """numerator -- The value of the numerator.
    denominator -- The value of the denominator.
    
    """
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = Element
    def __init__(self, id: 'string_primitive' = None, extension: List_['Extension'] = None, numerator: 'Quantity' = None, denominator: 'Quantity' = None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        super(globals().get("Ratio"), self).__init__(id, extension,  **kwargs_)
        self.numerator = numerator
        self.numerator_nsprefix_ = None
        self.denominator = denominator
        self.denominator_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, Ratio)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if Ratio.subclass:
            return Ratio.subclass(*args_, **kwargs_)
        else:
            return Ratio(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_numerator(self):
        return self.numerator
    def set_numerator(self, numerator):
        self.numerator = numerator
    def get_denominator(self):
        return self.denominator
    def set_denominator(self, denominator):
        self.denominator = denominator
    def has__content(self):
        if (
            self.numerator is not None or
            self.denominator is not None or
            super(Ratio, self).has__content()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_=' xmlns:None="http://hl7.org/fhir" ', name_='Ratio', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('Ratio')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'Ratio':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='Ratio')
        if self.has__content():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='Ratio', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='Ratio'):
        super(Ratio, self)._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='Ratio')
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_=' xmlns:None="http://hl7.org/fhir" ', name_='Ratio', fromsubclass_=False, pretty_print=True):
        super(Ratio, self)._exportChildren(outfile, level, namespaceprefix_, namespacedef_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.numerator is not None:
            namespaceprefix_ = self.numerator_nsprefix_ + ':' if (UseCapturedNS_ and self.numerator_nsprefix_) else ''
            self.numerator.export(outfile, level, namespaceprefix_, namespacedef_='', name_='numerator', pretty_print=pretty_print)
        if self.denominator is not None:
            namespaceprefix_ = self.denominator_nsprefix_ + ':' if (UseCapturedNS_ and self.denominator_nsprefix_) else ''
            self.denominator.export(outfile, level, namespaceprefix_, namespacedef_='', name_='denominator', pretty_print=pretty_print)
    def exportJson(self, parent_dict=None, key=None, is_list=False):
        json_dict = dict()
        self.exportJsonAttributes(json_dict)
        self.exportJsonChildren(json_dict)
        return self.exportJsonResult(json_dict, parent_dict, key, is_list)
    def exportJsonResult(self, json_dict, parent_dict, key, is_list, sub_defs=[], attr_defs=[]):
        return super().exportJsonResult(json_dict, parent_dict, key, is_list, attr_defs)
    def exportJsonAttributes(self, json_dict):
        super().exportJsonAttributes(json_dict)
    def exportJsonChildren(self, json_dict):
        super().exportJsonChildren(json_dict)
        if self.numerator is not None:
            child_dict = self.numerator.exportJson(json_dict, 'numerator', False)
            if child_dict:
                json_dict['numerator'] = child_dict
        if self.denominator is not None:
            child_dict = self.denominator.exportJson(json_dict, 'denominator', False)
            if child_dict:
                json_dict['denominator'] = child_dict
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        if SaveNodeDict:
            node_dict[node] = self 
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        super(Ratio, self)._buildAttributes(node, attrs, already_processed)
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'numerator':
            class_obj_ = self.get_class_obj_(child_, Quantity)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.numerator = obj_
            obj_.original_tagname_ = 'numerator'
        elif nodeName_ == 'denominator':
            class_obj_ = self.get_class_obj_(child_, Quantity)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.denominator = obj_
            obj_.original_tagname_ = 'denominator'
        super(Ratio, self)._buildChildren(child_, node, nodeName_, True)
# end class Ratio


class PropertyRepresentation(Element):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = Element
    def __init__(self, id: 'string_primitive' = None, extension: List_['Extension'] = None, value: 'PropertyRepresentationEnum' = None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        super(globals().get("PropertyRepresentation"), self).__init__(id, extension,  **kwargs_)
        self.value = _cast(None, value)
        self.value_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, PropertyRepresentation)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if PropertyRepresentation.subclass:
            return PropertyRepresentation.subclass(*args_, **kwargs_)
        else:
            return PropertyRepresentation(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_value(self):
        return self.value
    def set_value(self, value):
        self.value = value
    def validate_PropertyRepresentationEnum(self, value):
        # Validate type PropertyRepresentationEnum, a restriction on code-primitive.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['xmlAttr', 'xmlText', 'typeAttr', 'cdaText', 'xhtml']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on PropertyRepresentationEnum' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
            if len(value) < 1:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd minLength restriction on PropertyRepresentationEnum' % {"value" : value, "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_PropertyRepresentationEnum_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_PropertyRepresentationEnum_patterns_, ))
    validate_PropertyRepresentationEnum_patterns_ = [['^([^\\s]+(\\s[^\\s]+)*)$']]
    def has__content(self):
        if (
            super(PropertyRepresentation, self).has__content()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='PropertyRepresentation', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('PropertyRepresentation')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'PropertyRepresentation':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='PropertyRepresentation')
        if self.has__content():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='PropertyRepresentation', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='PropertyRepresentation'):
        super(PropertyRepresentation, self)._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='PropertyRepresentation')
        if self.value is not None and 'value' not in already_processed:
            already_processed.add('value')
            outfile.write(' value=%s' % (quote_attrib(self.value), ))
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='PropertyRepresentation', fromsubclass_=False, pretty_print=True):
        super(PropertyRepresentation, self)._exportChildren(outfile, level, namespaceprefix_, namespacedef_, name_, True, pretty_print=pretty_print)
    def exportJson(self, parent_dict=None, key=None, is_list=False):
        json_dict = dict()
        self.exportJsonAttributes(json_dict)
        self.exportJsonChildren(json_dict)
        return self.exportJsonResult(json_dict, parent_dict, key, is_list)
    def exportJsonResult(self, json_dict, parent_dict, key, is_list, sub_defs=[], attr_defs=['value']):
        return super().exportJsonResult(json_dict, parent_dict, key, is_list, attr_defs)
    def exportJsonAttributes(self, json_dict):
        super().exportJsonAttributes(json_dict)
        if self.value is not None:
            json_dict['value'] = self.value
    def exportJsonChildren(self, json_dict):
        super().exportJsonChildren(json_dict)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        if SaveNodeDict:
            node_dict[node] = self 
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('value', node)
        if value is not None and 'value' not in already_processed:
            already_processed.add('value')
            self.value = value
            self.value = ' '.join(self.value.split())
            self.validate_PropertyRepresentationEnum(self.value)    # validate type PropertyRepresentationEnum
        super(PropertyRepresentation, self)._buildAttributes(node, attrs, already_processed)
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        super(PropertyRepresentation, self)._buildChildren(child_, node, nodeName_, True)
        pass
# end class PropertyRepresentation


class ConstraintSeverity(Element):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = Element
    def __init__(self, id: 'string_primitive' = None, extension: List_['Extension'] = None, value: 'ConstraintSeverityEnum' = None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        super(globals().get("ConstraintSeverity"), self).__init__(id, extension,  **kwargs_)
        self.value = _cast(None, value)
        self.value_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ConstraintSeverity)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ConstraintSeverity.subclass:
            return ConstraintSeverity.subclass(*args_, **kwargs_)
        else:
            return ConstraintSeverity(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_value(self):
        return self.value
    def set_value(self, value):
        self.value = value
    def validate_ConstraintSeverityEnum(self, value):
        # Validate type ConstraintSeverityEnum, a restriction on code-primitive.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['error', 'warning']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on ConstraintSeverityEnum' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
            if len(value) < 1:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd minLength restriction on ConstraintSeverityEnum' % {"value" : value, "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_ConstraintSeverityEnum_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_ConstraintSeverityEnum_patterns_, ))
    validate_ConstraintSeverityEnum_patterns_ = [['^([^\\s]+(\\s[^\\s]+)*)$']]
    def has__content(self):
        if (
            super(ConstraintSeverity, self).has__content()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='ConstraintSeverity', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('ConstraintSeverity')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'ConstraintSeverity':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='ConstraintSeverity')
        if self.has__content():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='ConstraintSeverity', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='ConstraintSeverity'):
        super(ConstraintSeverity, self)._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='ConstraintSeverity')
        if self.value is not None and 'value' not in already_processed:
            already_processed.add('value')
            outfile.write(' value=%s' % (quote_attrib(self.value), ))
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='ConstraintSeverity', fromsubclass_=False, pretty_print=True):
        super(ConstraintSeverity, self)._exportChildren(outfile, level, namespaceprefix_, namespacedef_, name_, True, pretty_print=pretty_print)
    def exportJson(self, parent_dict=None, key=None, is_list=False):
        json_dict = dict()
        self.exportJsonAttributes(json_dict)
        self.exportJsonChildren(json_dict)
        return self.exportJsonResult(json_dict, parent_dict, key, is_list)
    def exportJsonResult(self, json_dict, parent_dict, key, is_list, sub_defs=[], attr_defs=['value']):
        return super().exportJsonResult(json_dict, parent_dict, key, is_list, attr_defs)
    def exportJsonAttributes(self, json_dict):
        super().exportJsonAttributes(json_dict)
        if self.value is not None:
            json_dict['value'] = self.value
    def exportJsonChildren(self, json_dict):
        super().exportJsonChildren(json_dict)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        if SaveNodeDict:
            node_dict[node] = self 
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('value', node)
        if value is not None and 'value' not in already_processed:
            already_processed.add('value')
            self.value = value
            self.value = ' '.join(self.value.split())
            self.validate_ConstraintSeverityEnum(self.value)    # validate type ConstraintSeverityEnum
        super(ConstraintSeverity, self)._buildAttributes(node, attrs, already_processed)
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        super(ConstraintSeverity, self)._buildChildren(child_, node, nodeName_, True)
        pass
# end class ConstraintSeverity


class AggregationMode(Element):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = Element
    def __init__(self, id: 'string_primitive' = None, extension: List_['Extension'] = None, value: 'AggregationModeEnum' = None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        super(globals().get("AggregationMode"), self).__init__(id, extension,  **kwargs_)
        self.value = _cast(None, value)
        self.value_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, AggregationMode)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if AggregationMode.subclass:
            return AggregationMode.subclass(*args_, **kwargs_)
        else:
            return AggregationMode(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_value(self):
        return self.value
    def set_value(self, value):
        self.value = value
    def validate_AggregationModeEnum(self, value):
        # Validate type AggregationModeEnum, a restriction on code-primitive.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['contained', 'referenced', 'bundled']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on AggregationModeEnum' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
            if len(value) < 1:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd minLength restriction on AggregationModeEnum' % {"value" : value, "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_AggregationModeEnum_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_AggregationModeEnum_patterns_, ))
    validate_AggregationModeEnum_patterns_ = [['^([^\\s]+(\\s[^\\s]+)*)$']]
    def has__content(self):
        if (
            super(AggregationMode, self).has__content()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='AggregationMode', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('AggregationMode')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'AggregationMode':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='AggregationMode')
        if self.has__content():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='AggregationMode', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='AggregationMode'):
        super(AggregationMode, self)._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='AggregationMode')
        if self.value is not None and 'value' not in already_processed:
            already_processed.add('value')
            outfile.write(' value=%s' % (quote_attrib(self.value), ))
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='AggregationMode', fromsubclass_=False, pretty_print=True):
        super(AggregationMode, self)._exportChildren(outfile, level, namespaceprefix_, namespacedef_, name_, True, pretty_print=pretty_print)
    def exportJson(self, parent_dict=None, key=None, is_list=False):
        json_dict = dict()
        self.exportJsonAttributes(json_dict)
        self.exportJsonChildren(json_dict)
        return self.exportJsonResult(json_dict, parent_dict, key, is_list)
    def exportJsonResult(self, json_dict, parent_dict, key, is_list, sub_defs=[], attr_defs=['value']):
        return super().exportJsonResult(json_dict, parent_dict, key, is_list, attr_defs)
    def exportJsonAttributes(self, json_dict):
        super().exportJsonAttributes(json_dict)
        if self.value is not None:
            json_dict['value'] = self.value
    def exportJsonChildren(self, json_dict):
        super().exportJsonChildren(json_dict)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        if SaveNodeDict:
            node_dict[node] = self 
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('value', node)
        if value is not None and 'value' not in already_processed:
            already_processed.add('value')
            self.value = value
            self.value = ' '.join(self.value.split())
            self.validate_AggregationModeEnum(self.value)    # validate type AggregationModeEnum
        super(AggregationMode, self)._buildAttributes(node, attrs, already_processed)
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        super(AggregationMode, self)._buildChildren(child_, node, nodeName_, True)
        pass
# end class AggregationMode


class ReferenceVersionRules(Element):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = Element
    def __init__(self, id: 'string_primitive' = None, extension: List_['Extension'] = None, value: 'ReferenceVersionRulesEnum' = None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        super(globals().get("ReferenceVersionRules"), self).__init__(id, extension,  **kwargs_)
        self.value = _cast(None, value)
        self.value_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ReferenceVersionRules)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ReferenceVersionRules.subclass:
            return ReferenceVersionRules.subclass(*args_, **kwargs_)
        else:
            return ReferenceVersionRules(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_value(self):
        return self.value
    def set_value(self, value):
        self.value = value
    def validate_ReferenceVersionRulesEnum(self, value):
        # Validate type ReferenceVersionRulesEnum, a restriction on code-primitive.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['either', 'independent', 'specific']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on ReferenceVersionRulesEnum' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
            if len(value) < 1:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd minLength restriction on ReferenceVersionRulesEnum' % {"value" : value, "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_ReferenceVersionRulesEnum_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_ReferenceVersionRulesEnum_patterns_, ))
    validate_ReferenceVersionRulesEnum_patterns_ = [['^([^\\s]+(\\s[^\\s]+)*)$']]
    def has__content(self):
        if (
            super(ReferenceVersionRules, self).has__content()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='ReferenceVersionRules', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('ReferenceVersionRules')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'ReferenceVersionRules':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='ReferenceVersionRules')
        if self.has__content():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='ReferenceVersionRules', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='ReferenceVersionRules'):
        super(ReferenceVersionRules, self)._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='ReferenceVersionRules')
        if self.value is not None and 'value' not in already_processed:
            already_processed.add('value')
            outfile.write(' value=%s' % (quote_attrib(self.value), ))
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='ReferenceVersionRules', fromsubclass_=False, pretty_print=True):
        super(ReferenceVersionRules, self)._exportChildren(outfile, level, namespaceprefix_, namespacedef_, name_, True, pretty_print=pretty_print)
    def exportJson(self, parent_dict=None, key=None, is_list=False):
        json_dict = dict()
        self.exportJsonAttributes(json_dict)
        self.exportJsonChildren(json_dict)
        return self.exportJsonResult(json_dict, parent_dict, key, is_list)
    def exportJsonResult(self, json_dict, parent_dict, key, is_list, sub_defs=[], attr_defs=['value']):
        return super().exportJsonResult(json_dict, parent_dict, key, is_list, attr_defs)
    def exportJsonAttributes(self, json_dict):
        super().exportJsonAttributes(json_dict)
        if self.value is not None:
            json_dict['value'] = self.value
    def exportJsonChildren(self, json_dict):
        super().exportJsonChildren(json_dict)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        if SaveNodeDict:
            node_dict[node] = self 
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('value', node)
        if value is not None and 'value' not in already_processed:
            already_processed.add('value')
            self.value = value
            self.value = ' '.join(self.value.split())
            self.validate_ReferenceVersionRulesEnum(self.value)    # validate type ReferenceVersionRulesEnum
        super(ReferenceVersionRules, self)._buildAttributes(node, attrs, already_processed)
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        super(ReferenceVersionRules, self)._buildChildren(child_, node, nodeName_, True)
        pass
# end class ReferenceVersionRules


class SlicingRules(Element):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = Element
    def __init__(self, id: 'string_primitive' = None, extension: List_['Extension'] = None, value: 'SlicingRulesEnum' = None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        super(globals().get("SlicingRules"), self).__init__(id, extension,  **kwargs_)
        self.value = _cast(None, value)
        self.value_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, SlicingRules)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if SlicingRules.subclass:
            return SlicingRules.subclass(*args_, **kwargs_)
        else:
            return SlicingRules(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_value(self):
        return self.value
    def set_value(self, value):
        self.value = value
    def validate_SlicingRulesEnum(self, value):
        # Validate type SlicingRulesEnum, a restriction on code-primitive.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['closed', 'open', 'openAtEnd']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on SlicingRulesEnum' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
            if len(value) < 1:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd minLength restriction on SlicingRulesEnum' % {"value" : value, "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_SlicingRulesEnum_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_SlicingRulesEnum_patterns_, ))
    validate_SlicingRulesEnum_patterns_ = [['^([^\\s]+(\\s[^\\s]+)*)$']]
    def has__content(self):
        if (
            super(SlicingRules, self).has__content()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='SlicingRules', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('SlicingRules')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'SlicingRules':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='SlicingRules')
        if self.has__content():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='SlicingRules', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='SlicingRules'):
        super(SlicingRules, self)._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='SlicingRules')
        if self.value is not None and 'value' not in already_processed:
            already_processed.add('value')
            outfile.write(' value=%s' % (quote_attrib(self.value), ))
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='SlicingRules', fromsubclass_=False, pretty_print=True):
        super(SlicingRules, self)._exportChildren(outfile, level, namespaceprefix_, namespacedef_, name_, True, pretty_print=pretty_print)
    def exportJson(self, parent_dict=None, key=None, is_list=False):
        json_dict = dict()
        self.exportJsonAttributes(json_dict)
        self.exportJsonChildren(json_dict)
        return self.exportJsonResult(json_dict, parent_dict, key, is_list)
    def exportJsonResult(self, json_dict, parent_dict, key, is_list, sub_defs=[], attr_defs=['value']):
        return super().exportJsonResult(json_dict, parent_dict, key, is_list, attr_defs)
    def exportJsonAttributes(self, json_dict):
        super().exportJsonAttributes(json_dict)
        if self.value is not None:
            json_dict['value'] = self.value
    def exportJsonChildren(self, json_dict):
        super().exportJsonChildren(json_dict)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        if SaveNodeDict:
            node_dict[node] = self 
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('value', node)
        if value is not None and 'value' not in already_processed:
            already_processed.add('value')
            self.value = value
            self.value = ' '.join(self.value.split())
            self.validate_SlicingRulesEnum(self.value)    # validate type SlicingRulesEnum
        super(SlicingRules, self)._buildAttributes(node, attrs, already_processed)
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        super(SlicingRules, self)._buildChildren(child_, node, nodeName_, True)
        pass
# end class SlicingRules


class DiscriminatorType(Element):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = Element
    def __init__(self, id: 'string_primitive' = None, extension: List_['Extension'] = None, value: 'DiscriminatorTypeEnum' = None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        super(globals().get("DiscriminatorType"), self).__init__(id, extension,  **kwargs_)
        self.value = _cast(None, value)
        self.value_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, DiscriminatorType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if DiscriminatorType.subclass:
            return DiscriminatorType.subclass(*args_, **kwargs_)
        else:
            return DiscriminatorType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_value(self):
        return self.value
    def set_value(self, value):
        self.value = value
    def validate_DiscriminatorTypeEnum(self, value):
        # Validate type DiscriminatorTypeEnum, a restriction on code-primitive.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['value', 'exists', 'pattern', 'type', 'profile']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on DiscriminatorTypeEnum' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
            if len(value) < 1:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd minLength restriction on DiscriminatorTypeEnum' % {"value" : value, "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_DiscriminatorTypeEnum_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_DiscriminatorTypeEnum_patterns_, ))
    validate_DiscriminatorTypeEnum_patterns_ = [['^([^\\s]+(\\s[^\\s]+)*)$']]
    def has__content(self):
        if (
            super(DiscriminatorType, self).has__content()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='DiscriminatorType', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('DiscriminatorType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'DiscriminatorType':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='DiscriminatorType')
        if self.has__content():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='DiscriminatorType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='DiscriminatorType'):
        super(DiscriminatorType, self)._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='DiscriminatorType')
        if self.value is not None and 'value' not in already_processed:
            already_processed.add('value')
            outfile.write(' value=%s' % (quote_attrib(self.value), ))
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='DiscriminatorType', fromsubclass_=False, pretty_print=True):
        super(DiscriminatorType, self)._exportChildren(outfile, level, namespaceprefix_, namespacedef_, name_, True, pretty_print=pretty_print)
    def exportJson(self, parent_dict=None, key=None, is_list=False):
        json_dict = dict()
        self.exportJsonAttributes(json_dict)
        self.exportJsonChildren(json_dict)
        return self.exportJsonResult(json_dict, parent_dict, key, is_list)
    def exportJsonResult(self, json_dict, parent_dict, key, is_list, sub_defs=[], attr_defs=['value']):
        return super().exportJsonResult(json_dict, parent_dict, key, is_list, attr_defs)
    def exportJsonAttributes(self, json_dict):
        super().exportJsonAttributes(json_dict)
        if self.value is not None:
            json_dict['value'] = self.value
    def exportJsonChildren(self, json_dict):
        super().exportJsonChildren(json_dict)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        if SaveNodeDict:
            node_dict[node] = self 
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('value', node)
        if value is not None and 'value' not in already_processed:
            already_processed.add('value')
            self.value = value
            self.value = ' '.join(self.value.split())
            self.validate_DiscriminatorTypeEnum(self.value)    # validate type DiscriminatorTypeEnum
        super(DiscriminatorType, self)._buildAttributes(node, attrs, already_processed)
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        super(DiscriminatorType, self)._buildChildren(child_, node, nodeName_, True)
        pass
# end class DiscriminatorType


class Reference(Element):
    """reference -- A reference to a location at which the other resource is found. The reference may be a relative reference, in which case it is relative to the service base URL, or an absolute URL that resolves to the location where the resource is found. The reference may be version specific or not. If the reference is not to a FHIR RESTful server, then it should be assumed to be version specific. Internal fragment references (start with '#') refer to contained resources.
    type -- The expected type of the target of the reference. If both Reference.type and Reference.reference are populated and Reference.reference is a FHIR URL, both SHALL be consistent.
    The type is the Canonical URL of Resource Definition that is the type this reference refers to. References are URLs that are relative to http://hl7.org/fhir/StructureDefinition/ e.g. "Patient" is a reference to http://hl7.org/fhir/StructureDefinition/Patient. Absolute URLs are only allowed for logical models (and can only be used in references in logical models, not resources).
    identifier -- An identifier for the target resource. This is used when there is no way to reference the other resource directly, either because the entity it represents is not available through a FHIR server, or because there is no way for the author of the resource to convert a known identifier to an actual location. There is no requirement that a Reference.identifier point to something that is actually exposed as a FHIR instance, but it SHALL point to a business concept that would be expected to be exposed as a FHIR instance, and that instance would need to be of a FHIR resource type allowed by the reference.
    display -- Plain text narrative that identifies the resource in addition to the resource reference.
    
    """
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = Element
    def __init__(self, id: 'string_primitive' = None, extension: List_['Extension'] = None, reference: 'string' = None, type_: 'uri' = None, identifier: 'Identifier' = None, display: 'string' = None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        super(globals().get("Reference"), self).__init__(id, extension,  **kwargs_)
        self.reference = reference
        self.reference_nsprefix_ = None
        self.type_ = type_
        self.type__nsprefix_ = None
        self.identifier = identifier
        self.identifier_nsprefix_ = None
        self.display = display
        self.display_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, Reference)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if Reference.subclass:
            return Reference.subclass(*args_, **kwargs_)
        else:
            return Reference(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_reference(self):
        return self.reference
    def set_reference(self, reference):
        self.reference = reference
    def get_type(self):
        return self.type_
    def set_type(self, type_):
        self.type_ = type_
    def get_identifier(self):
        return self.identifier
    def set_identifier(self, identifier):
        self.identifier = identifier
    def get_display(self):
        return self.display
    def set_display(self, display):
        self.display = display
    def has__content(self):
        if (
            self.reference is not None or
            self.type_ is not None or
            self.identifier is not None or
            self.display is not None or
            super(Reference, self).has__content()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_=' xmlns:None="http://hl7.org/fhir" ', name_='Reference', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('Reference')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'Reference':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='Reference')
        if self.has__content():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='Reference', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='Reference'):
        super(Reference, self)._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='Reference')
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_=' xmlns:None="http://hl7.org/fhir" ', name_='Reference', fromsubclass_=False, pretty_print=True):
        super(Reference, self)._exportChildren(outfile, level, namespaceprefix_, namespacedef_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.reference is not None:
            namespaceprefix_ = self.reference_nsprefix_ + ':' if (UseCapturedNS_ and self.reference_nsprefix_) else ''
            self.reference.export(outfile, level, namespaceprefix_, namespacedef_='', name_='reference', pretty_print=pretty_print)
        if self.type_ is not None:
            namespaceprefix_ = self.type__nsprefix_ + ':' if (UseCapturedNS_ and self.type__nsprefix_) else ''
            self.type_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='type', pretty_print=pretty_print)
        if self.identifier is not None:
            namespaceprefix_ = self.identifier_nsprefix_ + ':' if (UseCapturedNS_ and self.identifier_nsprefix_) else ''
            self.identifier.export(outfile, level, namespaceprefix_, namespacedef_='', name_='identifier', pretty_print=pretty_print)
        if self.display is not None:
            namespaceprefix_ = self.display_nsprefix_ + ':' if (UseCapturedNS_ and self.display_nsprefix_) else ''
            self.display.export(outfile, level, namespaceprefix_, namespacedef_='', name_='display', pretty_print=pretty_print)
    def exportJson(self, parent_dict=None, key=None, is_list=False):
        json_dict = dict()
        self.exportJsonAttributes(json_dict)
        self.exportJsonChildren(json_dict)
        return self.exportJsonResult(json_dict, parent_dict, key, is_list)
    def exportJsonResult(self, json_dict, parent_dict, key, is_list, sub_defs=[], attr_defs=[]):
        return super().exportJsonResult(json_dict, parent_dict, key, is_list, attr_defs)
    def exportJsonAttributes(self, json_dict):
        super().exportJsonAttributes(json_dict)
    def exportJsonChildren(self, json_dict):
        super().exportJsonChildren(json_dict)
        if self.reference is not None:
            child_dict = self.reference.exportJson(json_dict, 'reference', False)
            if child_dict:
                json_dict['reference'] = child_dict
        if self.type_ is not None:
            child_dict = self.type_.exportJson(json_dict, 'type', False)
            if child_dict:
                json_dict['type'] = child_dict
        if self.identifier is not None:
            child_dict = self.identifier.exportJson(json_dict, 'identifier', False)
            if child_dict:
                json_dict['identifier'] = child_dict
        if self.display is not None:
            child_dict = self.display.exportJson(json_dict, 'display', False)
            if child_dict:
                json_dict['display'] = child_dict
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        if SaveNodeDict:
            node_dict[node] = self 
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        super(Reference, self)._buildAttributes(node, attrs, already_processed)
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'reference':
            obj_ = string.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.reference = obj_
            obj_.original_tagname_ = 'reference'
        elif nodeName_ == 'type':
            obj_ = uri.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.type_ = obj_
            obj_.original_tagname_ = 'type'
        elif nodeName_ == 'identifier':
            obj_ = Identifier.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.identifier = obj_
            obj_.original_tagname_ = 'identifier'
        elif nodeName_ == 'display':
            obj_ = string.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.display = obj_
            obj_.original_tagname_ = 'display'
        super(Reference, self)._buildChildren(child_, node, nodeName_, True)
# end class Reference


class TriggerDefinition(Element):
    """type -- The type of triggering event.
    name -- A formal name for the event. This may be an absolute URI that identifies the event formally (e.g. from a trigger registry), or a simple relative URI that identifies the event in a local context.
    data -- The triggering data of the event (if this is a data trigger). If more than one data is requirement is specified, then all the data requirements must be true.
    condition -- A boolean-valued expression that is evaluated in the context of the container of the trigger definition and returns whether or not the trigger fires.
    
    """
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = Element
    def __init__(self, id: 'string_primitive' = None, extension: List_['Extension'] = None, type_: 'TriggerType' = None, name: 'string' = None, timingTiming: 'Timing' = None, timingReference: 'Reference' = None, timingDate: 'date' = None, timingDateTime: 'dateTime' = None, data: List_['DataRequirement'] = None, condition: 'Expression' = None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        super(globals().get("TriggerDefinition"), self).__init__(id, extension,  **kwargs_)
        self.type_ = type_
        self.type__nsprefix_ = None
        self.name = name
        self.name_nsprefix_ = None
        self.timingTiming = timingTiming
        self.timingTiming_nsprefix_ = None
        self.timingReference = timingReference
        self.timingReference_nsprefix_ = None
        self.timingDate = timingDate
        self.timingDate_nsprefix_ = None
        self.timingDateTime = timingDateTime
        self.timingDateTime_nsprefix_ = None
        if data is None:
            self.data = []
        else:
            self.data = data
        self.data_nsprefix_ = None
        self.condition = condition
        self.condition_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, TriggerDefinition)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if TriggerDefinition.subclass:
            return TriggerDefinition.subclass(*args_, **kwargs_)
        else:
            return TriggerDefinition(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_type(self):
        return self.type_
    def set_type(self, type_):
        self.type_ = type_
    def get_name(self):
        return self.name
    def set_name(self, name):
        self.name = name
    def get_timingTiming(self):
        return self.timingTiming
    def set_timingTiming(self, timingTiming):
        self.timingTiming = timingTiming
    def get_timingReference(self):
        return self.timingReference
    def set_timingReference(self, timingReference):
        self.timingReference = timingReference
    def get_timingDate(self):
        return self.timingDate
    def set_timingDate(self, timingDate):
        self.timingDate = timingDate
    def get_timingDateTime(self):
        return self.timingDateTime
    def set_timingDateTime(self, timingDateTime):
        self.timingDateTime = timingDateTime
    def get_data(self):
        return self.data
    def set_data(self, data):
        self.data = data
    def add_data(self, value):
        self.data.append(value)
    def insert_data_at(self, index, value):
        self.data.insert(index, value)
    def replace_data_at(self, index, value):
        self.data[index] = value
    def get_condition(self):
        return self.condition
    def set_condition(self, condition):
        self.condition = condition
    def has__content(self):
        if (
            self.type_ is not None or
            self.name is not None or
            self.timingTiming is not None or
            self.timingReference is not None or
            self.timingDate is not None or
            self.timingDateTime is not None or
            self.data or
            self.condition is not None or
            super(TriggerDefinition, self).has__content()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_=' xmlns:None="http://hl7.org/fhir" ', name_='TriggerDefinition', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('TriggerDefinition')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'TriggerDefinition':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='TriggerDefinition')
        if self.has__content():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='TriggerDefinition', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='TriggerDefinition'):
        super(TriggerDefinition, self)._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='TriggerDefinition')
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_=' xmlns:None="http://hl7.org/fhir" ', name_='TriggerDefinition', fromsubclass_=False, pretty_print=True):
        super(TriggerDefinition, self)._exportChildren(outfile, level, namespaceprefix_, namespacedef_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.type_ is not None:
            namespaceprefix_ = self.type__nsprefix_ + ':' if (UseCapturedNS_ and self.type__nsprefix_) else ''
            self.type_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='type', pretty_print=pretty_print)
        if self.name is not None:
            namespaceprefix_ = self.name_nsprefix_ + ':' if (UseCapturedNS_ and self.name_nsprefix_) else ''
            self.name.export(outfile, level, namespaceprefix_, namespacedef_='', name_='name', pretty_print=pretty_print)
        if self.timingTiming is not None:
            namespaceprefix_ = self.timingTiming_nsprefix_ + ':' if (UseCapturedNS_ and self.timingTiming_nsprefix_) else ''
            self.timingTiming.export(outfile, level, namespaceprefix_, namespacedef_='', name_='timingTiming', pretty_print=pretty_print)
        if self.timingReference is not None:
            namespaceprefix_ = self.timingReference_nsprefix_ + ':' if (UseCapturedNS_ and self.timingReference_nsprefix_) else ''
            self.timingReference.export(outfile, level, namespaceprefix_, namespacedef_='', name_='timingReference', pretty_print=pretty_print)
        if self.timingDate is not None:
            namespaceprefix_ = self.timingDate_nsprefix_ + ':' if (UseCapturedNS_ and self.timingDate_nsprefix_) else ''
            self.timingDate.export(outfile, level, namespaceprefix_, namespacedef_='', name_='timingDate', pretty_print=pretty_print)
        if self.timingDateTime is not None:
            namespaceprefix_ = self.timingDateTime_nsprefix_ + ':' if (UseCapturedNS_ and self.timingDateTime_nsprefix_) else ''
            self.timingDateTime.export(outfile, level, namespaceprefix_, namespacedef_='', name_='timingDateTime', pretty_print=pretty_print)
        for data_ in self.data:
            namespaceprefix_ = self.data_nsprefix_ + ':' if (UseCapturedNS_ and self.data_nsprefix_) else ''
            data_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='data', pretty_print=pretty_print)
        if self.condition is not None:
            namespaceprefix_ = self.condition_nsprefix_ + ':' if (UseCapturedNS_ and self.condition_nsprefix_) else ''
            self.condition.export(outfile, level, namespaceprefix_, namespacedef_='', name_='condition', pretty_print=pretty_print)
    def exportJson(self, parent_dict=None, key=None, is_list=False):
        json_dict = dict()
        self.exportJsonAttributes(json_dict)
        self.exportJsonChildren(json_dict)
        return self.exportJsonResult(json_dict, parent_dict, key, is_list)
    def exportJsonResult(self, json_dict, parent_dict, key, is_list, sub_defs=[], attr_defs=[]):
        return super().exportJsonResult(json_dict, parent_dict, key, is_list, attr_defs)
    def exportJsonAttributes(self, json_dict):
        super().exportJsonAttributes(json_dict)
    def exportJsonChildren(self, json_dict):
        super().exportJsonChildren(json_dict)
        if self.type_ is not None:
            child_dict = self.type_.exportJson(json_dict, 'type', False)
            if child_dict:
                json_dict['type'] = child_dict
        if self.name is not None:
            child_dict = self.name.exportJson(json_dict, 'name', False)
            if child_dict:
                json_dict['name'] = child_dict
        if self.timingTiming is not None:
            child_dict = self.timingTiming.exportJson(json_dict, 'timingTiming', False)
            if child_dict:
                json_dict['timingTiming'] = child_dict
        if self.timingReference is not None:
            child_dict = self.timingReference.exportJson(json_dict, 'timingReference', False)
            if child_dict:
                json_dict['timingReference'] = child_dict
        if self.timingDate is not None:
            child_dict = self.timingDate.exportJson(json_dict, 'timingDate', False)
            if child_dict:
                json_dict['timingDate'] = child_dict
        if self.timingDateTime is not None:
            child_dict = self.timingDateTime.exportJson(json_dict, 'timingDateTime', False)
            if child_dict:
                json_dict['timingDateTime'] = child_dict
        child_list = []
        for child in self.data:
            child_dict = child.exportJson(json_dict, 'data', True)
            if child_dict:
                child_list.append(child_dict)
        if child_list:
            json_dict['data'] = child_list
        if self.condition is not None:
            child_dict = self.condition.exportJson(json_dict, 'condition', False)
            if child_dict:
                json_dict['condition'] = child_dict
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        if SaveNodeDict:
            node_dict[node] = self 
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        super(TriggerDefinition, self)._buildAttributes(node, attrs, already_processed)
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'type':
            obj_ = TriggerType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.type_ = obj_
            obj_.original_tagname_ = 'type'
        elif nodeName_ == 'name':
            obj_ = string.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.name = obj_
            obj_.original_tagname_ = 'name'
        elif nodeName_ == 'timingTiming':
            obj_ = Timing.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.timingTiming = obj_
            obj_.original_tagname_ = 'timingTiming'
        elif nodeName_ == 'timingReference':
            obj_ = Reference.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.timingReference = obj_
            obj_.original_tagname_ = 'timingReference'
        elif nodeName_ == 'timingDate':
            obj_ = date.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.timingDate = obj_
            obj_.original_tagname_ = 'timingDate'
        elif nodeName_ == 'timingDateTime':
            obj_ = dateTime.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.timingDateTime = obj_
            obj_.original_tagname_ = 'timingDateTime'
        elif nodeName_ == 'data':
            obj_ = DataRequirement.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.data.append(obj_)
            obj_.original_tagname_ = 'data'
        elif nodeName_ == 'condition':
            obj_ = Expression.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.condition = obj_
            obj_.original_tagname_ = 'condition'
        super(TriggerDefinition, self)._buildChildren(child_, node, nodeName_, True)
# end class TriggerDefinition


class TriggerType(Element):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = Element
    def __init__(self, id: 'string_primitive' = None, extension: List_['Extension'] = None, value: 'TriggerTypeEnum' = None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        super(globals().get("TriggerType"), self).__init__(id, extension,  **kwargs_)
        self.value = _cast(None, value)
        self.value_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, TriggerType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if TriggerType.subclass:
            return TriggerType.subclass(*args_, **kwargs_)
        else:
            return TriggerType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_value(self):
        return self.value
    def set_value(self, value):
        self.value = value
    def validate_TriggerTypeEnum(self, value):
        # Validate type TriggerTypeEnum, a restriction on code-primitive.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['named-event', 'periodic', 'data-changed', 'data-added', 'data-modified', 'data-removed', 'data-accessed', 'data-access-ended']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on TriggerTypeEnum' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
            if len(value) < 1:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd minLength restriction on TriggerTypeEnum' % {"value" : value, "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_TriggerTypeEnum_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_TriggerTypeEnum_patterns_, ))
    validate_TriggerTypeEnum_patterns_ = [['^([^\\s]+(\\s[^\\s]+)*)$']]
    def has__content(self):
        if (
            super(TriggerType, self).has__content()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='TriggerType', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('TriggerType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'TriggerType':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='TriggerType')
        if self.has__content():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='TriggerType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='TriggerType'):
        super(TriggerType, self)._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='TriggerType')
        if self.value is not None and 'value' not in already_processed:
            already_processed.add('value')
            outfile.write(' value=%s' % (quote_attrib(self.value), ))
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='TriggerType', fromsubclass_=False, pretty_print=True):
        super(TriggerType, self)._exportChildren(outfile, level, namespaceprefix_, namespacedef_, name_, True, pretty_print=pretty_print)
    def exportJson(self, parent_dict=None, key=None, is_list=False):
        json_dict = dict()
        self.exportJsonAttributes(json_dict)
        self.exportJsonChildren(json_dict)
        return self.exportJsonResult(json_dict, parent_dict, key, is_list)
    def exportJsonResult(self, json_dict, parent_dict, key, is_list, sub_defs=[], attr_defs=['value']):
        return super().exportJsonResult(json_dict, parent_dict, key, is_list, attr_defs)
    def exportJsonAttributes(self, json_dict):
        super().exportJsonAttributes(json_dict)
        if self.value is not None:
            json_dict['value'] = self.value
    def exportJsonChildren(self, json_dict):
        super().exportJsonChildren(json_dict)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        if SaveNodeDict:
            node_dict[node] = self 
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('value', node)
        if value is not None and 'value' not in already_processed:
            already_processed.add('value')
            self.value = value
            self.value = ' '.join(self.value.split())
            self.validate_TriggerTypeEnum(self.value)    # validate type TriggerTypeEnum
        super(TriggerType, self)._buildAttributes(node, attrs, already_processed)
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        super(TriggerType, self)._buildChildren(child_, node, nodeName_, True)
        pass
# end class TriggerType


class Quantity(Element):
    """value -- The value of the measured amount. The value includes an implicit precision in the presentation of the value.
    comparator -- How the value should be understood and represented - whether the actual value is greater or less than the stated value due to measurement issues; e.g. if the comparator is "
    <
    " , then the real value is
    <
    stated value.
    unit -- A human-readable form of the unit.
    system -- The identification of the system that provides the coded form of the unit.
    code -- A computer processable form of the unit in some unit representation system.
    
    """
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = Element
    def __init__(self, id: 'string_primitive' = None, extension: List_['Extension'] = None, value: 'decimal' = None, comparator: 'QuantityComparator' = None, unit: 'string' = None, system: 'uri' = None, code: 'code' = None, extensiontype_=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        super(globals().get("Quantity"), self).__init__(id, extension, extensiontype_,  **kwargs_)
        self.value = value
        self.value_nsprefix_ = None
        self.comparator = comparator
        self.comparator_nsprefix_ = None
        self.unit = unit
        self.unit_nsprefix_ = None
        self.system = system
        self.system_nsprefix_ = None
        self.code = code
        self.code_nsprefix_ = None
        self.extensiontype_ = extensiontype_
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, Quantity)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if Quantity.subclass:
            return Quantity.subclass(*args_, **kwargs_)
        else:
            return Quantity(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_value(self):
        return self.value
    def set_value(self, value):
        self.value = value
    def get_comparator(self):
        return self.comparator
    def set_comparator(self, comparator):
        self.comparator = comparator
    def get_unit(self):
        return self.unit
    def set_unit(self, unit):
        self.unit = unit
    def get_system(self):
        return self.system
    def set_system(self, system):
        self.system = system
    def get_code(self):
        return self.code
    def set_code(self, code):
        self.code = code
    def get_extensiontype_(self): return self.extensiontype_
    def set_extensiontype_(self, extensiontype_): self.extensiontype_ = extensiontype_
    def has__content(self):
        if (
            self.value is not None or
            self.comparator is not None or
            self.unit is not None or
            self.system is not None or
            self.code is not None or
            super(Quantity, self).has__content()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_=' xmlns:None="http://hl7.org/fhir" ', name_='Quantity', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('Quantity')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'Quantity':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='Quantity')
        if self.has__content():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='Quantity', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='Quantity'):
        super(Quantity, self)._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='Quantity')
        if self.extensiontype_ is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            outfile.write(' xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"')
            if ":" not in self.extensiontype_:
                imported_ns_type_prefix_ = GenerateDSNamespaceTypePrefixes_.get(self.extensiontype_, '')
                outfile.write(' xsi:type="%s%s"' % (imported_ns_type_prefix_, self.extensiontype_))
            else:
                outfile.write(' xsi:type="%s"' % self.extensiontype_)
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_=' xmlns:None="http://hl7.org/fhir" ', name_='Quantity', fromsubclass_=False, pretty_print=True):
        super(Quantity, self)._exportChildren(outfile, level, namespaceprefix_, namespacedef_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.value is not None:
            namespaceprefix_ = self.value_nsprefix_ + ':' if (UseCapturedNS_ and self.value_nsprefix_) else ''
            self.value.export(outfile, level, namespaceprefix_, namespacedef_='', name_='value', pretty_print=pretty_print)
        if self.comparator is not None:
            namespaceprefix_ = self.comparator_nsprefix_ + ':' if (UseCapturedNS_ and self.comparator_nsprefix_) else ''
            self.comparator.export(outfile, level, namespaceprefix_, namespacedef_='', name_='comparator', pretty_print=pretty_print)
        if self.unit is not None:
            namespaceprefix_ = self.unit_nsprefix_ + ':' if (UseCapturedNS_ and self.unit_nsprefix_) else ''
            self.unit.export(outfile, level, namespaceprefix_, namespacedef_='', name_='unit', pretty_print=pretty_print)
        if self.system is not None:
            namespaceprefix_ = self.system_nsprefix_ + ':' if (UseCapturedNS_ and self.system_nsprefix_) else ''
            self.system.export(outfile, level, namespaceprefix_, namespacedef_='', name_='system', pretty_print=pretty_print)
        if self.code is not None:
            namespaceprefix_ = self.code_nsprefix_ + ':' if (UseCapturedNS_ and self.code_nsprefix_) else ''
            self.code.export(outfile, level, namespaceprefix_, namespacedef_='', name_='code', pretty_print=pretty_print)
    def exportJson(self, parent_dict=None, key=None, is_list=False):
        json_dict = dict()
        self.exportJsonAttributes(json_dict)
        self.exportJsonChildren(json_dict)
        return self.exportJsonResult(json_dict, parent_dict, key, is_list)
    def exportJsonResult(self, json_dict, parent_dict, key, is_list, sub_defs=[], attr_defs=[]):
        return super().exportJsonResult(json_dict, parent_dict, key, is_list, attr_defs)
    def exportJsonAttributes(self, json_dict):
        super().exportJsonAttributes(json_dict)
    def exportJsonChildren(self, json_dict):
        super().exportJsonChildren(json_dict)
        if self.value is not None:
            child_dict = self.value.exportJson(json_dict, 'value', False)
            if child_dict:
                json_dict['value'] = child_dict
        if self.comparator is not None:
            child_dict = self.comparator.exportJson(json_dict, 'comparator', False)
            if child_dict:
                json_dict['comparator'] = child_dict
        if self.unit is not None:
            child_dict = self.unit.exportJson(json_dict, 'unit', False)
            if child_dict:
                json_dict['unit'] = child_dict
        if self.system is not None:
            child_dict = self.system.exportJson(json_dict, 'system', False)
            if child_dict:
                json_dict['system'] = child_dict
        if self.code is not None:
            child_dict = self.code.exportJson(json_dict, 'code', False)
            if child_dict:
                json_dict['code'] = child_dict
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        if SaveNodeDict:
            node_dict[node] = self 
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('xsi:type', node)
        if value is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            self.extensiontype_ = value
        super(Quantity, self)._buildAttributes(node, attrs, already_processed)
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'value':
            obj_ = decimal.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.value = obj_
            obj_.original_tagname_ = 'value'
        elif nodeName_ == 'comparator':
            obj_ = QuantityComparator.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.comparator = obj_
            obj_.original_tagname_ = 'comparator'
        elif nodeName_ == 'unit':
            obj_ = string.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.unit = obj_
            obj_.original_tagname_ = 'unit'
        elif nodeName_ == 'system':
            obj_ = uri.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.system = obj_
            obj_.original_tagname_ = 'system'
        elif nodeName_ == 'code':
            obj_ = code.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.code = obj_
            obj_.original_tagname_ = 'code'
        super(Quantity, self)._buildChildren(child_, node, nodeName_, True)
# end class Quantity


class QuantityComparator(Element):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = Element
    def __init__(self, id: 'string_primitive' = None, extension: List_['Extension'] = None, value: 'QuantityComparatorEnum' = None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        super(globals().get("QuantityComparator"), self).__init__(id, extension,  **kwargs_)
        self.value = _cast(None, value)
        self.value_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, QuantityComparator)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if QuantityComparator.subclass:
            return QuantityComparator.subclass(*args_, **kwargs_)
        else:
            return QuantityComparator(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_value(self):
        return self.value
    def set_value(self, value):
        self.value = value
    def validate_QuantityComparatorEnum(self, value):
        # Validate type QuantityComparatorEnum, a restriction on code-primitive.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['<', '<=', '>=', '>']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on QuantityComparatorEnum' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
            if len(value) < 1:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd minLength restriction on QuantityComparatorEnum' % {"value" : value, "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_QuantityComparatorEnum_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_QuantityComparatorEnum_patterns_, ))
    validate_QuantityComparatorEnum_patterns_ = [['^([^\\s]+(\\s[^\\s]+)*)$']]
    def has__content(self):
        if (
            super(QuantityComparator, self).has__content()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='QuantityComparator', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('QuantityComparator')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'QuantityComparator':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='QuantityComparator')
        if self.has__content():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='QuantityComparator', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='QuantityComparator'):
        super(QuantityComparator, self)._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='QuantityComparator')
        if self.value is not None and 'value' not in already_processed:
            already_processed.add('value')
            outfile.write(' value=%s' % (quote_attrib(self.value), ))
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='QuantityComparator', fromsubclass_=False, pretty_print=True):
        super(QuantityComparator, self)._exportChildren(outfile, level, namespaceprefix_, namespacedef_, name_, True, pretty_print=pretty_print)
    def exportJson(self, parent_dict=None, key=None, is_list=False):
        json_dict = dict()
        self.exportJsonAttributes(json_dict)
        self.exportJsonChildren(json_dict)
        return self.exportJsonResult(json_dict, parent_dict, key, is_list)
    def exportJsonResult(self, json_dict, parent_dict, key, is_list, sub_defs=[], attr_defs=['value']):
        return super().exportJsonResult(json_dict, parent_dict, key, is_list, attr_defs)
    def exportJsonAttributes(self, json_dict):
        super().exportJsonAttributes(json_dict)
        if self.value is not None:
            json_dict['value'] = self.value
    def exportJsonChildren(self, json_dict):
        super().exportJsonChildren(json_dict)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        if SaveNodeDict:
            node_dict[node] = self 
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('value', node)
        if value is not None and 'value' not in already_processed:
            already_processed.add('value')
            self.value = value
            self.value = ' '.join(self.value.split())
            self.validate_QuantityComparatorEnum(self.value)    # validate type QuantityComparatorEnum
        super(QuantityComparator, self)._buildAttributes(node, attrs, already_processed)
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        super(QuantityComparator, self)._buildChildren(child_, node, nodeName_, True)
        pass
# end class QuantityComparator


class Period(Element):
    """start -- The start of the period. The boundary is inclusive.
    end -- The end of the period. If the end of the period is missing, it means no end was known or planned at the time the instance was created. The start may be in the past, and the end date in the future, which means that period is expected/planned to end at that time.
    
    """
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = Element
    def __init__(self, id: 'string_primitive' = None, extension: List_['Extension'] = None, start: 'dateTime' = None, end: 'dateTime' = None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        super(globals().get("Period"), self).__init__(id, extension,  **kwargs_)
        self.start = start
        self.start_nsprefix_ = None
        self.end = end
        self.end_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, Period)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if Period.subclass:
            return Period.subclass(*args_, **kwargs_)
        else:
            return Period(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_start(self):
        return self.start
    def set_start(self, start):
        self.start = start
    def get_end(self):
        return self.end
    def set_end(self, end):
        self.end = end
    def has__content(self):
        if (
            self.start is not None or
            self.end is not None or
            super(Period, self).has__content()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_=' xmlns:None="http://hl7.org/fhir" ', name_='Period', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('Period')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'Period':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='Period')
        if self.has__content():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='Period', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='Period'):
        super(Period, self)._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='Period')
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_=' xmlns:None="http://hl7.org/fhir" ', name_='Period', fromsubclass_=False, pretty_print=True):
        super(Period, self)._exportChildren(outfile, level, namespaceprefix_, namespacedef_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.start is not None:
            namespaceprefix_ = self.start_nsprefix_ + ':' if (UseCapturedNS_ and self.start_nsprefix_) else ''
            self.start.export(outfile, level, namespaceprefix_, namespacedef_='', name_='start', pretty_print=pretty_print)
        if self.end is not None:
            namespaceprefix_ = self.end_nsprefix_ + ':' if (UseCapturedNS_ and self.end_nsprefix_) else ''
            self.end.export(outfile, level, namespaceprefix_, namespacedef_='', name_='end', pretty_print=pretty_print)
    def exportJson(self, parent_dict=None, key=None, is_list=False):
        json_dict = dict()
        self.exportJsonAttributes(json_dict)
        self.exportJsonChildren(json_dict)
        return self.exportJsonResult(json_dict, parent_dict, key, is_list)
    def exportJsonResult(self, json_dict, parent_dict, key, is_list, sub_defs=[], attr_defs=[]):
        return super().exportJsonResult(json_dict, parent_dict, key, is_list, attr_defs)
    def exportJsonAttributes(self, json_dict):
        super().exportJsonAttributes(json_dict)
    def exportJsonChildren(self, json_dict):
        super().exportJsonChildren(json_dict)
        if self.start is not None:
            child_dict = self.start.exportJson(json_dict, 'start', False)
            if child_dict:
                json_dict['start'] = child_dict
        if self.end is not None:
            child_dict = self.end.exportJson(json_dict, 'end', False)
            if child_dict:
                json_dict['end'] = child_dict
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        if SaveNodeDict:
            node_dict[node] = self 
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        super(Period, self)._buildAttributes(node, attrs, already_processed)
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'start':
            obj_ = dateTime.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.start = obj_
            obj_.original_tagname_ = 'start'
        elif nodeName_ == 'end':
            obj_ = dateTime.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.end = obj_
            obj_.original_tagname_ = 'end'
        super(Period, self)._buildChildren(child_, node, nodeName_, True)
# end class Period


class Duration(Quantity):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = Quantity
    def __init__(self, id: 'string_primitive' = None, extension: List_['Extension'] = None, value: 'decimal' = None, comparator: 'QuantityComparator' = None, unit: 'string' = None, system: 'uri' = None, code: 'code' = None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        super(globals().get("Duration"), self).__init__(id, extension, value, comparator, unit, system, code,  **kwargs_)
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, Duration)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if Duration.subclass:
            return Duration.subclass(*args_, **kwargs_)
        else:
            return Duration(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def has__content(self):
        if (
            super(Duration, self).has__content()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='Duration', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('Duration')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'Duration':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='Duration')
        if self.has__content():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='Duration', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='Duration'):
        super(Duration, self)._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='Duration')
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='Duration', fromsubclass_=False, pretty_print=True):
        super(Duration, self)._exportChildren(outfile, level, namespaceprefix_, namespacedef_, name_, True, pretty_print=pretty_print)
    def exportJson(self, parent_dict=None, key=None, is_list=False):
        json_dict = dict()
        self.exportJsonAttributes(json_dict)
        self.exportJsonChildren(json_dict)
        return self.exportJsonResult(json_dict, parent_dict, key, is_list)
    def exportJsonResult(self, json_dict, parent_dict, key, is_list, sub_defs=[], attr_defs=[]):
        return super().exportJsonResult(json_dict, parent_dict, key, is_list, attr_defs)
    def exportJsonAttributes(self, json_dict):
        super().exportJsonAttributes(json_dict)
    def exportJsonChildren(self, json_dict):
        super().exportJsonChildren(json_dict)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        if SaveNodeDict:
            node_dict[node] = self 
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        super(Duration, self)._buildAttributes(node, attrs, already_processed)
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        super(Duration, self)._buildChildren(child_, node, nodeName_, True)
        pass
# end class Duration


class Range(Element):
    """low -- The low limit. The boundary is inclusive.
    high -- The high limit. The boundary is inclusive.
    
    """
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = Element
    def __init__(self, id: 'string_primitive' = None, extension: List_['Extension'] = None, low: 'Quantity' = None, high: 'Quantity' = None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        super(globals().get("Range"), self).__init__(id, extension,  **kwargs_)
        self.low = low
        self.low_nsprefix_ = None
        self.high = high
        self.high_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, Range)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if Range.subclass:
            return Range.subclass(*args_, **kwargs_)
        else:
            return Range(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_low(self):
        return self.low
    def set_low(self, low):
        self.low = low
    def get_high(self):
        return self.high
    def set_high(self, high):
        self.high = high
    def has__content(self):
        if (
            self.low is not None or
            self.high is not None or
            super(Range, self).has__content()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_=' xmlns:None="http://hl7.org/fhir" ', name_='Range', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('Range')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'Range':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='Range')
        if self.has__content():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='Range', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='Range'):
        super(Range, self)._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='Range')
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_=' xmlns:None="http://hl7.org/fhir" ', name_='Range', fromsubclass_=False, pretty_print=True):
        super(Range, self)._exportChildren(outfile, level, namespaceprefix_, namespacedef_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.low is not None:
            namespaceprefix_ = self.low_nsprefix_ + ':' if (UseCapturedNS_ and self.low_nsprefix_) else ''
            self.low.export(outfile, level, namespaceprefix_, namespacedef_='', name_='low', pretty_print=pretty_print)
        if self.high is not None:
            namespaceprefix_ = self.high_nsprefix_ + ':' if (UseCapturedNS_ and self.high_nsprefix_) else ''
            self.high.export(outfile, level, namespaceprefix_, namespacedef_='', name_='high', pretty_print=pretty_print)
    def exportJson(self, parent_dict=None, key=None, is_list=False):
        json_dict = dict()
        self.exportJsonAttributes(json_dict)
        self.exportJsonChildren(json_dict)
        return self.exportJsonResult(json_dict, parent_dict, key, is_list)
    def exportJsonResult(self, json_dict, parent_dict, key, is_list, sub_defs=[], attr_defs=[]):
        return super().exportJsonResult(json_dict, parent_dict, key, is_list, attr_defs)
    def exportJsonAttributes(self, json_dict):
        super().exportJsonAttributes(json_dict)
    def exportJsonChildren(self, json_dict):
        super().exportJsonChildren(json_dict)
        if self.low is not None:
            child_dict = self.low.exportJson(json_dict, 'low', False)
            if child_dict:
                json_dict['low'] = child_dict
        if self.high is not None:
            child_dict = self.high.exportJson(json_dict, 'high', False)
            if child_dict:
                json_dict['high'] = child_dict
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        if SaveNodeDict:
            node_dict[node] = self 
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        super(Range, self)._buildAttributes(node, attrs, already_processed)
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'low':
            class_obj_ = self.get_class_obj_(child_, Quantity)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.low = obj_
            obj_.original_tagname_ = 'low'
        elif nodeName_ == 'high':
            class_obj_ = self.get_class_obj_(child_, Quantity)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.high = obj_
            obj_.original_tagname_ = 'high'
        super(Range, self)._buildChildren(child_, node, nodeName_, True)
# end class Range


class RelatedArtifact(Element):
    """type -- The type of relationship to the related artifact.
    label -- A short label that can be used to reference the citation from elsewhere in the containing artifact, such as a footnote index.
    display -- A brief description of the document or knowledge resource being referenced, suitable for display to a consumer.
    citation -- A bibliographic citation for the related artifact. This text SHOULD be formatted according to an accepted citation format.
    url -- A url for the artifact that can be followed to access the actual content.
    document -- The document being referenced, represented as an attachment. This is exclusive with the resource element.
    resource -- The related resource, such as a library, value set, profile, or other knowledge resource.
    
    """
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = Element
    def __init__(self, id: 'string_primitive' = None, extension: List_['Extension'] = None, type_: 'RelatedArtifactType' = None, label: 'string' = None, display: 'string' = None, citation: 'markdown' = None, url: 'url' = None, document: 'Attachment' = None, resource: 'canonical' = None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        super(globals().get("RelatedArtifact"), self).__init__(id, extension,  **kwargs_)
        self.type_ = type_
        self.type__nsprefix_ = None
        self.label = label
        self.label_nsprefix_ = None
        self.display = display
        self.display_nsprefix_ = None
        self.citation = citation
        self.citation_nsprefix_ = None
        self.url = url
        self.url_nsprefix_ = None
        self.document = document
        self.document_nsprefix_ = None
        self.resource = resource
        self.resource_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, RelatedArtifact)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if RelatedArtifact.subclass:
            return RelatedArtifact.subclass(*args_, **kwargs_)
        else:
            return RelatedArtifact(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_type(self):
        return self.type_
    def set_type(self, type_):
        self.type_ = type_
    def get_label(self):
        return self.label
    def set_label(self, label):
        self.label = label
    def get_display(self):
        return self.display
    def set_display(self, display):
        self.display = display
    def get_citation(self):
        return self.citation
    def set_citation(self, citation):
        self.citation = citation
    def get_url(self):
        return self.url
    def set_url(self, url):
        self.url = url
    def get_document(self):
        return self.document
    def set_document(self, document):
        self.document = document
    def get_resource(self):
        return self.resource
    def set_resource(self, resource):
        self.resource = resource
    def has__content(self):
        if (
            self.type_ is not None or
            self.label is not None or
            self.display is not None or
            self.citation is not None or
            self.url is not None or
            self.document is not None or
            self.resource is not None or
            super(RelatedArtifact, self).has__content()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_=' xmlns:None="http://hl7.org/fhir" ', name_='RelatedArtifact', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('RelatedArtifact')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'RelatedArtifact':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='RelatedArtifact')
        if self.has__content():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='RelatedArtifact', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='RelatedArtifact'):
        super(RelatedArtifact, self)._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='RelatedArtifact')
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_=' xmlns:None="http://hl7.org/fhir" ', name_='RelatedArtifact', fromsubclass_=False, pretty_print=True):
        super(RelatedArtifact, self)._exportChildren(outfile, level, namespaceprefix_, namespacedef_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.type_ is not None:
            namespaceprefix_ = self.type__nsprefix_ + ':' if (UseCapturedNS_ and self.type__nsprefix_) else ''
            self.type_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='type', pretty_print=pretty_print)
        if self.label is not None:
            namespaceprefix_ = self.label_nsprefix_ + ':' if (UseCapturedNS_ and self.label_nsprefix_) else ''
            self.label.export(outfile, level, namespaceprefix_, namespacedef_='', name_='label', pretty_print=pretty_print)
        if self.display is not None:
            namespaceprefix_ = self.display_nsprefix_ + ':' if (UseCapturedNS_ and self.display_nsprefix_) else ''
            self.display.export(outfile, level, namespaceprefix_, namespacedef_='', name_='display', pretty_print=pretty_print)
        if self.citation is not None:
            namespaceprefix_ = self.citation_nsprefix_ + ':' if (UseCapturedNS_ and self.citation_nsprefix_) else ''
            self.citation.export(outfile, level, namespaceprefix_, namespacedef_='', name_='citation', pretty_print=pretty_print)
        if self.url is not None:
            namespaceprefix_ = self.url_nsprefix_ + ':' if (UseCapturedNS_ and self.url_nsprefix_) else ''
            self.url.export(outfile, level, namespaceprefix_, namespacedef_='', name_='url', pretty_print=pretty_print)
        if self.document is not None:
            namespaceprefix_ = self.document_nsprefix_ + ':' if (UseCapturedNS_ and self.document_nsprefix_) else ''
            self.document.export(outfile, level, namespaceprefix_, namespacedef_='', name_='document', pretty_print=pretty_print)
        if self.resource is not None:
            namespaceprefix_ = self.resource_nsprefix_ + ':' if (UseCapturedNS_ and self.resource_nsprefix_) else ''
            self.resource.export(outfile, level, namespaceprefix_, namespacedef_='', name_='resource', pretty_print=pretty_print)
    def exportJson(self, parent_dict=None, key=None, is_list=False):
        json_dict = dict()
        self.exportJsonAttributes(json_dict)
        self.exportJsonChildren(json_dict)
        return self.exportJsonResult(json_dict, parent_dict, key, is_list)
    def exportJsonResult(self, json_dict, parent_dict, key, is_list, sub_defs=[], attr_defs=[]):
        return super().exportJsonResult(json_dict, parent_dict, key, is_list, attr_defs)
    def exportJsonAttributes(self, json_dict):
        super().exportJsonAttributes(json_dict)
    def exportJsonChildren(self, json_dict):
        super().exportJsonChildren(json_dict)
        if self.type_ is not None:
            child_dict = self.type_.exportJson(json_dict, 'type', False)
            if child_dict:
                json_dict['type'] = child_dict
        if self.label is not None:
            child_dict = self.label.exportJson(json_dict, 'label', False)
            if child_dict:
                json_dict['label'] = child_dict
        if self.display is not None:
            child_dict = self.display.exportJson(json_dict, 'display', False)
            if child_dict:
                json_dict['display'] = child_dict
        if self.citation is not None:
            child_dict = self.citation.exportJson(json_dict, 'citation', False)
            if child_dict:
                json_dict['citation'] = child_dict
        if self.url is not None:
            child_dict = self.url.exportJson(json_dict, 'url', False)
            if child_dict:
                json_dict['url'] = child_dict
        if self.document is not None:
            child_dict = self.document.exportJson(json_dict, 'document', False)
            if child_dict:
                json_dict['document'] = child_dict
        if self.resource is not None:
            child_dict = self.resource.exportJson(json_dict, 'resource', False)
            if child_dict:
                json_dict['resource'] = child_dict
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        if SaveNodeDict:
            node_dict[node] = self 
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        super(RelatedArtifact, self)._buildAttributes(node, attrs, already_processed)
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'type':
            obj_ = RelatedArtifactType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.type_ = obj_
            obj_.original_tagname_ = 'type'
        elif nodeName_ == 'label':
            obj_ = string.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.label = obj_
            obj_.original_tagname_ = 'label'
        elif nodeName_ == 'display':
            obj_ = string.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.display = obj_
            obj_.original_tagname_ = 'display'
        elif nodeName_ == 'citation':
            obj_ = markdown.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.citation = obj_
            obj_.original_tagname_ = 'citation'
        elif nodeName_ == 'url':
            obj_ = url.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.url = obj_
            obj_.original_tagname_ = 'url'
        elif nodeName_ == 'document':
            obj_ = Attachment.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.document = obj_
            obj_.original_tagname_ = 'document'
        elif nodeName_ == 'resource':
            obj_ = canonical.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.resource = obj_
            obj_.original_tagname_ = 'resource'
        super(RelatedArtifact, self)._buildChildren(child_, node, nodeName_, True)
# end class RelatedArtifact


class RelatedArtifactType(Element):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = Element
    def __init__(self, id: 'string_primitive' = None, extension: List_['Extension'] = None, value: 'RelatedArtifactTypeEnum' = None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        super(globals().get("RelatedArtifactType"), self).__init__(id, extension,  **kwargs_)
        self.value = _cast(None, value)
        self.value_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, RelatedArtifactType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if RelatedArtifactType.subclass:
            return RelatedArtifactType.subclass(*args_, **kwargs_)
        else:
            return RelatedArtifactType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_value(self):
        return self.value
    def set_value(self, value):
        self.value = value
    def validate_RelatedArtifactTypeEnum(self, value):
        # Validate type RelatedArtifactTypeEnum, a restriction on code-primitive.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['documentation', 'justification', 'citation', 'predecessor', 'successor', 'derived-from', 'depends-on', 'composed-of']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on RelatedArtifactTypeEnum' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
            if len(value) < 1:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd minLength restriction on RelatedArtifactTypeEnum' % {"value" : value, "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_RelatedArtifactTypeEnum_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_RelatedArtifactTypeEnum_patterns_, ))
    validate_RelatedArtifactTypeEnum_patterns_ = [['^([^\\s]+(\\s[^\\s]+)*)$']]
    def has__content(self):
        if (
            super(RelatedArtifactType, self).has__content()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='RelatedArtifactType', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('RelatedArtifactType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'RelatedArtifactType':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='RelatedArtifactType')
        if self.has__content():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='RelatedArtifactType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='RelatedArtifactType'):
        super(RelatedArtifactType, self)._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='RelatedArtifactType')
        if self.value is not None and 'value' not in already_processed:
            already_processed.add('value')
            outfile.write(' value=%s' % (quote_attrib(self.value), ))
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='RelatedArtifactType', fromsubclass_=False, pretty_print=True):
        super(RelatedArtifactType, self)._exportChildren(outfile, level, namespaceprefix_, namespacedef_, name_, True, pretty_print=pretty_print)
    def exportJson(self, parent_dict=None, key=None, is_list=False):
        json_dict = dict()
        self.exportJsonAttributes(json_dict)
        self.exportJsonChildren(json_dict)
        return self.exportJsonResult(json_dict, parent_dict, key, is_list)
    def exportJsonResult(self, json_dict, parent_dict, key, is_list, sub_defs=[], attr_defs=['value']):
        return super().exportJsonResult(json_dict, parent_dict, key, is_list, attr_defs)
    def exportJsonAttributes(self, json_dict):
        super().exportJsonAttributes(json_dict)
        if self.value is not None:
            json_dict['value'] = self.value
    def exportJsonChildren(self, json_dict):
        super().exportJsonChildren(json_dict)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        if SaveNodeDict:
            node_dict[node] = self 
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('value', node)
        if value is not None and 'value' not in already_processed:
            already_processed.add('value')
            self.value = value
            self.value = ' '.join(self.value.split())
            self.validate_RelatedArtifactTypeEnum(self.value)    # validate type RelatedArtifactTypeEnum
        super(RelatedArtifactType, self)._buildAttributes(node, attrs, already_processed)
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        super(RelatedArtifactType, self)._buildChildren(child_, node, nodeName_, True)
        pass
# end class RelatedArtifactType


class Annotation(Element):
    """time -- Indicates when this particular annotation was made.
    text -- The text of the annotation in markdown format.
    
    """
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = Element
    def __init__(self, id: 'string_primitive' = None, extension: List_['Extension'] = None, authorReference: 'Reference' = None, authorString: 'string' = None, time: 'dateTime' = None, text: 'markdown' = None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        super(globals().get("Annotation"), self).__init__(id, extension,  **kwargs_)
        self.authorReference = authorReference
        self.authorReference_nsprefix_ = None
        self.authorString = authorString
        self.authorString_nsprefix_ = None
        self.time = time
        self.time_nsprefix_ = None
        self.text = text
        self.text_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, Annotation)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if Annotation.subclass:
            return Annotation.subclass(*args_, **kwargs_)
        else:
            return Annotation(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_authorReference(self):
        return self.authorReference
    def set_authorReference(self, authorReference):
        self.authorReference = authorReference
    def get_authorString(self):
        return self.authorString
    def set_authorString(self, authorString):
        self.authorString = authorString
    def get_time(self):
        return self.time
    def set_time(self, time):
        self.time = time
    def get_text(self):
        return self.text
    def set_text(self, text):
        self.text = text
    def has__content(self):
        if (
            self.authorReference is not None or
            self.authorString is not None or
            self.time is not None or
            self.text is not None or
            super(Annotation, self).has__content()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_=' xmlns:None="http://hl7.org/fhir" ', name_='Annotation', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('Annotation')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'Annotation':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='Annotation')
        if self.has__content():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='Annotation', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='Annotation'):
        super(Annotation, self)._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='Annotation')
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_=' xmlns:None="http://hl7.org/fhir" ', name_='Annotation', fromsubclass_=False, pretty_print=True):
        super(Annotation, self)._exportChildren(outfile, level, namespaceprefix_, namespacedef_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.authorReference is not None:
            namespaceprefix_ = self.authorReference_nsprefix_ + ':' if (UseCapturedNS_ and self.authorReference_nsprefix_) else ''
            self.authorReference.export(outfile, level, namespaceprefix_, namespacedef_='', name_='authorReference', pretty_print=pretty_print)
        if self.authorString is not None:
            namespaceprefix_ = self.authorString_nsprefix_ + ':' if (UseCapturedNS_ and self.authorString_nsprefix_) else ''
            self.authorString.export(outfile, level, namespaceprefix_, namespacedef_='', name_='authorString', pretty_print=pretty_print)
        if self.time is not None:
            namespaceprefix_ = self.time_nsprefix_ + ':' if (UseCapturedNS_ and self.time_nsprefix_) else ''
            self.time.export(outfile, level, namespaceprefix_, namespacedef_='', name_='time', pretty_print=pretty_print)
        if self.text is not None:
            namespaceprefix_ = self.text_nsprefix_ + ':' if (UseCapturedNS_ and self.text_nsprefix_) else ''
            self.text.export(outfile, level, namespaceprefix_, namespacedef_='', name_='text', pretty_print=pretty_print)
    def exportJson(self, parent_dict=None, key=None, is_list=False):
        json_dict = dict()
        self.exportJsonAttributes(json_dict)
        self.exportJsonChildren(json_dict)
        return self.exportJsonResult(json_dict, parent_dict, key, is_list)
    def exportJsonResult(self, json_dict, parent_dict, key, is_list, sub_defs=[], attr_defs=[]):
        return super().exportJsonResult(json_dict, parent_dict, key, is_list, attr_defs)
    def exportJsonAttributes(self, json_dict):
        super().exportJsonAttributes(json_dict)
    def exportJsonChildren(self, json_dict):
        super().exportJsonChildren(json_dict)
        if self.authorReference is not None:
            child_dict = self.authorReference.exportJson(json_dict, 'authorReference', False)
            if child_dict:
                json_dict['authorReference'] = child_dict
        if self.authorString is not None:
            child_dict = self.authorString.exportJson(json_dict, 'authorString', False)
            if child_dict:
                json_dict['authorString'] = child_dict
        if self.time is not None:
            child_dict = self.time.exportJson(json_dict, 'time', False)
            if child_dict:
                json_dict['time'] = child_dict
        if self.text is not None:
            child_dict = self.text.exportJson(json_dict, 'text', False)
            if child_dict:
                json_dict['text'] = child_dict
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        if SaveNodeDict:
            node_dict[node] = self 
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        super(Annotation, self)._buildAttributes(node, attrs, already_processed)
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'authorReference':
            obj_ = Reference.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.authorReference = obj_
            obj_.original_tagname_ = 'authorReference'
        elif nodeName_ == 'authorString':
            obj_ = string.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.authorString = obj_
            obj_.original_tagname_ = 'authorString'
        elif nodeName_ == 'time':
            obj_ = dateTime.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.time = obj_
            obj_.original_tagname_ = 'time'
        elif nodeName_ == 'text':
            obj_ = markdown.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.text = obj_
            obj_.original_tagname_ = 'text'
        super(Annotation, self)._buildChildren(child_, node, nodeName_, True)
# end class Annotation


class ContactDetail(Element):
    """name -- The name of an individual to contact.
    telecom -- The contact details for the individual (if a name was provided) or the organization.
    
    """
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = Element
    def __init__(self, id: 'string_primitive' = None, extension: List_['Extension'] = None, name: 'string' = None, telecom: List_['ContactPoint'] = None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        super(globals().get("ContactDetail"), self).__init__(id, extension,  **kwargs_)
        self.name = name
        self.name_nsprefix_ = None
        if telecom is None:
            self.telecom = []
        else:
            self.telecom = telecom
        self.telecom_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ContactDetail)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ContactDetail.subclass:
            return ContactDetail.subclass(*args_, **kwargs_)
        else:
            return ContactDetail(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_name(self):
        return self.name
    def set_name(self, name):
        self.name = name
    def get_telecom(self):
        return self.telecom
    def set_telecom(self, telecom):
        self.telecom = telecom
    def add_telecom(self, value):
        self.telecom.append(value)
    def insert_telecom_at(self, index, value):
        self.telecom.insert(index, value)
    def replace_telecom_at(self, index, value):
        self.telecom[index] = value
    def has__content(self):
        if (
            self.name is not None or
            self.telecom or
            super(ContactDetail, self).has__content()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_=' xmlns:None="http://hl7.org/fhir" ', name_='ContactDetail', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('ContactDetail')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'ContactDetail':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='ContactDetail')
        if self.has__content():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='ContactDetail', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='ContactDetail'):
        super(ContactDetail, self)._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='ContactDetail')
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_=' xmlns:None="http://hl7.org/fhir" ', name_='ContactDetail', fromsubclass_=False, pretty_print=True):
        super(ContactDetail, self)._exportChildren(outfile, level, namespaceprefix_, namespacedef_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.name is not None:
            namespaceprefix_ = self.name_nsprefix_ + ':' if (UseCapturedNS_ and self.name_nsprefix_) else ''
            self.name.export(outfile, level, namespaceprefix_, namespacedef_='', name_='name', pretty_print=pretty_print)
        for telecom_ in self.telecom:
            namespaceprefix_ = self.telecom_nsprefix_ + ':' if (UseCapturedNS_ and self.telecom_nsprefix_) else ''
            telecom_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='telecom', pretty_print=pretty_print)
    def exportJson(self, parent_dict=None, key=None, is_list=False):
        json_dict = dict()
        self.exportJsonAttributes(json_dict)
        self.exportJsonChildren(json_dict)
        return self.exportJsonResult(json_dict, parent_dict, key, is_list)
    def exportJsonResult(self, json_dict, parent_dict, key, is_list, sub_defs=[], attr_defs=[]):
        return super().exportJsonResult(json_dict, parent_dict, key, is_list, attr_defs)
    def exportJsonAttributes(self, json_dict):
        super().exportJsonAttributes(json_dict)
    def exportJsonChildren(self, json_dict):
        super().exportJsonChildren(json_dict)
        if self.name is not None:
            child_dict = self.name.exportJson(json_dict, 'name', False)
            if child_dict:
                json_dict['name'] = child_dict
        child_list = []
        for child in self.telecom:
            child_dict = child.exportJson(json_dict, 'telecom', True)
            if child_dict:
                child_list.append(child_dict)
        if child_list:
            json_dict['telecom'] = child_list
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        if SaveNodeDict:
            node_dict[node] = self 
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        super(ContactDetail, self)._buildAttributes(node, attrs, already_processed)
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'name':
            obj_ = string.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.name = obj_
            obj_.original_tagname_ = 'name'
        elif nodeName_ == 'telecom':
            obj_ = ContactPoint.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.telecom.append(obj_)
            obj_.original_tagname_ = 'telecom'
        super(ContactDetail, self)._buildChildren(child_, node, nodeName_, True)
# end class ContactDetail


class UsageContext(Element):
    """code -- A code that identifies the type of context being specified by this usage context.
    
    """
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = Element
    def __init__(self, id: 'string_primitive' = None, extension: List_['Extension'] = None, code: 'Coding' = None, valueCodeableConcept: 'CodeableConcept' = None, valueQuantity: 'Quantity' = None, valueRange: 'Range' = None, valueReference: 'Reference' = None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        super(globals().get("UsageContext"), self).__init__(id, extension,  **kwargs_)
        self.code = code
        self.code_nsprefix_ = None
        self.valueCodeableConcept = valueCodeableConcept
        self.valueCodeableConcept_nsprefix_ = None
        self.valueQuantity = valueQuantity
        self.valueQuantity_nsprefix_ = None
        self.valueRange = valueRange
        self.valueRange_nsprefix_ = None
        self.valueReference = valueReference
        self.valueReference_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, UsageContext)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if UsageContext.subclass:
            return UsageContext.subclass(*args_, **kwargs_)
        else:
            return UsageContext(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_code(self):
        return self.code
    def set_code(self, code):
        self.code = code
    def get_valueCodeableConcept(self):
        return self.valueCodeableConcept
    def set_valueCodeableConcept(self, valueCodeableConcept):
        self.valueCodeableConcept = valueCodeableConcept
    def get_valueQuantity(self):
        return self.valueQuantity
    def set_valueQuantity(self, valueQuantity):
        self.valueQuantity = valueQuantity
    def get_valueRange(self):
        return self.valueRange
    def set_valueRange(self, valueRange):
        self.valueRange = valueRange
    def get_valueReference(self):
        return self.valueReference
    def set_valueReference(self, valueReference):
        self.valueReference = valueReference
    def has__content(self):
        if (
            self.code is not None or
            self.valueCodeableConcept is not None or
            self.valueQuantity is not None or
            self.valueRange is not None or
            self.valueReference is not None or
            super(UsageContext, self).has__content()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_=' xmlns:None="http://hl7.org/fhir" ', name_='UsageContext', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('UsageContext')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'UsageContext':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='UsageContext')
        if self.has__content():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='UsageContext', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='UsageContext'):
        super(UsageContext, self)._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='UsageContext')
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_=' xmlns:None="http://hl7.org/fhir" ', name_='UsageContext', fromsubclass_=False, pretty_print=True):
        super(UsageContext, self)._exportChildren(outfile, level, namespaceprefix_, namespacedef_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.code is not None:
            namespaceprefix_ = self.code_nsprefix_ + ':' if (UseCapturedNS_ and self.code_nsprefix_) else ''
            self.code.export(outfile, level, namespaceprefix_, namespacedef_='', name_='code', pretty_print=pretty_print)
        if self.valueCodeableConcept is not None:
            namespaceprefix_ = self.valueCodeableConcept_nsprefix_ + ':' if (UseCapturedNS_ and self.valueCodeableConcept_nsprefix_) else ''
            self.valueCodeableConcept.export(outfile, level, namespaceprefix_, namespacedef_='', name_='valueCodeableConcept', pretty_print=pretty_print)
        if self.valueQuantity is not None:
            namespaceprefix_ = self.valueQuantity_nsprefix_ + ':' if (UseCapturedNS_ and self.valueQuantity_nsprefix_) else ''
            self.valueQuantity.export(outfile, level, namespaceprefix_, namespacedef_='', name_='valueQuantity', pretty_print=pretty_print)
        if self.valueRange is not None:
            namespaceprefix_ = self.valueRange_nsprefix_ + ':' if (UseCapturedNS_ and self.valueRange_nsprefix_) else ''
            self.valueRange.export(outfile, level, namespaceprefix_, namespacedef_='', name_='valueRange', pretty_print=pretty_print)
        if self.valueReference is not None:
            namespaceprefix_ = self.valueReference_nsprefix_ + ':' if (UseCapturedNS_ and self.valueReference_nsprefix_) else ''
            self.valueReference.export(outfile, level, namespaceprefix_, namespacedef_='', name_='valueReference', pretty_print=pretty_print)
    def exportJson(self, parent_dict=None, key=None, is_list=False):
        json_dict = dict()
        self.exportJsonAttributes(json_dict)
        self.exportJsonChildren(json_dict)
        return self.exportJsonResult(json_dict, parent_dict, key, is_list)
    def exportJsonResult(self, json_dict, parent_dict, key, is_list, sub_defs=[], attr_defs=[]):
        return super().exportJsonResult(json_dict, parent_dict, key, is_list, attr_defs)
    def exportJsonAttributes(self, json_dict):
        super().exportJsonAttributes(json_dict)
    def exportJsonChildren(self, json_dict):
        super().exportJsonChildren(json_dict)
        if self.code is not None:
            child_dict = self.code.exportJson(json_dict, 'code', False)
            if child_dict:
                json_dict['code'] = child_dict
        if self.valueCodeableConcept is not None:
            child_dict = self.valueCodeableConcept.exportJson(json_dict, 'valueCodeableConcept', False)
            if child_dict:
                json_dict['valueCodeableConcept'] = child_dict
        if self.valueQuantity is not None:
            child_dict = self.valueQuantity.exportJson(json_dict, 'valueQuantity', False)
            if child_dict:
                json_dict['valueQuantity'] = child_dict
        if self.valueRange is not None:
            child_dict = self.valueRange.exportJson(json_dict, 'valueRange', False)
            if child_dict:
                json_dict['valueRange'] = child_dict
        if self.valueReference is not None:
            child_dict = self.valueReference.exportJson(json_dict, 'valueReference', False)
            if child_dict:
                json_dict['valueReference'] = child_dict
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        if SaveNodeDict:
            node_dict[node] = self 
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        super(UsageContext, self)._buildAttributes(node, attrs, already_processed)
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'code':
            obj_ = Coding.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.code = obj_
            obj_.original_tagname_ = 'code'
        elif nodeName_ == 'valueCodeableConcept':
            obj_ = CodeableConcept.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.valueCodeableConcept = obj_
            obj_.original_tagname_ = 'valueCodeableConcept'
        elif nodeName_ == 'valueQuantity':
            class_obj_ = self.get_class_obj_(child_, Quantity)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.valueQuantity = obj_
            obj_.original_tagname_ = 'valueQuantity'
        elif nodeName_ == 'valueRange':
            obj_ = Range.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.valueRange = obj_
            obj_.original_tagname_ = 'valueRange'
        elif nodeName_ == 'valueReference':
            obj_ = Reference.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.valueReference = obj_
            obj_.original_tagname_ = 'valueReference'
        super(UsageContext, self)._buildChildren(child_, node, nodeName_, True)
# end class UsageContext


class Expression(Element):
    """description -- A brief, natural language description of the condition that effectively communicates the intended semantics.
    name -- A short name assigned to the expression to allow for multiple reuse of the expression in the context where it is defined.
    language -- The media type of the language for the expression.
    expression -- An expression in the specified language that returns a value.
    reference -- A URI that defines where the expression is found.
    
    """
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = Element
    def __init__(self, id: 'string_primitive' = None, extension: List_['Extension'] = None, description: 'string' = None, name: 'id' = None, language: 'ExpressionLanguage' = None, expression: 'string' = None, reference: 'uri' = None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        super(globals().get("Expression"), self).__init__(id, extension,  **kwargs_)
        self.description = description
        self.description_nsprefix_ = None
        self.name = name
        self.name_nsprefix_ = None
        self.language = language
        self.language_nsprefix_ = None
        self.expression = expression
        self.expression_nsprefix_ = None
        self.reference = reference
        self.reference_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, Expression)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if Expression.subclass:
            return Expression.subclass(*args_, **kwargs_)
        else:
            return Expression(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_description(self):
        return self.description
    def set_description(self, description):
        self.description = description
    def get_name(self):
        return self.name
    def set_name(self, name):
        self.name = name
    def get_language(self):
        return self.language
    def set_language(self, language):
        self.language = language
    def get_expression(self):
        return self.expression
    def set_expression(self, expression):
        self.expression = expression
    def get_reference(self):
        return self.reference
    def set_reference(self, reference):
        self.reference = reference
    def has__content(self):
        if (
            self.description is not None or
            self.name is not None or
            self.language is not None or
            self.expression is not None or
            self.reference is not None or
            super(Expression, self).has__content()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_=' xmlns:None="http://hl7.org/fhir" ', name_='Expression', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('Expression')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'Expression':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='Expression')
        if self.has__content():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='Expression', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='Expression'):
        super(Expression, self)._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='Expression')
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_=' xmlns:None="http://hl7.org/fhir" ', name_='Expression', fromsubclass_=False, pretty_print=True):
        super(Expression, self)._exportChildren(outfile, level, namespaceprefix_, namespacedef_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.description is not None:
            namespaceprefix_ = self.description_nsprefix_ + ':' if (UseCapturedNS_ and self.description_nsprefix_) else ''
            self.description.export(outfile, level, namespaceprefix_, namespacedef_='', name_='description', pretty_print=pretty_print)
        if self.name is not None:
            namespaceprefix_ = self.name_nsprefix_ + ':' if (UseCapturedNS_ and self.name_nsprefix_) else ''
            self.name.export(outfile, level, namespaceprefix_, namespacedef_='', name_='name', pretty_print=pretty_print)
        if self.language is not None:
            namespaceprefix_ = self.language_nsprefix_ + ':' if (UseCapturedNS_ and self.language_nsprefix_) else ''
            self.language.export(outfile, level, namespaceprefix_, namespacedef_='', name_='language', pretty_print=pretty_print)
        if self.expression is not None:
            namespaceprefix_ = self.expression_nsprefix_ + ':' if (UseCapturedNS_ and self.expression_nsprefix_) else ''
            self.expression.export(outfile, level, namespaceprefix_, namespacedef_='', name_='expression', pretty_print=pretty_print)
        if self.reference is not None:
            namespaceprefix_ = self.reference_nsprefix_ + ':' if (UseCapturedNS_ and self.reference_nsprefix_) else ''
            self.reference.export(outfile, level, namespaceprefix_, namespacedef_='', name_='reference', pretty_print=pretty_print)
    def exportJson(self, parent_dict=None, key=None, is_list=False):
        json_dict = dict()
        self.exportJsonAttributes(json_dict)
        self.exportJsonChildren(json_dict)
        return self.exportJsonResult(json_dict, parent_dict, key, is_list)
    def exportJsonResult(self, json_dict, parent_dict, key, is_list, sub_defs=[], attr_defs=[]):
        return super().exportJsonResult(json_dict, parent_dict, key, is_list, attr_defs)
    def exportJsonAttributes(self, json_dict):
        super().exportJsonAttributes(json_dict)
    def exportJsonChildren(self, json_dict):
        super().exportJsonChildren(json_dict)
        if self.description is not None:
            child_dict = self.description.exportJson(json_dict, 'description', False)
            if child_dict:
                json_dict['description'] = child_dict
        if self.name is not None:
            child_dict = self.name.exportJson(json_dict, 'name', False)
            if child_dict:
                json_dict['name'] = child_dict
        if self.language is not None:
            child_dict = self.language.exportJson(json_dict, 'language', False)
            if child_dict:
                json_dict['language'] = child_dict
        if self.expression is not None:
            child_dict = self.expression.exportJson(json_dict, 'expression', False)
            if child_dict:
                json_dict['expression'] = child_dict
        if self.reference is not None:
            child_dict = self.reference.exportJson(json_dict, 'reference', False)
            if child_dict:
                json_dict['reference'] = child_dict
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        if SaveNodeDict:
            node_dict[node] = self 
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        super(Expression, self)._buildAttributes(node, attrs, already_processed)
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'description':
            obj_ = string.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.description = obj_
            obj_.original_tagname_ = 'description'
        elif nodeName_ == 'name':
            obj_ = id.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.name = obj_
            obj_.original_tagname_ = 'name'
        elif nodeName_ == 'language':
            obj_ = ExpressionLanguage.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.language = obj_
            obj_.original_tagname_ = 'language'
        elif nodeName_ == 'expression':
            obj_ = string.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.expression = obj_
            obj_.original_tagname_ = 'expression'
        elif nodeName_ == 'reference':
            obj_ = uri.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.reference = obj_
            obj_.original_tagname_ = 'reference'
        super(Expression, self)._buildChildren(child_, node, nodeName_, True)
# end class Expression


class ExpressionLanguage(Element):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = Element
    def __init__(self, id: 'string_primitive' = None, extension: List_['Extension'] = None, value: 'ExpressionLanguageEnum' = None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        super(globals().get("ExpressionLanguage"), self).__init__(id, extension,  **kwargs_)
        self.value = _cast(None, value)
        self.value_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ExpressionLanguage)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ExpressionLanguage.subclass:
            return ExpressionLanguage.subclass(*args_, **kwargs_)
        else:
            return ExpressionLanguage(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_value(self):
        return self.value
    def set_value(self, value):
        self.value = value
    def validate_ExpressionLanguageEnum(self, value):
        # Validate type ExpressionLanguageEnum, a restriction on code-primitive.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['text/cql', 'text/fhirpath', 'application/x-fhir-query', 'text/cql-identifier', 'text/cql-expression']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on ExpressionLanguageEnum' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
            if len(value) < 1:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd minLength restriction on ExpressionLanguageEnum' % {"value" : value, "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_ExpressionLanguageEnum_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_ExpressionLanguageEnum_patterns_, ))
    validate_ExpressionLanguageEnum_patterns_ = [['^([^\\s]+(\\s[^\\s]+)*)$']]
    def has__content(self):
        if (
            super(ExpressionLanguage, self).has__content()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='ExpressionLanguage', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('ExpressionLanguage')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'ExpressionLanguage':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='ExpressionLanguage')
        if self.has__content():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='ExpressionLanguage', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='ExpressionLanguage'):
        super(ExpressionLanguage, self)._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='ExpressionLanguage')
        if self.value is not None and 'value' not in already_processed:
            already_processed.add('value')
            outfile.write(' value=%s' % (quote_attrib(self.value), ))
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='ExpressionLanguage', fromsubclass_=False, pretty_print=True):
        super(ExpressionLanguage, self)._exportChildren(outfile, level, namespaceprefix_, namespacedef_, name_, True, pretty_print=pretty_print)
    def exportJson(self, parent_dict=None, key=None, is_list=False):
        json_dict = dict()
        self.exportJsonAttributes(json_dict)
        self.exportJsonChildren(json_dict)
        return self.exportJsonResult(json_dict, parent_dict, key, is_list)
    def exportJsonResult(self, json_dict, parent_dict, key, is_list, sub_defs=[], attr_defs=['value']):
        return super().exportJsonResult(json_dict, parent_dict, key, is_list, attr_defs)
    def exportJsonAttributes(self, json_dict):
        super().exportJsonAttributes(json_dict)
        if self.value is not None:
            json_dict['value'] = self.value
    def exportJsonChildren(self, json_dict):
        super().exportJsonChildren(json_dict)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        if SaveNodeDict:
            node_dict[node] = self 
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('value', node)
        if value is not None and 'value' not in already_processed:
            already_processed.add('value')
            self.value = value
            self.value = ' '.join(self.value.split())
            self.validate_ExpressionLanguageEnum(self.value)    # validate type ExpressionLanguageEnum
        super(ExpressionLanguage, self)._buildAttributes(node, attrs, already_processed)
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        super(ExpressionLanguage, self)._buildChildren(child_, node, nodeName_, True)
        pass
# end class ExpressionLanguage


class CodeableReference(Element):
    """concept -- A reference to a concept - e.g. the information is identified by its general class to the degree of precision found in the terminology.
    reference -- A reference to a resource the provides exact details about the information being referenced.
    
    """
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = Element
    def __init__(self, id: 'string_primitive' = None, extension: List_['Extension'] = None, concept: 'CodeableConcept' = None, reference: 'Reference' = None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        super(globals().get("CodeableReference"), self).__init__(id, extension,  **kwargs_)
        self.concept = concept
        self.concept_nsprefix_ = None
        self.reference = reference
        self.reference_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, CodeableReference)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if CodeableReference.subclass:
            return CodeableReference.subclass(*args_, **kwargs_)
        else:
            return CodeableReference(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_concept(self):
        return self.concept
    def set_concept(self, concept):
        self.concept = concept
    def get_reference(self):
        return self.reference
    def set_reference(self, reference):
        self.reference = reference
    def has__content(self):
        if (
            self.concept is not None or
            self.reference is not None or
            super(CodeableReference, self).has__content()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_=' xmlns:None="http://hl7.org/fhir" ', name_='CodeableReference', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('CodeableReference')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'CodeableReference':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='CodeableReference')
        if self.has__content():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='CodeableReference', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='CodeableReference'):
        super(CodeableReference, self)._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='CodeableReference')
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_=' xmlns:None="http://hl7.org/fhir" ', name_='CodeableReference', fromsubclass_=False, pretty_print=True):
        super(CodeableReference, self)._exportChildren(outfile, level, namespaceprefix_, namespacedef_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.concept is not None:
            namespaceprefix_ = self.concept_nsprefix_ + ':' if (UseCapturedNS_ and self.concept_nsprefix_) else ''
            self.concept.export(outfile, level, namespaceprefix_, namespacedef_='', name_='concept', pretty_print=pretty_print)
        if self.reference is not None:
            namespaceprefix_ = self.reference_nsprefix_ + ':' if (UseCapturedNS_ and self.reference_nsprefix_) else ''
            self.reference.export(outfile, level, namespaceprefix_, namespacedef_='', name_='reference', pretty_print=pretty_print)
    def exportJson(self, parent_dict=None, key=None, is_list=False):
        json_dict = dict()
        self.exportJsonAttributes(json_dict)
        self.exportJsonChildren(json_dict)
        return self.exportJsonResult(json_dict, parent_dict, key, is_list)
    def exportJsonResult(self, json_dict, parent_dict, key, is_list, sub_defs=[], attr_defs=[]):
        return super().exportJsonResult(json_dict, parent_dict, key, is_list, attr_defs)
    def exportJsonAttributes(self, json_dict):
        super().exportJsonAttributes(json_dict)
    def exportJsonChildren(self, json_dict):
        super().exportJsonChildren(json_dict)
        if self.concept is not None:
            child_dict = self.concept.exportJson(json_dict, 'concept', False)
            if child_dict:
                json_dict['concept'] = child_dict
        if self.reference is not None:
            child_dict = self.reference.exportJson(json_dict, 'reference', False)
            if child_dict:
                json_dict['reference'] = child_dict
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        if SaveNodeDict:
            node_dict[node] = self 
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        super(CodeableReference, self)._buildAttributes(node, attrs, already_processed)
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'concept':
            obj_ = CodeableConcept.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.concept = obj_
            obj_.original_tagname_ = 'concept'
        elif nodeName_ == 'reference':
            obj_ = Reference.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.reference = obj_
            obj_.original_tagname_ = 'reference'
        super(CodeableReference, self)._buildChildren(child_, node, nodeName_, True)
# end class CodeableReference


class Signature(Element):
    """type -- An indication of the reason that the entity signed this document. This may be explicitly included as part of the signature information and can be used when determining accountability for various actions concerning the document.
    when -- When the digital signature was signed.
    who -- A reference to an application-usable description of the identity that signed  (e.g. the signature used their private key).
    onBehalfOf -- A reference to an application-usable description of the identity that is represented by the signature.
    targetFormat -- A mime type that indicates the technical format of the target resources signed by the signature.
    sigFormat -- A mime type that indicates the technical format of the signature. Important mime types are application/signature+xml for X ML DigSig, application/jose for JWS, and image/* for a graphical image of a signature, etc.
    data -- The base64 encoding of the Signature content. When signature is not recorded electronically this element would be empty.
    
    """
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = Element
    def __init__(self, id: 'string_primitive' = None, extension: List_['Extension'] = None, type_: List_['Coding'] = None, when: 'instant' = None, who: 'Reference' = None, onBehalfOf: 'Reference' = None, targetFormat: 'code' = None, sigFormat: 'code' = None, data: 'base64Binary' = None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        super(globals().get("Signature"), self).__init__(id, extension,  **kwargs_)
        if type_ is None:
            self.type_ = []
        else:
            self.type_ = type_
        self.type__nsprefix_ = None
        self.when = when
        self.when_nsprefix_ = None
        self.who = who
        self.who_nsprefix_ = None
        self.onBehalfOf = onBehalfOf
        self.onBehalfOf_nsprefix_ = None
        self.targetFormat = targetFormat
        self.targetFormat_nsprefix_ = None
        self.sigFormat = sigFormat
        self.sigFormat_nsprefix_ = None
        self.data = data
        self.data_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, Signature)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if Signature.subclass:
            return Signature.subclass(*args_, **kwargs_)
        else:
            return Signature(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_type(self):
        return self.type_
    def set_type(self, type_):
        self.type_ = type_
    def add_type(self, value):
        self.type_.append(value)
    def insert_type_at(self, index, value):
        self.type_.insert(index, value)
    def replace_type_at(self, index, value):
        self.type_[index] = value
    def get_when(self):
        return self.when
    def set_when(self, when):
        self.when = when
    def get_who(self):
        return self.who
    def set_who(self, who):
        self.who = who
    def get_onBehalfOf(self):
        return self.onBehalfOf
    def set_onBehalfOf(self, onBehalfOf):
        self.onBehalfOf = onBehalfOf
    def get_targetFormat(self):
        return self.targetFormat
    def set_targetFormat(self, targetFormat):
        self.targetFormat = targetFormat
    def get_sigFormat(self):
        return self.sigFormat
    def set_sigFormat(self, sigFormat):
        self.sigFormat = sigFormat
    def get_data(self):
        return self.data
    def set_data(self, data):
        self.data = data
    def has__content(self):
        if (
            self.type_ or
            self.when is not None or
            self.who is not None or
            self.onBehalfOf is not None or
            self.targetFormat is not None or
            self.sigFormat is not None or
            self.data is not None or
            super(Signature, self).has__content()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_=' xmlns:None="http://hl7.org/fhir" ', name_='Signature', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('Signature')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'Signature':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='Signature')
        if self.has__content():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='Signature', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='Signature'):
        super(Signature, self)._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='Signature')
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_=' xmlns:None="http://hl7.org/fhir" ', name_='Signature', fromsubclass_=False, pretty_print=True):
        super(Signature, self)._exportChildren(outfile, level, namespaceprefix_, namespacedef_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for type_ in self.type_:
            namespaceprefix_ = self.type__nsprefix_ + ':' if (UseCapturedNS_ and self.type__nsprefix_) else ''
            type_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='type', pretty_print=pretty_print)
        if self.when is not None:
            namespaceprefix_ = self.when_nsprefix_ + ':' if (UseCapturedNS_ and self.when_nsprefix_) else ''
            self.when.export(outfile, level, namespaceprefix_, namespacedef_='', name_='when', pretty_print=pretty_print)
        if self.who is not None:
            namespaceprefix_ = self.who_nsprefix_ + ':' if (UseCapturedNS_ and self.who_nsprefix_) else ''
            self.who.export(outfile, level, namespaceprefix_, namespacedef_='', name_='who', pretty_print=pretty_print)
        if self.onBehalfOf is not None:
            namespaceprefix_ = self.onBehalfOf_nsprefix_ + ':' if (UseCapturedNS_ and self.onBehalfOf_nsprefix_) else ''
            self.onBehalfOf.export(outfile, level, namespaceprefix_, namespacedef_='', name_='onBehalfOf', pretty_print=pretty_print)
        if self.targetFormat is not None:
            namespaceprefix_ = self.targetFormat_nsprefix_ + ':' if (UseCapturedNS_ and self.targetFormat_nsprefix_) else ''
            self.targetFormat.export(outfile, level, namespaceprefix_, namespacedef_='', name_='targetFormat', pretty_print=pretty_print)
        if self.sigFormat is not None:
            namespaceprefix_ = self.sigFormat_nsprefix_ + ':' if (UseCapturedNS_ and self.sigFormat_nsprefix_) else ''
            self.sigFormat.export(outfile, level, namespaceprefix_, namespacedef_='', name_='sigFormat', pretty_print=pretty_print)
        if self.data is not None:
            namespaceprefix_ = self.data_nsprefix_ + ':' if (UseCapturedNS_ and self.data_nsprefix_) else ''
            self.data.export(outfile, level, namespaceprefix_, namespacedef_='', name_='data', pretty_print=pretty_print)
    def exportJson(self, parent_dict=None, key=None, is_list=False):
        json_dict = dict()
        self.exportJsonAttributes(json_dict)
        self.exportJsonChildren(json_dict)
        return self.exportJsonResult(json_dict, parent_dict, key, is_list)
    def exportJsonResult(self, json_dict, parent_dict, key, is_list, sub_defs=[], attr_defs=[]):
        return super().exportJsonResult(json_dict, parent_dict, key, is_list, attr_defs)
    def exportJsonAttributes(self, json_dict):
        super().exportJsonAttributes(json_dict)
    def exportJsonChildren(self, json_dict):
        super().exportJsonChildren(json_dict)
        child_list = []
        for child in self.type_:
            child_dict = child.exportJson(json_dict, 'type', True)
            if child_dict:
                child_list.append(child_dict)
        if child_list:
            json_dict['type'] = child_list
        if self.when is not None:
            child_dict = self.when.exportJson(json_dict, 'when', False)
            if child_dict:
                json_dict['when'] = child_dict
        if self.who is not None:
            child_dict = self.who.exportJson(json_dict, 'who', False)
            if child_dict:
                json_dict['who'] = child_dict
        if self.onBehalfOf is not None:
            child_dict = self.onBehalfOf.exportJson(json_dict, 'onBehalfOf', False)
            if child_dict:
                json_dict['onBehalfOf'] = child_dict
        if self.targetFormat is not None:
            child_dict = self.targetFormat.exportJson(json_dict, 'targetFormat', False)
            if child_dict:
                json_dict['targetFormat'] = child_dict
        if self.sigFormat is not None:
            child_dict = self.sigFormat.exportJson(json_dict, 'sigFormat', False)
            if child_dict:
                json_dict['sigFormat'] = child_dict
        if self.data is not None:
            child_dict = self.data.exportJson(json_dict, 'data', False)
            if child_dict:
                json_dict['data'] = child_dict
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        if SaveNodeDict:
            node_dict[node] = self 
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        super(Signature, self)._buildAttributes(node, attrs, already_processed)
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'type':
            obj_ = Coding.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.type_.append(obj_)
            obj_.original_tagname_ = 'type'
        elif nodeName_ == 'when':
            obj_ = instant.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.when = obj_
            obj_.original_tagname_ = 'when'
        elif nodeName_ == 'who':
            obj_ = Reference.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.who = obj_
            obj_.original_tagname_ = 'who'
        elif nodeName_ == 'onBehalfOf':
            obj_ = Reference.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.onBehalfOf = obj_
            obj_.original_tagname_ = 'onBehalfOf'
        elif nodeName_ == 'targetFormat':
            obj_ = code.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.targetFormat = obj_
            obj_.original_tagname_ = 'targetFormat'
        elif nodeName_ == 'sigFormat':
            obj_ = code.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.sigFormat = obj_
            obj_.original_tagname_ = 'sigFormat'
        elif nodeName_ == 'data':
            obj_ = base64Binary.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.data = obj_
            obj_.original_tagname_ = 'data'
        super(Signature, self)._buildChildren(child_, node, nodeName_, True)
# end class Signature


class UnitsOfTime(Element):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = Element
    def __init__(self, id: 'string_primitive' = None, extension: List_['Extension'] = None, value: 'UnitsOfTimeEnum' = None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        super(globals().get("UnitsOfTime"), self).__init__(id, extension,  **kwargs_)
        self.value = _cast(None, value)
        self.value_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, UnitsOfTime)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if UnitsOfTime.subclass:
            return UnitsOfTime.subclass(*args_, **kwargs_)
        else:
            return UnitsOfTime(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_value(self):
        return self.value
    def set_value(self, value):
        self.value = value
    def validate_UnitsOfTimeEnum(self, value):
        # Validate type UnitsOfTimeEnum, a restriction on code-primitive.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['s', 'min', 'h', 'd', 'wk', 'mo', 'a']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on UnitsOfTimeEnum' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
            if len(value) < 1:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd minLength restriction on UnitsOfTimeEnum' % {"value" : value, "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_UnitsOfTimeEnum_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_UnitsOfTimeEnum_patterns_, ))
    validate_UnitsOfTimeEnum_patterns_ = [['^([^\\s]+(\\s[^\\s]+)*)$']]
    def has__content(self):
        if (
            super(UnitsOfTime, self).has__content()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='UnitsOfTime', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('UnitsOfTime')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'UnitsOfTime':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='UnitsOfTime')
        if self.has__content():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='UnitsOfTime', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='UnitsOfTime'):
        super(UnitsOfTime, self)._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='UnitsOfTime')
        if self.value is not None and 'value' not in already_processed:
            already_processed.add('value')
            outfile.write(' value=%s' % (quote_attrib(self.value), ))
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='UnitsOfTime', fromsubclass_=False, pretty_print=True):
        super(UnitsOfTime, self)._exportChildren(outfile, level, namespaceprefix_, namespacedef_, name_, True, pretty_print=pretty_print)
    def exportJson(self, parent_dict=None, key=None, is_list=False):
        json_dict = dict()
        self.exportJsonAttributes(json_dict)
        self.exportJsonChildren(json_dict)
        return self.exportJsonResult(json_dict, parent_dict, key, is_list)
    def exportJsonResult(self, json_dict, parent_dict, key, is_list, sub_defs=[], attr_defs=['value']):
        return super().exportJsonResult(json_dict, parent_dict, key, is_list, attr_defs)
    def exportJsonAttributes(self, json_dict):
        super().exportJsonAttributes(json_dict)
        if self.value is not None:
            json_dict['value'] = self.value
    def exportJsonChildren(self, json_dict):
        super().exportJsonChildren(json_dict)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        if SaveNodeDict:
            node_dict[node] = self 
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('value', node)
        if value is not None and 'value' not in already_processed:
            already_processed.add('value')
            self.value = value
            self.value = ' '.join(self.value.split())
            self.validate_UnitsOfTimeEnum(self.value)    # validate type UnitsOfTimeEnum
        super(UnitsOfTime, self)._buildAttributes(node, attrs, already_processed)
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        super(UnitsOfTime, self)._buildChildren(child_, node, nodeName_, True)
        pass
# end class UnitsOfTime


class EventTiming(Element):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = Element
    def __init__(self, id: 'string_primitive' = None, extension: List_['Extension'] = None, value: 'EventTimingEnum' = None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        super(globals().get("EventTiming"), self).__init__(id, extension,  **kwargs_)
        self.value = _cast(None, value)
        self.value_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, EventTiming)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if EventTiming.subclass:
            return EventTiming.subclass(*args_, **kwargs_)
        else:
            return EventTiming(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_value(self):
        return self.value
    def set_value(self, value):
        self.value = value
    def validate_EventTimingEnum(self, value):
        # Validate type EventTimingEnum, a restriction on code-primitive.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['MORN', 'MORN.early', 'MORN.late', 'NOON', 'AFT', 'AFT.early', 'AFT.late', 'EVE', 'EVE.early', 'EVE.late', 'NIGHT', 'PHS', 'HS', 'WAKE', 'C', 'CM', 'CD', 'CV', 'AC', 'ACM', 'ACD', 'ACV', 'PC', 'PCM', 'PCD', 'PCV']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on EventTimingEnum' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
            if len(value) < 1:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd minLength restriction on EventTimingEnum' % {"value" : value, "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_EventTimingEnum_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_EventTimingEnum_patterns_, ))
    validate_EventTimingEnum_patterns_ = [['^([^\\s]+(\\s[^\\s]+)*)$']]
    def has__content(self):
        if (
            super(EventTiming, self).has__content()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='EventTiming', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('EventTiming')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'EventTiming':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='EventTiming')
        if self.has__content():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='EventTiming', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='EventTiming'):
        super(EventTiming, self)._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='EventTiming')
        if self.value is not None and 'value' not in already_processed:
            already_processed.add('value')
            outfile.write(' value=%s' % (quote_attrib(self.value), ))
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='EventTiming', fromsubclass_=False, pretty_print=True):
        super(EventTiming, self)._exportChildren(outfile, level, namespaceprefix_, namespacedef_, name_, True, pretty_print=pretty_print)
    def exportJson(self, parent_dict=None, key=None, is_list=False):
        json_dict = dict()
        self.exportJsonAttributes(json_dict)
        self.exportJsonChildren(json_dict)
        return self.exportJsonResult(json_dict, parent_dict, key, is_list)
    def exportJsonResult(self, json_dict, parent_dict, key, is_list, sub_defs=[], attr_defs=['value']):
        return super().exportJsonResult(json_dict, parent_dict, key, is_list, attr_defs)
    def exportJsonAttributes(self, json_dict):
        super().exportJsonAttributes(json_dict)
        if self.value is not None:
            json_dict['value'] = self.value
    def exportJsonChildren(self, json_dict):
        super().exportJsonChildren(json_dict)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        if SaveNodeDict:
            node_dict[node] = self 
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('value', node)
        if value is not None and 'value' not in already_processed:
            already_processed.add('value')
            self.value = value
            self.value = ' '.join(self.value.split())
            self.validate_EventTimingEnum(self.value)    # validate type EventTimingEnum
        super(EventTiming, self)._buildAttributes(node, attrs, already_processed)
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        super(EventTiming, self)._buildChildren(child_, node, nodeName_, True)
        pass
# end class EventTiming


class CodeableConcept(Element):
    """coding -- A reference to a code defined by a terminology system.
    text -- A human language representation of the concept as seen/selected/uttered by the user who entered the data and/or which represents the intended meaning of the user.
    
    """
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = Element
    def __init__(self, id: 'string_primitive' = None, extension: List_['Extension'] = None, coding: List_['Coding'] = None, text: 'string' = None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        super(globals().get("CodeableConcept"), self).__init__(id, extension,  **kwargs_)
        if coding is None:
            self.coding = []
        else:
            self.coding = coding
        self.coding_nsprefix_ = None
        self.text = text
        self.text_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, CodeableConcept)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if CodeableConcept.subclass:
            return CodeableConcept.subclass(*args_, **kwargs_)
        else:
            return CodeableConcept(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_coding(self):
        return self.coding
    def set_coding(self, coding):
        self.coding = coding
    def add_coding(self, value):
        self.coding.append(value)
    def insert_coding_at(self, index, value):
        self.coding.insert(index, value)
    def replace_coding_at(self, index, value):
        self.coding[index] = value
    def get_text(self):
        return self.text
    def set_text(self, text):
        self.text = text
    def has__content(self):
        if (
            self.coding or
            self.text is not None or
            super(CodeableConcept, self).has__content()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_=' xmlns:None="http://hl7.org/fhir" ', name_='CodeableConcept', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('CodeableConcept')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'CodeableConcept':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='CodeableConcept')
        if self.has__content():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='CodeableConcept', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='CodeableConcept'):
        super(CodeableConcept, self)._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='CodeableConcept')
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_=' xmlns:None="http://hl7.org/fhir" ', name_='CodeableConcept', fromsubclass_=False, pretty_print=True):
        super(CodeableConcept, self)._exportChildren(outfile, level, namespaceprefix_, namespacedef_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for coding_ in self.coding:
            namespaceprefix_ = self.coding_nsprefix_ + ':' if (UseCapturedNS_ and self.coding_nsprefix_) else ''
            coding_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='coding', pretty_print=pretty_print)
        if self.text is not None:
            namespaceprefix_ = self.text_nsprefix_ + ':' if (UseCapturedNS_ and self.text_nsprefix_) else ''
            self.text.export(outfile, level, namespaceprefix_, namespacedef_='', name_='text', pretty_print=pretty_print)
    def exportJson(self, parent_dict=None, key=None, is_list=False):
        json_dict = dict()
        self.exportJsonAttributes(json_dict)
        self.exportJsonChildren(json_dict)
        return self.exportJsonResult(json_dict, parent_dict, key, is_list)
    def exportJsonResult(self, json_dict, parent_dict, key, is_list, sub_defs=[], attr_defs=[]):
        return super().exportJsonResult(json_dict, parent_dict, key, is_list, attr_defs)
    def exportJsonAttributes(self, json_dict):
        super().exportJsonAttributes(json_dict)
    def exportJsonChildren(self, json_dict):
        super().exportJsonChildren(json_dict)
        child_list = []
        for child in self.coding:
            child_dict = child.exportJson(json_dict, 'coding', True)
            if child_dict:
                child_list.append(child_dict)
        if child_list:
            json_dict['coding'] = child_list
        if self.text is not None:
            child_dict = self.text.exportJson(json_dict, 'text', False)
            if child_dict:
                json_dict['text'] = child_dict
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        if SaveNodeDict:
            node_dict[node] = self 
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        super(CodeableConcept, self)._buildAttributes(node, attrs, already_processed)
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'coding':
            obj_ = Coding.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.coding.append(obj_)
            obj_.original_tagname_ = 'coding'
        elif nodeName_ == 'text':
            obj_ = string.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.text = obj_
            obj_.original_tagname_ = 'text'
        super(CodeableConcept, self)._buildChildren(child_, node, nodeName_, True)
# end class CodeableConcept


class ParameterDefinition(Element):
    """name -- The name of the parameter used to allow access to the value of the parameter in evaluation contexts.
    use -- Whether the parameter is input or output for the module.
    min -- The minimum number of times this parameter SHALL appear in the request or response.
    max -- The maximum number of times this element is permitted to appear in the request or response.
    documentation -- A brief discussion of what the parameter is for and how it is used by the module.
    type -- The type of the parameter.
    profile -- If specified, this indicates a profile that the input data must conform to, or that the output data will conform to.
    
    """
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = Element
    def __init__(self, id: 'string_primitive' = None, extension: List_['Extension'] = None, name: 'code' = None, use: 'code' = None, min: 'integer' = None, max: 'string' = None, documentation: 'string' = None, type_: 'code' = None, profile: 'canonical' = None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        super(globals().get("ParameterDefinition"), self).__init__(id, extension,  **kwargs_)
        self.name = name
        self.name_nsprefix_ = None
        self.use = use
        self.use_nsprefix_ = None
        self.min = min
        self.min_nsprefix_ = None
        self.max = max
        self.max_nsprefix_ = None
        self.documentation = documentation
        self.documentation_nsprefix_ = None
        self.type_ = type_
        self.type__nsprefix_ = None
        self.profile = profile
        self.profile_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ParameterDefinition)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ParameterDefinition.subclass:
            return ParameterDefinition.subclass(*args_, **kwargs_)
        else:
            return ParameterDefinition(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_name(self):
        return self.name
    def set_name(self, name):
        self.name = name
    def get_use(self):
        return self.use
    def set_use(self, use):
        self.use = use
    def get_min(self):
        return self.min
    def set_min(self, min):
        self.min = min
    def get_max(self):
        return self.max
    def set_max(self, max):
        self.max = max
    def get_documentation(self):
        return self.documentation
    def set_documentation(self, documentation):
        self.documentation = documentation
    def get_type(self):
        return self.type_
    def set_type(self, type_):
        self.type_ = type_
    def get_profile(self):
        return self.profile
    def set_profile(self, profile):
        self.profile = profile
    def has__content(self):
        if (
            self.name is not None or
            self.use is not None or
            self.min is not None or
            self.max is not None or
            self.documentation is not None or
            self.type_ is not None or
            self.profile is not None or
            super(ParameterDefinition, self).has__content()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_=' xmlns:None="http://hl7.org/fhir" ', name_='ParameterDefinition', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('ParameterDefinition')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'ParameterDefinition':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='ParameterDefinition')
        if self.has__content():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='ParameterDefinition', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='ParameterDefinition'):
        super(ParameterDefinition, self)._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='ParameterDefinition')
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_=' xmlns:None="http://hl7.org/fhir" ', name_='ParameterDefinition', fromsubclass_=False, pretty_print=True):
        super(ParameterDefinition, self)._exportChildren(outfile, level, namespaceprefix_, namespacedef_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.name is not None:
            namespaceprefix_ = self.name_nsprefix_ + ':' if (UseCapturedNS_ and self.name_nsprefix_) else ''
            self.name.export(outfile, level, namespaceprefix_, namespacedef_='', name_='name', pretty_print=pretty_print)
        if self.use is not None:
            namespaceprefix_ = self.use_nsprefix_ + ':' if (UseCapturedNS_ and self.use_nsprefix_) else ''
            self.use.export(outfile, level, namespaceprefix_, namespacedef_='', name_='use', pretty_print=pretty_print)
        if self.min is not None:
            namespaceprefix_ = self.min_nsprefix_ + ':' if (UseCapturedNS_ and self.min_nsprefix_) else ''
            self.min.export(outfile, level, namespaceprefix_, namespacedef_='', name_='min', pretty_print=pretty_print)
        if self.max is not None:
            namespaceprefix_ = self.max_nsprefix_ + ':' if (UseCapturedNS_ and self.max_nsprefix_) else ''
            self.max.export(outfile, level, namespaceprefix_, namespacedef_='', name_='max', pretty_print=pretty_print)
        if self.documentation is not None:
            namespaceprefix_ = self.documentation_nsprefix_ + ':' if (UseCapturedNS_ and self.documentation_nsprefix_) else ''
            self.documentation.export(outfile, level, namespaceprefix_, namespacedef_='', name_='documentation', pretty_print=pretty_print)
        if self.type_ is not None:
            namespaceprefix_ = self.type__nsprefix_ + ':' if (UseCapturedNS_ and self.type__nsprefix_) else ''
            self.type_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='type', pretty_print=pretty_print)
        if self.profile is not None:
            namespaceprefix_ = self.profile_nsprefix_ + ':' if (UseCapturedNS_ and self.profile_nsprefix_) else ''
            self.profile.export(outfile, level, namespaceprefix_, namespacedef_='', name_='profile', pretty_print=pretty_print)
    def exportJson(self, parent_dict=None, key=None, is_list=False):
        json_dict = dict()
        self.exportJsonAttributes(json_dict)
        self.exportJsonChildren(json_dict)
        return self.exportJsonResult(json_dict, parent_dict, key, is_list)
    def exportJsonResult(self, json_dict, parent_dict, key, is_list, sub_defs=[], attr_defs=[]):
        return super().exportJsonResult(json_dict, parent_dict, key, is_list, attr_defs)
    def exportJsonAttributes(self, json_dict):
        super().exportJsonAttributes(json_dict)
    def exportJsonChildren(self, json_dict):
        super().exportJsonChildren(json_dict)
        if self.name is not None:
            child_dict = self.name.exportJson(json_dict, 'name', False)
            if child_dict:
                json_dict['name'] = child_dict
        if self.use is not None:
            child_dict = self.use.exportJson(json_dict, 'use', False)
            if child_dict:
                json_dict['use'] = child_dict
        if self.min is not None:
            child_dict = self.min.exportJson(json_dict, 'min', False)
            if child_dict:
                json_dict['min'] = child_dict
        if self.max is not None:
            child_dict = self.max.exportJson(json_dict, 'max', False)
            if child_dict:
                json_dict['max'] = child_dict
        if self.documentation is not None:
            child_dict = self.documentation.exportJson(json_dict, 'documentation', False)
            if child_dict:
                json_dict['documentation'] = child_dict
        if self.type_ is not None:
            child_dict = self.type_.exportJson(json_dict, 'type', False)
            if child_dict:
                json_dict['type'] = child_dict
        if self.profile is not None:
            child_dict = self.profile.exportJson(json_dict, 'profile', False)
            if child_dict:
                json_dict['profile'] = child_dict
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        if SaveNodeDict:
            node_dict[node] = self 
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        super(ParameterDefinition, self)._buildAttributes(node, attrs, already_processed)
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'name':
            obj_ = code.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.name = obj_
            obj_.original_tagname_ = 'name'
        elif nodeName_ == 'use':
            obj_ = code.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.use = obj_
            obj_.original_tagname_ = 'use'
        elif nodeName_ == 'min':
            obj_ = integer.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.min = obj_
            obj_.original_tagname_ = 'min'
        elif nodeName_ == 'max':
            obj_ = string.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.max = obj_
            obj_.original_tagname_ = 'max'
        elif nodeName_ == 'documentation':
            obj_ = string.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.documentation = obj_
            obj_.original_tagname_ = 'documentation'
        elif nodeName_ == 'type':
            obj_ = code.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.type_ = obj_
            obj_.original_tagname_ = 'type'
        elif nodeName_ == 'profile':
            obj_ = canonical.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.profile = obj_
            obj_.original_tagname_ = 'profile'
        super(ParameterDefinition, self)._buildChildren(child_, node, nodeName_, True)
# end class ParameterDefinition


class Resource(GeneratedsSuper):
    """id -- The logical id of the resource, as used in the URL for the resource. Once assigned, this value never changes.
    meta -- The metadata about the resource. This is content that is maintained by the infrastructure. Changes to the content might not always be associated with version changes to the resource.
    implicitRules -- A reference to a set of rules that were followed when the resource was constructed, and which must be understood when processing the content. Often, this is a reference to an implementation guide that defines the special rules along with other profiles etc.
    language -- The base language in which the resource is written.
    
    """
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, id: 'string' = None, meta: 'Meta' = None, implicitRules: 'uri' = None, language: 'code' = None, extensiontype_=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.id = id
        self.id_nsprefix_ = None
        self.meta = meta
        self.meta_nsprefix_ = None
        self.implicitRules = implicitRules
        self.implicitRules_nsprefix_ = None
        self.language = language
        self.language_nsprefix_ = None
        self.extensiontype_ = extensiontype_
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, Resource)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if Resource.subclass:
            return Resource.subclass(*args_, **kwargs_)
        else:
            return Resource(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_id(self):
        return self.id
    def set_id(self, id):
        self.id = id
    def get_meta(self):
        return self.meta
    def set_meta(self, meta):
        self.meta = meta
    def get_implicitRules(self):
        return self.implicitRules
    def set_implicitRules(self, implicitRules):
        self.implicitRules = implicitRules
    def get_language(self):
        return self.language
    def set_language(self, language):
        self.language = language
    def get_extensiontype_(self): return self.extensiontype_
    def set_extensiontype_(self, extensiontype_): self.extensiontype_ = extensiontype_
    def has__content(self):
        if (
            self.id is not None or
            self.meta is not None or
            self.implicitRules is not None or
            self.language is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_=' xmlns:None="http://hl7.org/fhir" ', name_='Resource', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('Resource')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'Resource':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='Resource')
        if self.has__content():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='Resource', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='Resource'):
        if self.extensiontype_ is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            outfile.write(' xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"')
            if ":" not in self.extensiontype_:
                imported_ns_type_prefix_ = GenerateDSNamespaceTypePrefixes_.get(self.extensiontype_, '')
                outfile.write(' xsi:type="%s%s"' % (imported_ns_type_prefix_, self.extensiontype_))
            else:
                outfile.write(' xsi:type="%s"' % self.extensiontype_)
        pass
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_=' xmlns:None="http://hl7.org/fhir" ', name_='Resource', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.id is not None:
            namespaceprefix_ = self.id_nsprefix_ + ':' if (UseCapturedNS_ and self.id_nsprefix_) else ''
            self.id.export(outfile, level, namespaceprefix_, namespacedef_='', name_='id', pretty_print=pretty_print)
        if self.meta is not None:
            namespaceprefix_ = self.meta_nsprefix_ + ':' if (UseCapturedNS_ and self.meta_nsprefix_) else ''
            self.meta.export(outfile, level, namespaceprefix_, namespacedef_='', name_='meta', pretty_print=pretty_print)
        if self.implicitRules is not None:
            namespaceprefix_ = self.implicitRules_nsprefix_ + ':' if (UseCapturedNS_ and self.implicitRules_nsprefix_) else ''
            self.implicitRules.export(outfile, level, namespaceprefix_, namespacedef_='', name_='implicitRules', pretty_print=pretty_print)
        if self.language is not None:
            namespaceprefix_ = self.language_nsprefix_ + ':' if (UseCapturedNS_ and self.language_nsprefix_) else ''
            self.language.export(outfile, level, namespaceprefix_, namespacedef_='', name_='language', pretty_print=pretty_print)
    def exportJson(self, parent_dict=None, key=None, is_list=False):
        json_dict = dict()
        self.exportJsonAttributes(json_dict)
        self.exportJsonChildren(json_dict)
        return self.exportJsonResult(json_dict, parent_dict, key, is_list)
    def exportJsonResult(self, json_dict, parent_dict, key, is_list, sub_defs=[], attr_defs=[]):
        return json_dict
    def exportJsonAttributes(self, json_dict):
        pass
    def exportJsonChildren(self, json_dict):
        if self.id is not None:
            child_dict = self.id.exportJson(json_dict, 'id', False)
            if child_dict:
                json_dict['id'] = child_dict
        if self.meta is not None:
            child_dict = self.meta.exportJson(json_dict, 'meta', False)
            if child_dict:
                json_dict['meta'] = child_dict
        if self.implicitRules is not None:
            child_dict = self.implicitRules.exportJson(json_dict, 'implicitRules', False)
            if child_dict:
                json_dict['implicitRules'] = child_dict
        if self.language is not None:
            child_dict = self.language.exportJson(json_dict, 'language', False)
            if child_dict:
                json_dict['language'] = child_dict
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        if SaveNodeDict:
            node_dict[node] = self 
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('xsi:type', node)
        if value is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            self.extensiontype_ = value
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'id':
            obj_ = string.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.id = obj_
            obj_.original_tagname_ = 'id'
        elif nodeName_ == 'meta':
            obj_ = Meta.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.meta = obj_
            obj_.original_tagname_ = 'meta'
        elif nodeName_ == 'implicitRules':
            obj_ = uri.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.implicitRules = obj_
            obj_.original_tagname_ = 'implicitRules'
        elif nodeName_ == 'language':
            obj_ = code.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.language = obj_
            obj_.original_tagname_ = 'language'
# end class Resource


class AccountStatus(Element):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = Element
    def __init__(self, id: 'string_primitive' = None, extension: List_['Extension'] = None, value: 'AccountStatusEnum' = None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        super(globals().get("AccountStatus"), self).__init__(id, extension,  **kwargs_)
        self.value = _cast(None, value)
        self.value_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, AccountStatus)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if AccountStatus.subclass:
            return AccountStatus.subclass(*args_, **kwargs_)
        else:
            return AccountStatus(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_value(self):
        return self.value
    def set_value(self, value):
        self.value = value
    def validate_AccountStatusEnum(self, value):
        # Validate type AccountStatusEnum, a restriction on code-primitive.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['active', 'inactive', 'entered-in-error', 'on-hold', 'unknown']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on AccountStatusEnum' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
            if len(value) < 1:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd minLength restriction on AccountStatusEnum' % {"value" : value, "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_AccountStatusEnum_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_AccountStatusEnum_patterns_, ))
    validate_AccountStatusEnum_patterns_ = [['^([^\\s]+(\\s[^\\s]+)*)$']]
    def has__content(self):
        if (
            super(AccountStatus, self).has__content()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='AccountStatus', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('AccountStatus')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'AccountStatus':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='AccountStatus')
        if self.has__content():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='AccountStatus', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='AccountStatus'):
        super(AccountStatus, self)._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='AccountStatus')
        if self.value is not None and 'value' not in already_processed:
            already_processed.add('value')
            outfile.write(' value=%s' % (quote_attrib(self.value), ))
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='AccountStatus', fromsubclass_=False, pretty_print=True):
        super(AccountStatus, self)._exportChildren(outfile, level, namespaceprefix_, namespacedef_, name_, True, pretty_print=pretty_print)
    def exportJson(self, parent_dict=None, key=None, is_list=False):
        json_dict = dict()
        self.exportJsonAttributes(json_dict)
        self.exportJsonChildren(json_dict)
        return self.exportJsonResult(json_dict, parent_dict, key, is_list)
    def exportJsonResult(self, json_dict, parent_dict, key, is_list, sub_defs=[], attr_defs=['value']):
        return super().exportJsonResult(json_dict, parent_dict, key, is_list, attr_defs)
    def exportJsonAttributes(self, json_dict):
        super().exportJsonAttributes(json_dict)
        if self.value is not None:
            json_dict['value'] = self.value
    def exportJsonChildren(self, json_dict):
        super().exportJsonChildren(json_dict)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        if SaveNodeDict:
            node_dict[node] = self 
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('value', node)
        if value is not None and 'value' not in already_processed:
            already_processed.add('value')
            self.value = value
            self.value = ' '.join(self.value.split())
            self.validate_AccountStatusEnum(self.value)    # validate type AccountStatusEnum
        super(AccountStatus, self)._buildAttributes(node, attrs, already_processed)
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        super(AccountStatus, self)._buildChildren(child_, node, nodeName_, True)
        pass
# end class AccountStatus


class ActionParticipantType(Element):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = Element
    def __init__(self, id: 'string_primitive' = None, extension: List_['Extension'] = None, value: 'ActionParticipantTypeEnum' = None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        super(globals().get("ActionParticipantType"), self).__init__(id, extension,  **kwargs_)
        self.value = _cast(None, value)
        self.value_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ActionParticipantType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ActionParticipantType.subclass:
            return ActionParticipantType.subclass(*args_, **kwargs_)
        else:
            return ActionParticipantType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_value(self):
        return self.value
    def set_value(self, value):
        self.value = value
    def validate_ActionParticipantTypeEnum(self, value):
        # Validate type ActionParticipantTypeEnum, a restriction on code-primitive.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['patient', 'practitioner', 'related-person', 'device']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on ActionParticipantTypeEnum' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
            if len(value) < 1:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd minLength restriction on ActionParticipantTypeEnum' % {"value" : value, "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_ActionParticipantTypeEnum_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_ActionParticipantTypeEnum_patterns_, ))
    validate_ActionParticipantTypeEnum_patterns_ = [['^([^\\s]+(\\s[^\\s]+)*)$']]
    def has__content(self):
        if (
            super(ActionParticipantType, self).has__content()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='ActionParticipantType', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('ActionParticipantType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'ActionParticipantType':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='ActionParticipantType')
        if self.has__content():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='ActionParticipantType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='ActionParticipantType'):
        super(ActionParticipantType, self)._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='ActionParticipantType')
        if self.value is not None and 'value' not in already_processed:
            already_processed.add('value')
            outfile.write(' value=%s' % (quote_attrib(self.value), ))
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='ActionParticipantType', fromsubclass_=False, pretty_print=True):
        super(ActionParticipantType, self)._exportChildren(outfile, level, namespaceprefix_, namespacedef_, name_, True, pretty_print=pretty_print)
    def exportJson(self, parent_dict=None, key=None, is_list=False):
        json_dict = dict()
        self.exportJsonAttributes(json_dict)
        self.exportJsonChildren(json_dict)
        return self.exportJsonResult(json_dict, parent_dict, key, is_list)
    def exportJsonResult(self, json_dict, parent_dict, key, is_list, sub_defs=[], attr_defs=['value']):
        return super().exportJsonResult(json_dict, parent_dict, key, is_list, attr_defs)
    def exportJsonAttributes(self, json_dict):
        super().exportJsonAttributes(json_dict)
        if self.value is not None:
            json_dict['value'] = self.value
    def exportJsonChildren(self, json_dict):
        super().exportJsonChildren(json_dict)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        if SaveNodeDict:
            node_dict[node] = self 
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('value', node)
        if value is not None and 'value' not in already_processed:
            already_processed.add('value')
            self.value = value
            self.value = ' '.join(self.value.split())
            self.validate_ActionParticipantTypeEnum(self.value)    # validate type ActionParticipantTypeEnum
        super(ActionParticipantType, self)._buildAttributes(node, attrs, already_processed)
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        super(ActionParticipantType, self)._buildChildren(child_, node, nodeName_, True)
        pass
# end class ActionParticipantType


class RequestIntent(Element):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = Element
    def __init__(self, id: 'string_primitive' = None, extension: List_['Extension'] = None, value: 'RequestIntentEnum' = None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        super(globals().get("RequestIntent"), self).__init__(id, extension,  **kwargs_)
        self.value = _cast(None, value)
        self.value_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, RequestIntent)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if RequestIntent.subclass:
            return RequestIntent.subclass(*args_, **kwargs_)
        else:
            return RequestIntent(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_value(self):
        return self.value
    def set_value(self, value):
        self.value = value
    def validate_RequestIntentEnum(self, value):
        # Validate type RequestIntentEnum, a restriction on code-primitive.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['proposal', 'plan', 'directive', 'order', 'original-order', 'reflex-order', 'filler-order', 'instance-order', 'option']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on RequestIntentEnum' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
            if len(value) < 1:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd minLength restriction on RequestIntentEnum' % {"value" : value, "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_RequestIntentEnum_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_RequestIntentEnum_patterns_, ))
    validate_RequestIntentEnum_patterns_ = [['^([^\\s]+(\\s[^\\s]+)*)$']]
    def has__content(self):
        if (
            super(RequestIntent, self).has__content()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='RequestIntent', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('RequestIntent')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'RequestIntent':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='RequestIntent')
        if self.has__content():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='RequestIntent', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='RequestIntent'):
        super(RequestIntent, self)._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='RequestIntent')
        if self.value is not None and 'value' not in already_processed:
            already_processed.add('value')
            outfile.write(' value=%s' % (quote_attrib(self.value), ))
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='RequestIntent', fromsubclass_=False, pretty_print=True):
        super(RequestIntent, self)._exportChildren(outfile, level, namespaceprefix_, namespacedef_, name_, True, pretty_print=pretty_print)
    def exportJson(self, parent_dict=None, key=None, is_list=False):
        json_dict = dict()
        self.exportJsonAttributes(json_dict)
        self.exportJsonChildren(json_dict)
        return self.exportJsonResult(json_dict, parent_dict, key, is_list)
    def exportJsonResult(self, json_dict, parent_dict, key, is_list, sub_defs=[], attr_defs=['value']):
        return super().exportJsonResult(json_dict, parent_dict, key, is_list, attr_defs)
    def exportJsonAttributes(self, json_dict):
        super().exportJsonAttributes(json_dict)
        if self.value is not None:
            json_dict['value'] = self.value
    def exportJsonChildren(self, json_dict):
        super().exportJsonChildren(json_dict)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        if SaveNodeDict:
            node_dict[node] = self 
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('value', node)
        if value is not None and 'value' not in already_processed:
            already_processed.add('value')
            self.value = value
            self.value = ' '.join(self.value.split())
            self.validate_RequestIntentEnum(self.value)    # validate type RequestIntentEnum
        super(RequestIntent, self)._buildAttributes(node, attrs, already_processed)
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        super(RequestIntent, self)._buildChildren(child_, node, nodeName_, True)
        pass
# end class RequestIntent


class RequestPriority(Element):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = Element
    def __init__(self, id: 'string_primitive' = None, extension: List_['Extension'] = None, value: 'RequestPriorityEnum' = None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        super(globals().get("RequestPriority"), self).__init__(id, extension,  **kwargs_)
        self.value = _cast(None, value)
        self.value_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, RequestPriority)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if RequestPriority.subclass:
            return RequestPriority.subclass(*args_, **kwargs_)
        else:
            return RequestPriority(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_value(self):
        return self.value
    def set_value(self, value):
        self.value = value
    def validate_RequestPriorityEnum(self, value):
        # Validate type RequestPriorityEnum, a restriction on code-primitive.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['routine', 'urgent', 'asap', 'stat']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on RequestPriorityEnum' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
            if len(value) < 1:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd minLength restriction on RequestPriorityEnum' % {"value" : value, "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_RequestPriorityEnum_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_RequestPriorityEnum_patterns_, ))
    validate_RequestPriorityEnum_patterns_ = [['^([^\\s]+(\\s[^\\s]+)*)$']]
    def has__content(self):
        if (
            super(RequestPriority, self).has__content()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='RequestPriority', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('RequestPriority')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'RequestPriority':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='RequestPriority')
        if self.has__content():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='RequestPriority', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='RequestPriority'):
        super(RequestPriority, self)._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='RequestPriority')
        if self.value is not None and 'value' not in already_processed:
            already_processed.add('value')
            outfile.write(' value=%s' % (quote_attrib(self.value), ))
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='RequestPriority', fromsubclass_=False, pretty_print=True):
        super(RequestPriority, self)._exportChildren(outfile, level, namespaceprefix_, namespacedef_, name_, True, pretty_print=pretty_print)
    def exportJson(self, parent_dict=None, key=None, is_list=False):
        json_dict = dict()
        self.exportJsonAttributes(json_dict)
        self.exportJsonChildren(json_dict)
        return self.exportJsonResult(json_dict, parent_dict, key, is_list)
    def exportJsonResult(self, json_dict, parent_dict, key, is_list, sub_defs=[], attr_defs=['value']):
        return super().exportJsonResult(json_dict, parent_dict, key, is_list, attr_defs)
    def exportJsonAttributes(self, json_dict):
        super().exportJsonAttributes(json_dict)
        if self.value is not None:
            json_dict['value'] = self.value
    def exportJsonChildren(self, json_dict):
        super().exportJsonChildren(json_dict)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        if SaveNodeDict:
            node_dict[node] = self 
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('value', node)
        if value is not None and 'value' not in already_processed:
            already_processed.add('value')
            self.value = value
            self.value = ' '.join(self.value.split())
            self.validate_RequestPriorityEnum(self.value)    # validate type RequestPriorityEnum
        super(RequestPriority, self)._buildAttributes(node, attrs, already_processed)
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        super(RequestPriority, self)._buildChildren(child_, node, nodeName_, True)
        pass
# end class RequestPriority


class AdverseEventActuality(Element):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = Element
    def __init__(self, id: 'string_primitive' = None, extension: List_['Extension'] = None, value: 'AdverseEventActualityEnum' = None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        super(globals().get("AdverseEventActuality"), self).__init__(id, extension,  **kwargs_)
        self.value = _cast(None, value)
        self.value_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, AdverseEventActuality)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if AdverseEventActuality.subclass:
            return AdverseEventActuality.subclass(*args_, **kwargs_)
        else:
            return AdverseEventActuality(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_value(self):
        return self.value
    def set_value(self, value):
        self.value = value
    def validate_AdverseEventActualityEnum(self, value):
        # Validate type AdverseEventActualityEnum, a restriction on code-primitive.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['actual', 'potential']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on AdverseEventActualityEnum' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
            if len(value) < 1:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd minLength restriction on AdverseEventActualityEnum' % {"value" : value, "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_AdverseEventActualityEnum_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_AdverseEventActualityEnum_patterns_, ))
    validate_AdverseEventActualityEnum_patterns_ = [['^([^\\s]+(\\s[^\\s]+)*)$']]
    def has__content(self):
        if (
            super(AdverseEventActuality, self).has__content()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='AdverseEventActuality', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('AdverseEventActuality')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'AdverseEventActuality':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='AdverseEventActuality')
        if self.has__content():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='AdverseEventActuality', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='AdverseEventActuality'):
        super(AdverseEventActuality, self)._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='AdverseEventActuality')
        if self.value is not None and 'value' not in already_processed:
            already_processed.add('value')
            outfile.write(' value=%s' % (quote_attrib(self.value), ))
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='AdverseEventActuality', fromsubclass_=False, pretty_print=True):
        super(AdverseEventActuality, self)._exportChildren(outfile, level, namespaceprefix_, namespacedef_, name_, True, pretty_print=pretty_print)
    def exportJson(self, parent_dict=None, key=None, is_list=False):
        json_dict = dict()
        self.exportJsonAttributes(json_dict)
        self.exportJsonChildren(json_dict)
        return self.exportJsonResult(json_dict, parent_dict, key, is_list)
    def exportJsonResult(self, json_dict, parent_dict, key, is_list, sub_defs=[], attr_defs=['value']):
        return super().exportJsonResult(json_dict, parent_dict, key, is_list, attr_defs)
    def exportJsonAttributes(self, json_dict):
        super().exportJsonAttributes(json_dict)
        if self.value is not None:
            json_dict['value'] = self.value
    def exportJsonChildren(self, json_dict):
        super().exportJsonChildren(json_dict)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        if SaveNodeDict:
            node_dict[node] = self 
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('value', node)
        if value is not None and 'value' not in already_processed:
            already_processed.add('value')
            self.value = value
            self.value = ' '.join(self.value.split())
            self.validate_AdverseEventActualityEnum(self.value)    # validate type AdverseEventActualityEnum
        super(AdverseEventActuality, self)._buildAttributes(node, attrs, already_processed)
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        super(AdverseEventActuality, self)._buildChildren(child_, node, nodeName_, True)
        pass
# end class AdverseEventActuality


class AllergyIntoleranceCriticality(Element):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = Element
    def __init__(self, id: 'string_primitive' = None, extension: List_['Extension'] = None, value: 'AllergyIntoleranceCriticalityEnum' = None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        super(globals().get("AllergyIntoleranceCriticality"), self).__init__(id, extension,  **kwargs_)
        self.value = _cast(None, value)
        self.value_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, AllergyIntoleranceCriticality)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if AllergyIntoleranceCriticality.subclass:
            return AllergyIntoleranceCriticality.subclass(*args_, **kwargs_)
        else:
            return AllergyIntoleranceCriticality(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_value(self):
        return self.value
    def set_value(self, value):
        self.value = value
    def validate_AllergyIntoleranceCriticalityEnum(self, value):
        # Validate type AllergyIntoleranceCriticalityEnum, a restriction on code-primitive.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['low', 'high', 'unable-to-assess']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on AllergyIntoleranceCriticalityEnum' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
            if len(value) < 1:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd minLength restriction on AllergyIntoleranceCriticalityEnum' % {"value" : value, "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_AllergyIntoleranceCriticalityEnum_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_AllergyIntoleranceCriticalityEnum_patterns_, ))
    validate_AllergyIntoleranceCriticalityEnum_patterns_ = [['^([^\\s]+(\\s[^\\s]+)*)$']]
    def has__content(self):
        if (
            super(AllergyIntoleranceCriticality, self).has__content()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='AllergyIntoleranceCriticality', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('AllergyIntoleranceCriticality')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'AllergyIntoleranceCriticality':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='AllergyIntoleranceCriticality')
        if self.has__content():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='AllergyIntoleranceCriticality', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='AllergyIntoleranceCriticality'):
        super(AllergyIntoleranceCriticality, self)._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='AllergyIntoleranceCriticality')
        if self.value is not None and 'value' not in already_processed:
            already_processed.add('value')
            outfile.write(' value=%s' % (quote_attrib(self.value), ))
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='AllergyIntoleranceCriticality', fromsubclass_=False, pretty_print=True):
        super(AllergyIntoleranceCriticality, self)._exportChildren(outfile, level, namespaceprefix_, namespacedef_, name_, True, pretty_print=pretty_print)
    def exportJson(self, parent_dict=None, key=None, is_list=False):
        json_dict = dict()
        self.exportJsonAttributes(json_dict)
        self.exportJsonChildren(json_dict)
        return self.exportJsonResult(json_dict, parent_dict, key, is_list)
    def exportJsonResult(self, json_dict, parent_dict, key, is_list, sub_defs=[], attr_defs=['value']):
        return super().exportJsonResult(json_dict, parent_dict, key, is_list, attr_defs)
    def exportJsonAttributes(self, json_dict):
        super().exportJsonAttributes(json_dict)
        if self.value is not None:
            json_dict['value'] = self.value
    def exportJsonChildren(self, json_dict):
        super().exportJsonChildren(json_dict)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        if SaveNodeDict:
            node_dict[node] = self 
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('value', node)
        if value is not None and 'value' not in already_processed:
            already_processed.add('value')
            self.value = value
            self.value = ' '.join(self.value.split())
            self.validate_AllergyIntoleranceCriticalityEnum(self.value)    # validate type AllergyIntoleranceCriticalityEnum
        super(AllergyIntoleranceCriticality, self)._buildAttributes(node, attrs, already_processed)
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        super(AllergyIntoleranceCriticality, self)._buildChildren(child_, node, nodeName_, True)
        pass
# end class AllergyIntoleranceCriticality


class AllergyIntoleranceType(Element):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = Element
    def __init__(self, id: 'string_primitive' = None, extension: List_['Extension'] = None, value: 'AllergyIntoleranceTypeEnum' = None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        super(globals().get("AllergyIntoleranceType"), self).__init__(id, extension,  **kwargs_)
        self.value = _cast(None, value)
        self.value_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, AllergyIntoleranceType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if AllergyIntoleranceType.subclass:
            return AllergyIntoleranceType.subclass(*args_, **kwargs_)
        else:
            return AllergyIntoleranceType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_value(self):
        return self.value
    def set_value(self, value):
        self.value = value
    def validate_AllergyIntoleranceTypeEnum(self, value):
        # Validate type AllergyIntoleranceTypeEnum, a restriction on code-primitive.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['allergy', 'intolerance']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on AllergyIntoleranceTypeEnum' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
            if len(value) < 1:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd minLength restriction on AllergyIntoleranceTypeEnum' % {"value" : value, "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_AllergyIntoleranceTypeEnum_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_AllergyIntoleranceTypeEnum_patterns_, ))
    validate_AllergyIntoleranceTypeEnum_patterns_ = [['^([^\\s]+(\\s[^\\s]+)*)$']]
    def has__content(self):
        if (
            super(AllergyIntoleranceType, self).has__content()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='AllergyIntoleranceType', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('AllergyIntoleranceType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'AllergyIntoleranceType':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='AllergyIntoleranceType')
        if self.has__content():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='AllergyIntoleranceType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='AllergyIntoleranceType'):
        super(AllergyIntoleranceType, self)._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='AllergyIntoleranceType')
        if self.value is not None and 'value' not in already_processed:
            already_processed.add('value')
            outfile.write(' value=%s' % (quote_attrib(self.value), ))
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='AllergyIntoleranceType', fromsubclass_=False, pretty_print=True):
        super(AllergyIntoleranceType, self)._exportChildren(outfile, level, namespaceprefix_, namespacedef_, name_, True, pretty_print=pretty_print)
    def exportJson(self, parent_dict=None, key=None, is_list=False):
        json_dict = dict()
        self.exportJsonAttributes(json_dict)
        self.exportJsonChildren(json_dict)
        return self.exportJsonResult(json_dict, parent_dict, key, is_list)
    def exportJsonResult(self, json_dict, parent_dict, key, is_list, sub_defs=[], attr_defs=['value']):
        return super().exportJsonResult(json_dict, parent_dict, key, is_list, attr_defs)
    def exportJsonAttributes(self, json_dict):
        super().exportJsonAttributes(json_dict)
        if self.value is not None:
            json_dict['value'] = self.value
    def exportJsonChildren(self, json_dict):
        super().exportJsonChildren(json_dict)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        if SaveNodeDict:
            node_dict[node] = self 
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('value', node)
        if value is not None and 'value' not in already_processed:
            already_processed.add('value')
            self.value = value
            self.value = ' '.join(self.value.split())
            self.validate_AllergyIntoleranceTypeEnum(self.value)    # validate type AllergyIntoleranceTypeEnum
        super(AllergyIntoleranceType, self)._buildAttributes(node, attrs, already_processed)
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        super(AllergyIntoleranceType, self)._buildChildren(child_, node, nodeName_, True)
        pass
# end class AllergyIntoleranceType


class AllergyIntoleranceCategory(Element):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = Element
    def __init__(self, id: 'string_primitive' = None, extension: List_['Extension'] = None, value: 'AllergyIntoleranceCategoryEnum' = None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        super(globals().get("AllergyIntoleranceCategory"), self).__init__(id, extension,  **kwargs_)
        self.value = _cast(None, value)
        self.value_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, AllergyIntoleranceCategory)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if AllergyIntoleranceCategory.subclass:
            return AllergyIntoleranceCategory.subclass(*args_, **kwargs_)
        else:
            return AllergyIntoleranceCategory(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_value(self):
        return self.value
    def set_value(self, value):
        self.value = value
    def validate_AllergyIntoleranceCategoryEnum(self, value):
        # Validate type AllergyIntoleranceCategoryEnum, a restriction on code-primitive.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['food', 'medication', 'environment', 'biologic']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on AllergyIntoleranceCategoryEnum' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
            if len(value) < 1:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd minLength restriction on AllergyIntoleranceCategoryEnum' % {"value" : value, "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_AllergyIntoleranceCategoryEnum_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_AllergyIntoleranceCategoryEnum_patterns_, ))
    validate_AllergyIntoleranceCategoryEnum_patterns_ = [['^([^\\s]+(\\s[^\\s]+)*)$']]
    def has__content(self):
        if (
            super(AllergyIntoleranceCategory, self).has__content()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='AllergyIntoleranceCategory', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('AllergyIntoleranceCategory')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'AllergyIntoleranceCategory':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='AllergyIntoleranceCategory')
        if self.has__content():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='AllergyIntoleranceCategory', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='AllergyIntoleranceCategory'):
        super(AllergyIntoleranceCategory, self)._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='AllergyIntoleranceCategory')
        if self.value is not None and 'value' not in already_processed:
            already_processed.add('value')
            outfile.write(' value=%s' % (quote_attrib(self.value), ))
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='AllergyIntoleranceCategory', fromsubclass_=False, pretty_print=True):
        super(AllergyIntoleranceCategory, self)._exportChildren(outfile, level, namespaceprefix_, namespacedef_, name_, True, pretty_print=pretty_print)
    def exportJson(self, parent_dict=None, key=None, is_list=False):
        json_dict = dict()
        self.exportJsonAttributes(json_dict)
        self.exportJsonChildren(json_dict)
        return self.exportJsonResult(json_dict, parent_dict, key, is_list)
    def exportJsonResult(self, json_dict, parent_dict, key, is_list, sub_defs=[], attr_defs=['value']):
        return super().exportJsonResult(json_dict, parent_dict, key, is_list, attr_defs)
    def exportJsonAttributes(self, json_dict):
        super().exportJsonAttributes(json_dict)
        if self.value is not None:
            json_dict['value'] = self.value
    def exportJsonChildren(self, json_dict):
        super().exportJsonChildren(json_dict)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        if SaveNodeDict:
            node_dict[node] = self 
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('value', node)
        if value is not None and 'value' not in already_processed:
            already_processed.add('value')
            self.value = value
            self.value = ' '.join(self.value.split())
            self.validate_AllergyIntoleranceCategoryEnum(self.value)    # validate type AllergyIntoleranceCategoryEnum
        super(AllergyIntoleranceCategory, self)._buildAttributes(node, attrs, already_processed)
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        super(AllergyIntoleranceCategory, self)._buildChildren(child_, node, nodeName_, True)
        pass
# end class AllergyIntoleranceCategory


class AllergyIntoleranceSeverity(Element):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = Element
    def __init__(self, id: 'string_primitive' = None, extension: List_['Extension'] = None, value: 'AllergyIntoleranceSeverityEnum' = None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        super(globals().get("AllergyIntoleranceSeverity"), self).__init__(id, extension,  **kwargs_)
        self.value = _cast(None, value)
        self.value_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, AllergyIntoleranceSeverity)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if AllergyIntoleranceSeverity.subclass:
            return AllergyIntoleranceSeverity.subclass(*args_, **kwargs_)
        else:
            return AllergyIntoleranceSeverity(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_value(self):
        return self.value
    def set_value(self, value):
        self.value = value
    def validate_AllergyIntoleranceSeverityEnum(self, value):
        # Validate type AllergyIntoleranceSeverityEnum, a restriction on code-primitive.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['mild', 'moderate', 'severe']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on AllergyIntoleranceSeverityEnum' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
            if len(value) < 1:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd minLength restriction on AllergyIntoleranceSeverityEnum' % {"value" : value, "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_AllergyIntoleranceSeverityEnum_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_AllergyIntoleranceSeverityEnum_patterns_, ))
    validate_AllergyIntoleranceSeverityEnum_patterns_ = [['^([^\\s]+(\\s[^\\s]+)*)$']]
    def has__content(self):
        if (
            super(AllergyIntoleranceSeverity, self).has__content()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='AllergyIntoleranceSeverity', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('AllergyIntoleranceSeverity')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'AllergyIntoleranceSeverity':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='AllergyIntoleranceSeverity')
        if self.has__content():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='AllergyIntoleranceSeverity', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='AllergyIntoleranceSeverity'):
        super(AllergyIntoleranceSeverity, self)._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='AllergyIntoleranceSeverity')
        if self.value is not None and 'value' not in already_processed:
            already_processed.add('value')
            outfile.write(' value=%s' % (quote_attrib(self.value), ))
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='AllergyIntoleranceSeverity', fromsubclass_=False, pretty_print=True):
        super(AllergyIntoleranceSeverity, self)._exportChildren(outfile, level, namespaceprefix_, namespacedef_, name_, True, pretty_print=pretty_print)
    def exportJson(self, parent_dict=None, key=None, is_list=False):
        json_dict = dict()
        self.exportJsonAttributes(json_dict)
        self.exportJsonChildren(json_dict)
        return self.exportJsonResult(json_dict, parent_dict, key, is_list)
    def exportJsonResult(self, json_dict, parent_dict, key, is_list, sub_defs=[], attr_defs=['value']):
        return super().exportJsonResult(json_dict, parent_dict, key, is_list, attr_defs)
    def exportJsonAttributes(self, json_dict):
        super().exportJsonAttributes(json_dict)
        if self.value is not None:
            json_dict['value'] = self.value
    def exportJsonChildren(self, json_dict):
        super().exportJsonChildren(json_dict)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        if SaveNodeDict:
            node_dict[node] = self 
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('value', node)
        if value is not None and 'value' not in already_processed:
            already_processed.add('value')
            self.value = value
            self.value = ' '.join(self.value.split())
            self.validate_AllergyIntoleranceSeverityEnum(self.value)    # validate type AllergyIntoleranceSeverityEnum
        super(AllergyIntoleranceSeverity, self)._buildAttributes(node, attrs, already_processed)
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        super(AllergyIntoleranceSeverity, self)._buildChildren(child_, node, nodeName_, True)
        pass
# end class AllergyIntoleranceSeverity


class ParticipantRequired(Element):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = Element
    def __init__(self, id: 'string_primitive' = None, extension: List_['Extension'] = None, value: 'ParticipantRequiredEnum' = None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        super(globals().get("ParticipantRequired"), self).__init__(id, extension,  **kwargs_)
        self.value = _cast(None, value)
        self.value_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ParticipantRequired)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ParticipantRequired.subclass:
            return ParticipantRequired.subclass(*args_, **kwargs_)
        else:
            return ParticipantRequired(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_value(self):
        return self.value
    def set_value(self, value):
        self.value = value
    def validate_ParticipantRequiredEnum(self, value):
        # Validate type ParticipantRequiredEnum, a restriction on code-primitive.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['required', 'optional', 'information-only']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on ParticipantRequiredEnum' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
            if len(value) < 1:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd minLength restriction on ParticipantRequiredEnum' % {"value" : value, "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_ParticipantRequiredEnum_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_ParticipantRequiredEnum_patterns_, ))
    validate_ParticipantRequiredEnum_patterns_ = [['^([^\\s]+(\\s[^\\s]+)*)$']]
    def has__content(self):
        if (
            super(ParticipantRequired, self).has__content()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='ParticipantRequired', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('ParticipantRequired')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'ParticipantRequired':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='ParticipantRequired')
        if self.has__content():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='ParticipantRequired', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='ParticipantRequired'):
        super(ParticipantRequired, self)._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='ParticipantRequired')
        if self.value is not None and 'value' not in already_processed:
            already_processed.add('value')
            outfile.write(' value=%s' % (quote_attrib(self.value), ))
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='ParticipantRequired', fromsubclass_=False, pretty_print=True):
        super(ParticipantRequired, self)._exportChildren(outfile, level, namespaceprefix_, namespacedef_, name_, True, pretty_print=pretty_print)
    def exportJson(self, parent_dict=None, key=None, is_list=False):
        json_dict = dict()
        self.exportJsonAttributes(json_dict)
        self.exportJsonChildren(json_dict)
        return self.exportJsonResult(json_dict, parent_dict, key, is_list)
    def exportJsonResult(self, json_dict, parent_dict, key, is_list, sub_defs=[], attr_defs=['value']):
        return super().exportJsonResult(json_dict, parent_dict, key, is_list, attr_defs)
    def exportJsonAttributes(self, json_dict):
        super().exportJsonAttributes(json_dict)
        if self.value is not None:
            json_dict['value'] = self.value
    def exportJsonChildren(self, json_dict):
        super().exportJsonChildren(json_dict)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        if SaveNodeDict:
            node_dict[node] = self 
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('value', node)
        if value is not None and 'value' not in already_processed:
            already_processed.add('value')
            self.value = value
            self.value = ' '.join(self.value.split())
            self.validate_ParticipantRequiredEnum(self.value)    # validate type ParticipantRequiredEnum
        super(ParticipantRequired, self)._buildAttributes(node, attrs, already_processed)
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        super(ParticipantRequired, self)._buildChildren(child_, node, nodeName_, True)
        pass
# end class ParticipantRequired


class AppointmentStatus(Element):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = Element
    def __init__(self, id: 'string_primitive' = None, extension: List_['Extension'] = None, value: 'AppointmentStatusEnum' = None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        super(globals().get("AppointmentStatus"), self).__init__(id, extension,  **kwargs_)
        self.value = _cast(None, value)
        self.value_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, AppointmentStatus)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if AppointmentStatus.subclass:
            return AppointmentStatus.subclass(*args_, **kwargs_)
        else:
            return AppointmentStatus(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_value(self):
        return self.value
    def set_value(self, value):
        self.value = value
    def validate_AppointmentStatusEnum(self, value):
        # Validate type AppointmentStatusEnum, a restriction on code-primitive.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['proposed', 'pending', 'booked', 'arrived', 'fulfilled', 'cancelled', 'noshow', 'entered-in-error', 'checked-in', 'waitlist']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on AppointmentStatusEnum' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
            if len(value) < 1:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd minLength restriction on AppointmentStatusEnum' % {"value" : value, "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_AppointmentStatusEnum_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_AppointmentStatusEnum_patterns_, ))
    validate_AppointmentStatusEnum_patterns_ = [['^([^\\s]+(\\s[^\\s]+)*)$']]
    def has__content(self):
        if (
            super(AppointmentStatus, self).has__content()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='AppointmentStatus', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('AppointmentStatus')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'AppointmentStatus':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='AppointmentStatus')
        if self.has__content():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='AppointmentStatus', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='AppointmentStatus'):
        super(AppointmentStatus, self)._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='AppointmentStatus')
        if self.value is not None and 'value' not in already_processed:
            already_processed.add('value')
            outfile.write(' value=%s' % (quote_attrib(self.value), ))
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='AppointmentStatus', fromsubclass_=False, pretty_print=True):
        super(AppointmentStatus, self)._exportChildren(outfile, level, namespaceprefix_, namespacedef_, name_, True, pretty_print=pretty_print)
    def exportJson(self, parent_dict=None, key=None, is_list=False):
        json_dict = dict()
        self.exportJsonAttributes(json_dict)
        self.exportJsonChildren(json_dict)
        return self.exportJsonResult(json_dict, parent_dict, key, is_list)
    def exportJsonResult(self, json_dict, parent_dict, key, is_list, sub_defs=[], attr_defs=['value']):
        return super().exportJsonResult(json_dict, parent_dict, key, is_list, attr_defs)
    def exportJsonAttributes(self, json_dict):
        super().exportJsonAttributes(json_dict)
        if self.value is not None:
            json_dict['value'] = self.value
    def exportJsonChildren(self, json_dict):
        super().exportJsonChildren(json_dict)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        if SaveNodeDict:
            node_dict[node] = self 
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('value', node)
        if value is not None and 'value' not in already_processed:
            already_processed.add('value')
            self.value = value
            self.value = ' '.join(self.value.split())
            self.validate_AppointmentStatusEnum(self.value)    # validate type AppointmentStatusEnum
        super(AppointmentStatus, self)._buildAttributes(node, attrs, already_processed)
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        super(AppointmentStatus, self)._buildChildren(child_, node, nodeName_, True)
        pass
# end class AppointmentStatus


class ParticipationStatus(Element):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = Element
    def __init__(self, id: 'string_primitive' = None, extension: List_['Extension'] = None, value: 'ParticipationStatusEnum' = None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        super(globals().get("ParticipationStatus"), self).__init__(id, extension,  **kwargs_)
        self.value = _cast(None, value)
        self.value_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ParticipationStatus)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ParticipationStatus.subclass:
            return ParticipationStatus.subclass(*args_, **kwargs_)
        else:
            return ParticipationStatus(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_value(self):
        return self.value
    def set_value(self, value):
        self.value = value
    def validate_ParticipationStatusEnum(self, value):
        # Validate type ParticipationStatusEnum, a restriction on code-primitive.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['accepted', 'declined', 'tentative', 'needs-action']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on ParticipationStatusEnum' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
            if len(value) < 1:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd minLength restriction on ParticipationStatusEnum' % {"value" : value, "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_ParticipationStatusEnum_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_ParticipationStatusEnum_patterns_, ))
    validate_ParticipationStatusEnum_patterns_ = [['^([^\\s]+(\\s[^\\s]+)*)$']]
    def has__content(self):
        if (
            super(ParticipationStatus, self).has__content()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='ParticipationStatus', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('ParticipationStatus')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'ParticipationStatus':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='ParticipationStatus')
        if self.has__content():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='ParticipationStatus', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='ParticipationStatus'):
        super(ParticipationStatus, self)._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='ParticipationStatus')
        if self.value is not None and 'value' not in already_processed:
            already_processed.add('value')
            outfile.write(' value=%s' % (quote_attrib(self.value), ))
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='ParticipationStatus', fromsubclass_=False, pretty_print=True):
        super(ParticipationStatus, self)._exportChildren(outfile, level, namespaceprefix_, namespacedef_, name_, True, pretty_print=pretty_print)
    def exportJson(self, parent_dict=None, key=None, is_list=False):
        json_dict = dict()
        self.exportJsonAttributes(json_dict)
        self.exportJsonChildren(json_dict)
        return self.exportJsonResult(json_dict, parent_dict, key, is_list)
    def exportJsonResult(self, json_dict, parent_dict, key, is_list, sub_defs=[], attr_defs=['value']):
        return super().exportJsonResult(json_dict, parent_dict, key, is_list, attr_defs)
    def exportJsonAttributes(self, json_dict):
        super().exportJsonAttributes(json_dict)
        if self.value is not None:
            json_dict['value'] = self.value
    def exportJsonChildren(self, json_dict):
        super().exportJsonChildren(json_dict)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        if SaveNodeDict:
            node_dict[node] = self 
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('value', node)
        if value is not None and 'value' not in already_processed:
            already_processed.add('value')
            self.value = value
            self.value = ' '.join(self.value.split())
            self.validate_ParticipationStatusEnum(self.value)    # validate type ParticipationStatusEnum
        super(ParticipationStatus, self)._buildAttributes(node, attrs, already_processed)
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        super(ParticipationStatus, self)._buildChildren(child_, node, nodeName_, True)
        pass
# end class ParticipationStatus


class AuditEventOutcome(Element):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = Element
    def __init__(self, id: 'string_primitive' = None, extension: List_['Extension'] = None, value: 'AuditEventOutcomeEnum' = None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        super(globals().get("AuditEventOutcome"), self).__init__(id, extension,  **kwargs_)
        self.value = _cast(None, value)
        self.value_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, AuditEventOutcome)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if AuditEventOutcome.subclass:
            return AuditEventOutcome.subclass(*args_, **kwargs_)
        else:
            return AuditEventOutcome(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_value(self):
        return self.value
    def set_value(self, value):
        self.value = value
    def validate_AuditEventOutcomeEnum(self, value):
        # Validate type AuditEventOutcomeEnum, a restriction on code-primitive.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['0', '4', '8', '12']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on AuditEventOutcomeEnum' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
            if len(value) < 1:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd minLength restriction on AuditEventOutcomeEnum' % {"value" : value, "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_AuditEventOutcomeEnum_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_AuditEventOutcomeEnum_patterns_, ))
    validate_AuditEventOutcomeEnum_patterns_ = [['^([^\\s]+(\\s[^\\s]+)*)$']]
    def has__content(self):
        if (
            super(AuditEventOutcome, self).has__content()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='AuditEventOutcome', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('AuditEventOutcome')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'AuditEventOutcome':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='AuditEventOutcome')
        if self.has__content():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='AuditEventOutcome', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='AuditEventOutcome'):
        super(AuditEventOutcome, self)._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='AuditEventOutcome')
        if self.value is not None and 'value' not in already_processed:
            already_processed.add('value')
            outfile.write(' value=%s' % (quote_attrib(self.value), ))
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='AuditEventOutcome', fromsubclass_=False, pretty_print=True):
        super(AuditEventOutcome, self)._exportChildren(outfile, level, namespaceprefix_, namespacedef_, name_, True, pretty_print=pretty_print)
    def exportJson(self, parent_dict=None, key=None, is_list=False):
        json_dict = dict()
        self.exportJsonAttributes(json_dict)
        self.exportJsonChildren(json_dict)
        return self.exportJsonResult(json_dict, parent_dict, key, is_list)
    def exportJsonResult(self, json_dict, parent_dict, key, is_list, sub_defs=[], attr_defs=['value']):
        return super().exportJsonResult(json_dict, parent_dict, key, is_list, attr_defs)
    def exportJsonAttributes(self, json_dict):
        super().exportJsonAttributes(json_dict)
        if self.value is not None:
            json_dict['value'] = self.value
    def exportJsonChildren(self, json_dict):
        super().exportJsonChildren(json_dict)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        if SaveNodeDict:
            node_dict[node] = self 
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('value', node)
        if value is not None and 'value' not in already_processed:
            already_processed.add('value')
            self.value = value
            self.value = ' '.join(self.value.split())
            self.validate_AuditEventOutcomeEnum(self.value)    # validate type AuditEventOutcomeEnum
        super(AuditEventOutcome, self)._buildAttributes(node, attrs, already_processed)
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        super(AuditEventOutcome, self)._buildChildren(child_, node, nodeName_, True)
        pass
# end class AuditEventOutcome


class AuditEventAction(Element):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = Element
    def __init__(self, id: 'string_primitive' = None, extension: List_['Extension'] = None, value: 'AuditEventActionEnum' = None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        super(globals().get("AuditEventAction"), self).__init__(id, extension,  **kwargs_)
        self.value = _cast(None, value)
        self.value_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, AuditEventAction)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if AuditEventAction.subclass:
            return AuditEventAction.subclass(*args_, **kwargs_)
        else:
            return AuditEventAction(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_value(self):
        return self.value
    def set_value(self, value):
        self.value = value
    def validate_AuditEventActionEnum(self, value):
        # Validate type AuditEventActionEnum, a restriction on code-primitive.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['C', 'R', 'U', 'D', 'E']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on AuditEventActionEnum' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
            if len(value) < 1:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd minLength restriction on AuditEventActionEnum' % {"value" : value, "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_AuditEventActionEnum_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_AuditEventActionEnum_patterns_, ))
    validate_AuditEventActionEnum_patterns_ = [['^([^\\s]+(\\s[^\\s]+)*)$']]
    def has__content(self):
        if (
            super(AuditEventAction, self).has__content()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='AuditEventAction', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('AuditEventAction')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'AuditEventAction':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='AuditEventAction')
        if self.has__content():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='AuditEventAction', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='AuditEventAction'):
        super(AuditEventAction, self)._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='AuditEventAction')
        if self.value is not None and 'value' not in already_processed:
            already_processed.add('value')
            outfile.write(' value=%s' % (quote_attrib(self.value), ))
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='AuditEventAction', fromsubclass_=False, pretty_print=True):
        super(AuditEventAction, self)._exportChildren(outfile, level, namespaceprefix_, namespacedef_, name_, True, pretty_print=pretty_print)
    def exportJson(self, parent_dict=None, key=None, is_list=False):
        json_dict = dict()
        self.exportJsonAttributes(json_dict)
        self.exportJsonChildren(json_dict)
        return self.exportJsonResult(json_dict, parent_dict, key, is_list)
    def exportJsonResult(self, json_dict, parent_dict, key, is_list, sub_defs=[], attr_defs=['value']):
        return super().exportJsonResult(json_dict, parent_dict, key, is_list, attr_defs)
    def exportJsonAttributes(self, json_dict):
        super().exportJsonAttributes(json_dict)
        if self.value is not None:
            json_dict['value'] = self.value
    def exportJsonChildren(self, json_dict):
        super().exportJsonChildren(json_dict)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        if SaveNodeDict:
            node_dict[node] = self 
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('value', node)
        if value is not None and 'value' not in already_processed:
            already_processed.add('value')
            self.value = value
            self.value = ' '.join(self.value.split())
            self.validate_AuditEventActionEnum(self.value)    # validate type AuditEventActionEnum
        super(AuditEventAction, self)._buildAttributes(node, attrs, already_processed)
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        super(AuditEventAction, self)._buildChildren(child_, node, nodeName_, True)
        pass
# end class AuditEventAction


class AuditEventAgentNetworkType(Element):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = Element
    def __init__(self, id: 'string_primitive' = None, extension: List_['Extension'] = None, value: 'AuditEventAgentNetworkTypeEnum' = None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        super(globals().get("AuditEventAgentNetworkType"), self).__init__(id, extension,  **kwargs_)
        self.value = _cast(None, value)
        self.value_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, AuditEventAgentNetworkType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if AuditEventAgentNetworkType.subclass:
            return AuditEventAgentNetworkType.subclass(*args_, **kwargs_)
        else:
            return AuditEventAgentNetworkType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_value(self):
        return self.value
    def set_value(self, value):
        self.value = value
    def validate_AuditEventAgentNetworkTypeEnum(self, value):
        # Validate type AuditEventAgentNetworkTypeEnum, a restriction on code-primitive.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['1', '2', '3', '4', '5']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on AuditEventAgentNetworkTypeEnum' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
            if len(value) < 1:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd minLength restriction on AuditEventAgentNetworkTypeEnum' % {"value" : value, "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_AuditEventAgentNetworkTypeEnum_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_AuditEventAgentNetworkTypeEnum_patterns_, ))
    validate_AuditEventAgentNetworkTypeEnum_patterns_ = [['^([^\\s]+(\\s[^\\s]+)*)$']]
    def has__content(self):
        if (
            super(AuditEventAgentNetworkType, self).has__content()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='AuditEventAgentNetworkType', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('AuditEventAgentNetworkType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'AuditEventAgentNetworkType':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='AuditEventAgentNetworkType')
        if self.has__content():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='AuditEventAgentNetworkType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='AuditEventAgentNetworkType'):
        super(AuditEventAgentNetworkType, self)._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='AuditEventAgentNetworkType')
        if self.value is not None and 'value' not in already_processed:
            already_processed.add('value')
            outfile.write(' value=%s' % (quote_attrib(self.value), ))
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='AuditEventAgentNetworkType', fromsubclass_=False, pretty_print=True):
        super(AuditEventAgentNetworkType, self)._exportChildren(outfile, level, namespaceprefix_, namespacedef_, name_, True, pretty_print=pretty_print)
    def exportJson(self, parent_dict=None, key=None, is_list=False):
        json_dict = dict()
        self.exportJsonAttributes(json_dict)
        self.exportJsonChildren(json_dict)
        return self.exportJsonResult(json_dict, parent_dict, key, is_list)
    def exportJsonResult(self, json_dict, parent_dict, key, is_list, sub_defs=[], attr_defs=['value']):
        return super().exportJsonResult(json_dict, parent_dict, key, is_list, attr_defs)
    def exportJsonAttributes(self, json_dict):
        super().exportJsonAttributes(json_dict)
        if self.value is not None:
            json_dict['value'] = self.value
    def exportJsonChildren(self, json_dict):
        super().exportJsonChildren(json_dict)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        if SaveNodeDict:
            node_dict[node] = self 
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('value', node)
        if value is not None and 'value' not in already_processed:
            already_processed.add('value')
            self.value = value
            self.value = ' '.join(self.value.split())
            self.validate_AuditEventAgentNetworkTypeEnum(self.value)    # validate type AuditEventAgentNetworkTypeEnum
        super(AuditEventAgentNetworkType, self)._buildAttributes(node, attrs, already_processed)
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        super(AuditEventAgentNetworkType, self)._buildChildren(child_, node, nodeName_, True)
        pass
# end class AuditEventAgentNetworkType


class Binary(Resource):
    """contentType -- MimeType of the binary content represented as a standard MimeType (BCP 13).
    securityContext -- This element identifies another resource that can be used as a proxy of the security sensitivity to use when deciding and enforcing access control rules for the Binary resource. Given that the Binary resource contains very few elements that can be used to determine the sensitivity of the data and relationships to individuals, the referenced resource stands in as a proxy equivalent for this purpose. This referenced resource may be related to the Binary (e.g. Media, DocumentReference), or may be some non-related Resource purely as a security proxy. E.g. to identify that the binary resource relates to a patient, and access should only be granted to applications that have access to the patient.
    data -- The actual content, base64 encoded.
    
    """
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = Resource
    def __init__(self, id: 'string' = None, meta: 'Meta' = None, implicitRules: 'uri' = None, language: 'code' = None, contentType: 'code' = None, securityContext: 'Reference' = None, data: 'base64Binary' = None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        super(globals().get("Binary"), self).__init__(id, meta, implicitRules, language,  **kwargs_)
        self.contentType = contentType
        self.contentType_nsprefix_ = None
        self.securityContext = securityContext
        self.securityContext_nsprefix_ = None
        self.data = data
        self.data_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, Binary)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if Binary.subclass:
            return Binary.subclass(*args_, **kwargs_)
        else:
            return Binary(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_contentType(self):
        return self.contentType
    def set_contentType(self, contentType):
        self.contentType = contentType
    def get_securityContext(self):
        return self.securityContext
    def set_securityContext(self, securityContext):
        self.securityContext = securityContext
    def get_data(self):
        return self.data
    def set_data(self, data):
        self.data = data
    def has__content(self):
        if (
            self.contentType is not None or
            self.securityContext is not None or
            self.data is not None or
            super(Binary, self).has__content()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_=' xmlns:None="http://hl7.org/fhir" ', name_='Binary', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('Binary')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'Binary':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='Binary')
        if self.has__content():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='Binary', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='Binary'):
        super(Binary, self)._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='Binary')
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_=' xmlns:None="http://hl7.org/fhir" ', name_='Binary', fromsubclass_=False, pretty_print=True):
        super(Binary, self)._exportChildren(outfile, level, namespaceprefix_, namespacedef_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.contentType is not None:
            namespaceprefix_ = self.contentType_nsprefix_ + ':' if (UseCapturedNS_ and self.contentType_nsprefix_) else ''
            self.contentType.export(outfile, level, namespaceprefix_, namespacedef_='', name_='contentType', pretty_print=pretty_print)
        if self.securityContext is not None:
            namespaceprefix_ = self.securityContext_nsprefix_ + ':' if (UseCapturedNS_ and self.securityContext_nsprefix_) else ''
            self.securityContext.export(outfile, level, namespaceprefix_, namespacedef_='', name_='securityContext', pretty_print=pretty_print)
        if self.data is not None:
            namespaceprefix_ = self.data_nsprefix_ + ':' if (UseCapturedNS_ and self.data_nsprefix_) else ''
            self.data.export(outfile, level, namespaceprefix_, namespacedef_='', name_='data', pretty_print=pretty_print)
    def exportJson(self, parent_dict=None, key=None, is_list=False):
        json_dict = dict()
        self.exportJsonAttributes(json_dict)
        self.exportJsonChildren(json_dict)
        return self.exportJsonResult(json_dict, parent_dict, key, is_list)
    def exportJsonResult(self, json_dict, parent_dict, key, is_list, sub_defs=[], attr_defs=[]):
        return super().exportJsonResult(json_dict, parent_dict, key, is_list, attr_defs)
    def exportJsonAttributes(self, json_dict):
        super().exportJsonAttributes(json_dict)
    def exportJsonChildren(self, json_dict):
        super().exportJsonChildren(json_dict)
        if self.contentType is not None:
            child_dict = self.contentType.exportJson(json_dict, 'contentType', False)
            if child_dict:
                json_dict['contentType'] = child_dict
        if self.securityContext is not None:
            child_dict = self.securityContext.exportJson(json_dict, 'securityContext', False)
            if child_dict:
                json_dict['securityContext'] = child_dict
        if self.data is not None:
            child_dict = self.data.exportJson(json_dict, 'data', False)
            if child_dict:
                json_dict['data'] = child_dict
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        if SaveNodeDict:
            node_dict[node] = self 
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        super(Binary, self)._buildAttributes(node, attrs, already_processed)
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'contentType':
            obj_ = code.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.contentType = obj_
            obj_.original_tagname_ = 'contentType'
        elif nodeName_ == 'securityContext':
            obj_ = Reference.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.securityContext = obj_
            obj_.original_tagname_ = 'securityContext'
        elif nodeName_ == 'data':
            obj_ = base64Binary.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.data = obj_
            obj_.original_tagname_ = 'data'
        super(Binary, self)._buildChildren(child_, node, nodeName_, True)
# end class Binary


class BiologicallyDerivedProductCategory(Element):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = Element
    def __init__(self, id: 'string_primitive' = None, extension: List_['Extension'] = None, value: 'BiologicallyDerivedProductCategoryEnum' = None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        super(globals().get("BiologicallyDerivedProductCategory"), self).__init__(id, extension,  **kwargs_)
        self.value = _cast(None, value)
        self.value_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, BiologicallyDerivedProductCategory)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if BiologicallyDerivedProductCategory.subclass:
            return BiologicallyDerivedProductCategory.subclass(*args_, **kwargs_)
        else:
            return BiologicallyDerivedProductCategory(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_value(self):
        return self.value
    def set_value(self, value):
        self.value = value
    def validate_BiologicallyDerivedProductCategoryEnum(self, value):
        # Validate type BiologicallyDerivedProductCategoryEnum, a restriction on code-primitive.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['organ', 'tissue', 'fluid', 'cells', 'biologicalAgent']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on BiologicallyDerivedProductCategoryEnum' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
            if len(value) < 1:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd minLength restriction on BiologicallyDerivedProductCategoryEnum' % {"value" : value, "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_BiologicallyDerivedProductCategoryEnum_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_BiologicallyDerivedProductCategoryEnum_patterns_, ))
    validate_BiologicallyDerivedProductCategoryEnum_patterns_ = [['^([^\\s]+(\\s[^\\s]+)*)$']]
    def has__content(self):
        if (
            super(BiologicallyDerivedProductCategory, self).has__content()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='BiologicallyDerivedProductCategory', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('BiologicallyDerivedProductCategory')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'BiologicallyDerivedProductCategory':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='BiologicallyDerivedProductCategory')
        if self.has__content():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='BiologicallyDerivedProductCategory', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='BiologicallyDerivedProductCategory'):
        super(BiologicallyDerivedProductCategory, self)._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='BiologicallyDerivedProductCategory')
        if self.value is not None and 'value' not in already_processed:
            already_processed.add('value')
            outfile.write(' value=%s' % (quote_attrib(self.value), ))
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='BiologicallyDerivedProductCategory', fromsubclass_=False, pretty_print=True):
        super(BiologicallyDerivedProductCategory, self)._exportChildren(outfile, level, namespaceprefix_, namespacedef_, name_, True, pretty_print=pretty_print)
    def exportJson(self, parent_dict=None, key=None, is_list=False):
        json_dict = dict()
        self.exportJsonAttributes(json_dict)
        self.exportJsonChildren(json_dict)
        return self.exportJsonResult(json_dict, parent_dict, key, is_list)
    def exportJsonResult(self, json_dict, parent_dict, key, is_list, sub_defs=[], attr_defs=['value']):
        return super().exportJsonResult(json_dict, parent_dict, key, is_list, attr_defs)
    def exportJsonAttributes(self, json_dict):
        super().exportJsonAttributes(json_dict)
        if self.value is not None:
            json_dict['value'] = self.value
    def exportJsonChildren(self, json_dict):
        super().exportJsonChildren(json_dict)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        if SaveNodeDict:
            node_dict[node] = self 
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('value', node)
        if value is not None and 'value' not in already_processed:
            already_processed.add('value')
            self.value = value
            self.value = ' '.join(self.value.split())
            self.validate_BiologicallyDerivedProductCategoryEnum(self.value)    # validate type BiologicallyDerivedProductCategoryEnum
        super(BiologicallyDerivedProductCategory, self)._buildAttributes(node, attrs, already_processed)
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        super(BiologicallyDerivedProductCategory, self)._buildChildren(child_, node, nodeName_, True)
        pass
# end class BiologicallyDerivedProductCategory


class BiologicallyDerivedProductStatus(Element):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = Element
    def __init__(self, id: 'string_primitive' = None, extension: List_['Extension'] = None, value: 'BiologicallyDerivedProductStatusEnum' = None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        super(globals().get("BiologicallyDerivedProductStatus"), self).__init__(id, extension,  **kwargs_)
        self.value = _cast(None, value)
        self.value_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, BiologicallyDerivedProductStatus)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if BiologicallyDerivedProductStatus.subclass:
            return BiologicallyDerivedProductStatus.subclass(*args_, **kwargs_)
        else:
            return BiologicallyDerivedProductStatus(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_value(self):
        return self.value
    def set_value(self, value):
        self.value = value
    def validate_BiologicallyDerivedProductStatusEnum(self, value):
        # Validate type BiologicallyDerivedProductStatusEnum, a restriction on code-primitive.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['available', 'unavailable']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on BiologicallyDerivedProductStatusEnum' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
            if len(value) < 1:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd minLength restriction on BiologicallyDerivedProductStatusEnum' % {"value" : value, "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_BiologicallyDerivedProductStatusEnum_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_BiologicallyDerivedProductStatusEnum_patterns_, ))
    validate_BiologicallyDerivedProductStatusEnum_patterns_ = [['^([^\\s]+(\\s[^\\s]+)*)$']]
    def has__content(self):
        if (
            super(BiologicallyDerivedProductStatus, self).has__content()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='BiologicallyDerivedProductStatus', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('BiologicallyDerivedProductStatus')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'BiologicallyDerivedProductStatus':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='BiologicallyDerivedProductStatus')
        if self.has__content():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='BiologicallyDerivedProductStatus', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='BiologicallyDerivedProductStatus'):
        super(BiologicallyDerivedProductStatus, self)._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='BiologicallyDerivedProductStatus')
        if self.value is not None and 'value' not in already_processed:
            already_processed.add('value')
            outfile.write(' value=%s' % (quote_attrib(self.value), ))
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='BiologicallyDerivedProductStatus', fromsubclass_=False, pretty_print=True):
        super(BiologicallyDerivedProductStatus, self)._exportChildren(outfile, level, namespaceprefix_, namespacedef_, name_, True, pretty_print=pretty_print)
    def exportJson(self, parent_dict=None, key=None, is_list=False):
        json_dict = dict()
        self.exportJsonAttributes(json_dict)
        self.exportJsonChildren(json_dict)
        return self.exportJsonResult(json_dict, parent_dict, key, is_list)
    def exportJsonResult(self, json_dict, parent_dict, key, is_list, sub_defs=[], attr_defs=['value']):
        return super().exportJsonResult(json_dict, parent_dict, key, is_list, attr_defs)
    def exportJsonAttributes(self, json_dict):
        super().exportJsonAttributes(json_dict)
        if self.value is not None:
            json_dict['value'] = self.value
    def exportJsonChildren(self, json_dict):
        super().exportJsonChildren(json_dict)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        if SaveNodeDict:
            node_dict[node] = self 
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('value', node)
        if value is not None and 'value' not in already_processed:
            already_processed.add('value')
            self.value = value
            self.value = ' '.join(self.value.split())
            self.validate_BiologicallyDerivedProductStatusEnum(self.value)    # validate type BiologicallyDerivedProductStatusEnum
        super(BiologicallyDerivedProductStatus, self)._buildAttributes(node, attrs, already_processed)
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        super(BiologicallyDerivedProductStatus, self)._buildChildren(child_, node, nodeName_, True)
        pass
# end class BiologicallyDerivedProductStatus


class BiologicallyDerivedProductStorageScale(Element):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = Element
    def __init__(self, id: 'string_primitive' = None, extension: List_['Extension'] = None, value: 'BiologicallyDerivedProductStorageScaleEnum' = None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        super(globals().get("BiologicallyDerivedProductStorageScale"), self).__init__(id, extension,  **kwargs_)
        self.value = _cast(None, value)
        self.value_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, BiologicallyDerivedProductStorageScale)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if BiologicallyDerivedProductStorageScale.subclass:
            return BiologicallyDerivedProductStorageScale.subclass(*args_, **kwargs_)
        else:
            return BiologicallyDerivedProductStorageScale(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_value(self):
        return self.value
    def set_value(self, value):
        self.value = value
    def validate_BiologicallyDerivedProductStorageScaleEnum(self, value):
        # Validate type BiologicallyDerivedProductStorageScaleEnum, a restriction on code-primitive.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['farenheit', 'celsius', 'kelvin']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on BiologicallyDerivedProductStorageScaleEnum' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
            if len(value) < 1:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd minLength restriction on BiologicallyDerivedProductStorageScaleEnum' % {"value" : value, "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_BiologicallyDerivedProductStorageScaleEnum_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_BiologicallyDerivedProductStorageScaleEnum_patterns_, ))
    validate_BiologicallyDerivedProductStorageScaleEnum_patterns_ = [['^([^\\s]+(\\s[^\\s]+)*)$']]
    def has__content(self):
        if (
            super(BiologicallyDerivedProductStorageScale, self).has__content()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='BiologicallyDerivedProductStorageScale', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('BiologicallyDerivedProductStorageScale')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'BiologicallyDerivedProductStorageScale':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='BiologicallyDerivedProductStorageScale')
        if self.has__content():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='BiologicallyDerivedProductStorageScale', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='BiologicallyDerivedProductStorageScale'):
        super(BiologicallyDerivedProductStorageScale, self)._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='BiologicallyDerivedProductStorageScale')
        if self.value is not None and 'value' not in already_processed:
            already_processed.add('value')
            outfile.write(' value=%s' % (quote_attrib(self.value), ))
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='BiologicallyDerivedProductStorageScale', fromsubclass_=False, pretty_print=True):
        super(BiologicallyDerivedProductStorageScale, self)._exportChildren(outfile, level, namespaceprefix_, namespacedef_, name_, True, pretty_print=pretty_print)
    def exportJson(self, parent_dict=None, key=None, is_list=False):
        json_dict = dict()
        self.exportJsonAttributes(json_dict)
        self.exportJsonChildren(json_dict)
        return self.exportJsonResult(json_dict, parent_dict, key, is_list)
    def exportJsonResult(self, json_dict, parent_dict, key, is_list, sub_defs=[], attr_defs=['value']):
        return super().exportJsonResult(json_dict, parent_dict, key, is_list, attr_defs)
    def exportJsonAttributes(self, json_dict):
        super().exportJsonAttributes(json_dict)
        if self.value is not None:
            json_dict['value'] = self.value
    def exportJsonChildren(self, json_dict):
        super().exportJsonChildren(json_dict)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        if SaveNodeDict:
            node_dict[node] = self 
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('value', node)
        if value is not None and 'value' not in already_processed:
            already_processed.add('value')
            self.value = value
            self.value = ' '.join(self.value.split())
            self.validate_BiologicallyDerivedProductStorageScaleEnum(self.value)    # validate type BiologicallyDerivedProductStorageScaleEnum
        super(BiologicallyDerivedProductStorageScale, self)._buildAttributes(node, attrs, already_processed)
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        super(BiologicallyDerivedProductStorageScale, self)._buildChildren(child_, node, nodeName_, True)
        pass
# end class BiologicallyDerivedProductStorageScale


class Bundle(Resource):
    """identifier -- A persistent identifier for the bundle that won't change as a bundle is copied from server to server.
    type -- Indicates the purpose of this bundle - how it is intended to be used.
    timestamp -- The date/time that the bundle was assembled - i.e. when the resources were placed in the bundle.
    total -- If a set of search matches, this is the total number of entries of type 'match' across all pages in the search.  It does not include search.mode = 'include' or 'outcome' entries and it does not provide a count of the number of entries in the Bundle.
    link -- A series of links that provide context to this bundle.
    entry -- An entry in a bundle resource - will either contain a resource or information about a resource (transactions and history only).
    signature -- Digital Signature - base64 encoded. XML-DSig or a JWT.
    
    """
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = Resource
    def __init__(self, id: 'string' = None, meta: 'Meta' = None, implicitRules: 'uri' = None, language: 'code' = None, identifier: 'Identifier' = None, type_: 'BundleType' = None, timestamp: 'instant' = None, total: 'unsignedInt' = None, link: List_['Bundle.Link'] = None, entry: List_['Bundle.Entry'] = None, signature: 'Signature' = None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        super(globals().get("Bundle"), self).__init__(id, meta, implicitRules, language,  **kwargs_)
        self.identifier = identifier
        self.identifier_nsprefix_ = None
        self.type_ = type_
        self.type__nsprefix_ = None
        self.timestamp = timestamp
        self.timestamp_nsprefix_ = None
        self.total = total
        self.total_nsprefix_ = None
        if link is None:
            self.link = []
        else:
            self.link = link
        self.link_nsprefix_ = None
        if entry is None:
            self.entry = []
        else:
            self.entry = entry
        self.entry_nsprefix_ = None
        self.signature = signature
        self.signature_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, Bundle)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if Bundle.subclass:
            return Bundle.subclass(*args_, **kwargs_)
        else:
            return Bundle(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_identifier(self):
        return self.identifier
    def set_identifier(self, identifier):
        self.identifier = identifier
    def get_type(self):
        return self.type_
    def set_type(self, type_):
        self.type_ = type_
    def get_timestamp(self):
        return self.timestamp
    def set_timestamp(self, timestamp):
        self.timestamp = timestamp
    def get_total(self):
        return self.total
    def set_total(self, total):
        self.total = total
    def get_link(self):
        return self.link
    def set_link(self, link):
        self.link = link
    def add_link(self, value):
        self.link.append(value)
    def insert_link_at(self, index, value):
        self.link.insert(index, value)
    def replace_link_at(self, index, value):
        self.link[index] = value
    def get_entry(self):
        return self.entry
    def set_entry(self, entry):
        self.entry = entry
    def add_entry(self, value):
        self.entry.append(value)
    def insert_entry_at(self, index, value):
        self.entry.insert(index, value)
    def replace_entry_at(self, index, value):
        self.entry[index] = value
    def get_signature(self):
        return self.signature
    def set_signature(self, signature):
        self.signature = signature
    def has__content(self):
        if (
            self.identifier is not None or
            self.type_ is not None or
            self.timestamp is not None or
            self.total is not None or
            self.link or
            self.entry or
            self.signature is not None or
            super(Bundle, self).has__content()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_=' xmlns:None="http://hl7.org/fhir" ', name_='Bundle', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('Bundle')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'Bundle':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='Bundle')
        if self.has__content():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='Bundle', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='Bundle'):
        super(Bundle, self)._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='Bundle')
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_=' xmlns:None="http://hl7.org/fhir" ', name_='Bundle', fromsubclass_=False, pretty_print=True):
        super(Bundle, self)._exportChildren(outfile, level, namespaceprefix_, namespacedef_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.identifier is not None:
            namespaceprefix_ = self.identifier_nsprefix_ + ':' if (UseCapturedNS_ and self.identifier_nsprefix_) else ''
            self.identifier.export(outfile, level, namespaceprefix_, namespacedef_='', name_='identifier', pretty_print=pretty_print)
        if self.type_ is not None:
            namespaceprefix_ = self.type__nsprefix_ + ':' if (UseCapturedNS_ and self.type__nsprefix_) else ''
            self.type_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='type', pretty_print=pretty_print)
        if self.timestamp is not None:
            namespaceprefix_ = self.timestamp_nsprefix_ + ':' if (UseCapturedNS_ and self.timestamp_nsprefix_) else ''
            self.timestamp.export(outfile, level, namespaceprefix_, namespacedef_='', name_='timestamp', pretty_print=pretty_print)
        if self.total is not None:
            namespaceprefix_ = self.total_nsprefix_ + ':' if (UseCapturedNS_ and self.total_nsprefix_) else ''
            self.total.export(outfile, level, namespaceprefix_, namespacedef_='', name_='total', pretty_print=pretty_print)
        for link_ in self.link:
            namespaceprefix_ = self.link_nsprefix_ + ':' if (UseCapturedNS_ and self.link_nsprefix_) else ''
            link_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='link', pretty_print=pretty_print)
        for entry_ in self.entry:
            namespaceprefix_ = self.entry_nsprefix_ + ':' if (UseCapturedNS_ and self.entry_nsprefix_) else ''
            entry_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='entry', pretty_print=pretty_print)
        if self.signature is not None:
            namespaceprefix_ = self.signature_nsprefix_ + ':' if (UseCapturedNS_ and self.signature_nsprefix_) else ''
            self.signature.export(outfile, level, namespaceprefix_, namespacedef_='', name_='signature', pretty_print=pretty_print)
    def exportJson(self, parent_dict=None, key=None, is_list=False):
        json_dict = dict()
        self.exportJsonAttributes(json_dict)
        self.exportJsonChildren(json_dict)
        return self.exportJsonResult(json_dict, parent_dict, key, is_list)
    def exportJsonResult(self, json_dict, parent_dict, key, is_list, sub_defs=[], attr_defs=[]):
        return super().exportJsonResult(json_dict, parent_dict, key, is_list, attr_defs)
    def exportJsonAttributes(self, json_dict):
        super().exportJsonAttributes(json_dict)
    def exportJsonChildren(self, json_dict):
        super().exportJsonChildren(json_dict)
        if self.identifier is not None:
            child_dict = self.identifier.exportJson(json_dict, 'identifier', False)
            if child_dict:
                json_dict['identifier'] = child_dict
        if self.type_ is not None:
            child_dict = self.type_.exportJson(json_dict, 'type', False)
            if child_dict:
                json_dict['type'] = child_dict
        if self.timestamp is not None:
            child_dict = self.timestamp.exportJson(json_dict, 'timestamp', False)
            if child_dict:
                json_dict['timestamp'] = child_dict
        if self.total is not None:
            child_dict = self.total.exportJson(json_dict, 'total', False)
            if child_dict:
                json_dict['total'] = child_dict
        child_list = []
        for child in self.link:
            child_dict = child.exportJson(json_dict, 'link', True)
            if child_dict:
                child_list.append(child_dict)
        if child_list:
            json_dict['link'] = child_list
        child_list = []
        for child in self.entry:
            child_dict = child.exportJson(json_dict, 'entry', True)
            if child_dict:
                child_list.append(child_dict)
        if child_list:
            json_dict['entry'] = child_list
        if self.signature is not None:
            child_dict = self.signature.exportJson(json_dict, 'signature', False)
            if child_dict:
                json_dict['signature'] = child_dict
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        if SaveNodeDict:
            node_dict[node] = self 
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        super(Bundle, self)._buildAttributes(node, attrs, already_processed)
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'identifier':
            obj_ = Identifier.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.identifier = obj_
            obj_.original_tagname_ = 'identifier'
        elif nodeName_ == 'type':
            obj_ = BundleType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.type_ = obj_
            obj_.original_tagname_ = 'type'
        elif nodeName_ == 'timestamp':
            obj_ = instant.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.timestamp = obj_
            obj_.original_tagname_ = 'timestamp'
        elif nodeName_ == 'total':
            obj_ = unsignedInt.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.total = obj_
            obj_.original_tagname_ = 'total'
        elif nodeName_ == 'link':
            obj_ = Bundle_Link.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.link.append(obj_)
            obj_.original_tagname_ = 'link'
        elif nodeName_ == 'entry':
            obj_ = Bundle_Entry.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.entry.append(obj_)
            obj_.original_tagname_ = 'entry'
        elif nodeName_ == 'signature':
            obj_ = Signature.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.signature = obj_
            obj_.original_tagname_ = 'signature'
        super(Bundle, self)._buildChildren(child_, node, nodeName_, True)
# end class Bundle


class HTTPVerb(Element):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = Element
    def __init__(self, id: 'string_primitive' = None, extension: List_['Extension'] = None, value: 'HTTPVerbEnum' = None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        super(globals().get("HTTPVerb"), self).__init__(id, extension,  **kwargs_)
        self.value = _cast(None, value)
        self.value_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, HTTPVerb)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if HTTPVerb.subclass:
            return HTTPVerb.subclass(*args_, **kwargs_)
        else:
            return HTTPVerb(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_value(self):
        return self.value
    def set_value(self, value):
        self.value = value
    def validate_HTTPVerbEnum(self, value):
        # Validate type HTTPVerbEnum, a restriction on code-primitive.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['GET', 'HEAD', 'POST', 'PUT', 'DELETE', 'PATCH']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on HTTPVerbEnum' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
            if len(value) < 1:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd minLength restriction on HTTPVerbEnum' % {"value" : value, "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_HTTPVerbEnum_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_HTTPVerbEnum_patterns_, ))
    validate_HTTPVerbEnum_patterns_ = [['^([^\\s]+(\\s[^\\s]+)*)$']]
    def has__content(self):
        if (
            super(HTTPVerb, self).has__content()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='HTTPVerb', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('HTTPVerb')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'HTTPVerb':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='HTTPVerb')
        if self.has__content():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='HTTPVerb', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='HTTPVerb'):
        super(HTTPVerb, self)._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='HTTPVerb')
        if self.value is not None and 'value' not in already_processed:
            already_processed.add('value')
            outfile.write(' value=%s' % (quote_attrib(self.value), ))
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='HTTPVerb', fromsubclass_=False, pretty_print=True):
        super(HTTPVerb, self)._exportChildren(outfile, level, namespaceprefix_, namespacedef_, name_, True, pretty_print=pretty_print)
    def exportJson(self, parent_dict=None, key=None, is_list=False):
        json_dict = dict()
        self.exportJsonAttributes(json_dict)
        self.exportJsonChildren(json_dict)
        return self.exportJsonResult(json_dict, parent_dict, key, is_list)
    def exportJsonResult(self, json_dict, parent_dict, key, is_list, sub_defs=[], attr_defs=['value']):
        return super().exportJsonResult(json_dict, parent_dict, key, is_list, attr_defs)
    def exportJsonAttributes(self, json_dict):
        super().exportJsonAttributes(json_dict)
        if self.value is not None:
            json_dict['value'] = self.value
    def exportJsonChildren(self, json_dict):
        super().exportJsonChildren(json_dict)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        if SaveNodeDict:
            node_dict[node] = self 
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('value', node)
        if value is not None and 'value' not in already_processed:
            already_processed.add('value')
            self.value = value
            self.value = ' '.join(self.value.split())
            self.validate_HTTPVerbEnum(self.value)    # validate type HTTPVerbEnum
        super(HTTPVerb, self)._buildAttributes(node, attrs, already_processed)
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        super(HTTPVerb, self)._buildChildren(child_, node, nodeName_, True)
        pass
# end class HTTPVerb


class BundleType(Element):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = Element
    def __init__(self, id: 'string_primitive' = None, extension: List_['Extension'] = None, value: 'BundleTypeEnum' = None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        super(globals().get("BundleType"), self).__init__(id, extension,  **kwargs_)
        self.value = _cast(None, value)
        self.value_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, BundleType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if BundleType.subclass:
            return BundleType.subclass(*args_, **kwargs_)
        else:
            return BundleType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_value(self):
        return self.value
    def set_value(self, value):
        self.value = value
    def validate_BundleTypeEnum(self, value):
        # Validate type BundleTypeEnum, a restriction on code-primitive.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['document', 'message', 'transaction', 'transaction-response', 'batch', 'batch-response', 'history', 'searchset', 'collection']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on BundleTypeEnum' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
            if len(value) < 1:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd minLength restriction on BundleTypeEnum' % {"value" : value, "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_BundleTypeEnum_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_BundleTypeEnum_patterns_, ))
    validate_BundleTypeEnum_patterns_ = [['^([^\\s]+(\\s[^\\s]+)*)$']]
    def has__content(self):
        if (
            super(BundleType, self).has__content()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='BundleType', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('BundleType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'BundleType':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='BundleType')
        if self.has__content():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='BundleType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='BundleType'):
        super(BundleType, self)._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='BundleType')
        if self.value is not None and 'value' not in already_processed:
            already_processed.add('value')
            outfile.write(' value=%s' % (quote_attrib(self.value), ))
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='BundleType', fromsubclass_=False, pretty_print=True):
        super(BundleType, self)._exportChildren(outfile, level, namespaceprefix_, namespacedef_, name_, True, pretty_print=pretty_print)
    def exportJson(self, parent_dict=None, key=None, is_list=False):
        json_dict = dict()
        self.exportJsonAttributes(json_dict)
        self.exportJsonChildren(json_dict)
        return self.exportJsonResult(json_dict, parent_dict, key, is_list)
    def exportJsonResult(self, json_dict, parent_dict, key, is_list, sub_defs=[], attr_defs=['value']):
        return super().exportJsonResult(json_dict, parent_dict, key, is_list, attr_defs)
    def exportJsonAttributes(self, json_dict):
        super().exportJsonAttributes(json_dict)
        if self.value is not None:
            json_dict['value'] = self.value
    def exportJsonChildren(self, json_dict):
        super().exportJsonChildren(json_dict)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        if SaveNodeDict:
            node_dict[node] = self 
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('value', node)
        if value is not None and 'value' not in already_processed:
            already_processed.add('value')
            self.value = value
            self.value = ' '.join(self.value.split())
            self.validate_BundleTypeEnum(self.value)    # validate type BundleTypeEnum
        super(BundleType, self)._buildAttributes(node, attrs, already_processed)
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        super(BundleType, self)._buildChildren(child_, node, nodeName_, True)
        pass
# end class BundleType


class SearchEntryMode(Element):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = Element
    def __init__(self, id: 'string_primitive' = None, extension: List_['Extension'] = None, value: 'SearchEntryModeEnum' = None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        super(globals().get("SearchEntryMode"), self).__init__(id, extension,  **kwargs_)
        self.value = _cast(None, value)
        self.value_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, SearchEntryMode)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if SearchEntryMode.subclass:
            return SearchEntryMode.subclass(*args_, **kwargs_)
        else:
            return SearchEntryMode(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_value(self):
        return self.value
    def set_value(self, value):
        self.value = value
    def validate_SearchEntryModeEnum(self, value):
        # Validate type SearchEntryModeEnum, a restriction on code-primitive.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['match', 'include', 'outcome']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on SearchEntryModeEnum' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
            if len(value) < 1:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd minLength restriction on SearchEntryModeEnum' % {"value" : value, "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_SearchEntryModeEnum_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_SearchEntryModeEnum_patterns_, ))
    validate_SearchEntryModeEnum_patterns_ = [['^([^\\s]+(\\s[^\\s]+)*)$']]
    def has__content(self):
        if (
            super(SearchEntryMode, self).has__content()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='SearchEntryMode', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('SearchEntryMode')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'SearchEntryMode':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='SearchEntryMode')
        if self.has__content():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='SearchEntryMode', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='SearchEntryMode'):
        super(SearchEntryMode, self)._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='SearchEntryMode')
        if self.value is not None and 'value' not in already_processed:
            already_processed.add('value')
            outfile.write(' value=%s' % (quote_attrib(self.value), ))
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='SearchEntryMode', fromsubclass_=False, pretty_print=True):
        super(SearchEntryMode, self)._exportChildren(outfile, level, namespaceprefix_, namespacedef_, name_, True, pretty_print=pretty_print)
    def exportJson(self, parent_dict=None, key=None, is_list=False):
        json_dict = dict()
        self.exportJsonAttributes(json_dict)
        self.exportJsonChildren(json_dict)
        return self.exportJsonResult(json_dict, parent_dict, key, is_list)
    def exportJsonResult(self, json_dict, parent_dict, key, is_list, sub_defs=[], attr_defs=['value']):
        return super().exportJsonResult(json_dict, parent_dict, key, is_list, attr_defs)
    def exportJsonAttributes(self, json_dict):
        super().exportJsonAttributes(json_dict)
        if self.value is not None:
            json_dict['value'] = self.value
    def exportJsonChildren(self, json_dict):
        super().exportJsonChildren(json_dict)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        if SaveNodeDict:
            node_dict[node] = self 
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('value', node)
        if value is not None and 'value' not in already_processed:
            already_processed.add('value')
            self.value = value
            self.value = ' '.join(self.value.split())
            self.validate_SearchEntryModeEnum(self.value)    # validate type SearchEntryModeEnum
        super(SearchEntryMode, self)._buildAttributes(node, attrs, already_processed)
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        super(SearchEntryMode, self)._buildChildren(child_, node, nodeName_, True)
        pass
# end class SearchEntryMode


class CapabilityStatementKind(Element):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = Element
    def __init__(self, id: 'string_primitive' = None, extension: List_['Extension'] = None, value: 'CapabilityStatementKindEnum' = None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        super(globals().get("CapabilityStatementKind"), self).__init__(id, extension,  **kwargs_)
        self.value = _cast(None, value)
        self.value_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, CapabilityStatementKind)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if CapabilityStatementKind.subclass:
            return CapabilityStatementKind.subclass(*args_, **kwargs_)
        else:
            return CapabilityStatementKind(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_value(self):
        return self.value
    def set_value(self, value):
        self.value = value
    def validate_CapabilityStatementKindEnum(self, value):
        # Validate type CapabilityStatementKindEnum, a restriction on code-primitive.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['instance', 'capability', 'requirements']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on CapabilityStatementKindEnum' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
            if len(value) < 1:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd minLength restriction on CapabilityStatementKindEnum' % {"value" : value, "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_CapabilityStatementKindEnum_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_CapabilityStatementKindEnum_patterns_, ))
    validate_CapabilityStatementKindEnum_patterns_ = [['^([^\\s]+(\\s[^\\s]+)*)$']]
    def has__content(self):
        if (
            super(CapabilityStatementKind, self).has__content()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='CapabilityStatementKind', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('CapabilityStatementKind')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'CapabilityStatementKind':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='CapabilityStatementKind')
        if self.has__content():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='CapabilityStatementKind', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='CapabilityStatementKind'):
        super(CapabilityStatementKind, self)._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='CapabilityStatementKind')
        if self.value is not None and 'value' not in already_processed:
            already_processed.add('value')
            outfile.write(' value=%s' % (quote_attrib(self.value), ))
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='CapabilityStatementKind', fromsubclass_=False, pretty_print=True):
        super(CapabilityStatementKind, self)._exportChildren(outfile, level, namespaceprefix_, namespacedef_, name_, True, pretty_print=pretty_print)
    def exportJson(self, parent_dict=None, key=None, is_list=False):
        json_dict = dict()
        self.exportJsonAttributes(json_dict)
        self.exportJsonChildren(json_dict)
        return self.exportJsonResult(json_dict, parent_dict, key, is_list)
    def exportJsonResult(self, json_dict, parent_dict, key, is_list, sub_defs=[], attr_defs=['value']):
        return super().exportJsonResult(json_dict, parent_dict, key, is_list, attr_defs)
    def exportJsonAttributes(self, json_dict):
        super().exportJsonAttributes(json_dict)
        if self.value is not None:
            json_dict['value'] = self.value
    def exportJsonChildren(self, json_dict):
        super().exportJsonChildren(json_dict)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        if SaveNodeDict:
            node_dict[node] = self 
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('value', node)
        if value is not None and 'value' not in already_processed:
            already_processed.add('value')
            self.value = value
            self.value = ' '.join(self.value.split())
            self.validate_CapabilityStatementKindEnum(self.value)    # validate type CapabilityStatementKindEnum
        super(CapabilityStatementKind, self)._buildAttributes(node, attrs, already_processed)
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        super(CapabilityStatementKind, self)._buildChildren(child_, node, nodeName_, True)
        pass
# end class CapabilityStatementKind


class EventCapabilityMode(Element):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = Element
    def __init__(self, id: 'string_primitive' = None, extension: List_['Extension'] = None, value: 'EventCapabilityModeEnum' = None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        super(globals().get("EventCapabilityMode"), self).__init__(id, extension,  **kwargs_)
        self.value = _cast(None, value)
        self.value_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, EventCapabilityMode)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if EventCapabilityMode.subclass:
            return EventCapabilityMode.subclass(*args_, **kwargs_)
        else:
            return EventCapabilityMode(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_value(self):
        return self.value
    def set_value(self, value):
        self.value = value
    def validate_EventCapabilityModeEnum(self, value):
        # Validate type EventCapabilityModeEnum, a restriction on code-primitive.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['sender', 'receiver']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on EventCapabilityModeEnum' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
            if len(value) < 1:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd minLength restriction on EventCapabilityModeEnum' % {"value" : value, "lineno": lineno} )
                result = False
            if not self.gds_validate_simple_patterns(
                    self.validate_EventCapabilityModeEnum_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_EventCapabilityModeEnum_patterns_, ))
    validate_Event