# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class DeliveryRule(Model):
    """A rule that specifies a set of actions and conditions.

    All required parameters must be populated in order to send to Azure.

    :param order: Required. The order in which the rules are applied for the
     endpoint. Possible values {0,1,2,3,………}. A rule with a lesser order will
     be applied before a rule with a greater order. Rule with order 0 is a
     special rule. It does not require any condition and actions listed in it
     will always be applied.
    :type order: int
    :param actions: Required. A list of actions that are executed when all the
     conditions of a rule are satisfied.
    :type actions: list[~azure.mgmt.cdn.models.DeliveryRuleAction]
    :param conditions: A list of conditions that must be matched for the
     actions to be executed
    :type conditions: list[~azure.mgmt.cdn.models.DeliveryRuleCondition]
    """

    _validation = {
        'order': {'required': True},
        'actions': {'required': True},
    }

    _attribute_map = {
        'order': {'key': 'order', 'type': 'int'},
        'actions': {'key': 'actions', 'type': '[DeliveryRuleAction]'},
        'conditions': {'key': 'conditions', 'type': '[DeliveryRuleCondition]'},
    }

    def __init__(self, **kwargs):
        super(DeliveryRule, self).__init__(**kwargs)
        self.order = kwargs.get('order', None)
        self.actions = kwargs.get('actions', None)
        self.conditions = kwargs.get('conditions', None)
