﻿from ._version import __version__  # <- única fonte de verdade

from .curves import PiecewiseFlatCurve
from .models.gbm import RiskNeutralGBM
from .engine.montecarlo import MonteCarloEngine
from .exercise.lsmc import ExerciseSpec
from .payoffs.core import (
PF,
relu,
max_ as max,
min_ as min,
where,
european_call,
european_put,
asian_arith_call,
up_and_out_call,
basket_call,
bs_call_price,
)
from .dsl.spec import price_from_spec, build_engine_from_spec

__all__ = [
"__version__",
"PiecewiseFlatCurve",
"RiskNeutralGBM",
"MonteCarloEngine",
"ExerciseSpec",
"PF",
"relu",
"max",
"min",
"where",
"european_call",
"european_put",
"asian_arith_call",
"up_and_out_call",
"basket_call",
"bs_call_price",
"price_from_spec",
"build_engine_from_spec",
]

