"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.PrivateAssetBucket = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const certificatemanager = require("@aws-cdk/aws-certificatemanager");
const cloudfront = require("@aws-cdk/aws-cloudfront");
const origins = require("@aws-cdk/aws-cloudfront-origins");
const iam = require("@aws-cdk/aws-iam");
const route53 = require("@aws-cdk/aws-route53");
const route53Targets = require("@aws-cdk/aws-route53-targets");
const s3 = require("@aws-cdk/aws-s3");
const core = require("@aws-cdk/core");
const nodejs_edge_function_1 = require("./nodejs-edge-function");
/**
 * @stability stable
 */
class PrivateAssetBucket extends core.Construct {
    /**
     * @stability stable
     */
    constructor(scope, id, props) {
        var _b;
        super(scope, id);
        let assetBucket;
        if (props.assetBucketNameImport) {
            assetBucket = s3.Bucket.fromBucketName(this, 'Resource', props.assetBucketNameImport);
        }
        else {
            assetBucket = new s3.Bucket(this, 'Resource', {
                bucketName: props.assetBucketName,
            });
        }
        this.assetBucketName = assetBucket.bucketName;
        const imageAccessFunction = new nodejs_edge_function_1.NodejsEdgeFunction(this, 'edge');
        imageAccessFunction.addToRolePolicy(new iam.PolicyStatement({
            actions: [
                'logs:CreateLogGroup',
                'logs:CreateLogStream',
                'logs:PutLogEvents',
            ],
            resources: ['arn:aws:logs:*:*:*'],
        }));
        const assetBucketDomainName = (_b = props.customDomain) === null || _b === void 0 ? void 0 : _b.domainName;
        const assetBucketCert = props.customDomain ? new certificatemanager.DnsValidatedCertificate(this, 'assetBucketCert', {
            domainName: assetBucketDomainName !== null && assetBucketDomainName !== void 0 ? assetBucketDomainName : '',
            hostedZone: props.customDomain.zone,
            region: 'us-east-1',
        }) : undefined;
        const imageCloudfront = new cloudfront.Distribution(this, 'imageCloudfront', {
            certificate: assetBucketCert,
            domainNames: assetBucketDomainName ? [assetBucketDomainName] : undefined,
            defaultBehavior: {
                originRequestPolicy: new cloudfront.OriginRequestPolicy(this, 'originRequestPolicy', {
                    cookieBehavior: cloudfront.OriginRequestCookieBehavior.all(),
                }),
                origin: new origins.S3Origin(assetBucket, {
                    customHeaders: {
                        // Need to ingest the userpool infor through headers as enviornment variables aren't supported for Lambda@Edge
                        'x-env-userpoolid': props.userPoolId,
                        'x-env-clientid': props.userPoolClientId,
                        'x-env-tokenuse': props.tokenUse || 'null',
                    },
                }),
                edgeLambdas: [
                    {
                        functionVersion: imageAccessFunction.currentVersion,
                        eventType: cloudfront.LambdaEdgeEventType.ORIGIN_REQUEST,
                    },
                ],
            },
        });
        this.assetBucketCloudfrontUrl = imageCloudfront.distributionDomainName;
        const assetBucketRecord = props.customDomain ? new route53.ARecord(this, 'assetBucketRecord', {
            recordName: props.customDomain.domainName.split('.')[0],
            target: route53.RecordTarget.fromAlias(new route53Targets.CloudFrontTarget(imageCloudfront)),
            zone: props.customDomain.zone,
        }) : undefined;
        this.assetBucketRecordDomainName = assetBucketRecord === null || assetBucketRecord === void 0 ? void 0 : assetBucketRecord.domainName;
    }
}
exports.PrivateAssetBucket = PrivateAssetBucket;
_a = JSII_RTTI_SYMBOL_1;
PrivateAssetBucket[_a] = { fqn: "cdk-private-asset-bucket.PrivateAssetBucket", version: "1.144.1" };
//# sourceMappingURL=data:application/json;base64,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