# Doxygen stubs generation
import numpy
import typing
Exception = typing.NewType("Exception", None)
Kinematics = typing.NewType("Kinematics", None)
boost_type_index = typing.NewType("boost_type_index", None)
std_type_index = typing.NewType("std_type_index", None)
class Exception:
  def __init__(
    arg1: object,
    arg2: str,
  ) -> None:
    ...

  message: any


class Kinematics:
  def __init__(
    self,
    motor_arm_length: float, # double
    rod_length: float, # double
  ) -> any:
    """
    Create a kinematics object.
    
    :param float motor_arm_length: length of the motor arm 
    :param float rod_length: length of the rods
    """
    ...

  def add_branch(
    self,
    branch_platform: numpy.ndarray, # Eigen::Vector3d
    T_world_motor: numpy.ndarray, # Eigen::Affine3d
    solution: float = 1.0, # double
  ) -> None:
    """
    Adds a branch to the kinematics.
    
    :param numpy.ndarray branch_platform: position of the branch in the platform frame 
    :param numpy.ndarray T_world_motor: transformation matrix from motor to world frame
    """
    ...

  def forward_kinematics(
    self,
    joint_angles: numpy.ndarray, # Eigen::VectorXd
  ) -> numpy.ndarray:
    """
    Update the platform pose estimation based on joint angles.
    
    :param numpy.ndarray joint_angles: vector of joint angles
    """
    ...

  def inverse_kinematics(
    self,
    T_world_platform: numpy.ndarray, # Eigen::Affine3d
  ) -> numpy.ndarray:
    """
    Computes the inverse kinematics for the given platform pose.
    
    :param numpy.ndarray T_world_platform: transformation matrix from platform to world frame
    """
    ...

  line_search_maximum_iterations: int # int

  motor_arm_length: float # double

  def reset_forward_kinematics(
    self,
    T_world_platform: numpy.ndarray, # Eigen::Affine3d
  ) -> None:
    """
    Resets the forward kinematics estimation.
    """
    ...

  rod_length: float # double

  @staticmethod
  def wrap_angle(
    self,
    angle: float, # double
  ) -> float:
    ...


class boost_type_index:
  def __init__(
  ) -> any:
    ...

  def hash_code(
    self: boost_type_index,
  ) -> int:
    """
    Returns an unspecified value (here denoted by hash code) such that for all std::type_info objects referring to the same type, their hash code is the same.
    """
    ...

  def name(
    self: boost_type_index,
  ) -> str:
    """
    Returns an implementation defined null-terminated character string containing the name of the type. No guarantees are given; in particular, the returned string can be identical for several types and change between invocations of the same program.
    """
    ...

  def pretty_name(
    self: boost_type_index,
  ) -> str:
    """
    Human readible name.
    """
    ...


def seed(
  seed_value: int,
) -> None:
  """
  Initialize the pseudo-random number generator with the argument seed_value.
  """
  ...


def sharedMemory(
  value: bool,
) -> None:
  """
  Share the memory when converting from Eigen to Numpy.
  """
  ...


class std_type_index:
  def __init__(
  ) -> any:
    ...

  def hash_code(
    self: std_type_index,
  ) -> int:
    """
    Returns an unspecified value (here denoted by hash code) such that for all std::type_info objects referring to the same type, their hash code is the same.
    """
    ...

  def name(
    self: std_type_index,
  ) -> str:
    """
    Returns an implementation defined null-terminated character string containing the name of the type. No guarantees are given; in particular, the returned string can be identical for several types and change between invocations of the same program.
    """
    ...

  def pretty_name(
    self: std_type_index,
  ) -> str:
    """
    Human readible name.
    """
    ...


__groups__ = {'reachy_mini_kinematics': ['Kinematics']}
