"""
    Asana

    This is the interface for interacting with the Asana platform  # noqa: E501

    The version of the OpenAPI document: 1.0.0
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from asana_preview.model_utils import (  # noqa: F401
    ApiTypeError,
    ModelComposed,
    ModelNormal,
    ModelSimple,
    cached_property,
    change_keys_js_to_python,
    convert_js_args_to_python_args,
    date,
    datetime,
    file_type,
    none_type,
    validate_get_composed_info,
    OpenApiModel
)
from asana_preview.exceptions import ApiAttributeError


def lazy_import():
    from asana_preview.model.custom_field_base_all_of import CustomFieldBaseAllOf
    from asana_preview.model.custom_field_compact import CustomFieldCompact
    from asana_preview.model.custom_field_compact_all_of_date_value import CustomFieldCompactAllOfDateValue
    from asana_preview.model.enum_option import EnumOption
    globals()['CustomFieldBaseAllOf'] = CustomFieldBaseAllOf
    globals()['CustomFieldCompact'] = CustomFieldCompact
    globals()['CustomFieldCompactAllOfDateValue'] = CustomFieldCompactAllOfDateValue
    globals()['EnumOption'] = EnumOption


class CustomFieldBase(ModelComposed):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.

    Attributes:
      allowed_values (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          with a capitalized key describing the allowed value and an allowed
          value. These dicts store the allowed enum values.
      attribute_map (dict): The key is attribute name
          and the value is json key in definition.
      discriminator_value_class_map (dict): A dict to go from the discriminator
          variable value to the discriminator class name.
      validations (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          that stores validations for max_length, min_length, max_items,
          min_items, exclusive_maximum, inclusive_maximum, exclusive_minimum,
          inclusive_minimum, and regex.
      additional_properties_type (tuple): A tuple of classes accepted
          as additional properties values.
    """

    allowed_values = {
        ('resource_subtype',): {
            'TEXT': "text",
            'ENUM': "enum",
            'MULTI_ENUM': "multi_enum",
            'NUMBER': "number",
            'DATE': "date",
            'PEOPLE': "people",
        },
        ('type',): {
            'TEXT': "text",
            'ENUM': "enum",
            'MULTI_ENUM': "multi_enum",
            'NUMBER': "number",
        },
        ('format',): {
            'CURRENCY': "currency",
            'IDENTIFIER': "identifier",
            'PERCENTAGE': "percentage",
            'CUSTOM': "custom",
            'NONE': "none",
        },
        ('custom_label_position',): {
            'PREFIX': "prefix",
            'SUFFIX': "suffix",
        },
    }

    validations = {
    }

    @cached_property
    def additional_properties_type():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded
        """
        lazy_import()
        return (bool, date, datetime, dict, float, int, list, str, none_type,)  # noqa: E501

    _nullable = False

    @cached_property
    def openapi_types():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded

        Returns
            openapi_types (dict): The key is attribute name
                and the value is attribute type.
        """
        lazy_import()
        return {
            'gid': (str,),  # noqa: E501
            'resource_type': (bool, date, datetime, dict, float, int, list, str, none_type,),  # noqa: E501
            'name': (str,),  # noqa: E501
            'resource_subtype': (str,),  # noqa: E501
            'type': (str,),  # noqa: E501
            'enum_options': ([EnumOption],),  # noqa: E501
            'enabled': (bool,),  # noqa: E501
            'date_value': (CustomFieldCompactAllOfDateValue,),  # noqa: E501
            'enum_value': (bool, date, datetime, dict, float, int, list, str, none_type,),  # noqa: E501
            'multi_enum_values': ([EnumOption],),  # noqa: E501
            'number_value': (float,),  # noqa: E501
            'text_value': (str,),  # noqa: E501
            'display_value': (str, none_type,),  # noqa: E501
            'description': (str,),  # noqa: E501
            'precision': (int,),  # noqa: E501
            'format': (str,),  # noqa: E501
            'currency_code': (str, none_type,),  # noqa: E501
            'custom_label': (str, none_type,),  # noqa: E501
            'custom_label_position': (str,),  # noqa: E501
            'has_notifications_enabled': (bool,),  # noqa: E501
        }

    @cached_property
    def discriminator():
        return None


    attribute_map = {
        'gid': 'gid',  # noqa: E501
        'resource_type': 'resource_type',  # noqa: E501
        'name': 'name',  # noqa: E501
        'resource_subtype': 'resource_subtype',  # noqa: E501
        'type': 'type',  # noqa: E501
        'enum_options': 'enum_options',  # noqa: E501
        'enabled': 'enabled',  # noqa: E501
        'date_value': 'date_value',  # noqa: E501
        'enum_value': 'enum_value',  # noqa: E501
        'multi_enum_values': 'multi_enum_values',  # noqa: E501
        'number_value': 'number_value',  # noqa: E501
        'text_value': 'text_value',  # noqa: E501
        'display_value': 'display_value',  # noqa: E501
        'description': 'description',  # noqa: E501
        'precision': 'precision',  # noqa: E501
        'format': 'format',  # noqa: E501
        'currency_code': 'currency_code',  # noqa: E501
        'custom_label': 'custom_label',  # noqa: E501
        'custom_label_position': 'custom_label_position',  # noqa: E501
        'has_notifications_enabled': 'has_notifications_enabled',  # noqa: E501
    }

    read_only_vars = {
        'gid',  # noqa: E501
        'type',  # noqa: E501
        'display_value',  # noqa: E501
    }

    @classmethod
    @convert_js_args_to_python_args
    def _from_openapi_data(cls, *args, **kwargs):  # noqa: E501
        """CustomFieldBase - a model defined in OpenAPI

        Keyword Args:
            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                allOf includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)
            gid (str): Globally unique identifier of the resource, as a string.. [optional]  # noqa: E501
            resource_type (bool, date, datetime, dict, float, int, list, str, none_type): [optional]  # noqa: E501
            name (str): The name of the custom field.. [optional]  # noqa: E501
            resource_subtype (str): The type of the custom field. Must be one of the given values.. [optional]  # noqa: E501
            type (str): *Deprecated: new integrations should prefer the resource_subtype field.* The type of the custom field. Must be one of the given values.. [optional]  # noqa: E501
            enum_options ([EnumOption]): *Conditional*. Only relevant for custom fields of type `enum`. This array specifies the possible values which an `enum` custom field can adopt. To modify the enum options, refer to [working with enum options](/reference/createenumoptionforcustomfield).. [optional]  # noqa: E501
            enabled (bool): *Conditional*. Determines if the custom field is enabled or not.. [optional]  # noqa: E501
            date_value (CustomFieldCompactAllOfDateValue): [optional]  # noqa: E501
            enum_value (bool, date, datetime, dict, float, int, list, str, none_type): [optional]  # noqa: E501
            multi_enum_values ([EnumOption]): *Conditional*. Only relevant for custom fields of type `multi_enum`. This object is the chosen values of a `multi_enum` custom field.. [optional]  # noqa: E501
            number_value (float): *Conditional*. This number is the value of a `number` custom field.. [optional]  # noqa: E501
            text_value (str): *Conditional*. This string is the value of a `text` custom field.. [optional]  # noqa: E501
            display_value (str, none_type): A string representation for the value of the custom field. Integrations that don't require the underlying type should use this field to read values. Using this field will future-proof an app against new custom field types.. [optional]  # noqa: E501
            description (str): [Opt In](/docs/inputoutput-options). The description of the custom field.. [optional]  # noqa: E501
            precision (int): Only relevant for custom fields of type ‘Number’. This field dictates the number of places after the decimal to round to, i.e. 0 is integer values, 1 rounds to the nearest tenth, and so on. Must be between 0 and 6, inclusive. For percentage format, this may be unintuitive, as a value of 0.25 has a precision of 0, while a value of 0.251 has a precision of 1. This is due to 0.25 being displayed as 25%. The identifier format will always have a precision of 0.. [optional]  # noqa: E501
            format (str): The format of this custom field.. [optional]  # noqa: E501
            currency_code (str, none_type): ISO 4217 currency code to format this custom field. This will be null if the `format` is not `currency`.. [optional]  # noqa: E501
            custom_label (str, none_type): This is the string that appears next to the custom field value. This will be null if the `format` is not `custom`.. [optional]  # noqa: E501
            custom_label_position (str): Only relevant for custom fields with `custom` format. This depicts where to place the custom label. This will be null if the `format` is not `custom`.. [optional]  # noqa: E501
            has_notifications_enabled (bool): *Conditional*. This flag describes whether a follower of a task with this field should receive inbox notifications from changes to this field.. [optional]  # noqa: E501
        """

        _check_type = kwargs.pop('_check_type', True)
        _spec_property_naming = kwargs.pop('_spec_property_naming', False)
        _path_to_item = kwargs.pop('_path_to_item', ())
        _configuration = kwargs.pop('_configuration', None)
        _visited_composed_classes = kwargs.pop('_visited_composed_classes', ())

        self = super(OpenApiModel, cls).__new__(cls)

        if args:
            for arg in args:
                if isinstance(arg, dict):
                    kwargs.update(arg)
                else:
                    raise ApiTypeError(
                        "Invalid positional arguments=%s passed to %s. Remove those invalid positional arguments." % (
                            args,
                            self.__class__.__name__,
                        ),
                        path_to_item=_path_to_item,
                        valid_classes=(self.__class__,),
                    )

        self._data_store = {}
        self._check_type = _check_type
        self._spec_property_naming = _spec_property_naming
        self._path_to_item = _path_to_item
        self._configuration = _configuration
        self._visited_composed_classes = _visited_composed_classes + (self.__class__,)

        constant_args = {
            '_check_type': _check_type,
            '_path_to_item': _path_to_item,
            '_spec_property_naming': _spec_property_naming,
            '_configuration': _configuration,
            '_visited_composed_classes': self._visited_composed_classes,
        }
        composed_info = validate_get_composed_info(
            constant_args, kwargs, self)
        self._composed_instances = composed_info[0]
        self._var_name_to_model_instances = composed_info[1]
        self._additional_properties_model_instances = composed_info[2]
        discarded_args = composed_info[3]

        for var_name, var_value in kwargs.items():
            if var_name in discarded_args and \
                        self._configuration is not None and \
                        self._configuration.discard_unknown_keys and \
                        self._additional_properties_model_instances:
                # discard variable.
                continue
            setattr(self, var_name, var_value)

        return self

    required_properties = set([
        '_data_store',
        '_check_type',
        '_spec_property_naming',
        '_path_to_item',
        '_configuration',
        '_visited_composed_classes',
        '_composed_instances',
        '_var_name_to_model_instances',
        '_additional_properties_model_instances',
    ])

    @convert_js_args_to_python_args
    def __init__(self, *args, **kwargs):  # noqa: E501
        """CustomFieldBase - a model defined in OpenAPI

        Keyword Args:
            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                allOf includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)
            gid (str): Globally unique identifier of the resource, as a string.. [optional]  # noqa: E501
            resource_type (bool, date, datetime, dict, float, int, list, str, none_type): [optional]  # noqa: E501
            name (str): The name of the custom field.. [optional]  # noqa: E501
            resource_subtype (str): The type of the custom field. Must be one of the given values.. [optional]  # noqa: E501
            type (str): *Deprecated: new integrations should prefer the resource_subtype field.* The type of the custom field. Must be one of the given values.. [optional]  # noqa: E501
            enum_options ([EnumOption]): *Conditional*. Only relevant for custom fields of type `enum`. This array specifies the possible values which an `enum` custom field can adopt. To modify the enum options, refer to [working with enum options](/reference/createenumoptionforcustomfield).. [optional]  # noqa: E501
            enabled (bool): *Conditional*. Determines if the custom field is enabled or not.. [optional]  # noqa: E501
            date_value (CustomFieldCompactAllOfDateValue): [optional]  # noqa: E501
            enum_value (bool, date, datetime, dict, float, int, list, str, none_type): [optional]  # noqa: E501
            multi_enum_values ([EnumOption]): *Conditional*. Only relevant for custom fields of type `multi_enum`. This object is the chosen values of a `multi_enum` custom field.. [optional]  # noqa: E501
            number_value (float): *Conditional*. This number is the value of a `number` custom field.. [optional]  # noqa: E501
            text_value (str): *Conditional*. This string is the value of a `text` custom field.. [optional]  # noqa: E501
            display_value (str, none_type): A string representation for the value of the custom field. Integrations that don't require the underlying type should use this field to read values. Using this field will future-proof an app against new custom field types.. [optional]  # noqa: E501
            description (str): [Opt In](/docs/inputoutput-options). The description of the custom field.. [optional]  # noqa: E501
            precision (int): Only relevant for custom fields of type ‘Number’. This field dictates the number of places after the decimal to round to, i.e. 0 is integer values, 1 rounds to the nearest tenth, and so on. Must be between 0 and 6, inclusive. For percentage format, this may be unintuitive, as a value of 0.25 has a precision of 0, while a value of 0.251 has a precision of 1. This is due to 0.25 being displayed as 25%. The identifier format will always have a precision of 0.. [optional]  # noqa: E501
            format (str): The format of this custom field.. [optional]  # noqa: E501
            currency_code (str, none_type): ISO 4217 currency code to format this custom field. This will be null if the `format` is not `currency`.. [optional]  # noqa: E501
            custom_label (str, none_type): This is the string that appears next to the custom field value. This will be null if the `format` is not `custom`.. [optional]  # noqa: E501
            custom_label_position (str): Only relevant for custom fields with `custom` format. This depicts where to place the custom label. This will be null if the `format` is not `custom`.. [optional]  # noqa: E501
            has_notifications_enabled (bool): *Conditional*. This flag describes whether a follower of a task with this field should receive inbox notifications from changes to this field.. [optional]  # noqa: E501
        """

        _check_type = kwargs.pop('_check_type', True)
        _spec_property_naming = kwargs.pop('_spec_property_naming', False)
        _path_to_item = kwargs.pop('_path_to_item', ())
        _configuration = kwargs.pop('_configuration', None)
        _visited_composed_classes = kwargs.pop('_visited_composed_classes', ())

        if args:
            for arg in args:
                if isinstance(arg, dict):
                    kwargs.update(arg)
                else:
                    raise ApiTypeError(
                        "Invalid positional arguments=%s passed to %s. Remove those invalid positional arguments." % (
                            args,
                            self.__class__.__name__,
                        ),
                        path_to_item=_path_to_item,
                        valid_classes=(self.__class__,),
                    )

        self._data_store = {}
        self._check_type = _check_type
        self._spec_property_naming = _spec_property_naming
        self._path_to_item = _path_to_item
        self._configuration = _configuration
        self._visited_composed_classes = _visited_composed_classes + (self.__class__,)

        constant_args = {
            '_check_type': _check_type,
            '_path_to_item': _path_to_item,
            '_spec_property_naming': _spec_property_naming,
            '_configuration': _configuration,
            '_visited_composed_classes': self._visited_composed_classes,
        }
        composed_info = validate_get_composed_info(
            constant_args, kwargs, self)
        self._composed_instances = composed_info[0]
        self._var_name_to_model_instances = composed_info[1]
        self._additional_properties_model_instances = composed_info[2]
        discarded_args = composed_info[3]

        for var_name, var_value in kwargs.items():
            if var_name in discarded_args and \
                        self._configuration is not None and \
                        self._configuration.discard_unknown_keys and \
                        self._additional_properties_model_instances:
                # discard variable.
                continue
            setattr(self, var_name, var_value)
            if var_name in self.read_only_vars:
                raise ApiAttributeError(f"`{var_name}` is a read-only attribute. Use `from_openapi_data` to instantiate "
                                     f"class with read only attributes.")

    @cached_property
    def _composed_schemas():
        # we need this here to make our import statements work
        # we must store _composed_schemas in here so the code is only run
        # when we invoke this method. If we kept this at the class
        # level we would get an error because the class level
        # code would be run when this module is imported, and these composed
        # classes don't exist yet because their module has not finished
        # loading
        lazy_import()
        return {
          'anyOf': [
          ],
          'allOf': [
              CustomFieldBaseAllOf,
              CustomFieldCompact,
          ],
          'oneOf': [
          ],
        }
