"""Agent Types and Enums."""

# pylint: disable=no-member, unused-argument, too-many-locals, duplicate-code

# Autogenerated
# DO NOT MODIFY

from dataclasses import dataclass, field

from enum import Enum

from typing import Any, Dict, List, Optional, Tuple, Union

from dataclasses_json import config, dataclass_json


from taegis_sdk_python._consts import TaegisEnum
from taegis_sdk_python.utils import encode_enum, decode_enum


class AgentArch(str, Enum):
    """AgentArch."""

    ARCH_UNKNOWN = "ARCH_UNKNOWN"
    ARCH_X86 = "ARCH_X86"
    ARCH_X64 = "ARCH_X64"
    ARCH_ARM64 = "ARCH_ARM64"


class AgentPlatform(str, Enum):
    """AgentPlatform."""

    WINDOWS = "WINDOWS"
    LINUX = "LINUX"
    MAC = "MAC"


class AgentPkgType(str, Enum):
    """AgentPkgType."""

    DEB = "DEB"
    RPM = "RPM"
    MSI = "MSI"
    PKG = "PKG"
    GPG = "GPG"


class AgentChannel(str, Enum):
    """AgentChannel."""

    STABLE = "STABLE"
    PREVIEW = "PREVIEW"
    BETA = "BETA"
    INTERNAL_PREVIEW = "INTERNAL_PREVIEW"
    DEV = "DEV"
    CANARY = "CANARY"
    QE_PREV = "QE_PREV"
    QE_NEXT = "QE_NEXT"
    WEEKLY = "WEEKLY"
    WEEKLY_NEXT = "WEEKLY_NEXT"


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class MetaData:
    """MetaData."""

    key: Optional[str] = field(default=None, metadata=config(field_name="key"))
    value: Optional[str] = field(default=None, metadata=config(field_name="value"))


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class PackageSignedUrl:
    """PackageSignedUrl."""

    id: Optional[str] = field(default=None, metadata=config(field_name="id"))
    name: Optional[str] = field(default=None, metadata=config(field_name="name"))
    modified_time: Optional[str] = field(
        default=None, metadata=config(field_name="modifiedTime")
    )
    checksum: Optional[str] = field(
        default=None, metadata=config(field_name="checksum")
    )
    size: Optional[int] = field(default=None, metadata=config(field_name="size"))
    signed_url: Optional[str] = field(
        default=None, metadata=config(field_name="signedUrl")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class ReleaseChannelsConfig:
    """ReleaseChannelsConfig."""

    name: Optional[str] = field(default=None, metadata=config(field_name="name"))
    display_name: Optional[str] = field(
        default=None, metadata=config(field_name="displayName")
    )
    description: Optional[str] = field(
        default=None, metadata=config(field_name="description")
    )
    internal: Optional[bool] = field(
        default=None, metadata=config(field_name="internal")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class PackageDownloadInput:
    """PackageDownloadInput."""

    version: Optional[str] = field(default=None, metadata=config(field_name="version"))
    language: Optional[str] = field(
        default=None, metadata=config(field_name="language")
    )
    platform: Optional[Union[AgentPlatform, TaegisEnum]] = field(
        default=None,
        metadata=config(
            encoder=encode_enum,
            decoder=lambda x: decode_enum(AgentPlatform, x),
            field_name="platform",
        ),
    )
    architecture: Optional[Union[AgentArch, TaegisEnum]] = field(
        default=None,
        metadata=config(
            encoder=encode_enum,
            decoder=lambda x: decode_enum(AgentArch, x),
            field_name="architecture",
        ),
    )
    pkg_type: Optional[Union[AgentPkgType, TaegisEnum]] = field(
        default=None,
        metadata=config(
            encoder=encode_enum,
            decoder=lambda x: decode_enum(AgentPkgType, x),
            field_name="pkgType",
        ),
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class Package:
    """Package."""

    id: Optional[str] = field(default=None, metadata=config(field_name="id"))
    name: Optional[str] = field(default=None, metadata=config(field_name="name"))
    version: Optional[str] = field(default=None, metadata=config(field_name="version"))
    modified_time: Optional[str] = field(
        default=None, metadata=config(field_name="modifiedTime")
    )
    checksum: Optional[str] = field(
        default=None, metadata=config(field_name="checksum")
    )
    size: Optional[int] = field(default=None, metadata=config(field_name="size"))
    supported_languages: Optional[List[str]] = field(
        default=None, metadata=config(field_name="supportedLanguages")
    )
    platform: Optional[Union[AgentPlatform, TaegisEnum]] = field(
        default=None,
        metadata=config(
            encoder=encode_enum,
            decoder=lambda x: decode_enum(AgentPlatform, x),
            field_name="platform",
        ),
    )
    pkg_type: Optional[Union[AgentPkgType, TaegisEnum]] = field(
        default=None,
        metadata=config(
            encoder=encode_enum,
            decoder=lambda x: decode_enum(AgentPkgType, x),
            field_name="pkgType",
        ),
    )
    architecture: Optional[Union[AgentArch, TaegisEnum]] = field(
        default=None,
        metadata=config(
            encoder=encode_enum,
            decoder=lambda x: decode_enum(AgentArch, x),
            field_name="architecture",
        ),
    )
    meta_data: Optional[List[MetaData]] = field(
        default=None, metadata=config(field_name="metaData")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class PackageSearchInput:
    """PackageSearchInput."""

    num_recent_versions: Optional[int] = field(
        default=None, metadata=config(field_name="numRecentVersions")
    )
    version: Optional[str] = field(default=None, metadata=config(field_name="version"))
    language: Optional[str] = field(
        default=None, metadata=config(field_name="language")
    )
    platform: Optional[Union[AgentPlatform, TaegisEnum]] = field(
        default=None,
        metadata=config(
            encoder=encode_enum,
            decoder=lambda x: decode_enum(AgentPlatform, x),
            field_name="platform",
        ),
    )
    architecture: Optional[Union[AgentArch, TaegisEnum]] = field(
        default=None,
        metadata=config(
            encoder=encode_enum,
            decoder=lambda x: decode_enum(AgentArch, x),
            field_name="architecture",
        ),
    )
    pkg_type: Optional[Union[AgentPkgType, TaegisEnum]] = field(
        default=None,
        metadata=config(
            encoder=encode_enum,
            decoder=lambda x: decode_enum(AgentPkgType, x),
            field_name="pkgType",
        ),
    )
    channel: Optional[Union[AgentChannel, TaegisEnum]] = field(
        default=None,
        metadata=config(
            encoder=encode_enum,
            decoder=lambda x: decode_enum(AgentChannel, x),
            field_name="channel",
        ),
    )
