"""ContractedEndpoint Types and Enums."""

# pylint: disable=no-member, unused-argument, too-many-locals, duplicate-code

# Autogenerated
# DO NOT MODIFY

from dataclasses import dataclass, field

from enum import Enum

from typing import Any, Dict, List, Optional, Tuple, Union

from dataclasses_json import config, dataclass_json


from taegis_sdk_python._consts import TaegisEnum
from taegis_sdk_python.utils import encode_enum, decode_enum


class ContractedEndpointsAuthzObject(str, Enum):
    """ContractedEndpointsAuthzObject."""

    CONTRACTED_ENDPOINTS = "ContractedEndpoints"


class ContractedEndpointsAuthzAction(str, Enum):
    """ContractedEndpointsAuthzAction."""

    READ = "Read"


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class ContractedEndpoints:
    """ContractedEndpoints."""

    id: Optional[str] = field(default=None, metadata=config(field_name="id"))
    tenant_id: Optional[str] = field(
        default=None, metadata=config(field_name="tenantId")
    )
    endpoint_count: Optional[int] = field(
        default=None, metadata=config(field_name="endpointCount")
    )
    service: Optional[List[str]] = field(
        default=None, metadata=config(field_name="service")
    )
    service_date: Optional[str] = field(
        default=None, metadata=config(field_name="serviceDate")
    )
    created_at: Optional[str] = field(
        default=None, metadata=config(field_name="created_at")
    )
    updated_at: Optional[str] = field(
        default=None, metadata=config(field_name="updated_at")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class EndpointHistory:
    """EndpointHistory."""

    service_date: Optional[str] = field(
        default=None, metadata=config(field_name="serviceDate")
    )
    endpoint_count: Optional[int] = field(
        default=None, metadata=config(field_name="endpointCount")
    )
    error: Optional[str] = field(default=None, metadata=config(field_name="error"))
