"""Datasources Mutation."""

# pylint: disable=no-member, unused-argument, too-many-locals, duplicate-code, wildcard-import, unused-wildcard-import, cyclic-import


# Autogenerated
# DO NOT MODIFY

from __future__ import annotations

import logging
from typing import TYPE_CHECKING, Any, Dict, List, Optional, Tuple, Union

from taegis_sdk_python import GraphQLNoRowsInResultSetError
from taegis_sdk_python._consts import TaegisEnum
from taegis_sdk_python.services.datasources.types import *
from taegis_sdk_python.utils import (
    build_output_string,
    parse_union_result,
    prepare_input,
)

if TYPE_CHECKING:  # pragma: no cover
    from taegis_sdk_python.services.datasources import DatasourcesService

log = logging.getLogger(__name__)


class TaegisSDKDatasourcesMutation:
    """Taegis Datasources Mutation operations."""

    def __init__(self, service: DatasourcesService):
        self.service = service

    def delete_data_source_assets(
        self, delete_asset_input: List[DeleteAssetInput]
    ) -> List[DeletedAsset]:
        """Executes a delete operation on all included data sources for a specified tenant. Returns an array of all
        deleted assets with metadata. Authorization permission is required with delete access to the collector
        object.."""
        endpoint = "deleteDataSourceAssets"

        result = self.service.execute_mutation(
            endpoint=endpoint,
            variables={
                "deleteAssetInput": prepare_input(delete_asset_input),
            },
            output=build_output_string(DeletedAsset),
        )
        if result.get(endpoint) is not None:
            return DeletedAsset.schema().load(
                [r or {} for r in result.get(endpoint)], many=True
            )
        raise GraphQLNoRowsInResultSetError("for mutation deleteDataSourceAssets")
