"""DetectorRegistry Types and Enums."""

# pylint: disable=no-member, unused-argument, too-many-locals, duplicate-code

# Autogenerated
# DO NOT MODIFY

from dataclasses import dataclass, field

from enum import Enum

from typing import Any, Dict, List, Optional, Tuple, Union

from dataclasses_json import config, dataclass_json


from taegis_sdk_python._consts import TaegisEnum
from taegis_sdk_python.utils import encode_enum, decode_enum


class STATE(str, Enum):
    """STATE."""

    DEPLOYED = "deployed"
    RESEARCH = "research"
    DISABLED = "disabled"


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class SearchDetectors:
    """SearchDetectors."""

    ids: Optional[List[str]] = field(default=None, metadata=config(field_name="ids"))
    creator_names: Optional[List[str]] = field(
        default=None, metadata=config(field_name="creatorNames")
    )
    display_names: Optional[List[str]] = field(
        default=None, metadata=config(field_name="displayNames")
    )
    tags: Optional[List[str]] = field(default=None, metadata=config(field_name="tags"))
    maintainers: Optional[List[str]] = field(
        default=None, metadata=config(field_name="maintainers")
    )
    archived: Optional[bool] = field(
        default=None, metadata=config(field_name="archived")
    )
    alerting_rule: Optional[bool] = field(
        default=None, metadata=config(field_name="alertingRule")
    )
    should_compact: Optional[bool] = field(
        default=None, metadata=config(field_name="shouldCompact")
    )
    created_on_or_after: Optional[str] = field(
        default=None, metadata=config(field_name="createdOnOrAfter")
    )
    created_before: Optional[str] = field(
        default=None, metadata=config(field_name="createdBefore")
    )
    updated_on_or_after: Optional[str] = field(
        default=None, metadata=config(field_name="updatedOnOrAfter")
    )
    updated_before: Optional[str] = field(
        default=None, metadata=config(field_name="updatedBefore")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class RegisteredDetector:
    """RegisteredDetector."""

    id: Optional[str] = field(default=None, metadata=config(field_name="id"))
    creator_name: Optional[str] = field(
        default=None, metadata=config(field_name="creatorName")
    )
    display_name: Optional[str] = field(
        default=None, metadata=config(field_name="displayName")
    )
    tags: Optional[List[str]] = field(default=None, metadata=config(field_name="tags"))
    maintainers: Optional[List[str]] = field(
        default=None, metadata=config(field_name="maintainers")
    )
    archived: Optional[bool] = field(
        default=None, metadata=config(field_name="archived")
    )
    alerting_rule: Optional[bool] = field(
        default=None, metadata=config(field_name="alertingRule")
    )
    should_compact: Optional[bool] = field(
        default=None, metadata=config(field_name="shouldCompact")
    )
    created_at: Optional[str] = field(
        default=None, metadata=config(field_name="createdAt")
    )
    updated_at: Optional[str] = field(
        default=None, metadata=config(field_name="updatedAt")
    )
    state: Optional[Union[STATE, TaegisEnum]] = field(
        default=None,
        metadata=config(
            encoder=encode_enum,
            decoder=lambda x: decode_enum(STATE, x),
            field_name="state",
        ),
    )
