"""Events Subscription."""

# pylint: disable=no-member, unused-argument, too-many-locals, duplicate-code, wildcard-import, unused-wildcard-import, cyclic-import


# Autogenerated
# DO NOT MODIFY

from __future__ import annotations

import logging
from typing import TYPE_CHECKING, Any, Dict, List, Optional, Tuple, Union

from taegis_sdk_python import GraphQLNoRowsInResultSetError
from taegis_sdk_python._consts import TaegisEnum
from taegis_sdk_python.services.events.types import *
from taegis_sdk_python.utils import (
    build_output_string,
    parse_union_result,
    prepare_input,
)

if TYPE_CHECKING:  # pragma: no cover
    from taegis_sdk_python.services.events import EventsService

log = logging.getLogger(__name__)


class TaegisSDKEventsSubscription:
    """Taegis Events Subscription operations."""

    def __init__(self, service: EventsService):
        self.service = service

    def event_query(
        self,
        query: str,
        metadata: Optional[Dict[str, Any]] = None,
        options: Optional[EventQueryOptions] = None,
    ) -> List[EventQueryResults]:
        """Evaluate a query string and returns results for the first page of
        each event type covered by the query.."""
        endpoint = "eventQuery"

        result = self.service.execute_subscription(
            endpoint=endpoint,
            variables={
                "query": prepare_input(query),
                "metadata": prepare_input(metadata),
                "options": prepare_input(options),
            },
            output=build_output_string(EventQueryResults),
        )
        if any(r.get(endpoint) for r in result):
            return EventQueryResults.schema().load(
                [r.get(endpoint, {}) or {} for r in result], many=True
            )
        raise GraphQLNoRowsInResultSetError("for subscription eventQuery")

    def event_page(self, id_: str) -> List[EventQueryResults]:
        """Returns the next logical page of results for each of the event types
        covered by the query.."""
        endpoint = "eventPage"

        result = self.service.execute_subscription(
            endpoint=endpoint,
            variables={
                "id": prepare_input(id_),
            },
            output=build_output_string(EventQueryResults),
        )
        if any(r.get(endpoint) for r in result):
            return EventQueryResults.schema().load(
                [r.get(endpoint, {}) or {} for r in result], many=True
            )
        raise GraphQLNoRowsInResultSetError("for subscription eventPage")
