"""Isensor Mutation."""

# pylint: disable=no-member, unused-argument, too-many-locals, duplicate-code, wildcard-import, unused-wildcard-import, cyclic-import


# Autogenerated
# DO NOT MODIFY

from __future__ import annotations

import logging
from typing import TYPE_CHECKING, Any, Dict, List, Optional, Tuple, Union

from taegis_sdk_python import GraphQLNoRowsInResultSetError
from taegis_sdk_python._consts import TaegisEnum
from taegis_sdk_python.services.isensor.types import *
from taegis_sdk_python.utils import (
    build_output_string,
    parse_union_result,
    prepare_input,
)

if TYPE_CHECKING:  # pragma: no cover
    from taegis_sdk_python.services.isensor import IsensorService

log = logging.getLogger(__name__)


class TaegisSDKIsensorMutation:
    """Taegis Isensor Mutation operations."""

    def __init__(self, service: IsensorService):
        self.service = service

    def i_sensor_create_firewall_rules(
        self,
        id_: str,
        action: Union[IsensorRuleActionInput, TaegisEnum],
        input_: List[IsensorFirewallRuleInput],
    ) -> IsensorFirewallRulePayload:
        """iSensor Create Firewall Rules."""
        endpoint = "iSensorCreateFirewallRules"

        result = self.service.execute_mutation(
            endpoint=endpoint,
            variables={
                "id": prepare_input(id_),
                "action": prepare_input(action),
                "input": prepare_input(input_),
            },
            output=build_output_string(IsensorFirewallRulePayload),
        )
        if result.get(endpoint) is not None:
            return IsensorFirewallRulePayload.from_dict(result.get(endpoint))
        raise GraphQLNoRowsInResultSetError("for mutation iSensorCreateFirewallRules")

    def i_sensor_delete_firewall_rules(
        self,
        id_: str,
        action: Union[IsensorRuleActionInput, TaegisEnum],
        input_: List[IsensorFirewallRuleInput],
    ) -> IsensorFirewallRulePayload:
        """iSensor Delete Firewall Rules."""
        endpoint = "iSensorDeleteFirewallRules"

        result = self.service.execute_mutation(
            endpoint=endpoint,
            variables={
                "id": prepare_input(id_),
                "action": prepare_input(action),
                "input": prepare_input(input_),
            },
            output=build_output_string(IsensorFirewallRulePayload),
        )
        if result.get(endpoint) is not None:
            return IsensorFirewallRulePayload.from_dict(result.get(endpoint))
        raise GraphQLNoRowsInResultSetError("for mutation iSensorDeleteFirewallRules")

    def i_sensor_create_change_mgmt_report(
        self, input_: IsensorChangeMgmtReportInput
    ) -> IsensorChangeMgmtReportPayload:
        """iSensor Create Change Management Report."""
        endpoint = "iSensorCreateChangeMgmtReport"

        result = self.service.execute_mutation(
            endpoint=endpoint,
            variables={
                "input": prepare_input(input_),
            },
            output=build_output_string(IsensorChangeMgmtReportPayload),
        )
        if result.get(endpoint) is not None:
            return IsensorChangeMgmtReportPayload.from_dict(result.get(endpoint))
        raise GraphQLNoRowsInResultSetError(
            "for mutation iSensorCreateChangeMgmtReport"
        )

    def i_sensor_deploy_customizations(
        self, id_: str, uin: str
    ) -> IsensorDeployCustomizationsPayload:
        """iSensor Deploy Customizations."""
        endpoint = "iSensorDeployCustomizations"

        result = self.service.execute_mutation(
            endpoint=endpoint,
            variables={
                "id": prepare_input(id_),
                "uin": prepare_input(uin),
            },
            output=build_output_string(IsensorDeployCustomizationsPayload),
        )
        if result.get(endpoint) is not None:
            return IsensorDeployCustomizationsPayload.from_dict(result.get(endpoint))
        raise GraphQLNoRowsInResultSetError("for mutation iSensorDeployCustomizations")

    def i_sensor_rule_variable_customizations(
        self,
        id_: str,
        uin: str,
        policy: str,
        input_: List[IsensorRuleVariableCustomizationsInput],
    ) -> List[IsensorRuleVariableCustomizationsPayload]:
        """iSensor Rule Variable Customizations."""
        endpoint = "iSensorRuleVariableCustomizations"

        result = self.service.execute_mutation(
            endpoint=endpoint,
            variables={
                "id": prepare_input(id_),
                "uin": prepare_input(uin),
                "policy": prepare_input(policy),
                "input": prepare_input(input_),
            },
            output=build_output_string(IsensorRuleVariableCustomizationsPayload),
        )
        if result.get(endpoint) is not None:
            return IsensorRuleVariableCustomizationsPayload.schema().load(
                [r or {} for r in result.get(endpoint)], many=True
            )
        raise GraphQLNoRowsInResultSetError(
            "for mutation iSensorRuleVariableCustomizations"
        )

    def ndr_save_maintenance_window(
        self, input_: NdrMaintenanceWindowInput
    ) -> NdrMaintenanceWindowResult:
        """Create a new ndr device maintenance window of a given input."""
        endpoint = "ndrSaveMaintenanceWindow"

        result = self.service.execute_mutation(
            endpoint=endpoint,
            variables={
                "input": prepare_input(input_),
            },
            output=build_output_string(NdrMaintenanceWindowResult),
        )
        if result.get(endpoint) is not None:
            return NdrMaintenanceWindowResult.from_dict(result.get(endpoint))
        raise GraphQLNoRowsInResultSetError("for mutation ndrSaveMaintenanceWindow")

    def ndr_defer_maintenance_event_device(
        self, id_: str, idn: str
    ) -> NdrDeferEventDeviceResult:
        """Defer Event Device event for given id."""
        endpoint = "ndrDeferMaintenanceEventDevice"

        result = self.service.execute_mutation(
            endpoint=endpoint,
            variables={
                "id": prepare_input(id_),
                "idn": prepare_input(idn),
            },
            output=build_output_string(NdrDeferEventDeviceResult),
        )
        if result.get(endpoint) is not None:
            return NdrDeferEventDeviceResult.from_dict(result.get(endpoint))
        raise GraphQLNoRowsInResultSetError(
            "for mutation ndrDeferMaintenanceEventDevice"
        )
